/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: frmex.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 05:33:03 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _FRMEX_HXX
#define _FRMEX_HXX

#ifndef _SV_WINDOW_HXX //autogen
#include <vcl/window.hxx>
#endif

// auto strip #ifndef _COLOR_HXX //autogen
// auto strip #include <tools/color.hxx>
// auto strip #endif

// auto strip #ifndef _GEN_HXX //autogen
// auto strip #include <tools/gen.hxx>
// auto strip #endif
namespace binfilter {

// class SwFrmPagePreview -------------------------------------------------------

class SwFrmPagePreview : public Window
{
	Color		m_aTransColor;		// transparency
	Color		m_aBgCol;			// background
	Color		m_aFrameColor;		// graphic frame
	Color     	m_aAlignColor;		// align anchor
	Color		m_aBorderCol;		// frame of doc
	Color		m_aPrintAreaCol;	// frame of printable area of doc
	Color		m_aTxtCol;			// symbolised text
	Color		m_aBlankCol;		// area of symbol for blank
	Color		m_aBlankFrameCol;	// frame of symbol for blank

	Rectangle 	aPage;
	Rectangle 	aPagePrtArea;
	Rectangle 	aTextLine;
	Rectangle 	aPara;
	Rectangle 	aParaPrtArea;
	Rectangle 	aFrameAtFrame;
	Rectangle 	aDrawObj;
	Rectangle 	aAutoCharFrame;
	Size      	aFrmSize;

	USHORT		nHAlign;
	USHORT		nHRel;

	USHORT		nVAlign;
	USHORT		nVRel;

	USHORT		nWrap;
	USHORT 		nAnchor;
	BOOL 		bTrans;

	Point		aRelPos;

	void InitColors( void );
	void InitAllRects();
	void CalcBoundRect(Rectangle &rRect);
	Rectangle DrawInnerFrame(const Rectangle &rRect, const Color &rFillColor, const Color &rBorderColor);

	void DrawRect(const Rectangle &rRect, const Color &rFillColor, const Color &rLineColor);
	void Paint(const Rectangle&);
protected:
	virtual void DataChanged( const DataChangedEvent& rDCEvt );
public:

	SwFrmPagePreview(Window* pParent, const ResId& rResID);
	~SwFrmPagePreview();

	inline void SetWrap(USHORT nW) 			{ nWrap 	= nW; }

	inline void SetHAlign(USHORT nH) 		{ nHAlign 	= nH; }
	inline void SetHoriRel(USHORT nR) 		{ nHRel 	= nR; }

	inline void SetVAlign(USHORT nV) 		{ nVAlign 	= nV; }
	inline void SetVertRel(USHORT nR) 		{ nVRel 	= nR; }

	inline void SetTransparent(BOOL bT)		{ bTrans 	= bT; }
	inline void SetAnchor(USHORT nA)  		{ nAnchor 	= nA; }

	void SetRelPos(const Point& rP);
};


} //namespace binfilter
#endif // _FRMEX_HXX
