/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: linbox.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 05:40:24 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _LINBOX_HXX
#define _LINBOX_HXX

#ifndef _SVARRAY_HXX //autogen
#include <svtools/svarray.hxx>
#endif

#ifndef _LSTBOX_HXX //autogen
#include <vcl/lstbox.hxx>
#endif

#ifndef _VIRDEV_HXX //autogen
#include <vcl/virdev.hxx>
#endif
namespace binfilter {

struct SwLineStyle
{
	SwLineStyle(USHORT nWidth=0, USHORT nWidth2=0, USHORT nDst=0);
	SwLineStyle(const SwLineStyle& rTyp);
	BOOL operator==(const SwLineStyle& rTyp) const;

	USHORT nIn;
	USHORT nOut;
	USHORT nDist;
};

inline BOOL SwLineStyle::operator==(const SwLineStyle& rTyp) const
	{ return(nIn == rTyp.nIn && nOut == rTyp.nOut && nDist == rTyp.nDist); }

SV_DECL_PTRARR(SwLineStyleLst, SwLineStyle*, 5, 5)

/*--------------------------------------------------------------------
	 Beschreibung: Box fuer Linenarten
 --------------------------------------------------------------------*/

class SwLineBox : public ListBox
{
	USHORT FindEntry(const SwLineStyle& rType);

	VirtualDevice	aVirDev;
	SwLineStyleLst 	aTypeList;

public:
	SwLineBox(Window* pPar, const ResId& rResId);
	~SwLineBox();

	void 		InsertEntry(const SwLineStyle& rTyp, USHORT nPos=LISTBOX_APPEND);

	void 		SelectEntry(const SwLineStyle& rTyp);
	SwLineStyle GetSelectEntry();
};

} //namespace binfilter
#endif
