/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: view.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: obo $ $Date: 2006/01/19 17:30:50 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SWVIEW_HXX
#define _SWVIEW_HXX

#ifndef _TIMER_HXX //autogen
#include <vcl/timer.hxx>
#endif
#ifndef _SV_FIELD_HXX //autogen
#include <vcl/field.hxx>
#endif
#ifndef _VIEWFAC_HXX //autogen
#include <bf_sfx2/viewfac.hxx>
#endif
#ifndef _SFXVIEWSH_HXX //autogen
#include <bf_sfx2/viewsh.hxx>
#endif
#ifndef _SFX_OBJSH_HXX
#include <bf_sfx2/objsh.hxx>   // SfxObjectShellRef <-> SV_DECL_REF(SfxObjectShell)
#endif
#ifndef _SVX_SVXENUM_HXX //autogen
#include <bf_svx/svxenum.hxx>
#endif
#ifndef _SVX_ZOOMITEM_HXX //autogen
#include <bf_svx/zoomitem.hxx>
#endif

#ifndef _SWTYPES_HXX
#include <swtypes.hxx>
#endif
#ifndef _SHELLID_HXX
#include <shellid.hxx>
#endif
class Button; 
class ImageButton; 
class PrintDialog; 
class SvBorder; 
class Dialog; 
class SvGlobalName; 
class SvtAccessibilityOptions; 
namespace com{ namespace sun { namespace star {
	namespace view{ class XSelectionSupplier; }
}}}

namespace binfilter {

class SwBaseShell;
class SwTxtFmtColl;
class SwPageDesc;
class SwFrmFmt;
class SwCharFmt;
class SwNumRule;
class SwViewOption;
class SwGlossaryHdl;
class SwDrawBase;
class SvxRuler;
class SvxLRSpaceItem;
class SwDocShell;
class SwScrollbar;

class SvxVCBrowser;

class Ruler;
class OutlinerView;
class SvxSearchItem;
class SearchAttrItemList;
class SvxSearchDialog;
class SdrView;

class SdrObject;
class SdrPageView;
class SwNaviImageButton;
class SwHlpImageButton;
class Outliner;
class SwView;
class SwEditWin;
class SwWrtShell;
class SwView_Impl;
class XSelectionObject;
struct SwSearchOptions;
class FmFormShell;
class CommandEvent;
class InsCaptionOpt;


class SwPrtOptions;
class SwTransferable;
struct SwPrintData;


const long nLeftOfst = -370;
const long nScrollX	 =	 30;
const long nScrollY	 =	 30;

#define MINZOOM 20
#define MAXZOOM 600

#define MAX_MARKS 5


enum ShellModes
{
	SEL_TEXT,
	SEL_FRAME,
	SEL_GRAPHIC,
	SEL_OBJECT,
	SEL_DRAW,
	SEL_DRAW_CTRL,
	SEL_DRAW_FORM,
	SEL_DRAWTEXT,
	SEL_BEZIER,
	SEL_LIST_TEXT,
	SEL_TABLE_TEXT,
	SEL_TABLE_LIST_TEXT
};

/*--------------------------------------------------------------------
	Beschreibung:	Anwendung einer Vorlage
 --------------------------------------------------------------------*/

struct SwApplyTemplate
{
	union
	{
		SwTxtFmtColl* pTxtColl;
		SwPageDesc*   pPageDesc;
		SwFrmFmt*	  pFrmFmt;
		SwCharFmt*	  pCharFmt;
		SwNumRule*	  pNumRule;
	} aColl;

	int eType;
	USHORT nColor;
	BOOL bUndo;

	SwApplyTemplate() :
		eType(0),
		nColor(0),
		bUndo(FALSE)
	{
		aColl.pTxtColl = 0;
	}
};


/*--------------------------------------------------------------------
	Beschreibung:	Sicht auf ein Dokument
 --------------------------------------------------------------------*/

class SwView: public SfxViewShell
{
	//Messehack (MA,MBA)
	friend void lcl_SelectShellForDrop( SwView &rView );

	friend class TestTemplateItem;
    friend class SwHHCWrapper;
	friend class SwSpellWrapper;
	friend class SwHyphWrapper;
	friend class SwView_Impl;
	friend class SwClipboardChangeListener;

	//suchen & ersetzen
	static SvxSearchDialog *pSrchDlg;
	static SvxSearchItem   *pSrchItem;

	static USHORT			nInsertCtrlState;
	static USHORT			nWebInsertCtrlState;
	static USHORT			nInsertObjectCtrlState;
	static USHORT			nInsertFieldCtrlState;
	static USHORT			nMoveType; // fuer Buttons unter dem Scrollbar (viewmdi)
	static BYTE				nActMark; // aktuelle Sprungmarke fuer unbenannte Merker

	static BOOL             bExtra;
	static BOOL             bFound;
	static BOOL				bJustOpened;

	static SearchAttrItemList* pSrchList;
	static SearchAttrItemList* pReplList;


	Timer				aTimer;			//Fuer verzoegerte ChgLnks waehrend
										//einer Aktion
	String				aPageStr;		//Statusanzeige, aktuelle Seite
	String 				sSwViewData,
	//and the new cursor position if the user double click in the PagePreView
						sNewCrsrPos;
    // to support keyboard the number of the page to go to can be set too
    USHORT              nNewPage;

	Point				aTabColFromDocPos;	//Verschieben von Tabellenspalten aus
											//aus dem Dokument heraus.
	Size				aDocSz;			// aktuelle Dokumentgroesse
	Rectangle			aVisArea;		// sichtbarer Bereich

	SwEditWin			*pEditWin;
	SwWrtShell			*pWrtShell;

	SfxShell			*pShell;		//aktuelle SubShell auf dem Dispatcher
	FmFormShell			*pFormShell;	// DB-FormShell

	SwView_Impl			*pViewImpl;		// Impl-Daten fuer UNO + Basic


	SwScrollbar	   		*pHScrollbar,	// MDI Bedienelemente
						*pVScrollbar;

	Window		   		*pScrollFill;	// Dummy-Window zum Fllen der rechten
										// unteren Ecke, wenn beide Scrollbars
										// aktiv sind

    SvxRuler            *pHRuler,
                        *pVRuler;
	ImageButton	   		*pTogglePageBtn;

	SwHlpImageButton 	*pPageUpBtn,
						*pPageDownBtn;

//STRIP001 	SwNaviImageButton 	*pNaviBtn;
//STRIP001 	SwGlossaryHdl  		*pGlosHdl;			// Henkel Textbausteine
	SwDrawBase			*pDrawActual;

	const SwFrmFmt		*pLastTableFormat;

	int					nSelectionType;

	// Aktueller Drawmode
	USHORT			nDrawSfxId;
	USHORT			nFormSfxId;
	USHORT			nLastPasteDestination;

	BOOL			bCenterCrsr : 1,
					bTopCrsr : 1,
					bAllwaysShowSel : 1,
					bTabColFromDoc : 1,
					bSetTabColFromDoc : 1 ,
					bAttrChgNotified : 1,
					bAttrChgNotifiedWithRegistrations : 1,
					bVerbsActive : 1,
					bDrawRotate : 1,
					bDrawSelMode : 1,
					bShowAtResize : 1,
					bInOuterResizePixel : 1,
                    bInInnerResizePixel : 1,
					bIsApi : 1,
					bPasteState : 1,
                    bPasteSpecialState : 1,
                    bInMailMerge : 1,
                    bInDtor : 1 //detect destructor to prevent creating of sub shells while closing
					;

	// Methoden fuers Suchen
	// Suchkontext setzen
//STRIP001 	BOOL   			SearchAndWrap(BOOL bApi = FALSE);
//STRIP001 	BOOL 			SearchAll(USHORT* pFound = 0);
//STRIP001 	ULONG			FUNC_Search( const SwSearchOptions& rOptions );
//STRIP001 	void 			Replace();

//STRIP001 	inline BOOL		IsDocumentBorder();

//STRIP001 	BOOL			IsTextTool() const;

	// Bedienelemente verwalten anlegen
	void			CreateBtns();
	DECL_LINK( BtnPage, Button * );

	DECL_LINK( TimeoutHdl, Timer * );

	inline long		GetXScroll() const;
	inline long		GetYScroll() const;
//STRIP001 		   Point	AlignToPixel(const Point& rPt) const;
//STRIP001 		   void		CalcPt(	Point* pPt,const Rectangle& rRect,
//STRIP001 							USHORT nRangeX = USHRT_MAX,
//STRIP001 							USHORT nRangeY = USHRT_MAX);

//STRIP001 	BOOL			GetPageScrollUpOffset(SwTwips& rOff) const;
//STRIP001 	BOOL			GetPageScrollDownOffset(SwTwips& rOff) const;

	// Scrollbar Movements
//STRIP001 	long			PageUp();
//STRIP001 	long			PageDown();
//STRIP001 	long			PageUpCrsr(BOOL bSelect);
//STRIP001 	long			PageDownCrsr(BOOL bSelect);
//STRIP001 	long			PhyPageUp();
//STRIP001 	long			PhyPageDown();

	int				_CreateScrollbar( int bHori );
	int				_KillScrollbar( int bHori );
	DECL_LINK( ScrollHdl, SwScrollbar * );
	DECL_LINK( EndScrollHdl, SwScrollbar * );
	BOOL			UpdateScrollbars();
//STRIP001 	void			CalcVisArea( const Size &rPixelSz );

    void            CreatePageButtons(BOOL bShow);

	// Linguistik-Funktionen
//STRIP001 	void			SpellDocument( const String* pStr, BOOL bAllRight = FALSE );
//STRIP001 	void			HyphenateDocument();
//STRIP001 	BOOL			IsDrawTextHyphenate();
//STRIP001 	void			HyphenateDrawText();
//STRIP001 	void			StartThesaurus();

    // text conversion
    void            ConvertDocument( const String* pStr );
    void            _ConvertDocument( const String* pStr );

    // used for spell checking and text conversion
//STRIP001 	void			SpellStart( SvxSpellArea eSpell, BOOL bStartDone,
//STRIP001                                 BOOL bEndDone, sal_Bool bIsConversion = sal_False );
//STRIP001     void            SpellEnd( sal_Bool bIsConversion = sal_False );

//STRIP001     void            HyphStart( SvxSpellArea eSpell );
//STRIP001 	void			_SpellDocument( const String* pStr, BOOL bAllRight );
	BOOL			CheckSpecialCntnt();
	void			SpellKontext(BOOL bOn = TRUE)
							{ bCenterCrsr = bOn; bAllwaysShowSel = bOn; }

	// Methoden fuers Printing
	virtual	SfxPrinter* 	GetPrinter( BOOL bCreate = FALSE );
//STRIP001 	virtual PrintDialog*	CreatePrintDialog( Window* pParent );
//STRIP001 			SfxTabPage* 	CreatePrintOptionsPage( Window* pParent,
//STRIP001 													const SfxItemSet& rSet);
	// fuer Readonly-Umschaltung
	virtual void	Notify( SfxBroadcaster& rBC, const SfxHint& rHint );
	void			_CheckReadonlyState();
	void			_CheckReadonlySelection();

	// Methode fuer PageDesc drehen
	void			SwapPageMargin(const SwPageDesc&, SvxLRSpaceItem& rLR);

	void			_SetZoom( const Size &rEditSz,//STRIP001 	void			_SetZoom( const Size &rEditSz,
		SvxZoomType eZoomType,//STRIP001 							  SvxZoomType eZoomType,
		short nFactor = 100,//STRIP001 							  short nFactor = 100,
		BOOL bViewOnly = FALSE){DBG_BF_ASSERT(0, "STRIP");} ;//STRIP001 							  BOOL bViewOnly = FALSE);
//STRIP001 	void			CalcAndSetBorderPixel( SvBorder &rToFill, FASTBOOL bInner );

//STRIP001 	void		    ShowAtResize();

//STRIP001 	virtual void	Move();


protected:

	SwView_Impl*	GetViewImpl() {return pViewImpl;}

	void ImpSetVerb( int nSelType );

	int				GetSelectionType() const { return nSelectionType; }
	void			SetSelectionType(int nSet) { nSelectionType = nSet;}

	// fuer die SwWebView
	void			SetShell( SfxShell* pS ) 			{ pShell = pS; }
	void 			SetFormShell( FmFormShell* pSh )	{ pFormShell = pSh; }

	virtual void	SelectShell();

	virtual void	Activate(BOOL);
//STRIP001 	virtual void 	Deactivate(BOOL);
//STRIP001 	virtual void 	InnerResizePixel( const Point &rOfs, const Size &rSize );
//STRIP001 	virtual void 	OuterResizePixel( const Point &rOfs, const Size &rSize );
//STRIP001 	virtual Size	GetOptimalSizePixel() const;

//STRIP001 	void			SetImageButtonColor(Color& rColor);

	const SwFrmFmt* GetLastTblFrmFmt() const {return pLastTableFormat;}
	void 			SetLastTblFrmFmt(const SwFrmFmt* pSet) {pLastTableFormat = pSet;}

    // form letter execution
    void    GenerateFormLetter(BOOL bUseCurrentDocument);

public:

	SFX_DECL_VIEWFACTORY(SwView);
/*N*/ 	SFX_DECL_INTERFACE(SW_VIEWSHELL);
	TYPEINFO();

	SfxDispatcher 	&GetDispatcher();

//STRIP001 	virtual SdrView*		GetDrawView() const;
	virtual	BOOL			HasUIFeature( ULONG nFeature );
	virtual	void			ShowCursor( FASTBOOL bOn = TRUE );
//STRIP001 	virtual ErrCode			DoVerb( long nVerb );

//STRIP001 	virtual USHORT			SetPrinter(	SfxPrinter* pNew,
//STRIP001 										USHORT nDiff = SFX_PRINTER_ALL);
//STRIP001 	virtual ErrCode			DoPrint( SfxPrinter *pPrinter, PrintDialog *pPrintDialog,
//STRIP001 									 BOOL bSilent );
	ShellModes				GetShellMode();

	::com::sun::star::view::XSelectionSupplier*		GetUNOObject();

//STRIP001 	String					GetSelectionTextParam( BOOL bCompleteWords,
//STRIP001 												   BOOL bEraseTrail );
//STRIP001 	virtual BOOL			HasSelection( BOOL  bText ) const;
//STRIP001 	virtual String			GetSelectionText( BOOL bCompleteWords = FALSE );
	virtual USHORT			PrepareClose( BOOL bUI = TRUE, BOOL bForBrowsing = FALSE );
//STRIP001 	virtual	void			MarginChanged();

	// Shell sofort wechseln ->  fuer GetSelectionObject
	void		StopShellTimer();
	// hier wird bei Bedarf SelectShell gerufen (getSelection)
//STRIP001 	void		PrepareGetSelection();

	inline SwWrtShell&		GetWrtShell   () const { return *pWrtShell; }
	inline SwWrtShell*		GetWrtShellPtr() const { return  pWrtShell; }

	inline 		 SwEditWin &GetEditWin() 	    { return *pEditWin; }
	inline const SwEditWin &GetEditWin () const { return *pEditWin; }

#if defined WIN || defined WNT || defined UNX
//STRIP001 	void ScannerEventHdl( const ::com::sun::star::lang::EventObject& rEventObject );
#endif

	//Handler fuer Textbausteine an die Textshell rausreichen, gfs. anlegen
//STRIP001 	SwGlossaryHdl*			GetGlosHdl();

	inline const Rectangle&	GetVisArea() const { return aVisArea; }

//STRIP001 	BOOL			IsScroll(const Rectangle& rRect) const;
	void			Scroll(	const Rectangle& rRect,
							USHORT nRangeX = USHRT_MAX,
							USHORT nRangeY = USHRT_MAX);

//STRIP001 	long		SetVScrollMax(long lMax);
//STRIP001 	long		SetHScrollMax(long lMax);

//STRIP001 	DECL_LINK( SpellError, void * );
//STRIP001 	BOOL 			ExecSpellPopup( const Point& rPt );
//STRIP001 	BOOL			ExecDrwTxtSpellPopup(const Point& rPt);

	void			SetTabColFromDocPos( const Point &rPt ) { aTabColFromDocPos = rPt; }
	void			SetTabColFromDoc( BOOL b ) { bTabColFromDoc = b; }
	BOOL			IsTabColFromDoc() const	   { return bTabColFromDoc; }

			void	DocSzChgd( const Size& rNewSize );
	const 	Size&	GetDocSz() const { return aDocSz; }
	virtual void	SetVisArea( const Rectangle&, BOOL bUpdateScrollbar = TRUE){DBG_BF_ASSERT(0, "STRIP");} ;//STRIP001 	virtual void	SetVisArea( const Rectangle&, BOOL bUpdateScrollbar = TRUE);
//STRIP001 			void	SetVisArea( const Point&, BOOL bUpdateScrollbar = TRUE);
			void	CheckVisArea();

//STRIP001 	static Dialog* 	GetSearchDialog();

//STRIP001 	static USHORT	GetMoveType();
//STRIP001 	static void		SetMoveType(USHORT nSet);
//STRIP001 	void 			MoveNavigation(BOOL bNext);
//STRIP001 	static void		SetActMark(BYTE nSet);

//STRIP001 	BOOL 			HandleWheelCommands( const CommandEvent& );

	// Rahmen einfuegen
//STRIP001 	void			InsFrmMode(USHORT nCols);

	void			SetZoom( SvxZoomType eZoomType, short nFactor = 100, BOOL bViewOnly = FALSE);
//STRIP001 	virtual void	SetZoomFactor( const Fraction &rX, const Fraction & );

    void            ShowHScrollbar(sal_Bool bShow);
//STRIP001     sal_Bool        IsHScrollbarVisible()const;

    void            ShowVScrollbar(sal_Bool bShow);
//STRIP001     sal_Bool        IsVScrollbarVisible()const;

//STRIP001     int             CreateVLineal();
//STRIP001     int             KillVLineal();
    int             CreateTab();
//STRIP001     int             KillTab();

    int             StatVLineal() const { return ((Window*)pVRuler)->IsVisible(); }
//STRIP001 //STRIP001 	void			ChangeVLinealMetric(FieldUnit eUnit);
    BOOL            GetVLinealMetric(FieldUnit& rToFill) const;

    int             StatTab() const { return ((Window*)pHRuler)->IsVisible(); }
    SvxRuler&       GetHLineal()    { return *pHRuler; }
    SvxRuler&       GetVLineal()    { return *pVRuler; }
//STRIP001 	void			InvalidateRulerPos();
//STRIP001 	void			ChangeTabMetric(FieldUnit eUnit);
//STRIP001     BOOL            GetHLinealMetric(FieldUnit& rToFill) const;

		// Handler
	void			Execute(SfxRequest&){DBG_BF_ASSERT(0, "STRIP");} ;//STRIP001 	void			Execute(SfxRequest&);
	void			ExecPageMove(SfxRequest&);
	void			ExecStyle(SfxRequest&);
	void			ExecLingu(SfxRequest&){DBG_BF_ASSERT(0, "STRIP");} ;//STRIP001 	void			ExecLingu(SfxRequest&);
	void			ExecDataBase(SfxRequest&);
	void			ExecDlg(SfxRequest&){DBG_BF_ASSERT(0, "STRIP");} ;//STRIP001 	void			ExecDlg(SfxRequest&);
	void			ExecDlgExt(SfxRequest&){DBG_BF_ASSERT(0, "STRIP");} ;//STRIP001 	void			ExecDlgExt(SfxRequest&);
	void			ExecDBDlg(SfxRequest &);
	void			ExecColl(SfxRequest&){DBG_BF_ASSERT(0, "STRIP");} ;//STRIP001 	void			ExecColl(SfxRequest&);
	void			ExecutePrint(SfxRequest&){DBG_BF_ASSERT(0, "STRIP");} ;//STRIP001 	void			ExecutePrint(SfxRequest&);
	void 			ExecDraw(SfxRequest&){DBG_BF_ASSERT(0, "STRIP");} ;//STRIP001 	void 			ExecDraw(SfxRequest&);
	void 			ExecTabWin(SfxRequest&){DBG_BF_ASSERT(0, "STRIP");} ;//STRIP001 	void 			ExecTabWin(SfxRequest&);
	void			ExecuteStatusLine(SfxRequest&);
	DECL_LINK( ExecRulerClick, Ruler * );
	void 			ExecSearch(SfxRequest&, BOOL bNoMessage = FALSE){DBG_BF_ASSERT(0, "STRIP");} ;//STRIP001 	void 			ExecSearch(SfxRequest&, BOOL bNoMessage = FALSE);

	void            StateSearch(SfxItemSet &){DBG_BF_ASSERT(0, "STRIP");} ;//STRIP001 	void            StateSearch(SfxItemSet &);
	void			GetState(SfxItemSet&);
	void			StateStatusLine(SfxItemSet&);


	// Funktionen fuer Drawing
	void			SetDrawFuncPtr(SwDrawBase* pFuncPtr);
	inline SwDrawBase* GetDrawFuncPtr(BOOL bBuf = FALSE) const	{ return pDrawActual; }
	void 			GetDrawState(SfxItemSet &rSet);
//STRIP001 	void			ExitDraw();
	inline BOOL		IsDrawRotate()		{ return bDrawRotate; }
	inline void		FlipDrawRotate()	{ bDrawRotate = !bDrawRotate; }
	inline BOOL		IsDrawSelMode() 	{ return bDrawSelMode; }
//STRIP001 	void			SetSelDrawSlot();
	inline void		FlipDrawSelMode()	{ bDrawSelMode = !bDrawSelMode; }
//STRIP001 	void			NoRotate();		// Rotate-Mode abschalten
//STRIP001 	BOOL			EnterDrawTextMode(const Point& aDocPos);
	void			LeaveDrawCreate()	{ nDrawSfxId = nFormSfxId = USHRT_MAX; }
	BOOL			IsDrawMode()		{ return (nDrawSfxId != USHRT_MAX || nFormSfxId != USHRT_MAX); }
//STRIP001 	BOOL			IsFormMode() const;
//STRIP001 	BOOL			IsBezierEditMode();
//STRIP001 	BOOL			AreOnlyFormsSelected() const;
//STRIP001 	BOOL			HasDrwObj(SdrObject *pSdrObj) const;
//STRIP001 	BOOL			HasOnlyObj(SdrObject *pSdrObj, UINT32 eObjInventor) const;
//STRIP001 	BOOL			BeginTextEdit(	SdrObject* pObj, SdrPageView* pPV=NULL,
//STRIP001 									Window* pWin=NULL, BOOL bIsNewObj=FALSE);

	void			StateTabWin(SfxItemSet&);

	// Attribute haben sich geaendert
	DECL_LINK( AttrChangedNotify, SwWrtShell * );

	// Links bearbeiten
//STRIP001 	void			EditLinkDlg();
//STRIP001 	void			AutoCaption(const USHORT nType, const SvGlobalName *pOleId = 0);
//STRIP001 	void			InsertCaption(const InsCaptionOpt *pOpt);

	// Async Aufruf durch Core
	void        UpdatePageNums(USHORT nPhyNum, USHORT nVirtNum, const String& rPgStr);

	String 		GetPageStr(USHORT nPhyNum, USHORT nVirtNum, const String& rPgStr);

	// Shell rausreichen
				 SfxShell		*GetCurShell()	{ return pShell; }
				 SwDocShell		*GetDocShell();
	inline const SwDocShell		*GetDocShell() const;
	inline		 FmFormShell	*GetFormShell()	{ return pFormShell; }

	//damit in DToren der SubShells ggf. pShell zurueckgesetzt werden kann
	void ResetSubShell() 	{ pShell = 0; }

	virtual void	WriteUserData(String &, BOOL bBrowse = FALSE );
//STRIP001 	virtual void	ReadUserData(const String &, BOOL bBrowse = FALSE );
//STRIP001     virtual void    ReadUserDataSequence ( const ::com::sun::star::uno::Sequence < ::com::sun::star::beans::PropertyValue >&, sal_Bool bBrowse );
    virtual void    WriteUserDataSequence ( ::com::sun::star::uno::Sequence < ::com::sun::star::beans::PropertyValue >&, sal_Bool bBrowse );

	void SetCrsrAtTop( BOOL bFlag, BOOL bCenter = FALSE )
		{ bTopCrsr = bFlag, bCenterCrsr = bCenter; }
	BOOL IsCrsrAtTop() const 					{ return bTopCrsr; }
	BOOL IsCrsrAtCenter() const 				{ return bCenterCrsr; }

//STRIP001 	BOOL JumpToSwMark( const String& rMark );

//STRIP001 	long InsertDoc( USHORT nSlotId, const String& rFileName,
//STRIP001 					const String& rFilterName, INT16 nVersion = 0 );

	// status methods for clipboard.
	// Status changes now notified from the clipboard.
	BOOL IsPasteAllowed();
//STRIP001 	BOOL IsPasteSpecialAllowed();

    // Enable mail merge - mail merge field dialog enabled
    void EnableMailMerge(BOOL bEnable = TRUE);
    //apply Accessiblity options
    void ApplyAccessiblityOptions(SvtAccessibilityOptions& rAccessibilityOptions);

    // get print options (SwPrtOptions)
    static void MakeOptions( PrintDialog* pDlg, SwPrtOptions& rOpts, 
            BOOL* pPrtProspect, BOOL bWeb, SfxPrinter* pPrt, SwPrintData* pData );

	SwView(SfxViewFrame* pFrame, SfxViewShell*);
	~SwView();

//STRIP001     void NotifyDBChanged();

    SfxObjectShellRef & GetTmpSelectionDoc();
    SfxObjectShellRef & GetOrCreateTmpSelectionDoc();

    void        AddTransferable(SwTransferable& rTransferable);
};

// ----------------- inline Methoden ----------------------

inline long SwView::GetXScroll() const
{
	return aVisArea.GetWidth() * nScrollX / 100L;
}

inline long SwView::GetYScroll() const
{
	return aVisArea.GetHeight() * nScrollY / 100L;
}

inline const SwDocShell	*SwView::GetDocShell() const
{
	return ((SwView*)this)->GetDocShell();
}

//***********************************************************

SfxTabPage* CreatePrintOptionsPage(	Window *pParent,
									const SfxItemSet &rOptions,
									BOOL bPreview);

} //namespace binfilter
#endif
