/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_tautofmt.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 06:45:32 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
namespace binfilter {


//STRIP001 #pragma hdrstop
//STRIP001 
//STRIP001 
//STRIP001 #ifndef _EDIT_HXX //autogen
//STRIP001 #include <vcl/edit.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _MSGBOX_HXX //autogen
//STRIP001 #include <vcl/msgbox.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _ZFORLIST_HXX //autogen
//STRIP001 #include <svtools/zforlist.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
//STRIP001 #include <com/sun/star/lang/XMultiServiceFactory.hpp>
//STRIP001 #endif
//STRIP001 #ifndef _COMPHELPER_PROCESSFACTORY_HXX_
//STRIP001 #include <comphelper/processfactory.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVTOOLS_SCRIPTEDTEXT_HXX
//STRIP001 #include <svtools/scriptedtext.hxx>
//STRIP001 #endif
//STRIP001 #ifndef INCLUDED_SVTOOLS_ACCESSIBILITYOPTIONS_HXX
//STRIP001 #include <svtools/accessibilityoptions.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _SWMODULE_HXX
//STRIP001 #include "swmodule.hxx"
//STRIP001 #endif
//STRIP001 #ifndef _UIPARAM_HXX
//STRIP001 #include "uiparam.hxx"
//STRIP001 #endif
//STRIP001 #ifndef _SWTYPES_HXX
//STRIP001 #include "swtypes.hxx"
//STRIP001 #endif
//STRIP001 #ifndef _VIEW_HXX
//STRIP001 #include "view.hxx"
//STRIP001 #endif
//STRIP001 #ifndef _WRTSH_HXX
//STRIP001 #include "wrtsh.hxx"
//STRIP001 #endif
//STRIP001 #ifndef _TBLAFMT_HXX
//STRIP001 #include "tblafmt.hxx"
//STRIP001 #endif
//STRIP001 #ifndef _TAUTOFMT_HXX
//STRIP001 #include "tautofmt.hxx"
//STRIP001 #endif
//STRIP001 #ifndef _SHELLRES_HXX
//STRIP001 #include "shellres.hxx"
//STRIP001 #endif
//STRIP001 #ifndef _BREAKIT_HXX
//STRIP001 #include "breakit.hxx"
//STRIP001 #endif
//STRIP001 #ifndef _TAUTOFMT_HRC
//STRIP001 #include "tautofmt.hrc"
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _LEGACYBINFILTERMGR_HXX
//STRIP001 #include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
//STRIP001 #endif
//STRIP001 using namespace ::com::sun::star::lang;
//STRIP001 using namespace ::com::sun::star::uno;
//STRIP001 
//STRIP001 #define FRAME_OFFSET 4
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 
//STRIP001 class AutoFmtPreview : public Window
//STRIP001 {
//STRIP001 public:
//STRIP001 			AutoFmtPreview( Window* pParent, const ResId& rRes );
//STRIP001 			~AutoFmtPreview();
//STRIP001 
//STRIP001 	void NotifyChange( const SwTableAutoFmt& rNewData );
//STRIP001 
//STRIP001 protected:
//STRIP001 	virtual void Paint( const Rectangle& rRect );
//STRIP001 
//STRIP001 private:
//STRIP001     SwTableAutoFmt          aCurData;
//STRIP001     VirtualDevice           aVD;
//STRIP001     SvtScriptedTextHelper   aScriptedText;
//STRIP001     BOOL                    bFitWidth;
//STRIP001     static BYTE             aFmtMap[25];        // Zuordnung: Zelle->Format
//STRIP001     Rectangle               aCellArray[25];     // Position und Groesse der Zellen
//STRIP001     SvxBoxItem*             aLinePtrArray[49];  // LinienAttribute
//STRIP001     Size                    aPrvSize;
//STRIP001     const USHORT            nLabelColWidth;
//STRIP001     const USHORT            nDataColWidth1;
//STRIP001     const USHORT            nDataColWidth2;
//STRIP001     const USHORT            nRowHeight;
//STRIP001     const String            aStrJan;
//STRIP001     const String            aStrFeb;
//STRIP001     const String            aStrMar;
//STRIP001     const String            aStrNorth;
//STRIP001     const String            aStrMid;
//STRIP001     const String            aStrSouth;
//STRIP001     const String            aStrSum;
//STRIP001     SvNumberFormatter*      pNumFmt;
//STRIP001 	//-------------------------------------------
//STRIP001 	void	Init			();
//STRIP001 	void	DoPaint			( const Rectangle& rRect );
//STRIP001 	void	CalcCellArray	( BOOL bFitWidth );
//STRIP001 	void	CalcLineMap		();
//STRIP001 	void	PaintCells		();
//STRIP001 	void	DrawBackground	( BYTE nIndex );
//STRIP001 	void	DrawFrame		( BYTE nIndex );
//STRIP001 	void	DrawString		( BYTE nIndex );
//STRIP001     void    MakeFonts       ( BYTE nIndex, Font& rFont, Font& rCJKFont, Font& rCTLFont );
//STRIP001 	String	MakeNumberString( String cellString, BOOL bAddDec );
//STRIP001 	void	DrawFrameLine	( const SvxBorderLine&	rLineD,
//STRIP001 							  Point					from,
//STRIP001 							  Point					to,
//STRIP001 							  BOOL					bHorizontal,
//STRIP001 							  const SvxBorderLine&	rLineLT,
//STRIP001 							  const SvxBorderLine&	rLineL,
//STRIP001 							  const SvxBorderLine&	rLineLB,
//STRIP001 							  const SvxBorderLine&	rLineRT,
//STRIP001 							  const SvxBorderLine&	rLineR,
//STRIP001 							  const SvxBorderLine&	rLineRB );
//STRIP001 	void 	CheckPriority	( USHORT			nCurLine,
//STRIP001 							  AutoFmtLine		eLine,
//STRIP001 							  SvxBorderLine&	rLine );
//STRIP001 	void	GetLines		( BYTE nIndex, AutoFmtLine eLine,
//STRIP001 							  SvxBorderLine&	rLineD,
//STRIP001 							  SvxBorderLine&	rLineLT,
//STRIP001 							  SvxBorderLine&	rLineL,
//STRIP001 							  SvxBorderLine&	rLineLB,
//STRIP001 							  SvxBorderLine&	rLineRT,
//STRIP001 							  SvxBorderLine&	rLineR,
//STRIP001 							  SvxBorderLine&	rLineRB );
//STRIP001 };
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 
//STRIP001 struct SwLineStruct
//STRIP001 {
//STRIP001 	short nLeft;  //Breite der linken Linie
//STRIP001 	short nMiddle;//Breite des Zwischenraums
//STRIP001 	short nRight; //Breite der rechten Linie
//STRIP001 };
//STRIP001 
//STRIP001 void lcl_SwLinkLine( const SwLineStruct& dLine,
//STRIP001 						const SwLineStruct& ltLine,
//STRIP001 						const SwLineStruct& lLine,
//STRIP001 						const SwLineStruct& lbLine,
//STRIP001 						const SwLineStruct& rtLine,
//STRIP001 						const SwLineStruct& rLine,
//STRIP001 						const SwLineStruct& rbLine,
//STRIP001 						short* dxArr);
//STRIP001 
//STRIP001 //SC-Produkt!
//STRIP001 BOOL lcl_HasPriority(	const SvxBorderLine* pThis,
//STRIP001 						const SvxBorderLine* pOther );
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 class SwStringInputDlg : public ModalDialog
//STRIP001 {
//STRIP001 public:
//STRIP001 			SwStringInputDlg( 	  Window* pParent,
//STRIP001 							const String& rTitle,
//STRIP001 							const String& rEditTitle,
//STRIP001 							const String& rDefault );
//STRIP001 			~SwStringInputDlg();
//STRIP001 
//STRIP001 	void GetInputString( String& rString ) const;
//STRIP001 
//STRIP001 private:
//STRIP001 	Edit			aEdInput;	// Edit erhaelt so den Focus
//STRIP001 	FixedText		aFtEditTitle;
//STRIP001 	OKButton		aBtnOk;
//STRIP001 	CancelButton	aBtnCancel;
//STRIP001 };
//STRIP001 
//STRIP001 
//STRIP001 BYTE AutoFmtPreview::aFmtMap[] = { 0,  1,  2,  1,  3, // Zuordnung:
//STRIP001 								   4,  5,  6,  5,  7, // Zelle->Format
//STRIP001 								   8,  9, 10,  9, 11,
//STRIP001 								   4,  5,  6,  5,  7,
//STRIP001 								  12, 13, 14, 13, 15  };
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 SwStringInputDlg::SwStringInputDlg( Window* 		pParent,
//STRIP001 									const String&	rTitle,
//STRIP001 									const String&	rEditTitle,
//STRIP001 									const String&	rDefault	) :
//STRIP001 	ModalDialog 	( pParent, SW_RES( DLG_SWDLG_STRINPUT ) ),
//STRIP001 	//
//STRIP001 	aEdInput		( this, SW_RES( ED_INPUT ) ),
//STRIP001 	aBtnOk			( this, SW_RES( BTN_OK ) ),
//STRIP001 	aBtnCancel		( this, SW_RES( BTN_CANCEL ) ),
//STRIP001 	aFtEditTitle	( this, SW_RES( FT_LABEL ) )
//STRIP001 {
//STRIP001 	SetText( rTitle );
//STRIP001 	aFtEditTitle.SetText( rEditTitle );
//STRIP001 	aEdInput.SetText( rDefault );
//STRIP001 	//-------------
//STRIP001 	FreeResource();
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SwStringInputDlg::GetInputString( String& rString ) const
//STRIP001 {
//STRIP001 	rString = aEdInput.GetText();
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 __EXPORT SwStringInputDlg::~SwStringInputDlg()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 // AutoFormat-Dialog:
//STRIP001 
//STRIP001 
//STRIP001 SwAutoFormatDlg::SwAutoFormatDlg( Window* pParent, SwWrtShell* pWrtShell,
//STRIP001 					BOOL bSetAutoFormat, const SwTableAutoFmt* pSelFmt )
//STRIP001 	: SfxModalDialog( pParent, SW_RES( DLG_AUTOFMT_TABLE ) ),
//STRIP001 	//
//STRIP001     aFlFormat       ( this, SW_RES( FL_FORMAT ) ),
//STRIP001 	aLbFormat		( this, SW_RES( LB_FORMAT ) ),
//STRIP001 	pWndPreview 	( new AutoFmtPreview( this, SW_RES( WND_PREVIEW ) ) ),
//STRIP001 	aBtnNumFormat	( this, SW_RES( BTN_NUMFORMAT ) ),
//STRIP001 	aBtnBorder		( this, SW_RES( BTN_BORDER ) ),
//STRIP001 	aBtnFont		( this, SW_RES( BTN_FONT ) ),
//STRIP001 	aBtnPattern 	( this, SW_RES( BTN_PATTERN ) ),
//STRIP001 	aBtnAlignment	( this, SW_RES( BTN_ALIGNMENT ) ),
//STRIP001     aFlFormats       ( this, SW_RES( FL_FORMATS ) ),
//STRIP001 	aBtnOk			( this, SW_RES( BTN_OK ) ),
//STRIP001 	aBtnCancel		( this, SW_RES( BTN_CANCEL ) ),
//STRIP001 	aBtnHelp		( this, SW_RES( BTN_HELP ) ),
//STRIP001 	aBtnAdd 		( this, SW_RES( BTN_ADD ) ),
//STRIP001 	aBtnRemove		( this, SW_RES( BTN_REMOVE ) ),
//STRIP001 	aBtnMore		( this, SW_RES( BTN_MORE ) ),
//STRIP001 	aBtnRename		( this, SW_RES( BTN_RENAME ) ),
//STRIP001 	aStrTitle		( SW_RES( STR_ADD_TITLE ) ),
//STRIP001 	aStrLabel		( SW_RES( STR_ADD_LABEL ) ),
//STRIP001 	aStrClose		( SW_RES( STR_BTN_CLOSE ) ),
//STRIP001 	aStrDelTitle	( SW_RES( STR_DEL_TITLE ) ),
//STRIP001 	aStrDelMsg		( SW_RES( STR_DEL_MSG ) ),
//STRIP001 	aStrRenameTitle	( SW_RES( STR_RENAME_TITLE ) ),
//STRIP001 	aStrInvalidFmt	( SW_RES( STR_INVALID_AFNAME )),
//STRIP001 	//
//STRIP001 	nIndex			( 0 ),
//STRIP001 	nDfltStylePos	( 0 ),
//STRIP001 	bCoreDataChanged( FALSE ),
//STRIP001 	bSetAutoFmt		( bSetAutoFormat ),
//STRIP001 	pShell			( pWrtShell )
//STRIP001 {
//STRIP001 	pTableTbl = new SwTableAutoFmtTbl;
//STRIP001 	pTableTbl->Load();
//STRIP001 
//STRIP001 	Init( pSelFmt );
//STRIP001 	//------------- >
//STRIP001 	FreeResource();
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 
//STRIP001 __EXPORT SwAutoFormatDlg::~SwAutoFormatDlg()
//STRIP001 {
//STRIP001 	delete pWndPreview;
//STRIP001 
//STRIP001 	if( bCoreDataChanged )
//STRIP001 		pTableTbl->Save();
//STRIP001 	delete pTableTbl;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 
//STRIP001 void SwAutoFormatDlg::Init( const SwTableAutoFmt* pSelFmt )
//STRIP001 {
//STRIP001 	Link aLk( LINK( this, SwAutoFormatDlg, CheckHdl ) );
//STRIP001 	aBtnBorder.SetClickHdl( aLk );
//STRIP001 	aBtnFont.SetClickHdl( aLk );
//STRIP001 	aBtnPattern.SetClickHdl( aLk );
//STRIP001 	aBtnAlignment.SetClickHdl( aLk );
//STRIP001 	aBtnNumFormat.SetClickHdl( aLk );
//STRIP001 
//STRIP001 	aBtnAdd.SetClickHdl ( LINK( this, SwAutoFormatDlg, AddHdl ) );
//STRIP001 	aBtnRemove.SetClickHdl ( LINK( this, SwAutoFormatDlg, RemoveHdl ) );
//STRIP001 	aBtnRename.SetClickHdl ( LINK( this, SwAutoFormatDlg, RenameHdl ) );
//STRIP001 	aBtnOk.SetClickHdl ( LINK( this, SwAutoFormatDlg, OkHdl ) );
//STRIP001 	aLbFormat.SetSelectHdl( LINK( this, SwAutoFormatDlg, SelFmtHdl ) );
//STRIP001 
//STRIP001 	aBtnMore.AddWindow( &aBtnNumFormat );
//STRIP001 	aBtnMore.AddWindow( &aBtnBorder );
//STRIP001 	aBtnMore.AddWindow( &aBtnFont );
//STRIP001 	aBtnMore.AddWindow( &aBtnPattern );
//STRIP001 	aBtnMore.AddWindow( &aBtnAlignment );
//STRIP001     aBtnMore.AddWindow( &aFlFormats );
//STRIP001 	aBtnMore.AddWindow( &aBtnRename );
//STRIP001 
//STRIP001 	aBtnAdd.Enable( bSetAutoFmt );
//STRIP001 
//STRIP001 	nIndex = 0;
//STRIP001 	if( !bSetAutoFmt )
//STRIP001 	{
//STRIP001 		// dann muss die Liste um den Eintrag <Keins> erweitert werden.
//STRIP001 		aLbFormat.InsertEntry( ViewShell::GetShellRes()->aStrNone );
//STRIP001 		nDfltStylePos = 1;
//STRIP001 		nIndex = 255;
//STRIP001 	}
//STRIP001 
//STRIP001 	for( BYTE i = 0, nCount = (BYTE)pTableTbl->Count(); i < nCount; i++ )
//STRIP001 	{
//STRIP001 		SwTableAutoFmt* pFmt = (*pTableTbl)[ i ];
//STRIP001 		aLbFormat.InsertEntry( pFmt->GetName() );
//STRIP001 		if( pSelFmt && pFmt->GetName() == pSelFmt->GetName() )
//STRIP001 			nIndex = i;
//STRIP001 	}
//STRIP001 
//STRIP001 	aLbFormat.SelectEntryPos( 255 != nIndex ? (nDfltStylePos + nIndex) : 0 );
//STRIP001 	SelFmtHdl( 0 );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 
//STRIP001 void SwAutoFormatDlg::UpdateChecks( const SwTableAutoFmt& rFmt, BOOL bEnable )
//STRIP001 {
//STRIP001 	aBtnNumFormat.Enable( bEnable );
//STRIP001 	aBtnNumFormat.Check( rFmt.IsValueFormat() );
//STRIP001 
//STRIP001 	aBtnBorder.Enable( bEnable );
//STRIP001 	aBtnBorder.Check( rFmt.IsFrame() );
//STRIP001 
//STRIP001 	aBtnFont.Enable( bEnable );
//STRIP001 	aBtnFont.Check( rFmt.IsFont() );
//STRIP001 
//STRIP001 	aBtnPattern.Enable( bEnable );
//STRIP001 	aBtnPattern.Check( rFmt.IsBackground() );
//STRIP001 
//STRIP001 	aBtnAlignment.Enable( bEnable );
//STRIP001 	aBtnAlignment.Check( rFmt.IsJustify() );
//STRIP001 }
//STRIP001 
//STRIP001 void SwAutoFormatDlg::FillAutoFmtOfIndex( SwTableAutoFmt*& rToFill ) const
//STRIP001 {
//STRIP001 	if( 255 != nIndex )
//STRIP001 	{
//STRIP001 		if( rToFill )
//STRIP001 			*rToFill = *(*pTableTbl)[ nIndex ];
//STRIP001 		else
//STRIP001 			rToFill = new SwTableAutoFmt( *(*pTableTbl)[ nIndex ] );
//STRIP001 	}
//STRIP001 	else if( rToFill )
//STRIP001 		delete rToFill, rToFill = 0;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*------------------------------------------------------------------------
//STRIP001   Handler:
//STRIP001   ---------*/
//STRIP001 
//STRIP001 
//STRIP001 IMPL_LINK( SwAutoFormatDlg, CheckHdl, Button *, pBtn )
//STRIP001 {
//STRIP001 	SwTableAutoFmtPtr pData  = (*pTableTbl)[nIndex];
//STRIP001 	BOOL bCheck = ((CheckBox*)pBtn)->IsChecked(), bDataChgd = TRUE;
//STRIP001 
//STRIP001 	if( pBtn == &aBtnNumFormat )
//STRIP001 		pData->SetValueFormat( bCheck );
//STRIP001 	else if ( pBtn == &aBtnBorder )
//STRIP001 		pData->SetFrame( bCheck );
//STRIP001 	else if ( pBtn == &aBtnFont )
//STRIP001 		pData->SetFont( bCheck );
//STRIP001 	else if ( pBtn == &aBtnPattern )
//STRIP001 		pData->SetBackground( bCheck );
//STRIP001 	else if ( pBtn == &aBtnAlignment )
//STRIP001 		pData->SetJustify( bCheck );
//STRIP001 //	  else if ( pBtn == &aBtnAdjust )
//STRIP001 //		  pData->SetIncludeWidthHeight( bCheck );
//STRIP001 	else
//STRIP001 		bDataChgd = FALSE;
//STRIP001 
//STRIP001 	if( bDataChgd )
//STRIP001 	{
//STRIP001 		if( !bCoreDataChanged )
//STRIP001 		{
//STRIP001 			aBtnCancel.SetText( aStrClose );
//STRIP001 			bCoreDataChanged = TRUE;
//STRIP001 		}
//STRIP001 
//STRIP001 		pWndPreview->NotifyChange( *pData );
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 /*------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 IMPL_LINK( SwAutoFormatDlg, AddHdl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	BOOL bOk = FALSE, bFmtInserted = FALSE;
//STRIP001 	while( !bOk )
//STRIP001 	{
//STRIP001 		SwStringInputDlg*	pDlg = new SwStringInputDlg( this,
//STRIP001 															aStrTitle,
//STRIP001 															aStrLabel,
//STRIP001 															aEmptyStr );
//STRIP001 		if( RET_OK == pDlg->Execute() )
//STRIP001 		{
//STRIP001 			String aFormatName;
//STRIP001 			pDlg->GetInputString( aFormatName );
//STRIP001 
//STRIP001 			if( aFormatName.Len() > 0 )
//STRIP001 			{
//STRIP001 				for( USHORT n = 0; n < pTableTbl->Count(); ++n )
//STRIP001 					if( (*pTableTbl)[n]->GetName() == aFormatName )
//STRIP001 						break;
//STRIP001 
//STRIP001 				if( n >= pTableTbl->Count() )
//STRIP001 				{
//STRIP001 					// Format mit dem Namen noch nicht vorhanden, also
//STRIP001 					// aufnehmen
//STRIP001 					SwTableAutoFmtPtr pNewData = new
//STRIP001 										SwTableAutoFmt( aFormatName );
//STRIP001 					pShell->GetTableAutoFmt( *pNewData );
//STRIP001 
//STRIP001 					// Sortiert einfuegen!!
//STRIP001 					for( n = 1; n < pTableTbl->Count(); ++n )
//STRIP001 						if( (*pTableTbl)[ n ]->GetName() > aFormatName )
//STRIP001 							break;
//STRIP001 
//STRIP001 					pTableTbl->Insert( pNewData, n );
//STRIP001 					aLbFormat.InsertEntry( aFormatName, nDfltStylePos + n );
//STRIP001 					aLbFormat.SelectEntryPos( nDfltStylePos + n );
//STRIP001 					bFmtInserted = TRUE;
//STRIP001 					aBtnAdd.Enable( FALSE );
//STRIP001 					if ( !bCoreDataChanged )
//STRIP001 					{
//STRIP001 						aBtnCancel.SetText( aStrClose );
//STRIP001 						bCoreDataChanged = TRUE;
//STRIP001 					}
//STRIP001 
//STRIP001 					SelFmtHdl( 0 );
//STRIP001 					bOk = TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			if( !bFmtInserted )
//STRIP001 			{
//STRIP001 				bOk = RET_CANCEL == ErrorBox( this,
//STRIP001 									WinBits( WB_OK_CANCEL | WB_DEF_OK),
//STRIP001 									aStrInvalidFmt
//STRIP001 									).Execute();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 			bOk = TRUE;
//STRIP001 		delete pDlg;
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SwAutoFormatDlg, RemoveHdl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	String aMessage	= aStrDelMsg ;
//STRIP001 	aMessage.AppendAscii("\n\n");
//STRIP001 	aMessage += aLbFormat.GetSelectEntry() ;
//STRIP001 	aMessage += '\n';
//STRIP001 
//STRIP001 	MessBox* pBox = new MessBox( this, WinBits( WB_OK_CANCEL ),
//STRIP001 									aStrDelTitle, aMessage);
//STRIP001 
//STRIP001 	if ( pBox->Execute() == RET_OK )
//STRIP001 	{
//STRIP001 		aLbFormat.RemoveEntry( nDfltStylePos + nIndex );
//STRIP001 		aLbFormat.SelectEntryPos( nDfltStylePos + nIndex-1 );
//STRIP001 
//STRIP001 		pTableTbl->DeleteAndDestroy( nIndex );
//STRIP001 		nIndex--;
//STRIP001 
//STRIP001 		if( !nIndex )
//STRIP001 		{
//STRIP001 			aBtnRemove.Enable(FALSE);
//STRIP001 			aBtnRename.Enable(FALSE);
//STRIP001 		}
//STRIP001 
//STRIP001 		if( !bCoreDataChanged )
//STRIP001 		{
//STRIP001 			aBtnCancel.SetText( aStrClose );
//STRIP001 			bCoreDataChanged = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	delete pBox;
//STRIP001 
//STRIP001 	SelFmtHdl( 0 );
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK( SwAutoFormatDlg, RenameHdl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	BOOL bOk = FALSE;
//STRIP001 	while( !bOk )
//STRIP001 	{
//STRIP001 		SwStringInputDlg* pDlg = new SwStringInputDlg( this,
//STRIP001 						aStrRenameTitle, aLbFormat.GetSelectEntry(),
//STRIP001 														aEmptyStr );
//STRIP001 		if( pDlg->Execute() == RET_OK )
//STRIP001 		{
//STRIP001 			BOOL bFmtRenamed = FALSE;
//STRIP001 			String aFormatName;
//STRIP001 			pDlg->GetInputString( aFormatName );
//STRIP001 
//STRIP001 			if ( aFormatName.Len() > 0 )
//STRIP001 			{
//STRIP001 				for( USHORT n = 0; n < pTableTbl->Count(); ++n )
//STRIP001 					if ((*pTableTbl)[n]->GetName() == aFormatName)
//STRIP001 						break;
//STRIP001 
//STRIP001 				if( n >= pTableTbl->Count() )
//STRIP001 				{
//STRIP001 					// Format mit dem Namen noch nicht vorhanden, also
//STRIP001 					// umbenennen
//STRIP001 
//STRIP001 					aLbFormat.RemoveEntry( nDfltStylePos + nIndex );
//STRIP001 					SwTableAutoFmtPtr p = (*pTableTbl)[ nIndex ];
//STRIP001 					pTableTbl->Remove( nIndex );
//STRIP001 
//STRIP001 					p->SetName( aFormatName );
//STRIP001 
//STRIP001 					// Sortiert einfuegen!!
//STRIP001 					for( n = 1; n < pTableTbl->Count(); ++n )
//STRIP001 						if( (*pTableTbl)[ n ]->GetName() > aFormatName )
//STRIP001 							break;
//STRIP001 
//STRIP001 					pTableTbl->Insert( p, n );
//STRIP001 					aLbFormat.InsertEntry( aFormatName, nDfltStylePos + n );
//STRIP001 					aLbFormat.SelectEntryPos( nDfltStylePos + n );
//STRIP001 
//STRIP001 					if ( !bCoreDataChanged )
//STRIP001 					{
//STRIP001 						aBtnCancel.SetText( aStrClose );
//STRIP001 						bCoreDataChanged = TRUE;
//STRIP001 					}
//STRIP001 
//STRIP001 					SelFmtHdl( 0 );
//STRIP001 					bOk = TRUE;
//STRIP001 					bFmtRenamed = TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			if( !bFmtRenamed )
//STRIP001 			{
//STRIP001 				bOk = RET_CANCEL == ErrorBox( this,
//STRIP001 									WinBits( WB_OK_CANCEL | WB_DEF_OK),
//STRIP001 									aStrInvalidFmt
//STRIP001 									).Execute();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 			bOk = TRUE;
//STRIP001 		delete pDlg;
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SwAutoFormatDlg, SelFmtHdl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	BOOL bBtnEnable = FALSE;
//STRIP001 	BYTE nSelPos = (BYTE) aLbFormat.GetSelectEntryPos(), nOldIdx = nIndex;
//STRIP001 	if( nSelPos >= nDfltStylePos )
//STRIP001 	{
//STRIP001 		nIndex = nSelPos - nDfltStylePos;
//STRIP001 		pWndPreview->NotifyChange( *(*pTableTbl)[nIndex] );
//STRIP001 		bBtnEnable = 0 != nIndex;
//STRIP001 		UpdateChecks( *(*pTableTbl)[nIndex], TRUE );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		nIndex = 255;
//STRIP001 
//STRIP001 		SwTableAutoFmt aTmp( ViewShell::GetShellRes()->aStrNone );
//STRIP001 		aTmp.SetFont( FALSE );
//STRIP001 		aTmp.SetJustify( FALSE );
//STRIP001 		aTmp.SetFrame( FALSE );
//STRIP001 		aTmp.SetBackground( FALSE );
//STRIP001 		aTmp.SetValueFormat( FALSE );
//STRIP001 		aTmp.SetWidthHeight( FALSE );
//STRIP001 
//STRIP001 		if( nOldIdx != nIndex )
//STRIP001 			pWndPreview->NotifyChange( aTmp );
//STRIP001 		UpdateChecks( aTmp, FALSE );
//STRIP001 	}
//STRIP001 
//STRIP001 	aBtnRemove.Enable( bBtnEnable );
//STRIP001 	aBtnRename.Enable( bBtnEnable );
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK_INLINE_START( SwAutoFormatDlg, OkHdl, Button *, EMPTYARG )
//STRIP001 {
//STRIP001 	if( bSetAutoFmt )
//STRIP001 		pShell->SetTableAutoFmt( *(*pTableTbl)[ nIndex ] );
//STRIP001 	EndDialog( RET_OK );
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SwAutoFormatDlg, OkHdl, Button *, EMPTYARG )
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 // AutoFmtPreview
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 AutoFmtPreview::AutoFmtPreview( Window* pParent, const ResId& rRes ) :
//STRIP001 		Window			( pParent, rRes ),
//STRIP001 		aVD 			( *this ),
//STRIP001         aScriptedText   ( aVD ),
//STRIP001 		aCurData		( aEmptyStr ),
//STRIP001 		bFitWidth		( FALSE ),
//STRIP001 		aStrJan 		( SW_RES( STR_JAN ) ),
//STRIP001 		aStrFeb 		( SW_RES( STR_FEB ) ),
//STRIP001 		aStrMar 		( SW_RES( STR_MAR ) ),
//STRIP001 		aStrNorth		( SW_RES( STR_NORTH ) ),
//STRIP001 		aStrMid 		( SW_RES( STR_MID ) ),
//STRIP001 		aStrSouth		( SW_RES( STR_SOUTH ) ),
//STRIP001 		aStrSum 		( SW_RES( STR_SUM ) ),
//STRIP001 		aPrvSize		( GetSizePixel().Width()  - 6,
//STRIP001 						  GetSizePixel().Height() - 30 ),
//STRIP001 		nLabelColWidth	( (USHORT)(((aPrvSize.Width()-4)/4)-12) ),
//STRIP001 		nDataColWidth1	( (USHORT)(((aPrvSize.Width()-4)-(nLabelColWidth*2)) / 3) ),
//STRIP001 		nDataColWidth2	( (USHORT)(((aPrvSize.Width()-4)-(nLabelColWidth*2)) / 4) ),
//STRIP001 		nRowHeight		( (USHORT)((aPrvSize.Height()-4) / 5) )
//STRIP001 {
//STRIP001 	Reference< XMultiServiceFactory > xMSF = ::legacy_binfilters::getLegacyProcessServiceFactory();
//STRIP001 	pNumFmt	= new SvNumberFormatter( xMSF, LANGUAGE_SYSTEM );
//STRIP001 
//STRIP001 	Init();
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 __EXPORT AutoFmtPreview::~AutoFmtPreview()
//STRIP001 {
//STRIP001 	for ( USHORT i=0; i<=35; i++ )
//STRIP001 	{
//STRIP001 		delete aLinePtrArray[i];
//STRIP001 	}
//STRIP001 	delete pNumFmt;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void lcl_AssignLine( SvxBorderLine& 	  dest,
//STRIP001 						const SvxBorderLine* src )
//STRIP001 {
//STRIP001 	if( src )
//STRIP001 	{
//STRIP001 		dest.SetColor( src->GetColor() );
//STRIP001 		dest.SetOutWidth( src->GetOutWidth() );
//STRIP001 		dest.SetInWidth( src->GetInWidth() );
//STRIP001 		dest.SetDistance( src->GetDistance() );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		dest.SetColor( Color( COL_WHITE ) );
//STRIP001 		dest.SetOutWidth ( 0 );
//STRIP001 		dest.SetInWidth  ( 0 );
//STRIP001 		dest.SetDistance ( 0 );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void lcl_GetLineStruct(	SwLineStruct&		 rLine,
//STRIP001 						const SvxBorderLine& rBoxLine )
//STRIP001 {
//STRIP001 	if ( rBoxLine.GetOutWidth() > 0 )
//STRIP001 	{
//STRIP001 		rLine.nLeft 	= rBoxLine.GetOutWidth();
//STRIP001 		rLine.nMiddle	= rBoxLine.GetDistance();
//STRIP001 		rLine.nRight	= rBoxLine.GetInWidth();
//STRIP001 
//STRIP001 		/* Linienstaerke auf dick/duenn abbilden:
//STRIP001 		 *
//STRIP001 		 * (in TWIPS, 1pt = 20 TWIPS = duenn)
//STRIP001 		 * alles was <=0  ist -> (0,0,0)
//STRIP001 		 * alles was <=20 ist -> (1,0,0)/(1,1,1)
//STRIP001 		 * alles andere 	  -> (3,0,0)/(2,1,2)
//STRIP001 		 */
//STRIP001 
//STRIP001 		if ( rLine.nMiddle == 0 ) // einfache Linie?
//STRIP001 		{
//STRIP001 			rLine.nRight = 0; // sicher ist sicher
//STRIP001 
//STRIP001 			if ( rLine.nLeft <= 20 )
//STRIP001 			{
//STRIP001 				rLine.nLeft = 1;
//STRIP001 			}
//STRIP001 			else if ( rLine.nLeft > 20 )
//STRIP001 			{
//STRIP001 				rLine.nLeft = 3;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else // doppelte Linie
//STRIP001 		{
//STRIP001 			rLine.nMiddle = 1;
//STRIP001 			if ( rLine.nLeft <= 20 )
//STRIP001 			{
//STRIP001 				rLine.nLeft = rLine.nRight = 1;
//STRIP001 			}
//STRIP001 			else if ( rLine.nLeft > 20 )
//STRIP001 			{
//STRIP001 				rLine.nLeft = rLine.nRight = 2;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		rLine.nLeft 	= 0;
//STRIP001 		rLine.nMiddle	= 0;
//STRIP001 		rLine.nRight	= 0;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void AutoFmtPreview::CheckPriority( USHORT			nCurLine,
//STRIP001 									AutoFmtLine 	eLine,
//STRIP001 									SvxBorderLine&	rLine )
//STRIP001 {
//STRIP001 
//STRIP001 	 const SvxBorderLine*	 pDrawLine;
//STRIP001 	USHORT					nOther = 0;
//STRIP001 
//STRIP001 	switch ( eLine )
//STRIP001 	{
//STRIP001 		case TOP_LINE:
//STRIP001 			{
//STRIP001 				lcl_AssignLine( rLine, aLinePtrArray[nCurLine]->GetTop() );
//STRIP001 				nOther = nCurLine-7;
//STRIP001 				pDrawLine = aLinePtrArray[nOther]->GetBottom();
//STRIP001 
//STRIP001 				if ( lcl_HasPriority( pDrawLine, &rLine ) )
//STRIP001 					lcl_AssignLine( rLine, pDrawLine );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case BOTTOM_LINE:
//STRIP001 			{
//STRIP001 				lcl_AssignLine( rLine, aLinePtrArray[nCurLine]->GetBottom() );
//STRIP001 				nOther = nCurLine+7;
//STRIP001 				pDrawLine = aLinePtrArray[nOther]->GetTop();
//STRIP001 
//STRIP001 				if ( lcl_HasPriority( pDrawLine, &rLine ) )
//STRIP001 					lcl_AssignLine( rLine, pDrawLine );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case LEFT_LINE:
//STRIP001 			{
//STRIP001 				lcl_AssignLine( rLine, aLinePtrArray[nCurLine]->GetLeft() );
//STRIP001 				nOther = nCurLine-1;
//STRIP001 				pDrawLine = aLinePtrArray[nOther]->GetRight();
//STRIP001 
//STRIP001 				if ( lcl_HasPriority( pDrawLine, &rLine ) )
//STRIP001 					lcl_AssignLine( rLine, pDrawLine );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case RIGHT_LINE:
//STRIP001 			{
//STRIP001 				lcl_AssignLine( rLine, aLinePtrArray[nCurLine]->GetRight() );
//STRIP001 				nOther = nCurLine+1;
//STRIP001 				pDrawLine = aLinePtrArray[nOther]->GetLeft();
//STRIP001 
//STRIP001 				if ( lcl_HasPriority( pDrawLine, &rLine ) )
//STRIP001 					lcl_AssignLine( rLine, pDrawLine );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void AutoFmtPreview::GetLines( BYTE nIndex, AutoFmtLine eLine,
//STRIP001 							   SvxBorderLine&	rLineD,
//STRIP001 							   SvxBorderLine&	rLineLT,
//STRIP001 							   SvxBorderLine&	rLineL,
//STRIP001 							   SvxBorderLine&	rLineLB,
//STRIP001 							   SvxBorderLine&	rLineRT,
//STRIP001 							   SvxBorderLine&	rLineR,
//STRIP001 							   SvxBorderLine&	rLineRB )
//STRIP001 {
//STRIP001 	{
//STRIP001 		SvxBorderLine aNullLine;
//STRIP001 
//STRIP001 		lcl_AssignLine( rLineD,  &aNullLine);
//STRIP001 		lcl_AssignLine( rLineLT, &aNullLine);
//STRIP001 		lcl_AssignLine( rLineL,  &aNullLine);
//STRIP001 		lcl_AssignLine( rLineLB, &aNullLine);
//STRIP001 		lcl_AssignLine( rLineRT, &aNullLine);
//STRIP001 		lcl_AssignLine( rLineR,  &aNullLine);
//STRIP001 		lcl_AssignLine( rLineRB, &aNullLine);
//STRIP001 	}
//STRIP001 
//STRIP001 	USHORT	nCurLine   = nIndex + 8 + ((nIndex/5)*2);
//STRIP001 	USHORT	nOther	   = 0;
//STRIP001 
//STRIP001 	switch ( eLine )
//STRIP001 	{
//STRIP001 		case TOP_LINE:
//STRIP001 			{
//STRIP001 				// obere Linien werden nur in der
//STRIP001 				// ersten Zeile gemalt:
//STRIP001 				if ( (nIndex >= 0) && (nIndex <= 4) )
//STRIP001 				{
//STRIP001 					// links
//STRIP001 					CheckPriority( nCurLine, eLine, rLineD );
//STRIP001 					nOther = nCurLine-7;
//STRIP001 					CheckPriority( nOther, LEFT_LINE, rLineLT );
//STRIP001 					nOther = nCurLine-1;
//STRIP001 					CheckPriority( nOther, TOP_LINE, rLineL );
//STRIP001 					CheckPriority( nCurLine, LEFT_LINE, rLineLB );
//STRIP001 					// rechts
//STRIP001 					nOther = nCurLine-7;
//STRIP001 					CheckPriority( nOther, RIGHT_LINE, rLineRT );
//STRIP001 					nOther = nCurLine+1;
//STRIP001 					CheckPriority( nOther, TOP_LINE, rLineR );
//STRIP001 					CheckPriority( nCurLine, RIGHT_LINE, rLineRB );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case BOTTOM_LINE:
//STRIP001 			{
//STRIP001 				// links
//STRIP001 				CheckPriority( nCurLine, eLine, rLineD );
//STRIP001 				CheckPriority( nCurLine, LEFT_LINE, rLineLT );
//STRIP001 				nOther = nCurLine-1;
//STRIP001 				CheckPriority( nOther, BOTTOM_LINE, rLineL );
//STRIP001 				nOther = nCurLine+7;
//STRIP001 				CheckPriority( nOther, LEFT_LINE, rLineLB );
//STRIP001 				// rechts
//STRIP001 				CheckPriority( nCurLine, RIGHT_LINE, rLineRT );
//STRIP001 				nOther = nCurLine+1;
//STRIP001 				CheckPriority( nOther, BOTTOM_LINE, rLineR );
//STRIP001 				nOther = nCurLine+7;
//STRIP001 				CheckPriority( nOther, RIGHT_LINE, rLineRB );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case LEFT_LINE:
//STRIP001 			{
//STRIP001 				// linke Linien werden nur in der
//STRIP001 				// ersten Spalte gemalt:
//STRIP001 				if ( (nIndex%5) == 0 )
//STRIP001 				{
//STRIP001 					// oben
//STRIP001 					CheckPriority( nCurLine, eLine, rLineD );
//STRIP001 					CheckPriority( nCurLine, TOP_LINE, rLineLT );
//STRIP001 					nOther = nCurLine-7;
//STRIP001 					CheckPriority( nOther, LEFT_LINE, rLineL );
//STRIP001 					nOther = nCurLine-1;
//STRIP001 					CheckPriority( nOther, TOP_LINE, rLineLB );
//STRIP001 					// unten
//STRIP001 					CheckPriority( nCurLine, BOTTOM_LINE, rLineRT );
//STRIP001 					nOther = nCurLine+7;
//STRIP001 					CheckPriority( nOther, LEFT_LINE, rLineR );
//STRIP001 					nOther = nCurLine-1;
//STRIP001 					CheckPriority( nOther, BOTTOM_LINE, rLineRB );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case RIGHT_LINE:
//STRIP001 			{
//STRIP001 				// oben
//STRIP001 				CheckPriority( nCurLine, eLine, rLineD );
//STRIP001 				nOther = nCurLine+1;
//STRIP001 				CheckPriority( nOther, TOP_LINE, rLineLT );
//STRIP001 				nOther = nCurLine-7;
//STRIP001 				CheckPriority( nOther, RIGHT_LINE, rLineL );
//STRIP001 				CheckPriority( nCurLine, TOP_LINE, rLineLB );
//STRIP001 				// unten
//STRIP001 				nOther = nCurLine+1;
//STRIP001 				CheckPriority( nOther, BOTTOM_LINE, rLineRT );
//STRIP001 				nOther = nCurLine+7;
//STRIP001 				CheckPriority( nOther, RIGHT_LINE, rLineR );
//STRIP001 				CheckPriority( nCurLine, BOTTOM_LINE, rLineRB );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void lcl_DrawHorizontalLine( OutputDevice& rDev, const Point& rStart, const Point& rEnd )
//STRIP001 {
//STRIP001     DBG_ASSERT( rStart.Y() <= rEnd.Y(), "lcl_DrawHorizontalLine - wrong point order" );
//STRIP001     Point aLineStart( rStart );
//STRIP001     Point aLineEnd( rEnd.X(), rStart.Y() );
//STRIP001     while( aLineStart.Y() <= rEnd.Y() )
//STRIP001     {
//STRIP001         rDev.DrawLine( aLineStart, aLineEnd );
//STRIP001         ++aLineStart.Y();
//STRIP001         ++aLineEnd.Y();
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 void lcl_DrawVerticalLine( OutputDevice& rDev, const Point& rStart, const Point& rEnd )
//STRIP001 {
//STRIP001     DBG_ASSERT( rStart.X() <= rEnd.X(), "lcl_DrawVerticalLine - wrong point order" );
//STRIP001     Point aLineStart( rStart );
//STRIP001     Point aLineEnd( rStart.X(), rEnd.Y() );
//STRIP001     while( aLineStart.X() <= rEnd.X() )
//STRIP001     {
//STRIP001         rDev.DrawLine( aLineStart, aLineEnd );
//STRIP001         ++aLineStart.X();
//STRIP001         ++aLineEnd.X();
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 void AutoFmtPreview::DrawFrameLine( const SvxBorderLine&	rLineD,
//STRIP001 									Point					from,
//STRIP001 									Point					to,
//STRIP001 									BOOL					bHorizontal,
//STRIP001 									const SvxBorderLine&	rLineLT,
//STRIP001 									const SvxBorderLine&	rLineL,
//STRIP001 									const SvxBorderLine&	rLineLB,
//STRIP001 									const SvxBorderLine&	rLineRT,
//STRIP001 									const SvxBorderLine&	rLineR,
//STRIP001 									const SvxBorderLine&	rLineRB )
//STRIP001 {
//STRIP001 	SwLineStruct	dLine;
//STRIP001 	SwLineStruct	ltLine;
//STRIP001 	SwLineStruct	lLine;
//STRIP001 	SwLineStruct	lbLine;
//STRIP001 	SwLineStruct	rtLine;
//STRIP001 	SwLineStruct	rLine;
//STRIP001 	SwLineStruct	rbLine;
//STRIP001 	short			dxArr[4];
//STRIP001 
//STRIP001 	lcl_GetLineStruct( dLine,	rLineD	);
//STRIP001 	lcl_GetLineStruct( ltLine,	rLineLT );
//STRIP001 	lcl_GetLineStruct( lLine,	rLineL	);
//STRIP001 	lcl_GetLineStruct( lbLine,	rLineLB );
//STRIP001 	lcl_GetLineStruct( rtLine,	rLineRT );
//STRIP001 	lcl_GetLineStruct( rLine,	rLineR	);
//STRIP001 	lcl_GetLineStruct( rbLine,	rLineRB );
//STRIP001 
//STRIP001 	if ( dLine.nLeft > 0 )
//STRIP001 	{
//STRIP001         Color oldColor = aVD.GetLineColor();
//STRIP001         aVD.SetLineColor( rLineD.GetColor() );
//STRIP001 
//STRIP001 		USHORT	nHeight  = dLine.nLeft + dLine.nMiddle + dLine.nRight;
//STRIP001 		Point	from2	 = from;
//STRIP001 		Point	to2 	 = to;
//STRIP001 
//STRIP001 		lcl_SwLinkLine( dLine,
//STRIP001 					ltLine, lLine, lbLine,
//STRIP001 					rtLine, rLine, rbLine,
//STRIP001 					dxArr );
//STRIP001 
//STRIP001 		if ( bHorizontal )
//STRIP001 		{
//STRIP001 			from.Y() -= nHeight/2;
//STRIP001 			to.Y()	 -= nHeight/2;
//STRIP001 			to.Y()	 += (dLine.nLeft-1);
//STRIP001 
//STRIP001 			from.X() += dxArr[0];
//STRIP001 			to.X()	 += dxArr[2];
//STRIP001 
//STRIP001             lcl_DrawHorizontalLine( aVD, from, to );
//STRIP001 
//STRIP001 			// noch eine zweite Linie zu malen?
//STRIP001 			if ( dLine.nRight != 0 )
//STRIP001 			{
//STRIP001 				from2.Y() -= nHeight/2;
//STRIP001 				from2.Y() += dLine.nLeft+dLine.nMiddle;
//STRIP001 				to2.Y()   -= nHeight/2;
//STRIP001 				to2.Y()   += dLine.nMiddle+dLine.nLeft;
//STRIP001 				to2.Y()   += (dLine.nRight-1);
//STRIP001 
//STRIP001 				from2.X() += dxArr[1];
//STRIP001 				to2.X()   += dxArr[3];
//STRIP001 
//STRIP001                 lcl_DrawHorizontalLine( aVD, from2, to2 );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			from.X() += nHeight/2;
//STRIP001 			from.X() -= (dLine.nLeft-1);
//STRIP001 			to.X()	 += nHeight/2;
//STRIP001 
//STRIP001 			from.Y() += dxArr[0];
//STRIP001 			to.Y()	 += dxArr[2];
//STRIP001 
//STRIP001             lcl_DrawVerticalLine( aVD, from, to );
//STRIP001 
//STRIP001 			// noch eine zweite Linie zu malen?
//STRIP001 			if ( dLine.nRight != 0 )
//STRIP001 			{
//STRIP001 				from2.X() -= nHeight/2;
//STRIP001 				to2.X()   -= nHeight/2;
//STRIP001 				to2.X()   += (dLine.nRight-1);
//STRIP001 
//STRIP001 				from2.Y() += dxArr[1];
//STRIP001 				to2.Y()   += dxArr[3];
//STRIP001 
//STRIP001                 lcl_DrawVerticalLine( aVD, from2, to2 );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		aVD.SetLineColor( oldColor );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void AutoFmtPreview::DrawFrame( BYTE nIndex )
//STRIP001 {
//STRIP001 	//----------------------
//STRIP001 	// Malen des Zellrahmens
//STRIP001 	//----------------------
//STRIP001 
//STRIP001 	SvxBorderLine	aLineD;
//STRIP001 	SvxBorderLine	aLineLT;
//STRIP001 	SvxBorderLine	aLineL;
//STRIP001 	SvxBorderLine	aLineLB;
//STRIP001 	SvxBorderLine	aLineRT;
//STRIP001 	SvxBorderLine	aLineR;
//STRIP001 	SvxBorderLine	aLineRB;
//STRIP001 	Rectangle&		cellRect = aCellArray[nIndex];
//STRIP001 
//STRIP001 	//---------
//STRIP001 	// TopLine ---------------------------------------------
//STRIP001 	//---------
//STRIP001 	GetLines( nIndex, TOP_LINE, aLineD,
//STRIP001 				aLineLT, aLineL, aLineLB,
//STRIP001 				aLineRT, aLineR, aLineRB );
//STRIP001 
//STRIP001 	DrawFrameLine( aLineD,
//STRIP001 					cellRect.TopLeft(), cellRect.TopRight(), TRUE,
//STRIP001 					aLineLT,  aLineL, aLineLB,
//STRIP001 					aLineRT,  aLineR, aLineRB );
//STRIP001 
//STRIP001 	//------------
//STRIP001 	// BottomLine ------------------------------------------
//STRIP001 	//------------
//STRIP001 	GetLines( nIndex, BOTTOM_LINE, aLineD,
//STRIP001 				aLineLT, aLineL, aLineLB,
//STRIP001 				aLineRT, aLineR, aLineRB );
//STRIP001 
//STRIP001 	DrawFrameLine( aLineD,
//STRIP001 					cellRect.BottomLeft(), cellRect.BottomRight(), TRUE,
//STRIP001 					aLineLT,  aLineL, aLineLB,
//STRIP001 					aLineRT,  aLineR, aLineRB );
//STRIP001 
//STRIP001 	//----------
//STRIP001 	// LeftLine --------------------------------------------
//STRIP001 	//----------
//STRIP001 	GetLines( nIndex, LEFT_LINE, aLineD,
//STRIP001 				aLineLT, aLineL, aLineLB,
//STRIP001 				aLineRT, aLineR, aLineRB );
//STRIP001 
//STRIP001 	DrawFrameLine( aLineD,
//STRIP001 					cellRect.TopLeft(), cellRect.BottomLeft(), FALSE,
//STRIP001 					aLineLT,  aLineL, aLineLB,
//STRIP001 					aLineRT,  aLineR, aLineRB );
//STRIP001 
//STRIP001 	//-----------
//STRIP001 	// RightLine -------------------------------------------
//STRIP001 	//-----------
//STRIP001 	GetLines( nIndex, RIGHT_LINE, aLineD,
//STRIP001 				aLineLT, aLineL, aLineLB,
//STRIP001 				aLineRT, aLineR, aLineRB );
//STRIP001 
//STRIP001 	DrawFrameLine( aLineD,
//STRIP001 					cellRect.TopRight(), cellRect.BottomRight(), FALSE,
//STRIP001 					aLineLT,  aLineL, aLineLB,
//STRIP001 					aLineRT,  aLineR, aLineRB );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void lcl_SetFontProperties(
//STRIP001         Font& rFont,
//STRIP001         const SvxFontItem& rFontItem,
//STRIP001         const SvxWeightItem& rWeightItem,
//STRIP001         const SvxPostureItem& rPostureItem )
//STRIP001 {
//STRIP001     rFont.SetFamily     ( rFontItem.GetFamily() );
//STRIP001     rFont.SetName       ( rFontItem.GetFamilyName() );
//STRIP001     rFont.SetStyleName  ( rFontItem.GetStyleName() );
//STRIP001     rFont.SetCharSet    ( rFontItem.GetCharSet() );
//STRIP001     rFont.SetPitch      ( rFontItem.GetPitch() );
//STRIP001     rFont.SetWeight     ( (FontWeight)rWeightItem.GetValue() );
//STRIP001     rFont.SetItalic     ( (FontItalic)rPostureItem.GetValue() );
//STRIP001 }
//STRIP001 
//STRIP001 #define SETONALLFONTS( MethodName, Value )                  \
//STRIP001 rFont.MethodName( Value );                                  \
//STRIP001 rCJKFont.MethodName( Value );                               \
//STRIP001 rCTLFont.MethodName( Value );
//STRIP001 
//STRIP001 void AutoFmtPreview::MakeFonts( BYTE nIndex, Font& rFont, Font& rCJKFont, Font& rCTLFont )
//STRIP001 {
//STRIP001 	const SwBoxAutoFmt& rBoxFmt = aCurData.GetBoxFmt( nIndex );
//STRIP001 
//STRIP001     rFont = rCJKFont = rCTLFont = GetFont();
//STRIP001     Size aFontSize( rFont.GetSize().Width(), 10 );
//STRIP001 
//STRIP001     lcl_SetFontProperties( rFont, rBoxFmt.GetFont(), rBoxFmt.GetWeight(), rBoxFmt.GetPosture() );
//STRIP001     lcl_SetFontProperties( rCJKFont, rBoxFmt.GetCJKFont(), rBoxFmt.GetCJKWeight(), rBoxFmt.GetCJKPosture() );
//STRIP001     lcl_SetFontProperties( rCTLFont, rBoxFmt.GetCTLFont(), rBoxFmt.GetCTLWeight(), rBoxFmt.GetCTLPosture() );
//STRIP001 
//STRIP001     SETONALLFONTS( SetUnderline,    (FontUnderline)rBoxFmt.GetUnderline().GetValue() );
//STRIP001     SETONALLFONTS( SetStrikeout,    (FontStrikeout)rBoxFmt.GetCrossedOut().GetValue() );
//STRIP001     SETONALLFONTS( SetOutline,      rBoxFmt.GetContour().GetValue() );
//STRIP001     SETONALLFONTS( SetShadow,       rBoxFmt.GetShadowed().GetValue() );
//STRIP001     SETONALLFONTS( SetColor,        rBoxFmt.GetColor().GetValue() );
//STRIP001     SETONALLFONTS( SetSize,         aFontSize );
//STRIP001     SETONALLFONTS( SetTransparent,  TRUE );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void AutoFmtPreview::DrawString( BYTE nIndex )
//STRIP001 {
//STRIP001 	//------------------------
//STRIP001 	// Ausgabe des Zelltextes:
//STRIP001 	//------------------------
//STRIP001 	ULONG   nNum;
//STRIP001 	double  nVal;
//STRIP001 	String cellString;
//STRIP001 	switch( nIndex )
//STRIP001 	{
//STRIP001 		case  1: cellString = aStrJan;			break;
//STRIP001 		case  2: cellString = aStrFeb;			break;
//STRIP001 		case  3: cellString = aStrMar;			break;
//STRIP001 		case  5: cellString = aStrNorth;		break;
//STRIP001 		case 10: cellString = aStrMid;			break;
//STRIP001 		case 15: cellString = aStrSouth;		break;
//STRIP001 		case  4:
//STRIP001 		case 20: cellString = aStrSum;			break;
//STRIP001 
//STRIP001 		case  6:
//STRIP001 		case  8:
//STRIP001 		case 16:
//STRIP001 		case 18:    nVal = nIndex;
//STRIP001 					nNum = 5;
//STRIP001 					goto MAKENUMSTR;
//STRIP001 		case 17:
//STRIP001 		case  7: 	nVal = nIndex;
//STRIP001 					nNum = 6;
//STRIP001 					goto MAKENUMSTR;
//STRIP001 		case 11:
//STRIP001 		case 12:
//STRIP001 		case 13: 	nVal = nIndex;
//STRIP001 					nNum = 12 == nIndex ? 10 : 9;
//STRIP001 					goto MAKENUMSTR;
//STRIP001 
//STRIP001 		case  9:	nVal = 21; nNum = 7; 	goto MAKENUMSTR;
//STRIP001 		case 14:	nVal = 36; nNum = 11; 	goto MAKENUMSTR;
//STRIP001 		case 19:	nVal = 51; nNum = 7;	goto MAKENUMSTR;
//STRIP001 		case 21:	nVal = 33; nNum = 13;	goto MAKENUMSTR;
//STRIP001 		case 22:	nVal = 36; nNum = 14;	goto MAKENUMSTR;
//STRIP001 		case 23:	nVal = 39; nNum = 13;	goto MAKENUMSTR;
//STRIP001 		case 24:	nVal = 108; nNum = 15;	goto MAKENUMSTR;
//STRIP001 MAKENUMSTR:
//STRIP001 			if( aCurData.IsValueFormat() )
//STRIP001 			{
//STRIP001 				String sFmt; LanguageType eLng, eSys;
//STRIP001 				aCurData.GetBoxFmt( (BYTE)nNum ).GetValueFormat( sFmt, eLng, eSys );
//STRIP001 
//STRIP001 				ULONG nKey = 0;
//STRIP001 				if ( eLng == LANGUAGE_SYSTEM && eSys != ::GetAppLanguage() )
//STRIP001 				{
//STRIP001 					//	#53381# wenn System beim Speichern etwas anderes war,
//STRIP001 					//	muss konvertiert werden (geht nur mit eingebauten Formaten)
//STRIP001 					ULONG nOrig = pNumFmt->GetEntryKey( sFmt, eSys );
//STRIP001 					if ( nOrig != NUMBERFORMAT_ENTRY_NOT_FOUND )
//STRIP001 						nKey = pNumFmt->GetFormatForLanguageIfBuiltIn( nOrig,
//STRIP001 														::GetAppLanguage() );
//STRIP001 				}
//STRIP001 				else	// sonst einfach suchen oder anlegen
//STRIP001 				{
//STRIP001 					nKey = pNumFmt->GetEntryKey( sFmt, eLng );
//STRIP001 					if( NUMBERFORMAT_ENTRY_NOT_FOUND == nKey )
//STRIP001 					{
//STRIP001 						xub_StrLen nCheckPos;
//STRIP001 						short nType;
//STRIP001 						pNumFmt->PutEntry( sFmt, nCheckPos, nType, nKey, eLng );
//STRIP001 					}
//STRIP001 				}
//STRIP001 				Color* pDummy;
//STRIP001 				pNumFmt->GetOutputString( nVal, nKey, cellString, &pDummy );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				cellString = String::CreateFromInt32(nVal);
//STRIP001 			break;
//STRIP001 
//STRIP001 	}
//STRIP001 
//STRIP001 	if( cellString.Len() )
//STRIP001 	{
//STRIP001 		Size				aStrSize;
//STRIP001 		BYTE			  	nFmtIndex		= (BYTE) aFmtMap[nIndex];
//STRIP001 		Rectangle&			cellRect		= aCellArray[nIndex];
//STRIP001 		Point				aPos			= aCellArray[nIndex].TopLeft();
//STRIP001 		USHORT				nRightX 		= 0;
//STRIP001 //			  BOOL				  bJustify		  = aCurData.IsJustify();
//STRIP001 //			  ScHorJustifyAttr	  aHorJustifyItem;
//STRIP001 //			CellHorJustify	  eJustification;
//STRIP001 
//STRIP001 		Size theMaxStrSize( cellRect.GetWidth() - FRAME_OFFSET,
//STRIP001 							cellRect.GetHeight() - FRAME_OFFSET );
//STRIP001 		if( aCurData.IsFont() )
//STRIP001 		{
//STRIP001             Font aFont, aCJKFont, aCTLFont;
//STRIP001             MakeFonts( nFmtIndex, aFont, aCJKFont, aCTLFont );
//STRIP001             aScriptedText.SetFonts( &aFont, &aCJKFont, &aCTLFont );
//STRIP001 		}
//STRIP001         else
//STRIP001             aScriptedText.SetDefaultFont();
//STRIP001 
//STRIP001         aScriptedText.SetText( cellString, pBreakIt->xBreak );
//STRIP001         aStrSize = aScriptedText.GetTextSize();
//STRIP001 
//STRIP001 		if( aCurData.IsFont() &&
//STRIP001 			theMaxStrSize.Height() < aStrSize.Height() )
//STRIP001 		{
//STRIP001 				// wenn der String in diesem Font nicht
//STRIP001 				// in die Zelle passt, wird wieder der
//STRIP001 				// Standard-Font genommen:
//STRIP001                 aScriptedText.SetDefaultFont();
//STRIP001                 aStrSize = aScriptedText.GetTextSize();
//STRIP001 		}
//STRIP001 
//STRIP001 		while( theMaxStrSize.Width() <= aStrSize.Width() &&
//STRIP001 				cellString.Len() > 1 )
//STRIP001 		{
//STRIP001 //					if( eJustification == SVX_HOR_JUSTIFY_RIGHT )
//STRIP001 //  						cellString.Erase( 0, 1 );
//STRIP001 //					else
//STRIP001 			cellString.Erase( cellString.Len() - 1 );
//STRIP001             aScriptedText.SetText( cellString, pBreakIt->xBreak );
//STRIP001             aStrSize = aScriptedText.GetTextSize();
//STRIP001 		}
//STRIP001 
//STRIP001 		nRightX  = (USHORT)(  cellRect.GetWidth()
//STRIP001 								- aStrSize.Width()
//STRIP001 								- FRAME_OFFSET );
//STRIP001 		//-------------
//STRIP001 		// Ausrichtung:
//STRIP001 		//-------------
//STRIP001 		/*   if ( bJustify )
//STRIP001 		{
//STRIP001 			aCurData.GetHorJustify( nFmtIndex, aHorJustifyItem );
//STRIP001 			eJustification = (CellHorJustify)aHorJustifyItem.GetValue();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			eJustification = SC_HOR_JUSTIFY_STANDARD;
//STRIP001 		}*/
//STRIP001 
//STRIP001 		//-----------------------------
//STRIP001 		// vertikal (immer zentrieren):
//STRIP001 		//-----------------------------
//STRIP001 		aPos.Y() += (nRowHeight - (USHORT)aStrSize.Height()) / 2;
//STRIP001 
//STRIP001 		//-----------
//STRIP001 		// horizontal
//STRIP001 		//-----------
//STRIP001 /* 		  if ( eJustification != SC_HOR_JUSTIFY_STANDARD )*/
//STRIP001 		if (aCurData.IsJustify())
//STRIP001 		{
//STRIP001 			USHORT nHorPos = (USHORT)
//STRIP001 					((cellRect.GetWidth()-aStrSize.Width())/2);
//STRIP001 			const SvxAdjustItem& rAdj = aCurData.GetBoxFmt(nFmtIndex).GetAdjust();
//STRIP001 			switch ( rAdj.GetAdjust() )
//STRIP001 			{
//STRIP001 				case SVX_ADJUST_LEFT:
//STRIP001 					aPos.X() += FRAME_OFFSET;
//STRIP001 					break;
//STRIP001 				case SVX_ADJUST_RIGHT:
//STRIP001 					aPos.X() += nRightX;
//STRIP001 					break;
//STRIP001 				default:
//STRIP001 					aPos.X() += nHorPos;
//STRIP001 					break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			//---------------------
//STRIP001 			// Standardausrichtung:
//STRIP001 			//---------------------
//STRIP001 			if ( ((nIndex%5) == 0) || (nIndex == 4) )
//STRIP001 			{
//STRIP001 				// Text-Label links oder Summe linksbuendig
//STRIP001 				aPos.X() += FRAME_OFFSET;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 					// Zahlen/Datum rechtsbuendig
//STRIP001 				aPos.X() += nRightX;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		//-------------------------------
//STRIP001         aScriptedText.DrawText( aPos );
//STRIP001 		//-------------------------------
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 #undef FRAME_OFFSET
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 
//STRIP001 void AutoFmtPreview::DrawBackground( BYTE nIndex )
//STRIP001 {
//STRIP001 	SvxBrushItem aBrushItem( aCurData.GetBoxFmt( aFmtMap[nIndex])
//STRIP001 								.GetBackground() );
//STRIP001 	Color 	oldColor	 = aVD.GetLineColor();
//STRIP001 	aVD.SetLineColor( Color(COL_TRANSPARENT) );
//STRIP001 	Color oldFillColor = aVD.GetFillColor();
//STRIP001 	aVD.SetFillColor( aBrushItem.GetColor() );
//STRIP001 	//-----------------------
//STRIP001 	aVD.DrawRect( aCellArray[nIndex] );
//STRIP001 	//-----------------------
//STRIP001 	aVD.SetLineColor( oldColor );
//STRIP001 	aVD.SetFillColor( oldFillColor );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 
//STRIP001 void AutoFmtPreview::PaintCells()
//STRIP001 {
//STRIP001 	BYTE i = 0;
//STRIP001 
//STRIP001 	//---------------
//STRIP001 	// 1. Hintergrund
//STRIP001 	//---------------
//STRIP001 	if ( aCurData.IsBackground() )
//STRIP001 	{
//STRIP001 		for ( i=0; i<=24; i++ )
//STRIP001 		{
//STRIP001 			DrawBackground( i );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//----------
//STRIP001 	// 2. Rahmen
//STRIP001 	//----------
//STRIP001 	if ( aCurData.IsFrame() )
//STRIP001 	{
//STRIP001 		for ( i=0; i<=24; i++ )
//STRIP001 		{
//STRIP001 			DrawFrame( i );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//---------
//STRIP001 	// 3. Werte
//STRIP001 	//---------
//STRIP001 	for ( i = 0; i<=24; i++ )
//STRIP001 	{
//STRIP001 		DrawString( i );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 
//STRIP001 void __EXPORT AutoFmtPreview::Init()
//STRIP001 {
//STRIP001     SetBorderStyle( GetBorderStyle() | WINDOW_BORDER_MONO );
//STRIP001 
//STRIP001 	SvxBoxItem aEmptyBoxItem;
//STRIP001 
//STRIP001 	aEmptyBoxItem.SetLine	 ( NULL, BOX_LINE_TOP );
//STRIP001 	aEmptyBoxItem.SetLine	 ( NULL, BOX_LINE_BOTTOM );
//STRIP001 	aEmptyBoxItem.SetLine	 ( NULL, BOX_LINE_LEFT );
//STRIP001 	aEmptyBoxItem.SetLine	 ( NULL, BOX_LINE_RIGHT );
//STRIP001 	aEmptyBoxItem.SetDistance( 0 );
//STRIP001 
//STRIP001 	//------------------------
//STRIP001 	// Linienattribut-Feld mit
//STRIP001 	// Null-BoxItems fuellen
//STRIP001 	//------------------------
//STRIP001 	for ( USHORT i=0; i<=48; i++ )
//STRIP001 	{
//STRIP001 		aLinePtrArray[i] = new SvxBoxItem( aEmptyBoxItem );
//STRIP001 	}
//STRIP001 
//STRIP001 	CalcCellArray( FALSE );
//STRIP001 	CalcLineMap();
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 
//STRIP001 void AutoFmtPreview::CalcCellArray( BOOL bFitWidth )
//STRIP001 {
//STRIP001 	// Initialisieren des Zellfeldes (5x5 Zellen).
//STRIP001 	// Rectangles enthalten Position und Groesse einer Zelle.
//STRIP001 	// abhaengig, ob Zellbreite an Format angepasst werden soll (bFitWidth)
//STRIP001 	USHORT	nRow;
//STRIP001 	USHORT	nDataColWidth = (bFitWidth) ? nDataColWidth2 : nDataColWidth1;
//STRIP001 
//STRIP001 	for ( nRow=0; nRow<=4; nRow++ )
//STRIP001 	{
//STRIP001 		Point	topLeftPos ( 2, (nRowHeight * nRow) + 2 );
//STRIP001 		Size	rectSize   ( 0, nRowHeight );
//STRIP001 		USHORT	nCell;
//STRIP001 		USHORT	nFirst = nRow*5;
//STRIP001 		USHORT	nLast  = nFirst+4;
//STRIP001 
//STRIP001 		for ( nCell=nFirst; nCell<=nLast; nCell++ )
//STRIP001 		{
//STRIP001 			//--------------------
//STRIP001 			// Position berechnen:
//STRIP001 			//--------------------
//STRIP001 			if ( nCell == 0 )
//STRIP001 			{
//STRIP001 				// erste Zelle benoetigt keine Sonderbehandlung
//STRIP001 			}
//STRIP001 			else if ( (nCell <= 4) && (nCell != 0) )
//STRIP001 			{
//STRIP001 				// Zelle aus der ersten Zeile
//STRIP001 				topLeftPos = aCellArray[nCell-1].TopRight();
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				topLeftPos = aCellArray[nCell-5].BottomLeft();
//STRIP001 			}
//STRIP001 
//STRIP001 			//-------------------
//STRIP001 			// Groesse berechnen:
//STRIP001 			//-------------------
//STRIP001 			if ( (nCell == nFirst) || (nCell == nLast) )
//STRIP001 				rectSize.Width() = nLabelColWidth;
//STRIP001 			else
//STRIP001 				rectSize.Width() = nDataColWidth;
//STRIP001 
//STRIP001 			aCellArray[nCell] = Rectangle( topLeftPos, rectSize );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	aPrvSize.Width()  = aCellArray[24].BottomRight().X() + 3;
//STRIP001 	aPrvSize.Height() = aCellArray[24].BottomRight().Y() + 3;
//STRIP001 
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 
//STRIP001 void AutoFmtPreview::CalcLineMap()
//STRIP001 {
//STRIP001 	//----------------------------------------------------
//STRIP001 	// Initialisieren des Linenattributfeldes (7x7 Zellen)
//STRIP001 	// Ein Eintrag dieses Feldes enthaelt einen Verweis
//STRIP001 	// auf die Linienattribute des zugehoerigen Feldes.
//STRIP001 	// Dieses Feld "umschliesst" das Zellfeld mit einer
//STRIP001 	// Reihe "leerer" Zellen.
//STRIP001 	//----------------------------------------------------
//STRIP001 
//STRIP001 	SvxBoxItem aFrameItem;
//STRIP001 	BYTE nRow;
//STRIP001 
//STRIP001 	for ( nRow=0; nRow<=4; nRow++ )
//STRIP001 	{
//STRIP001 		USHORT	nLine;
//STRIP001 		BYTE  nCell;
//STRIP001 		BYTE  nFirst = (nRow * 5);
//STRIP001 		BYTE  nLast  = nFirst+4;
//STRIP001 
//STRIP001 		for ( nCell=nFirst; nCell<=nLast; nCell++ )
//STRIP001 		{
//STRIP001 			nLine = nCell + 8 + ((nCell/5)*2);
//STRIP001 				aFrameItem = aCurData.GetBoxFmt( aFmtMap[nCell]).GetBox();
//STRIP001 			*(aLinePtrArray[nLine]) = aFrameItem;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 
//STRIP001 void AutoFmtPreview::NotifyChange( const SwTableAutoFmt& rNewData )
//STRIP001 {
//STRIP001 	aCurData  = rNewData;
//STRIP001 	bFitWidth = aCurData.IsJustify();//TRUE;  //???
//STRIP001 	CalcCellArray( bFitWidth );
//STRIP001 	CalcLineMap();
//STRIP001 	DoPaint( Rectangle( Point(0,0), GetSizePixel() ) );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 
//STRIP001 void AutoFmtPreview::DoPaint( const Rectangle& rRect )
//STRIP001 {
//STRIP001     sal_uInt32 nOldDrawMode = aVD.GetDrawMode();
//STRIP001     if( GetSettings().GetStyleSettings().GetHighContrastMode() &&
//STRIP001             SW_MOD()->GetAccessibilityOptions().GetIsForBorders() )
//STRIP001         aVD.SetDrawMode( DRAWMODE_SETTINGSLINE | DRAWMODE_SETTINGSFILL | DRAWMODE_SETTINGSTEXT | DRAWMODE_SETTINGSGRADIENT );
//STRIP001 
//STRIP001 	Bitmap	thePreview;
//STRIP001 	Point	aCenterPos;
//STRIP001 	Size	theWndSize = GetSizePixel();
//STRIP001 	Size	thePrevSize;
//STRIP001 	Color 	oldColor;
//STRIP001 	Font	aFont;
//STRIP001 
//STRIP001 	aFont = aVD.GetFont();
//STRIP001 	aFont.SetTransparent( TRUE );
//STRIP001 
//STRIP001 	aVD.SetFont 		 ( aFont );
//STRIP001     aVD.SetLineColor     ();
//STRIP001     const Color& rWinColor = GetSettings().GetStyleSettings().GetWindowColor();
//STRIP001     aVD.SetBackground    ( Wallpaper(rWinColor) );
//STRIP001     aVD.SetFillColor     ( rWinColor );
//STRIP001 	aVD.SetOutputSizePixel	( aPrvSize );
//STRIP001 
//STRIP001 	//--------------------------------
//STRIP001 	// Zellen auf virtual Device malen
//STRIP001 	// und Ergebnis sichern
//STRIP001 	//--------------------------------
//STRIP001 	PaintCells();
//STRIP001 	thePreview = aVD.GetBitmap( Point(0,0), aPrvSize );
//STRIP001 
//STRIP001 	//--------------------------------------
//STRIP001 	// Rahmen malen und Vorschau zentrieren:
//STRIP001 	// (virtual Device fuer Fensterausgabe)
//STRIP001 	//--------------------------------------
//STRIP001 	aVD.SetOutputSizePixel( theWndSize );
//STRIP001 	oldColor = aVD.GetLineColor();
//STRIP001     aVD.SetLineColor();
//STRIP001 	aVD.DrawRect( Rectangle( Point(0,0), theWndSize ) );
//STRIP001 	SetLineColor( oldColor );
//STRIP001 	aCenterPos	= Point( (theWndSize.Width()  - aPrvSize.Width() ) / 2,
//STRIP001 						 (theWndSize.Height() - aPrvSize.Height()) / 2 );
//STRIP001 	aVD.DrawBitmap( aCenterPos, thePreview );
//STRIP001 
//STRIP001 	//----------------------------
//STRIP001 	// Ausgabe im Vorschaufenster:
//STRIP001 	//----------------------------
//STRIP001 	DrawBitmap( Point(0,0), aVD.GetBitmap( Point(0,0), theWndSize ) );
//STRIP001 
//STRIP001     aVD.SetDrawMode( nOldDrawMode );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void __EXPORT AutoFmtPreview::Paint( const Rectangle& rRect )
//STRIP001 {
//STRIP001 	DoPaint( rRect );
//STRIP001 }
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 
//STRIP001 BOOL lcl_HasPriority(	const SvxBorderLine* pThis,
//STRIP001 						const SvxBorderLine* pOther )
//STRIP001 {
//STRIP001 
//STRIP001 	if (!pThis)
//STRIP001 		return FALSE;
//STRIP001 	if (!pOther)
//STRIP001 		return TRUE;
//STRIP001 
//STRIP001 	USHORT nThisSize = pThis->GetOutWidth() + pThis->GetDistance() + pThis->GetInWidth();
//STRIP001 	USHORT nOtherSize = pOther->GetOutWidth() + pOther->GetDistance() + pOther->GetInWidth();
//STRIP001 
//STRIP001 	if (nThisSize > nOtherSize)
//STRIP001 		return TRUE;
//STRIP001 	else if (nThisSize < nOtherSize)
//STRIP001 		return FALSE;
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if ( pOther->GetInWidth() && !pThis->GetInWidth() )
//STRIP001 			return TRUE;
//STRIP001 		else if ( pThis->GetInWidth() && !pOther->GetInWidth() )
//STRIP001 			return FALSE;
//STRIP001 		else
//STRIP001 		{
//STRIP001 			return TRUE;			//! ???
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void lcl_SwLinkLine(const SwLineStruct& dLine,
//STRIP001 					const SwLineStruct& ltLine,
//STRIP001 					const SwLineStruct& lLine,
//STRIP001 					const SwLineStruct& lbLine,
//STRIP001 					const SwLineStruct& rtLine,
//STRIP001 					const SwLineStruct& rLine,
//STRIP001 					const SwLineStruct& rbLine,
//STRIP001 					short* dxArr)
//STRIP001 {
//STRIP001 	short nDx;
//STRIP001 	short nDxDx;
//STRIP001 	short nltW = ltLine.nLeft + ltLine.nMiddle + ltLine.nRight;
//STRIP001 	short nlbW = lbLine.nLeft + lbLine.nMiddle + lbLine.nRight;
//STRIP001 	short nrtW = rtLine.nLeft + rtLine.nMiddle + rtLine.nRight;
//STRIP001 	short nrbW = rbLine.nLeft + rbLine.nMiddle + rbLine.nRight;
//STRIP001 	if (dLine.nRight == 0) // einfache Linie
//STRIP001 	{
//STRIP001 		dxArr[1] = 0;
//STRIP001 		dxArr[3] = 0;
//STRIP001 
//STRIP001 		// Linker Teil
//STRIP001 		if ((lLine.nLeft != 0) && (lLine.nRight == 0)) // links einfache Linie
//STRIP001 			dxArr[0] = 0;
//STRIP001 		else
//STRIP001 		{
//STRIP001 			nDx = Max(nltW, nlbW) / 2;
//STRIP001 			nDxDx = (Max(nltW, nlbW) + 1) % 2;
//STRIP001 			if ((nDx == 0) || (ltLine.nRight == 0) || (lbLine.nRight == 0))
//STRIP001 			{
//STRIP001 				if (lLine.nLeft == 0)
//STRIP001 					dxArr[0] = nDxDx - nDx;
//STRIP001 				else
//STRIP001 					dxArr[0] = nDxDx + nDx;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				dxArr[0] = nDxDx + nDx;
//STRIP001 		}
//STRIP001 
//STRIP001 		// Rechter Teil
//STRIP001 		if ((rLine.nLeft != 0) && (rLine.nRight == 0)) // rechts keine Linie
//STRIP001 			dxArr[2] = 0;
//STRIP001 		else
//STRIP001 		{
//STRIP001 			nDx = Max(nrtW, nrbW) / 2;
//STRIP001 			if ((nDx == 0) || (rtLine.nRight == 0) || (rbLine.nRight == 0))
//STRIP001 			{
//STRIP001 				if (rLine.nLeft == 0)
//STRIP001 					dxArr[2] = nDx;
//STRIP001 				else
//STRIP001 					dxArr[2] = -nDx;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				dxArr[2] = -nDx;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// Linker oberer Teil
//STRIP001 		if ((nltW == 0) || (ltLine.nRight == 0)) // Links oben keine oder einfache Linie
//STRIP001 		{
//STRIP001 			nDx = (nlbW + 1) / 2;
//STRIP001 			nDxDx = (nlbW + 1) % 2;
//STRIP001 			if (nDx == 0)
//STRIP001 				dxArr[0] = nDxDx + nDx;
//STRIP001 			else
//STRIP001 				dxArr[0] = nDxDx - (nlbW / 2) + ltLine.nLeft;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			nDx = (nltW + 1) / 2;
//STRIP001 			nDxDx = (nltW + 1) % 2;
//STRIP001 			if (nDx == 0)
//STRIP001 				dxArr[0] = nDxDx - nDx;
//STRIP001 			else
//STRIP001 				dxArr[0] = nDxDx + nDx - ltLine.nRight;
//STRIP001 		}
//STRIP001 		// Linker unterer Teil
//STRIP001 		if ((nlbW == 0) || (lbLine.nRight == 0)) // Links unten keine oder einfache Linie
//STRIP001 		{
//STRIP001 			nDx = (nltW + 1) / 2;
//STRIP001 			nDxDx = (nltW + 1) % 2;
//STRIP001 			if (nDx == 0)
//STRIP001 				dxArr[1] = nDxDx + nDx;
//STRIP001 			else
//STRIP001 				dxArr[1] = nDxDx - (nltW / 2) + lbLine.nLeft;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			nDx = (nlbW + 1) / 2;
//STRIP001 			nDxDx = (nlbW + 1) % 2;
//STRIP001 			if (nDx == 0)
//STRIP001 				dxArr[1] = nDxDx - nDx;
//STRIP001 			else
//STRIP001 				dxArr[1] = nDxDx + nDx - lbLine.nRight;
//STRIP001 		}
//STRIP001 
//STRIP001 		// Rechter oberer Teil
//STRIP001 		if ((nrtW == 0) || (rtLine.nRight == 0)) // Rechts oben keine oder einfache Linie
//STRIP001 		{
//STRIP001 			nDx = (nrbW + 1) / 2;
//STRIP001 			if (nDx == 0)
//STRIP001 				dxArr[2] = -nDx;
//STRIP001 			else
//STRIP001 				dxArr[2] = (nrbW / 2) - rtLine.nLeft;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			nDx = (nrtW + 1) / 2;
//STRIP001 			if (nDx == 0)
//STRIP001 				dxArr[2] = nDx;
//STRIP001 			else
//STRIP001 				dxArr[2] = -nDx + rtLine.nLeft;
//STRIP001 		}
//STRIP001 		// Rechter unterer Teil
//STRIP001 		if ((nrbW == 0) || (rbLine.nRight == 0)) // Rechts unten keine oder einfache Linie
//STRIP001 		{
//STRIP001 			nDx = (nrtW + 1) / 2;
//STRIP001 			if (nDx == 0)
//STRIP001 				dxArr[3] = -nDx;
//STRIP001 			else
//STRIP001 				dxArr[3] = (nrtW / 2) - rbLine.nLeft;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			nDx = (nrbW + 1) / 2;
//STRIP001 			if (nDx == 0)
//STRIP001 				dxArr[3] = nDx;
//STRIP001 			else
//STRIP001 				dxArr[3] = -nDx + rbLine.nLeft;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }


}
