/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_viewport.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 06:51:44 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

#include "hintids.hxx"

// auto strip #ifndef _SV_HELP_HXX //autogen
// auto strip #include <vcl/help.hxx>
// auto strip #endif

// auto strip #ifndef _SVX_RULER_HXX //autogen
// auto strip #include <bf_svx/ruler.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_PAPERINF_HXX //autogen
// auto strip #include <bf_svx/paperinf.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_LRSPITEM_HXX //autogen
// auto strip #include <bf_svx/lrspitem.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_BINDINGS_HXX //autogen
// auto strip #include <bf_sfx2/bindings.hxx>
// auto strip #endif
// auto strip #ifndef _SFXSTBMGR_HXX //autogen
// auto strip #include <bf_sfx2/stbmgr.hxx>
// auto strip #endif
// auto strip #ifndef _SFXAPP_HXX //autogen
// auto strip #include <bf_sfx2/app.hxx>
// auto strip #endif

// auto strip #ifndef _VIEW_HXX
// auto strip #include <view.hxx>
// auto strip #endif

#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif

// auto strip #ifndef _WRTSH_HXX
// auto strip #include <wrtsh.hxx>
// auto strip #endif
// auto strip #ifndef _SWMODULE_HXX
// auto strip #include <swmodule.hxx>
// auto strip #endif
// auto strip #ifndef _VIEWOPT_HXX
// auto strip #include <viewopt.hxx>
// auto strip #endif
// auto strip #ifndef _FRMATR_HXX
// auto strip #include <frmatr.hxx>
// auto strip #endif
// auto strip #ifndef _DOCSH_HXX
// auto strip #include <docsh.hxx>
// auto strip #endif
#ifndef _CMDID_H
#include <cmdid.h>
#endif
// auto strip #ifndef _EDTWIN_HXX
// auto strip #include <edtwin.hxx>
// auto strip #endif
// auto strip #ifndef _SCROLL_HXX
// auto strip #include <scroll.hxx>
// auto strip #endif
#ifndef _WVIEW_HXX
#include <wview.hxx>
#endif
// auto strip #ifndef _USRPREF_HXX
// auto strip #include <usrpref.hxx>
// auto strip #endif
// auto strip #ifndef _PAGEDESC_HXX
// auto strip #include <pagedesc.hxx>
// auto strip #endif
// auto strip #ifndef _WORKCTRL_HXX
// auto strip #include <workctrl.hxx>
// auto strip #endif
// auto strip #ifndef _CRSSKIP_HXX
// auto strip #include <crsskip.hxx>
// auto strip #endif
namespace binfilter {
extern int bDocSzUpdated; //STRIP008
//Das SetVisArea der DocShell darf nicht vom InnerResizePixel gerufen werden.
//Unsere Einstellungen muessen aber stattfinden.
#ifndef WB_RIGHT_ALIGNED
#define WB_RIGHT_ALIGNED    ((WinBits)0x00008000)
#endif

static BOOL bProtectDocShellVisArea = FALSE;

static USHORT nPgNum = 0;

//STRIP001 inline BOOL SwView::IsDocumentBorder()
//STRIP001 {
//STRIP001     return GetDocShell()->GetProtocol().IsInPlaceActive() ||
//STRIP001 		   GetDocShell()->GetCreateMode() == SFX_CREATE_MODE_EMBEDDED ||
//STRIP001            pWrtShell->IsBrowseMode() ||
//STRIP001            SVX_ZOOM_PAGEWIDTH_NOBORDER == (SvxZoomType)pWrtShell->GetViewOptions()->GetZoomType();
//STRIP001 }
//STRIP001 inline long GetLeftMargin( SwView &rView )
//STRIP001 {
//STRIP001 	BOOL bWeb = 0 != PTR_CAST(SwWebView, &rView);
//STRIP001     SvxZoomType eType = (SvxZoomType)rView.GetWrtShell().GetViewOptions()->GetZoomType();
//STRIP001 	long lRet = rView.GetWrtShell().GetAnyCurRect(RECT_PAGE_PRT).Left();
//STRIP001 	return eType == SVX_ZOOM_PERCENT   ? lRet + DOCUMENTBORDER :
//STRIP001            eType == SVX_ZOOM_PAGEWIDTH || eType == SVX_ZOOM_PAGEWIDTH_NOBORDER ? 0 :
//STRIP001 										 lRet + DOCUMENTBORDER + nLeftOfst;
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 void lcl_GetPos(SwView* pView,
//STRIP001 				Point& rPos,
//STRIP001 				SwScrollbar* pScrollbar,
//STRIP001 				FASTBOOL bBorder)
//STRIP001 {
//STRIP001 	SwWrtShell &rSh = pView->GetWrtShell();
//STRIP001 	const Size aDocSz( rSh.GetDocSize() );
//STRIP001 
//STRIP001 	const long lBorder = bBorder ? DOCUMENTBORDER : DOCUMENTBORDER * 2;
//STRIP001 	BOOL bHori = pScrollbar->IsHoriScroll();
//STRIP001 
//STRIP001 	const long lPos = pScrollbar->GetThumbPos() + (bBorder ? DOCUMENTBORDER : 0);
//STRIP001 	long Point:: *pPt = bHori ? &Point::nA : &Point::nB;
//STRIP001 	long Size::  *pSz = bHori ? &Size::nA  : &Size::nB;
//STRIP001 
//STRIP001 	long lDelta = lPos - rSh.VisArea().Pos().*pPt;
//STRIP001 	const long lSize = aDocSz.*pSz + lBorder;
//STRIP001 	// Bug 11693: sollte rechts oder unten zuviel Wiese sein, dann muss
//STRIP001 	// 			  diese von der VisArea herausgerechnet werden!
//STRIP001 	long nTmp = pView->GetVisArea().Right()+lDelta;
//STRIP001 	if ( bHori && nTmp > lSize )
//STRIP001 		lDelta -= nTmp - lSize;
//STRIP001 	nTmp = pView->GetVisArea().Bottom()+lDelta;
//STRIP001 	if ( !bHori && nTmp > lSize )
//STRIP001 		lDelta -= nTmp - lSize;
//STRIP001 
//STRIP001 	rPos.*pPt += lDelta;
//STRIP001 	if ( bBorder && rPos.*pPt < DOCUMENTBORDER )
//STRIP001 		rPos.*pPt = DOCUMENTBORDER;
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:	Nullpunkt Lineal setzen
 --------------------------------------------------------------------*/

//STRIP001 void SwView::InvalidateRulerPos()
//STRIP001 {
//STRIP001 	static USHORT __READONLY_DATA aInval[] =
//STRIP001 	{
//STRIP001 		SID_ATTR_PARA_LRSPACE, SID_RULER_BORDERS, SID_RULER_PAGE_POS,
//STRIP001 		SID_RULER_LR_MIN_MAX, SID_ATTR_LONG_ULSPACE, SID_ATTR_LONG_LRSPACE,
//STRIP001         SID_ATTR_PARA_LRSPACE_VERTICAL, SID_RULER_BORDERS_VERTICAL,
//STRIP001         SID_RULER_TEXT_RIGHT_TO_LEFT, FN_STAT_PAGE, 0
//STRIP001 	};
//STRIP001 
//STRIP001 	GetViewFrame()->GetBindings().Invalidate(aInval);
//STRIP001 
//STRIP001     DBG_ASSERT(pHRuler, "warum ist das Lineal nicht da?")
//STRIP001     pHRuler->ForceUpdate();
//STRIP001     pVRuler->ForceUpdate();
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:	begrenzt das Scrollen soweit, dass jeweils nur einen
					viertel Bildschirm bis vor das Ende des Dokumentes
					gescrollt werden kann.
 --------------------------------------------------------------------*/

//STRIP001 long SwView::SetHScrollMax( long lMax )
//STRIP001 {
//STRIP001 	const long lBorder = IsDocumentBorder() ? DOCUMENTBORDER : DOCUMENTBORDER * 2;
//STRIP001 	const long lSize = GetDocSz().Width() + lBorder - aVisArea.GetWidth();
//STRIP001 
//STRIP001 	// bei negativen Werten ist das Dokument vollstaendig sichtbar;
//STRIP001 	// in diesem Fall kein Scrollen
//STRIP001 	return Max( Min( lMax, lSize ), 0L );
//STRIP001 }


//STRIP001 long SwView::SetVScrollMax( long lMax )
//STRIP001 {
//STRIP001 	const long lBorder = IsDocumentBorder() ? DOCUMENTBORDER : DOCUMENTBORDER * 2;
//STRIP001 	long lSize = GetDocSz().Height() + lBorder - aVisArea.GetHeight();
//STRIP001 	return Max( Min( lMax, lSize), 0L );		// siehe horz.
//STRIP001 }


//STRIP001 Point SwView::AlignToPixel(const Point &rPt) const
//STRIP001 {
//STRIP001 	return GetEditWin().PixelToLogic( GetEditWin().LogicToPixel( rPt ) );
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:	Dokumentgroesse hat sich geaendert
 --------------------------------------------------------------------*/

/*N*/ void SwView::DocSzChgd(const Size &rSz)
/*N*/ {
/*N*/ 
//STRIP008 /*N*/ extern int ::binfilter::bDocSzUpdated;
/*N*/ 
/*N*/ 	aDocSz = rSz;
/*N*/ 
/*N*/ 	if( !pWrtShell || aVisArea.IsEmpty() )		// keine Shell -> keine Aenderung
/*N*/ 	{
/*N*/ 		bDocSzUpdated = FALSE;
/*N*/ 		return;
/*N*/ 	}
/*?*/ 
/*?*/ 	//Wenn Text geloescht worden ist, kann es sein, dass die VisArea hinter
/*?*/ 	//den sichtbaren Bereich verweist
		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 	Rectangle aNewVisArea( aVisArea );
//STRIP001 /*?*/ 	BOOL bModified = FALSE;
//STRIP001 /*?*/ 	const SwTwips lGreenOffset = IsDocumentBorder() ? DOCUMENTBORDER : DOCUMENTBORDER * 2;
//STRIP001 /*?*/ 	SwTwips lTmp = aDocSz.Width() + lGreenOffset;
//STRIP001 /*?*/ 	if ( aNewVisArea.Right() >= lTmp  )
//STRIP001 /*?*/ 	{
//STRIP001 /*?*/ 		lTmp = aNewVisArea.Right() - lTmp;
//STRIP001 /*?*/ 		aNewVisArea.Right() -= lTmp;
//STRIP001 /*?*/ 		aNewVisArea.Left() -= lTmp;
//STRIP001 /*?*/ 		bModified = TRUE;
//STRIP001 /*?*/ 	}
//STRIP001 /*?*/ 	lTmp = aDocSz.Height() + lGreenOffset;
//STRIP001 /*?*/ 	if ( aNewVisArea.Bottom() >= lTmp )
//STRIP001 /*?*/ 	{
//STRIP001 /*?*/ 		lTmp = aNewVisArea.Bottom() - lTmp;
//STRIP001 /*?*/ 		aNewVisArea.Bottom() -= lTmp;
//STRIP001 /*?*/ 		aNewVisArea.Top() -= lTmp;
//STRIP001 /*?*/ 		bModified = TRUE;
//STRIP001 /*?*/ 	}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 	if ( bModified )
//STRIP001 /*?*/ 		SetVisArea( aNewVisArea, FALSE );
//STRIP001 /*?*/ 
//STRIP001 /*?*/     if ( UpdateScrollbars() && !bInOuterResizePixel && !bInInnerResizePixel &&
//STRIP001 /*?*/             !GetDocShell()->GetProtocol().IsInPlaceActive())
//STRIP001 /*?*/         OuterResizePixel( Point(),
//STRIP001 /*?*/ 						  GetViewFrame()->GetWindow().GetOutputSizePixel() );
/*N*/ }

/*--------------------------------------------------------------------
	Beschreibung:	Visarea neu setzen
 --------------------------------------------------------------------*/

//STRIP001 void SwView::SetVisArea( const Rectangle &rRect, BOOL bUpdateScrollbar )
//STRIP001 {
//STRIP001 	const Size aOldSz( aVisArea.GetSize() );
//STRIP001 
//STRIP001 	const Point aTopLeft(	  AlignToPixel( rRect.TopLeft() ));
//STRIP001 	const Point aBottomRight( AlignToPixel( rRect.BottomRight() ));
//STRIP001 	Rectangle aLR( aTopLeft, aBottomRight );
//STRIP001 
//STRIP001 	if( aLR == aVisArea )
//STRIP001 		return;
//STRIP001 
//STRIP001 	const SwTwips lMin = IsDocumentBorder() ? DOCUMENTBORDER : 0;
//STRIP001 
//STRIP001 	// keine negative Position, keine neg. Groesse
//STRIP001 	if( aLR.Top() < lMin )
//STRIP001 	{
//STRIP001 		aLR.Bottom() += lMin - aLR.Top();
//STRIP001 		aLR.Top() = lMin;
//STRIP001 	}
//STRIP001 	if( aLR.Left() < lMin )
//STRIP001 	{
//STRIP001 		aLR.Right() += lMin - aLR.Left();
//STRIP001 		aLR.Left() = lMin;
//STRIP001 	}
//STRIP001 	if( aLR.Right() < 0 )
//STRIP001 		aLR.Right() = 0;
//STRIP001 	if( aLR.Bottom() < 0 )
//STRIP001 		aLR.Bottom() = 0;
//STRIP001 
//STRIP001 	if( aLR == aVisArea )
//STRIP001 		return;
//STRIP001 
//STRIP001 	const Size aSize( aLR.GetSize() );
//STRIP001 	if( aSize.Width() < 0 || aSize.Height() < 0 )
//STRIP001 		return;
//STRIP001 
//STRIP001 	//Bevor die Daten veraendert werden ggf. ein Update rufen. Dadurch wird
//STRIP001 	//sichergestellt, da?anliegende Paints korrekt in Dokumentkoordinaten
//STRIP001 	//umgerechnet werden.
//STRIP001 	//Vorsichtshalber tun wir das nur wenn an der Shell eine Action laeuft,
//STRIP001 	//denn dann wir nicht wirklich gepaintet sondern die Rechtecke werden
//STRIP001 	//lediglich (in Dokumentkoordinaten) vorgemerkt.
//STRIP001 	if ( pWrtShell && pWrtShell->ActionPend() )
//STRIP001 		pWrtShell->GetWin()->Update();
//STRIP001 
//STRIP001 	aVisArea = aLR;
//STRIP001 
//STRIP001     const FASTBOOL bOuterResize = bUpdateScrollbar && UpdateScrollbars();
//STRIP001 
//STRIP001 	if ( pWrtShell )
//STRIP001 	{
//STRIP001 		pWrtShell->VisPortChgd( aVisArea );
//STRIP001 		if ( aOldSz != pWrtShell->VisArea().SSize() &&
//STRIP001 			 ( Abs(aOldSz.Width() - pWrtShell->VisArea().Width()) > 2 ||
//STRIP001 				Abs(aOldSz.Height() - pWrtShell->VisArea().Height()) > 2 ) )
//STRIP001 			pWrtShell->CheckBrowseView( FALSE );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( !bProtectDocShellVisArea )
//STRIP001 	{
//STRIP001 		//Wenn die Groesse der VisArea unveraendert ist, reichen wir die
//STRIP001 		//Groesse der VisArea vom InternalObject weiter. Damit soll der
//STRIP001 		//Transport von Fehlern vermieden werden.
//STRIP001 		Rectangle aVis( aVisArea );
//STRIP001 		if ( aVis.GetSize() == aOldSz )
//STRIP001 			aVis.SetSize(
//STRIP001 					GetDocShell()->SfxInPlaceObject::GetVisArea().GetSize() );
//STRIP001 
//STRIP001 		//Bei embedded immer mit Modify...
//STRIP001 		if ( GetDocShell()->GetCreateMode() == SFX_CREATE_MODE_EMBEDDED )
//STRIP001 			GetDocShell()->SfxInPlaceObject::SetVisArea( aVis );
//STRIP001 		else
//STRIP001 			GetDocShell()->SvEmbeddedObject::SetVisArea( aVis );
//STRIP001 	}
//STRIP001 
//STRIP001 	SfxViewShell::VisAreaChanged( aVisArea );
//STRIP001 
//STRIP001 	InvalidateRulerPos();
//STRIP001 
//STRIP001 	SwEditWin::ClearTip();
//STRIP001 
//STRIP001     if ( bOuterResize && !bInOuterResizePixel && !bInInnerResizePixel)
//STRIP001             OuterResizePixel( Point(),
//STRIP001 						  GetViewFrame()->GetWindow().GetOutputSizePixel() );
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:	Pos VisArea setzen
 --------------------------------------------------------------------*/

//STRIP001 void SwView::SetVisArea( const Point &rPt, BOOL bUpdateScrollbar )
//STRIP001 {
//STRIP001 	//einmal alignen, damit Brushes korrekt angesetzt werden.
//STRIP001 	//MA 31. May. 96: Das geht in der BrowseView schief, weil evlt.
//STRIP001 	//nicht das ganze Dokument sichtbar wird. Da der Inhalt in Frames
//STRIP001 	//passgenau ist, kann nicht aligned werden (bessere Idee?!?!)
//STRIP001 	//MA 29. Oct. 96 (fix: Bild.de, 200%) ganz ohne Alignment geht es nicht
//STRIP001 	//mal sehen wie weit wir mit der halben BrushSize kommen.
//STRIP001 	//TODO: why BRUSH_SIZE?
//STRIP001 	Point aPt( rPt );
//STRIP001 //	const long nTmp = GetWrtShell().IsFrameView() ? BRUSH_SIZE/2 : BRUSH_SIZE;
//STRIP001 	const long nTmp = GetWrtShell().IsFrameView() ? 4 : 8;
//STRIP001 	aPt = GetEditWin().LogicToPixel( aPt );
//STRIP001 	aPt.X() -= aPt.X() % nTmp;
//STRIP001 	aPt.Y() -= aPt.Y() % nTmp;
//STRIP001 	aPt = GetEditWin().PixelToLogic( aPt );
//STRIP001 
//STRIP001 	if ( aPt == aVisArea.TopLeft() )
//STRIP001 		return;
//STRIP001 
//STRIP001 	const long lXDiff = aVisArea.Left() - aPt.X();
//STRIP001 	const long lYDiff = aVisArea.Top()	- aPt.Y();
//STRIP001 	SetVisArea( Rectangle( aPt,
//STRIP001 			Point( aVisArea.Right() - lXDiff, aVisArea.Bottom() - lYDiff ) ),
//STRIP001 			bUpdateScrollbar);
//STRIP001 }


/*N*/ void SwView::CheckVisArea()
/*N*/ {
DBG_BF_ASSERT(0, "STRIP"); //STRIP001 //STRIP001     pHScrollbar->SetAuto( pWrtShell->IsBrowseMode() &&
//STRIP001 							  !GetDocShell()->GetProtocol().IsInPlaceActive() );
//STRIP001 	if ( IsDocumentBorder() )
//STRIP001 	{
//STRIP001 		if ( aVisArea.Left() != DOCUMENTBORDER ||
//STRIP001 			 aVisArea.Top()  != DOCUMENTBORDER )
//STRIP001 		{
//STRIP001 			Rectangle aNewVisArea( aVisArea );
//STRIP001 			aNewVisArea.Move( DOCUMENTBORDER - aVisArea.Left(),
//STRIP001 							  DOCUMENTBORDER - aVisArea.Top() );
//STRIP001 			SetVisArea( aNewVisArea, TRUE );
//STRIP001 		}
//STRIP001 	}
/*N*/ }

/*--------------------------------------------------------------------
	Beschreibung:	Sichtbaren Bereich berechnen

	OUT Point *pPt:				neue Position des sichtbaren
								Bereiches
	IN	Rectangle &rRect:		Rechteck, das sich innerhalb des neuen
								sichtbaren Bereiches befinden soll
		USHORT nRange			optional exakte Angabe des Bereiches,
								um den ggfs. gescrollt werden soll
 --------------------------------------------------------------------*/

//STRIP001 void SwView::CalcPt( Point *pPt, const Rectangle &rRect,
//STRIP001 					 USHORT nRangeX, USHORT nRangeY)
//STRIP001 {
//STRIP001 
//STRIP001 	const SwTwips lMin = IsDocumentBorder() ? DOCUMENTBORDER : 0;
//STRIP001 
//STRIP001 	long nYScroll = GetYScroll();
//STRIP001 	long nDesHeight = rRect.GetHeight();
//STRIP001 	long nCurHeight = aVisArea.GetHeight();
//STRIP001 	nYScroll = Min(nYScroll, nCurHeight - nDesHeight); // wird es knapp, dann nicht zuviel scrollen
//STRIP001 	if(nDesHeight > nCurHeight) // die Hoehe reicht nicht aus, dann interessiert nYScroll nicht mehr
//STRIP001 	{
//STRIP001 		pPt->Y() = rRect.Top();
//STRIP001 		pPt->Y() = Max( lMin, pPt->Y() );
//STRIP001 	}
//STRIP001 	else if ( rRect.Top() < aVisArea.Top() )				//Verschiebung nach oben
//STRIP001 	{
//STRIP001 		pPt->Y() = rRect.Top() - (nRangeY != USHRT_MAX ? nRangeY : nYScroll);
//STRIP001 		pPt->Y() = Max( lMin, pPt->Y() );
//STRIP001 	}
//STRIP001 	else if( rRect.Bottom() > aVisArea.Bottom() )	//Verschiebung nach unten
//STRIP001 	{
//STRIP001 		pPt->Y() = rRect.Bottom() -
//STRIP001 					(aVisArea.GetHeight()) + ( nRangeY != USHRT_MAX ?
//STRIP001 			nRangeY : nYScroll );
//STRIP001 		pPt->Y() = SetVScrollMax( pPt->Y() );
//STRIP001 	}
//STRIP001 	long nXScroll = GetXScroll();
//STRIP001 	if ( rRect.Right() > aVisArea.Right() )			//Verschiebung nach rechts
//STRIP001 	{
//STRIP001 		pPt->X() = rRect.Right()  -
//STRIP001 					(aVisArea.GetWidth()) +
//STRIP001 					(nRangeX != USHRT_MAX ? nRangeX : nXScroll);
//STRIP001 		pPt->X() = SetHScrollMax( pPt->X() );
//STRIP001 	}
//STRIP001 	else if ( rRect.Left() < aVisArea.Left() )		//Verschiebung nach links
//STRIP001 	{
//STRIP001 		pPt->X() = rRect.Left() -
//STRIP001 					(nRangeX != USHRT_MAX ? nRangeX : nXScroll);
//STRIP001 		pPt->X() = Max( ::GetLeftMargin( *this ) + nLeftOfst, pPt->X() );
//STRIP001 		pPt->X() = Min( rRect.Left() - nScrollX, pPt->X() );
//STRIP001 		pPt->X() = Max( 0L, pPt->X() );
//STRIP001 	}
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:	Scrolling
 --------------------------------------------------------------------*/

//STRIP001 BOOL SwView::IsScroll( const Rectangle &rRect ) const
//STRIP001 {
//STRIP001 	return bCenterCrsr || bTopCrsr || !aVisArea.IsInside(rRect);
//STRIP001 }


/*N*/ void SwView::Scroll( const Rectangle &rRect, USHORT nRangeX, USHORT nRangeY )
/*N*/ {
/*N*/ 	if ( aVisArea.IsEmpty() )
/*N*/ 		return;
			{DBG_BF_ASSERT(0, "STRIP");} /*?*/ 
//STRIP001 /*?*/ 	Rectangle aOldVisArea( aVisArea );
//STRIP001 /*?*/ 	long nDiffY = 0;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 	Window* pCareWn = ViewShell::GetCareWin(GetWrtShell());
//STRIP001 /*?*/ 	if ( pCareWn )
//STRIP001 /*?*/ 	{
//STRIP001 /*?*/         Rectangle aDlgRect( GetEditWin().PixelToLogic(
//STRIP001 /*?*/                 pCareWn->GetWindowExtentsRelative( &GetEditWin() ) ) );
//STRIP001 /*?*/ 		// Nur, wenn der Dialog nicht rechts oder links der VisArea liegt:
//STRIP001 /*?*/ 		if ( aDlgRect.Left() < aVisArea.Right() &&
//STRIP001 /*?*/ 			 aDlgRect.Right() > aVisArea.Left() )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			// Falls wir nicht zentriert werden sollen, in der VisArea liegen
//STRIP001 /*?*/ 			// und nicht vom Dialog ueberdeckt werden ...
//STRIP001 /*?*/ 			if ( !bCenterCrsr && aOldVisArea.IsInside( rRect )
//STRIP001 /*?*/ 				 && ( rRect.Left() > aDlgRect.Right()
//STRIP001 /*?*/ 					  || rRect.Right() < aDlgRect.Left()
//STRIP001 /*?*/ 					  || rRect.Top() > aDlgRect.Bottom()
//STRIP001 /*?*/ 					  || rRect.Bottom() < aDlgRect.Top() ) )
//STRIP001 /*?*/ 				return;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			// Ist oberhalb oder unterhalb der Dialogs mehr Platz?
//STRIP001 /*?*/ 			long nTopDiff = aDlgRect.Top() - aVisArea.Top();
//STRIP001 /*?*/ 			long nBottomDiff = aVisArea.Bottom() - aDlgRect.Bottom();
//STRIP001 /*?*/ 			if ( nTopDiff < nBottomDiff )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				if ( nBottomDiff > 0 ) // Ist unterhalb ueberhaupt Platz?
//STRIP001 /*?*/ 				{	// dann verschieben wir die Oberkante und merken uns dies
//STRIP001 /*?*/ 					nDiffY = aDlgRect.Bottom() - aVisArea.Top();
//STRIP001 /*?*/ 					aVisArea.Top() += nDiffY;
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			else
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				if ( nTopDiff > 0 ) // Ist oberhalb ueberhaupt Platz?
//STRIP001 /*?*/ 					aVisArea.Bottom() = aDlgRect.Top(); // Unterkante aendern
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 	}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 	//s.o. !IsScroll()
//STRIP001 /*?*/ 	if( !(bCenterCrsr || bTopCrsr) && aVisArea.IsInside( rRect ) )
//STRIP001 /*?*/ 	{
//STRIP001 /*?*/ 		aVisArea = aOldVisArea;
//STRIP001 /*?*/ 		return;
//STRIP001 /*?*/ 	}
//STRIP001 /*?*/ 	//falls das Rechteck groesser als der sichtbare Bereich -->
//STRIP001 /*?*/ 	//obere linke Ecke
//STRIP001 /*?*/ 	Size aSize( rRect.GetSize() );
//STRIP001 /*?*/ 	const Size aVisSize( aVisArea.GetSize() );
//STRIP001 /*?*/ 	if( !aVisArea.IsEmpty() && (
//STRIP001 /*?*/ 		aSize.Width() + GetXScroll() > aVisSize.Width() ||
//STRIP001 /*?*/ 		aSize.Height()+ GetYScroll() > aVisSize.Height() ))
//STRIP001 /*?*/ 	{
//STRIP001 /*?*/ 		Point aPt( aVisArea.TopLeft() );
//STRIP001 /*?*/ 		aSize.Width() = Min( aSize.Width(), aVisSize.Width() );
//STRIP001 /*?*/ 		aSize.Height()= Min( aSize.Height(),aVisSize.Height());
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		CalcPt( &aPt, Rectangle( rRect.TopLeft(), aSize ),
//STRIP001 /*?*/ 				(aVisSize.Width() - aSize.Width()) / 2,
//STRIP001 /*?*/ 				(aVisSize.Height()- aSize.Height())/ 2 );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		if( bTopCrsr )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			long nBorder = IsDocumentBorder() ? DOCUMENTBORDER : 0;
//STRIP001 /*?*/ 			aPt.Y() = Min( Max( nBorder, rRect.Top() ),
//STRIP001 /*?*/ 								aDocSz.Height() + nBorder -
//STRIP001 /*?*/ 									aVisArea.GetHeight() );
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		aPt.Y() -= nDiffY;
//STRIP001 /*?*/ 		aVisArea = aOldVisArea;
//STRIP001 /*?*/ 		SetVisArea( aPt );
//STRIP001 /*?*/ 		return;
//STRIP001 /*?*/ 	}
//STRIP001 /*?*/ 	if( !bCenterCrsr )
//STRIP001 /*?*/ 	{
//STRIP001 /*?*/ 		Point aPt( aVisArea.TopLeft() );
//STRIP001 /*?*/ 		CalcPt( &aPt, rRect, nRangeX, nRangeY );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		if( bTopCrsr )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			long nBorder = IsDocumentBorder() ? DOCUMENTBORDER : 0;
//STRIP001 /*?*/ 			aPt.Y() = Min( Max( nBorder, rRect.Top() ),
//STRIP001 /*?*/ 								aDocSz.Height() + nBorder -
//STRIP001 /*?*/ 									aVisArea.GetHeight() );
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		aPt.Y() -= nDiffY;
//STRIP001 /*?*/ 		aVisArea = aOldVisArea;
//STRIP001 /*?*/ 		SetVisArea( aPt );
//STRIP001 /*?*/ 		return;
//STRIP001 /*?*/ 	}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 	//Cursor zentrieren
//STRIP001 /*?*/ 	Point aPnt( aVisArea.TopLeft() );
//STRIP001 /*?*/ 	// ... in Y-Richtung auf jeden Fall
//STRIP001 /*?*/ 	aPnt.Y() += ( rRect.Top() + rRect.Bottom()
//STRIP001 /*?*/ 				  - aVisArea.Top() - aVisArea.Bottom() ) / 2 - nDiffY;
//STRIP001 /*?*/ 	// ... in X-Richtung nur, wenn das Rechteck rechts oder links aus der
//STRIP001 /*?*/ 	//	   VisArea hinausragt.
//STRIP001 /*?*/ 	if ( rRect.Right() > aVisArea.Right() || rRect.Left() < aVisArea.Left() )
//STRIP001 /*?*/ 	{
//STRIP001 /*?*/ 		aPnt.X() += ( rRect.Left() + rRect.Right()
//STRIP001 /*?*/ 				  - aVisArea.Left() - aVisArea.Right() ) / 2;
//STRIP001 /*?*/ 		aPnt.X() = SetHScrollMax( aPnt.X() );
//STRIP001 /*?*/ 		const SwTwips lMin = IsDocumentBorder() ? DOCUMENTBORDER : 0;
//STRIP001 /*?*/ 		aPnt.X() = Max( (GetLeftMargin( *this ) - lMin) + nLeftOfst, aPnt.X() );
//STRIP001 /*?*/ 	}
//STRIP001 /*?*/ 	aVisArea = aOldVisArea;
//STRIP001 /*?*/ 	if( pCareWn )
//STRIP001 /*?*/ 	{   // Wenn wir nur einem Dialog ausweichen wollen, wollen wir nicht ueber
//STRIP001 /*?*/ 		// das Ende des Dokument hinausgehen.
//STRIP001 /*?*/ 		aPnt.Y() = SetVScrollMax( aPnt.Y() );
//STRIP001 /*?*/ 	}
//STRIP001 /*?*/ 	SetVisArea( aPnt );
/*N*/ }

/*--------------------------------------------------------------------
	Beschreibung:	Seitenweises Scrollen
	Liefern den Wert, um den bei PageUp / -Down gescrollt werden soll
 --------------------------------------------------------------------*/

//STRIP001 BOOL SwView::GetPageScrollUpOffset( SwTwips &rOff ) const
//STRIP001 {
//STRIP001 	if ( !aVisArea.Top() || !aVisArea.GetHeight() )
//STRIP001 		return FALSE;
//STRIP001 	long nYScrl = GetYScroll() / 2;
//STRIP001 	rOff = -(aVisArea.GetHeight() - nYScrl);
//STRIP001 	//nicht vor den Dokumentanfang scrollen
//STRIP001 	if( aVisArea.Top() - rOff < 0 )
//STRIP001 		rOff = rOff - aVisArea.Top();
//STRIP001 	else if( GetWrtShell().GetCharRect().Top() < (aVisArea.Top() + nYScrl))
//STRIP001 		rOff += nYScrl;
//STRIP001 	return TRUE;
//STRIP001 }


//STRIP001 BOOL SwView::GetPageScrollDownOffset( SwTwips &rOff ) const
//STRIP001 {
//STRIP001 	if ( !aVisArea.GetHeight() ||
//STRIP001 		 (aVisArea.GetHeight() > aDocSz.Height()) )
//STRIP001 		return FALSE;
//STRIP001 	long nYScrl = GetYScroll() / 2;
//STRIP001 	rOff = aVisArea.GetHeight() - nYScrl;
//STRIP001 	//nicht hinter das Dokumentende scrollen
//STRIP001 	if ( aVisArea.Top() + rOff > aDocSz.Height() )
//STRIP001 		rOff = aDocSz.Height() - aVisArea.Bottom();
//STRIP001 	else if( GetWrtShell().GetCharRect().Bottom() >
//STRIP001 											( aVisArea.Bottom() - nYScrl ))
//STRIP001 		rOff -= nYScrl;
//STRIP001 	return rOff > 0;
//STRIP001 }

// Seitenweises Blaettern

//STRIP001 long SwView::PageUp()
//STRIP001 {
//STRIP001 	if (!aVisArea.GetHeight())
//STRIP001 		return 0;
//STRIP001 
//STRIP001 	Point aPos(aVisArea.TopLeft());
//STRIP001 	aPos.Y() -= aVisArea.GetHeight() - (GetYScroll() / 2);
//STRIP001 	aPos.Y() = Max(0L, aPos.Y());
//STRIP001 	SetVisArea( aPos );
//STRIP001 	return 1;
//STRIP001 }


//STRIP001 long SwView::PageDown()
//STRIP001 {
//STRIP001 	if ( !aVisArea.GetHeight() )
//STRIP001 		return 0;
//STRIP001 	Point aPos( aVisArea.TopLeft() );
//STRIP001 	aPos.Y() += aVisArea.GetHeight() - (GetYScroll() / 2);
//STRIP001 	aPos.Y() = SetVScrollMax( aPos.Y() );
//STRIP001 	SetVisArea( aPos );
//STRIP001 	return 1;
//STRIP001 }


//STRIP001 long SwView::PhyPageUp()
//STRIP001 {
//STRIP001 	//aktuell sichtbare Seite erfragen, nicht formatieren
//STRIP001 	USHORT nActPage = pWrtShell->GetNextPrevPageNum( FALSE );
//STRIP001 
//STRIP001 	if( USHRT_MAX != nActPage )
//STRIP001 	{
//STRIP001 		const Point aPt( aVisArea.Left(),
//STRIP001 						 pWrtShell->GetPagePos( nActPage ).Y() );
//STRIP001 		Point aAlPt( AlignToPixel( aPt ) );
//STRIP001 		// falls ein Unterschied besteht, wurde abgeschnitten --> dann
//STRIP001 		// einen Pixel addieren, damit kein Rest der Vorgaengerseite
//STRIP001 		// sichtbar ist
//STRIP001 		if( aPt.Y() != aAlPt.Y() )
//STRIP001 			aAlPt.Y() += GetEditWin().PixelToLogic( Size( 0, 1 ) ).Height();
//STRIP001 		SetVisArea( aAlPt );
//STRIP001 	}
//STRIP001 	return 1;
//STRIP001 }


//STRIP001 long SwView::PhyPageDown()
//STRIP001 {
//STRIP001 	//aktuell sichtbare Seite erfragen, nicht formatieren
//STRIP001 	USHORT nActPage = pWrtShell->GetNextPrevPageNum( TRUE );
//STRIP001 	// falls die letzte Dokumentseite sichtbar ist, nichts tun
//STRIP001 	if( USHRT_MAX != nActPage )
//STRIP001 	{
//STRIP001 		const Point aPt( aVisArea.Left(),
//STRIP001 						 pWrtShell->GetPagePos( nActPage ).Y() );
//STRIP001 		Point aAlPt( AlignToPixel( aPt ) );
//STRIP001 		// falls ein Unterschied besteht, wurde abgeschnitten --> dann
//STRIP001 		// einen Pixel addieren, damit kein Rest der Vorgaengerseite sichtbar ist
//STRIP001 		if( aPt.Y() != aAlPt.Y() )
//STRIP001 			aAlPt.Y() += GetEditWin().PixelToLogic( Size( 0, 1 ) ).Height();
//STRIP001 		SetVisArea( aAlPt );
//STRIP001 	}
//STRIP001 	return 1;
//STRIP001 }


//STRIP001 long SwView::PageUpCrsr( BOOL bSelect )
//STRIP001 {
//STRIP001 	if ( !bSelect )
//STRIP001 	{
//STRIP001 		const USHORT eType = pWrtShell->GetFrmType(0,TRUE);
//STRIP001 		if ( eType & FRMTYPE_FOOTNOTE )
//STRIP001 		{
//STRIP001 			pWrtShell->MoveCrsr();
//STRIP001 			pWrtShell->GotoFtnAnchor();
//STRIP001 			pWrtShell->Right(CRSR_SKIP_CHARS, FALSE, 1, FALSE );
//STRIP001 			return 1;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	SwTwips lOff = 0;
//STRIP001 	if ( GetPageScrollUpOffset( lOff ) &&
//STRIP001 		 (pWrtShell->IsCrsrReadonly() ||
//STRIP001 		  !pWrtShell->PageCrsr( lOff, bSelect )) &&
//STRIP001 		 PageUp() )
//STRIP001 	{
//STRIP001 		pWrtShell->ResetCursorStack();
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 	return FALSE;
//STRIP001 }


//STRIP001 long SwView::PageDownCrsr(BOOL bSelect)
//STRIP001 {
//STRIP001 	SwTwips lOff = 0;
//STRIP001 	if ( GetPageScrollDownOffset( lOff ) &&
//STRIP001 		 (pWrtShell->IsCrsrReadonly() ||
//STRIP001 		  !pWrtShell->PageCrsr( lOff, bSelect )) &&
//STRIP001 		 PageDown() )
//STRIP001 	{
//STRIP001 		pWrtShell->ResetCursorStack();
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 	return FALSE;
//STRIP001 }

/*------------------------------------------------------------------------
 Beschreibung:	Handler der Scrollbars
------------------------------------------------------------------------*/

/*?*/ IMPL_LINK( SwView, ScrollHdl, SwScrollbar *, pScrollbar )
/*?*/ {
			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 	if ( GetWrtShell().ActionPend() )
//STRIP001 		return 0;
//STRIP001 
//STRIP001 	if ( pScrollbar->GetType() == SCROLL_DRAG )
//STRIP001 		pWrtShell->EnableSmooth( FALSE );
//STRIP001 
//STRIP001 	if(!pWrtShell->IsBrowseMode() &&
//STRIP001 		pScrollbar->GetType() == SCROLL_DRAG)
//STRIP001 	{
//STRIP001 		//Hier wieder auskommentieren wenn das mitscrollen nicht gewuenscht ist.
//STRIP001 		// JP 21.07.00: the end scrollhandler invalidate the FN_STAT_PAGE,
//STRIP001 		// 				so we dont must do it agin.
//STRIP001 		EndScrollHdl(pScrollbar);
//STRIP001 
//STRIP001 		Point aPos( aVisArea.TopLeft() );
//STRIP001 		lcl_GetPos(this, aPos, pScrollbar, IsDocumentBorder());
//STRIP001 
//STRIP001 		USHORT nPhNum = 1;
//STRIP001 		USHORT nVirtNum = 1;
//STRIP001 
//STRIP001 		String sDisplay;
//STRIP001 		if(pWrtShell->GetPageNumber( aPos.Y(), FALSE, nPhNum, nVirtNum, sDisplay ))
//STRIP001 		{
//STRIP001 			// JP 21.07.00: the end scrollhandler invalidate the FN_STAT_PAGE,
//STRIP001 			// 				so we dont must do it agin.
//STRIP001 //			if(!GetDocShell()->GetProtocol().IsInPlaceActive())
//STRIP001 //				S F X_BINDINGS().Update(FN_STAT_PAGE);
//STRIP001 
//STRIP001 			//QuickHelp:
//STRIP001 			USHORT nPageCnt = pWrtShell->GetPageCnt();
//STRIP001 			if( nPageCnt > 1 && Help::IsQuickHelpEnabled() )
//STRIP001 			{
//STRIP001 				if( !nPgNum || nPgNum != nPhNum )
//STRIP001 				{
//STRIP001 					Rectangle aRect;
//STRIP001 					aRect.Left() = pScrollbar->GetParent()->OutputToScreenPixel(
//STRIP001 										pScrollbar->GetPosPixel() ).X() -8;
//STRIP001 					aRect.Top() = pScrollbar->OutputToScreenPixel(
//STRIP001 									pScrollbar->GetPointerPosPixel() ).Y();
//STRIP001 					aRect.Right() 	= aRect.Left();
//STRIP001 					aRect.Bottom()	= aRect.Top();
//STRIP001 
//STRIP001 					String sPageStr( GetPageStr( nPhNum, nVirtNum, sDisplay ));
//STRIP001 					SwContentAtPos aCnt( SwContentAtPos::SW_OUTLINE );
//STRIP001 					pWrtShell->GetContentAtPos( aPos, aCnt );
//STRIP001 					if( aCnt.sStr.Len() )
//STRIP001 					{
//STRIP001 						sPageStr += String::CreateFromAscii(
//STRIP001 										RTL_CONSTASCII_STRINGPARAM( "  - " ));
//STRIP001 						sPageStr.Insert( aCnt.sStr, 0, 80 );
//STRIP001 						sPageStr.SearchAndReplaceAll( '\t', ' ' );
//STRIP001 					}
//STRIP001 
//STRIP001 					Help::ShowQuickHelp( pScrollbar, aRect, sPageStr,
//STRIP001 									QUICKHELP_RIGHT|QUICKHELP_VCENTER);
//STRIP001 				}
//STRIP001 				nPgNum = nPhNum;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		EndScrollHdl(pScrollbar);
//STRIP001 
//STRIP001 	if ( pScrollbar->GetType() == SCROLL_DRAG )
//STRIP001 		pWrtShell->EnableSmooth( TRUE );
//STRIP001 
/*?*/  	return 0;
/*?*/ }
/*------------------------------------------------------------------------
 Beschreibung:	Handler der Scrollbars
------------------------------------------------------------------------*/

/*?*/ IMPL_LINK( SwView, EndScrollHdl, SwScrollbar *, pScrollbar )
/*?*/ {
		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 	if ( !GetWrtShell().ActionPend() )
//STRIP001 	{
//STRIP001 		if(nPgNum)
//STRIP001 		{
//STRIP001 			nPgNum = 0;
//STRIP001 			Help::ShowQuickHelp(pScrollbar, Rectangle(), aEmptyStr, 0);
//STRIP001 		}
//STRIP001 		Point aPos( aVisArea.TopLeft() );
//STRIP001 		FASTBOOL bBorder = IsDocumentBorder();
//STRIP001 		lcl_GetPos(this, aPos, pScrollbar, bBorder);
//STRIP001 		if ( bBorder && aPos == aVisArea.TopLeft() )
//STRIP001 			UpdateScrollbars();
//STRIP001 		else
//STRIP001 			SetVisArea( aPos, FALSE );
//STRIP001 
//STRIP001 		GetViewFrame()->GetBindings().Update(FN_STAT_PAGE);
//STRIP001 	}
/*?*/ 	return 0;
/*?*/ }

/*--------------------------------------------------------------------
	Beschreibung:

		berechnet die Groesse von aVisArea abhaengig von der Groesse
		des EditWin auf dem Schirm.

 --------------------------------------------------------------------*/

//STRIP001 void SwView::CalcVisArea( const Size &rOutPixel )
//STRIP001 {
//STRIP001 	Point aTopLeft;
//STRIP001 	Rectangle aRect( aTopLeft, rOutPixel );
//STRIP001 	aTopLeft = GetEditWin().PixelToLogic( aTopLeft );
//STRIP001 	Point aBottomRight( GetEditWin().PixelToLogic( aRect.BottomRight() ) );
//STRIP001 
//STRIP001 	aRect.Left() = aTopLeft.X();
//STRIP001 	aRect.Top() = aTopLeft.Y();
//STRIP001 	aRect.Right() = aBottomRight.X();
//STRIP001 	aRect.Bottom() = aBottomRight.Y();
//STRIP001 
//STRIP001 	//Die Verschiebungen nach rechts und/oder unten koennen jetzt falsch
//STRIP001 	//sein (z.B. Zoom aendern, Viewgroesse aendern.
//STRIP001 	const long lBorder = IsDocumentBorder() ? DOCUMENTBORDER : DOCUMENTBORDER*2;
//STRIP001 	if ( aRect.Left() )
//STRIP001 	{
//STRIP001 		const long lWidth = GetWrtShell().GetDocSize().Width() + lBorder;
//STRIP001 		if ( aRect.Right() > lWidth )
//STRIP001 		{
//STRIP001 			long lDelta    = aRect.Right() - lWidth;
//STRIP001 			aRect.Left()  -= lDelta;
//STRIP001 			aRect.Right() -= lDelta;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if ( aRect.Top() )
//STRIP001 	{
//STRIP001 		const long lHeight = GetWrtShell().GetDocSize().Height() + lBorder;
//STRIP001 		if ( aRect.Bottom() > lHeight )
//STRIP001 		{
//STRIP001 			long lDelta		= aRect.Bottom() - lHeight;
//STRIP001 			aRect.Top()	   -= lDelta;
//STRIP001 			aRect.Bottom() -= lDelta;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	SetVisArea( aRect );
//STRIP001 	GetViewFrame()->GetBindings().Invalidate( SID_ATTR_ZOOM );
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:	Bedienelemente neu anordnen
 --------------------------------------------------------------------*/


//STRIP001 void SwView::CalcAndSetBorderPixel( SvBorder &rToFill, FASTBOOL bInner )
//STRIP001 {
//STRIP001 	BOOL bRightVRuler = pWrtShell->GetViewOptions()->IsVRulerRight();
//STRIP001     if ( pVRuler->IsVisible() )
//STRIP001 	{
//STRIP001         long nWidth = pVRuler->GetSizePixel().Width();
//STRIP001 		if(bRightVRuler)
//STRIP001             rToFill.Right() = nWidth;
//STRIP001 		else
//STRIP001 			rToFill.Left() = nWidth;
//STRIP001 	}
//STRIP001 
//STRIP001     DBG_ASSERT(pHRuler, "warum ist das Lineal nicht da?")
//STRIP001     if ( pHRuler->IsVisible() )
//STRIP001         rToFill.Top() = pHRuler->GetSizePixel().Height();
//STRIP001 
//STRIP001 	const StyleSettings &rSet = GetEditWin().GetSettings().GetStyleSettings();
//STRIP001 	const long nTmp = rSet.GetScrollBarSize();
//STRIP001 	if( pVScrollbar->IsVisible(TRUE) )
//STRIP001 	{
//STRIP001 		if(bRightVRuler)
//STRIP001             rToFill.Left() = nTmp;
//STRIP001 		else
//STRIP001 			rToFill.Right()  = nTmp;
//STRIP001 	}
//STRIP001     if ( pHScrollbar->IsVisible(TRUE) )
//STRIP001 		rToFill.Bottom() = nTmp;
//STRIP001 
//STRIP001 	SetBorderPixel( rToFill );
//STRIP001 }


//STRIP001 void ViewResizePixel( const Window &rRef,
//STRIP001 					const Point &rOfst,
//STRIP001 					const Size &rSize,
//STRIP001 					const Size &rEditSz,
//STRIP001 					const BOOL bInner,
//STRIP001                     SwScrollbar& rVScrollbar,
//STRIP001                     SwScrollbar& rHScrollbar,
//STRIP001 					ImageButton* pPageUpBtn,
//STRIP001 					ImageButton* pPageDownBtn,
//STRIP001 					ImageButton* pNaviBtn,
//STRIP001                     Window& rScrollBarBox,
//STRIP001 					SvxRuler* pVLineal,
//STRIP001 					SvxRuler* pHLineal,
//STRIP001                     BOOL bWebView,
//STRIP001                     BOOL bVRulerRight )
//STRIP001 //STRIP001 {
//STRIP001 // ViewResizePixel wird auch von der PreView benutzt!!!
//STRIP001 
//STRIP001 	const BOOL bHLineal = pHLineal && pHLineal->IsVisible();
//STRIP001 	const long nHLinSzHeight = bHLineal ?
//STRIP001 						pHLineal->GetSizePixel().Height() : 0;
//STRIP001     const BOOL bVLineal = pVLineal && pVLineal->IsVisible();
//STRIP001     const long nVLinSzWidth = bVLineal ?
//STRIP001 						pVLineal->GetSizePixel().Width() : 0;
//STRIP001     long nHBSzHeight2= rHScrollbar.IsVisible() || !rHScrollbar.IsAuto() ?
//STRIP001 					   rRef.GetSettings().GetStyleSettings().GetScrollBarSize() : 0;
//STRIP001     long nHBSzHeight =
//STRIP001 				rHScrollbar.IsVisible(TRUE) ||  (rHScrollbar.IsVisible() && !rHScrollbar.IsAuto()) ?
//STRIP001 								nHBSzHeight2:0;
//STRIP001     long nVBSzWidth = rVScrollbar.IsVisible(TRUE) ||  (rVScrollbar.IsVisible() && !rVScrollbar.IsAuto()) ?
//STRIP001                          rRef.GetSettings().GetStyleSettings().GetScrollBarSize() : 0;
//STRIP001 
//STRIP001     if(pVLineal)
//STRIP001     {
//STRIP001         WinBits nStyle = pVLineal->GetStyle()&~WB_RIGHT_ALIGNED;
//STRIP001         Point aPos( rOfst.X(), rOfst.Y()+nHLinSzHeight );
//STRIP001 		if(bVRulerRight)
//STRIP001 		{
//STRIP001             aPos.X() += rSize.Width() - nVLinSzWidth;
//STRIP001             nStyle |= WB_RIGHT_ALIGNED;
//STRIP001         }
//STRIP001         Size  aSize( nVLinSzWidth, rEditSz.Height() );
//STRIP001 		if(!aSize.Width())
//STRIP001 			aSize.Width() = pVLineal->GetSizePixel().Width();
//STRIP001         pVLineal->SetStyle(nStyle);
//STRIP001         pVLineal->SetPosSizePixel( aPos, aSize );
//STRIP001         if(!pVLineal->IsVisible())
//STRIP001             pVLineal->Resize();
//STRIP001     }
//STRIP001 //  Lineal braucht ein Resize, sonst funktioniert es nicht im unischtbaren Zustand
//STRIP001     if(pHLineal)
//STRIP001     {
//STRIP001 		Size aSize( rSize.Width(), nHLinSzHeight );
//STRIP001         if ( nVBSzWidth && !bVRulerRight)
//STRIP001 			aSize.Width() -= nVBSzWidth;
//STRIP001 		if(!aSize.Height())
//STRIP001 			aSize.Height() = pHLineal->GetSizePixel().Height();
//STRIP001 		pHLineal->SetPosSizePixel( rOfst, aSize );
//STRIP001 //		#46802 VCL ruft an unsichtbaren Fenstern kein Resize
//STRIP001 //      fuer das Lineal ist das aber keine gute Idee
//STRIP001 		if(!pHLineal->IsVisible())
//STRIP001 			pHLineal->Resize();
//STRIP001 	}
//STRIP001 
//STRIP001 	// Scrollbars und SizeBox anordnen
//STRIP001 	Point aScrollFillPos;
//STRIP001 	{
//STRIP001 		Point aPos( rOfst.X(),
//STRIP001 					rOfst.Y()+rSize.Height()-nHBSzHeight );
//STRIP001         if(bVRulerRight)
//STRIP001         {
//STRIP001             aPos.X() += nVBSzWidth;
//STRIP001         }
//STRIP001 
//STRIP001 		Size  aSize( rSize.Width(), nHBSzHeight2 );
//STRIP001 		if ( nVBSzWidth )
//STRIP001 			aSize.Width() -= nVBSzWidth;
//STRIP001         rHScrollbar.SetPosSizePixel( aPos, aSize );
//STRIP001 		aScrollFillPos.Y() = aPos.Y();
//STRIP001 	}
//STRIP001 	{
//STRIP001 		Point aPos( rOfst.X()+rSize.Width()-nVBSzWidth,
//STRIP001 					rOfst.Y() );
//STRIP001         Size  aSize( nVBSzWidth, rSize.Height() );
//STRIP001         if(bVRulerRight)
//STRIP001 		{
//STRIP001 			aPos.X() = rOfst.X();
//STRIP001             if(bHLineal)
//STRIP001             {
//STRIP001                 aPos.Y() += nHLinSzHeight;
//STRIP001                 aSize.Height() -= nHLinSzHeight;
//STRIP001             }
//STRIP001 		}
//STRIP001 
//STRIP001         Size  aImgSz( nVBSzWidth, nVBSzWidth );
//STRIP001 
//STRIP001 		//#55949#  wenn der Platz fuer Scrollbar und Page-Buttons zu klein wird, dann
//STRIP001 		// werden die Buttons versteckt
//STRIP001 		USHORT nCnt = pNaviBtn ? 3 : 2;
//STRIP001 		long nSubSize = (aImgSz.Width() * nCnt );
//STRIP001 		//
//STRIP001 		BOOL bHidePageButtons = aSize.Height() < ((bWebView ? 3 : 2) * nSubSize);
//STRIP001 		if(!bHidePageButtons)
//STRIP001 			aSize.Height() -= nSubSize;
//STRIP001 		else
//STRIP001 			aImgSz.Width() = 0;	// kein Hide, weil das im Update Scrollbar missverstanden wird
//STRIP001 
//STRIP001 		if ( nHBSzHeight )
//STRIP001 			aSize.Height() -= nHBSzHeight;
//STRIP001         rVScrollbar.SetPosSizePixel( aPos, aSize );
//STRIP001 
//STRIP001 		aPos.Y() += aSize.Height();
//STRIP001 		pPageUpBtn->SetPosSizePixel( aPos, aImgSz );
//STRIP001 		if(pNaviBtn)
//STRIP001 		{
//STRIP001 			aPos.Y() += aImgSz.Height();
//STRIP001 			pNaviBtn->SetPosSizePixel(aPos, aImgSz);
//STRIP001 		}
//STRIP001 
//STRIP001 		aPos.Y() += aImgSz.Height();
//STRIP001 		pPageDownBtn->SetPosSizePixel( aPos, aImgSz );
//STRIP001 
//STRIP001 
//STRIP001         if( rHScrollbar.IsVisible() )
//STRIP001 		{
//STRIP001 			aScrollFillPos.X() = aPos.X();
//STRIP001 
//STRIP001             rScrollBarBox.SetPosSizePixel( aScrollFillPos,
//STRIP001 										 Size( nHBSzHeight,	nVBSzWidth) );
//STRIP001         }
//STRIP001 	}
//STRIP001 }


//STRIP001 void SwView::ShowAtResize()
//STRIP001 {
//STRIP001 	const FASTBOOL bBrowse = pWrtShell->IsBrowseMode();
//STRIP001 	bShowAtResize = FALSE;
//STRIP001 	    if ( pWrtShell->GetViewOptions()->IsViewHRuler() )
//STRIP001         pHRuler->Show();
//STRIP001 //    if ( !bBrowse ||GetDocShell()->GetProtocol().IsInPlaceActive())
//STRIP001 //        pHScrollbar->Show();
//STRIP001 //    if ( !bBrowse && pVScrollbar->IsVisible() && pHScrollbar->IsVisible())
//STRIP001 //            pScrollFill->Show();
//STRIP001 }
//STRIP001 

//STRIP001 void SwView::InnerResizePixel( const Point &rOfst, const Size &rSize )
//STRIP001 {
//STRIP001     bInInnerResizePixel = TRUE;
//STRIP001     const BOOL bHScrollVisible = pHScrollbar->IsVisible(TRUE);
//STRIP001     const BOOL bVScrollVisible = pVScrollbar->IsVisible(TRUE);
//STRIP001 	BOOL bRepeat = FALSE;
//STRIP001 	do
//STRIP001 	{
//STRIP001 		SvBorder aBorder;
//STRIP001 		CalcAndSetBorderPixel( aBorder, TRUE );
//STRIP001 		Size aSz( rSize );
//STRIP001 		aSz.Height() += aBorder.Top()  + aBorder.Bottom();
//STRIP001 		aSz.Width()  += aBorder.Left() + aBorder.Right();
//STRIP001 		Size aEditSz( GetEditWin().GetOutputSizePixel() );
//STRIP001 		const BOOL bBrowse = pWrtShell->IsBrowseMode();
//STRIP001 		ViewResizePixel( GetEditWin(), rOfst, aSz, aEditSz, TRUE, *pVScrollbar,
//STRIP001                             *pHScrollbar, pPageUpBtn, pPageDownBtn,
//STRIP001 							pNaviBtn,
//STRIP001                             *pScrollFill, pVRuler, pHRuler,
//STRIP001                             0 != PTR_CAST(SwWebView, this),
//STRIP001                             pWrtShell->GetViewOptions()->IsVRulerRight());
//STRIP001 		if ( bShowAtResize )
//STRIP001 			ShowAtResize();
//STRIP001 
//STRIP001 		if( pHRuler->IsVisible() || pVRuler->IsVisible() )
//STRIP001 		{
//STRIP001 			const Fraction& rFrac = GetEditWin().GetMapMode().GetScaleX();
//STRIP001 			USHORT nZoom = USHORT(rFrac.GetNumerator() * 100L / rFrac.GetDenominator());
//STRIP001 
//STRIP001 			const Fraction aFrac( nZoom, 100 );
//STRIP001 			pVRuler->SetZoom( aFrac );
//STRIP001 			pHRuler->SetZoom( aFrac );
//STRIP001 			InvalidateRulerPos();	//Inhalt invalidieren.
//STRIP001 		}
//STRIP001 		//CursorStack zuruecksetzen, da die Cursorpositionen fuer PageUp/-Down
//STRIP001 		//nicht mehr zum aktuell sichtbaren Bereich passen
//STRIP001 		pWrtShell->ResetCursorStack();
//STRIP001 
//STRIP001 		//EditWin niemals einstellen!
//STRIP001 
//STRIP001 		//VisArea einstellen, aber dort nicht das SetVisArea der DocShell rufen!
//STRIP001 		bProtectDocShellVisArea = TRUE;
//STRIP001 		CalcVisArea( aEditSz );
//STRIP001 		//visibility changes of the automatic horizontal scrollbar
//STRIP001 		//require to repeat the ViewResizePixel() call - but only once!
//STRIP001 		if(bRepeat)
//STRIP001 			bRepeat = FALSE;
//STRIP001 		else if(bHScrollVisible != pHScrollbar->IsVisible(TRUE) ||
//STRIP001 				bVScrollVisible != pVScrollbar->IsVisible(TRUE))
//STRIP001 			bRepeat = TRUE;
//STRIP001 	}while( bRepeat );
//STRIP001 	bProtectDocShellVisArea = FALSE;
//STRIP001     bInInnerResizePixel = FALSE;
//STRIP001 }


//STRIP001 void SwView::OuterResizePixel( const Point &rOfst, const Size &rSize )
//STRIP001 {
//STRIP001 	if( bInOuterResizePixel )
//STRIP001 		return;
//STRIP001 	bInOuterResizePixel	= TRUE;
//STRIP001 
//STRIP001 // feststellen, ob Scrollbars angezeigt werden duerfen
//STRIP001 	FASTBOOL bBrowse = pWrtShell->IsBrowseMode();
//STRIP001 	FASTBOOL bShowH,
//STRIP001 			 bShowV,
//STRIP001 			 bAuto = FALSE,
//STRIP001 			 bHAuto= bBrowse;
//STRIP001 	switch( GetScrollingMode() )
//STRIP001 	{
//STRIP001 	case SCROLLING_DEFAULT:
//STRIP001 		{
//STRIP001 			const SwViewOption *pVOpt = pWrtShell->GetViewOptions();
//STRIP001 			if ( !pVOpt->IsReadonly() || pVOpt->IsStarOneSetting() )
//STRIP001 			{
//STRIP001 				bShowH = pVOpt->IsViewHScrollBar();
//STRIP001 				bShowV = pVOpt->IsViewVScrollBar();
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		/* kein break hier */
//STRIP001 	case SCROLLING_AUTO:
//STRIP001 		bAuto = bHAuto = TRUE;
//STRIP001 		bShowH = bShowV = TRUE;
//STRIP001 		break;
//STRIP001 	case SCROLLING_YES:
//STRIP001 		bShowH = bShowV = TRUE;
//STRIP001 		break;
//STRIP001 	case SCROLLING_NO:
//STRIP001 		bShowH = bShowV = bHAuto = FALSE;
//STRIP001 		break;
//STRIP001 	}
//STRIP001     SwDocShell* pDocSh = GetDocShell();
//STRIP001     BOOL bIsPreview = pDocSh->IsPreview();
//STRIP001     if( bIsPreview )
//STRIP001     {
//STRIP001         bShowH = bShowV = bHAuto = FALSE;
//STRIP001     }
//STRIP001     if(pHScrollbar->IsVisible() != bShowH)
//STRIP001         ShowHScrollbar(bShowH);
//STRIP001     pHScrollbar->SetAuto( bHAuto );
//STRIP001     if(pVScrollbar->IsVisible() != bShowV)
//STRIP001         ShowVScrollbar(bShowV);
//STRIP001     pVScrollbar->SetAuto(bAuto);
//STRIP001 
//STRIP001 	SET_CURR_SHELL( pWrtShell );
//STRIP001 	FASTBOOL bRepeat = FALSE;
//STRIP001 	long nCnt = 0;
//STRIP001 
//STRIP001 	BOOL bUnLockView = !pWrtShell->IsViewLocked();
//STRIP001 	pWrtShell->LockView( TRUE );
//STRIP001 	pWrtShell->LockPaint();
//STRIP001 
//STRIP001 	do {
//STRIP001 		++nCnt;
//STRIP001         const FASTBOOL bScroll1 = pVScrollbar->IsVisible(TRUE);
//STRIP001         const FASTBOOL bScroll2 = pHScrollbar->IsVisible(TRUE);
//STRIP001 		SvBorder aBorder;
//STRIP001 		CalcAndSetBorderPixel( aBorder, FALSE );
//STRIP001 		const Size aEditSz( GetEditWin().GetOutputSizePixel() );
//STRIP001         ViewResizePixel( GetEditWin(), rOfst, rSize, aEditSz, FALSE, *pVScrollbar,
//STRIP001                                 *pHScrollbar, pPageUpBtn, pPageDownBtn,
//STRIP001 								pNaviBtn,
//STRIP001                                 *pScrollFill, pVRuler, pHRuler,
//STRIP001                                 0 != PTR_CAST(SwWebView, this),
//STRIP001                                 pWrtShell->GetViewOptions()->IsVRulerRight() );
//STRIP001 		if ( bShowAtResize )
//STRIP001 			ShowAtResize();
//STRIP001 
//STRIP001         if( pHRuler->IsVisible() || pVRuler->IsVisible() )
//STRIP001 			InvalidateRulerPos();	//Inhalt invalidieren.
//STRIP001 
//STRIP001 		//CursorStack zuruecksetzen, da die Cursorpositionen fuer PageUp/-Down
//STRIP001 		//nicht mehr zum aktuell sichtbaren Bereich passen
//STRIP001 		pWrtShell->ResetCursorStack();
//STRIP001 
//STRIP001 #if OSL_DEBUG_LEVEL > 1
//STRIP001         SwEditWin &rW = GetEditWin();
//STRIP001 #endif
//STRIP001         ASSERT( !GetEditWin().IsVisible() ||
//STRIP001                     (( aEditSz.Width() > 0 && aEditSz.Height() > 0 )
//STRIP001                         || !aVisArea.IsEmpty()), "Small world, isn't it?" );
//STRIP001 
//STRIP001 		//EditWin niemals einstellen!
//STRIP001 
//STRIP001 		//Die VisArea muss aber natuerlich eingestellt werden.
//STRIP001 		//jetzt ist auch der richtige Zeitpunkt den Zoom neu zu berechnen wenn
//STRIP001 		//es kein einfacher Faktor ist.
//STRIP001 		pWrtShell->StartAction();
//STRIP001 		CalcVisArea( aEditSz );
//STRIP001 
//STRIP001 		//Damit auch beim outplace editing die Seitenbreite sofort
//STRIP001 		//angepasst wird.
//STRIP001         if ( pDocSh->GetCreateMode() == SFX_CREATE_MODE_EMBEDDED )
//STRIP001             pDocSh->SetVisArea(
//STRIP001                             pDocSh->SfxInPlaceObject::GetVisArea() );
//STRIP001 		if ( pWrtShell->GetViewOptions()->GetZoomType() != SVX_ZOOM_PERCENT &&
//STRIP001 			 !pWrtShell->IsBrowseMode() )
//STRIP001 			_SetZoom( aEditSz, (SvxZoomType)pWrtShell->GetViewOptions()->GetZoomType(), 100, TRUE );
//STRIP001 		pWrtShell->EndAction();
//STRIP001 
//STRIP001         bRepeat = bScroll1 != pVScrollbar->IsVisible(TRUE);
//STRIP001 		if ( !bRepeat )
//STRIP001             bRepeat = bScroll2 != pHScrollbar->IsVisible(TRUE);
//STRIP001 
//STRIP001 		//Nicht endlosschleifen. Moeglichst dann stoppen wenn die
//STRIP001 		//(Auto-)Scrollbars sichtbar sind.
//STRIP001 		if ( bRepeat && nCnt > 10 ||
//STRIP001 			 (nCnt > 3 && bHAuto && bAuto &&
//STRIP001               bAuto  && bHAuto) )
//STRIP001 		{
//STRIP001 			bRepeat = FALSE;
//STRIP001 		}
//STRIP001 
//STRIP001 	}while ( bRepeat );
//STRIP001 
//STRIP001 	if( pVScrollbar->IsVisible() || pVScrollbar->IsAuto())
//STRIP001 	{
//STRIP001 		BOOL bShowButtons = pVScrollbar->IsVisible(TRUE);
//STRIP001 		if(pPageUpBtn && pPageUpBtn->IsVisible() != bShowButtons)
//STRIP001 		{
//STRIP001 			pPageUpBtn->Show(bShowButtons);
//STRIP001 			if(pPageDownBtn)
//STRIP001 				pPageDownBtn->Show(bShowButtons);
//STRIP001 			if(pNaviBtn)
//STRIP001 				pNaviBtn->Show(bShowButtons);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	pWrtShell->UnlockPaint();
//STRIP001 	if( bUnLockView )
//STRIP001 		pWrtShell->LockView( FALSE );
//STRIP001 
//STRIP001     bInOuterResizePixel = FALSE;
//STRIP001 
//STRIP001 }


//STRIP001 void SwView::SetZoomFactor( const Fraction &rX, const Fraction &rY )
//STRIP001 {
//STRIP001 	const Fraction &rFrac = rX < rY ? rX : rY;
//STRIP001 	SetZoom( SVX_ZOOM_PERCENT, (short) long(rFrac * Fraction( 100, 1 )) );
//STRIP001 
//STRIP001 	//Um Rundungsfehler zu minimieren lassen wir von der Basisklasse ggf.
//STRIP001 	//auch die krummen Werte einstellen
//STRIP001 	SfxViewShell::SetZoomFactor( rX, rY );
//STRIP001 }


//STRIP001 Size SwView::GetOptimalSizePixel() const
//STRIP001 {
//STRIP001 	Size aPgSize;
//STRIP001 	if ( pWrtShell->IsBrowseMode() )
//STRIP001 	{
//STRIP001 		aPgSize.Height() = lA4Height;
//STRIP001 		aPgSize.Width()  = lA4Width;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		const SwPageDesc &rDesc = pWrtShell->GetPageDesc(
//STRIP001 													pWrtShell->GetCurPageDesc() );
//STRIP001 		const SvxLRSpaceItem &rLRSpace = rDesc.GetMaster().GetLRSpace();
//STRIP001 		aPgSize = GetWrtShell().GetAnyCurRect(RECT_PAGE).SSize();
//STRIP001 		if( PD_MIRROR == rDesc.GetUseOn() )
//STRIP001 		{
//STRIP001 			const SvxLRSpaceItem &rLeftLRSpace = rDesc.GetLeft().GetLRSpace();
//STRIP001 			aPgSize.Width() +=
//STRIP001 				Abs( long(rLeftLRSpace.GetLeft()) - long(rLRSpace.GetLeft()) );
//STRIP001 		}
//STRIP001 		aPgSize.Width() += DOCUMENTBORDER * 2;
//STRIP001 	}
//STRIP001 	return GetEditWin().LogicToPixel( aPgSize );
//STRIP001 }


/*N*/ BOOL SwView::UpdateScrollbars()
/*N*/ {
/*N*/     BOOL bRet = FALSE;
/*N*/     if ( !aVisArea.IsEmpty() /*&& (pHScrollbar->IsVisible() || pVScrollbar->IsVisible())*/ )
			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*N*/ 	{
//STRIP001 /*?*/ 		const FASTBOOL bBorder = IsDocumentBorder();
//STRIP001 /*?*/ 		Rectangle aTmpRect( aVisArea );
//STRIP001 /*?*/ 		if ( bBorder )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			Point aPt( DOCUMENTBORDER, DOCUMENTBORDER );
//STRIP001 /*?*/ 			aPt = AlignToPixel( aPt );
//STRIP001 /*?*/ 			aTmpRect.Move( -aPt.X(), -aPt.Y() );
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		Size aTmpSz( aDocSz );
//STRIP001 /*?*/ 		const long lOfst = bBorder ? 0 : DOCUMENTBORDER * 2L;
//STRIP001 /*?*/ 		aTmpSz.Width() += lOfst; aTmpSz.Height() += lOfst;
//STRIP001 /*?*/ 
//STRIP001 /*?*/         {
//STRIP001 /*?*/             const BOOL bVScrollVisible = pVScrollbar->IsVisible(TRUE);
//STRIP001 /*?*/             pVScrollbar->DocSzChgd( aTmpSz );
//STRIP001 /*?*/             pVScrollbar->ViewPortChgd( aTmpRect );
//STRIP001 /*?*/ 
//STRIP001 /*?*/             BOOL bShowButtons = pVScrollbar->IsVisible(TRUE);
//STRIP001 /*?*/             if(pPageUpBtn && pPageUpBtn->IsVisible() != bShowButtons)
//STRIP001 /*?*/             {
//STRIP001 /*?*/                 pPageUpBtn->Show(bShowButtons);
//STRIP001 /*?*/                 if(pPageDownBtn)
//STRIP001 /*?*/                     pPageDownBtn->Show(bShowButtons);
//STRIP001 /*?*/                 if(pNaviBtn)
//STRIP001 /*?*/                     pNaviBtn->Show(bShowButtons);
//STRIP001 /*?*/             }
//STRIP001 /*?*/ 
//STRIP001 /*?*/             if ( bVScrollVisible != pVScrollbar->IsVisible(TRUE) )
//STRIP001 /*?*/                 bRet = TRUE;
//STRIP001 /*?*/         }
//STRIP001 /*?*/         {
//STRIP001 /*?*/             const BOOL bHScrollVisible = pHScrollbar->IsVisible(TRUE);
//STRIP001 /*?*/             pHScrollbar->DocSzChgd( aTmpSz );
//STRIP001 /*?*/             pHScrollbar->ViewPortChgd( aTmpRect );
//STRIP001 /*?*/             if ( bHScrollVisible != pHScrollbar->IsVisible(TRUE) )
//STRIP001 /*?*/                 bRet = TRUE;
//STRIP001 /*?*/             pScrollFill->Show(pHScrollbar->IsVisible(TRUE) && pVScrollbar->IsVisible(TRUE) );
//STRIP001 /*?*/         }
//STRIP001 /*?*/ 	}
/*N*/     return bRet;
/*N*/ }


//STRIP001 void SwView::Move()
//STRIP001 {
//STRIP001 	if ( GetWrtShell().IsInSelect() )
//STRIP001 		GetWrtShell().EndSelect();	//#32427#
//STRIP001 	SfxViewShell::Move();
//STRIP001 }

//STRIP001 BOOL SwView::HandleWheelCommands( const CommandEvent& rCEvt )
//STRIP001 {
//STRIP001 	BOOL bOk = FALSE;
//STRIP001 	const CommandWheelData* pWData = rCEvt.GetWheelData();
//STRIP001 	if( pWData && COMMAND_WHEEL_ZOOM == pWData->GetMode() )
//STRIP001 	{
//STRIP001 		USHORT nFact = pWrtShell->GetViewOptions()->GetZoom();
//STRIP001 		if( 0L > pWData->GetDelta() )
//STRIP001 			nFact = Max( 20, nFact - 10 );
//STRIP001 		else
//STRIP001 			nFact = Min( 600, nFact + 10 );
//STRIP001 
//STRIP001 		SetZoom( SVX_ZOOM_PERCENT, nFact );
//STRIP001 		bOk = TRUE;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		bOk = pEditWin->HandleScrollCommand( rCEvt,
//STRIP001                     pHScrollbar, pVScrollbar);
//STRIP001 	return bOk;
//STRIP001 }


}
