/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_wizpage.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 07:23:03 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

#ifndef _VIRDEV_HXX //autogen
#include <vcl/virdev.hxx>
#endif
#ifndef _WINDOW_HXX //autogen
#include <vcl/window.hxx>
#endif
#ifndef _OUTDEV_HXX //autogen
#include <vcl/outdev.hxx>
#endif
#ifndef _TL_POLY_HXX
#include <tools/poly.hxx>
#endif
#ifndef _VIEWOPT_HXX
#include <viewopt.hxx>
#endif

#ifndef _SWTYPES_HXX
#include <swtypes.hxx>
#endif
#ifndef _WIZPAGE_HXX
#include <wizpage.hxx>
#endif
#ifndef _WIZARD_HRC
#include <wizard.hrc>
#endif
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
namespace binfilter {
////////////////////////////////////////////////////////////////////////////////
// Invalidate fuer's dusselige OS/2
////////////////////////////////////////////////////////////////////////////////

#ifdef PM2 /* Repaint-Fehler unter OS/Daemlich */

void MyInvalidate(Window* pWin, Rectangle aRect)
{
	Size aSizRO=pWin->PixelToLogic(Size(2,2));
	Size aSizLU=pWin->PixelToLogic(Size(1,1));
	aRect.Right ()+=aSizRO.Width();
	aRect.Top   ()-=aSizRO.Height();
	aRect.Left  ()-=aSizLU.Width();
	aRect.Bottom()+=aSizLU.Height();
	pWin->InvalidateForeground(aRect);
}

#else

inline void MyInvalidate(Window* pWin, Rectangle aRect)
{
	pWin->Invalidate(aRect, INVALIDATE_NOERASE );
}

#endif

////////////////////////////////////////////////////////////////////////////////
// WizardPage
////////////////////////////////////////////////////////////////////////////////

WizardPage::WizardPage()
	: SizeX( 0 ), SizeY( 0 )
{
	SetDinA4();
	RandL=25*EINHEIT;
	RandR=20*EINHEIT;
	RandO=10*EINHEIT;
	RandU=10*EINHEIT;
	MapMul=1;
	MapDiv=1;
}

WizardPage::~WizardPage()
{
}

void WizardPage::Draw(OutputDevice& rOut)
{
#ifndef PM2 /* Clipping funkt nich richtig unter OS/Dumm */
	rOut.SetClipRegion(); // Fuer den Schatten
#endif
	double xFakt,yFakt/*,nFakt*/;
	long xMul,xDiv;
	long yMul,yDiv;
	long nMul,nDiv;
	long xSiz,ySiz;
	long xOfs,yOfs;
	Size aSize=rOut.GetOutputSizePixel();
	xSiz=aSize.Width();
	ySiz=aSize.Height();
	xMul=xSiz-16;
	yMul=ySiz-16;
	xDiv=SizeX;
	yDiv=SizeY;
	xFakt=double(xMul)/double(xDiv);
	yFakt=double(yMul)/double(yDiv);
	if (xFakt<yFakt) { /*nFakt=xFakt;*/ nMul=xMul; nDiv=xDiv; }
	else { /*nFakt=yFakt;*/ nMul=yMul; nDiv=yDiv; }
	Fraction aScale(nMul,nDiv);
	xSiz=((xSiz-1)*nDiv)/nMul;
	ySiz=((ySiz-1)*nDiv)/nMul; // Outputgroesse in 1/10mm
	xOfs=(xSiz-SizeX)/2;
	yOfs=(ySiz-SizeY)/2;
	MapMul=nMul;
	MapDiv=nDiv;
	long nPixWdt=nDiv/nMul;
	MapMode aMap(/*MAP_10TH_MM*/MAP_PIXEL,Point(short(xOfs),short(yOfs)),aScale,aScale);
	rOut.SetMapMode(aMap);

	const StyleSettings& rStyleSettings = Application::GetSettings().GetStyleSettings();
	const Color& rWinColor = rStyleSettings.GetWindowColor();

    rOut.SetLineColor(SwViewOption::GetFontColor());
	rOut.DrawLine(Point((SizeX+nPixWdt),(nPixWdt)),Point((SizeX+nPixWdt),(SizeY+nPixWdt)));
	rOut.DrawLine(Point((nPixWdt),(SizeY+nPixWdt)),Point((SizeX+nPixWdt),(SizeY+nPixWdt)));

	rOut.SetFillColor(rWinColor);
	rOut.SetLineColor(rStyleSettings.GetShadowColor());
	rOut.DrawRect(Rectangle(0,0,(SizeX),(SizeY)));

	rOut.SetLineColor(rStyleSettings.GetLightBorderColor());
	rOut.SetFillColor(Color(COL_TRANSPARENT));
	rOut.DrawRect(Rectangle(RandL,RandO,(SizeX-RandR),(SizeY-RandU)));
#ifndef PM2 /* Clipping funkt nich richtig unter OS/Dumm */
	rOut.SetClipRegion(Rectangle(0,0,SizeX,SizeY));
#endif
}

void WizardPage::DrawBaseText(OutputDevice& rOut, USHORT nWortAnz)
{
static long __READONLY_DATA aWords_[40]={20,18,9,30,8,31,26,20,16,5,21,10,31,8,28,23,13,22,12,0,25,20,26,12,21,10,26,14,21,24,28,8,24,12,20,26,6,10,25,0};
	MapMode aMapMerk=rOut.GetMapMode();
	long aWords[40];
//	rOut.SetPen(Pen(PEN_NULL));
//	Brush aBrs=Brush(Color(COL_BLACK),BRUSH_50);
//	aBrs.SetTransparent(TRUE);
	const StyleSettings& rStyleSettings = Application::GetSettings().GetStyleSettings();
	rOut.SetFillColor(rStyleSettings.GetShadowColor());

	long nLH;    // Zeilenhoehe   (Pixel)
	long nLF;    // Zeilenabstand (Pixel)
	long nWD;    // Wortabstand (Pixel)
	Point aP;
	Size  aS;
	USHORT i,j;

	// Zeilenhoehe mind 2 Pixel, Zwischenraum mind. 1 Pixel
	// Immer 1 Pixel drauf, weil DrawRect() inkl malt.
	nLH=4*EINHEIT; // 4mm=ca 11.3Pt
	nLH=rOut.LogicToPixel(Size(0,nLH)).Height(); // LH nun in Pixel
	if (nLH<1) nLH=1;         // mind 2 Pixel
	nLF=nLH*12/10;            // 120% LineFeed
	if (nLF<nLH+2) nLF=nLH+2; // mind 1 Pixel dazwischen
	nWD=nLH*8/10;             // 80% Wortdistanz
	if (nWD<3) nLF=nLH+3;     // jedoch mind 2 Pixel

	for (i=0; i<40; i++) { // Wortbreiten nach Pixel
		aWords[i]=aWords_[i]*EINHEIT;
		aWords[i]=rOut.LogicToPixel(Size(aWords[i],0)).Width();
	}

	aS=Size(short(SizeX-RandL-RandR),short(SizeY-RandO-RandU));
	aS=rOut.LogicToPixel(aS);
	long nWdt=aS.Width();   // Groesse des Bereichs zwischen
	long nHgt=aS.Height();  // den Raendern in Pixel
	aP=Point(short(RandL),short(RandO));
	aP=rOut.LogicToPixel(aP);
	MapMode aMap(MAP_PIXEL,aP,Fraction(1,1),Fraction(1,1));
	rOut.SetMapMode(aMap);

	BOOL bWeiter=TRUE;
	long xp;
	long yp=0;
	i=0; j=0;
	long nWord;
	nWord=aWords[i++];
	while (yp<nHgt && bWeiter) {
		xp=0;
		do {
			if (nWord>0) {
				long x2=xp+nWord;
				long y2=yp+nLH;
				if (x2>nWdt) x2=nWdt;
				if (y2<nHgt) { // Keine halben Buchstaben malen
					rOut.DrawRect(Rectangle(xp,yp,x2,y2));
				}
				xp+=nWord+nWD;
				if (i>=40) i=0;
			} else {
				xp=nWdt+1;   // Absatzende
				yp+=nLF-nLH; // Etwas mehr Abstand am Absatzende
			}
			nWord=aWords[i++];
			j++;
			bWeiter=j<nWortAnz;
		} while (xp+nWord<nWdt && bWeiter);
		yp+=nLF;
	}
	rOut.SetMapMode(aMapMerk);
}

void WizardPage::SetRandO(USHORT nRand, Window* pWin)
{
	nRand=USHORT(Min(long(nRand),long(SizeY-RandU-10*EINHEIT))); // Begrenzen
	if( long(nRand) != RandO )
	{
		if( pWin )
		{
			long y1 = long( Min( USHORT(RandO), nRand ) ),
				y2 = RandU;
			RandO = nRand;
			MyInvalidate(pWin,Rectangle( RandL, y1, SizeX-RandR, SizeY-y2 ));
		}
		else
			RandO = nRand;
	}
}

void WizardPage::SetRandU(USHORT nRand, Window* pWin)
{
	nRand=USHORT(Min(long(nRand),long(SizeY-RandO-10*EINHEIT))); // Begrenzen
	if (long(nRand)!=RandU)
	{
		if( pWin )
		{
			long y1 = RandO,
				 y2 = long( Min( USHORT( RandU ), nRand ));
			RandU = nRand;
			MyInvalidate( pWin, Rectangle(RandL,y1,SizeX-RandR,SizeY-y2) );
		}
		else
			RandU = nRand;
	}
}

void WizardPage::SetRandL(USHORT nRand, Window* pWin)
{
	nRand=USHORT(Min(long(nRand),long(SizeX-RandR-10*EINHEIT))); // Begrenzen
	if( long(nRand)!=RandL )
	{
		if( pWin )
		{
			long x1 = long(Min(USHORT(RandL),nRand)),
				 x2 = RandR;
			RandL=nRand;
			MyInvalidate(pWin,Rectangle(x1,RandO,SizeX-x2,SizeY-RandU));
		}
		else
			RandL=nRand;
	}
}

void WizardPage::SetRandR(USHORT nRand, Window* pWin)
{
	nRand=USHORT(Min(long(nRand),long(SizeX-RandL-10*EINHEIT))); // Begrenzen
	if (long(nRand)!=RandR)
	{
		if( pWin )
		{
			long x1 = RandL,
				 x2 = long( Min( USHORT(RandR), nRand ));
			RandR=nRand;
			MyInvalidate( pWin, Rectangle( x1, RandO, SizeX-x2, SizeY-RandU ));
		}
		else
			RandR=nRand;
	}
}

void WizardPage::SetWdt(USHORT nWdt, Window* pWin)
{
	if( nWdt != USHORT( SizeX ) )
	{
		SizeX = nWdt;
		if( pWin )
			pWin->Invalidate();
	}
}

void WizardPage::SetHgt(USHORT nHgt, Window* pWin)
{
	if( nHgt != USHORT( SizeY ) )
	{
		SizeY=nHgt;
		if( pWin )
			pWin->Invalidate();
	}
}

////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////

void DrawEckRect(OutputDevice& rOut, short x1, short y1, short x2, short y2)
{
	rOut.DrawLine(Point(x1,y1),Point(x1+5*EINHEIT,y1));
	rOut.DrawLine(Point(x1,y1),Point(x1,y1+5*EINHEIT));
	rOut.DrawLine(Point(x2-5*EINHEIT,y1),Point(x2,y1));
	rOut.DrawLine(Point(x2,y1),Point(x2,y1+5*EINHEIT));
	rOut.DrawLine(Point(x1,y2-5*EINHEIT),Point(x1,y2));
	rOut.DrawLine(Point(x1,y2),Point(x1+5*EINHEIT,y2));
	rOut.DrawLine(Point(x2,y2-5*EINHEIT),Point(x2,y2));
	rOut.DrawLine(Point(x2-5*EINHEIT,y2),Point(x2,y2));
}

////////////////////////////////////////////////////////////////////////////////
// WizardFrame
////////////////////////////////////////////////////////////////////////////////

WizardFrame::WizardFrame()
{
	pPage=NULL;
	bGemerkt=FALSE;
	PosX=0;
	PosY=0;
	SizX=0;
	SizY=0;
	RandL=25*EINHEIT;
	RandR=20*EINHEIT;
	RandO=10*EINHEIT;
	RandU=10*EINHEIT;
	bIsDa=TRUE;
	b2ndHide=FALSE;
	bFill=FALSE;
	bText=FALSE;
	bFram=TRUE;
	eAlign=ALIGN_Null;
}

void WizardFrame::SetPage(WizardPage* pPg)
{ pPage=pPg; KorregPos(); }

void WizardFrame::DrawFrame(OutputDevice& rOut, BOOL bFillIt)
{
	short x1=short(PosX);
	short x2=short(PosX+SizX);
	short y1=short(PosY);
	short y2=short(PosY+SizY);

	const StyleSettings& rStyleSettings = Application::GetSettings().GetStyleSettings();
	rOut.SetLineColor(rStyleSettings.GetShadowColor());
	if (bFillIt)
		rOut.SetFillColor(rStyleSettings.GetLightBorderColor());
	else
		rOut.SetFillColor(Color(COL_TRANSPARENT));
	rOut.DrawRect(Rectangle(x1,y1,x2,y2));
}

void WizardFrame::Draw(OutputDevice& rOut)
{
	if (IsVisible()) {
		/*short x1=short(PosX);
		short x2=short(PosX+SizX);
		short y1=short(PosY);
		short y2=short(PosY+SizY);*/
		if (bFram) DrawFrame(rOut,FALSE);
		if (bFill) DrawFrame(rOut,TRUE);
	}
}

void WizardFrame::SetAlign(PageAlign eNeuAlign, Window* pWin)
{
	MerkePos();
	eAlign=eNeuAlign;
	if (pPage!=NULL) {
		switch (eNeuAlign) {
			case ALIGN_LiOb: {
				PosX=RandL;
				PosY=RandO;
			} break;
			case ALIGN_MiOb: {
				PosX=(pPage->SizeX-SizX)/2;
				PosY=RandO;
			} break;
			case ALIGN_ReOb: {
				PosX=pPage->SizeX-RandR-SizX;
				PosY=RandO;
			} break;
			case ALIGN_LiUn: {
				PosX=RandL;
				PosY=pPage->SizeY-RandU-SizY;
			} break;
			case ALIGN_ReUn: {
				PosX=pPage->SizeX-RandR-SizX;
				PosY=pPage->SizeY-RandU-SizY;
			} break;
			case ALIGN_Mitt: {
				PosX=pPage->SizeX-RandR-SizX;
				PosY=55*EINHEIT;
			} break;
			case ALIGN_LiMg: {
				PosX=RandL;
			} break;
			case ALIGN_ReMg: {
				PosX=pPage->SizeX-RandR-SizX;
			} break;
		}
	}
	CheckInvalidate(pWin);
}

void WizardFrame::KorregPos(Window* pWin)
{ MerkePos(); SetAlign(eAlign,pWin); }

void WizardFrame::SetSiz(USHORT nWdt, USHORT nHgt, Window* pWin)
{
	SetWdt(nWdt,pWin);
	SetHgt(nHgt,pWin);
}

void WizardFrame::SetWdt(USHORT nWdt, Window* pWin)
{ MerkePos(); SizX=nWdt; KorregPos(pWin); }

void WizardFrame::SetHgt(USHORT nHgt, Window* pWin)
{ MerkePos(); SizY=nHgt; KorregPos(pWin); }

void WizardFrame::SetRandL(USHORT nRand, Window* pWin)
{ MerkePos(); RandL=nRand; KorregPos(pWin); }

void WizardFrame::SetRandR(USHORT nRand, Window* pWin)
{ MerkePos(); RandR=nRand; KorregPos(pWin); }

USHORT WizardFrame::GetWdt() { return USHORT(SizX); } // virtuell
USHORT WizardFrame::GetHgt() { return USHORT(SizY); } // virtuell

void WizardFrame::MerkePos()
{ if (!bGemerkt) { PosX0=PosX; PosY0=PosY; SizX0=SizX; SizY0=SizY; bGemerkt=TRUE; } }

void WizardFrame::CheckInvalidate(Window* pWin)
{
	if (bGemerkt) {
		bGemerkt=FALSE;
		if (pWin!=NULL && (PosX!=PosX0 || PosY!=PosY0 || SizX!=SizX0 || SizY!=SizY0)) {
			MyInvalidate(pWin,Rectangle(short(PosX0),short(PosY0),short(PosX0+SizX0),short(PosY0+SizY0)));
			Invalidate(pWin);
			//MyInvalidate(pWin,Rectangle(short(PosX),short(PosY),short(PosX+SizX),short(PosY+SizY)));
		}
	}
}

void WizardFrame::SetHor(USHORT nRand, Window* pWin)
{
	MerkePos();
	if (IsLks()) RandL=nRand;
	if (IsRts()) RandR=nRand;
	KorregPos(pWin);
}

void WizardFrame::SetVer(USHORT nRand, Window* pWin)
{
	MerkePos();
	if (IsObn()) RandO=nRand;
	if (IsUnt()) RandU=nRand;
	KorregPos(pWin);
}

USHORT WizardFrame::GetHor() { if (IsLks()) return(USHORT(RandL)); if (IsRts()) return(USHORT(RandR)); return(0); }
USHORT WizardFrame::GetVer() { if (IsObn()) return(USHORT(RandO)); if (IsUnt()) return(USHORT(RandU)); return(0); }

BOOL WizardFrame::IsLks() { return(eAlign==ALIGN_LiOb || eAlign==ALIGN_LiUn || eAlign==ALIGN_LiMg); }
BOOL WizardFrame::IsRts() { return(eAlign==ALIGN_ReOb || eAlign==ALIGN_ReUn || eAlign==ALIGN_Mitt); }
BOOL WizardFrame::IsObn() { return(eAlign==ALIGN_ReOb || eAlign==ALIGN_MiOb || eAlign==ALIGN_LiOb); }
BOOL WizardFrame::IsUnt() { return(eAlign==ALIGN_LiUn || eAlign==ALIGN_ReUn || eAlign==ALIGN_ReMg); }

BOOL WizardFrame::GetHorStr(String& rStr)
{
	if (IsLks()) rStr=SW_RESSTR(STR_Pag_VonLinks);
	else if (IsRts()) rStr=SW_RESSTR(STR_Pag_VonRecht);
	else return FALSE;
	return TRUE;
}

BOOL WizardFrame::GetVerStr(String& rStr)
{
	if (IsObn()) rStr=SW_RESSTR(STR_Pag_VonOOben);
	else if (IsUnt()) rStr=SW_RESSTR(STR_Pag_VonUnten);
	else return FALSE;
	return TRUE;
}

void WizardFrame::Show(Window* pWin, BOOL bOn) { if (bOn!=bIsDa) { bIsDa=bOn; Invalidate(pWin); } }
void WizardFrame::Hide(Window* pWin) { if (bIsDa) { bIsDa=FALSE; Invalidate(pWin); } }

void WizardFrame::Invalidate(Window* pWin)
{ if (pWin!=NULL) MyInvalidate(pWin,Rectangle(short(PosX),short(PosY),short(PosX+SizX),short(PosY+SizY))); }

void WizardFrame::SetPosX(long nPosX, Window* pWin)
{ MerkePos(); eAlign=ALIGN_Null; PosX=nPosX; KorregPos(pWin); }

void WizardFrame::SetPosY(long nPosY, Window* pWin)
{ MerkePos(); eAlign=ALIGN_Null; PosY=nPosY; KorregPos(pWin); }

void WizardFrame::Set2ndHide(BOOL bHide, Window* pWin)
{
	BOOL bMerk=IsVisible();
	b2ndHide=bHide;
	if (IsVisible()!=bMerk) Invalidate(pWin);
}

////////////////////////////////////////////////////////////////////////////////
// WizardLogo
////////////////////////////////////////////////////////////////////////////////

void Transform(Polygon& rPoly, long dx, long dy, long xMul, long yMul, long xDiv, long yDiv)
{
	USHORT nAnz=rPoly.GetSize();
	USHORT i;
	for( i = 0; i < nAnz; ++i )
	{
		Point aPnt=rPoly.GetPoint(i);
		long x=aPnt.X();
		long y=aPnt.Y();
		x= x * xMul / xDiv + dx;
		y= y * yMul / yDiv + dy;
		aPnt.X()= short(x);
		aPnt.Y()= short(y);
		rPoly.SetPoint(aPnt,i);
	}
}

void GetDefaultLogo(PolyPolygon& rPoly, long PosX, long PosY, long SizX, long SizY)
{   // Wer hier rumpfuscht kriegt maechtigen Aerger!
	Polygon aPoly(21);
	aPoly.SetPoint(Point( 0*8,0*8  ), 0);
	aPoly.SetPoint(Point(19*8,0*8  ), 1);
	aPoly.SetPoint(Point(19*8,1*8  ), 2);
	aPoly.SetPoint(Point(14*8,1*8  ), 3);
	aPoly.SetPoint(Point(14*8,4*8  ), 4);
	aPoly.SetPoint(Point(19*8,4*8  ), 5);
	aPoly.SetPoint(Point(19*8,5*8  ), 6);
	aPoly.SetPoint(Point(13*8,5*8  ), 7);
	aPoly.SetPoint(Point(13*8,1*8  ), 8);
	aPoly.SetPoint(Point(10*8,1*8  ), 9);
	aPoly.SetPoint(Point(10*8,2*8+6),10);
	aPoly.SetPoint(Point( 9*8,2*8+6),11);
	aPoly.SetPoint(Point( 9*8,1*8  ),12);
	aPoly.SetPoint(Point( 6*8,1*8  ),13);
	aPoly.SetPoint(Point( 6*8,5*8  ),14);
	aPoly.SetPoint(Point( 0*8,5*8  ),15);
	aPoly.SetPoint(Point( 0*8,4*8  ),16);
	aPoly.SetPoint(Point( 5*8,4*8  ),17);
	aPoly.SetPoint(Point( 5*8,1*8  ),18);
	aPoly.SetPoint(Point( 0*8,1*8  ),19);
	aPoly.SetPoint(Point( 0*8,0*8  ),20);
	for (USHORT i=0; i<21; i++) {  // Skalieren, Verschieben
		Point aP=aPoly.GetPoint(i);
		aP=Point(short(PosX+long(aP.X())*SizX/(19*8)),
				 short(PosY+long(aP.Y())*SizY/( 5*8)));
		aPoly.SetPoint(aP,i);
	}
	rPoly=PolyPolygon(aPoly);
}

void GetLogoLetter(char c, Polygon& rPoly1, Polygon& rPoly2, USHORT& rWdt, USHORT& rHgt, short xOfs=0)
{
	rWdt=0;
	rHgt=8;
	rPoly1.Clear();
	rPoly2.Clear();
	switch (c) {
		case 'M': {
			rPoly1.SetSize(13);
			rPoly1.SetPoint(Point(0,0), 0);
			rPoly1.SetPoint(Point(2,0), 1);
			rPoly1.SetPoint(Point(4,2), 2);
			rPoly1.SetPoint(Point(6,0), 3);
			rPoly1.SetPoint(Point(8,0), 4);
			rPoly1.SetPoint(Point(8,8), 5);
			rPoly1.SetPoint(Point(6,8), 6);
			rPoly1.SetPoint(Point(6,3), 7);
			rPoly1.SetPoint(Point(4,5), 8);
			rPoly1.SetPoint(Point(2,3), 9);
			rPoly1.SetPoint(Point(2,8),10);
			rPoly1.SetPoint(Point(0,8),11);
			rPoly1.SetPoint(Point(0,0),12);
			rWdt=8;
		} break;
		case 'E': {
			rPoly1.SetSize(13);
			rPoly1.SetPoint(Point(0,0), 0);
			rPoly1.SetPoint(Point(6,0), 1);
			rPoly1.SetPoint(Point(6,2), 2);
			rPoly1.SetPoint(Point(2,2), 3);
			rPoly1.SetPoint(Point(2,3), 4);
			rPoly1.SetPoint(Point(5,3), 5); // evtl 4,3
			rPoly1.SetPoint(Point(5,5), 6); //      4,5
			rPoly1.SetPoint(Point(2,5), 7);
			rPoly1.SetPoint(Point(2,6), 8);
			rPoly1.SetPoint(Point(6,6), 9);
			rPoly1.SetPoint(Point(6,8),10);
			rPoly1.SetPoint(Point(0,8),11);
			rPoly1.SetPoint(Point(0,0),12);
			rWdt=6;
		} break;
		case 'O': {
			rPoly1.SetSize(9);
			rPoly2.SetSize(5);
			rPoly1.SetPoint(Point(0,1), 0);
			rPoly1.SetPoint(Point(1,0), 1);
			rPoly1.SetPoint(Point(5,0), 2);
			rPoly1.SetPoint(Point(6,1), 3);
			rPoly1.SetPoint(Point(6,7), 4);
			rPoly1.SetPoint(Point(5,8), 5);
			rPoly1.SetPoint(Point(1,8), 6);
			rPoly1.SetPoint(Point(0,7), 7);
			rPoly1.SetPoint(Point(0,1), 8);
			rPoly2.SetPoint(Point(2,2), 0);
			rPoly2.SetPoint(Point(4,2), 1);
			rPoly2.SetPoint(Point(4,6), 2);
			rPoly2.SetPoint(Point(2,6), 3);
			rPoly2.SetPoint(Point(2,2), 4);
			rWdt=6;
		} break;
	}
	if (xOfs!=0)
	{
		USHORT i;
		USHORT nAnz;
		nAnz=rPoly1.GetSize();
		for (i=0; i<nAnz; i++)
			rPoly1[i].X()+=xOfs;
		nAnz=rPoly2.GetSize();
		for (i=0; i<nAnz; i++)
			rPoly2[i].X()+=xOfs;
	}
}

/*void PolyPolyAdd(PolyPolygon& rPoly, const PolyPolygon& rDazu)
{
	USHORT nAnz=rDazu.Count();
	USHORT i;
	for (i=0; i<nAnz; i++) {
		Polygon aPoly(rDazu.GetObject(i));
		rPoly.Insert(aPoly);
	}
}*/

void GetMemoLogo(PolyPolygon& rPoly, long PosX, long PosY, long SizX, long SizY)
{
	Polygon aPoly1,aPoly2,aPoly3,aPoly4,aPoly5;
	USHORT nPos=0;
	USHORT nWdt,nHgt;

	GetLogoLetter('M',aPoly1,aPoly5,nWdt,nHgt);
	nPos+=nWdt;

	nPos+=2;
	GetLogoLetter('E',aPoly2,aPoly5,nWdt,nHgt,nPos);
	nPos+=nWdt;

	nPos+=2;
	GetLogoLetter('M',aPoly3,aPoly5,nWdt,nHgt,nPos);
	nPos+=nWdt;

	nPos+=2;
	GetLogoLetter('O',aPoly4,aPoly5,nWdt,nHgt,nPos);
	nPos+=nWdt;

	Transform(aPoly1,PosX,PosY,SizX,SizY,nPos,nHgt);
	Transform(aPoly2,PosX,PosY,SizX,SizY,nPos,nHgt);
	Transform(aPoly3,PosX,PosY,SizX,SizY,nPos,nHgt);
	Transform(aPoly4,PosX,PosY,SizX,SizY,nPos,nHgt);
	Transform(aPoly5,PosX,PosY,SizX,SizY,nPos,nHgt);
	rPoly.Insert(aPoly1);
	rPoly.Insert(aPoly2);
	rPoly.Insert(aPoly3);
	rPoly.Insert(aPoly4);
	rPoly.Insert(aPoly5);
}

WizardLogo::WizardLogo()
{
	bTextLogo=FALSE;
    bAsLink = FALSE;
    bGrfFlag=FALSE;
	SetFit(TRUE);
	SetStyle(TEXT_FitSiz|TEXT_JstCnt);
	SetDefStr(SW_RESSTR(STR_Pag_DefsLogo));
	SetStrVisi();
	bMemoTitl=FALSE;
	bAgenGraf=FALSE;
}

void WizardLogo::Draw(OutputDevice& rOut)
{
	if (IsVisible()) {
		if (bTextLogo) {
			WizardText::Draw(rOut);
		} else {
			if (bGrfFlag && aGrfFNam.Len()!=0 && FALSE) {
				// aGrf.Draw(&rOut,Point(short(PosX),short(PosY)),Size(short(SizX),short(SizY)));
			} else { // ansonsten eine Defaultgrafik
				PolyPolygon aPoly(1);
				if (bMemoTitl) {
					GetMemoLogo(aPoly,PosX,PosY,SizX,SizY);
				} else {
					GetDefaultLogo(aPoly,PosX,PosY,SizX,SizY);
				}
				const StyleSettings& rStyleSettings = Application::GetSettings().GetStyleSettings();
				rOut.SetLineColor(rStyleSettings.GetShadowColor());
				rOut.SetFillColor(rStyleSettings.GetLightBorderColor());
				rOut.DrawPolyPolygon(aPoly);
			}
		}
	}
}

void WizardLogo::SetModeGraf(Window* pWin, BOOL bJa) { bTextLogo=!bJa; Invalidate(pWin); }
void WizardLogo::SetModeText(Window* pWin, BOOL bJa) { bTextLogo=bJa;  Invalidate(pWin); }

void WizardLogo::SetGraphic(
    const String& rFNam, const String& rFilt, BOOL bLink)
{
	aGrfFNam=rFNam;
	aGrfFilt=rFilt;
    bAsLink = bLink;
	bGrfFlag=TRUE;
}

USHORT WizardLogo::GetLogoTextHgt()
{
	USHORT tHgt=GetTextHgt(aFont,GetStr(),short(SizX),short(SizY),TEXT_FitSiz);
	return tHgt;
}

////////////////////////////////////////////////////////////////////////////////
// WizardText
////////////////////////////////////////////////////////////////////////////////

USHORT CountLines(const String& rStr)
{
	USHORT nCnt = 1;
	xub_StrLen nPos = 0;
	while( STRING_NOTFOUND != ( nPos = rStr.SearchAscii( NEWLINE, nPos )))
	{
		nPos += sizeof( NEWLINE ) - 1;
		++nCnt;
	}
	return nCnt;
}

String GetLine(const String& rStr, USHORT nNum ) // Num=0 ist die erste Zeile
{
	USHORT nCnt = 0;
	xub_StrLen nPrevPos = 0, nPos;
	while( STRING_NOTFOUND != ( nPos = rStr.SearchAscii( NEWLINE, nPrevPos ))
			&& nCnt != nNum )
	{
		nPrevPos = nPos + sizeof( NEWLINE ) - 1;
		++nCnt;
	}
	String sRet;
	if( nCnt == nNum )
		sRet = rStr.Copy( nPrevPos, nPos - nPrevPos );
	return sRet;
}


WizardText::WizardText()
{
	bFram=FALSE;
	bFill=TRUE;
	bText=TRUE;
    aFont = OutputDevice::GetDefaultFont( DEFAULTFONT_SANS_UNICODE, GetAppLanguage(),
                                        DEFAULTFONT_FLAGS_ONLYONE );
    aFont.SetTransparent(TRUE);
	nLineFeed=5*EINHEIT;
	aFont.SetSize(Size(0,nLineFeed));
	bStrVisi=FALSE;
	bStrGrow=FALSE;
	nFramHgt=0;
	nStyle=0;
	nLnDazu=0;
}

WizardText::~WizardText()
{
}


USHORT WizardText::GetTextHgt(const Font& rFont, const String& rStr, short w, short h, USHORT Style)
{
	USHORT LnAnz=CountLines(rStr);
	BOOL   bDscr=((Style & TEXT_FrDscr)!=0);
	BOOL   bFitS=((Style & TEXT_FitSiz)!=0);
	if (h>10*EINHEIT) {
		h-=4*EINHEIT;  // Etwas Rand, bitte
		if (h<10*EINHEIT) h=10*EINHEIT;
	}
	long tHgt=aFont.GetSize().Height(); // Schrifthoehe
	if (tHgt>h) tHgt=h;
	//short x1=0; // Offset zum Rahmen
	//short y1=0; // Offset zum Rahmen
	if (bFitS || bDscr) {
		long nSiz=h/LnAnz;
		if (nSiz<EINHEIT) nSiz=EINHEIT;        // mind. 1mm
		if (bDscr) nSiz=Min(nSiz,long(12*EINHEIT));  // max 12mm fuer Dscr
		tHgt=nSiz;
	}
	if (bFitS) {
		VirtualDevice aVD;
		Font aFont=rFont;
		aFont.SetSize(Size(0,short(tHgt)));
		aVD.SetFont(aFont);
		long nMax=0;
		for (USHORT i=0; i<LnAnz; i++) {
			String aStr=GetLine(rStr,i);
			long nWidth = aVD.GetTextWidth(aStr);
			if (nWidth>nMax)
				nMax=nWidth;
		}
		if (nMax>w) tHgt=tHgt*w/nMax;
	}
	if (tHgt<EINHEIT) tHgt=EINHEIT;        // mind. 1mm
	return USHORT(tHgt);
}

void WizardText::DrawText(OutputDevice& rOut, const String& rStr, short x, short y, short w, short h, USHORT Style)
{
#ifndef PM2 /* Clipping funkt nich richtig unter OS/Dumm */
	Region aRegion=rOut.GetClipRegion();
	rOut.IntersectClipRegion(Rectangle(short(x),short(y),short(x+w),short(y+h)));
#endif
	Font   aFontMerk = rOut.GetFont();
	USHORT LnAnz = CountLines( rStr );
	BOOL   bDscr=((Style & TEXT_FrDscr)!=0);
	BOOL   bFitS=((Style & TEXT_FitSiz)!=0);
	BOOL   bJCnt=((Style & TEXT_JstCnt)!=0);
	BOOL   bJRgt=((Style & TEXT_JstRgt)!=0);
	BOOL   bJHCn=bDscr || bFitS;              // Vertikal zentrieren ?
	if (bDscr)
		bJCnt =  TRUE;
	if (bJCnt)
		bJRgt = FALSE;
	USHORT tHgt = nLineFeed;
	if( bFitS || bDscr )
		tHgt = GetTextHgt(aFont,rStr,w,h,Style);

	long x1 = 0; // Offset zum Rahmen
	long y1 = 0; // Offset zum Rahmen
	if (bJHCn)
		y1 = (h - tHgt * LnAnz) / 2;     // Vertikal zentrieren.
	aFont.SetSize( Size( 0, tHgt ));
	rOut.SetFont( aFont );
	for (USHORT i=0; i<LnAnz; i++)
	{
		String aStr=GetLine(rStr,i);
		if( bJCnt || bJRgt )
		{
			x1 = w - rOut.GetTextWidth( aStr );
			if( bJCnt )
				x1 /= 2;
		}
		rOut.DrawText( Point( x + x1, y + y1 ), aStr );
		y1 += tHgt;
	}
#ifndef PM2 /* Clipping funkt nich richtig unter OS/Dumm */
	rOut.SetClipRegion(aRegion);
#endif
	rOut.SetFont( aFontMerk );
}

void WizardText::Draw(OutputDevice& rOut)
{
	if (IsVisible()) {
		//USHORT nFlags=0;
		//if (bRgt) nFlags|=TEXT_JstRgt;
		if (bStrVisi && aStr.Len()!=0) {
			WizardFrame::DrawFrame(rOut,FALSE);
			//if (bFitS) nFlags|=TEXT_FitSiz;
			const StyleSettings& rStyleSettings = Application::GetSettings().GetStyleSettings();
            aFont.SetColor(SwViewOption::GetFontColor());
			DrawText(rOut,aStr,short(PosX),short(PosY),short(SizX),short(SizY),nStyle);
		} else {
			WizardFrame::DrawFrame(rOut,TRUE);
			if (aDefStr.Len()!=0) {
				const StyleSettings& rStyleSettings = Application::GetSettings().GetStyleSettings();
				aFont.SetColor(rStyleSettings.GetWindowColor());
				DrawText(rOut,aDefStr,short(PosX),short(PosY),short(SizX),short(SizY),TEXT_FrDscr);
			}
		}
	}
}

void WizardText::SetStr(const String& rStr, Window* pWin)
{
	if (aStr!=rStr) {
		aStr=rStr;
		KorregGrowHgt(pWin);
		if (bStrVisi) Invalidate(pWin);
	}
}

void WizardText::SetStyle(USHORT nStl, Window* pWin)
{
	if (nStl!=nStyle) {
		nStyle=nStl;
		if (bStrVisi) Invalidate(pWin);
	}
}

void WizardText::SetStrVisi(BOOL bVisi, Window* pWin)
{
	if (bVisi!=bStrVisi) {
		bStrVisi=bVisi;
		if (aStr.Len()!=0) Invalidate(pWin);
	}
}

void WizardText::SetGrowOnStr(BOOL bGrow, Window* pWin)
{
	if (bGrow!=bStrGrow) {
		bStrGrow=bGrow;
		KorregGrowHgt(pWin);
	}
}

void WizardText::KorregGrowHgt(Window* pWin)
{
	if (!bStrGrow && nFramHgt==0) nFramHgt=SizY; // Wegen der Faxfusszeile
	USHORT nHgt=USHORT(nFramHgt);
	if (bStrGrow) {
		USHORT n2=nLineFeed*(nLnDazu+CountLines(aStr));
		if (n2>nHgt) nHgt=n2;
	}
	WizardFrame::SetHgt(nHgt,pWin);
}

void WizardText::SetHgt(USHORT nHgt, Window* pWin)
{
	nFramHgt=nHgt;
	KorregGrowHgt(pWin);
}

void WizardText::SetLnDazu(USHORT nNum, Window* pWin)
{
	nLnDazu=nNum;
	KorregGrowHgt(pWin);
}

USHORT WizardText::GetHgt() // Virtuell
{
	return USHORT(SizY);
	//return USHORT(nFramHgt);
}

////////////////////////////////////////////////////////////////////////////////
// WizardAbsn
////////////////////////////////////////////////////////////////////////////////

WizardAbsn::WizardAbsn()
{
	SetDefStr(SW_RESSTR(STR_Pag_DefsAbsn));
}

////////////////////////////////////////////////////////////////////////////////
// WizardEmpf
////////////////////////////////////////////////////////////////////////////////

WizardEmpf::WizardEmpf()
{
	bShowAbsn=TRUE;
	PosX=25*EINHEIT;
	PosY=55*EINHEIT;
	SetWdt(75*EINHEIT);
	SetHgt(35*EINHEIT);
	//bFill=TRUE;
	//bText=TRUE;
	SetDefStr(SW_RESSTR(STR_Pag_DefsEmpf));
	aAbsnDefStr=SW_RESSTR(STR_Pag_DefsAbsn);
}
/*
	Paint the addressee.
*/
void WizardEmpf::Draw(OutputDevice& rOut)
{
	//WizardFrame::Draw(rOut);
	if (IsVisible()) {
		short x1=short(PosX);
		short x2=short(PosX+SizX);
		short y1=short(PosY);
		short y2=short(PosY+SizY);
		const StyleSettings& rStyleSettings = Application::GetSettings().GetStyleSettings();

		const Color& rColor = rStyleSettings.GetLightBorderColor();
		rOut.SetLineColor(rColor);
		DrawEckRect(rOut,x1-5*EINHEIT,y1-5*EINHEIT,x2+5*EINHEIT,y2+5*EINHEIT);
		rOut.SetLineColor(rStyleSettings.GetShadowColor());
		rOut.SetFillColor(rColor);
		if (bShowAbsn || TRUE)
			y1+=5*EINHEIT;
		rOut.DrawRect(Rectangle(x1,y1,x2,y2));
		aFont.SetColor(rStyleSettings.GetWindowColor());
		DrawText(rOut,GetDefStr(),short(x1),short(y1),short(x2-x1),short(y2-y1),TEXT_FrDscr);
		if (bShowAbsn) {
			y1-=5*EINHEIT;
			y2=y1+2*EINHEIT+EINHEIT/2;
// JP 06.10.95: Bug 20511: vollst. Absender uebern Empfaengerfeld nicht ausgeben
//            if (aAbsnStr.Len()==0) {
				rOut.DrawRect(Rectangle(x1,y1,x2,y2));
				aFont.SetColor(rStyleSettings.GetWindowColor());
				DrawText(rOut,aAbsnDefStr,short(x1),short(y1),short(x2-x1),short(y2-y1),TEXT_FrDscr);
/*            } else {
				rOut.DrawRect(Rectangle(x1,y1,x2,y2),FALSE);
				aFont.SetColor(Color(COL_BLACK));
				DrawText(rOut,aAbsnStr,short(x1),short(y1),short(x2-x1),short(y2-y1),TEXT_JstCnt);
			}
*/
		}
	}
}

void WizardEmpf::ShowAbsn(Window* pWin, BOOL bOn)
{ if (bOn!=bShowAbsn) { bShowAbsn=bOn; Invalidate(pWin); } }

void WizardEmpf::Invalidate(Window* pWin)
{ if (pWin!=NULL) MyInvalidate(pWin,Rectangle(short(PosX-5*EINHEIT),short(PosY-5*EINHEIT),short(PosX+SizX+5*EINHEIT),short(PosY+SizY+5*EINHEIT))); }

void WizardEmpf::SetAbsnStr(String& rStr, Window* pWin)
{
	aAbsnStr=aEmptyStr;
	USHORT n=CountLines(rStr);
	USHORT i;
	for (i=0; i<n; i++) {
		if (i>0) aAbsnStr.AppendAscii( RTL_CONSTASCII_STRINGPARAM( " - "));
		aAbsnStr+=GetLine(rStr,i);
	}
	if (bShowAbsn && pWin!=NULL)
	  MyInvalidate(pWin,Rectangle(short(PosX),short(PosY),short(SizX),short(2*EINHEIT+EINHEIT/2)));
}

////////////////////////////////////////////////////////////////////////////////
// WizardElem
////////////////////////////////////////////////////////////////////////////////

WizardElem::WizardElem()
{
	pPage=NULL;
}

void WizardElem::Draw(OutputDevice& rOut)
{
	for(USHORT i=0; i<5; i++) {
		aBezeich[i].Draw(rOut);
		aDerText[i].Draw(rOut);
	}
}

void WizardElem::Korreg(Window* pWin)
{
	if (pPage==NULL) return;
	USHORT Anz=0;
	USHORT i;
	if (aBezeich[0].GetPosY()==0) { // Init muesste eigentlich zum Construktor
		for(USHORT i=0; i<5; i++) {
			aBezeich[i].SetPosY(100*EINHEIT,pWin);
			aBezeich[i].SetHgt(5*EINHEIT,pWin);
			aDerText[i].SetPosY(105*EINHEIT,pWin);
			aDerText[i].SetHgt(5*EINHEIT,pWin);
		}
	}
	long PageUsrWdt=pPage->SizeX-25*EINHEIT-20*EINHEIT; //pPage->RandL-pPage->RandR;
	for(i=0; i<5; i++) if (aBezeich[i].IsVisible()) Anz++;
	if (Anz==1 && aBezeich[4].IsVisible()) {  // nur Datum ?
		for(i=0; i<5; i++) aDerText[i].Hide(pWin);
		aBezeich[4].SetPosX(USHORT(pPage->SizeX-20*EINHEIT/*pPage->RandR*/-80*EINHEIT),pWin);
		aBezeich[4].SetWdt(USHORT(80*EINHEIT),pWin);
	} else {
		long DateWdt=40*EINHEIT;
		long RestWdt=PageUsrWdt;
		if (aBezeich[4].IsVisible()) {
			RestWdt-=DateWdt; // 40mm fuer's Datum
			Anz--;
		}
		long ElemWdt=0;
		if (Anz!=0) ElemWdt=RestWdt/Anz;
		if (ElemWdt>60*EINHEIT) ElemWdt=60*EINHEIT; // Max. 60mm sollten reichen je Element
		USHORT Num=0;
		for(i=0; i<5; i++) {
			aDerText[i].Show(pWin,aBezeich[i].IsVisible());
			if (aBezeich[i].IsVisible()) {
				if (i==4) {
					aBezeich[i].SetPosX(USHORT(pPage->SizeX-20*EINHEIT/*pPage->RandR*/-DateWdt),pWin);
					aBezeich[i].SetWdt(USHORT(DateWdt),pWin);
				} else {
					aBezeich[i].SetPosX(USHORT(25*EINHEIT/*pPage->RandL*/+ElemWdt*Num),pWin);
					aBezeich[i].SetWdt(USHORT(ElemWdt),pWin);
				}
				aDerText[i].SetPosX(aBezeich[i].GetPosX(),pWin);
				aDerText[i].SetWdt(aBezeich[i].GetWdt(),pWin);
				Num++;
			}
		}
	}
}

void WizardElem::Show(USHORT Num, Window* pWin, BOOL bOn)
{ if (Num<5 && bOn!=aBezeich[Num].IsVisible()) { aBezeich[Num].Show(pWin,bOn); Korreg(pWin); } }

void WizardElem::Hide(USHORT Num, Window* pWin)
{ if (Num<5 && aBezeich[Num].IsVisible()) { aBezeich[Num].Hide(pWin); Korreg(pWin); } }

BOOL WizardElem::IsVisible(USHORT Num)
{ return (Num<5 && aBezeich[Num].IsVisible()); }

BOOL WizardElem::NurDatum()
{
	USHORT Anz=0;
	USHORT i;
	for(i=0; i<5; i++) if (aBezeich[i].IsVisible()) Anz++;
	return (Anz==1 && aBezeich[4].IsVisible());
}

USHORT WizardElem::GetHgt()
{
	USHORT Anz=0;
	USHORT i;
	for(i=0; i<5; i++) if (aBezeich[i].IsVisible()) Anz++;
	if (Anz==0) return 0;
	if (Anz==1 && aBezeich[4].IsVisible()) return aBezeich[4].GetHgt();
	for(i=0; i<5; i++)
		if (aBezeich[i].IsVisible())
			return aBezeich[i].GetHgt()+aBezeich[i].GetHgt();
	return 0; // Sicherheitshalber...
}

long WizardElem::GetPosX()
{
	if (NurDatum()) return aBezeich[4].GetPosX();
	return 25*EINHEIT;
}

USHORT WizardElem::GetWdt()
{
	if (NurDatum()) return aBezeich[4].GetWdt();
	long l=0x7FFFFFFF,r=0;
	long l1,r1;
	for (USHORT i=0; i<5; i++) {
		if (IsVisible(i)) {
			l1=aBezeich[i].GetPosX();
			r1=l1+aBezeich[i].GetWdt();
			if (l1<l) l=l1;
			if (r1>r) r=r1;
		}
	}
	if (l<r) return USHORT(r-l);
	return 0; // Sicherheitshalber
}

void WizardElem::Set2ndHide(BOOL bHide, Window* pWin)
{
	for(USHORT i=0; i<5; i++) {
		aBezeich[i].Set2ndHide(bHide,pWin);
		aDerText[i].Set2ndHide(bHide,pWin);
	}
}

void WizardElem::SetPosY(USHORT nPosY, Window* pWin)
{
	for(USHORT i=0; i<5; i++)  {
		aBezeich[i].SetPosY(nPosY,pWin);
		aDerText[i].SetPosY(nPosY+aBezeich[i].GetHgt(),pWin);
	}
}

void WizardElem::SetPage(WizardPage* pPg)
{ pPage=pPg; Korreg(); }

BOOL WizardElem::IsAnyVisible()
{
	for(USHORT i=0; i<5; i++)
		if (aBezeich[i].IsVisible()) return TRUE;
	return FALSE;
}

////////////////////////////////////////////////////////////////////////////////
// WizardBetr
////////////////////////////////////////////////////////////////////////////////

WizardBetr::WizardBetr()
{
	PosX=25*EINHEIT;
	PosY=120*EINHEIT;
	SizX=0;
	SizY=5*EINHEIT;
	SetDefStr(SW_RESSTR(STR_Pag_DefsBetr));
}

void WizardBetr::SetPage(WizardPage* pPg)
{
	WizardFrame::SetPage(pPg);
	KorregWdt();
}

void WizardBetr::KorregWdt(Window* pWin)
{
	if (pPage!=NULL) {
		USHORT x=USHORT(pPage->RandL);
		USHORT w=USHORT(pPage->SizeX-pPage->RandL-pPage->RandR);
		SetPosX(x,pWin);
		SetWdt(w,pWin);
	}
}

////////////////////////////////////////////////////////////////////////////////
// WizardFusz
////////////////////////////////////////////////////////////////////////////////

WizardFusz::WizardFusz()
{
	PosX=25*EINHEIT;
	PosY=0*EINHEIT;
	SizX=0;
	SizY=5*EINHEIT;
	eAlign=ALIGN_LiUn;
	bTrenn=TRUE;
	TextDst=6*EINHEIT;
	aTrenn.SetPosX(PosX);
	SetDefStr(SW_RESSTR(STR_Pag_DefsFusz));
	bPgNum=FALSE;
	nPgNumFmt=0;
	bPgNumGes=FALSE;
}

WizardFusz::~WizardFusz()
{
}

void WizardFusz::Draw(OutputDevice& rOut)
{
	WizardText::Draw(rOut);
	if (bTrenn && IsVisible()) {
		aTrenn.Draw(rOut);
	}
}

void WizardFusz::Invalidate(Window* pWin)
{
	WizardText::Invalidate(pWin);
	aTrenn.Invalidate(pWin);
	KorregPgRand(pWin);
}

void WizardFusz::SetPage(WizardPage* pPg)
{
	WizardFrame::SetPage(pPg);
	KorregWdt();
	KorregPgRand();
}

void WizardFusz::SetTextDst(USHORT nDst, Window* pWin)
{
	if (nDst!=USHORT(TextDst)) {
		TextDst=nDst;
		KorregPgRand(pWin);
	}
}

void WizardFusz::KorregPgRand(Window* pWin)
{
	if (pPage!=NULL) {
		KorregPos(pWin);
		long nRand=GetVer();
		if (IsVisible()) nRand+=GetHgt()+TextDst;
		pPage->SetRandU(USHORT(nRand),pWin);
		if (bTrenn)
		  aTrenn.SetPosY(PosY-2*EINHEIT/*-TextDst/2*/,pWin);
	}
}

void WizardFusz::KorregWdt(Window* pWin)
{
	if (pPage!=NULL) {
		USHORT x=USHORT(pPage->RandL);
		USHORT w=USHORT(pPage->SizeX-pPage->RandL-pPage->RandR);
		SetRandL(x,pWin);        // kein SetPosX, weil Aligned!
		SetWdt(w,pWin);
		aTrenn.SetPosX(x,pWin);
		aTrenn.SetWdt(w,pWin);
	}
}

void WizardFusz::SetTrennlinie(BOOL bTrn, Window* pWin)
{
	if (bTrn!=bTrenn) {
		bTrenn=bTrn;
		if (IsVisible()) Invalidate(pWin);
	}
}

void WizardFusz::SetPgNum(BOOL bPgNumOn, Window* pWin)
{
	bPgNum=bPgNumOn;
	USHORT a=5*EINHEIT;
	if (bPgNum) a+=5*EINHEIT;
	SetHgt(a,pWin);
}

void WizardFusz::SetHgt(USHORT nHgt, Window* pWin)
{
	WizardText::SetHgt(nHgt,pWin);
	KorregPgRand(pWin);
}

////////////////////////////////////////////////////////////////////////////////
// WizardKopz
////////////////////////////////////////////////////////////////////////////////

WizardKopz::WizardKopz()
{
	//eAlign=ALIGN_LiOb;
	TextDst=6*EINHEIT;
	pPage=NULL;
	aLogo.SetAlign(ALIGN_LiOb);
	aLogo.SetSiz(40*EINHEIT,10*EINHEIT);
	aAbsn.SetAlign(ALIGN_ReOb);
	aAbsn.SetSiz(40*EINHEIT,20*EINHEIT);
}

void WizardKopz::Draw(OutputDevice& rOut)
{
	if (aLogo.IsVisible()) aLogo.Draw(rOut);
	if (aAbsn.IsVisible()) aAbsn.Draw(rOut);
}

/*void WizardKopz::Invalidate(Window* pWin)
{
	aLogo.Invalidate(pWin);
	aAbsn.Invalidate(pWin);
}*/

void WizardKopz::SetPage(WizardPage* pPg)
{
	pPage=pPg;
	aLogo.SetPage(pPg);
	aAbsn.SetPage(pPg);
	KorregWdt();
}

void WizardKopz::KorregWdt(Window* pWin)
{
	if (pPage!=NULL) {
		USHORT l=USHORT(pPage->RandL);
		USHORT r=USHORT(pPage->RandR);
		aLogo.SetRandL(l,pWin);  // kein SetPosX, weil Aligned!
		aLogo.SetRandR(r,pWin);
		aAbsn.SetRandL(l,pWin);
		aAbsn.SetRandR(r,pWin);
	}
}

void WizardKopz::SetVer(USHORT nRand, Window* pWin)
{
	aLogo.SetVer(nRand,pWin);
	aAbsn.SetVer(nRand,pWin);
	KorregPgRand(pWin);
}

void WizardKopz::SetTextDst(USHORT nDst, Window* pWin)
{ TextDst=nDst; KorregPgRand(pWin); }

void WizardKopz::ShowLogo(Window* pWin, BOOL bOn)
{ aLogo.Show(pWin,bOn); KorregPgRand(pWin); }

void WizardKopz::ShowAbsn(Window* pWin, BOOL bOn)
{ aAbsn.Show(pWin,bOn); KorregPgRand(pWin); }

void WizardKopz::SetLogoHgt(USHORT nHgt, Window* pWin)
{ aLogo.SetHgt(nHgt,pWin); KorregPgRand(pWin); }

void WizardKopz::SetAbsnHgt(USHORT nHgt, Window* pWin)
{ aAbsn.SetHgt(nHgt,pWin); KorregPgRand(pWin); }

void WizardKopz::KorregPgRand(Window* pWin)
{
	if (pPage!=NULL) {
		long nRand=aLogo.GetVer();
		long y1=aLogo.GetPosY()+aLogo.GetHgt()+TextDst;
		long y2=aAbsn.GetPosY()+aAbsn.GetHgt()+TextDst;
		if (!aLogo.IsVisible()) y1=0;
		if (!aAbsn.IsVisible()) y2=0;
		nRand=Max(nRand,(Max(y1,y2)));
		pPage->SetRandO(USHORT(nRand),pWin);
	}
}

USHORT WizardKopz::GetHgt()
{
	USHORT nRet=0;
	if (LogoIsVisible()) {
		USHORT a=GetLogoHgt();
		if (a>nRet) nRet=a;
	}
	if (AbsnIsVisible()) {
		USHORT a=GetAbsnHgt();
		if (a>nRet) nRet=a;
	}
	return nRet;
}

////////////////////////////////////////////////////////////////////////////////
// WizardLettPage1
////////////////////////////////////////////////////////////////////////////////

WizardLettPage1::WizardLettPage1()
{
	aLogo.SetPage(this);
	aAbsn.SetPage(this);
	aEmpf.SetPage(this);
	aElem.SetPage(this);
	aBetr.SetPage(this);
	aFusz.SetPage(this);

	aLogo.SetAlign(ALIGN_MiOb);
	aLogo.SetSiz(80*EINHEIT,20*EINHEIT);
	aAbsn.SetAlign(ALIGN_Mitt);
	aAbsn.SetSiz(60*EINHEIT,25*EINHEIT);
	aAbsn.SetGrowOnStr();
	aElem.Hide(0);
	aElem.Hide(1);
	aElem.Hide(2);
	aElem.Hide(3);
	aElem.Show(4);
	aFusz.Hide();
	/*aBetr.SetStr(String("Betreff:")); Das bringt's nich
	aElem.aBezeich[0].SetStr(String("Ihr Zeichen"));
	aElem.aBezeich[1].SetStr(String("Unser Zeichen"));
	aElem.aBezeich[2].SetStr(String("Ihr Schreiben vom"));
	aElem.aBezeich[3].SetStr(String("Unser Schreiben vom"));
	aElem.aBezeich[4].SetStr(String("Datum"));*/
}

WizardLettPage1::~WizardLettPage1()
{
}

void WizardLettPage1::Draw(OutputDevice& rOut)
{
	WizardPage::Draw(rOut);
	DrawBaseText(rOut,70);
	aLogo.Draw(rOut);
	aAbsn.Draw(rOut);
	aEmpf.Draw(rOut);
	aElem.Draw(rOut);
	aBetr.Draw(rOut);
	aFusz.Draw(rOut);
}

// WizardLettPageF

WizardLettPageF::WizardLettPageF()
{
	aFusz.SetPage(this);
	aKopz.SetPage(this);
	aKopz.ShowLogo(FALSE);
	aKopz.ShowAbsn(FALSE);
	aFusz.Hide();
}

void WizardLettPageF::Draw(OutputDevice& rOut)
{
	WizardPage::Draw(rOut);
	DrawBaseText(rOut,90);
	aFusz.Draw(rOut);
	aKopz.Draw(rOut);
}


////////////////////////////////////////////////////////////////////////////////
// WizardFaxnPage
////////////////////////////////////////////////////////////////////////////////

WizardFaxnPage::WizardFaxnPage()
{
	aLogo.SetPage(this);
	aTitl.SetPage(this);
	aDatm.SetPage(this);
	aEmpf.SetPage(this);
	aAbsn.SetPage(this);
	aBetr.SetPage(this);
	aElem.SetPage(this);
	aFusz.SetPage(this);
	aTitl.SetModeText();         // der Titel ist bei mir ein Textlogo (Fit)
	aTitl.SetStyle(TEXT_FitSiz); // jedoch rechtsbuendig
	aTitl.SetDefStr(SW_RESSTR(STR_Pag_DefsTitl));
	aDatm.SetDefStr(SW_RESSTR(STR_Pag_DefsDatm));
	aEmpf.SetDefStr(SW_RESSTR(STR_Pag_DefsEmpf));
	aBetr.Hide();
	aElem.Hide(0);
	aElem.Hide(1);
	aElem.Hide(2);
	aElem.Hide(3);
	aElem.Hide(4); // Datum bei den Elementen wird im Fax immer aus bleiben
	aLogo.SetAlign(ALIGN_MiOb);
	aLogo.SetSiz(80*EINHEIT,20*EINHEIT);
	aTitl.SetAlign(ALIGN_LiOb);
	aTitl.SetSiz(80*EINHEIT,15*EINHEIT);
	aDatm.SetAlign(ALIGN_ReOb);
	aDatm.SetSiz(80*EINHEIT,5*EINHEIT);
	aDatm.SetGrowOnStr();
	aDatm.SetLnDazu(1);
	aEmpf.SetAlign(ALIGN_LiOb);
	aEmpf.SetSiz(80*EINHEIT,30*EINHEIT);
	aEmpf.SetGrowOnStr();
	aAbsn.SetAlign(ALIGN_ReOb);
	aAbsn.SetSiz(80*EINHEIT,30*EINHEIT);
	aAbsn.SetGrowOnStr();
	aBetr.SetGrowOnStr();
	//aEmpf.SetStrVisi();
	//aAbsn.SetStrVisi();
}

void WizardFaxnPage::Draw(OutputDevice& rOut)
{
	WizardPage::Draw(rOut);
	DrawBaseText(rOut,90);
	aLogo.Draw(rOut);
	aTitl.Draw(rOut);
	aDatm.Draw(rOut);
	aEmpf.Draw(rOut);
	aAbsn.Draw(rOut);
	aBetr.Draw(rOut);
	aElem.Draw(rOut);
	aFusz.Draw(rOut);
}


////////////////////////////////////////////////////////////////////////////////
// WizardMemoPage
////////////////////////////////////////////////////////////////////////////////

WizardMemoPage::WizardMemoPage()
{
	SetRandL(20*EINHEIT);
	SetRandR(20*EINHEIT);
	SetRandO(20*EINHEIT);
	SetRandU(20*EINHEIT);
	aTitl.SetPage(this);
	aEleZ.SetPage(this);
	aEleT.SetPage(this);
	aFusz.SetPage(this);
	aTitl.SetModeText();         // der Titel ist bei mir ein Textlogo (Fit)
	aTitl.SetDefStr(SW_RESSTR(STR_Pag_DefsTitl));
	aTitl.SetMemoTitel();        // MEMO als Grafik anzeigen
	aEleZ.SetDefStr(SW_RESSTR(STR_Pag_DefsElem));
	aEleT.Hide(0);
	aEleT.Hide(1);
	aEleT.Hide(2);
	aEleT.Hide(3);
	aEleT.Hide(4);
	aTitl.SetAlign(ALIGN_MiOb);
	aTitl.SetVer(20*EINHEIT);
	aTitl.SetSiz(170*EINHEIT,20*EINHEIT);
	aEleZ.SetAlign(ALIGN_LiOb);
	aEleZ.SetHor(20*EINHEIT);
	aEleZ.SetSiz(170*EINHEIT,5*EINHEIT);
	aEleZ.SetGrowOnStr();
	aFusz.SetVer(20*EINHEIT);
}

void WizardMemoPage::Draw(OutputDevice& rOut)
{
	WizardPage::Draw(rOut);
	DrawBaseText(rOut,90);
	aTitl.Draw(rOut);
	aEleZ.Draw(rOut);
	aEleT.Draw(rOut);
	aFusz.Draw(rOut);
}


////////////////////////////////////////////////////////////////////////////////
// WizardAgenPage
////////////////////////////////////////////////////////////////////////////////

WizardAgenPage::WizardAgenPage()
{
	SetRandL(20*EINHEIT);
	SetRandR(15*EINHEIT);
	SetRandO(10*EINHEIT);
	SetRandU(10*EINHEIT);
	aLogo.SetPage(this);
	aLogo.SetModeGraf();
	aLogo.SetAlign(ALIGN_LiOb);
	aLogo.SetVer(10*EINHEIT);
	aLogo.SetHor(20*EINHEIT);
	aLogo.SetSiz(50*EINHEIT,35*EINHEIT);
	aLogo.SetAgenGraf();
	aLogo.Hide();
	aLogo.SetDefStr(SW_RESSTR(STR_Pag_DefsGraf));
	aTitl.SetPage(this);
	aTitl.SetModeText();
	aTitl.SetAlign(ALIGN_LiOb);
	aTitl.SetHor(20*EINHEIT);
	aTitl.SetHgt(15*EINHEIT);
	aTitl.SetDefStr(SW_RESSTR(STR_Pag_DefsTitl));
	aDatm.SetPage(this);
	aDatm.SetAlign(ALIGN_LiOb);
	aDatm.SetHor(20*EINHEIT);
	aDatm.SetHgt(15*EINHEIT);
	aDatm.SetDefStr(SW_RESSTR(STR_Pag_DefsDatm));
	aElem.SetPage(this);
	aElem.SetAlign(ALIGN_LiOb);
	aElem.SetHor(20*EINHEIT);
	aElem.SetSiz(175*EINHEIT,5*EINHEIT);
	aElem.SetGrowOnStr();
	aElem.SetDefStr(SW_RESSTR(STR_Pag_DefsElem));
}

void WizardAgenPage::Draw(OutputDevice& rOut)
{
	WizardPage::Draw(rOut);
	DrawBaseText(rOut,90);
	aLogo.Draw(rOut);
	aTitl.Draw(rOut);
	aDatm.Draw(rOut);
	aElem.Draw(rOut);
}




}
