/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_wizzard.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 07:23:33 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

#ifndef _SVX_SVXIDS_HRC
#include <bf_svx/svxids.hrc>
#endif
#include "wizzard.hxx"
#include "wizlt.hxx"
#include "wizfx.hxx"
#include "wizmm.hxx"
#include "wizag.hxx"
#include <vcl/msgbox.hxx>
namespace binfilter {



Wizzard::Wizzard( USHORT nSlotId )
{
	SwWizardDialog* pDlg = 0;
	switch( nSlotId )
	{
	case SID_SW_LETTER_WIZZARD:	pDlg = new LetterDialog( 0 );	break;
	case SID_SW_FAX_WIZZARD:	pDlg = new FaxDialog( 0 );	break;
	case SID_SW_MEMO_WIZZARD:	pDlg = new MemoDialog( 0 );	break;
	case SID_SW_AGENDA_WIZZARD:	pDlg = new AgenDialog( 0 );	break;
	}

	if( pDlg )
	{
		if( RET_OK == pDlg->Execute() )
		{
			pDlg->WriteToIni();
			pDlg->MakeDoc();
		}
		delete pDlg;
	}
}

}
