/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: tbxctrl.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 12:42:11 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SFXTBXCTRL_HXX
#define _SFXTBXCTRL_HXX

#ifndef _TIMER_HXX //autogen
#include <vcl/timer.hxx>
#endif
#ifndef _MENU_HXX //autogen
#include <vcl/menu.hxx>
#endif
#ifndef _FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif
#ifndef _FLOATWIN_HXX //autogen
#include <vcl/floatwin.hxx>
#endif
#include <bf_sfx2/ctrlitem.hxx>
namespace binfilter {

//------------------------------------------------------------------

class SfxUnoToolBoxControl;
class SfxToolBoxControl;
class SfxBindings;
class SfxModule;
class SfxUnoControllerItem;

typedef SfxToolBoxControl* (*SfxToolBoxControlCtor)( USHORT nId, ToolBox &rTbx, SfxBindings & );

struct SfxTbxCtrlFactory
{
	SfxToolBoxControlCtor	pCtor;
	TypeId					nTypeId;
	USHORT					nSlotId;

	SfxTbxCtrlFactory( SfxToolBoxControlCtor pTheCtor,
			TypeId nTheTypeId, USHORT nTheSlotId ):
		pCtor(pTheCtor),
		nTypeId(nTheTypeId),
		nSlotId(nTheSlotId)
	{}
};

//------------------------------------------------------------------

enum SfxPopupWindowType
{
	SFX_POPUPWINDOW_NONE,
	SFX_POPUPWINDOW_ONCLICK,
	SFX_POPUPWINDOW_ONTIMEOUT,
	SFX_POPUPWINDOW_ONCLICKANDMOVE,
	SFX_POPUPWINDOW_ONTIMEOUTANDMOVE,
	SFX_POPUPWINDOW_CONTEXTMENU
};

//------------------------------------------------------------------

/*	FloatingWindows, die aus ToolBoxen abgerissen werden k"onnen, sollten
	dieser Klasse abgeleitet werden. Da sie ebenfalls von SfxControllerItem
	abgeleitet ist, erhalten ihre Instanzen auch die StateChanged Aufrufe.
*/

class SfxPopupWindow: public FloatingWindow, public SfxControllerItem
{
friend class SfxToolBox_Impl;
	BOOL					bFloating;
	ULONG					nEventId;
	BOOL					bCascading;
	Link					aDeleteLink;

	private:
#if _SOLAR__PRIVATE
//STRIP001 	DECL_LINK( Delete, void * );
#endif

protected:
//STRIP001 	virtual void			PopupModeEnd();
//STRIP001 	virtual BOOL			Close();
//STRIP001 	virtual void			DeleteFloatingWindow();
//STRIP001 	virtual void			StateChanged( USHORT nSID, SfxItemState eState,
//STRIP001 										  const SfxPoolItem* pState );

public:
							SfxPopupWindow( USHORT nId, WinBits nBits, SfxBindings & );
							SfxPopupWindow( USHORT nId, const ResId &rId, SfxBindings & );
                            ~SfxPopupWindow();

//STRIP001 	virtual SfxPopupWindow* Clone() const;
//STRIP001 	virtual void			MouseMove( const MouseEvent& rMEvt );
//STRIP001 
#if _SOLAR__PRIVATE
//STRIP001 	void					StartCascading_Impl();
//STRIP001 	void					EndCascading_Impl();
//STRIP001 	void					SetDeleteLink_Impl( const Link& rLink )
//STRIP001 							{
//STRIP001 								aDeleteLink = rLink;
//STRIP001 							}
#endif
};

//------------------------------------------------------------------

#define SFX_DECL_TOOLBOX_CONTROL() \
		static SfxToolBoxControl* CreateImpl( USHORT nId, ToolBox &rTbx, SfxBindings &rBindings ); \
		static void RegisterControl(USHORT nSlotId = 0, SfxModule *pMod=NULL)

#define SFX_IMPL_TOOLBOX_CONTROL(Class, nItemClass) \
		SfxToolBoxControl* __EXPORT Class::CreateImpl( USHORT nId, ToolBox &rTbx, SfxBindings &rBindings ) \
			   { return new Class(nId, rTbx, rBindings); } \
		void Class::RegisterControl(USHORT nSlotId, SfxModule *pMod) \
			   { SFX_APP()->RegisterToolBoxControl( pMod, new SfxTbxCtrlFactory( \
					Class::CreateImpl, TYPE(nItemClass), nSlotId ) ); }

#define SFX_IMPL_TOOLBOX_CONTROL_ARG(Class, nItemClass, Arg) \
		SfxToolBoxControl* __EXPORT Class::CreateImpl( USHORT nId, ToolBox &rTbx, SfxBindings &rBindings ) \
			   { return new Class(nId, rTbx, rBindings, Arg); } \
		void Class::RegisterControl(USHORT nSlotId, SfxModule *pMod) \
			   { SFX_APP()->RegisterToolBoxControl( pMod, new SfxTbxCtrlFactory( \
					Class::CreateImpl, TYPE(nItemClass), nSlotId ) ); }

//------------------------------------------------------------------

/*	F"ur spezielle ToolBox-Controls, z.B. eine Font-Auswahl-Box oder
	aus ToolBoxen abrei"sbare FloatingWindows mu"s passend zur Item-Subclass
	eine Subclass von SfxTooBoxControl implementiert werden.

	Diese Klasse mu"s in SfxApplication::Init() mit der statischen Methode
	RegisterControl() registriert werden. Der SFx erzeugt dann automatisch
	diese Controls in ToolBoxen, wenn die dazugeh"origen Slots von dem
	angegebenen Typ sind.
 */

class SfxToolBoxControl: public SfxControllerItem
{
friend class SfxToolBoxManager;
//STRIP001 friend class SfxToolbox;
//STRIP001 friend class SfxToolBox_Impl;
//STRIP001 friend class SfxToolboxCustomizer;
//STRIP001 friend class SfxPopupWindow;
//STRIP001 friend struct SfxTbxCtrlFactory;
//STRIP001 
	ToolBox*				pBox;
	BOOL					bShowString;
	USHORT                  nSelectModifier;
	SfxTbxCtrlFactory*		pFact;

protected:
	virtual void			StateChanged( USHORT nSID, SfxItemState eState,
										  const SfxPoolItem* pState );
	virtual void			Select( BOOL bMod1 = FALSE );
	virtual void			Select( USHORT nModifier );

	virtual void			DoubleClick();
	virtual void			Click();
	virtual SfxPopupWindowType
							GetPopupWindowType() const;
//STRIP001 	virtual SfxPopupWindow* CreatePopupWindow();
//STRIP001 	virtual	SfxPopupWindow* CreatePopupWindowCascading();
	virtual Window*         CreateItemWindow( Window *pParent );

public:
							SFX_DECL_TOOLBOX_CONTROL();

							SfxToolBoxControl( USHORT nId, ToolBox& rBox,
											   SfxBindings &,
											   BOOL bShowStrings = FALSE );
	virtual 				~SfxToolBoxControl();

	ToolBox&				GetToolBox() const
							{ return *pBox; }

	static SfxToolBoxControl* CreateControl( USHORT nId, ToolBox *pBox,
											 SfxBindings&, SfxModule *pMod );

	static SfxUnoToolBoxControl* CreateControl( const String&, USHORT nId,
											 ToolBox *pBox,
											 SfxBindings& );
#if _SOLAR__PRIVATE
	SfxToolBoxControl*		ReInit_Impl();
#endif
};

//STRIP001 class SfxUnoToolBoxControl : public SfxToolBoxControl
//STRIP001 {
//STRIP001 	SfxUnoControllerItem*	pUnoCtrl;
//STRIP001 public:
//STRIP001 							SfxUnoToolBoxControl( const String&, USHORT nId,
//STRIP001 											 ToolBox *pBox,
//STRIP001 											 SfxBindings& );
//STRIP001 							~SfxUnoToolBoxControl();
//STRIP001 	virtual void			Select( BOOL bMod1 = FALSE );
//STRIP001 };

//=========================================================================

#if _SOLAR__PRIVATE

//STRIP001 class SfxDragButton_Impl : public FixedImage
//STRIP001 {
//STRIP001     SfxBindings*    pBindings;
//STRIP001 public:
//STRIP001 
//STRIP001                     SfxDragButton_Impl( Window *pParent, SfxBindings& rBind );
//STRIP001 	virtual void 	Command ( const CommandEvent& rCEvt );
//STRIP001 	virtual void	MouseMove( const MouseEvent& rMEvt );
//STRIP001 	virtual void	MouseButtonDown( const MouseEvent& rMEvt );
//STRIP001 };

//STRIP001 class SfxDragToolBoxControl_Impl : public SfxToolBoxControl
/*  [Beschreibung]

*/

//STRIP001 {
//STRIP001 public:
//STRIP001 							SFX_DECL_TOOLBOX_CONTROL();
//STRIP001 							SfxDragToolBoxControl_Impl(
//STRIP001 								USHORT nId, ToolBox& rBox, SfxBindings& );
//STRIP001 	virtual Window*         CreateItemWindow( Window *pParent );
//STRIP001 	virtual void			Select( BOOL bMod1 = FALSE );
//STRIP001 };

//------------------------------------------------------------------------

class SfxAppToolBoxControl_Impl : public SfxToolBoxControl

/*  [Beschreibung]

	Interne Hilfsklasse f"ur um das Popup-Menu <AppMenu_Impl> unter Neu
	im SDT zu starten.
*/

{
    String                  aLastURL;
	Timer					aTimer;
	BOOL					bBigImages;
    PopupMenu*              pMenu;
	BOOL					m_bWasHiContrastMode;
	BOOL					m_bShowMenuImages;

private:
							DECL_LINK( Timeout, Timer * );

protected:
    virtual void            Click();
	virtual void			Select( BOOL );
    virtual void            StateChanged( USHORT nSID, SfxItemState eState, const SfxPoolItem* pState );
							DECL_LINK( Activate, Menu * ); // Needed to support high contrast images
public:
							SFX_DECL_TOOLBOX_CONTROL();
                            SfxAppToolBoxControl_Impl( USHORT nId, ToolBox& rBox,  SfxBindings& );
                            ~SfxAppToolBoxControl_Impl();
	void					SetImage( const String& rFacName );
};

//STRIP001 class SfxHistoryToolBoxControl_Impl : public SfxToolBoxControl
//STRIP001 {
//STRIP001 	Timer					aTimer;
//STRIP001 
//STRIP001 private:
//STRIP001 							DECL_LINK( Timeout, Timer * );
//STRIP001 
//STRIP001 protected:
//STRIP001 	virtual void			Click( );
//STRIP001 	virtual void			Select( BOOL );
//STRIP001 
//STRIP001 public:
//STRIP001 							SFX_DECL_TOOLBOX_CONTROL();
//STRIP001 							SfxHistoryToolBoxControl_Impl(
//STRIP001 								USHORT nId, ToolBox& rBox,  SfxBindings& );
//STRIP001 };

//STRIP001 class SfxReloadToolBoxControl_Impl : public SfxToolBoxControl
//STRIP001 {
//STRIP001 protected:
//STRIP001 	virtual void			Select( USHORT nSelectModifier );
//STRIP001 
//STRIP001 public:
//STRIP001 							SFX_DECL_TOOLBOX_CONTROL();
//STRIP001 							SfxReloadToolBoxControl_Impl(
//STRIP001 								USHORT nId, ToolBox& rBox,  SfxBindings& );
//STRIP001 };

class SfxPopupMenuManager;
class SfxAddonsToolBoxControl_Impl : public SfxToolBoxControl

/*  [Description]

	Internal helper class to provide the addons popup menu through the addons
	toolbox button.
*/

{
	BOOL					bBigImages;
    SfxPopupMenuManager*    pMenu;
	BOOL					m_bWasHiContrastMode;
	BOOL					m_bShowMenuImages;

protected:
    virtual void            Click();
	virtual void			Select( BOOL );
    virtual void            StateChanged( USHORT nSID, SfxItemState eState, const SfxPoolItem* pState );
							DECL_LINK( Activate, Menu * ); // Needed to support high contrast images
public:
							SFX_DECL_TOOLBOX_CONTROL();
                            SfxAddonsToolBoxControl_Impl( USHORT nId, ToolBox& rBox,  SfxBindings& );
                            ~SfxAddonsToolBoxControl_Impl();

                            void RefreshMenuImages( Menu* pMenu );
};

#endif

}//end of namespace binfilter
#endif
