/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: edit.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 12:48:14 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef EDIT_HXX
#define EDIT_HXX

#ifndef _SV_WINDOW_HXX //autogen
#include <vcl/window.hxx>
#endif
#ifndef _SV_TIMER_HXX //autogen
#include <vcl/timer.hxx>
#endif
#ifndef _TRANSFER_HXX
#include <svtools/transfer.hxx>
#endif
#ifndef _MyEDITDATA_HXX //autogen
#include <bf_svx/editdata.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_COLORCFG_HXX
#include <svtools/colorcfg.hxx>
#endif

#ifndef _ACCESSIBILITY_HXX_
#include "accessibility.hxx"
#endif
class ScrollBar; 
class ScrollBarBox; 
class Menu; 
namespace binfilter {

class SmDocShell;
class SmViewShell;
class EditView;
class EditEngine;
class EditStatus;
class DataChangedEvent;

class SmCmdBoxWindow;

/**************************************************************************/

	void SmGetLeftSelectionPart(const ESelection aSelection,
								USHORT &nPara, USHORT &nPos);

/**************************************************************************/

class SmEditWindow : public Window, public DropTargetHelper
{
//STRIP001     ::com::sun::star::uno::Reference<
//STRIP001         ::com::sun::star::accessibility::XAccessible >  xAccessible;
//STRIP001     SmEditAccessible *                                          pAccessible;

    SmCmdBoxWindow &rCmdBox;
	EditView	   *pEditView;
	ScrollBar	   *pHScrollBar,
				   *pVScrollBar;
	ScrollBarBox   *pScrollBox;
	Timer			aModifyTimer,
					aCursorMoveTimer;
	ESelection		aOldSelection;

	virtual void KeyInput(const KeyEvent& rKEvt);
//STRIP001 	virtual void Command(const CommandEvent& rCEvt);
//STRIP001 	DECL_LINK(MenuSelectHdl, Menu *);
	DECL_LINK(ModifyTimerHdl, Timer *);
	DECL_LINK(CursorMoveTimerHdl, Timer *);

//STRIP001 	virtual void DataChanged( const DataChangedEvent& );
	virtual void Resize();
//STRIP001 	virtual void MouseMove(const MouseEvent &rEvt);
//STRIP001 	virtual void MouseButtonUp(const MouseEvent &rEvt);
//STRIP001 	virtual void MouseButtonDown(const MouseEvent &rEvt);

//STRIP001     virtual sal_Int8    AcceptDrop( const AcceptDropEvent& rEvt );
//STRIP001     virtual sal_Int8    ExecuteDrop( const ExecuteDropEvent& rEvt );
//STRIP001 	virtual void Paint(const Rectangle& rRect);

	DECL_LINK(EditStatusHdl ,EditStatus *);
	DECL_LINK(ScrollHdl, ScrollBar *);

	void 		CreateEditView();

	Rectangle 	AdjustScrollBars();
	void 		SetScrollBarRanges();
	void 		InitScrollBars();

public:
    SmEditWindow( SmCmdBoxWindow &rMyCmdBoxWin );
	~SmEditWindow();

    SmDocShell *    GetDoc();
//STRIP001     SmViewShell *   GetView();
    EditView *      GetEditView()   { return pEditView; }
    EditEngine *    GetEditEngine();
//STRIP001     SfxItemPool *   GetEditEngineItemPool();

	// Window
	virtual void		SetText(const XubString &rText);
	virtual XubString	GetText();
	virtual void		GetFocus();
//STRIP001 	virtual void		LoseFocus();

	ESelection			GetSelection() const;
//STRIP001 	void				SetSelection(const ESelection &rSel);

	BOOL 				IsEmpty() const;
	BOOL 				IsSelected() const;
//STRIP001 	BOOL 				IsAllSelected() const;
//STRIP001 	void 				Cut();
//STRIP001 	void 				Copy();
//STRIP001 	void 				Paste();
//STRIP001 	void 				Delete();
//STRIP001 	void 				SelectAll();
//STRIP001 	void 				InsertText(const String &rText);
//STRIP001 	void 				InsertCommand(USHORT nCommand);
//STRIP001 	void 				MarkError(const Point &rPos);
//STRIP001 	void 				SelNextMark();
//STRIP001 	void 				SelPrevMark();
//STRIP001 	BOOL 				HasMark(const String &rText) const;

	void 				Flush();
//STRIP001     void                DeleteEditView( SmViewShell &rView );

    void ApplyColorConfigValues( const svtools::ColorConfig &rColorCfg );

    // for Accessibility
//STRIP001     virtual ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible > CreateAccessible();

//STRIP001     SmEditAccessible *   GetAccessible()  { return pAccessible; }
};


} //namespace binfilter
#endif

