/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: stringrepresentation.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: vg $ $Date: 2006/03/14 11:33:27 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef EXTENSIONS_SOURCE_PROPCTRLR_STRINGREPRESENTATION_HXX
#define EXTENSIONS_SOURCE_PROPCTRLR_STRINGREPRESENTATION_HXX

#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif

#ifndef _COM_SUN_STAR_SCRIPT_XTYPECONVERTER_HPP_
#include <com/sun/star/script/XTypeConverter.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif

//........................................................................
namespace pcr
{
//........................................................................

    class IPropertyEnumRepresentation;
	//====================================================================
	//= StringRepresentation
	//====================================================================
    /** is a helper class for handling string representations of property values
    */
	class StringRepresentation
	{
    private:
		::com::sun::star::uno::Reference< ::com::sun::star::script::XTypeConverter >
							m_xTypeConverter;

    public:
        StringRepresentation( const ::com::sun::star::uno::Reference< ::com::sun::star::script::XTypeConverter >& _rxConverter );

	    ::rtl::OUString convertSimpleToString( const ::com::sun::star::uno::Any& _rValue );

        ::rtl::OUString convertPropertyValueToStringRepresentation(
                            const ::com::sun::star::uno::Any& rValue
                        );

        ::com::sun::star::uno::Any
                        convertStringRepresentationToPropertyValue(
                            const ::rtl::OUString& _rStringRep,
                            const ::com::sun::star::uno::Type& _rTargetType
                        );

    private:
        /** converts a generic value into a string representation

            If you want to convert values whose string representation does not depend
            on a concrete property, use this version

            @return <TRUE/>
                if and only if the value could be converted
        */
        bool            convertGenericValueToString(
                            const ::com::sun::star::uno::Any&   _rValue,
                                  ::rtl::OUString&              _rStringRep
                        );

        /** converts string representation into generic value

            If you want to convert values whose string representation does not depend
            on a concrete property, use this version

            @return <TRUE/>
                if and only if the value could be converted
        */
        bool            convertStringToGenericValue(
                            const ::rtl::OUString&              _rStringRep,
                                  ::com::sun::star::uno::Any&   _rValue,
                            const ::com::sun::star::uno::Type& _rTargetType
                        );
	};

//........................................................................
} // namespace pcr
//........................................................................

#endif // EXTENSIONS_SOURCE_PROPCTRLR_STRINGREPRESENTATION_HXX

