/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: b2drascon.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 02:12:18 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _B2D_RASCON_HXX
#define _B2D_RASCON_HXX

#ifndef _SV_GEN_HXX
#include <tools/gen.hxx>
#endif

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

class PolyPolygon;
class Polygon;
class ImplLineNode;

//************************************************************
//   Base2D PolyPolygon Raster Converter (Rasterizer)
//************************************************************

class B2dPolyPolygonRasterConverter
{
	const Rectangle				maPolyPolyRectangle;
	const PolyPolygon&			mrPolyPolygonRaster;

	sal_uInt32					mnYCurrent;
	
	ImplLineNode**				mppLineNodes;
	ImplLineNode*				mpCurrentLine;

	void ImplBuildLists();
	void ImplAddList(const Polygon& rPolygon);
	void ImplAddSortedLineNode(ImplLineNode* pNew, ImplLineNode** ppDestList);
	void ImplPrepareLine();
	void ImplProcessLine();
	void ImplProgressLine();

public:
	B2dPolyPolygonRasterConverter(const PolyPolygon& rPolyPolyRaster);
	virtual ~B2dPolyPolygonRasterConverter();

	void Convert();

	virtual void Scanline(const double& rfXLeft, const double& rfXRight, sal_Int32 nY, sal_uInt32 nNodeNumber) = 0;
};

#endif          // _B2D_RASCON_HXX
