/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: mailsys.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 02:19:44 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _MAILSYS_HXX
#define _MAILSYS_HXX

// include ---------------------------------------------------------------



#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif

#include "mailenum.hxx"

// forward ---------------------------------------------------------------

class ResMgr;
class MailServer;
class INetSession;
class SfxCancelManager;
class TaskStatusBar;

struct MailSystem_Impl;
struct MailLoginInfo_Impl;

// structs ---------------------------------------------------------------

struct MailInfo
{
	String	aEmailName;
	String	aSmtpServerName;
	String	aPopServerName;
	String	aUserName;
	String	aUserPassword;
};

struct MailInfoHeader
{
	MailDriver 	eDriver;

	String		aUserName;
	String		aPassword;
	String		aLocalPath;
	String		aMessageId;
	String		aExtra1;
	String		aExtra2;
	String		aExtra3;

	FASTBOOL	bDeleteFromServer;

	MailInfoHeader() :
		eDriver(MAIL_DRIVER_DETECT), bDeleteFromServer(FALSE) {}
};

// callback function -----------------------------------------------------

typedef INetSession* (*GetMailINetSession)();
typedef void (*GetMailInfo)( MailInfo* pInfo );
typedef TaskStatusBar* (*GetTaskStatusBar)();

// class MailSystem ------------------------------------------------------

class MailSystem
{
private:
	MailSystem_Impl*	pImpl;
	String				sNames;

#if _SOLAR__PRIVATE
	BOOL			GetDefaultDriver( MailDriver& rDriver );
	void			CheckDrivers();
#endif

public:
	MailSystem();
	~MailSystem();

	BOOL			IsAvailable() const { return ( sNames.Len() != 0 ); }
	ResMgr*			GetResMgr() const;
	const String&	GetServerNames() const { return sNames; }
	BOOL			QueryMailDriver( MailDriver eDriver, String* pName = 0 );
	void			GetDefaults( MailDriver eDriver,
								 String& rUser, BOOL& bReqUser,
								 String& rPath, BOOL& bReqPath,
								 BOOL& bReqPasswd ) const;
	MailServer* 	CreateServer( MailDriver eDriver );
	MailServer* 	CreateServer( MailDriver eDriver, const String& rPath,
								  const String& rUser, const String& rPassw,
								  const String& rLocalPath, const String& rId,
								  FASTBOOL bDeleteFromServer );
	MailServer* 	CreateServer( const MailInfoHeader& rInfo );
	void			SetMailINetSessionFunc( GetMailINetSession pFunc );
	void			SetMailInfoFunc( GetMailInfo pFunc );
	void			GetMailSmtpInfo( MailInfo* pInfo ) const;
	void			SetTaskStatusBarFunc( GetTaskStatusBar pFunc );

	TaskStatusBar*		GetApplTaskBar() const;
	SfxCancelManager*   GetCancelManager() const;
	void				SetCancelManager( SfxCancelManager* pMgr );

	static USHORT		GetDriverTextId( MailDriver eDriver );
};


#endif

