package org.netbeans.modules.openoffice.wizard;

import org.openide.src.Identifier;
import java.util.Vector;
import org.openide.TopManager;
import org.openide.NotifyDescriptor;
import org.openide.src.MethodElement;

/*
 * IDLInterface.java
 *
 * Created on 15. Februar 2002, 19:15
 */

/**
 *
 * @author  Michael E. Bohn, Bertram Nolte
 * @version 0.2
 *
 */

public class IDLInterface {
    
    private Identifier identifierInterfaceName;
    private Vector vectorIDLMethods;
    
    public IDLInterface() {
        vectorIDLMethods = new Vector();
    }
    
    public void setName(Identifier InterfaceName) {
        this.identifierInterfaceName = InterfaceName;
    }
    
    public Identifier getIDLName() {
        return this.identifierInterfaceName;
        
    }
    
    public void addIDLMethod(IDLMethod aMethode) {
        vectorIDLMethods.add(aMethode);
    }
    
    public MethodElement[] getMethodes()
    { MethodElement[] aMethodeList = new MethodElement[vectorIDLMethods.size()];
      
      for(int i=0; i< vectorIDLMethods.size();i++) {
          aMethodeList[i]= (MethodElement) ((IDLMethod)vectorIDLMethods.get(i)).getMethod();
      }
      return aMethodeList;
    }
    
    public boolean equals(IDLInterface aIDLInterface) {
        if (identifierInterfaceName.getFullName() == aIDLInterface.getIDLName().getFullName())
        { return true;
        } else return false;
        
    }
    
    public int getMethodCount() {
        return vectorIDLMethods.size();
    }
    
    public final Identifier getIdentifierName() {
        return( this.identifierInterfaceName );
    }
    
    public final void setIdentifierName(final Identifier identifierName ) {
        this.identifierInterfaceName = identifierName;
    }
    
    public final Vector getVectorMethods() {
        return( this.vectorIDLMethods );
    }
    
    public final void setVectorMethods(final Vector vectorMethods ) {
        this.vectorIDLMethods = vectorMethods;
    }
    
}
