/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: XclExpCharts.hxx,v $
 *
 *  $Revision: 1.16 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 19:13:57 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef SC_XCLEXPCHARTS_HXX
#define SC_XCLEXPCHARTS_HXX

#ifndef _COM_SUN_STAR_CHART_XCHARTDOCUMENT_HPP_
#include <com/sun/star/chart/XChartDocument.hpp>
#endif
#ifndef _COM_SUN_STAR_CHART_XDIAGRAM_HPP_
#include <com/sun/star/chart/XDiagram.hpp>
#endif
#ifndef _COM_SUN_STAR_CHART_X3DDISPLAY_HPP_
#include <com/sun/star/chart/X3DDisplay.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSHAPE_HPP_
#include <com/sun/star/drawing/XShape.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif

#ifndef _REF_HXX //autogen wg. SV_DECL_REF_LIST
#include <tools/ref.hxx>
#endif

#include <memory>

#ifndef _SVX_ESCHEREX_HXX
#include <svx/escherex.hxx>
#endif

#ifndef SC_RANGELST_HXX
#include "rangelst.hxx"
#endif

#ifndef SC_XLCHART_HXX
#include "xlchart.hxx"
#endif
#ifndef SC_XESTYLE_HXX
#include "xestyle.hxx"
#endif

#ifndef _XCL97REC_HXX
#include "xcl97rec.hxx"
#endif

// -------------------------------------------------------------------

#define CSS ::com::sun::star

enum XclChartType
{
    EXC_CHART_LINE,
    EXC_CHART_AREA,
    EXC_CHART_BAR,              // horizontal bar chart
    EXC_CHART_COLUMN,           // vertical bar chart
    EXC_CHART_PIE,
    EXC_CHART_DONUT,            // pie sub type
    EXC_CHART_SCATTER,          // XY
    EXC_CHART_RADARLINE,        // radar
    EXC_CHART_RADARAREA,        // filled radar
    EXC_CHART_STOCK,
    EXC_CHART_SURFACE,          // not supported yet
    EXC_CHART_UNKNOWN
};

SV_DECL_REF_LIST( ScRangeList, ScRangeList* );

// --- struct XclPosSize ---------------------------------------------

struct XclPosSize
{
	INT32						nPosX;
	INT32						nPosY;
	INT32						nWidth;
	INT32						nHeight;
	UINT16						nAngle;

	inline void					Set( INT32 nX, INT32 nY, INT32 nW, INT32 nH, UINT16 nA = 0 );
};


inline void XclPosSize::Set( INT32 nX, INT32 nY, INT32 nW, INT32 nH, UINT16 nA )
{
	nPosX = nX; nPosY = nY; nWidth = nW; nHeight = nH; nAngle = nA;
}


// --- class XclChartDataFormat --------------------------------------
// contains global properties of data series

class XclChartDataFormat
{
private:
    typedef ::std::auto_ptr< EscherPropertyContainer > EscherPropertyContainerPtr;

public:
	// line format
	UINT16						nLineStyle;
	INT16						nLineWidth;
	Color						aLineColor;
	UINT16						nLineIndex;
	// area format
	UINT16						nAreaStyle;
	Color						aAreaColor;
	UINT16						nAreaIndex;
    // complex area format
    EscherPropertyContainerPtr  mpGelframe;
	// pie segment offset
	UINT16						nSegment;
	// line symbols
	BOOL						bHasSymbol;
	// data captions
	UINT16						nFontx;
	Color						aTextColor;
	UINT16						nTextIndex;
	UINT16						nTextFlags;
	UINT16						nLabelFlags;
	// 3D bar style
	UINT8						nDataFormatBase;
	UINT8						nDataFormatTop;

								XclChartDataFormat();

	void						SetLineFormat( UINT16 nStyle, INT16 nWidth, const Color& rColor, UINT16 nIndex );
	inline void					SetSegmentOffset( UINT16 nSeg );
	inline void					SetSymbol( BOOL bHas );
	void						SetTextFormat(
									UINT16 nFx, const Color& rColor, UINT16 nIndex,
									UINT16 nTFl, UINT16 nLFl );
	void						SetSolidType( UINT8 nBase, UINT8 nTop );

	UINT16						GetSymbol( UINT16 nSeries ) const;
};


inline void XclChartDataFormat::SetSegmentOffset( UINT16 nSeg )
{
	nSegment = nSeg;
}

inline void XclChartDataFormat::SetSymbol( BOOL bHas )
{
	bHasSymbol &= bHas;
}


// --- struct XclChartText -------------------------------------------
// contains data for a TEXT record

struct XclChartText
{
	UINT16						nSeries;
	UINT16						nPoint;
	UINT16						nFontx;
	ColorData					nRGB;
	UINT16						nIndex;
	UINT16						nFlags;

								XclChartText( UINT16 nSer, UINT16 nPt,
											const XclChartDataFormat& rFormats );
};


// --- class XclChartTextList ----------------------------------------
// list of XclChartText, write them at end of chart

class XclChartTextList : private List
{
private:
	inline XclChartText*		_First()	{ return (XclChartText*) List::First(); }
	inline XclChartText*		_Next()		{ return (XclChartText*) List::Next(); }

protected:
public:
	virtual						~XclChartTextList();

	inline const XclChartText*	First()		{ return (const XclChartText*) List::First(); }
	inline const XclChartText*	Next()		{ return (const XclChartText*) List::Next(); }

	inline void					Append( XclChartText* pText )
											{ List::Insert( pText, LIST_APPEND ); }
};


// --- class XclObjChart ---------------------------------------------

class ScChartArray;

class XclObjChart : public XclObj, protected XclExpRoot
{
private:
	enum TextType			// for WriteGroupText(), WriteText(), WritePos()
	{
		ttNone,				// no POS record
		ttCommon,			// POS record
		ttTitle,			// POS record chart relative
		ttLegend,			// no POS record
		ttXAxisTitle,		// POS record X axis relative
		ttYAxisTitle,		// POS record Y axis relative
		ttZAxisTitle,		// POS record Z axis relative
		ttDataCaption		// caption of data points
	};

	enum DefaultAlign		// for WriteText()
	{
		daAboveTop,
		daBelowTop,
		daCenter,
		daAboveBottom,
		daBelowBottom
	};

    typedef ::std::vector< XclExpTokenArrayRef > XclExpTokenArrayVec;

    CSS::uno::Reference< CSS::drawing::XShape >       xChartShape;
    CSS::uno::Reference< CSS::chart::XChartDocument > xChartDoc;
    CSS::uno::Reference< CSS::beans::XPropertySet >   xDocProp;
    CSS::uno::Reference< CSS::chart::XDiagram >       xDiagram;
    CSS::uno::Reference< CSS::beans::XPropertySet >   xDiaProp;
    CSS::uno::Reference< CSS::chart::X3DDisplay >     xDiagr3D;
    CSS::uno::Any    aAny;               // used for Get...PropValue
	ScRangeListMemberList		aSeriesYRangeList;	// Y-values
	ScRangeListMemberList		aSeriesXRangeList;	// X-categories
    XclExpTokenArrayVec         aSeriesYUpnList;    // Y-UPN values
    XclExpTokenArrayVec         aSeriesXUpnList;    // X-UPN categories
    XclExpTokenArrayVec         aSeriesNUpnList;    // N-UPN names, title or text
	List						aSerieslistList;	// list of SvUShort arrays
	XclChartTextList			aTextList;			// write TEXT groups at end of chart
	double						fX4000;
	double						fY4000;
	RootData&					rRootData;
	const SdrObject&			rChartObj;
    XclExpPalette&              rPal;
    XclExpFontBuffer&           rFontList;
	ScChartArray*				pChartArray;
	XclExpStream*				pStrm;
    XclChartType                eChartType;
	XclPosSize					aDiaPosSize;
	XclChartDataFormat			aDiaFormats;
	UINT16						nMaxSegOffset;		// correct diagram area for pie chart
	USHORT						nLevel;				// BEGIN, END
	SCSIZE						nChartDataColumns;
	UINT16						nChartCategoriesDataType;
    UINT16                      nCurrAxesSet;
    UINT16                      nCurrAxis;
	BOOL						bInitOk			: 1;
	BOOL						bColHeaders		: 1;
	BOOL						bRowHeaders		: 1;
	BOOL						bXAxisDescr		: 1;
	BOOL						bYAxisDescr		: 1;
	BOOL						bChartStacked	: 1;
	BOOL						bChartPercent	: 1;
	BOOL						bChartLine		: 1;
	BOOL						bChartSpline	: 1;
	BOOL						bChart3D		: 1;
	BOOL						bChartDeep		: 1;
	BOOL						bStockUpDown	: 1;
	BOOL						bStockVolume	: 1;
	BOOL						bChartTypeRound	: 1;	// ctPie, ctDonut
	BOOL						bChartTypeBars	: 1;	// ctBar, ctColumn
    BOOL                        bHasSecAxes     : 1;    // any series on secondary Y-axis?
	BOOL						bWriteMode		: 1;


	// properties
			BOOL				GetPropValue(
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp,
									const rtl::OUString& rString
									);
			BOOL				GetPropBool(	// FALSE = either property value is FALSE or property not found
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp,
									const rtl::OUString& rString
									);
			BOOL				GetPropBool(	// property in rValue
									sal_Bool& rValue,
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp,
									const rtl::OUString& rString
									);
			BOOL				GetPropInt32(
									sal_Int32& rValue,
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp,
									const rtl::OUString& rString
									);
			BOOL				GetPropInt16(
									sal_Int16& rValue,
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp,
									const rtl::OUString& rString
									);
			BOOL				GetPropDouble(
									double& rValue,
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp,
									const rtl::OUString& rString
									);

			void				GetChartType();

			ColorData			GetColor(
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp,
									const rtl::OUString& rString
									);
			void				GetTextColor(
									Color& rColor, UINT16& rIndex,
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp
									);

            bool                CreateXclFont(
                                    XclExpFontData& rFontData,
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp
									);

			UINT16				GetFontx(
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp
									);
			void				GetTextFormat(
									UINT16& rFontx,
									Color& rColor, UINT16& rColIndex,
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp
									);

			void				GetLineformat(
									UINT16& rStyle, INT16& rWidth,
									Color& rColor, UINT16& rColIndex,
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp
									);
			void				GetAreaformat(
									UINT16& rStyle, Color& rColor, UINT16& rColIndex,
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp
									);

            void                RegisterEscherColor(
                                    EscherPropertyContainer& rPropSet,
                                    sal_uInt16 nPropId, XclExpColorType eColorType
                                    );
            EscherPropertyContainer* CreateGelframe(
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp
                                    );

			BOOL				GetDataCaption(
									UINT16& rTextFlags, UINT16& rLabelFlags,
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp
									);

			void				GetFormats(
									XclChartDataFormat& rFormats,
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp,
									BOOL bGetLineArea, BOOL bGetText
									);

	// initialization, global functions
			void				InitChartFormats();

								// FALSE	= find formats (colors, fonts, number formats)
								// TRUE		= save the chart
			void				GoThroughChart( BOOL bSetWriteMode );

			BOOL				InitInterface();
			void				InitValues();
			void				AppendToSeriesNUpnList( const ScAddress* pA );
			void				BuildSeriesList();

	// writing records...
	inline	void				StartRecord( UINT16 nRecNum, ULONG nRecLen )
												{ pStrm->StartRecord( nRecNum, nRecLen ); }
	inline	void				EndRecord()		{ pStrm->EndRecord(); }

	inline	void				WriteEmptyRecord( UINT16 nRecNum );
	inline	void				WriteUINT16Record( UINT16 nRecNum, UINT16 nData );

			void				WriteBeginLevel();
			void				WriteEndLevel();

			void				WriteSheetHeaderSetup();
			void				WriteChart();
			void				WriteShtprops();

	inline	void				WriteRGB( ColorData nRGB );

	// FRAME group
			void				WriteGroupFrame(
                                    const CSS::uno::Reference< CSS::drawing::XShape >& xShape,
									BOOL bAutoSize = TRUE
									);
			void				WriteGroupFrame(
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp,
									BOOL bAutoSize = TRUE
									);
			void				WriteFrame( BOOL bAutoSize );

			void				WriteLineformat(
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp,
									UINT16 nGrbit = 0x0000
									);
			void				WriteLineformat( const XclChartDataFormat& rF, UINT16 nGrbit = 0x0000 );
			void				WriteLineformat(
									ColorData nRGB, UINT16 nIndex,
									UINT16 nStyle, INT16 nWidth, UINT16 nGrbit
									);

			void				WriteAreaformat(
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp,
									UINT16 nGrbit = 0x0000
									);
			void				WriteAreaformat( const XclChartDataFormat& rF, UINT16 nGrbit = 0x0000 );
			void				WriteAreaformat(
									ColorData nForeRGB, ColorData nBackRGB,
									UINT16 nForeIndex, UINT16 nBackIndex,
									UINT16 nStyle, UINT16 nGrbit
									);

			void				WriteGelframe(
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp
									);
			void				WriteGelframe( const XclChartDataFormat& rF );
            void                WriteGelframe( EscherPropertyContainer& rGelframe );

	// POS record - position, size, rotation
			void				WritePos(
                                    const CSS::uno::Reference< CSS::drawing::XShape >& xShape,
									TextType eType
									);
			void				WritePos( const XclPosSize& rPos, TextType eType );

			void				WritePosData(
                                    const CSS::uno::Reference< CSS::drawing::XShape >& xShape,
									TextType eType
									);
			void				WritePosData( const XclPosSize& rPos, TextType eType );

			INT32				GetDefRelPos(
									INT32 nPos, INT32 nSize,
									INT32 nParPos, INT32 nParSize,
									DefaultAlign eDefAlign, INT32 nDist,
									INT32 nScaling = 4000
									);

			void				GetPosSize(
									XclPosSize& rP,
                                    const CSS::uno::Reference< CSS::drawing::XShape >& xShape
									);

			BOOL				GetRotation(
									UINT16& nRealAngle,
									UINT16& nExcAngle,
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp
									);
			UINT16				GetRotationFlags( UINT16 nExcAngle );

	// TEXT group
			void				WriteTheText();
			void				WriteDefaulttext( UINT16 nId );
			void				WriteGroupText(
                                    const CSS::uno::Reference< CSS::drawing::XShape >& xTextShape,
									TextType eType
									);
			void				WriteGroupText(
									UINT16 nSeries, UINT16 nPoint, UINT16 nFontx,
									ColorData nRGB, UINT16 nIndex, UINT16 nFlags
									);

			void				WriteText(
                                    const CSS::uno::Reference< CSS::drawing::XShape >& xTextShape,
									const XclPosSize& rPosSize,
									TextType eType
									);
			void				WriteText(
									const XclPosSize& rPosSize,
									ColorData nRGB, UINT16 nIndex,
									TextType eType,
									UINT16 nFlags
									);

			void				WriteFontx(
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp
									);
			void				WriteFontx( UINT16 nFontx );
			void				WriteAI();
			void				WriteSeriestext(
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp
									);
            void                WriteSeriestext( const XclExpString& rString );
			void				WriteObjectlink( UINT16 nLinkObj, UINT16 nLinkVar1, UINT16 nLinkVar2 );

			void				WriteTextList();

	// SERIES group
			void				WriteTheSeries();
			void				WriteGroupSeries(
									UINT16 nSeriesCnt,
									UINT16 nSeriesIndex,
									UINT16 nSeriesNumber,
									UINT16 nXCatCount,
									UINT16 nYValCount,
                                    XclExpTokenArrayRef xYUPN,
                                    XclExpTokenArrayRef xXUPN,
                                    XclExpTokenArrayRef xNUPN
									);
			void				WriteSeries( UINT16 nXValCount, UINT16 nYValCount );

	// DATAFORMAT group
			void				WriteGroupDataformat(
									UINT16 nSeriesIndex,
									UINT16 nSeriesNumber,
									UINT16 nSeriesPoint,
									const XclChartDataFormat& rFormats
									);
			void				WriteDataformat(
									UINT16 nSeriesIndex,
									UINT16 nSeriesNumber,
									UINT16 nSeriesPoint
									);
			void				Write3DDataformat( const XclChartDataFormat& rFormats );
			void				WriteMarkerformat( UINT16 nType, UINT16 nBordInd, UINT16 nFillInd );
			void				WriteSerfmt( UINT16 nFlags );
			void				WriteAttachedLabel( UINT16 nFlags );
			void				WriteSertocrt();
            void                WriteAI( XclExpTokenArrayRef xUPN, UINT8 nType, UINT8 nRef, UINT16 nFmt );

	// AXIS group
			void				WriteAllAxes();
			void				WriteAxesused( UINT16 nNumber );
            void                WriteTheAxes( UINT16 nNewAxesSet );
			void				WriteAxisparent();
			void				WritePlotarea();
            void                WriteGroupAxis( UINT16 nNewAxis );
			void				WriteFirstXAxis(
                                    CSS::uno::Reference< CSS::drawing::XShape >& xTitle,
                                    TextType& rType,
                                    BOOL bMaxCross
									);
//            void                WriteSecondXAxis();
			void				WriteFirstYAxis(
                                    CSS::uno::Reference< CSS::drawing::XShape >& xTitle,
									TextType& rType,
									BOOL bWriteExtras
									);
			void				WriteSecondYAxis();
			void				WriteFirstZAxis(
                                    CSS::uno::Reference< CSS::drawing::XShape >& xTitle,
									TextType& rType
									);
			void				WriteAxis();
			void				WriteXZRange();
			void				WriteCatserrange();
			void				WriteAxcext();
			BOOL				WriteTick(
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp,
									BOOL bHasDescr
									);
			void				WriteValuerange(
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp,
                                    BOOL bMaxCross
									);
			void				WriteIfmt(
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp
									);
			void				WriteTheAxisline(
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp,
									UINT16 nId, BOOL bTicks = FALSE
									);
			void				WriteTheAxisframe(
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xProp,
									UINT16 nId
									);
			void				WriteAxislineformat( UINT16 nId );

	// chart formats
            void                WriteGroupChartformat();
			void				WriteChartformat( UINT16 nZOrder );
			void				WriteSerieslist( UINT16 nAxesSet );
			void				Write3D();
			void				WriteTheChartline( UINT16 nId );
			void				WriteChartline( UINT16 nId );
			void				WriteTheDropbars();
			void				WriteGroupDropbar( UINT16 nBar );
			void				WriteDropbar();

	// chart types
	inline	void				WriteLine()		{ WriteLineArea( 0x1018 ); }
	inline	void				WriteArea()		{ WriteLineArea( 0x101A ); }
			void				WriteLineArea( UINT16 nRecId );
			void				WriteBar();
			void				WritePie();
			void				WritePieformat( UINT16 nPercent );
			void				WriteScatter();
			void				WriteRadar();

	// main title, legend
			void				WriteTheMainTitle();

			void				WriteGroupLegend();
			void				WriteLegend(
                                    const CSS::uno::Reference< CSS::drawing::XShape >& xShape
									);
	// SIINDEX
			void				WriteTheSiindex();
			void				WriteSiindex( UINT16 nIndex );

public:
                                XclObjChart( const XclExpRoot& rRoot,
                                    const CSS::uno::Reference< CSS::drawing::XShape >& rShape
									);
	virtual						~XclObjChart();

	virtual	void				Save( XclExpStream& rStrm );
};


inline void XclObjChart::WriteEmptyRecord( UINT16 nRecNum )
{
	pStrm->StartRecord( nRecNum, 0 );
	pStrm->EndRecord();
}

inline void XclObjChart::WriteUINT16Record( UINT16 nRecNum, UINT16 nData )
{
	pStrm->StartRecord( nRecNum, 2 );
	*pStrm << nData;
	pStrm->EndRecord();
}

inline void XclObjChart::WriteRGB( ColorData nRGB )
{
	*pStrm	<< COLORDATA_RED( nRGB )
			<< COLORDATA_GREEN( nRGB )
			<< COLORDATA_BLUE( nRGB )
			<< (UINT8)0;
}


#endif

