/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: SchXMLWrapper.hxx,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 23:27:25 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SCH_XMLWRP_HXX_
#define _SCH_XMLWRP_HXX_

#include <sot/storage.hxx>

class SfxMedium;

namespace com { namespace sun { namespace star {
	namespace xml {
		namespace sax {
			class XParser;
		}
	}
	namespace document {
		class XGraphicObjectResolver;
	}
	namespace frame {
		class XModel;
	}
	namespace task {
		class XStatusIndicator;
	}
	namespace lang {
		class XMultiServiceFactory;
	}
    namespace io {
        class XActiveDataSource;
    }
    namespace embed {
        class XStorage;
    }
    namespace beans {
        class XPropertySet;
    }
}}}

class SchXMLWrapper
{
	::com::sun::star::uno::Reference< ::com::sun::star::frame::XModel > mxModel;
	::com::sun::star::uno::Reference< ::com::sun::star::task::XStatusIndicator > mxStatusIndicator;
    ::com::sun::star::uno::Reference< ::com::sun::star::embed::XStorage > mxStorage;
    SfxMedium* mpMedium;

	sal_Bool mbIsDraw : 1;
	sal_Bool mbShowProgress : 1;

	sal_Int32 ImportStream(
		const ::rtl::OUString& rsStreamName,
		const ::rtl::OUString& rsServiceName,
		::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XParser >& xParser,
		::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory>& xServiceFactory,
		::com::sun::star::uno::Reference< ::com::sun::star::document::XGraphicObjectResolver >& xGraphObjResolver,
		::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet >& xPropSet );

	sal_Bool ExportStream(
		const ::rtl::OUString& rsStreamName,
		const ::rtl::OUString& rsServiceName,
		::com::sun::star::uno::Reference< ::com::sun::star::io::XActiveDataSource >& xDataSource,
		::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory>& xServiceFactory,
		::com::sun::star::uno::Sequence< ::com::sun::star::uno::Any >& aArgs );

public:
    SchXMLWrapper(  const ::com::sun::star::uno::Reference< com::sun::star::frame::XModel >& xModel,
                    SfxMedium& rMedium,
				   sal_Bool bShowProgress = TRUE );

	sal_Int32 Import();
	sal_Bool Export();
};

#endif	// _SCH_XMLWRP_HXX_
