/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: un3dview.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 00:26:58 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

#include "schdll.hxx"
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#include "chtscene.hxx"
#include <svx/camera3d.hxx>
#include "un3dview.hxx"

TYPEINIT1(SchUndo3DView, SchUndoAction);


/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchUndo3DView::Undo()
{
	DoIt(nOldXAngle,nOldYAngle,nOldZAngle);
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchUndo3DView::Redo()
{
	DoIt(nNewXAngle,nNewYAngle,nNewZAngle);
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

BOOL SchUndo3DView::CanRepeat(SfxRepeatTarget& rView) const
{
	return FALSE;
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchUndo3DView::DoIt(short nX, short nY, short nZ)
{
	rDoc.SetAngles (nX, nY, nZ);

	if (rDoc.IsReal3D())//IsAxisChart())
	{

		ChartScene* pScene = rDoc.GetScene();
		Camera3D aCam(pScene->GetCamera());

		/*
		Rectangle aRect = rDoc.GetChartRect();
		long	nW = aRect.GetWidth();
		long	nH = aRect.GetHeight();
		aCam.SetViewWindow(-nW/2, -nH/2, nW, nH);
		*/

		aCam.Reset();
		//aCam.SetProjection(rDoc.GetProjection());
		aCam.RotateAroundLookAt(DEG2RAD((double)nY / (double)10),
								DEG2RAD((double)nX / (double)10));
		aCam.SetBankAngle(DEG2RAD(-(double)nZ / (double)10));
		pScene->SetCamera(aCam);
	}

	//rDoc.SetChanged();
		//if( !rDoc.IsReal3D() ||rDoc.ShowXAxisTitle() ||  rDoc.ShowYAxisTitle() || rDoc.ShowZAxisTitle())
	rDoc.BuildChart(FALSE);
		//ele pWindow->Invalidate();
}



