/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: inspage.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 04:04:31 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef SD_DLLIMPLEMENTATION
#undef SD_DLLIMPLEMENTATION
#endif

#pragma hdrstop

#ifndef _SFXITEMSET_HXX //autogen
#include <svtools/itemset.hxx>
#endif

#include "strings.hrc"
#include "sdattr.hxx"
#include "sdresid.hxx"
#include "ins_page.hxx"
#include "ins_page.hrc"

/*************************************************************************
|*
|*    SdInsertLayerDlg::SdInsertLayerDlg()
|*
|*    Beschreibung      Dialog-Klasse zum Einfuegen einer Ebene
|*    Ersterstellung    13.10.94
|*    Letzte Aenderung  13.10.94
|*
*************************************************************************/

SdInsertLayerDlg::SdInsertLayerDlg( Window* pWindow,
								  const SfxItemSet& rInAttrs,
								  BOOL bDeletable,
								  String aStr ) :
				ModalDialog             ( pWindow, SdResId( DLG_INSERT_LAYER ) ),
				aFtName                 ( this, SdResId( FT_NAME ) ),
				aEdtName                ( this, SdResId( EDT_NAME ) ),
				aCbxVisible             ( this, SdResId( CBX_VISIBLE ) ),
				aCbxPrintable           ( this, SdResId( CBX_PRINTABLE ) ),
				aCbxLocked              ( this, SdResId( CBX_LOCKED ) ),
				//aRbtThisPage          ( this, SdResId( RBT_THISPAGE ) ),
				//aRbtAllPages          ( this, SdResId( RBT_ALLPAGES ) ),
				aGrpOptions             ( this, SdResId( GRP_OPTIONS ) ),
				aBtnOK                  ( this, SdResId( BTN_OK ) ),
				aBtnCancel              ( this, SdResId( BTN_CANCEL ) ),
				aBtnHelp                ( this, SdResId( BTN_HELP ) ),
				aBtnDelete              ( this, SdResId( BTN_DELETE ) ),
				rOutAttrs               ( rInAttrs )
{
	FreeResource();

	aBtnDelete.SetClickHdl( LINK ( this, SdInsertLayerDlg, DeleteButtonHdl ) );

	SetText( aStr );
	if( aStr == String(SdResId( STR_INSERTLAYER )) )
		aBtnDelete.Hide();

	aEdtName.SetText( ( ( const SdAttrLayerName& ) rOutAttrs.Get( ATTR_LAYER_NAME ) ).GetValue() );
	aCbxVisible.Check( ( ( const SdAttrLayerVisible& ) rOutAttrs.Get( ATTR_LAYER_VISIBLE ) ).GetValue() );
	aCbxPrintable.Check( ( ( const SdAttrLayerPrintable& ) rOutAttrs.Get( ATTR_LAYER_PRINTABLE ) ).GetValue() );
	aCbxLocked.Check( ( ( const SdAttrLayerLocked& ) rOutAttrs.Get( ATTR_LAYER_LOCKED ) ).GetValue() );

	if( !bDeletable )
	{
		aFtName.Disable();
		aEdtName.Disable();
		aBtnDelete.Disable();
	}
	else
		aBtnDelete.Disable(); // Temporr !!! (wird noch gendert)
}

#if defined HP9000 || defined SINIX
SdInsertLayerDlg::SdInsertLayerDlg( Window* pWindow,
								  const SfxItemSet& rInAttrs,
								  BOOL bDeletable):
				ModalDialog             ( pWindow, SdResId( DLG_INSERT_LAYER ) ),
				aFtName                 ( this, SdResId( FT_NAME ) ),
				aEdtName                ( this, SdResId( EDT_NAME ) ),
				aCbxVisible             ( this, SdResId( CBX_VISIBLE ) ),
				aCbxPrintable           ( this, SdResId( CBX_PRINTABLE ) ),
				aCbxLocked              ( this, SdResId( CBX_LOCKED ) ),
				//aRbtThisPage          ( this, SdResId( RBT_THISPAGE ) ),
				//aRbtAllPages          ( this, SdResId( RBT_ALLPAGES ) ),
				aGrpOptions             ( this, SdResId( GRP_OPTIONS ) ),
				aBtnOK                  ( this, SdResId( BTN_OK ) ),
				aBtnCancel              ( this, SdResId( BTN_CANCEL ) ),
				aBtnHelp                ( this, SdResId( BTN_HELP ) ),
				aBtnDelete              ( this, SdResId( BTN_DELETE ) ),
				rOutAttrs               ( rInAttrs )
{
	FreeResource();

	aBtnDelete.SetClickHdl( LINK ( this, SdInsertLayerDlg, DeleteButtonHdl ) );
	String aStr( SdResId( STR_INSERTLAYER ) );
	SetText( aStr );
	aBtnDelete.Hide();

	aEdtName.SetText( ( ( const SdAttrLayerName& ) rOutAttrs.Get( ATTR_LAYER_NAME ) ).GetValue() );
	aCbxVisible.Check( ( ( const SdAttrLayerVisible& ) rOutAttrs.Get( ATTR_LAYER_VISIBLE ) ).GetValue() );
	aCbxPrintable.Check( ( ( const SdAttrLayerPrintable& ) rOutAttrs.Get( ATTR_LAYER_PRINTABLE ) ).GetValue() );
	aCbxLocked.Check( ( ( const SdAttrLayerLocked& ) rOutAttrs.Get( ATTR_LAYER_LOCKED ) ).GetValue() );

	if( !bDeletable )
	{
		aFtName.Disable();
		aEdtName.Disable();
		aBtnDelete.Disable();
	}
	else
		aBtnDelete.Disable(); // Temporr !!! (wird noch gendert)
}

#endif

/*************************************************************************
|*
|*    SdInsertLayerDlg::GetAttr()
|*
|*    Beschreibung      Fuellt uebergebenen Item-Set mit Dialogbox-
|*                                              Attributen
|*    Letzte Aenderung  13.10.94
|*
*************************************************************************/

void SdInsertLayerDlg::GetAttr( SfxItemSet& rOutAttrs )
{
	rOutAttrs.Put( SdAttrLayerName( aEdtName.GetText() ) );
	rOutAttrs.Put( SdAttrLayerVisible( aCbxVisible.IsChecked() ) );
	rOutAttrs.Put( SdAttrLayerPrintable( aCbxPrintable.IsChecked() ) );
	rOutAttrs.Put( SdAttrLayerLocked( aCbxLocked.IsChecked() ) );

	//rOutAttrs.Put( SdAttrLayerThisPage( aRbtThisPage.IsChecked() ) );
}


/*************************************************************************
|*      Handler: beendet Dialog und liefert
\************************************************************************/

IMPL_LINK_INLINE_START( SdInsertLayerDlg, DeleteButtonHdl, Button *, EMPTYARG )
{
	EndDialog( RET_DELETE );
	return 0;
}
IMPL_LINK_INLINE_END( SdInsertLayerDlg, DeleteButtonHdl, Button *, EMPTYARG )
