/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: SlsPreviewBitmapFactory.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 06:11:18 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef SD_SLIDESORTER_PREVIEW_BITMAP_FACTORY_HXX
#define SD_SLIDESORTER_PREVIEW_BITMAP_FACTORY_HXX

class Link;
class Rectangle;
class SdrPageView;
class SdrPaintInfoRec;

#include <svx/svdtypes.hxx>
#include <vcl/bitmapex.hxx>
#include <memory>

namespace sd { namespace slidesorter { namespace view {
class SlideSorterView;
class PageObjectViewObjectContact;
} } }

namespace sd { namespace slidesorter { namespace cache {

class PreviewBitmapFactory
{
public:
    PreviewBitmapFactory (view::SlideSorterView& rView);

    BitmapEx CreateBitmap (view::PageObjectViewObjectContact& rContact);

private:
    view::SlideSorterView& mrView;

    ::std::auto_ptr<SdrPaintInfoRec> mpInfoRectangle;

    /** Make sure that mpInfoRectangle holds an info rectangle and that it
        is set up according to the given parameters.
        At the moment a new info rectangle is created every time this method
        is called.  This may be optimized in the future.
    */
    void ProvideInfoRectangle (
        const Rectangle& rDirtyRect, 
        SdrPageView* pPageView);
};



} } } // end of namespace ::sd::slidesorter::cache

#endif
