
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <msiquery.h>
#include <string>
#include <malloc.h>

#define MY_STRINGIFY_EX( x ) #x
#define MY_STRINGIFY( x ) MY_STRINGIFY_EX( x )

/*
    Conversion of the following Basic procedure to a MSI custom action:
    
    Sub PythonInst
        On Error goto PYTHON_END
        fileHandle = FreeFile
        open curdir()+"\python.bat" for Output Access Write as fileHandle
        print #filehandle, "@echo off"
        print #filehandle, "set PATH_OLD=%PATH%"
        print #filehandle, "set PATH=%PATH%;"+curdir()
        print #fileHandle, "set PYTHONPATH="+curdir()+";"+curdir()+"\python-core-2.3.4\lib"
        print #fileHandle, "set PYTHONHOME="+curdir()+"\python-core-2.3.4"
        print #fileHandle, chr(34)+curdir()+"\python-core-2.3.4\bin\python.exe" + chr(34)+" %1 %2 %3 %4 %5 %6 %7 %8 %9"
        print #filehandle, "set PATH=%PATH_OLD%"
        close #fileHandle

        PYTHON_END:
    End Sub 
*/  

std::string GetOfficeInstallationPath(MSIHANDLE handle)
{
    std::string progpath;
    DWORD sz = 0;
    LPTSTR dummy = TEXT("");
    
    if (MsiGetProperty(handle, TEXT("INSTALLLOCATION"), dummy, &sz) == ERROR_MORE_DATA)
    {
        sz++; // space for the final '\0'
        DWORD nbytes = sz * sizeof(TCHAR);
        LPTSTR buff = reinterpret_cast<LPTSTR>(_alloca(nbytes));
        ZeroMemory(buff, nbytes);
        MsiGetProperty(handle, TEXT("INSTALLLOCATION"), buff, &sz);
        progpath = buff;            
    }
    return progpath;
}

inline bool IsValidHandle(HANDLE handle)
{
    return ((handle != INVALID_HANDLE_VALUE) && (handle != NULL));
}

static const char * g_part1 =
   "@echo off\n"
   "\n"
   "@echo off\n"
   "\n"
   "rem check, whether we have extended features\n"
   "if \"%CMDEXTVERSION%\"==\"\" goto win98\n"
   "\n"
   "setlocal\n"
   "set MYROOT=%~d0%~p0\n"
   "set PATH=%PATH%;%MYROOT%\n"
   "set PYTHONPATH=%MYROOT%;%MYROOT%python-core-" MY_STRINGIFY(PYVERSION) "\\lib;%MYROOT%python-core-" MY_STRINGIFY(PYVERSION) "\\lib\\site-packages\n"
   "set PYTHONHOME=%MYROOT%python-core-" MY_STRINGIFY(PYVERSION) "\n"
   "\"%MYROOT%python-core-" MY_STRINGIFY(PYVERSION) "\\bin\\python.exe\" %*\n"
   "endlocal\n"
   "\n"
   "goto ende\n"
   "\n"
   ":win98\n"
   "set OLD_PATH=%PATH%\n"
   "set MY_PYTHON_ROOT=";

static const char * g_part2 =
   "\n"
   "set PATH=%PATH%;\"%MY_PYTHON_ROOT%\"\n"
   "set PYTHONPATH=%MY_PYTHON_ROOT%;%MY_PYTHON_ROOT%\\python-core-" MY_STRINGIFY(PYVERSION) "\\lib;%MYROOT%python-core-" MY_STRINGIFY(PYVERSION) "\\lib\\site-packages\n"
   "set PYTHONHOME=%MY_PYTHON_ROOT%\\python-core-" MY_STRINGIFY(PYVERSION) "\n"
   "\"%MY_PYTHON_ROOT%\\python-core-" MY_STRINGIFY(PYVERSION) "\\bin\\python.exe\" %1 %2 %3 %4 %5 %6 %7 %8 %9\n"
   "set PATH=%OLD_PATH%\n"
   ":ende\n";



extern "C" UINT __stdcall InstallExecSequenceEntry(MSIHANDLE handle)
{
    //MessageBox(NULL, TEXT("InstallExecSequenceEntry"), TEXT("Pythonmsi"), MB_OK | MB_ICONINFORMATION);
        
    std::string python_bat_path = GetOfficeInstallationPath(handle) + TEXT("program\\python.bat");
    
    HANDLE hfile = CreateFile(
        python_bat_path.c_str(),
        GENERIC_WRITE,
        0,
        NULL,
        CREATE_NEW,
        FILE_ATTRIBUTE_NORMAL,
        NULL);
    
    if (IsValidHandle(hfile))
    {
        std::string inst_prog_path = GetOfficeInstallationPath(handle) + std::string("program");

        std::string strToWrite( g_part1 );
        strToWrite += inst_prog_path;
        strToWrite += g_part2;
        
        DWORD dummy;
        WriteFile( hfile, strToWrite.c_str(), strToWrite.size() ,&dummy, 0 );
        
        CloseHandle(hfile);            
    }                            
    
    return ERROR_SUCCESS;    
}

extern "C" UINT __stdcall DeinstallExecSequenceEntry(MSIHANDLE handle)
{
    //MessageBox(NULL, TEXT("DeinstallExecSequenceEntry"), TEXT("Pythonmsi"), MB_OK | MB_ICONINFORMATION);
    
    std::string python_bat_path = GetOfficeInstallationPath(handle) + TEXT("program\\python.bat");
    DeleteFile(python_bat_path.c_str());
    
    return ERROR_SUCCESS;
}
