/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: strcrypt.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 13:58:03 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SVTOOLS_STRCRYPT_HXX_
#define _SVTOOLS_STRCRYPT_HXX_

class ByteString;

//============================================================================
/** Encrypt and encode a byte string.

	@param rSource  A byte string (that may not contain null bytes).

	@return  If rSource is empty, an empty string is returned.  Otherwise, a
	string of length O(n), where n is the length of rSource, is returned, that
	contains only visible ASCII characters.  SvStringDecode() will decode and
	decrypt such a string to its original form.
 */
ByteString SvStringEncode(ByteString const & rSource);

//============================================================================
/** Decode and decrypt a byte string.

	@param rSource  A byte string.

	@return  If rSource is empty, or is not encrypted using SvStringEncode(),
	an empty string is returned.  Otherwise, the decrypted and decoded version
	of rSource is returned.
 */
ByteString SvStringDecode(ByteString const & rSource);

#endif // _SVTOOLS_STRCRYPT_HXX_

