/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svdpagv.hxx,v $
 *
 *  $Revision: 1.23 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 18:53:02 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SVDPAGV_HXX
#define _SVDPAGV_HXX

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif

#ifndef _COM_SUN_STAR_AWT_XWINDOWLISTENER_HPP_
#include <com/sun/star/awt/XWindowListener.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYCHANGELISTENER_HPP_
#include <com/sun/star/beans/XPropertyChangeListener.hpp>
#endif
#ifndef _COM_SUN_STAR_AWT_XIMAGECONSUMER_HPP_
#include <com/sun/star/awt/XImageConsumer.hpp>
#endif
#ifndef _COM_SUN_STAR_AWT_XCONTROL_HPP_
#include <com/sun/star/awt/XControl.hpp>
#endif
#ifndef _COM_SUN_STAR_AWT_XCONTROLCONTAINER_HPP_
#include <com/sun/star/awt/XControlContainer.hpp>
#endif
#ifndef _COM_SUN_STAR_UTIL_XMODECHANGELISTENER_HPP_
#include <com/sun/star/util/XModeChangeListener.hpp>
#endif

#ifndef _SFXLSTNER_HXX //autogen
#include <svtools/lstner.hxx>
#endif
#ifndef _APP_HXX //autogen
#include <vcl/svapp.hxx>
#endif
#ifndef _SVDLAYER_HXX
#include "svdlayer.hxx"
#endif
#ifndef _SVDHLPLN_HXX
#include "svdhlpln.hxx"
#endif

#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif

#ifndef INCLUDED_SVXDLLAPI_H
#include "svx/svxdllapi.h"
#endif

#include <cppuhelper/implbase4.hxx> 
#include <vector>

////////////////////////////////////////////////////////////////////////////////////////////////////

class Region;
class Link;
class OutputDevice;
class XOutputDevice;
class SdrPaintInfoRec;
class XPolyPolygon;
class SdrObjListIter;
class SdrObjList;
class SdrObject;
class SdrModel;
class SdrPage;
class SdrUnoObj;
class SdrPageObj;
class B2dIAOManager;
class SdrPageView;
class SdrView;

// #110094#
namespace sdr
{
	namespace contact
	{
		class ObjectContact;
		class DisplayInfo;
		class ViewObjectContactRedirector;
	} // end of namespace contact
} // end of namespace sdr

//class SdrPageViewWinList;
class SdrUnoControlList;

#define SDRUNOCONTROL_NOTFOUND USHRT_MAX

////////////////////////////////////////////////////////////////////////////////////////////////////
//	Listener an den UnoControls

class SdrUnoControlRec : public ::cppu::WeakImplHelper4<
	::com::sun::star::awt::XWindowListener,
	::com::sun::star::beans::XPropertyChangeListener,
	::com::sun::star::awt::XImageConsumer,
	::com::sun::star::util::XModeChangeListener >
{
	SdrUnoControlList*		pParent;
	SdrUnoObj*				pObj;
    bool                    bVisible : 1;
    bool                    bDisposed : 1;
    bool                    bIsListening : 1;
    sal_uInt16              mnPaintLevel;
    
	::com::sun::star::uno::Reference< ::com::sun::star::awt::XControl > xControl;

public:
	SdrUnoControlRec(SdrUnoControlList*	_pParent, SdrUnoObj* _pObj, ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControl > _xControl) throw();
	~SdrUnoControlRec() throw();

protected:
	// XEventListener
    virtual void SAL_CALL disposing( const ::com::sun::star::lang::EventObject& Source ) throw(::com::sun::star::uno::RuntimeException);

	// XWindowListener
    virtual void SAL_CALL windowResized( const ::com::sun::star::awt::WindowEvent& e ) throw(::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL windowMoved( const ::com::sun::star::awt::WindowEvent& e ) throw(::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL windowShown( const ::com::sun::star::lang::EventObject& e ) throw(::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL windowHidden( const ::com::sun::star::lang::EventObject& e ) throw(::com::sun::star::uno::RuntimeException);

	// XPropertyChangeListener
    virtual void SAL_CALL propertyChange( const ::com::sun::star::beans::PropertyChangeEvent& evt ) throw(::com::sun::star::uno::RuntimeException);

	// XImageConsumer
    virtual void SAL_CALL init( sal_Int32 Width, sal_Int32 Height ) throw(::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL setColorModel( sal_Int16 BitCount, const ::com::sun::star::uno::Sequence< sal_Int32 >& RGBAPal, sal_Int32 RedMask, sal_Int32 GreenMask, sal_Int32 BlueMask, sal_Int32 AlphaMask ) throw(::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL setPixelsByBytes( sal_Int32 nX, sal_Int32 nY, sal_Int32 nWidth, sal_Int32 nHeight, const ::com::sun::star::uno::Sequence< sal_Int8 >& aProducerData, sal_Int32 nOffset, sal_Int32 nScanSize ) throw(::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL setPixelsByLongs( sal_Int32 nX, sal_Int32 nY, sal_Int32 nWidth, sal_Int32 nHeight, const ::com::sun::star::uno::Sequence< sal_Int32 >& aProducerData, sal_Int32 nOffset, sal_Int32 nScanSize ) throw(::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL complete( sal_Int32 Status, const ::com::sun::star::uno::Reference< ::com::sun::star::awt::XImageProducer >& xProducer ) throw(::com::sun::star::uno::RuntimeException);

    // XModeChangeListener
    virtual void SAL_CALL modeChanged( const ::com::sun::star::util::ModeChangeEvent& _rSource ) throw (::com::sun::star::uno::RuntimeException);

public:
	// More functions
	::com::sun::star::uno::Reference< ::com::sun::star::awt::XControl > GetControl() const {return xControl;}
	BOOL               IsVisible() const {return bVisible;}
	BOOL               IsListening() const {return bIsListening;}
	SdrUnoObj*         GetUnoObj() const { return pObj; }

	// Setzen eines neuen Controls
	void ReplaceControl( ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControl > _xControl);
	void Clear(BOOL bDispose);

    struct AccessControl { friend class SdrUnoControlPaintGuard; private: AccessControl() { } };
    inline void EnterPaint( const AccessControl& )  { ++mnPaintLevel; }
    inline void LeavePaint( const AccessControl& )  { DBG_ASSERT( mnPaintLevel, "SdrUnoControlRec::LeavePaint: not locked!" ); --mnPaintLevel; }

    // in alive mode, the visibility of the control must be adjusted to the visibility of the layer
    void    adjustControlVisibility( bool _bForce );

private:
    // starts or stops listening for any relevant events on the control or it's model
    void    switchControlListening( bool _bStart );

    // starts or stops listening for interesting properties at the model
    void    switchPropertyListening( bool _bStart, bool _bListenForAll );

    // starts listening for changes which are relevant in design mode only
    void    switchDesignModeListening( bool _bStart );
};

////////////////////////////////////////////////////////////////////////////////////////////////////
// class for temporarily (during painting) locking some functionality of the SdrUnoControlRec

class SdrUnoControlPaintGuard
{
private:
    SdrUnoControlRec&  m_rRec;

public:
    inline SdrUnoControlPaintGuard( SdrUnoControlRec& _rRec )
        :m_rRec( _rRec )
    {
        m_rRec.EnterPaint( SdrUnoControlRec::AccessControl( ) );
    }
    inline ~SdrUnoControlPaintGuard( )
    {
        m_rRec.LeavePaint( SdrUnoControlRec::AccessControl( ) );
    }
};

////////////////////////////////////////////////////////////////////////////////////////////////////
// Klasse fuer den schnellen Zugriff auf Recs ueber das ControlModel

class SdrUnoControlAccess
{
public:
	SdrUnoControlRec* pControlRec;
	::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlModel > xControlModel;

	SdrUnoControlAccess(::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlModel > _xControlModel, SdrUnoControlRec* _pControlRec = NULL)
		:pControlRec( _pControlRec )
		,xControlModel( _xControlModel )
	{};
    SdrUnoControlAccess()
    {
        pControlRec = NULL;
    };

	BOOL operator==( const SdrUnoControlAccess& rAcc ) const
	{
		::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface > xInt1( xControlModel, ::com::sun::star::uno::UNO_QUERY );
		::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface > xInt2( rAcc.xControlModel, ::com::sun::star::uno::UNO_QUERY );
		return ((::com::sun::star::uno::XInterface*)xInt1.get()) == ((::com::sun::star::uno::XInterface*)xInt2.get());
	}
	BOOL operator<( const SdrUnoControlAccess& rAcc ) const
	{
		return xControlModel.get() < rAcc.xControlModel.get();
	}
};

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef SdrUnoControlAccess* SdrUnoControlAccessPtr;
SV_DECL_PTRARR_SORT( SdrUnoControlAccessArr, SdrUnoControlAccessPtr, 16, 16 )

class SdrUnoControlList
{
	friend class SdrUnoControlRec;

	Container aList;
	SdrUnoControlAccessArr aAccessArr;
    SdrPageView&            rPageView;

protected:
	SdrUnoControlRec* GetObject(USHORT i) const;
	void              Disposing(SdrUnoControlRec* pRec);

public:
	SdrUnoControlList( SdrPageView& _rPageView )
		:aList(1024,4,4)
        ,rPageView( _rPageView )
	{}
	~SdrUnoControlList()                                              { Clear(TRUE); }
	void              Clear(BOOL bDispose);
	USHORT            GetCount() const                                { return (USHORT)aList.Count(); }
	void              Insert(SdrUnoControlRec* pRec);
	void              Delete(USHORT nPos, BOOL bDispose);
	SdrUnoControlRec&       operator[](USHORT nPos)                    { return *GetObject(nPos); }
	const SdrUnoControlRec& operator[](USHORT nPos) const              { return *GetObject(nPos); }
	USHORT            Find(SdrUnoControlRec* pUCR) const;
	USHORT            Find(::com::sun::star::uno::Reference< ::com::sun::star::awt::XControl > rUnoControl) const;
	USHORT            Find(::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlModel > rUnoControlModel) const;
};

////////////////////////////////////////////////////////////////////////////////////////////////////

class SVX_DLLPUBLIC SdrPageViewWindow
{
	// #110094# ObjectContact section
	sdr::contact::ObjectContact*						mpObjectContact;

	// the SdrPageView this window belongs to
	SdrPageView&										mrPageView;

	// the OutputDevice this window has to handle
	OutputDevice&										mrOutputDevice;

	// the IAOManager. It will exist if mpOutputDevice is set and is a window
	B2dIAOManager*										mpIAOManager;

	// UNO stuff for xControls
	SdrUnoControlList*									mpControlList;
	::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlContainer > mxControlContainer;

	// #110094# ObjectContact section
	sdr::contact::ObjectContact* CreateViewSpecificObjectContact();

	// support method for creating PageInfoRecs for painting
	SdrPaintInfoRec* ImpCreateNewPageInfoRec(const Rectangle& rDirtyRect, 
		sal_uInt16 nPaintMode, const SdrLayerID* pId) const;

public:
	SdrPageViewWindow(SdrPageView& rNewPageView, OutputDevice& rOut);
	~SdrPageViewWindow();

	// data read accesses
	SdrPageView& GetPageView() const;
	OutputDevice& GetOutputDevice() const;
	SdrUnoControlList& GetControlList() const;
	::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlContainer > GetControlContainerRef() const;
	void CreateControlContainer();
	B2dIAOManager* GetIAOManager() const;

	// the repaint methods. For migration from pPaintProc, use one more parameter
	void Redraw(const Region& rReg, sal_uInt16 nPaintMode, 
		const SdrLayerID* pId, ::sdr::contact::ViewObjectContactRedirector* pRedirector = 0L) const;

	// Invalidate call, used from ObjectContact(OfPageView) in InvalidatePartOfView(...)
	void Invalidate(const Rectangle& rRectangle);

	// #110094# ObjectContact section
	sdr::contact::ObjectContact& GetObjectContact() const;

	// #i26631#
	void ResetObjectContact();
};

//class SdrPageViewWinRec
//{
//friend class SdrPageView;
//	SdrView&							rView;
//	OutputDevice*						pOutDev;
//	B2dIAOManager*						pIAOManager;
//	SdrUnoControlList					aControlList;
//	::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlContainer > xControlContainer;
//
//protected:
//	void                 CreateControlContainer();
//
//public:
//	SdrPageViewWinRec(SdrPageView& rNewPageView, OutputDevice* pOutDev);
//	~SdrPageViewWinRec();
//
//	BOOL                     MatchOutputDevice(OutputDevice* pOut) const;
//	OutputDevice*            GetOutputDevice() const { return pOutDev; }
//	const SdrUnoControlList& GetControlList() const { return aControlList; }
//	::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlContainer >     GetControlContainerRef() const { return xControlContainer; }
//
//	B2dIAOManager* GetIAOManager() const { return pIAOManager; }
//};

////////////////////////////////////////////////////////////////////////////////////////////////////
// typedefs for a list of SdrPageViewWindow
//typedef ::std::vector< SdrPageViewWindow* > SdrPageViewWindowVector;
//
//class SdrPageViewWindows
//{
//	SdrPageViewWindowVector								maVector;
//
//public:
//	SdrPageViewWindows();
//	~SdrPageViewWindows();
//
//	sal_uInt32 WindowCount() const;
//	SdrPageViewWindow* FindWindow(OutputDevice& rOut) const;
//	SdrPageViewWindow* GetWindow(sal_uInt32 nIndex) const;
//
//	void ClearWindows();
//	void AppendWindow(SdrPageViewWindow& rNew);
//	SdrPageViewWindow* RemoveWindow(sal_uInt32 nPos);
//	SdrPageViewWindow* RemoveWindow(SdrPageViewWindow& rOld);
//};
//
////////////////////////////////////////////////////////////////////////////////////////////////////
//
//#define SDRPAGEVIEWWIN_NOTFOUND 0xFFFF
//
//class SdrPageViewWinList {
//	Container aList;
//private:
//	SdrPageViewWinList(const SdrPageViewWinList& rSource): aList(1024,4,4) {}
//	void operator=(const SdrPageViewWinList& rSource)                  {}
//protected:
//	SdrPageViewWinRec* GetObject(USHORT i) const { return (SdrPageViewWinRec*)(aList.GetObject(i)); }
//public:
//	SdrPageViewWinList(): aList(1024,4,4) {}
//	~SdrPageViewWinList()                                                    { Clear(); }
//	void                     Clear();
//	USHORT                   GetCount() const                                { return (USHORT)aList.Count(); }
//	void                     Insert(SdrPageViewWinRec* pVWR, USHORT nPos=0xFFFF) { aList.Insert(pVWR,nPos); }
//	void                     Delete(USHORT nPos)                             { delete (SdrPageViewWinRec*)aList.Remove(nPos); }
//	SdrPageViewWinRec&       operator[](USHORT nPos)                         { return *GetObject(nPos); }
//	const SdrPageViewWinRec& operator[](USHORT nPos) const                   { return *GetObject(nPos); }
//	USHORT                   Find(OutputDevice* pW) const;
//};
//
////////////////////////////////////////////////////////////////////////////////////////////////////

// typedefs for a list of SdrPageViewWindow
typedef ::std::vector< SdrPageViewWindow* > SdrPageViewWindowVector;

class SVX_DLLPUBLIC SdrPageView : public SfxListener 
{
	// friend class SdrPaintView;

	const ::sdr::contact::DisplayInfo*								mpDisplayInfo;

protected:
//    Container     aRedraw;  // Ein Eintrag fuer jedes Win. Dieser Container
	SdrView&														mrView;
	SdrPage*														mpPage;
	Point         aPgOrg;   // Nullpunkt der Page
	Point         aOfs;     // Offset der Page im Win
	//Timer      aGetBack;

	Rectangle     aMarkBound; // wird
	Rectangle     aMarkSnap;  // von
	XPolyPolygon* pDragPoly0; // SdrView
	XPolyPolygon* pDragPoly;  //
	sal_Bool														mbHasMarked;
	sal_Bool														mbVisible;

	SetOfByte    aLayerVisi;   // Menge der sichtbaren Layer
	SetOfByte    aLayerLock;   // Menge der nicht editierbaren Layer
	SetOfByte    aLayerPrn;    // Menge der druckbaren Layer

	SdrObjList*  pAktList;     // Aktuelle Liste, in der Regel die Page.
	SdrObject*   pAktGroup;    // Aktuelle Gruppe. NULL=Keine.

	SdrHelpLineList aHelpLines; // Hilfslinien und -punkte

	// #103834# Use one reserved slot (bReserveBool1) for the background color
	Color		  maBackgroundColor;
	
	// #103911# Use one reserved slot (bReserveBool2) for the document color
	Color		  maDocumentColor;

	// SdrPageViewWinList* pWinList;
	SdrPageViewWindowVector											maWindowVector;
	//SdrPageViewWindows												maPageViewWindows;

	// SdrPageObj*														mpPaintingPageObj;

public:
	// interface to SdrPageViewWindow
	sal_uInt32 WindowCount() const { return maWindowVector.size(); }
	SdrPageViewWindow* FindWindow(OutputDevice& rOut) const;
	SdrPageViewWindow* GetWindow(sal_uInt32 nIndex) const;
	void ClearWindows();
	void AppendWindow(SdrPageViewWindow& rNew);
	SdrPageViewWindow* RemoveWindow(sal_uInt32 nPos);
	SdrPageViewWindow* RemoveWindow(SdrPageViewWindow& rOld);

	void PaintOutlinerView(OutputDevice* pOut, const Rectangle& rRect) const;
private:
	SVX_DLLPRIVATE SdrPageViewWindow& ImpMakePageViewWinRec(OutputDevice& rOut);
	
	//void ImpInsertControl(const SdrUnoObj* pObj, SdrPageViewWinRec* pRec);
	SVX_DLLPRIVATE void ImpInsertControl(const SdrUnoObj* pObj, SdrPageViewWindow& rWindow);
	
	SVX_DLLPRIVATE void ImpUnoInserted(const SdrObject* pObj);
	SVX_DLLPRIVATE void ImpUnoRemoved(const SdrObject* pObj);

protected:
	void ImpInvalidateHelpLineArea(USHORT nNum) const;

protected:
	//USHORT      GetWinCount() const       { return USHORT(aRedraw.Count()); }
	//SdrPageWin* GetWin(USHORT nNum) const { return (SdrPageWin*)(aRedraw.GetObject(nNum)); }
	//void        AddWin()                  { aRedraw.Insert(new SdrPageWin,CONTAINER_APPEND); }
	//void        DelWin(USHORT nNum)       { delete aRedraw.Remove(nNum); }
	//void        ClearWinList();
	// Jeder ContainerEntry muss auf ein OutputDevice zeigen:
	//void        SetWinList(const Container& rWinList);

	void SetLayer(const String& rName, SetOfByte& rBS, sal_Bool bJa);
	sal_Bool IsLayer(const String& rName, const SetOfByte& rBS) const;
	void SetAllLayers(SetOfByte& rB, sal_Bool bJa);

	virtual void SFX_NOTIFY(SfxBroadcaster& rBC, const TypeId& rBCType, const SfxHint& rHint, const TypeId& rHintType);

	// Nachsehen, ob AktGroup noch Inserted ist.
	void CheckAktGroup();

	void AdjHdl();

public:
	TYPEINFO();
	SdrPageView(SdrPage* pPage1, const Point& rOffs, SdrView& rNewView);
	~SdrPageView();

	// Wird von der PaintView gerufen, wenn Modelaenderungen abgeschlossen sind
	void ModelHasChanged();

	void Show();
	void Hide();

	//void AddWin(OutputDevice* pOutDev1);
	//void DelWin(OutputDevice* pOutDev1);
	void AddWindowToPageView(OutputDevice& rOut);
	void DeleteWindowFromPageView(OutputDevice& rOut);

	SdrView& GetView() { return mrView; }
	const SdrView& GetView() const { return mrView; }
	
	//const SdrPageViewWinList& GetWinList() const                { return *pWinList; }
	//const SdrPageViewWindows& GetPageViewWindows() const { return maPageViewWindows; }

    /** looks up the control container belonging to given output device

        @return
            If the given output device belongs to one of the SdrPageViewWinRecs associated with this
            SdrPageView instance, the XControlContainer for this output device is returned, <NULL/>
            otherwise.
    */
    ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlContainer >
		GetControlContainer( const OutputDevice* _pDevice );

	sal_Bool IsVisible() const { return mbVisible; }

	// Invalidiert den gesamten Bereich der Page
	void InvalidateAllWin();

	// rRect bezieht sich auf die Page
	void InvalidateAllWin(const Rectangle& rRect, sal_Bool bPlus1Pix=FALSE);

	// rReg bezieht sich auf's OutDev, nicht auf die Page
	// For migration from pPaintProc, use one more parameter
	void CompleteRedraw(OutputDevice* pGivenTarget, const Region& rReg, sal_uInt16 nPaintMode, 
		::sdr::contact::ViewObjectContactRedirector* pRedirector = 0L) const;

	//#110094#-4
	void DrawLayer(SdrLayerID nID, const Rectangle& rRect, OutputDevice* pGivenTarget = 0L, sal_uInt16 nPaintMode = 0) const;

	//FASTBOOL IsReady() const;

	// #110094#-5		
	//FASTBOOL RedrawOne(USHORT nBrkEvent=INPUT_MOUSEANDKEYBOARD);         // n.i.
	//FASTBOOL RedrawUntilInput(USHORT nBrkEvent=INPUT_MOUSEANDKEYBOARD);  // n.i.
	
	// #110094#-8
	//void DrawPaper(OutputDevice& rOut);
    //void DrawPaperBorder(OutputDevice& rOut);
	//void DrawBorder(OutputDevice& rOut);
	void DrawGrid(OutputDevice& rOut, const Rectangle& rRect, Color aColor = Color( COL_BLACK ) );
	//void DrawGrid(OutputDevice& rOut, Color aColor = Color( COL_BLACK ))                     { DrawGrid(rOut,Rectangle(), aColor); }
	//void DrawHelplines(OutputDevice& rOut);

	// #110094#-7
	//// MasterPage ueber VirtualDevice Painten
	//FASTBOOL DoCachedMasterPaint(const SdrPage* pMasterPage, XOutputDevice& rXOut,
	//							 const SdrPaintInfoRec& InfoRec) const;
	//FASTBOOL DoCachedMasterPaint(const SdrPage* pMasterPage, XOutputDevice& rXOut,
	//							 const SdrPaintInfoRec& InfoRec, ULONG nCacheMode) const;
	//FASTBOOL MasterShouldBeCached(const SdrPage* pMasterPage) const;

	void SetOffset(const Point& rPnt);
	const Point& GetOffset() const { return aOfs; }
	Rectangle GetPageRect() const;
	SdrPage* GetPage() const { return mpPage; }

	// Betretene Liste rausreichen
	SdrObjList* GetObjList() const { return pAktList; }

	// Betretene Gruppe rausreichen
	SdrObject* GetAktGroup() const { return pAktGroup; }

	// Betretene Gruppe und Liste setzen
	void SetAktGroupAndList(SdrObject* pNewGroup, SdrObjList* pNewList);

	sal_Bool HasMarkedObjPageView() const { return mbHasMarked; }
	void SetHasMarkedObj(sal_Bool bOn) { mbHasMarked = bOn; }

	const Rectangle& MarkBound() const { return aMarkBound; }
	const Rectangle& MarkSnap() const { return aMarkSnap; }
	Rectangle& MarkBound() { return aMarkBound; }
	Rectangle& MarkSnap() { return aMarkSnap; }

	//#110094#-10
	//void ShowLayerSet(const String& rName, FASTBOOL bShow=TRUE);
	//FASTBOOL IsLayerSetVisible(const String& rName) const;

	void SetLayerVisible(const String& rName, sal_Bool bShow = sal_True) { SetLayer(rName, aLayerVisi, bShow); if(!bShow) AdjHdl(); InvalidateAllWin(); }
	sal_Bool IsLayerVisible(const String& rName) const { return IsLayer(rName, aLayerVisi); }
	void SetAllLayersVisible(sal_Bool bShow = sal_True) { SetAllLayers(aLayerVisi, bShow); if(!bShow) AdjHdl(); InvalidateAllWin(); }

	void SetLayerLocked(const String& rName, sal_Bool bLock = sal_True) { SetLayer(rName, aLayerLock, bLock); if(bLock) AdjHdl(); }
	sal_Bool IsLayerLocked(const String& rName) const { return IsLayer(rName,aLayerLock); }
	void SetAllLayersLocked(sal_Bool bLock = sal_True) { SetAllLayers(aLayerLock, bLock); if(bLock) AdjHdl(); }

	void SetLayerPrintable(const String& rName, sal_Bool bPrn = sal_True) { SetLayer(rName, aLayerPrn, bPrn); }
	sal_Bool IsLayerPrintable(const String& rName) const { return IsLayer(rName, aLayerPrn); }
	void SetAllLayersPrintable(sal_Bool bPrn = sal_True) { SetAllLayers(aLayerPrn, bPrn); }

	// PV stellt eine RefPage oder eine SubList eines RefObj dar oder Model ist ReadOnly
	sal_Bool IsReadOnly() const;

	// der Origin bezieht sich immer auf die obere linke Ecke der Page
	const Point& GetPageOrigin() const { return aPgOrg; }
	void SetPageOrigin(const Point& rOrg);

	void LogicToPagePos(Point& rPnt) const { rPnt-=aPgOrg; }
	void LogicToPagePos(Rectangle& rRect) const { rRect.Move(-aPgOrg.X(),-aPgOrg.Y()); }
	void PagePosToLogic(Point& rPnt) const { rPnt+=aPgOrg; }
	void PagePosToLogic(Rectangle& rRect) const { rRect.Move(aPgOrg.X(),aPgOrg.Y()); }

	void SetVisibleLayers(const SetOfByte& rSet) { aLayerVisi=rSet; InvalidateAllWin(); }
	const SetOfByte& GetVisibleLayers() const { return aLayerVisi; }
	void SetPrintableLayers(const SetOfByte& rSet) { aLayerPrn=rSet; }
	const SetOfByte& GetPrintableLayers() const { return aLayerPrn;  }
	void SetLockedLayers(const SetOfByte& rSet) { aLayerLock=rSet; }
	const SetOfByte& GetLockedLayers() const { return aLayerLock; }

	const SdrHelpLineList& GetHelpLines() const { return aHelpLines; }
	void SetHelpLines(const SdrHelpLineList& rHLL);
	//void SetHelpLinePos(USHORT nNum, const Point& rNewPos);
	void SetHelpLine(USHORT nNum, const SdrHelpLine& rNewHelpLine);
	void DeleteHelpLine(USHORT nNum);
	void InsertHelpLine(const SdrHelpLine& rHL, USHORT nNum=0xFFFF);
	void MoveHelpLine(USHORT nNum, USHORT nNewNum) { aHelpLines.Move(nNum,nNewNum); }

	// Liefert TRUE, wenn Layer des Obj sichtbar und nicht gesperrt.
	// Beim Gruppenobjekt muss wenigstens ein Member sichtbar sein,
	// gesperrt sein darf keiner.
	sal_Bool IsObjMarkable(SdrObject* pObj) const;

	// Betreten (Editieren) einer Objektgruppe. Anschliessend liegen alle
	// Memberobjekte der Gruppe im direkten Zugriff. Alle anderen Objekte
	// koennen waerendessen nicht bearbeitet werden (bis zum naechsten
	// LeaveGroup()). (wie MsDos chdir bla).
	sal_Bool EnterGroup(SdrObject* pObj);

	// Verlassen einer betretenen Objektgruppe. (wie MsDos chdir ..)
	void LeaveOneGroup();

	// Verlassen aller betretenen Objektgruppen. (wie MsDos chdir \)
	void LeaveAllGroup();

	// Feststellen, wie weit hinabgestiegen wurde (0=Root(Page))
	USHORT GetEnteredLevel() const;

	// Name der aktuellen Objektgruppe
	String GetActualGroupName() const;

	// Die Namen aller z.Zt. betretenen Gruppen
	String GetActualPathName(sal_Unicode cSep = sal_Unicode('|')) const;

	const XPolyPolygon& DragPoly0() const { return *pDragPoly0; }
	const XPolyPolygon& DragPoly() const { return *pDragPoly;  }
	XPolyPolygon& DragPoly0() { return *pDragPoly0; }
	XPolyPolygon& DragPoly() { return *pDragPoly;  }

	//void SetPaintingPageObj( SdrPageObj* pObj ) { mpPaintingPageObj = pObj; }
	//SdrPageObj* GetPaintingPageObj() const { return mpPaintingPageObj; }

//BFS01	friend SvStream& operator<<(SvStream& rOut, const SdrPageView& rPageView);
//BFS01	friend SvStream& operator>>(SvStream& rIn, SdrPageView& rPageView);

	// #103834# Set background color for svx at SdrPageViews
	void SetApplicationBackgroundColor(Color aBackgroundColor);

	// #109585#
	Color GetApplicationBackgroundColor() const;

	// #103911# Set/Get document color for svx at SdrPageViews
	void SetApplicationDocumentColor(Color aDocumentColor);
	Color GetApplicationDocumentColor() const;

	void SetCurrentPaintingDisplayInfo(const ::sdr::contact::DisplayInfo* pDisplayInfo)
	{
		if(pDisplayInfo != mpDisplayInfo)
		{
			mpDisplayInfo = pDisplayInfo;
		}
	}

	const ::sdr::contact::DisplayInfo* GetCurrentPaintingDisplayInfo() const
	{
		return mpDisplayInfo;
	}
};

#endif //_SVDPAGV_HXX

