/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svdsuro.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 18:55:48 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SVDSURO_HXX
#define _SVDSURO_HXX

//BFS01#ifndef _SVDTYPES_HXX
//BFS01#include "svdtypes.hxx"
//BFS01#endif

////////////////////////////////////////////////////////////////////////////////////////////////////

//BFS01class SdrPage;
//BFS01class SdrModel;
//BFS01class SdrObject;
//BFS01class SdrObjList;
//BFS01class SvStream;

//BFS01class SdrObjSurrogate {
//BFS01protected:
//BFS01	const SdrObject*  pRefObj;
//BFS01	SdrObject*  pObj;
//BFS01	const SdrObjList* pList;
//BFS01	const SdrObjList* pRootList;
//BFS01	const SdrPage*    pPage;
//BFS01	const SdrModel*   pModel;
//BFS01	SdrObjListKind eList;
//BFS01	UINT32      nOrdNum;         // Ordnungsnummer des Obj in seiner Liste
//BFS01	UINT32*     pGrpOrdNums;     // Ordnungsnummern der Gruppenobjekte auf dem Path zum Zielobj
//BFS01	UINT16      nGrpLevel;
//BFS01	UINT16      nPageNum;
//BFS01#if _SOLAR__PRIVATE
//BFS01private:
//BFS01	void ImpClearVars();
//BFS01	void ImpMakeSurrogate();
//BFS01	void ImpFindObj();
//BFS01	void ImpRead(SvStream& rIn);
//BFS01	void ImpWriteValue(SvStream& rOut, UINT32 nVal, unsigned nByteAnz) const;
//BFS01	void ImpReadValue(SvStream& rIn, UINT32& rVal, unsigned nByteAnz) const;
//BFS01#endif // __PRIVATE
//BFS01public:
//BFS01//    TYPEINFO();
//BFS01
//BFS01	// Konstruktor zum Schreiben
//BFS01	// pObj ist das referenzierte Objekt.
//BFS01	// Wird ueber pRefObj ein Referenzobjekt angegeben, so muss dieses
//BFS01	// auch beim spaeteren Einlesen wieder angegeben werden (fuer Verweis
//BFS01	// von einem Zeichenobjekt auf ein anderes). Diese Verwendung ist platz-
//BFS01	// und zeitsparender, wenn sich beide Objekte auf derselben Page oder
//BFS01	// noch besser in der selben ObjList befinden.
//BFS01	// (pRefObj hat einen Verweis auf pObj).
//BFS01	SdrObjSurrogate(SdrObject* pObj1, const SdrObject* pRefObj1=NULL);
//BFS01
//BFS01	// Konstruktoren zum Lesen
//BFS01	// Lesen eines absoluten Surrogats.
//BFS01	SdrObjSurrogate(const SdrModel& rMod, SvStream& rIn);
//BFS01	// Lesen eines relativen Surrogats. Muss verwendet werden, wenn das
//BFS01	// Surrogat unter Angabe eines Referenzobjektes geschrieben wurde.
//BFS01	SdrObjSurrogate(const SdrObject& rRefObj1, SvStream& rIn);
//BFS01
//BFS01	~SdrObjSurrogate();
//BFS01
//BFS01	// GetObject() funktioniert nur sicher, wenn das gesamte Model
//BFS01	// eingestreamt ist.
//BFS01	SdrObject* GetObject();
//BFS01
//BFS01	friend SvStream& operator<<(SvStream& rOut, const SdrObjSurrogate& rSurro);
//BFS01};

/*
Ein SdrObjSurrogat ist eine Ersatzdarstellung zur Realisierung einer
persistenten Verbindung zu einem Zeichenobjekt. Anwendungsfaelle (Beispiele):
  - Virtuelles Objekt und Symbolreferenzierung
  - LayoutObjekt
  - Texterweiterungsrahmen
  - Konnektoren
Beim Rausstreamen eines SdrObjSurrogate wird die Listenart und die
Ordnungsnummer des Objekts in dieser Liste geschrieben, sowie ggf.
Angaben ueber die Seitennummer und das Grouping-Level (zzgl. der
Ordnungszahlen der Objektgruppen).
Wichtig ist zu wissen, dass die Verbindungen beim Einlesen erst
nach vollstaendigem Einlesen des SdrModel wiederhergestellt werden
koennen. Aus diesem Grund gibt es nach dem Einlesen des Models ein
Post-Processing (Methode AfterRead() wird noch im Stream-Operator
des Models am Model, an allen Pages und allen Objekten gerufen),
in dem allen Objekten Gelegenheit gegeben wird, nun die ersehnten
SdrObject* zu erlangen.

Surrogate koennen nur auf Objekte zeigen, die Member einer dem
Model bekannten Listen sind (DrawPages,MasterPages)

Internes Datenformat im Stream
1 Byte: Bit0-Bit4=Listenkennung. Siehe SdrObjListKind in SdrPage.HXX
		Bit5     =TRUE bedeutet Objekt ist gruppiert (so.)
		Bit6-Bit7=Byteanzahl m der Ordnungsnummern
				  00=1Byte, 01=2Byte, 10=reserviert, 11=4Byte
wenn Listenkennung!=OBJLIST_UNKNOWN
  m Bytes: Ordnungsnummer des referenzierten Objekts
  wenn eine Page  angegeben ist (SdrIsPageKind(Listenkennung)=TRUE)
	2 Byte: USHORT : Seitennummer
  wenn Bit5=TRUE
	2 Byte: USHORT : Tiefe n der Objektschachtelung
	n*m Bytes      : Ordnungsnummern der jeweiligen Gruppenobjekte

Virtuelle Objekte und Symbolreferenzierungen benoetigen z.B. bei Ordnungszahlen
bis 255 (also z.B. die ersten 256 Symbole) 2 Bytes im Stream.
Bei Referenzierung eines Objektes das in einem Gruppenobjekt steckt kommen
mind. 3 Bytes hinzu. Im unguenstigsten Fall liegt dieses Objekt auf einer
anderen Seite (z.B. Texterweiterungsrahmen), was bedeutet, dass weitere 2 Bytes
fuer die Seitennummer benoetigt werden.
Ein absolutes Surrogat welches ein nichtgruppiertes Objekt auf einer Page
repraesentiert benoetigt demzufolge mind. 4 Bytes und maximal 7 Bytes.
Ein NULL-Surrogat schreibt stets nur 1 Byte in den Stream, naemlich eine 0.
*/

////////////////////////////////////////////////////////////////////////////////////////////////////

#endif //_SVDSURO_HXX

