/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: fastfsys.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 13:40:04 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _FASTFSYS_HXX
#define _FASTFSYS_HXX

#ifndef _DATETIME_HXX
#include <datetime.hxx>
#endif

#ifndef _STRING_HXX
#include <string.hxx>
#endif

#ifndef _LINK_HXX
#include <link.hxx>
#endif

#ifndef _FSYS_HXX
#include <fsys.hxx>
#endif

#ifdef UNX
#include <sys/types.h>
#endif

#if defined( OS2) || defined (MAC)
#include <stdio.h>	//fr size_t
#endif

// Klammerung fuer spezial URLs

#define VIRTUAL_URL_OPENBRACKET		"{"
#define VIRTUAL_URL_CLOSEBRACKET	"}"
// Schluesselwoerter fuer spezielle Ordner

#define VIRTUAL_DESKTOP_TOKEN		"desktop"
#define VIRTUAL_WORKPLACE_TOKEN		"workplace"
#define VIRTUAL_BOOKMARKS_TOKEN		"bookmarks"
#define VIRTUAL_DOCUMENTS_TOKEN		"documents"
#define VIRTUAL_SETTINGS_TOKEN		"settings"

#define VIRTUAL_CONTROLS_TOKEN		"controls"
#define VIRTUAL_PRINTERS_TOKEN		"printers"
#define VIRTUAL_NETWORK_TOKEN		"network"
#define VIRTUAL_PROGRAMS_TOKEN		"programs"
#define VIRTUAL_COMMON_PROGS_TOKEN	"common-programs"

// Kombination

#define VIRTUAL_DESKTOP_URL			VIRTUAL_URL_OPENBRACKET VIRTUAL_DESKTOP_TOKEN		VIRTUAL_URL_CLOSEBRACKET
#define VIRTUAL_WORKPLACE_URL		VIRTUAL_URL_OPENBRACKET VIRTUAL_WORKPLACE_TOKEN		VIRTUAL_URL_CLOSEBRACKET
#define VIRTUAL_BOOKMARKS_URL		VIRTUAL_URL_OPENBRACKET VIRTUAL_BOOKMARKS_TOKEN		VIRTUAL_URL_CLOSEBRACKET
#define VIRTUAL_DOCUMENTS_URL		VIRTUAL_URL_OPENBRACKET VIRTUAL_DOCUMENTS_TOKEN		VIRTUAL_URL_CLOSEBRACKET
#define VIRTUAL_SETTINGS_URL		VIRTUAL_URL_OPENBRACKET VIRTUAL_SETTINGS_TOKEN		VIRTUAL_URL_CLOSEBRACKET

#define VIRTUAL_CONTROLS_URL		VIRTUAL_URL_OPENBRACKET VIRTUAL_CONTROLS_TOKEN		VIRTUAL_URL_CLOSEBRACKET
#define VIRTUAL_PRINTERS_URL		VIRTUAL_URL_OPENBRACKET VIRTUAL_PRINTERS_TOKEN		VIRTUAL_URL_CLOSEBRACKET
#define VIRTUAL_NETWORK_URL			VIRTUAL_URL_OPENBRACKET VIRTUAL_NETWORK_TOKEN		VIRTUAL_URL_CLOSEBRACKET
#define VIRTUAL_PROGRAMS_URL		VIRTUAL_URL_OPENBRACKET VIRTUAL_PROGRAMS_TOKEN		VIRTUAL_URL_CLOSEBRACKET
#define VIRTUAL_COMMON_PROGS_URL	VIRTUAL_URL_OPENBRACKET VIRTUAL_COMMON_PROGS_TOKEN	VIRTUAL_URL_CLOSEBRACKET

// Enumeration fuer spezielle Ornder
enum SpecialFolderID {
	FOLDER_ROOT,
	FOLDER_DRIVES,
	FOLDER_NETWORK,
	FOLDER_DESKTOP,
	FOLDER_CONTROLS,
	FOLDER_PRINTERS,
	FOLDER_BOOKMARKS,
	FOLDER_WORKPLACE,
	FOLDER_SETTINGS,
	FOLDER_DOCUMENTS,
	FOLDER_PROGRAMS,
	FOLDER_COMMON_PROGS
};

// Pfad-Klasse

#ifdef WNT
class ItemIDPathData;
#else
#define	ItemIDPathData	void
#endif

class ItemIDPath
{
public:
	ItemIDPath();
	~ItemIDPath();

	ItemIDPath( SpecialFolderID eFolder );
	ItemIDPath( void *, size_t );
	ItemIDPath( const ItemIDPath & );
	ItemIDPath( const String& rDescription, BOOL bIsFileDesc = TRUE );

	ItemIDPath & operator = ( const ItemIDPath & );
	ItemIDPath & operator = ( const String& );

	ItemIDPath & operator += ( const ItemIDPath & );
	ItemIDPath operator + ( const ItemIDPath & ) const;

	int operator == ( const ItemIDPath & ) const;
	int operator != ( const ItemIDPath & ) const;

	ItemIDPath operator[] ( int nIndex ) const;

	int GetTokenCount() const;
	ItemIDPath GetToken( int nIndex ) const;

	BOOL Split( ItemIDPath &rParent, ItemIDPath &rChild ) const;

	String GetFileDescription() const;
	String GetBinaryDescription() const;
	String GetHostNotationPath() const;

	void SetData( void *, size_t );
	const void * GetDataPtr() const;
	size_t GetDataSize() const;

private:
	ItemIDPathData *	pData;

	friend class Folder;
};

// FastItemInfo

typedef UINT32	ItemFlags;

#define	ITEM_FLAG_COPYABLE		0x00000001
#define	ITEM_FLAG_MOVABLE		0x00000002
#define	ITEM_FLAG_LINKABLE		0x00000004
#define	ITEM_FLAG_DISCARDABLE	0x00000008
#define ITEM_FLAG_RENAMABLE		0x00000010

#define ITEM_FLAG_ISFOLDER		0x00000100
#define ITEM_FLAG_HASSUBFOLDERS	0x00000200
#define ITEM_FLAG_HASITEMS		0x00000400
#define ITEM_FLAG_ISLINK		0x00000800

#define ITEM_FLAG_ISFILESYSTEM	0x00001000

#define ITEM_FLAG_ISREMOTE		0x80000000


enum ItemKind
{
	ITEM_KIND_FILESYSTEM,
	ITEM_KIND_VOLUME,
	ITEM_KIND_NETWORK,
	ITEM_KIND_NAMESPACE,
	ITEM_KIND_OTHER
};

struct FastItemInfo
{
	ItemKind	aItemKind;
	String		aDisplayName;
	String		aIconLocation;
	ItemFlags	aAttributes;
	String    aContent;
};


// FastItemInfo

enum FileKind
{
	FILE_KIND_FILE,
	FILE_KIND_DIRECTORY,
	FILE_KIND_OTHER
};

typedef UINT32	FileFlags;

#define FILE_FLAG_READONLY		0x00000001
#define FILE_FLAG_HIDDEN		0x00000002
#define FILE_FLAG_SYSTEM		0x00000004
#define FILE_FLAG_DIRECTORY		0x00000008
#define FILE_FLAG_ARCHIVE		0x00000010
#define FILE_FLAG_COMPRESSED	0x00000020
#define FILE_FLAG_EXECUTABLE	0x00000040

typedef UINT32	FileSize;

class FileTime : public DateTime
{
public:
	FileTime() : DateTime( Date(0), Time(0) ) {};
};

struct FastFileInfo
{
	FileKind	aFileKind;
	String		aFileName;
	String		aAlternateName;
	FileTime	aCreationTime;
	FileTime	aLastAccessTime;
	FileTime	aLastWriteTime;
	FileSize	aFileSize;
	FileSize	aFileSizeHigh;
	FileFlags	aAttributes;
};

// LinkInfo

struct LinkFileInfo
{
	ItemIDPath	aTargetPath;
	String		aTargetURL;
	String		aIconLocation;
};

// VolumeInfo

enum VolumeKind
{
	VOLUME_KIND_FLOPPY_525,
	VOLUME_KIND_FLOPPY_35,
	VOLUME_KIND_CDROM,
	VOLUME_KIND_REMOVABLE,
	VOLUME_KIND_FIXED,
	VOLUME_KIND_RAM,
	VOLUME_KIND_REMOTE,
	VOLUME_KIND_OTHER
};

typedef UINT32 FileSysFlags;

#define	FILESYS_FLAG_CASESENSITIVE	0x00000001
#define	FILESYS_FLAG_CASEPRESERVE	0x00000002
#define	FILESYS_FLAG_COMPRESSED		0x00000004

struct VolumeInfo
{
	VolumeKind	aVolumeKind;
	String		aVolumeName;
	String		aMappingName;
	String		aDeviceName;
	String		aFileSystemName;
	UINT32		nMaxFileNameLength;
	UINT32		nMaxFilePathLength;
};

// NamespaceInfo

enum NameSpaceKind
{
	NAMESPACE_KIND_UNKNOWN
};

struct NameSpaceInfo
{
	NameSpaceKind	aNameSpaceKind;
	String			aClassName;
};

// Netzwerk-Objekte

enum NetworkKind
{
	NETWORK_KIND_TREE,
	NETWORK_KIND_SERVER,
	NETWORK_KIND_SHARED_DIRECTORY,
	NETWORK_KIND_SHARED_PRINTER,
	NETWORK_KIND_OTHER
};

struct NetworkInfo
{
	NetworkKind	aNetworkKind;
	String		aLocalName;
	String		aRemoteName;
	String		aComment;
};

// Kontext-Menu

enum MenuItemKind
{
	MENU_ITEM_KIND_COMMAND,
	MENU_ITEM_KIND_SEPARATOR,
	MENU_ITEM_KIND_SUBMENU
};

typedef UINT32	MenuItemFlags;

#define MENU_ITEM_FLAG_DISABLED		0x00000001
#define MENU_ITEM_FLAG_CHECKED		0x00000002
#define MENU_ITEM_FLAG_DEFAULT		0x00000004
#define MENU_ITEM_FLAG_RADIOCHECKED	0x00000008

// Kontext-Menus

struct MenuItem
{
	MenuItemKind		aItemKind;
	MenuItemFlags		aItemFlags;
	String				aDisplayText;
	String				aHelpText;
	String				aVerb;
	String				aCommand;
};

class IfcContextMenu
{
public:
	virtual ~IfcContextMenu() {}
	virtual UINT32 GetItemCount() = 0;

	virtual BOOL GetMenuItem( UINT32 nIndex, MenuItem & rItem ) = 0;
	virtual IfcContextMenu *GetSubMenu( UINT32 nIndex ) = 0;

	virtual BOOL ExecuteCommand( String  aCommand ) = 0;
};

// Link-Interface

enum ShortcutFormat
{
	SHORTCUT_FORMAT_BESTFIT,	// Format bleibt der Implementierung berlassen
	SHORTCUT_FORMAT_URL,		// URL File erzwingen
	SHORTCUT_FORMAT_SYSTEM		// System-format erzwingen
};

class IfcShortcut
{
public:
	virtual ~IfcShortcut() {}

	virtual UINT32 GetValueNameCount() const = 0;
	virtual const String& GetValueName( UINT32 nIndex ) const = 0;

	virtual const String& GetValueContent( const String & crValueName ) const = 0;
	virtual void SetValueContent( const String & crValueName, const String & crValueContent ) = 0;

	virtual FSysError Load( const ItemIDPath & crIDPath ) = 0;
	virtual FSysError Store( const String & crTitle, ItemIDPath & rNewIDPath,
		ShortcutFormat ePreferred = SHORTCUT_FORMAT_BESTFIT ) = 0;
};


// Folder-Interface

typedef UINT32 FindFlags;

#define	FIND_FLAG_INCLUDE_NONFOLDER		0x00000001
#define	FIND_FLAG_INCLUDE_FOLDER		0x00000002
#define FIND_FLAG_INCLUDE_HIDDEN		0x00000004

#define FIND_FLAG_INCLUDE_FILES			0x00000008
#define FIND_FLAG_INCLUDE_VOLUMES		0x00000010
#define FIND_FLAG_INCLUDE_NETWORK		0x00000020
#define FIND_FLAG_INCLUDE_NAMESPACE		0x00000040

#define FIND_FLAG_ONLYDEFAULT_NAMESPACE	0x00000080

#define FIND_FLAG_INCLUDE_ALL			0xFFFFFFFF

// defines for GetNextItem
#define FOLDER_OK 1
#define FOLDER_NO_MORE_ITEMS 0
#define FOLDER_PENDING 0xFF

class Folder
{
public:
	Folder( const ItemIDPath &, FindFlags = FIND_FLAG_INCLUDE_ALL );
	~Folder();

	BOOL IsValid() const;

	BYTE GetNextItem( ItemIDPath & );
	BOOL RestartEnum( FindFlags = FIND_FLAG_INCLUDE_ALL );

	BOOL GetItemIDInfo( const ItemIDPath & path, FastItemInfo & info );

	BOOL GetFileInfo( const ItemIDPath & path, FastFileInfo & info );
	BOOL GetVolumeInfo( const ItemIDPath & path, VolumeInfo & info );

	BOOL GetNetworkInfo( const ItemIDPath & path, NetworkInfo & info );
	BOOL GetNameSpaceInfo( const ItemIDPath & path, NameSpaceInfo & info );

	BOOL GetLinkFileInfo( const ItemIDPath & path, LinkFileInfo & info );
	IfcShortcut *CreateShortcutInstance( const String & crLanguage );

	IfcContextMenu * GetContextMenu( UINT32, const ItemIDPath * );

	UINT32 BuildCRC( FindFlags = FIND_FLAG_INCLUDE_ALL );

	ItemIDPath	GetItemIDPath() const;

	BOOL IsCaseSensitive() const;

	BOOL RenameItem( const ItemIDPath & crOldPath, ItemIDPath & rNewPath, const String & crNewName );
	BOOL DeleteItem( const ItemIDPath & crPath );
	BOOL RenameFile( const ItemIDPath & crOldPath, ItemIDPath & rNewPath, const String & crNewFileName );

#ifdef OS2
    /* KSO special: only write longname eas, but do not rename file */
    BOOL SetTitle( const ItemIDPath& crPath, const String crTitle );
#endif

	Link InstallChangeNotifier( const Link& rLink );

	static void ShowExtensions( BOOL = TRUE );
	static BOOL IsAvailable();
	static Folder& GetRootFolder();

private:
	static void DestroyRoot(); // atexit handler; destroys pRoot
	static Folder* pRoot;

	void *	pData;
};

#endif // __ITEMPATH_HXX
