/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: shmalloc.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:50:21 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SHUTIL_H_
#include "SHUtil.h"
#endif

class ShellAlloc
{
public:
	~ShellAlloc();
	
	static LPMALLOC GetShellMalloc();
private:
	static ShellAlloc	gaInstance;
	static BOOL			gfShutDown;
	static LPMALLOC		gpMalloc;
};

//--------------------------------------------------------------------------

BOOL		ShellAlloc::gfShutDown = FALSE;
LPMALLOC	ShellAlloc::gpMalloc = NULL;
ShellAlloc	ShellAlloc::gaInstance;

//--------------------------------------------------------------------------

LPMALLOC ShellAlloc::GetShellMalloc()
{
	if ( !gpMalloc && !gfShutDown )
	{
		LPMALLOC pMalloc = NULL;

		if ( NOERROR == SHGetMalloc( &pMalloc ) )
			gpMalloc = pMalloc;
	}

	return gpMalloc;
}

//--------------------------------------------------------------------------

ShellAlloc::~ShellAlloc()
{
	if ( gpMalloc )
	{
		gpMalloc->Release();
		gpMalloc = NULL;
		gfShutDown = TRUE;
	}
}

//--------------------------------------------------------------------------

extern "C" {

//--------------------------------------------------------------------------
//	SHAlloc
//--------------------------------------------------------------------------

void * WINAPI WIN_SHAlloc( ULONG cb )
{
	LPMALLOC	pMalloc = ShellAlloc::GetShellMalloc();
	void *		pv = NULL;

	if ( pMalloc )
		pv = pMalloc->Alloc( cb );

	return pv;
}


//--------------------------------------------------------------------------
//	SHRealloc
//--------------------------------------------------------------------------

void * WINAPI WIN_SHRealloc( void * pv, ULONG cb )
{
	LPMALLOC	pMalloc = ShellAlloc::GetShellMalloc();
	void *		pvNew = NULL;

	if ( pMalloc )
		pvNew = pMalloc->Realloc( pv, cb );

	return pvNew;
}


//--------------------------------------------------------------------------
//	SHFree
//--------------------------------------------------------------------------

void WINAPI WIN_SHFree( void * pv )
{
	LPMALLOC	pMalloc = ShellAlloc::GetShellMalloc();

	if ( pMalloc )
		pMalloc->Free( pv );
}

//--------------------------------------------------------------------------

}	// extern "C"

