/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: tt_basics.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:31:09 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef UDM_TT_BASICS_HXX
#define UDM_TT_BASICS_HXX



// USED SERVICES
	// BASE CLASSES
#include <udm/type_traits.hxx>
	// COMPONENTS
	// PARAMETERS

namespace udm
{




template <class DATA>
class basictype_traits : public type_traits< typename DATA::source_type >
{
  public:
    typedef typename DATA::value_type   result_type;
    typedef typename DATA::source_type  source_type;

//    result_type         convert(
//                            const XY &          i_rSrc ) const;

  private:
    virtual DYN Data &  do_CreateData() const;
    virtual void        do_ConnectOriginal(
                            Data &              o_rData,
                            const source_type & i_rOriginal ) const;
    virtual DYN source_type *
                        do_CreateObject() const;
};


#if 0
template <class DATA>
inline basictype_traits<DATA>::result_type
basictype_traits<XY,DATA>::convert( const source_type & i_rSrc ) const
{
    convert_value_src_2_udm<source_type,result_type>(i_rSrc);
}
#endif // 0

template <class DATA>
DYN Data &
basictype_traits<DATA>::do_CreateData() const
{
 	return *new DATA();
}

template <class DATA>
void
basictype_traits<DATA>::do_ConnectOriginal( Data &              o_rData,
                                            const source_type & i_rOriginal ) const
{
    static_cast< DATA& >(o_rData).connect_to(i_rOriginal);
}


template <class DATA>
typename DYN basictype_traits<DATA>::source_type *
basictype_traits<DATA>::do_CreateObject() const
{
 	return new source_type();
}





}   // namespace udm


#endif


