/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: salgdiutils.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 10:34:27 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SV_SALGDIUTILS_HXX
#define _SV_SALGDIUTILS_HXX

#include <premac.h>
#include <ApplicationServices/ApplicationServices.h>
#include <postmac.h>

#ifndef _SV_SALGDI_HXX
	#include <salgdi.hxx>
#endif

#ifndef _SV_SALCONST_H
	#include <salconst.h>
#endif

#ifndef _SV_SALGDI_H
	#include <salgdi.h>
#endif

#ifndef _SV_VCLGRAPHICS_H
	#include <VCLGraphics.h>
#endif

#ifndef _SV_SALCOLORUTILS_HXX
	#include <salcolorutils.hxx>
#endif

// ------------------------------------------------------------------

short SelectCopyMode ( const SalGraphicsDataPtr pSalGraphicsData );

// ------------------------------------------------------------------

RgnHandle GetPolygonRgn ( const unsigned long   nPolyCount, 
                          const unsigned long  *pPoints,
                          PCONSTSALPOINT       *ppPtAry,
                          OSStatus             *rQDStatus
                        );

// ------------------------------------------------------------------

OSStatus GetGDeviceBitDepth ( unsigned short  *rGDeviceBitDepth );

OSStatus GetGDeviceResolution ( long  *rGDeviceHRes,
                                long  *rGDeviceVRes
                              );
                              
// ------------------------------------------------------------------

BOOL LockGraphics ( SalGraphics *rSalGraphics );

BOOL UnlockGraphics ( SalGraphics *rSalGraphics );

// ------------------------------------------------------------------

BOOL BeginGraphics ( SalGraphicsDataPtr rSalGraphicsData );

BOOL EndGraphics ( SalGraphicsDataPtr rSalGraphicsData );

// ------------------------------------------------------------------

void InitBrush ( SalGraphicsDataPtr rSalGraphicsData );

void InitFont ( SalGraphicsDataPtr rSalGraphicsData );

void InitGWorld ( SalGraphicsDataPtr rSalGraphicsData );

void InitPen ( SalGraphicsDataPtr rSalGraphicsData );

void InitQD ( SalGraphicsDataPtr rSalGraphicsData );

void InitRegions ( SalGraphicsDataPtr rSalGraphicsData );

void InitStatusFlags ( SalGraphicsDataPtr rSalGraphicsData );

// ------------------------------------------------------------------

#endif	// _SV_SALGDIUTILS_HXX
