/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: VCLGraphics.m,v $
 *
 *  $Revision: 1.24 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 10:40:23 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#define _SV_VCLGRAPHICS_M

#import <VCLGraphics.h>

// =======================================================================

// =======================================================================

// -----------------------------------------------------------------------
//
//                               VCLGraphics
//
// -----------------------------------------------------------------------

@implementation VCLGraphics

// -----------------------------------------------------------------------
//
// Get, and lock, a QuickDraw View
//
// -----------------------------------------------------------------------

+ (CGrafPtr)LockFocusCGrafPort: (VCLView *)hView 
{
	if ( hView != nil )
	{
		if ( [hView isKindOfClass: [NSQuickDrawView class]] )
		{
			CGrafPtr pCGrafPort=NULL;
			RGBColor oldFore, newFore;
			Rect r;
			NSRect viewBounds;
			
			[hView lockFocus];
			
			// [ed] 12/12/01 The Carbon GrafPort only is valid as long as the view has
			// the focus, so we need to be sure to execute lockFocus before assigning
			// the port.
			
			pCGrafPort = [(NSQuickDrawView *)hView qdPort];
			
			return pCGrafPort;
		}
		else
		{
			// [ed] 12/12/01 Error checking
			
			fprintf(stderr, "Non nil hView in LockFocusCGrafPort(), but not a quickdrawview\n");
		} // if
	}
	else
	{
		// [ed] 12/12/01 Error checking
		
		fprintf(stderr, "Nil hView in LockFocusCGrafPort()\n");
	} // if

	return NULL;
} // LockFocusCGrafPort

// -----------------------------------------------------------------------
//
// Close, and unlock, a QuickDraw View
//
// -----------------------------------------------------------------------

+ (void)UnLockFocusCGrafPort: (VCLView *)hView 
{
	if ( hView != nil )
	{
		if ( [hView isKindOfClass: [NSQuickDrawView class]] )
		{
			[hView unlockFocus];
		} // if
	} // if
} // UnLockFocusCGrafPort

@end

// =======================================================================

// =======================================================================

// -----------------------------------------------------------------------
//
//                           C wrapper functions
//
// -----------------------------------------------------------------------

// -----------------------------------------------------------------------
//
// Get, and lock, a QuickDraw View
//
// -----------------------------------------------------------------------

CGrafPtr VCLGraphics_LockFocusCGrafPort ( VCLVIEW hView ) 
{
	if ( (VCLView *)hView == nil )
		return NULL;

	return [ VCLGraphics LockFocusCGrafPort: (VCLView *)hView ];
} // VCLGraphics_LockFocusCGrafPort
	
// -----------------------------------------------------------------------
//
// Close, and unlock, a QuickDraw View
//
// -----------------------------------------------------------------------

void VCLGraphics_UnLockFocusCGrafPort ( VCLVIEW hView ) 
{
	if ( (VCLView *)hView == nil )
		return;

	[ VCLGraphics UnLockFocusCGrafPort: (VCLView *)hView ];
} // VCLGraphics_UnLockFocusCGrafPort

// =======================================================================

// =======================================================================

