/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: bytestrm.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 09:06:28 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#include <vos/diagnose.hxx>
#include <vos/object.hxx>
#include <vos/macros.hxx>
#include <vos/bytestrm.hxx>

#ifdef _USE_NAMESPACE
using namespace vos;
#endif


/////////////////////////////////////////////////////////////////////////////
//
//  class ByteStream
//

OByteStream::OByteStream(OByteArray& s)
	: OStream((IPositionableStream&)*this), m_Buffer(s)
{
    m_Position = 0;
}

sal_Int32 OByteStream::read(void* poutput, sal_uInt32 n) const
{
    sal_Int32 ret = VOS_MAX(0, VOS_MIN(m_Buffer.getSize() - m_Position, n));
    if (ret > 0) 
	{
        m_Buffer.copyTo(poutput, ret, m_Position);
        ((OByteStream*)this)->m_Position += ret; // const cast away
    }

    return (ret);
}

sal_Int32 OByteStream::write(const void* buffer, sal_uInt32 n)
{
    sal_uInt32 size = m_Buffer.getSize();
    if (size - m_Position < n) 
	{
        sal_Int32 new_size = m_Position + n;
        if (! changeSize(new_size))
            return (sal_False);
    }
        
    if (n > 0) 
	{
        m_Buffer.copyFrom(buffer, n, m_Position);
        m_Position += n;
    }

    return (n >= 0);
}

///
sal_Int32 OByteStream::read(IPositionableStream::Offset offset, 
					      void* pbuffer, 
					      sal_uInt32 n) const
{
	return OStream::read(offset, pbuffer, n);
}

///
sal_Int32 OByteStream::write(IPositionableStream::Offset offset, 
						   const void* pbuffer, 
						   sal_uInt32 n)
{
	return OStream::write(offset, pbuffer, n);
}


#define DEFAULT_EXPANSION 64

// Change the current position. Returns sal_True on success.
sal_Bool OByteStream::seekTo(Offset position) const
{
    if (position < 0)
        return (sal_False);

    sal_uInt32 size = m_Buffer.getSize();
    
	if ((m_Position > size) && ! m_Buffer.changeSize (size + DEFAULT_EXPANSION))
        return (sal_False);
    ((OByteStream*) this)->m_Position = position; // const cast away
    
	return (sal_True);
}

sal_Bool OByteStream::seekToEnd () const
{
    ((OByteStream*)this)->m_Position = m_Buffer.getSize(); // Cast away const
    
	return (sal_True);
}

sal_Bool OByteStream::seekRelative(sal_Int32 change) const
{
    Offset new_pos = VOS_MAX(0, m_Position + change);
    
	((OByteStream*)this)->m_Position = new_pos; // Cast away const
    
	return sal_True;
}

sal_Bool OByteStream::changeSize(sal_uInt32 new_size)
{
    return (m_Buffer.changeSize(new_size));
}

inline sal_uInt32 OByteStream::getSize() const
{
    return (m_Buffer.getSize());
}

sal_Bool OByteStream::isEof() const
{
    return (m_Position >= m_Buffer.getSize());
}

IPositionableStream::Offset OByteStream::getOffset() const
{
    return (m_Position);
}

