/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: HelpResultSetForRoot.java,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: obo $ $Date: 2006/01/16 12:38:55 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

package com.sun.star.help;

import com.sun.star.beans.Property;

public class HelpResultSetForRoot extends HelpResultSetBase
// implements XComponent,XCloseable,XPropertySet,XContentAccess,XRow,XResultSet,XResultSetMetaDataSupplier
{

	private String[] m_xHitData = null;

	public String getDocumentURL() {
		if (ret()) {
			int idx = m_xHitData[m_nRow].lastIndexOf('.');
			String str =
				"vnd.sun.star.help://"
					+ m_xHitData[m_nRow].substring(0, idx)
					+ "/";
			// str += ( "?Language=" + m_xParameter.get_language() +
			//		 "&System="   + m_xParameter.get_system() );
			return str;
		} else
			return null;
	}

	public Object getVal(int i) {
		if (m_xProperties[i].Name.equals("Title")) {
			return ((HelpContentIdentifier) queryContentIdentifier())
				.getParameter()
				.get_title();
		} else if (m_xProperties[i].Name.equals("ContentType")) {
			return new String("application/vnd.sun.star.help");
		} else if (m_xProperties[i].Name.equals("IsDocument")) {
			return new Boolean(false);
		} else if (m_xProperties[i].Name.equals("IsFolder")) {
			return new Boolean(true);
		} else {
			return new Object();
		}
	}

	public int getLength() {
		return m_xHitData.length;
	}

	public HelpResultSetForRoot(
		HelpProvider xProvider,
		String[] result,
		Property[] xProperties,
		HelpURLParameter xParameter) {
		super(xProvider, xProperties, xParameter);
		m_xHitData = result;
	}
}
