/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: eventexport.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:07:09 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _XMLOFF_FORMS_EVENTEXPORT_HXX_
#define _XMLOFF_FORMS_EVENTEXPORT_HXX_

#ifndef _COM_SUN_STAR_CONTAINER_XNAMEREPLACE_HPP_
#include <com/sun/star/container/XNameReplace.hpp>
#endif
#ifndef _COM_SUN_STAR_SCRIPT_SCRIPTEVENTDESCRIPTOR_HPP_
#include <com/sun/star/script/ScriptEventDescriptor.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif
#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx>
#endif
#ifndef _COMPHELPER_STLTYPES_HXX_
#include <comphelper/stl_types.hxx>
#endif

//.........................................................................
namespace xmloff
{
//.........................................................................

	//=====================================================================
	//= OEventDescriptorMapper
	//=====================================================================
	typedef ::cppu::WeakImplHelper1	<	::com::sun::star::container::XNameReplace
									>	OEventDescriptorMapper_Base;
	/** helper class wrapping different script event representations

		<p>In the form layer, the script events are represented by <type scope="com.sun.star.script">ScriptEventDescriptor</type>
		instances. The office applications, on the other hand, represent their a single script event as sequence
		of <type scope="com.sun.star.beans">PropertyValue</type>s, where all events of a given object are
		accessible through a <type scope="com.sun.star.container">XNameReplace</type> interface.</p>
		<p>This class maps the first representation of events of a single object to the second one.</p>
		<p>This way, we can use the helper classes here in the project.</p>
	*/
	class OEventDescriptorMapper : public OEventDescriptorMapper_Base
	{
	protected:
		DECLARE_STL_USTRINGACCESS_MAP( ::com::sun::star::uno::Sequence < ::com::sun::star::beans::PropertyValue >, MapString2PropertyValueSequence );
		MapString2PropertyValueSequence	m_aMappedEvents;

	public:
		OEventDescriptorMapper(
			const ::com::sun::star::uno::Sequence< ::com::sun::star::script::ScriptEventDescriptor >& _rEvents);

		// XNameReplace
	    virtual void SAL_CALL replaceByName( const ::rtl::OUString& aName, const ::com::sun::star::uno::Any& aElement ) throw(::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::container::NoSuchElementException, ::com::sun::star::lang::WrappedTargetException, ::com::sun::star::uno::RuntimeException);

		// XNameAccess
		virtual ::com::sun::star::uno::Any SAL_CALL getByName( const ::rtl::OUString& aName ) throw(::com::sun::star::container::NoSuchElementException, ::com::sun::star::lang::WrappedTargetException, ::com::sun::star::uno::RuntimeException);
		virtual ::com::sun::star::uno::Sequence< ::rtl::OUString > SAL_CALL getElementNames(  ) throw(::com::sun::star::uno::RuntimeException);
		virtual sal_Bool SAL_CALL hasByName( const ::rtl::OUString& aName ) throw(::com::sun::star::uno::RuntimeException);

		// XElementAccess
		virtual ::com::sun::star::uno::Type SAL_CALL getElementType(  ) throw(::com::sun::star::uno::RuntimeException);
		virtual sal_Bool SAL_CALL hasElements(  ) throw(::com::sun::star::uno::RuntimeException);
	};


//.........................................................................
}	// namespace xmloff
//.........................................................................

#endif // _XMLOFF_FORMS_EVENTEXPORT_HXX_

/*************************************************************************
 * history:
 *	$Log: eventexport.hxx,v $
 *	Revision 1.2  2005/09/09 14:07:09  rt
 *	INTEGRATION: CWS ooo19126 (1.1.646); FILE MERGED
 *	2005/09/05 14:38:57 rt 1.1.646.1: #i54170# Change license header: remove SISSL
 *	
 *	Revision 1.1.646.1  2005/09/05 14:38:57  rt
 *	#i54170# Change license header: remove SISSL
 *	
 *	Revision 1.1  2001/01/02 15:55:40  fs
 *	initial checkin - helper for exporting script events
 *	
 *
 *	Revision 1.0 21.12.00 12:14:08  fs
 ************************************************************************/

