/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: NextDocGeneratorHeap.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:58:52 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

package com.sun.xmlsearch.xml.qe;

import com.sun.xmlsearch.util.NonnegativeIntegerGenerator;

final class NextDocGeneratorHeap {
    private static final int InitSize = 1024;
  
    private int                _heapSize = 0;
    private int                _size = InitSize;
    private NextDocGenerator[] _heap = new NextDocGenerator[InitSize];
    private int                _free = 0;
    private boolean             _nonEmpty = false;
  
    public boolean isNonEmpty() {
	return _nonEmpty;
    }
  
    public void addGenerator(NextDocGenerator gen) {
	if (_free == _size) {
	    NextDocGenerator[] newArray = new NextDocGenerator[_size *= 2];
	    System.arraycopy(_heap, 0, newArray, 0, _free);
	    _heap = newArray;
	}
	_heap[_free++] = gen;
    }
  
    public void start() {
	if ((_heapSize = _free) > 0) {
	    // build heap
	    for (int i = _heapSize/2; i >= 0; i--)
		heapify(i);
	    _nonEmpty = true;
	}
	else
	    _nonEmpty = false;
    }
  
    public void step() throws Exception {
	if (_heap[0].next() != NonnegativeIntegerGenerator.END)
	    heapify(0);
	else if (_heapSize > 1) {
	    _heap[0] = _heap[--_heapSize];
	    heapify(0);
	}
	else
	    _nonEmpty = false;
    }
  
    public int getDocument() {
	return _heap[0].getDocument();
    }
  
    public int getConcept() {
	return _heap[0].getConcept();
    }
  
    public ConceptData getTerms() {
	return _heap[0].getTerms();
    }
  
    public int getQueryMask() {
	return _heap[0].getQueryMask();
    }
  
    public void reset() {
	_nonEmpty = false;
	_free = 0;
    }
  
    public boolean atDocument(int document) {
	return _nonEmpty && _heap[0].getDocument() == document;
    }
  
    private void heapify(int i) {
	for (int r, l, smallest;;) {
	    r = (i + 1) << 1; l = r - 1;
	    smallest = l < _heapSize && _heap[l].smallerThan(_heap[i]) ? l : i;
	    if (r < _heapSize && _heap[r].smallerThan(_heap[smallest]))
		smallest = r;
	    if (smallest != i) {
		NextDocGenerator temp = _heap[smallest];
		_heap[smallest] = _heap[i];
		_heap[i] = temp;
		i = smallest;
	    }
	    else
		break;
	}
    }
}
