/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: QueryHit.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:59:38 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

package com.sun.xmlsearch.xml.qe;

// !!! public now
public final class QueryHit implements Comparable {
    private final double _penalty;
    private final int    _doc;
    private final int    _begin;
    private final int    _end;
    private final int[]  _matches; // ...concept, word number, ...

    public QueryHit(int nColumns, double penalty, int doc, int begin, int end) {
	_penalty = penalty;
	_doc   = doc;
	_begin = begin;
	_end   = end;
	_matches = new int[2 * nColumns];
    }
  
    public String toString() {
	return "[doc = "+_doc+", "+_begin+", "+_end+", "+_penalty+"]";
    }

    public int getDocument() {
	return _doc;
    }

    public int[] getMatches() {
	return _matches;
    }

    public int getBegin() {
	return _begin;
    }

    public int getEnd() {
	return _end;
    }

    public double getPenalty() {
	return _penalty;
    }

    /** for Arrays.sort() */
    public int compareTo(Object o) {
	if (_penalty != ((QueryHit)o)._penalty)
	    return _penalty < ((QueryHit)o)._penalty ? -1 : 1;
	else if (_begin != ((QueryHit)o)._begin)
	    return _begin < ((QueryHit)o)._begin ? -1 : 1;
	else if (_end   != ((QueryHit)o)._end)
	    return _end < ((QueryHit)o)._end ? -1 : 1;
	else
	    return 0;
    }

    public boolean betterThan(QueryHit x) {
	if (_penalty != x._penalty)
	    return _penalty < x._penalty;
	else if (_begin != x._begin)
	    return _begin < x._begin;
	else if (_end   != x._end)
	    return _end < x._end;
	else
	    return false;
    }
  
    public boolean worseThan(double penalty, int begin, int end) {
	if (_penalty != penalty)
	    return _penalty > penalty;
	else if (_begin != begin)
	    return _begin > begin;
	else if (_end   != end)
	    return _end > end;
	else
	    return false;
    }
}
