/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ii_gate.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 16:26:12 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_autodoc.hxx"


#include <precomp.h>
#include "ii_gate.hxx"


// NOT FULLY DEFINED SERVICES



namespace ary
{

// KORR_FUTURE
class PhysicalLocationPilot {};
class LogicalLocationPilot {};
class InformationPilot {};

PhysicalLocationPilot   aPL_dummy;
LogicalLocationPilot    aLL_dummy;
InformationPilot        aI_dummy;

namespace idl
{

Gate_Inst::Gate_Inst( CePilot &           io_rCes,
                      TypePilot &         io_rTypes,
                      SecondariesPilot &  io_rSecondaries )
    :   pCes(&io_rCes),
        pTypes(&io_rTypes),
        pSecondaries(&io_rSecondaries)
{
}

Gate_Inst::~Gate_Inst()
{
}

PhysicalLocationPilot &
Gate_Inst::access_PhysicalLocations()
{
    // KORR_FUTURE
    return aPL_dummy;
}

LogicalLocationPilot &
Gate_Inst::access_LogicalLocations()
{
    // KORR_FUTURE
    return aLL_dummy;
}

InformationPilot &
Gate_Inst::access_Informations()
{
    // KORR_FUTURE
    return aI_dummy;
}

CePilot &
Gate_Inst::access_Ces()
{
    return *pCes;
}

TypePilot &
Gate_Inst::access_Types()
{
    return *pTypes;
}

SecondariesPilot &
Gate_Inst::access_Secondaries()
{
    return *pSecondaries;
}



}   // namespace idl
}   // namespace ary


