/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: g_stgifc.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:04:10 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ARY_STORE_G_STGIFC_HXX
#define ARY_STORE_G_STGIFC_HXX



// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
	// PARAMETERS
#include <ary/ids.hxx>


namespace ary
{
    class AryGroup;
    class TopProject;

    namespace cpp
    {
        class ProjectGroup;
        class FileGroup;
    }

namespace store
{
    class IndependentGroups;

class Groups_Ifc
{
  public:
	// LIFECYCLE
						Groups_Ifc(
                            IndependentGroups & io_rGroupStorage );
    void                Init_TopProject(
                            DYN ary::TopProject &
                                                let_drProject );
						~Groups_Ifc();

	// OPERATIONS
    void                Add_ProjectGroup_Cpp(
                            DYN ary::cpp::ProjectGroup &
                                                let_drProject );
    void                Add_FileGroup_Cpp(
                            DYN ary::cpp::FileGroup &
                                                let_drFile );
    // INQUIRY
    const ary::TopProject &
                        Top() const;
    const ary::AryGroup *
                        Find_Group(
                            Gid                 i_nId ) const;
    const ary::cpp::ProjectGroup *
                        Find_ProjectGroup_Cpp(
                            Gid                 i_nProject ) const;
    const ary::cpp::ProjectGroup *
                        Search_ProjectGroup_Cpp(
                            const udmstri &     i_sProjectName  ) const;
    // ACCESS
    ary::TopProject &   Top();
    ary::cpp::ProjectGroup *
                        Find_ProjectGroup_Cpp(
                            Gid                 i_nProject );
    ary::cpp::ProjectGroup *
                        Search_ProjectGroup_Cpp(
                            Lid                 i_nRootDir );
    ary::cpp::FileGroup *
                        Search_FileGroup_Cpp(
                            Lid                 i_nFile );
  private:
    struct CheshireCat;

    // DATA
    Dyn<CheshireCat>    pi;

};



// IMPLEMENTATION

inline const ary::cpp::ProjectGroup *
Groups_Ifc::Find_ProjectGroup_Cpp( Gid i_nProject ) const
    { return const_cast< Groups_Ifc& >(*this).Find_ProjectGroup_Cpp( i_nProject ); }


}   // namespace store
}   // namespace ary



#endif

