/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: langtab.cxx,v $
 *
 *  $Revision: 1.11 $
 *
 *  last change: $Author: hr $ $Date: 2007/06/27 17:19:11 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svx.hxx"

// include ---------------------------------------------------------------

#include <svx/dialogs.hrc> // -> RID_SVXSTR_LANGUAGE_TABLE
#include <svx/dialmgr.hxx>
#include "langtab.hxx"

#ifndef _SHL_HXX //autogen
#include <tools/shl.hxx>
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif

//------------------------------------------------------------------------

SvxLanguageTable::SvxLanguageTable() :

	ResStringArray( SVX_RES( RID_SVXSTR_LANGUAGE_TABLE ) )

{
}

//------------------------------------------------------------------------

SvxLanguageTable::~SvxLanguageTable()
{
}

//------------------------------------------------------------------------

const String& SvxLanguageTable::GetString( const LanguageType eType ) const
{
    // no_NO is an alias for nb_NO
    LanguageType eLang = (eType == LANGUAGE_NORWEGIAN ?
            LANGUAGE_NORWEGIAN_BOKMAL : eType);
	sal_uInt32 nPos = FindIndex( (long)eLang );

	if ( RESARRAY_INDEX_NOTFOUND != nPos && nPos < Count() )
		return ResStringArray::GetString( nPos );
	else
	{
        // If we knew what a simple "en" should alias to (en_US?) we could
        // generally raise an error.
        OSL_ENSURE(
            eLang == LANGUAGE_ENGLISH, "language entry not found in resource" );
        
        nPos = FindIndex( (long)LANGUAGE_DONTKNOW );

		if ( RESARRAY_INDEX_NOTFOUND != nPos && nPos < Count() )
			return ResStringArray::GetString( nPos );
	}
    static String aEmptyStr;
    return aEmptyStr;
}

//------------------------------------------------------------------------

LanguageType SvxLanguageTable::GetType( const String& rStr ) const
{
	LanguageType eType = LANGUAGE_DONTKNOW;
	sal_uInt32 nCount = Count();

	for ( sal_uInt32 i = 0; i < nCount; ++i )
		if ( rStr == ResStringArray::GetString( i ) )
		{
			eType = LanguageType( GetValue( i ) );
			break;
		}
	return eType;
}

//------------------------------------------------------------------------

sal_uInt32 SvxLanguageTable::GetEntryCount() const
{
	return Count();
}
	
//------------------------------------------------------------------------

LanguageType SvxLanguageTable::GetTypeAtIndex( sal_uInt32 nIndex ) const
{
	LanguageType nType = LANGUAGE_DONTKNOW;
	if (nIndex < Count())
		nType = LanguageType( GetValue( nIndex ) );
	return nType;
}

//------------------------------------------------------------------------

