/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: crsrsh.hxx,v $
 *
 *  $Revision: 1.37 $
 *
 *  last change: $Author: hr $ $Date: 2007/06/27 13:13:02 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _CRSRSH_HXX
#define _CRSRSH_HXX

#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif
#ifndef _LINK_HXX //autogen
#include <tools/link.hxx>
#endif
#ifndef _RTTI_HXX //autogen
#include <tools/rtti.hxx>
#endif

#ifndef INCLUDED_SWDLLAPI_H
#include "swdllapi.h"
#endif
#ifndef _SWTYPES_HXX
#include <swtypes.hxx>			// fuer SWPOSDOC
#endif
#ifndef _VIEWSH_HXX
#include <viewsh.hxx>			// fuer ViewShell
#endif
#ifndef _CALBCK_HXX
#include <calbck.hxx>			// fuer SwClient
#endif
#ifndef _CSHTYP_HXX
#include <cshtyp.hxx>        	// fuer die CursorShell Typen
#endif
#ifndef _CRSTATE_HXX
#include <crstate.hxx>			// fuer die CursorMove-Staties
#endif
#ifndef _TOXE_HXX
#include <toxe.hxx>				// SwTOXSearchDir
#endif
#ifndef _TBLSEL_HXX
#include <tblsel.hxx>				//SwTblSearchType
#endif
#ifndef _VISCRS_HXX
#include <viscrs.hxx>
#endif
#ifndef _NODE_HXX
#include <node.hxx>
#endif
#ifndef _TBLSEL_HXX
#include <tblsel.hxx>
#endif

#ifndef IDOCUMENTBOOKMARKACCESS_HXX_INCLUDED
#include <IDocumentBookmarkAccess.hxx>
#endif

// einige Forward Deklarationen

class KeyCode;
class SfxItemSet;
class SfxPoolItem;
class SwBookmark;
class SwCntntFrm;
class SwCrsrShell;
class SwCursor;
class SwField;
class SwFieldType;
class SwFmt;
class SwFmtFld;
class SwNodeIndex;
class SwPaM;
class SwShellCrsr;
class SwShellTableCrsr;
class SwTableNode;
class SwTxtFmtColl;
class SwVisCrsr;
class SwTxtINetFmt;
class SwFmtINetFmt;
class SwTxtAttr;
class SwTableBox;
class SwCellFrms;
class SwTOXMark;
class SwRedline;
class SwCntntNode; //  #i23726#
struct SwPosition;

namespace com { namespace sun { namespace star { namespace util {
	struct SearchOptions;
} } } }

namespace com { namespace sun { namespace star { namespace text {
	class XTextRange;
}}}};

namespace com { namespace sun { namespace star { namespace container {
	class XStringKeyMap;
}}}};

// enum und struktur, um ueber die Doc-Position Informationen zu erfragen

struct SwContentAtPos
{
	enum IsAttrAtPos
	{
        SW_NOTHING          = 0x0000,
        SW_FIELD            = 0x0001,
        SW_CLICKFIELD       = 0x0002,
        SW_FTN              = 0x0004,
        SW_INETATTR         = 0x0008,
        SW_TABLEBOXFML      = 0x0010,
        SW_REDLINE          = 0x0020,
        SW_OUTLINE          = 0x0040,
        SW_TOXMARK          = 0x0080,
        SW_REFMARK          = 0x0100,
        SW_NUMLABEL         = 0x0200, // #i23726#
        SW_CONTENT_CHECK    = 0x0400, // --> FME 2005-05-13 #i43742# <--
        SW_SMARTTAG         = 0x0800
#ifndef PRODUCT
		,SW_CURR_ATTRS 		= 0x4000		// nur zum Debuggen
		,SW_TABLEBOXVALUE	= 0x8000		// nur zum Debuggen
#endif
	} eCntntAtPos;

	union {
		const SwField* pFld;
		const SfxPoolItem* pAttr;
		const SwRedline* pRedl;
        SwCntntNode * pNode; // #i23726#
	} aFnd;

    int nDist; // #i23726#

	String sStr;
	const SwTxtAttr* pFndTxtAttr;

	SwContentAtPos( int eGetAtPos = 0xffff )
		: eCntntAtPos( (IsAttrAtPos)eGetAtPos )
	{
		aFnd.pFld = 0;
		pFndTxtAttr = 0;
        nDist = 0; // #i23726#
	}

	// befindet sich der Node in einem geschuetzten Bereich?
	FASTBOOL IsInProtectSect() const;
    bool     IsInRTLText()const;
};

// ReturnWerte von SetCrsr (werden verodert)
const int CRSR_POSOLD = 0x01,   // Cursor bleibt an alter Doc-Position
          CRSR_POSCHG = 0x02;   // Position vom Layout veraendert
          
// die Cursor - Shell
class SW_DLLPUBLIC SwCrsrShell : public ViewShell, public SwModify
{
	friend class SwCallLink;
	friend class SwVisCrsr;
	friend class SwSelPaintRects;
	friend class SwChgLinkFlag;

	//Braucht den Crsr als IntrnlCrsr.
    friend BOOL GetAutoSumSel( const SwCrsrShell&, SwCellFrms& );

public:     // public, damit defaultet werden kann !!

	/* ein enum fuer den Aufruf von UpdateCrsr */
	enum CrsrFlag {
		UPDOWN		= (1 << 0),     // Up/Down auf Spalte halten
		SCROLLWIN	= (1 << 1),     // Window Scrollen
		CHKRANGE	= (1 << 2),     // ueberpruefen von ueberlappenden PaM's
		NOCALRECT 	= (1 << 3),		// CharRect nicht neu berechnen
		READONLY	= (1 << 4)		// Sichtbar machen trotz Readonly
	};

private:

	SwRect	aCharRect;			// Char-SRectangle auf dem der Cursor steht
	Point	aCrsrHeight;     	// Hohe&Offset von sichtbaren Cursor
	Point 	aOldRBPos;			// Right/Bottom von letzter VisArea
								// (wird im Invalidate vom Cursor benutzt)


	// um event. Macro was anhaengt auszufuehren.
	Link aFlyMacroLnk;			// Link will be called, if the Crsr is set
								// into a fly. A macro can be then becalled
	Link aChgLnk;				// link will be called by every attribut/
								// format changes at cursor position.
	Link aGrfArrivedLnk;		// Link calls to UI if a grafik is arrived


	SwShellCrsr* pCurCrsr; 		// der aktuelle Cursor
	SwShellCrsr* pCrsrStk;		// Stack fuer den Cursor
	SwVisCrsr *pVisCrsr;        // der Sichtbare-Cursor

	SwShellTableCrsr* pTblCrsr;	// Tabellen-Crsr; nur in Tabellen, wenn
								// die Selection ueber 2 Spalten liegt

	SwNodeIndex* pBoxIdx;		// fuers erkennen der veraenderten
	SwTableBox* pBoxPtr;		// Tabellen-Zelle

	long nUpDownX;				// versuche den Cursor bei Up/Down immer in
								// der gleichen Spalte zu bewegen
	long nLeftFrmPos;
	ULONG nAktNode;				// save CursorPos at Start-Action
	xub_StrLen nAktCntnt;
	USHORT nAktNdTyp;
    bool bAktSelection;

	/*
	 * Mit den Methoden SttCrsrMove und EndCrsrMove wird dieser Zaehler
	 * Inc-/Decrementiert. Solange der Zaehler ungleich 0 ist, erfolgt
	 * auf den akt. Cursor kein Update. Dadurch koennen "komplizierte"
	 * Cursorbewegungen (ueber Find()) realisiert werden.
	 */
	USHORT nCrsrMove;
	USHORT nBasicActionCnt;		// Actions, die vom Basic geklammert wurden
	CrsrMoveState eMvState;		// Status fuers Crsr-Travelling - GetCrsrOfst
    // -> #i27615#
    /**
       marked numbering rule

       If a numbering level/rule are marked, changes to character
       attributes are propagated to the according numbering style.

    */
    String sMarkedNumRule;

    /**
       marked numbering level

       If a numbering level/rule are marked, changes to character
       attributes are propagated to the according numbering style.

    */
    BYTE nMarkedNumLevel;
    // <- #i27615#


    BOOL bHasFocus : 1;         // Shell ist in einem Window "aktiv"
	BOOL bSVCrsrVis : 1;		// SV-Cursor Un-/Sichtbar
	BOOL bChgCallFlag : 1;		// Attributaenderung innerhalb von
								// Start- und EndAction
	BOOL bVisPortChgd : 1;		// befindet sich im VisPortChg-Aufruf
								// (wird im Invalidate vom Cursor benutzt)

	BOOL bCallChgLnk : 1;		// Flag fuer abgeleitete Klassen:
								// TRUE -> ChgLnk callen
								// Zugriff nur ueber SwChgLinkFlag
	BOOL bAllProtect : 1;		// Flag fuer Bereiche
								// TRUE -> alles geschuetzt / versteckt
	BOOL bInCMvVisportChgd : 1;	// Flag fuer CrsrMoves
								// TRUE -> die Sicht wurde verschoben
	BOOL bGCAttr : 1;			// TRUE -> es existieren nichtaufgespannte Attr.
	BOOL bIgnoreReadonly : 1;	// TRUE -> Beim naechsten EndAction trotz
								// Readonly den Crsr sichtbar machen.
	BOOL bSelTblCells : 1;		// TRUE -> Zellen uebers InputWin selektieren
	BOOL bAutoUpdateCells : 1;	// TRUE -> Zellen werden autoformatiert
	BOOL bBasicHideCrsr : 1;	// TRUE -> HideCrsr vom Basic
	BOOL bSetCrsrInReadOnly : 1;// TRUE -> Cursor darf in ReadOnly-Bereiche
	BOOL bOverwriteCrsr : 1;	// TRUE -> show Overwrite Crsr

    // OD 11.02.2003 #100556# - flag to allow/avoid execution of marcos (default: true)
    bool mbMacroExecAllowed : 1;

	SW_DLLPRIVATE void UpdateCrsr( USHORT eFlags
							=SwCrsrShell::SCROLLWIN|SwCrsrShell::CHKRANGE,
					 BOOL bIdleEnd = FALSE );

	SW_DLLPRIVATE void _ParkPams( SwPaM* pDelRg, SwShellCrsr** ppDelRing );

    // -> #i27615#

    /**
       Set the marked numbering level stored in this shell.

       @param sNumRule   the name of the marked numbering rule
       @param nLevel     the marked numbering level

       The empty string denotes that no numbering rule is marked.
     */
    SW_DLLPRIVATE void SetMarkedNumLevel(const String & sNumRule, BYTE nLevel);
    // <- #i27615#

	// private method(s) accessed from public inline method(s) must be exported.
                  FASTBOOL LeftRight( BOOL, USHORT, USHORT, BOOL );
	SW_DLLPRIVATE FASTBOOL UpDown( BOOL, USHORT );
	SW_DLLPRIVATE FASTBOOL LRMargin( BOOL, BOOL bAPI = FALSE );
	SW_DLLPRIVATE FASTBOOL IsAtLRMargin( BOOL, BOOL bAPI = FALSE ) const;
	FASTBOOL SttEndDoc( BOOL bStt );

    SW_DLLPRIVATE short GetTextDirection( const Point* pPt = 0 ) const;

typedef FASTBOOL (SwCursor:: *FNCrsr)();
	SW_DLLPRIVATE FASTBOOL CallCrsrFN( FNCrsr );

	SW_DLLPRIVATE const SwRedline* _GotoRedline( USHORT nArrPos, BOOL bSelect );

protected:

    inline SwMoveFnCollection* MakeFindRange( USHORT, USHORT, SwPaM* ) const;

	/*
	 * Compare-Methode for the StackCursor and the current Cursor.
	 * The Methods return -1, 0, 1 for lower, equal, greater. The enum
	 * CrsrCompareType says which position is compared.
	 */
	enum CrsrCompareType {
		StackPtStackMk,
		StackPtCurrPt,
		StackPtCurrMk,
		StackMkCurrPt,
		StackMkCurrMk,
		CurrPtCurrMk
	};
	int CompareCursor( CrsrCompareType eType ) const;

    // Setzt alle PaMs in OldNode auf NewPos + Offset
	void PaMCorrAbs(const SwNodeIndex &rOldNode, const SwPosition &rNewPos,
					const xub_StrLen nOffset = 0 );

    // --> FME 2004-07-30 #i32329# Enhanced table selection
    FASTBOOL _SelTblRowOrCol( bool bRow, bool bRowSimple = false );
    // <--

    // --> FME 2005-01-31 #i41424# Only update the marked number levels if necessary
    bool SetInFrontOfLabel( FASTBOOL bNew );
    // <--

    /**
       Updates the marked numbering level stored in this shell
       according to the cursor.
     */
    SW_DLLPRIVATE void UpdateMarkedNumLevel();

public:
	TYPEINFO();
	SwCrsrShell( SwDoc& rDoc, Window *pWin,
				SwRootFrm * = 0, const SwViewOption *pOpt = 0 );
	// verkleideter Copy-Constructor
	SwCrsrShell( SwCrsrShell& rShell, Window *pWin );
	virtual ~SwCrsrShell();

	virtual void Modify( SfxPoolItem *pOld, SfxPoolItem *pNew);

	// neuen Cusror erzeugen und den alten anhaengen
	SwPaM * CreateCrsr();
	// loesche den aktuellen Cursor und der folgende wird zum Aktuellen
	FASTBOOL DestroyCrsr();
	// TableCursor in normale Cursor verwandeln, Tablemode aufheben
	void TblCrsrToCursor();

	SwPaM* GetCrsr( FASTBOOL bMakeTblCrsr = TRUE ) const;
    inline SwCursor* GetSwCrsr( FASTBOOL bMakeTblCrsr = TRUE ) const;
	// nur den akt. Cursor returnen
		  SwShellCrsr* _GetCrsr()  						{ return pCurCrsr; }
	const SwShellCrsr* _GetCrsr() const 				{ return pCurCrsr; }

	// uebergebenen Cursor anzeigen - fuer UNO
	void	SetSelection(const SwPaM& rCrsr);

	// alle Cursor aus den ContentNodes entfernen und auf 0 setzen.
	// Wurde aus der FEShell hierher verschoben.
	void ParkCrsr( const SwNodeIndex &rIdx );

	// gebe den akt. Cursor-Stack zurueck.
	// ( Wird in der EditShell beim Loeschen von Inhalten benoetigt! )
    inline SwPaM* GetStkCrsr() const;

	// Start der Klammerung, SV-Cursor und selektierte Bereiche hiden
	void StartAction();
	// Ende der Klammerung, SV-Cursor und selektierte Bereiche anzeigen
	void EndAction( const BOOL bIdleEnd = FALSE );

    // Basiscursortravelling
	long GetUpDownX() const 			{ return nUpDownX; }

    FASTBOOL Left( USHORT nCnt, USHORT nMode, BOOL bAllowVisual = FALSE )
        { return LeftRight( TRUE, nCnt, nMode, bAllowVisual ); }
    FASTBOOL Right( USHORT nCnt, USHORT nMode, BOOL bAllowVisual = FALSE )
        { return LeftRight( FALSE, nCnt, nMode, bAllowVisual ); }
    FASTBOOL Up( USHORT nCnt = 1 )      { return UpDown( TRUE, nCnt ); }
    FASTBOOL Down( USHORT nCnt = 1 )    { return UpDown( FALSE, nCnt ); }
    FASTBOOL LeftMargin()               { return LRMargin( TRUE ); }
    FASTBOOL RightMargin(BOOL bAPI = FALSE) { return LRMargin( FALSE, bAPI ); }
    FASTBOOL SttDoc()                   { return SttEndDoc( TRUE ); }
    FASTBOOL EndDoc()                   { return SttEndDoc( FALSE ); }

	FASTBOOL MovePage( SwWhichPage, SwPosPage );
	FASTBOOL MovePara( SwWhichPara, SwPosPara );
	FASTBOOL MoveSection( SwWhichSection, SwPosSection );
	FASTBOOL MoveTable( SwWhichTable, SwPosTable );
	FASTBOOL MoveColumn( SwWhichColumn, SwPosColumn );
	FASTBOOL MoveRegion( SwWhichRegion, SwPosRegion );

	// die Suchfunktionen
	ULONG Find( const com::sun::star::util::SearchOptions& rSearchOpt,
                SwDocPositions eStart, SwDocPositions eEnde,
                BOOL& bCancel,
				FindRanges eRng, int bReplace = FALSE );

	ULONG Find( const SwTxtFmtColl& rFmtColl,
				SwDocPositions eStart, SwDocPositions eEnde,
                BOOL& bCancel,
                FindRanges eRng, const SwTxtFmtColl* pReplFmt = 0 );

	ULONG Find( const SfxItemSet& rSet, FASTBOOL bNoCollections,
				SwDocPositions eStart, SwDocPositions eEnde,
                BOOL& bCancel,
                FindRanges eRng,
				const com::sun::star::util::SearchOptions* pSearchOpt = 0,
				const SfxItemSet* rReplSet = 0 );

	// Positionieren des Cursors
	// returnt
	//	CRSR_POSCHG: wenn der ob der SPoint vom Layout korrigiert wurde.
	//	CRSR_POSOLD: wenn der Crsr nicht veraendert wurde
	int SetCrsr( const Point &rPt, BOOL bOnlyText = FALSE );

	/*
	 * Benachrichtung, dass der sichtbare Bereich sich geaendert
	 * hat. aVisArea wird neu gesetzt, anschliessend wird
	 * gescrollt. Das uebergebene Rectangle liegt auf
	 * Pixelgrenzen, um Pixelfehler beim Scrollen zu vermeiden.
	 */
	virtual void VisPortChgd( const SwRect & );

	/*
	 * Virtuelle PaintMethode, damit die Selection nach dem Paint wieder
	 * sichtbar wird.
	 */
	void Paint( const Rectangle & rRect );

	// Bereiche
    inline void SetMark();
    inline FASTBOOL HasMark();

	void ClearMark();

    /**
       Ensure point and mark of the current PaM are in a specific order.

       @param bPointFirst TRUE: If the point is behind the mark then
       swap the PaM. FALSE: If the mark is behind the point then swap
       the PaM.
    */
    void NormalizePam(BOOL bPointFirst = TRUE);

	void SwapPam();
	FASTBOOL ChgCurrPam( const Point & rPt,
					 BOOL bTstOnly = TRUE,		//Nur testen, nicht setzen
					 BOOL bTstHit  = FALSE );	//Nur genaue Treffer
	void KillPams();

	// erzeuge eine Kopie vom Cursor und speicher diese im Stack
	void Push();
	/*
	 *  Loescht einen Cursor (gesteuert durch bOldCrsr)
	 * 		- vom Stack oder	( bOldCrsr = TRUE )
	 * 		- den aktuellen und der auf dem Stack stehende wird zum aktuellen
	 *
	 * 	Return:  es war auf dem Stack noch einer vorhanden
	 */
	FASTBOOL Pop( BOOL bOldCrsr = TRUE );
	/*
	 * Verbinde zwei Cursor miteinander.
	 * Loesche vom Stack den obersten und setzen dessen Mark im Aktuellen.
	 */
	void Combine();

#if defined( PRODUCT )
	void SttCrsrMove() { ++nCrsrMove; StartAction(); }
	void EndCrsrMove( const BOOL bIdleEnd = FALSE )
			{ EndAction( bIdleEnd ); --nCrsrMove; }
#else
	void SttCrsrMove();
	void EndCrsrMove( const BOOL bIdleEnd = FALSE );
#endif

	/*
	 * Beim Abgeben des Focuses werden die selektierten Bereiche nicht mehr
	 * angezeigt; andererseits beim Erhalten des Focuses, werden alle selek-
	 * tierten Bereiche wieder angezeigt. (Bereiche muessen neu berechnet
	 * werden!)
	 */
	BOOL HasShFcs() const { return bHasFocus; }
	void ShLooseFcs();
	void ShGetFcs( BOOL bUpdate = TRUE );

	// Methoden zum Anzeigen bzw. Verstecken des sichtbaren Text-Cursors
	void ShowCrsr();
	void HideCrsr();
	// Methoden zum Anzeigen bzw. Verstecken der selektierten Bereiche mit
	// dem sichtbaren Cursor
	void ShowCrsrs( BOOL bCrsrVis );
	void HideCrsrs();

	FASTBOOL IsOverwriteCrsr() const { return bOverwriteCrsr; }
	void SetOverwriteCrsr( FASTBOOL bFlag ) { bOverwriteCrsr = bFlag; }

	// gebe den aktuellen Frame, in dem der Cursor steht, zurueck
	SwCntntFrm *GetCurrFrm( const BOOL bCalcFrm = TRUE ) const;

	//TRUE wenn der Crsr wenn der Crsr wegen Readonly gehidet ist,
	//FALSE wenn der arbeitet (trotz Readonly).
	FASTBOOL IsCrsrReadonly() const;
	// Cursor steht in etwas geschuetztem oder in die Selektion umspannt
	// etwas geschuetztes.
	FASTBOOL HasReadonlySel() const;
	// darf der Cursor in ReadOnlyBereiche?
	FASTBOOL IsReadOnlyAvailable() const { return bSetCrsrInReadOnly; }
	void SetReadOnlyAvailable( BOOL bFlag );
	FASTBOOL IsOverReadOnlyPos( const Point& rPt ) const;

	// Methoden fuer aFlyMacroLnk
    void        SetFlyMacroLnk( const Link& rLnk ) { aFlyMacroLnk = rLnk; }
	const Link& GetFlyMacroLnk() const 			   { return aFlyMacroLnk; }

	// Methoden geben/aendern den Link fuer die Attribut/Format-Aenderungen
    void        SetChgLnk( const Link &rLnk ) { aChgLnk = rLnk; }
    const Link& GetChgLnk() const             { return aChgLnk; }

	// Methoden geben/aendern den Link fuers "Grafik vollstaendig geladen"
    void        SetGrfArrivedLnk( const Link &rLnk ) { aGrfArrivedLnk = rLnk; }
    const Link& GetGrfArrivedLnk() const             { return aGrfArrivedLnk; }

	//ChgLink callen, innerhalb einer Action wird der Ruf verzoegert.
	void CallChgLnk();

	// Abfrage, ob der aktuelle Cursor eine Selektion aufspannt,
	// also, ob Mark gesetzt und SPoint und Mark unterschiedlich sind.
	FASTBOOL HasSelection() const;

	// Abfrage, ob ueberhaupt eine Selektion existiert, sprich der akt. Cursor
	// aufgespannt oder nicht der einzigste ist.
    inline FASTBOOL IsSelection() const;
    // returns if multiple cursors are available
    inline FASTBOOL IsMultiSelection() const;

	// Abfrage, ob ein kompletter Absatz selektiert wurde
	FASTBOOL IsSelFullPara() const;
	// Abfrage, ob die Selektion in einem Absatz ist
    inline FASTBOOL IsSelOnePara() const;

	//Sollte fuer das Clipboard der WaitPtr geschaltet werden.
	FASTBOOL ShouldWait() const;

	/*
	 * liefert das SRectangle, auf dem der Cursor steht.
	 */
	const SwRect &GetCharRect() const { return aCharRect; }
	/*
	 * liefert zurueck, ob der Cursor sich ganz oder teilweise im
	 * sichtbaren Bereich befindet.
	 */
    FASTBOOL IsCrsrVisible() const { return VisArea().IsOver( GetCharRect() ); }

	// gebe die aktuelle Seitennummer zurueck:
	// TRUE:  in der der Cursor steht
	// FALSE: die am oberen Rand sichtbar ist
	void GetPageNum( USHORT &rnPhyNum, USHORT &rnVirtNum,
					 BOOL bAtCrsrPos = TRUE, const BOOL bCalcFrm = TRUE );
	// bestimme in welche Richtung "leere Seiten" behandelt werden!
	// (wird benutzt im PhyPage.. )
	USHORT GetNextPrevPageNum( BOOL bNext = TRUE );

	// setze den Cursor auf die Seite "nPage" an den Anfang
	FASTBOOL GotoPage( USHORT nPage );

	// gebe alle Dokumentseiten zurueck
	USHORT GetPageCnt();

	// Gehe zur naechsten Selection
	FASTBOOL GoNextCrsr();
	// gehe zur vorherigen Selection
	FASTBOOL GoPrevCrsr();

	// am CurCrsr.SPoint
	FASTBOOL SetBookmark( const KeyCode&, const String& rName,
				const String& rShortName, IDocumentBookmarkAccess::BookmarkType eMark = IDocumentBookmarkAccess::BOOKMARK);
	FASTBOOL GotoBookmark( USHORT );	// setzt CurCrsr.SPoint
	FASTBOOL GotoBookmark( USHORT nPos, BOOL bAtStart ); //
	FASTBOOL GoNextBookmark(); // TRUE, wenn's noch eine gab
	FASTBOOL GoPrevBookmark();
	USHORT GetBookmarkCnt(BOOL bBkmrk = FALSE) const;
	SwBookmark& GetBookmark( USHORT, BOOL bBkmrk = FALSE );
	void DelBookmark( USHORT );
	void DelBookmark( const String& rName );
	USHORT FindBookmark( const String& rName );
		// erzeugt einen eindeutigen Namen. Der Name selbst muss vorgegeben
		// werden, es wird dann bei gleichen Namen nur durchnumeriert.
	void MakeUniqueBookmarkName( String& rNm );

	// aktualisiere den Crsrs, d.H. setze ihn wieder in den Content.
	// Das sollte nur aufgerufen werden, wenn der Cursor z.B. beim
	// Loeschen von Rahmen irgendwohin gesetzt wurde. Die Position
	// ergibt sich aus seiner aktuellen Position im Layout !!
	void UpdateCrsrPos();

	// returne den am akt. Cursor selektierten Text. Dieser wird mit
	// Felder etc. aufgefuellt!!
	String GetSelTxt() const;
	// gebe nur den Text ab der akt. Cursor Position zurueck (bis zum NodeEnde)
	String GetText() const;

	// pruefe ob vom aktuellen Crsr der SPoint/Mark in einer Tabelle stehen
    inline const SwTableNode* IsCrsrInTbl( BOOL bIsPtInTbl = TRUE ) const;
	// erfrage die Document - Layout - Position vom akt. Crsr
    inline Point& GetCrsrDocPos( BOOL bPoint = TRUE ) const;
    inline FASTBOOL IsCrsrPtAtEnd() const;

    inline const  SwPaM* GetTblCrs() const;
    inline        SwPaM* GetTblCrs();

	FASTBOOL IsTblComplex() const;
	FASTBOOL IsTblComplexForChart();
	// erfrage die akt. TabellenSelektion als Text
	String GetBoxNms() const;

	// setze Crsr in die naechsten/vorherigen Celle
	FASTBOOL GoNextCell( BOOL bAppendLine = TRUE );
	FASTBOOL GoPrevCell();
	// gehe zu dieser Box (wenn vorhanden und in Tabelle!)
	FASTBOOL GotoTable( const String& rName );

	// select a table row, column or box (based on the current cursor)
    FASTBOOL SelTblRow() { return _SelTblRowOrCol( true  ); }
    FASTBOOL SelTblCol() { return _SelTblRowOrCol( false ); }
    FASTBOOL SelTblBox();
    // --> FME 2004-07-30 #i32329# Enhanced table selection
    FASTBOOL SelTbl();
    // <--

	// zum naechsten/vorhergehenden Punkt auf gleicher Ebene
	FASTBOOL GotoNextNum();
	FASTBOOL GotoPrevNum();

		// zu diesem Gliederungspunkt
	FASTBOOL GotoOutline( const String& rName );
		// zum naechsten/vorhergehenden oder angegebenen OultineNode
	void GotoOutline( USHORT nIdx );
		// suche die "Outline-Position" im Nodes-Array vom akt. Kaiptel
	USHORT GetOutlinePos( BYTE nLevel = UCHAR_MAX );
		// selektiere den angeben Bereich von OutlineNodes. Optional
		// inclusive der Childs. Die USHORT sind die Positionen im
		// OutlineNds-Array!! (EditShell)
	FASTBOOL MakeOutlineSel( USHORT nSttPos, USHORT nEndPos,
						BOOL bWithChilds = FALSE );

	FASTBOOL GotoNextOutline();			// naechster Node mit Outline-Num.
	FASTBOOL GotoPrevOutline();			// vorheriger Node mit Outline-Num.

		// ist der Crsr in einer Tabelle und ist die Selection ueber
		// zwei Spalten
	FASTBOOL IsTableMode() const { return 0 != pTblCrsr; }

		// erfrage den Tabellen Crsr; ausserhalb von Tabellen immer 0
	const SwShellTableCrsr* GetTableCrsr() const { return pTblCrsr; }
	SwShellTableCrsr* GetTableCrsr() { return pTblCrsr; }
	USHORT UpdateTblSelBoxes();

	FASTBOOL GotoFtnTxt();		// springe aus dem Content zur Fussnote
	FASTBOOL GotoFtnAnchor();	// springe aus der Fussnote zum Anker
	FASTBOOL GotoPrevFtnAnchor();
	FASTBOOL GotoNextFtnAnchor();

	FASTBOOL GotoFlyAnchor();		// springe aus dem Rahmen zum Anker
	FASTBOOL GotoHeaderTxt();		// springe aus dem Content zum Header
	FASTBOOL GotoFooterTxt();		// springe aus dem Content zum Footer
	// springe in den Header/Footer des angegebenen oder akt. PageDesc
	FASTBOOL SetCrsrInHdFt( USHORT nDescNo = USHRT_MAX,
							FASTBOOL bInHeader = TRUE );
	// is point of cursor in header/footer. pbInHeader return TRUE if it is
	// in a headerframe otherwise in a footerframe
	FASTBOOL IsInHeaderFooter( FASTBOOL* pbInHeader = 0 ) const;

	// springe zum naechsten Verzeichnis [mit dem Namen]
	FASTBOOL GotoNextTOXBase( const String* = 0 );
	// springe zum vorherigen Verzeichnis [mit dem Namen]
	FASTBOOL GotoPrevTOXBase( const String* = 0 );
	FASTBOOL GotoTOXMarkBase();		// springe zum Verzeichnis vom TOXMark
	// springe zum naechsten (vorherigen) Verzeichniseintrag
	FASTBOOL GotoNxtPrvTOXMark( BOOL bNext = TRUE );
	// Zur naechsten/ vorherigen Verzeichnismarke dieses Typs traveln
	const SwTOXMark& GotoTOXMark( const SwTOXMark& rStart, SwTOXSearch eDir );

	// springe zum naechsten (vorherigen) Tabellenformel
	// optional auch nur zu kaputten Formeln springen
	FASTBOOL GotoNxtPrvTblFormula( BOOL bNext = TRUE,
									BOOL bOnlyErrors = FALSE );
	// jump to the next / previous hyperlink - inside text and also
	// on graphics
	FASTBOOL SelectNxtPrvHyperlink( BOOL bNext = TRUE );

	// springe zu dieser Refmark
	FASTBOOL GotoRefMark( const String& rRefMark, USHORT nSubType = 0,
							USHORT nSeqNo = 0 );

	// hole vom Start/Ende der akt. Selection das nte Zeichen
	sal_Unicode GetChar( BOOL bEnd = TRUE, long nOffset = 0 );
	// erweiter die akt. Selection am Anfang/Ende um n Zeichen
	FASTBOOL ExtendSelection( BOOL bEnd = TRUE, xub_StrLen nCount = 1 );
	// setze nur den sichtbaren Cursor an die angegebene Dokument-Pos.
	// returnt FALSE: wenn der ob der SPoint vom Layout korrigiert wurde.
	// (wird zum Anzeigen von Drag&Drop/Copy-Cursor benoetigt)
	FASTBOOL SetVisCrsr( const Point &rPt );
    inline void UnSetVisCrsr();

	// springe zum nachsten/vorherigen Feld des entsprechenden Types
	FASTBOOL MoveFldType( const SwFieldType* pFldType, BOOL bNext,
											USHORT nSubType = USHRT_MAX,
											USHORT nResType = USHRT_MAX );
	// springe genau zu diesem Feld
	FASTBOOL GotoFld( const SwFmtFld& rFld );

	// returne die Anzahl der Cursor im Ring (Flag besagt ob man nur
	// aufgepspannte haben will - sprich etwas selektiert ist (Basic))
	USHORT GetCrsrCnt( BOOL bAll = TRUE ) const;

	// Char Travelling - Methoden (in crstrvl1.cxx)
    FASTBOOL GoStartWord();
	FASTBOOL GoEndWord();
	FASTBOOL GoNextWord();
	FASTBOOL GoPrevWord();
	FASTBOOL GoNextSentence();
	FASTBOOL GoPrevSentence();
    FASTBOOL GoStartSentence();
    FASTBOOL GoEndSentence();
    FASTBOOL SelectWord( const Point* pPt = 0 );

	// Position vom akt. Cursor erfragen
    FASTBOOL IsStartWord()const;
    FASTBOOL IsEndWord() const;
    FASTBOOL IsInWord() const;
    FASTBOOL IsStartSentence() const;
    FASTBOOL IsEndSentence() const;
    FASTBOOL IsSttPara() const;
    FASTBOOL IsEndPara() const;
    FASTBOOL IsStartOfDoc() const;
	FASTBOOL IsEndOfDoc() const;
    FASTBOOL IsInFrontOfLabel() const;
    FASTBOOL IsAtLeftMargin()   const       { return IsAtLRMargin( TRUE ); }
    FASTBOOL IsAtRightMargin(BOOL bAPI = FALSE) const   { return IsAtLRMargin( FALSE, bAPI ); }

	// loesche alle erzeugten Crsr, setze den Tabellen-Crsr und den letzten
	// Cursor auf seinen TextNode (oder StartNode?).
	// Beim naechsten ::GetCrsr werden sie wieder alle erzeugt.
	// Wird fuers Drag&Drop/ClipBorad-Paste in Tabellen benoetigt.
	FASTBOOL ParkTblCrsr();

    // gibt es nicht aufgespannte Attribute?
    FASTBOOL IsGCAttr() const { return bGCAttr; }
    void ClearGCAttr() { bGCAttr = FALSE; }
    void    UpdateAttr() {  bGCAttr = TRUE; }

	// ist das gesamte Dokument geschuetzt/versteckt?? (fuer UI,..)
	FASTBOOL IsAllProtect() const { return bAllProtect; }

#ifdef SW_CRSR_TIMER
	// setze das Flag am VisCrsr, ob dieser ueber Timer getriggert (TRUE)
	// oder direkt (FALSE) angezeigt wird. (default ist Timer getriggert)
	FASTBOOL ChgCrsrTimerFlag( BOOL bTimerOn = TRUE );
#endif

	BOOL BasicActionPend() const 	{ return nBasicActionCnt != nStartAction; }

		// springe zum benannten Bereich
	FASTBOOL GotoRegion( const String& rName );

	// zeige die aktuelle Selektion an
	virtual void MakeSelVisible();

	// setzte den Cursor auf einen NICHT geschuetzten/versteckten Node
	FASTBOOL FindValidCntntNode( BOOL bOnlyText = FALSE );

	FASTBOOL GetContentAtPos( const Point& rPt,
							SwContentAtPos& rCntntAtPos,
							FASTBOOL bSetCrsr = FALSE,
							SwRect* pFldRect = 0 );
    
    // get smart tags at point position
    void GetSmartTagTerm( const Point& rPt,
                          SwRect& rSelectRect,
                          ::com::sun::star::uno::Sequence< rtl::OUString >& rSmartTagTypes,
                          ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Reference< ::com::sun::star::container::XStringKeyMap > >& rStringKeyMaps,
                          ::com::sun::star::uno::Reference<com::sun::star::text::XTextRange>& rRange );

    // get smart tags at current cursor position
    void GetSmartTagTerm( ::com::sun::star::uno::Sequence< rtl::OUString >& rSmartTagTypes,
                          ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Reference< ::com::sun::star::container::XStringKeyMap > >& rStringKeyMaps,
                          ::com::sun::star::uno::Reference<com::sun::star::text::XTextRange>& rRange ) const;
    
    FASTBOOL IsPageAtPos( const Point &rPt ) const;

		// Attribut selelktieren
	FASTBOOL SelectTxtAttr( USHORT nWhich, BOOL bExpand = FALSE,
							const SwTxtAttr* pAttr = 0 );
	FASTBOOL GotoINetAttr( const SwTxtINetFmt& rAttr );
	const SwFmtINetFmt* FindINetAttr( const String& rName ) const;

	FASTBOOL CheckTblBoxCntnt( const SwPosition* pPos = 0 );
	void SaveTblBoxCntnt( const SwPosition* pPos = 0 );
	void ClearTblBoxCntnt();
	FASTBOOL EndAllTblBoxEdit();

	// wird gerufen, wenn eine Tabellenselektion im UpdateCrsr erzeugt wird,
	// ohne das die UI davon etaws weiss
	virtual void NewCoreSelection();

    void SetSelTblCells( BOOL bFlag )           { bSelTblCells = bFlag; }
	BOOL IsSelTblCells() const 					{ return bSelTblCells; }

	BOOL IsAutoUpdateCells() const 				{ return bAutoUpdateCells; }
    void SetAutoUpdateCells( BOOL bFlag )       { bAutoUpdateCells = bFlag; }

	FASTBOOL GetShadowCrsrPos( const Point& rPt, SwFillMode eFillMode,
							SwRect& rRect, SwHoriOrient& rOrient );
	FASTBOOL SetShadowCrsrPos( const Point& rPt, SwFillMode eFillMode );

	const SwRedline* SelNextRedline();
	const SwRedline* SelPrevRedline();
	const SwRedline* GotoRedline( USHORT nArrPos, BOOL bSelect = FALSE );

	// is cursor or the point in/over a vertical formatted text?
	FASTBOOL IsInVerticalText( const Point* pPt = 0 ) const;
    // is cursor or the point in/over a right to left formatted text?
    FASTBOOL IsInRightToLeftText( const Point* pPt = 0 ) const;

    // If the current cursor position is inside a hidden range, the hidden range
    // is selected and true is returned:
    bool SelectHiddenRange();

    // remove all invalid cursors
    void ClearUpCrsrs();

    // OD 11.02.2003 #100556# - set/get flag to allow/avoid execution of macros
    inline void SetMacroExecAllowed( const bool _bMacroExecAllowed )
    {
        mbMacroExecAllowed = _bMacroExecAllowed;
    }
    inline bool IsMacroExecAllowed()
    {
        return mbMacroExecAllowed;
    }

    // #111827#
    /**
       Returns textual description of the current selection.

       - If the current selection is a multi-selection the result is
         STR_MULTISEL.
       - Else the result is the text of the selection.

       @return the textual description of the current selection
     */
    String GetCrsrDescr() const;
};


// Cursor Inlines:
inline SwMoveFnCollection* SwCrsrShell::MakeFindRange(
			USHORT nStt, USHORT nEnd, SwPaM* pPam ) const
{
	return pCurCrsr->MakeFindRange( (SwDocPositions)nStt, (SwDocPositions)nEnd, pPam );
}

inline SwCursor* SwCrsrShell::GetSwCrsr( FASTBOOL bMakeTblCrsr ) const
{
	return (SwCursor*)GetCrsr( bMakeTblCrsr );
}

inline SwPaM* SwCrsrShell::GetStkCrsr() const { return pCrsrStk; }

inline void SwCrsrShell::SetMark() { pCurCrsr->SetMark(); }

inline FASTBOOL SwCrsrShell::HasMark() { return( pCurCrsr->HasMark() ); }

inline FASTBOOL SwCrsrShell::IsSelection() const
{
	return IsTableMode() || pCurCrsr->HasMark() ||
			pCurCrsr->GetNext() != pCurCrsr;
}
inline FASTBOOL SwCrsrShell::IsMultiSelection() const
{
    return pCurCrsr->GetNext() != pCurCrsr;
}

inline FASTBOOL SwCrsrShell::IsSelOnePara() const
{
	return pCurCrsr == pCurCrsr->GetNext() &&
		   pCurCrsr->GetPoint()->nNode == pCurCrsr->GetMark()->nNode;
}

inline const SwTableNode* SwCrsrShell::IsCrsrInTbl( BOOL bIsPtInTbl ) const
{
	return pCurCrsr->GetNode( bIsPtInTbl )->FindTableNode();
}

inline FASTBOOL SwCrsrShell::IsCrsrPtAtEnd() const
{
	return pCurCrsr->End() == pCurCrsr->GetPoint();
}

inline Point& SwCrsrShell::GetCrsrDocPos( BOOL bPoint ) const
{
	return bPoint ? pCurCrsr->GetPtPos() : pCurCrsr->GetMkPos();
}

inline const SwPaM* SwCrsrShell::GetTblCrs() const
{
	return pTblCrsr;
}

inline SwPaM* SwCrsrShell::GetTblCrs()
{
	return pTblCrsr;
}

inline void SwCrsrShell::UnSetVisCrsr()
{
	pVisCrsr->Hide();
	pVisCrsr->SetDragCrsr( FALSE );
}

#endif  // _CRSRSH_HXX
