/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sprmcodetostr.cxx,v $
 *
 *  $Revision: 1.26 $
 *
 *  last change: $Author: hbrinkm $ $Date: 2007/06/15 09:33:51 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <doctok/resourceids.hxx>
#include <ooxml/resourceids.hxx>
#include <resourcemodel/QNameToString.hxx>
#include <resourcemodel/sprmids.hxx>

namespace writerfilter
{

SprmIdToString::Pointer_t SprmIdToString::pInstance;

SprmIdToString::Pointer_t SprmIdToString::Instance()
{
    if (pInstance.get() == NULL)
        pInstance = SprmIdToString::Pointer_t(new SprmIdToString());

    return pInstance;
}

string SprmIdToString::operator()(sal_uInt32 nId)
{
    return mMap[nId];
}


SprmIdToString::SprmIdToString()
{
    mMap[NS_sprm::LN_PIstdPermute] = "rtf:sprmPIstdPermute";
    mMap[NS_sprm::LN_TCantSplit] = "rtf:sprmTCantSplit";
    mMap[NS_sprm::LN_PIncLvl] = "rtf:sprmPIncLvl";
    mMap[NS_sprm::LN_PJcExtra] = "rtf:sprmPJcExtra";
    mMap[NS_sprm::LN_PJc] = "rtf:sprmPJc";
    mMap[NS_sprm::LN_PFSideBySide] = "rtf:sprmPFSideBySide";
    mMap[NS_sprm::LN_PFKeep] = "rtf:sprmPFKeep";
    mMap[NS_sprm::LN_PFKeepFollow] = "rtf:sprmPFKeepFollow";
    mMap[NS_sprm::LN_PFPageBreakBefore] = "rtf:sprmPFPageBreakBefore";
    mMap[NS_sprm::LN_PBrcl] = "rtf:sprmPBrcl";
    mMap[NS_sprm::LN_PBrcp] = "rtf:sprmPBrcp";
    mMap[NS_sprm::LN_PIlvl] = "rtf:sprmPIlvl";
    mMap[NS_sprm::LN_PIlfo] = "rtf:sprmPIlfo";
    mMap[NS_sprm::LN_PFNoLineNumb] = "rtf:sprmPFNoLineNumb";
    mMap[NS_sprm::LN_PChgTabsPapx] = "rtf:sprmPChgTabsPapx";
    mMap[NS_sprm::LN_PDxaRight] = "rtf:sprmPDxaRight";
    mMap[NS_sprm::LN_PDxaLeft] = "rtf:sprmPDxaLeft";
    mMap[NS_sprm::LN_PNest] = "rtf:sprmPNest";
    mMap[NS_sprm::LN_PDxaLeft1] = "rtf:sprmPDxaLeft1";
    mMap[NS_sprm::LN_PDyaLine] = "rtf:sprmPDyaLine";
    mMap[NS_sprm::LN_PDyaBefore] = "rtf:sprmPDyaBefore";
    mMap[NS_sprm::LN_PDyaAfter] = "rtf:sprmPDyaAfter";
    mMap[NS_sprm::LN_PChgTabs] = "rtf:sprmPChgTabs";
    mMap[NS_sprm::LN_PFInTable] = "rtf:sprmPFInTable";
    mMap[NS_sprm::LN_PCell] = "rtf:sprmPCell";
    mMap[NS_sprm::LN_PRow] = "rtf:sprmPRow";
    mMap[NS_sprm::LN_PFTtp] = "rtf:sprmPFTtp";
    mMap[NS_sprm::LN_PDxaAbs] = "rtf:sprmPDxaAbs";
    mMap[NS_sprm::LN_PDyaAbs] = "rtf:sprmPDyaAbs";
    mMap[NS_sprm::LN_PDxaWidth] = "rtf:sprmPDxaWidth";
    mMap[NS_sprm::LN_PPc] = "rtf:sprmPPc";
    mMap[NS_sprm::LN_PBrcTop10] = "rtf:sprmPBrcTop10";
    mMap[NS_sprm::LN_PBrcLeft10] = "rtf:sprmPBrcLeft10";
    mMap[NS_sprm::LN_PBrcBottom10] = "rtf:sprmPBrcBottom10";
    mMap[NS_sprm::LN_PBrcRight10] = "rtf:sprmPBrcRight10";
    mMap[NS_sprm::LN_PBrcBetween10] = "rtf:sprmPBrcBetween10";
    mMap[NS_sprm::LN_PBrcBar10] = "rtf:sprmPBrcBar10";
    mMap[NS_sprm::LN_PDxaFromText10] = "rtf:sprmPDxaFromText10";
    mMap[NS_sprm::LN_PWr] = "rtf:sprmPWr";
    mMap[NS_sprm::LN_PBrcBar] = "rtf:sprmPBrcBar";
    mMap[NS_sprm::LN_PFNoAutoHyph] = "rtf:sprmPFNoAutoHyph";
    mMap[NS_sprm::LN_PWHeightAbs] = "rtf:sprmPWHeightAbs";
    mMap[NS_sprm::LN_PDcs] = "rtf:sprmPDcs";
    mMap[NS_sprm::LN_PShd] = "rtf:sprmPShd";
    mMap[NS_sprm::LN_PDyaFromText] = "rtf:sprmPDyaFromText";
    mMap[NS_sprm::LN_PDxaFromText] = "rtf:sprmPDxaFromText";
    mMap[NS_sprm::LN_PFLocked] = "rtf:sprmPFLocked";
    mMap[NS_sprm::LN_PFWidowControl] = "rtf:sprmPFWidowControl";
    mMap[NS_sprm::LN_PRuler] = "rtf:sprmPRuler";
    mMap[NS_sprm::LN_PFKinsoku] = "rtf:sprmPFKinsoku";
    mMap[NS_sprm::LN_PFWordWrap] = "rtf:sprmPFWordWrap";
    mMap[NS_sprm::LN_PFOverflowPunct] = "rtf:sprmPFOverflowPunct";
    mMap[NS_sprm::LN_PFTopLinePunct] = "rtf:sprmPFTopLinePunct";
    mMap[NS_sprm::LN_PFAutoSpaceDE] = "rtf:sprmPFAutoSpaceDE";
    mMap[NS_sprm::LN_PFAutoSpaceDN] = "rtf:sprmPFAutoSpaceDN";
    mMap[NS_sprm::LN_PWAlignFont] = "rtf:sprmPWAlignFont";
    mMap[NS_sprm::LN_PFrameTextFlow] = "rtf:sprmPFrameTextFlow";
    mMap[NS_sprm::LN_PISnapBaseLine] = "rtf:sprmPISnapBaseLine";
    mMap[NS_sprm::LN_PAnld] = "rtf:sprmPAnld";
    mMap[NS_sprm::LN_PPropRMark] = "rtf:sprmPPropRMark";
    mMap[NS_sprm::LN_POutLvl] = "rtf:sprmPOutLvl";
    mMap[NS_sprm::LN_PFBiDi] = "rtf:sprmPFBiDi";
    mMap[NS_sprm::LN_PFNumRMIns] = "rtf:sprmPFNumRMIns";
    mMap[NS_sprm::LN_PCrLf] = "rtf:sprmPCrLf";
    mMap[NS_sprm::LN_PNumRM] = "rtf:sprmPNumRM";
    mMap[NS_sprm::LN_PHugePapx] = "rtf:sprmPHugePapx";
    mMap[NS_sprm::LN_PFUsePgsuSettings] = "rtf:sprmPFUsePgsuSettings";
    mMap[NS_sprm::LN_PFAdjustRight] = "rtf:sprmPFAdjustRight";
    mMap[NS_sprm::LN_CFRMarkDel] = "rtf:sprmCFRMarkDel";
    mMap[NS_sprm::LN_CFRMark] = "rtf:sprmCFRMark";
    mMap[NS_sprm::LN_CFFldVanish] = "rtf:sprmCFFldVanish";
    mMap[NS_sprm::LN_CPicLocation] = "rtf:sprmCPicLocation";
    mMap[NS_sprm::LN_CIbstRMark] = "rtf:sprmCIbstRMark";
    mMap[NS_sprm::LN_CDttmRMark] = "rtf:sprmCDttmRMark";
    mMap[NS_sprm::LN_CFData] = "rtf:sprmCFData";
    mMap[NS_sprm::LN_CIdslRMark] = "rtf:sprmCIdslRMark";
    mMap[NS_sprm::LN_CChs] = "rtf:sprmCChs";
    mMap[NS_sprm::LN_CSymbol] = "rtf:sprmCSymbol";
    mMap[NS_sprm::LN_CFOle2] = "rtf:sprmCFOle2";
    mMap[NS_sprm::LN_CIdCharType] = "rtf:sprmCIdCharType";
    mMap[NS_sprm::LN_CHighlight] = "rtf:sprmCHighlight";
    mMap[NS_sprm::LN_CObjLocation] = "rtf:sprmCObjLocation";
    mMap[NS_sprm::LN_CFFtcAsciSymb] = "rtf:sprmCFFtcAsciSymb";
    mMap[NS_sprm::LN_CIstd] = "rtf:sprmCIstd";
    mMap[NS_sprm::LN_CIstdPermute] = "rtf:sprmCIstdPermute";
    mMap[NS_sprm::LN_CDefault] = "rtf:sprmCDefault";
    mMap[NS_sprm::LN_CPlain] = "rtf:sprmCPlain";
    mMap[NS_sprm::LN_CKcd] = "rtf:sprmCKcd";
    mMap[NS_sprm::LN_CFBold] = "rtf:sprmCFBold";
    mMap[NS_sprm::LN_CFItalic] = "rtf:sprmCFItalic";
    mMap[NS_sprm::LN_CFStrike] = "rtf:sprmCFStrike";
    mMap[NS_sprm::LN_CFOutline] = "rtf:sprmCFOutline";
    mMap[NS_sprm::LN_CFShadow] = "rtf:sprmCFShadow";
    mMap[NS_sprm::LN_CFSmallCaps] = "rtf:sprmCFSmallCaps";
    mMap[NS_sprm::LN_CFCaps] = "rtf:sprmCFCaps";
    mMap[NS_sprm::LN_CFVanish] = "rtf:sprmCFVanish";
    mMap[NS_sprm::LN_CFtcDefault] = "rtf:sprmCFtcDefault";
    mMap[NS_sprm::LN_CKul] = "rtf:sprmCKul";
    mMap[NS_sprm::LN_CSizePos] = "rtf:sprmCSizePos";
    mMap[NS_sprm::LN_CDxaSpace] = "rtf:sprmCDxaSpace";
    mMap[NS_sprm::LN_CLid] = "rtf:sprmCLid";
    mMap[NS_sprm::LN_CIco] = "rtf:sprmCIco";
    mMap[NS_sprm::LN_CHps] = "rtf:sprmCHps";
    mMap[NS_sprm::LN_CHpsInc] = "rtf:sprmCHpsInc";
    mMap[NS_sprm::LN_CHpsPos] = "rtf:sprmCHpsPos";
    mMap[NS_sprm::LN_CHpsPosAdj] = "rtf:sprmCHpsPosAdj";
    mMap[NS_sprm::LN_CMajority] = "rtf:sprmCMajority";
    mMap[NS_sprm::LN_CIss] = "rtf:sprmCIss";
    mMap[NS_sprm::LN_CHpsNew50] = "rtf:sprmCHpsNew50";
    mMap[NS_sprm::LN_CHpsInc1] = "rtf:sprmCHpsInc1";
    mMap[NS_sprm::LN_CHpsKern] = "rtf:sprmCHpsKern";
    mMap[NS_sprm::LN_CMajority50] = "rtf:sprmCMajority50";
    mMap[NS_sprm::LN_CHpsMul] = "rtf:sprmCHpsMul";
    mMap[NS_sprm::LN_CYsri] = "rtf:sprmCYsri";
    mMap[NS_sprm::LN_CRgFtc0] = "rtf:sprmCRgFtc0";
    mMap[NS_sprm::LN_CRgFtc1] = "rtf:sprmCRgFtc1";
    mMap[NS_sprm::LN_CRgFtc2] = "rtf:sprmCRgFtc2";
    mMap[NS_sprm::LN_CCharScale] = "rtf:sprmCCharScale";
    mMap[NS_sprm::LN_CFDStrike] = "rtf:sprmCFDStrike";
    mMap[NS_sprm::LN_CFImprint] = "rtf:sprmCFImprint";
    mMap[NS_sprm::LN_CFNoProof] = "rtf:sprmCFNoProof";
    mMap[NS_sprm::LN_CFspecVanish] = "rtf:sprmCFspecVanish";
    mMap[NS_sprm::LN_CFitText] = "rtf:sprmCFitText";
    mMap[NS_sprm::LN_CComplexScript] = "rtf:sprmCComplexScript";
    mMap[NS_sprm::LN_PTightWrap] = "rtf:sprmPTightWrap";
    mMap[NS_sprm::LN_CFSpec] = "rtf:sprmCFSpec";
    mMap[NS_sprm::LN_CFObj] = "rtf:sprmCFObj";
    mMap[NS_sprm::LN_CPropRMark] = "rtf:sprmCPropRMark";
    mMap[NS_sprm::LN_CFEmboss] = "rtf:sprmCFEmboss";
    mMap[NS_sprm::LN_CSfxText] = "rtf:sprmCSfxText";
    mMap[NS_sprm::LN_CFBiDi] = "rtf:sprmCFBiDi";
    mMap[NS_sprm::LN_CFDiacColor] = "rtf:sprmCFDiacColor";
    mMap[NS_sprm::LN_CFBoldBi] = "rtf:sprmCFBoldBi";
    mMap[NS_sprm::LN_CFItalicBi] = "rtf:sprmCFItalicBi";
    mMap[NS_sprm::LN_CFtcBi] = "rtf:sprmCFtcBi";
    mMap[NS_sprm::LN_CLidBi] = "rtf:sprmCLidBi";
    mMap[NS_sprm::LN_CIcoBi] = "rtf:sprmCIcoBi";
    mMap[NS_sprm::LN_CHpsBi] = "rtf:sprmCHpsBi";
    mMap[NS_sprm::LN_CDispFldRMark] = "rtf:sprmCDispFldRMark";
    mMap[NS_sprm::LN_CIbstRMarkDel] = "rtf:sprmCIbstRMarkDel";
    mMap[NS_sprm::LN_CDttmRMarkDel] = "rtf:sprmCDttmRMarkDel";
    mMap[NS_sprm::LN_CBrc] = "rtf:sprmCBrc";
    mMap[NS_sprm::LN_CShd] = "rtf:sprmCShd";
    mMap[NS_sprm::LN_CIdslRMarkDel] = "rtf:sprmCIdslRMarkDel";
    mMap[NS_sprm::LN_CFUsePgsuSettings] = "rtf:sprmCFUsePgsuSettings";
    mMap[NS_sprm::LN_CCpg] = "rtf:sprmCCpg";
    mMap[NS_sprm::LN_CRgLid0] = "rtf:sprmCRgLid0";
    mMap[NS_sprm::LN_CRgLid1] = "rtf:sprmCRgLid1";
    mMap[NS_sprm::LN_CIdctHint] = "rtf:sprmCIdctHint";
    mMap[NS_sprm::LN_PicBrcl] = "rtf:sprmPicBrcl";
    mMap[NS_sprm::LN_PicScale] = "rtf:sprmPicScale";
    mMap[NS_sprm::LN_PicBrcTop] = "rtf:sprmPicBrcTop";
    mMap[NS_sprm::LN_PicBrcLeft] = "rtf:sprmPicBrcLeft";
    mMap[NS_sprm::LN_PicBrcBottom] = "rtf:sprmPicBrcBottom";
    mMap[NS_sprm::LN_PicBrcRight] = "rtf:sprmPicBrcRight";
    mMap[NS_sprm::LN_ScnsPgn] = "rtf:sprmScnsPgn";
    mMap[NS_sprm::LN_SiHeadingPgn] = "rtf:sprmSiHeadingPgn";
    mMap[NS_sprm::LN_SOlstAnm] = "rtf:sprmSOlstAnm";
    mMap[NS_sprm::LN_SDxaColWidth] = "rtf:sprmSDxaColWidth";
    mMap[NS_sprm::LN_SDxaColSpacing] = "rtf:sprmSDxaColSpacing";
    mMap[NS_sprm::LN_SFEvenlySpaced] = "rtf:sprmSFEvenlySpaced";
    mMap[NS_sprm::LN_SFProtected] = "rtf:sprmSFProtected";
    mMap[NS_sprm::LN_SDmBinFirst] = "rtf:sprmSDmBinFirst";
    mMap[NS_sprm::LN_SDmBinOther] = "rtf:sprmSDmBinOther";
    mMap[NS_sprm::LN_SBkc] = "rtf:sprmSBkc";
    mMap[NS_sprm::LN_SFTitlePage] = "rtf:sprmSFTitlePage";
    mMap[NS_sprm::LN_SCcolumns] = "rtf:sprmSCcolumns";
    mMap[NS_sprm::LN_SDxaColumns] = "rtf:sprmSDxaColumns";
    mMap[NS_sprm::LN_SFAutoPgn] = "rtf:sprmSFAutoPgn";
    mMap[NS_sprm::LN_SNfcPgn] = "rtf:sprmSNfcPgn";
    mMap[NS_sprm::LN_SDyaPgn] = "rtf:sprmSDyaPgn";
    mMap[NS_sprm::LN_SDxaPgn] = "rtf:sprmSDxaPgn";
    mMap[NS_sprm::LN_SFPgnRestart] = "rtf:sprmSFPgnRestart";
    mMap[NS_sprm::LN_SFEndnote] = "rtf:sprmSFEndnote";
    mMap[NS_sprm::LN_SLnc] = "rtf:sprmSLnc";
    mMap[NS_sprm::LN_SGprfIhdt] = "rtf:sprmSGprfIhdt";
    mMap[NS_sprm::LN_SNLnnMod] = "rtf:sprmSNLnnMod";
    mMap[NS_sprm::LN_SDxaLnn] = "rtf:sprmSDxaLnn";
    mMap[NS_sprm::LN_SDyaHdrTop] = "rtf:sprmSDyaHdrTop";
    mMap[NS_sprm::LN_SDyaHdrBottom] = "rtf:sprmSDyaHdrBottom";
    mMap[NS_sprm::LN_SLBetween] = "rtf:sprmSLBetween";
    mMap[NS_sprm::LN_SVjc] = "rtf:sprmSVjc";
    mMap[NS_sprm::LN_SLnnMin] = "rtf:sprmSLnnMin";
    mMap[NS_sprm::LN_SPgnStart] = "rtf:sprmSPgnStart";
    mMap[NS_sprm::LN_SBOrientation] = "rtf:sprmSBOrientation";
    mMap[NS_sprm::LN_SBCustomize] = "rtf:sprmSBCustomize";
    mMap[NS_sprm::LN_SXaPage] = "rtf:sprmSXaPage";
    mMap[NS_sprm::LN_SYaPage] = "rtf:sprmSYaPage";
    mMap[NS_sprm::LN_SDxaLeft] = "rtf:sprmSDxaLeft";
    mMap[NS_sprm::LN_SDxaRight] = "rtf:sprmSDxaRight";
    mMap[NS_sprm::LN_SDyaTop] = "rtf:sprmSDyaTop";
    mMap[NS_sprm::LN_SDyaBottom] = "rtf:sprmSDyaBottom";
    mMap[NS_sprm::LN_SDzaGutter] = "rtf:sprmSDzaGutter";
    mMap[NS_sprm::LN_SDmPaperReq] = "rtf:sprmSDmPaperReq";
    mMap[NS_sprm::LN_SPropRMark] = "rtf:sprmSPropRMark";
    mMap[NS_sprm::LN_SFBiDi] = "rtf:sprmSFBiDi";
    mMap[NS_sprm::LN_SFFacingCol] = "rtf:sprmSFFacingCol";
    mMap[NS_sprm::LN_SFRTLGutter] = "rtf:sprmSFRTLGutter";
    mMap[NS_sprm::LN_SBrcTop] = "rtf:sprmSBrcTop";
    mMap[NS_sprm::LN_SBrcLeft] = "rtf:sprmSBrcLeft";
    mMap[NS_sprm::LN_SBrcBottom] = "rtf:sprmSBrcBottom";
    mMap[NS_sprm::LN_SBrcRight] = "rtf:sprmSBrcRight";
    mMap[NS_sprm::LN_SPgbProp] = "rtf:sprmSPgbProp";
    mMap[NS_sprm::LN_SDxtCharSpace] = "rtf:sprmSDxtCharSpace";
    mMap[NS_sprm::LN_SDyaLinePitch] = "rtf:sprmSDyaLinePitch";
    mMap[NS_sprm::LN_SClm] = "rtf:sprmSClm";
    mMap[NS_sprm::LN_STextFlow] = "rtf:sprmSTextFlow";
    mMap[NS_sprm::LN_TJc] = "rtf:sprmTJc";
    mMap[NS_sprm::LN_TDxaLeft] = "rtf:sprmTDxaLeft";
    mMap[NS_sprm::LN_TDxaGapHalf] = "rtf:sprmTDxaGapHalf";
    mMap[NS_sprm::LN_TFCantSplit] = "rtf:sprmTFCantSplit";
    mMap[NS_sprm::LN_TTableHeader] = "rtf:sprmTTableHeader";
    mMap[NS_sprm::LN_TTableBorders] = "rtf:sprmTTableBorders";
    mMap[NS_sprm::LN_TDefTable10] = "rtf:sprmTDefTable10";
    mMap[NS_sprm::LN_TDyaRowHeight] = "rtf:sprmTDyaRowHeight";
    mMap[NS_sprm::LN_TDefTable] = "rtf:sprmTDefTable";
    mMap[NS_sprm::LN_TDefTableShd] = "rtf:sprmTDefTableShd";
    mMap[NS_sprm::LN_TCellShd] = "rtf:sprmTCellShd";
    mMap[NS_sprm::LN_TTlp] = "rtf:sprmTTlp";
    mMap[NS_sprm::LN_TFBiDi] = "rtf:sprmTFBiDi";
    mMap[NS_sprm::LN_THTMLProps] = "rtf:sprmTHTMLProps";
    mMap[NS_sprm::LN_TSetBrc] = "rtf:sprmTSetBrc";
    mMap[NS_sprm::LN_TInsert] = "rtf:sprmTInsert";
    mMap[NS_sprm::LN_TDelete] = "rtf:sprmTDelete";
    mMap[NS_sprm::LN_TDxaCol] = "rtf:sprmTDxaCol";
    mMap[NS_sprm::LN_TMerge] = "rtf:sprmTMerge";
    mMap[NS_sprm::LN_TSplit] = "rtf:sprmTSplit";
    mMap[NS_sprm::LN_TSetBrc10] = "rtf:sprmTSetBrc10";
    mMap[NS_sprm::LN_TSetShd] = "rtf:sprmTSetShd";
    mMap[NS_sprm::LN_TSetShdOdd] = "rtf:sprmTSetShdOdd";
    mMap[NS_sprm::LN_TTextFlow] = "rtf:sprmTTextFlow";
    mMap[NS_sprm::LN_TDiagLine] = "rtf:sprmTDiagLine";
    mMap[NS_sprm::LN_TVertMerge] = "rtf:sprmTVertMerge";
    mMap[NS_sprm::LN_TVertAlign] = "rtf:sprmTVertAlign";
    mMap[NS_sprm::LN_TCellTopColor] = "rtf:sprmTCellTopColor";
    mMap[NS_sprm::LN_TCellLeftColor] = "rtf:sprmTCellLeftColor";
    mMap[NS_sprm::LN_TCellBottomColor] = "rtf:sprmTCellBottomColor";
    mMap[NS_sprm::LN_TCellRightColor] = "rtf:sprmTCellRightColor";
    mMap[NS_sprm::LN_TGridLineProps] = "rtf:sprmTGridLineProps";
    mMap[NS_sprm::LN_CIndrsid] = "rtf:insrsid";
    mMap[NS_sprm::LN_Cdelrsid] = "rtf:delrsid";
    mMap[NS_sprm::LN_PTableDepth] = "rtf:sprmPTableDepth";
    mMap[NS_sprm::LN_TCellShadow] = "rtf:sprmTCellShadow";
    mMap[NS_sprm::LN_PBrcTop] = "rtf:sprmPBrcTop";
    mMap[NS_sprm::LN_PBrcLeft] = "rtf:sprmPBrcLeft";
    mMap[NS_sprm::LN_PBrcBottom] = "rtf:sprmPBrcBottom";
    mMap[NS_sprm::LN_PBrcRight] = "rtf:sprmPBrcRight";
    mMap[NS_sprm::LN_PBrcBetween] = "rtf:sprmPBrcBetween";
    mMap[NS_sprm::LN_PBorderTop] = "rtf:sprmPBorderTop";
    mMap[NS_sprm::LN_PBorderLeft] = "rtf:sprmPBorderLeft";
    mMap[NS_sprm::LN_PBorderBottom] = "rtf:sprmPBorderBottom";
    mMap[NS_sprm::LN_PBorderRight] = "rtf:sprmPBorderRight";
    mMap[NS_sprm::LN_PBorderBetween] = "rtf:sprmPBorderBetween";
    mMap[NS_sprm::LN_CBorder] = "rtf:sprmPBorderBetween";
    mMap[NS_sprm::LN_TTPreferredWidth] = "rtf:sprmTTPreferredWidth";
    mMap[NS_sprm::LN_TTRLeft] = "rtf:sprmTTRLeft";
    mMap[NS_sprm::LN_CEastAsianLayout] = "rtf:sprmCEastAsianLayout";
}
}
