/**
 * ===========================================
 * LibFonts : a free Java font reading library
 * ===========================================
 *
 * Project Info:  http://reporting.pentaho.org/libfonts/
 *
 * (C) Copyright 2006-2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * PostscriptInformationTable.java
 * ------------
 */
package org.pentaho.reporting.libraries.fonts.truetype;

import org.pentaho.reporting.libraries.fonts.ByteAccessUtilities;

/**
 * Creation-Date: 06.11.2005, 20:24:42
 *
 * @author Thomas Morgner
 */
public class PostscriptInformationTable implements FontTable
{
  public static final long TABLE_ID =
          ('p' << 24 | 'o' << 16 | 's' << 8 | 't');
  private float version;
  private float italicAngle;
  private short underlinePosition;
  private short underlineThickness;
  private boolean fixedPitch;

  public PostscriptInformationTable(final byte[] data)
  {
    version = ByteAccessUtilities.readFixed(data, 0);
    italicAngle = ByteAccessUtilities.readFixed(data, 4);
    underlinePosition = ByteAccessUtilities.readShort(data, 8);
    underlineThickness = ByteAccessUtilities.readShort(data, 10);
    fixedPitch = ByteAccessUtilities.readULong(data, 12) != 0;
  }

  public float getVersion()
  {
    return version;
  }

  public float getItalicAngle()
  {
    return italicAngle;
  }

  public short getUnderlinePosition()
  {
    return underlinePosition;
  }

  public short getUnderlineThickness()
  {
    return underlineThickness;
  }

  public boolean isFixedPitch()
  {
    return fixedPitch;
  }

  public long getName()
  {
    return TABLE_ID;
  }
}
