.\"
.\" $XFree86: xc/doc/man/Xi/XChgPtr.man,v 1.4 2005/02/11 03:03:03 dawes Exp $
.\"
.\"
.\" Copyright ([\d,\s]*) by Hewlett-Packard Company, Ardent Computer, 
.\" 
.\" Permission to use, copy, modify, distribute, and sell this documentation 
.\" for any purpose and without fee is hereby granted, provided that the above
.\" copyright notice and this permission notice appear in all copies.
.\" Ardent, and Hewlett-Packard make no representations about the 
.\" suitability for any purpose of the information in this document.  It is 
.\" provided \`\`as is'' without express or implied warranty.
.\" 
.\" $Xorg: XChgPtr.man,v 1.3 2000/08/17 19:41:56 cpqbld Exp $
.ds xL Programming With Xlib
.TH XChangePointerDevice 3X11 __vendorversion__ "X FUNCTIONS"
.SH NAME
XChangePointerDevice \- change which device is the X pointer
.SH SYNTAX
.HP
Status XChangePointerDevice\^(\^Display *\fIdisplay\fP\^, XDevice
*\fIdevice\fP\^, int \fIxaxis\fP\^, int \fIyaxis\fP\^); 
.br
.SH ARGUMENTS
.TP 12
.I display
Specifies the connection to the X server.
.TP 12
.I device
Specifies the device to be used as the X pointer.
.TP 12
.I xaxis
Specifies the axis of the device to be used as the X pointer x-axis.
.TP 12
.I yaxis
Specifies the axis of the device to be used as the X pointer y-axis.
.SH DESCRIPTION
The \fIXChangePointerDevice\fP request causes the server to use the specified
device as the X pointer.  The device must have been opened by the client via
\fIXOpenDevice\fP or a \fIBadDevice\fP error will result.  The device must
support input class \fIValuators\fP or a \fIBadMatch\fP error will result.
If the implementation does not support use of the specified device as the
X pointer, a \fIBadDevice\fP error will result.
.LP
If the specified device is grabbed by another client, \fIAlreadyGrabbed\fP
is returned.  If the specified device is frozen by a grab on another device,
\fIGrabFrozen\fP is returned.
If the request is successful, \fISuccess\fP is returned.
.LP
If the request succeeds,
a \fIChangeDeviceNotify\fP event is sent to all clients that have selected that
event.  A \fIMappingNotify\fP event with request = \fIMappingPointer\fP is
sent to all clients.
The specified device becomes the X pointer, and
the old X pointer becomes accessible through the input extension
protocol requests.
.LP
\fIXChangePointerDevice\fP can generate a \fIBadDevice\fP or a \fIBadMatch\fP
error.
.SH DIAGNOSTICS
.TP 12
\fIBadDevice\fP
An invalid device was specified.  The specified device does not exist, has 
not been opened by this client via \fIXOpenInputDevice\fP, or is already
one of the core X input devices (pointer or keyboard).  This error may also
occur if the server implementation does not support using the specified
device as the X pointer.
.TP 12
\fIBadMatch\fP
This error may occur if an \fIXChangePointerDevice\fP request was made 
specifying a device that has less than two valuators, or specifying a 
valuator index beyond the range supported by the device.
.SH "SEE ALSO"
XChangeKeyboardDevice
.br
\fI\*(xL\fP
