/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.app.Activity;
import android.app.Instrumentation;
import android.content.Context;
import android.view.View;
import android.widget.TextView;
import com.jayway.android.robotium.solo.ActivityUtils;
import com.jayway.android.robotium.solo.Timeout;
import com.jayway.android.robotium.solo.Waiter;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Getter {
    private final Instrumentation instrumentation;
    private final ActivityUtils activityUtils;
    private final Waiter waiter;

    public Getter(Instrumentation instrumentation, ActivityUtils activityUtils, Waiter waiter) {
        this.instrumentation = instrumentation;
        this.activityUtils = activityUtils;
        this.waiter = waiter;
    }

    public <T extends View> T getView(Class<T> classToFilterBy, int index) {
        return this.waiter.waitForAndGetView(index, classToFilterBy);
    }

    public <T extends TextView> T getView(Class<T> classToFilterBy, String text, boolean onlyVisible) {
        T viewToReturn = this.waiter.waitForText(classToFilterBy, text, 0, Timeout.getSmallTimeout(), false, onlyVisible, false);
        if (viewToReturn == null) {
            Assert.assertTrue((String)(classToFilterBy.getSimpleName() + " with text: '" + text + "' is not found!"), (boolean)false);
        }
        return viewToReturn;
    }

    public View getView(int id, int index) {
        Activity activity = this.activityUtils.getCurrentActivity(false);
        View viewToReturn = null;
        if (index < 1) {
            index = 0;
            viewToReturn = activity.findViewById(id);
        }
        if (viewToReturn != null) {
            return viewToReturn;
        }
        return this.waiter.waitForView(id, index);
    }

    public View getView(String id, int index) {
        Context targetContext = this.instrumentation.getTargetContext();
        String packageName = targetContext.getPackageName();
        int viewId = targetContext.getResources().getIdentifier(id, "id", packageName);
        return this.getView(viewId, index);
    }
}

