/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.os.SystemClock;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import com.jayway.android.robotium.solo.By;
import com.jayway.android.robotium.solo.RobotiumUtils;
import com.jayway.android.robotium.solo.Scroller;
import com.jayway.android.robotium.solo.Sleeper;
import com.jayway.android.robotium.solo.ViewFetcher;
import com.jayway.android.robotium.solo.WebElement;
import com.jayway.android.robotium.solo.WebUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Searcher {
    private final ViewFetcher viewFetcher;
    private final WebUtils webUtils;
    private final Scroller scroller;
    private final Sleeper sleeper;
    private final String LOG_TAG = "Robotium";
    Set<TextView> uniqueTextViews;
    List<WebElement> webElements;
    private int numberOfUniqueViews;
    private final int TIMEOUT = 5000;

    public Searcher(ViewFetcher viewFetcher, WebUtils webUtils, Scroller scroller, Sleeper sleeper) {
        this.viewFetcher = viewFetcher;
        this.webUtils = webUtils;
        this.scroller = scroller;
        this.sleeper = sleeper;
        this.webElements = new ArrayList<WebElement>();
        this.uniqueTextViews = new HashSet<TextView>();
    }

    public boolean searchWithTimeoutFor(Class<? extends TextView> viewClass, String regex, int expectedMinimumNumberOfMatches, boolean scroll, boolean onlyVisible) {
        long endTime = SystemClock.uptimeMillis() + 5000L;
        TextView foundAnyMatchingView = null;
        while (SystemClock.uptimeMillis() < endTime) {
            this.sleeper.sleep();
            foundAnyMatchingView = this.searchFor(viewClass, regex, expectedMinimumNumberOfMatches, 0L, scroll, onlyVisible);
            if (foundAnyMatchingView == null) continue;
            return true;
        }
        return false;
    }

    public <T extends TextView> T searchFor(final Class<T> viewClass, String regex, int expectedMinimumNumberOfMatches, long timeout, boolean scroll, final boolean onlyVisible) {
        if (expectedMinimumNumberOfMatches < 1) {
            expectedMinimumNumberOfMatches = 1;
        }
        Callable viewFetcherCallback = new Callable<Collection<T>>(){

            @Override
            public Collection<T> call() throws Exception {
                Searcher.this.sleeper.sleep();
                ArrayList viewsToReturn = Searcher.this.viewFetcher.getCurrentViews(viewClass);
                if (onlyVisible) {
                    viewsToReturn = RobotiumUtils.removeInvisibleViews(viewsToReturn);
                }
                if (viewClass.isAssignableFrom(TextView.class)) {
                    viewsToReturn.addAll(Searcher.this.webUtils.getTextViewsFromWebView());
                }
                return viewsToReturn;
            }
        };
        try {
            return this.searchFor(viewFetcherCallback, regex, expectedMinimumNumberOfMatches, timeout, scroll);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T extends View> boolean searchFor(Set<T> uniqueViews, Class<T> viewClass, int index) {
        ArrayList<T> allViews = RobotiumUtils.removeInvisibleViews(this.viewFetcher.getCurrentViews(viewClass));
        int uniqueViewsFound = this.getNumberOfUniqueViews(uniqueViews, allViews);
        if (uniqueViewsFound > 0 && index < uniqueViewsFound) {
            return true;
        }
        return uniqueViewsFound > 0 && index == 0;
    }

    public <T extends View> boolean searchFor(View view) {
        ArrayList<View> views = this.viewFetcher.getAllViews(true);
        for (View v : views) {
            if (!v.equals(view)) continue;
            return true;
        }
        return false;
    }

    public <T extends TextView> T searchFor(Callable<Collection<T>> viewFetcherCallback, String regex, int expectedMinimumNumberOfMatches, long timeout, boolean scroll) throws Exception {
        long endTime = SystemClock.uptimeMillis() + timeout;
        do {
            boolean timedOut;
            boolean bl = timedOut = timeout > 0L && SystemClock.uptimeMillis() > endTime;
            if (timedOut) {
                this.logMatchesFound(regex);
                return null;
            }
            Collection<T> views = viewFetcherCallback.call();
            for (TextView view : views) {
                if (RobotiumUtils.getNumberOfMatches(regex, view, this.uniqueTextViews) != expectedMinimumNumberOfMatches) continue;
                this.uniqueTextViews.clear();
                return (T)view;
            }
            if (!scroll || this.scroller.scroll(0)) continue;
            this.logMatchesFound(regex);
            return null;
        } while (scroll);
        this.logMatchesFound(regex);
        return null;
    }

    public WebElement searchForWebElement(By by, int minimumNumberOfMatches, int timeout, boolean scroll) {
        if (minimumNumberOfMatches < 1) {
            minimumNumberOfMatches = 1;
        }
        ArrayList<WebElement> viewsFromScreen = this.webUtils.getCurrentWebElements(by);
        this.addViewsToList(this.webElements, viewsFromScreen);
        return this.getViewFromList(this.webElements, minimumNumberOfMatches);
    }

    private void addViewsToList(List<WebElement> allWebElements, List<WebElement> webElementsOnScreen) {
        int[] xyViewFromSet = new int[2];
        int[] xyViewFromScreen = new int[2];
        for (WebElement textFromScreen : webElementsOnScreen) {
            boolean foundView = false;
            textFromScreen.getLocationOnScreen(xyViewFromScreen);
            for (WebElement textFromList : allWebElements) {
                textFromList.getLocationOnScreen(xyViewFromSet);
                if (!textFromScreen.getText().equals(textFromList.getText()) || xyViewFromScreen[0] != xyViewFromSet[0] || xyViewFromScreen[1] != xyViewFromSet[1]) continue;
                foundView = true;
            }
            if (foundView) continue;
            allWebElements.add(textFromScreen);
        }
    }

    private WebElement getViewFromList(List<WebElement> webElements, int match) {
        WebElement webElementToReturn = null;
        if (webElements.size() >= match) {
            try {
                webElementToReturn = webElements.get(--match);
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        if (webElementToReturn != null) {
            webElements.clear();
        }
        return webElementToReturn;
    }

    public <T extends View> int getNumberOfUniqueViews(Set<T> uniqueViews, ArrayList<T> views) {
        for (int i = 0; i < views.size(); ++i) {
            uniqueViews.add(views.get(i));
        }
        this.numberOfUniqueViews = uniqueViews.size();
        return this.numberOfUniqueViews;
    }

    public int getNumberOfUniqueViews() {
        return this.numberOfUniqueViews;
    }

    public void logMatchesFound(String regex) {
        if (this.uniqueTextViews.size() > 0) {
            Log.d((String)"Robotium", (String)(" There are only " + this.uniqueTextViews.size() + " matches of '" + regex + "'"));
        } else if (this.webElements.size() > 0) {
            Log.d((String)"Robotium", (String)(" There are only " + this.webElements.size() + " matches of '" + regex + "'"));
        }
        this.uniqueTextViews.clear();
        this.webElements.clear();
    }
}

