/* Any copyright is dedicated to the Public Domain.
   http://creativecommons.org/publicdomain/zero/1.0/ */

MARIONETTE_HEAD_JS = "stk_helper.js";

function testSendUSSD(command, expect) {
  log("STK CMD " + JSON.stringify(command));
  is(command.typeOfCommand, iccManager.STK_CMD_SEND_USSD, expect.name);
  is(command.commandQualifier, expect.commandQualifier, expect.name);
  is(command.options.text, expect.title, expect.name);

  runNextTest();
}

let tests = [
  {command: "d050810301120082028183850a372d62697420555353448a39f041e19058341e9149e592d9743ea151e9945ab55eb1596d2b2c1e93cbe6333aad5eb3dbee373c2e9fd3ebf63b3eaf6fc564335acd76c3e560",
   func: testSendUSSD,
   expect: {name: "send_ussd_cmd_1_with_alpha_identifier",
            commandQualifier: 0x00,
            title: "7-bit USSD"}},
  {command: "d0448103011200820281838a39f041e19058341e9149e592d9743ea151e9945ab55eb1596d2b2c1e93cbe6333aad5eb3dbee373c2e9fd3ebf63b3eaf6fc564335acd76c3e560",
   func: testSendUSSD,
   expect: {name: "send_ussd_cmd_1_without_alpha_identifier",
            commandQualifier: 0x00}},
  {command: "d058810301120082028183850a382d62697420555353448a41444142434445464748494a4b4c4d4e4f505152535455565758595a2d6162636465666768696a6b6c6d6e6f707172737475767778797a2d31323334353637383930",
   func: testSendUSSD,
   expect: {name: "send_ussd_cmd_2_with_alpha_identifier",
            commandQualifier: 0x00,
            title: "8-bit USSD"}},
  {command: "d04c8103011200820281838a41444142434445464748494a4b4c4d4e4f505152535455565758595a2d6162636465666768696a6b6c6d6e6f707172737475767778797a2d31323334353637383930",
   func: testSendUSSD,
   expect: {name: "send_ussd_cmd_2_without_alpha_identifier",
            commandQualifier: 0x00}},
  {command: "d02f81030112008202818385095543533220555353448a1948041704140420041004120421042204120423041904220415",
   func: testSendUSSD,
   expect: {name: "send_ussd_cmd_3_with_alpha_identifier",
            commandQualifier: 0x00,
            title: "UCS2 USSD"}},
  {command: "d0248103011200820281838a1948041704140420041004120421042204120423041904220415",
   func: testSendUSSD,
   expect: {name: "send_ussd_cmd_3_without_alpha_identifier",
            commandQualifier: 0x00}},
  {command: "d081fd8103011200820281838581b66f6e636520612052454c4541534520434f4d504c455445206d65737361676520636f6e7461696e696e672074686520555353442052657475726e20526573756c74206d657373616765206e6f7420636f6e7461696e696e6720616e206572726f7220686173206265656e2072656365697665642066726f6d20746865206e6574776f726b2c20746865204d45207368616c6c20696e666f726d207468652053494d20746861742074686520636f6d6d616e64206861738a39f041e19058341e9149e592d9743ea151e9945ab55eb1596d2b2c1e93cbe6333aad5eb3dbee373c2e9fd3ebf63b3eaf6fc564335acd76c3e560",
   func: testSendUSSD,
   expect: {name: "send_ussd_cmd_4_with_alpha_identifier",
            commandQualifier: 0x00,
            title: "once a RELEASE COMPLETE message containing the USSD Return Result message not containing an error has been received from the network, the ME shall inform the SIM that the command has"}},
  // send_ussd_cmd_4_without_alpha_identifier has the same pdu as
  // send_ussd_cmd_1_without_alpha_identifier.
  {command: "d04681030112008202818385008a39f041e19058341e9149e592d9743ea151e9945ab55eb1596d2b2c1e93cbe6333aad5eb3dbee373c2e9fd3ebf63b3eaf6fc564335acd76c3e560",
   func: testSendUSSD,
   expect: {name: "send_ussd_cmd_5_with_alpha_identifier",
         commandQualifier: 0x00,
         title: ""}},
  // send_ussd_cmd_5_without_alpha_identifier has the same pdu as
  // send_ussd_cmd_1_without_alpha_identifier.
  {command: "d054810301120082028183850a42617369632049636f6e8a39f041e19058341e9149e592d9743ea151e9945ab55eb1596d2b2c1e93cbe6333aad5eb3dbee373c2e9fd3ebf63b3eaf6fc564335acd76c3e5609e020001",
   func: testSendUSSD,
   expect: {name: "send_ussd_cmd_6_with_alpha_identifier",
            commandQualifier: 0x00,
            title: "Basic Icon"}},
  {command: "d0488103011200820281838a39f041e19058341e9149e592d9743ea151e9945ab55eb1596d2b2c1e93cbe6333aad5eb3dbee373c2e9fd3ebf63b3eaf6fc564335acd76c3e5609e020001",
   func: testSendUSSD,
   expect: {name: "send_ussd_cmd_6_without_alpha_identifier",
            commandQualifier: 0x00}},
  {command: "d054810301120082028183850a436f6c6f722049636f6e8a39f041e19058341e9149e592d9743ea151e9945ab55eb1596d2b2c1e93cbe6333aad5eb3dbee373c2e9fd3ebf63b3eaf6fc564335acd76c3e5609e020002",
   func: testSendUSSD,
   expect: {name: "send_ussd_cmd_7_with_alpha_identifier",
            commandQualifier: 0x00,
            title: "Color Icon"}},
  {command: "d0488103011200820281838a39f041e19058341e9149e592d9743ea151e9945ab55eb1596d2b2c1e93cbe6333aad5eb3dbee373c2e9fd3ebf63b3eaf6fc564335acd76c3e5609e020002",
   func: testSendUSSD,
   expect: {name: "send_ussd_cmd_7_without_alpha_identifier",
            commandQualifier: 0x00}},
  {command: "d054810301120082028183850a42617369632049636f6e8a39f041e19058341e9149e592d9743ea151e9945ab55eb1596d2b2c1e93cbe6333aad5eb3dbee373c2e9fd3ebf63b3eaf6fc564335acd76c3e5609e020101",
   func: testSendUSSD,
   expect: {name: "send_ussd_cmd_8_with_alpha_identifier",
            commandQualifier: 0x00,
            title: "Basic Icon"}},
  {command: "d0488103011200820281838a39f041e19058341e9149e592d9743ea151e9945ab55eb1596d2b2c1e93cbe6333aad5eb3dbee373c2e9fd3ebf63b3eaf6fc564335acd76c3e5609e020101",
   func: testSendUSSD,
   expect: {name: "send_ussd_cmd_8_without_alpha_identifier",
            commandQualifier: 0x00}},
  {command: "d05f8103011200820281838519800417041404200410041204210422041204230419042204158a39f041e19058341e9149e592d9743ea151e9945ab55eb1596d2b2c1e93cbe6333aad5eb3dbee373c2e9fd3ebf63b3eaf6fc564335acd76c3e560",
   func: testSendUSSD,
   expect: {name: "send_ussd_cmd_9_with_alpha_identifier",
            commandQualifier: 0x00,
            title: "ЗДРАВСТВУЙТЕ"}},
  // send_ussd_cmd_9_without_alpha_identifier has the same pdu as
  // send_ussd_cmd_1_without_alpha_identifier.
  {command: "d05c8103011200820281838510546578742041747472696275746520318a39f041e19058341e9149e592d9743ea151e9945ab55eb1596d2b2c1e93cbe6333aad5eb3dbee373c2e9fd3ebf63b3eaf6fc564335acd76c3e560d004001000b4",
   func: testSendUSSD,
   expect: {name: "send_ussd_cmd_10_with_alpha_identifier",
            commandQualifier: 0x00,
            title: "Text Attribute 1"}},
  {command: "d04a8103011200820281838a39f041e19058341e9149e592d9743ea151e9945ab55eb1596d2b2c1e93cbe6333aad5eb3dbee373c2e9fd3ebf63b3eaf6fc564335acd76c3e560d004001000b4",
   func: testSendUSSD,
   expect: {name: "send_ussd_cmd_10_without_alpha_identifier",
            commandQualifier: 0x00}},
  {command: "d0568103011200820281838510546578742041747472696275746520328a39f041e19058341e9149e592d9743ea151e9945ab55eb1596d2b2c1e93cbe6333aad5eb3dbee373c2e9fd3ebf63b3eaf6fc564335acd76c3e560",
   func: testSendUSSD,
   expect: {name: "send_ussd_cmd_11_with_alpha_identifier",
            commandQualifier: 0x00,
            title: "Text Attribute 2"}},
  // send_ussd_cmd_11_without_alpha_identifier has the same pdu as
  // send_ussd_cmd_1_without_alpha_identifier.
  {command: "d05c8103011200820281838510546578742041747472696275746520318a39f041e19058341e9149e592d9743ea151e9945ab55eb1596d2b2c1e93cbe6333aad5eb3dbee373c2e9fd3ebf63b3eaf6fc564335acd76c3e560d004001001b4",
   func: testSendUSSD,
   expect: {name: "send_ussd_cmd_12_with_alpha_identifier",
            commandQualifier: 0x00,
            title: "Text Attribute 1"}},
  {command: "d04a8103011200820281838a39f041e19058341e9149e592d9743ea151e9945ab55eb1596d2b2c1e93cbe6333aad5eb3dbee373c2e9fd3ebf63b3eaf6fc564335acd76c3e560d004001001b4",
   func: testSendUSSD,
   expect: {name: "send_ussd_cmd_12_without_alpha_identifier",
            commandQualifier: 0x00}},
  {command: "d05c8103011200820281838510546578742041747472696275746520318a39f041e19058341e9149e592d9743ea151e9945ab55eb1596d2b2c1e93cbe6333aad5eb3dbee373c2e9fd3ebf63b3eaf6fc564335acd76c3e560d004001002b4",
   func: testSendUSSD,
   expect: {name: "send_ussd_cmd_13_with_alpha_identifier",
            commandQualifier: 0x00,
            title: "Text Attribute 1"}},
  {command: "d04a8103011200820281838a39f041e19058341e9149e592d9743ea151e9945ab55eb1596d2b2c1e93cbe6333aad5eb3dbee373c2e9fd3ebf63b3eaf6fc564335acd76c3e560d004001002b4",
   func: testSendUSSD,
   expect: {name: "send_ussd_cmd_13_without_alpha_identifier",
            commandQualifier: 0x00}},
  {command: "d05c8103011200820281838510546578742041747472696275746520318a39f041e19058341e9149e592d9743ea151e9945ab55eb1596d2b2c1e93cbe6333aad5eb3dbee373c2e9fd3ebf63b3eaf6fc564335acd76c3e560d004001004b4",
   func: testSendUSSD,
   expect: {name: "send_ussd_cmd_14_with_alpha_identifier",
            commandQualifier: 0x00,
            title: "Text Attribute 1"}},
  {command: "d04a8103011200820281838a39f041e19058341e9149e592d9743ea151e9945ab55eb1596d2b2c1e93cbe6333aad5eb3dbee373c2e9fd3ebf63b3eaf6fc564335acd76c3e560d004001004b4",
   func: testSendUSSD,
   expect: {name: "send_ussd_cmd_14_without_alpha_identifier",
            commandQualifier: 0x00}},
  {command: "d05c8103011200820281838510546578742041747472696275746520328a39f041e19058341e9149e592d9743ea151e9945ab55eb1596d2b2c1e93cbe6333aad5eb3dbee373c2e9fd3ebf63b3eaf6fc564335acd76c3e560d004001000b4",
   func: testSendUSSD,
   expect: {name: "send_ussd_cmd_15_with_alpha_identifier",
            commandQualifier: 0x00,
            title: "Text Attribute 2"}},
  // send_ussd_cmd_15_without_alpha_identifier has the same pdu as
  // send_ussd_cmd_10_with_alpha_identifier.
  {command: "d0568103011200820281838510546578742041747472696275746520338a39f041e19058341e9149e592d9743ea151e9945ab55eb1596d2b2c1e93cbe6333aad5eb3dbee373c2e9fd3ebf63b3eaf6fc564335acd76c3e560",
   func: testSendUSSD,
   expect: {name: "send_ussd_cmd_16_with_alpha_identifier",
            commandQualifier: 0x00,
            title: "Text Attribute 3"}},
  // send_ussd_cmd_16_without_alpha_identifier has the same pdu as
  // send_ussd_cmd_1_without_alpha_identifier.
  {command: "d05c8103011200820281838510546578742041747472696275746520318a39f041e19058341e9149e592d9743ea151e9945ab55eb1596d2b2c1e93cbe6333aad5eb3dbee373c2e9fd3ebf63b3eaf6fc564335acd76c3e560d004001008b4",
   func: testSendUSSD,
   expect: {name: "send_ussd_cmd_17_with_alpha_identifier",
            commandQualifier: 0x00,
            title: "Text Attribute 1"}},
  {command: "d04a8103011200820281838a39f041e19058341e9149e592d9743ea151e9945ab55eb1596d2b2c1e93cbe6333aad5eb3dbee373c2e9fd3ebf63b3eaf6fc564335acd76c3e560d004001008b4",
   func: testSendUSSD,
   expect: {name: "send_ussd_cmd_17_without_alpha_identifier",
            commandQualifier: 0x00}},
  {command: "d05c8103011200820281838510546578742041747472696275746520318a39f041e19058341e9149e592d9743ea151e9945ab55eb1596d2b2c1e93cbe6333aad5eb3dbee373c2e9fd3ebf63b3eaf6fc564335acd76c3e560d004001010b4",
   func: testSendUSSD,
   expect: {name: "send_ussd_cmd_18_with_alpha_identifier",
            commandQualifier: 0x00,
            title: "Text Attribute 1"}},
  {command: "d04a8103011200820281838a39f041e19058341e9149e592d9743ea151e9945ab55eb1596d2b2c1e93cbe6333aad5eb3dbee373c2e9fd3ebf63b3eaf6fc564335acd76c3e560d004001010b4",
   func: testSendUSSD,
   expect: {name: "send_ussd_cmd_18_without_alpha_identifier",
            commandQualifier: 0x00}},
  {command: "d05c8103011200820281838510546578742041747472696275746520318a39f041e19058341e9149e592d9743ea151e9945ab55eb1596d2b2c1e93cbe6333aad5eb3dbee373c2e9fd3ebf63b3eaf6fc564335acd76c3e560d004001020b4",
   func: testSendUSSD,
   expect: {name: "send_ussd_cmd_19_with_alpha_identifier",
            commandQualifier: 0x00,
            title: "Text Attribute 1"}},
  {command: "d04a8103011200820281838a39f041e19058341e9149e592d9743ea151e9945ab55eb1596d2b2c1e93cbe6333aad5eb3dbee373c2e9fd3ebf63b3eaf6fc564335acd76c3e560d004001020b4",
   func: testSendUSSD,
   expect: {name: "send_ussd_cmd_19_without_alpha_identifier",
            commandQualifier: 0x00}},
  {command: "d05c8103011200820281838510546578742041747472696275746520318a39f041e19058341e9149e592d9743ea151e9945ab55eb1596d2b2c1e93cbe6333aad5eb3dbee373c2e9fd3ebf63b3eaf6fc564335acd76c3e560d004001040b4",
   func: testSendUSSD,
   expect: {name: "send_ussd_cmd_20_with_alpha_identifier",
            commandQualifier: 0x00,
            title: "Text Attribute 1"}},
  {command: "d04a8103011200820281838a39f041e19058341e9149e592d9743ea151e9945ab55eb1596d2b2c1e93cbe6333aad5eb3dbee373c2e9fd3ebf63b3eaf6fc564335acd76c3e560d004001040b4",
   func: testSendUSSD,
   expect: {name: "send_ussd_cmd_20_without_alpha_identifier",
            commandQualifier: 0x00}},
  {command: "d05c8103011200820281838510546578742041747472696275746520318a39f041e19058341e9149e592d9743ea151e9945ab55eb1596d2b2c1e93cbe6333aad5eb3dbee373c2e9fd3ebf63b3eaf6fc564335acd76c3e560d004001080b4",
   func: testSendUSSD,
   expect: {name: "send_ussd_cmd_21_with_alpha_identifier",
            commandQualifier: 0x00,
            title: "Text Attribute 1"}},
  {command: "d04a8103011200820281838a39f041e19058341e9149e592d9743ea151e9945ab55eb1596d2b2c1e93cbe6333aad5eb3dbee373c2e9fd3ebf63b3eaf6fc564335acd76c3e560d004001080b4",
   func: testSendUSSD,
   expect: {name: "send_ussd_cmd_21_without_alpha_identifier",
            commandQualifier: 0x00}},
  {command: "d04b8103011200820281838505804f60597d8a39f041e19058341e9149e592d9743ea151e9945ab55eb1596d2b2c1e93cbe6333aad5eb3dbee373c2e9fd3ebf63b3eaf6fc564335acd76c3e560",
   func: testSendUSSD,
   expect: {name: "send_ussd_cmd_22_with_alpha_identifier",
            commandQualifier: 0x00,
            title: "你好"}},
  // send_ussd_cmd_22_without_alpha_identifier has the same pdu as
  // send_ussd_cmd_1_without_alpha_identifier.
  {command: "d04981030112008202818385038030eb8a39f041e19058341e9149e592d9743ea151e9945ab55eb1596d2b2c1e93cbe6333aad5eb3dbee373c2e9fd3ebf63b3eaf6fc564335acd76c3e560",
   func: testSendUSSD,
   expect: {name: "send_ussd_cmd_23_with_alpha_identifier",
            commandQualifier: 0x00,
            title: "ル"}},
  // send_ussd_cmd_23_without_alpha_identifier has the same pdu as
  // send_ussd_cmd_1_without_alpha_identifier.
];

runNextTest();
