
/* -*- Mode: C++; tab-width: 20; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/*
 * Derived from the Unicode Character Database by genUnicodePropertyData.pl
 *
 * For Unicode terms of use, see http://www.unicode.org/terms_of_use.html
 */

/*
 * Created on Mon Sep  7 02:52:23 2015 from UCD data files with version info:
 *

# Date: 2015-06-16, 20:24:00 GMT [KW]
#
# Unicode Character Database
# Copyright (c) 1991-2015 Unicode, Inc.
# For terms of use, see http://www.unicode.org/terms_of_use.html
#
# For documentation, see the following:
# NamesList.html
# UAX #38, "Unicode Han Database (Unihan)"
# UAX #44, "Unicode Character Database."
#
# The UAXes can be accessed at http://www.unicode.org/versions/Unicode8.0.0/

This directory contains the final data files
for the Unicode Character Database, for Version 8.0.0 of the Unicode
Standard.


# Scripts-8.0.0.txt
# Date: 2015-03-11, 22:29:42 GMT [MD]

# BidiMirroring-8.0.0.txt
# Date: 2015-01-20, 18:30:00 GMT [KW, LI]

# HangulSyllableType-8.0.0.txt
# Date: 2014-12-16, 23:07:45 GMT [MD]

# File: xidmodifications.txt
# Version: 8.0.0
# Generated: 2015-05-17, 03:09:04 GMT

#
# Unihan_Variants.txt
# Date: 2015-04-30 18:38:20 GMT [JHJ]

# VerticalOrientation-13.txt
# Date: 2014-09-03, 17:30:00 GMT [EM, KI, LI]

 *
 * * * * * This file contains MACHINE-GENERATED DATA, do not edit! * * * * *
 */

#include <stdint.h>
#include "harfbuzz/hb.h"

static const uint32_t sScriptCodeToTag[] = {
  HB_TAG('Z','y','y','y'),
  HB_TAG('Z','i','n','h'),
  HB_TAG('A','r','a','b'),
  HB_TAG('A','r','m','n'),
  HB_TAG('B','e','n','g'),
  HB_TAG('B','o','p','o'),
  HB_TAG('C','h','e','r'),
  HB_TAG('C','o','p','t'),
  HB_TAG('C','y','r','l'),
  HB_TAG('D','s','r','t'),
  HB_TAG('D','e','v','a'),
  HB_TAG('E','t','h','i'),
  HB_TAG('G','e','o','r'),
  HB_TAG('G','o','t','h'),
  HB_TAG('G','r','e','k'),
  HB_TAG('G','u','j','r'),
  HB_TAG('G','u','r','u'),
  HB_TAG('H','a','n','i'),
  HB_TAG('H','a','n','g'),
  HB_TAG('H','e','b','r'),
  HB_TAG('H','i','r','a'),
  HB_TAG('K','n','d','a'),
  HB_TAG('K','a','n','a'),
  HB_TAG('K','h','m','r'),
  HB_TAG('L','a','o','o'),
  HB_TAG('L','a','t','n'),
  HB_TAG('M','l','y','m'),
  HB_TAG('M','o','n','g'),
  HB_TAG('M','y','m','r'),
  HB_TAG('O','g','a','m'),
  HB_TAG('I','t','a','l'),
  HB_TAG('O','r','y','a'),
  HB_TAG('R','u','n','r'),
  HB_TAG('S','i','n','h'),
  HB_TAG('S','y','r','c'),
  HB_TAG('T','a','m','l'),
  HB_TAG('T','e','l','u'),
  HB_TAG('T','h','a','a'),
  HB_TAG('T','h','a','i'),
  HB_TAG('T','i','b','t'),
  HB_TAG('C','a','n','s'),
  HB_TAG('Y','i','i','i'),
  HB_TAG('T','g','l','g'),
  HB_TAG('H','a','n','o'),
  HB_TAG('B','u','h','d'),
  HB_TAG('T','a','g','b'),
  HB_TAG('B','r','a','i'),
  HB_TAG('C','p','r','t'),
  HB_TAG('L','i','m','b'),
  HB_TAG('O','s','m','a'),
  HB_TAG('S','h','a','w'),
  HB_TAG('L','i','n','b'),
  HB_TAG('T','a','l','e'),
  HB_TAG('U','g','a','r'),
  HB_TAG('T','a','l','u'),
  HB_TAG('B','u','g','i'),
  HB_TAG('G','l','a','g'),
  HB_TAG('T','f','n','g'),
  HB_TAG('S','y','l','o'),
  HB_TAG('X','p','e','o'),
  HB_TAG('K','h','a','r'),
  HB_TAG('Z','z','z','z'),
  HB_TAG('B','a','l','i'),
  HB_TAG('X','s','u','x'),
  HB_TAG('P','h','n','x'),
  HB_TAG('P','h','a','g'),
  HB_TAG('N','k','o','o'),
  HB_TAG('K','a','l','i'),
  HB_TAG('L','e','p','c'),
  HB_TAG('R','j','n','g'),
  HB_TAG('S','u','n','d'),
  HB_TAG('S','a','u','r'),
  HB_TAG('C','h','a','m'),
  HB_TAG('O','l','c','k'),
  HB_TAG('V','a','i','i'),
  HB_TAG('C','a','r','i'),
  HB_TAG('L','y','c','i'),
  HB_TAG('L','y','d','i'),
  HB_TAG('A','v','s','t'),
  HB_TAG('B','a','m','u'),
  HB_TAG('E','g','y','p'),
  HB_TAG('A','r','m','i'),
  HB_TAG('P','h','l','i'),
  HB_TAG('P','r','t','i'),
  HB_TAG('J','a','v','a'),
  HB_TAG('K','t','h','i'),
  HB_TAG('L','i','s','u'),
  HB_TAG('M','t','e','i'),
  HB_TAG('S','a','r','b'),
  HB_TAG('O','r','k','h'),
  HB_TAG('S','a','m','r'),
  HB_TAG('L','a','n','a'),
  HB_TAG('T','a','v','t'),
  HB_TAG('B','a','t','k'),
  HB_TAG('B','r','a','h'),
  HB_TAG('M','a','n','d'),
  HB_TAG('C','a','k','m'),
  HB_TAG('M','e','r','c'),
  HB_TAG('M','e','r','o'),
  HB_TAG('P','l','r','d'),
  HB_TAG('S','h','r','d'),
  HB_TAG('S','o','r','a'),
  HB_TAG('T','a','k','r'),
  HB_TAG('B','a','s','s'),
  HB_TAG('A','g','h','b'),
  HB_TAG('D','u','p','l'),
  HB_TAG('E','l','b','a'),
  HB_TAG('G','r','a','n'),
  HB_TAG('K','h','o','j'),
  HB_TAG('S','i','n','d'),
  HB_TAG('L','i','n','a'),
  HB_TAG('M','a','h','j'),
  HB_TAG('M','a','n','i'),
  HB_TAG('M','e','n','d'),
  HB_TAG('M','o','d','i'),
  HB_TAG('M','r','o','o'),
  HB_TAG('N','b','a','t'),
  HB_TAG('N','a','r','b'),
  HB_TAG('P','e','r','m'),
  HB_TAG('H','m','n','g'),
  HB_TAG('P','a','l','m'),
  HB_TAG('P','a','u','c'),
  HB_TAG('P','h','l','p'),
  HB_TAG('S','i','d','d'),
  HB_TAG('T','i','r','h'),
  HB_TAG('W','a','r','a'),
  HB_TAG('A','h','o','m'),
  HB_TAG('H','l','u','w'),
  HB_TAG('H','a','t','r'),
  HB_TAG('M','u','l','t'),
  HB_TAG('H','u','n','g'),
  HB_TAG('S','g','n','w'),
  HB_TAG('Z','m','t','h')
};

static const int16_t sMirrorOffsets[] = {
  0,
  1,
  -1,
  2,
  -2,
  16,
  -16,
  3,
  -3,
  2016,
  138,
  1824,
  2104,
  2108,
  2106,
  -138,
  8,
  7,
  -8,
  -7,
  -1824,
  -2016,
  -2104,
  -2106,
  -2108
};

#ifndef ENABLE_INTL_API
#define kCharProp1MaxPlane  1
#define kCharProp1IndexBits 11
#define kCharProp1CharBits  5
static const uint8_t sCharProp1Planes[1] = {1};

static const uint8_t sCharProp1Pages[2][2048] = {
  {0,1,2,2,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,5,6,7,0,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,9,10,11,0,12,0,13,14,0,0,15,16,17,18,19,0,0,0,0,20,21,22,23,0,0,0,0,24,0,25,26,0,0,25,27,0,0,25,27,0,0,25,27,0,0,25,27,0,0,0,27,0,0,0,28,0,0,25,27,0,0,0,27,0,0,0,29,0,0,30,31,0,0,32,33,0,34,35,0,36,37,0,38,0,0,39,0,0,40,0,0,0,41,41,41,42,42,43,44,44,0,0,0,0,0,0,0,0,0,0,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,0,0,0,47,47,0,0,0,0,48,0,0,0,0,0,0,49,0,0,0,50,0,0,0,0,0,0,51,0,0,52,0,53,0,0,0,54,55,56,0,57,0,58,0,59,0,0,0,0,60,61,0,0,0,0,0,0,62,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,65,66,67,0,68,69,0,0,0,0,0,0,0,0,70,71,72,73,74,75,76,77,78,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,0,0,81,82,0,0,0,0,0,0,0,0,0,0,0,0,83,84,85,86,0,87,0,88,89,90,91,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,0,0,0,94,0,0,0,95,96,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,99,0,0,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,102,0,0,103,0,0,0,0,0,0,0,0,104,0,0,0,0,0,55,105,0,106,107,108,0,109,110,0,0,0,0,0,0,111,112,113,0,0,0,0,0,0,0,27,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,121,122,123,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,126,127,0,0,0,0,1,2,128,129,0,0,0,0},
  {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,0,0,0,0,0,0,0,131,0,0,0,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,133,134,0,0,0,0,0,135,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,94,0,136,0,0,137,138,0,109,0,0,139,0,0,140,0,0,0,0,0,141,0,25,27,142,0,0,0,0,0,0,0,0,0,0,143,0,0,0,0,0,0,94,144,0,0,94,0,0,0,145,0,0,0,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,147,0,148,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,149,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,150,151,152,0,0,0,0,153,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,154,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
};

static const nsCharProps1 sCharProp1Values[155][32] = {
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {3,0,0}, {0,0,0}, {4,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {3,0,0}, {0,0,0}, {4,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {5,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {6,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,232}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,232}, {0,0,216}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220},},
  {{0,0,220}, {0,0,202}, {0,0,202}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,202}, {0,0,202}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,1}, {0,0,1}, {0,0,1}, {0,0,1}, {0,0,1}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,230},},
  {{0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,240}, {0,0,230}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,220}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,230}, {0,0,232}, {0,0,220}, {0,0,220}, {0,0,230}, {0,0,233}, {0,0,234}, {0,0,234}, {0,0,233},},
  {{0,0,234}, {0,0,234}, {0,0,233}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,222}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230},},
  {{0,0,230}, {0,0,230}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,222}, {0,0,228}, {0,0,230}, {0,0,10}, {0,0,11}, {0,0,12}, {0,0,13}, {0,0,14}, {0,0,15}, {0,0,16}, {0,0,17}, {0,0,18}, {0,0,19}, {0,0,19}, {0,0,20}, {0,0,21}, {0,0,22}, {0,0,0}, {0,0,23},},
  {{0,0,0}, {0,0,24}, {0,0,25}, {0,0,0}, {0,0,230}, {0,0,220}, {0,0,0}, {0,0,18}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,30}, {0,0,31}, {0,0,32}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,27}, {0,0,28}, {0,0,29}, {0,0,30}, {0,0,31}, {0,0,32}, {0,0,33}, {0,0,34}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,220},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,35}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,230},},
  {{0,0,230}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,36}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,230}, {0,0,220}, {0,0,220}, {0,0,230}, {0,0,220}, {0,0,230},},
  {{0,0,230}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230},},
  {{0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,27}, {0,0,28}, {0,0,29}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,7}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,84}, {0,0,91}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,103}, {0,0,103}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,107}, {0,0,107}, {0,0,107}, {0,0,107}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,118}, {0,0,118}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,122}, {0,0,122}, {0,0,122}, {0,0,122}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,220}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,220}, {0,0,0}, {0,0,220}, {0,0,0}, {0,0,216}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,129}, {0,0,130}, {0,0,0}, {0,0,132}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,130}, {0,0,130}, {0,0,130}, {0,0,130}, {0,0,0}, {0,0,0},},
  {{0,0,130}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,9}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,7}, {0,0,0}, {0,0,9}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0},},
  {{0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0},},
  {{0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0},},
  {{0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,228}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,222}, {0,0,230}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,220},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,7}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,7}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,7}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,1}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220},},
  {{0,0,230}, {0,0,0}, {0,0,1}, {0,0,1}, {0,0,1}, {0,0,1}, {0,0,1}, {0,0,1}, {0,0,1}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,230}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,234}, {0,0,214}, {0,0,220}, {0,0,202}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230},},
  {{0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,233}, {0,0,220}, {0,0,230}, {0,0,220},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,1}, {0,0,1}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,1}, {0,0,1}, {0,0,1}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,1}, {0,0,1}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,1}, {0,0,1}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {7,0,0}, {7,0,0}, {7,0,0}, {8,0,0}, {8,0,0}, {8,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {9,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {10,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0},},
  {{1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {11,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {12,0,0}, {0,0,0}, {13,0,0}, {14,0,0}, {0,0,0}, {14,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {15,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0},},
  {{1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {16,0,0}, {16,0,0}, {16,0,0}, {0,0,0}, {17,0,0}, {17,0,0}, {0,0,0}, {0,0,0}, {18,0,0}, {18,0,0}, {18,0,0}, {19,0,0}, {19,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {3,0,0}, {0,0,0}, {4,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {7,0,0}, {1,0,0}, {2,0,0}, {8,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {20,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {21,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0},},
  {{2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0},},
  {{2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {22,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {23,0,0}, {24,0,0}, {23,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9},},
  {{0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230},},
  {{0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0},},
  {{1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,218}, {0,0,228}, {0,0,232}, {0,0,222}, {0,0,224}, {0,0,224}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,8}, {0,0,8}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,7}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230},},
  {{0,0,0}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,3,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,3,0}, {0,7,0}, {0,7,0}, {0,7,0},},
  {{0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,3,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0},},
  {{0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,3,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0},},
  {{0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,3,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0},},
  {{0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,3,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0},},
  {{0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,3,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0},},
  {{0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,3,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0},},
  {{0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0},},
  {{0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0},},
  {{0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,26}, {0,0,0},},
  {{0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {3,0,0}, {0,0,0}, {4,0,0}, {0,0,0}, {1,0,0},},
  {{2,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,220}, {0,0,0}, {0,0,0},},
  {{0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,220}, {0,0,0}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,1}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,7}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,7}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,7}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,7}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,9}, {0,0,7}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,7}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,7}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,1}, {0,0,1}, {0,0,1}, {0,0,1}, {0,0,1}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,1}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,216}, {0,0,216}, {0,0,1}, {0,0,1}, {0,0,1}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,226}, {0,0,216}, {0,0,216}, {0,0,216}, {0,0,216}, {0,0,216}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220},},
  {{0,0,220}, {0,0,220}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},}
};

#endif

#define kCharProp2MaxPlane  16
#define kCharProp2IndexBits 11
#define kCharProp2CharBits  5
static const uint8_t sCharProp2Planes[16] = {1,2,3,4,4,4,4,4,4,4,4,4,4,5,6,6};

static const uint16_t sCharProp2Pages[7][2048] = {
  {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,37,37,39,40,41,42,43,44,45,46,47,48,49,50,47,51,52,53,54,55,47,56,57,58,59,60,61,62,63,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,110,114,115,116,117,118,119,120,110,121,122,123,124,125,126,127,128,129,129,130,131,129,129,129,129,132,132,133,132,134,135,136,132,137,132,138,139,140,141,141,142,143,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,145,146,147,147,148,149,150,151,152,153,154,155,156,157,158,159,160,158,161,144,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,110,110,177,178,179,180,181,182,183,184,185,186,187,188,110,110,189,190,191,192,193,194,195,196,197,198,8,8,8,8,199,8,8,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,227,227,227,227,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,241,242,243,243,243,243,243,244,245,246,247,236,236,248,236,249,236,236,236,236,236,250,251,243,252,253,254,254,254,254,254,254,254,254,227,227,227,227,255,227,256,257,258,227,227,259,227,227,260,227,261,262,263,264,265,266,267,268,269,270,271,272,273,273,273,274,275,276,277,278,279,280,280,281,282,283,284,110,285,286,286,287,288,288,288,288,288,288,289,290,291,292,293,294,295,296,297,298,299,300,301,302,303,304,236,305,306,307,308,309,307,310,311,312,313,313,314,315,241,241,316,317,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,319,236,236,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,319,320,321,322,322,322,322,322,322,322,322,322,322,322,322,322,322,322,322,322,322,322,322,322,322,322,322,322,322,322,322,322,322,322,322,322,322,322,323,324,325,326,327,327,327,327,327,327,327,327,328,329,35,330,331,332,332,333,334,335,336,337,338,339,110,340,341,342,343,344,345,346,347,348,349,350,351,352,353,354,355,356,357,358,359,360,361,362,363,364,365,366,367,368,369,369,370,371,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,372,373,374,375,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,376,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,378,378,378,378,378,378,378,378,379,380,378,381,378,378,382,320,383,384,385,386,386,387,388,386,386,386,386,386,386,386,386,386,386,389,390,386,391,386,392,393,394,395,396,397,386,386,386,398,399,400,401,402,403,404,405,406},
  {407,408,409,110,410,410,410,411,412,413,414,415,416,417,418,419,110,110,110,110,420,421,422,423,424,425,426,427,428,429,430,110,431,432,433,434,435,436,110,110,437,438,439,440,110,110,110,110,441,441,441,441,441,441,441,441,441,442,443,444,110,110,110,110,445,446,447,448,449,450,63,451,452,453,63,63,454,455,456,457,458,459,460,461,462,63,463,464,465,466,467,468,469,470,63,63,471,471,472,63,473,474,475,476,63,63,63,63,63,63,63,63,63,63,63,477,63,63,63,63,63,63,63,63,63,63,63,63,478,479,480,481,482,483,484,485,486,487,488,489,490,491,492,493,494,495,110,110,496,497,498,499,500,501,502,503,110,110,110,110,110,110,110,110,504,505,506,110,110,110,110,110,507,508,509,320,510,511,512,110,513,514,515,110,516,517,110,110,110,110,110,110,110,110,110,110,110,518,519,520,110,110,110,110,110,110,110,110,110,110,110,110,110,110,521,522,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,523,523,523,523,523,523,523,523,523,523,523,523,523,523,523,523,523,523,523,523,523,523,523,523,523,523,523,523,524,110,110,110,525,525,525,526,523,523,523,523,523,523,527,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,528,528,528,528,528,528,528,528,528,528,528,528,528,528,528,528,528,528,528,528,528,528,528,528,528,528,528,528,528,528,528,528,528,529,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,530,530,530,530,530,530,530,530,530,530,530,530,530,530,530,530,530,530,531,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,332,332,332,332,332,332,332,332,332,332,332,332,332,332,332,332,332,532,533,534,110,110,535,536,537,538,539,540,541,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,542,542,543,544,545,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,546,320,320,320,320,320,320,320,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,547,547,547,548,549,550,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,551,551,551,551,551,551,551,552,551,553,554,555,556,557,558,559,560,560,561,110,110,110,110,110,236,236,562,563,110,110,110,110,564,565,566,567,568,569,570,571,572,573,574,575,576,564,565,577,567,578,579,580,571,581,582,583,584,585,586,587,588,589,590,591,592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,593,594,593,595,596,597,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,598,598,598,598,598,598,599,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,600,601,602,603,604,605,65,606,63,63,63,63,63,63,63,63,236,607,236,236,608,609,610,611,612,613,614,615,616,320,320,617,618,619,620,320,320,320,320,320,236,236,236,236,236,236,236,621,236,236,236,236,236,236,236,236,236,236,236,622,236,623,236,236,236,236,236,236,236,236,624,625,236,236,236,608,236,236,626,320,627,243,628,243,629,630,110,110,631,110,110,110,632,110,633,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110},
  {318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,634,320,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,635,318,318,318,318,318,318,636,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,318,637,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,378,378,378,378,378,378,378,378,378,378,378,378,378,378,378,378,638,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,639},
  {320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,639},
  {110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110},
  {640,641,641,642,110,110,110,110,643,643,643,643,643,643,643,644,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110},
  {377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,645}
};

static const nsCharProps2 sCharProp2Values[646][32] = {
  {{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,8,8,-1,1},{0,0,0,7,8,-1,1},{0,0,0,8,8,-1,1},{0,0,0,9,8,-1,1},{0,0,0,7,8,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,7,12,-1,1},{0,0,0,7,12,-1,1},{0,0,0,7,12,-1,1},{0,0,0,8,12,-1,1}},
  {{0,0,29,9,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,4,8,-1,1},{0,0,23,4,8,-1,1},{0,0,21,4,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,1,-1,1},{0,0,22,10,8,-1,1},{0,0,18,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,25,3,8,-1,1},{0,0,21,6,8,-1,1},{0,0,17,3,1,-1,1},{0,0,21,6,1,-1,1},{0,0,21,6,8,-1,1},{0,0,13,2,0,0,1},{0,0,13,2,0,1,1},{0,0,13,2,0,2,1},{0,0,13,2,0,3,1},{0,0,13,2,0,4,1},{0,0,13,2,0,5,1},{0,0,13,2,0,6,1},{0,0,13,2,0,7,1},{0,0,13,2,0,8,1},{0,0,13,2,0,9,1},{0,0,21,6,1,-1,1},{0,0,21,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,21,10,8,-1,1}},
  {{0,0,21,10,8,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{0,0,22,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,18,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,16,10,0,-1,1}},
  {{0,0,24,10,8,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{0,0,22,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,18,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,0,18,12,-1,1}},
  {{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,7,8,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1},{0,0,0,18,12,-1,1}},
  {{0,0,29,6,9,-1,1},{0,0,21,10,8,-1,1},{0,0,23,4,8,-1,1},{0,0,23,4,8,-1,1},{0,0,23,4,8,-1,1},{0,0,23,4,8,-1,1},{0,0,26,10,8,-1,1},{0,0,21,10,8,-1,0},{0,0,24,10,9,-1,1},{0,0,26,10,8,-1,0},{25,0,7,0,9,-1,1},{0,0,20,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,1,18,10,-1,1},{0,0,26,10,8,-1,0},{0,0,24,10,9,-1,1},{0,0,26,4,8,-1,1},{0,0,25,4,8,-1,0},{0,0,15,2,9,2,1},{0,0,15,2,9,3,1},{0,0,24,10,9,-1,1},{0,0,5,0,9,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,1,-1,1},{0,0,24,10,9,-1,1},{0,0,15,2,9,1,1},{25,0,7,0,9,-1,1},{0,0,19,10,8,-1,1},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,21,10,8,-1,1}},
  {{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{0,0,25,10,8,-1,0},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1}},
  {{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{0,0,25,10,8,-1,0},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1}},
  {{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1}},
  {{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,9,-1,1},{25,0,5,0,9,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,9,-1,1}},
  {{25,0,5,0,9,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,11,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1}},
  {{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,9,-1,1}},
  {{25,0,5,0,3,-1,1},{25,0,9,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,2,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,9,0,2,-1,1}},
  {{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,7,0,4,-1,1},{25,0,9,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1}},
  {{25,0,7,0,3,-1,1},{25,0,7,0,3,-1,1},{25,0,7,0,3,-1,1},{25,0,7,0,3,-1,1},{25,0,9,0,9,-1,1},{25,0,8,0,9,-1,1},{25,0,5,0,9,-1,1},{25,0,9,0,9,-1,1},{25,0,8,0,9,-1,1},{25,0,5,0,9,-1,1},{25,0,9,0,9,-1,1},{25,0,8,0,9,-1,1},{25,0,5,0,9,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,2,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1}},
  {{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,9,-1,1},{25,0,8,0,9,-1,1},{25,0,5,0,9,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1}},
  {{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1}},
  {{25,0,9,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,5,0,2,-1,1}},
  {{25,0,5,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,2,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,4,-1,1}},
  {{25,0,5,0,2,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,2,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,2,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,2,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,2,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1}},
  {{25,0,5,0,2,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,2,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,2,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,2,-1,1},{25,0,5,0,3,-1,1},{25,0,7,0,2,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,3,-1,1}},
  {{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{0,0,6,10,3,-1,1},{0,0,6,10,3,-1,1},{0,0,6,0,0,-1,1},{0,0,6,0,0,-1,1},{0,0,6,0,3,-1,1},{0,0,6,0,3,-1,1},{0,0,6,0,3,-1,1}},
  {{0,0,6,0,3,-1,1},{0,0,6,0,3,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,6,10,3,-1,1},{0,0,6,10,3,-1,1},{0,0,6,10,3,-1,1},{0,0,6,10,3,-1,1},{0,0,6,10,3,-1,1},{0,0,6,10,3,-1,1},{0,0,6,10,3,-1,1},{0,0,6,10,3,-1,1},{0,0,6,10,3,-1,1},{0,0,6,10,3,-1,1},{0,0,6,0,3,-1,1},{0,0,6,0,3,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,9,-1,1},{0,0,24,10,9,-1,1},{0,0,24,10,9,-1,1},{0,0,24,10,9,-1,1},{0,0,24,10,9,-1,1},{0,0,24,10,9,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1}},
  {{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{5,0,24,10,8,-1,0},{5,0,24,10,8,-1,0},{0,0,6,10,0,-1,1},{0,0,24,10,8,-1,1},{0,0,6,0,3,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1}},
  {{1,0,12,17,0,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,2,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,2,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,2,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1}},
  {{1,0,12,17,3,-1,1},{1,0,12,17,2,-1,1},{1,0,12,17,2,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,2,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,2,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,2,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1}},
  {{1,0,12,17,9,-1,1},{1,0,12,17,9,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,9,-1,1},{1,0,12,17,9,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,2,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1}},
  {{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{14,0,9,0,4,-1,1},{14,0,5,0,4,-1,1},{14,0,9,0,4,-1,1},{14,0,5,0,4,-1,1},{0,0,6,10,9,-1,1},{14,0,24,10,1,-1,1},{14,0,9,0,4,-1,1},{14,0,5,0,4,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{14,0,6,0,9,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{0,0,21,10,9,-1,1},{14,0,9,0,4,-1,1}},
  {{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{14,0,24,10,9,-1,1},{0,0,24,10,9,-1,1},{14,0,9,0,0,-1,1},{0,0,21,10,9,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{61,0,2,0,12,-1,1},{14,0,9,0,0,-1,1},{61,0,2,0,12,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1}},
  {{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{61,0,2,0,12,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1}},
  {{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,9,0,3,-1,1},{14,0,5,0,9,-1,1},{14,0,5,0,9,-1,1},{14,0,9,0,9,-1,1},{14,0,9,0,9,-1,1},{14,0,9,0,9,-1,1},{14,0,5,0,9,-1,1},{14,0,5,0,9,-1,1},{14,0,5,0,3,-1,1},{14,0,9,0,4,-1,1},{14,0,5,0,4,-1,1},{14,0,9,0,4,-1,1},{14,0,5,0,4,-1,1},{14,0,9,0,4,-1,1},{14,0,5,0,4,-1,1},{14,0,9,0,4,-1,1},{14,0,5,0,4,-1,1}},
  {{14,0,9,0,4,-1,1},{14,0,5,0,4,-1,1},{7,0,9,0,7,-1,1},{7,0,5,0,7,-1,1},{7,0,9,0,7,-1,1},{7,0,5,0,7,-1,1},{7,0,9,0,7,-1,1},{7,0,5,0,7,-1,1},{7,0,9,0,7,-1,1},{7,0,5,0,7,-1,1},{7,0,9,0,7,-1,1},{7,0,5,0,7,-1,1},{7,0,9,0,7,-1,1},{7,0,5,0,7,-1,1},{7,0,9,0,7,-1,1},{7,0,5,0,7,-1,1},{14,0,5,0,9,-1,1},{14,0,5,0,9,-1,1},{14,0,5,0,9,-1,1},{14,0,5,0,4,-1,1},{14,0,9,0,9,-1,1},{14,0,5,0,9,-1,1},{14,0,25,10,8,-1,1},{14,0,9,0,4,-1,1},{14,0,5,0,4,-1,1},{14,0,9,0,9,-1,1},{14,0,9,0,4,-1,1},{14,0,5,0,4,-1,1},{14,0,5,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1}},
  {{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1}},
  {{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1}},
  {{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1}},
  {{8,0,9,0,4,-1,1},{8,0,5,0,4,-1,1},{8,0,9,0,4,-1,1},{8,0,5,0,4,-1,1},{8,0,9,0,4,-1,1},{8,0,5,0,4,-1,1},{8,0,9,0,4,-1,1},{8,0,5,0,4,-1,1},{8,0,9,0,4,-1,1},{8,0,5,0,4,-1,1},{8,0,9,0,4,-1,1},{8,0,5,0,4,-1,1},{8,0,9,0,4,-1,1},{8,0,5,0,4,-1,1},{8,0,9,0,4,-1,1},{8,0,5,0,4,-1,1},{8,0,9,0,4,-1,1},{8,0,5,0,4,-1,1},{8,0,9,0,4,-1,1},{8,0,5,0,4,-1,1},{8,0,9,0,4,-1,1},{8,0,5,0,4,-1,1},{8,0,9,0,4,-1,1},{8,0,5,0,4,-1,1},{8,0,9,0,4,-1,1},{8,0,5,0,4,-1,1},{8,0,9,0,4,-1,1},{8,0,5,0,4,-1,1},{8,0,9,0,4,-1,1},{8,0,5,0,4,-1,1},{8,0,9,0,4,-1,1},{8,0,5,0,4,-1,1}},
  {{8,0,9,0,4,-1,1},{8,0,5,0,4,-1,1},{8,0,26,0,8,-1,1},{8,0,12,17,4,-1,1},{8,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{8,0,12,17,4,-1,1},{8,0,11,17,8,-1,1},{8,0,11,17,8,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1}},
  {{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1}},
  {{8,0,9,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1}},
  {{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,4,-1,1},{8,0,5,0,4,-1,1},{8,0,9,0,4,-1,1},{8,0,5,0,4,-1,1},{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{61,0,2,0,12,-1,1},{3,0,9,0,0,-1,1},{3,0,9,0,0,-1,1},{3,0,9,0,0,-1,1},{3,0,9,0,0,-1,1},{3,0,9,0,0,-1,1},{3,0,9,0,0,-1,1},{3,0,9,0,0,-1,1},{3,0,9,0,0,-1,1},{3,0,9,0,0,-1,1},{3,0,9,0,0,-1,1},{3,0,9,0,0,-1,1},{3,0,9,0,0,-1,1},{3,0,9,0,0,-1,1},{3,0,9,0,0,-1,1},{3,0,9,0,0,-1,1}},
  {{3,0,9,0,0,-1,1},{3,0,9,0,0,-1,1},{3,0,9,0,0,-1,1},{3,0,9,0,0,-1,1},{3,0,9,0,0,-1,1},{3,0,9,0,0,-1,1},{3,0,9,0,0,-1,1},{3,0,9,0,0,-1,1},{3,0,9,0,0,-1,1},{3,0,9,0,0,-1,1},{3,0,9,0,0,-1,1},{3,0,9,0,0,-1,1},{3,0,9,0,0,-1,1},{3,0,9,0,0,-1,1},{3,0,9,0,0,-1,1},{3,0,9,0,0,-1,1},{3,0,9,0,0,-1,1},{3,0,9,0,0,-1,1},{3,0,9,0,0,-1,1},{3,0,9,0,0,-1,1},{3,0,9,0,0,-1,1},{3,0,9,0,0,-1,1},{3,0,9,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{3,0,6,0,0,-1,1},{3,0,21,0,8,-1,1},{3,0,21,0,8,-1,1},{3,0,21,0,8,-1,1},{3,0,21,0,8,-1,1},{3,0,21,0,8,-1,1},{3,0,21,0,8,-1,1}},
  {{61,0,2,0,12,-1,1},{3,0,5,0,0,-1,1},{3,0,5,0,0,-1,1},{3,0,5,0,0,-1,1},{3,0,5,0,0,-1,1},{3,0,5,0,0,-1,1},{3,0,5,0,0,-1,1},{3,0,5,0,0,-1,1},{3,0,5,0,0,-1,1},{3,0,5,0,0,-1,1},{3,0,5,0,0,-1,1},{3,0,5,0,0,-1,1},{3,0,5,0,0,-1,1},{3,0,5,0,0,-1,1},{3,0,5,0,0,-1,1},{3,0,5,0,0,-1,1},{3,0,5,0,0,-1,1},{3,0,5,0,0,-1,1},{3,0,5,0,0,-1,1},{3,0,5,0,0,-1,1},{3,0,5,0,0,-1,1},{3,0,5,0,0,-1,1},{3,0,5,0,0,-1,1},{3,0,5,0,0,-1,1},{3,0,5,0,0,-1,1},{3,0,5,0,0,-1,1},{3,0,5,0,0,-1,1},{3,0,5,0,0,-1,1},{3,0,5,0,0,-1,1},{3,0,5,0,0,-1,1},{3,0,5,0,0,-1,1},{3,0,5,0,0,-1,1}},
  {{3,0,5,0,0,-1,1},{3,0,5,0,0,-1,1},{3,0,5,0,0,-1,1},{3,0,5,0,0,-1,1},{3,0,5,0,0,-1,1},{3,0,5,0,0,-1,1},{3,0,5,0,0,-1,1},{3,0,5,0,9,-1,1},{61,0,2,0,12,-1,1},{0,0,21,0,8,-1,1},{3,0,17,10,1,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{3,0,26,10,8,-1,1},{3,0,26,10,8,-1,1},{3,0,23,4,8,-1,1},{61,0,2,1,12,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1}},
  {{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,4,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,0,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1},{19,0,17,1,8,-1,1},{19,0,12,17,2,-1,1}},
  {{19,0,21,1,8,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,2,-1,1},{19,0,21,1,8,-1,1},{19,0,12,17,2,-1,1},{19,0,12,17,4,-1,1},{19,0,21,1,8,-1,1},{19,0,12,17,4,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{19,0,7,1,0,-1,1},{19,0,7,1,0,-1,1},{19,0,7,1,0,-1,1},{19,0,7,1,0,-1,1},{19,0,7,1,0,-1,1},{19,0,7,1,0,-1,1},{19,0,7,1,0,-1,1},{19,0,7,1,0,-1,1},{19,0,7,1,0,-1,1},{19,0,7,1,0,-1,1},{19,0,7,1,0,-1,1},{19,0,7,1,0,-1,1},{19,0,7,1,0,-1,1},{19,0,7,1,0,-1,1},{19,0,7,1,0,-1,1},{19,0,7,1,0,-1,1}},
  {{19,0,7,1,0,-1,1},{19,0,7,1,0,-1,1},{19,0,7,1,0,-1,1},{19,0,7,1,0,-1,1},{19,0,7,1,0,-1,1},{19,0,7,1,0,-1,1},{19,0,7,1,0,-1,1},{19,0,7,1,0,-1,1},{19,0,7,1,0,-1,1},{19,0,7,1,0,-1,1},{19,0,7,1,0,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{19,0,7,1,0,-1,1},{19,0,7,1,0,-1,1},{19,0,7,1,0,-1,1},{19,0,21,1,1,-1,1},{19,0,21,1,1,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1}},
  {{2,0,1,5,8,-1,1},{2,0,1,5,8,-1,1},{2,0,1,5,8,-1,1},{2,0,1,5,8,-1,1},{2,0,1,5,8,-1,1},{0,0,1,5,8,-1,1},{2,0,25,10,8,-1,1},{2,0,25,10,8,-1,1},{2,0,25,13,8,-1,1},{2,0,21,4,8,-1,1},{2,0,21,4,8,-1,1},{2,0,23,13,8,-1,1},{0,0,21,6,8,-1,1},{2,0,21,13,8,-1,1},{2,0,26,10,8,-1,1},{2,0,26,10,8,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{0,0,21,13,8,-1,1},{0,0,1,13,10,-1,1},{61,0,2,13,12,-1,1},{2,0,21,13,8,-1,1},{0,0,21,13,8,-1,1}},
  {{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1}},
  {{0,0,6,13,7,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,0,-1,1},{1,0,12,17,0,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1}},
  {{2,0,13,5,0,0,1},{2,0,13,5,0,1,1},{2,0,13,5,0,2,1},{2,0,13,5,0,3,1},{2,0,13,5,0,4,1},{2,0,13,5,0,5,1},{2,0,13,5,0,6,1},{2,0,13,5,0,7,1},{2,0,13,5,0,8,1},{2,0,13,5,0,9,1},{2,0,21,4,8,-1,1},{2,0,21,5,8,-1,1},{2,0,21,5,8,-1,1},{2,0,21,13,8,-1,1},{2,0,7,13,4,-1,1},{2,0,7,13,4,-1,1},{1,0,12,17,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,11,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1}},
  {{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,4,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1}},
  {{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,21,13,8,-1,1},{2,0,7,13,0,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{0,0,1,5,8,-1,1},{2,0,26,10,8,-1,1},{2,0,12,17,2,-1,1}},
  {{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,6,13,0,-1,1},{2,0,6,13,0,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,26,10,8,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,13,2,0,0,1},{2,0,13,2,0,1,1},{2,0,13,2,0,2,1},{2,0,13,2,0,3,1},{2,0,13,2,0,4,1},{2,0,13,2,0,5,1},{2,0,13,2,0,6,1},{2,0,13,2,0,7,1},{2,0,13,2,0,8,1},{2,0,13,2,0,9,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,26,13,1,-1,1},{2,0,26,13,1,-1,1},{2,0,7,13,0,-1,1}},
  {{34,0,21,13,8,-1,1},{34,0,21,13,8,-1,1},{34,0,21,13,8,-1,1},{34,0,21,13,8,-1,1},{34,0,21,13,8,-1,1},{34,0,21,13,8,-1,1},{34,0,21,13,8,-1,1},{34,0,21,13,8,-1,1},{34,0,21,13,8,-1,1},{34,0,21,13,8,-1,1},{34,0,21,13,8,-1,1},{34,0,21,13,8,-1,1},{34,0,21,13,8,-1,1},{34,0,21,13,8,-1,1},{61,0,2,13,12,-1,1},{34,0,1,13,8,-1,1},{34,0,7,13,6,-1,1},{34,0,12,17,6,-1,1},{34,0,7,13,6,-1,1},{34,0,7,13,6,-1,1},{34,0,7,13,6,-1,1},{34,0,7,13,6,-1,1},{34,0,7,13,6,-1,1},{34,0,7,13,6,-1,1},{34,0,7,13,6,-1,1},{34,0,7,13,6,-1,1},{34,0,7,13,6,-1,1},{34,0,7,13,6,-1,1},{34,0,7,13,6,-1,1},{34,0,7,13,6,-1,1},{34,0,7,13,6,-1,1},{34,0,7,13,6,-1,1}},
  {{34,0,7,13,6,-1,1},{34,0,7,13,6,-1,1},{34,0,7,13,6,-1,1},{34,0,7,13,6,-1,1},{34,0,7,13,6,-1,1},{34,0,7,13,6,-1,1},{34,0,7,13,6,-1,1},{34,0,7,13,6,-1,1},{34,0,7,13,6,-1,1},{34,0,7,13,6,-1,1},{34,0,7,13,6,-1,1},{34,0,7,13,6,-1,1},{34,0,7,13,6,-1,1},{34,0,7,13,6,-1,1},{34,0,7,13,6,-1,1},{34,0,7,13,6,-1,1},{34,0,12,17,6,-1,1},{34,0,12,17,6,-1,1},{34,0,12,17,6,-1,1},{34,0,12,17,6,-1,1},{34,0,12,17,6,-1,1},{34,0,12,17,6,-1,1},{34,0,12,17,6,-1,1},{34,0,12,17,6,-1,1},{34,0,12,17,6,-1,1},{34,0,12,17,6,-1,1},{34,0,12,17,6,-1,1},{34,0,12,17,6,-1,1},{34,0,12,17,6,-1,1},{34,0,12,17,6,-1,1},{34,0,12,17,6,-1,1},{34,0,12,17,6,-1,1}},
  {{34,0,12,17,6,-1,1},{34,0,12,17,6,-1,1},{34,0,12,17,6,-1,1},{34,0,12,17,6,-1,1},{34,0,12,17,6,-1,1},{34,0,12,17,6,-1,1},{34,0,12,17,6,-1,1},{34,0,12,17,6,-1,1},{34,0,12,17,6,-1,1},{34,0,12,17,6,-1,1},{34,0,12,17,6,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{34,0,7,13,6,-1,1},{34,0,7,13,6,-1,1},{34,0,7,13,6,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1}},
  {{37,0,7,13,0,-1,1},{37,0,7,13,0,-1,1},{37,0,7,13,0,-1,1},{37,0,7,13,0,-1,1},{37,0,7,13,0,-1,1},{37,0,7,13,0,-1,1},{37,0,7,13,0,-1,1},{37,0,7,13,0,-1,1},{37,0,7,13,0,-1,1},{37,0,7,13,0,-1,1},{37,0,7,13,0,-1,1},{37,0,7,13,0,-1,1},{37,0,7,13,0,-1,1},{37,0,7,13,0,-1,1},{37,0,7,13,0,-1,1},{37,0,7,13,0,-1,1},{37,0,7,13,0,-1,1},{37,0,7,13,0,-1,1},{37,0,7,13,0,-1,1},{37,0,7,13,0,-1,1},{37,0,7,13,0,-1,1},{37,0,7,13,0,-1,1},{37,0,7,13,0,-1,1},{37,0,7,13,0,-1,1},{37,0,7,13,0,-1,1},{37,0,7,13,0,-1,1},{37,0,7,13,0,-1,1},{37,0,7,13,0,-1,1},{37,0,7,13,0,-1,1},{37,0,7,13,0,-1,1},{37,0,7,13,0,-1,1},{37,0,7,13,0,-1,1}},
  {{37,0,7,13,0,-1,1},{37,0,7,13,0,-1,1},{37,0,7,13,0,-1,1},{37,0,7,13,0,-1,1},{37,0,7,13,0,-1,1},{37,0,7,13,0,-1,1},{37,0,12,17,0,-1,1},{37,0,12,17,0,-1,1},{37,0,12,17,0,-1,1},{37,0,12,17,0,-1,1},{37,0,12,17,0,-1,1},{37,0,12,17,0,-1,1},{37,0,12,17,0,-1,1},{37,0,12,17,0,-1,1},{37,0,12,17,0,-1,1},{37,0,12,17,0,-1,1},{37,0,12,17,0,-1,1},{37,0,7,13,0,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1}},
  {{66,0,13,1,6,0,1},{66,0,13,1,6,1,1},{66,0,13,1,6,2,1},{66,0,13,1,6,3,1},{66,0,13,1,6,4,1},{66,0,13,1,6,5,1},{66,0,13,1,6,6,1},{66,0,13,1,6,7,1},{66,0,13,1,6,8,1},{66,0,13,1,6,9,1},{66,0,7,1,6,-1,1},{66,0,7,1,6,-1,1},{66,0,7,1,6,-1,1},{66,0,7,1,6,-1,1},{66,0,7,1,6,-1,1},{66,0,7,1,6,-1,1},{66,0,7,1,6,-1,1},{66,0,7,1,6,-1,1},{66,0,7,1,6,-1,1},{66,0,7,1,6,-1,1},{66,0,7,1,6,-1,1},{66,0,7,1,6,-1,1},{66,0,7,1,6,-1,1},{66,0,7,1,6,-1,1},{66,0,7,1,6,-1,1},{66,0,7,1,6,-1,1},{66,0,7,1,6,-1,1},{66,0,7,1,6,-1,1},{66,0,7,1,6,-1,1},{66,0,7,1,6,-1,1},{66,0,7,1,6,-1,1},{66,0,7,1,6,-1,1}},
  {{66,0,7,1,6,-1,1},{66,0,7,1,6,-1,1},{66,0,7,1,6,-1,1},{66,0,7,1,6,-1,1},{66,0,7,1,6,-1,1},{66,0,7,1,6,-1,1},{66,0,7,1,6,-1,1},{66,0,7,1,6,-1,1},{66,0,7,1,6,-1,1},{66,0,7,1,6,-1,1},{66,0,7,1,6,-1,1},{66,0,12,17,6,-1,1},{66,0,12,17,6,-1,1},{66,0,12,17,6,-1,1},{66,0,12,17,6,-1,1},{66,0,12,17,6,-1,1},{66,0,12,17,6,-1,1},{66,0,12,17,6,-1,1},{66,0,12,17,6,-1,1},{66,0,12,17,6,-1,1},{66,0,6,1,6,-1,1},{66,0,6,1,6,-1,1},{66,0,26,10,8,-1,1},{66,0,21,10,8,-1,1},{66,0,21,10,8,-1,1},{66,0,21,10,8,-1,1},{66,0,6,1,7,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1}},
  {{90,0,7,1,7,-1,1},{90,0,7,1,7,-1,1},{90,0,7,1,7,-1,1},{90,0,7,1,7,-1,1},{90,0,7,1,7,-1,1},{90,0,7,1,7,-1,1},{90,0,7,1,7,-1,1},{90,0,7,1,7,-1,1},{90,0,7,1,7,-1,1},{90,0,7,1,7,-1,1},{90,0,7,1,7,-1,1},{90,0,7,1,7,-1,1},{90,0,7,1,7,-1,1},{90,0,7,1,7,-1,1},{90,0,7,1,7,-1,1},{90,0,7,1,7,-1,1},{90,0,7,1,7,-1,1},{90,0,7,1,7,-1,1},{90,0,7,1,7,-1,1},{90,0,7,1,7,-1,1},{90,0,7,1,7,-1,1},{90,0,7,1,7,-1,1},{90,0,12,17,7,-1,1},{90,0,12,17,7,-1,1},{90,0,12,17,7,-1,1},{90,0,12,17,7,-1,1},{90,0,6,1,7,-1,1},{90,0,12,17,7,-1,1},{90,0,12,17,7,-1,1},{90,0,12,17,7,-1,1},{90,0,12,17,7,-1,1},{90,0,12,17,7,-1,1}},
  {{90,0,12,17,7,-1,1},{90,0,12,17,7,-1,1},{90,0,12,17,7,-1,1},{90,0,12,17,7,-1,1},{90,0,6,1,7,-1,1},{90,0,12,17,7,-1,1},{90,0,12,17,7,-1,1},{90,0,12,17,7,-1,1},{90,0,6,1,7,-1,1},{90,0,12,17,7,-1,1},{90,0,12,17,7,-1,1},{90,0,12,17,7,-1,1},{90,0,12,17,7,-1,1},{90,0,12,17,7,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{90,0,21,1,8,-1,1},{90,0,21,1,8,-1,1},{90,0,21,1,8,-1,1},{90,0,21,1,8,-1,1},{90,0,21,1,8,-1,1},{90,0,21,1,8,-1,1},{90,0,21,1,8,-1,1},{90,0,21,1,8,-1,1},{90,0,21,1,8,-1,1},{90,0,21,1,8,-1,1},{90,0,21,1,8,-1,1},{90,0,21,1,8,-1,1},{90,0,21,1,8,-1,1},{90,0,21,1,8,-1,1},{90,0,21,1,8,-1,1},{61,0,2,1,12,-1,1}},
  {{95,0,7,1,6,-1,1},{95,0,7,1,6,-1,1},{95,0,7,1,6,-1,1},{95,0,7,1,6,-1,1},{95,0,7,1,6,-1,1},{95,0,7,1,6,-1,1},{95,0,7,1,6,-1,1},{95,0,7,1,6,-1,1},{95,0,7,1,6,-1,1},{95,0,7,1,6,-1,1},{95,0,7,1,6,-1,1},{95,0,7,1,6,-1,1},{95,0,7,1,6,-1,1},{95,0,7,1,6,-1,1},{95,0,7,1,6,-1,1},{95,0,7,1,6,-1,1},{95,0,7,1,6,-1,1},{95,0,7,1,6,-1,1},{95,0,7,1,6,-1,1},{95,0,7,1,6,-1,1},{95,0,7,1,6,-1,1},{95,0,7,1,6,-1,1},{95,0,7,1,6,-1,1},{95,0,7,1,6,-1,1},{95,0,7,1,6,-1,1},{95,0,12,17,6,-1,1},{95,0,12,17,6,-1,1},{95,0,12,17,6,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{95,0,21,1,8,-1,1},{61,0,2,1,12,-1,1}},
  {{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1}},
  {{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,4,-1,1},{2,0,7,13,4,-1,1},{2,0,7,13,4,-1,1},{2,0,7,13,4,-1,1},{2,0,7,13,4,-1,1},{2,0,7,13,0,-1,1},{2,0,7,13,2,-1,1},{2,0,7,13,2,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1}},
  {{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1}},
  {{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1},{2,0,12,17,2,-1,1}},
  {{10,0,12,17,2,-1,1},{10,0,12,17,0,-1,1},{10,0,12,17,0,-1,1},{10,0,10,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1}},
  {{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,12,17,0,-1,1},{10,0,10,0,0,-1,1},{10,0,12,17,0,-1,1},{10,0,7,0,0,-1,1},{10,0,10,0,0,-1,1},{10,0,10,0,0,-1,1}},
  {{10,0,10,0,0,-1,1},{10,0,12,17,0,-1,1},{10,0,12,17,0,-1,1},{10,0,12,17,0,-1,1},{10,0,12,17,0,-1,1},{10,0,12,17,0,-1,1},{10,0,12,17,0,-1,1},{10,0,12,17,0,-1,1},{10,0,12,17,0,-1,1},{10,0,10,0,0,-1,1},{10,0,10,0,0,-1,1},{10,0,10,0,0,-1,1},{10,0,10,0,0,-1,1},{10,0,12,17,0,-1,1},{10,0,10,0,4,-1,1},{10,0,10,0,0,-1,1},{10,0,7,0,0,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{10,0,12,17,3,-1,1},{10,0,12,17,3,-1,1},{10,0,12,17,2,-1,1},{10,0,12,17,0,-1,1},{10,0,12,17,0,-1,1},{10,0,7,0,9,-1,1},{10,0,7,0,9,-1,1},{10,0,7,0,9,-1,1},{10,0,7,0,9,-1,1},{10,0,7,0,9,-1,1},{10,0,7,0,9,-1,1},{10,0,7,0,9,-1,1},{10,0,7,0,9,-1,1}},
  {{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,12,17,0,-1,1},{10,0,12,17,0,-1,1},{0,0,21,0,8,-1,1},{0,0,21,0,8,-1,1},{10,0,13,0,0,0,1},{10,0,13,0,0,1,1},{10,0,13,0,0,2,1},{10,0,13,0,0,3,1},{10,0,13,0,0,4,1},{10,0,13,0,0,5,1},{10,0,13,0,0,6,1},{10,0,13,0,0,7,1},{10,0,13,0,0,8,1},{10,0,13,0,0,9,1},{10,0,21,0,8,-1,1},{10,0,6,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,4,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1},{10,0,7,0,0,-1,1}},
  {{4,0,7,0,4,-1,1},{4,0,12,17,0,-1,1},{4,0,10,0,0,-1,1},{4,0,10,0,0,-1,1},{61,0,2,0,12,-1,1},{4,0,7,0,0,-1,1},{4,0,7,0,0,-1,1},{4,0,7,0,0,-1,1},{4,0,7,0,0,-1,1},{4,0,7,0,0,-1,1},{4,0,7,0,0,-1,1},{4,0,7,0,0,-1,1},{4,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{4,0,7,0,0,-1,1},{4,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{4,0,7,0,0,-1,1},{4,0,7,0,0,-1,1},{4,0,7,0,0,-1,1},{4,0,7,0,0,-1,1},{4,0,7,0,0,-1,1},{4,0,7,0,0,-1,1},{4,0,7,0,0,-1,1},{4,0,7,0,0,-1,1},{4,0,7,0,0,-1,1},{4,0,7,0,0,-1,1},{4,0,7,0,0,-1,1},{4,0,7,0,0,-1,1},{4,0,7,0,0,-1,1}},
  {{4,0,7,0,0,-1,1},{4,0,7,0,0,-1,1},{4,0,7,0,0,-1,1},{4,0,7,0,0,-1,1},{4,0,7,0,0,-1,1},{4,0,7,0,0,-1,1},{4,0,7,0,0,-1,1},{4,0,7,0,0,-1,1},{4,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{4,0,7,0,0,-1,1},{4,0,7,0,0,-1,1},{4,0,7,0,0,-1,1},{4,0,7,0,0,-1,1},{4,0,7,0,0,-1,1},{4,0,7,0,0,-1,1},{4,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{4,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{4,0,7,0,0,-1,1},{4,0,7,0,0,-1,1},{4,0,7,0,0,-1,1},{4,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{4,0,12,17,0,-1,1},{4,0,7,0,0,-1,1},{4,0,10,0,0,-1,1},{4,0,10,0,0,-1,1}},
  {{4,0,10,0,0,-1,1},{4,0,12,17,0,-1,1},{4,0,12,17,0,-1,1},{4,0,12,17,0,-1,1},{4,0,12,17,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{4,0,10,0,0,-1,1},{4,0,10,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{4,0,10,0,0,-1,1},{4,0,10,0,0,-1,1},{4,0,12,17,0,-1,1},{4,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{4,0,10,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{4,0,7,0,9,-1,1},{4,0,7,0,9,-1,1},{61,0,2,0,12,-1,1},{4,0,7,0,9,-1,1}},
  {{4,0,7,0,0,-1,1},{4,0,7,0,0,-1,1},{4,0,12,17,0,-1,1},{4,0,12,17,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{4,0,13,0,0,0,1},{4,0,13,0,0,1,1},{4,0,13,0,0,2,1},{4,0,13,0,0,3,1},{4,0,13,0,0,4,1},{4,0,13,0,0,5,1},{4,0,13,0,0,6,1},{4,0,13,0,0,7,1},{4,0,13,0,0,8,1},{4,0,13,0,0,9,1},{4,0,7,0,0,-1,1},{4,0,7,0,0,-1,1},{4,0,23,4,8,-1,1},{4,0,23,4,8,-1,1},{4,0,15,0,8,-1,1},{4,0,15,0,8,-1,1},{4,0,15,0,8,-1,1},{4,0,15,0,8,-1,1},{4,0,15,0,8,-1,1},{4,0,15,0,8,-1,1},{4,0,26,0,8,-1,1},{4,0,23,4,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{61,0,2,0,12,-1,1},{16,0,12,17,0,-1,1},{16,0,12,17,0,-1,1},{16,0,10,0,0,-1,1},{61,0,2,0,12,-1,1},{16,0,7,0,0,-1,1},{16,0,7,0,0,-1,1},{16,0,7,0,0,-1,1},{16,0,7,0,0,-1,1},{16,0,7,0,0,-1,1},{16,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{16,0,7,0,0,-1,1},{16,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{16,0,7,0,0,-1,1},{16,0,7,0,0,-1,1},{16,0,7,0,0,-1,1},{16,0,7,0,0,-1,1},{16,0,7,0,0,-1,1},{16,0,7,0,0,-1,1},{16,0,7,0,0,-1,1},{16,0,7,0,0,-1,1},{16,0,7,0,0,-1,1},{16,0,7,0,0,-1,1},{16,0,7,0,0,-1,1},{16,0,7,0,0,-1,1},{16,0,7,0,0,-1,1}},
  {{16,0,7,0,0,-1,1},{16,0,7,0,0,-1,1},{16,0,7,0,0,-1,1},{16,0,7,0,0,-1,1},{16,0,7,0,0,-1,1},{16,0,7,0,0,-1,1},{16,0,7,0,0,-1,1},{16,0,7,0,0,-1,1},{16,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{16,0,7,0,0,-1,1},{16,0,7,0,0,-1,1},{16,0,7,0,0,-1,1},{16,0,7,0,0,-1,1},{16,0,7,0,0,-1,1},{16,0,7,0,0,-1,1},{16,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{16,0,7,0,0,-1,1},{16,0,7,0,9,-1,1},{61,0,2,0,12,-1,1},{16,0,7,0,0,-1,1},{16,0,7,0,9,-1,1},{61,0,2,0,12,-1,1},{16,0,7,0,0,-1,1},{16,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{16,0,12,17,0,-1,1},{61,0,2,0,12,-1,1},{16,0,10,0,0,-1,1},{16,0,10,0,0,-1,1}},
  {{16,0,10,0,0,-1,1},{16,0,12,17,0,-1,1},{16,0,12,17,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{16,0,12,17,0,-1,1},{16,0,12,17,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{16,0,12,17,0,-1,1},{16,0,12,17,0,-1,1},{16,0,12,17,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{16,0,12,17,2,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{16,0,7,0,9,-1,1},{16,0,7,0,9,-1,1},{16,0,7,0,9,-1,1},{16,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{16,0,7,0,9,-1,1},{61,0,2,0,12,-1,1}},
  {{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{16,0,13,0,0,0,1},{16,0,13,0,0,1,1},{16,0,13,0,0,2,1},{16,0,13,0,0,3,1},{16,0,13,0,0,4,1},{16,0,13,0,0,5,1},{16,0,13,0,0,6,1},{16,0,13,0,0,7,1},{16,0,13,0,0,8,1},{16,0,13,0,0,9,1},{16,0,12,17,0,-1,1},{16,0,12,17,0,-1,1},{16,0,7,0,0,-1,1},{16,0,7,0,0,-1,1},{16,0,7,0,0,-1,1},{16,0,12,17,2,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{61,0,2,0,12,-1,1},{15,0,12,17,0,-1,1},{15,0,12,17,0,-1,1},{15,0,10,0,0,-1,1},{61,0,2,0,12,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1}},
  {{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{15,0,12,17,0,-1,1},{15,0,7,0,0,-1,1},{15,0,10,0,0,-1,1},{15,0,10,0,0,-1,1}},
  {{15,0,10,0,0,-1,1},{15,0,12,17,0,-1,1},{15,0,12,17,0,-1,1},{15,0,12,17,0,-1,1},{15,0,12,17,0,-1,1},{15,0,12,17,0,-1,1},{61,0,2,0,12,-1,1},{15,0,12,17,0,-1,1},{15,0,12,17,0,-1,1},{15,0,10,0,0,-1,1},{61,0,2,0,12,-1,1},{15,0,10,0,0,-1,1},{15,0,10,0,0,-1,1},{15,0,12,17,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{15,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{15,0,7,0,0,-1,1},{15,0,7,0,0,-1,1},{15,0,12,17,0,-1,1},{15,0,12,17,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{15,0,13,0,0,0,1},{15,0,13,0,0,1,1},{15,0,13,0,0,2,1},{15,0,13,0,0,3,1},{15,0,13,0,0,4,1},{15,0,13,0,0,5,1},{15,0,13,0,0,6,1},{15,0,13,0,0,7,1},{15,0,13,0,0,8,1},{15,0,13,0,0,9,1},{15,0,21,0,8,-1,1},{15,0,23,4,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{15,0,7,0,2,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{61,0,2,0,12,-1,1},{31,0,12,17,0,-1,1},{31,0,10,0,0,-1,1},{31,0,10,0,0,-1,1},{61,0,2,0,12,-1,1},{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1}},
  {{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{31,0,12,17,0,-1,1},{31,0,7,0,0,-1,1},{31,0,10,0,0,-1,1},{31,0,12,17,0,-1,1}},
  {{31,0,10,0,0,-1,1},{31,0,12,17,0,-1,1},{31,0,12,17,0,-1,1},{31,0,12,17,0,-1,1},{31,0,12,17,2,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{31,0,10,0,0,-1,1},{31,0,10,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{31,0,10,0,0,-1,1},{31,0,10,0,0,-1,1},{31,0,12,17,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{31,0,12,17,0,-1,1},{31,0,10,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{31,0,7,0,9,-1,1},{31,0,7,0,9,-1,1},{61,0,2,0,12,-1,1},{31,0,7,0,0,-1,1}},
  {{31,0,7,0,0,-1,1},{31,0,7,0,0,-1,1},{31,0,12,17,2,-1,1},{31,0,12,17,2,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{31,0,13,0,0,0,1},{31,0,13,0,0,1,1},{31,0,13,0,0,2,1},{31,0,13,0,0,3,1},{31,0,13,0,0,4,1},{31,0,13,0,0,5,1},{31,0,13,0,0,6,1},{31,0,13,0,0,7,1},{31,0,13,0,0,8,1},{31,0,13,0,0,9,1},{31,0,26,0,8,-1,1},{31,0,7,0,0,-1,1},{31,0,15,0,8,-1,1},{31,0,15,0,8,-1,1},{31,0,15,0,8,-1,1},{31,0,15,0,8,-1,1},{31,0,15,0,8,-1,1},{31,0,15,0,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{35,0,12,17,0,-1,1},{35,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{35,0,7,0,0,-1,1},{35,0,7,0,0,-1,1},{35,0,7,0,0,-1,1},{35,0,7,0,0,-1,1},{35,0,7,0,0,-1,1},{35,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{35,0,7,0,0,-1,1},{35,0,7,0,0,-1,1},{35,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{35,0,7,0,0,-1,1},{35,0,7,0,0,-1,1},{35,0,7,0,0,-1,1},{35,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{35,0,7,0,0,-1,1},{35,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{35,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{35,0,7,0,0,-1,1},{35,0,7,0,0,-1,1}},
  {{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{35,0,7,0,0,-1,1},{35,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{35,0,7,0,0,-1,1},{35,0,7,0,0,-1,1},{35,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{35,0,7,0,0,-1,1},{35,0,7,0,0,-1,1},{35,0,7,0,0,-1,1},{35,0,7,0,0,-1,1},{35,0,7,0,0,-1,1},{35,0,7,0,0,-1,1},{35,0,7,0,0,-1,1},{35,0,7,0,0,-1,1},{35,0,7,0,0,-1,1},{35,0,7,0,0,-1,1},{35,0,7,0,0,-1,1},{35,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{35,0,10,0,0,-1,1},{35,0,10,0,0,-1,1}},
  {{35,0,12,17,0,-1,1},{35,0,10,0,0,-1,1},{35,0,10,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{35,0,10,0,0,-1,1},{35,0,10,0,0,-1,1},{35,0,10,0,0,-1,1},{61,0,2,0,12,-1,1},{35,0,10,0,0,-1,1},{35,0,10,0,0,-1,1},{35,0,10,0,0,-1,1},{35,0,12,17,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{35,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{35,0,10,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{35,0,13,0,0,0,1},{35,0,13,0,0,1,1},{35,0,13,0,0,2,1},{35,0,13,0,0,3,1},{35,0,13,0,0,4,1},{35,0,13,0,0,5,1},{35,0,13,0,0,6,1},{35,0,13,0,0,7,1},{35,0,13,0,0,8,1},{35,0,13,0,0,9,1},{35,0,15,0,8,-1,1},{35,0,15,0,8,-1,1},{35,0,15,0,8,-1,1},{35,0,26,10,8,-1,1},{35,0,26,10,8,-1,1},{35,0,26,10,8,-1,1},{35,0,26,10,8,-1,1},{35,0,26,10,8,-1,1},{35,0,26,10,8,-1,1},{35,0,23,4,8,-1,1},{35,0,26,10,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{36,0,12,17,4,-1,1},{36,0,10,0,0,-1,1},{36,0,10,0,0,-1,1},{36,0,10,0,0,-1,1},{61,0,2,0,12,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1}},
  {{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,4,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{36,0,7,0,0,-1,1},{36,0,12,17,0,-1,1},{36,0,12,17,0,-1,1}},
  {{36,0,12,17,0,-1,1},{36,0,10,0,0,-1,1},{36,0,10,0,0,-1,1},{36,0,10,0,0,-1,1},{36,0,10,0,0,-1,1},{61,0,2,0,12,-1,1},{36,0,12,17,0,-1,1},{36,0,12,17,0,-1,1},{36,0,12,17,0,-1,1},{61,0,2,0,12,-1,1},{36,0,12,17,0,-1,1},{36,0,12,17,0,-1,1},{36,0,12,17,0,-1,1},{36,0,12,17,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{36,0,12,17,0,-1,1},{36,0,12,17,0,-1,1},{61,0,2,0,12,-1,1},{36,0,7,0,4,-1,1},{36,0,7,0,4,-1,1},{36,0,7,0,2,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{36,0,7,0,0,-1,1},{36,0,7,0,0,-1,1},{36,0,12,17,2,-1,1},{36,0,12,17,2,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{36,0,13,0,0,0,1},{36,0,13,0,0,1,1},{36,0,13,0,0,2,1},{36,0,13,0,0,3,1},{36,0,13,0,0,4,1},{36,0,13,0,0,5,1},{36,0,13,0,0,6,1},{36,0,13,0,0,7,1},{36,0,13,0,0,8,1},{36,0,13,0,0,9,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{36,0,15,10,8,-1,1},{36,0,15,10,8,-1,1},{36,0,15,10,8,-1,1},{36,0,15,10,8,-1,1},{36,0,15,10,8,-1,1},{36,0,15,10,8,-1,1},{36,0,15,10,8,-1,1},{36,0,26,0,8,-1,1}},
  {{61,0,2,0,12,-1,1},{21,0,12,17,4,-1,1},{21,0,10,0,0,-1,1},{21,0,10,0,0,-1,1},{61,0,2,0,12,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1}},
  {{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{21,0,12,17,0,-1,1},{21,0,7,0,0,-1,1},{21,0,10,0,0,-1,1},{21,0,12,0,0,-1,1}},
  {{21,0,10,0,0,-1,1},{21,0,10,0,0,-1,1},{21,0,10,0,0,-1,1},{21,0,10,0,0,-1,1},{21,0,10,0,0,-1,1},{61,0,2,0,12,-1,1},{21,0,12,0,0,-1,1},{21,0,10,0,0,-1,1},{21,0,10,0,0,-1,1},{61,0,2,0,12,-1,1},{21,0,10,0,0,-1,1},{21,0,10,0,0,-1,1},{21,0,12,17,0,-1,1},{21,0,12,17,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{21,0,10,0,0,-1,1},{21,0,10,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{21,0,7,0,4,-1,1},{61,0,2,0,12,-1,1}},
  {{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{21,0,12,17,0,-1,1},{21,0,12,17,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{21,0,13,0,0,0,1},{21,0,13,0,0,1,1},{21,0,13,0,0,2,1},{21,0,13,0,0,3,1},{21,0,13,0,0,4,1},{21,0,13,0,0,5,1},{21,0,13,0,0,6,1},{21,0,13,0,0,7,1},{21,0,13,0,0,8,1},{21,0,13,0,0,9,1},{61,0,2,0,12,-1,1},{21,0,7,0,0,-1,1},{21,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{61,0,2,0,12,-1,1},{26,0,12,17,4,-1,1},{26,0,10,0,0,-1,1},{26,0,10,0,0,-1,1},{61,0,2,0,12,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1}},
  {{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{26,0,7,0,0,-1,1},{26,0,10,0,0,-1,1},{26,0,10,0,0,-1,1}},
  {{26,0,10,0,0,-1,1},{26,0,12,17,0,-1,1},{26,0,12,17,0,-1,1},{26,0,12,17,0,-1,1},{26,0,12,17,2,-1,1},{61,0,2,0,12,-1,1},{26,0,10,0,0,-1,1},{26,0,10,0,0,-1,1},{26,0,10,0,0,-1,1},{61,0,2,0,12,-1,1},{26,0,10,0,0,-1,1},{26,0,10,0,0,-1,1},{26,0,10,0,0,-1,1},{26,0,12,17,0,-1,1},{26,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{26,0,10,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{26,0,7,0,4,-1,1}},
  {{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,12,17,2,-1,1},{26,0,12,17,2,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{26,0,13,0,0,0,1},{26,0,13,0,0,1,1},{26,0,13,0,0,2,1},{26,0,13,0,0,3,1},{26,0,13,0,0,4,1},{26,0,13,0,0,5,1},{26,0,13,0,0,6,1},{26,0,13,0,0,7,1},{26,0,13,0,0,8,1},{26,0,13,0,0,9,1},{26,0,15,0,8,-1,1},{26,0,15,0,8,-1,1},{26,0,15,0,8,-1,1},{26,0,15,0,8,-1,1},{26,0,15,0,8,-1,1},{26,0,15,0,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{26,0,26,0,8,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1},{26,0,7,0,0,-1,1}},
  {{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{33,0,10,0,0,-1,1},{33,0,10,0,0,-1,1},{61,0,2,0,12,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,3,-1,1},{33,0,7,0,3,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1}},
  {{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,3,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{33,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{33,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{33,0,12,17,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{33,0,10,0,0,-1,1},{33,0,10,0,0,-1,1},{33,0,10,0,0,-1,1},{33,0,12,17,0,-1,1},{33,0,12,17,0,-1,1},{33,0,12,17,0,-1,1},{61,0,2,0,12,-1,1},{33,0,12,17,0,-1,1},{61,0,2,0,12,-1,1},{33,0,10,0,0,-1,1},{33,0,10,0,0,-1,1},{33,0,10,0,0,-1,1},{33,0,10,0,0,-1,1},{33,0,10,0,0,-1,1},{33,0,10,0,0,-1,1},{33,0,10,0,0,-1,1},{33,0,10,0,3,-1,1}},
  {{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{33,0,13,0,4,0,1},{33,0,13,0,4,1,1},{33,0,13,0,4,2,1},{33,0,13,0,4,3,1},{33,0,13,0,4,4,1},{33,0,13,0,4,5,1},{33,0,13,0,4,6,1},{33,0,13,0,4,7,1},{33,0,13,0,4,8,1},{33,0,13,0,4,9,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{33,0,10,0,0,-1,1},{33,0,10,0,3,-1,1},{33,0,21,0,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{61,0,2,0,12,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1}},
  {{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,12,17,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,9,-1,1},{38,0,12,17,0,-1,1},{38,0,12,17,0,-1,1},{38,0,12,17,0,-1,1},{38,0,12,17,0,-1,1},{38,0,12,17,0,-1,1},{38,0,12,17,0,-1,1},{38,0,12,17,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{0,0,23,4,8,-1,1}},
  {{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,7,0,0,-1,1},{38,0,6,0,0,-1,1},{38,0,12,17,0,-1,1},{38,0,12,17,0,-1,1},{38,0,12,17,0,-1,1},{38,0,12,17,0,-1,1},{38,0,12,17,0,-1,1},{38,0,12,17,0,-1,1},{38,0,12,17,0,-1,1},{38,0,12,17,0,-1,1},{38,0,21,0,8,-1,1},{38,0,13,0,0,0,1},{38,0,13,0,0,1,1},{38,0,13,0,0,2,1},{38,0,13,0,0,3,1},{38,0,13,0,0,4,1},{38,0,13,0,0,5,1},{38,0,13,0,0,6,1},{38,0,13,0,0,7,1},{38,0,13,0,0,8,1},{38,0,13,0,0,9,1},{38,0,21,0,8,-1,1},{38,0,21,0,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{61,0,2,0,12,-1,1},{24,0,7,0,0,-1,1},{24,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{24,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{24,0,7,0,0,-1,1},{24,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{24,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{24,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{24,0,7,0,0,-1,1},{24,0,7,0,0,-1,1},{24,0,7,0,0,-1,1},{24,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{24,0,7,0,0,-1,1},{24,0,7,0,0,-1,1},{24,0,7,0,0,-1,1},{24,0,7,0,0,-1,1},{24,0,7,0,0,-1,1},{24,0,7,0,0,-1,1},{24,0,7,0,0,-1,1}},
  {{61,0,2,0,12,-1,1},{24,0,7,0,0,-1,1},{24,0,7,0,0,-1,1},{24,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{24,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{24,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{24,0,7,0,0,-1,1},{24,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{24,0,7,0,0,-1,1},{24,0,7,0,0,-1,1},{24,0,7,0,0,-1,1},{24,0,7,0,0,-1,1},{24,0,12,17,0,-1,1},{24,0,7,0,0,-1,1},{24,0,7,0,9,-1,1},{24,0,12,17,0,-1,1},{24,0,12,17,0,-1,1},{24,0,12,17,0,-1,1},{24,0,12,17,0,-1,1},{24,0,12,17,0,-1,1},{24,0,12,17,0,-1,1},{61,0,2,0,12,-1,1},{24,0,12,17,0,-1,1},{24,0,12,17,0,-1,1},{24,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{24,0,7,0,0,-1,1},{24,0,7,0,0,-1,1},{24,0,7,0,0,-1,1},{24,0,7,0,0,-1,1},{24,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{24,0,6,0,0,-1,1},{61,0,2,0,12,-1,1},{24,0,12,17,0,-1,1},{24,0,12,17,0,-1,1},{24,0,12,17,0,-1,1},{24,0,12,17,0,-1,1},{24,0,12,17,0,-1,1},{24,0,12,17,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{24,0,13,0,0,0,1},{24,0,13,0,0,1,1},{24,0,13,0,0,2,1},{24,0,13,0,0,3,1},{24,0,13,0,0,4,1},{24,0,13,0,0,5,1},{24,0,13,0,0,6,1},{24,0,13,0,0,7,1},{24,0,13,0,0,8,1},{24,0,13,0,0,9,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{24,0,7,0,9,-1,1},{24,0,7,0,9,-1,1},{24,0,7,0,0,-1,1},{24,0,7,0,0,-1,1}},
  {{39,0,7,0,0,-1,1},{39,0,26,0,8,-1,1},{39,0,26,0,8,-1,1},{39,0,26,0,8,-1,1},{39,0,21,0,8,-1,1},{39,0,21,0,8,-1,1},{39,0,21,0,8,-1,1},{39,0,21,0,8,-1,1},{39,0,21,0,8,-1,1},{39,0,21,0,8,-1,1},{39,0,21,0,8,-1,1},{39,0,21,0,1,-1,1},{39,0,21,0,9,-1,1},{39,0,21,0,8,-1,1},{39,0,21,0,8,-1,1},{39,0,21,0,8,-1,1},{39,0,21,0,8,-1,1},{39,0,21,0,8,-1,1},{39,0,21,0,8,-1,1},{39,0,26,0,8,-1,1},{39,0,21,0,8,-1,1},{39,0,26,0,8,-1,1},{39,0,26,0,8,-1,1},{39,0,26,0,8,-1,1},{39,0,12,17,3,-1,1},{39,0,12,17,3,-1,1},{39,0,26,0,8,-1,1},{39,0,26,0,8,-1,1},{39,0,26,0,8,-1,1},{39,0,26,0,8,-1,1},{39,0,26,0,8,-1,1},{39,0,26,0,8,-1,1}},
  {{39,0,13,0,0,0,1},{39,0,13,0,0,1,1},{39,0,13,0,0,2,1},{39,0,13,0,0,3,1},{39,0,13,0,0,4,1},{39,0,13,0,0,5,1},{39,0,13,0,0,6,1},{39,0,13,0,0,7,1},{39,0,13,0,0,8,1},{39,0,13,0,0,9,1},{39,0,15,0,8,-1,1},{39,0,15,0,8,-1,1},{39,0,15,0,8,-1,1},{39,0,15,0,8,-1,1},{39,0,15,0,8,-1,1},{39,0,15,0,8,-1,1},{39,0,15,0,8,-1,1},{39,0,15,0,8,-1,1},{39,0,15,0,8,-1,1},{39,0,15,0,8,-1,1},{39,0,26,0,8,-1,1},{39,0,12,17,0,-1,1},{39,0,26,0,8,-1,1},{39,0,12,17,0,-1,1},{39,0,26,0,8,-1,1},{39,0,12,17,2,-1,1},{39,0,22,10,8,-1,1},{39,0,18,10,8,-1,1},{39,0,22,10,8,-1,1},{39,0,18,10,8,-1,1},{39,0,10,0,0,-1,1},{39,0,10,0,0,-1,1}},
  {{39,0,7,0,0,-1,1},{39,0,7,0,0,-1,1},{39,0,7,0,0,-1,1},{39,0,7,0,9,-1,1},{39,0,7,0,0,-1,1},{39,0,7,0,0,-1,1},{39,0,7,0,0,-1,1},{39,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{39,0,7,0,0,-1,1},{39,0,7,0,0,-1,1},{39,0,7,0,0,-1,1},{39,0,7,0,0,-1,1},{39,0,7,0,9,-1,1},{39,0,7,0,0,-1,1},{39,0,7,0,0,-1,1},{39,0,7,0,0,-1,1},{39,0,7,0,0,-1,1},{39,0,7,0,9,-1,1},{39,0,7,0,0,-1,1},{39,0,7,0,0,-1,1},{39,0,7,0,0,-1,1},{39,0,7,0,0,-1,1},{39,0,7,0,9,-1,1},{39,0,7,0,0,-1,1},{39,0,7,0,0,-1,1},{39,0,7,0,0,-1,1},{39,0,7,0,0,-1,1},{39,0,7,0,9,-1,1},{39,0,7,0,0,-1,1},{39,0,7,0,0,-1,1},{39,0,7,0,0,-1,1}},
  {{39,0,7,0,0,-1,1},{39,0,7,0,0,-1,1},{39,0,7,0,0,-1,1},{39,0,7,0,0,-1,1},{39,0,7,0,0,-1,1},{39,0,7,0,0,-1,1},{39,0,7,0,0,-1,1},{39,0,7,0,0,-1,1},{39,0,7,0,0,-1,1},{39,0,7,0,9,-1,1},{39,0,7,0,0,-1,1},{39,0,7,0,0,-1,1},{39,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,9,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,9,-1,1},{39,0,12,17,9,-1,1},{39,0,12,17,11,-1,1},{39,0,12,17,9,-1,1},{39,0,12,17,11,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1},{39,0,10,0,0,-1,1}},
  {{39,0,12,17,0,-1,1},{39,0,12,17,9,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1},{39,0,21,0,8,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1},{39,0,7,0,0,-1,1},{39,0,7,0,0,-1,1},{39,0,7,0,0,-1,1},{39,0,7,0,0,-1,1},{39,0,7,0,0,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,9,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1},{61,0,2,0,12,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,9,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1}},
  {{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,9,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,9,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,9,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,9,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1},{39,0,12,17,0,-1,1},{61,0,2,0,12,-1,1},{39,0,26,0,8,-1,1},{39,0,26,0,8,-1,1}},
  {{39,0,26,0,8,-1,1},{39,0,26,0,8,-1,1},{39,0,26,0,8,-1,1},{39,0,26,0,8,-1,1},{39,0,26,0,8,-1,1},{39,0,26,0,8,-1,1},{39,0,12,17,0,-1,1},{39,0,26,0,8,-1,1},{39,0,26,0,8,-1,1},{39,0,26,0,8,-1,1},{39,0,26,0,8,-1,1},{39,0,26,0,8,-1,1},{39,0,26,0,8,-1,1},{61,0,2,0,12,-1,1},{39,0,26,0,8,-1,1},{39,0,26,0,8,-1,1},{39,0,21,0,8,-1,1},{39,0,21,0,8,-1,1},{39,0,21,0,8,-1,1},{39,0,21,0,8,-1,1},{39,0,21,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{39,0,21,0,8,-1,1},{39,0,21,0,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1}},
  {{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,10,0,0,-1,1},{28,0,10,0,0,-1,1},{28,0,12,17,0,-1,1},{28,0,12,17,0,-1,1},{28,0,12,17,0,-1,1},{28,0,12,17,0,-1,1},{28,0,10,0,0,-1,1},{28,0,12,17,0,-1,1},{28,0,12,17,0,-1,1},{28,0,12,17,0,-1,1},{28,0,12,17,0,-1,1},{28,0,12,17,0,-1,1},{28,0,12,17,0,-1,1},{28,0,10,0,0,-1,1},{28,0,12,17,0,-1,1},{28,0,12,17,0,-1,1},{28,0,10,0,0,-1,1},{28,0,10,0,0,-1,1},{28,0,12,17,0,-1,1},{28,0,12,17,0,-1,1},{28,0,7,0,0,-1,1}},
  {{28,0,13,0,0,0,1},{28,0,13,0,0,1,1},{28,0,13,0,0,2,1},{28,0,13,0,0,3,1},{28,0,13,0,0,4,1},{28,0,13,0,0,5,1},{28,0,13,0,0,6,1},{28,0,13,0,0,7,1},{28,0,13,0,0,8,1},{28,0,13,0,0,9,1},{28,0,21,0,8,-1,1},{28,0,21,0,8,-1,1},{28,0,21,0,8,-1,1},{28,0,21,0,8,-1,1},{28,0,21,0,8,-1,1},{28,0,21,0,8,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,10,0,0,-1,1},{28,0,10,0,0,-1,1},{28,0,12,17,0,-1,1},{28,0,12,17,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,12,17,0,-1,1},{28,0,12,17,0,-1,1}},
  {{28,0,12,17,0,-1,1},{28,0,7,0,0,-1,1},{28,0,10,0,0,-1,1},{28,0,10,0,0,-1,1},{28,0,10,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,10,0,0,-1,1},{28,0,10,0,0,-1,1},{28,0,10,0,0,-1,1},{28,0,10,0,0,-1,1},{28,0,10,0,0,-1,1},{28,0,10,0,0,-1,1},{28,0,10,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,12,17,0,-1,1},{28,0,12,17,0,-1,1},{28,0,12,17,0,-1,1},{28,0,12,17,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1}},
  {{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,12,17,0,-1,1},{28,0,10,0,0,-1,1},{28,0,10,0,0,-1,1},{28,0,12,17,0,-1,1},{28,0,12,17,0,-1,1},{28,0,10,0,0,-1,1},{28,0,10,0,0,-1,1},{28,0,10,0,0,-1,1},{28,0,10,0,0,-1,1},{28,0,10,0,0,-1,1},{28,0,10,0,0,-1,1},{28,0,12,17,0,-1,1},{28,0,7,0,0,-1,1},{28,0,10,0,0,-1,1},{28,0,13,0,0,0,1},{28,0,13,0,0,1,1},{28,0,13,0,0,2,1},{28,0,13,0,0,3,1},{28,0,13,0,0,4,1},{28,0,13,0,0,5,1},{28,0,13,0,0,6,1},{28,0,13,0,0,7,1},{28,0,13,0,0,8,1},{28,0,13,0,0,9,1},{28,0,10,0,0,-1,1},{28,0,10,0,0,-1,1},{28,0,10,0,0,-1,1},{28,0,12,17,0,-1,1},{28,0,26,0,8,-1,1},{28,0,26,0,8,-1,1}},
  {{12,0,9,0,4,-1,1},{12,0,9,0,4,-1,1},{12,0,9,0,4,-1,1},{12,0,9,0,4,-1,1},{12,0,9,0,4,-1,1},{12,0,9,0,4,-1,1},{12,0,9,0,4,-1,1},{12,0,9,0,4,-1,1},{12,0,9,0,4,-1,1},{12,0,9,0,4,-1,1},{12,0,9,0,4,-1,1},{12,0,9,0,4,-1,1},{12,0,9,0,4,-1,1},{12,0,9,0,4,-1,1},{12,0,9,0,4,-1,1},{12,0,9,0,4,-1,1},{12,0,9,0,4,-1,1},{12,0,9,0,4,-1,1},{12,0,9,0,4,-1,1},{12,0,9,0,4,-1,1},{12,0,9,0,4,-1,1},{12,0,9,0,4,-1,1},{12,0,9,0,4,-1,1},{12,0,9,0,4,-1,1},{12,0,9,0,4,-1,1},{12,0,9,0,4,-1,1},{12,0,9,0,4,-1,1},{12,0,9,0,4,-1,1},{12,0,9,0,4,-1,1},{12,0,9,0,4,-1,1},{12,0,9,0,4,-1,1},{12,0,9,0,4,-1,1}},
  {{12,0,9,0,4,-1,1},{12,0,9,0,4,-1,1},{12,0,9,0,4,-1,1},{12,0,9,0,4,-1,1},{12,0,9,0,4,-1,1},{12,0,9,0,4,-1,1},{61,0,2,0,12,-1,1},{12,0,9,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{12,0,9,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{12,0,7,0,0,-1,1},{12,0,7,0,0,-1,1},{12,0,7,0,0,-1,1},{12,0,7,0,0,-1,1},{12,0,7,0,0,-1,1},{12,0,7,0,0,-1,1},{12,0,7,0,0,-1,1},{12,0,7,0,0,-1,1},{12,0,7,0,0,-1,1},{12,0,7,0,0,-1,1},{12,0,7,0,0,-1,1},{12,0,7,0,0,-1,1},{12,0,7,0,0,-1,1},{12,0,7,0,0,-1,1},{12,0,7,0,0,-1,1},{12,0,7,0,0,-1,1}},
  {{12,0,7,0,0,-1,1},{12,0,7,0,0,-1,1},{12,0,7,0,0,-1,1},{12,0,7,0,0,-1,1},{12,0,7,0,0,-1,1},{12,0,7,0,0,-1,1},{12,0,7,0,0,-1,1},{12,0,7,0,0,-1,1},{12,0,7,0,0,-1,1},{12,0,7,0,0,-1,1},{12,0,7,0,0,-1,1},{12,0,7,0,0,-1,1},{12,0,7,0,0,-1,1},{12,0,7,0,0,-1,1},{12,0,7,0,0,-1,1},{12,0,7,0,0,-1,1},{12,0,7,0,0,-1,1},{12,0,7,0,4,-1,1},{12,0,7,0,4,-1,1},{12,0,7,0,4,-1,1},{12,0,7,0,4,-1,1},{12,0,7,0,4,-1,1},{12,0,7,0,4,-1,1},{12,0,7,0,0,-1,1},{12,0,7,0,0,-1,1},{12,0,7,0,0,-1,1},{12,0,7,0,0,-1,1},{0,0,21,0,8,-1,1},{12,0,6,0,9,-1,1},{12,0,7,0,0,-1,1},{12,0,7,0,0,-1,1},{12,0,7,0,0,-1,1}},
  {{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0}},
  {{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,10,-1,0}},
  {{18,0,7,0,10,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0}},
  {{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1}},
  {{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{11,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1}},
  {{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{61,0,2,0,12,-1,1}},
  {{11,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1}},
  {{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1}},
  {{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{11,0,12,17,0,-1,1},{11,0,12,17,0,-1,1},{11,0,12,17,0,-1,1}},
  {{11,0,21,0,8,-1,1},{11,0,21,0,8,-1,1},{11,0,21,0,8,-1,1},{11,0,21,0,8,-1,1},{11,0,21,0,8,-1,1},{11,0,21,0,8,-1,1},{11,0,21,0,8,-1,1},{11,0,21,0,8,-1,1},{11,0,21,0,8,-1,1},{11,0,15,0,4,1,1},{11,0,15,0,4,2,1},{11,0,15,0,4,3,1},{11,0,15,0,4,4,1},{11,0,15,0,4,5,1},{11,0,15,0,4,6,1},{11,0,15,0,4,7,1},{11,0,15,0,4,8,1},{11,0,15,0,4,9,1},{11,0,15,0,8,-1,1},{11,0,15,0,8,-1,1},{11,0,15,0,8,-1,1},{11,0,15,0,8,-1,1},{11,0,15,0,8,-1,1},{11,0,15,0,8,-1,1},{11,0,15,0,8,-1,1},{11,0,15,0,8,-1,1},{11,0,15,0,8,-1,1},{11,0,15,0,8,-1,1},{11,0,15,0,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,26,10,8,-1,1},{11,0,26,10,8,-1,1},{11,0,26,10,8,-1,1},{11,0,26,10,8,-1,1},{11,0,26,10,8,-1,1},{11,0,26,10,8,-1,1},{11,0,26,10,8,-1,1},{11,0,26,10,8,-1,1},{11,0,26,10,8,-1,1},{11,0,26,10,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1}},
  {{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{6,0,9,0,6,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{40,0,17,10,8,-1,1},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0}},
  {{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0}},
  {{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,21,0,8,-1,0},{40,0,21,0,8,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0}},
  {{29,0,29,9,8,-1,1},{29,0,7,0,7,-1,1},{29,0,7,0,7,-1,1},{29,0,7,0,7,-1,1},{29,0,7,0,7,-1,1},{29,0,7,0,7,-1,1},{29,0,7,0,7,-1,1},{29,0,7,0,7,-1,1},{29,0,7,0,7,-1,1},{29,0,7,0,7,-1,1},{29,0,7,0,7,-1,1},{29,0,7,0,7,-1,1},{29,0,7,0,7,-1,1},{29,0,7,0,7,-1,1},{29,0,7,0,7,-1,1},{29,0,7,0,7,-1,1},{29,0,7,0,7,-1,1},{29,0,7,0,7,-1,1},{29,0,7,0,7,-1,1},{29,0,7,0,7,-1,1},{29,0,7,0,7,-1,1},{29,0,7,0,7,-1,1},{29,0,7,0,7,-1,1},{29,0,7,0,7,-1,1},{29,0,7,0,7,-1,1},{29,0,7,0,7,-1,1},{29,0,7,0,7,-1,1},{29,0,22,10,8,-1,1},{29,0,18,10,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1}},
  {{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{0,0,21,0,8,-1,1},{0,0,21,0,8,-1,1},{0,0,21,0,8,-1,1},{32,0,14,0,7,-1,1},{32,0,14,0,7,-1,1},{32,0,14,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{32,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{42,0,7,0,7,-1,1},{42,0,7,0,7,-1,1},{42,0,7,0,7,-1,1},{42,0,7,0,7,-1,1},{42,0,7,0,7,-1,1},{42,0,7,0,7,-1,1},{42,0,7,0,7,-1,1},{42,0,7,0,7,-1,1},{42,0,7,0,7,-1,1},{42,0,7,0,7,-1,1},{42,0,7,0,7,-1,1},{42,0,7,0,7,-1,1},{42,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{42,0,7,0,7,-1,1},{42,0,7,0,7,-1,1},{42,0,7,0,7,-1,1},{42,0,7,0,7,-1,1},{42,0,12,17,7,-1,1},{42,0,12,17,7,-1,1},{42,0,12,17,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{43,0,7,0,7,-1,1},{43,0,7,0,7,-1,1},{43,0,7,0,7,-1,1},{43,0,7,0,7,-1,1},{43,0,7,0,7,-1,1},{43,0,7,0,7,-1,1},{43,0,7,0,7,-1,1},{43,0,7,0,7,-1,1},{43,0,7,0,7,-1,1},{43,0,7,0,7,-1,1},{43,0,7,0,7,-1,1},{43,0,7,0,7,-1,1},{43,0,7,0,7,-1,1},{43,0,7,0,7,-1,1},{43,0,7,0,7,-1,1},{43,0,7,0,7,-1,1},{43,0,7,0,7,-1,1},{43,0,7,0,7,-1,1},{43,0,12,17,7,-1,1},{43,0,12,17,7,-1,1},{43,0,12,17,7,-1,1},{0,0,21,0,8,-1,1},{0,0,21,0,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{44,0,7,0,7,-1,1},{44,0,7,0,7,-1,1},{44,0,7,0,7,-1,1},{44,0,7,0,7,-1,1},{44,0,7,0,7,-1,1},{44,0,7,0,7,-1,1},{44,0,7,0,7,-1,1},{44,0,7,0,7,-1,1},{44,0,7,0,7,-1,1},{44,0,7,0,7,-1,1},{44,0,7,0,7,-1,1},{44,0,7,0,7,-1,1},{44,0,7,0,7,-1,1},{44,0,7,0,7,-1,1},{44,0,7,0,7,-1,1},{44,0,7,0,7,-1,1},{44,0,7,0,7,-1,1},{44,0,7,0,7,-1,1},{44,0,12,17,7,-1,1},{44,0,12,17,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{45,0,7,0,7,-1,1},{45,0,7,0,7,-1,1},{45,0,7,0,7,-1,1},{45,0,7,0,7,-1,1},{45,0,7,0,7,-1,1},{45,0,7,0,7,-1,1},{45,0,7,0,7,-1,1},{45,0,7,0,7,-1,1},{45,0,7,0,7,-1,1},{45,0,7,0,7,-1,1},{45,0,7,0,7,-1,1},{45,0,7,0,7,-1,1},{45,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{45,0,7,0,7,-1,1},{45,0,7,0,7,-1,1},{45,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{45,0,12,17,7,-1,1},{45,0,12,17,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1}},
  {{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,11,-1,1},{23,0,7,0,11,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,4,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,7,0,0,-1,1},{23,0,12,17,10,-1,1},{23,0,12,17,10,-1,1},{23,0,10,0,0,-1,1},{23,0,12,17,0,-1,1},{23,0,12,17,0,-1,1},{23,0,12,17,0,-1,1},{23,0,12,17,0,-1,1},{23,0,12,17,0,-1,1},{23,0,12,17,0,-1,1},{23,0,12,17,0,-1,1},{23,0,10,0,0,-1,1},{23,0,10,0,0,-1,1}},
  {{23,0,10,0,0,-1,1},{23,0,10,0,0,-1,1},{23,0,10,0,0,-1,1},{23,0,10,0,0,-1,1},{23,0,10,0,0,-1,1},{23,0,10,0,0,-1,1},{23,0,12,17,0,-1,1},{23,0,10,0,0,-1,1},{23,0,10,0,0,-1,1},{23,0,12,17,0,-1,1},{23,0,12,17,0,-1,1},{23,0,12,17,3,-1,1},{23,0,12,17,3,-1,1},{23,0,12,17,3,-1,1},{23,0,12,17,3,-1,1},{23,0,12,17,3,-1,1},{23,0,12,17,3,-1,1},{23,0,12,17,4,-1,1},{23,0,12,17,0,-1,1},{23,0,12,17,4,-1,1},{23,0,21,0,8,-1,1},{23,0,21,0,8,-1,1},{23,0,21,0,8,-1,1},{23,0,6,0,0,-1,1},{23,0,21,0,8,-1,1},{23,0,21,0,8,-1,1},{23,0,21,0,8,-1,1},{23,0,23,4,8,-1,1},{23,0,7,0,0,-1,1},{23,0,12,17,4,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{23,0,13,0,0,0,1},{23,0,13,0,0,1,1},{23,0,13,0,0,2,1},{23,0,13,0,0,3,1},{23,0,13,0,0,4,1},{23,0,13,0,0,5,1},{23,0,13,0,0,6,1},{23,0,13,0,0,7,1},{23,0,13,0,0,8,1},{23,0,13,0,0,9,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{23,0,15,10,8,-1,1},{23,0,15,10,8,-1,1},{23,0,15,10,8,-1,1},{23,0,15,10,8,-1,1},{23,0,15,10,8,-1,1},{23,0,15,10,8,-1,1},{23,0,15,10,8,-1,1},{23,0,15,10,8,-1,1},{23,0,15,10,8,-1,1},{23,0,15,10,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{27,0,21,10,8,-1,1},{27,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{27,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{27,0,17,10,8,-1,1},{27,0,21,10,8,-1,1},{27,0,21,10,8,-1,1},{27,0,21,10,8,-1,1},{27,0,21,10,8,-1,1},{27,0,12,17,10,-1,1},{27,0,12,17,10,-1,1},{27,0,12,17,10,-1,1},{27,0,1,18,10,-1,1},{61,0,2,0,12,-1,1},{27,0,13,0,5,0,1},{27,0,13,0,5,1,1},{27,0,13,0,5,2,1},{27,0,13,0,5,3,1},{27,0,13,0,5,4,1},{27,0,13,0,5,5,1},{27,0,13,0,5,6,1},{27,0,13,0,5,7,1},{27,0,13,0,5,8,1},{27,0,13,0,5,9,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1}},
  {{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,6,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1}},
  {{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,7,0,5,-1,1},{27,0,12,17,5,-1,1},{27,0,7,0,5,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0}},
  {{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{40,0,7,0,5,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0}},
  {{48,0,7,0,6,-1,1},{48,0,7,0,6,-1,1},{48,0,7,0,6,-1,1},{48,0,7,0,6,-1,1},{48,0,7,0,6,-1,1},{48,0,7,0,6,-1,1},{48,0,7,0,6,-1,1},{48,0,7,0,6,-1,1},{48,0,7,0,6,-1,1},{48,0,7,0,6,-1,1},{48,0,7,0,6,-1,1},{48,0,7,0,6,-1,1},{48,0,7,0,6,-1,1},{48,0,7,0,6,-1,1},{48,0,7,0,6,-1,1},{48,0,7,0,6,-1,1},{48,0,7,0,6,-1,1},{48,0,7,0,6,-1,1},{48,0,7,0,6,-1,1},{48,0,7,0,6,-1,1},{48,0,7,0,6,-1,1},{48,0,7,0,6,-1,1},{48,0,7,0,6,-1,1},{48,0,7,0,6,-1,1},{48,0,7,0,6,-1,1},{48,0,7,0,6,-1,1},{48,0,7,0,6,-1,1},{48,0,7,0,6,-1,1},{48,0,7,0,6,-1,1},{48,0,7,0,6,-1,1},{48,0,7,0,6,-1,1},{61,0,2,0,12,-1,1}},
  {{48,0,12,17,6,-1,1},{48,0,12,17,6,-1,1},{48,0,12,17,6,-1,1},{48,0,10,0,6,-1,1},{48,0,10,0,6,-1,1},{48,0,10,0,6,-1,1},{48,0,10,0,6,-1,1},{48,0,12,17,6,-1,1},{48,0,12,17,6,-1,1},{48,0,10,0,6,-1,1},{48,0,10,0,6,-1,1},{48,0,10,0,6,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{48,0,10,0,6,-1,1},{48,0,10,0,6,-1,1},{48,0,12,17,6,-1,1},{48,0,10,0,6,-1,1},{48,0,10,0,6,-1,1},{48,0,10,0,6,-1,1},{48,0,10,0,6,-1,1},{48,0,10,0,6,-1,1},{48,0,10,0,6,-1,1},{48,0,12,17,6,-1,1},{48,0,12,17,6,-1,1},{48,0,12,17,6,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{48,0,26,10,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{48,0,21,10,8,-1,1},{48,0,21,10,8,-1,1},{48,0,13,0,6,0,1},{48,0,13,0,6,1,1},{48,0,13,0,6,2,1},{48,0,13,0,6,3,1},{48,0,13,0,6,4,1},{48,0,13,0,6,5,1},{48,0,13,0,6,6,1},{48,0,13,0,6,7,1},{48,0,13,0,6,8,1},{48,0,13,0,6,9,1},{52,0,7,0,6,-1,1},{52,0,7,0,6,-1,1},{52,0,7,0,6,-1,1},{52,0,7,0,6,-1,1},{52,0,7,0,6,-1,1},{52,0,7,0,6,-1,1},{52,0,7,0,6,-1,1},{52,0,7,0,6,-1,1},{52,0,7,0,6,-1,1},{52,0,7,0,6,-1,1},{52,0,7,0,6,-1,1},{52,0,7,0,6,-1,1},{52,0,7,0,6,-1,1},{52,0,7,0,6,-1,1},{52,0,7,0,6,-1,1},{52,0,7,0,6,-1,1}},
  {{52,0,7,0,6,-1,1},{52,0,7,0,6,-1,1},{52,0,7,0,6,-1,1},{52,0,7,0,6,-1,1},{52,0,7,0,6,-1,1},{52,0,7,0,6,-1,1},{52,0,7,0,6,-1,1},{52,0,7,0,6,-1,1},{52,0,7,0,6,-1,1},{52,0,7,0,6,-1,1},{52,0,7,0,6,-1,1},{52,0,7,0,6,-1,1},{52,0,7,0,6,-1,1},{52,0,7,0,6,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{52,0,7,0,6,-1,1},{52,0,7,0,6,-1,1},{52,0,7,0,6,-1,1},{52,0,7,0,6,-1,1},{52,0,7,0,6,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1}},
  {{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1}},
  {{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{54,0,7,0,6,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{54,0,13,0,6,0,1},{54,0,13,0,6,1,1},{54,0,13,0,6,2,1},{54,0,13,0,6,3,1},{54,0,13,0,6,4,1},{54,0,13,0,6,5,1},{54,0,13,0,6,6,1},{54,0,13,0,6,7,1},{54,0,13,0,6,8,1},{54,0,13,0,6,9,1},{54,0,15,0,6,1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{54,0,26,10,8,-1,1},{54,0,26,10,8,-1,1}},
  {{23,0,26,10,8,-1,1},{23,0,26,10,8,-1,1},{23,0,26,10,8,-1,1},{23,0,26,10,8,-1,1},{23,0,26,10,8,-1,1},{23,0,26,10,8,-1,1},{23,0,26,10,8,-1,1},{23,0,26,10,8,-1,1},{23,0,26,10,8,-1,1},{23,0,26,10,8,-1,1},{23,0,26,10,8,-1,1},{23,0,26,10,8,-1,1},{23,0,26,10,8,-1,1},{23,0,26,10,8,-1,1},{23,0,26,10,8,-1,1},{23,0,26,10,8,-1,1},{23,0,26,10,8,-1,1},{23,0,26,10,8,-1,1},{23,0,26,10,8,-1,1},{23,0,26,10,8,-1,1},{23,0,26,10,8,-1,1},{23,0,26,10,8,-1,1},{23,0,26,10,8,-1,1},{23,0,26,10,8,-1,1},{23,0,26,10,8,-1,1},{23,0,26,10,8,-1,1},{23,0,26,10,8,-1,1},{23,0,26,10,8,-1,1},{23,0,26,10,8,-1,1},{23,0,26,10,8,-1,1},{23,0,26,10,8,-1,1},{23,0,26,10,8,-1,1}},
  {{55,0,7,0,7,-1,1},{55,0,7,0,7,-1,1},{55,0,7,0,7,-1,1},{55,0,7,0,7,-1,1},{55,0,7,0,7,-1,1},{55,0,7,0,7,-1,1},{55,0,7,0,7,-1,1},{55,0,7,0,7,-1,1},{55,0,7,0,7,-1,1},{55,0,7,0,7,-1,1},{55,0,7,0,7,-1,1},{55,0,7,0,7,-1,1},{55,0,7,0,7,-1,1},{55,0,7,0,7,-1,1},{55,0,7,0,7,-1,1},{55,0,7,0,7,-1,1},{55,0,7,0,7,-1,1},{55,0,7,0,7,-1,1},{55,0,7,0,7,-1,1},{55,0,7,0,7,-1,1},{55,0,7,0,7,-1,1},{55,0,7,0,7,-1,1},{55,0,7,0,7,-1,1},{55,0,12,17,7,-1,1},{55,0,12,17,7,-1,1},{55,0,10,0,7,-1,1},{55,0,10,0,7,-1,1},{55,0,12,17,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{55,0,21,0,8,-1,1},{55,0,21,0,8,-1,1}},
  {{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1}},
  {{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,7,0,6,-1,1},{91,0,10,0,6,-1,1},{91,0,12,17,6,-1,1},{91,0,10,0,6,-1,1},{91,0,12,17,6,-1,1},{91,0,12,17,6,-1,1},{91,0,12,17,6,-1,1},{91,0,12,17,6,-1,1},{91,0,12,17,6,-1,1},{91,0,12,17,6,-1,1},{91,0,12,17,6,-1,1},{61,0,2,0,12,-1,1}},
  {{91,0,12,17,6,-1,1},{91,0,10,0,6,-1,1},{91,0,12,17,6,-1,1},{91,0,10,0,6,-1,1},{91,0,10,0,6,-1,1},{91,0,12,17,6,-1,1},{91,0,12,17,6,-1,1},{91,0,12,17,6,-1,1},{91,0,12,17,6,-1,1},{91,0,12,17,6,-1,1},{91,0,12,17,6,-1,1},{91,0,12,17,6,-1,1},{91,0,12,17,6,-1,1},{91,0,10,0,6,-1,1},{91,0,10,0,6,-1,1},{91,0,10,0,6,-1,1},{91,0,10,0,6,-1,1},{91,0,10,0,6,-1,1},{91,0,10,0,6,-1,1},{91,0,12,17,6,-1,1},{91,0,12,17,6,-1,1},{91,0,12,17,6,-1,1},{91,0,12,17,6,-1,1},{91,0,12,17,6,-1,1},{91,0,12,17,6,-1,1},{91,0,12,17,6,-1,1},{91,0,12,17,6,-1,1},{91,0,12,17,6,-1,1},{91,0,12,17,6,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{91,0,12,17,6,-1,1}},
  {{91,0,13,0,6,0,1},{91,0,13,0,6,1,1},{91,0,13,0,6,2,1},{91,0,13,0,6,3,1},{91,0,13,0,6,4,1},{91,0,13,0,6,5,1},{91,0,13,0,6,6,1},{91,0,13,0,6,7,1},{91,0,13,0,6,8,1},{91,0,13,0,6,9,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{91,0,13,0,6,0,1},{91,0,13,0,6,1,1},{91,0,13,0,6,2,1},{91,0,13,0,6,3,1},{91,0,13,0,6,4,1},{91,0,13,0,6,5,1},{91,0,13,0,6,6,1},{91,0,13,0,6,7,1},{91,0,13,0,6,8,1},{91,0,13,0,6,9,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{91,0,21,0,8,-1,1},{91,0,21,0,8,-1,1},{91,0,21,0,8,-1,1},{91,0,21,0,8,-1,1},{91,0,21,0,8,-1,1},{91,0,21,0,8,-1,1},{91,0,21,0,8,-1,1},{91,0,6,0,6,-1,1},{91,0,21,0,8,-1,1},{91,0,21,0,8,-1,1},{91,0,21,0,8,-1,1},{91,0,21,0,8,-1,1},{91,0,21,0,8,-1,1},{91,0,21,0,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,11,17,8,-1,1},{61,0,2,0,12,-1,1}},
  {{62,0,12,17,6,-1,1},{62,0,12,17,6,-1,1},{62,0,12,17,6,-1,1},{62,0,12,17,6,-1,1},{62,0,10,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1}},
  {{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,12,17,6,-1,1},{62,0,10,0,6,-1,1},{62,0,12,17,6,-1,1},{62,0,12,17,6,-1,1},{62,0,12,17,6,-1,1},{62,0,12,17,6,-1,1},{62,0,12,17,6,-1,1},{62,0,10,0,6,-1,1},{62,0,12,17,6,-1,1},{62,0,10,0,6,-1,1},{62,0,10,0,6,-1,1},{62,0,10,0,6,-1,1}},
  {{62,0,10,0,6,-1,1},{62,0,10,0,6,-1,1},{62,0,12,17,6,-1,1},{62,0,10,0,6,-1,1},{62,0,10,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{62,0,7,0,6,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{62,0,13,0,6,0,1},{62,0,13,0,6,1,1},{62,0,13,0,6,2,1},{62,0,13,0,6,3,1},{62,0,13,0,6,4,1},{62,0,13,0,6,5,1},{62,0,13,0,6,6,1},{62,0,13,0,6,7,1},{62,0,13,0,6,8,1},{62,0,13,0,6,9,1},{62,0,21,0,8,-1,1},{62,0,21,0,8,-1,1},{62,0,21,0,8,-1,1},{62,0,21,0,8,-1,1},{62,0,21,0,8,-1,1},{62,0,21,0,8,-1,1}},
  {{62,0,21,0,8,-1,1},{62,0,26,0,8,-1,1},{62,0,26,0,8,-1,1},{62,0,26,0,8,-1,1},{62,0,26,0,8,-1,1},{62,0,26,0,8,-1,1},{62,0,26,0,8,-1,1},{62,0,26,0,8,-1,1},{62,0,26,0,8,-1,1},{62,0,26,0,8,-1,1},{62,0,26,0,8,-1,1},{62,0,12,17,6,-1,1},{62,0,12,17,6,-1,1},{62,0,12,17,6,-1,1},{62,0,12,17,6,-1,1},{62,0,12,17,6,-1,1},{62,0,12,17,6,-1,1},{62,0,12,17,6,-1,1},{62,0,12,17,6,-1,1},{62,0,12,17,6,-1,1},{62,0,26,0,8,-1,1},{62,0,26,0,8,-1,1},{62,0,26,0,8,-1,1},{62,0,26,0,8,-1,1},{62,0,26,0,8,-1,1},{62,0,26,0,8,-1,1},{62,0,26,0,8,-1,1},{62,0,26,0,8,-1,1},{62,0,26,0,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{70,0,12,17,6,-1,1},{70,0,12,17,6,-1,1},{70,0,10,0,6,-1,1},{70,0,7,0,6,-1,1},{70,0,7,0,6,-1,1},{70,0,7,0,6,-1,1},{70,0,7,0,6,-1,1},{70,0,7,0,6,-1,1},{70,0,7,0,6,-1,1},{70,0,7,0,6,-1,1},{70,0,7,0,6,-1,1},{70,0,7,0,6,-1,1},{70,0,7,0,6,-1,1},{70,0,7,0,6,-1,1},{70,0,7,0,6,-1,1},{70,0,7,0,6,-1,1},{70,0,7,0,6,-1,1},{70,0,7,0,6,-1,1},{70,0,7,0,6,-1,1},{70,0,7,0,6,-1,1},{70,0,7,0,6,-1,1},{70,0,7,0,6,-1,1},{70,0,7,0,6,-1,1},{70,0,7,0,6,-1,1},{70,0,7,0,6,-1,1},{70,0,7,0,6,-1,1},{70,0,7,0,6,-1,1},{70,0,7,0,6,-1,1},{70,0,7,0,6,-1,1},{70,0,7,0,6,-1,1},{70,0,7,0,6,-1,1},{70,0,7,0,6,-1,1}},
  {{70,0,7,0,6,-1,1},{70,0,10,0,6,-1,1},{70,0,12,17,6,-1,1},{70,0,12,17,6,-1,1},{70,0,12,17,6,-1,1},{70,0,12,17,6,-1,1},{70,0,10,0,6,-1,1},{70,0,10,0,6,-1,1},{70,0,12,17,6,-1,1},{70,0,12,17,6,-1,1},{70,0,10,0,6,-1,1},{70,0,12,17,6,-1,1},{70,0,12,17,6,-1,1},{70,0,12,17,6,-1,1},{70,0,7,0,6,-1,1},{70,0,7,0,6,-1,1},{70,0,13,0,6,0,1},{70,0,13,0,6,1,1},{70,0,13,0,6,2,1},{70,0,13,0,6,3,1},{70,0,13,0,6,4,1},{70,0,13,0,6,5,1},{70,0,13,0,6,6,1},{70,0,13,0,6,7,1},{70,0,13,0,6,8,1},{70,0,13,0,6,9,1},{70,0,7,0,6,-1,1},{70,0,7,0,6,-1,1},{70,0,7,0,6,-1,1},{70,0,7,0,6,-1,1},{70,0,7,0,6,-1,1},{70,0,7,0,6,-1,1}},
  {{93,0,7,0,6,-1,1},{93,0,7,0,6,-1,1},{93,0,7,0,6,-1,1},{93,0,7,0,6,-1,1},{93,0,7,0,6,-1,1},{93,0,7,0,6,-1,1},{93,0,7,0,6,-1,1},{93,0,7,0,6,-1,1},{93,0,7,0,6,-1,1},{93,0,7,0,6,-1,1},{93,0,7,0,6,-1,1},{93,0,7,0,6,-1,1},{93,0,7,0,6,-1,1},{93,0,7,0,6,-1,1},{93,0,7,0,6,-1,1},{93,0,7,0,6,-1,1},{93,0,7,0,6,-1,1},{93,0,7,0,6,-1,1},{93,0,7,0,6,-1,1},{93,0,7,0,6,-1,1},{93,0,7,0,6,-1,1},{93,0,7,0,6,-1,1},{93,0,7,0,6,-1,1},{93,0,7,0,6,-1,1},{93,0,7,0,6,-1,1},{93,0,7,0,6,-1,1},{93,0,7,0,6,-1,1},{93,0,7,0,6,-1,1},{93,0,7,0,6,-1,1},{93,0,7,0,6,-1,1},{93,0,7,0,6,-1,1},{93,0,7,0,6,-1,1}},
  {{93,0,7,0,6,-1,1},{93,0,7,0,6,-1,1},{93,0,7,0,6,-1,1},{93,0,7,0,6,-1,1},{93,0,7,0,6,-1,1},{93,0,7,0,6,-1,1},{93,0,12,17,6,-1,1},{93,0,10,0,6,-1,1},{93,0,12,17,6,-1,1},{93,0,12,17,6,-1,1},{93,0,10,0,6,-1,1},{93,0,10,0,6,-1,1},{93,0,10,0,6,-1,1},{93,0,12,17,6,-1,1},{93,0,10,0,6,-1,1},{93,0,12,17,6,-1,1},{93,0,12,17,6,-1,1},{93,0,12,17,6,-1,1},{93,0,10,0,6,-1,1},{93,0,10,0,6,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{93,0,21,0,8,-1,1},{93,0,21,0,8,-1,1},{93,0,21,0,8,-1,1},{93,0,21,0,8,-1,1}},
  {{68,0,7,0,6,-1,1},{68,0,7,0,6,-1,1},{68,0,7,0,6,-1,1},{68,0,7,0,6,-1,1},{68,0,7,0,6,-1,1},{68,0,7,0,6,-1,1},{68,0,7,0,6,-1,1},{68,0,7,0,6,-1,1},{68,0,7,0,6,-1,1},{68,0,7,0,6,-1,1},{68,0,7,0,6,-1,1},{68,0,7,0,6,-1,1},{68,0,7,0,6,-1,1},{68,0,7,0,6,-1,1},{68,0,7,0,6,-1,1},{68,0,7,0,6,-1,1},{68,0,7,0,6,-1,1},{68,0,7,0,6,-1,1},{68,0,7,0,6,-1,1},{68,0,7,0,6,-1,1},{68,0,7,0,6,-1,1},{68,0,7,0,6,-1,1},{68,0,7,0,6,-1,1},{68,0,7,0,6,-1,1},{68,0,7,0,6,-1,1},{68,0,7,0,6,-1,1},{68,0,7,0,6,-1,1},{68,0,7,0,6,-1,1},{68,0,7,0,6,-1,1},{68,0,7,0,6,-1,1},{68,0,7,0,6,-1,1},{68,0,7,0,6,-1,1}},
  {{68,0,7,0,6,-1,1},{68,0,7,0,6,-1,1},{68,0,7,0,6,-1,1},{68,0,7,0,6,-1,1},{68,0,10,0,6,-1,1},{68,0,10,0,6,-1,1},{68,0,10,0,6,-1,1},{68,0,10,0,6,-1,1},{68,0,10,0,6,-1,1},{68,0,10,0,6,-1,1},{68,0,10,0,6,-1,1},{68,0,10,0,6,-1,1},{68,0,12,17,6,-1,1},{68,0,12,17,6,-1,1},{68,0,12,17,6,-1,1},{68,0,12,17,6,-1,1},{68,0,12,17,6,-1,1},{68,0,12,17,6,-1,1},{68,0,12,17,6,-1,1},{68,0,12,17,6,-1,1},{68,0,10,0,6,-1,1},{68,0,10,0,6,-1,1},{68,0,12,17,6,-1,1},{68,0,12,17,6,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{68,0,21,0,8,-1,1},{68,0,21,0,8,-1,1},{68,0,21,0,8,-1,1},{68,0,21,0,8,-1,1},{68,0,21,0,8,-1,1}},
  {{68,0,13,0,6,0,1},{68,0,13,0,6,1,1},{68,0,13,0,6,2,1},{68,0,13,0,6,3,1},{68,0,13,0,6,4,1},{68,0,13,0,6,5,1},{68,0,13,0,6,6,1},{68,0,13,0,6,7,1},{68,0,13,0,6,8,1},{68,0,13,0,6,9,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{68,0,7,0,6,-1,1},{68,0,7,0,6,-1,1},{68,0,7,0,6,-1,1},{73,0,13,0,6,0,1},{73,0,13,0,6,1,1},{73,0,13,0,6,2,1},{73,0,13,0,6,3,1},{73,0,13,0,6,4,1},{73,0,13,0,6,5,1},{73,0,13,0,6,6,1},{73,0,13,0,6,7,1},{73,0,13,0,6,8,1},{73,0,13,0,6,9,1},{73,0,7,0,6,-1,1},{73,0,7,0,6,-1,1},{73,0,7,0,6,-1,1},{73,0,7,0,6,-1,1},{73,0,7,0,6,-1,1},{73,0,7,0,6,-1,1}},
  {{73,0,7,0,6,-1,1},{73,0,7,0,6,-1,1},{73,0,7,0,6,-1,1},{73,0,7,0,6,-1,1},{73,0,7,0,6,-1,1},{73,0,7,0,6,-1,1},{73,0,7,0,6,-1,1},{73,0,7,0,6,-1,1},{73,0,7,0,6,-1,1},{73,0,7,0,6,-1,1},{73,0,7,0,6,-1,1},{73,0,7,0,6,-1,1},{73,0,7,0,6,-1,1},{73,0,7,0,6,-1,1},{73,0,7,0,6,-1,1},{73,0,7,0,6,-1,1},{73,0,7,0,6,-1,1},{73,0,7,0,6,-1,1},{73,0,7,0,6,-1,1},{73,0,7,0,6,-1,1},{73,0,7,0,6,-1,1},{73,0,7,0,6,-1,1},{73,0,7,0,6,-1,1},{73,0,7,0,6,-1,1},{73,0,6,0,6,-1,1},{73,0,6,0,6,-1,1},{73,0,6,0,6,-1,1},{73,0,6,0,6,-1,1},{73,0,6,0,6,-1,1},{73,0,6,0,6,-1,1},{73,0,21,0,8,-1,1},{73,0,21,0,8,-1,1}},
  {{70,0,21,0,8,-1,1},{70,0,21,0,8,-1,1},{70,0,21,0,8,-1,1},{70,0,21,0,8,-1,1},{70,0,21,0,8,-1,1},{70,0,21,0,8,-1,1},{70,0,21,0,8,-1,1},{70,0,21,0,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{0,0,21,0,8,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1}},
  {{1,0,12,17,4,-1,1},{0,0,10,0,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{0,0,7,0,4,-1,1},{0,0,7,0,4,-1,1},{0,0,7,0,4,-1,1},{0,0,7,0,4,-1,1},{1,0,12,17,4,-1,1},{0,0,7,0,4,-1,1},{0,0,7,0,4,-1,1},{0,0,7,0,4,-1,1},{0,0,7,0,4,-1,1},{0,0,10,0,4,-1,1},{0,0,10,0,4,-1,1},{1,0,12,17,4,-1,1},{0,0,7,0,4,-1,1},{0,0,7,0,4,-1,1},{61,0,2,0,12,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1}},
  {{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{14,0,5,0,3,-1,1},{14,0,5,0,3,-1,1},{14,0,5,0,3,-1,1},{14,0,5,0,3,-1,1},{14,0,5,0,3,-1,1},{8,0,5,0,3,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,3,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,3,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1}},
  {{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,3,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{14,0,6,0,9,-1,1},{14,0,6,0,9,-1,1},{14,0,6,0,9,-1,1}},
  {{14,0,6,0,9,-1,1},{14,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{14,0,6,0,9,-1,1},{14,0,6,0,9,-1,1},{14,0,6,0,9,-1,1},{14,0,6,0,9,-1,1},{14,0,6,0,9,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{8,0,6,0,9,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1}},
  {{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1}},
  {{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{14,0,6,0,9,-1,1}},
  {{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1}},
  {{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,4,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1}},
  {{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,9,-1,1},{25,0,5,0,9,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,3,-1,1}},
  {{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,9,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,9,0,3,-1,1},{25,0,5,0,3,-1,1}},
  {{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1}},
  {{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{61,0,2,0,12,-1,1},{14,0,9,0,0,-1,1},{61,0,2,0,12,-1,1},{14,0,9,0,0,-1,1},{61,0,2,0,12,-1,1},{14,0,9,0,0,-1,1},{61,0,2,0,12,-1,1},{14,0,9,0,0,-1,1}},
  {{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,9,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,9,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,9,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,9,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,9,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,9,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,9,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,8,0,0,-1,1},{14,0,8,0,0,-1,1},{14,0,8,0,0,-1,1},{14,0,8,0,0,-1,1},{14,0,8,0,0,-1,1},{14,0,8,0,0,-1,1},{14,0,8,0,0,-1,1},{14,0,8,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,8,0,0,-1,1},{14,0,8,0,0,-1,1},{14,0,8,0,0,-1,1},{14,0,8,0,0,-1,1},{14,0,8,0,0,-1,1},{14,0,8,0,0,-1,1},{14,0,8,0,0,-1,1},{14,0,8,0,0,-1,1}},
  {{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,8,0,0,-1,1},{14,0,8,0,0,-1,1},{14,0,8,0,0,-1,1},{14,0,8,0,0,-1,1},{14,0,8,0,0,-1,1},{14,0,8,0,0,-1,1},{14,0,8,0,0,-1,1},{14,0,8,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{61,0,2,0,12,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,9,-1,1},{14,0,8,0,0,-1,1},{14,0,24,10,9,-1,1},{14,0,5,0,9,-1,1},{14,0,24,10,9,-1,1}},
  {{14,0,24,10,9,-1,1},{14,0,24,10,9,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{61,0,2,0,12,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,9,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,9,-1,1},{14,0,8,0,0,-1,1},{14,0,24,10,9,-1,1},{14,0,24,10,9,-1,1},{14,0,24,10,9,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,9,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,9,-1,1},{61,0,2,0,12,-1,1},{14,0,24,10,9,-1,1},{14,0,24,10,9,-1,1},{14,0,24,10,9,-1,1}},
  {{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,9,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,9,-1,1},{14,0,9,0,0,-1,1},{14,0,24,10,9,-1,1},{14,0,24,10,9,-1,1},{14,0,24,10,9,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{61,0,2,0,12,-1,1},{14,0,5,0,0,-1,1},{14,0,5,0,0,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,9,-1,1},{14,0,9,0,0,-1,1},{14,0,9,0,9,-1,1},{14,0,8,0,0,-1,1},{14,0,24,10,9,-1,1},{14,0,24,10,9,-1,1},{61,0,2,0,12,-1,1}},
  {{0,0,29,9,9,-1,1},{0,0,29,9,9,-1,1},{0,0,29,9,9,-1,1},{0,0,29,9,9,-1,1},{0,0,29,9,9,-1,1},{0,0,29,9,9,-1,1},{0,0,29,9,9,-1,1},{0,0,29,9,9,-1,1},{0,0,29,9,9,-1,1},{0,0,29,9,9,-1,1},{0,0,29,9,9,-1,1},{0,0,1,18,10,-1,1},{1,0,1,18,1,-1,1},{1,0,1,18,1,-1,1},{0,0,1,0,10,-1,1},{0,0,1,1,10,-1,1},{0,0,17,10,1,-1,1},{0,0,17,10,9,-1,1},{0,0,17,10,8,-1,1},{0,0,17,10,8,-1,1},{0,0,17,10,8,-1,1},{0,0,17,10,8,-1,1},{0,0,21,10,8,-1,0},{0,0,21,10,9,-1,1},{0,0,20,10,8,-1,1},{0,0,19,10,1,-1,1},{0,0,22,10,8,-1,1},{0,0,20,10,8,-1,1},{0,0,20,10,8,-1,1},{0,0,19,10,8,-1,1},{0,0,22,10,8,-1,1},{0,0,20,10,8,-1,1}},
  {{0,0,21,10,8,-1,0},{0,0,21,10,8,-1,0},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,9,-1,1},{0,0,21,10,9,-1,1},{0,0,21,10,9,-1,1},{0,0,21,10,1,-1,1},{0,0,27,9,8,-1,1},{0,0,28,7,8,-1,1},{0,0,1,11,10,-1,1},{0,0,1,14,10,-1,1},{0,0,1,16,10,-1,1},{0,0,1,12,10,-1,1},{0,0,1,15,10,-1,1},{0,0,29,6,9,-1,1},{0,0,21,4,8,-1,0},{0,0,21,4,8,-1,0},{0,0,21,4,8,-1,1},{0,0,21,4,9,-1,1},{0,0,21,4,9,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,9,-1,1},{0,0,21,10,9,-1,1},{0,0,21,10,8,-1,1},{0,0,20,10,8,-1,1},{0,0,19,10,8,-1,1},{0,0,21,10,8,-1,0},{0,0,21,10,9,-1,0},{0,0,21,10,8,-1,1},{0,0,21,10,9,-1,1},{0,0,16,10,3,-1,1}},
  {{0,0,16,10,3,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,0},{0,0,21,10,8,-1,1},{0,0,25,6,8,-1,1},{0,0,22,10,8,-1,1},{0,0,18,10,8,-1,1},{0,0,21,10,9,-1,0},{0,0,21,10,9,-1,0},{0,0,21,10,9,-1,0},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,0},{0,0,25,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,16,10,2,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,9,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,29,9,9,-1,1}},
  {{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{61,0,2,0,12,-1,0},{0,0,1,19,10,-1,1},{0,0,1,20,10,-1,1},{0,0,1,21,10,-1,1},{0,0,1,22,10,-1,1},{0,0,1,18,11,-1,1},{0,0,1,18,11,-1,1},{0,0,1,18,11,-1,1},{0,0,1,18,11,-1,1},{0,0,1,18,11,-1,1},{0,0,1,18,11,-1,1},{0,0,15,2,9,0,1},{25,0,6,0,9,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{0,0,15,2,9,4,1},{0,0,15,2,9,5,1},{0,0,15,2,9,6,1},{0,0,15,2,9,7,1},{0,0,15,2,9,8,1},{0,0,15,2,9,9,1},{0,0,25,3,9,-1,1},{0,0,25,3,9,-1,1},{0,0,25,10,9,-1,1},{0,0,22,10,9,-1,1},{0,0,18,10,9,-1,1},{25,0,6,0,9,-1,1}},
  {{0,0,15,2,9,0,1},{0,0,15,2,9,1,1},{0,0,15,2,9,2,1},{0,0,15,2,9,3,1},{0,0,15,2,9,4,1},{0,0,15,2,9,5,1},{0,0,15,2,9,6,1},{0,0,15,2,9,7,1},{0,0,15,2,9,8,1},{0,0,15,2,9,9,1},{0,0,25,3,9,-1,1},{0,0,25,3,9,-1,1},{0,0,25,10,9,-1,1},{0,0,22,10,9,-1,1},{0,0,18,10,9,-1,1},{61,0,2,0,12,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{0,0,23,4,8,-1,1},{0,0,23,4,8,-1,1},{0,0,23,4,8,-1,1},{0,0,23,4,8,-1,1},{0,0,23,4,8,-1,1},{0,0,23,4,8,-1,1},{0,0,23,4,8,-1,1},{0,0,23,4,8,-1,1},{0,0,23,4,9,-1,1},{0,0,23,4,8,-1,1},{0,0,23,4,8,-1,1},{0,0,23,4,8,-1,1},{0,0,23,4,8,-1,1},{0,0,23,4,8,-1,1},{0,0,23,4,8,-1,1},{0,0,23,4,8,-1,1},{0,0,23,4,8,-1,1},{0,0,23,4,8,-1,1},{0,0,23,4,8,-1,1},{0,0,23,4,8,-1,1},{0,0,23,4,8,-1,1},{0,0,23,4,8,-1,1},{0,0,23,4,8,-1,1},{0,0,23,4,8,-1,1},{0,0,23,4,8,-1,1},{0,0,23,4,8,-1,1},{0,0,23,4,8,-1,1},{0,0,23,4,8,-1,1},{0,0,23,4,8,-1,1},{0,0,23,4,8,-1,1},{0,0,23,4,8,-1,1},{61,0,2,4,12,-1,1}},
  {{61,0,2,4,12,-1,1},{61,0,2,4,12,-1,1},{61,0,2,4,12,-1,1},{61,0,2,4,12,-1,1},{61,0,2,4,12,-1,1},{61,0,2,4,12,-1,1},{61,0,2,4,12,-1,1},{61,0,2,4,12,-1,1},{61,0,2,4,12,-1,1},{61,0,2,4,12,-1,1},{61,0,2,4,12,-1,1},{61,0,2,4,12,-1,1},{61,0,2,4,12,-1,1},{61,0,2,4,12,-1,1},{61,0,2,4,12,-1,1},{61,0,2,4,12,-1,1},{1,0,12,17,7,-1,1},{1,0,12,17,7,-1,1},{1,0,12,17,7,-1,1},{1,0,12,17,7,-1,1},{1,0,12,17,7,-1,1},{1,0,12,17,7,-1,1},{1,0,12,17,7,-1,1},{1,0,12,17,7,-1,1},{1,0,12,17,7,-1,1},{1,0,12,17,7,-1,1},{1,0,12,17,7,-1,1},{1,0,12,17,7,-1,1},{1,0,12,17,7,-1,1},{1,0,11,17,8,-1,0},{1,0,11,17,8,-1,0},{1,0,11,17,8,-1,0}},
  {{1,0,11,17,8,-1,0},{1,0,12,17,7,-1,1},{1,0,11,17,8,-1,0},{1,0,11,17,8,-1,0},{1,0,11,17,8,-1,0},{1,0,12,17,7,-1,1},{1,0,12,17,7,-1,1},{1,0,12,17,7,-1,1},{1,0,12,17,7,-1,1},{1,0,12,17,7,-1,1},{1,0,12,17,7,-1,1},{1,0,12,17,7,-1,1},{1,0,12,17,7,-1,1},{1,0,12,17,7,-1,1},{1,0,12,17,7,-1,1},{1,0,12,17,7,-1,1},{1,0,12,17,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{0,0,26,10,9,-1,0},{0,0,26,10,9,-1,0},{0,0,9,0,9,-1,1},{0,0,26,10,9,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,9,-1,0},{0,0,26,10,9,-1,0},{0,0,9,0,9,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,9,-1,0},{0,0,5,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,0},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,5,0,9,-1,0},{0,0,26,10,8,-1,0},{0,0,9,0,9,-1,1},{0,0,26,10,9,-1,0},{0,0,26,10,8,-1,0},{0,0,25,10,3,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0}},
  {{0,0,26,10,9,-1,0},{0,0,26,10,9,-1,0},{0,0,26,10,9,-1,0},{0,0,26,10,8,-1,0},{0,0,9,0,9,-1,1},{0,0,26,10,8,-1,0},{14,0,9,0,9,-1,1},{0,0,26,10,8,-1,0},{0,0,9,0,9,-1,1},{0,0,26,10,8,-1,0},{25,0,9,0,9,-1,1},{25,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,26,4,3,-1,0},{0,0,5,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{25,0,9,0,4,-1,1},{0,0,9,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,7,0,9,-1,0},{0,0,7,0,9,-1,0},{0,0,7,0,9,-1,0},{0,0,7,0,9,-1,0},{0,0,5,0,9,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,9,-1,0},{0,0,5,0,9,-1,0},{0,0,5,0,9,-1,0},{0,0,9,0,9,-1,0},{0,0,9,0,9,-1,0}},
  {{0,0,25,10,9,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,9,0,9,-1,0},{0,0,5,0,9,-1,0},{0,0,5,0,9,-1,0},{0,0,5,0,9,-1,0},{0,0,5,0,9,-1,0},{0,0,26,10,8,-1,0},{0,0,25,10,8,-1,1},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{25,0,5,0,4,-1,1},{0,0,26,0,8,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0}},
  {{25,0,14,0,9,-1,0},{25,0,14,0,9,-1,0},{25,0,14,0,9,-1,0},{25,0,14,0,9,-1,0},{25,0,14,0,9,-1,0},{25,0,14,0,9,-1,0},{25,0,14,0,9,-1,0},{25,0,14,0,9,-1,0},{25,0,14,0,9,-1,0},{25,0,14,0,9,-1,0},{25,0,14,0,9,-1,0},{25,0,14,0,9,-1,0},{25,0,14,0,9,-1,0},{25,0,14,0,9,-1,0},{25,0,14,0,9,-1,0},{25,0,14,0,9,-1,0},{25,0,14,0,9,-1,0},{25,0,14,0,9,-1,0},{25,0,14,0,9,-1,0},{25,0,14,0,9,-1,0},{25,0,14,0,9,-1,0},{25,0,14,0,9,-1,0},{25,0,14,0,9,-1,0},{25,0,14,0,9,-1,0},{25,0,14,0,9,-1,0},{25,0,14,0,9,-1,0},{25,0,14,0,9,-1,0},{25,0,14,0,9,-1,0},{25,0,14,0,9,-1,0},{25,0,14,0,9,-1,0},{25,0,14,0,9,-1,0},{25,0,14,0,9,-1,0}},
  {{25,0,14,0,4,-1,0},{25,0,14,0,4,-1,0},{25,0,14,0,4,-1,0},{25,0,9,0,4,-1,0},{25,0,5,0,4,-1,0},{25,0,14,0,4,-1,0},{25,0,14,0,4,-1,0},{25,0,14,0,4,-1,0},{25,0,14,0,4,-1,0},{0,0,15,10,9,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1}},
  {{0,0,25,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1}},
  {{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1}},
  {{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1}},
  {{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,3,8,-1,1},{0,0,25,4,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,0},{0,0,25,10,8,-1,1}},
  {{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,9,-1,1},{0,0,25,10,9,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,9,-1,1},{0,0,25,10,9,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,0},{0,0,25,10,8,-1,0},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1}},
  {{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1}},
  {{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,22,10,8,-1,1},{0,0,18,10,8,-1,1},{0,0,22,10,8,-1,1},{0,0,18,10,8,-1,1},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0}},
  {{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,22,10,11,-1,3},{0,0,18,10,11,-1,3},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1}},
  {{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1}},
  {{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0}},
  {{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1}},
  {{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0}},
  {{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1}},
  {{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0}},
  {{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0}},
  {{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0}},
  {{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0}},
  {{0,0,15,10,9,1,0},{0,0,15,10,9,2,0},{0,0,15,10,9,3,0},{0,0,15,10,9,4,0},{0,0,15,10,9,5,0},{0,0,15,10,9,6,0},{0,0,15,10,9,7,0},{0,0,15,10,9,8,0},{0,0,15,10,9,9,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,1,0},{0,0,15,10,9,2,0},{0,0,15,10,9,3,0},{0,0,15,10,9,4,0},{0,0,15,10,9,5,0},{0,0,15,10,9,6,0},{0,0,15,10,9,7,0},{0,0,15,10,9,8,0},{0,0,15,10,9,9,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0}},
  {{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,2,9,1,0},{0,0,15,2,9,2,0},{0,0,15,2,9,3,0},{0,0,15,2,9,4,0},{0,0,15,2,9,5,0},{0,0,15,2,9,6,0},{0,0,15,2,9,7,0},{0,0,15,2,9,8,0},{0,0,15,2,9,9,0},{0,0,15,2,9,-1,0},{0,0,15,2,9,-1,0},{0,0,15,2,9,-1,0},{0,0,15,2,9,-1,0},{0,0,15,2,9,-1,0},{0,0,15,2,9,-1,0},{0,0,15,2,9,-1,0},{0,0,15,2,9,-1,0},{0,0,15,2,9,-1,0},{0,0,15,2,9,-1,0},{0,0,15,2,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0}},
  {{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0}},
  {{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,15,10,9,0,0},{0,0,15,10,8,-1,0},{0,0,15,10,8,-1,0},{0,0,15,10,8,-1,0},{0,0,15,10,8,-1,0},{0,0,15,10,8,-1,0},{0,0,15,10,8,-1,0},{0,0,15,10,8,-1,0},{0,0,15,10,8,-1,0},{0,0,15,10,8,-1,0},{0,0,15,10,8,-1,0},{0,0,15,10,8,1,0},{0,0,15,10,8,2,0},{0,0,15,10,8,3,0},{0,0,15,10,8,4,0},{0,0,15,10,8,5,0},{0,0,15,10,8,6,0},{0,0,15,10,8,7,0},{0,0,15,10,8,8,0},{0,0,15,10,8,9,0},{0,0,15,10,8,-1,0},{0,0,15,10,8,0,0}},
  {{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1}},
  {{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,25,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0}},
  {{0,0,26,10,8,-1,0},{0,0,25,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0}},
  {{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,25,10,8,-1,0},{0,0,25,10,8,-1,0},{0,0,25,10,8,-1,0},{0,0,25,10,8,-1,0},{0,0,25,10,8,-1,0},{0,0,25,10,8,-1,0},{0,0,25,10,8,-1,0},{0,0,25,10,8,-1,0}},
  {{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1}},
  {{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,25,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0}},
  {{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0}},
  {{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,22,10,8,-1,1},{0,0,18,10,8,-1,1},{0,0,22,10,8,-1,1},{0,0,18,10,8,-1,1},{0,0,22,10,8,-1,1},{0,0,18,10,8,-1,1},{0,0,22,10,8,-1,1},{0,0,18,10,8,-1,1},{0,0,22,10,8,-1,1},{0,0,18,10,8,-1,1},{0,0,22,10,8,-1,1},{0,0,18,10,8,-1,1},{0,0,22,10,8,-1,1},{0,0,18,10,8,-1,1},{0,0,15,10,8,1,0},{0,0,15,10,8,2,0},{0,0,15,10,8,3,0},{0,0,15,10,8,4,0},{0,0,15,10,8,5,0},{0,0,15,10,8,6,0},{0,0,15,10,8,7,0},{0,0,15,10,8,8,0},{0,0,15,10,8,9,0},{0,0,15,10,8,-1,0}},
  {{0,0,15,10,8,1,0},{0,0,15,10,8,2,0},{0,0,15,10,8,3,0},{0,0,15,10,8,4,0},{0,0,15,10,8,5,0},{0,0,15,10,8,6,0},{0,0,15,10,8,7,0},{0,0,15,10,8,8,0},{0,0,15,10,8,9,0},{0,0,15,10,8,-1,0},{0,0,15,10,8,1,0},{0,0,15,10,8,2,0},{0,0,15,10,8,3,0},{0,0,15,10,8,4,0},{0,0,15,10,8,5,0},{0,0,15,10,8,6,0},{0,0,15,10,8,7,0},{0,0,15,10,8,8,0},{0,0,15,10,8,9,0},{0,0,15,10,8,-1,0},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1}},
  {{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,22,10,8,-1,1},{0,0,18,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1}},
  {{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,22,10,8,-1,1},{0,0,18,10,8,-1,1},{0,0,22,10,8,-1,1},{0,0,18,10,8,-1,1},{0,0,22,10,8,-1,1},{0,0,18,10,8,-1,1},{0,0,22,10,8,-1,1},{0,0,18,10,8,-1,1},{0,0,22,10,8,-1,1},{0,0,18,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1}},
  {{46,0,26,0,8,-1,1},{46,0,26,0,8,-1,1},{46,0,26,0,8,-1,1},{46,0,26,0,8,-1,1},{46,0,26,0,8,-1,1},{46,0,26,0,8,-1,1},{46,0,26,0,8,-1,1},{46,0,26,0,8,-1,1},{46,0,26,0,8,-1,1},{46,0,26,0,8,-1,1},{46,0,26,0,8,-1,1},{46,0,26,0,8,-1,1},{46,0,26,0,8,-1,1},{46,0,26,0,8,-1,1},{46,0,26,0,8,-1,1},{46,0,26,0,8,-1,1},{46,0,26,0,8,-1,1},{46,0,26,0,8,-1,1},{46,0,26,0,8,-1,1},{46,0,26,0,8,-1,1},{46,0,26,0,8,-1,1},{46,0,26,0,8,-1,1},{46,0,26,0,8,-1,1},{46,0,26,0,8,-1,1},{46,0,26,0,8,-1,1},{46,0,26,0,8,-1,1},{46,0,26,0,8,-1,1},{46,0,26,0,8,-1,1},{46,0,26,0,8,-1,1},{46,0,26,0,8,-1,1},{46,0,26,0,8,-1,1},{46,0,26,0,8,-1,1}},
  {{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,22,10,8,-1,1},{0,0,18,10,8,-1,1},{0,0,22,10,8,-1,1},{0,0,18,10,8,-1,1},{0,0,22,10,8,-1,1},{0,0,18,10,8,-1,1},{0,0,22,10,8,-1,1},{0,0,18,10,8,-1,1},{0,0,22,10,8,-1,1},{0,0,18,10,8,-1,1},{0,0,22,10,8,-1,1},{0,0,18,10,8,-1,1},{0,0,22,10,8,-1,1},{0,0,18,10,8,-1,1},{0,0,22,10,8,-1,1},{0,0,18,10,8,-1,1},{0,0,22,10,8,-1,1},{0,0,18,10,8,-1,1},{0,0,22,10,8,-1,1},{0,0,18,10,8,-1,1},{0,0,22,10,8,-1,1},{0,0,18,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1}},
  {{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,22,10,8,-1,1},{0,0,18,10,8,-1,1},{0,0,22,10,8,-1,1},{0,0,18,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1}},
  {{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,22,10,8,-1,1},{0,0,18,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1}},
  {{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,9,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1}},
  {{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,9,-1,1},{0,0,25,10,9,-1,1},{0,0,25,10,9,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1}},
  {{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,9,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1}},
  {{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0}},
  {{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1}},
  {{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,25,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1}},
  {{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1}},
  {{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1}},
  {{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0}},
  {{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{61,0,2,0,12,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0}},
  {{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0}},
  {{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1}},
  {{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{56,0,9,0,7,-1,1},{61,0,2,0,12,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1}},
  {{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{56,0,5,0,7,-1,1},{61,0,2,0,12,-1,1}},
  {{25,0,9,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,9,0,3,-1,1},{25,0,9,0,3,-1,1},{25,0,9,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,9,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,9,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,5,0,3,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,9,0,4,-1,1},{25,0,9,0,4,-1,1}},
  {{7,0,9,0,7,-1,1},{7,0,5,0,7,-1,1},{7,0,9,0,7,-1,1},{7,0,5,0,7,-1,1},{7,0,9,0,7,-1,1},{7,0,5,0,7,-1,1},{7,0,9,0,7,-1,1},{7,0,5,0,7,-1,1},{7,0,9,0,7,-1,1},{7,0,5,0,7,-1,1},{7,0,9,0,7,-1,1},{7,0,5,0,7,-1,1},{7,0,9,0,7,-1,1},{7,0,5,0,7,-1,1},{7,0,9,0,7,-1,1},{7,0,5,0,7,-1,1},{7,0,9,0,7,-1,1},{7,0,5,0,7,-1,1},{7,0,9,0,7,-1,1},{7,0,5,0,7,-1,1},{7,0,9,0,7,-1,1},{7,0,5,0,7,-1,1},{7,0,9,0,7,-1,1},{7,0,5,0,7,-1,1},{7,0,9,0,7,-1,1},{7,0,5,0,7,-1,1},{7,0,9,0,7,-1,1},{7,0,5,0,7,-1,1},{7,0,9,0,7,-1,1},{7,0,5,0,7,-1,1},{7,0,9,0,7,-1,1},{7,0,5,0,7,-1,1}},
  {{7,0,9,0,7,-1,1},{7,0,5,0,7,-1,1},{7,0,9,0,7,-1,1},{7,0,5,0,7,-1,1},{7,0,5,0,7,-1,1},{7,0,26,10,8,-1,1},{7,0,26,10,8,-1,1},{7,0,26,10,8,-1,1},{7,0,26,10,8,-1,1},{7,0,26,10,8,-1,1},{7,0,26,10,8,-1,1},{7,0,9,0,7,-1,1},{7,0,5,0,7,-1,1},{7,0,9,0,7,-1,1},{7,0,5,0,7,-1,1},{7,0,12,17,7,-1,1},{7,0,12,17,7,-1,1},{7,0,12,17,7,-1,1},{7,0,9,0,7,-1,1},{7,0,5,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{7,0,21,10,8,-1,1},{7,0,21,10,8,-1,1},{7,0,21,10,8,-1,1},{7,0,21,10,8,-1,1},{7,0,15,10,8,-1,1},{7,0,21,10,8,-1,1},{7,0,21,10,8,-1,1}},
  {{12,0,5,0,4,-1,1},{12,0,5,0,4,-1,1},{12,0,5,0,4,-1,1},{12,0,5,0,4,-1,1},{12,0,5,0,4,-1,1},{12,0,5,0,4,-1,1},{12,0,5,0,4,-1,1},{12,0,5,0,4,-1,1},{12,0,5,0,4,-1,1},{12,0,5,0,4,-1,1},{12,0,5,0,4,-1,1},{12,0,5,0,4,-1,1},{12,0,5,0,4,-1,1},{12,0,5,0,4,-1,1},{12,0,5,0,4,-1,1},{12,0,5,0,4,-1,1},{12,0,5,0,4,-1,1},{12,0,5,0,4,-1,1},{12,0,5,0,4,-1,1},{12,0,5,0,4,-1,1},{12,0,5,0,4,-1,1},{12,0,5,0,4,-1,1},{12,0,5,0,4,-1,1},{12,0,5,0,4,-1,1},{12,0,5,0,4,-1,1},{12,0,5,0,4,-1,1},{12,0,5,0,4,-1,1},{12,0,5,0,4,-1,1},{12,0,5,0,4,-1,1},{12,0,5,0,4,-1,1},{12,0,5,0,4,-1,1},{12,0,5,0,4,-1,1}},
  {{12,0,5,0,4,-1,1},{12,0,5,0,4,-1,1},{12,0,5,0,4,-1,1},{12,0,5,0,4,-1,1},{12,0,5,0,4,-1,1},{12,0,5,0,4,-1,1},{61,0,2,0,12,-1,1},{12,0,5,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{12,0,5,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1}},
  {{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1}},
  {{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{57,0,7,0,5,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{57,0,6,0,9,-1,1},{57,0,21,0,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{57,0,12,17,5,-1,1}},
  {{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{61,0,2,0,12,-1,1}},
  {{8,0,12,17,4,-1,1},{8,0,12,17,4,-1,1},{8,0,12,17,4,-1,1},{8,0,12,17,4,-1,1},{8,0,12,17,4,-1,1},{8,0,12,17,4,-1,1},{8,0,12,17,4,-1,1},{8,0,12,17,4,-1,1},{8,0,12,17,4,-1,1},{8,0,12,17,4,-1,1},{8,0,12,17,4,-1,1},{8,0,12,17,4,-1,1},{8,0,12,17,4,-1,1},{8,0,12,17,4,-1,1},{8,0,12,17,4,-1,1},{8,0,12,17,4,-1,1},{8,0,12,17,4,-1,1},{8,0,12,17,4,-1,1},{8,0,12,17,4,-1,1},{8,0,12,17,4,-1,1},{8,0,12,17,4,-1,1},{8,0,12,17,4,-1,1},{8,0,12,17,4,-1,1},{8,0,12,17,4,-1,1},{8,0,12,17,4,-1,1},{8,0,12,17,4,-1,1},{8,0,12,17,4,-1,1},{8,0,12,17,4,-1,1},{8,0,12,17,4,-1,1},{8,0,12,17,4,-1,1},{8,0,12,17,4,-1,1},{8,0,12,17,4,-1,1}},
  {{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,20,10,8,-1,1},{0,0,19,10,8,-1,1},{0,0,20,10,8,-1,1},{0,0,19,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,20,10,8,-1,1},{0,0,19,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,20,10,8,-1,1},{0,0,19,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,17,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,17,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,20,10,8,-1,1},{0,0,19,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1}},
  {{0,0,20,10,8,-1,1},{0,0,19,10,8,-1,1},{0,0,22,10,8,-1,1},{0,0,18,10,8,-1,1},{0,0,22,10,8,-1,1},{0,0,18,10,8,-1,1},{0,0,22,10,8,-1,1},{0,0,18,10,8,-1,1},{0,0,22,10,8,-1,1},{0,0,18,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,6,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,17,10,8,-1,1},{0,0,17,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,10,8,-1,1}},
  {{0,0,17,10,8,-1,1},{0,0,21,10,8,-1,1},{0,0,22,10,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{61,0,2,0,12,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,9,-1,0}},
  {{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0}},
  {{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,8,-1,0},{17,0,26,10,9,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0}},
  {{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0}},
  {{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{17,0,26,10,9,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0}},
  {{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0}},
  {{0,0,29,9,9,-1,0},{0,0,21,10,8,-1,2},{0,0,21,10,8,-1,2},{0,0,21,10,8,-1,0},{0,0,26,10,8,-1,0},{17,0,6,0,0,-1,0},{0,0,7,0,0,-1,0},{17,0,14,0,0,-1,0},{0,0,22,10,8,-1,3},{0,0,18,10,8,-1,3},{0,0,22,10,8,-1,3},{0,0,18,10,8,-1,3},{0,0,22,10,8,-1,3},{0,0,18,10,8,-1,3},{0,0,22,10,8,-1,3},{0,0,18,10,8,-1,3},{0,0,22,10,8,-1,3},{0,0,18,10,8,-1,3},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,22,10,8,-1,3},{0,0,18,10,8,-1,3},{0,0,22,10,8,-1,3},{0,0,18,10,8,-1,3},{0,0,22,10,8,-1,3},{0,0,18,10,8,-1,3},{0,0,22,10,8,-1,3},{0,0,18,10,8,-1,3},{0,0,17,10,8,-1,3},{0,0,22,10,8,-1,3},{0,0,18,10,8,-1,3},{0,0,18,10,8,-1,3}},
  {{0,0,26,10,8,-1,0},{17,0,14,0,3,-1,0},{17,0,14,0,3,-1,0},{17,0,14,0,3,-1,0},{17,0,14,0,3,-1,0},{17,0,14,0,3,-1,0},{17,0,14,0,3,-1,0},{17,0,14,0,3,-1,0},{17,0,14,0,3,-1,0},{17,0,14,0,3,-1,0},{1,0,12,17,3,-1,0},{1,0,12,17,3,-1,0},{1,0,12,17,3,-1,0},{1,0,12,17,3,-1,0},{18,0,10,0,4,-1,0},{18,0,10,0,4,-1,0},{0,0,17,10,8,-1,3},{0,0,6,0,3,-1,0},{0,0,6,0,3,-1,0},{0,0,6,0,3,-1,0},{0,0,6,0,3,-1,0},{0,0,6,0,3,-1,0},{0,0,26,10,9,-1,0},{0,0,26,10,8,-1,0},{17,0,14,0,9,-1,0},{17,0,14,0,9,-1,0},{17,0,14,0,9,-1,0},{17,0,6,0,3,-1,0},{0,0,7,0,3,-1,0},{0,0,21,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0}},
  {{61,0,2,0,12,-1,0},{20,0,7,0,0,-1,2},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,2},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,2},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,2},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,2},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0}},
  {{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,2},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0}},
  {{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,2},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,2},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,2},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,2},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,0},{20,0,7,0,0,-1,2},{20,0,7,0,0,-1,2},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{1,0,12,17,0,-1,0},{1,0,12,17,0,-1,0},{0,0,24,10,9,-1,2},{0,0,24,10,9,-1,2},{20,0,6,0,0,-1,0},{20,0,6,0,0,-1,0},{20,0,7,0,9,-1,0}},
  {{0,0,17,10,1,-1,3},{22,0,7,0,0,-1,2},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,2},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,2},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,2},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,2},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0}},
  {{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,2},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0}},
  {{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,2},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,2},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,2},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,2},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,2},{22,0,7,0,0,-1,2},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{22,0,7,0,0,-1,0},{0,0,21,10,1,-1,0},{0,0,6,0,0,-1,3},{22,0,6,0,0,-1,0},{22,0,6,0,0,-1,0},{22,0,7,0,9,-1,0}},
  {{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0}},
  {{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,2},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0}},
  {{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0}},
  {{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,10,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0}},
  {{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{18,0,7,0,9,-1,0},{61,0,2,0,12,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,15,0,9,-1,0},{0,0,15,0,9,-1,0},{0,0,15,0,9,-1,0},{0,0,15,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0}},
  {{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{5,0,7,0,0,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0}},
  {{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{22,0,7,0,3,-1,2},{22,0,7,0,3,-1,2},{22,0,7,0,3,-1,2},{22,0,7,0,3,-1,2},{22,0,7,0,3,-1,2},{22,0,7,0,3,-1,2},{22,0,7,0,3,-1,2},{22,0,7,0,3,-1,2},{22,0,7,0,3,-1,2},{22,0,7,0,3,-1,2},{22,0,7,0,3,-1,2},{22,0,7,0,3,-1,2},{22,0,7,0,3,-1,2},{22,0,7,0,3,-1,2},{22,0,7,0,3,-1,2},{22,0,7,0,3,-1,2}},
  {{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,10,9,-1,0},{18,0,26,10,9,-1,0},{61,0,2,0,12,-1,0}},
  {{0,0,15,0,9,-1,0},{0,0,15,0,9,-1,0},{0,0,15,0,9,-1,0},{0,0,15,0,9,-1,0},{0,0,15,0,9,-1,0},{0,0,15,0,9,-1,0},{0,0,15,0,9,-1,0},{0,0,15,0,9,-1,0},{0,0,15,0,9,-1,0},{0,0,15,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0}},
  {{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,15,0,8,-1,0},{0,0,15,0,8,-1,0},{0,0,15,0,8,-1,0},{0,0,15,0,8,-1,0},{0,0,15,0,8,-1,0},{0,0,15,0,8,-1,0},{0,0,15,0,8,-1,0},{0,0,15,0,8,-1,0},{0,0,26,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0}},
  {{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,0,9,-1,0},{18,0,26,10,9,-1,0},{18,0,26,10,9,-1,0},{18,0,26,10,9,-1,0},{0,0,26,0,8,-1,0}},
  {{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0},{0,0,15,10,9,-1,0}},
  {{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,10,9,-1,0},{0,0,26,10,9,-1,0},{0,0,26,10,9,-1,0},{0,0,26,10,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0}},
  {{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{22,0,26,0,9,-1,0},{61,0,2,0,12,-1,0}},
  {{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2}},
  {{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{22,0,26,0,9,-1,2},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0}},
  {{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,10,9,-1,0},{0,0,26,10,9,-1,0},{0,0,26,10,9,-1,0},{0,0,26,10,9,-1,0},{0,0,26,0,9,-1,2},{0,0,26,0,9,-1,2},{0,0,26,0,9,-1,2},{0,0,26,0,9,-1,2},{0,0,26,0,9,-1,2}},
  {{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,10,9,-1,0},{0,0,26,10,9,-1,0}},
  {{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,10,9,-1,0}},
  {{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0}},
  {{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0}},
  {{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0}},
  {{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,6,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0}},
  {{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0}},
  {{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{41,0,7,0,5,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0}},
  {{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0}},
  {{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{41,0,26,10,8,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{86,0,7,0,6,-1,1},{86,0,7,0,6,-1,1},{86,0,7,0,6,-1,1},{86,0,7,0,6,-1,1},{86,0,7,0,6,-1,1},{86,0,7,0,6,-1,1},{86,0,7,0,6,-1,1},{86,0,7,0,6,-1,1},{86,0,7,0,6,-1,1},{86,0,7,0,6,-1,1},{86,0,7,0,6,-1,1},{86,0,7,0,6,-1,1},{86,0,7,0,6,-1,1},{86,0,7,0,6,-1,1},{86,0,7,0,6,-1,1},{86,0,7,0,6,-1,1}},
  {{86,0,7,0,6,-1,1},{86,0,7,0,6,-1,1},{86,0,7,0,6,-1,1},{86,0,7,0,6,-1,1},{86,0,7,0,6,-1,1},{86,0,7,0,6,-1,1},{86,0,7,0,6,-1,1},{86,0,7,0,6,-1,1},{86,0,7,0,6,-1,1},{86,0,7,0,6,-1,1},{86,0,7,0,6,-1,1},{86,0,7,0,6,-1,1},{86,0,7,0,6,-1,1},{86,0,7,0,6,-1,1},{86,0,7,0,6,-1,1},{86,0,7,0,6,-1,1},{86,0,7,0,6,-1,1},{86,0,7,0,6,-1,1},{86,0,7,0,6,-1,1},{86,0,7,0,6,-1,1},{86,0,7,0,6,-1,1},{86,0,7,0,6,-1,1},{86,0,7,0,6,-1,1},{86,0,7,0,6,-1,1},{86,0,6,0,6,-1,1},{86,0,6,0,6,-1,1},{86,0,6,0,6,-1,1},{86,0,6,0,6,-1,1},{86,0,6,0,6,-1,1},{86,0,6,0,6,-1,1},{86,0,21,0,8,-1,1},{86,0,21,0,8,-1,1}},
  {{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1}},
  {{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,6,0,6,-1,1},{74,0,21,10,8,-1,1},{74,0,21,10,8,-1,1},{74,0,21,10,8,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1}},
  {{74,0,13,0,6,0,1},{74,0,13,0,6,1,1},{74,0,13,0,6,2,1},{74,0,13,0,6,3,1},{74,0,13,0,6,4,1},{74,0,13,0,6,5,1},{74,0,13,0,6,6,1},{74,0,13,0,6,7,1},{74,0,13,0,6,8,1},{74,0,13,0,6,9,1},{74,0,7,0,6,-1,1},{74,0,7,0,6,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{8,0,9,0,0,-1,1},{8,0,5,0,0,-1,1},{8,0,9,0,4,-1,1},{8,0,5,0,4,-1,1},{8,0,9,0,4,-1,1},{8,0,5,0,4,-1,1},{8,0,9,0,4,-1,1},{8,0,5,0,4,-1,1},{8,0,9,0,4,-1,1},{8,0,5,0,4,-1,1},{8,0,9,0,4,-1,1},{8,0,5,0,4,-1,1},{8,0,9,0,4,-1,1},{8,0,5,0,4,-1,1},{8,0,7,0,4,-1,1},{8,0,12,17,2,-1,1},{8,0,11,17,8,-1,1},{8,0,11,17,8,-1,1},{8,0,11,17,8,-1,1},{8,0,21,10,8,-1,1},{8,0,12,17,0,-1,1},{8,0,12,17,0,-1,1},{8,0,12,17,0,-1,1},{8,0,12,17,0,-1,1},{8,0,12,17,0,-1,1},{8,0,12,17,0,-1,1},{8,0,12,17,0,-1,1},{8,0,12,17,0,-1,1},{8,0,12,17,2,-1,1},{8,0,12,17,2,-1,1},{8,0,21,10,8,-1,1},{8,0,6,10,0,-1,1}},
  {{8,0,9,0,4,-1,1},{8,0,5,0,4,-1,1},{8,0,9,0,4,-1,1},{8,0,5,0,4,-1,1},{8,0,9,0,4,-1,1},{8,0,5,0,4,-1,1},{8,0,9,0,4,-1,1},{8,0,5,0,4,-1,1},{8,0,9,0,4,-1,1},{8,0,5,0,4,-1,1},{8,0,9,0,4,-1,1},{8,0,5,0,4,-1,1},{8,0,9,0,4,-1,1},{8,0,5,0,4,-1,1},{8,0,9,0,4,-1,1},{8,0,5,0,4,-1,1},{8,0,9,0,4,-1,1},{8,0,5,0,4,-1,1},{8,0,9,0,4,-1,1},{8,0,5,0,4,-1,1},{8,0,9,0,4,-1,1},{8,0,5,0,4,-1,1},{8,0,9,0,4,-1,1},{8,0,5,0,4,-1,1},{8,0,9,0,4,-1,1},{8,0,5,0,4,-1,1},{8,0,9,0,4,-1,1},{8,0,5,0,4,-1,1},{8,0,6,0,9,-1,1},{8,0,6,0,9,-1,1},{8,0,12,17,2,-1,1},{8,0,12,17,0,-1,1}},
  {{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1}},
  {{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,14,0,6,-1,1},{79,0,14,0,6,-1,1},{79,0,14,0,6,-1,1},{79,0,14,0,6,-1,1},{79,0,14,0,6,-1,1},{79,0,14,0,6,-1,1},{79,0,14,0,6,-1,1},{79,0,14,0,6,-1,1},{79,0,14,0,6,-1,1},{79,0,14,0,6,-1,1},{79,0,12,17,6,-1,1},{79,0,12,17,6,-1,1},{79,0,21,0,8,-1,1},{79,0,21,0,8,-1,1},{79,0,21,0,8,-1,1},{79,0,21,0,8,-1,1},{79,0,21,0,8,-1,1},{79,0,21,0,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{0,0,6,10,0,-1,1},{0,0,6,10,0,-1,1},{0,0,6,10,0,-1,1},{0,0,6,10,0,-1,1},{0,0,6,10,0,-1,1},{0,0,6,10,0,-1,1},{0,0,6,10,0,-1,1},{0,0,6,10,0,-1,1},{0,0,6,10,0,-1,1}},
  {{0,0,24,10,8,-1,1},{0,0,24,10,8,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1}},
  {{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1}},
  {{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,6,0,9,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1}},
  {{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{0,0,6,10,0,-1,1},{0,0,24,0,8,-1,1},{0,0,24,0,8,-1,1},{25,0,9,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,7,0,2,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,5,0,4,-1,1}},
  {{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,5,0,0,-1,1},{25,0,9,0,0,-1,1},{25,0,9,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,9,0,4,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{25,0,9,0,4,-1,1},{25,0,9,0,4,-1,1},{25,0,9,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,9,0,2,-1,1},{25,0,5,0,2,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{25,0,7,0,4,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,5,0,0,-1,1},{25,0,7,0,4,-1,1},{25,0,7,0,4,-1,1},{25,0,7,0,4,-1,1},{25,0,7,0,4,-1,1},{25,0,7,0,4,-1,1}},
  {{58,0,7,0,6,-1,1},{58,0,7,0,6,-1,1},{58,0,12,17,6,-1,1},{58,0,7,0,6,-1,1},{58,0,7,0,6,-1,1},{58,0,7,0,6,-1,1},{58,0,12,17,6,-1,1},{58,0,7,0,6,-1,1},{58,0,7,0,6,-1,1},{58,0,7,0,6,-1,1},{58,0,7,0,6,-1,1},{58,0,12,17,6,-1,1},{58,0,7,0,6,-1,1},{58,0,7,0,6,-1,1},{58,0,7,0,6,-1,1},{58,0,7,0,6,-1,1},{58,0,7,0,6,-1,1},{58,0,7,0,6,-1,1},{58,0,7,0,6,-1,1},{58,0,7,0,6,-1,1},{58,0,7,0,6,-1,1},{58,0,7,0,6,-1,1},{58,0,7,0,6,-1,1},{58,0,7,0,6,-1,1},{58,0,7,0,6,-1,1},{58,0,7,0,6,-1,1},{58,0,7,0,6,-1,1},{58,0,7,0,6,-1,1},{58,0,7,0,6,-1,1},{58,0,7,0,6,-1,1},{58,0,7,0,6,-1,1},{58,0,7,0,6,-1,1}},
  {{58,0,7,0,6,-1,1},{58,0,7,0,6,-1,1},{58,0,7,0,6,-1,1},{58,0,10,0,6,-1,1},{58,0,10,0,6,-1,1},{58,0,12,17,6,-1,1},{58,0,12,17,6,-1,1},{58,0,10,0,6,-1,1},{58,0,26,10,8,-1,1},{58,0,26,10,8,-1,1},{58,0,26,10,8,-1,1},{58,0,26,10,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,23,4,8,-1,1},{0,0,26,4,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1}},
  {{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,7,0,7,-1,1},{65,0,21,10,8,-1,1},{65,0,21,10,8,-1,1},{65,0,21,10,8,-1,1},{65,0,21,10,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{71,0,10,0,6,-1,1},{71,0,10,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1}},
  {{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,7,0,6,-1,1},{71,0,10,0,6,-1,1},{71,0,10,0,6,-1,1},{71,0,10,0,6,-1,1},{71,0,10,0,6,-1,1},{71,0,10,0,6,-1,1},{71,0,10,0,6,-1,1},{71,0,10,0,6,-1,1},{71,0,10,0,6,-1,1},{71,0,10,0,6,-1,1},{71,0,10,0,6,-1,1},{71,0,10,0,6,-1,1},{71,0,10,0,6,-1,1}},
  {{71,0,10,0,6,-1,1},{71,0,10,0,6,-1,1},{71,0,10,0,6,-1,1},{71,0,10,0,6,-1,1},{71,0,12,17,6,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{71,0,21,0,8,-1,1},{71,0,21,0,8,-1,1},{71,0,13,0,6,0,1},{71,0,13,0,6,1,1},{71,0,13,0,6,2,1},{71,0,13,0,6,3,1},{71,0,13,0,6,4,1},{71,0,13,0,6,5,1},{71,0,13,0,6,6,1},{71,0,13,0,6,7,1},{71,0,13,0,6,8,1},{71,0,13,0,6,9,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{10,0,12,17,4,-1,1},{10,0,12,17,4,-1,1},{10,0,12,17,4,-1,1},{10,0,12,17,4,-1,1},{10,0,12,17,4,-1,1},{10,0,12,17,4,-1,1},{10,0,12,17,4,-1,1},{10,0,12,17,4,-1,1},{10,0,12,17,4,-1,1},{10,0,12,17,4,-1,1},{10,0,12,17,4,-1,1},{10,0,12,17,4,-1,1},{10,0,12,17,4,-1,1},{10,0,12,17,4,-1,1},{10,0,12,17,4,-1,1},{10,0,12,17,4,-1,1},{10,0,12,17,4,-1,1},{10,0,12,17,4,-1,1},{10,0,7,0,4,-1,1},{10,0,7,0,4,-1,1},{10,0,7,0,4,-1,1},{10,0,7,0,4,-1,1},{10,0,7,0,4,-1,1},{10,0,7,0,4,-1,1},{10,0,21,0,8,-1,1},{10,0,21,0,8,-1,1},{10,0,21,0,8,-1,1},{10,0,7,0,4,-1,1},{10,0,21,0,8,-1,1},{10,0,7,0,4,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{67,0,13,0,6,0,1},{67,0,13,0,6,1,1},{67,0,13,0,6,2,1},{67,0,13,0,6,3,1},{67,0,13,0,6,4,1},{67,0,13,0,6,5,1},{67,0,13,0,6,6,1},{67,0,13,0,6,7,1},{67,0,13,0,6,8,1},{67,0,13,0,6,9,1},{67,0,7,0,6,-1,1},{67,0,7,0,6,-1,1},{67,0,7,0,6,-1,1},{67,0,7,0,6,-1,1},{67,0,7,0,6,-1,1},{67,0,7,0,6,-1,1},{67,0,7,0,6,-1,1},{67,0,7,0,6,-1,1},{67,0,7,0,6,-1,1},{67,0,7,0,6,-1,1},{67,0,7,0,6,-1,1},{67,0,7,0,6,-1,1},{67,0,7,0,6,-1,1},{67,0,7,0,6,-1,1},{67,0,7,0,6,-1,1},{67,0,7,0,6,-1,1},{67,0,7,0,6,-1,1},{67,0,7,0,6,-1,1},{67,0,7,0,6,-1,1},{67,0,7,0,6,-1,1},{67,0,7,0,6,-1,1},{67,0,7,0,6,-1,1}},
  {{67,0,7,0,6,-1,1},{67,0,7,0,6,-1,1},{67,0,7,0,6,-1,1},{67,0,7,0,6,-1,1},{67,0,7,0,6,-1,1},{67,0,7,0,6,-1,1},{67,0,12,17,6,-1,1},{67,0,12,17,6,-1,1},{67,0,12,17,6,-1,1},{67,0,12,17,6,-1,1},{67,0,12,17,6,-1,1},{67,0,12,17,6,-1,1},{67,0,12,17,6,-1,1},{67,0,12,17,6,-1,1},{0,0,21,0,8,-1,1},{67,0,21,0,8,-1,1},{69,0,7,0,7,-1,1},{69,0,7,0,7,-1,1},{69,0,7,0,7,-1,1},{69,0,7,0,7,-1,1},{69,0,7,0,7,-1,1},{69,0,7,0,7,-1,1},{69,0,7,0,7,-1,1},{69,0,7,0,7,-1,1},{69,0,7,0,7,-1,1},{69,0,7,0,7,-1,1},{69,0,7,0,7,-1,1},{69,0,7,0,7,-1,1},{69,0,7,0,7,-1,1},{69,0,7,0,7,-1,1},{69,0,7,0,7,-1,1},{69,0,7,0,7,-1,1}},
  {{69,0,7,0,7,-1,1},{69,0,7,0,7,-1,1},{69,0,7,0,7,-1,1},{69,0,7,0,7,-1,1},{69,0,7,0,7,-1,1},{69,0,7,0,7,-1,1},{69,0,7,0,7,-1,1},{69,0,12,17,7,-1,1},{69,0,12,17,7,-1,1},{69,0,12,17,7,-1,1},{69,0,12,17,7,-1,1},{69,0,12,17,7,-1,1},{69,0,12,17,7,-1,1},{69,0,12,17,7,-1,1},{69,0,12,17,7,-1,1},{69,0,12,17,7,-1,1},{69,0,12,17,7,-1,1},{69,0,12,17,7,-1,1},{69,0,10,0,7,-1,1},{69,0,10,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{69,0,21,0,8,-1,1}},
  {{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0}},
  {{84,0,12,17,6,-1,1},{84,0,12,17,6,-1,1},{84,0,12,17,6,-1,1},{84,0,10,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1}},
  {{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,7,0,6,-1,1},{84,0,12,17,6,-1,1},{84,0,10,0,6,-1,1},{84,0,10,0,6,-1,1},{84,0,12,17,6,-1,1},{84,0,12,17,6,-1,1},{84,0,12,17,6,-1,1},{84,0,12,17,6,-1,1},{84,0,10,0,6,-1,1},{84,0,10,0,6,-1,1},{84,0,12,17,6,-1,1},{84,0,10,0,6,-1,1},{84,0,10,0,6,-1,1},{84,0,10,0,6,-1,1}},
  {{84,0,10,0,6,-1,1},{84,0,21,0,8,-1,1},{84,0,21,0,8,-1,1},{84,0,21,0,8,-1,1},{84,0,21,0,8,-1,1},{84,0,21,0,8,-1,1},{84,0,21,0,8,-1,1},{84,0,21,0,8,-1,1},{84,0,21,0,8,-1,1},{84,0,21,0,8,-1,1},{84,0,21,0,8,-1,1},{84,0,21,0,8,-1,1},{84,0,21,0,8,-1,1},{84,0,21,0,8,-1,1},{61,0,2,0,12,-1,1},{0,0,6,0,7,-1,1},{84,0,13,0,6,0,1},{84,0,13,0,6,1,1},{84,0,13,0,6,2,1},{84,0,13,0,6,3,1},{84,0,13,0,6,4,1},{84,0,13,0,6,5,1},{84,0,13,0,6,6,1},{84,0,13,0,6,7,1},{84,0,13,0,6,8,1},{84,0,13,0,6,9,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{84,0,21,0,8,-1,1},{84,0,21,0,8,-1,1}},
  {{28,0,7,0,4,-1,1},{28,0,7,0,4,-1,1},{28,0,7,0,4,-1,1},{28,0,7,0,4,-1,1},{28,0,7,0,4,-1,1},{28,0,12,17,4,-1,1},{28,0,6,0,4,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,13,0,0,0,1},{28,0,13,0,0,1,1},{28,0,13,0,0,2,1},{28,0,13,0,0,3,1},{28,0,13,0,0,4,1},{28,0,13,0,0,5,1},{28,0,13,0,0,6,1},{28,0,13,0,0,7,1},{28,0,13,0,0,8,1},{28,0,13,0,0,9,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{61,0,2,0,12,-1,1}},
  {{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1}},
  {{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,12,17,6,-1,1},{72,0,12,17,6,-1,1},{72,0,12,17,6,-1,1},{72,0,12,17,6,-1,1},{72,0,12,17,6,-1,1},{72,0,12,17,6,-1,1},{72,0,10,0,6,-1,1},{72,0,10,0,6,-1,1},{72,0,12,17,6,-1,1},{72,0,12,17,6,-1,1},{72,0,10,0,6,-1,1},{72,0,10,0,6,-1,1},{72,0,12,17,6,-1,1},{72,0,12,17,6,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,12,17,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,7,0,6,-1,1},{72,0,12,17,6,-1,1},{72,0,10,0,6,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{72,0,13,0,6,0,1},{72,0,13,0,6,1,1},{72,0,13,0,6,2,1},{72,0,13,0,6,3,1},{72,0,13,0,6,4,1},{72,0,13,0,6,5,1},{72,0,13,0,6,6,1},{72,0,13,0,6,7,1},{72,0,13,0,6,8,1},{72,0,13,0,6,9,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{72,0,21,0,8,-1,1},{72,0,21,0,8,-1,1},{72,0,21,0,8,-1,1},{72,0,21,0,8,-1,1}},
  {{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,6,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,26,0,8,-1,1},{28,0,26,0,8,-1,1},{28,0,26,0,8,-1,1},{28,0,7,0,0,-1,1},{28,0,10,0,0,-1,1},{28,0,12,17,0,-1,1},{28,0,10,0,0,-1,1},{28,0,7,0,0,-1,1},{28,0,7,0,0,-1,1}},
  {{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1}},
  {{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,12,17,6,-1,1},{92,0,7,0,6,-1,1},{92,0,12,17,6,-1,1},{92,0,12,17,6,-1,1},{92,0,12,17,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,12,17,6,-1,1},{92,0,12,17,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,12,17,6,-1,1},{92,0,12,17,6,-1,1}},
  {{92,0,7,0,6,-1,1},{92,0,12,17,6,-1,1},{92,0,7,0,6,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{92,0,7,0,6,-1,1},{92,0,7,0,6,-1,1},{92,0,6,0,6,-1,1},{92,0,21,0,8,-1,1},{92,0,21,0,8,-1,1}},
  {{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,10,0,6,-1,1},{87,0,12,17,6,-1,1},{87,0,12,17,6,-1,1},{87,0,10,0,6,-1,1},{87,0,10,0,6,-1,1},{87,0,21,0,8,-1,1},{87,0,21,0,8,-1,1},{87,0,7,0,6,-1,1},{87,0,6,0,6,-1,1},{87,0,6,0,6,-1,1},{87,0,10,0,6,-1,1},{87,0,12,17,6,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{61,0,2,0,12,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{11,0,7,0,0,-1,1},{61,0,2,0,12,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1}},
  {{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{25,0,5,0,4,-1,1},{0,0,24,0,8,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1},{25,0,6,0,9,-1,1}},
  {{25,0,5,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,5,0,2,-1,1},{25,0,5,0,4,-1,1},{14,0,5,0,4,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1}},
  {{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1},{6,0,5,0,6,-1,1}},
  {{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1}},
  {{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,7,0,6,-1,1},{87,0,10,0,6,-1,1},{87,0,10,0,6,-1,1},{87,0,12,17,6,-1,1},{87,0,10,0,6,-1,1},{87,0,10,0,6,-1,1},{87,0,12,17,6,-1,1},{87,0,10,0,6,-1,1},{87,0,10,0,6,-1,1},{87,0,21,0,8,-1,1},{87,0,10,0,6,-1,1},{87,0,12,17,6,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{87,0,13,0,6,0,1},{87,0,13,0,6,1,1},{87,0,13,0,6,2,1},{87,0,13,0,6,3,1},{87,0,13,0,6,4,1},{87,0,13,0,6,5,1},{87,0,13,0,6,6,1},{87,0,13,0,6,7,1},{87,0,13,0,6,8,1},{87,0,13,0,6,9,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{18,0,7,0,0,-1,0},{18,0,7,0,0,-1,0},{18,0,7,0,0,-1,0},{18,0,7,0,0,-1,0},{18,0,7,0,0,-1,0},{18,0,7,0,0,-1,0},{18,0,7,0,0,-1,0},{18,0,7,0,0,-1,0},{18,0,7,0,0,-1,0},{18,0,7,0,0,-1,0},{18,0,7,0,0,-1,0},{18,0,7,0,0,-1,0},{18,0,7,0,0,-1,0},{18,0,7,0,0,-1,0},{18,0,7,0,0,-1,0},{18,0,7,0,0,-1,0},{18,0,7,0,0,-1,0},{18,0,7,0,0,-1,0},{18,0,7,0,0,-1,0},{18,0,7,0,0,-1,0},{18,0,7,0,0,-1,0},{18,0,7,0,0,-1,0},{18,0,7,0,0,-1,0},{18,0,7,0,0,-1,0},{18,0,7,0,0,-1,0},{18,0,7,0,0,-1,0},{18,0,7,0,0,-1,0},{18,0,7,0,0,-1,0},{18,0,7,0,0,-1,0},{18,0,7,0,0,-1,0},{18,0,7,0,0,-1,0},{18,0,7,0,0,-1,0}},
  {{18,0,7,0,0,-1,0},{18,0,7,0,0,-1,0},{18,0,7,0,0,-1,0},{18,0,7,0,0,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0}},
  {{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0}},
  {{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{18,0,7,0,4,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0}},
  {{61,0,4,0,12,-1,1},{61,0,4,0,12,-1,1},{61,0,4,0,12,-1,1},{61,0,4,0,12,-1,1},{61,0,4,0,12,-1,1},{61,0,4,0,12,-1,1},{61,0,4,0,12,-1,1},{61,0,4,0,12,-1,1},{61,0,4,0,12,-1,1},{61,0,4,0,12,-1,1},{61,0,4,0,12,-1,1},{61,0,4,0,12,-1,1},{61,0,4,0,12,-1,1},{61,0,4,0,12,-1,1},{61,0,4,0,12,-1,1},{61,0,4,0,12,-1,1},{61,0,4,0,12,-1,1},{61,0,4,0,12,-1,1},{61,0,4,0,12,-1,1},{61,0,4,0,12,-1,1},{61,0,4,0,12,-1,1},{61,0,4,0,12,-1,1},{61,0,4,0,12,-1,1},{61,0,4,0,12,-1,1},{61,0,4,0,12,-1,1},{61,0,4,0,12,-1,1},{61,0,4,0,12,-1,1},{61,0,4,0,12,-1,1},{61,0,4,0,12,-1,1},{61,0,4,0,12,-1,1},{61,0,4,0,12,-1,1},{61,0,4,0,12,-1,1}},
  {{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0}},
  {{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0}},
  {{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,0,-1,0}},
  {{17,0,7,0,9,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0}},
  {{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0}},
  {{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0}},
  {{25,0,5,0,9,-1,1},{25,0,5,0,9,-1,1},{25,0,5,0,9,-1,1},{25,0,5,0,9,-1,1},{25,0,5,0,9,-1,1},{25,0,5,0,9,-1,1},{25,0,5,0,9,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{3,0,5,0,9,-1,1},{3,0,5,0,9,-1,1},{3,0,5,0,9,-1,1},{3,0,5,0,9,-1,1},{3,0,5,0,9,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{19,0,7,1,9,-1,1},{19,0,12,17,3,-1,1},{19,0,7,1,9,-1,1}},
  {{19,0,7,1,9,-1,1},{19,0,7,1,9,-1,1},{19,0,7,1,9,-1,1},{19,0,7,1,9,-1,1},{19,0,7,1,9,-1,1},{19,0,7,1,9,-1,1},{19,0,7,1,9,-1,1},{19,0,7,1,9,-1,1},{19,0,7,1,9,-1,1},{19,0,25,3,9,-1,1},{19,0,7,1,9,-1,1},{19,0,7,1,9,-1,1},{19,0,7,1,9,-1,1},{19,0,7,1,9,-1,1},{19,0,7,1,9,-1,1},{19,0,7,1,9,-1,1},{19,0,7,1,9,-1,1},{19,0,7,1,9,-1,1},{19,0,7,1,9,-1,1},{19,0,7,1,9,-1,1},{19,0,7,1,9,-1,1},{19,0,7,1,9,-1,1},{19,0,7,1,9,-1,1},{61,0,2,1,12,-1,1},{19,0,7,1,9,-1,1},{19,0,7,1,9,-1,1},{19,0,7,1,9,-1,1},{19,0,7,1,9,-1,1},{19,0,7,1,9,-1,1},{61,0,2,1,12,-1,1},{19,0,7,1,9,-1,1},{61,0,2,1,12,-1,1}},
  {{19,0,7,1,9,-1,1},{19,0,7,1,9,-1,1},{61,0,2,1,12,-1,1},{19,0,7,1,9,-1,1},{19,0,7,1,9,-1,1},{61,0,2,1,12,-1,1},{19,0,7,1,9,-1,1},{19,0,7,1,9,-1,1},{19,0,7,1,9,-1,1},{19,0,7,1,9,-1,1},{19,0,7,1,9,-1,1},{19,0,7,1,9,-1,1},{19,0,7,1,9,-1,1},{19,0,7,1,9,-1,1},{19,0,7,1,9,-1,1},{19,0,7,1,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1}},
  {{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1}},
  {{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,24,13,8,-1,1},{2,0,24,13,8,-1,1},{2,0,24,13,8,-1,1},{2,0,24,13,8,-1,1},{2,0,24,13,8,-1,1},{2,0,24,13,8,-1,1},{2,0,24,13,8,-1,1},{2,0,24,13,8,-1,1},{2,0,24,13,8,-1,1},{2,0,24,13,8,-1,1},{2,0,24,13,8,-1,1},{2,0,24,13,8,-1,1},{2,0,24,13,8,-1,1},{2,0,24,13,8,-1,1}},
  {{2,0,24,13,8,-1,1},{2,0,24,13,8,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1}},
  {{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{0,0,18,10,8,-1,1},{0,0,22,10,8,-1,1}},
  {{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1}},
  {{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1}},
  {{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,23,13,9,-1,1},{2,0,26,10,8,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1}},
  {{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{0,0,21,10,9,-1,0},{0,0,21,10,9,-1,0},{0,0,21,10,9,-1,0},{0,0,21,10,9,-1,0},{0,0,21,10,9,-1,0},{0,0,21,10,9,-1,0},{0,0,21,10,9,-1,0},{0,0,22,10,9,-1,0},{0,0,18,10,9,-1,0},{0,0,21,10,9,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0}},
  {{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{1,0,12,17,3,-1,1},{8,0,12,17,3,-1,1},{8,0,12,17,3,-1,1},{0,0,21,10,9,-1,0},{0,0,17,10,9,-1,0},{0,0,17,10,9,-1,0},{0,0,16,10,9,-1,0},{0,0,16,10,9,-1,0},{0,0,22,10,9,-1,0},{0,0,18,10,9,-1,0},{0,0,22,10,9,-1,0},{0,0,18,10,9,-1,0},{0,0,22,10,9,-1,0},{0,0,18,10,9,-1,0},{0,0,22,10,9,-1,0},{0,0,18,10,9,-1,0},{0,0,22,10,9,-1,0},{0,0,18,10,9,-1,0},{0,0,22,10,9,-1,0}},
  {{0,0,18,10,9,-1,0},{0,0,22,10,9,-1,0},{0,0,18,10,9,-1,0},{0,0,22,10,9,-1,0},{0,0,18,10,9,-1,0},{0,0,21,10,8,-1,0},{0,0,21,10,8,-1,0},{0,0,22,10,9,-1,0},{0,0,18,10,9,-1,0},{0,0,21,10,9,-1,1},{0,0,21,10,9,-1,1},{0,0,21,10,9,-1,1},{0,0,21,10,9,-1,1},{0,0,16,10,9,-1,1},{0,0,16,10,9,-1,1},{0,0,16,10,9,-1,1},{0,0,21,6,9,-1,2},{0,0,21,10,9,-1,2},{0,0,21,6,9,-1,2},{61,0,2,0,12,-1,0},{0,0,21,10,9,-1,0},{0,0,21,6,9,-1,0},{0,0,21,10,9,-1,0},{0,0,21,10,9,-1,0},{0,0,17,10,9,-1,1},{0,0,22,10,9,-1,3},{0,0,18,10,9,-1,3},{0,0,22,10,9,-1,3},{0,0,18,10,9,-1,3},{0,0,22,10,9,-1,3},{0,0,18,10,9,-1,3},{0,0,21,4,9,-1,0}},
  {{0,0,21,10,9,-1,0},{0,0,21,10,9,-1,0},{0,0,25,3,9,-1,0},{0,0,17,3,9,-1,1},{0,0,25,10,9,-1,1},{0,0,25,10,9,-1,1},{0,0,25,10,9,-1,1},{61,0,2,0,12,-1,0},{0,0,21,10,9,-1,0},{0,0,23,4,9,-1,0},{0,0,21,4,9,-1,0},{0,0,21,10,9,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,3,-1,1},{2,0,7,13,9,-1,1},{61,0,2,13,12,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1}},
  {{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{0,0,1,18,10,-1,1}},
  {{61,0,2,0,12,-1,1},{0,0,21,10,9,-1,2},{0,0,21,10,9,-1,0},{0,0,21,4,9,-1,0},{0,0,23,4,9,-1,0},{0,0,21,4,9,-1,0},{0,0,21,10,9,-1,0},{0,0,21,10,9,-1,0},{0,0,22,10,9,-1,3},{0,0,18,10,9,-1,3},{0,0,21,10,9,-1,0},{0,0,25,3,9,-1,0},{0,0,21,6,9,-1,2},{0,0,17,3,9,-1,1},{0,0,21,6,9,-1,2},{0,0,21,6,9,-1,0},{0,0,13,2,9,0,0},{0,0,13,2,9,1,0},{0,0,13,2,9,2,0},{0,0,13,2,9,3,0},{0,0,13,2,9,4,0},{0,0,13,2,9,5,0},{0,0,13,2,9,6,0},{0,0,13,2,9,7,0},{0,0,13,2,9,8,0},{0,0,13,2,9,9,0},{0,0,21,6,9,-1,3},{0,0,21,10,9,-1,3},{0,0,25,10,9,-1,1},{0,0,25,10,9,-1,1},{0,0,25,10,9,-1,1},{0,0,21,10,9,-1,2}},
  {{0,0,21,10,9,-1,0},{25,0,9,0,9,-1,0},{25,0,9,0,9,-1,0},{25,0,9,0,9,-1,0},{25,0,9,0,9,-1,0},{25,0,9,0,9,-1,0},{25,0,9,0,9,-1,0},{25,0,9,0,9,-1,0},{25,0,9,0,9,-1,0},{25,0,9,0,9,-1,0},{25,0,9,0,9,-1,0},{25,0,9,0,9,-1,0},{25,0,9,0,9,-1,0},{25,0,9,0,9,-1,0},{25,0,9,0,9,-1,0},{25,0,9,0,9,-1,0},{25,0,9,0,9,-1,0},{25,0,9,0,9,-1,0},{25,0,9,0,9,-1,0},{25,0,9,0,9,-1,0},{25,0,9,0,9,-1,0},{25,0,9,0,9,-1,0},{25,0,9,0,9,-1,0},{25,0,9,0,9,-1,0},{25,0,9,0,9,-1,0},{25,0,9,0,9,-1,0},{25,0,9,0,9,-1,0},{0,0,22,10,9,-1,3},{0,0,21,10,9,-1,0},{0,0,18,10,9,-1,3},{0,0,24,10,9,-1,0},{0,0,16,10,9,-1,3}},
  {{0,0,24,10,9,-1,0},{25,0,5,0,9,-1,0},{25,0,5,0,9,-1,0},{25,0,5,0,9,-1,0},{25,0,5,0,9,-1,0},{25,0,5,0,9,-1,0},{25,0,5,0,9,-1,0},{25,0,5,0,9,-1,0},{25,0,5,0,9,-1,0},{25,0,5,0,9,-1,0},{25,0,5,0,9,-1,0},{25,0,5,0,9,-1,0},{25,0,5,0,9,-1,0},{25,0,5,0,9,-1,0},{25,0,5,0,9,-1,0},{25,0,5,0,9,-1,0},{25,0,5,0,9,-1,0},{25,0,5,0,9,-1,0},{25,0,5,0,9,-1,0},{25,0,5,0,9,-1,0},{25,0,5,0,9,-1,0},{25,0,5,0,9,-1,0},{25,0,5,0,9,-1,0},{25,0,5,0,9,-1,0},{25,0,5,0,9,-1,0},{25,0,5,0,9,-1,0},{25,0,5,0,9,-1,0},{0,0,22,10,9,-1,3},{0,0,25,10,9,-1,3},{0,0,18,10,9,-1,3},{0,0,25,10,9,-1,3},{0,0,22,10,9,-1,3}},
  {{0,0,18,10,9,-1,3},{0,0,21,10,9,-1,1},{0,0,22,10,9,-1,1},{0,0,18,10,9,-1,1},{0,0,21,10,9,-1,1},{0,0,21,10,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{0,0,6,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1}},
  {{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{22,0,7,0,9,-1,1},{0,0,6,0,9,-1,1},{0,0,6,0,9,-1,1}},
  {{18,0,7,0,10,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{61,0,2,0,12,-1,1}},
  {{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{18,0,7,0,9,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{0,0,23,4,9,-1,0},{0,0,23,4,9,-1,0},{0,0,25,10,9,-1,0},{0,0,24,10,9,-1,3},{0,0,26,10,9,-1,0},{0,0,23,4,9,-1,0},{0,0,23,4,9,-1,0},{61,0,2,0,12,-1,0},{0,0,26,10,9,-1,1},{0,0,25,10,9,-1,1},{0,0,25,10,9,-1,1},{0,0,25,10,9,-1,1},{0,0,25,10,9,-1,1},{0,0,26,10,9,-1,1},{0,0,26,10,9,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{0,0,1,10,8,-1,1},{0,0,1,10,8,-1,1},{0,0,1,10,8,-1,1},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1}},
  {{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{51,0,7,0,7,-1,1}},
  {{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1}},
  {{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{51,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{0,0,21,0,8,-1,1},{0,0,21,10,8,-1,1},{0,0,21,0,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1}},
  {{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{0,0,15,0,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1}},
  {{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1}},
  {{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,14,10,4,-1,1},{14,0,15,10,8,-1,1},{14,0,15,10,8,-1,1},{14,0,15,10,8,-1,1},{14,0,15,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1}},
  {{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,15,10,8,-1,1},{14,0,15,10,8,-1,1},{14,0,26,10,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{14,0,26,10,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1}},
  {{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{0,0,26,0,8,-1,1},{1,0,12,17,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{76,0,7,0,7,-1,1},{76,0,7,0,7,-1,1},{76,0,7,0,7,-1,1},{76,0,7,0,7,-1,1},{76,0,7,0,7,-1,1},{76,0,7,0,7,-1,1},{76,0,7,0,7,-1,1},{76,0,7,0,7,-1,1},{76,0,7,0,7,-1,1},{76,0,7,0,7,-1,1},{76,0,7,0,7,-1,1},{76,0,7,0,7,-1,1},{76,0,7,0,7,-1,1},{76,0,7,0,7,-1,1},{76,0,7,0,7,-1,1},{76,0,7,0,7,-1,1},{76,0,7,0,7,-1,1},{76,0,7,0,7,-1,1},{76,0,7,0,7,-1,1},{76,0,7,0,7,-1,1},{76,0,7,0,7,-1,1},{76,0,7,0,7,-1,1},{76,0,7,0,7,-1,1},{76,0,7,0,7,-1,1},{76,0,7,0,7,-1,1},{76,0,7,0,7,-1,1},{76,0,7,0,7,-1,1},{76,0,7,0,7,-1,1},{76,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1}},
  {{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{75,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{1,0,12,17,4,-1,1},{0,0,15,2,8,-1,1},{0,0,15,2,8,-1,1},{0,0,15,2,8,-1,1},{0,0,15,2,8,-1,1},{0,0,15,2,8,-1,1},{0,0,15,2,8,-1,1},{0,0,15,2,8,-1,1},{0,0,15,2,8,-1,1},{0,0,15,2,8,-1,1},{0,0,15,2,8,-1,1},{0,0,15,2,8,-1,1},{0,0,15,2,8,-1,1},{0,0,15,2,8,-1,1},{0,0,15,2,8,-1,1},{0,0,15,2,8,-1,1},{0,0,15,2,8,-1,1},{0,0,15,2,8,-1,1},{0,0,15,2,8,-1,1},{0,0,15,2,8,-1,1},{0,0,15,2,8,-1,1},{0,0,15,2,8,-1,1},{0,0,15,2,8,-1,1},{0,0,15,2,8,-1,1},{0,0,15,2,8,-1,1},{0,0,15,2,8,-1,1},{0,0,15,2,8,-1,1},{0,0,15,2,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{30,0,7,0,7,-1,1},{30,0,7,0,7,-1,1},{30,0,7,0,7,-1,1},{30,0,7,0,7,-1,1},{30,0,7,0,7,-1,1},{30,0,7,0,7,-1,1},{30,0,7,0,7,-1,1},{30,0,7,0,7,-1,1},{30,0,7,0,7,-1,1},{30,0,7,0,7,-1,1},{30,0,7,0,7,-1,1},{30,0,7,0,7,-1,1},{30,0,7,0,7,-1,1},{30,0,7,0,7,-1,1},{30,0,7,0,7,-1,1},{30,0,7,0,7,-1,1},{30,0,7,0,7,-1,1},{30,0,7,0,7,-1,1},{30,0,7,0,7,-1,1},{30,0,7,0,7,-1,1},{30,0,7,0,7,-1,1},{30,0,7,0,7,-1,1},{30,0,7,0,7,-1,1},{30,0,7,0,7,-1,1},{30,0,7,0,7,-1,1},{30,0,7,0,7,-1,1},{30,0,7,0,7,-1,1},{30,0,7,0,7,-1,1},{30,0,7,0,7,-1,1},{30,0,7,0,7,-1,1},{30,0,7,0,7,-1,1},{30,0,7,0,7,-1,1}},
  {{30,0,15,0,8,-1,1},{30,0,15,0,8,-1,1},{30,0,15,0,8,-1,1},{30,0,15,0,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{13,0,7,0,7,-1,1},{13,0,7,0,7,-1,1},{13,0,7,0,7,-1,1},{13,0,7,0,7,-1,1},{13,0,7,0,7,-1,1},{13,0,7,0,7,-1,1},{13,0,7,0,7,-1,1},{13,0,7,0,7,-1,1},{13,0,7,0,7,-1,1},{13,0,7,0,7,-1,1},{13,0,7,0,7,-1,1},{13,0,7,0,7,-1,1},{13,0,7,0,7,-1,1},{13,0,7,0,7,-1,1},{13,0,7,0,7,-1,1},{13,0,7,0,7,-1,1}},
  {{13,0,7,0,7,-1,1},{13,0,14,0,7,-1,1},{13,0,7,0,7,-1,1},{13,0,7,0,7,-1,1},{13,0,7,0,7,-1,1},{13,0,7,0,7,-1,1},{13,0,7,0,7,-1,1},{13,0,7,0,7,-1,1},{13,0,7,0,7,-1,1},{13,0,7,0,7,-1,1},{13,0,14,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{118,0,7,0,7,-1,1},{118,0,7,0,7,-1,1},{118,0,7,0,7,-1,1},{118,0,7,0,7,-1,1},{118,0,7,0,7,-1,1},{118,0,7,0,7,-1,1},{118,0,7,0,7,-1,1},{118,0,7,0,7,-1,1},{118,0,7,0,7,-1,1},{118,0,7,0,7,-1,1},{118,0,7,0,7,-1,1},{118,0,7,0,7,-1,1},{118,0,7,0,7,-1,1},{118,0,7,0,7,-1,1},{118,0,7,0,7,-1,1},{118,0,7,0,7,-1,1}},
  {{118,0,7,0,7,-1,1},{118,0,7,0,7,-1,1},{118,0,7,0,7,-1,1},{118,0,7,0,7,-1,1},{118,0,7,0,7,-1,1},{118,0,7,0,7,-1,1},{118,0,7,0,7,-1,1},{118,0,7,0,7,-1,1},{118,0,7,0,7,-1,1},{118,0,7,0,7,-1,1},{118,0,7,0,7,-1,1},{118,0,7,0,7,-1,1},{118,0,7,0,7,-1,1},{118,0,7,0,7,-1,1},{118,0,7,0,7,-1,1},{118,0,7,0,7,-1,1},{118,0,7,0,7,-1,1},{118,0,7,0,7,-1,1},{118,0,7,0,7,-1,1},{118,0,7,0,7,-1,1},{118,0,7,0,7,-1,1},{118,0,7,0,7,-1,1},{118,0,12,17,7,-1,1},{118,0,12,17,7,-1,1},{118,0,12,17,7,-1,1},{118,0,12,17,7,-1,1},{118,0,12,17,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{53,0,7,0,7,-1,1},{53,0,7,0,7,-1,1},{53,0,7,0,7,-1,1},{53,0,7,0,7,-1,1},{53,0,7,0,7,-1,1},{53,0,7,0,7,-1,1},{53,0,7,0,7,-1,1},{53,0,7,0,7,-1,1},{53,0,7,0,7,-1,1},{53,0,7,0,7,-1,1},{53,0,7,0,7,-1,1},{53,0,7,0,7,-1,1},{53,0,7,0,7,-1,1},{53,0,7,0,7,-1,1},{53,0,7,0,7,-1,1},{53,0,7,0,7,-1,1},{53,0,7,0,7,-1,1},{53,0,7,0,7,-1,1},{53,0,7,0,7,-1,1},{53,0,7,0,7,-1,1},{53,0,7,0,7,-1,1},{53,0,7,0,7,-1,1},{53,0,7,0,7,-1,1},{53,0,7,0,7,-1,1},{53,0,7,0,7,-1,1},{53,0,7,0,7,-1,1},{53,0,7,0,7,-1,1},{53,0,7,0,7,-1,1},{53,0,7,0,7,-1,1},{53,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{53,0,21,0,8,-1,1}},
  {{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1}},
  {{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{59,0,7,0,7,-1,1},{59,0,21,0,8,-1,1},{59,0,14,0,7,-1,1},{59,0,14,0,7,-1,1},{59,0,14,0,7,-1,1},{59,0,14,0,7,-1,1},{59,0,14,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{9,0,9,0,7,-1,1},{9,0,9,0,7,-1,1},{9,0,9,0,7,-1,1},{9,0,9,0,7,-1,1},{9,0,9,0,7,-1,1},{9,0,9,0,7,-1,1},{9,0,9,0,7,-1,1},{9,0,9,0,7,-1,1},{9,0,9,0,7,-1,1},{9,0,9,0,7,-1,1},{9,0,9,0,7,-1,1},{9,0,9,0,7,-1,1},{9,0,9,0,7,-1,1},{9,0,9,0,7,-1,1},{9,0,9,0,7,-1,1},{9,0,9,0,7,-1,1},{9,0,9,0,7,-1,1},{9,0,9,0,7,-1,1},{9,0,9,0,7,-1,1},{9,0,9,0,7,-1,1},{9,0,9,0,7,-1,1},{9,0,9,0,7,-1,1},{9,0,9,0,7,-1,1},{9,0,9,0,7,-1,1},{9,0,9,0,7,-1,1},{9,0,9,0,7,-1,1},{9,0,9,0,7,-1,1},{9,0,9,0,7,-1,1},{9,0,9,0,7,-1,1},{9,0,9,0,7,-1,1},{9,0,9,0,7,-1,1},{9,0,9,0,7,-1,1}},
  {{9,0,9,0,7,-1,1},{9,0,9,0,7,-1,1},{9,0,9,0,7,-1,1},{9,0,9,0,7,-1,1},{9,0,9,0,7,-1,1},{9,0,9,0,7,-1,1},{9,0,9,0,7,-1,1},{9,0,9,0,7,-1,1},{9,0,5,0,7,-1,1},{9,0,5,0,7,-1,1},{9,0,5,0,7,-1,1},{9,0,5,0,7,-1,1},{9,0,5,0,7,-1,1},{9,0,5,0,7,-1,1},{9,0,5,0,7,-1,1},{9,0,5,0,7,-1,1},{9,0,5,0,7,-1,1},{9,0,5,0,7,-1,1},{9,0,5,0,7,-1,1},{9,0,5,0,7,-1,1},{9,0,5,0,7,-1,1},{9,0,5,0,7,-1,1},{9,0,5,0,7,-1,1},{9,0,5,0,7,-1,1},{9,0,5,0,7,-1,1},{9,0,5,0,7,-1,1},{9,0,5,0,7,-1,1},{9,0,5,0,7,-1,1},{9,0,5,0,7,-1,1},{9,0,5,0,7,-1,1},{9,0,5,0,7,-1,1},{9,0,5,0,7,-1,1}},
  {{9,0,5,0,7,-1,1},{9,0,5,0,7,-1,1},{9,0,5,0,7,-1,1},{9,0,5,0,7,-1,1},{9,0,5,0,7,-1,1},{9,0,5,0,7,-1,1},{9,0,5,0,7,-1,1},{9,0,5,0,7,-1,1},{9,0,5,0,7,-1,1},{9,0,5,0,7,-1,1},{9,0,5,0,7,-1,1},{9,0,5,0,7,-1,1},{9,0,5,0,7,-1,1},{9,0,5,0,7,-1,1},{9,0,5,0,7,-1,1},{9,0,5,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1}},
  {{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1},{50,0,7,0,7,-1,1}},
  {{49,0,7,0,7,-1,1},{49,0,7,0,7,-1,1},{49,0,7,0,7,-1,1},{49,0,7,0,7,-1,1},{49,0,7,0,7,-1,1},{49,0,7,0,7,-1,1},{49,0,7,0,7,-1,1},{49,0,7,0,7,-1,1},{49,0,7,0,7,-1,1},{49,0,7,0,7,-1,1},{49,0,7,0,7,-1,1},{49,0,7,0,7,-1,1},{49,0,7,0,7,-1,1},{49,0,7,0,7,-1,1},{49,0,7,0,7,-1,1},{49,0,7,0,7,-1,1},{49,0,7,0,7,-1,1},{49,0,7,0,7,-1,1},{49,0,7,0,7,-1,1},{49,0,7,0,7,-1,1},{49,0,7,0,7,-1,1},{49,0,7,0,7,-1,1},{49,0,7,0,7,-1,1},{49,0,7,0,7,-1,1},{49,0,7,0,7,-1,1},{49,0,7,0,7,-1,1},{49,0,7,0,7,-1,1},{49,0,7,0,7,-1,1},{49,0,7,0,7,-1,1},{49,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{49,0,13,0,7,0,1},{49,0,13,0,7,1,1},{49,0,13,0,7,2,1},{49,0,13,0,7,3,1},{49,0,13,0,7,4,1},{49,0,13,0,7,5,1},{49,0,13,0,7,6,1},{49,0,13,0,7,7,1},{49,0,13,0,7,8,1},{49,0,13,0,7,9,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{106,0,7,0,7,-1,1},{106,0,7,0,7,-1,1},{106,0,7,0,7,-1,1},{106,0,7,0,7,-1,1},{106,0,7,0,7,-1,1},{106,0,7,0,7,-1,1},{106,0,7,0,7,-1,1},{106,0,7,0,7,-1,1},{106,0,7,0,7,-1,1},{106,0,7,0,7,-1,1},{106,0,7,0,7,-1,1},{106,0,7,0,7,-1,1},{106,0,7,0,7,-1,1},{106,0,7,0,7,-1,1},{106,0,7,0,7,-1,1},{106,0,7,0,7,-1,1},{106,0,7,0,7,-1,1},{106,0,7,0,7,-1,1},{106,0,7,0,7,-1,1},{106,0,7,0,7,-1,1},{106,0,7,0,7,-1,1},{106,0,7,0,7,-1,1},{106,0,7,0,7,-1,1},{106,0,7,0,7,-1,1},{106,0,7,0,7,-1,1},{106,0,7,0,7,-1,1},{106,0,7,0,7,-1,1},{106,0,7,0,7,-1,1},{106,0,7,0,7,-1,1},{106,0,7,0,7,-1,1},{106,0,7,0,7,-1,1},{106,0,7,0,7,-1,1}},
  {{106,0,7,0,7,-1,1},{106,0,7,0,7,-1,1},{106,0,7,0,7,-1,1},{106,0,7,0,7,-1,1},{106,0,7,0,7,-1,1},{106,0,7,0,7,-1,1},{106,0,7,0,7,-1,1},{106,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1}},
  {{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1}},
  {{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{104,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{104,0,21,0,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1}},
  {{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{110,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{47,0,7,1,7,-1,1},{61,0,2,1,12,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1}},
  {{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{61,0,2,1,12,-1,1},{47,0,7,1,7,-1,1},{47,0,7,1,7,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{47,0,7,1,7,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{47,0,7,1,7,-1,1}},
  {{81,0,7,1,7,-1,1},{81,0,7,1,7,-1,1},{81,0,7,1,7,-1,1},{81,0,7,1,7,-1,1},{81,0,7,1,7,-1,1},{81,0,7,1,7,-1,1},{81,0,7,1,7,-1,1},{81,0,7,1,7,-1,1},{81,0,7,1,7,-1,1},{81,0,7,1,7,-1,1},{81,0,7,1,7,-1,1},{81,0,7,1,7,-1,1},{81,0,7,1,7,-1,1},{81,0,7,1,7,-1,1},{81,0,7,1,7,-1,1},{81,0,7,1,7,-1,1},{81,0,7,1,7,-1,1},{81,0,7,1,7,-1,1},{81,0,7,1,7,-1,1},{81,0,7,1,7,-1,1},{81,0,7,1,7,-1,1},{81,0,7,1,7,-1,1},{61,0,2,1,12,-1,1},{81,0,21,1,8,-1,1},{81,0,15,1,8,-1,1},{81,0,15,1,8,-1,1},{81,0,15,1,8,-1,1},{81,0,15,1,8,-1,1},{81,0,15,1,8,-1,1},{81,0,15,1,8,-1,1},{81,0,15,1,8,-1,1},{81,0,15,1,8,-1,1}},
  {{120,0,7,1,7,-1,1},{120,0,7,1,7,-1,1},{120,0,7,1,7,-1,1},{120,0,7,1,7,-1,1},{120,0,7,1,7,-1,1},{120,0,7,1,7,-1,1},{120,0,7,1,7,-1,1},{120,0,7,1,7,-1,1},{120,0,7,1,7,-1,1},{120,0,7,1,7,-1,1},{120,0,7,1,7,-1,1},{120,0,7,1,7,-1,1},{120,0,7,1,7,-1,1},{120,0,7,1,7,-1,1},{120,0,7,1,7,-1,1},{120,0,7,1,7,-1,1},{120,0,7,1,7,-1,1},{120,0,7,1,7,-1,1},{120,0,7,1,7,-1,1},{120,0,7,1,7,-1,1},{120,0,7,1,7,-1,1},{120,0,7,1,7,-1,1},{120,0,7,1,7,-1,1},{120,0,26,1,8,-1,1},{120,0,26,1,8,-1,1},{120,0,15,1,8,-1,1},{120,0,15,1,8,-1,1},{120,0,15,1,8,-1,1},{120,0,15,1,8,-1,1},{120,0,15,1,8,-1,1},{120,0,15,1,8,-1,1},{120,0,15,1,8,-1,1}},
  {{116,0,7,1,7,-1,1},{116,0,7,1,7,-1,1},{116,0,7,1,7,-1,1},{116,0,7,1,7,-1,1},{116,0,7,1,7,-1,1},{116,0,7,1,7,-1,1},{116,0,7,1,7,-1,1},{116,0,7,1,7,-1,1},{116,0,7,1,7,-1,1},{116,0,7,1,7,-1,1},{116,0,7,1,7,-1,1},{116,0,7,1,7,-1,1},{116,0,7,1,7,-1,1},{116,0,7,1,7,-1,1},{116,0,7,1,7,-1,1},{116,0,7,1,7,-1,1},{116,0,7,1,7,-1,1},{116,0,7,1,7,-1,1},{116,0,7,1,7,-1,1},{116,0,7,1,7,-1,1},{116,0,7,1,7,-1,1},{116,0,7,1,7,-1,1},{116,0,7,1,7,-1,1},{116,0,7,1,7,-1,1},{116,0,7,1,7,-1,1},{116,0,7,1,7,-1,1},{116,0,7,1,7,-1,1},{116,0,7,1,7,-1,1},{116,0,7,1,7,-1,1},{116,0,7,1,7,-1,1},{116,0,7,1,7,-1,1},{61,0,2,1,12,-1,1}},
  {{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{116,0,15,1,8,-1,1},{116,0,15,1,8,-1,1},{116,0,15,1,8,-1,1},{116,0,15,1,8,-1,1},{116,0,15,1,8,-1,1},{116,0,15,1,8,-1,1},{116,0,15,1,8,-1,1},{116,0,15,1,8,-1,1},{116,0,15,1,8,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1}},
  {{128,0,7,1,7,-1,1},{128,0,7,1,7,-1,1},{128,0,7,1,7,-1,1},{128,0,7,1,7,-1,1},{128,0,7,1,7,-1,1},{128,0,7,1,7,-1,1},{128,0,7,1,7,-1,1},{128,0,7,1,7,-1,1},{128,0,7,1,7,-1,1},{128,0,7,1,7,-1,1},{128,0,7,1,7,-1,1},{128,0,7,1,7,-1,1},{128,0,7,1,7,-1,1},{128,0,7,1,7,-1,1},{128,0,7,1,7,-1,1},{128,0,7,1,7,-1,1},{128,0,7,1,7,-1,1},{128,0,7,1,7,-1,1},{128,0,7,1,7,-1,1},{61,0,2,1,12,-1,1},{128,0,7,1,7,-1,1},{128,0,7,1,7,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{128,0,15,1,8,-1,1},{128,0,15,1,8,-1,1},{128,0,15,1,8,-1,1},{128,0,15,1,8,-1,1},{128,0,15,1,8,-1,1}},
  {{64,0,7,1,7,-1,1},{64,0,7,1,7,-1,1},{64,0,7,1,7,-1,1},{64,0,7,1,7,-1,1},{64,0,7,1,7,-1,1},{64,0,7,1,7,-1,1},{64,0,7,1,7,-1,1},{64,0,7,1,7,-1,1},{64,0,7,1,7,-1,1},{64,0,7,1,7,-1,1},{64,0,7,1,7,-1,1},{64,0,7,1,7,-1,1},{64,0,7,1,7,-1,1},{64,0,7,1,7,-1,1},{64,0,7,1,7,-1,1},{64,0,7,1,7,-1,1},{64,0,7,1,7,-1,1},{64,0,7,1,7,-1,1},{64,0,7,1,7,-1,1},{64,0,7,1,7,-1,1},{64,0,7,1,7,-1,1},{64,0,7,1,7,-1,1},{64,0,15,1,8,-1,1},{64,0,15,1,8,-1,1},{64,0,15,1,8,-1,1},{64,0,15,1,8,-1,1},{64,0,15,1,8,-1,1},{64,0,15,1,8,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{64,0,21,10,8,-1,1}},
  {{77,0,7,1,7,-1,1},{77,0,7,1,7,-1,1},{77,0,7,1,7,-1,1},{77,0,7,1,7,-1,1},{77,0,7,1,7,-1,1},{77,0,7,1,7,-1,1},{77,0,7,1,7,-1,1},{77,0,7,1,7,-1,1},{77,0,7,1,7,-1,1},{77,0,7,1,7,-1,1},{77,0,7,1,7,-1,1},{77,0,7,1,7,-1,1},{77,0,7,1,7,-1,1},{77,0,7,1,7,-1,1},{77,0,7,1,7,-1,1},{77,0,7,1,7,-1,1},{77,0,7,1,7,-1,1},{77,0,7,1,7,-1,1},{77,0,7,1,7,-1,1},{77,0,7,1,7,-1,1},{77,0,7,1,7,-1,1},{77,0,7,1,7,-1,1},{77,0,7,1,7,-1,1},{77,0,7,1,7,-1,1},{77,0,7,1,7,-1,1},{77,0,7,1,7,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{77,0,21,1,8,-1,1}},
  {{98,0,7,1,7,-1,0},{98,0,7,1,7,-1,0},{98,0,7,1,7,-1,0},{98,0,7,1,7,-1,0},{98,0,7,1,7,-1,0},{98,0,7,1,7,-1,0},{98,0,7,1,7,-1,0},{98,0,7,1,7,-1,0},{98,0,7,1,7,-1,0},{98,0,7,1,7,-1,0},{98,0,7,1,7,-1,0},{98,0,7,1,7,-1,0},{98,0,7,1,7,-1,0},{98,0,7,1,7,-1,0},{98,0,7,1,7,-1,0},{98,0,7,1,7,-1,0},{98,0,7,1,7,-1,0},{98,0,7,1,7,-1,0},{98,0,7,1,7,-1,0},{98,0,7,1,7,-1,0},{98,0,7,1,7,-1,0},{98,0,7,1,7,-1,0},{98,0,7,1,7,-1,0},{98,0,7,1,7,-1,0},{98,0,7,1,7,-1,0},{98,0,7,1,7,-1,0},{98,0,7,1,7,-1,0},{98,0,7,1,7,-1,0},{98,0,7,1,7,-1,0},{98,0,7,1,7,-1,0},{98,0,7,1,7,-1,0},{98,0,7,1,7,-1,0}},
  {{97,0,7,1,7,-1,1},{97,0,7,1,7,-1,1},{97,0,7,1,7,-1,1},{97,0,7,1,7,-1,1},{97,0,7,1,7,-1,1},{97,0,7,1,7,-1,1},{97,0,7,1,7,-1,1},{97,0,7,1,7,-1,1},{97,0,7,1,7,-1,1},{97,0,7,1,7,-1,1},{97,0,7,1,7,-1,1},{97,0,7,1,7,-1,1},{97,0,7,1,7,-1,1},{97,0,7,1,7,-1,1},{97,0,7,1,7,-1,1},{97,0,7,1,7,-1,1},{97,0,7,1,7,-1,1},{97,0,7,1,7,-1,1},{97,0,7,1,7,-1,1},{97,0,7,1,7,-1,1},{97,0,7,1,7,-1,1},{97,0,7,1,7,-1,1},{97,0,7,1,7,-1,1},{97,0,7,1,7,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,7,1,7,-1,1},{97,0,7,1,7,-1,1}},
  {{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1}},
  {{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1},{97,0,15,1,8,-1,1}},
  {{60,0,7,1,7,-1,1},{60,0,12,17,7,-1,1},{60,0,12,17,7,-1,1},{60,0,12,17,7,-1,1},{61,0,2,1,12,-1,1},{60,0,12,17,7,-1,1},{60,0,12,17,7,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{60,0,12,17,7,-1,1},{60,0,12,17,7,-1,1},{60,0,12,17,7,-1,1},{60,0,12,17,7,-1,1},{60,0,7,1,7,-1,1},{60,0,7,1,7,-1,1},{60,0,7,1,7,-1,1},{60,0,7,1,7,-1,1},{61,0,2,1,12,-1,1},{60,0,7,1,7,-1,1},{60,0,7,1,7,-1,1},{60,0,7,1,7,-1,1},{61,0,2,1,12,-1,1},{60,0,7,1,7,-1,1},{60,0,7,1,7,-1,1},{60,0,7,1,7,-1,1},{60,0,7,1,7,-1,1},{60,0,7,1,7,-1,1},{60,0,7,1,7,-1,1},{60,0,7,1,7,-1,1}},
  {{60,0,7,1,7,-1,1},{60,0,7,1,7,-1,1},{60,0,7,1,7,-1,1},{60,0,7,1,7,-1,1},{60,0,7,1,7,-1,1},{60,0,7,1,7,-1,1},{60,0,7,1,7,-1,1},{60,0,7,1,7,-1,1},{60,0,7,1,7,-1,1},{60,0,7,1,7,-1,1},{60,0,7,1,7,-1,1},{60,0,7,1,7,-1,1},{60,0,7,1,7,-1,1},{60,0,7,1,7,-1,1},{60,0,7,1,7,-1,1},{60,0,7,1,7,-1,1},{60,0,7,1,7,-1,1},{60,0,7,1,7,-1,1},{60,0,7,1,7,-1,1},{60,0,7,1,7,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{60,0,12,17,7,-1,1},{60,0,12,17,7,-1,1},{60,0,12,17,7,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{60,0,12,17,7,-1,1}},
  {{60,0,15,1,8,1,1},{60,0,15,1,8,2,1},{60,0,15,1,8,3,1},{60,0,15,1,8,4,1},{60,0,15,1,8,-1,1},{60,0,15,1,8,-1,1},{60,0,15,1,8,-1,1},{60,0,15,1,8,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{60,0,21,1,8,-1,1},{60,0,21,1,8,-1,1},{60,0,21,1,8,-1,1},{60,0,21,1,8,-1,1},{60,0,21,1,8,-1,1},{60,0,21,1,8,-1,1},{60,0,21,1,8,-1,1},{60,0,21,1,8,-1,1},{60,0,21,1,8,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1}},
  {{88,0,7,1,7,-1,1},{88,0,7,1,7,-1,1},{88,0,7,1,7,-1,1},{88,0,7,1,7,-1,1},{88,0,7,1,7,-1,1},{88,0,7,1,7,-1,1},{88,0,7,1,7,-1,1},{88,0,7,1,7,-1,1},{88,0,7,1,7,-1,1},{88,0,7,1,7,-1,1},{88,0,7,1,7,-1,1},{88,0,7,1,7,-1,1},{88,0,7,1,7,-1,1},{88,0,7,1,7,-1,1},{88,0,7,1,7,-1,1},{88,0,7,1,7,-1,1},{88,0,7,1,7,-1,1},{88,0,7,1,7,-1,1},{88,0,7,1,7,-1,1},{88,0,7,1,7,-1,1},{88,0,7,1,7,-1,1},{88,0,7,1,7,-1,1},{88,0,7,1,7,-1,1},{88,0,7,1,7,-1,1},{88,0,7,1,7,-1,1},{88,0,7,1,7,-1,1},{88,0,7,1,7,-1,1},{88,0,7,1,7,-1,1},{88,0,7,1,7,-1,1},{88,0,15,1,8,-1,1},{88,0,15,1,8,-1,1},{88,0,21,1,8,-1,1}},
  {{117,0,7,1,7,-1,1},{117,0,7,1,7,-1,1},{117,0,7,1,7,-1,1},{117,0,7,1,7,-1,1},{117,0,7,1,7,-1,1},{117,0,7,1,7,-1,1},{117,0,7,1,7,-1,1},{117,0,7,1,7,-1,1},{117,0,7,1,7,-1,1},{117,0,7,1,7,-1,1},{117,0,7,1,7,-1,1},{117,0,7,1,7,-1,1},{117,0,7,1,7,-1,1},{117,0,7,1,7,-1,1},{117,0,7,1,7,-1,1},{117,0,7,1,7,-1,1},{117,0,7,1,7,-1,1},{117,0,7,1,7,-1,1},{117,0,7,1,7,-1,1},{117,0,7,1,7,-1,1},{117,0,7,1,7,-1,1},{117,0,7,1,7,-1,1},{117,0,7,1,7,-1,1},{117,0,7,1,7,-1,1},{117,0,7,1,7,-1,1},{117,0,7,1,7,-1,1},{117,0,7,1,7,-1,1},{117,0,7,1,7,-1,1},{117,0,7,1,7,-1,1},{117,0,15,1,8,-1,1},{117,0,15,1,8,-1,1},{117,0,15,1,8,-1,1}},
  {{112,0,7,1,7,-1,1},{112,0,7,1,7,-1,1},{112,0,7,1,7,-1,1},{112,0,7,1,7,-1,1},{112,0,7,1,7,-1,1},{112,0,7,1,7,-1,1},{112,0,7,1,7,-1,1},{112,0,7,1,7,-1,1},{112,0,26,1,8,-1,1},{112,0,7,1,7,-1,1},{112,0,7,1,7,-1,1},{112,0,7,1,7,-1,1},{112,0,7,1,7,-1,1},{112,0,7,1,7,-1,1},{112,0,7,1,7,-1,1},{112,0,7,1,7,-1,1},{112,0,7,1,7,-1,1},{112,0,7,1,7,-1,1},{112,0,7,1,7,-1,1},{112,0,7,1,7,-1,1},{112,0,7,1,7,-1,1},{112,0,7,1,7,-1,1},{112,0,7,1,7,-1,1},{112,0,7,1,7,-1,1},{112,0,7,1,7,-1,1},{112,0,7,1,7,-1,1},{112,0,7,1,7,-1,1},{112,0,7,1,7,-1,1},{112,0,7,1,7,-1,1},{112,0,7,1,7,-1,1},{112,0,7,1,7,-1,1},{112,0,7,1,7,-1,1}},
  {{112,0,7,1,7,-1,1},{112,0,7,1,7,-1,1},{112,0,7,1,7,-1,1},{112,0,7,1,7,-1,1},{112,0,7,1,7,-1,1},{112,0,12,17,7,-1,1},{112,0,12,17,7,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{112,0,15,1,8,-1,1},{112,0,15,1,8,-1,1},{112,0,15,1,8,-1,1},{112,0,15,1,8,-1,1},{112,0,15,1,8,-1,1},{112,0,21,1,8,-1,1},{112,0,21,1,8,-1,1},{112,0,21,1,8,-1,1},{112,0,21,1,8,-1,1},{112,0,21,1,8,-1,1},{112,0,21,1,8,-1,1},{112,0,21,1,8,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1}},
  {{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1}},
  {{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{78,0,7,1,7,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{78,0,21,10,8,-1,1},{78,0,21,10,8,-1,1},{78,0,21,10,8,-1,1},{78,0,21,10,8,-1,1},{78,0,21,10,8,-1,1},{78,0,21,10,8,-1,1},{78,0,21,10,8,-1,1}},
  {{83,0,7,1,7,-1,1},{83,0,7,1,7,-1,1},{83,0,7,1,7,-1,1},{83,0,7,1,7,-1,1},{83,0,7,1,7,-1,1},{83,0,7,1,7,-1,1},{83,0,7,1,7,-1,1},{83,0,7,1,7,-1,1},{83,0,7,1,7,-1,1},{83,0,7,1,7,-1,1},{83,0,7,1,7,-1,1},{83,0,7,1,7,-1,1},{83,0,7,1,7,-1,1},{83,0,7,1,7,-1,1},{83,0,7,1,7,-1,1},{83,0,7,1,7,-1,1},{83,0,7,1,7,-1,1},{83,0,7,1,7,-1,1},{83,0,7,1,7,-1,1},{83,0,7,1,7,-1,1},{83,0,7,1,7,-1,1},{83,0,7,1,7,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{83,0,15,1,8,-1,1},{83,0,15,1,8,-1,1},{83,0,15,1,8,-1,1},{83,0,15,1,8,-1,1},{83,0,15,1,8,-1,1},{83,0,15,1,8,-1,1},{83,0,15,1,8,-1,1},{83,0,15,1,8,-1,1}},
  {{82,0,7,1,7,-1,1},{82,0,7,1,7,-1,1},{82,0,7,1,7,-1,1},{82,0,7,1,7,-1,1},{82,0,7,1,7,-1,1},{82,0,7,1,7,-1,1},{82,0,7,1,7,-1,1},{82,0,7,1,7,-1,1},{82,0,7,1,7,-1,1},{82,0,7,1,7,-1,1},{82,0,7,1,7,-1,1},{82,0,7,1,7,-1,1},{82,0,7,1,7,-1,1},{82,0,7,1,7,-1,1},{82,0,7,1,7,-1,1},{82,0,7,1,7,-1,1},{82,0,7,1,7,-1,1},{82,0,7,1,7,-1,1},{82,0,7,1,7,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{82,0,15,1,8,-1,1},{82,0,15,1,8,-1,1},{82,0,15,1,8,-1,1},{82,0,15,1,8,-1,1},{82,0,15,1,8,-1,1},{82,0,15,1,8,-1,1},{82,0,15,1,8,-1,1},{82,0,15,1,8,-1,1}},
  {{122,0,7,1,7,-1,1},{122,0,7,1,7,-1,1},{122,0,7,1,7,-1,1},{122,0,7,1,7,-1,1},{122,0,7,1,7,-1,1},{122,0,7,1,7,-1,1},{122,0,7,1,7,-1,1},{122,0,7,1,7,-1,1},{122,0,7,1,7,-1,1},{122,0,7,1,7,-1,1},{122,0,7,1,7,-1,1},{122,0,7,1,7,-1,1},{122,0,7,1,7,-1,1},{122,0,7,1,7,-1,1},{122,0,7,1,7,-1,1},{122,0,7,1,7,-1,1},{122,0,7,1,7,-1,1},{122,0,7,1,7,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{122,0,21,1,8,-1,1},{122,0,21,1,8,-1,1},{122,0,21,1,8,-1,1},{122,0,21,1,8,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1}},
  {{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{122,0,15,1,8,-1,1},{122,0,15,1,8,-1,1},{122,0,15,1,8,-1,1},{122,0,15,1,8,-1,1},{122,0,15,1,8,-1,1},{122,0,15,1,8,-1,1},{122,0,15,1,8,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1}},
  {{89,0,7,1,7,-1,1},{89,0,7,1,7,-1,1},{89,0,7,1,7,-1,1},{89,0,7,1,7,-1,1},{89,0,7,1,7,-1,1},{89,0,7,1,7,-1,1},{89,0,7,1,7,-1,1},{89,0,7,1,7,-1,1},{89,0,7,1,7,-1,1},{89,0,7,1,7,-1,1},{89,0,7,1,7,-1,1},{89,0,7,1,7,-1,1},{89,0,7,1,7,-1,1},{89,0,7,1,7,-1,1},{89,0,7,1,7,-1,1},{89,0,7,1,7,-1,1},{89,0,7,1,7,-1,1},{89,0,7,1,7,-1,1},{89,0,7,1,7,-1,1},{89,0,7,1,7,-1,1},{89,0,7,1,7,-1,1},{89,0,7,1,7,-1,1},{89,0,7,1,7,-1,1},{89,0,7,1,7,-1,1},{89,0,7,1,7,-1,1},{89,0,7,1,7,-1,1},{89,0,7,1,7,-1,1},{89,0,7,1,7,-1,1},{89,0,7,1,7,-1,1},{89,0,7,1,7,-1,1},{89,0,7,1,7,-1,1},{89,0,7,1,7,-1,1}},
  {{89,0,7,1,7,-1,1},{89,0,7,1,7,-1,1},{89,0,7,1,7,-1,1},{89,0,7,1,7,-1,1},{89,0,7,1,7,-1,1},{89,0,7,1,7,-1,1},{89,0,7,1,7,-1,1},{89,0,7,1,7,-1,1},{89,0,7,1,7,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1}},
  {{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1}},
  {{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{130,0,9,1,7,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1}},
  {{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1}},
  {{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{130,0,5,1,7,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{130,0,15,1,8,-1,1},{130,0,15,1,8,-1,1},{130,0,15,1,8,-1,1},{130,0,15,1,8,-1,1},{130,0,15,1,8,-1,1},{130,0,15,1,8,-1,1}},
  {{2,0,15,5,8,1,1},{2,0,15,5,8,2,1},{2,0,15,5,8,3,1},{2,0,15,5,8,4,1},{2,0,15,5,8,5,1},{2,0,15,5,8,6,1},{2,0,15,5,8,7,1},{2,0,15,5,8,8,1},{2,0,15,5,8,9,1},{2,0,15,5,8,-1,1},{2,0,15,5,8,-1,1},{2,0,15,5,8,-1,1},{2,0,15,5,8,-1,1},{2,0,15,5,8,-1,1},{2,0,15,5,8,-1,1},{2,0,15,5,8,-1,1},{2,0,15,5,8,-1,1},{2,0,15,5,8,-1,1},{2,0,15,5,8,-1,1},{2,0,15,5,8,-1,1},{2,0,15,5,8,-1,1},{2,0,15,5,8,-1,1},{2,0,15,5,8,-1,1},{2,0,15,5,8,-1,1},{2,0,15,5,8,-1,1},{2,0,15,5,8,-1,1},{2,0,15,5,8,-1,1},{2,0,15,5,8,-1,1},{2,0,15,5,8,-1,1},{2,0,15,5,8,-1,1},{2,0,15,5,8,-1,1},{61,0,2,1,12,-1,1}},
  {{94,0,10,0,7,-1,1},{94,0,12,17,7,-1,1},{94,0,10,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1}},
  {{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,7,0,7,-1,1},{94,0,12,17,7,-1,1},{94,0,12,17,7,-1,1},{94,0,12,17,7,-1,1},{94,0,12,17,7,-1,1},{94,0,12,17,7,-1,1},{94,0,12,17,7,-1,1},{94,0,12,17,7,-1,1},{94,0,12,17,7,-1,1}},
  {{94,0,12,17,7,-1,1},{94,0,12,17,7,-1,1},{94,0,12,17,7,-1,1},{94,0,12,17,7,-1,1},{94,0,12,17,7,-1,1},{94,0,12,17,7,-1,1},{94,0,12,17,7,-1,1},{94,0,21,0,8,-1,1},{94,0,21,0,8,-1,1},{94,0,21,0,8,-1,1},{94,0,21,0,8,-1,1},{94,0,21,0,8,-1,1},{94,0,21,0,8,-1,1},{94,0,21,0,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{94,0,15,10,8,1,1},{94,0,15,10,8,2,1},{94,0,15,10,8,3,1},{94,0,15,10,8,4,1},{94,0,15,10,8,5,1},{94,0,15,10,8,6,1},{94,0,15,10,8,7,1},{94,0,15,10,8,8,1},{94,0,15,10,8,9,1},{94,0,15,10,8,-1,1},{94,0,15,10,8,-1,1},{94,0,15,10,8,-1,1},{94,0,15,10,8,-1,1},{94,0,15,10,8,-1,1}},
  {{94,0,15,10,8,-1,1},{94,0,15,10,8,-1,1},{94,0,15,10,8,-1,1},{94,0,15,10,8,-1,1},{94,0,15,10,8,-1,1},{94,0,15,10,8,-1,1},{94,0,13,0,7,0,1},{94,0,13,0,7,1,1},{94,0,13,0,7,2,1},{94,0,13,0,7,3,1},{94,0,13,0,7,4,1},{94,0,13,0,7,5,1},{94,0,13,0,7,6,1},{94,0,13,0,7,7,1},{94,0,13,0,7,8,1},{94,0,13,0,7,9,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{94,0,12,17,7,-1,1}},
  {{85,0,12,17,7,-1,1},{85,0,12,17,7,-1,1},{85,0,10,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1}},
  {{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,7,0,7,-1,1},{85,0,10,0,7,-1,1},{85,0,10,0,7,-1,1},{85,0,10,0,7,-1,1},{85,0,12,17,7,-1,1},{85,0,12,17,7,-1,1},{85,0,12,17,7,-1,1},{85,0,12,17,7,-1,1},{85,0,10,0,7,-1,1},{85,0,10,0,7,-1,1},{85,0,12,17,7,-1,1},{85,0,12,17,7,-1,1},{85,0,21,0,8,-1,1},{85,0,21,0,8,-1,1},{85,0,1,0,8,-1,1},{85,0,21,0,8,-1,1},{85,0,21,0,8,-1,1}},
  {{85,0,21,0,8,-1,1},{85,0,21,0,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{101,0,7,0,7,-1,1},{101,0,7,0,7,-1,1},{101,0,7,0,7,-1,1},{101,0,7,0,7,-1,1},{101,0,7,0,7,-1,1},{101,0,7,0,7,-1,1},{101,0,7,0,7,-1,1},{101,0,7,0,7,-1,1},{101,0,7,0,7,-1,1},{101,0,7,0,7,-1,1},{101,0,7,0,7,-1,1},{101,0,7,0,7,-1,1},{101,0,7,0,7,-1,1},{101,0,7,0,7,-1,1},{101,0,7,0,7,-1,1},{101,0,7,0,7,-1,1}},
  {{101,0,7,0,7,-1,1},{101,0,7,0,7,-1,1},{101,0,7,0,7,-1,1},{101,0,7,0,7,-1,1},{101,0,7,0,7,-1,1},{101,0,7,0,7,-1,1},{101,0,7,0,7,-1,1},{101,0,7,0,7,-1,1},{101,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{101,0,13,0,7,0,1},{101,0,13,0,7,1,1},{101,0,13,0,7,2,1},{101,0,13,0,7,3,1},{101,0,13,0,7,4,1},{101,0,13,0,7,5,1},{101,0,13,0,7,6,1},{101,0,13,0,7,7,1},{101,0,13,0,7,8,1},{101,0,13,0,7,9,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{96,0,12,17,6,-1,1},{96,0,12,17,6,-1,1},{96,0,12,17,6,-1,1},{96,0,7,0,6,-1,1},{96,0,7,0,6,-1,1},{96,0,7,0,6,-1,1},{96,0,7,0,6,-1,1},{96,0,7,0,6,-1,1},{96,0,7,0,6,-1,1},{96,0,7,0,6,-1,1},{96,0,7,0,6,-1,1},{96,0,7,0,6,-1,1},{96,0,7,0,6,-1,1},{96,0,7,0,6,-1,1},{96,0,7,0,6,-1,1},{96,0,7,0,6,-1,1},{96,0,7,0,6,-1,1},{96,0,7,0,6,-1,1},{96,0,7,0,6,-1,1},{96,0,7,0,6,-1,1},{96,0,7,0,6,-1,1},{96,0,7,0,6,-1,1},{96,0,7,0,6,-1,1},{96,0,7,0,6,-1,1},{96,0,7,0,6,-1,1},{96,0,7,0,6,-1,1},{96,0,7,0,6,-1,1},{96,0,7,0,6,-1,1},{96,0,7,0,6,-1,1},{96,0,7,0,6,-1,1},{96,0,7,0,6,-1,1},{96,0,7,0,6,-1,1}},
  {{96,0,7,0,6,-1,1},{96,0,7,0,6,-1,1},{96,0,7,0,6,-1,1},{96,0,7,0,6,-1,1},{96,0,7,0,6,-1,1},{96,0,7,0,6,-1,1},{96,0,7,0,6,-1,1},{96,0,12,17,6,-1,1},{96,0,12,17,6,-1,1},{96,0,12,17,6,-1,1},{96,0,12,17,6,-1,1},{96,0,12,17,6,-1,1},{96,0,10,0,6,-1,1},{96,0,12,17,6,-1,1},{96,0,12,17,6,-1,1},{96,0,12,17,6,-1,1},{96,0,12,17,6,-1,1},{96,0,12,17,6,-1,1},{96,0,12,17,6,-1,1},{96,0,12,17,6,-1,1},{96,0,12,17,6,-1,1},{61,0,2,0,12,-1,1},{96,0,13,0,6,0,1},{96,0,13,0,6,1,1},{96,0,13,0,6,2,1},{96,0,13,0,6,3,1},{96,0,13,0,6,4,1},{96,0,13,0,6,5,1},{96,0,13,0,6,6,1},{96,0,13,0,6,7,1},{96,0,13,0,6,8,1},{96,0,13,0,6,9,1}},
  {{96,0,21,0,8,-1,1},{96,0,21,0,8,-1,1},{96,0,21,0,8,-1,1},{96,0,21,0,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{111,0,7,0,7,-1,1},{111,0,7,0,7,-1,1},{111,0,7,0,7,-1,1},{111,0,7,0,7,-1,1},{111,0,7,0,7,-1,1},{111,0,7,0,7,-1,1},{111,0,7,0,7,-1,1},{111,0,7,0,7,-1,1},{111,0,7,0,7,-1,1},{111,0,7,0,7,-1,1},{111,0,7,0,7,-1,1},{111,0,7,0,7,-1,1},{111,0,7,0,7,-1,1},{111,0,7,0,7,-1,1},{111,0,7,0,7,-1,1},{111,0,7,0,7,-1,1}},
  {{111,0,7,0,7,-1,1},{111,0,7,0,7,-1,1},{111,0,7,0,7,-1,1},{111,0,7,0,7,-1,1},{111,0,7,0,7,-1,1},{111,0,7,0,7,-1,1},{111,0,7,0,7,-1,1},{111,0,7,0,7,-1,1},{111,0,7,0,7,-1,1},{111,0,7,0,7,-1,1},{111,0,7,0,7,-1,1},{111,0,7,0,7,-1,1},{111,0,7,0,7,-1,1},{111,0,7,0,7,-1,1},{111,0,7,0,7,-1,1},{111,0,7,0,7,-1,1},{111,0,7,0,7,-1,1},{111,0,7,0,7,-1,1},{111,0,7,0,7,-1,1},{111,0,12,17,7,-1,1},{111,0,21,0,8,-1,1},{111,0,21,0,8,-1,1},{111,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{100,0,12,17,7,-1,1},{100,0,12,17,7,-1,1},{100,0,10,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1}},
  {{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,10,0,7,-1,1},{100,0,10,0,7,-1,1},{100,0,10,0,7,-1,1},{100,0,12,17,7,-1,1},{100,0,12,17,7,-1,1},{100,0,12,17,7,-1,1},{100,0,12,17,7,-1,1},{100,0,12,17,7,-1,1},{100,0,12,17,7,-1,1},{100,0,12,17,7,-1,1},{100,0,12,17,7,-1,1},{100,0,12,17,7,-1,1},{100,0,10,0,7,-1,1}},
  {{100,0,10,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,7,0,7,-1,1},{100,0,21,0,8,-1,1},{100,0,21,0,8,-1,1},{100,0,21,0,8,-1,1},{100,0,21,0,8,-1,1},{100,0,21,0,8,-1,1},{100,0,12,17,7,-1,1},{100,0,12,17,7,-1,1},{100,0,12,17,7,-1,1},{100,0,21,0,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{100,0,13,0,7,0,1},{100,0,13,0,7,1,1},{100,0,13,0,7,2,1},{100,0,13,0,7,3,1},{100,0,13,0,7,4,1},{100,0,13,0,7,5,1},{100,0,13,0,7,6,1},{100,0,13,0,7,7,1},{100,0,13,0,7,8,1},{100,0,13,0,7,9,1},{100,0,7,0,7,-1,1},{100,0,21,0,8,-1,1},{100,0,7,0,7,-1,1},{100,0,21,0,8,-1,1},{100,0,21,0,8,-1,1},{100,0,21,0,8,-1,1}},
  {{61,0,2,0,12,-1,1},{33,0,15,0,8,-1,1},{33,0,15,0,8,-1,1},{33,0,15,0,8,-1,1},{33,0,15,0,8,-1,1},{33,0,15,0,8,-1,1},{33,0,15,0,8,-1,1},{33,0,15,0,8,-1,1},{33,0,15,0,8,-1,1},{33,0,15,0,8,-1,1},{33,0,15,0,8,-1,1},{33,0,15,0,8,-1,1},{33,0,15,0,8,-1,1},{33,0,15,0,8,-1,1},{33,0,15,0,8,-1,1},{33,0,15,0,8,-1,1},{33,0,15,0,8,-1,1},{33,0,15,0,8,-1,1},{33,0,15,0,8,-1,1},{33,0,15,0,8,-1,1},{33,0,15,0,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1}},
  {{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1},{108,0,7,0,7,-1,1},{108,0,10,0,7,-1,1},{108,0,10,0,7,-1,1},{108,0,10,0,7,-1,1},{108,0,12,17,7,-1,1},{108,0,12,17,7,-1,1},{108,0,12,17,7,-1,1},{108,0,10,0,7,-1,1},{108,0,10,0,7,-1,1},{108,0,12,17,7,-1,1},{108,0,10,0,7,-1,1},{108,0,12,17,7,-1,1},{108,0,12,17,7,-1,1},{108,0,21,0,8,-1,1},{108,0,21,0,8,-1,1},{108,0,21,0,8,-1,1},{108,0,21,0,8,-1,1},{108,0,21,0,8,-1,1},{108,0,21,0,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{129,0,7,0,7,-1,1},{129,0,7,0,7,-1,1},{129,0,7,0,7,-1,1},{129,0,7,0,7,-1,1},{129,0,7,0,7,-1,1},{129,0,7,0,7,-1,1},{129,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{129,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{129,0,7,0,7,-1,1},{129,0,7,0,7,-1,1},{129,0,7,0,7,-1,1},{129,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{129,0,7,0,7,-1,1},{129,0,7,0,7,-1,1},{129,0,7,0,7,-1,1},{129,0,7,0,7,-1,1},{129,0,7,0,7,-1,1},{129,0,7,0,7,-1,1},{129,0,7,0,7,-1,1},{129,0,7,0,7,-1,1},{129,0,7,0,7,-1,1},{129,0,7,0,7,-1,1},{129,0,7,0,7,-1,1},{129,0,7,0,7,-1,1},{129,0,7,0,7,-1,1},{129,0,7,0,7,-1,1},{129,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{129,0,7,0,7,-1,1}},
  {{129,0,7,0,7,-1,1},{129,0,7,0,7,-1,1},{129,0,7,0,7,-1,1},{129,0,7,0,7,-1,1},{129,0,7,0,7,-1,1},{129,0,7,0,7,-1,1},{129,0,7,0,7,-1,1},{129,0,7,0,7,-1,1},{129,0,7,0,7,-1,1},{129,0,21,0,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1}},
  {{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,7,0,7,-1,1},{109,0,12,17,7,-1,1}},
  {{109,0,10,0,7,-1,1},{109,0,10,0,7,-1,1},{109,0,10,0,7,-1,1},{109,0,12,17,7,-1,1},{109,0,12,17,7,-1,1},{109,0,12,17,7,-1,1},{109,0,12,17,7,-1,1},{109,0,12,17,7,-1,1},{109,0,12,17,7,-1,1},{109,0,12,17,7,-1,1},{109,0,12,17,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{109,0,13,0,7,0,1},{109,0,13,0,7,1,1},{109,0,13,0,7,2,1},{109,0,13,0,7,3,1},{109,0,13,0,7,4,1},{109,0,13,0,7,5,1},{109,0,13,0,7,6,1},{109,0,13,0,7,7,1},{109,0,13,0,7,8,1},{109,0,13,0,7,9,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{107,0,12,17,7,-1,1},{107,0,12,17,7,-1,1},{107,0,10,0,7,-1,1},{107,0,10,0,7,-1,1},{61,0,2,0,12,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1}},
  {{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{107,0,12,17,7,-1,1},{107,0,7,0,7,-1,1},{107,0,10,0,7,-1,1},{107,0,10,0,7,-1,1}},
  {{107,0,12,17,7,-1,1},{107,0,10,0,7,-1,1},{107,0,10,0,7,-1,1},{107,0,10,0,7,-1,1},{107,0,10,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{107,0,10,0,7,-1,1},{107,0,10,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{107,0,10,0,7,-1,1},{107,0,10,0,7,-1,1},{107,0,10,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{107,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{107,0,10,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1}},
  {{107,0,7,0,7,-1,1},{107,0,7,0,7,-1,1},{107,0,10,0,7,-1,1},{107,0,10,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{107,0,12,17,7,-1,1},{107,0,12,17,7,-1,1},{107,0,12,17,7,-1,1},{107,0,12,17,7,-1,1},{107,0,12,17,7,-1,1},{107,0,12,17,7,-1,1},{107,0,12,17,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{107,0,12,17,7,-1,1},{107,0,12,17,7,-1,1},{107,0,12,17,7,-1,1},{107,0,12,17,7,-1,1},{107,0,12,17,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1}},
  {{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,10,0,7,-1,1},{124,0,10,0,7,-1,1},{124,0,10,0,7,-1,1},{124,0,12,17,7,-1,1},{124,0,12,17,7,-1,1},{124,0,12,17,7,-1,1},{124,0,12,17,7,-1,1},{124,0,12,17,7,-1,1},{124,0,12,17,7,-1,1},{124,0,10,0,7,-1,1},{124,0,12,17,7,-1,1},{124,0,10,0,7,-1,1},{124,0,10,0,7,-1,1},{124,0,10,0,7,-1,1},{124,0,10,0,7,-1,1},{124,0,12,17,7,-1,1}},
  {{124,0,12,17,7,-1,1},{124,0,10,0,7,-1,1},{124,0,12,17,7,-1,1},{124,0,12,17,7,-1,1},{124,0,7,0,7,-1,1},{124,0,7,0,7,-1,1},{124,0,21,0,8,-1,1},{124,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{124,0,13,0,7,0,1},{124,0,13,0,7,1,1},{124,0,13,0,7,2,1},{124,0,13,0,7,3,1},{124,0,13,0,7,4,1},{124,0,13,0,7,5,1},{124,0,13,0,7,6,1},{124,0,13,0,7,7,1},{124,0,13,0,7,8,1},{124,0,13,0,7,9,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0}},
  {{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,10,0,7,-1,0},{123,0,10,0,7,-1,0},{123,0,10,0,7,-1,0},{123,0,12,17,7,-1,0},{123,0,12,17,7,-1,0},{123,0,12,17,7,-1,0},{123,0,12,17,7,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{123,0,10,0,7,-1,0},{123,0,10,0,7,-1,0},{123,0,10,0,7,-1,0},{123,0,10,0,7,-1,0},{123,0,12,17,7,-1,0},{123,0,12,17,7,-1,0},{123,0,10,0,7,-1,0},{123,0,12,17,7,-1,0}},
  {{123,0,12,17,7,-1,0},{123,0,21,0,8,-1,0},{123,0,21,0,8,-1,0},{123,0,21,0,8,-1,0},{123,0,21,0,8,-1,0},{123,0,21,0,8,-1,0},{123,0,21,0,8,-1,0},{123,0,21,0,8,-1,0},{123,0,21,0,8,-1,0},{123,0,21,0,8,-1,0},{123,0,21,0,8,-1,0},{123,0,21,0,8,-1,0},{123,0,21,0,8,-1,0},{123,0,21,0,8,-1,0},{123,0,21,0,8,-1,0},{123,0,21,0,8,-1,0},{123,0,21,0,8,-1,0},{123,0,21,0,8,-1,0},{123,0,21,0,8,-1,0},{123,0,21,0,8,-1,0},{123,0,21,0,8,-1,0},{123,0,21,0,8,-1,0},{123,0,21,0,8,-1,0},{123,0,21,0,8,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,7,0,7,-1,0},{123,0,12,17,7,-1,0},{123,0,12,17,7,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0}},
  {{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1}},
  {{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,7,0,7,-1,1},{114,0,10,0,7,-1,1},{114,0,10,0,7,-1,1},{114,0,10,0,7,-1,1},{114,0,12,17,7,-1,1},{114,0,12,17,7,-1,1},{114,0,12,17,7,-1,1},{114,0,12,17,7,-1,1},{114,0,12,17,7,-1,1},{114,0,12,17,7,-1,1},{114,0,12,17,7,-1,1},{114,0,12,17,7,-1,1},{114,0,10,0,7,-1,1},{114,0,10,0,7,-1,1},{114,0,12,17,7,-1,1},{114,0,10,0,7,-1,1},{114,0,12,17,7,-1,1}},
  {{114,0,12,17,7,-1,1},{114,0,21,0,8,-1,1},{114,0,21,0,8,-1,1},{114,0,21,0,8,-1,1},{114,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{114,0,13,0,7,0,1},{114,0,13,0,7,1,1},{114,0,13,0,7,2,1},{114,0,13,0,7,3,1},{114,0,13,0,7,4,1},{114,0,13,0,7,5,1},{114,0,13,0,7,6,1},{114,0,13,0,7,7,1},{114,0,13,0,7,8,1},{114,0,13,0,7,9,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1}},
  {{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,7,0,7,-1,1},{102,0,12,17,7,-1,1},{102,0,10,0,7,-1,1},{102,0,12,17,7,-1,1},{102,0,10,0,7,-1,1},{102,0,10,0,7,-1,1},{102,0,12,17,7,-1,1},{102,0,12,17,7,-1,1},{102,0,12,17,7,-1,1},{102,0,12,17,7,-1,1},{102,0,12,17,7,-1,1},{102,0,12,17,7,-1,1},{102,0,10,0,7,-1,1},{102,0,12,17,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{102,0,13,0,7,0,1},{102,0,13,0,7,1,1},{102,0,13,0,7,2,1},{102,0,13,0,7,3,1},{102,0,13,0,7,4,1},{102,0,13,0,7,5,1},{102,0,13,0,7,6,1},{102,0,13,0,7,7,1},{102,0,13,0,7,8,1},{102,0,13,0,7,9,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{126,0,7,0,7,-1,1},{126,0,7,0,7,-1,1},{126,0,7,0,7,-1,1},{126,0,7,0,7,-1,1},{126,0,7,0,7,-1,1},{126,0,7,0,7,-1,1},{126,0,7,0,7,-1,1},{126,0,7,0,7,-1,1},{126,0,7,0,7,-1,1},{126,0,7,0,7,-1,1},{126,0,7,0,7,-1,1},{126,0,7,0,7,-1,1},{126,0,7,0,7,-1,1},{126,0,7,0,7,-1,1},{126,0,7,0,7,-1,1},{126,0,7,0,7,-1,1},{126,0,7,0,7,-1,1},{126,0,7,0,7,-1,1},{126,0,7,0,7,-1,1},{126,0,7,0,7,-1,1},{126,0,7,0,7,-1,1},{126,0,7,0,7,-1,1},{126,0,7,0,7,-1,1},{126,0,7,0,7,-1,1},{126,0,7,0,7,-1,1},{126,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{126,0,12,17,7,-1,1},{126,0,12,17,7,-1,1},{126,0,12,17,7,-1,1}},
  {{126,0,10,0,7,-1,1},{126,0,10,0,7,-1,1},{126,0,12,17,7,-1,1},{126,0,12,17,7,-1,1},{126,0,12,17,7,-1,1},{126,0,12,17,7,-1,1},{126,0,10,0,7,-1,1},{126,0,12,17,7,-1,1},{126,0,12,17,7,-1,1},{126,0,12,17,7,-1,1},{126,0,12,17,7,-1,1},{126,0,12,17,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{126,0,13,0,7,0,1},{126,0,13,0,7,1,1},{126,0,13,0,7,2,1},{126,0,13,0,7,3,1},{126,0,13,0,7,4,1},{126,0,13,0,7,5,1},{126,0,13,0,7,6,1},{126,0,13,0,7,7,1},{126,0,13,0,7,8,1},{126,0,13,0,7,9,1},{126,0,15,0,8,-1,1},{126,0,15,0,8,-1,1},{126,0,21,0,8,-1,1},{126,0,21,0,8,-1,1},{126,0,21,0,8,-1,1},{126,0,26,0,8,-1,1}},
  {{125,0,9,0,7,-1,1},{125,0,9,0,7,-1,1},{125,0,9,0,7,-1,1},{125,0,9,0,7,-1,1},{125,0,9,0,7,-1,1},{125,0,9,0,7,-1,1},{125,0,9,0,7,-1,1},{125,0,9,0,7,-1,1},{125,0,9,0,7,-1,1},{125,0,9,0,7,-1,1},{125,0,9,0,7,-1,1},{125,0,9,0,7,-1,1},{125,0,9,0,7,-1,1},{125,0,9,0,7,-1,1},{125,0,9,0,7,-1,1},{125,0,9,0,7,-1,1},{125,0,9,0,7,-1,1},{125,0,9,0,7,-1,1},{125,0,9,0,7,-1,1},{125,0,9,0,7,-1,1},{125,0,9,0,7,-1,1},{125,0,9,0,7,-1,1},{125,0,9,0,7,-1,1},{125,0,9,0,7,-1,1},{125,0,9,0,7,-1,1},{125,0,9,0,7,-1,1},{125,0,9,0,7,-1,1},{125,0,9,0,7,-1,1},{125,0,9,0,7,-1,1},{125,0,9,0,7,-1,1},{125,0,9,0,7,-1,1},{125,0,9,0,7,-1,1}},
  {{125,0,5,0,7,-1,1},{125,0,5,0,7,-1,1},{125,0,5,0,7,-1,1},{125,0,5,0,7,-1,1},{125,0,5,0,7,-1,1},{125,0,5,0,7,-1,1},{125,0,5,0,7,-1,1},{125,0,5,0,7,-1,1},{125,0,5,0,7,-1,1},{125,0,5,0,7,-1,1},{125,0,5,0,7,-1,1},{125,0,5,0,7,-1,1},{125,0,5,0,7,-1,1},{125,0,5,0,7,-1,1},{125,0,5,0,7,-1,1},{125,0,5,0,7,-1,1},{125,0,5,0,7,-1,1},{125,0,5,0,7,-1,1},{125,0,5,0,7,-1,1},{125,0,5,0,7,-1,1},{125,0,5,0,7,-1,1},{125,0,5,0,7,-1,1},{125,0,5,0,7,-1,1},{125,0,5,0,7,-1,1},{125,0,5,0,7,-1,1},{125,0,5,0,7,-1,1},{125,0,5,0,7,-1,1},{125,0,5,0,7,-1,1},{125,0,5,0,7,-1,1},{125,0,5,0,7,-1,1},{125,0,5,0,7,-1,1},{125,0,5,0,7,-1,1}},
  {{125,0,13,0,7,0,1},{125,0,13,0,7,1,1},{125,0,13,0,7,2,1},{125,0,13,0,7,3,1},{125,0,13,0,7,4,1},{125,0,13,0,7,5,1},{125,0,13,0,7,6,1},{125,0,13,0,7,7,1},{125,0,13,0,7,8,1},{125,0,13,0,7,9,1},{125,0,15,0,8,-1,1},{125,0,15,0,8,-1,1},{125,0,15,0,8,-1,1},{125,0,15,0,8,-1,1},{125,0,15,0,8,-1,1},{125,0,15,0,8,-1,1},{125,0,15,0,8,-1,1},{125,0,15,0,8,-1,1},{125,0,15,0,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{125,0,7,0,7,-1,1}},
  {{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1}},
  {{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{121,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1}},
  {{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1}},
  {{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{63,0,14,0,7,-1,1},{61,0,2,0,12,-1,1},{63,0,21,0,8,-1,1},{63,0,21,0,8,-1,1},{63,0,21,0,8,-1,1},{63,0,21,0,8,-1,1},{63,0,21,0,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{63,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0}},
  {{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{80,0,7,0,7,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{127,0,7,0,7,-1,1},{127,0,7,0,7,-1,1},{127,0,7,0,7,-1,1},{127,0,7,0,7,-1,1},{127,0,7,0,7,-1,1},{127,0,7,0,7,-1,1},{127,0,7,0,7,-1,1},{127,0,7,0,7,-1,1},{127,0,7,0,7,-1,1},{127,0,7,0,7,-1,1},{127,0,7,0,7,-1,1},{127,0,7,0,7,-1,1},{127,0,7,0,7,-1,1},{127,0,7,0,7,-1,1},{127,0,7,0,7,-1,1},{127,0,7,0,7,-1,1},{127,0,7,0,7,-1,1},{127,0,7,0,7,-1,1},{127,0,7,0,7,-1,1},{127,0,7,0,7,-1,1},{127,0,7,0,7,-1,1},{127,0,7,0,7,-1,1},{127,0,7,0,7,-1,1},{127,0,7,0,7,-1,1},{127,0,7,0,7,-1,1},{127,0,7,0,7,-1,1},{127,0,7,0,7,-1,1},{127,0,7,0,7,-1,1},{127,0,7,0,7,-1,1},{127,0,7,0,7,-1,1},{127,0,7,0,7,-1,1},{127,0,7,0,7,-1,1}},
  {{127,0,7,0,7,-1,1},{127,0,7,0,7,-1,1},{127,0,7,0,7,-1,1},{127,0,7,0,7,-1,1},{127,0,7,0,7,-1,1},{127,0,7,0,7,-1,1},{127,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{79,0,7,0,6,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{115,0,7,0,7,-1,1},{115,0,7,0,7,-1,1},{115,0,7,0,7,-1,1},{115,0,7,0,7,-1,1},{115,0,7,0,7,-1,1},{115,0,7,0,7,-1,1},{115,0,7,0,7,-1,1},{115,0,7,0,7,-1,1},{115,0,7,0,7,-1,1},{115,0,7,0,7,-1,1},{115,0,7,0,7,-1,1},{115,0,7,0,7,-1,1},{115,0,7,0,7,-1,1},{115,0,7,0,7,-1,1},{115,0,7,0,7,-1,1},{115,0,7,0,7,-1,1},{115,0,7,0,7,-1,1},{115,0,7,0,7,-1,1},{115,0,7,0,7,-1,1},{115,0,7,0,7,-1,1},{115,0,7,0,7,-1,1},{115,0,7,0,7,-1,1},{115,0,7,0,7,-1,1},{115,0,7,0,7,-1,1},{115,0,7,0,7,-1,1},{115,0,7,0,7,-1,1},{115,0,7,0,7,-1,1},{115,0,7,0,7,-1,1},{115,0,7,0,7,-1,1},{115,0,7,0,7,-1,1},{115,0,7,0,7,-1,1},{61,0,2,0,12,-1,1}},
  {{115,0,13,0,7,0,1},{115,0,13,0,7,1,1},{115,0,13,0,7,2,1},{115,0,13,0,7,3,1},{115,0,13,0,7,4,1},{115,0,13,0,7,5,1},{115,0,13,0,7,6,1},{115,0,13,0,7,7,1},{115,0,13,0,7,8,1},{115,0,13,0,7,9,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{115,0,21,0,8,-1,1},{115,0,21,0,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{103,0,7,0,7,-1,1},{103,0,7,0,7,-1,1},{103,0,7,0,7,-1,1},{103,0,7,0,7,-1,1},{103,0,7,0,7,-1,1},{103,0,7,0,7,-1,1},{103,0,7,0,7,-1,1},{103,0,7,0,7,-1,1},{103,0,7,0,7,-1,1},{103,0,7,0,7,-1,1},{103,0,7,0,7,-1,1},{103,0,7,0,7,-1,1},{103,0,7,0,7,-1,1},{103,0,7,0,7,-1,1},{103,0,7,0,7,-1,1},{103,0,7,0,7,-1,1}},
  {{103,0,7,0,7,-1,1},{103,0,7,0,7,-1,1},{103,0,7,0,7,-1,1},{103,0,7,0,7,-1,1},{103,0,7,0,7,-1,1},{103,0,7,0,7,-1,1},{103,0,7,0,7,-1,1},{103,0,7,0,7,-1,1},{103,0,7,0,7,-1,1},{103,0,7,0,7,-1,1},{103,0,7,0,7,-1,1},{103,0,7,0,7,-1,1},{103,0,7,0,7,-1,1},{103,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{103,0,12,17,7,-1,1},{103,0,12,17,7,-1,1},{103,0,12,17,7,-1,1},{103,0,12,17,7,-1,1},{103,0,12,17,7,-1,1},{103,0,21,0,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1}},
  {{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,12,17,7,-1,1},{119,0,12,17,7,-1,1},{119,0,12,17,7,-1,1},{119,0,12,17,7,-1,1},{119,0,12,17,7,-1,1},{119,0,12,17,7,-1,1},{119,0,12,17,7,-1,1},{119,0,21,0,8,-1,1},{119,0,21,0,8,-1,1},{119,0,21,0,8,-1,1},{119,0,21,0,8,-1,1},{119,0,21,0,8,-1,1},{119,0,26,0,8,-1,1},{119,0,26,0,8,-1,1},{119,0,26,0,8,-1,1},{119,0,26,0,8,-1,1}},
  {{119,0,6,0,7,-1,1},{119,0,6,0,7,-1,1},{119,0,6,0,7,-1,1},{119,0,6,0,7,-1,1},{119,0,21,0,8,-1,1},{119,0,26,0,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{119,0,13,0,7,0,1},{119,0,13,0,7,1,1},{119,0,13,0,7,2,1},{119,0,13,0,7,3,1},{119,0,13,0,7,4,1},{119,0,13,0,7,5,1},{119,0,13,0,7,6,1},{119,0,13,0,7,7,1},{119,0,13,0,7,8,1},{119,0,13,0,7,9,1},{61,0,2,0,12,-1,1},{119,0,15,0,8,-1,1},{119,0,15,0,8,-1,1},{119,0,15,0,8,-1,1},{119,0,15,0,8,-1,1},{119,0,15,0,8,-1,1}},
  {{119,0,15,0,8,-1,1},{119,0,15,0,8,-1,1},{61,0,2,0,12,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1}},
  {{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{119,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{99,0,7,0,5,-1,1},{99,0,7,0,5,-1,1},{99,0,7,0,5,-1,1},{99,0,7,0,5,-1,1},{99,0,7,0,5,-1,1},{99,0,7,0,5,-1,1},{99,0,7,0,5,-1,1},{99,0,7,0,5,-1,1},{99,0,7,0,5,-1,1},{99,0,7,0,5,-1,1},{99,0,7,0,5,-1,1},{99,0,7,0,5,-1,1},{99,0,7,0,5,-1,1},{99,0,7,0,5,-1,1},{99,0,7,0,5,-1,1},{99,0,7,0,5,-1,1},{99,0,7,0,5,-1,1},{99,0,7,0,5,-1,1},{99,0,7,0,5,-1,1},{99,0,7,0,5,-1,1},{99,0,7,0,5,-1,1},{99,0,7,0,5,-1,1},{99,0,7,0,5,-1,1},{99,0,7,0,5,-1,1},{99,0,7,0,5,-1,1},{99,0,7,0,5,-1,1},{99,0,7,0,5,-1,1},{99,0,7,0,5,-1,1},{99,0,7,0,5,-1,1},{99,0,7,0,5,-1,1},{99,0,7,0,5,-1,1},{99,0,7,0,5,-1,1}},
  {{99,0,7,0,5,-1,1},{99,0,7,0,5,-1,1},{99,0,7,0,5,-1,1},{99,0,7,0,5,-1,1},{99,0,7,0,5,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{99,0,7,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1}},
  {{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{99,0,10,0,5,-1,1},{61,0,2,0,12,-1,1}},
  {{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{99,0,12,17,5,-1,1},{99,0,12,17,5,-1,1},{99,0,12,17,5,-1,1},{99,0,12,17,5,-1,1},{99,0,6,0,5,-1,1},{99,0,6,0,5,-1,1},{99,0,6,0,5,-1,1},{99,0,6,0,5,-1,1},{99,0,6,0,5,-1,1},{99,0,6,0,5,-1,1},{99,0,6,0,5,-1,1},{99,0,6,0,5,-1,1},{99,0,6,0,5,-1,1},{99,0,6,0,5,-1,1},{99,0,6,0,5,-1,1},{99,0,6,0,5,-1,1},{99,0,6,0,5,-1,1}},
  {{22,0,7,0,4,-1,0},{20,0,7,0,4,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0}},
  {{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1}},
  {{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{105,0,7,0,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{105,0,26,0,8,-1,1},{105,0,12,17,7,-1,1},{105,0,12,17,7,-1,1},{105,0,21,0,8,-1,1}},
  {{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0}},
  {{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0}},
  {{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0}},
  {{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0}},
  {{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,10,0,7,-1,0},{0,0,10,0,7,-1,0},{1,0,12,17,7,-1,0},{1,0,12,17,7,-1,0},{1,0,12,17,7,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,10,0,7,-1,0},{0,0,10,0,7,-1,0},{0,0,10,0,7,-1,0},{0,0,10,0,7,-1,0},{0,0,10,0,7,-1,0},{0,0,10,0,7,-1,0},{0,0,1,18,10,-1,0},{0,0,1,18,10,-1,0},{0,0,1,18,10,-1,0},{0,0,1,18,10,-1,0},{0,0,1,18,10,-1,0},{0,0,1,18,10,-1,0},{0,0,1,18,10,-1,0},{0,0,1,18,10,-1,0},{1,0,12,17,7,-1,0},{1,0,12,17,7,-1,0},{1,0,12,17,7,-1,0},{1,0,12,17,7,-1,0},{1,0,12,17,7,-1,0}},
  {{1,0,12,17,7,-1,0},{1,0,12,17,7,-1,0},{1,0,12,17,7,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{1,0,12,17,7,-1,0},{1,0,12,17,7,-1,0},{1,0,12,17,7,-1,0},{1,0,12,17,7,-1,0},{1,0,12,17,7,-1,0},{1,0,12,17,7,-1,0},{1,0,12,17,7,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0}},
  {{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{1,0,12,17,7,-1,0},{1,0,12,17,7,-1,0},{1,0,12,17,7,-1,0},{1,0,12,17,7,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0}},
  {{0,0,26,0,9,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0}},
  {{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0}},
  {{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1}},
  {{14,0,26,10,8,-1,1},{14,0,26,10,8,-1,1},{14,0,12,17,7,-1,1},{14,0,12,17,7,-1,1},{14,0,12,17,7,-1,1},{14,0,26,10,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0}},
  {{0,0,15,0,8,-1,0},{0,0,15,0,8,-1,0},{0,0,15,0,8,-1,0},{0,0,15,0,8,-1,0},{0,0,15,0,8,-1,0},{0,0,15,0,8,-1,0},{0,0,15,0,8,-1,0},{0,0,15,0,8,-1,0},{0,0,15,0,8,-1,0},{0,0,15,0,8,-1,0},{0,0,15,0,8,-1,0},{0,0,15,0,8,-1,0},{0,0,15,0,8,-1,0},{0,0,15,0,8,-1,0},{0,0,15,0,8,-1,0},{0,0,15,0,8,-1,0},{0,0,15,0,8,-1,0},{0,0,15,0,8,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0}},
  {{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1}},
  {{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1}},
  {{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{61,0,2,0,12,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1}},
  {{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1}},
  {{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,9,0,9,-1,1},{61,0,2,0,12,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1}},
  {{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{0,0,9,0,9,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{61,0,2,0,12,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{61,0,2,0,12,-1,1},{0,0,5,0,9,-1,1},{61,0,2,0,12,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1}},
  {{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{61,0,2,0,12,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1}},
  {{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1}},
  {{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{61,0,2,0,12,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{61,0,2,0,12,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{61,0,2,0,12,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1}},
  {{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{61,0,2,0,12,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{61,0,2,0,12,-1,1}},
  {{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{61,0,2,0,12,-1,1},{0,0,9,0,9,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{61,0,2,0,12,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1}},
  {{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1}},
  {{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1}},
  {{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1}},
  {{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1}},
  {{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1}},
  {{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1}},
  {{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1}},
  {{0,0,9,0,9,-1,1},{0,0,25,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,25,10,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1}},
  {{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,25,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1}},
  {{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,25,10,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1}},
  {{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,25,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1}},
  {{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,25,10,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1}},
  {{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,25,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1}},
  {{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,25,10,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1}},
  {{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,25,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1}},
  {{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,25,10,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,5,0,9,-1,1},{0,0,9,0,9,-1,1},{0,0,5,0,9,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{0,0,13,2,9,0,1},{0,0,13,2,9,1,1},{0,0,13,2,9,2,1},{0,0,13,2,9,3,1},{0,0,13,2,9,4,1},{0,0,13,2,9,5,1},{0,0,13,2,9,6,1},{0,0,13,2,9,7,1},{0,0,13,2,9,8,1},{0,0,13,2,9,9,1},{0,0,13,2,9,0,1},{0,0,13,2,9,1,1},{0,0,13,2,9,2,1},{0,0,13,2,9,3,1},{0,0,13,2,9,4,1},{0,0,13,2,9,5,1},{0,0,13,2,9,6,1},{0,0,13,2,9,7,1}},
  {{0,0,13,2,9,8,1},{0,0,13,2,9,9,1},{0,0,13,2,9,0,1},{0,0,13,2,9,1,1},{0,0,13,2,9,2,1},{0,0,13,2,9,3,1},{0,0,13,2,9,4,1},{0,0,13,2,9,5,1},{0,0,13,2,9,6,1},{0,0,13,2,9,7,1},{0,0,13,2,9,8,1},{0,0,13,2,9,9,1},{0,0,13,2,9,0,1},{0,0,13,2,9,1,1},{0,0,13,2,9,2,1},{0,0,13,2,9,3,1},{0,0,13,2,9,4,1},{0,0,13,2,9,5,1},{0,0,13,2,9,6,1},{0,0,13,2,9,7,1},{0,0,13,2,9,8,1},{0,0,13,2,9,9,1},{0,0,13,2,9,0,1},{0,0,13,2,9,1,1},{0,0,13,2,9,2,1},{0,0,13,2,9,3,1},{0,0,13,2,9,4,1},{0,0,13,2,9,5,1},{0,0,13,2,9,6,1},{0,0,13,2,9,7,1},{0,0,13,2,9,8,1},{0,0,13,2,9,9,1}},
  {{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1}},
  {{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1}},
  {{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1}},
  {{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,12,17,7,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1}},
  {{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,12,17,7,-1,1},{131,0,26,0,8,-1,1},{131,0,26,0,8,-1,1},{131,0,21,0,8,-1,1},{131,0,21,0,8,-1,1},{131,0,21,0,8,-1,1},{131,0,21,0,8,-1,1},{131,0,21,0,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1}},
  {{61,0,2,0,12,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{131,0,12,17,7,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{113,0,7,1,7,-1,1},{113,0,7,1,7,-1,1},{113,0,7,1,7,-1,1},{113,0,7,1,7,-1,1},{113,0,7,1,7,-1,1},{113,0,7,1,7,-1,1},{113,0,7,1,7,-1,1},{113,0,7,1,7,-1,1},{113,0,7,1,7,-1,1},{113,0,7,1,7,-1,1},{113,0,7,1,7,-1,1},{113,0,7,1,7,-1,1},{113,0,7,1,7,-1,1},{113,0,7,1,7,-1,1},{113,0,7,1,7,-1,1},{113,0,7,1,7,-1,1},{113,0,7,1,7,-1,1},{113,0,7,1,7,-1,1},{113,0,7,1,7,-1,1},{113,0,7,1,7,-1,1},{113,0,7,1,7,-1,1},{113,0,7,1,7,-1,1},{113,0,7,1,7,-1,1},{113,0,7,1,7,-1,1},{113,0,7,1,7,-1,1},{113,0,7,1,7,-1,1},{113,0,7,1,7,-1,1},{113,0,7,1,7,-1,1},{113,0,7,1,7,-1,1},{113,0,7,1,7,-1,1},{113,0,7,1,7,-1,1},{113,0,7,1,7,-1,1}},
  {{113,0,7,1,7,-1,1},{113,0,7,1,7,-1,1},{113,0,7,1,7,-1,1},{113,0,7,1,7,-1,1},{113,0,7,1,7,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{113,0,15,1,8,-1,1},{113,0,15,1,8,-1,1},{113,0,15,1,8,-1,1},{113,0,15,1,8,-1,1},{113,0,15,1,8,-1,1},{113,0,15,1,8,-1,1},{113,0,15,1,8,-1,1},{113,0,15,1,8,-1,1},{113,0,15,1,8,-1,1},{113,0,12,17,7,-1,1},{113,0,12,17,7,-1,1},{113,0,12,17,7,-1,1},{113,0,12,17,7,-1,1},{113,0,12,17,7,-1,1},{113,0,12,17,7,-1,1},{113,0,12,17,7,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1},{61,0,2,1,12,-1,1}},
  {{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{61,0,2,13,12,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1}},
  {{61,0,2,13,12,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{61,0,2,13,12,-1,1},{2,0,7,13,9,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{2,0,7,13,9,-1,1},{61,0,2,13,12,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{61,0,2,13,12,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{61,0,2,13,12,-1,1},{2,0,7,13,9,-1,1},{61,0,2,13,12,-1,1},{2,0,7,13,9,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1}},
  {{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{2,0,7,13,9,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{2,0,7,13,9,-1,1},{61,0,2,13,12,-1,1},{2,0,7,13,9,-1,1},{61,0,2,13,12,-1,1},{2,0,7,13,9,-1,1},{61,0,2,13,12,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{61,0,2,13,12,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{61,0,2,13,12,-1,1},{2,0,7,13,9,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{2,0,7,13,9,-1,1},{61,0,2,13,12,-1,1},{2,0,7,13,9,-1,1},{61,0,2,13,12,-1,1},{2,0,7,13,9,-1,1},{61,0,2,13,12,-1,1},{2,0,7,13,9,-1,1},{61,0,2,13,12,-1,1},{2,0,7,13,9,-1,1}},
  {{61,0,2,13,12,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{61,0,2,13,12,-1,1},{2,0,7,13,9,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{61,0,2,13,12,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{61,0,2,13,12,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{61,0,2,13,12,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{61,0,2,13,12,-1,1},{2,0,7,13,9,-1,1},{61,0,2,13,12,-1,1}},
  {{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{61,0,2,13,12,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1}},
  {{61,0,2,13,12,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{61,0,2,13,12,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{61,0,2,13,12,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{2,0,7,13,9,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1}},
  {{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{2,0,25,10,8,-1,1},{2,0,25,10,8,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1},{61,0,2,13,12,-1,1}},
  {{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0}},
  {{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0}},
  {{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0}},
  {{61,0,2,0,12,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{61,0,2,0,12,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0}},
  {{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0}},
  {{0,0,15,2,9,0,0},{0,0,15,2,9,0,0},{0,0,15,2,9,1,0},{0,0,15,2,9,2,0},{0,0,15,2,9,3,0},{0,0,15,2,9,4,0},{0,0,15,2,9,5,0},{0,0,15,2,9,6,0},{0,0,15,2,9,7,0},{0,0,15,2,9,8,0},{0,0,15,2,9,9,0},{0,0,15,10,8,-1,0},{0,0,15,10,8,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0}},
  {{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{61,0,2,0,12,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0}},
  {{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0}},
  {{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,10,9,-1,0},{0,0,26,10,9,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0}},
  {{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0}},
  {{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0},{0,0,26,0,8,-1,0}},
  {{20,0,26,0,9,-1,2},{0,0,26,0,9,-1,2},{0,0,26,0,9,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0}},
  {{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0}},
  {{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{0,0,26,0,9,-1,0},{0,0,26,0,9,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0}},
  {{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,24,10,8,-1,0},{0,0,24,10,8,-1,0},{0,0,24,10,8,-1,0},{0,0,24,10,8,-1,0},{0,0,24,10,8,-1,0}},
  {{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{61,0,2,0,12,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0}},
  {{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{61,0,2,0,12,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0}},
  {{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0}},
  {{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0}},
  {{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{0,0,26,10,8,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0}},
  {{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1}},
  {{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1}},
  {{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{0,0,26,10,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{0,0,26,10,8,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0}},
  {{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0}},
  {{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0}},
  {{17,0,7,0,0,-1,0},{17,0,7,0,0,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0}},
  {{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{17,0,7,0,9,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0}},
  {{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,0},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{61,0,2,0,12,-1,1},{0,0,1,18,11,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1}},
  {{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,10,-1,1},{0,0,1,18,11,-1,1}},
  {{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1}},
  {{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{1,0,12,17,10,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}},
  {{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,3,0,12,-1,0},{61,0,2,0,12,-1,1},{61,0,2,0,12,-1,1}}
};

#define kHanVariantMaxPlane  2
#define kHanVariantIndexBits 9
#define kHanVariantCharBits  7
static const uint8_t sHanVariantPlanes[2] = {1,2};

static const uint16_t sHanVariantPages[3][512] = {
  {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,2,0,0,0,0,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,16,18,19,16,20,16,21,16,22,23,24,25,26,27,28,29,16,16,30,31,32,33,16,34,35,16,36,37,38,16,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,16,210,211,0,0,0,0,0,0,0,0,0,0},
  {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,212,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {16,16,16,213,214,16,215,216,16,16,16,16,16,217,16,218,219,16,16,16,16,16,16,220,16,221,222,16,16,16,16,16,16,16,223,16,16,224,16,16,225,226,16,16,16,16,227,228,229,230,16,16,16,16,231,232,16,16,16,233,16,16,16,234,16,16,16,16,16,235,16,16,16,16,16,16,236,237,16,16,16,238,16,16,16,239,240,16,16,16,16,241,242,16,243,16,16,16,16,244,16,16,245,246,247,16,16,248,249,16,250,251,252,16,16,16,16,16,253,254,16,16,16,255,256,257,258,259,260,16,16,261,262,263,16,16,16,219,16,16,16,16,16,264,265,16,16,266,16,267,16,16,16,268,16,269,270,16,237,266,16,16,271,272,16,16,230,16,273,16,274,275,16,16,16,16,16,276,16,277,278,16,279,280,281,16,282,16,283,284,285,286,16,287,16,16,288,16,16,16,16,16,16,16,16,289,290,291,16,292,16,16,293,294,16,16,233,16,16,16,16,16,16,16,16,16,16,16,295,16,16,16,16,296,215,16,16,16,297,16,16,16,16,16,298,16,16,299,16,300,31,301,302,16,16,235,303,304,305,306,307,308,16,309,310,16,16,16,16,16,16,16,16,16,311,312,16,313,16,314,315,316,317,318,319,16,320,16,16,16,16,16,16,16,16,321,266,260,16,322,323,324,325,326,327,328,329,330,331,16,332,333,334,335,336,337,338,16,339,340,341,342,343,31,344,242,16,345,16,16,346,16,347,348,16,349,350,351,16,16,352,16,16,16,16,16,16,16,16,353,16,354,355,356,357,16,16,16,358,248,359,360,361,362,363,364,365,16,366,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,367,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,16,16,16,368,0,0,0,0,0,0,0,0,0,0,0}
};

static const uint8_t sHanVariantValues[369][32] = {
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xcf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf7,0xff,0x7f,0xfd,0xff,0xff,0xfd,0xff,0xff,0xff,0xff,0xf7,0xbf,0xbf,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xbf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf7,0xfe,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xf7,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xdf,0xff,0xff,0xff,0xff,0xdf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xef,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xdf,0xff,0xff,0xef,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xff,0xff,0xff,0xff,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0x7d,0xfd,0xff,0xff,0xff,0xff,0xff,0x7f},
  {0xff,0xfe,0xff,0xbf,0xff,0xff,0xff,0xff,0xef,0xff,0xff,0xff,0xff,0xbf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xef,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xdf,0xff,0xff,0xff,0xff,0xff,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xbf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfb,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xef,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xef,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xf5,0xff,0xff,0x7f,0xff,0xff,0xff,0xff,0xfd,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfe,0xff,0xff,0xff,0xff,0xbf,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x5f,0xff,0xff,0xff,0xff,0x7f,0xfd,0xff,0xff,0xff,0xfd,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf7,0xdf,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xff,0xff,0xff,0xff,0xff,0xf5,0xff,0xff,0xd5,0xff,0xff,0xff,0xff,0xff,0xff,0xf7},
  {0xff,0xff,0xf7,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xdf,0xff,0xf7,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xbf},
  {0xff,0xff,0xff,0xb7,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf7,0xff,0x7f,0xff,0xff,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xbf,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf7,0xff,0xff,0xff,0xff,0xfb,0xff,0xff,0xff,0xff,0xff,0xff,0xdf,0xff,0xff,0xff,0xff,0xef,0xff,0xff,0xff,0xbf,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf7,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf7,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xdf,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xdf,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfb,0xff,0xff,0xfd,0xff,0xfe,0xef,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfb,0xff,0xbf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xeb,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xbf,0xbf},
  {0xff,0xff,0xbe,0xff,0xff,0xef,0xff,0xbb,0xff,0xfb,0xff,0xff,0xfe,0x5f,0x55,0xd5,0xf5,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf7,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xbf,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xdf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xbf},
  {0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xdf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xdf,0xfd,0x7f,0xff,0xff,0xff,0xfb,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0x75,0xf7,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf7,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xbf,0xfe},
  {0xff,0xff,0xfe,0xd5,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xdf,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xd5,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xbf,0xff,0xff,0xfb,0xff,0xff,0xff,0xff,0xff,0xfb,0xff,0xfb,0xff,0xdf,0x57},
  {0x55,0xf7,0xff,0xff,0xff,0xff,0xbe,0xbf,0xff,0xff,0xff,0xff,0xbf,0x5f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xef,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xbf,0xff,0xbf,0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfe,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xfe,0xeb,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xbe,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xdf,0xff,0xff,0xff,0xff,0xbf},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xeb,0xfe,0xff,0xbf,0xff,0xbf,0xff,0xff,0xef,0x7e,0xf5,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xef,0xff,0xff,0xff,0xff,0xff,0xff,0xfb,0xff,0xff,0xff,0xff,0xfe,0xfe,0xbf,0xff,0xfb},
  {0xfb,0xff,0xff,0xff,0xff,0xef,0xff,0x57,0x55,0xfd,0xff,0xff,0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xfb,0xff,0x7f,0x55,0xf5,0xff,0xff,0xff,0xff,0xfe,0xff,0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xdf,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  {0xff,0x7f,0xff,0xdf,0x77,0xff,0x5f,0xb5,0xdf,0x65,0xdf,0xff,0xfd,0xfd,0xdf,0xd7,0xff,0xff,0xf5,0xfd,0xfd,0xfd,0xff,0xff,0xf5,0xdf,0xff,0xff,0xf5,0xff,0xff,0xef},
  {0xef,0xff,0xf7,0x5f,0xf7,0xff,0xdf,0xef,0xff,0x7f,0xf7,0xff,0xdf,0xf7,0xfd,0x7f,0xff,0xd7,0xff,0xdf,0x77,0xff,0xff,0xff,0xff,0xff,0xdf,0xfd,0xff,0x7f,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0x7f,0x5d,0x5f,0x75,0x55,0x5f,0xff,0xff,0xff,0xff,0xff,0xff,0xbf,0xff,0xff,0x7f,0xff,0xff,0xff,0x7f,0xf7,0xff,0xff,0xff,0xfb,0xff,0xff},
  {0xff,0xef,0xff,0xff,0xff,0xef,0xff,0xff,0x7d,0x57,0xd5,0xfd,0xff,0xef,0xff,0xff,0xeb,0xff,0xff,0xff,0xff,0xfe,0xff,0xff,0x7e,0xdb,0x55,0xf7,0xff,0xff,0xff,0xff},
  {0xfe,0xef,0xba,0xff,0xfb,0xff,0xff,0xff,0xff,0xff,0xbf,0xff,0xef,0xff,0xdf,0xdf,0xff,0xff,0xfb,0xff,0xfb,0xff,0xff,0xff,0xff,0xff,0xff,0xfd,0xff,0xfa,0x7f,0x5b},
  {0xff,0xff,0xff,0xff,0xfb,0xef,0xfa,0xff,0xff,0x77,0xf5,0xbb,0xbf,0xba,0xff,0xef,0xef,0xfb,0xfb,0xff,0xfb,0xfb,0xff,0xef,0xff,0xfb,0xfe,0xff,0xff,0xff,0xfb,0xff},
  {0xee,0xfe,0xfa,0xff,0xfe,0xfa,0xfe,0xbf,0xbf,0xff,0xef,0xff,0xef,0xbf,0xae,0x7e,0xff,0xff,0x7f,0xfe,0xe7,0x9f,0xdf,0xff,0xff,0xbf,0xfb,0xff,0x7d,0xfd,0x77,0xf7},
  {0xf7,0xf7,0xed,0xfd,0xff,0xff,0x77,0xfd,0xff,0xff,0xef,0x7f,0x5f,0xf7,0x7f,0xff,0xfd,0xdf,0xf6,0x7b,0xf7,0xff,0x7b,0xfe,0xfd,0xfd,0x7f,0x77,0xfb,0xff,0x7f,0x7f},
  {0xff,0xff,0xff,0xf7,0xdf,0xff,0x55,0xff,0xfd,0xfb,0x6f,0xd5,0xff,0xdf,0xf7,0x57,0xdd,0xbe,0xbf,0xef,0xf5,0xbf,0xbf,0xfb,0xff,0x77,0xff,0xef,0xff,0xfa,0xff,0xef},
  {0xbf,0xbf,0xeb,0xba,0xfb,0xff,0xef,0xd7,0xd7,0xff,0xfd,0xff,0x57,0xff,0xff,0x7f,0xfb,0xff,0x7f,0xff,0xff,0xfb,0x9b,0xeb,0xef,0xff,0xfb,0xff,0xfb,0xfb,0xbe,0xff},
  {0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xdf,0xff,0x9b,0xfb,0xff,0x5f,0xff,0xfe,0xff,0xff,0x5f,0xff,0xd6,0xff,0xff,0xdf,0xfd,0x7f,0xff,0xff,0xfd,0xbf,0xff},
  {0xdf,0xd7,0x77,0xf5,0xfd,0xf7,0xf9,0xff,0x5f,0xdf,0xf5,0xdb,0xef,0xfe,0xff,0x7f,0x97,0xfe,0xff,0xfd,0xf7,0xff,0xf5,0xff,0xed,0xff,0xdf,0xff,0xff,0x5f,0xf7,0xf7},
  {0xff,0xff,0xff,0xff,0x67,0x77,0xff,0xff,0x7f,0xff,0xfd,0x7d,0xbf,0xed,0xff,0xff,0xef,0xff,0xff,0xff,0x5d,0x57,0x75,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0x7f,0xff,0xff,0x77,0xf7,0xff,0xfd,0xff,0xff,0xff,0xff,0xfd,0xfe,0xff,0xff,0xff,0xf7,0x57,0x75,0xf7,0x75,0xfb,0xff,0xff,0xbf,0xff,0xff,0xff,0xff},
  {0xff,0xfe,0xff,0xff,0xff,0xff,0x6f,0xf7,0xd5,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xbf,0xff,0xff,0xff,0xaf,0xef,0x7f,0xff,0x55,0xfd,0xfd,0xfd,0xff},
  {0xff,0xff,0xff,0xef,0xff,0xff,0xef,0xff,0xff,0xff,0xef,0xee,0xef,0x7f,0xff,0xd7,0xff,0xaf,0xef,0xef,0xff,0xff,0xef,0xff,0xff,0xff,0x7b,0xff,0x7f,0xef,0xfb,0xff},
  {0xff,0xef,0xff,0xfb,0xbf,0xae,0xfd,0xfe,0xff,0xfd,0xfb,0xaf,0xf6,0xfb,0xfe,0xfb,0xff,0xfb,0xff,0xff,0xbf,0xff,0xef,0xf9,0xfe,0xeb,0xff,0xbf,0xef,0xfe,0xfa,0xff},
  {0xfe,0xbf,0xff,0xfe,0xff,0xfb,0xfb,0xff,0x7f,0xef,0xfe,0xff,0xaf,0xee,0xff,0xff,0xea,0xfb,0xfa,0xff,0xfb,0xff,0xff,0xff,0xdf,0xff,0xef,0xf7,0xf5,0xf5,0xff,0xd7},
  {0xff,0x9f,0xbf,0xfb,0xaf,0xef,0xfe,0xef,0x7f,0xff,0xff,0xff,0xff,0xff,0xd7,0xff,0xdf,0xff,0xff,0x7f,0xff,0x7f,0x5f,0x55,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xd5,0xff,0xff,0xdf,0xff,0xff,0xff,0xff,0xdf,0x77,0xf7,0xd7,0xf9,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xd5,0xff,0xfb,0xff,0xff,0x7f,0xfe,0xbf,0xff,0xff},
  {0xff,0xfb,0xef,0xff,0xf7,0xe7,0xff,0xfb,0xff,0xff,0xff,0xbf,0xfb,0xfe,0xff,0xff,0xff,0xff,0xaf,0xbf,0xef,0xbf,0xff,0xff,0xef,0xfe,0xff,0xff,0xff,0xfb,0xfb,0xff},
  {0xff,0xff,0xef,0xff,0xff,0xff,0xf7,0xfe,0xff,0xff,0xff,0xef,0xbf,0xff,0xff,0xef,0xff,0xbf,0xbe,0xff,0xbf,0xff,0xea,0xaf,0xee,0xff,0xfb,0x9f,0x7d,0xdf,0xed,0xfa},
  {0xff,0x7d,0xff,0xf7,0xff,0xff,0xff,0x7f,0xee,0xff,0xff,0xff,0xff,0xfd,0xd5,0xef,0xd7,0xff,0x7f,0xff,0xfe,0xdf,0xff,0xff,0xff,0xb7,0xeb,0xef,0xff,0xff,0xfd,0xfe},
  {0xff,0x5f,0xfd,0xff,0xff,0xff,0xff,0xfb,0xff,0xff,0x57,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfb,0xff,0x7f,0xff,0xff,0xff,0xef,0xff,0xff,0xff,0xff,0xf7,0xff},
  {0xff,0x55,0xfd,0xff,0xff,0xff,0xbf,0xff,0xff,0xff,0xff,0xff,0xd7,0xfd,0xff,0xff,0xfb,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xef,0xff,0xfb,0x7f,0xd5,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xbf,0xdf,0xb7,0xfe,0xff,0xff,0xfa,0xff,0xff,0xff,0xff,0xdf,0xbd,0xff,0xff,0xff,0xff,0xff,0xff,0xf7,0xfb,0xbf,0xbf},
  {0xbf,0xff,0xbe,0xfe,0xff,0xff,0xfb,0xff,0xfb,0xfe,0xef,0xff,0xfe,0x7f,0xfe,0xff,0xff,0xff,0xbf,0xfe,0xff,0xff,0xf7,0xff,0xff,0xdf,0x9f,0xff,0xff,0xff,0xfe,0xbf},
  {0xf7,0xff,0xff,0xff,0xff,0xff,0xff,0xd7,0xf5,0xff,0x5f,0xef,0xff,0xff,0xff,0xd7,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf7,0xef,0xaf,0xbb,0xfe,0xff,0xeb,0x77,0x7d},
  {0xff,0x9f,0xbe,0xeb,0xff,0xfd,0xfd,0xf7,0xff,0x7f,0xff,0xff,0xff,0xbd,0xfd,0xf7,0x5f,0xef,0xd7,0xfb,0xbf,0xff,0xff,0xde,0xe7,0xde,0xfa,0xfe,0xff,0xff,0xff,0x7f},
  {0xd7,0xff,0xff,0xff,0xff,0x5f,0x55,0xff,0xfb,0xff,0xff,0xf7,0xff,0xff,0xff,0x77,0xff,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0x77,0xd5,0xff,0xff,0xff,0xee,0xff,0xfb},
  {0x5f,0xfd,0xff,0xfb,0xff,0xbf,0xff,0xff,0xef,0xff,0xff,0xf6,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfe,0xff,0xdd,0xf7,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfe},
  {0xfb,0xbe,0xff,0xff,0xff,0xbe,0xff,0xff,0xee,0xbf,0xff,0xef,0xff,0xfe,0xee,0xfe,0xff,0xf7,0xbf,0xff,0xef,0xfe,0xff,0xff,0xff,0xff,0xf7,0x7f,0xfe,0xff,0xff,0xff},
  {0xf7,0xf7,0xfd,0x7f,0xfd,0xff,0xfd,0xfd,0xff,0x5b,0xbf,0xdf,0xb7,0xef,0x7f,0xfd,0x9e,0xff,0xff,0xff,0xff,0xbf,0xfe,0xbf,0xbf,0xff,0xbf,0xfe,0xdf,0xdf,0xeb,0x6f},
  {0xff,0xdd,0xff,0xff,0x75,0xfd,0xf7,0x5f,0xff,0xff,0xbf,0xff,0xff,0xff,0xff,0xff,0xeb,0xfe,0xfe,0xff,0xff,0xff,0xef,0xbb,0xaa,0xff,0xdb,0xfe,0xbf,0xff,0xff,0xff},
  {0x5d,0xff,0xff,0xff,0xe7,0xff,0xff,0xff,0xfd,0xf7,0xdf,0x7f,0xbf,0xbb,0xd7,0xff,0xff,0xff,0xfe,0xee,0x5f,0xf7,0xfb,0x67,0xfe,0xdb,0xfd,0xff,0xef,0xff,0x7f,0xff},
  {0xff,0xfd,0xff,0xfe,0xfb,0xf7,0xff,0xef,0xf6,0xff,0xfb,0xff,0xff,0xff,0xfb,0xff,0xff,0xdf,0xff,0x7f,0xff,0xff,0xff,0xff,0xff,0x7f,0xff,0xff,0xff,0xff,0xff,0xdf},
  {0x55,0xd5,0xff,0xff,0xff,0xff,0xff,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0x7d,0xff,0xef,0x7f,0xff,0xdf,0xff,0xff,0xff,0xff,0xfb,0xff,0xff,0x7f,0xdf,0x55,0xf5},
  {0xff,0xfb,0xff,0xff,0xff,0xff,0xff,0xef,0xff,0xdf,0x7f,0x55,0xff,0xeb,0xff,0xff,0xff,0xff,0xdf,0xff,0xff,0xff,0xff,0xff,0xfb,0x7f,0x75,0x55,0xeb,0xff,0xbf,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xbf,0xfe,0xfd,0xdd,0xfe,0xff,0xff,0xbe,0xff,0xef,0xff,0xfe,0xbf,0xfb,0xf7,0xff,0xee,0xbf,0xbf,0xff,0xaf,0xef,0xbf,0xef,0xff,0xff},
  {0xef,0xff,0xef,0xff,0xea,0xff,0xef,0xff,0xff,0xfe,0xbf,0xef,0xef,0xef,0xff,0xff,0xfe,0xbf,0xfb,0xfa,0xd7,0xfd,0xff,0xbf,0xbf,0xff,0xfe,0xff,0xef,0xaf,0xee,0xee},
  {0xfe,0x9f,0x7f,0x7f,0xff,0x7e,0xfd,0xff,0xff,0xbf,0xfb,0x7d,0xea,0x6f,0xff,0xff,0xff,0xff,0xff,0xff,0xf7,0xff,0xff,0xff,0xff,0x7f,0x57,0xfd,0xfd,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0x5f,0x7f,0xd5,0xf5,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf7,0xbf,0xff,0xff,0xff,0xff,0x7f,0x5f,0x57,0xf5,0xff,0xff,0xff,0xff,0xff},
  {0xdf,0xff,0xff,0xff,0xff,0xff,0x5f,0x55,0x55,0xd5,0xfb,0xff,0xff,0xff,0xff,0xe7,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x57,0x57,0xff,0xbe,0xdf,0xff,0xff,0xff,0xff},
  {0xbf,0xee,0xff,0xff,0xff,0xbf,0xbb,0xff,0xfb,0xff,0xff,0xff,0x7f,0x7d,0xdd,0xfd,0xfe,0xff,0xff,0xff,0xff,0xff,0xaf,0xff,0xff,0xff,0xff,0xef,0xff,0xff,0xff,0x57},
  {0xd5,0xf7,0xff,0xfb,0xff,0xaf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xeb,0xdf,0xff,0xff,0x55,0x9d,0xff,0xfb,0xff,0xff,0xbe,0xff,0xff,0xff,0xbf,0xbf,0xef,0xbf,0xff},
  {0xff,0xfd,0xfe,0xbf,0xb6,0xff,0xff,0xbb,0xbf,0xfb,0xbf,0xff,0xaf,0x77,0x9d,0xaf,0xfb,0xbe,0xaf,0xff,0xbf,0xfe,0xef,0xdf,0xbe,0xff,0xff,0xbe,0xea,0xbe,0xaf,0xea},
  {0xff,0xee,0xff,0xbf,0xdf,0xee,0xbb,0xfa,0xaf,0xfe,0xef,0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfd,0xff,0xbf,0x7e,0xff,0xff,0xff,0xf7,0xff,0xfd,0xfb,0xfe,0xff},
  {0xaf,0xeb,0x7f,0xff,0x7f,0x7b,0xff,0xff,0xff,0xff,0xf7,0xf6,0xff,0xbf,0xff,0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfd,0x7f,0xff,0xff,0xff,0x5f,0xfd,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xf7,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xd5,0xef,0xff,0x7b,0xff,0x5f,0xd5,0xff,0xfb,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xdf,0xff,0xfa,0xff,0xff,0xff,0xfe,0xff,0xef,0x7f,0xbf,0xff,0xff,0xff,0xff,0xff,0xff,0xae,0xfb,0xbf,0xff,0xef,0xff,0xff,0xfe,0xfb,0xfe,0xfe,0xff,0xff,0xfe,0xff},
  {0xbf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xbb,0xff,0x7f,0xff,0xfd,0xdf,0xff,0x5d,0xdf,0xff,0xff,0xff,0xff,0xff,0xff,0xf7,0xf7,0xf5,0xff,0xf9,0xfe,0xff,0x5f},
  {0xff,0xfd,0xff,0xff,0xff,0xff,0xff,0xdf,0x5f,0x77,0x5d,0xf7,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfd,0xfd,0xff,0xff,0xff,0xff,0xfb,0xff,0xf7},
  {0xfd,0x77,0x55,0x5d,0xf7,0x5f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xff,0xdf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x55,0x55,0xd5,0xff,0xff,0xff,0xff,0xbf},
  {0xff,0xff,0xff,0xff,0xff,0xfe,0xfe,0xbb,0xff,0xdf,0xff,0xff,0xef,0xff,0xff,0x5d,0xd5,0xfe,0xff,0xff,0xff,0xaf,0xff,0xbf,0xfb,0xbf,0xff,0xff,0xef,0xef,0xff,0xff},
  {0xf7,0xff,0xff,0xbf,0xff,0xff,0xff,0x77,0xdd,0xfd,0x7f,0xf7,0xef,0xff,0xff,0xff,0xff,0xff,0xef,0xff,0xbf,0xff,0xff,0xff,0xff,0xff,0xfe,0xfb,0xff,0xfb,0xff,0xfd},
  {0xff,0x75,0xf5,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xef,0xef,0xef,0xff,0xff,0xbf,0xff,0xff,0xbf,0xfb,0xff,0xff,0x5f,0x7f,0xfd,0xbe,0xfe,0xff,0xbf,0xef,0xff,0xfe},
  {0xeb,0xfb,0xff,0xff,0xbf,0xff,0xfb,0xef,0xaf,0xff,0x9f,0x7f,0xb7,0xff,0xea,0xbf,0xff,0xff,0xbe,0xff,0xff,0xff,0xff,0xbf,0xef,0xf7,0xbf,0xff,0xf7,0xff,0xf7,0xfd},
  {0xfb,0xff,0xfb,0xff,0xff,0xfe,0xff,0xbe,0xaf,0xff,0xf7,0xab,0xbf,0xff,0xbe,0xff,0xbf,0xff,0xff,0xff,0xbf,0xff,0xaf,0xab,0xff,0xbb,0xae,0xfe,0xbb,0xff,0xbe,0xff},
  {0xff,0xfe,0xef,0xbb,0xaf,0xef,0xff,0xef,0xdf,0x7d,0xff,0xff,0xff,0xff,0xff,0xfb,0xff,0xff,0xff,0xff,0xfe,0xff,0xff,0xbf,0xfb,0xff,0xff,0xff,0xef,0xbf,0xfe,0xbd},
  {0xf7,0x7f,0x7f,0xff,0x5f,0xff,0xde,0xef,0xf7,0xfe,0xbe,0xaf,0xee,0xfd,0xef,0xfe,0xd6,0xef,0xff,0xff,0xff,0xf7,0xf7,0xff,0xf7,0xff,0xff,0xff,0xff,0xf7,0xff,0xbf},
  {0xef,0x7f,0xfe,0xfe,0xff,0xfd,0xff,0xff,0x9f,0xff,0xb7,0xfe,0x9f,0xff,0xff,0xff,0xff,0x7f,0xf7,0xff,0xff,0xff,0xff,0xff,0xff,0xfd,0xff,0xff,0xff,0xff,0xe7,0xff},
  {0xff,0xff,0xfd,0xff,0xef,0xef,0xff,0x7f,0x77,0x55,0xd5,0xff,0xff,0xff,0xff,0xff,0xfb,0xff,0xff,0xff,0xff,0xff,0xff,0xdf,0xff,0xff,0xdd,0xff,0xff,0x5f,0x5d,0xd5},
  {0xf7,0xff,0xff,0xff,0xdf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xef,0xff,0xfd,0x7f,0x57,0x5d,0x57,0x55,0xf5,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfb,0xff},
  {0xdf,0xbf,0xff,0xff,0xff,0xff,0x7f,0x57,0x55,0x5d,0xf5,0xff,0xff,0xff,0xff,0xfe,0xfd,0xff,0xff,0xff,0xff,0xff,0xef,0xff,0xff,0xfb,0xef,0xff,0xff,0xeb,0xef,0xff},
  {0xff,0xff,0xdf,0xd5,0xf5,0x7d,0xbb,0xff,0xef,0xef,0xf7,0xfe,0xff,0xff,0xff,0xef,0xff,0xff,0xef,0xff,0xff,0xff,0xff,0xef,0xff,0xff,0xff,0xbf,0xff,0xff,0xff,0x5f},
  {0x7f,0x57,0xfe,0xff,0xff,0xef,0xff,0xfb,0xff,0xff,0xbf,0xff,0xbf,0xff,0xff,0xff,0xff,0xfa,0xff,0xee,0xff,0x7f,0xdf,0x5f,0xd5,0xd5,0xd5,0xbe,0xef,0xff,0xbe,0xaf},
  {0xfb,0xff,0xef,0xff,0x7f,0xff,0xef,0xff,0xaf,0xfd,0xff,0xfe,0xef,0xfb,0xfe,0xbf,0xfb,0x5f,0x7f,0xf7,0xfb,0xfe,0xbf,0xfd,0xff,0xfe,0xff,0xbf,0xfe,0xbd,0xff,0xbf},
  {0xfe,0xab,0xff,0xff,0xff,0xbf,0x7f,0xfd,0xfe,0xee,0xfb,0xef,0xfb,0xff,0xff,0xef,0xbb,0xee,0xff,0xff,0xd7,0xfb,0xfe,0xbe,0xff,0xbe,0xbf,0xff,0xfa,0xff,0xef,0xee},
  {0xaf,0xab,0xbb,0xbf,0xff,0xfb,0xfe,0xbb,0xfe,0xaf,0xfe,0xff,0xee,0xff,0xff,0xef,0xbf,0xfe,0xff,0x7f,0xfb,0xfb,0xfa,0xfb,0xba,0xbe,0xff,0x77,0xff,0xf7,0xff,0x5b},
  {0xfd,0xff,0xf7,0xff,0xff,0xff,0xff,0xf5,0xff,0xff,0xff,0xff,0xff,0xff,0xe7,0xf5,0x57,0xff,0xff,0xbf,0xff,0xff,0x7f,0x7f,0xff,0x5f,0x75,0xf5,0xff,0xfe,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xd7,0xfd,0xff,0xfb,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfb,0xff,0xef,0xff,0xfb,0xff,0xef,0xfb,0xfb,0xfe,0xfb,0xfd,0xff,0xff},
  {0xff,0xfb,0xfb,0xfe,0xaf,0xbf,0xff,0xff,0xfb,0xff,0xff,0xff,0xeb,0xff,0xff,0xef,0xfb,0xff,0xfe,0xff,0xef,0xff,0xfb,0xbe,0xff,0xef,0xff,0xfb,0xff,0xee,0xff,0xee},
  {0xff,0xfe,0xff,0xfb,0xfe,0xff,0xbf,0xff,0xff,0xff,0xff,0xfb,0xf7,0x7f,0xef,0xef,0xff,0xef,0xff,0xf7,0xff,0xff,0xfe,0xff,0xff,0xdf,0xff,0xff,0xff,0xf7,0xdf,0xfb},
  {0xff,0xff,0xdf,0xff,0xff,0xef,0xff,0xff,0xef,0xbf,0xff,0xff,0xff,0x5f,0xf5,0xff,0xfe,0xff,0xfd,0xff,0xff,0xff,0xff,0xd7,0xff,0xff,0xff,0x55,0xd5,0xff,0xfb,0xfb},
  {0x7f,0xff,0xff,0xdf,0xff,0xf7,0xfb,0xff,0xf7,0xff,0x5f,0xdd,0xff,0xef,0xbf,0xff,0xfb,0xfa,0xff,0xef,0xff,0xff,0xff,0xff,0xff,0xff,0xae,0xe7,0xea,0xbb,0xae,0xfe},
  {0xfa,0xff,0xff,0xff,0xf7,0xff,0x5f,0xff,0xff,0xff,0xff,0x5f,0xf5,0xff,0xdf,0xff,0xff,0xff,0xff,0xff,0xf5,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xdd,0xff,0xff,0xef},
  {0xff,0xff,0xff,0x7f,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xef,0xbd,0xff,0xff,0xbf,0xff,0xef,0xff,0xff,0xff,0xbf,0xfe,0xeb,0xff,0xef,0x5f,0xff,0xfb},
  {0xff,0xff,0xfb,0xdf,0xff,0xff,0xff,0xff,0xbf,0xef,0xbf,0xbf,0xfe,0xff,0xff,0xfb,0xff,0xff,0xef,0xbf,0xdf,0xfa,0xef,0xff,0xff,0xff,0xff,0x7f,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xfe,0xff,0xff,0xff,0xff,0xef,0xff,0xff,0xff,0xff,0xf7,0x7f,0xff,0xff,0xf7,0xff,0xff,0xff,0xff,0xff,0xfb,0xef,0xff,0xbf,0xff,0xfe,0xed,0xff,0xff},
  {0xff,0xbf,0xef,0xff,0xff,0x5f,0xff,0x7f,0xf5,0xff,0xff,0x55,0xf7,0xfd,0xff,0xff,0xff,0x7f,0xf5,0xff,0xdf,0xdf,0xfb,0xff,0xff,0xff,0x5d,0xff,0xff,0xff,0xff,0xef},
  {0xef,0xd7,0xbf,0xfb,0xbf,0x7f,0xfd,0xef,0xfb,0xbf,0x5f,0xef,0xef,0xff,0xef,0x5f,0xef,0xaf,0xfb,0xff,0xff,0xff,0xfe,0x9f,0x6f,0xba,0x7b,0xea,0xea,0xff,0xff,0xfe},
  {0xff,0xff,0xff,0xff,0xf7,0xff,0xef,0xbf,0xff,0xff,0xff,0xff,0xd6,0xff,0xee,0xff,0xff,0xff,0xff,0x7f,0xf5,0x5f,0xfd,0xee,0xbb,0xbe,0xef,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xf7,0xff,0xff,0xff,0xff,0xff,0xdb,0xff,0xfd,0xff,0xff,0xff,0xef,0xf5,0xff,0xff,0xbb,0xf5,0xff,0xff,0xee,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xdf,0xff,0xff,0xdf,0xff,0xfe,0xee,0xff,0xfe,0xf7,0xff,0xff,0xef,0xff,0xfe,0xff,0xff,0xff,0xff,0xbf,0xff,0xef,0xff,0xff,0xff,0x7f,0xbf,0xff,0xdf,0xff,0x5f},
  {0xf5,0xff,0xff,0xff,0xff,0x5f,0xdf,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0x5f,0xdf,0xf5,0xff,0xff,0xff,0xff,0x57,0xd7,0xfe,0xff,0xfe,0xfe,0x9f,0xff,0x77,0xff,0xff},
  {0xff,0xff,0xff,0xf7,0xff,0xff,0x7b,0xfd,0xff,0xff,0xfb,0xfb,0xff,0xff,0xee,0xfa,0xff,0xff,0xff,0xff,0xfb,0xff,0xef,0xff,0xbe,0xbf,0xff,0xbf,0xff,0xff,0xff,0xfb},
  {0xff,0xee,0xff,0xef,0xef,0xff,0xfb,0xff,0xff,0xef,0xaf,0xfe,0xfb,0xff,0xff,0xfd,0x7f,0xff,0xff,0xdf,0xff,0xff,0xff,0xff,0xdf,0xff,0xff,0x7f,0xff,0x7f,0xfd,0xbf},
  {0xfd,0xf5,0xff,0xeb,0xff,0xfb,0xff,0xff,0xfb,0xef,0xef,0xef,0xfa,0xff,0x7f,0xbf,0x7f,0xdf,0xfe,0xf7,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xfd,0xff,0xff,0xd7},
  {0xff,0xdb,0xfe,0x9f,0xff,0xff,0xff,0xbf,0x7f,0xff,0xff,0xef,0x7b,0xff,0xff,0xff,0xfe,0xff,0xff,0xea,0xf7,0xff,0xff,0xff,0xea,0xff,0xbb,0xfb,0xff,0x7f,0xff,0xff},
  {0x7f,0xff,0xff,0xd7,0xf7,0xff,0xff,0xf5,0xff,0xd7,0xeb,0xa7,0xff,0xeb,0xef,0xff,0xff,0xba,0xef,0xff,0xff,0xdf,0xff,0xdf,0xff,0xff,0xff,0xff,0xff,0xef,0xff,0xff},
  {0x7f,0xff,0x7f,0xff,0xff,0xf5,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xdf,0xdd,0xff,0xef,0xff,0xfb,0xf7,0xff,0x5f,0xf5,0xff,0xbf,0xff,0xff,0xff,0xfe,0xf7,0xdd},
  {0xfd,0xff,0xbf,0xbf,0x7f,0xff,0xff,0xff,0xff,0x5f,0x55,0xff,0xff,0xff,0xff,0xff,0xfe,0xfe,0xbb,0xff,0x77,0xfe,0xfe,0xff,0xff,0xfe,0xfb,0x5f,0xb7,0xff,0xff,0xff},
  {0xfe,0xff,0xff,0xfb,0xff,0xdf,0xff,0xef,0xbb,0xff,0xbf,0xff,0xff,0xff,0xfb,0xeb,0xb7,0xff,0xbf,0xfe,0xff,0xfe,0xbb,0xbe,0xfe,0xff,0xeb,0xee,0xff,0xfd,0x7f,0xfd},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf5,0xff,0xfd,0xdf,0xdf,0xff,0xfb,0xff,0xff,0xf7,0x7f,0xff,0xff,0xff,0xff,0xff,0xeb,0xff,0xbf,0xff,0xff,0xef,0xee,0x7b,0xef},
  {0xee,0xaa,0xba,0xfb,0xbe,0xaa,0xaa,0xfa,0xfb,0x7f,0xff,0x7e,0xaa,0xfb,0xeb,0xbe,0xee,0xea,0xff,0xef,0xfe,0xfb,0xbf,0xeb,0xeb,0xef,0xfe,0xff,0xaa,0x7f,0xeb,0xff},
  {0xba,0xaf,0xfe,0xbe,0xbe,0xff,0xff,0xee,0xae,0xff,0xff,0xba,0xea,0xfa,0xaa,0xab,0xff,0xbe,0xaf,0xfb,0xaf,0xbf,0xea,0xeb,0xba,0xef,0xfa,0xbe,0xea,0xae,0xba,0xff},
  {0xff,0xff,0xaa,0xef,0xfa,0xbb,0xbf,0xab,0xbf,0xff,0xbf,0xea,0xab,0xab,0xeb,0xeb,0xbf,0xeb,0xff,0xbf,0xaf,0xfa,0xef,0xaf,0xeb,0xff,0xab,0xbb,0xbe,0xff,0xba,0xaa},
  {0xfb,0xbf,0xee,0xba,0xbf,0xef,0xfe,0x7e,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55},
  {0x55,0x55,0x55,0x55,0x57,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xf5,0xff,0xfb,0xdf,0xff,0xfe,0xfe,0xf7,0x7f,0xdf,0xff,0xdf,0xff,0xff,0xff,0xfe,0xb9,0xff,0xff},
  {0xf7,0xeb,0xbe,0xff,0xff,0xff,0xff,0x7f,0xff,0xfb,0xfb,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xef,0xff,0xd5,0xff,0xff,0xff,0xff,0xfe,0xff,0xff,0xfb,0xfb},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xdf,0x7f,0xff,0xee,0xff,0xff,0x7d,0xff,0xdf,0xff,0x7f,0xf5,0xff,0xed,0xff,0xef,0xff,0xff,0xd7,0xbf,0xae,0xab,0xfb,0xeb},
  {0x7f,0xfb,0xff,0xff,0xff,0xff,0xff,0xff,0xfd,0xfd,0xff,0xdf,0xff,0xfd,0xff,0x5f,0xf5,0xdf,0xff,0xff,0xff,0xff,0xff,0xfd,0xf7,0x7f,0x5d,0xff,0xff,0xdf,0xff,0xff},
  {0xff,0xfb,0xf6,0x77,0x75,0xfd,0x9f,0xff,0xff,0xfb,0xbf,0xff,0xf7,0xdf,0xf9,0xff,0xff,0xff,0xdf,0xef,0xff,0xef,0xfd,0xff,0xfb,0xef,0xaf,0xf7,0xbf,0xff,0x7e,0xd5},
  {0xbf,0xff,0xff,0xff,0xf7,0xfb,0xef,0xff,0xee,0xff,0xfb,0xff,0xff,0xff,0xff,0xab,0xff,0xff,0xfb,0xbb,0xff,0xbf,0xee,0xbd,0xee,0xff,0xfe,0xff,0xff,0xfd,0xef,0xff},
  {0xff,0x9f,0xea,0xf7,0xff,0xff,0xff,0xff,0x7f,0xff,0xff,0xff,0xf5,0xff,0x7f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfb,0xff,0xff,0xee,0xbf,0xff,0x79,0xbf,0xdf,0xff},
  {0xdf,0xff,0xfd,0xff,0xff,0x7f,0xff,0xfd,0xff,0xdf,0xff,0xff,0xff,0xff,0xbd,0xff,0xf7,0x7f,0x7d,0x55,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf7,0xff},
  {0x7f,0xff,0xff,0x5f,0xf7,0xf5,0xff,0xff,0xff,0x7f,0xff,0xff,0xef,0xff,0xff,0xff,0xff,0xdf,0xef,0xff,0xfd,0xff,0x57,0x55,0x75,0x55,0x55,0x55,0xff,0xff,0xff,0xff},
  {0xff,0xf7,0xef,0xff,0xff,0xef,0xff,0xff,0xef,0xbf,0xff,0xff,0x57,0x5d,0xd5,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xbf,0xff,0xff,0xff,0xff},
  {0xff,0xbf,0xef,0xff,0xff,0xff,0xff,0xf7,0xff,0x55,0xfd,0xfe,0xff,0xfa,0xff,0xff,0xff,0xff,0xfb,0xff,0xef,0xbf,0xff,0xff,0xff,0xee,0xff,0xff,0xf7,0xbf,0xff,0xff},
  {0xff,0x7f,0x77,0xfd,0xff,0xfe,0xff,0xef,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfe,0xfe,0xff,0xbf,0xff,0xff,0xff,0xff,0x77,0x7d,0xd7,0xff,0xaf,0xff,0xfe,0xff,0xfb},
  {0xdf,0xff,0xff,0xff,0xff,0xff,0xff,0xef,0xbf,0xeb,0xff,0xfb,0xff,0x7f,0xd7,0xfd,0xfb,0xef,0xff,0xef,0xaf,0xfb,0xfe,0xff,0xef,0xff,0xeb,0xfb,0xdd,0xbd,0xff,0xff},
  {0xfe,0xff,0xee,0xfe,0xff,0xfe,0xfe,0xbf,0xff,0xef,0xfb,0xdf,0xbf,0xfe,0xef,0xff,0xff,0xff,0xff,0xeb,0x7f,0xff,0xff,0xfb,0xff,0xfb,0xef,0xff,0xff,0xef,0xeb,0xff},
  {0xff,0xae,0xaf,0xff,0xff,0xdf,0xef,0xef,0xef,0xff,0xff,0xfb,0xff,0xff,0xef,0xbf,0xff,0xef,0xff,0x7f,0xf7,0xfb,0x9f,0xbe,0xff,0xbf,0x7f,0x9d,0xff,0xff,0xff,0x57},
  {0x55,0xff,0xff,0xff,0xff,0xf7,0xff,0xff,0xff,0xff,0xff,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xdf,0x5f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xdf,0x55,0xfd,0xaf,0xff},
  {0xff,0xef,0xff,0xff,0xff,0x77,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xf5,0xff,0xff,0xfb,0xff,0xbf,0xff,0xef,0xff,0xff,0xff,0xff,0xfe,0xdd},
  {0xfd,0xfe,0xff,0xff,0xff,0xff,0xff,0xef,0xef,0xff,0xfd,0xef,0xff,0xff,0xbf,0xbf,0xff,0xfe,0xfe,0x6f,0xff,0xff,0xff,0xff,0xbf,0xff,0xff,0xbe,0xef,0xef,0xbf,0xff},
  {0xfb,0xeb,0xff,0xff,0xfa,0xff,0xff,0xbf,0xbf,0xff,0xfe,0xff,0xfb,0xef,0xbf,0xff,0xff,0xf7,0xff,0xff,0xbf,0xf9,0xaf,0xfb,0xff,0xf7,0xfd,0xdd,0xff,0xff,0xff,0xff},
  {0xff,0xd5,0xff,0xff,0xff,0xff,0xff,0xed,0xff,0xff,0xff,0x77,0xff,0xff,0xff,0xff,0xff,0xd7,0xed,0xff,0xff,0xff,0xff,0xfa,0x5b,0xf5,0xff,0xff,0xff,0xff,0xff,0xfb},
  {0xff,0xbf,0xff,0xfe,0xff,0xff,0x7e,0xff,0xff,0xff,0xff,0xff,0xaf,0xfd,0xbe,0xff,0xfe,0xff,0xfb,0xbf,0xff,0xe7,0xff,0xfb,0xfe,0xfe,0xef,0xbe,0xef,0xfe,0xff,0xff},
  {0xff,0xef,0xbf,0xaf,0xbf,0xef,0xfe,0xff,0xfb,0xeb,0xef,0xbe,0xef,0xbf,0xef,0xba,0x56,0x55,0x55,0x55,0xf5,0xff,0xff,0xdf,0xff,0xdf,0xff,0x7f,0xff,0xee,0xfe,0xff},
  {0xab,0xff,0xee,0xee,0xaa,0xab,0x9e,0xbb,0xaf,0xfb,0xeb,0xfb,0xfb,0xee,0xaf,0xff,0xfa,0xef,0xff,0xef,0xea,0xaa,0xbe,0x6f,0xaa,0xef,0xbb,0xea,0xaa,0xfb,0xff,0xbe},
  {0xff,0xaa,0xd7,0xfa,0xeb,0xfb,0xee,0xef,0xba,0xea,0xee,0xff,0xee,0xef,0xfb,0xae,0xef,0xbe,0xbb,0xbb,0xeb,0xaf,0xbf,0xea,0xef,0xae,0xbf,0xeb,0xba,0xaf,0xee,0xee},
  {0xea,0xfa,0xef,0xaf,0xfe,0xae,0xab,0xfb,0xfe,0xff,0xbe,0xfe,0xbf,0xff,0xfb,0xef,0xff,0xff,0xeb,0xaf,0xff,0xef,0xea,0xfe,0xff,0xff,0xbf,0xbf,0xfe,0xbe,0xfe,0xeb},
  {0xfe,0xff,0xaf,0xee,0xaf,0xeb,0xff,0xee,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55},
  {0x55,0x55,0x5d,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xff,0xff,0xff,0xff,0xfe,0xef,0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0xde,0xff,0xef,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xbf,0xff,0xfb,0xab,0xea,0xbf,0xaa,0xbe,0xae,0xae,0xae,0xba,0xaa,0xba,0xee,0xff,0xab,0xfb,0xeb,0xae,0xaa,0xae,0xef,0xfa,0xfe,0xfa,0xaf,0xea},
  {0xbf,0xba,0xee,0xbb,0xbe,0xae,0xbf,0x57,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xff,0xdf,0xfe,0xff,0xd7,0xff,0xff},
  {0xff,0xff,0x7f,0xff,0xff,0xfb,0xfb,0xff,0xff,0xff,0xfe,0xff,0xe7,0xff,0xfd,0xff,0x7f,0xfd,0xff,0xff,0xff,0xff,0xff,0xdf,0xfb,0xff,0xff,0xff,0xff,0x57,0x75,0xff},
  {0xff,0xff,0xdf,0xfd,0xfe,0xff,0xff,0xff,0xff,0xff,0xdf,0x7d,0xff,0xfe,0xff,0xff,0xff,0xff,0xff,0xfe,0xd7,0xfb,0xff,0xff,0xbf,0xfe,0xff,0xff,0xfd,0xff,0xaf,0x7f},
  {0xef,0xff,0xab,0x6b,0xab,0xfb,0xef,0xf9,0xfb,0xeb,0xef,0x7f,0xff,0xff,0xff,0xff,0xfe,0xff,0xab,0xba,0xeb,0xbe,0xbf,0xbf,0xff,0xfe,0xbe,0xff,0xef,0xff,0xaa,0xee},
  {0xbf,0xba,0xea,0xff,0xaf,0xba,0xbf,0xaa,0xff,0xeb,0xeb,0xae,0xbf,0xff,0xbe,0xaf,0xee,0xea,0xfb,0xeb,0xff,0xfe,0xff,0xbf,0xab,0x5e,0x55,0x55,0x55,0x55,0x55,0x55},
  {0x55,0x55,0x55,0x55,0x55,0x55,0xd5,0xdf,0xff,0xef,0x77,0xab,0xef,0xff,0xf7,0xd7,0xf7,0x7f,0xfd,0xff,0xfd,0xff,0x75,0x55,0xff,0xff,0xf7,0xff,0x7f,0xff,0xf7,0xff},
  {0xdf,0xff,0xd7,0xff,0xdf,0xfb,0xfb,0xff,0xbf,0xdf,0xff,0xff,0xef,0xff,0x7f,0xff,0xff,0xff,0xbf,0xef,0xff,0x7a,0xfb,0xee,0xfe,0xf7,0xfb,0xff,0xef,0xbf,0xee,0xfe},
  {0xfb,0xbe,0xef,0xbf,0x7e,0xff,0xff,0xf7,0xff,0xff,0xff,0xdd,0xff,0xff,0x57,0xff,0xf7,0xff,0xff,0x7f,0x75,0xff,0xff,0xbf,0xff,0x5f,0xff,0xff,0xff,0xfb,0xfd,0xff},
  {0xff,0xef,0xfb,0xff,0xef,0xee,0xff,0xff,0xff,0xbf,0xff,0xfb,0xee,0xee,0xef,0xff,0xdf,0xbf,0xfe,0xff,0xff,0xff,0xff,0xf7,0xff,0xdf,0xff,0xff,0xf7,0xff,0xff,0x57},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xee,0xff,0xff,0xbf,0xfe,0xfb,0xff,0xff,0xff,0xba,0x7b,0x9f,0xfd,0xae,0xba,0xfa,0xfb,0xbf,0xbe,0xfb,0xff,0xbf,0xbb,0xeb,0xef},
  {0xba,0xbe,0xba,0xfb,0xea,0xfa,0xff,0xef,0xbe,0xab,0xff,0xaf,0xae,0xbe,0xea,0xab,0xfa,0xfb,0xba,0xfb,0xfb,0xbb,0xaf,0xef,0xff,0xee,0xff,0xfa,0xff,0xed,0xae,0xbf},
  {0xbe,0xfb,0xff,0xfb,0xbb,0xef,0xae,0xfe,0xbe,0xeb,0xaa,0xde,0xbb,0xaf,0xbf,0xfe,0xbb,0xbb,0xfb,0xbe,0xef,0xff,0xfb,0xbb,0xbf,0xea,0xea,0xaf,0xfa,0xef,0xfe,0xfe},
  {0xeb,0xae,0xfe,0xbf,0xee,0xfb,0xaa,0xbf,0xea,0xef,0xba,0xaf,0xbf,0xef,0xfe,0xdf,0xbe,0xae,0xbe,0xfb,0xff,0xfe,0xae,0xff,0xfe,0xfa,0xfb,0xee,0xfe,0xeb,0xef,0xef},
  {0xef,0xbe,0xef,0xff,0xff,0xee,0xbe,0xfb,0xab,0xaf,0xeb,0xae,0xae,0xab,0xff,0xbf,0xbf,0xaf,0xfa,0xfa,0xfa,0xbf,0xfe,0xaa,0xeb,0xee,0xfe,0xff,0xfe,0xbb,0xeb,0xfb},
  {0xbf,0xfe,0xbf,0xab,0xae,0xfe,0xfa,0xff,0xfe,0xab,0xbe,0xaf,0xaf,0xeb,0xee,0xbf,0xff,0xfe,0xef,0xfe,0xef,0xfa,0xff,0xef,0xbe,0xfb,0xff,0xfb,0xea,0xbf,0xfb,0xaa},
  {0xfb,0x57,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55},
  {0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x95,0xff,0x7f},
  {0xae,0xef,0xba,0xaa,0xba,0xfe,0xfe,0xff,0xbb,0xfb,0xba,0xfa,0xfb,0xef,0xbb,0xaa,0xbf,0xef,0xae,0xfa,0xae,0xea,0xff,0xee,0xfa,0xfa,0x55,0x55,0x55,0x55,0x55,0x55},
  {0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x7f,0xff,0xff,0xef,0xff,0x7f,0xd5,0xff,0xff,0xff,0x57,0xf5,0xff,0xff,0xf7,0xfe,0xfb,0xbf,0x7f,0xf5,0xff,0xbe,0xff,0xfe,0xfb},
  {0xff,0xff,0xeb,0x6f,0xfd,0xfb,0xbf,0xff,0xff,0xff,0xee,0xff,0xfb,0xde,0xbe,0xd7,0xff,0xff,0xbf,0x7f,0xff,0xef,0xbb,0xee,0xad,0xff,0xff,0xff,0x6f,0xff,0xbf,0xdf},
  {0xf7,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xe7,0xbf,0xff,0xf7,0xff,0xff,0xff,0xfb,0xef,0xfe,0xfe,0xff,0x7f,0xff,0xe7,0xfe,0xdf,0xe7,0xfe,0xff,0xff,0xff,0xff,0xff},
  {0xfe,0xff,0xff,0xbf,0xd7,0xff,0xff,0xfb,0xff,0xff,0xff,0x7f,0xff,0xff,0xff,0xfb,0xbb,0xff,0xbb,0xfa,0xbf,0xff,0xfb,0xee,0xff,0x5f,0x55,0xfd,0xff,0xf7,0xbf,0xbf},
  {0xab,0xab,0xee,0xae,0xaa,0xbf,0xfe,0xfe,0xfb,0xee,0xff,0xeb,0xee,0xbe,0xba,0xff,0xbf,0xef,0xff,0xaa,0xaf,0xff,0xba,0xef,0xef,0xbb,0xbf,0xbe,0xba,0x56,0x55,0x55},
  {0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xfe,0xab,0xba,0xaf,0xae,0xee,0xfe,0xee,0xfe,0x5f,0x55,0x55,0x95,0xdf,0xae,0xfb,0xa9,0xbb,0xef,0xfe,0xff,0xaa},
  {0xbf,0xfa,0xeb,0xa6,0xab,0xaa,0xae,0xee,0xfb,0xef,0xfe,0xfb,0xbb,0xaf,0xee,0xae,0xbb,0xfb,0xaa,0xfe,0xef,0xbf,0xfe,0xee,0x6f,0x55,0x55,0x55,0x55,0x55,0x55,0x55},
  {0x55,0x55,0x55,0x55,0x55,0xf5,0xff,0xff,0xff,0xff,0xff,0xea,0xbb,0xfe,0xfb,0xff,0xbb,0xff,0xff,0xef,0xea,0xfa,0xaa,0xbb,0xef,0xbf,0xfb,0xfb,0xfa,0xef,0xbe,0xbf},
  {0xab,0xfb,0xff,0xaa,0xff,0xee,0xeb,0xbb,0xfe,0xbe,0xaf,0xeb,0xfe,0xaf,0xfe,0xef,0xaa,0xfa,0xaf,0xba,0xff,0xbb,0xaf,0xbf,0xef,0xea,0xaf,0x55,0x55,0x55,0x55,0x55},
  {0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xff,0xbf,0xff,0xff,0xff,0xff,0xff,0xf7,0x7f,0xbd,0xef,0xea,0xff,0xff,0xff,0xff,0xff,0xef,0xff,0xff,0xff,0xff},
  {0xff,0xef,0xff,0xfb,0x7f,0xff,0xef,0xff,0xef,0xbb,0xfb,0xef,0xfb,0xdf,0xfb,0xff,0xff,0x7f,0xf7,0xef,0xff,0xff,0xae,0xbf,0xef,0xfb,0xfe,0xbf,0xff,0xbe,0xef,0xff},
  {0xbb,0xfe,0xaf,0xfb,0xaa,0xff,0xef,0xae,0xbf,0xef,0xaf,0xeb,0xbe,0xef,0xee,0xff,0xfa,0xae,0xeb,0xff,0xef,0xaa,0xbf,0xfb,0xeb,0xbe,0xae,0xff,0xfb,0xae,0xff,0xbb},
  {0xab,0xef,0xfa,0xba,0xaf,0xff,0xff,0xbe,0xbe,0xba,0xfa,0xeb,0xab,0xbb,0xab,0xee,0xef,0xbb,0xfa,0xff,0xef,0xae,0xfe,0xbb,0xbe,0xbe,0xfe,0xab,0xff,0xbf,0xee,0x55},
  {0x55,0xd5,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x75,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xbb,0xfb,0xff,0xaf,0xae,0xff,0xee},
  {0xbf,0xaf,0xfb,0xff,0xef,0xbb,0xbf,0xaa,0xbf,0xef,0xfe,0xbf,0xee,0xbe,0xbf,0xbf,0xab,0xff,0xff,0xff,0xaa,0xff,0xef,0xfa,0xfa,0xff,0xef,0xae,0xef,0xbf,0xff,0xef},
  {0xff,0xbe,0xeb,0xff,0xaf,0xaf,0xee,0xff,0xfb,0xfb,0xeb,0xbe,0xef,0xfe,0xab,0xbe,0xeb,0xff,0xee,0xff,0xbf,0xae,0xeb,0xff,0xff,0xeb,0xbe,0xbf,0xaf,0xff,0xea,0xbb},
  {0xef,0xbf,0xbf,0xbe,0xff,0xfb,0xae,0x6b,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xf9,0xeb,0xda},
  {0xff,0xff,0xff,0xff,0xff,0xbf,0xff,0xff,0xff,0xdb,0xfa,0xff,0xef,0xfb,0xfd,0xfa,0xbf,0xfd,0xf7,0xfe,0xff,0xff,0xff,0xef,0xf7,0xff,0xd6,0xff,0xef,0xaf,0xff,0x9b},
  {0xff,0xff,0x7b,0xf7,0xff,0x7f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfe,0xf7,0xff,0xff,0xff,0xaf,0xaf,0xe5,0xba,0xfb,0xbe,0xfa,0xef,0xef,0xfe,0xef,0xaf,0xff,0x7f},
  {0x55,0x55,0x55,0xe9,0xfa,0xfa,0x57,0x7e,0xff,0xff,0xff,0xbb,0xff,0xff,0xff,0xff,0xfb,0xff,0xff,0x7f,0x6e,0x0d,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0f,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x3f,0x00,0xff,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xdf,0xff,0xff,0x7f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xdf,0xff,0xff,0xff,0xff,0x7f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfb,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xef,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xff,0xff,0xff,0xff,0xd7,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xef,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xef,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf7,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xdf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfd,0xdf},
  {0xff,0xff,0xff,0xff,0xff,0xfe,0xff,0xff,0xbf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xbf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfd,0xff,0xff,0xff,0xff,0x7f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfb,0xff,0xff,0xff,0xff},
  {0xff,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xef},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf7,0xfb,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfb,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xbf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfd,0xff,0xff,0xff,0xfd,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xfb,0xff,0xff,0xff,0xff,0xff,0xbf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfb,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xd7,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xef,0xff,0xff,0xff,0xff,0xfb,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xdf,0xff,0xff,0xff,0xff,0xdf,0xff,0xff,0xff,0xfd,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xdf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xbf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xef,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xbf},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xdf},
  {0xff,0xff,0xff,0xff,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfd,0x7f,0xfd,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xf7,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xdf,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0x7f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7d,0xff,0xff,0xff,0xff,0xff,0xef,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfb,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xbf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xef,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfd,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfe,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x77,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf5,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xbf,0xff,0xff,0xff,0xff,0xfb,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xbf,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf7,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x5f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0x7f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xef,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfb,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfe,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xbf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xfd,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xdf,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xff,0xff,0xff,0x7f,0xfd,0xff,0x7f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfb,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xfb,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xef,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xdf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xdf,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf7,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0x7f,0xff,0xff,0xff,0xff,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xbf,0xff,0xef,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf7,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0x77,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfb,0xff,0xff,0xff,0xff,0xff,0xef,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xef,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xfb,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0x75,0x5d,0x55,0x55,0x55,0x55,0xf5,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfd,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfd},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xef,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf7,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfb,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xdf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf7,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xbf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfb,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xef,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfb,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xdf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf7,0xff,0xbf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xfe,0xff,0xff,0xff,0xbf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x77,0x57,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf7,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfd,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xdf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xbf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfb,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xfd,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfb,0xff,0xff,0xff,0xff,0xff,0xff,0xef,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xef,0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfe,0xff,0xbe,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xef,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xef,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfe,0xfb,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0x57,0xd5,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf7,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfd,0xff,0xbf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xbf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xbf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfe,0xff,0xff,0xff,0xff,0xfb,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xef,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xef,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfb,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x5f,0x55,0x55,0x55,0x55,0x55,0xd5,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfb,0xfb,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xbf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfb,0xff,0xff,0xff,0xfe,0xff},
  {0xfe,0xff,0xff,0xbf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xef,0xef,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xef,0xff,0xff,0x7f},
  {0x55,0x55,0x57,0xdd,0xff,0xff,0xfd,0x7f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xbf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xef,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xef,0xff,0xff,0xff,0xff,0x55},
  {0xff,0xff,0xff,0xff,0xff,0x57,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0xfb,0xff,0xff,0xff,0xff,0xff,0xff,0xeb,0xff,0xff,0xff,0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0x57,0x55,0x55,0xfd,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xbf,0xff,0xff,0xfb,0xff,0xff,0xff,0xfb,0xff,0xff,0xff,0xef,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfb,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xbf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xef,0xff,0xff,0xff,0xfb,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xef,0xff,0xbf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f},
  {0x55,0x57,0x55,0x5d,0xff,0xff,0xff,0xff,0xfd,0xff,0xff,0xff,0xff,0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xef,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfb,0xff,0xff,0xff,0xff,0xfe,0xfe,0xef,0xff,0xff,0xff,0xbf,0xfb,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xef,0xff},
  {0xff,0xff,0xef,0xff,0xff,0xff,0xfb,0xff,0xff,0xff,0xff,0xff,0xef,0xff,0xfe,0xff,0xff,0xbe,0xfb,0xff,0xfb,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xef,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xdf,0x55,0x55,0x55,0xd5,0xdf,0x7d},
  {0x75,0x55,0x55,0x55,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfb,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xdf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xbf,0xff,0xff,0xff},
  {0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xdf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfe,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfb,0xff,0xff,0xff,0xfb,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xfe,0xff,0xff,0xff,0xff,0xff,0xfa,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfe,0xff,0xff,0xff},
  {0xbf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xef,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x57,0x55},
  {0x57,0x55,0x5d,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xef,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xef,0xff,0xff,0xff,0xff,0xff,0xef,0xff,0xff,0xfe,0xff,0xff,0xef,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xef,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xbb,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xef,0xff,0xff,0xff,0xfb,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x5f,0xd5,0x55,0x55,0xd5,0xf5,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0x55,0xf7,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf7,0xff,0xfb,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xbf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0x7f,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf7,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xdf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xdf,0xff,0xff,0x7f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xdf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf7,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfd,0xff,0xff,0xff,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf7,0x7f,0xdf,0xff,0xff,0xff,0xdd,0xff,0xff,0xff},
  {0xff,0xdd,0xf7,0xff,0x7d,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xf7,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xdf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xfd,0x5f,0xff,0xdf,0xff,0xfd,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf7,0x7f,0xfd,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xf5,0xff,0xdf,0xf5,0xf7,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x7f,0xdf,0xdf,0xff,0xff,0xff,0xff,0xdf,0xfd,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x03,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}
};

#define kFullWidthMaxPlane  0
#define kFullWidthIndexBits 10
#define kFullWidthCharBits  6
static const uint8_t sFullWidthPages[1024] = {
  0,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,5,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,6,7,8
};

static const uint16_t sFullWidthValues[9][64] = {
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3000,0xff01,0xff02,0xff03,0xff04,0xff05,0xff06,0xff07,0xff08,0xff09,0xff0a,0xff0b,0xff0c,0xff0d,0xff0e,0xff0f,0xff10,0xff11,0xff12,0xff13,0xff14,0xff15,0xff16,0xff17,0xff18,0xff19,0xff1a,0xff1b,0xff1c,0xff1d,0xff1e,0xff1f},
  {0xff20,0xff21,0xff22,0xff23,0xff24,0xff25,0xff26,0xff27,0xff28,0xff29,0xff2a,0xff2b,0xff2c,0xff2d,0xff2e,0xff2f,0xff30,0xff31,0xff32,0xff33,0xff34,0xff35,0xff36,0xff37,0xff38,0xff39,0xff3a,0xff3b,0xff3c,0xff3d,0xff3e,0xff3f,0xff40,0xff41,0xff42,0xff43,0xff44,0xff45,0xff46,0xff47,0xff48,0xff49,0xff4a,0xff4b,0xff4c,0xff4d,0xff4e,0xff4f,0xff50,0xff51,0xff52,0xff53,0xff54,0xff55,0xff56,0xff57,0xff58,0xff59,0xff5a,0xff5b,0xff5c,0xff5d,0xff5e,0x0000},
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffe0,0xffe1,0x0000,0xffe5,0xffe4,0x0000,0x0000,0x0000,0x0000,0x0000,0xffe2,0x0000,0x0000,0xffe3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffe6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0000,0x0000,0x0000,0x0000,0x0000,0xff5f,0xff60,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3002,0x300c,0x300d,0x3001,0x30fb,0x30f2,0x30a1,0x30a3,0x30a5,0x30a7,0x30a9,0x30e3,0x30e5,0x30e7,0x30c3,0x30fc,0x30a2,0x30a4,0x30a6,0x30a8,0x30aa,0x30ab,0x30ad,0x30af,0x30b1,0x30b3,0x30b5,0x30b7,0x30b9,0x30bb,0x30bd},
  {0x30bf,0x30c1,0x30c4,0x30c6,0x30c8,0x30ca,0x30cb,0x30cc,0x30cd,0x30ce,0x30cf,0x30d2,0x30d5,0x30d8,0x30db,0x30de,0x30df,0x30e0,0x30e1,0x30e2,0x30e4,0x30e6,0x30e8,0x30e9,0x30ea,0x30eb,0x30ec,0x30ed,0x30ef,0x30f3,0x3099,0x309a,0x3164,0x3131,0x3132,0x3133,0x3134,0x3135,0x3136,0x3137,0x3138,0x3139,0x313a,0x313b,0x313c,0x313d,0x313e,0x313f,0x3140,0x3141,0x3142,0x3143,0x3144,0x3145,0x3146,0x3147,0x3148,0x3149,0x314a,0x314b,0x314c,0x314d,0x314e,0x0000},
  {0x0000,0x0000,0x314f,0x3150,0x3151,0x3152,0x3153,0x3154,0x0000,0x0000,0x3155,0x3156,0x3157,0x3158,0x3159,0x315a,0x0000,0x0000,0x315b,0x315c,0x315d,0x315e,0x315f,0x3160,0x0000,0x0000,0x3161,0x3162,0x3163,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2502,0x2190,0x2191,0x2192,0x2193,0x25a0,0x25cb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000}
};

#define kCaseMapMaxPlane  1
#define kCaseMapIndexBits 11
#define kCaseMapCharBits  5
static const uint8_t sCaseMapPlanes[1] = {1};

static const uint8_t sCaseMapPages[2][2048] = {
  {0,0,1,2,0,3,4,5,6,7,8,9,10,11,12,13,6,14,15,16,17,0,0,0,0,0,18,19,20,21,22,23,24,25,26,6,27,6,28,6,6,29,30,31,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,36,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,0,0,0,0,6,6,6,6,39,6,6,6,40,41,42,43,41,44,45,46,0,0,0,0,0,0,0,0,0,47,48,49,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,52,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,55,56,57,6,6,6,58,59,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,61,62,0,0,0,0,63,6,64,65,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,68,69,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,72,0,0,0,0,0},
  {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,74,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,77,78,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
};

static const uint32_t sCaseMapValues[82][32] = {
  {0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x00000000,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x00000000,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x10000329,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x00000000,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x00000000},
  {0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x00000000,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000187},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000159,0x10000178,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x40000003,0x10000003,0x40000007,0x10000007,0x40000003,0x10000003,0x4000007f},
  {0x1000007f,0x40000003,0x10000003,0x40000007,0x10000007,0x40000003,0x10000003,0x4000000f,0x1000000f,0x00000000,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000187,0x40000003,0x10000003,0x40000007,0x10000007,0x40000003,0x10000003,0x1000012c},
  {0x100003c3,0x400003d2,0x40000001,0x10000001,0x40000001,0x10000001,0x400003d2,0x4000000f,0x1000000f,0x400003df,0x400003dd,0x40000007,0x10000007,0x00000000,0x40000053,0x400003d6,0x400003cb,0x40000003,0x10000003,0x400003f3,0x400003f7,0x10000063,0x400003ff,0x400003ff,0x40000001,0x10000001,0x100003a7,0x00000000,0x400003f3,0x400003ef,0x100003be,0x400003ea},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000326,0x4000000f,0x1000000f,0x4000032a,0x00000000,0x00000000,0x40000001,0x10000001,0x40000326,0x4000001f,0x1000001f,0x4000033b,0x40000339,0x40000007,0x10000007,0x40000003,0x10000003,0x40000325,0x40000001,0x10000001,0x00000000,0x00000000,0x40000001,0x10000001,0x00000000,0x10000048},
  {0x00000000,0x00000000,0x00000000,0x00000000,0x40000002,0x80000001,0x20000003,0x4000000e,0x8000000f,0x20000001,0x40000006,0x80000001,0x20000007,0x40000003,0x10000003,0x4000001f,0x1000001f,0x40000003,0x10000003,0x40000007,0x10000007,0x40000003,0x10000003,0x4000000f,0x1000000f,0x40000003,0x10000003,0x40000007,0x10000007,0x10000053,0x40000001,0x10000001},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x40000002,0x80000003,0x20000001,0x40000001,0x10000001,0x40000063,0x40000048,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001},
  {0x400003be,0x00000000,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x40002e5f,0x40000007,0x10000007,0x400003a7,0x40002e58,0x10002e41},
  {0x10002e3f,0x40000003,0x10000003,0x400003c3,0x400000cd,0x400000c9,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x10002e3f,0x10002e3c,0x10002e22,0x100003d2,0x100003d2,0x00000000,0x100003df,0x100003dd,0x00000000,0x100003d6,0x00000000,0x100003cb,0x1000a5f7,0x00000000,0x00000000,0x00000000},
  {0x100003f3,0x1000a5cd,0x00000000,0x100003f7,0x00000000,0x1000a5e8,0x1000a5cc,0x00000000,0x100003ff,0x100003ff,0x00000000,0x10002e09,0x1000a5c1,0x00000000,0x00000000,0x100003f3,0x00000000,0x10002e1f,0x100003ef,0x00000000,0x00000000,0x100003ea,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x10002e19,0x00000000,0x00000000},
  {0x10000326,0x00000000,0x00000000,0x1000032a,0x00000000,0x00000000,0x00000000,0x1000a536,0x10000326,0x100000cd,0x1000033b,0x10000339,0x100000c9,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x10000325,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x1000a52f,0x1000a52e,0x00000000},
  {0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x100000dc,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x00000000,0x40000001,0x10000001,0x00000000,0x00000000,0x00000000,0x10000086,0x10000082,0x10000082,0x00000000,0x4000008c},
  {0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x4000002a,0x00000000,0x40000025,0x40000027,0x40000025,0x00000000,0x40000040,0x00000000,0x40000043,0x40000041,0x00000000,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020},
  {0x40000060,0x40000060,0x00000000,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x1000002a,0x10000025,0x10000027,0x10000025,0x00000000,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020},
  {0x10000060,0x10000060,0x10000061,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000040,0x10000043,0x10000041,0x40000018,0x10000042,0x10000049,0x00000000,0x00000000,0x00000000,0x10000073,0x10000076,0x10000018,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x1000006a,0x10000050,0x1000000b,0x1000008c,0x4000004c,0x10000060,0x00000000,0x4000000f,0x1000000f,0x4000000b,0x40000001,0x10000001,0x00000000,0x40000086,0x40000082,0x40000082},
  {0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020},
  {0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020},
  {0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050},
  {0x40000001,0x10000001,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001},
  {0x4000000f,0x40000003,0x10000003,0x40000007,0x10000007,0x40000003,0x10000003,0x4000000f,0x1000000f,0x40000003,0x10000003,0x40000007,0x10000007,0x40000003,0x10000003,0x1000000f,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050},
  {0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x400000d0,0x400000d0,0x400000d0,0x400000d0,0x400000d0,0x400000d0,0x400000d0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x00000000,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030},
  {0x100000d0,0x100000d0,0x100000d0,0x100000d0,0x100000d0,0x100000d0,0x100000d0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0},
  {0x40003de0,0x40003de0,0x40003de0,0x40003de0,0x40003de0,0x40003de0,0x00000000,0x40003de0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x40003de0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b830,0x4000b830,0x4000b830,0x4000b830,0x4000b830,0x4000b830,0x4000b830,0x4000b830,0x4000b830,0x4000b830,0x4000b830,0x4000b830,0x4000b830,0x4000b830,0x4000b830,0x4000b830},
  {0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b870,0x4000b870,0x4000b870,0x4000b870,0x4000b870,0x4000b870,0x4000b870,0x4000b870,0x4000b870,0x4000b870,0x4000b870,0x4000b870,0x4000b870,0x4000b870,0x4000b870,0x4000b870},
  {0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x00000000,0x00000000,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x00000000,0x00000000},
  {0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x1000ba04,0x00000000,0x00000000,0x00000000,0x1000311e,0x00000000,0x00000000},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x100000fb,0x00000000,0x00000000,0x40001e41,0x00000000},
  {0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x00000000,0x00000000,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x00000000,0x00000000},
  {0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008},
  {0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x00000000,0x00000000,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x00000000,0x00000000,0x00000000,0x10000008,0x00000000,0x10000008,0x00000000,0x10000008,0x00000000,0x10000008,0x00000000,0x40000008,0x00000000,0x40000008,0x00000000,0x40000008,0x00000000,0x40000008},
  {0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x100000ca,0x100000ca,0x100000ba,0x100000ba,0x100000be,0x100000be,0x100000ac,0x100000ac,0x10000080,0x10000080,0x10000090,0x10000090,0x10000086,0x10000086,0x00000000,0x00000000},
  {0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x10000008,0x10000008,0x00000000,0x1000000f,0x00000000,0x00000000,0x00000000,0x00000000,0x40000008,0x40000008,0x400000ca,0x400000ca,0x4000000f,0x00000000,0x10001c27,0x00000000},
  {0x00000000,0x00000000,0x00000000,0x1000000f,0x00000000,0x00000000,0x00000000,0x00000000,0x400000ba,0x400000ba,0x400000be,0x400000be,0x4000000f,0x00000000,0x00000000,0x00000000,0x10000008,0x10000008,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x40000008,0x40000008,0x400000ac,0x400000ac,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x10000008,0x10000008,0x00000000,0x00000000,0x00000000,0x10000009,0x00000000,0x00000000,0x40000008,0x40000008,0x40000090,0x40000090,0x40000009,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x1000000f,0x00000000,0x00000000,0x00000000,0x00000000,0x40000080,0x40000080,0x40000086,0x40000086,0x4000000f,0x00000000,0x00000000,0x00000000},
  {0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x400022ef,0x00000000,0x00000000,0x00000000,0x40002141,0x400021ce,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x4000007c,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x1000007c,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x40000010,0x40000010,0x40000010,0x40000010,0x40000010,0x40000010,0x40000010,0x40000010,0x40000010,0x40000010,0x40000010,0x40000010,0x40000010,0x40000010,0x40000010,0x40000010,0x10000010,0x10000010,0x10000010,0x10000010,0x10000010,0x10000010,0x10000010,0x10000010,0x10000010,0x10000010,0x10000010,0x10000010,0x10000010,0x10000010,0x10000010,0x10000010},
  {0x00000000,0x00000000,0x00000000,0x40000007,0x10000007,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x40000066,0x40000066,0x4000006a,0x4000006a,0x4000006e,0x4000006e,0x4000006a,0x4000006a,0x40000066,0x40000066},
  {0x4000001a,0x4000001a,0x4000001e,0x4000001e,0x4000001a,0x4000001a,0x40000026,0x40000026,0x4000002a,0x4000002a,0x4000002e,0x4000002e,0x4000002a,0x4000002a,0x40000026,0x40000026,0x10000066,0x10000066,0x1000006a,0x1000006a,0x1000006e,0x1000006e,0x1000006a,0x1000006a,0x10000066,0x10000066,0x1000001a,0x1000001a,0x1000001e,0x1000001e,0x1000001a,0x1000001a},
  {0x10000026,0x10000026,0x1000002a,0x1000002a,0x1000002e,0x1000002e,0x1000002a,0x1000002a,0x10000026,0x10000026,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050},
  {0x40000070,0x40000070,0x40000070,0x40000070,0x40000070,0x40000070,0x40000070,0x40000070,0x40000070,0x40000070,0x40000070,0x40000070,0x40000070,0x40000070,0x40000070,0x00000000,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030},
  {0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000070,0x10000070,0x10000070,0x10000070,0x10000070,0x10000070,0x10000070,0x10000070,0x10000070,0x10000070,0x10000070,0x10000070,0x10000070,0x10000070,0x10000070,0x00000000},
  {0x40000001,0x10000001,0x40002e09,0x4000311e,0x40002e19,0x10002e5f,0x10002e58,0x4000000f,0x1000000f,0x40000003,0x10000003,0x40000007,0x10000007,0x40002e3c,0x40002e1f,0x40002e3f,0x40002e22,0x00000000,0x40000001,0x10000001,0x00000000,0x40000003,0x10000003,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x40002e41,0x40002e3f},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x40000007,0x10000007,0x40000003,0x10000003,0x00000000,0x00000000,0x00000000,0x40000001,0x10000001,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0},
  {0x10003de0,0x10003de0,0x10003de0,0x10003de0,0x10003de0,0x10003de0,0x00000000,0x10003de0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x10003de0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x00000000,0x00000000,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x00000000,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x40000003,0x10000003,0x40000007,0x10000007,0x4000ba04,0x40000001,0x10000001},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x00000000,0x00000000,0x40000007,0x10000007,0x4000a5e8,0x00000000,0x00000000,0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x00000000,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x4000a5cc,0x4000a5f7,0x4000a5cd,0x4000a5c1,0x00000000,0x00000000,0x4000a52e,0x4000a536,0x4000a52f,0x40000ce0,0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x10000ce0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x1000b8d0,0x1000b8d0,0x1000b8d0,0x1000b8d0,0x1000b8d0,0x1000b8d0,0x1000b8d0,0x1000b8d0,0x1000b8d0,0x1000b8d0,0x1000b8d0,0x1000b8d0,0x1000b8d0,0x1000b8d0,0x1000b8d0,0x1000b8d0},
  {0x1000b830,0x1000b830,0x1000b830,0x1000b830,0x1000b830,0x1000b830,0x1000b830,0x1000b830,0x1000b830,0x1000b830,0x1000b830,0x1000b830,0x1000b830,0x1000b830,0x1000b830,0x1000b830,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850},
  {0x1000b870,0x1000b870,0x1000b870,0x1000b870,0x1000b870,0x1000b870,0x1000b870,0x1000b870,0x1000b870,0x1000b870,0x1000b870,0x1000b870,0x1000b870,0x1000b870,0x1000b870,0x1000b870,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850},
  {0x00000000,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x00000000,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x40000028,0x40000028,0x40000028,0x40000028,0x40000028,0x40000028,0x40000028,0x40000028,0x40000038,0x40000038,0x40000038,0x40000038,0x40000038,0x40000038,0x40000038,0x40000038,0x40000028,0x40000028,0x40000028,0x40000028,0x40000028,0x40000028,0x40000028,0x40000028,0x40000058,0x40000058,0x40000058,0x40000058,0x40000058,0x40000058,0x40000058,0x40000058},
  {0x40000068,0x40000068,0x40000068,0x40000068,0x40000068,0x40000068,0x40000068,0x40000068,0x10000028,0x10000028,0x10000028,0x10000028,0x10000028,0x10000028,0x10000028,0x10000028,0x10000038,0x10000038,0x10000038,0x10000038,0x10000038,0x10000038,0x10000038,0x10000038,0x10000028,0x10000028,0x10000028,0x10000028,0x10000028,0x10000028,0x10000028,0x10000028},
  {0x10000058,0x10000058,0x10000058,0x10000058,0x10000058,0x10000058,0x10000058,0x10000058,0x10000068,0x10000068,0x10000068,0x10000068,0x10000068,0x10000068,0x10000068,0x10000068,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040},
  {0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040},
  {0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060},
  {0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060}
};

const uint32_t kTitleToUpper = 0x80000000;
const uint32_t kUpperToLower = 0x40000000;
const uint32_t kLowerToTitle = 0x20000000;
const uint32_t kLowerToUpper = 0x10000000;
const uint32_t kCaseMapCharMask = 0x001fffff;

/*
 * * * * * This file contains MACHINE-GENERATED DATA, do not edit! * * * * *
 */
