/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set ts=8 sts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_dom_PostMessageEvent_h
#define mozilla_dom_PostMessageEvent_h

#include "mozilla/dom/StructuredCloneHelper.h"
#include "nsCOMPtr.h"
#include "mozilla/nsRefPtr.h"
#include "nsTArray.h"
#include "nsThreadUtils.h"

class nsGlobalWindow;
class nsIPrincipal;
class nsPIDOMWindow;

namespace mozilla {
namespace dom {

/**
 * Class used to represent events generated by calls to Window.postMessage,
 * which asynchronously creates and dispatches events.
 */
class PostMessageEvent final : public nsRunnable
                             , public StructuredCloneHelper
{
public:
  NS_DECL_NSIRUNNABLE

  PostMessageEvent(nsGlobalWindow* aSource,
                   const nsAString& aCallerOrigin,
                   nsGlobalWindow* aTargetWindow,
                   nsIPrincipal* aProvidedPrincipal,
                   bool aTrustedCaller);

private:
  ~PostMessageEvent();

  nsRefPtr<nsGlobalWindow> mSource;
  nsString mCallerOrigin;
  nsRefPtr<nsGlobalWindow> mTargetWindow;
  nsCOMPtr<nsIPrincipal> mProvidedPrincipal;
  bool mTrustedCaller;
};

} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_PostMessageEvent_h
