/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/*****************************************************************************/
/* This is an automatically generated file. If you're not                    */
/* nsSiteSecurityService.cpp, you shouldn't be #including it.     */
/*****************************************************************************/

#include <stdint.h>
const PRTime gPreloadListExpirationTime = INT64_C(1468150086032000);

class nsSTSPreload
{
  public:
    const char *mHost;
    const bool mIncludeSubdomains;
};

static const nsSTSPreload kSTSPreloadList[] = {
  { "0.me.uk", true },
  { "007sascha.de", true },
  { "0au.de", true },
  { "0p.no", true },
  { "0paste.com", true },
  { "0x0a.net", true },
  { "0x1337.eu", true },
  { "0x90.io", true },
  { "0xfc.de", true },
  { "1000minds.com", true },
  { "1017scribes.com", true },
  { "17hats.com", true },
  { "188trafalgar.ca", true },
  { "18f.gov", true },
  { "18f.gsa.gov", true },
  { "1a-diamantscheiben.de", true },
  { "1a-jva.de", true },
  { "1a-vermessung.at", true },
  { "1a-werkstattgeraete.de", true },
  { "1co-jp.net", true },
  { "1km.ro", true },
  { "2048game.co.uk", true },
  { "2600hq.com", true },
  { "2bis10.de", true },
  { "2nerds1bit.com", true },
  { "301.website", true },
  { "314chan.org", true },
  { "33-km.ru", true },
  { "3473-wiki.de", true },
  { "360gradus.com", true },
  { "368mibn.com", true },
  { "3chit.cf", true },
  { "3do3dont.com", true },
  { "403.ch", true },
  { "42ms.org", true },
  { "47ronin.com", false },
  { "4eyes.ch", true },
  { "4g-server.eu", true },
  { "4mm.org", true },
  { "4sqsu.eu", true },
  { "5apps.com", true },
  { "692b8c32.de", true },
  { "6969.us", true },
  { "7183.org", true },
  { "777coin.com", true },
  { "888sport.dk", true },
  { "8ack.de", true },
  { "9point6.com", true },
  { "a-plus.space", true },
  { "aaeblog.com", true },
  { "abecodes.net", false },
  { "abeestrada.com", true },
  { "abiapp.net", true },
  { "abioniere.de", true },
  { "abiturma.de", true },
  { "abmahnhelfer.de", true },
  { "abrilect.com", true },
  { "abury.me", true },
  { "access-sofia.org", true },
  { "accountradar.com", true },
  { "accounts.firefox.com", true },
  { "accounts.google.com", true },
  { "achenar.net", true },
  { "aclu.org", false },
  { "acorns.com", true },
  { "acr.im", true },
  { "acuica.co.uk", false },
  { "acus.gov", true },
  { "ad-notam.pt", true },
  { "adam-kostecki.de", true },
  { "adambyers.com", true },
  { "adamkostecki.de", true },
  { "adamradocz.com", true },
  { "adams.dk", true },
  { "adamstas.com", true },
  { "adblock.ovh", true },
  { "adblockextreme.com", true },
  { "adduono.com", true },
  { "addvocate.com", true },
  { "adevel.eu", true },
  { "adimaja.com", true },
  { "adjagu.org", true },
  { "adlershop.ch", true },
  { "admin.fedoraproject.org", true },
  { "admin.google.com", true },
  { "admin.stg.fedoraproject.org", true },
  { "admsel.ec", true },
  { "adorai.tk", true },
  { "adrl.ca", true },
  { "adsfund.org", true },
  { "advanced-online.eu", true },
  { "advancis.net", true },
  { "adviespuntklokkenluiders.nl", true },
  { "aerolog.co", true },
  { "aes256.ru", true },
  { "aeyoun.com", true },
  { "affinitysync.com", true },
  { "afp548.com", true },
  { "afrodigital.uk", true },
  { "ageg.ca", true },
  { "agonswim.com", true },
  { "ahmerjamilkhan.org", true },
  { "ahoyconference.com", true },
  { "ahwatukeefoothillsmontessori.com", true },
  { "ahxxm.com", true },
  { "aids.gov", true },
  { "aie.de", true },
  { "aircomms.com", true },
  { "airlea.com", true },
  { "aishnair.com", true },
  { "aiticon.com", true },
  { "ajouin.com", true },
  { "akachanikuji.com", true },
  { "akhilindurti.com", true },
  { "akombakom.net", true },
  { "akostecki.de", true },
  { "akselinurmio.fi", true },
  { "aktiv-naturheilmittel.at", true },
  { "aktiv-naturheilmittel.ch", true },
  { "aktiv-naturheilmittel.de", true },
  { "aladdin.ie", true },
  { "aladdinschools.appspot.com", true },
  { "alainwolf.ch", true },
  { "alainwolf.net", true },
  { "alair.cn", true },
  { "alaninkenya.org", true },
  { "alanrickmanflipstable.com", true },
  { "alaricfavier.eu", true },
  { "alcazaar.com", true },
  { "alenan.org", true },
  { "alethearose.com", true },
  { "alex-ross.co.uk", true },
  { "alexbaker.org", true },
  { "alexgaynor.net", true },
  { "alexsexton.com", true },
  { "alexvetter.de", true },
  { "alexwardweb.com", true },
  { "alexyang.me", true },
  { "alfredxing.com", true },
  { "alkami.com", true },
  { "alkamitech.com", true },
  { "allcarepharmacy.com", true },
  { "alltheducks.com", true },
  { "allthingswild.co.uk", true },
  { "alocato.com", true },
  { "alpca.org", true },
  { "alphassl.de", true },
  { "alt.org", true },
  { "altedirect.com", true },
  { "altesses.eu", true },
  { "altestore.com", true },
  { "altonblom.com", true },
  { "alza.cz", true },
  { "alza.de", true },
  { "alza.sk", true },
  { "alzashop.com", true },
  { "amaforums.org", true },
  { "amdouglas.com", true },
  { "amdouglas.uk", true },
  { "americanbio.com", true },
  { "amerimarkdirect.com", true },
  { "amisharingstuff.com", true },
  { "amishsecurity.com", true },
  { "amoory.com", false },
  { "amunoz.org", true },
  { "anadoluefessk.org", true },
  { "anadoluefessporkulubu.org", true },
  { "anakros.me", true },
  { "andere-gedanken.net", true },
  { "anderslind.dk", true },
  { "andreas-kluge.eu", true },
  { "andreasfeusi.ch", true },
  { "andreaskluge.eu", true },
  { "andreasolsson.se", true },
  { "andreigec.net", true },
  { "andrewbroekman.com", true },
  { "andrewimeson.com", true },
  { "andrewsun.com", true },
  { "andreypopp.com", true },
  { "andymartin.cc", true },
  { "anedot.com", true },
  { "anedot.xyz", true },
  { "anetaben.nl", true },
  { "anfsanchezo.me", true },
  { "angristan.fr", true },
  { "angularjs.org", true },
  { "anime.my", false },
  { "animesharp.com", true },
  { "aniplus.cf", true },
  { "aniplus.gq", true },
  { "anitube-nocookie.ch", true },
  { "anitube.ch", true },
  { "ankakaak.com", true },
  { "ankarakart.com.tr", true },
  { "ankaraprofesyonelnakliyat.com", true },
  { "ankaraprofesyonelnakliyat.com.tr", true },
  { "ankaraprofesyonelwebtasarim.com", true },
  { "ankarauzmanlarnakliyat.com", true },
  { "annabellaw.com", true },
  { "annahmeschluss.de", true },
  { "annevankesteren.com", true },
  { "annevankesteren.nl", true },
  { "annevankesteren.org", true },
  { "anonym-surfen.de", true },
  { "another.ch", true },
  { "ansdell.net", true },
  { "antipolygraph.org", true },
  { "antoniomarques.eu", true },
  { "anzeiger.ag", true },
  { "aojf.fr", true },
  { "aosus.org", true },
  { "apachehaus.de", false },
  { "apadvantage.com", true },
  { "api.cloudflare.com", false },
  { "api.intercom.io", false },
  { "api.lookout.com", false },
  { "api.simple.com", false },
  { "api.xero.com", false },
  { "apis.google.com", true },
  { "apn-einstellungen.de", true },
  { "apnakliyat.com", true },
  { "aponow.de", true },
  { "app.lookout.com", false },
  { "app.manilla.com", true },
  { "app.recurly.com", true },
  { "app.simpletax.ca", false },
  { "app.yinxiang.com", false },
  { "appartementhaus-badria.de", true },
  { "appengine.google.com", true },
  { "appharbor.com", true },
  { "apple-watch-zubehoer.de", true },
  { "appmobile.io", true },
  { "approlys.fr", true },
  { "apps-for-fishing.com", true },
  { "apps.facebook.com", false },
  { "apps.fedoraproject.org", true },
  { "apps.stg.fedoraproject.org", true },
  { "appson.co.uk", true },
  { "appuro.com", true },
  { "aprz.de", true },
  { "apstudynotes.org", true },
  { "aquilaguild.com", true },
  { "aranycsillag.net", true },
  { "arbitrary.ch", true },
  { "archlinux.de", true },
  { "areafiftylan.nl", true },
  { "areatrend.com", true },
  { "arendburgers.nl", true },
  { "arguggi.co.uk", true },
  { "arivo.com.br", false },
  { "arjandejong.eu", true },
  { "arlen.io", true },
  { "armory.consulting", true },
  { "armory.supplies", false },
  { "armytricka.cz", true },
  { "arnaudfeld.de", true },
  { "arnor.org", true },
  { "aroonchande.com", true },
  { "artegusto.ru", true },
  { "arteseideias.com.pt", true },
  { "artofwhere.com", true },
  { "arty.name", true },
  { "aryasenna.net", true },
  { "asandu.eu", true },
  { "ask.fedoraproject.org", true },
  { "ask.stg.fedoraproject.org", true },
  { "askfit.cz", true },
  { "askwhy.cz", true },
  { "askwhy.eu", true },
  { "asm-x.com", true },
  { "aspargesgaarden.no", true },
  { "aspires.co.jp", true },
  { "ass.org.au", true },
  { "assdecoeur.org", true },
  { "astengox.com", true },
  { "asun.co", true },
  { "at.search.yahoo.com", false },
  { "atc.io", true },
  { "atgseed.co.uk", true },
  { "atgseed.uk", true },
  { "athenelive.com", true },
  { "atishchenko.com", true },
  { "atisoft.com.tr", true },
  { "atisoft.net", true },
  { "atisoft.net.tr", true },
  { "atisoft.web.tr", true },
  { "atlantichomes.com.au", true },
  { "atlantischild.hu", true },
  { "atlassian.net", true },
  { "atlex.nl", true },
  { "atolm.net", true },
  { "atop.io", true },
  { "atte.fi", true },
  { "auditmatrix.com", true },
  { "auf-feindgebiet.de", true },
  { "augustian-life.cz", true },
  { "augustiner-kantorei-erfurt.de", true },
  { "augustiner-kantorei.de", true },
  { "aulo.in", false },
  { "aunali1.com", true },
  { "aurainfosec.com", true },
  { "aurainfosec.com.au", true },
  { "auraredeye.com", true },
  { "auraredshield.com", true },
  { "aussiecable.org", true },
  { "authentication.io", true },
  { "authint.com", true },
  { "autokovrik-diskont.ru", true },
  { "autoledky.sk", true },
  { "avacariu.me", true },
  { "avalon-island.ru", true },
  { "avantmfg.com", true },
  { "avarty.com", true },
  { "avastantivirus.ro", true },
  { "avec-ou-sans-ordonnance.fr", true },
  { "aviacao.pt", true },
  { "axka.com", false },
  { "aylak.com", true },
  { "azabani.com", true },
  { "azirevpn.com", true },
  { "b-root-force.de", true },
  { "b2and.com", false },
  { "b3orion.com", true },
  { "babarkata.com", true },
  { "babyfotograf-schweiz.ch", true },
  { "bacchanallia.com", true },
  { "backschues.net", true },
  { "badcronjob.com", true },
  { "badges.fedoraproject.org", true },
  { "badges.stg.fedoraproject.org", true },
  { "badkamergigant.com", true },
  { "badlink.org", true },
  { "baer.im", true },
  { "baff.lu", true },
  { "bagelsbakery.com", true },
  { "bajic.ch", true },
  { "balboa.io", true },
  { "balcan-underground.net", true },
  { "balikonos.cz", true },
  { "balkonien.org", true },
  { "ball.holdings", true },
  { "bam.com.au", true },
  { "bananabandy.com", true },
  { "bandrcrafts.com", true },
  { "bank.simple.com", false },
  { "bankin.com", true },
  { "baofengtech.com", true },
  { "barcodeberlin.com", true },
  { "bardiharborow.com", true },
  { "barslecht.com", true },
  { "barslecht.nl", true },
  { "baruch.me", true },
  { "basnoslovno.com.ua", true },
  { "basnoslovno.ru", true },
  { "bassh.net", true },
  { "bastianstalder.ch", true },
  { "baud.ninja", true },
  { "bautied.de", true },
  { "bayrisch-fuer-anfaenger.de", true },
  { "bbnx.net", true },
  { "bccx.com", true },
  { "bcrook.com", false },
  { "bcsytv.com", true },
  { "bcvps.com", true },
  { "beach-inspector.com", true },
  { "beachi.es", true },
  { "beaglewatch.com", true },
  { "beamitapp.com", true },
  { "beans-one.com", false },
  { "beastowner.li", true },
  { "bebesurdoue.com", true },
  { "bedeta.de", true },
  { "bedreid.dk", true },
  { "beeksnetwork.nl", true },
  { "beercandle.com", true },
  { "beholdthehurricane.com", true },
  { "beier.io", true },
  { "ben-energy.com", false },
  { "ben.ninja", true },
  { "benchling.com", true },
  { "bendechrai.com", true },
  { "beneathvt.com", true },
  { "beneffy.com", true },
  { "benjamin.pe", true },
  { "benjamins.com", true },
  { "bentertain.de", true },
  { "bentley.link", true },
  { "bentrask.com", true },
  { "beranovi.com", true },
  { "bergstoneware.com", false },
  { "bermeitinger.eu", true },
  { "berra.se", true },
  { "berst.cz", true },
  { "berthabailey.com", true },
  { "best-wedding-quotes.com", true },
  { "besthost.cz", true },
  { "betaworx.de", true },
  { "betaworx.eu", true },
  { "bets.de", true },
  { "bettercrypto.org", true },
  { "betterhelp.com", true },
  { "bettrlifeapp.com", true },
  { "bettween.com", true },
  { "bexit.nl", true },
  { "bfelob.gov", true },
  { "bfw-online.de", true },
  { "bgmn.net", true },
  { "bgneuesheim.de", true },
  { "bhatia.at", true },
  { "biasmath.es", true },
  { "biathloncup.ru", true },
  { "biddl.com", true },
  { "bienici.com", true },
  { "big-andy.co.uk", true },
  { "bigbluedoor.net", true },
  { "bigbrownpromotions.com.au", true },
  { "bigclassaction.com", true },
  { "bike-shack.com", true },
  { "bildermachr.de", true },
  { "billigssl.dk", true },
  { "binaryevolved.com", true },
  { "bionicspirit.com", true },
  { "biosignalanalytics.com", true },
  { "biou.me", true },
  { "bit-sentinel.com", true },
  { "bit.voyage", true },
  { "bitbucket.org", false },
  { "bitchan.it", true },
  { "bitcoin.de", true },
  { "bitcoinhk.org", true },
  { "bitcoinworld.me", true },
  { "bitcoinx.ro", true },
  { "bitfactory.ws", true },
  { "bitgo.com", true },
  { "bitlish.com", true },
  { "bitmex.com", true },
  { "bitminter.com", true },
  { "bitmon.net", true },
  { "bitnet.io", true },
  { "bitok.com", true },
  { "bitpod.de", true },
  { "bizcms.com", true },
  { "bjornhelmersson.se", true },
  { "bjornjohansen.no", true },
  { "bl4ckb0x.com", true },
  { "bl4ckb0x.de", true },
  { "bl4ckb0x.info", true },
  { "bl4ckb0x.net", true },
  { "bl4ckb0x.org", true },
  { "blablacar.co.uk", true },
  { "blablacar.com", true },
  { "blablacar.com.tr", true },
  { "blablacar.com.ua", true },
  { "blablacar.de", true },
  { "blablacar.es", true },
  { "blablacar.fr", true },
  { "blablacar.hr", true },
  { "blablacar.hu", true },
  { "blablacar.in", true },
  { "blablacar.it", true },
  { "blablacar.mx", true },
  { "blablacar.nl", true },
  { "blablacar.pl", true },
  { "blablacar.pt", true },
  { "blablacar.ro", true },
  { "blablacar.rs", true },
  { "blablacar.ru", true },
  { "blackberrycentral.com", true },
  { "blackburn.link", true },
  { "blackdragoninc.org", true },
  { "blackpayment.ru", true },
  { "blaise.io", true },
  { "blauwwit.be", true },
  { "blazor.nl", true },
  { "blechschmidt.saarland", true },
  { "blendle.com", true },
  { "blendle.nl", true },
  { "blessnet.jp", true },
  { "blmiller.com", true },
  { "blockchain.info", true },
  { "blocksatz-medien.de", true },
  { "bloemendal.me", true },
  { "blog.cyveillance.com", true },
  { "blog.gov.uk", true },
  { "blog.gparent.org", true },
  { "blog.linode.com", false },
  { "blog.torproject.org", false },
  { "blognone.com", true },
  { "blubbablasen.de", true },
  { "bluemosh.com", true },
  { "blumenfeldart.com", true },
  { "bm-trading.nl", true },
  { "bockenauer.at", true },
  { "bodyblog.nl", true },
  { "bohramt.de", true },
  { "boiseonlinemall.com", true },
  { "bonapp.restaurant", true },
  { "bonifacius.be", true },
  { "bonobo.cz", true },
  { "boringsecurity.net", true },
  { "boris.one", false },
  { "borrelioz.com", true },
  { "borysek.net", true },
  { "bougeret.fr", true },
  { "bouncyball.eu", true },
  { "bouncyballs.org", true },
  { "bowling.com", true },
  { "bownty.dk", true },
  { "boxcryptor.com", true },
  { "boxintense.com", true },
  { "boypoint.de", true },
  { "bpastudies.org", true },
  { "bqtoolbox.com", true },
  { "br.search.yahoo.com", false },
  { "bradkovach.com", true },
  { "brage.info", true },
  { "brainfork.ml", true },
  { "brainster.co", false },
  { "braintreegateway.com", true },
  { "brakemanpro.com", true },
  { "brakstad.org", true },
  { "bran.cc", true },
  { "brandbuilderwebsites.com", true },
  { "brandon.so", true },
  { "brasalcosmetics.com", true },
  { "bratteng.me", true },
  { "breeswish.org", true },
  { "brianmwaters.net", true },
  { "brightstarkids.co.uk", true },
  { "brightstarkids.com.au", true },
  { "brightstarkids.net", true },
  { "brightstarkids.sg", true },
  { "brks.xyz", true },
  { "broadsheet.com.au", true },
  { "broersma.com", true },
  { "broeselei.at", true },
  { "brossmanit.com", true },
  { "brownfieldstsc.org", true },
  { "brrr.fr", true },
  { "brunosouza.org", true },
  { "bryanquigley.com", true },
  { "bryn.xyz", true },
  { "bsidessf.com", true },
  { "bsklabels.com", true },
  { "btsoft.eu", true },
  { "buddhistische-weisheiten.org", true },
  { "budgetalk.com", true },
  { "bugcrowd.com", true },
  { "bugginslab.co.uk", true },
  { "bugzil.la", true },
  { "bugzilla.mozilla.org", true },
  { "buiko.com", true },
  { "build.chromium.org", false },
  { "buildkite.com", true },
  { "bulktrade.de", true },
  { "bulldog-hosting.de", true },
  { "bulmafox.com", true },
  { "bunbun.be", true },
  { "bundaberg.com", true },
  { "burningcrash.de", true },
  { "burningflipside.com", true },
  { "burnworks.com", true },
  { "burtrum.me", true },
  { "burtrum.org", true },
  { "business.facebook.com", false },
  { "business.lookout.com", false },
  { "businesshosting.nl", true },
  { "bustimes.org", true },
  { "buzzconcert.com", true },
  { "buzzconf.io", true },
  { "bvalle.com", true },
  { "bwcscorecard.org", true },
  { "bygningsregistrering.dk", true },
  { "byronwade.com", true },
  { "byrtz.de", true },
  { "bytejail.com", true },
  { "bytepark.de", false },
  { "bzv-fr.eu", true },
  { "c16t.uk", true },
  { "ca.gparent.org", true },
  { "ca.search.yahoo.com", false },
  { "cackette.com", true },
  { "cadoth.net", true },
  { "cafe-scientifique.org.ec", true },
  { "caffeinatedcode.com", true },
  { "cais.de", true },
  { "caja-pdf.es", true },
  { "calaborlawnews.com", true },
  { "calculator-imt.com", true },
  { "call.me", true },
  { "callsigns.ca", true },
  { "calomel.org", true },
  { "calories.org", true },
  { "calvin.me", true },
  { "calvinallen.net", true },
  { "camolist.com", true },
  { "camperverzekerd.nl", true },
  { "campus-finance.com", true },
  { "canadalife.de", true },
  { "canadasmotorcycle.ca", true },
  { "canhazip.com", true },
  { "cannyfoxx.me", true },
  { "canyonshoa.com", true },
  { "cao.gov", true },
  { "cao.la", true },
  { "capitaltg.com", true },
  { "capriccio.to", true },
  { "carboneselectricosnettosl.info", true },
  { "carck.co.uk", true },
  { "cardoni.net", true },
  { "cardrecovery.fr", true },
  { "caremad.io", true },
  { "carezone.com", false },
  { "cargobay.net", true },
  { "carlosalves.info", true },
  { "carsforbackpackers.com", true },
  { "cartouche24.eu", true },
  { "cartucce24.it", true },
  { "casa-su.casa", true },
  { "cashlink.io", true },
  { "casperpanel.com", true },
  { "cativa.net", true },
  { "catnapstudios.com", true },
  { "catnet.dk", true },
  { "cattivo.nl", true },
  { "cavac.at", true },
  { "caveclan.org", true },
  { "cbhq.net", true },
  { "ccayearbook.com", true },
  { "ccblog.de", true },
  { "ccsys.com", true },
  { "cdlcenter.com", true },
  { "cdnb.co", true },
  { "cdt.org", true },
  { "cecipu.gob.cl", true },
  { "cementscience.com", true },
  { "centralync.com", true },
  { "centricweb.com", true },
  { "ceopedia.org", true },
  { "certcenter.com", true },
  { "certcenter.de", true },
  { "certible.com", true },
  { "certifi.io", true },
  { "certly.io", true },
  { "cesal.net", true },
  { "cesobaly.cz", true },
  { "cevrimici.com", true },
  { "cfa.gov", true },
  { "cfcnexus.org", true },
  { "cfetengineering.com", true },
  { "cfo.gov", true },
  { "ch.search.yahoo.com", false },
  { "chahub.com", true },
  { "chainmonitor.com", true },
  { "chaletmanager.com", true },
  { "changetip.com", true },
  { "chaoschemnitz.de", true },
  { "chaosdorf.de", true },
  { "charge.co", true },
  { "charmander.me", true },
  { "chartstoffarm.de", false },
  { "chatbot.me", true },
  { "chcemvediet.sk", true },
  { "chch.it", true },
  { "cheapgeekts.com", false },
  { "check.torproject.org", false },
  { "checkout.google.com", true },
  { "checktype.com", true },
  { "cheerflow.com", true },
  { "cheesetart.my", false },
  { "chfr.search.yahoo.com", false },
  { "chic-leather.com", true },
  { "chimeratool.com", true },
  { "chippy.ch", false },
  { "chiralsoftware.com", true },
  { "chiru.no", true },
  { "chit.search.yahoo.com", false },
  { "chloe.re", true },
  { "choosemypc.net", true },
  { "chrisbrown.id.au", true },
  { "chrisirwin.ca", true },
  { "chrisjean.com", true },
  { "chrismckee.co.uk", true },
  { "christiaanconover.com", true },
  { "christianbro.gq", true },
  { "chrisupjohn.com", true },
  { "chriswarrick.com", true },
  { "chriswells.io", true },
  { "chrome-devtools-frontend.appspot.com", true },
  { "chrome.com", false },
  { "chrome.google.com", true },
  { "chromebooksforwork.com", true },
  { "chromiumcodereview.appspot.com", false },
  { "chrst.ph", true },
  { "chulado.com", true },
  { "chun.pro", true },
  { "ciat.no", true },
  { "cidbot.com", true },
  { "cig-dem.com", true },
  { "cimballa.com", true },
  { "cinefilzonen.se", true },
  { "cio.gov", true },
  { "cip.md", false },
  { "cipherli.st", true },
  { "cirfi.com", true },
  { "cirope.com", true },
  { "ciscodude.net", true },
  { "ckleemann.de", true },
  { "cklie.de", true },
  { "ckliemann.com", true },
  { "ckliemann.net", true },
  { "cktennis.com", true },
  { "cl.search.yahoo.com", false },
  { "claimconnect.us", true },
  { "clan-ww.com", true },
  { "clapping-rhymes.com", true },
  { "claralabs.com", true },
  { "classdojo.com", true },
  { "classicspublishing.com", true },
  { "clearviewwealthprojector.com.au", true },
  { "clerkendweller.uk", true },
  { "clevertarget.ru", true },
  { "clevisto.com", true },
  { "clickandgo.com", true },
  { "clickclickphish.com", true },
  { "climateinteractive.org", true },
  { "clintonbloodworth.com", true },
  { "clintwilson.technology", true },
  { "clipped4u.com", true },
  { "clmde.de", true },
  { "cloud-project.com", true },
  { "cloud.google.com", true },
  { "cloud.wtf", true },
  { "clouddesktop.co.nz", true },
  { "cloudflareonazure.com", true },
  { "cloudily.com", true },
  { "cloudimag.es", true },
  { "cloudmigrator365.com", true },
  { "cloudns.com.au", true },
  { "cloudpagesforwork.com", true },
  { "cloudpebble.net", true },
  { "cloudsecurityalliance.org", true },
  { "cloudspace-analytics.com", true },
  { "cloudstoragemaus.com", true },
  { "cloudstorm.me", true },
  { "cloudup.com", true },
  { "clu-in.org", true },
  { "clubmini.jp", true },
  { "clycat.ru", true },
  { "cmc-versand.de", true },
  { "cmdline.org", true },
  { "cnlic.com", true },
  { "co.search.yahoo.com", false },
  { "co50.com", true },
  { "cobalt.io", false },
  { "cocoaheads.at", true },
  { "codabix.com", true },
  { "codabix.de", true },
  { "codabix.net", true },
  { "code-poets.co.uk", true },
  { "code.facebook.com", false },
  { "code.google.com", true },
  { "codepoints.net", true },
  { "codepref.com", true },
  { "codepult.com", true },
  { "codepx.com", true },
  { "codereview.appspot.com", false },
  { "codereview.chromium.org", false },
  { "codeux.com", true },
  { "codingforspeed.com", true },
  { "cogumelosmagicos.org", true },
  { "coiffeurschnittstelle.ch", true },
  { "coinapult.com", true },
  { "coinbase.com", true },
  { "coindam.com", false },
  { "cojo.eu", true },
  { "coldhak.ca", true },
  { "collabornation.net", true },
  { "collinmbarrett.com", true },
  { "colognegaming.net", true },
  { "coloradocomputernetworking.net", true },
  { "colorlib.com", true },
  { "comarkinstruments.net", true },
  { "comitesaustria.at", true },
  { "comiteshopping.com", true },
  { "commencepayments.com", true },
  { "comparejewelleryprices.co.uk", true },
  { "completionist.audio", true },
  { "compucorner.com.mx", true },
  { "compucorner.mx", true },
  { "comssa.org.au", true },
  { "concentrade.de", true },
  { "config.schokokeks.org", false },
  { "conformal.com", true },
  { "connect.ua", false },
  { "connext.de", true },
  { "conrad-kostecki.de", true },
  { "consciousandglamorous.com", true },
  { "console.support", true },
  { "consonare.de", true },
  { "constructionjobs.com", true },
  { "consul.io", true },
  { "consumersentinel.gov", true },
  { "contributor.google.com", true },
  { "controlcenter.gigahost.dk", true },
  { "conversiones.com", true },
  { "convert.zone", true },
  { "converter.ml", true },
  { "coolaj86.com", true },
  { "coopens.com", true },
  { "coore.jp", true },
  { "copperhead.co", true },
  { "cor-ser.es", true },
  { "coralproject.net", true },
  { "core.mx", true },
  { "coreless-stretchfilm.com", true },
  { "cormilu.com.br", true },
  { "corruption-mc.net", true },
  { "corruption-rsps.net", true },
  { "corruption-server.net", true },
  { "cortexitrecruitment.com", true },
  { "costablancavoorjou.com", true },
  { "cotonea.de", true },
  { "count.sh", true },
  { "countermail.com", true },
  { "couragewhispers.ca", true },
  { "courtlistener.com", true },
  { "covenantoftheriver.org", true },
  { "covoiturage.fr", false },
  { "cowboyim.com", true },
  { "cpvmatch.eu", true },
  { "cqchome.com", true },
  { "cracker.in.th", true },
  { "crackingking.com", true },
  { "cradlepointecm.com", true },
  { "craftbeerbarn.co.uk", true },
  { "crazydomains.com.au", true },
  { "crbug.com", false },
  { "creditkarma.com", true },
  { "crepererum.net", true },
  { "crestoncottage.com", true },
  { "crizk.com", true },
  { "crl-autos.com", true },
  { "crm.onlime.ch", false },
  { "crosscom.ch", true },
  { "crossfitblackwater.com", true },
  { "crow.tw", true },
  { "crowdjuris.com", true },
  { "crudysql.com", true },
  { "crute.me", true },
  { "cryptify.eu", true },
  { "crypto.cat", false },
  { "crypto.graphics", true },
  { "cryptobells.com", true },
  { "cryptobin.org", true },
  { "cryptography.io", true },
  { "cryptoparty.at", true },
  { "cryptoparty.dk", true },
  { "cryptopartyatx.org", true },
  { "cryptopartyutah.org", true },
  { "cryptopush.com", true },
  { "cryptoseb.pw", true },
  { "crystalchandelierservices.com", true },
  { "csacongress.org", true },
  { "csfs.org.uk", true },
  { "csgokings.eu", true },
  { "cspbuilder.info", true },
  { "cspvalidator.org", true },
  { "csuw.net", true },
  { "cthulhuden.com", true },
  { "ctns.de", true },
  { "ctoforhire.com.au", true },
  { "cube.de", true },
  { "cubewano.com", true },
  { "culinae.nl", true },
  { "cupcake.io", true },
  { "cupcake.is", true },
  { "curiosity-driven.org", true },
  { "curlybracket.co.uk", true },
  { "curroapp.com", true },
  { "curtacircuitos.com.br", false },
  { "custodyxchange.com", true },
  { "cuvva.co", true },
  { "cvjm-memmingen.de", true },
  { "cvmu.jp", true },
  { "cvsoftub.com", true },
  { "cvursache.com", true },
  { "cwagner.me", true },
  { "cyanogenmod.xxx", true },
  { "cyberkov.com", true },
  { "cyberpunk.ca", true },
  { "cybershambles.com", true },
  { "cybozu.com", true },
  { "cybozulive.com", true },
  { "cycleluxembourg.lu", true },
  { "cydia-search.io", true },
  { "cyon.ch", true },
  { "cyph.com", true },
  { "cyph.im", true },
  { "cyph.video", true },
  { "cyphertite.com", true },
  { "cyprus-company-service.com", true },
  { "cysec.biz", true },
  { "czakey.net", true },
  { "czbix.com", true },
  { "czk.mk", true },
  { "d3xt3r01.tk", true },
  { "d42.no", true },
  { "dadons-laserdiscs.com", true },
  { "daemon.xin", true },
  { "dailyenglishchallenge.com", true },
  { "daimadi.com", true },
  { "dale-electric.com", true },
  { "daniel-ruf.de", true },
  { "danielalvarez.net", true },
  { "dank.ninja", true },
  { "dannyrohde.de", true },
  { "danonsecurity.com", true },
  { "danpiel.net", true },
  { "danskoferie.dk", true },
  { "danw.io", true },
  { "daphne.informatik.uni-freiburg.de", true },
  { "daplie.com", true },
  { "darchoods.net", false },
  { "dario.im", true },
  { "darioturchetti.me", true },
  { "dark-x.cf", true },
  { "darkag.ovh", true },
  { "darkdestiny.ch", true },
  { "darkengine.io", true },
  { "darknebula.space", false },
  { "darknode.in", true },
  { "darkpony.ru", true },
  { "darkserver.fedoraproject.org", true },
  { "darkserver.stg.fedoraproject.org", true },
  { "darlo.co.uk", true },
  { "darom.jp", true },
  { "dash-board.jp", false },
  { "data-abundance.com", true },
  { "data.qld.gov.au", false },
  { "datapun.ch", true },
  { "dataretention.solutions", true },
  { "datasharesystem.com", true },
  { "datasnitch.co.uk", true },
  { "datatekniikka.com", false },
  { "datatekniikka.fi", false },
  { "dateno1.com", false },
  { "datorb.com", false },
  { "daveoc64.co.uk", true },
  { "david-schiffmann.de", true },
  { "david.kitchen", true },
  { "davidgow.net", true },
  { "davidgrudl.com", true },
  { "davidlyness.com", true },
  { "davidmcevoy.org.uk", true },
  { "davidnoren.com", true },
  { "davisroi.com", true },
  { "daylightpirates.org", true },
  { "dbgamestudio.com", true },
  { "dbmteam.com", true },
  { "dccode.gov", true },
  { "ddatsh.com", true },
  { "dden.ca", true },
  { "de-medici.nl", true },
  { "de-spil.be", true },
  { "de.search.yahoo.com", false },
  { "deadbeef.ninja", true },
  { "dealbanana.com", true },
  { "dealbanana.it", true },
  { "dealcruiser.nl", true },
  { "dealpass.no", true },
  { "decafu.co", true },
  { "decoder.link", true },
  { "decomplify.com", true },
  { "dedeo.tk", true },
  { "dedimax.de", true },
  { "dee.pe", true },
  { "deepcovelabs.net", true },
  { "deepserve.info", true },
  { "defcon.org", true },
  { "dekasan.ru", true },
  { "delfic.org", true },
  { "deliciisanatoase.ro", true },
  { "deliverance.co.uk", false },
  { "democracy.io", true },
  { "democracychronicles.com", true },
  { "demuzere.be", true },
  { "demuzere.com", true },
  { "demuzere.eu", true },
  { "demuzere.net", true },
  { "denh.am", true },
  { "dennisdoes.net", true },
  { "depechemode-live.com", true },
  { "dequehablamos.es", true },
  { "dereferenced.net", true },
  { "derhil.de", true },
  { "derp.army", true },
  { "derreichesack.com", true },
  { "desmaakvanplanten.be", true },
  { "destinationbijoux.fr", true },
  { "detectify.com", false },
  { "detector.exposed", true },
  { "detteflies.com", true },
  { "devdoodle.net", true },
  { "developer.mydigipass.com", false },
  { "developers.facebook.com", false },
  { "devh.net", true },
  { "deviltracks.net", true },
  { "deviltraxxx.de", true },
  { "devinfo.net", false },
  { "devklog.net", true },
  { "devlux.ch", true },
  { "devnsec.com", true },
  { "devolution.ws", true },
  { "devopps.me", true },
  { "dgeex.eu", true },
  { "dhautefeuille.eu", true },
  { "dhauwer.nl", true },
  { "diamante.ro", true },
  { "dibiphp.com", true },
  { "dicgaming.net", true },
  { "didacte.com", true },
  { "die-besten-weisheiten.de", true },
  { "die-blahuts.de", true },
  { "die-partei-reutlingen.de", true },
  { "diegelernten.de", true },
  { "dienstplan.one", true },
  { "dietrich.cx", true },
  { "digital1st.co.uk", true },
  { "digitalskillswap.com", true },
  { "digitkon.com", true },
  { "dillonkorman.com", true },
  { "dime-staging.com", true },
  { "dime.io", true },
  { "dinkum.online", true },
  { "dinube.com", true },
  { "dirkwolf.de", true },
  { "discofitta.com", true },
  { "discoveringdocker.com", true },
  { "dise-online.de", true },
  { "disking.co.uk", true },
  { "dislocated.de", true },
  { "disorderboutique.com", true },
  { "disruptivelabs.net", true },
  { "disruptivelabs.org", true },
  { "dissimulo.me", true },
  { "dist.torproject.org", false },
  { "diversityflags.com", true },
  { "divingwithnic.com", true },
  { "dixmag.com", true },
  { "dk.search.yahoo.com", false },
  { "dl.google.com", true },
  { "dlc.viasinc.com", true },
  { "dlscomputers.com.au", true },
  { "dm.lookout.com", false },
  { "dm.mylookout.com", false },
  { "dmlogic.com", true },
  { "dmxledlights.com", true },
  { "dn42.us", true },
  { "dnmlab.it", true },
  { "dnscrypt.org", true },
  { "dnsman.se", true },
  { "dobet.in", true },
  { "doc.python.org", true },
  { "docemeldoces.com", true },
  { "docket.news", true },
  { "docloh.de", true },
  { "docs.google.com", true },
  { "docs.python.org", true },
  { "doctorwho.cz", true },
  { "docucopies.com", true },
  { "dogan.ch", false },
  { "dogoodbehappyllc.com", true },
  { "doktorsitesi.com", false },
  { "dolphin-cloud.com", true },
  { "dolphin-hosting.com", true },
  { "dolphin-it.de", true },
  { "dolphincorp.co.uk", true },
  { "domainexpress.de", true },
  { "domainkauf.de", true },
  { "domains.google.com", true },
  { "domainstaff.com", true },
  { "domfee.com", true },
  { "domodedovo.travel", true },
  { "donateaday.net", true },
  { "donmez.uk", true },
  { "donmez.ws", true },
  { "donner-reuschel.de", true },
  { "donotcall.gov", true },
  { "dopost.it", true },
  { "dorianharmans.nl", true },
  { "dorianmuthig.com", true },
  { "doridian.com", true },
  { "doridian.de", true },
  { "doridian.net", true },
  { "doridian.org", true },
  { "dot.ro", true },
  { "dotsiam.com", true },
  { "dovetailnow.com", true },
  { "dpsg-roden.de", true },
  { "dragon-chem.eu", true },
  { "dragonisles.net", true },
  { "dragons-of-highlands.cz", true },
  { "dreadbyte.com", true },
  { "dreamsforabetterworld.com.au", true },
  { "dreid.org", true },
  { "drive.google.com", true },
  { "driving-lessons.co.uk", true },
  { "droidwiki.de", true },
  { "dronepit.dk", true },
  { "dropbox.com", true },
  { "dropboxer.net", true },
  { "drtroyhendrickson.com", true },
  { "drumbandesperanto.nl", true },
  { "drupal.org", true },
  { "dsebastien.net", true },
  { "dubrovskiy.net", true },
  { "dubrovskiy.pro", true },
  { "duckduckstart.com", true },
  { "ducohosting.com", true },
  { "dukun.de", true },
  { "dutchrank.com", true },
  { "dutchrank.nl", true },
  { "dyeager.org", true },
  { "dylanscott.com.au", true },
  { "dynaloop.net", true },
  { "dynamicsnetwork.net", true },
  { "dyrenesverden.no", true },
  { "dziekonski.com", true },
  { "dzimejl.sk", true },
  { "dzlibs.io", true },
  { "e-kontakti.fi", true },
  { "e-typ.eu", true },
  { "e.mail.ru", true },
  { "eagletechz.com.br", true },
  { "eagleyecs.com", true },
  { "earmarks.gov", true },
  { "easy-rpg.org", true },
  { "easyhaul.com", true },
  { "easykonto.de", true },
  { "easysimplecrm.com", false },
  { "eatsleeprepeat.net", true },
  { "ebanking.indovinabank.com.vn", true },
  { "ecake.in", true },
  { "ecdn.cz", true },
  { "ecfs.link", true },
  { "ecg.fr", false },
  { "echomanchester.net", true },
  { "eckel.co", true },
  { "ecnetworker.com", true },
  { "ecobee.com", true },
  { "econsumer.gov", true },
  { "ecosystem.atlassian.net", true },
  { "ecrimex.net", true },
  { "ectora.com", true },
  { "ed.gs", true },
  { "edakoe.ru", true },
  { "eddmixpanel.com", true },
  { "edge-cloud.net", true },
  { "edgereinvent.com", true },
  { "ediscomp.sk", true },
  { "edissecurity.sk", true },
  { "edit.yahoo.com", false },
  { "edix.ru", true },
  { "edoss.co.za", true },
  { "edpubs.gov", true },
  { "eduid.se", true },
  { "eduroam.no", true },
  { "eduvance.in", true },
  { "edyou.eu", true },
  { "eelsden.net", true },
  { "eeqj.com", true },
  { "ef.gy", true },
  { "eff.org", true },
  { "efficienthealth.com", true },
  { "egfl.org.uk", true },
  { "egit.co", true },
  { "ego4u.com", true },
  { "ego4u.de", true },
  { "ehipaa.com", true },
  { "ehipaadev.com", true },
  { "eksisozluk.com", true },
  { "elbetech.net", true },
  { "electronic-ignition-system.com", true },
  { "electronicfasteners.com", true },
  { "eleicoes2016.com.br", true },
  { "elemental.software", true },
  { "elementalrobotics.com", true },
  { "elenag.ga", true },
  { "elephpant.cz", true },
  { "eligible.com", true },
  { "elisa.ee", true },
  { "elitegameservers.net", true },
  { "elitehosting.de", true },
  { "ellegaard.dk", true },
  { "elliquiy.com", true },
  { "ellsinger.me", true },
  { "elmermx.ch", true },
  { "elpo.net", true },
  { "elvidence.com.au", true },
  { "emailhunter.co", true },
  { "emailprivacytester.com", true },
  { "emanuelduss.ch", true },
  { "embracethedarkness.co.uk", true },
  { "emirabiz.com", false },
  { "empowerdb.com", true },
  { "emptypath.com", true },
  { "encircleapp.com", true },
  { "encryptallthethings.net", true },
  { "encrypted.google.com", true },
  { "endlesshorizon.net", true },
  { "endlesstone.com", true },
  { "endofnet.org", true },
  { "endzeit-architekten.com", true },
  { "energy-drink-magazin.de", true },
  { "engelundlicht.ch", true },
  { "englerts.de", true },
  { "englishbulgaria.net", true },
  { "englishclub.com", true },
  { "enigmail.net", true },
  { "enjen.net", true },
  { "enorekcah.com", true },
  { "enquos.com", true },
  { "enskat.de", true },
  { "enskatson-sippe.de", true },
  { "enteente.com", true },
  { "entersynapse.com", true },
  { "entrepreneur.or.id", true },
  { "entropia.de", false },
  { "envygeeks.com", true },
  { "envygeeks.io", true },
  { "epay.bg", true },
  { "eqorg.com", true },
  { "eriix.org", true },
  { "erisrenee.com", true },
  { "ernesto.at", true },
  { "errors.zenpayroll.com", false },
  { "eru.me", true },
  { "es.search.yahoo.com", false },
  { "escalate.eu", true },
  { "esclear.de", true },
  { "esg-abi2001.de", true },
  { "esoa.net", true },
  { "espanol.search.yahoo.com", false },
  { "espci.fr", true },
  { "espgg.org", true },
  { "espra.com", true },
  { "esquonic.com", true },
  { "essoduke.org", true },
  { "etaes.eu", true },
  { "ethack.org", true },
  { "ethercalc.com", true },
  { "ethercalc.org", true },
  { "etherpad.fr", true },
  { "ethicaldata.co.uk", true },
  { "ethicalexploiting.com", true },
  { "ethitter.com", true },
  { "eucl3d.com", true },
  { "eugenekay.com", true },
  { "europop.com", true },
  { "eurostrategy.vn.ua", true },
  { "eurotramp.com", true },
  { "ev-zertifikate.de", true },
  { "eva.cz", true },
  { "evalesc.com", true },
  { "evasovova.cz", true },
  { "evdenevenakliyatankara.pw", true },
  { "everhome.de", true },
  { "eveseat.net", true },
  { "eveshamglass.co.uk", true },
  { "evomon.com", true },
  { "evrial.com", true },
  { "evstatus.com", true },
  { "ewe2.ninja", true },
  { "exceltobarcode.com", true },
  { "excessamerica.com", true },
  { "exekutori.com", true },
  { "exfiles.cz", true },
  { "exiahost.com", true },
  { "expatads.com", true },
  { "experienceoz.com.au", true },
  { "explodie.org", true },
  { "expo-designers.com", true },
  { "express-vpn.com", true },
  { "expressfinance.co.za", true },
  { "expresshosting.org", true },
  { "expressvpn.com", true },
  { "expxkcd.com", true },
  { "extendwings.com", true },
  { "eyasc.nl", true },
  { "eydesignguidelines.com", true },
  { "eyyit.com", true },
  { "f-droid.org", true },
  { "f-thie.de", true },
  { "f2f.cash", true },
  { "fa-works.com", true },
  { "fabhub.io", true },
  { "fabianasantiago.com", true },
  { "fabse.net", true },
  { "facebook.com", false },
  { "factor.cc", false },
  { "fahrenwal.de", true },
  { "fahrenwalde.de", true },
  { "fairbill.com", true },
  { "faizan.net", true },
  { "faizan.xyz", true },
  { "fakturoid.cz", true },
  { "falconvintners.com", true },
  { "falkp.no", true },
  { "fallenangeldrinks.co.uk", true },
  { "fallenangeldrinks.com", true },
  { "fallenangeldrinks.eu", true },
  { "fallenangelspirits.co.uk", true },
  { "fallenangelspirits.com", true },
  { "fallenangelspirits.uk", true },
  { "fallenspirits.co.uk", true },
  { "familieholme.de", true },
  { "fandomservices.com", true },
  { "fangs.ink", true },
  { "faq.lookout.com", false },
  { "fasdoutreach.ca", true },
  { "faspirits.co.uk", true },
  { "faspirits.com", true },
  { "fassadenverkleidung24.de", true },
  { "fastaim.de", true },
  { "fastcomcorp.com", true },
  { "fastcomcorp.net", true },
  { "fastmail.com", false },
  { "fatherhood.gov", true },
  { "fatlossguide.xyz", true },
  { "faucetbox.com", true },
  { "fayolle.info", true },
  { "fbox.li", true },
  { "fca-tools.com", true },
  { "fdsys.gov", false },
  { "fearsomegaming.com", true },
  { "federalregister.gov", true },
  { "federicomigliavacca.it", true },
  { "fedorahosted.org", true },
  { "fedorapeople.org", true },
  { "fedrtc.org", true },
  { "feedbin.com", false },
  { "feedthebot.com", true },
  { "feen.us", true },
  { "feezmodo.com", true },
  { "felixrr.pro", true },
  { "feminists.co", true },
  { "ferienhaus-polchow-ruegen.de", false },
  { "fetch.co.uk", true },
  { "fewo-thueringer-wald.de", true },
  { "ff-bad-hoehenstadt.de", true },
  { "ffbans.org", true },
  { "fhcdn.xyz", true },
  { "fi.google.com", true },
  { "fi.search.yahoo.com", false },
  { "fidanza.eu", true },
  { "fidelapp.com", true },
  { "fiftyshadesofluca.ml", true },
  { "fightr.co", true },
  { "fiilr.com", true },
  { "fiken.no", true },
  { "file-pdf.it", true },
  { "filedir.com", false },
  { "filip-prochazka.com", true },
  { "filippo.io", true },
  { "filoo.de", true },
  { "finkelstein.fr", true },
  { "finn.io", true },
  { "firebaseio-demo.com", true },
  { "firebaseio.com", true },
  { "firebirdrangecookers.com", true },
  { "firefart.at", false },
  { "firemail.io", true },
  { "firevap.org", true },
  { "firma-offshore.com", true },
  { "firmapi.com", true },
  { "firstchoicecandy.com", true },
  { "firstlook.org", true },
  { "fish-hook.ru", true },
  { "fitkram.cz", true },
  { "fj.simple.com", false },
  { "flagspot.net", true },
  { "flajshans.cz", true },
  { "flamer-scene.com", false },
  { "flamewall.net", false },
  { "flamingcow.tv", true },
  { "flamingkeys.com", true },
  { "flat.io", true },
  { "flawlesscowboy.xyz", true },
  { "fleximus.org", false },
  { "flipagram.com", false },
  { "flirchi.com", false },
  { "floobits.com", true },
  { "floorball-haunwoehr.de", true },
  { "floort.net", true },
  { "florian-lillpopp.de", true },
  { "florian-schlachter.de", true },
  { "florianlillpopp.de", true },
  { "florianmitrea.uk", true },
  { "floridaescapes.co.uk", true },
  { "florismouwen.com", true },
  { "floskelwolke.de", true },
  { "flow.su", true },
  { "flowersandclouds.com", true },
  { "flowlo.me", true },
  { "flra.gov", true },
  { "flukethoughts.com", true },
  { "flushstudios.com", true },
  { "fluxent.de", true },
  { "fluxfingers.net", true },
  { "flynn.io", true },
  { "fmarchal.fr", true },
  { "fniephaus.com", true },
  { "focusmark.jp", true },
  { "food4health.guide", true },
  { "foodwise.marketing", true },
  { "footballmapped.com", true },
  { "foray-jero.me", true },
  { "fordbydesign.com", true },
  { "forewordreviews.com", true },
  { "forgix.com", true },
  { "formationsfactory.co.uk", false },
  { "foro.io", false },
  { "forodeespanol.com", true },
  { "fortress.sk", true },
  { "forum.linode.com", false },
  { "forum.quantifiedself.com", false },
  { "fotofaerie.net", true },
  { "fotostudio-schweiz.ch", true },
  { "foxdev.io", false },
  { "foxelbox.com", true },
  { "fr.search.yahoo.com", false },
  { "fr33d0m.link", true },
  { "fralef.me", false },
  { "frankierprofi.de", true },
  { "franzt.ovh", true },
  { "fraye.net", true },
  { "frederik-braun.com", true },
  { "fredvoyage.fr", true },
  { "free.com.tw", true },
  { "freedom.press", false },
  { "freelance.boutique", true },
  { "freenetproject.org", true },
  { "freeshell.de", true },
  { "freesounding.com", true },
  { "freesounding.ru", true },
  { "freethought.org.au", true },
  { "freeutopia.org", true },
  { "freeweibo.com", true },
  { "freifunk-essen.de", true },
  { "freifunk-luenen.de", true },
  { "freiwurst.net", true },
  { "fresh-hotel.org", true },
  { "fretscha.com", true },
  { "friendica.ch", true },
  { "frillip.com", true },
  { "froggstack.de", true },
  { "fronteers.nl", true },
  { "frtr.gov", true },
  { "fruchthof24.de", true },
  { "fruitusers.com", true },
  { "frusky.de", true },
  { "fsapubs.gov", true },
  { "fsfi.is", true },
  { "ftccomplaintassistant.gov", true },
  { "fteproxy.org", true },
  { "fuglede.dk", true },
  { "fukushima-web.com", true },
  { "fundingempire.com", true },
  { "furkancaliskan.com", true },
  { "furry.dk", true },
  { "futos.de", true },
  { "fuzzing-project.org", true },
  { "fx5.de", true },
  { "fzn.io", true },
  { "g-m-w.eu", true },
  { "g4w.co", true },
  { "gallery44.org", true },
  { "gambit.pro", true },
  { "gambitnash.co.uk", true },
  { "gambitnash.com", true },
  { "gambitprint.com", true },
  { "gamenected.com", true },
  { "gamenected.de", true },
  { "gamercredo.com", true },
  { "gamercredo.net", true },
  { "gamers-life.fr", true },
  { "gameserver-sponsor.de", true },
  { "gamingzoneservers.com", true },
  { "garbage-juice.com", true },
  { "garron.net", true },
  { "gautvedt.no", true },
  { "gavick.com", true },
  { "gaytorrent.ru", true },
  { "gc-mc.de", true },
  { "gc.net", true },
  { "gcs-ventures.com", true },
  { "ge3k.net", true },
  { "geblitzt.de", true },
  { "geek-hub.de", true },
  { "geeky.software", true },
  { "gehaowu.com", true },
  { "gemeinfreie-lieder.de", true },
  { "genshiken-itb.org", true },
  { "genshiken.org", true },
  { "genslerwisp.com", true },
  { "genuxation.com", true },
  { "genuxtsg.com", true },
  { "genxbeats.com", true },
  { "genxnotes.com", true },
  { "genyaa.com", true },
  { "geoip.fedoraproject.org", true },
  { "geoip.stg.fedoraproject.org", true },
  { "gerardozamudio.mx", true },
  { "gerencianet.com.br", false },
  { "gernert-server.de", true },
  { "geschwinder.net", true },
  { "get.zenpayroll.com", false },
  { "getbox.me", true },
  { "getbutterfly.com", true },
  { "getcloak.com", false },
  { "getcolor.com", true },
  { "getdash.io", true },
  { "getdigitized.net", true },
  { "getfedora.org", true },
  { "getfittedstore.com", true },
  { "getmango.com", true },
  { "getnikola.com", true },
  { "getsello.com", true },
  { "getspire.com", true },
  { "getsport.mobi", true },
  { "getvdownloader.com", true },
  { "gfournier.ca", true },
  { "ggp2.com", true },
  { "gha.st", true },
  { "gheorghesarcov.ga", true },
  { "ghostblog.info", true },
  { "giacomopelagatti.it", true },
  { "giftservices.nl", true },
  { "gigacloud.org", true },
  { "gintenreiter-photography.com", true },
  { "gipsamsfashion.com", true },
  { "github.com", true },
  { "github.party", false },
  { "giveattheoffice.org", true },
  { "givingnexus.org", true },
  { "gizzo.sk", true },
  { "glasgestaltung.biz", true },
  { "glass.google.com", true },
  { "glidingshop.cz", true },
  { "globalcomix.com", true },
  { "globalexpert.co.nz", true },
  { "globalinstitutefortraining.org.au", true },
  { "globalittech.com", false },
  { "globalperspectivescanada.com", true },
  { "globuli-info.de", true },
  { "glossopnorthendafc.co.uk", true },
  { "gm-assicurazioni.it", true },
  { "gmail.com", false },
  { "gmcd.co", true },
  { "gmdu.net", true },
  { "gmta.nl", true },
  { "gmw-ingenieurbuero.de", true },
  { "gnetwork.eu", true },
  { "go-zh.org", true },
  { "go.xero.com", false },
  { "goabonga.com", true },
  { "goaltree.ch", true },
  { "goat.xyz", true },
  { "gocardless.com", true },
  { "goggs.eu", true },
  { "gokmenguresci.com", true },
  { "goldendata.io", true },
  { "goldenhillsoftware.com", true },
  { "google", true },
  { "googlemail.com", false },
  { "googleplex.com", true },
  { "gopay.cz", true },
  { "goshop.cz", true },
  { "gosuland.org", true },
  { "gotech.com.eg", true },
  { "gothamlimo.com", true },
  { "goto.google.com", true },
  { "gotocloud.ru", true },
  { "gotspot.com", true },
  { "govtrack.us", true },
  { "gowe.wang", true },
  { "gpfclan.de", true },
  { "gplintegratedit.com", true },
  { "gpo.gov", false },
  { "gpsfix.cz", true },
  { "gpsvideocanada.com", true },
  { "gr.search.yahoo.com", false },
  { "gra2.com", true },
  { "grace-wan.com", true },
  { "gracedays.org", true },
  { "gracesofgrief.com", true },
  { "grafitec.ru", true },
  { "graingert.co.uk", true },
  { "grandcapital.id", true },
  { "grandcapital.ru", true },
  { "grandlinecsk.ru", true },
  { "grandmasfridge.org", true },
  { "grannyshouse.de", true },
  { "grantedby.me", true },
  { "granth.io", true },
  { "granular.ag", true },
  { "graph.no", true },
  { "graphire.io", true },
  { "gravity-net.de", true },
  { "graymalk.in", true },
  { "grazetech.com", true },
  { "grc.com", false },
  { "grcnode.co.uk", true },
  { "greatfire.org", true },
  { "greenpeace-magazin.de", true },
  { "greenroach.ru", true },
  { "greensolid.biz", true },
  { "greenteamtwente.nl", true },
  { "gregmilton.com", true },
  { "gregmilton.org", true },
  { "gregorytlee.me", true },
  { "grepular.com", true },
  { "grh.am", true },
  { "grigalanzsoftware.com", true },
  { "grimm-gastrobedarf.de", true },
  { "grocock.me.uk", true },
  { "groetzner.net", true },
  { "grossmann.gr", true },
  { "groszek.pl", true },
  { "groups.google.com", true },
  { "grsecurity.net", true },
  { "gs-net.at", true },
  { "gsm-map.com", true },
  { "gtanda.tk", true },
  { "gtmasterclub.it", false },
  { "gtmetrix.com", true },
  { "gtraxapp.com", true },
  { "gudini.net", true },
  { "gugga.dk", false },
  { "guguke.net", true },
  { "guidetoiceland.is", false },
  { "guilde-vindicta.fr", true },
  { "guineapigmustach.es", true },
  { "guphi.net", true },
  { "gurochan.ch", true },
  { "gurom.lv", true },
  { "guru-naradi.cz", true },
  { "gurusupe.com", true },
  { "guthabenkarten-billiger.de", true },
  { "gvt2.com", true },
  { "gvt3.com", true },
  { "gw2treasures.com", true },
  { "gyboche.com", true },
  { "gyboche.science", true },
  { "h2check.org", true },
  { "habarisoft.com", true },
  { "hablemosdetecnologia.com.ve", true },
  { "hachre.de", false },
  { "hack.cz", true },
  { "hack.li", true },
  { "hackcraft.net", true },
  { "hackenturet.dk", true },
  { "hacker.one", true },
  { "hackerone-user-content.com", true },
  { "hackerone.com", true },
  { "hackthissite.org", true },
  { "hafniatimes.com", true },
  { "haircrazy.com", true },
  { "hakase.kr", true },
  { "hana.ondemand.com", true },
  { "handmadetutorials.ro", true },
  { "hangouts.google.com", true },
  { "hannover-banditen.de", true },
  { "hansvaneijsden.com", true },
  { "haozi.me", true },
  { "happygadget.me", true },
  { "happylifestyle.com", true },
  { "happyteamlabs.com", true },
  { "harbor-light.net", true },
  { "hardfalcon.net", true },
  { "hardh.at", true },
  { "harmoney.com", true },
  { "harringtonca.com", true },
  { "harristony.com", true },
  { "harvestapp.com", true },
  { "harvester.fr", false },
  { "haselsteiner.me", true },
  { "hash-list.com", true },
  { "hashiconf.com", true },
  { "hashicorp.com", true },
  { "hashplex.com", true },
  { "haste.ch", true },
  { "hastherebeenamassshooting.today", true },
  { "hatoko.net", true },
  { "haucke.xyz", true },
  { "haufschild.de", true },
  { "hausverbrauch.de", true },
  { "haveeruexaminer.com", true },
  { "haveibeenpwned.com", true },
  { "havelland-obstler.de", true },
  { "hawkeyeinsight.com", true },
  { "hboeck.de", true },
  { "hd-offensive.at", true },
  { "hda.me", true },
  { "hdc.cz", true },
  { "hdm.io", true },
  { "hds-lan.de", true },
  { "hduin.xyz", true },
  { "healthcare.gov", false },
  { "healtheffectsofasbestos.com", true },
  { "healthiercompany.com", true },
  { "heartlandrentals.com", true },
  { "heartsucker.com", true },
  { "heavystresser.com", true },
  { "heh.ee", true },
  { "heha.co", false },
  { "heid.ws", true },
  { "heijblok.com", true },
  { "hejsupport.se", true },
  { "helgakristoffer.com", true },
  { "helgakristoffer.wedding", true },
  { "helichat.de", true },
  { "helix.am", true },
  { "helloacm.com", true },
  { "helloanselm.com", true },
  { "help.simpletax.ca", false },
  { "helpadmin.net", true },
  { "helpconnect.com.au", true },
  { "helpium.de", true },
  { "hemlockhillscabinrentals.com", true },
  { "hencagon.com", true },
  { "henriknoerr.com", true },
  { "henriksen.is", true },
  { "henrock.net", true },
  { "heppler.net", true },
  { "herbert.io", true },
  { "herocentral.de", true },
  { "herpaderp.net", true },
  { "hetmer.com", true },
  { "heute-kaufen.de", true },
  { "heutger.net", true },
  { "hex2013.com", true },
  { "hexo.io", true },
  { "heyguevara.com", true },
  { "hg.python.org", true },
  { "hicn.gq", true },
  { "hicoria.com", true },
  { "hiddenmail.xyz", true },
  { "hilahdih.cz", true },
  { "hiphop.ren", true },
  { "hisbrucker.net", true },
  { "history.google.com", false },
  { "hiv.gov", true },
  { "hk.search.yahoo.com", false },
  { "hlavacek.us", true },
  { "hledejpravnika.cz", true },
  { "hmm.nyc", true },
  { "hobby-gamerz-community.de", true },
  { "hobbyspeed.com", true },
  { "hochhaus.us", true },
  { "hohm.in", true },
  { "holifestival-freyung.de", true },
  { "holisticon.de", true },
  { "hollowrap.com", true },
  { "holymoly.lu", true },
  { "homads.com", false },
  { "homecareassociatespa.com", true },
  { "hompus.nl", true },
  { "honeybadger.io", false },
  { "hoodoo.io", true },
  { "hoodoo.tech", true },
  { "hopewellproperties.co.uk", true },
  { "horza.org", true },
  { "hoshinplan.com", false },
  { "hoshisato.com", true },
  { "hostanalyticsconsulting.com", true },
  { "hostedtalkgadget.google.com", true },
  { "hostgarou.com", true },
  { "hostinghelp.guru", true },
  { "hostinginnederland.nl", true },
  { "hostix.de", true },
  { "hotchillibox.co.za", true },
  { "hotchillibox.com", true },
  { "hoton.in", true },
  { "howrandom.org", true },
  { "howsmyssl.com", true },
  { "howsmytls.com", true },
  { "hozana.si", true },
  { "hpac-portal.com", true },
  { "hpkp-faq.de", true },
  { "hrackydomino.cz", true },
  { "hranicka.cz", true },
  { "hrbatypes.cz", true },
  { "hroschyk.cz", true },
  { "hs-group.net", true },
  { "hsmr.cc", true },
  { "hsr.gov", true },
  { "hsts.date", true },
  { "hstsfail.appspot.com", true },
  { "htaccessbook.com", true },
  { "html5.org", true },
  { "httpswatch.com", true },
  { "huaxueba.com", true },
  { "huffduffer.com", true },
  { "humankode.com", true },
  { "humblefinances.com", true },
  { "hund.io", true },
  { "hurricanelabs.com", true },
  { "hushfile.it", true },
  { "hymerscollege.co.uk", true },
  { "hyper-text.org", true },
  { "i10z.com", true },
  { "i5y.co.uk", true },
  { "i95.me", true },
  { "iainsimms.me", true },
  { "iamcarrico.com", true },
  { "iamokay.nl", true },
  { "ian.sh", true },
  { "iban.is", true },
  { "ichronos.net", true },
  { "icq-project.net", true },
  { "id-co.in", true },
  { "id.atlassian.com", true },
  { "id.fedoraproject.org", false },
  { "id.mayfirst.org", false },
  { "id.search.yahoo.com", false },
  { "idaspis.com", true },
  { "ideadozz.hu", true },
  { "ideation-inc.co.jp", true },
  { "ideaweb.de", true },
  { "idndx.com", true },
  { "idvl.de", true },
  { "iec.pe", true },
  { "ieval.ro", true },
  { "ifcfg.me", true },
  { "ifleurs.com", true },
  { "ifoss.me", true },
  { "iggprivate.com", true },
  { "iggsoft.com", true },
  { "iggsoftware.com", true },
  { "ihrlotto.de", true },
  { "ihsbsd.me", true },
  { "iispeed.com", true },
  { "ijohan.nl", true },
  { "ijsclubtilburg.nl", true },
  { "ikk.me", true },
  { "ikkatsu-satei.jp", true },
  { "ikvts.de", true },
  { "ilbuongiorno.it", true },
  { "ilhadocaranguejo.com.br", true },
  { "ilikerainbows.co", true },
  { "ilikerainbows.co.uk", false },
  { "illorenese.fr", true },
  { "im-c-shop.com", true },
  { "imagescostumes.com", true },
  { "imaginary.ca", true },
  { "imagr.io", true },
  { "imbrian.org", true },
  { "imgg.es", true },
  { "imirhil.fr", true },
  { "imlonghao.com", true },
  { "immoverkauf24.at", true },
  { "immoverkauf24.de", true },
  { "immunicity.info", true },
  { "imoni-blog.net", true },
  { "impex.com.bd", true },
  { "imququ.com", true },
  { "imreh.net", true },
  { "imrejonk.nl", true },
  { "in.search.yahoo.com", false },
  { "in.xero.com", false },
  { "inb4.us", true },
  { "inbitcoin.it", true },
  { "inbounder.io", true },
  { "inbox.google.com", true },
  { "inboxen.org", true },
  { "incparadise.net", true },
  { "indiecert.net", true },
  { "indovinabank.com.vn", true },
  { "indust.me", false },
  { "indybay.org", true },
  { "infilock.com", true },
  { "infinitusgaming.eu", true },
  { "influxus.com", false },
  { "infocommsociety.com", false },
  { "informnapalm.org", true },
  { "iniiter.com", true },
  { "initq.net", true },
  { "initrd.net", true },
  { "inkbunny.net", true },
  { "inksay.com", true },
  { "inleaked.com", true },
  { "innophate-security.com", true },
  { "innophate-security.nl", true },
  { "insideaudit.com", true },
  { "insouciant.org", true },
  { "inspiroinc.com", true },
  { "instant-hack.com", true },
  { "instant.io", true },
  { "instasex.ch", true },
  { "instela.com", true },
  { "institutoflordelavida.com", true },
  { "institutolancaster.com", true },
  { "intarweb.ca", true },
  { "integrationinc.com", false },
  { "integromat.com", true },
  { "interaffairs.com", true },
  { "interasistmen.se", true },
  { "interfug.de", true },
  { "interisaudit.com", true },
  { "internetbank.swedbank.se", true },
  { "internetbugbounty.org", true },
  { "internethering.de", true },
  { "interviewpipeline.co.uk", true },
  { "intim-uslugi-kazan.net", true },
  { "intxt.net", true },
  { "inusasha.de", true },
  { "invictusmc.uk", true },
  { "involved-it.be", true },
  { "inwesttitle.com", true },
  { "iocheck.com", false },
  { "ionas-law.ro", false },
  { "ionlabs.kr", true },
  { "ipcfg.me", true },
  { "ipledgeonline.org", true },
  { "ipomue.com", false },
  { "ipsec.pl", true },
  { "ipswitch.com.tw", true },
  { "ipv6-adresse.dk", true },
  { "ipv6-handbuch.de", true },
  { "ipv6cloud.club", true },
  { "iqboxy.com", true },
  { "iqualtech.com", true },
  { "iranianlawschool.com", true },
  { "iready.ro", true },
  { "iridiumbrowser.de", true },
  { "irische-segenswuensche.info", true },
  { "irmag.ru", true },
  { "ironfistdesign.com", true },
  { "isaacman.tech", true },
  { "iseulde.com", true },
  { "isimonbrown.co.uk", true },
  { "isitamor.pm", true },
  { "isitchristmas.com", true },
  { "isitup.org", true },
  { "isondo.com", true },
  { "isopres.de", true },
  { "istanbul.systems", true },
  { "istheapplestoredown.com", true },
  { "istorrent.is", true },
  { "it-schwerin.de", true },
  { "it.search.yahoo.com", false },
  { "itdashboard.gov", true },
  { "itfh.eu", true },
  { "itinsight.hu", true },
  { "itpol.dk", true },
  { "itriskltd.com", true },
  { "itsagadget.com", true },
  { "itsamurai.ru", true },
  { "itsg-faq.de", true },
  { "itshost.ru", true },
  { "ivancacic.com", true },
  { "ivk.website", true },
  { "ix8.ru", true },
  { "izdiwho.com", true },
  { "j-lsolutions.com", true },
  { "j-navi.com", true },
  { "j0s.eu", true },
  { "j3e.de", true },
  { "jaba.hosting", true },
  { "jacekowski.org", true },
  { "jackfahnestock.com", true },
  { "jackyyf.com", false },
  { "jacobhaug.com", true },
  { "jacobparry.ca", false },
  { "jacobphono.com", true },
  { "jacuzziprozone.com", true },
  { "jagerman.com", true },
  { "jahliveradio.com", false },
  { "jakenbake.com", true },
  { "jakub-boucek.cz", true },
  { "jakubboucek.cz", true },
  { "jamesbywater.co.uk", true },
  { "jamesbywater.com", true },
  { "jamesbywater.me", true },
  { "jamesbywater.me.uk", true },
  { "jamesbywater.uk", true },
  { "jamesconroyfinn.com", true },
  { "jameshost.net", true },
  { "jamesmaurer.com", true },
  { "jamesrains.com", true },
  { "jamielinux.com", true },
  { "jamiemagee.co.uk", true },
  { "jamonsilva.com", true },
  { "janoberst.com", true },
  { "jaroslavtrsek.cz", true },
  { "jav-collective.com", true },
  { "jayharris.ca", true },
  { "jbn.mx", true },
  { "jcraft.us", true },
  { "jean-remy.ch", true },
  { "jeff393.com", true },
  { "jelmer.co.uk", true },
  { "jelmer.uk", true },
  { "jennedebleser.com", false },
  { "jennythebaker.com", true },
  { "jeremyness.com", true },
  { "jetmirshatri.com", true },
  { "jettshome.org", false },
  { "jfreitag.de", true },
  { "jgid.de", true },
  { "jh-media.eu", false },
  { "jhalderm.com", true },
  { "jhburton.uk", true },
  { "jikken.de", true },
  { "jimshaver.net", true },
  { "jinbo123.com", false },
  { "jira.com", true },
  { "jirav.io", true },
  { "jitsi.org", false },
  { "jkb.pics", true },
  { "jkbuster.com", true },
  { "jlkhosting.com", true },
  { "jmdekker.it", true },
  { "jmedved.com", true },
  { "jn1.me", true },
  { "jobbkk.com", true },
  { "jobss.co.uk", true },
  { "joelj.org", true },
  { "jogorama.com.br", true },
  { "johannes.io", true },
  { "johners.me", true },
  { "johngallias.com", true },
  { "johnguant.com", true },
  { "johnmichel.org", true },
  { "jonaskjodt.com", true },
  { "jonaswitmer.ch", true },
  { "jonathan-apps.com", true },
  { "jondevin.com", true },
  { "jonfor.net", true },
  { "jonlabelle.com", true },
  { "jonnybarnes.uk", true },
  { "jonpads.com", true },
  { "jordanhamilton.me", true },
  { "jorgemesa.me", true },
  { "josefjanosec.com", true },
  { "josephrees.uk", true },
  { "joshgrancell.com", true },
  { "joshi.su", true },
  { "joyofcookingandbaking.com", true },
  { "jpbike.cz", true },
  { "jrc9.ca", true },
  { "jrmd.io", true },
  { "julianmeyer.de", true },
  { "juliansimioni.com", true },
  { "junethack.net", true },
  { "juniwalk.cz", true },
  { "junqtion.com", false },
  { "jurriaan.ninja", true },
  { "justyy.com", true },
  { "jwilsson.com", true },
  { "jwilsson.me", true },
  { "jwnotifier.org", true },
  { "k-dev.de", true },
  { "kachlikova2.cz", true },
  { "kaheim.de", true },
  { "kahopoon.net", true },
  { "kakao-karten.de", true },
  { "kalevlamps.co.uk", true },
  { "kalmar.com", true },
  { "kaloix.de", true },
  { "kamisama.xyz", true },
  { "kaneo-gmbh.de", true },
  { "kanna.cf", true },
  { "kanotijd.nl", true },
  { "kantorosobisty.pl", true },
  { "kanzashi.com", true },
  { "kaplatz.is", true },
  { "karaoketonight.com", true },
  { "kardize24.pl", true },
  { "karmaspa.se", true },
  { "kartonmodellbau.org", true },
  { "kassa.at", true },
  { "katka.info", true },
  { "kau-boys.com", true },
  { "kau-boys.de", true },
  { "kaufberatung.community", true },
  { "kavovary-kava.cz", true },
  { "kawaii.io", true },
  { "kazandaemon.ru", true },
  { "kba-online.de", true },
  { "kbcequitas.hu", true },
  { "kbit.dk", true },
  { "kbjorklu.com", true },
  { "kcolford.com", true },
  { "kd-plus.pp.ua", true },
  { "kdex.de", true },
  { "kdyby.org", true },
  { "kedarastudios.com", true },
  { "keeleysam.com", true },
  { "keeleysam.me", true },
  { "keepa.com", true },
  { "keepclean.me", true },
  { "keeperapp.com", true },
  { "keepersecurity.com", true },
  { "keganthorrez.com", true },
  { "keke-shop.ch", true },
  { "kengilmour.com", true },
  { "kermadec.com", true },
  { "kernel-error.de", true },
  { "keskeces.com", true },
  { "kevincox.ca", true },
  { "keybase.io", true },
  { "keycdn.com", true },
  { "keyerror.com", true },
  { "khanovaskola.cz", true },
  { "khetzal.info", true },
  { "khipu.com", true },
  { "khmath.com", true },
  { "ki-on.net", true },
  { "kiano.net", true },
  { "kick-in.nl", true },
  { "kickass.al", true },
  { "kiebel.de", true },
  { "kikuzuki.org", true },
  { "kilobyte22.de", true },
  { "kimmel.com", false },
  { "kinderbasar-luhe.de", true },
  { "kinderbuecher-kostenlos.de", true },
  { "kindof.ninja", true },
  { "kingant.net", true },
  { "kinganywhere.eu", true },
  { "kingmanhall.org", true },
  { "kinogb.net", false },
  { "kinsights.com", false },
  { "kintone.com", true },
  { "kirei.se", true },
  { "kissflow.com", true },
  { "kitakemon.com", true },
  { "kitsostech.com", true },
  { "kitsta.com", true },
  { "kjarrval.is", true },
  { "klarmobil-empfehlen.de", true },
  { "klasfauseweh.de", true },
  { "klatschreime.de", true },
  { "klausbrinch.dk", false },
  { "klauwd.com", true },
  { "klaxn.com", true },
  { "kle.cz", true },
  { "kleidertauschpartys.de", true },
  { "kleppe.co", true },
  { "kleteckova.cz", true },
  { "kliemann.me", true },
  { "klif1.nl", true },
  { "klingeletest.de", true },
  { "knip.ch", true },
  { "knowledgehook.com", true },
  { "knygos.lt", true },
  { "kodokushi.fr", true },
  { "koen.io", true },
  { "koenrouwhorst.nl", true },
  { "koenvdheuvel.me", false },
  { "koerperimpuls.ch", true },
  { "kojipkgs.fedoraproject.org", true },
  { "kokenmetaanbiedingen.nl", true },
  { "kollawat.me", true },
  { "komandakovalchuk.com", false },
  { "komoju.com", true },
  { "konijntjes.nl", true },
  { "konklone.com", true },
  { "konsertoversikt.no", true },
  { "koop-bremen.de", true },
  { "korinar.com", true },
  { "korobi.io", true },
  { "korobkovsky.ru", true },
  { "kosho.org", true },
  { "kotonehoko.net", true },
  { "koukni.cz", true },
  { "kpdyer.com", true },
  { "kpebetka.net", true },
  { "kpinvest.eu", true },
  { "kradalby.no", true },
  { "kraft.im", true },
  { "kraken.io", true },
  { "kreativstrecke.de", true },
  { "kreavis.com", true },
  { "kredietpaspoort.nl", true },
  { "kredite.sale", true },
  { "kredite24.de", true },
  { "kreen.org", false },
  { "kristofferkoch.com", true },
  { "kropkait.pl", true },
  { "krypsys.com", true },
  { "krypteia.org", true },
  { "kschv-rdeck.de", true },
  { "kuppingercole.com", true },
  { "kupschke.net", true },
  { "kura.io", false },
  { "kurehun.org", true },
  { "kurtmclester.com", true },
  { "kybi.sk", true },
  { "kylinj.com", true },
  { "kynaston.org.uk", true },
  { "labaia.info", true },
  { "labrador-retrievers.com.au", true },
  { "labradorpuppiesforsalebyregisteredlabradorbreeders.com", true },
  { "labs.directory", true },
  { "lafkor.de", true },
  { "lagerauftrag.info", true },
  { "lagoza.name", true },
  { "lainchan.org", true },
  { "lambda-complex.org", true },
  { "lana.swedbank.se", true },
  { "lancejames.com", true },
  { "lapetition.be", true },
  { "larrysalibra.com", true },
  { "laserfuchs.de", true },
  { "lashstuff.com", true },
  { "lasst-uns-beten.de", true },
  { "lastpass.com", false },
  { "latenitefilms.com", false },
  { "lateralsecurity.com", true },
  { "latrine.cz", true },
  { "laukstein.com", true },
  { "launchkey.com", true },
  { "lavalite.de", true },
  { "lavval.com", true },
  { "lawformt.com", true },
  { "laylo.nl", true },
  { "lazurit.com", true },
  { "lb-toner.de", true },
  { "leadbook.ru", true },
  { "leakedminecraft.net", true },
  { "leanclub.org", true },
  { "ledhouse.sk", true },
  { "leerliga.de", true },
  { "legendofkrystal.com", true },
  { "legoutdesplantes.be", true },
  { "lehighmathcircle.org", true },
  { "leibniz-remscheid.de", true },
  { "leifdreizler.com", true },
  { "leinir.dk", true },
  { "lellyboi.ml", true },
  { "lemp.io", true },
  { "lence.net", true },
  { "leninalbertop.com.ve", true },
  { "lenzw.de", true },
  { "leob.in", true },
  { "leominstercu.com", false },
  { "leonardcamacho.me", true },
  { "leonax.net", true },
  { "leonklingele.de", true },
  { "lepont.pl", true },
  { "leppis-it.de", true },
  { "les-corsaires.net", true },
  { "levendwater.org", true },
  { "levert.ch", true },
  { "levinus.de", true },
  { "lewisjuggins.co.uk", true },
  { "lexway.pk", true },
  { "libertyrp.org", true },
  { "libfte.org", true },
  { "libraryfreedomproject.org", false },
  { "libreboot.org", true },
  { "librelamp.com", true },
  { "libsodium.org", true },
  { "liceserv.com", true },
  { "lichtspot.de", true },
  { "liebel.org", true },
  { "light.mail.ru", true },
  { "lighting-centres.co.uk", true },
  { "lightme.us", true },
  { "lillpopp.eu", true },
  { "lilpwny.com", true },
  { "limeyeti.com", true },
  { "limitededitioncomputers.com", true },
  { "limitededitionsolutions.com", true },
  { "limpid.nl", true },
  { "limpido.it", true },
  { "lingolia.com", true },
  { "linguatrip.com", false },
  { "linode.com", false },
  { "linorman1997.me", true },
  { "linux-admin-california.com", true },
  { "linux.cn", true },
  { "linux.fi", true },
  { "linuxbierwanderung.com", true },
  { "linuxcommand.ru", true },
  { "linuxgeek.ro", true },
  { "linuxlounge.net", true },
  { "linx.li", true },
  { "linx.net", true },
  { "liquid.cz", true },
  { "liquorsanthe.in", true },
  { "listafirmelor.com", true },
  { "lists.fedoraproject.org", true },
  { "lists.mayfirst.org", false },
  { "lists.stg.fedoraproject.org", true },
  { "litespeed.io", true },
  { "litvideoserver.de", true },
  { "liud.im", true },
  { "livedemo.io", true },
  { "livej.am", true },
  { "livekaarten.nl", true },
  { "liverewrite.com", true },
  { "ljs.io", true },
  { "lloyd-day.me", true },
  { "lmddgtfy.net", true },
  { "lmintlcx.com", true },
  { "lmmtfy.io", true },
  { "lmsptfy.com", true },
  { "lnx.li", true },
  { "loacg.com", true },
  { "loancompare.co.za", true },
  { "lobste.rs", true },
  { "lockify.com", true },
  { "locktheirphone.com", true },
  { "locomore.com", true },
  { "lodash.com", true },
  { "loenshotel.de", true },
  { "logement-saisonnier.com", true },
  { "logentries.com", false },
  { "logfile.at", true },
  { "login.corp.google.com", true },
  { "login.launchpad.net", true },
  { "login.persona.org", true },
  { "login.sapo.pt", true },
  { "login.ubuntu.com", true },
  { "login.xero.com", false },
  { "login.yahoo.com", false },
  { "lognot.net", true },
  { "logopaediereinhard.de", true },
  { "lolicore.ch", true },
  { "lookout.com", false },
  { "lookyman.net", true },
  { "lookzook.com", true },
  { "lore.azurewebsites.net", true },
  { "lostinsecurity.com", true },
  { "lothai.re", true },
  { "lovingearth.net", true },
  { "ltn-tom-morel.fr", true },
  { "ludwig.im", true },
  { "luehne.de", true },
  { "luelistan.net", true },
  { "lugbb.org", true },
  { "lukasberan.cz", true },
  { "lukasunger.cz", true },
  { "lukasunger.net", true },
  { "lukasztkacz.com", true },
  { "lumi.do", false },
  { "lunakit.org", true },
  { "luneta.nearbuysystems.com", false },
  { "luom.net", true },
  { "lusis.fr", true },
  { "lusis.net", true },
  { "lustrumxi.nl", true },
  { "luxwatch.com", true },
  { "lymia.moe", true },
  { "lyst.co.uk", true },
  { "lyx.dk", true },
  { "m.facebook.com", false },
  { "m.mail.ru", true },
  { "m0wef.uk", true },
  { "maarten.nyc", true },
  { "maartenvandekamp.nl", true },
  { "mac-torrents.me", true },
  { "macgeneral.de", true },
  { "mach-politik.ch", true },
  { "machbach.com", true },
  { "macker.io", true },
  { "maclemon.at", true },
  { "macleod.io", true },
  { "maco.org.uk", true },
  { "madars.org", true },
  { "madeitwor.se", true },
  { "maderwin.com", true },
  { "madrants.net", true },
  { "mafamane.com", true },
  { "maff.scot", false },
  { "magneticanvil.com", true },
  { "mahamed91.pw", true },
  { "mail-settings.google.com", true },
  { "mail.de", true },
  { "mail.google.com", true },
  { "mail.yahoo.com", false },
  { "mailbox.org", true },
  { "mailer-dot.de", true },
  { "mailgarant.nl", true },
  { "mailinabox.email", true },
  { "mailmag.net", true },
  { "make-pizza.info", true },
  { "makeitdynamic.com", true },
  { "makeyourlaws.org", true },
  { "makowitz.cz", true },
  { "maktoob.search.yahoo.com", false },
  { "malash.me", true },
  { "malaysia.search.yahoo.com", false },
  { "malinator.net", true },
  { "mall.cz", true },
  { "mall.hu", true },
  { "mall.pl", true },
  { "mall.sk", true },
  { "malnex.de", true },
  { "malwre.io", true },
  { "mamaison.io", true },
  { "mammaw.com", true },
  { "mammothmail.com", true },
  { "mammothmail.net", true },
  { "mammothmail.org", true },
  { "man3s.jp", true },
  { "manage.cm", true },
  { "manage.zenpayroll.com", false },
  { "management-companie.ro", true },
  { "manageprojects.com", true },
  { "manager.linode.com", false },
  { "mandala-ausmalbilder.de", true },
  { "manfredimatteo.com", true },
  { "manicode.com", true },
  { "manoirdecontres.com", true },
  { "mantor.org", false },
  { "maowtm.org", true },
  { "marcoececilia.it", true },
  { "marcoslater.com", true },
  { "mareklecian.cz", true },
  { "marie-curie.fr", true },
  { "marie.club", true },
  { "mark-semmler.de", true },
  { "markayapilandirma.com", true },
  { "market.android.com", true },
  { "markhaehnel.de", true },
  { "markprof.ru", true },
  { "marktboten.de", true },
  { "marktcontact.com", true },
  { "markusehrlicher.de", true },
  { "markusueberallassetmanagement.de", true },
  { "markusweimar.de", true },
  { "marlen.cz", true },
  { "marshut.net", true },
  { "martijnvhoof.nl", true },
  { "martinp.no", true },
  { "marumagic.com", true },
  { "masa-yoga.com", true },
  { "masjidtawheed.net", true },
  { "massivum.de", false },
  { "masters.black", true },
  { "matatall.com", false },
  { "maternalsafety.org", true },
  { "mathhire.org", true },
  { "mathiasbynens.be", true },
  { "mathiasgarbe.de", true },
  { "matrip.de", true },
  { "matspar.se", true },
  { "mattberryman.com", true },
  { "matteomarescotti.it", true },
  { "mattfin.ch", true },
  { "mattmccutchen.net", true },
  { "mattsvensson.com", true },
  { "mattwb65.com", true },
  { "mavenclinic.com", true },
  { "mavensecurity.com", true },
  { "maveris.com", true },
  { "max-moeglich.de", true },
  { "max.gov", true },
  { "maximeferon.fr", true },
  { "maximelouet.me", true },
  { "maximilian-greger.com", true },
  { "maxwell-english.co.jp", false },
  { "mazz-tech.com", true },
  { "mbasic.facebook.com", false },
  { "mblankhorst.nl", true },
  { "mbp.banking.co.at", false },
  { "mbweir.com", true },
  { "mc-venture.net", false },
  { "mca2017.org", true },
  { "mcard.vn", true },
  { "mcgarderen.nl", true },
  { "mchristopher.com", true },
  { "mclab.su", false },
  { "mcnext.net", true },
  { "mcpart.land", true },
  { "mcrn.jp", true },
  { "mctherealm.net", true },
  { "md5file.com", true },
  { "mdek.at", true },
  { "me.net.nz", true },
  { "meamod.com", true },
  { "medallia.io", true },
  { "meddelare.com", true },
  { "medexpress.co.uk", true },
  { "media-courses.com", true },
  { "mediawiki.org", true },
  { "medirich.co", true },
  { "meditek-dv.ru", true },
  { "medium.com", true },
  { "medo64.com", true },
  { "medovea.ru", true },
  { "medtehnika.ua", true },
  { "meetfinch.com", true },
  { "meetingmanage.nl", true },
  { "meetscompany.jp", true },
  { "mega.co.nz", true },
  { "mega.nz", true },
  { "megaplan.ru", true },
  { "megasslstore.com", true },
  { "mehmetince.net", true },
  { "meinebo.it", true },
  { "meizufans.eu", true },
  { "melcher.it", true },
  { "melf.nl", true },
  { "melitopol.co.ua", true },
  { "melted.pw", true },
  { "members.nearlyfreespeech.net", false },
  { "memo-linux.com", true },
  { "meozcraft.com", false },
  { "mercamaris.es", true },
  { "mercuryamericas.com", true },
  { "mercurystorm.co.za", true },
  { "meritz.rocks", true },
  { "mertcangokgoz.com", true },
  { "mesvt.com", true },
  { "meta-db.com", true },
  { "meta.sc", true },
  { "metebalci.com", true },
  { "meteosky.net", true },
  { "metrobriefs.com", true },
  { "mevs.cz", true },
  { "mexicansbook.ru", false },
  { "mfcatalin.com", true },
  { "mfiles.pl", true },
  { "mh-bloemen.co.jp", true },
  { "mhx.pw", true },
  { "miasarafina.de", true },
  { "michaelcullen.name", true },
  { "michaelleibundgut.com", true },
  { "michal-kral.cz", true },
  { "michalborka.cz", true },
  { "michalspacek.cz", true },
  { "miconcinemas.com", true },
  { "micro-dv.ru", true },
  { "micro-rain-systems.com", true },
  { "microme.ga", true },
  { "midonet.org", true },
  { "mig5.net", true },
  { "mijailovic.net", true },
  { "mijn-email.org", true },
  { "mijnkredietpaspoort.nl", true },
  { "mikaela.info", true },
  { "mike-bland.com", true },
  { "miketabor.com", true },
  { "mikewest.org", true },
  { "milahendri.com", false },
  { "milanpala.cz", true },
  { "millistream.com", true },
  { "mim.properties", true },
  { "mimeit.de", true },
  { "mimovrste.com", true },
  { "mind-moves.es", true },
  { "mindcoding.ro", true },
  { "minecraft-forum.cf", true },
  { "minecraft-forum.ga", true },
  { "minecraft-forum.gq", true },
  { "minecraft-forum.ml", true },
  { "minecraft-forums.cf", true },
  { "minecraft-forums.ga", true },
  { "minecraft-forums.gq", true },
  { "minecraftforum.de", true },
  { "minecraftforum.ovh", true },
  { "minecraftforums.cf", true },
  { "minecraftforums.gq", true },
  { "minecraftforums.ml", true },
  { "minecraftvoter.com", true },
  { "mineover.es", true },
  { "minez-nightswatch.com", false },
  { "minikneet.com", true },
  { "minkondom.nu", true },
  { "minnesotadata.com", true },
  { "minora.io", true },
  { "minpingvin.dk", true },
  { "mintrak2.com", true },
  { "mironet.cz", true },
  { "mirtes.cz", true },
  { "miskatonic.org", true },
  { "miss-inventory.co.uk", true },
  { "missdream.org", true },
  { "misskey.xyz", true },
  { "mistacms.com", true },
  { "mister.hosting", true },
  { "misterl.net", true },
  { "mitchellrenouf.ca", true },
  { "mitell.jp", false },
  { "mittelunsachlich.de", true },
  { "mittenhacks.com", true },
  { "mizd.at", true },
  { "mjanja.ch", true },
  { "mkcert.org", true },
  { "mkw.st", true },
  { "mlpepilepsy.org", true },
  { "mnd.sc", true },
  { "mnetworkingsolutions.co.uk", true },
  { "mnium.de", true },
  { "mnsure.org", true },
  { "mobilcom-debitel-empfehlen.de", true },
  { "mobile.eti.br", true },
  { "mobile.usaa.com", false },
  { "mobilemedics.com", true },
  { "mobiletraff.co", true },
  { "mobilux.lv", true },
  { "mobobe.com", true },
  { "mobocasino.com", false },
  { "mocloud.eu", true },
  { "modeldimension.com", true },
  { "modmountain.com", true },
  { "mojapraca.sk", true },
  { "mokote.com", true },
  { "moneromerchant.com", true },
  { "moniquedekermadec.com", true },
  { "monitman.solutions", true },
  { "monitzer.com", true },
  { "monnyonle.hu", true },
  { "moparcraft.com", true },
  { "moparcraft.net", true },
  { "moparcraft.org", true },
  { "moparisthebest.biz", true },
  { "moparisthebest.com", true },
  { "moparisthebest.info", true },
  { "moparisthebest.net", true },
  { "moparisthebest.org", true },
  { "moparscape.org", true },
  { "moreapp.co.uk", true },
  { "morethanadream.lv", true },
  { "moriz.de", true },
  { "mortgagecentersmo.com", true },
  { "mosstier.com", true },
  { "motd.ch", true },
  { "mothereff.in", true },
  { "motionpicturesolutions.com", true },
  { "motocyklovedily.cz", true },
  { "moula.com.au", false },
  { "mountainmusicpromotions.com", true },
  { "mountainroseherbs.com", true },
  { "movlib.org", true },
  { "mp3gratuiti.com", true },
  { "mp3juices.is", true },
  { "mpc-hc.org", true },
  { "mpintaamalabanna.it", true },
  { "mpreserver.com", true },
  { "mqas.net", true },
  { "mr-hosting.com", true },
  { "mrs-shop.com", true },
  { "msa-aesch.ch", true },
  { "msebera.cz", true },
  { "mt.me.uk", true },
  { "mtasa.com", true },
  { "mtau.com", true },
  { "mthode.org", true },
  { "mths.be", true },
  { "mtouch.facebook.com", false },
  { "muabannhanh.com", true },
  { "mudcrab.us", true },
  { "muguayuan.com", true },
  { "mujadin.se", false },
  { "multigamecard.com", true },
  { "multigeist.de", true },
  { "multitheftauto.com", true },
  { "munich-rage.de", true },
  { "munki.org", true },
  { "munuc.org", true },
  { "murraycoin.org", true },
  { "muscleangels.com", true },
  { "mushikabu.net", true },
  { "musi.cx", true },
  { "musicgamegalaxy.de", true },
  { "musicwear.cz", true },
  { "musikkfondene.no", true },
  { "musmann.io", true },
  { "musthavesforreal.com", true },
  { "mutamatic.com", true },
  { "mutantmonkey.in", true },
  { "mutantmonkey.info", true },
  { "mutantmonkey.sexy", true },
  { "mvno.io", true },
  { "mvsecurity.nl", true },
  { "mwe.st", true },
  { "mx.search.yahoo.com", false },
  { "my-pawnshop.com.ua", true },
  { "my.onlime.ch", false },
  { "my.swedbank.se", true },
  { "my.usa.gov", false },
  { "my.xero.com", false },
  { "myaccount.google.com", true },
  { "mybudget.xyz", true },
  { "mycieokien.info", true },
  { "mydeos.com", false },
  { "myg21.com", true },
  { "mygadgetguardian.lookout.com", false },
  { "mygov.scot", false },
  { "mygreatjobs.de", true },
  { "mygretchen.de", true },
  { "myhostname.net", true },
  { "myiocc.org", true },
  { "mykontool.de", true },
  { "mylookout.com", false },
  { "myni.io", true },
  { "mynigma.org", true },
  { "myonline.hu", true },
  { "mypagella.com", true },
  { "mypagella.eu", true },
  { "mypagella.it", true },
  { "myplaceonline.com", true },
  { "myprintcard.de", true },
  { "myraytech.net", false },
  { "mysecretcase.com", true },
  { "mysecretrewards.com", true },
  { "myvirtualserver.com", true },
  { "myvpl.com", true },
  { "myzina.cz", false },
  { "n-pix.com", false },
  { "n2x.in", false },
  { "nabytko.cz", true },
  { "nachsendeauftrag.net", true },
  { "nachsenden.info", true },
  { "nagb.gov", true },
  { "nagb.org", true },
  { "nagoya-kyuyo.com", true },
  { "naiharngym.com", true },
  { "najedlo.sk", true },
  { "nakedalarmclock.me", true },
  { "nakliyatsirketi.biz", true },
  { "nameid.org", true },
  { "namepros.com", true },
  { "nametiles.co", true },
  { "namorico.me", false },
  { "nan.zone", true },
  { "nanderson.me", true },
  { "nanogeneinc.com", true },
  { "nanogi.ga", true },
  { "narach.com", true },
  { "narfation.org", true },
  { "narodniki.com", true },
  { "narthollis.net", true },
  { "nationalpriorities.org", true },
  { "natukusa.com", false },
  { "naval.tf", true },
  { "navycs.com", true },
  { "nayahe.ru", true },
  { "nb.zone", true },
  { "nbg-ha.de", false },
  { "nbl.org.tw", true },
  { "ndarville.com", true },
  { "nder.be", true },
  { "ne-on.org", true },
  { "nearby.in.th", true },
  { "necesitodinero.org", true },
  { "nectarleaf.com", true },
  { "nedcdata.org", true },
  { "neel.ch", true },
  { "neg9.org", false },
  { "negai.moe", true },
  { "neilwynne.com", false },
  { "neko-life.com", true },
  { "neko.li", true },
  { "nekomimi.pl", false },
  { "nella-project.org", true },
  { "nellacms.com", true },
  { "nellacms.org", true },
  { "nellafw.org", true },
  { "neosolution.ca", true },
  { "net-safe.info", true },
  { "netbox.cc", true },
  { "netbrief.ml", true },
  { "netera.se", true },
  { "netfs.pl", true },
  { "netfxharmonics.com", true },
  { "nethackwiki.com", true },
  { "netlocal.ru", true },
  { "netprofile.com.au", true },
  { "netrelay.email", true },
  { "netrider.net.au", false },
  { "netsparker.com", false },
  { "netsystems.pro", true },
  { "nette.org", true },
  { "nettefoundation.com", true },
  { "nettopower.dk", true },
  { "netwarc.nl", true },
  { "network-notes.com", true },
  { "neuralgic.net", true },
  { "nevadafiber.net", true },
  { "neveta.com", true },
  { "new-black-order.com", true },
  { "newcitygas.ca", true },
  { "newmediaone.net", true },
  { "newodesign.com", true },
  { "newstarnootropics.com", true },
  { "nextend.net", true },
  { "ng-security.com", true },
  { "nginxnudes.com", true },
  { "nicky.io", true },
  { "nicoborghuis.nl", true },
  { "nicolaelmer.ch", true },
  { "nicolaw.uk", true },
  { "nidux.com", true },
  { "niftiestsoftware.com", true },
  { "nijm.nl", true },
  { "nikao-tech.com", true },
  { "nikobradshaw.com", true },
  { "nikolasbradshaw.com", true },
  { "niloxy.com", true },
  { "nl.search.yahoo.com", false },
  { "nmctest.net", true },
  { "nmd.so", true },
  { "no.search.yahoo.com", false },
  { "nodari.com.ar", true },
  { "nodebrewery.com", true },
  { "noemax.com", true },
  { "noima.com", true },
  { "noisetrap.cz", true },
  { "nolberg.net", true },
  { "nomadproject.io", true },
  { "nomial.co.uk", true },
  { "noname-ev.de", true },
  { "noob-box.net", true },
  { "nopex.no", true },
  { "northernmuscle.ca", true },
  { "nos-oignons.net", false },
  { "nostraforma.com", false },
  { "notalone.gov", true },
  { "nouvelle-vague-saint-cast.fr", true },
  { "novacoast.com", true },
  { "nowak.ninja", true },
  { "nowhere.dk", true },
  { "npmcdn.com", true },
  { "npw.net", true },
  { "nsboston.org", true },
  { "nsboutique.com", true },
  { "ntppool.org", true },
  { "nu3.fi", true },
  { "null-sec.ru", true },
  { "null.tips", true },
  { "nuos.org", true },
  { "nusatrip-api.com", true },
  { "nutritionculture.com", true },
  { "nuvini.com", true },
  { "nwa.xyz", true },
  { "nwgh.org", true },
  { "nyantec.com", true },
  { "nyffo.com", true },
  { "nymphetomania.net", true },
  { "o6asan.com", true },
  { "oakslighting.co.uk", true },
  { "oasis.mobi", true },
  { "obdolbacca.ru", true },
  { "obermeiers.eu", true },
  { "obscuredfiles.com", false },
  { "ochsundjunior.ch", true },
  { "ocrami.us", true },
  { "odin.xxx", true },
  { "offshoot.rentals", true },
  { "offshore-firma.org", true },
  { "oguya.ch", true },
  { "ohling.org", true },
  { "ohnemusik.com", true },
  { "okane.love", true },
  { "okonetwork.org.uk", true },
  { "oliverdunk.com", true },
  { "olivierlemoal.fr", true },
  { "olliespage.net", true },
  { "ollning.com", true },
  { "omacostudio.com", true },
  { "omifind.com", true },
  { "omitech.co.uk", true },
  { "ondrej.org", true },
  { "one---line.com", true },
  { "onedot.nl", true },
  { "onedrive.com", true },
  { "onedrive.live.com", false },
  { "onefour.co", true },
  { "onespiritinc.com", true },
  { "onet.space", true },
  { "onewpst.com", false },
  { "onixcco.com.br", true },
  { "online-bouwmaterialen.nl", true },
  { "online-casino.eu", true },
  { "online.swedbank.se", true },
  { "onlinecensorship.org", true },
  { "onlinedemo.hu", true },
  { "onlinelegalmarketing.com", true },
  { "onlinelegalmedia.com", true },
  { "onlinewetten.de", true },
  { "only-roses.com", true },
  { "onlyshopstation.com", true },
  { "onsitemassageco.com", true },
  { "ontimestamp.com", true },
  { "ooonja.de", true },
  { "oopsmycase.com", true },
  { "open-bs.com", true },
  { "open-bs.ru", true },
  { "open-mesh.org", true },
  { "openacademies.com", true },
  { "openkvk.nl", true },
  { "opennippon.com", true },
  { "opennippon.ru", true },
  { "openprovider.nl", true },
  { "openstreetmap.is", true },
  { "openxmpp.com", true },
  { "oplop.appspot.com", true },
  { "oprechtgezegd.nl", true },
  { "opsbears.com", true },
  { "opsmate.com", false },
  { "optimus.io", true },
  { "optmos.at", true },
  { "orbograph-hrcm.com", true },
  { "orcahq.com", true },
  { "orderswift.com", true },
  { "orf-digitalsatkarte.at", true },
  { "orf-kartentausch.at", true },
  { "organic-superfood.net", true },
  { "orhideous.name", true },
  { "oscarvk.ch", true },
  { "oshayr.com", true },
  { "osm.is", true },
  { "osquery.io", true },
  { "ossbinaries.com", true },
  { "oszri.hu", true },
  { "otakurepublic.com", true },
  { "otchecker.com", true },
  { "otoy.com", true },
  { "ottoproject.io", true },
  { "otya.me", true },
  { "ourcloud.at", true },
  { "ourevents.net", true },
  { "ovenapp.io", true },
  { "overclockers.ge", true },
  { "overkillshop.com", true },
  { "oversight.garden", true },
  { "oversight.io", true },
  { "owncloud.help", true },
  { "ownmovies.fr", true },
  { "oxygaming.com", true },
  { "oxymc.com", true },
  { "p.linode.com", false },
  { "p8r.de", true },
  { "packagist.org", false },
  { "packer.io", true },
  { "pacoda.de", true },
  { "pactf.com", true },
  { "pagure.io", true },
  { "pagure.org", true },
  { "pajonzeck.de", true },
  { "paku.me", true },
  { "palationtrade.com", true },
  { "palava.tv", true },
  { "pan.digital", true },
  { "panoti.com", true },
  { "panthur.com.au", false },
  { "pantsu.cat", true },
  { "pap.la", false },
  { "papayapythons.com", true },
  { "paragonie.com", true },
  { "parasitologyclub.org", true },
  { "paratlan.hu", true },
  { "parent5446.us", true },
  { "pariga.co.uk", true },
  { "parkingplus.co.il", true },
  { "parsemail.org", true },
  { "partyvan.eu", true },
  { "partyvan.it", true },
  { "partyvan.moe", true },
  { "partyvan.nl", true },
  { "partyvan.se", true },
  { "passphrase.today", true },
  { "passport.yandex.by", true },
  { "passport.yandex.com", true },
  { "passport.yandex.com.tr", true },
  { "passport.yandex.kz", true },
  { "passport.yandex.ru", true },
  { "passport.yandex.ua", true },
  { "passwd.io", true },
  { "password.codes", true },
  { "passwords.google.com", true },
  { "pasta-factory.co.il", true },
  { "paste.linode.com", false },
  { "pastebin.linode.com", false },
  { "patechmasters.com", true },
  { "patriksimek.cz", true },
  { "patt.us", true },
  { "paul.reviews", true },
  { "paulproell.at", true },
  { "paulschreiber.com", true },
  { "pay.gigahost.dk", true },
  { "pay.ubuntu.com", true },
  { "paylike.io", true },
  { "paymentaccuracy.gov", true },
  { "payments-reference.org", true },
  { "paymill.com", true },
  { "paymill.de", true },
  { "paypal.com", false },
  { "payroll.xero.com", false },
  { "paysera.com", true },
  { "pcel.com", true },
  { "pcfeuerwehr.de", true },
  { "pclob.gov", true },
  { "pcloud.com", true },
  { "pctonic.net", true },
  { "pdf.yt", true },
  { "pe.search.yahoo.com", false },
  { "peercraft.com", true },
  { "peerherrmann.de", true },
  { "peifi.de", true },
  { "penfold.fr", true },
  { "pennylane.me.uk", true },
  { "pentesterlab.com", true },
  { "pepchid.com", false },
  { "per-pedes.at", true },
  { "perfect.in.th", true },
  { "perfectionis.me", true },
  { "perfektesgewicht.com", true },
  { "perfektesgewicht.de", true },
  { "performaterm.ro", true },
  { "perishablepress.com", true },
  { "perplex.nl", false },
  { "pestici.de", true },
  { "peter.org.ua", true },
  { "peterdavehello.org", true },
  { "petko.me", true },
  { "petplum.com", true },
  { "petrachuk.ru", true },
  { "pettsy.com", true },
  { "peytonfarrar.com", true },
  { "pfadfinder-aurich.de", true },
  { "pgmann.cf", true },
  { "ph.search.yahoo.com", false },
  { "pharmaboard.de", true },
  { "phil.tw", true },
  { "philosopherswool.com", true },
  { "philosophyguides.org", true },
  { "phoenix.dj", true },
  { "phoenixlogan.com", true },
  { "photoblogverona.com", true },
  { "phparcade.com", true },
  { "phpdorset.co.uk", true },
  { "phpfashion.com", true },
  { "phryanjr.com", false },
  { "phryneas.de", true },
  { "phunehehe.net", true },
  { "phurl.de", true },
  { "pi-supply.com", true },
  { "picksin.club", true },
  { "piconepress.com", true },
  { "picsto.re", true },
  { "pieperhome.de", true },
  { "pier28.com", true },
  { "pierre-denoblens.net", true },
  { "pierre-schmitz.com", true },
  { "pijuice.com", true },
  { "pileofgarbage.net", true },
  { "pilgermaske.org", true },
  { "piligrimname.com", true },
  { "pimpmymac.ru", true },
  { "piratedb.com", true },
  { "piratedot.com", true },
  { "pirateproxy.la", true },
  { "pirateproxy.pl", true },
  { "pirateproxy.pw", true },
  { "pirateproxy.sx", true },
  { "pirlitu.com", true },
  { "pirxpilot.me", true },
  { "piwko.co", true },
  { "pixel.facebook.com", false },
  { "pixel.google.com", true },
  { "pixi.me", true },
  { "pjuu.com", true },
  { "pl.search.yahoo.com", false },
  { "planboardapp.com", true },
  { "planet-work.com", true },
  { "play.google.com", true },
  { "playkh.com", true },
  { "playnation.io", true },
  { "please-deny.me", true },
  { "pleier-it.de", true },
  { "pleier.it", true },
  { "plfgr.eu.org", true },
  { "plirt.ru", false },
  { "plogable.co", true },
  { "ploxel.com", true },
  { "pluga.co", true },
  { "plugin-planet.com", true },
  { "plus.google.com", false },
  { "plus.sandbox.google.com", false },
  { "plzenskybarcamp.cz", true },
  { "pm13.cz", true },
  { "pm13.org", true },
  { "pmctire.com", true },
  { "pmg-offshore-company.com", true },
  { "pmg-purchase.com", true },
  { "pmg-purchase.net", true },
  { "pmnts.io", true },
  { "pmponline.de", true },
  { "poed.com.au", true },
  { "poedgirl.com", true },
  { "pokemori.jp", true },
  { "pol.in.th", true },
  { "poleartschool.com", true },
  { "polimat.org", true },
  { "polis.or.at", true },
  { "polis.to", false },
  { "politic.org.ua", true },
  { "pollpodium.nl", true },
  { "polymathematician.com", true },
  { "polypho.nyc", true },
  { "ponythread.com", true },
  { "poolvilla-margarita.net", false },
  { "poon.io", true },
  { "poon.tech", true },
  { "portal.tirol.gv.at", true },
  { "portalplatform.net", true },
  { "posobota.cz", true },
  { "post4me.at", true },
  { "postal.dk", true },
  { "postbox.life", true },
  { "posteo.de", false },
  { "posterspy.com", true },
  { "postfinance.ch", true },
  { "postn.eu", true },
  { "postscheduler.org", true },
  { "posttigo.com", true },
  { "potbar.com", true },
  { "potbox.com", true },
  { "pothe.com", true },
  { "pothe.de", true },
  { "potlytics.com", true },
  { "powerplannerapp.com", true },
  { "ppmoon.com", true },
  { "ppy3.com", true },
  { "pr1sm.com", true },
  { "practicallabs.com", true },
  { "prakharprasad.com", true },
  { "prayerrequest.com", true },
  { "prediksisydney.com", true },
  { "prefis.com", true },
  { "prefontaine.name", true },
  { "preisser-it.de", true },
  { "preissler.co.uk", true },
  { "preloaded-hsts.badssl.com", true },
  { "premierheart.com", true },
  { "prepandgo-euro.com", true },
  { "presidentials2016.com", true },
  { "press-anime-nenkan.com", true },
  { "pressrush.com", true },
  { "pretix.eu", true },
  { "pretty.hu", true },
  { "principaltoolbox.com", true },
  { "priva.si", true },
  { "privacy.com", true },
  { "privacyinternational.org", true },
  { "privacyrup.net", true },
  { "privategiant.com", true },
  { "privytime.com", true },
  { "pro-bike.ro", true },
  { "profiles.google.com", true },
  { "profpay.com", true },
  { "profundr.com", true },
  { "progg.no", true },
  { "progressiveplanning.com", true },
  { "projectascension.io", true },
  { "projektzentrisch.de", true },
  { "proofwiki.org", true },
  { "proos.nl", true },
  { "propagandism.org", true },
  { "prospo.co", true },
  { "prowhisky.de", true },
  { "proximato.com", true },
  { "proxybay.al", true },
  { "proxybay.club", true },
  { "proxybay.co", true },
  { "proxybay.la", true },
  { "psw-group.de", true },
  { "psw.academy", true },
  { "psw.consulting", true },
  { "psw.net", true },
  { "pt-server.de", true },
  { "ptbx.co", true },
  { "ptgoldensun.com", true },
  { "ptm.ro", true },
  { "ptn.moscow", true },
  { "puac.de", true },
  { "pubkey.is", true },
  { "publications.qld.gov.au", false },
  { "publicsuffix.org", true },
  { "puiterwijk.org", true },
  { "pult.co", false },
  { "purewebmasters.com", false },
  { "purplebricks.com", true },
  { "purplemoon.ch", true },
  { "purplemoon.mobi", true },
  { "purplestar.ch", true },
  { "purplestar.com", true },
  { "purplestar.mobi", true },
  { "puryearlaw.com", true },
  { "pushapp.org", true },
  { "puyblanc.info", true },
  { "pwd.ovh", true },
  { "pwnies.dk", true },
  { "pypa.io", true },
  { "pypi.python.org", true },
  { "python.org", false },
  { "qa.fedoraproject.org", true },
  { "qa.stg.fedoraproject.org", true },
  { "qc.search.yahoo.com", false },
  { "qetesh.de", true },
  { "qgustavor.tk", true },
  { "qiliang.wang", true },
  { "qionglu.pw", true },
  { "qixxit.de", true },
  { "qlrace.com", false },
  { "qtxh.net", true },
  { "quai10.org", true },
  { "qualityedgarsolutions.com", true },
  { "qualityhomesystems.com", true },
  { "quantenteranik.eu", true },
  { "quchao.com", true },
  { "quebecmailbox.com", true },
  { "queercinema.ch", true },
  { "quli.nl", true },
  { "quppa.net", true },
  { "quuz.org", true },
  { "qvitoo.com", true },
  { "r3s1stanc3.me", false },
  { "r811.de", true },
  { "raah.co", true },
  { "racermaster.xyz", true },
  { "raconconsulting.co.uk", true },
  { "rad-route.de", true },
  { "radiormi.com", true },
  { "radtke.bayern", true },
  { "rafaelcz.de", true },
  { "ragingserenity.com", true },
  { "raidstone.com", true },
  { "raidstone.net", true },
  { "railgun.ac", true },
  { "rambitteh.ru", true },
  { "ramon-c.nl", true },
  { "ramsor-gaming.de", true },
  { "rangde.org", true },
  { "rantanda.com", true },
  { "rasing.me", true },
  { "raspass.me", true },
  { "rawoil.com", true },
  { "rawstorieslondon.com", true },
  { "raydobe.me", false },
  { "raymii.org", true },
  { "rc4.io", true },
  { "rcpcbd.com", true },
  { "reaconverter.com", true },
  { "realcapoeira.ru", true },
  { "realgarant-shop.de", true },
  { "realmic.net", true },
  { "realmofespionage.com", true },
  { "recommended.reviews", true },
  { "recon-networks.com", true },
  { "recyclingpromotions.us", true },
  { "red-t-shirt.ru", true },
  { "redb.cz", true },
  { "redd.it", true },
  { "reddit.com", true },
  { "redirect.fedoraproject.org", true },
  { "redirect.stg.fedoraproject.org", true },
  { "redletter.link", true },
  { "redlink.de", true },
  { "redports.org", false },
  { "redshield.co", true },
  { "redteam-pentesting.de", true },
  { "reedloden.com", true },
  { "refundo.cz", true },
  { "refundo.sk", true },
  { "reg.ru", false },
  { "regar42.fr", false },
  { "reishunger.de", true },
  { "release-monitoring.org", true },
  { "reliable-mail.de", true },
  { "remodela.com.ve", true },
  { "remotestance.com", true },
  { "remoteutilities.com", true },
  { "rene-schwarz.com", true },
  { "renlong.org", true },
  { "rentcarassist.com", true },
  { "rentinsingapore.com.sg", true },
  { "renuo.ch", true },
  { "repaxan.com", true },
  { "report-uri.com", true },
  { "report-uri.io", true },
  { "reporturi.com", true },
  { "reporturi.io", true },
  { "research.facebook.com", false },
  { "research.md", true },
  { "residentsinsurance.co.uk", true },
  { "resources.flowfinity.com", true },
  { "respice.xyz", true },
  { "responsibledisclosure.nl", true },
  { "restchart.com", true },
  { "retcor.net", true },
  { "retroarms.com", true },
  { "retroarms.cz", true },
  { "reucon.com", true },
  { "revolt.tv", true },
  { "rewrite3.com", true },
  { "rhdigital.pro", true },
  { "rhinelander.ca", true },
  { "riccy.org", true },
  { "richardwarrender.com", true },
  { "richiemail.net", true },
  { "richmondsunlight.com", false },
  { "ricki-z.com", true },
  { "rickyromero.com", true },
  { "ricochet.im", true },
  { "rideworks.com", true },
  { "riesenmagnete.de", true },
  { "riesenweber.id.au", true },
  { "right-to-love.name", true },
  { "rightcapital.com", true },
  { "rigolitch.fr", true },
  { "riiconnect24.net", true },
  { "rika.me", true },
  { "ringh.am", true },
  { "rinobroer.nl", true },
  { "rischard.org", true },
  { "riseup.net", true },
  { "riskmitigation.ch", true },
  { "ristioja.ee", true },
  { "rivy.org", true },
  { "rj.gg", true },
  { "rlalique.com", true },
  { "rmb.li", true },
  { "rmmanfredi.com", true },
  { "rmstudio.tw", true },
  { "rngmeme.com", true },
  { "ro.search.yahoo.com", false },
  { "roave.com", true },
  { "robandjanine.com", true },
  { "robertglastra.com", true },
  { "roberthurlbut.com", true },
  { "robertof.ovh", true },
  { "robi-net.it", true },
  { "robinadr.com", true },
  { "robinsonyu.com", true },
  { "robspc.repair", true },
  { "robteix.com", true },
  { "robtex.com", true },
  { "robtex.net", true },
  { "robtex.org", true },
  { "robud.info", true },
  { "rocketmill.co.uk", true },
  { "rodolfo.gs", true },
  { "rodosto.com", true },
  { "roeckx.be", true },
  { "roeitijd.nl", true },
  { "roeper.party", true },
  { "rohlik.cz", true },
  { "roland.io", true },
  { "rolemaster.net", true },
  { "romab.com", true },
  { "roman-pavlik.cz", true },
  { "romulusapp.com", false },
  { "room-checkin24.de", true },
  { "room208.org", true },
  { "roombase.nl", true },
  { "roomhub.jp", true },
  { "roosterpgplus.nl", true },
  { "rootforum.org", true },
  { "rootrelativity.com", true },
  { "roots.io", true },
  { "rootservice.org", true },
  { "rootwpn.com", true },
  { "roquecenter.org", true },
  { "rosenkeller.org", true },
  { "rot47.net", true },
  { "rotunneling.net", true },
  { "rotzonline.com", true },
  { "roundcube.mayfirst.org", false },
  { "royalacademy.org.uk", true },
  { "royalpalacenogent.fr", true },
  { "rpy.xyz", true },
  { "rr.in.th", true },
  { "rsajeey.info", true },
  { "rsi.im", false },
  { "rssr.se", true },
  { "rtcx.net", true },
  { "ru-sprachstudio.ch", true },
  { "ru.search.yahoo.com", false },
  { "ruanmi.de", true },
  { "rubecodeberg.com", true },
  { "rubendv.be", true },
  { "rubi-ka.net", true },
  { "ruborr.se", true },
  { "rubyshop.nl", true },
  { "rugstorene.co.uk", true },
  { "runementors.com", true },
  { "rusadmin.biz", true },
  { "rushball.net", true },
  { "rusl.net", true },
  { "russmarshall.com", true },
  { "ruudkoot.nl", true },
  { "ruxit.com", false },
  { "rws-vertriebsportal.de", true },
  { "rww.name", true },
  { "rxbusiness.com", true },
  { "ryan-goldstein.com", true },
  { "ryanhowell.io", true },
  { "ryansmithphotography.com", true },
  { "ryanteck.uk", false },
  { "s-c.se", true },
  { "sabahattin-gucukoglu.com", true },
  { "safar.sk", true },
  { "safematix.com", true },
  { "safemovescheme.co.uk", true },
  { "safescan.com", true },
  { "sagerus.com", true },
  { "sageth.com", true },
  { "saharalondon.com", true },
  { "saikarra.com", false },
  { "sailormoonevents.org", false },
  { "saintsrobotics.com", true },
  { "salaervergleich.com", true },
  { "sale4ru.ru", true },
  { "saltercane.com", true },
  { "saltstack.cz", true },
  { "samaritansnet.org", true },
  { "samba.org", true },
  { "sambeso.net", true },
  { "samegoal.com", true },
  { "samegoal.org", true },
  { "samfunnet.no", false },
  { "samizdat.cz", true },
  { "samkelleher.com", true },
  { "samuelkeeley.com", true },
  { "sanasport.cz", true },
  { "sanatfilan.com", false },
  { "sandbagexpress.com", true },
  { "sandbox.mydigipass.com", false },
  { "sanderdorigo.nl", true },
  { "sandervankasteel.nl", true },
  { "sandor.wtf", true },
  { "sanhei.ch", true },
  { "sarahlicity.co.uk", true },
  { "sarasturdivant.com", true },
  { "satmep.com", true },
  { "saulchristie.com", true },
  { "save.gov", true },
  { "saveaward.gov", true },
  { "saveyour.biz", true },
  { "savvytime.com", true },
  { "sb-group.dk", true },
  { "sbssoft.ru", true },
  { "scaling.solutions", true },
  { "scanpay.dk", true },
  { "schachburg.de", true },
  { "schelberts.de", true },
  { "schlarp.com", true },
  { "schokokeks.org", true },
  { "schorel.ovh", true },
  { "schorelweb.nl", true },
  { "schreibnacht.de", true },
  { "schrodinger.io", true },
  { "schwarzer.it", true },
  { "schwinabart.com", true },
  { "scicasts.com", true },
  { "sciencex.com", true },
  { "scotthel.me", true },
  { "scotthelme.co.uk", true },
  { "scotthelme.com", true },
  { "scourt.org.ua", true },
  { "scoutdb.ch", true },
  { "scp-trens.notaires.fr", true },
  { "scrambl.is", true },
  { "scrambler.in", false },
  { "scrap.tf", true },
  { "screenlight.tv", true },
  { "screenresolution.space", true },
  { "scribe.systems", true },
  { "script.google.com", true },
  { "scs-simulatoren.de", true },
  { "sdcardrecovery.de", true },
  { "sdrobs.com", true },
  { "sdsl-speedtest.de", true },
  { "se.search.yahoo.com", false },
  { "search.yahoo.com", false },
  { "searchbrothers.com", true },
  { "seatbeltpledge.com", true },
  { "sebastianboegl.de", true },
  { "sec.gd", true },
  { "secctexasgiving.org", true },
  { "secpatrol.de", true },
  { "secretserveronline.com", true },
  { "section.io", true },
  { "secure-games.us", true },
  { "secure.advancepayroll.com.au", true },
  { "secure.facebook.com", false },
  { "securedevelop.net", true },
  { "securedrop.org", false },
  { "secureideas.com", true },
  { "secureradio.net", true },
  { "securesuisse.ch", true },
  { "securify.nl", true },
  { "security-carpet.com", true },
  { "security.google.com", true },
  { "securityheaders.com", true },
  { "securityheaders.io", true },
  { "securitysnobs.com", false },
  { "secuvera.de", true },
  { "seele.ca", false },
  { "segurosocial.gov", false },
  { "seifried.org", true },
  { "seiko-dojo.com", true },
  { "selecadm.name", true },
  { "selectel.ru", true },
  { "selent.me", true },
  { "selfici.com", true },
  { "selfici.cz", true },
  { "sellme.biz", true },
  { "sellocdn.com", true },
  { "seminariruum.ee", true },
  { "sendya.me", true },
  { "seo-nerd.de", true },
  { "seo.consulting", true },
  { "sequencing.com", true },
  { "serbanpaun.ro", true },
  { "serfdom.io", true },
  { "serized.pw", true },
  { "serverstuff.info", true },
  { "servertastic.com", true },
  { "servethecity-karlsruhe.de", false },
  { "seryo.moe", true },
  { "seryo.net", true },
  { "seryovpn.com", true },
  { "setuid.io", true },
  { "sevsopr.ru", true },
  { "seyahatsagliksigortalari.com", true },
  { "seyr.me", true },
  { "sg.search.yahoo.com", false },
  { "sh-network.de", true },
  { "shaaaaaaaaaaaaa.com", true },
  { "shadex.net", true },
  { "shadowkitsune.net", true },
  { "shaitan.eu", true },
  { "shakepeers.org", true },
  { "shan.io", true },
  { "shanewadleigh.com", true },
  { "shasso.com", true },
  { "shaundanielz.com", true },
  { "sheilasdrivingschool.com", true },
  { "shellvatore.us", true },
  { "shenyuqi.com", true },
  { "sherbers.de", true },
  { "shft.cl", true },
  { "shiinko.com", false },
  { "shipard.com", true },
  { "shipcloud.io", true },
  { "shiroki-k.net", true },
  { "shodan.io", true },
  { "shopapi.cz", true },
  { "shopbakersnook.com", true },
  { "shopontarget.com", true },
  { "shortdiary.me", true },
  { "shtorku.com", true },
  { "shv25.se", true },
  { "si-benelux.nl", true },
  { "sidium.de", true },
  { "siebens.net", true },
  { "siewert-kau.de", true },
  { "sightcure.jp", true },
  { "signing-milter.org", true },
  { "sigterm.sh", true },
  { "sikayetvar.com", true },
  { "silentcircle.com", false },
  { "silentkernel.fr", true },
  { "silver-heart.co.uk", true },
  { "silvergoldbull.com", true },
  { "silvergoldbull.de", true },
  { "silverpvp.com", false },
  { "simbolo.co.uk", false },
  { "simod.org", false },
  { "simonkjellberg.com", true },
  { "simphony.cz", true },
  { "simple.com", false },
  { "simplednscrypt.org", true },
  { "simplelearner.com", true },
  { "simpletax.ca", false },
  { "simplexsupport.com", false },
  { "simplia.cz", true },
  { "simply-premium.com", true },
  { "simplycharlottemason.com", true },
  { "simplyfixit.co.uk", true },
  { "simplystudio.com", true },
  { "singul4rity.com", true },
  { "sinoscandinavia.se", true },
  { "siraweb.org", true },
  { "sirenslove.com", true },
  { "sites.google.com", true },
  { "sitesko.de", true },
  { "sitesten.com", true },
  { "sizzle.co.uk", true },
  { "sjoorm.com", true },
  { "skeeley.com", true },
  { "skhosting.eu", true },
  { "skia.org", true },
  { "skimming.net", true },
  { "skipfault.com", true },
  { "skoda-clever-lead.de", true },
  { "skoda-im-dialog.de", true },
  { "skoda-nurdiebesten.de", true },
  { "skoda-service-team-cup.de", true },
  { "skogsbruket.fi", true },
  { "skogskultur.fi", true },
  { "skoleniphp.cz", true },
  { "skou.dk", true },
  { "skydrive.live.com", false },
  { "skyminds.net", true },
  { "slack-files.com", true },
  { "slack.com", true },
  { "slainvet.net", true },
  { "slattery.co", true },
  { "sleio.com", true },
  { "slever.cz", true },
  { "slevomat.cz", true },
  { "slidebatch.com", true },
  { "slightfuture.click", true },
  { "slightfuture.com", true },
  { "slix.io", true },
  { "slope.haus", true },
  { "slse.ca", true },
  { "smares.de", true },
  { "smartcleaningcenter.nl", true },
  { "smartlend.se", true },
  { "smartlocksmith.com", true },
  { "smartmessages.net", true },
  { "smartpolicingplatform.com", true },
  { "smartship.co.jp", true },
  { "smb445.com", true },
  { "smiatek.name", true },
  { "smith.is", true },
  { "smm.im", true },
  { "sms1.ro", true },
  { "snailing.org", true },
  { "snakehosting.dk", false },
  { "snapappointments.com", true },
  { "snapappts.com", true },
  { "snazel.co.uk", true },
  { "sneakynote.com", true },
  { "sneberger.cz", true },
  { "sneezry.com", true },
  { "sniep.net", true },
  { "sny.no", true },
  { "sobabox.ru", true },
  { "sobie.ch", true },
  { "soci.ml", true },
  { "social-media-strategies.it", true },
  { "socialhead.io", true },
  { "socialrank.com", true },
  { "socialsecurity.gov", false },
  { "socialspirit.com.br", false },
  { "societyhilldance.com", true },
  { "sockeye.cc", false },
  { "sogutma.com.tr", true },
  { "soia.ca", true },
  { "solihullcarnival.co.uk", true },
  { "solihulllionsclub.org.uk", true },
  { "solsystems.ru", true },
  { "sonafe.info", true },
  { "soondy.com", true },
  { "soply.com", true },
  { "soporte.cc", true },
  { "sorz.org", true },
  { "sosecu.red", true },
  { "souki.cz", true },
  { "soulfulglamour.uk", true },
  { "soulogic.com", true },
  { "sour.is", true },
  { "sourceway.de", true },
  { "southside-crew.com", true },
  { "souvik.me", true },
  { "soved.eu", true },
  { "spacefish.biz", true },
  { "spark.team", true },
  { "sparklingsparklers.com", true },
  { "spawn.cz", true },
  { "spdf.net", true },
  { "speed-mailer.com", true },
  { "speedcounter.net", true },
  { "speedtest-russia.com", true },
  { "speich.net", true },
  { "spicymatch.com", true },
  { "spideroak.com", true },
  { "spillmaker.no", true },
  { "spira.io", true },
  { "splikity.com", true },
  { "spongepowered.org", true },
  { "sportifik.com", true },
  { "spreadsheets.google.com", true },
  { "spreed.me", true },
  { "sprueche-zum-valentinstag.de", true },
  { "sprueche-zur-geburt.info", true },
  { "sprueche-zur-hochzeit.de", true },
  { "sprueche-zur-konfirmation.de", true },
  { "square-gaming.org", true },
  { "square.com", false },
  { "square.gs", true },
  { "squareup.com", false },
  { "squawk.cc", true },
  { "srevilak.net", true },
  { "sritest.io", true },
  { "sro.center", true },
  { "srrr.ca", true },
  { "ss.lv", true },
  { "ssa.gov", false },
  { "sscd.no", true },
  { "ssl-zertifikate.de", true },
  { "ssl.google-analytics.com", true },
  { "ssl.rip", true },
  { "ssldecoder.org", true },
  { "sslmate.com", true },
  { "sslpoint.com", true },
  { "sslzilla.de", true },
  { "sstewartgallus.com", true },
  { "staack.com", true },
  { "stablelib.com", true },
  { "stackptr.com", true },
  { "stage.wepay.com", false },
  { "stalkerhispano.com", true },
  { "standardssuck.org", true },
  { "star-citizen.wiki", true },
  { "starapple.nl", true },
  { "starcomproj.com", true },
  { "starstreak.net", true },
  { "startupsort.com", true },
  { "stassi.ch", true },
  { "static.wepay.com", false },
  { "staticisnoise.com", true },
  { "stationary-traveller.eu", true },
  { "statuscode.ch", true },
  { "stbennett.org", true },
  { "steakovercooked.com", true },
  { "steamdb.info", true },
  { "steelephys.com.au", true },
  { "stellenticket.de", true },
  { "stemsims.com", true },
  { "stephenandburns.com", true },
  { "stereo.lu", true },
  { "stereochro.me", true },
  { "stesti.cz", true },
  { "stevegrav.es", true },
  { "steventress.com", true },
  { "stewartremodelingadvantage.com", true },
  { "stick2bike.de", true },
  { "sticklerjs.org", true },
  { "stinkytrashhound.com", true },
  { "stirling.co", true },
  { "stirlingpoon.com", true },
  { "stirlingpoon.xyz", true },
  { "stjohnmiami.org", true },
  { "stkbn.com", true },
  { "stmbgr.com", true },
  { "stocktrade.de", false },
  { "stolkschepen.nl", true },
  { "stomt.com", true },
  { "stopwoodfin.org", true },
  { "storedsafe.com", true },
  { "stormhub.org", true },
  { "storycollective.nl", true },
  { "strasweb.fr", false },
  { "streampanel.net", false },
  { "streams.dyndns.org", true },
  { "stressfreehousehold.com", true },
  { "stretchmyan.us", true },
  { "stricted.net", true },
  { "stripe.com", true },
  { "strongest-privacy.com", true },
  { "strugee.net", true },
  { "stuartbaxter.co", false },
  { "stuartbell.co.uk", true },
  { "student.andover.edu", true },
  { "studentloans.gov", true },
  { "studienportal.eu", true },
  { "stugb.de", true },
  { "stulda.cz", true },
  { "stupus.com", true },
  { "styles.pm", true },
  { "subdimension.org", false },
  { "subeesu.com", true },
  { "subrosa.io", true },
  { "suche.org", true },
  { "sufix.cz", true },
  { "suite73.org", true },
  { "sulek.eu", true },
  { "sumoscout.de", true },
  { "sunflyer.cn", true },
  { "sunjaydhama.com", true },
  { "sunnyfruit.ru", true },
  { "suos.io", true },
  { "supplies24.at", true },
  { "supplies24.es", true },
  { "support.mayfirst.org", false },
  { "surkatty.org", true },
  { "survivalmonkey.com", true },
  { "susanbpilates.co", true },
  { "susanbpilates.com", true },
  { "svager.cz", true },
  { "sveneckelmann.de", true },
  { "swapadoodle.com", true },
  { "sway-cdn.com", true },
  { "sway.com", true },
  { "sweetll.me", true },
  { "sweetstreats.ca", true },
  { "swehack.org", false },
  { "swift-devedge.de", true },
  { "sx3.no", true },
  { "sychov.pro", true },
  { "syezd.com.au", true },
  { "sykepleien.no", true },
  { "sylaps.com", true },
  { "syncappate.com", true },
  { "syncserve.net", true },
  { "synony.me", true },
  { "syntaxnightmare.com", true },
  { "sysctl.se", true },
  { "sysdb.io", true },
  { "syso.name", true },
  { "syss.de", true },
  { "system.is", true },
  { "syzygy-tables.info", true },
  { "szaydon.me", false },
  { "t23m-navi.jp", false },
  { "taborsky.cz", true },
  { "tacticalsquare.com", true },
  { "tadigitalstore.com", true },
  { "taken.pl", true },
  { "takkaaaaa.com", true },
  { "talado.gr", true },
  { "talideon.com", false },
  { "talk.google.com", true },
  { "talkgadget.google.com", true },
  { "tallr.se", true },
  { "tallshoe.com", true },
  { "tannenhof-moelln.de", true },
  { "tas2580.net", true },
  { "taskotron.fedoraproject.org", true },
  { "taskotron.stg.fedoraproject.org", true },
  { "taskstats.com", true },
  { "taskstream.com", true },
  { "taskulu.com", true },
  { "tatort-fanpage.de", true },
  { "tauchkater.de", true },
  { "taxbench.com", true },
  { "taxsquirrel.com", true },
  { "tazemama.biz", true },
  { "tazj.in", true },
  { "tbrss.com", true },
  { "tbspace.de", true },
  { "tc-bonito.de", true },
  { "tcao.info", true },
  { "tcgrepublic.com", true },
  { "tdelmas.eu", true },
  { "tdelmas.ovh", true },
  { "tdrs.info", true },
  { "teachforcanada.ca", true },
  { "teamblueridge.org", true },
  { "teamnorthgermany.de", true },
  { "teampaddymurphy.ie", true },
  { "teampoint.cz", true },
  { "teamupturn.com", true },
  { "teamzeus.cz", true },
  { "tecart-cloud.de", true },
  { "tecart-system.de", true },
  { "tecartcrm.de", true },
  { "tech-seminar.jp", true },
  { "techandtux.de", true },
  { "techcentric.com", false },
  { "techhipster.net", true },
  { "techhub.ml", true },
  { "techllage.com", true },
  { "techloaner.com", true },
  { "technosavvyport.com", true },
  { "technotonic.com.au", false },
  { "techpivot.net", true },
  { "techvalue.gr", true },
  { "teddy.ch", true },
  { "tehrabbitt.com", true },
  { "tekshrek.com", false },
  { "telekollektiv.org", true },
  { "teleogistic.net", true },
  { "telescam.com", true },
  { "temizmama.com", true },
  { "temp.pm", true },
  { "tempus-aquilae.de", true },
  { "tent.io", true },
  { "terraelectronica.ru", true },
  { "terraform.io", true },
  { "terraweb.net", true },
  { "terrax.info", true },
  { "terrax.net", true },
  { "terrty.net", true },
  { "testsuite.org", true },
  { "tetsumaki.net", true },
  { "texte-zur-taufe.de", true },
  { "textracer.dk", true },
  { "textualapp.com", true },
  { "texy.info", true },
  { "tf2b.com", true },
  { "th.search.yahoo.com", false },
  { "thca.ca", true },
  { "the-construct.com", true },
  { "the-gist.io", true },
  { "the-paddies.de", true },
  { "theamp.com", true },
  { "theater.cf", true },
  { "thebigwave.de", true },
  { "thebimhub.com", true },
  { "thebreakroom.org", true },
  { "thebrotherswarde.com", true },
  { "thecloudmigrator.com", true },
  { "thecustomizewindows.com", true },
  { "thedark1337.com", true },
  { "thedreamtravelgroup.co.uk", true },
  { "theescapistswiki.com", true },
  { "thefrozenfire.com", false },
  { "thego2swatking.com", true },
  { "thegoldregister.co.uk", true },
  { "thegraciousgourmet.com", true },
  { "thehackerblog.com", true },
  { "thehiddenbay.me", true },
  { "thehiddenbay.net", true },
  { "thehotfix.net", true },
  { "theintercept.com", true },
  { "theitsage.com", true },
  { "thejserver.de", true },
  { "thelocals.ru", true },
  { "themarshallproject.org", true },
  { "themicrocapital.com", true },
  { "themoep.at", true },
  { "theojones.name", true },
  { "thepaymentscompany.com", true },
  { "thepiratebay.al", true },
  { "therapynotes.com", true },
  { "therewill.be", true },
  { "thesession.org", true },
  { "theshadestore.com", true },
  { "thestagchorleywood.co.uk", true },
  { "thetomharling.com", true },
  { "theunitedstates.io", true },
  { "theweilai.com", false },
  { "theyosh.nl", true },
  { "thinkindifferent.net", true },
  { "thinklikeanentrepreneur.com", true },
  { "thom4s.info", true },
  { "thomas-grobelny.de", true },
  { "thomasgriffin.io", true },
  { "thomastimepieces.com.au", true },
  { "thomspooren.nl", true },
  { "thorbis.com", true },
  { "thorbiswebsitedesign.com", true },
  { "thorgames.nl", true },
  { "thouni.de", true },
  { "threelions.ch", true },
  { "throwpass.com", true },
  { "thusoy.com", true },
  { "thyngster.com", false },
  { "ticketmates.com.au", true },
  { "tickopa.co.uk", true },
  { "tid.jp", true },
  { "tidycustoms.net", true },
  { "tiens-ib.cz", true },
  { "tifan.net", true },
  { "tiffnix.com", true },
  { "timmy.ws", true },
  { "timtaubert.de", true },
  { "tinfoilsecurity.com", false },
  { "tinkertry.com", false },
  { "tinte24.de", true },
  { "tintenfix.net", true },
  { "tinylan.com", true },
  { "tinyvpn.net", true },
  { "tinyvpn.org", true },
  { "tipps-fuer-den-haushalt.de", true },
  { "tipsyk.ru", true },
  { "tittelbach.at", true },
  { "tlo.hosting", true },
  { "tlo.link", true },
  { "tlo.xyz", true },
  { "tls.builders", true },
  { "tls.li", true },
  { "tls1914.org", true },
  { "tm-solutions.eu", true },
  { "tmaward.net", true },
  { "tmpsantos.com.br", true },
  { "tmtopup.com", true },
  { "tncnanet.com.br", true },
  { "tnes.dk", true },
  { "tno.io", true },
  { "tobias-kluge.de", true },
  { "tobiasmathes.com", true },
  { "tobiasmathes.name", true },
  { "tobiassachs.de", true },
  { "tobiassattler.com", true },
  { "todesschaf.org", true },
  { "todoist.com", true },
  { "tokke.dk", true },
  { "tollsjekk.no", true },
  { "tom.horse", true },
  { "tomasjacik.cz", true },
  { "tomatenaufdenaugen.de", true },
  { "tomcort.com", true },
  { "tomfisher.eu", true },
  { "tomharling.co.uk", true },
  { "tomharling.uk", true },
  { "tomli.me", true },
  { "tommyads.com", true },
  { "tomo.gr", false },
  { "tomvote.com", true },
  { "tonburi.jp", true },
  { "toner24.at", true },
  { "toner24.co.uk", true },
  { "toner24.es", true },
  { "toner24.fr", true },
  { "toner24.it", true },
  { "toner24.nl", true },
  { "toner24.pl", true },
  { "tonerdepot.de", true },
  { "tonerjet.at", true },
  { "tonerjet.co.uk", true },
  { "tonerklick.de", true },
  { "tonerkurier.de", true },
  { "tonermaus.de", true },
  { "tonermonster.de", true },
  { "tonex.de", true },
  { "tonex.nl", true },
  { "tonytan.cn", true },
  { "tonytan.io", true },
  { "tonywebster.com", true },
  { "toolbox.ninja", true },
  { "topnewstoday.org", true },
  { "topnovini.com", true },
  { "toptexture.com", true },
  { "tor2web.org", true },
  { "tormentedradio.com", true },
  { "torproject.org", false },
  { "torprojects.com", true },
  { "torquato.de", false },
  { "torrent.is", true },
  { "tosecure.link", false },
  { "toshnix.com", true },
  { "totalcarcheck.co.uk", true },
  { "totalchecklist.com", true },
  { "totch.de", true },
  { "totem-eshop.cz", true },
  { "touch.facebook.com", false },
  { "touch.mail.ru", true },
  { "touhou.cc", true },
  { "tox.im", true },
  { "toxme.se", true },
  { "tpbcdn.com", true },
  { "tpbproxy.co", true },
  { "tpe-edu.com", true },
  { "tppleague.me", true },
  { "tr.search.yahoo.com", false },
  { "traas.org", true },
  { "tracktivity.com.au", true },
  { "trainex.org", true },
  { "translate.fedoraproject.org", true },
  { "translate.googleapis.com", true },
  { "translate.stg.fedoraproject.org", true },
  { "trashnothing.com", true },
  { "trauertexte.info", true },
  { "travador.com", true },
  { "travisf.net", true },
  { "treebaglia.xyz", true },
  { "treeby.net", true },
  { "tresorit.com", true },
  { "tresorsecurity.com", true },
  { "tribaldos.com", true },
  { "tribut.de", true },
  { "triop.se", true },
  { "trollme.me", true },
  { "trophee-discount.com", true },
  { "truckstop-magazin.de", true },
  { "trueblueessentials.com", true },
  { "trufflemonkey.co.uk", true },
  { "tryoneday.co", true },
  { "trywesayyes.com", true },
  { "ts3.consulting", true },
  { "ttcf.ca", true },
  { "ttz.im", true },
  { "tuamoronline.com", true },
  { "tucny.com", true },
  { "tucuxi.org", true },
  { "tuitle.com", true },
  { "tumutanzi.com", true },
  { "tunebitfm.de", true },
  { "tuningblog.eu", true },
  { "tunnelblick.net", true },
  { "tuntitili.fi", true },
  { "tuxgeo.com", true },
  { "tuxplace.nl", true },
  { "tuzaijidi.com", true },
  { "tw.search.yahoo.com", false },
  { "twaka.com", true },
  { "twentymilliseconds.com", true },
  { "twist.party", true },
  { "twisto.cz", true },
  { "twitter.com", false },
  { "twitteroauth.com", true },
  { "twofactorauth.org", true },
  { "twolinepassbrewing.com", true },
  { "twopif.net", true },
  { "tyche.io", true },
  { "typecodes.com", true },
  { "typewolf.com", true },
  { "typing.com", true },
  { "typingrevolution.com", true },
  { "tzappa.net", true },
  { "uae-company-service.com", true },
  { "uasmi.com", true },
  { "ub3rk1tten.com", false },
  { "ubanquity.com", true },
  { "ubertt.org", true },
  { "ubicv.com", true },
  { "ucfirst.nl", true },
  { "ufotable.uk", false },
  { "uk.search.yahoo.com", false },
  { "ukdefencejournal.org.uk", true },
  { "ukhas.net", true },
  { "ukrainians.ch", true },
  { "ukwct.org.uk", true },
  { "ulabox.cat", true },
  { "ulabox.com", true },
  { "ulabox.es", true },
  { "ulrik.moe", true },
  { "ultros.io", true },
  { "umgardi.ca", true },
  { "umwandeln-online.de", true },
  { "un-zero-un.fr", true },
  { "unapp.me", true },
  { "unblocked-networks.org", true },
  { "undone.me", true },
  { "uni-games.com", true },
  { "uniekglas.nl", true },
  { "unila.edu.br", true },
  { "unionplat.ru", true },
  { "unionstationapp.com", true },
  { "unison.com", true },
  { "unitedadmins.com", true },
  { "unitel2000.de", true },
  { "unixadm.org", false },
  { "unknownphenomena.net", true },
  { "uno-pizza.ru", true },
  { "unoccupyabq.org", true },
  { "unpr.dk", true },
  { "unravel.ie", true },
  { "unterfrankenclan.de", true },
  { "unterschicht.tv", true },
  { "untoldstory.eu", true },
  { "unwiredbrain.com", true },
  { "uonstaffhub.com", true },
  { "uow.ninja", true },
  { "up1.ca", true },
  { "upitnik.rs", true },
  { "upload.facebook.com", false },
  { "uploadbeta.com", true },
  { "upstats.eu", true },
  { "uptrends.com", true },
  { "uptrends.de", true },
  { "urandom.eu.org", true },
  { "uripura.de", true },
  { "urphp.com", true },
  { "usaa.com", false },
  { "uscntalk.com", true },
  { "use.be", true },
  { "usgande.com", true },
  { "uspsoig.gov", true },
  { "ust.space", true },
  { "utdsgda.com", true },
  { "utilia.tools", true },
  { "utilityapi.com", true },
  { "utleieplassen.no", true },
  { "utonia.ch", true },
  { "utopians.dk", true },
  { "uvarov.pw", false },
  { "v0tti.com", true },
  { "vaddder.com", true },
  { "vagrantup.com", true },
  { "valentin-sundermann.de", true },
  { "valis.sx", true },
  { "valmagus.com", true },
  { "valopv.be", true },
  { "valordolarblue.com.ar", true },
  { "vanetv.com", true },
  { "vanhoutte.be", true },
  { "vanitas.xyz", true },
  { "vanlaanen.com", true },
  { "vansieleghem.com", true },
  { "vapemania.eu", true },
  { "vapordepot.jp", true },
  { "varden.info", true },
  { "varghese.de", true },
  { "varunagw.com", false },
  { "varvy.com", true },
  { "vasanth.org", true },
  { "vat-eu.com", true },
  { "vaultproject.io", true },
  { "vbh2o.com", true },
  { "vbhelp.org", true },
  { "vbulletin-russia.com", true },
  { "vbulletinrussia.com", true },
  { "vcsjones.com", true },
  { "ve.search.yahoo.com", false },
  { "veblen.com", true },
  { "vechkasov.ru", true },
  { "venicerealdeal.com", true },
  { "veriny.tf", true },
  { "verizonguidelines.com", true },
  { "vfdworld.com", true },
  { "vgatest.nl", true },
  { "vhost.co.id", true },
  { "viasinc.com", false },
  { "victorcanera.com", true },
  { "videomail.io", false },
  { "vieclam24h.vn", true },
  { "viemeister.com", true },
  { "viennan.net", true },
  { "viewmyrecords.com", true },
  { "vigo-krankenversicherung.de", true },
  { "vijos.org", true },
  { "vikashkumar.me", true },
  { "vimeo.com", true },
  { "vincentcox.com", true },
  { "viperdns.com", true },
  { "virtualsanity.com", true },
  { "viscopic.com", true },
  { "visionless.me", false },
  { "vissanum.com", true },
  { "vistb.me", true },
  { "vitalorange.com", true },
  { "vitkausk.as", true },
  { "vitrado.de", true },
  { "viva-french.com", true },
  { "vivendi.de", true },
  { "vm0.eu", true },
  { "vmoagents.com", false },
  { "vmrdev.com", true },
  { "vn.search.yahoo.com", false },
  { "vnvisa.ru", true },
  { "vocaloid.my", true },
  { "voicesuk.co.uk", true },
  { "vokeapp.com", true },
  { "volcrado.com", true },
  { "vomitb.in", true },
  { "vorlif.org", true },
  { "votocek.cz", true },
  { "votockova.cz", true },
  { "vpnhot.com", true },
  { "vpnzoom.com", true },
  { "vrobert.fr", false },
  { "vrtak-cz.net", true },
  { "vsean.net", true },
  { "vserver-preis-vergleich.de", true },
  { "vsund.de", true },
  { "vulnerability.ch", true },
  { "vyber-odhadce.cz", true },
  { "vyberodhadce.cz", true },
  { "vyplnto.cz", true },
  { "vzk.io", false },
  { "w-spotlight.appspot.com", true },
  { "w.wiki", true },
  { "w4nvu.org", true },
  { "w4xzr.xyz", true },
  { "wachter.biz", true },
  { "wait.jp", true },
  { "walkeryoung.ca", true },
  { "wallet.google.com", true },
  { "wallpapers.pub", true },
  { "walnutgaming.co.uk", false },
  { "walnutgaming.com", false },
  { "wanban.io", true },
  { "wander.al", true },
  { "wangqiliang.cn", true },
  { "wangqiliang.com", true },
  { "warandpeace.xyz", true },
  { "warr.ath.cx", true },
  { "warrencreative.com", false },
  { "wartorngalaxy.com", true },
  { "wasema.com", true },
  { "watersb.org", true },
  { "watertrails.io", true },
  { "watsonhall.uk", true },
  { "wbg-vs.de", true },
  { "wdbgroup.co.uk", true },
  { "wdesk.com", true },
  { "wealthprojector.com", true },
  { "wealthprojector.com.au", true },
  { "wearvr.com", true },
  { "weathermyway.rocks", true },
  { "web4all.fr", true },
  { "webandmore.de", false },
  { "webandwords.com.au", true },
  { "webassadors.com", false },
  { "webcollect.org.uk", true },
  { "webdevops.io", true },
  { "webeau.com", true },
  { "webfilings-eu-mirror.appspot.com", true },
  { "webfilings-eu.appspot.com", true },
  { "webfilings-mirror-hrd.appspot.com", true },
  { "webfilings.appspot.com", true },
  { "weblogzwolle.nl", true },
  { "webm.to", true },
  { "webmail.gigahost.dk", false },
  { "webmail.onlime.ch", false },
  { "webmail.schokokeks.org", false },
  { "webmarketingfestival.it", true },
  { "webogram.org", true },
  { "webrebels.org", true },
  { "webscale.nl", true },
  { "webseitendesigner.com", true },
  { "websenat.de", true },
  { "webstudio-n.com", true },
  { "webswitch.io", true },
  { "webtalis.nl", true },
  { "webtasarim.pw", true },
  { "webtiles.co.uk", true },
  { "webtorrent.io", true },
  { "webtrh.cz", true },
  { "webyazilimankara.com", true },
  { "weeblr.com", true },
  { "weggeweest.nl", true },
  { "wegner.no", true },
  { "weirdesigns.com", true },
  { "welches-kinderfahrrad.de", true },
  { "welldrake.com", true },
  { "welovemail.com", true },
  { "welpy.com", false },
  { "wenjs.me", true },
  { "wepay.com", false },
  { "wepay.in.th", true },
  { "wesleycabus.be", true },
  { "wesleyharris.ca", true },
  { "westerhoud.nl", true },
  { "westeros.hu", true },
  { "wettbuero.de", true },
  { "wetten.eu", true },
  { "wettertoertchen.com", true },
  { "wetttipps.com", true },
  { "wetttipps.de", true },
  { "wevahoo.com", true },
  { "wevolver.com", true },
  { "wf-bigsky-master.appspot.com", true },
  { "wf-demo-eu.appspot.com", true },
  { "wf-demo-hrd.appspot.com", true },
  { "wf-dogfood-hrd.appspot.com", true },
  { "wf-hosting.de", true },
  { "wf-pentest.appspot.com", true },
  { "wf-staging-hr.appspot.com", true },
  { "wf-training-hrd.appspot.com", true },
  { "wf-training-master.appspot.com", true },
  { "wf-trial-hrd.appspot.com", true },
  { "wfh.ovh", true },
  { "wfh.se", true },
  { "whatsapp.com", true },
  { "whatsmychaincert.com", true },
  { "whatsupgold.com.tw", true },
  { "whatwg.org", true },
  { "whd-guide.de", true },
  { "when-release.ru", false },
  { "when.fm", true },
  { "wherephoto.com", true },
  { "whey-protein.ch", true },
  { "whispeer.de", true },
  { "whitehouse.gov", true },
  { "whocalld.com", true },
  { "whocalled.us", true },
  { "wholebites.com", true },
  { "whonix.org", true },
  { "widememory.com", true },
  { "wieninternational.at", true },
  { "wifirst.net", true },
  { "wiimotion.de", true },
  { "wiire.me", true },
  { "wiki.python.org", true },
  { "wikibooks.org", true },
  { "wikidata.org", true },
  { "wikimediafoundation.org", true },
  { "wikinews.org", true },
  { "wikipedia.org", true },
  { "wikiquote.org", true },
  { "wikisource.org", true },
  { "wikiversity.org", true },
  { "wikivoyage.org", true },
  { "wiktionary.org", true },
  { "wildbee.org", true },
  { "wilddog.com", true },
  { "wilf1rst.com", true },
  { "williamfeely.info", true },
  { "williamsapiens.com", true },
  { "williamsonshore.com", true },
  { "willnorris.com", true },
  { "willosagiede.com", true },
  { "wills.co.tt", true },
  { "winhistory-forum.net", true },
  { "winmodels.org", true },
  { "winmodels.ru", true },
  { "winsec.nl", true },
  { "winter.engineering", true },
  { "winterfeldt.de", true },
  { "wis.no", true },
  { "wiseloan.com", true },
  { "wisv.ch", true },
  { "wisweb.no", true },
  { "wit.ai", true },
  { "witae.com", true },
  { "withgoogle.com", true },
  { "withinsecurity.com", true },
  { "withyoutube.com", true },
  { "wittcher.com", true },
  { "wje-online.de", true },
  { "wjglerum.nl", true },
  { "wlzhiyin.cn", true },
  { "wm-talk.net", true },
  { "wo2forum.nl", true },
  { "wodka-division.de", true },
  { "wohlgemuth.rocks", false },
  { "wohnsitz-ausland.com", true },
  { "wolfachtal-alpaka.de", true },
  { "wolfemg.com", true },
  { "wolfsden.cz", true },
  { "wolfwings.us", true },
  { "womf.org", true },
  { "wonderhost.info", true },
  { "wondermags.com", true },
  { "wondershift.biz", true },
  { "woodbury.io", true },
  { "woodlandschurch.net", true },
  { "woodlandsmetro.church", true },
  { "woodomat.com", true },
  { "wootton95.com", true },
  { "worcesterfestival.co.uk", true },
  { "wordsmart.it", true },
  { "woresite.jp", true },
  { "workingclassmedia.com", true },
  { "workray.com", true },
  { "workwithgo.com", true },
  { "worldcubeassociation.org", true },
  { "wownmedia.com", true },
  { "wp-tao.com", true },
  { "wpfortify.com", true },
  { "wpletter.de", true },
  { "wpmeetup-berlin.de", true },
  { "wpserp.com", true },
  { "wpvulndb.com", true },
  { "wrara.org", true },
  { "wrightdoumawedding.com", true },
  { "wrldevelopment.com", true },
  { "wrwg.ca", true },
  { "wscales.com", true },
  { "wss.com.ve", true },
  { "wtfismyip.com", true },
  { "wubthecaptain.eu", true },
  { "wunderlist.com", true },
  { "wundi.net", true },
  { "wurzelzwerg.net", true },
  { "wvr-law.de", true },
  { "www.aclu.org", false },
  { "www.airbnb.com", true },
  { "www.apollo-auto.com", true },
  { "www.banking.co.at", false },
  { "www.braintreepayments.com", false },
  { "www.capitainetrain.com", false },
  { "www.captaintrain.com", false },
  { "www.cloudflare.com", false },
  { "www.cyveillance.com", true },
  { "www.dropbox.com", true },
  { "www.dropcam.com", false },
  { "www.entropia.de", false },
  { "www.eternalgoth.co.uk", true },
  { "www.etsy.com", true },
  { "www.evernote.com", false },
  { "www.facebook.com", false },
  { "www.fastmail.com", true },
  { "www.gamesdepartment.co.uk", false },
  { "www.getcloak.com", false },
  { "www.gmail.com", false },
  { "www.googlemail.com", false },
  { "www.gov.uk", false },
  { "www.gpo.gov", false },
  { "www.grc.com", false },
  { "www.healthcare.gov", false },
  { "www.heliosnet.com", true },
  { "www.honeybadger.io", false },
  { "www.icann.org", false },
  { "www.intercom.io", false },
  { "www.irccloud.com", false },
  { "www.lastpass.com", false },
  { "www.linode.com", false },
  { "www.lookout.com", false },
  { "www.makeyourlaws.org", true },
  { "www.mydigipass.com", false },
  { "www.mylookout.com", false },
  { "www.noisebridge.net", false },
  { "www.opsmate.com", true },
  { "www.paypal.com", false },
  { "www.python.org", true },
  { "www.schokokeks.org", true },
  { "www.simbolo.co.uk", false },
  { "www.simple.com", false },
  { "www.therapynotes.com", true },
  { "www.tinfoilsecurity.com", false },
  { "www.torproject.org", false },
  { "www.twitter.com", false },
  { "www.usaa.com", false },
  { "www.viasinc.com", true },
  { "www.vino75.com", false },
  { "www.wepay.com", false },
  { "www.zenpayroll.com", false },
  { "wxcafe.net", true },
  { "wyeworks.com", true },
  { "wzrd.in", true },
  { "wzyboy.org", true },
  { "x.io", true },
  { "x.st", true },
  { "x64architecture.com", true },
  { "xatr0z.org", false },
  { "xbrlsuccess.appspot.com", true },
  { "xcoop.me", true },
  { "xd.cm", true },
  { "xdd.io", true },
  { "xellos.ga", true },
  { "xellos.ml", true },
  { "xenesisziarovky.sk", true },
  { "xetown.com", true },
  { "xett.com", true },
  { "xf-liam.com", true },
  { "xgclan.com", true },
  { "xho.me", true },
  { "xiangweiqing.co.uk", true },
  { "xiaody.me", true },
  { "xiaofengsky.com", true },
  { "xiaolan.me", true },
  { "xiaolvmu.me", true },
  { "xiaoxiao.im", true },
  { "xkviz.net", true },
  { "xn--4dbjwf8c.cf", true },
  { "xn--4dbjwf8c.ga", true },
  { "xn--4dbjwf8c.ml", true },
  { "xn--4dbjwf8c.tk", true },
  { "xn--7xa.google.com", true },
  { "xn--datenrettung-mnchen-jbc.com", true },
  { "xn--hfk-allgu-schwaben-stb.de", true },
  { "xn--knstler-n2a.tips", false },
  { "xn--lgb3a8bcpn.cf", true },
  { "xn--lgb3a8bcpn.ga", true },
  { "xn--lgb3a8bcpn.gq", true },
  { "xn--lgb3a8bcpn.ml", true },
  { "xn--ls8hi7a.tk", true },
  { "xn--maraa-rta.org", true },
  { "xn--mgbbh2a9fub.xn--ngbc5azd", true },
  { "xn--t8j4aa4nyhxa7duezbl49aqg5546e264d.net", true },
  { "xn--u9jv84l7ea468b.com", true },
  { "xng.io", true },
  { "xpd.se", true },
  { "xps2pdf.co.uk", true },
  { "xss.sk", true },
  { "xtrim.ru", true },
  { "xuexb.com", true },
  { "xunn.io", true },
  { "xuntier.ch", true },
  { "xwaretech.info", true },
  { "y-s.pw", true },
  { "yafuoku.ru", true },
  { "yahvehyireh.com", true },
  { "yamaken.jp", true },
  { "yanovich.net", true },
  { "yawnbox.com", true },
  { "ycc.wtf", true },
  { "yecl.net", true },
  { "yello.website", true },
  { "yellowcar.website", true },
  { "yenniferallulli.com", true },
  { "yenniferallulli.de", true },
  { "yenniferallulli.es", true },
  { "yenniferallulli.moda", true },
  { "yenniferallulli.nl", true },
  { "yetcore.io", true },
  { "yetzt.me", true },
  { "yippie.nl", true },
  { "yksityisyydensuoja.fi", true },
  { "yobst.tk", true },
  { "yolobert.de", true },
  { "yoloprod.fr", true },
  { "yoloseo.com", true },
  { "yombo.net", true },
  { "yorcom.nl", true },
  { "youcancraft.de", true },
  { "youcontrol.ru", true },
  { "youdowell.com", true },
  { "yoursecondphone.co", true },
  { "youyoulemon.com", true },
  { "ypart.eu", true },
  { "yplanapp.com", true },
  { "ys-shop.biz", true },
  { "ytvwld.de", true },
  { "yuan.ga", true },
  { "yunity.org", true },
  { "yunzhu.li", true },
  { "yunzhu.org", true },
  { "yuyu.io", true },
  { "yvesx.com", true },
  { "yyyy.xyz", true },
  { "z.ai", true },
  { "z0rro.net", true },
  { "zacarias.com.ar", true },
  { "zalan.do", true },
  { "zapier.com", true },
  { "zaufanatrzeciastrona.pl", true },
  { "zbasenem.pl", true },
  { "zcarot.com", false },
  { "zcarrot.com", true },
  { "zdrojak.cz", true },
  { "ze3kr.com", true },
  { "zefu.ca", true },
  { "zen-trader.com", false },
  { "zeno-system.com", true },
  { "zenpayroll.com", false },
  { "zentralwolke.de", true },
  { "zeplin.io", true },
  { "zera.com.au", true },
  { "zeropush.com", true },
  { "zett4.me", true },
  { "zgrep.org", true },
  { "zhang-hao.com", true },
  { "zhanghao.me", true },
  { "zhangyuhao.com", true },
  { "zhaojin97.cn", true },
  { "zhihua-lai.com", true },
  { "zhovner.com", true },
  { "zifb.in", true },
  { "zirtue.io", true },
  { "zixiao.wang", true },
  { "zlatosnadno.cz", true },
  { "zlavomat.sk", true },
  { "zoneminder.com", true },
  { "zonglovani.info", true },
  { "zooom.azurewebsites.net", true },
  { "zooparadies.eu", true },
  { "zorntt.fr", true },
  { "zortium.report", true },
  { "zorz.info", true },
  { "zotero.org", true },
  { "zravypapir.cz", true },
  { "zscales.com", true },
  { "ztan.tk", true },
  { "zx6rninja.de", true },
  { "zzw.ca", true },
};
