"use strict";

let tab;
let notificationURL = "http://example.org/browser/browser/base/content/test/alerts/file_dom_notifications.html";

add_task(function* test_notificationClose() {
  let pm = Services.perms;
  pm.add(makeURI(notificationURL), "desktop-notification", pm.ALLOW_ACTION);

  yield BrowserTestUtils.withNewTab({
    gBrowser,
    url: notificationURL
  }, function* dummyTabTask(aBrowser) {
    yield openNotification(aBrowser, "showNotification2");

    info("Notification alert showing");

    let alertWindow = Services.wm.getMostRecentWindow("alert:alert");
    if (!alertWindow) {
      ok(true, "Notifications don't use XUL windows on all platforms.");
      yield closeNotification(aBrowser);
      return;
    }

    let alertTitleLabel = alertWindow.document.getElementById("alertTitleLabel");
    is(alertTitleLabel.value, "Test title", "Title text of notification should be present");
    let alertTextLabel = alertWindow.document.getElementById("alertTextLabel");
    is(alertTextLabel.textContent, "Test body", "Body text of notification should be present");

    let alertCloseButton = alertWindow.document.querySelector(".alertCloseButton");
    is(alertCloseButton.localName, "toolbarbutton", "close button found");
    let promiseBeforeUnloadEvent =
      BrowserTestUtils.waitForEvent(alertWindow, "beforeunload");
    let closedTime = alertWindow.Date.now();
    alertCloseButton.click();
    info("Clicked on close button");
    let beforeUnloadEvent = yield promiseBeforeUnloadEvent;

    ok(true, "Alert should close when the close button is clicked");
    let currentTime = alertWindow.Date.now();
    // The notification will self-close at 12 seconds, so this checks
    // that the notification closed before the timeout.
    ok(currentTime - closedTime < 5000,
       "Close requested at " + closedTime + ", actually closed at " + currentTime);
  });
});

add_task(function* cleanup() {
  Services.perms.remove(makeURI(notificationURL), "desktop-notification");
});
