/* Any copyright is dedicated to the Public Domain.
 * http://creativecommons.org/publicdomain/zero/1.0/ */

"use strict";

var {utils: Cu} = Components;

Cu.import("resource://gre/modules/Promise.jsm", this);
Cu.import("resource://gre/modules/Services.jsm", this);
Cu.import("resource://testing-common/AppData.jsm", this);

function run_test() {
  run_next_test();
}

add_task(function* test_setup() {
  do_get_profile();
  yield makeFakeAppDir();
});

add_task(function* test_main_process_crash() {
  let cm = Services.crashmanager;
  Assert.ok(cm, "CrashManager available.");

  let basename;
  let deferred = Promise.defer();
  do_crash(
    function() {
      // TelemetrySession setup will trigger the session annotation
      let scope = {};
      Components.utils.import("resource://gre/modules/TelemetrySession.jsm", scope);
      scope.TelemetrySession.setup();
      crashType = CrashTestUtils.CRASH_RUNTIMEABORT;
      crashReporter.annotateCrashReport("ShutdownProgress", "event-test");
    },
    (minidump, extra) => {
      basename = minidump.leafName;
      cm._eventsDirs = [getEventDir()];
      cm.aggregateEventsFiles().then(deferred.resolve, deferred.reject);
    },
    true);

  let count = yield deferred.promise;
  Assert.equal(count, 1, "A single crash event file was seen.");
  let crashes = yield cm.getCrashes();
  Assert.equal(crashes.length, 1);
  let crash = crashes[0];
  Assert.ok(crash.isOfType(cm.PROCESS_TYPE_MAIN, cm.CRASH_TYPE_CRASH));
  Assert.equal(crash.id + ".dmp", basename, "ID recorded properly");
  Assert.equal(crash.metadata.ShutdownProgress, "event-test");
  Assert.ok("TelemetrySessionId" in crash.metadata);
  Assert.ok("UptimeTS" in crash.metadata);
  Assert.ok(/^[0-9a-f]{8}\-([0-9a-f]{4}\-){3}[0-9a-f]{12}$/.test(crash.metadata.TelemetrySessionId));
  Assert.ok("CrashTime" in crash.metadata);
  Assert.ok(/^\d+$/.test(crash.metadata.CrashTime));
});
