/*
 *  DO NOT EDIT.  THIS FILE IS GENERATED.
 */

/* pp_macros.idl */

/*
 * @addtogroup PP
 * @{
 */

/* Use PP_INLINE to tell the compiler to inline functions.  The main purpose of
 * inline functions in ppapi is to allow us to define convenience functions in
 * the ppapi header files, without requiring clients or implementers to link a
 * PPAPI C library.  The "inline" keyword is not supported by pre-C99 C
 * compilers (such as MS Visual Studio 2008 and older versions of GCC).  MSVS
 * supports __forceinline and GCC supports __inline__.  Use of the static
 * keyword ensures (in C) that the function is not compiled on its own, which
 * could cause multiple definition errors.
 *  http://msdn.microsoft.com/en-us/library/z8y1yy88.aspx
 *  http://gcc.gnu.org/onlinedocs/gcc/Inline.html
 */
#if defined(__cplusplus)
/* The inline keyword is part of C++ and guarantees we won't get multiple
 * definition errors.
 */
# define PP_INLINE inline
#else
# if defined(_MSC_VER)
#  define PP_INLINE static __forceinline
# else
#  define PP_INLINE static __inline__
# endif
#endif

/* This is a compile-time assertion useful for ensuring that a given type is
   a given number of bytes wide.  The size of the array is designed to be 1
   (which should always be valid) if the enum's size is SIZE, and otherwise the
   size of the array will be -1 (which all/most compilers should flag as an
   error).  This is wrapped inside a struct, because if it is a simple global
   we get multiple definition errors at link time.

   NAME is the name of the type without any spaces or the struct or enum
   keywords.

   CTYPENAME is the typename required by C.  I.e., for a struct or enum, the
   appropriate keyword must be included.

   SIZE is the expected size in bytes.
 */
#define PP_COMPILE_ASSERT_SIZE_IN_BYTES_IMPL(NAME, CTYPENAME, SIZE) \
struct PP_Dummy_Struct_For_##NAME { \
char _COMPILE_ASSERT_FAILED_The_type_named_ \
## NAME ## _is_not_ ## SIZE ## \
_bytes_wide[(sizeof(CTYPENAME) == SIZE) ? 1 : -1]; }

/* PP_COMPILE_ASSERT_SIZE_IN_BYTES is for typenames that contain no spaces.
   E.g.:
   PP_COMPILE_ASSERT_SIZE_IN_BYTES(int, 4);
   typedef struct { int a; } Foo;
   PP_COMPILE_ASSERT_SIZE_IN_BYTES(Foo, 4);
 */
#define PP_COMPILE_ASSERT_SIZE_IN_BYTES(NAME, SIZE) \
PP_COMPILE_ASSERT_SIZE_IN_BYTES_IMPL(NAME, NAME, SIZE)

/* PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES is for typenames that contain 'struct'
   in C.  That is, struct names that are not typedefs.
   E.g.:
   struct Foo { int a; };
   PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(Foo, 4);
 */
#define PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(NAME, SIZE) \
PP_COMPILE_ASSERT_SIZE_IN_BYTES_IMPL(NAME, struct NAME, SIZE)

/* PP_COMPILE_ASSERT_ENUM_SIZE_IN_BYTES is for typenames that contain 'enum'
   in C.  That is, enum names that are not typedefs.
   E.g.:
   enum Bar { A = 0, B = 1 };
   PP_COMPILE_ASSERT_ENUM_SIZE_IN_BYTES(Foo, 4);
 */
#define PP_COMPILE_ASSERT_ENUM_SIZE_IN_BYTES(NAME, SIZE) \
PP_COMPILE_ASSERT_SIZE_IN_BYTES_IMPL(NAME, enum NAME, SIZE)

/**
 * @}
 * End of addtogroup PP
 */

/* pp_stdint.idl */

/**
 *
 * @addtogroup Typedefs
 * @{
 */
#if defined(_MSC_VER)

/** This value represents a guaranteed unsigned 8 bit integer. */
typedef unsigned char uint8_t;

/** This value represents a guaranteed signed 8 bit integer. */
typedef signed char int8_t;

/** This value represents a guaranteed unsigned 16 bit short. */
typedef unsigned short uint16_t;

/** This value represents a guaranteed signed 16 bit short. */
typedef short int16_t;

/** This value represents a guaranteed unsigned 32 bit integer. */
typedef unsigned int uint32_t;

/** This value represents a guaranteed signed 32 bit integer. */
typedef int int32_t;

/** This value represents a guaranteed signed 64 bit integer. */
typedef __int64 int64_t;

/** This value represents a guaranteed unsigned 64 bit integer. */
typedef unsigned __int64 uint64_t;

#else
#include <stdint.h>
#endif
/**
 * @}
 */

/* pp_array_output.idl */
/**
 * @addtogroup Typedefs
 * @{
 */
typedef void* (*PP_ArrayOutput_GetDataBuffer)(void* user_data,
                                              uint32_t element_count,
                                              uint32_t element_size);
/**
 * @}
 */

/**
 * @addtogroup Structs
 * @{
 */
/**
 * A structure that defines a way for the browser to return arrays of data
 * to the plugin. The browser can not allocate memory on behalf of the plugin
 * because the plugin and browser may have different allocators.
 *
 * Array output works by having the browser call to the plugin to allocate a
 * buffer, and then the browser will copy the contents of the array into that
 * buffer.
 *
 * In C, you would typically implement this as follows:
 *
 * @code
 * struct MyArrayOutput {
 *   void* data;
 *   int element_count;
 * };
 * void* MyGetDataBuffer(void* user_data, uint32_t count, uint32_t size) {
 *   MyArrayOutput* output = (MyArrayOutput*)user_data;
 *   output->element_count = count;
 *   if (size) {
 *     output->data = malloc(count * size);
 *     if (!output->data)  // Be careful to set size properly on malloc failure.
 *       output->element_count = 0;
 *   } else {
 *     output->data = NULL;
 *   }
 *   return output->data;
 * }
 * void MyFunction() {
 *   MyArrayOutput array = { NULL, 0 };
 *   PP_ArrayOutput output = { &MyGetDataBuffer, &array };
 *   ppb_foo->GetData(&output);
 * }
 * @endcode
 */
struct PP_ArrayOutput {
  /**
   * A pointer to the allocation function that the browser will call.
   */
  PP_ArrayOutput_GetDataBuffer GetDataBuffer;
  /**
   * Data that is passed to the allocation function. Typically, this is used
   * to communicate how the data should be stored.
   */
  void* user_data;
};
/**
 * @}
 */

/* pp_bool.idl */
/**
 * @addtogroup Enums
 * @{
 */
/**
 * The <code>PP_Bool</code> enum is a boolean value for use in PPAPI C headers.
 * The standard bool type is not available to pre-C99 compilers, and is not
 * guaranteed to be compatible between C and C++, whereas the PPAPI C headers
 * can be included from C or C++ code.
 */
typedef enum {
  PP_FALSE = 0,
  PP_TRUE = 1
} PP_Bool;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_Bool, 4);
/**
 * @}
 */

#ifdef __cplusplus
/**
 * Converts a C++ "bool" type to a PP_Bool.
 *
 * @param[in] b A C++ "bool" type.
 *
 * @return A PP_Bool.
 */
inline PP_Bool PP_FromBool(bool b) {
  return b ? PP_TRUE : PP_FALSE;
}

/**
 * Converts a PP_Bool to a C++ "bool" type.
 *
 * @param[in] b A PP_Bool.
 *
 * @return A C++ "bool" type.
 */
inline bool PP_ToBool(PP_Bool b) {
  return (b != PP_FALSE);
}

#endif  /* __cplusplus */

/* pp_point.idl */
/**
 * @addtogroup Structs
 * @{
 */
/**
 * The PP_Point structure defines the integer x and y coordinates of a point.
 */
struct PP_Point {
  /**
   * This value represents the horizontal coordinate of a point, starting with 0
   * as the left-most coordinate.
   */
  int32_t x;
  /**
   * This value represents the vertical coordinate of a point, starting with 0
   * as the top-most coordinate.
   */
  int32_t y;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_Point, 8);

/**
 * The PP_FloatPoint structure defines the floating-point x and y coordinates
 * of a point.
 */
struct PP_FloatPoint {
  float x;
  float y;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_FloatPoint, 8);
/**
 * @}
 */

/**
 * @addtogroup Functions
 * @{
 */

/**
 * PP_MakePoint() creates a <code>PP_Point</code> given the x and y coordinates
 * as int32_t values.
 *
 * @param[in] x An int32_t value representing a horizontal coordinate of a
 * point, starting with 0 as the left-most coordinate.
 * @param[in] y An int32_t value representing a vertical coordinate of a point,
 * starting with 0 as the top-most coordinate.
 *
 * @return A <code>PP_Point</code> structure.
 */
PP_INLINE struct PP_Point PP_MakePoint(int32_t x, int32_t y) {
  struct PP_Point ret;
  ret.x = x;
  ret.y = y;
  return ret;
}

PP_INLINE struct PP_FloatPoint PP_MakeFloatPoint(float x, float y) {
  struct PP_FloatPoint ret;
  ret.x = x;
  ret.y = y;
  return ret;
}
/**
 * @}
 */

/* pp_size.idl */
/**
 * @addtogroup Structs
 * @{
 */
/**
 * The <code>PP_Size</code> struct contains the size of a 2D rectangle.
 */
struct PP_Size {
  /** This value represents the width of the rectangle. */
  int32_t width;
  /** This value represents the height of the rectangle. */
  int32_t height;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_Size, 8);

/**
 * The <code>PP_FloatSize</code> struct contains the size of a 2D rectangle.
 */
struct PP_FloatSize {
  /** This value represents the width of the rectangle. */
  float width;
  /** This value represents the height of the rectangle. */
  float height;
};
/**
 * @}
 */

/**
 * @addtogroup Functions
 * @{
 */

/**
 * PP_MakeSize() creates a <code>PP_Size</code> given a width and height as
 * int32_t values.
 *
 * @param[in] w An int32_t value representing a width.
 * @param[in] h An int32_t value representing a height.
 *
 * @return A <code>PP_Size</code> structure.
 */
PP_INLINE struct PP_Size PP_MakeSize(int32_t w, int32_t h) {
  struct PP_Size ret;
  ret.width = w;
  ret.height = h;
  return ret;
}

/**
 * PP_MakeFloatSize() creates a <code>PP_FloatSize</code> given a
 * width and height as float values.
 *
 * @param[in] w An float value representing a width.
 * @param[in] h An float value representing a height.
 *
 * @return A <code>PP_FloatSize</code> structure.
 */
PP_INLINE struct PP_FloatSize PP_MakeFloatSize(float w, float h) {
  struct PP_FloatSize ret;
  ret.width = w;
  ret.height = h;
  return ret;
}
/**
 * @}
 */
/* pp_rect.idl */
/**
 * @addtogroup Structs
 * @{
 */
/**
 * The <code>PP_Rect</code> struct contains the size and location of a 2D
 * rectangle.
 */
struct PP_Rect {
  /**
   * This value represents the x and y coordinates of the upper-left corner of
   * the rectangle.
   */
  struct PP_Point point;
  /** This value represents the width and height of the rectangle. */
  struct PP_Size size;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_Rect, 16);

/**
 * The <code>PP_FloatRect</code> struct contains the size and location of a 2D
 * rectangle.
 */
struct PP_FloatRect {
  /**
   * This value represents the x and y coordinates of the upper-left corner of
   * the rectangle.
   */
  struct PP_FloatPoint point;
  /** This value represents the width and height of the rectangle. */
  struct PP_FloatSize size;
};
/**
 * @}
 */


/**
 * @addtogroup Functions
 * @{
 */

/**
 * PP_MakeRectFromXYWH() creates a <code>PP_Rect</code> given x and y
 * coordinates and width and height dimensions as int32_t values.
 *
 * @param[in] x An int32_t value representing a horizontal coordinate of a
 * point, starting with 0 as the left-most coordinate.
 * @param[in] y An int32_t value representing a vertical coordinate of a point,
 * starting with 0 as the top-most coordinate.
 * @param[in] w An int32_t value representing a width.
 * @param[in] h An int32_t value representing a height.
 *
 * @return A <code>PP_Rect</code> structure.
 */
PP_INLINE struct PP_Rect PP_MakeRectFromXYWH(int32_t x, int32_t y,
                                             int32_t w, int32_t h) {
  struct PP_Rect ret;
  ret.point.x = x;
  ret.point.y = y;
  ret.size.width = w;
  ret.size.height = h;
  return ret;
}

/**
 * PP_MakeFloatRectFromXYWH() creates a <code>PP_FloatRect</code> given x and y
 * coordinates and width and height dimensions as float values.
 *
 * @param[in] x An float value representing a horizontal coordinate of a
 * point, starting with 0 as the left-most coordinate.
 * @param[in] y An float value representing a vertical coordinate of a point,
 * starting with 0 as the top-most coordinate.
 * @param[in] w An float value representing a width.
 * @param[in] h An float value representing a height.
 *
 * @return A <code>PP_FloatRect</code> structure.
 */
PP_INLINE struct PP_FloatRect PP_MakeFloatRectFromXYWH(float x, float y,
                                                       float w, float h) {
  struct PP_FloatRect ret;
  ret.point.x = x;
  ret.point.y = y;
  ret.size.width = w;
  ret.size.height = h;
  return ret;
}

/**
 * @}
 */

/* pp_codecs.idl */
/**
 * @addtogroup Enums
 * @{
 */
typedef enum {
  PP_VIDEOPROFILE_H264BASELINE = 0,
  PP_VIDEOPROFILE_H264MAIN = 1,
  PP_VIDEOPROFILE_H264EXTENDED = 2,
  PP_VIDEOPROFILE_H264HIGH = 3,
  PP_VIDEOPROFILE_H264HIGH10PROFILE = 4,
  PP_VIDEOPROFILE_H264HIGH422PROFILE = 5,
  PP_VIDEOPROFILE_H264HIGH444PREDICTIVEPROFILE = 6,
  PP_VIDEOPROFILE_H264SCALABLEBASELINE = 7,
  PP_VIDEOPROFILE_H264SCALABLEHIGH = 8,
  PP_VIDEOPROFILE_H264STEREOHIGH = 9,
  PP_VIDEOPROFILE_H264MULTIVIEWHIGH = 10,
  PP_VIDEOPROFILE_VP8_ANY = 11,
  PP_VIDEOPROFILE_VP9_ANY = 12,
  PP_VIDEOPROFILE_MAX = PP_VIDEOPROFILE_VP9_ANY
} PP_VideoProfile;

/**
 * Audio profiles.
 */
typedef enum {
  PP_AUDIOPROFILE_OPUS = 0,
  PP_AUDIOPROFILE_MAX = PP_AUDIOPROFILE_OPUS
} PP_AudioProfile;

/**
 * Hardware acceleration options.
 */
typedef enum {
  /** Create a hardware accelerated resource only. */
  PP_HARDWAREACCELERATION_ONLY = 0,
  /**
   * Create a hardware accelerated resource if possible. Otherwise, fall back
   * to the software implementation.
   */
  PP_HARDWAREACCELERATION_WITHFALLBACK = 1,
  /** Create the software implementation only. */
  PP_HARDWAREACCELERATION_NONE = 2,
  PP_HARDWAREACCELERATION_LAST = PP_HARDWAREACCELERATION_NONE
} PP_HardwareAcceleration;
/**
 * @}
 */

/**
 * @addtogroup Structs
 * @{
 */
/**
 * Struct describing a decoded video picture. The decoded picture data is stored
 * in the GL texture corresponding to |texture_id|. The plugin can determine
 * which Decode call generated the picture using |decode_id|.
 */
struct PP_VideoPicture {
  /**
   * |decode_id| parameter of the Decode call which generated this picture.
   * See the PPB_VideoDecoder function Decode() for more details.
   */
  uint32_t decode_id;
  /**
   * Texture ID in the plugin's GL context. The plugin can use this to render
   * the decoded picture.
   */
  uint32_t texture_id;
  /**
   * The GL texture target for the decoded picture. Possible values are:
   *   GL_TEXTURE_2D
   *   GL_TEXTURE_RECTANGLE_ARB
   *   GL_TEXTURE_EXTERNAL_OES
   *
   * The pixel format of the texture is GL_RGBA.
   */
  uint32_t texture_target;
  /**
   * Dimensions of the texture holding the decoded picture.
   */
  struct PP_Size texture_size;
  /**
   * The visible subrectangle of the picture. The plugin should display only
   * this part of the picture.
   */
  struct PP_Rect visible_rect;
};

/**
 * Struct describing a decoded video picture. The decoded picture data is stored
 * in the GL texture corresponding to |texture_id|. The plugin can determine
 * which Decode call generated the picture using |decode_id|.
 */
struct PP_VideoPicture_0_1 {
  /**
   * |decode_id| parameter of the Decode call which generated this picture.
   * See the PPB_VideoDecoder function Decode() for more details.
   */
  uint32_t decode_id;
  /**
   * Texture ID in the plugin's GL context. The plugin can use this to render
   * the decoded picture.
   */
  uint32_t texture_id;
  /**
   * The GL texture target for the decoded picture. Possible values are:
   *   GL_TEXTURE_2D
   *   GL_TEXTURE_RECTANGLE_ARB
   *   GL_TEXTURE_EXTERNAL_OES
   *
   * The pixel format of the texture is GL_RGBA.
   */
  uint32_t texture_target;
  /**
   * Dimensions of the texture holding the decoded picture.
   */
  struct PP_Size texture_size;
};

/**
 * Supported video profile information. See the PPB_VideoEncoder function
 * GetSupportedProfiles() for more details.
 */
struct PP_VideoProfileDescription {
  /**
   * The codec profile.
   */
  PP_VideoProfile profile;
  /**
   * Dimensions of the maximum resolution of video frames, in pixels.
   */
  struct PP_Size max_resolution;
  /**
   * The numerator of the maximum frame rate.
   */
  uint32_t max_framerate_numerator;
  /**
   * The denominator of the maximum frame rate.
   */
  uint32_t max_framerate_denominator;
  /**
   * Whether the profile is hardware accelerated.
   */
  PP_Bool hardware_accelerated;
};

/**
 * Supported video profile information. See the PPB_VideoEncoder function
 * GetSupportedProfiles() for more details.
 */
struct PP_VideoProfileDescription_0_1 {
  /**
   * The codec profile.
   */
  PP_VideoProfile profile;
  /**
   * Dimensions of the maximum resolution of video frames, in pixels.
   */
  struct PP_Size max_resolution;
  /**
   * The numerator of the maximum frame rate.
   */
  uint32_t max_framerate_numerator;
  /**
   * The denominator of the maximum frame rate.
   */
  uint32_t max_framerate_denominator;
  /**
   * A value indicating if the profile is available in hardware, software, or
   * both.
   */
  PP_HardwareAcceleration acceleration;
};

/**
 * Supported audio profile information. See the PPB_AudioEncoder function
 * GetSupportedProfiles() for more details.
 */
struct PP_AudioProfileDescription {
  /**
   * The codec profile.
   */
  PP_AudioProfile profile;
  /**
   * Maximum number of channels that can be encoded.
   */
  uint32_t max_channels;
  /**
   * Sample size.
   */
  uint32_t sample_size;
  /**
   * Sampling rate that can be encoded
   */
  uint32_t sample_rate;
  /**
   * Whether the profile is hardware accelerated.
   */
  PP_Bool hardware_accelerated;
};

/**
 * Struct describing a bitstream buffer.
 */
struct PP_BitstreamBuffer {
  /**
   * The size, in bytes, of the bitstream data.
   */
  uint32_t size;
  /**
   * The base address of the bitstream data.
   */
  void* buffer;
  /**
   * Whether the buffer represents a key frame.
   */
  PP_Bool key_frame;
};

/**
 * Struct describing an audio bitstream buffer.
 */
struct PP_AudioBitstreamBuffer {
  /**
   * The size, in bytes, of the bitstream data.
   */
  uint32_t size;
  /**
   * The base address of the bitstream data.
   */
  void* buffer;
};
/**
 * @}
 */

/* pp_completion_callback.idl */
/**
 * @addtogroup Typedefs
 * @{
 */
/**
 * This typedef defines the signature that you implement to receive callbacks
 * on asynchronous completion of an operation.
 *
 * @param[in] user_data A pointer to user data passed to a callback function.
 * @param[in] result If result is 0 (PP_OK), the operation succeeded.  Negative
 * values (other than -1 or PP_OK_COMPLETE) indicate error and are specified
 * in pp_errors.h. Positive values for result usually indicate success and have
 * some operation-dependent meaning (such as bytes read).
 */
typedef void (*PP_CompletionCallback_Func)(void* user_data, int32_t result);
/**
 * @}
 */

/**
 * @addtogroup Enums
 * @{
 */
/**
 * This enumeration contains flags used to control how non-NULL callbacks are
 * scheduled by asynchronous methods.
 */
typedef enum {
  /**
   * By default any non-NULL callback will always invoked asynchronously,
   * on success or error, even if the operation could complete synchronously
   * without blocking.
   *
   * The method taking such callback will always return PP_OK_COMPLETIONPENDING.
   * The callback will be invoked on the same thread on which the method was
   * invoked.
   *
   * NOTE: If the method taking the callback is invoked on a background
   * thread that has no valid PPB_MessageLoop resource attached, the system has
   * no way to run the callback on the correct thread. In this case, a log
   * message will be emitted and the plugin will be made to crash.
   */
  PP_COMPLETIONCALLBACK_FLAG_NONE = 0 << 0,
  /**
   * This flag allows any method taking such callback to complete synchronously
   * and not call the callback if the operation would not block. This is useful
   * when performance is an issue, and the operation bandwidth should not be
   * limited to the processing speed of the message loop.
   *
   * On synchronous method completion, the completion result will be returned
   * by the method itself. Otherwise, the method will return
   * PP_OK_COMPLETIONPENDING, and the callback will be invoked asynchronously on
   * the same thread on which the method was invoked. If there is no valid
   * PPB_MessageLoop attached to that thread, and the callback would normally
   * run asynchronously, the invoked method will return
   * PP_ERROR_NO_MESSAGE_LOOP.
   */
  PP_COMPLETIONCALLBACK_FLAG_OPTIONAL = 1 << 0
} PP_CompletionCallback_Flag;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_CompletionCallback_Flag, 4);
/**
 * @}
 */

/**
 * @addtogroup Structs
 * @{
 */
/**
 * <code>PP_CompletionCallback</code> is a common mechanism for supporting
 * potentially asynchronous calls in browser interfaces. Any method that takes a
 * <code>PP_CompletionCallback</code> can be used in one of three different
 * ways:
 *   - Required: The callback will always be invoked asynchronously on the
 *               thread where the associated PPB method was invoked. The method
 *               will always return PP_OK_COMPLETIONPENDING when a required
 *               callback, and the callback will be invoked later (barring
 *               system or thread shutdown; see PPB_MessageLoop for details).
 *               Required callbacks are the default.
 *               <br /><br />
 *               NOTE: If you use a required callback on a background thread,
 *               you must have created and attached a PPB_MessageLoop.
 *               Otherwise, the system can not run your callback on that thread,
 *               and will instead emit a log message and crash your plugin to
 *               make the problem more obvious.
 *
 *   - Optional: The callback may be invoked asynchronously, or the PPB method
 *               may complete synchronously if it can do so without blocking.
 *               If the method will complete asynchronously, it will return
 *               PP_OK_COMPLETIONPENDING. Otherwise, it will complete
 *               synchronously and return an appropriate code (see below for
 *               more information on the return code). Optional callbacks are
 *               generally more difficult to use correctly than Required
 *               callbacks, but can provide better performance for some APIs
 *               (especially APIs with buffered reads, such as PPB_URLLoader or
 *               PPB_FileIO).
 *               <br /><br />
 *               NOTE: If you use an optional callback on a background thread,
 *               and you have not created and attached a PPB_MessageLoop, then
 *               the method you invoke will fail without running and return
 *               PP_ERROR_NO_MESSAGE_LOOP.
 *
 *   - Blocking: In this case, the callback's function pointer is NULL, and the
 *               invoked method must complete synchronously. The method will
 *               run to completion and return an appropriate code when finished
 *               (see below for more information). Blocking completion
 *               callbacks are only supported on background threads.
 *               <br /><br />
 *               <code>PP_BlockUntilComplete()</code> provides a convenient way
 *               to specify blocking behavior. Refer to
 *               <code>PP_BlockUntilComplete</code> for more information.
 *
 * When the callback is run asynchronously, the result parameter passed to
 * <code>func</code> is an int32_t that, if negative indicates an error code
 * whose meaning is specific to the calling method (refer to
 * <code>pp_error.h</code> for further information). A positive or 0 value is a
 * return result indicating success whose meaning depends on the calling method
 * (e.g. number of bytes read).
 */
struct PP_CompletionCallback {
  /**
   * This value is a callback function that will be called, or NULL if this is
   * a blocking completion callback.
   */
  PP_CompletionCallback_Func func;
  /**
   * This value is a pointer to user data passed to a callback function.
   */
  void* user_data;
  /**
   * Flags used to control how non-NULL callbacks are scheduled by
   * asynchronous methods.
   */
  int32_t flags;
};
/**
 * @}
 */

#include <stdlib.h>

/**
 * @addtogroup Functions
 * @{
 */
/**
 * PP_MakeCompletionCallback() is used to create a
 * <code>PP_CompletionCallback</code>.
 *
 * <strong>Example, creating a Required callback:</strong>
 *
 * @code
 * struct PP_CompletionCallback cc = PP_MakeCompletionCallback(Foo, NULL);
 * @endcode
 *
 * <strong>Example, creating an Optional callback:</strong>
 *
 * @code
 * struct PP_CompletionCallback cc = PP_MakeCompletionCallback(Foo, NULL);
 * cc.flags = cc.flags | PP_COMPLETIONCALLBACK_FLAG_OPTIONAL;
 * @endcode
 *
 * @param[in] func A <code>PP_CompletionCallback_Func</code> that will be
 * called.
 * @param[in] user_data A pointer to user data passed to your callback
 * function. This is optional and is typically used to help track state
 * when you may have multiple callbacks pending.
 *
 * @return A <code>PP_CompletionCallback</code> structure.
 */
PP_INLINE struct PP_CompletionCallback PP_MakeCompletionCallback(
    PP_CompletionCallback_Func func,
    void* user_data) {
  struct PP_CompletionCallback cc;
  cc.func = func;
  cc.user_data = user_data;
  cc.flags = PP_COMPLETIONCALLBACK_FLAG_NONE;
  return cc;
}

/**
 * PP_MakeOptionalCompletionCallback() is used to create a PP_CompletionCallback
 * with PP_COMPLETIONCALLBACK_FLAG_OPTIONAL set.
 *
 * @param[in] func A PP_CompletionCallback_Func to be called on completion.
 * @param[in] user_data A pointer to user data passed to be passed to the
 * callback function. This is optional and is typically used to help track state
 * in case of multiple pending callbacks.
 *
 * @return A PP_CompletionCallback structure.
 */
PP_INLINE struct PP_CompletionCallback PP_MakeOptionalCompletionCallback(
    PP_CompletionCallback_Func func,
    void* user_data) {
  struct PP_CompletionCallback cc = PP_MakeCompletionCallback(func, user_data);
  cc.flags = cc.flags | PP_COMPLETIONCALLBACK_FLAG_OPTIONAL;
  return cc;
}
/**
 * @}
 */

/**
 * @addtogroup Functions
 * @{
 */

/**
 * PP_RunCompletionCallback() is used to run a callback. It invokes
 * the callback function passing it user data specified on creation and
 * completion |result|.
 *
 * @param[in] cc A pointer to a <code>PP_CompletionCallback</code> that will be
 * run.
 * @param[in] result The result of the operation. Non-positive values correspond
 * to the error codes from pp_errors.h (excluding PP_OK_COMPLETIONPENDING).
 * Positive values indicate additional information such as bytes read.
 */
PP_INLINE void PP_RunCompletionCallback(struct PP_CompletionCallback* cc,
                                        int32_t result) {
  cc->func(cc->user_data, result);
}

/**
 * @}
 */

/**
 * @addtogroup Functions
 * @{
 */

 /**
 * PP_BlockUntilComplete() is used in place of an actual completion callback
 * to request blocking behavior. If specified, the calling thread will block
 * until the function completes. Blocking completion callbacks are only allowed
 * from background threads.
 *
 * @return A <code>PP_CompletionCallback</code> structure.
 */
PP_INLINE struct PP_CompletionCallback PP_BlockUntilComplete(void) {
  return PP_MakeCompletionCallback(NULL, NULL);
}

/**
 * PP_RunAndClearCompletionCallback() runs a callback and clears the reference
 * to that callback.
 *
 * This function is used when the null-ness of a completion callback is used as
 * a signal for whether a completion callback has been registered. In this
 * case, after the execution of the callback, it should be cleared. However,
 * this introduces a conflict if the completion callback wants to schedule more
 * work that involves the same completion callback again (for example, when
 * reading data from an URLLoader, one would typically queue up another read
 * callback). As a result, this function clears the pointer
 * before the provided callback is executed.
 */
PP_INLINE void PP_RunAndClearCompletionCallback(
    struct PP_CompletionCallback* cc,
    int32_t res) {
  struct PP_CompletionCallback temp = *cc;
  *cc = PP_BlockUntilComplete();
  PP_RunCompletionCallback(&temp, res);
}
/**
 * @}
 */

/* pp_time.idl */
/**
 * @addtogroup Typedefs
 * @{
 */
/**
 * The <code>PP_Time</code> type represents the "wall clock time" according
 * to the browser and is defined as the number of seconds since the Epoch
 * (00:00:00 UTC, January 1, 1970).
 */
typedef double PP_Time;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_Time, 8);

/**
 * A <code>PP_TimeTicks</code> value represents time ticks which are measured
 * in seconds and are used for indicating the time that certain messages were
 * received. In contrast to <code>PP_Time</code>, <code>PP_TimeTicks</code>
 * does not correspond to any actual wall clock time and will not change
 * discontinuously if the user changes their computer clock.
 *
 * The units are in seconds, but are not measured relative to any particular
 * epoch, so the most you can do is compare two values.
 */
typedef double PP_TimeTicks;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_TimeTicks, 8);

/**
 * A <code>PP_TimeDelta</code> value represents a duration of time which is
 * measured in seconds.
 */
typedef double PP_TimeDelta;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_TimeDelta, 8);
/**
 * @}
 */

/* pp_file_info.idl */
/**
 * @addtogroup Enums
 * @{
 */
/**
 * The <code>PP_FileType</code> enum contains file type constants.
 */
typedef enum {
  /** A regular file type */
  PP_FILETYPE_REGULAR = 0,
  /** A directory */
  PP_FILETYPE_DIRECTORY = 1,
  /** A catch-all for unidentified types */
  PP_FILETYPE_OTHER = 2
} PP_FileType;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_FileType, 4);

/**
 * The <code>PP_FileSystemType</code> enum contains file system type constants.
 */
typedef enum {
  /** For identified invalid return values */
  PP_FILESYSTEMTYPE_INVALID = 0,
  /** For external file system types */
  PP_FILESYSTEMTYPE_EXTERNAL = 1,
  /** For local persistent file system types */
  PP_FILESYSTEMTYPE_LOCALPERSISTENT = 2,
  /** For local temporary file system types */
  PP_FILESYSTEMTYPE_LOCALTEMPORARY = 3,
  /** For isolated file system types */
  PP_FILESYSTEMTYPE_ISOLATED = 4
} PP_FileSystemType;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_FileSystemType, 4);
/**
 * @}
 */

/**
 * @addtogroup Structs
 * @{
 */
/**
 * The <code>PP_FileInfo</code> struct represents all information about a file,
 * such as size, type, and creation time.
 */
struct PP_FileInfo {
  /** This value represents the size of the file measured in bytes */
  int64_t size;
  /**
   * This value represents the type of file as defined by the
   * <code>PP_FileType</code> enum
   */
  PP_FileType type;
  /**
   * This value represents the file system type of the file as defined by the
   * <code>PP_FileSystemType</code> enum.
   */
  PP_FileSystemType system_type;
  /**
   * This value represents the creation time of the file.
   */
  PP_Time creation_time;
  /**
   * This value represents the last time the file was accessed.
   */
  PP_Time last_access_time;
  /**
   * This value represents the last time the file was modified.
   */
  PP_Time last_modified_time;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_FileInfo, 40);
/**
 * @}
 */

/* pp_resource.idl */
/**
 * @addtogroup Typedefs
 * @{
 */
/**
 * This typedef represents an opaque handle assigned by the browser to the
 * resource. The handle is guaranteed never to be 0 for a valid resource, so a
 * module can initialize it to 0 to indicate a "NULL handle." Some interfaces
 * may return a NULL resource to indicate failure.
 *
 * While a Var represents something callable to JS or from the module to
 * the DOM, a resource has no meaning or visibility outside of the module
 * interface.
 *
 * Resources are reference counted. Use <code>AddRefResource()</code>
 * and <code>ReleaseResource()</code> in <code>ppb_core.h</code> to manage the
 * reference count of a resource. The data will be automatically destroyed when
 * the internal reference count reaches 0.
 */
typedef int32_t PP_Resource;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_Resource, 4);
/**
 * @}
 */

/* pp_directory_entry.idl */
/**
 * @addtogroup Structs
 * @{
 */
struct PP_DirectoryEntry {
  PP_Resource file_ref;
  PP_FileType file_type;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_DirectoryEntry, 8);
/**
 * @}
 */

/* pp_errors.idl */
/**
 * @addtogroup Enums
 * @{
 */
/**
 * This enumeration contains enumerators of all PPAPI error codes.
 *
 * Errors are negative valued. Callers should treat all negative values as a
 * failure, even if it's not in the list, since the possible errors are likely
 * to expand and change over time.
 */
enum {
  /**
   * This value is returned by a function on successful synchronous completion
   * or is passed as a result to a PP_CompletionCallback_Func on successful
   * asynchronous completion.
   */
  PP_OK = 0,
  /**
   * This value is returned by a function that accepts a PP_CompletionCallback
   * and cannot complete synchronously. This code indicates that the given
   * callback will be asynchronously notified of the final result once it is
   * available.
   */
  PP_OK_COMPLETIONPENDING = -1,
  /**This value indicates failure for unspecified reasons. */
  PP_ERROR_FAILED = -2,
  /**
   * This value indicates failure due to an asynchronous operation being
   * interrupted. The most common cause of this error code is destroying a
   * resource that still has a callback pending. All callbacks are guaranteed
   * to execute, so any callbacks pending on a destroyed resource will be
   * issued with PP_ERROR_ABORTED.
   *
   * If you get an aborted notification that you aren't expecting, check to
   * make sure that the resource you're using is still in scope. A common
   * mistake is to create a resource on the stack, which will destroy the
   * resource as soon as the function returns.
   */
  PP_ERROR_ABORTED = -3,
  /** This value indicates failure due to an invalid argument. */
  PP_ERROR_BADARGUMENT = -4,
  /** This value indicates failure due to an invalid PP_Resource. */
  PP_ERROR_BADRESOURCE = -5,
  /** This value indicates failure due to an unavailable PPAPI interface. */
  PP_ERROR_NOINTERFACE = -6,
  /** This value indicates failure due to insufficient privileges. */
  PP_ERROR_NOACCESS = -7,
  /** This value indicates failure due to insufficient memory. */
  PP_ERROR_NOMEMORY = -8,
  /** This value indicates failure due to insufficient storage space. */
  PP_ERROR_NOSPACE = -9,
  /** This value indicates failure due to insufficient storage quota. */
  PP_ERROR_NOQUOTA = -10,
  /**
   * This value indicates failure due to an action already being in
   * progress.
   */
  PP_ERROR_INPROGRESS = -11,
  /**
   * The requested command is not supported by the browser.
   */
  PP_ERROR_NOTSUPPORTED = -12,
  /**
   * Returned if you try to use a null completion callback to "block until
   * complete" on the main thread. Blocking the main thread is not permitted
   * to keep the browser responsive (otherwise, you may not be able to handle
   * input events, and there are reentrancy and deadlock issues).
   */
  PP_ERROR_BLOCKS_MAIN_THREAD = -13,
  /**
   * This value indicates that the plugin sent bad input data to a resource,
   * leaving it in an invalid state. The resource can't be used after returning
   * this error and should be released.
   */
  PP_ERROR_MALFORMED_INPUT = -14,
  /**
   * This value indicates that a resource has failed.  The resource can't be
   * used after returning this error and should be released.
   */
  PP_ERROR_RESOURCE_FAILED = -15,
  /** This value indicates failure due to a file that does not exist. */
  PP_ERROR_FILENOTFOUND = -20,
  /** This value indicates failure due to a file that already exists. */
  PP_ERROR_FILEEXISTS = -21,
  /** This value indicates failure due to a file that is too big. */
  PP_ERROR_FILETOOBIG = -22,
  /**
   * This value indicates failure due to a file having been modified
   * unexpectedly.
   */
  PP_ERROR_FILECHANGED = -23,
  /** This value indicates that the pathname does not reference a file. */
  PP_ERROR_NOTAFILE = -24,
  /** This value indicates failure due to a time limit being exceeded. */
  PP_ERROR_TIMEDOUT = -30,
  /**
   * This value indicates that the user cancelled rather than providing
   * expected input.
   */
  PP_ERROR_USERCANCEL = -40,
  /**
   * This value indicates failure due to lack of a user gesture such as a
   * mouse click or key input event. Examples of actions requiring a user
   * gesture are showing the file chooser dialog and going into fullscreen
   * mode.
   */
  PP_ERROR_NO_USER_GESTURE = -41,
  /**
   * This value indicates that the graphics context was lost due to a
   * power management event.
   */
  PP_ERROR_CONTEXT_LOST = -50,
  /**
   * Indicates an attempt to make a PPAPI call on a thread without previously
   * registering a message loop via PPB_MessageLoop.AttachToCurrentThread.
   * Without this registration step, no PPAPI calls are supported.
   */
  PP_ERROR_NO_MESSAGE_LOOP = -51,
  /**
   * Indicates that the requested operation is not permitted on the current
   * thread.
   */
  PP_ERROR_WRONG_THREAD = -52,
  /**
   * Indicates that a null completion callback was used on a thread handling a
   * blocking message from JavaScript. Null completion callbacks "block until
   * complete", which could cause the main JavaScript thread to be blocked
   * excessively.
   */
  PP_ERROR_WOULD_BLOCK_THREAD = -53,
  /**
   * This value indicates that the connection was closed. For TCP sockets, it
   * corresponds to a TCP FIN.
   */
  PP_ERROR_CONNECTION_CLOSED = -100,
  /**
   * This value indicates that the connection was reset. For TCP sockets, it
   * corresponds to a TCP RST.
   */
  PP_ERROR_CONNECTION_RESET = -101,
  /**
   * This value indicates that the connection attempt was refused.
   */
  PP_ERROR_CONNECTION_REFUSED = -102,
  /**
   * This value indicates that the connection was aborted. For TCP sockets, it
   * means the connection timed out as a result of not receiving an ACK for data
   * sent. This can include a FIN packet that did not get ACK'd.
   */
  PP_ERROR_CONNECTION_ABORTED = -103,
  /**
   * This value indicates that the connection attempt failed.
   */
  PP_ERROR_CONNECTION_FAILED = -104,
  /**
   * This value indicates that the connection attempt timed out.
   */
  PP_ERROR_CONNECTION_TIMEDOUT = -105,
  /**
   * This value indicates that the IP address or port number is invalid.
   */
  PP_ERROR_ADDRESS_INVALID = -106,
  /**
   * This value indicates that the IP address is unreachable. This usually means
   * that there is no route to the specified host or network.
   */
  PP_ERROR_ADDRESS_UNREACHABLE = -107,
  /**
   * This value is returned when attempting to bind an address that is already
   * in use.
   */
  PP_ERROR_ADDRESS_IN_USE = -108,
  /**
   * This value indicates that the message was too large for the transport.
   */
  PP_ERROR_MESSAGE_TOO_BIG = -109,
  /**
   * This value indicates that the host name could not be resolved.
   */
  PP_ERROR_NAME_NOT_RESOLVED = -110
};
/**
 * @}
 */

/* pp_graphics_3d.idl */
/**
 * @addtogroup Enums
 * @{
 */
typedef enum {
  /**
   * Bits of Alpha in the color buffer.
   */
  PP_GRAPHICS3DATTRIB_ALPHA_SIZE = 0x3021,
  /**
   * Bits of Blue in the color buffer.
   */
  PP_GRAPHICS3DATTRIB_BLUE_SIZE = 0x3022,
  /**
   * Bits of Green in the color buffer.
   */
  PP_GRAPHICS3DATTRIB_GREEN_SIZE = 0x3023,
  /**
   * Bits of Red in the color buffer.
   */
  PP_GRAPHICS3DATTRIB_RED_SIZE = 0x3024,
  /**
   * Bits of Z in the depth buffer.
   */
  PP_GRAPHICS3DATTRIB_DEPTH_SIZE = 0x3025,
  /**
   * Bits of Stencil in the stencil buffer.
   */
  PP_GRAPHICS3DATTRIB_STENCIL_SIZE = 0x3026,
  /**
   * Number of samples per pixel.
   */
  PP_GRAPHICS3DATTRIB_SAMPLES = 0x3031,
  /**
   * Number of multisample buffers.
   */
  PP_GRAPHICS3DATTRIB_SAMPLE_BUFFERS = 0x3032,
  /**
   * Attrib list terminator.
   */
  PP_GRAPHICS3DATTRIB_NONE = 0x3038,
  /**
   * Height of surface in pixels.
   */
  PP_GRAPHICS3DATTRIB_HEIGHT = 0x3056,
  /**
   * Width of surface in pixels.
   */
  PP_GRAPHICS3DATTRIB_WIDTH = 0x3057,
  /**
   * Specifies the effect on the color buffer of posting a surface
   * with SwapBuffers. The initial value is chosen by the implementation.
   */
  PP_GRAPHICS3DATTRIB_SWAP_BEHAVIOR = 0x3093,
  /**
   * Indicates that color buffer contents are unaffected.
   */
  PP_GRAPHICS3DATTRIB_BUFFER_PRESERVED = 0x3094,
  /**
   * Indicates that color buffer contents may be destroyed or changed.
   */
  PP_GRAPHICS3DATTRIB_BUFFER_DESTROYED = 0x3095,
  /**
   * Specifies whether the context is intended to be low-power or
   * high-performance. The initial value is
   * PP_GRAPHICS3DATTRIB_GPU_PREFERENCE_PERFORMANCE.
   */
  PP_GRAPHICS3DATTRIB_GPU_PREFERENCE = 0x11000,
  /**
   * The context should be low-power, and may be created on an integrated gpu.
   */
  PP_GRAPHICS3DATTRIB_GPU_PREFERENCE_LOW_POWER = 0x11001,
  /**
   * The context may be high-power and may be created on a discrete gpu.
   */
  PP_GRAPHICS3DATTRIB_GPU_PREFERENCE_PERFORMANCE = 0x11002
} PP_Graphics3DAttrib;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_Graphics3DAttrib, 4);
/**
 * @}
 */

/* pp_var.idl */
/**
 * @addtogroup Enums
 * @{
 */
/**
 * The <code>PP_VarType</code> is an enumeration of the different types that
 * can be contained within a <code>PP_Var</code> structure.
 */
typedef enum {
  /**
   * An undefined value.
   */
  PP_VARTYPE_UNDEFINED = 0,
  /**
   * A NULL value. This is similar to undefined, but JavaScript differentiates
   * the two so it is exposed here as well.
   */
  PP_VARTYPE_NULL = 1,
  /**
   * A boolean value, use the <code>as_bool</code> member of the var.
   */
  PP_VARTYPE_BOOL = 2,
  /**
   * A 32-bit integer value. Use the <code>as_int</code> member of the var.
   */
  PP_VARTYPE_INT32 = 3,
  /**
   * A double-precision floating point value. Use the <code>as_double</code>
   * member of the var.
   */
  PP_VARTYPE_DOUBLE = 4,
  /**
   * The Var represents a string. The <code>as_id</code> field is used to
   * identify the string, which may be created and retrieved from the
   * <code>PPB_Var</code> interface. These objects are reference counted, so
   * AddRef() and Release() must be used properly to avoid memory leaks.
   */
  PP_VARTYPE_STRING = 5,
  /**
   * Represents a JavaScript object. This vartype is not currently usable
   * from modules, although it is used internally for some tasks. These objects
   * are reference counted, so AddRef() and Release() must be used properly to
   * avoid memory leaks.
   */
  PP_VARTYPE_OBJECT = 6,
  /**
   * Represents an array of Vars. The <code>as_id</code> field is used to
   * identify the array, which may be created and manipulated from the
   * <code>PPB_VarArray</code> interface. These objects are reference counted,
   * so AddRef() and Release() must be used properly to avoid memory leaks.
   */
  PP_VARTYPE_ARRAY = 7,
  /**
   * Represents a mapping from strings to Vars. The <code>as_id</code> field is
   * used to identify the dictionary, which may be created and manipulated from
   * the <code>PPB_VarDictionary</code> interface. These objects are reference
   * counted, so AddRef() and Release() must be used properly to avoid memory
   * leaks.
   */
  PP_VARTYPE_DICTIONARY = 8,
  /**
   * ArrayBuffer represents a JavaScript ArrayBuffer. This is the type which
   * represents Typed Arrays in JavaScript. Unlike JavaScript 'Array', it is
   * only meant to contain basic numeric types, and is always stored
   * contiguously. See PPB_VarArrayBuffer_Dev for functions special to
   * ArrayBuffer vars. These objects are reference counted, so AddRef() and
   * Release() must be used properly to avoid memory leaks.
   */
  PP_VARTYPE_ARRAY_BUFFER = 9,
  /**
   * This type allows the <code>PP_Var</code> to wrap a <code>PP_Resource
   * </code>. This can be useful for sending or receiving some types of
   * <code>PP_Resource</code> using <code>PPB_Messaging</code> or
   * <code>PPP_Messaging</code>.
   *
   * These objects are reference counted, so AddRef() and Release() must be used
   * properly to avoid memory leaks. Under normal circumstances, the
   * <code>PP_Var</code> will implicitly hold a reference count on the
   * <code>PP_Resource</code> on your behalf. For example, if you call
   * VarFromResource(), it implicitly calls PPB_Core::AddRefResource() on the
   * <code>PP_Resource</code>. Likewise, PPB_Var::Release() on a Resource
   * <code>PP_Var</code> will invoke PPB_Core::ReleaseResource() when the Var
   * reference count goes to zero.
   */
  PP_VARTYPE_RESOURCE = 10
} PP_VarType;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_VarType, 4);
/**
 * @}
 */

/**
 * @addtogroup Structs
 * @{
 */
/**
 * The PP_VarValue union stores the data for any one of the types listed
 * in the PP_VarType enum.
 */
union PP_VarValue {
  /**
   * If <code>type</code> is <code>PP_VARTYPE_BOOL</code>,
   * <code>as_bool</code> represents the value of this <code>PP_Var</code> as
   * <code>PP_Bool</code>.
   */
  PP_Bool as_bool;
  /**
   * If <code>type</code> is <code>PP_VARTYPE_INT32</code>,
   * <code>as_int</code> represents the value of this <code>PP_Var</code> as
   * <code>int32_t</code>.
   */
  int32_t as_int;
  /**
   * If <code>type</code> is <code>PP_VARTYPE_DOUBLE</code>,
   * <code>as_double</code> represents the value of this <code>PP_Var</code>
   * as <code>double</code>.
   */
  double as_double;
  /**
   * If <code>type</code> is <code>PP_VARTYPE_STRING</code>,
   * <code>PP_VARTYPE_OBJECT</code>, <code>PP_VARTYPE_ARRAY</code>,
   * <code>PP_VARTYPE_DICTIONARY</code>, <code>PP_VARTYPE_ARRAY_BUFFER</code>,
   * or <code>PP_VARTYPE_RESOURCE</code>, <code>as_id</code> represents the
   * value of this <code>PP_Var</code> as an opaque handle assigned by the
   * browser. This handle is guaranteed never to be 0, so a module can
   * initialize this ID to 0 to indicate a "NULL handle."
   */
  int64_t as_id;
};

/**
 * The <code>PP_VAR</code> struct is a variant data type and can contain any
 * value of one of the types named in the <code>PP_VarType</code> enum. This
 * structure is for passing data between native code which can be strongly
 * typed and the browser (JavaScript) which isn't strongly typed.
 *
 * JavaScript has a "number" type for holding a number, and does not
 * differentiate between floating point and integer numbers. The
 * JavaScript operations will try to optimize operations by using
 * integers when possible, but could end up with doubles. Therefore,
 * you can't assume a numeric <code>PP_Var</code> will be the type you expect.
 * Your code should be capable of handling either int32_t or double for numeric
 * PP_Vars sent from JavaScript.
 */
struct PP_Var {
  PP_VarType type;
  /**
   * The <code>padding</code> ensures <code>value</code> is aligned on an
   * 8-byte boundary relative to the start of the struct. Some compilers
   * align doubles on 8-byte boundaries for 32-bit x86, and some align on
   * 4-byte boundaries.
   */
  int32_t padding;
  /**
   * This <code>value</code> represents the contents of the PP_Var. Only one of
   * the fields of <code>value</code> is valid at a time based upon
   * <code>type</code>.
   */
  union PP_VarValue value;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_Var, 16);
/**
 * @}
 */

/**
 * @addtogroup Functions
 * @{
 */

/**
 * PP_MakeUndefined() is used to wrap an undefined value into a
 * <code>PP_Var</code> struct for passing to the browser.
 *
 * @return A <code>PP_Var</code> structure.
 */
PP_INLINE struct PP_Var PP_MakeUndefined(void) {
  struct PP_Var result = { PP_VARTYPE_UNDEFINED, 0, {PP_FALSE} };
  return result;
}

/**
 * PP_MakeNull() is used to wrap a null value into a
 * <code>PP_Var</code> struct for passing to the browser.
 *
 * @return A <code>PP_Var</code> structure,
 */
PP_INLINE struct PP_Var PP_MakeNull(void) {
  struct PP_Var result = { PP_VARTYPE_NULL, 0, {PP_FALSE} };
  return result;
}

/**
 * PP_MakeBool() is used to wrap a boolean value into a
 * <code>PP_Var</code> struct for passing to the browser.
 *
 * @param[in] value A <code>PP_Bool</code> enumeration to
 * wrap.
 *
 * @return A <code>PP_Var</code> structure.
 */
PP_INLINE struct PP_Var PP_MakeBool(PP_Bool value) {
  struct PP_Var result = { PP_VARTYPE_BOOL, 0, {PP_FALSE} };
  result.value.as_bool = value;
  return result;
}

/**
 * PP_MakeInt32() is used to wrap a 32 bit integer value
 * into a <code>PP_Var</code> struct for passing to the browser.
 *
 * @param[in] value An int32 to wrap.
 *
 * @return A <code>PP_Var</code> structure.
 */
PP_INLINE struct PP_Var PP_MakeInt32(int32_t value) {
  struct PP_Var result = { PP_VARTYPE_INT32, 0, {PP_FALSE} };
  result.value.as_int = value;
  return result;
}

/**
 * PP_MakeDouble() is used to wrap a double value into a
 * <code>PP_Var</code> struct for passing to the browser.
 *
 * @param[in] value A double to wrap.
 *
 * @return A <code>PP_Var</code> structure.
 */
PP_INLINE struct PP_Var PP_MakeDouble(double value) {
  struct PP_Var result = { PP_VARTYPE_DOUBLE, 0, {PP_FALSE} };
  result.value.as_double = value;
  return result;
}
/**
 * @}
 */

/* pp_touch_point.idl */
/**
 * @addtogroup Structs
 * @{
 */
/**
 * The <code>PP_TouchPoint</code> struct represents all information about a
 * single touch point, such as position, id, rotation angle, and pressure.
 */
struct PP_TouchPoint {
  /**
   * This value represents the identifier for this TouchPoint. The id
   * corresponds to the order in which the points were pressed. For example,
   * the first point to be pressed has an id of 0, the second has an id of 1,
   * and so on. An id can be reused when a touch point is released.  For
   * example, if two fingers are down, with id 0 and 1, and finger 0 releases,
   * the next finger to be pressed can be assigned to id 0.
   */
  uint32_t id;
  /**
   * This value represents the x and y pixel position of this TouchPoint
   * relative to the upper-left of the module instance receiving the event.
   */
  struct PP_FloatPoint position;
  /**
   * This value represents the elliptical radii, in screen pixels, in the x
   * and y direction of this TouchPoint.
   */
  struct PP_FloatPoint radius;
  /**
   * This value represents the angle of rotation in degrees of the elliptical
   * model of this TouchPoint clockwise from "up."
   */
  float rotation_angle;
  /**
   * This value represents the pressure applied to this TouchPoint.  This value
   * is typically between 0 and 1, with 0 indicating no pressure and 1
   * indicating some maximum pressure. Scaling differs depending on the
   * hardware and the value is not guaranteed to stay within that range.
   */
  float pressure;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_TouchPoint, 28);
/**
 * @}
 */

/**
 * @addtogroup Functions
 * @{
 */

/**
 * PP_MakeTouchPoint() creates a <code>PP_TouchPoint</code>.
 *
 * @return A <code>PP_TouchPoint</code> structure.
 */
PP_INLINE struct PP_TouchPoint PP_MakeTouchPoint(void) {
  struct PP_TouchPoint result = { 0, {0, 0}, {0, 0}, 0, 0 };
  return result;
}
/**
 * @}
 */

/* pp_instance.idl */
/**
 * @addtogroup Typedefs
 * @{
 */
/**
 * The <code>PP_Instance</code> value uniquely identifies one instance of a
 * module (.nexe/PP_Module). There will be one module instance for every
 * \<embed> tag on a page.
 *
 * This identifier is an opaque handle assigned by the browser to the module.
 * It is guaranteed never to be 0, so a module can initialize it to 0 to
 * indicate a "NULL handle."
 */
typedef int32_t PP_Instance;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_Instance, 4);
/**
 * @}
 */

/* ppb_input_event.idl */
/**
 * @addtogroup Enums
 * @{
 */
/**
 * This enumeration contains the types of input events.
 */
typedef enum {
  PP_INPUTEVENT_TYPE_UNDEFINED = -1,
  /**
   * Notification that a mouse button was pressed.
   *
   * Register for this event using the PP_INPUTEVENT_CLASS_MOUSE class.
   */
  PP_INPUTEVENT_TYPE_MOUSEDOWN = 0,
  /**
   * Notification that a mouse button was released.
   *
   * Register for this event using the PP_INPUTEVENT_CLASS_MOUSE class.
   */
  PP_INPUTEVENT_TYPE_MOUSEUP = 1,
  /**
   * Notification that a mouse button was moved when it is over the instance
   * or dragged out of it.
   *
   * Register for this event using the PP_INPUTEVENT_CLASS_MOUSE class.
   */
  PP_INPUTEVENT_TYPE_MOUSEMOVE = 2,
  /**
   * Notification that the mouse entered the instance's bounds.
   *
   * Register for this event using the PP_INPUTEVENT_CLASS_MOUSE class.
   */
  PP_INPUTEVENT_TYPE_MOUSEENTER = 3,
  /**
   * Notification that a mouse left the instance's bounds.
   *
   * Register for this event using the PP_INPUTEVENT_CLASS_MOUSE class.
   */
  PP_INPUTEVENT_TYPE_MOUSELEAVE = 4,
  /**
   * Notification that the scroll wheel was used.
   *
   * Register for this event using the PP_INPUTEVENT_CLASS_WHEEL class.
   */
  PP_INPUTEVENT_TYPE_WHEEL = 5,
  /**
   * Notification that a key transitioned from "up" to "down".
   *
   * Register for this event using the PP_INPUTEVENT_CLASS_KEYBOARD class.
   */
  PP_INPUTEVENT_TYPE_RAWKEYDOWN = 6,
  /**
   * Notification that a key was pressed. This does not necessarily correspond
   * to a character depending on the key and language. Use the
   * PP_INPUTEVENT_TYPE_CHAR for character input.
   *
   * Register for this event using the PP_INPUTEVENT_CLASS_KEYBOARD class.
   */
  PP_INPUTEVENT_TYPE_KEYDOWN = 7,
  /**
   * Notification that a key was released.
   *
   * Register for this event using the PP_INPUTEVENT_CLASS_KEYBOARD class.
   */
  PP_INPUTEVENT_TYPE_KEYUP = 8,
  /**
   * Notification that a character was typed. Use this for text input. Key
   * down events may generate 0, 1, or more than one character event depending
   * on the key, locale, and operating system.
   *
   * Register for this event using the PP_INPUTEVENT_CLASS_KEYBOARD class.
   */
  PP_INPUTEVENT_TYPE_CHAR = 9,
  /**
   * Notification that a context menu should be shown.
   *
   * This message will be sent when the user right-clicks or performs another
   * OS-specific mouse command that should open a context menu. When this event
   * is delivered depends on the system, on some systems (Mac) it will
   * delivered after the mouse down event, and on others (Windows) it will be
   * delivered after the mouse up event.
   *
   * You will always get the normal mouse events. For example, you may see
   * MOUSEDOWN,CONTEXTMENU,MOUSEUP or MOUSEDOWN,MOUSEUP,CONTEXTMENU.
   *
   * The return value from the event handler determines if the context menu
   * event will be passed to the page when you are using filtered input events
   * (via RequestFilteringInputEvents()). In non-filtering mode the event will
   * never be propagated and no context menu will be displayed. If you are
   * handling mouse events in filtering mode, you may want to return true from
   * this event even if you do not support a context menu to suppress the
   * default one.
   *
   * Register for this event using the PP_INPUTEVENT_CLASS_MOUSE class.
   */
  PP_INPUTEVENT_TYPE_CONTEXTMENU = 10,
  /**
   * Notification that an input method composition process has just started.
   *
   * Register for this event using the PP_INPUTEVENT_CLASS_IME class.
   */
  PP_INPUTEVENT_TYPE_IME_COMPOSITION_START = 11,
  /**
   * Notification that the input method composition string is updated.
   *
   * Register for this event using the PP_INPUTEVENT_CLASS_IME class.
   */
  PP_INPUTEVENT_TYPE_IME_COMPOSITION_UPDATE = 12,
  /**
   * Notification that an input method composition process has completed.
   *
   * Register for this event using the PP_INPUTEVENT_CLASS_IME class.
   */
  PP_INPUTEVENT_TYPE_IME_COMPOSITION_END = 13,
  /**
   * Notification that an input method committed a string.
   *
   * Register for this event using the PP_INPUTEVENT_CLASS_IME class.
   */
  PP_INPUTEVENT_TYPE_IME_TEXT = 14,
  /**
   * Notification that a finger was placed on a touch-enabled device.
   *
   * Register for this event using the PP_INPUTEVENT_CLASS_TOUCH class.
   */
  PP_INPUTEVENT_TYPE_TOUCHSTART = 15,
  /**
   * Notification that a finger was moved on a touch-enabled device.
   *
   * Register for this event using the PP_INPUTEVENT_CLASS_TOUCH class.
   */
  PP_INPUTEVENT_TYPE_TOUCHMOVE = 16,
  /**
   * Notification that a finger was released on a touch-enabled device.
   *
   * Register for this event using the PP_INPUTEVENT_CLASS_TOUCH class.
   */
  PP_INPUTEVENT_TYPE_TOUCHEND = 17,
  /**
   * Notification that a touch event was canceled.
   *
   * Register for this event using the PP_INPUTEVENT_CLASS_TOUCH class.
   */
  PP_INPUTEVENT_TYPE_TOUCHCANCEL = 18
} PP_InputEvent_Type;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_InputEvent_Type, 4);

/**
 * This enumeration contains event modifier constants. Each modifier is one
 * bit. Retrieve the modifiers from an input event using the GetEventModifiers
 * function on PPB_InputEvent.
 */
typedef enum {
  PP_INPUTEVENT_MODIFIER_SHIFTKEY = 1 << 0,
  PP_INPUTEVENT_MODIFIER_CONTROLKEY = 1 << 1,
  PP_INPUTEVENT_MODIFIER_ALTKEY = 1 << 2,
  PP_INPUTEVENT_MODIFIER_METAKEY = 1 << 3,
  PP_INPUTEVENT_MODIFIER_ISKEYPAD = 1 << 4,
  PP_INPUTEVENT_MODIFIER_ISAUTOREPEAT = 1 << 5,
  PP_INPUTEVENT_MODIFIER_LEFTBUTTONDOWN = 1 << 6,
  PP_INPUTEVENT_MODIFIER_MIDDLEBUTTONDOWN = 1 << 7,
  PP_INPUTEVENT_MODIFIER_RIGHTBUTTONDOWN = 1 << 8,
  PP_INPUTEVENT_MODIFIER_CAPSLOCKKEY = 1 << 9,
  PP_INPUTEVENT_MODIFIER_NUMLOCKKEY = 1 << 10,
  PP_INPUTEVENT_MODIFIER_ISLEFT = 1 << 11,
  PP_INPUTEVENT_MODIFIER_ISRIGHT = 1 << 12,
  PP_INPUTEVENT_MODIFIER_ISPEN = 1 << 13,
  PP_INPUTEVENT_MODIFIER_ISERASER = 1 << 14
} PP_InputEvent_Modifier;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_InputEvent_Modifier, 4);

/**
 * This enumeration contains constants representing each mouse button. To get
 * the mouse button for a mouse down or up event, use GetMouseButton on
 * PPB_InputEvent.
 */
typedef enum {
  PP_INPUTEVENT_MOUSEBUTTON_NONE = -1,
  PP_INPUTEVENT_MOUSEBUTTON_LEFT = 0,
  PP_INPUTEVENT_MOUSEBUTTON_MIDDLE = 1,
  PP_INPUTEVENT_MOUSEBUTTON_RIGHT = 2
} PP_InputEvent_MouseButton;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_InputEvent_MouseButton, 4);

typedef enum {
  /**
   * Request mouse input events.
   *
   * Normally you will request mouse events by calling RequestInputEvents().
   * The only use case for filtered events (via RequestFilteringInputEvents())
   * is for instances that have irregular outlines and you want to perform hit
   * testing, which is very uncommon. Requesting non-filtered mouse events will
   * lead to higher performance.
   */
  PP_INPUTEVENT_CLASS_MOUSE = 1 << 0,
  /**
   * Requests keyboard events. Often you will want to request filtered mode
   * (via RequestFilteringInputEvents) for keyboard events so you can pass on
   * events (by returning false) that you don't handle. For example, if you
   * don't request filtered mode and the user pressed "Page Down" when your
   * instance has focus, the page won't scroll which will be a poor experience.
   *
   * A small number of tab and window management commands like Alt-F4 are never
   * sent to the page. You can not request these keyboard commands since it
   * would allow pages to trap users on a page.
   */
  PP_INPUTEVENT_CLASS_KEYBOARD = 1 << 1,
  /**
   * Identifies scroll wheel input event. Wheel events must be requested in
   * filtering mode via RequestFilteringInputEvents(). This is because many
   * wheel commands should be forwarded to the page.
   *
   * Most instances will not need this event. Consuming wheel events by
   * returning true from your filtered event handler will prevent the user from
   * scrolling the page when the mouse is over the instance which can be very
   * annoying.
   *
   * If you handle wheel events (for example, you have a document viewer which
   * the user can scroll), the recommended behavior is to return false only if
   * the wheel event actually causes your document to scroll. When the user
   * reaches the end of the document, return false to indicating that the event
   * was not handled. This will then forward the event to the containing page
   * for scrolling, producing the nested scrolling behavior users expect from
   * frames in a page.
   */
  PP_INPUTEVENT_CLASS_WHEEL = 1 << 2,
  /**
   * Identifies touch input events.
   *
   * Request touch events only if you intend to handle them. If the browser
   * knows you do not need to handle touch events, it can handle them at a
   * higher level and achieve higher performance. If the plugin does not
   * register for touch-events, then it will receive synthetic mouse events that
   * are generated from the touch events (e.g. mouse-down for touch-start,
   * mouse-move for touch-move (with left-button down), and mouse-up for
   * touch-end. If the plugin does register for touch events, then the synthetic
   * mouse events are not created.
   */
  PP_INPUTEVENT_CLASS_TOUCH = 1 << 3,
  /**
   * Identifies IME composition input events.
   *
   * Request this input event class if you allow on-the-spot IME input.
   */
  PP_INPUTEVENT_CLASS_IME = 1 << 4
} PP_InputEvent_Class;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_InputEvent_Class, 4);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPB_InputEvent</code> interface contains pointers to several
 * functions related to generic input events on the browser.
 */
struct PPB_InputEvent_1_0 {
  /**
   * RequestInputEvent() requests that input events corresponding to the given
   * input events are delivered to the instance.
   *
   * It's recommended that you use RequestFilteringInputEvents() for keyboard
   * events instead of this function so that you don't interfere with normal
   * browser accelerators.
   *
   * By default, no input events are delivered. Call this function with the
   * classes of events you are interested in to have them be delivered to
   * the instance. Calling this function will override any previous setting for
   * each specified class of input events (for example, if you previously
   * called RequestFilteringInputEvents(), this function will set those events
   * to non-filtering mode).
   *
   * Input events may have high overhead, so you should only request input
   * events that your plugin will actually handle. For example, the browser may
   * do optimizations for scroll or touch events that can be processed
   * substantially faster if it knows there are no non-default receivers for
   * that message. Requesting that such messages be delivered, even if they are
   * processed very quickly, may have a noticeable effect on the performance of
   * the page.
   *
   * Note that synthetic mouse events will be generated from touch events if
   * (and only if) you do not request touch events.
   *
   * When requesting input events through this function, the events will be
   * delivered and <i>not</i> bubbled to the default handlers.
   *
   * <strong>Example:</strong>
   * @code
   *   RequestInputEvents(instance, PP_INPUTEVENT_CLASS_MOUSE);
   *   RequestFilteringInputEvents(instance,
   *       PP_INPUTEVENT_CLASS_WHEEL | PP_INPUTEVENT_CLASS_KEYBOARD);
   * @endcode
   *
   * @param instance The <code>PP_Instance</code> of the instance requesting
   * the given events.
   *
   * @param event_classes A combination of flags from
   * <code>PP_InputEvent_Class</code> that identifies the classes of events the
   * instance is requesting. The flags are combined by logically ORing their
   * values.
   *
   * @return <code>PP_OK</code> if the operation succeeded,
   * <code>PP_ERROR_BADARGUMENT</code> if instance is invalid, or
   * <code>PP_ERROR_NOTSUPPORTED</code> if one of the event class bits were
   * illegal. In the case of an invalid bit, all valid bits will be applied
   * and only the illegal bits will be ignored. The most common cause of a
   * <code>PP_ERROR_NOTSUPPORTED</code> return value is requesting keyboard
   * events, these must use RequestFilteringInputEvents().
   */
  int32_t (*RequestInputEvents)(PP_Instance instance, uint32_t event_classes);
  /**
   * RequestFilteringInputEvents() requests that input events corresponding to
   * the given input events are delivered to the instance for filtering.
   *
   * By default, no input events are delivered. In most cases you would
   * register to receive events by calling RequestInputEvents(). In some cases,
   * however, you may wish to filter events such that they can be bubbled up
   * to the default handlers. In this case, register for those classes of
   * events using this function instead of RequestInputEvents().
   *
   * Filtering input events requires significantly more overhead than just
   * delivering them to the instance. As such, you should only request
   * filtering in those cases where it's absolutely necessary. The reason is
   * that it requires the browser to stop and block for the instance to handle
   * the input event, rather than sending the input event asynchronously. This
   * can have significant overhead.
   *
   * <strong>Example:</strong>
   * @code
   *   RequestInputEvents(instance, PP_INPUTEVENT_CLASS_MOUSE);
   *   RequestFilteringInputEvents(instance,
   *       PP_INPUTEVENT_CLASS_WHEEL | PP_INPUTEVENT_CLASS_KEYBOARD);
   * @endcode
   *
   * @return <code>PP_OK</code> if the operation succeeded,
   * <code>PP_ERROR_BADARGUMENT</code> if instance is invalid, or
   * <code>PP_ERROR_NOTSUPPORTED</code> if one of the event class bits were
   * illegal. In the case of an invalid bit, all valid bits will be applied
   * and only the illegal bits will be ignored.
   */
  int32_t (*RequestFilteringInputEvents)(PP_Instance instance,
                                         uint32_t event_classes);
  /**
   * ClearInputEventRequest() requests that input events corresponding to the
   * given input classes no longer be delivered to the instance.
   *
   * By default, no input events are delivered. If you have previously
   * requested input events via RequestInputEvents() or
   * RequestFilteringInputEvents(), this function will unregister handling
   * for the given instance. This will allow greater browser performance for
   * those events.
   *
   * Note that you may still get some input events after clearing the flag if
   * they were dispatched before the request was cleared. For example, if
   * there are 3 mouse move events waiting to be delivered, and you clear the
   * mouse event class during the processing of the first one, you'll still
   * receive the next two. You just won't get more events generated.
   *
   * @param instance The <code>PP_Instance</code> of the instance requesting
   * to no longer receive the given events.
   *
   * @param event_classes A combination of flags from
   * <code>PP_InputEvent_Class</code> that identify the classes of events the
   * instance is no longer interested in.
   */
  void (*ClearInputEventRequest)(PP_Instance instance, uint32_t event_classes);
  /**
   * IsInputEvent() returns true if the given resource is a valid input event
   * resource.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to a generic
   * resource.
   *
   * @return <code>PP_TRUE</code> if the given resource is a valid input event
   * resource.
   */
  PP_Bool (*IsInputEvent)(PP_Resource resource);
  /**
   * GetType() returns the type of input event for the given input event
   * resource.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to an input
   * event.
   *
   * @return A <code>PP_InputEvent_Type</code> if its a valid input event or
   * <code>PP_INPUTEVENT_TYPE_UNDEFINED</code> if the resource is invalid.
   */
  PP_InputEvent_Type (*GetType)(PP_Resource event);
  /**
   * GetTimeStamp() Returns the time that the event was generated. This will be
   *  before the current time since processing and dispatching the event has
   * some overhead. Use this value to compare the times the user generated two
   * events without being sensitive to variable processing time.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to the event.
   *
   * @return The return value is in time ticks, which is a monotonically
   * increasing clock not related to the wall clock time. It will not change
   * if the user changes their clock or daylight savings time starts, so can
   * be reliably used to compare events. This means, however, that you can't
   * correlate event times to a particular time of day on the system clock.
   */
  PP_TimeTicks (*GetTimeStamp)(PP_Resource event);
  /**
   * GetModifiers() returns a bitfield indicating which modifiers were down
   * at the time of the event. This is a combination of the flags in the
   * <code>PP_InputEvent_Modifier</code> enum.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to an input
   * event.
   *
   * @return The modifiers associated with the event, or 0 if the given
   * resource is not a valid event resource.
   */
  uint32_t (*GetModifiers)(PP_Resource event);
};

typedef struct PPB_InputEvent_1_0 PPB_InputEvent;

/**
 * The <code>PPB_MouseInputEvent</code> interface contains pointers to several
 * functions related to mouse input events.
 */
struct PPB_MouseInputEvent_1_1 {
  /**
   * Create() creates a mouse input event with the given parameters. Normally
   * you will get a mouse event passed through the
   * <code>HandleInputEvent</code> and will not need to create them, but some
   * applications may want to create their own for internal use. The type must
   * be one of the mouse event types.
   *
   * @param[in] instance The instance for which this event occurred.
   *
   * @param[in] type A <code>PP_InputEvent_Type</code> identifying the type of
   * input event.
   *
   * @param[in] time_stamp A <code>PP_TimeTicks</code> indicating the time
   * when the event occurred.
   *
   * @param[in] modifiers A bit field combination of the
   * <code>PP_InputEvent_Modifier</code> flags.
   *
   * @param[in] mouse_button The button that changed for mouse down or up
   * events. This value will be <code>PP_EVENT_MOUSEBUTTON_NONE</code> for
   * mouse move, enter, and leave events.
   *
   * @param[in] mouse_position A <code>Point</code> containing the x and y
   * position of the mouse when the event occurred.
   *
   * @param[in] mouse_movement The change in position of the mouse.
   *
   * @return A <code>PP_Resource</code> containing the new mouse input event.
   */
  PP_Resource (*Create)(PP_Instance instance,
                        PP_InputEvent_Type type,
                        PP_TimeTicks time_stamp,
                        uint32_t modifiers,
                        PP_InputEvent_MouseButton mouse_button,
                        const struct PP_Point* mouse_position,
                        int32_t click_count,
                        const struct PP_Point* mouse_movement);
  /**
   * IsMouseInputEvent() determines if a resource is a mouse event.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to an event.
   *
   * @return <code>PP_TRUE</code> if the given resource is a valid mouse input
   * event, otherwise <code>PP_FALSE</code>.
   */
  PP_Bool (*IsMouseInputEvent)(PP_Resource resource);
  /**
   * GetButton() returns the mouse button that generated a mouse down or up
   * event.
   *
   * @param[in] mouse_event A <code>PP_Resource</code> corresponding to a
   * mouse event.
   *
   * @return The mouse button associated with mouse down and up events. This
   * value will be <code>PP_EVENT_MOUSEBUTTON_NONE</code> for mouse move,
   * enter, and leave events, and for all non-mouse events.
   */
  PP_InputEvent_MouseButton (*GetButton)(PP_Resource mouse_event);
  /**
   * GetPosition() returns the pixel location of a mouse input event. When
   * the mouse is locked, it returns the last known mouse position just as
   * mouse lock was entered.
   *
   * @param[in] mouse_event A <code>PP_Resource</code> corresponding to a
   * mouse event.
   *
   * @return The point associated with the mouse event, relative to the upper-
   * left of the instance receiving the event. These values can be negative for
   * mouse drags. The return value will be (0, 0) for non-mouse events.
   */
  struct PP_Point (*GetPosition)(PP_Resource mouse_event);
  int32_t (*GetClickCount)(PP_Resource mouse_event);
  /**
   * Returns the change in position of the mouse. When the mouse is locked,
   * although the mouse position doesn't actually change, this function
   * still provides movement information, which indicates what the change in
   * position would be had the mouse not been locked.
   *
   * @param[in] mouse_event A <code>PP_Resource</code> corresponding to a
   * mouse event.
   *
   * @return The change in position of the mouse, relative to the previous
   * position.
   */
  struct PP_Point (*GetMovement)(PP_Resource mouse_event);
};

typedef struct PPB_MouseInputEvent_1_1 PPB_MouseInputEvent;

struct PPB_MouseInputEvent_1_0 {
  PP_Resource (*Create)(PP_Instance instance,
                        PP_InputEvent_Type type,
                        PP_TimeTicks time_stamp,
                        uint32_t modifiers,
                        PP_InputEvent_MouseButton mouse_button,
                        const struct PP_Point* mouse_position,
                        int32_t click_count);
  PP_Bool (*IsMouseInputEvent)(PP_Resource resource);
  PP_InputEvent_MouseButton (*GetButton)(PP_Resource mouse_event);
  struct PP_Point (*GetPosition)(PP_Resource mouse_event);
  int32_t (*GetClickCount)(PP_Resource mouse_event);
};

/**
 * The <code>PPB_WheelIputEvent</code> interface contains pointers to several
 * functions related to wheel input events.
 */
struct PPB_WheelInputEvent_1_0 {
  /**
   * Create() creates a wheel input event with the given parameters. Normally
   * you will get a wheel event passed through the
   * <code>HandleInputEvent</code> and will not need to create them, but some
   * applications may want to create their own for internal use.
   *
   * @param[in] instance The instance for which this event occurred.
   *
   * @param[in] time_stamp A <code>PP_TimeTicks</code> indicating the time
   * when the event occurred.
   *
   * @param[in] modifiers A bit field combination of the
   * <code>PP_InputEvent_Modifier</code> flags.
   *
   * @param[in] wheel_delta The scroll wheel's horizontal and vertical scroll
   * amounts.
   *
   * @param[in] wheel_ticks The number of "clicks" of the scroll wheel that
   * have produced the event.
   *
   * @param[in] scroll_by_page When true, the user is requesting to scroll
   * by pages. When false, the user is requesting to scroll by lines.
   *
   * @return A <code>PP_Resource</code> containing the new wheel input event.
   */
  PP_Resource (*Create)(PP_Instance instance,
                        PP_TimeTicks time_stamp,
                        uint32_t modifiers,
                        const struct PP_FloatPoint* wheel_delta,
                        const struct PP_FloatPoint* wheel_ticks,
                        PP_Bool scroll_by_page);
  /**
   * IsWheelInputEvent() determines if a resource is a wheel event.
   *
   * @param[in] wheel_event A <code>PP_Resource</code> corresponding to an
   * event.
   *
   * @return <code>PP_TRUE</code> if the given resource is a valid wheel input
   * event.
   */
  PP_Bool (*IsWheelInputEvent)(PP_Resource resource);
  /**
   * GetDelta() returns the amount vertically and horizontally the user has
   * requested to scroll by with their mouse wheel. A scroll down or to the
   * right (where the content moves up or left) is represented as positive
   * values, and a scroll up or to the left (where the content moves down or
   * right) is represented as negative values.
   *
   * This amount is system dependent and will take into account the user's
   * preferred scroll sensitivity and potentially also nonlinear acceleration
   * based on the speed of the scrolling.
   *
   * Devices will be of varying resolution. Some mice with large detents will
   * only generate integer scroll amounts. But fractional values are also
   * possible, for example, on some trackpads and newer mice that don't have
   * "clicks".
   *
   * @param[in] wheel_event A <code>PP_Resource</code> corresponding to a wheel
   * event.
   *
   * @return The vertical and horizontal scroll values. The units are either in
   * pixels (when scroll_by_page is false) or pages (when scroll_by_page is
   * true). For example, y = -3 means scroll up 3 pixels when scroll_by_page
   * is false, and scroll up 3 pages when scroll_by_page is true.
   */
  struct PP_FloatPoint (*GetDelta)(PP_Resource wheel_event);
  /**
   * GetTicks() returns the number of "clicks" of the scroll wheel
   * that have produced the event. The value may have system-specific
   * acceleration applied to it, depending on the device. The positive and
   * negative meanings are the same as for GetDelta().
   *
   * If you are scrolling, you probably want to use the delta values.  These
   * tick events can be useful if you aren't doing actual scrolling and don't
   * want or pixel values. An example may be cycling between different items in
   * a game.
   *
   * @param[in] wheel_event A <code>PP_Resource</code> corresponding to a wheel
   * event.
   *
   * @return The number of "clicks" of the scroll wheel. You may receive
   * fractional values for the wheel ticks if the mouse wheel is high
   * resolution or doesn't have "clicks". If your program wants discrete
   * events (as in the "picking items" example) you should accumulate
   * fractional click values from multiple messages until the total value
   * reaches positive or negative one. This should represent a similar amount
   * of scrolling as for a mouse that has a discrete mouse wheel.
   */
  struct PP_FloatPoint (*GetTicks)(PP_Resource wheel_event);
  /**
   * GetScrollByPage() indicates if the scroll delta x/y indicates pages or
   * lines to scroll by.
   *
   * @param[in] wheel_event A <code>PP_Resource</code> corresponding to a wheel
   * event.
   *
   * @return <code>PP_TRUE</code> if the event is a wheel event and the user is
   * scrolling by pages. <code>PP_FALSE</code> if not or if the resource is not
   * a wheel event.
   */
  PP_Bool (*GetScrollByPage)(PP_Resource wheel_event);
};

typedef struct PPB_WheelInputEvent_1_0 PPB_WheelInputEvent;

/**
 * The <code>PPB_KeyboardInputEvent</code> interface contains pointers to
 * several functions related to keyboard input events.
 */
struct PPB_KeyboardInputEvent_1_2 {
  /**
   * Creates a keyboard input event with the given parameters. Normally you
   * will get a keyboard event passed through the HandleInputEvent and will not
   * need to create them, but some applications may want to create their own
   * for internal use. The type must be one of the keyboard event types.
   *
   * @param[in] instance The instance for which this event occurred.
   *
   * @param[in] type A <code>PP_InputEvent_Type</code> identifying the type of
   * input event.
   *
   * @param[in] time_stamp A <code>PP_TimeTicks</code> indicating the time
   * when the event occurred.
   *
   * @param[in] modifiers A bit field combination of the
   * <code>PP_InputEvent_Modifier</code> flags.
   *
   * @param[in] key_code This value reflects the DOM KeyboardEvent
   * <code>keyCode</code> field, which is the Windows-style Virtual Key
   * code of the key.
   *
   * @param[in] character_text This value represents the typed character as a
   * UTF-8 string.
   *
   * @param[in] code This value represents the DOM3 |code| string that
   * corresponds to the physical key being pressed.
   *
   * @return A <code>PP_Resource</code> containing the new keyboard input
   * event.
   */
  PP_Resource (*Create)(PP_Instance instance,
                        PP_InputEvent_Type type,
                        PP_TimeTicks time_stamp,
                        uint32_t modifiers,
                        uint32_t key_code,
                        struct PP_Var character_text,
                        struct PP_Var code);
  /**
   * IsKeyboardInputEvent() determines if a resource is a keyboard event.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to an event.
   *
   * @return <code>PP_TRUE</code> if the given resource is a valid input event.
   */
  PP_Bool (*IsKeyboardInputEvent)(PP_Resource resource);
  /**
   * GetKeyCode() returns the DOM keyCode field for the keyboard event.
   * Chrome populates this with the Windows-style Virtual Key code of the key.
   *
   * @param[in] key_event A <code>PP_Resource</code> corresponding to a
   * keyboard event.
   *
   * @return The DOM keyCode field for the keyboard event.
   */
  uint32_t (*GetKeyCode)(PP_Resource key_event);
  /**
   * GetCharacterText() returns the typed character as a UTF-8 string for the
   * given character event.
   *
   * @param[in] character_event A <code>PP_Resource</code> corresponding to a
   * keyboard event.
   *
   * @return A string var representing a single typed character for character
   * input events. For non-character input events the return value will be an
   * undefined var.
   */
  struct PP_Var (*GetCharacterText)(PP_Resource character_event);
  /**
   * GetCode() returns the DOM |code| field for this keyboard event, as
   * defined in the DOM3 Events spec:
   * http://www.w3.org/TR/DOM-Level-3-Events/
   *
   * @param[in] key_event The key event for which to return the key code.
   *
   * @return The string that contains the DOM |code| for the keyboard event.
   */
  struct PP_Var (*GetCode)(PP_Resource key_event);
};

typedef struct PPB_KeyboardInputEvent_1_2 PPB_KeyboardInputEvent;

struct PPB_KeyboardInputEvent_1_0 {
  PP_Resource (*Create)(PP_Instance instance,
                        PP_InputEvent_Type type,
                        PP_TimeTicks time_stamp,
                        uint32_t modifiers,
                        uint32_t key_code,
                        struct PP_Var character_text);
  PP_Bool (*IsKeyboardInputEvent)(PP_Resource resource);
  uint32_t (*GetKeyCode)(PP_Resource key_event);
  struct PP_Var (*GetCharacterText)(PP_Resource character_event);
};
/**
 * @}
 */

/**
 * @addtogroup Enums
 * @{
 */
typedef enum {
  /**
   * The list of all TouchPoints which are currently down.
   */
  PP_TOUCHLIST_TYPE_TOUCHES = 0,
  /**
   * The list of all TouchPoints whose state has changed since the last
   * TouchInputEvent.
   */
  PP_TOUCHLIST_TYPE_CHANGEDTOUCHES = 1,
  /**
   * The list of all TouchPoints which are targeting this plugin.  This is a
   * subset of Touches.
   */
  PP_TOUCHLIST_TYPE_TARGETTOUCHES = 2
} PP_TouchListType;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_TouchListType, 4);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPB_TouchInputEvent</code> interface contains pointers to several
 * functions related to touch events.
 */
struct PPB_TouchInputEvent_1_0 {
  /**
   * Creates a touch input event with the given parameters. Normally you
   * will get a touch event passed through the HandleInputEvent and will not
   * need to create them, but some applications may want to create their own
   * for internal use. The type must be one of the touch event types.
   * This newly created touch input event does not have any touch point in any
   * of the touch-point lists. <code>AddTouchPoint</code> should be called to
   * add the touch-points.
   *
   * @param[in] instance The instance for which this event occurred.
   *
   * @param[in] type A <code>PP_InputEvent_Type</code> identifying the type of
   * input event.
   *
   * @param[in] time_stamp A <code>PP_TimeTicks</code> indicating the time
   * when the event occurred.
   *
   * @param[in]  modifiers A bit field combination of the
   * <code>PP_InputEvent_Modifier</code> flags.
   *
   * @return A <code>PP_Resource</code> containing the new touch input event.
   */
  PP_Resource (*Create)(PP_Instance instance,
                        PP_InputEvent_Type type,
                        PP_TimeTicks time_stamp,
                        uint32_t modifiers);
  /**
   * Adds a touch point to the touch event in the specified touch-list.
   *
   * @param[in] touch_event A <code>PP_Resource</code> corresponding to a touch
   * event.
   *
   * @param[in] list The list to add the touch point to.
   *
   * @param[in] point The point to add to the list.
   */
  void (*AddTouchPoint)(PP_Resource touch_event,
                        PP_TouchListType list,
                        const struct PP_TouchPoint* point);
  /**
   * IsTouchInputEvent() determines if a resource is a touch event.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to an event.
   *
   * @return <code>PP_TRUE</code> if the given resource is a valid touch input
   * event, otherwise <code>PP_FALSE</code>.
   */
  PP_Bool (*IsTouchInputEvent)(PP_Resource resource);
  /**
   * Returns the number of touch-points in the specified list.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to a touch
   * event.
   *
   * @param[in] list The list.
   *
   * @return The number of touch-points in the specified list.
   */
  uint32_t (*GetTouchCount)(PP_Resource resource, PP_TouchListType list);
  /**
   * Returns the touch-point at the specified index from the specified list.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to a touch
   * event.
   *
   * @param[in] list The list.
   *
   * @param[in] index The index.
   *
   * @return A <code>PP_TouchPoint</code> representing the touch-point.
   */
  struct PP_TouchPoint (*GetTouchByIndex)(PP_Resource resource,
                                          PP_TouchListType list,
                                          uint32_t index);
  /**
   * Returns the touch-point with the specified touch-id in the specified list.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to a touch
   * event.
   *
   * @param[in] list The list.
   *
   * @param[in] touch_id The id of the touch-point.
   *
   * @return A <code>PP_TouchPoint</code> representing the touch-point.
   */
  struct PP_TouchPoint (*GetTouchById)(PP_Resource resource,
                                       PP_TouchListType list,
                                       uint32_t touch_id);
};

typedef struct PPB_TouchInputEvent_1_0 PPB_TouchInputEvent;

struct PPB_IMEInputEvent_1_0 {
  /**
   * Create() creates an IME input event with the given parameters. Normally
   * you will get an IME event passed through the <code>HandleInputEvent</code>
   * and will not need to create them, but some applications may want to create
   * their own for internal use.
   *
   * @param[in] instance The instance for which this event occurred.
   *
   * @param[in] type A <code>PP_InputEvent_Type</code> identifying the type of
   * input event. The type must be one of the IME event types.
   *
   * @param[in] time_stamp A <code>PP_TimeTicks</code> indicating the time
   * when the event occurred.
   *
   * @param[in] text The string returned by <code>GetText</code>.
   *
   * @param[in] segment_number The number returned by
   * <code>GetSegmentNumber</code>.
   *
   * @param[in] segment_offsets The array of numbers returned by
   * <code>GetSegmentOffset</code>. If <code>segment_number</code> is zero,
   * the number of elements of the array should be zero. If
   * <code>segment_number</code> is non-zero, the length of the array must be
   * <code>segment_number</code> + 1.
   *
   * @param[in] target_segment The number returned by
   * <code>GetTargetSegment</code>.
   *
   * @param[in] selection_start The start index returned by
   * <code>GetSelection</code>.
   *
   * @param[in] selection_end The end index returned by
   * <code>GetSelection</code>.
   *
   * @return A <code>PP_Resource</code> containing the new IME input event.
   */
  PP_Resource (*Create)(PP_Instance instance,
                        PP_InputEvent_Type type,
                        PP_TimeTicks time_stamp,
                        struct PP_Var text,
                        uint32_t segment_number,
                        const uint32_t segment_offsets[],
                        int32_t target_segment,
                        uint32_t selection_start,
                        uint32_t selection_end);
  /**
   * IsIMEInputEvent() determines if a resource is an IME event.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to an event.
   *
   * @return <code>PP_TRUE</code> if the given resource is a valid input event.
   */
  PP_Bool (*IsIMEInputEvent)(PP_Resource resource);
  /**
   * GetText() returns the composition text as a UTF-8 string for the given IME
   * event.
   *
   * @param[in] ime_event A <code>PP_Resource</code> corresponding to an IME
   * event.
   *
   * @return A string var representing the composition text. For non-IME input
   * events the return value will be an undefined var.
   */
  struct PP_Var (*GetText)(PP_Resource ime_event);
  /**
   * GetSegmentNumber() returns the number of segments in the composition text.
   *
   * @param[in] ime_event A <code>PP_Resource</code> corresponding to an IME
   * event.
   *
   * @return The number of segments. For events other than COMPOSITION_UPDATE,
   * returns 0.
   */
  uint32_t (*GetSegmentNumber)(PP_Resource ime_event);
  /**
   * GetSegmentOffset() returns the position of the index-th segmentation point
   * in the composition text. The position is given by a byte-offset (not a
   * character-offset) of the string returned by GetText(). It always satisfies
   * 0=GetSegmentOffset(0) < ... < GetSegmentOffset(i) < GetSegmentOffset(i+1)
   * < ... < GetSegmentOffset(GetSegmentNumber())=(byte-length of GetText()).
   * Note that [GetSegmentOffset(i), GetSegmentOffset(i+1)) represents the range
   * of the i-th segment, and hence GetSegmentNumber() can be a valid argument
   * to this function instead of an off-by-1 error.
   *
   * @param[in] ime_event A <code>PP_Resource</code> corresponding to an IME
   * event.
   *
   * @param[in] index An integer indicating a segment.
   *
   * @return The byte-offset of the segmentation point. If the event is not
   * COMPOSITION_UPDATE or index is out of range, returns 0.
   */
  uint32_t (*GetSegmentOffset)(PP_Resource ime_event, uint32_t index);
  /**
   * GetTargetSegment() returns the index of the current target segment of
   * composition.
   *
   * @param[in] ime_event A <code>PP_Resource</code> corresponding to an IME
   * event.
   *
   * @return An integer indicating the index of the target segment. When there
   * is no active target segment, or the event is not COMPOSITION_UPDATE,
   * returns -1.
   */
  int32_t (*GetTargetSegment)(PP_Resource ime_event);
  /**
   * GetSelection() returns the range selected by caret in the composition text.
   *
   * @param[in] ime_event A <code>PP_Resource</code> corresponding to an IME
   * event.
   *
   * @param[out] start The start position of the current selection.
   *
   * @param[out] end The end position of the current selection.
   */
  void (*GetSelection)(PP_Resource ime_event, uint32_t* start, uint32_t* end);
};

typedef struct PPB_IMEInputEvent_1_0 PPB_IMEInputEvent;
/**
 * @}
 */

/* pp_input_event.idl */
/**
 * @addtogroup Structs
 * @{
 */
/**
 * The <code>PP_InputEvent_Key</code> struct represents a key up or key down
 * event.
 *
 * Key up and key down events correspond to physical keys on the keyboard. The
 * actual character that the user typed (if any) will be delivered in a
 * "character" event.
 *
 * If the user loses focus on the module while a key is down, a key up
 * event might not occur. For example, if the module has focus and the user
 * presses and holds the shift key, the module will see a "shift down" message.
 * Then if the user clicks elsewhere on the web page, the module's focus will
 * be lost and no more input events will be delivered.
 *
 * If your module depends on receiving key up events, it should also handle
 * "lost focus" as the equivalent of "all keys up."
 */
struct PP_InputEvent_Key {
  /** This value is a bit field combination of the EVENT_MODIFIER flags. */
  uint32_t modifier;
  /**
   * This value reflects the DOM KeyboardEvent <code>keyCode</code> field.
   * Chrome populates this with the Windows-style Virtual Key code of the key.
   */
  uint32_t key_code;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_InputEvent_Key, 8);

/**
 * The <code>PP_InputEvent_Character</code> struct represents a typed character
 * event.
 *
 * Normally, the program will receive a key down event, followed by a character
 * event, followed by a key up event. The character event will have any
 * modifier keys applied. Obvious examples are symbols, where Shift-5 gives you
 * a '%'. The key down and up events will give you the scan code for the "5"
 * key, and the character event will give you the '%' character.
 *
 * You may not get a character event for all key down events if the key doesn't
 * generate a character. Likewise, you may actually get multiple character
 * events in a row. For example, some locales have an accent key that modifies
 * the next character typed. You might get this stream of events: accent down,
 * accent up (it didn't generate a character), letter key down, letter with
 * accent character event (it was modified by the previous accent key), letter
 * key up.  If the letter can't be combined with the accent, like an umlaut and
 * an 'R', the system might send umlaut down, umlaut up, 'R' key down, umlaut
 * character (can't combine it with 'R', so just send the raw umlaut so it
 * isn't lost"), 'R' character event, 'R' key up.
 */
struct PP_InputEvent_Character {
  /** A combination of the <code>PP_InputEvent_Modifier</code> flags. */
  uint32_t modifier;
  /**
   * This value represents the typed character as a single null-terminated UTF-8
   * character. Any unused bytes will be filled with null bytes. Since the
   * maximum UTF-8 character is 4 bytes, there will always be at least one null
   * at the end so you can treat this as a null-terminated UTF-8 string.
   */
  int8_t text[5];
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_InputEvent_Character, 12);

/**
 * The <code>PP_InputEvent_Mouse</code> struct represents all mouse events
 * except mouse wheel events.
 */
struct PP_InputEvent_Mouse {
  /**
   * This value is a bit field combination of the
   * <code>PP_InputEvent_Modifier</code> flags.
   */
  uint32_t modifier;
  /**
   * This value represents the button that changed for mouse down or up events.
   * This value will be <code>PP_EVENT_MOUSEBUTTON_NONE</code> for mouse move,
   * enter, and leave events.
   */
  PP_InputEvent_MouseButton button;
  /**
   * This values represents the x coordinate of the mouse when the event
   * occurred.
   *
   * In most, but not all, cases these coordinates will just be integers.
   * For example, the plugin element might be arbitrarily scaled or transformed
   * in the DOM, and translating a mouse event into the coordinate space of the
   * plugin will give non-integer values.
   */
  float x;
  /**
   * This values represents the y coordinate of the mouse when the event
   * occurred.
   *
   * In most, but not all, cases these coordinates will just be integers.
   * For example, the plugin element might be arbitrarily scaled or transformed
   * in the DOM, and translating a mouse event into the coordinate space of the
   * plugin will give non-integer values.
   */
  float y;
  int32_t click_count;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_InputEvent_Mouse, 20);

/**
 * The <code>PP_InputEvent_Wheel</code> struct represents all mouse wheel
 * events.
 */
struct PP_InputEvent_Wheel {
  /**
   * This value represents a combination of the <code>EVENT_MODIFIER</code>
   * flags.
   */
  uint32_t modifier;
  /**
   * The mouse wheel's horizontal scroll amount. A scroll to the right
   * (where the content moves left) is represented as positive values,
   * and a scroll to the left (where the content moves right) is
   * represented as negative values.
   *
   * The units are either in pixels (when scroll_by_page is false) or pages
   * (when scroll_by_page is true). For example, delta_y = -3 means scroll up 3
   * pixels when scroll_by_page is false, and scroll up 3 pages when
   * scroll_by_page is true.
   *
   * This amount is system dependent and will take into account the user's
   * preferred scroll sensitivity and potentially also nonlinear acceleration
   * based on the speed of the scrolling.
   *
   * Devices will be of varying resolution. Some mice with large detents will
   * only generate integer scroll amounts. But fractional values are also
   * possible, for example, on some trackpads and newer mice that don't have
   * "clicks".
   */
  float delta_x;
  /**
   * The mouse wheel's vertical scroll amount. A scroll down (where the
   * content moves up) is represented as positive values, and a scroll up
   * (where the content moves down) is represented as negative values.
   *
   * The units are either in pixels (when scroll_by_page is false) or pages
   * (when scroll_by_page is true). For example, delta_y = -3 means scroll up 3
   * pixels when scroll_by_page is false, and scroll up 3 pages when
   * scroll_by_page is true.
   *
   * This amount is system dependent and will take into account the user's
   * preferred scroll sensitivity and potentially also nonlinear acceleration
   * based on the speed of the scrolling.
   *
   * Devices will be of varying resolution. Some mice with large detents will
   * only generate integer scroll amounts. But fractional values are also
   * possible, for example, on some trackpads and newer mice that don't have
   * "clicks".
   */
  float delta_y;
  /**
   * The number of "clicks" of the scroll wheel that have produced the
   * event. The value may have system-specific acceleration applied to it,
   * depending on the device. The positive and negative meanings are the same
   * as for <code>delta_x</code> and <code>delta_y</code>.
   *
   * If you are scrolling, you probably want to use the delta values above.
   * These tick events can be useful if you aren't doing actual scrolling and
   * don't want or pixel values. An example may be cycling between different
   * items in a game.
   *
   * You may receive fractional values for the wheel ticks if the mouse wheel
   * is high resolution or doesn't have "clicks". If your program wants
   * discrete events (as in the "picking items" example) you should accumulate
   * fractional click values from multiple messages until the total value
   * reaches positive or negative one. This should represent a similar amount
   * of scrolling as for a mouse that has a discrete mouse wheel.
   */
  float wheel_ticks_x;
  /** This value represents */
  float wheel_ticks_y;
  /**
   * Indicates if the scroll <code>delta_x</code>/<code>delta_y</code>
   * indicates pages or lines to scroll by. When true, the user is requesting
   * to scroll by pages.
   */
  PP_Bool scroll_by_page;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_InputEvent_Wheel, 24);
/**
 * @}
 */

/* pp_module.idl */
/**
 * @addtogroup Typedefs
 * @{
 */
/**
 * The PP_Module value uniquely identifies the module or .nexe.
 *
 * This identifier is an opaque handle assigned by the browser to the module. It
 * is guaranteed never to be 0, so a module can initialize it to 0 to
 * indicate a "NULL handle."
 */
typedef int32_t PP_Module;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_Module, 4);
/**
 * @}
 */

/* ppb.idl */
/**
 * @addtogroup Typedefs
 * @{
 */
/**
 * This function pointer type defines the signature for the
 * <code>PPB_GetInterface</code> function. A generic
 * <code>PPB_GetInterface</code> pointer is passed to
 * <code>PPP_InitializedModule</code> when your module is loaded. You can use
 * this pointer to request a pointer to a specific browser interface. Browser
 * interface names are ASCII strings and are generally defined in the header
 * file for the interface, such as <code>PPB_AUDIO_INTERFACE</code> found in
 * <code>ppb.audio.h</code> or
 * <code>PPB_GRAPHICS_2D_INTERFACE</code> in <code>ppb_graphics_2d.h</code>.
 * Click
 * <a href="globals_defs.html"
 * title="macros">here</a> for a complete list of interface
 * names.
 *
 * This value will be NULL if the interface is not supported on the browser.
 */
typedef const void* (*PPB_GetInterface)(const char* interface_name);
/**
 * @}
 */

/* ppb_audio.idl */
/**
 * @addtogroup Typedefs
 * @{
 */
/**
 * <code>PPB_Audio_Callback</code> defines the type of an audio callback
 * function used to fill the audio buffer with data. Please see the
 * Create() function in the <code>PPB_Audio</code> interface for
 * more details on this callback.
 *
 * @param[in] sample_buffer A buffer to fill with audio data.
 * @param[in] buffer_size_in_bytes The size of the buffer in bytes.
 * @param[in] latency How long before the audio data is to be presented.
 * @param[inout] user_data An opaque pointer that was passed into
 * <code>PPB_Audio.Create()</code>.
 */
typedef void (*PPB_Audio_Callback)(void* sample_buffer,
                                   uint32_t buffer_size_in_bytes,
                                   PP_TimeDelta latency,
                                   void* user_data);

typedef void (*PPB_Audio_Callback_1_0)(void* sample_buffer,
                                       uint32_t buffer_size_in_bytes,
                                       void* user_data);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPB_Audio</code> interface contains pointers to several functions
 * for handling audio resources. Refer to the
 * <a href="/native-client/devguide/coding/audio.html">Audio</a>
 * chapter in the Developer's Guide for information on using this interface.
 * Please see descriptions for each <code>PPB_Audio</code> and
 * <code>PPB_AudioConfig</code> function for more details. A C example using
 * <code>PPB_Audio</code> and <code>PPB_AudioConfig</code> follows.
 *
 * <strong>Example: </strong>
 *
 * @code
 * void audio_callback(void* sample_buffer,
 *                     uint32_t buffer_size_in_bytes,
 *                     void* user_data) {
 *   ... quickly fill in the buffer with samples and return to caller ...
 *  }
 *
 * ...Assume the application has cached the audio configuration interface in
 * audio_config_interface and the audio interface in
 * audio_interface...
 *
 * uint32_t count = audio_config_interface->RecommendSampleFrameCount(
 *     PP_AUDIOSAMPLERATE_44100, 4096);
 * PP_Resource pp_audio_config = audio_config_interface->CreateStereo16Bit(
 *     pp_instance, PP_AUDIOSAMPLERATE_44100, count);
 * PP_Resource pp_audio = audio_interface->Create(pp_instance, pp_audio_config,
 *     audio_callback, NULL);
 * audio_interface->StartPlayback(pp_audio);
 *
 * ...audio_callback() will now be periodically invoked on a separate thread...
 * @endcode
 */
struct PPB_Audio_1_1 {
  /**
   * Create() creates an audio resource. No sound will be heard until
   * StartPlayback() is called. The callback is called with the buffer address
   * and given user data whenever the buffer needs to be filled. From within the
   * callback, you should not call <code>PPB_Audio</code> functions. The
   * callback will be called on a different thread than the one which created
   * the interface. For performance-critical applications (i.e. low-latency
   * audio), the callback should avoid blocking or calling functions that can
   * obtain locks, such as malloc. The layout and the size of the buffer passed
   * to the audio callback will be determined by the device configuration and is
   * specified in the <code>AudioConfig</code> documentation.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying one instance
   * of a module.
   * @param[in] config A <code>PP_Resource</code> corresponding to an audio
   * config resource.
   * @param[in] audio_callback A <code>PPB_Audio_Callback</code> callback
   * function that the browser calls when it needs more samples to play.
   * @param[in] user_data A pointer to user data used in the callback function.
   *
   * @return A <code>PP_Resource</code> containing the audio resource if
   * successful or 0 if the configuration cannot be honored or the callback is
   * null.
   */
  PP_Resource (*Create)(PP_Instance instance,
                        PP_Resource config,
                        PPB_Audio_Callback audio_callback,
                        void* user_data);
  /**
   * IsAudio() determines if the provided resource is an audio resource.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to a generic
   * resource.
   *
   * @return A <code>PP_Bool</code> containing containing <code>PP_TRUE</code>
   * if the given resource is an Audio resource, otherwise
   * <code>PP_FALSE</code>.
   */
  PP_Bool (*IsAudio)(PP_Resource resource);
  /**
   * GetCurrrentConfig() returns an audio config resource for the given audio
   * resource.
   *
   * @param[in] config A <code>PP_Resource</code> corresponding to an audio
   * resource.
   *
   * @return A <code>PP_Resource</code> containing the audio config resource if
   * successful.
   */
  PP_Resource (*GetCurrentConfig)(PP_Resource audio);
  /**
   * StartPlayback() starts the playback of the audio resource and begins
   * periodically calling the callback.
   *
   * @param[in] config A <code>PP_Resource</code> corresponding to an audio
   * resource.
   *
   * @return A <code>PP_Bool</code> containing <code>PP_TRUE</code> if
   * successful, otherwise <code>PP_FALSE</code>. Also returns
   * <code>PP_TRUE</code> (and be a no-op) if called while playback is already
   * in progress.
   */
  PP_Bool (*StartPlayback)(PP_Resource audio);
  /**
   * StopPlayback() stops the playback of the audio resource.
   *
   * @param[in] config A <code>PP_Resource</code> corresponding to an audio
   * resource.
   *
   * @return A <code>PP_Bool</code> containing <code>PP_TRUE</code> if
   * successful, otherwise <code>PP_FALSE</code>. Also returns
   * <code>PP_TRUE</code> (and is a no-op) if called while playback is already
   * stopped. If a callback is in progress, StopPlayback() will block until the
   * callback completes.
   */
  PP_Bool (*StopPlayback)(PP_Resource audio);
};

typedef struct PPB_Audio_1_1 PPB_Audio;

struct PPB_Audio_1_0 {
  PP_Resource (*Create)(PP_Instance instance,
                        PP_Resource config,
                        PPB_Audio_Callback_1_0 audio_callback,
                        void* user_data);
  PP_Bool (*IsAudio)(PP_Resource resource);
  PP_Resource (*GetCurrentConfig)(PP_Resource audio);
  PP_Bool (*StartPlayback)(PP_Resource audio);
  PP_Bool (*StopPlayback)(PP_Resource audio);
};
/**
 * @}
 */

/* ppb_audio_buffer.idl */
/**
 * @addtogroup Enums
 * @{
 */
/**
 * PP_AudioBuffer_SampleRate is an enumeration of the different audio sample
 * rates.
 */
typedef enum {
  PP_AUDIOBUFFER_SAMPLERATE_UNKNOWN = 0,
  PP_AUDIOBUFFER_SAMPLERATE_8000 = 8000,
  PP_AUDIOBUFFER_SAMPLERATE_16000 = 16000,
  PP_AUDIOBUFFER_SAMPLERATE_22050 = 22050,
  PP_AUDIOBUFFER_SAMPLERATE_32000 = 32000,
  PP_AUDIOBUFFER_SAMPLERATE_44100 = 44100,
  PP_AUDIOBUFFER_SAMPLERATE_48000 = 48000,
  PP_AUDIOBUFFER_SAMPLERATE_96000 = 96000,
  PP_AUDIOBUFFER_SAMPLERATE_192000 = 192000
} PP_AudioBuffer_SampleRate;

/**
 * PP_AudioBuffer_SampleSize is an enumeration of the different audio sample
 * sizes.
 */
typedef enum {
  PP_AUDIOBUFFER_SAMPLESIZE_UNKNOWN = 0,
  PP_AUDIOBUFFER_SAMPLESIZE_16_BITS = 2
} PP_AudioBuffer_SampleSize;
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
struct PPB_AudioBuffer_0_1 {
  /**
   * Determines if a resource is an AudioBuffer resource.
   *
   * @param[in] resource The <code>PP_Resource</code> to test.
   *
   * @return A <code>PP_Bool</code> with <code>PP_TRUE</code> if the given
   * resource is an AudioBuffer resource or <code>PP_FALSE</code> otherwise.
   */
  PP_Bool (*IsAudioBuffer)(PP_Resource resource);
  /**
   * Gets the timestamp of the audio buffer.
   *
   * @param[in] buffer A <code>PP_Resource</code> corresponding to an audio
   * buffer resource.
   *
   * @return A <code>PP_TimeDelta</code> containing the timestamp of the audio
   * buffer. Given in seconds since the start of the containing audio stream.
   */
  PP_TimeDelta (*GetTimestamp)(PP_Resource buffer);
  /**
   * Sets the timestamp of the audio buffer.
   *
   * @param[in] buffer A <code>PP_Resource</code> corresponding to an audio
   * buffer resource.
   * @param[in] timestamp A <code>PP_TimeDelta</code> containing the timestamp
   * of the audio buffer. Given in seconds since the start of the containing
   * audio stream.
   */
  void (*SetTimestamp)(PP_Resource buffer, PP_TimeDelta timestamp);
  /**
   * Gets the sample rate of the audio buffer.
   *
   * @param[in] buffer A <code>PP_Resource</code> corresponding to an audio
   * buffer resource.
   *
   * @return The sample rate of the audio buffer.
   */
  PP_AudioBuffer_SampleRate (*GetSampleRate)(PP_Resource buffer);
  /**
   * Gets the sample size of the audio buffer.
   *
   * @param[in] buffer A <code>PP_Resource</code> corresponding to an audio
   * buffer resource.
   *
   * @return The sample size of the audio buffer.
   */
  PP_AudioBuffer_SampleSize (*GetSampleSize)(PP_Resource buffer);
  /**
   * Gets the number of channels in the audio buffer.
   *
   * @param[in] buffer A <code>PP_Resource</code> corresponding to an audio
   * buffer resource.
   *
   * @return The number of channels in the audio buffer.
   */
  uint32_t (*GetNumberOfChannels)(PP_Resource buffer);
  /**
   * Gets the number of samples in the audio buffer.
   *
   * @param[in] buffer A <code>PP_Resource</code> corresponding to an audio
   * buffer resource.
   *
   * @return The number of samples in the audio buffer.
   * For example, at a sampling rate of 44,100 Hz in stereo audio, a buffer
   * containing 4410 * 2 samples would have a duration of 100 milliseconds.
   */
  uint32_t (*GetNumberOfSamples)(PP_Resource buffer);
  /**
   * Gets the data buffer containing the audio samples.
   *
   * @param[in] buffer A <code>PP_Resource</code> corresponding to an audio
   * buffer resource.
   *
   * @return A pointer to the beginning of the data buffer.
   */
  void* (*GetDataBuffer)(PP_Resource buffer);
  /**
   * Gets the size of the data buffer in bytes.
   *
   * @param[in] buffer A <code>PP_Resource</code> corresponding to an audio
   * buffer resource.
   *
   * @return The size of the data buffer in bytes.
   */
  uint32_t (*GetDataBufferSize)(PP_Resource buffer);
};

typedef struct PPB_AudioBuffer_0_1 PPB_AudioBuffer;
/**
 * @}
 */

/* ppb_audio_config.idl */
/**
 * @addtogroup Enums
 * @{
 */
/**
 * This enumeration contains audio frame count constants.
 * <code>PP_AUDIOMINSAMPLEFRAMECOUNT</code> is the minimum possible frame
 * count. <code>PP_AUDIOMAXSAMPLEFRAMECOUNT</code> is the maximum possible
 * frame count.
 */
enum {
  PP_AUDIOMINSAMPLEFRAMECOUNT = 64,
  PP_AUDIOMAXSAMPLEFRAMECOUNT = 32768
};

/**
 * PP_AudioSampleRate is an enumeration of the different audio sampling rates.
 * <code>PP_AUDIOSAMPLERATE_44100</code> is the sample rate used on CDs and
 * <code>PP_AUDIOSAMPLERATE_48000</code> is the sample rate used on DVDs and
 * Digital Audio Tapes.
 */
typedef enum {
  PP_AUDIOSAMPLERATE_NONE = 0,
  PP_AUDIOSAMPLERATE_44100 = 44100,
  PP_AUDIOSAMPLERATE_48000 = 48000
} PP_AudioSampleRate;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_AudioSampleRate, 4);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPB_AudioConfig</code> interface contains pointers to several
 * functions for establishing your audio configuration within the browser.
 * This interface only supports 16-bit stereo output.
 *
 * Refer to the
 * <a href="/native-client/devguide/coding/audio.html">Audio
 * </a> chapter in the Developer's Guide for information on using this
 * interface.
 */
struct PPB_AudioConfig_1_1 {
  /**
   * CreateStereo16bit() creates a 16 bit audio configuration resource. The
   * <code>sample_rate</code> should be the result of calling
   * <code>RecommendSampleRate</code> and <code>sample_frame_count</code> should
   * be the result of calling <code>RecommendSampleFrameCount</code>. If the
   * sample frame count or bit rate isn't supported, this function will fail and
   * return a null resource.
   *
   * A single sample frame on a stereo device means one value for the left
   * channel and one value for the right channel.
   *
   * Buffer layout for a stereo int16 configuration:
   * <code>int16_t *buffer16;</code>
   * <code>buffer16[0]</code> is the first left channel sample.
   * <code>buffer16[1]</code> is the first right channel sample.
   * <code>buffer16[2]</code> is the second left channel sample.
   * <code>buffer16[3]</code> is the second right channel sample.
   * ...
   * <code>buffer16[2 * (sample_frame_count - 1)]</code> is the last left
   * channel sample.
   * <code>buffer16[2 * (sample_frame_count - 1) + 1]</code> is the last
   * right channel sample.
   * Data will always be in the native endian format of the platform.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying one instance
   * of a module.
   * @param[in] sample_rate A <code>PP_AudioSampleRate</code> which is either
   * <code>PP_AUDIOSAMPLERATE_44100</code> or
   * <code>PP_AUDIOSAMPLERATE_48000</code>.
   * @param[in] sample_frame_count A <code>uint32_t</code> frame count returned
   * from the <code>RecommendSampleFrameCount</code> function.
   *
   * @return A <code>PP_Resource</code> containing the
   * <code>PPB_Audio_Config</code> if successful or a null resource if the
   * sample frame count or bit rate are not supported.
   */
  PP_Resource (*CreateStereo16Bit)(PP_Instance instance,
                                   PP_AudioSampleRate sample_rate,
                                   uint32_t sample_frame_count);
  /**
   * RecommendSampleFrameCount() returns the supported sample frame count
   * closest to the requested count. The sample frame count determines the
   * overall latency of audio. Since one "frame" is always buffered in advance,
   * smaller frame counts will yield lower latency, but higher CPU utilization.
   *
   * Supported sample frame counts will vary by hardware and system (consider
   * that the local system might be anywhere from a cell phone or a high-end
   * audio workstation). Sample counts less than
   * <code>PP_AUDIOMINSAMPLEFRAMECOUNT</code> and greater than
   * <code>PP_AUDIOMAXSAMPLEFRAMECOUNT</code> are never supported on any
   * system, but values in between aren't necessarily valid. This function
   * will return a supported count closest to the requested frame count.
   *
   * RecommendSampleFrameCount() result is intended for audio output devices.
   *
   * @param[in] instance
   * @param[in] sample_rate A <code>PP_AudioSampleRate</code> which is either
   * <code>PP_AUDIOSAMPLERATE_44100</code> or
   * <code>PP_AUDIOSAMPLERATE_48000.</code>
   * @param[in] requested_sample_frame_count A <code>uint_32t</code> requested
   * frame count.
   *
   * @return A <code>uint32_t</code> containing the recommended sample frame
   * count if successful.
   */
  uint32_t (*RecommendSampleFrameCount)(
      PP_Instance instance,
      PP_AudioSampleRate sample_rate,
      uint32_t requested_sample_frame_count);
  /**
   * IsAudioConfig() determines if the given resource is a
   * <code>PPB_Audio_Config</code>.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to an audio
   * config resource.
   *
   * @return A <code>PP_Bool</code> containing <code>PP_TRUE</code> if the given
   * resource is an <code>AudioConfig</code> resource, otherwise
   * <code>PP_FALSE</code>.
   */
  PP_Bool (*IsAudioConfig)(PP_Resource resource);
  /**
   * GetSampleRate() returns the sample rate for the given
   * <code>PPB_Audio_Config</code>.
   *
   * @param[in] config A <code>PP_Resource</code> corresponding to a
   * <code>PPB_Audio_Config</code>.
   *
   * @return A <code>PP_AudioSampleRate</code> containing sample rate or
   * <code>PP_AUDIOSAMPLERATE_NONE</code> if the resource is invalid.
   */
  PP_AudioSampleRate (*GetSampleRate)(PP_Resource config);
  /**
   * GetSampleFrameCount() returns the sample frame count for the given
   * <code>PPB_Audio_Config</code>.
   *
   * @param[in] config A <code>PP_Resource</code> corresponding to an audio
   * config resource.
   *
   * @return A <code>uint32_t</code> containing sample frame count or
   * 0 if the resource is invalid. Refer to
   * RecommendSampleFrameCount() for more on sample frame counts.
   */
  uint32_t (*GetSampleFrameCount)(PP_Resource config);
  /**
   * RecommendSampleRate() returns the native sample rate that the browser
   * is using in the backend.  Applications that use the recommended sample
   * rate will have potentially better latency and fidelity.  The return value
   * is intended for audio output devices.  If the output sample rate cannot be
   * determined, this function can return PP_AUDIOSAMPLERATE_NONE.
   *
   * @param[in] instance
   *
   * @return A <code>uint32_t</code> containing the recommended sample frame
   * count if successful.
   */
  PP_AudioSampleRate (*RecommendSampleRate)(PP_Instance instance);
};

typedef struct PPB_AudioConfig_1_1 PPB_AudioConfig;

struct PPB_AudioConfig_1_0 {
  PP_Resource (*CreateStereo16Bit)(PP_Instance instance,
                                   PP_AudioSampleRate sample_rate,
                                   uint32_t sample_frame_count);
  uint32_t (*RecommendSampleFrameCount)(
      PP_AudioSampleRate sample_rate,
      uint32_t requested_sample_frame_count);
  PP_Bool (*IsAudioConfig)(PP_Resource resource);
  PP_AudioSampleRate (*GetSampleRate)(PP_Resource config);
  uint32_t (*GetSampleFrameCount)(PP_Resource config);
};
/**
 * @}
 */

/* ppb_audio_encoder.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * Audio encoder interface.
 *
 * Typical usage:
 * - Call Create() to create a new audio encoder resource.
 * - Call GetSupportedProfiles() to determine which codecs and profiles are
 *   available.
 * - Call Initialize() to initialize the encoder for a supported profile.
 * - Call GetBuffer() to get an empty buffer and fill it in, or get an audio
 *   buffer from another resource, e.g. <code>PPB_MediaStreamAudioTrack</code>.
 * - Call Encode() to push the audio buffer to the encoder. If an external
 *   buffer is pushed, wait for completion to recycle the buffer.
 * - Call GetBitstreamBuffer() continuously (waiting for each previous call to
 *   complete) to pull encoded buffers from the encoder.
 * - Call RecycleBitstreamBuffer() after consuming the data in the bitstream
 *   buffer.
 * - To destroy the encoder, the plugin should release all of its references to
 *   it. Any pending callbacks will abort before the encoder is destroyed.
 *
 * Available audio codecs vary by platform.
 * All: opus.
 */
struct PPB_AudioEncoder_0_1 { /* dev */
  /**
   * Creates a new audio encoder resource.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying the instance
   * with the audio encoder.
   *
   * @return A <code>PP_Resource</code> corresponding to an audio encoder if
   * successful or 0 otherwise.
   */
  PP_Resource (*Create)(PP_Instance instance);
  /**
   * Determines if the given resource is an audio encoder.
   *
   * @param[in] resource A <code>PP_Resource</code> identifying a resource.
   *
   * @return <code>PP_TRUE</code> if the resource is a
   * <code>PPB_AudioEncoder</code>, <code>PP_FALSE</code> if the resource is
   * invalid or some other type.
   */
  PP_Bool (*IsAudioEncoder)(PP_Resource resource);
  /**
   * Gets an array of supported audio encoder profiles.
   * These can be used to choose a profile before calling Initialize().
   *
   * @param[in] audio_encoder A <code>PP_Resource</code> identifying the audio
   * encoder.
   * @param[in] output A <code>PP_ArrayOutput</code> to receive the supported
   * <code>PP_AudioProfileDescription</code> structs.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion.
   *
   * @return If >= 0, the number of supported profiles returned, otherwise an
   * error code from <code>pp_errors.h</code>.
   */
  int32_t (*GetSupportedProfiles)(PP_Resource audio_encoder,
                                  struct PP_ArrayOutput output,
                                  struct PP_CompletionCallback callback);
  /**
   * Initializes an audio encoder resource. The plugin should call Initialize()
   * successfully before calling any of the functions below.
   *
   * @param[in] audio_encoder A <code>PP_Resource</code> identifying the audio
   * encoder.
   * @param[in] channels The number of audio channels to encode.
   * @param[in] input_sampling_rate The sampling rate of the input audio buffer.
   * @param[in] input_sample_size The sample size of the input audio buffer.
   * @param[in] output_profile A <code>PP_AudioProfile</code> specifying the
   * codec profile of the encoded output stream.
   * @param[in] initial_bitrate The initial bitrate for the encoder.
   * @param[in] acceleration A <code>PP_HardwareAcceleration</code> specifying
   * whether to use a hardware accelerated or a software implementation.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   * Returns PP_ERROR_NOTSUPPORTED if audio encoding is not available, or the
   * requested codec profile is not supported.
   */
  int32_t (*Initialize)(PP_Resource audio_encoder,
                        uint32_t channels,
                        PP_AudioBuffer_SampleRate input_sample_rate,
                        PP_AudioBuffer_SampleSize input_sample_size,
                        PP_AudioProfile output_profile,
                        uint32_t initial_bitrate,
                        PP_HardwareAcceleration acceleration,
                        struct PP_CompletionCallback callback);
  /**
   * Gets the number of audio samples per channel that audio buffers must
   * contain in order to be processed by the encoder. This will be the number of
   * samples per channels contained in buffers returned by GetBuffer().
   *
   * @param[in] audio_encoder A <code>PP_Resource</code> identifying the audio
   * encoder.
   * @return An int32_t containing the number of samples required, or an error
   * code from <code>pp_errors.h</code>.
   * Returns PP_ERROR_FAILED if Initialize() has not successfully completed.
   */
  int32_t (*GetNumberOfSamples)(PP_Resource audio_encoder);
  /**
   * Gets a blank audio buffer (with metadata given by the Initialize()
   * call) which can be filled with audio data and passed to the encoder.
   *
   * @param[in] audio_encoder A <code>PP_Resource</code> identifying the audio
   * encoder.
   * @param[out] audio_buffer A blank <code>PPB_AudioBuffer</code> resource.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   * Returns PP_ERROR_FAILED if Initialize() has not successfully completed.
   */
  int32_t (*GetBuffer)(PP_Resource audio_encoder,
                       PP_Resource* audio_buffer,
                       struct PP_CompletionCallback callback);
  /**
   * Encodes an audio buffer.
   *
   * @param[in] audio_encoder A <code>PP_Resource</code> identifying the audio
   * encoder.
   * @param[in] audio_buffer The <code>PPB_AudioBuffer</code> to be encoded.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion. Plugins that pass <code>PPB_AudioBuffer</code> resources owned
   * by other resources should wait for completion before reusing them.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   * Returns PP_ERROR_FAILED if Initialize() has not successfully completed.
   */
  int32_t (*Encode)(PP_Resource audio_encoder,
                    PP_Resource audio_buffer,
                    struct PP_CompletionCallback callback);
  /**
   * Gets the next encoded bitstream buffer from the encoder.
   *
   * @param[in] audio_encoder A <code>PP_Resource</code> identifying the audio
   * encoder.
   * @param[out] bitstream_buffer A <code>PP_BitstreamBuffer</code> containing
   * encoded audio data.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion. The plugin can call GetBitstreamBuffer from the callback in
   * order to continuously "pull" bitstream buffers from the encoder.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   * Returns PP_ERROR_FAILED if Initialize() has not successfully completed.
   * Returns PP_ERROR_INPROGRESS if a prior call to GetBitstreamBuffer() has
   * not completed.
   */
  int32_t (*GetBitstreamBuffer)(
      PP_Resource audio_encoder,
      struct PP_AudioBitstreamBuffer* bitstream_buffer,
      struct PP_CompletionCallback callback);
  /**
   * Recycles a bitstream buffer back to the encoder.
   *
   * @param[in] audio_encoder A <code>PP_Resource</code> identifying the audio
   * encoder.
   * @param[in] bitstream_buffer A <code>PP_BitstreamBuffer</code> that is no
   * longer needed by the plugin.
   */
  void (*RecycleBitstreamBuffer)(
      PP_Resource audio_encoder,
      const struct PP_AudioBitstreamBuffer* bitstream_buffer);
  /**
   * Requests a change to the encoding bitrate. This is only a request,
   * fulfilled on a best-effort basis.
   *
   * @param[in] audio_encoder A <code>PP_Resource</code> identifying the audio
   * encoder.
   * @param[in] bitrate The requested new bitrate, in bits per second.
   */
  void (*RequestBitrateChange)(PP_Resource audio_encoder, uint32_t bitrate);
  /**
   * Closes the audio encoder, and cancels any pending encodes. Any pending
   * callbacks will still run, reporting <code>PP_ERROR_ABORTED</code> . It is
   * not valid to call any encoder functions after a call to this method.
   * <strong>Note:</strong> Destroying the audio encoder closes it implicitly,
   * so you are not required to call Close().
   *
   * @param[in] audio_encoder A <code>PP_Resource</code> identifying the audio
   * encoder.
   */
  void (*Close)(PP_Resource audio_encoder);
};
/**
 * @}
 */

/* ppb_compositor.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * Defines the <code>PPB_Compositor</code> interface. Used for setting
 * <code>PPB_CompositorLayer</code> layers to the Chromium compositor for
 * compositing. This allows a plugin to combine different sources of visual
 * data efficiently, such as <code>PPB_ImageData</code> images and
 * OpenGL textures. See also <code>PPB_CompositorLayer</code> for more
 * information.
 * This interface is still in development (Dev API status) and may change,
 * so is only supported on Dev channel and Canary currently.
 *
 * <strong>Example usage from plugin code:</strong>
 *
 * <strong>Setup:</strong>
 * @code
 * PP_Resource compositor;
 * compositor = compositor_if->Create(instance);
 * instance_if->BindGraphics(instance, compositor);
 * @endcode
 *
 * <strong>Setup layer stack:</strong>
 * @code
 * PP_Resource color_layer = compositor_if->AddLayer(compositor);
 * PP_Resource texture_layer = compositor_if->AddLayer(compositor);
 * @endcode
 *
 * <strong> Present one frame:</strong>
 * layer_if->SetColor(color_layer, 255, 255, 0, 255, PP_MakeSize(400, 400));
 * PP_CompletionCallback release_callback = {
 *   TextureReleasedCallback, 0, PP_COMPLETIONCALLBACK_FLAG_NONE,
 * };
 * layer_if->SetTexture(texture_layer, graphics3d, texture_id,
 *                      PP_MakeSize(300, 300), release_callback);
 *
 * PP_CompletionCallback callback = {
 *   DidFinishCommitLayersCallback,
 *   (void*) texture_id,
 *   PP_COMPLETIONCALLBACK_FLAG_NONE,
 * };
 * compositor_if->CommitLayers(compositor, callback);
 * @endcode
 *
 * <strong>release callback</strong>
 * void ReleaseCallback(int32_t result, void* user_data) {
 *   if (result == PP_OK) {
 *     uint32_t texture_id = (uint32_t) user_data;
 *     // reuse the texture or delete it.
 *   }
 * }
 *
 * <strong>Shutdown:</strong>
 * @code
 * core->ReleaseResource(color_layer);
 * core->ReleaseResource(texture_layer);
 * core->ReleaseResource(compositor);
 * @endcode
 */
struct PPB_Compositor_0_1 { /* dev */
  /**
   * Determines if a resource is a compositor resource.
   *
   * @param[in] resource The <code>PP_Resource</code> to test.
   *
   * @return A <code>PP_Bool</code> with <code>PP_TRUE</code> if the given
   * resource is a compositor resource or <code>PP_FALSE</code> otherwise.
   */
  PP_Bool (*IsCompositor)(PP_Resource resource);
  /**
   * Creates a Compositor resource.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying one instance
   * of a module.
   *
   * @return A <code>PP_Resource</code> containing the compositor resource if
   * successful or 0 otherwise.
   */
  PP_Resource (*Create)(PP_Instance instance);
  /**
   * Creates a new <code>PPB_CompositorLayer</code> and adds it to the end
   * of the layer stack. A <code>PP_Resource</code> containing the layer is
   * returned. It is uninitialized, <code>SetColor()</code>,
   * <code>SetTexture</code> or <code>SetImage</code> should be used to
   * initialize it. The layer will appear above other pre-existing layers.
   * If <code>ResetLayers</code> is called or the <code>PPB_Compositor</code> is
   * released, the returned layer will be invalidated, and any further calls on
   * the layer will return <code>PP_ERROR_BADRESOURCE</code>.
   *
   * param[in] compositor A <code>PP_Resource</code> corresponding to
   * a compositor layer resource.
   *
   * @return A <code>PP_Resource</code> containing the compositor layer
   * resource if successful or 0 otherwise.
   */
  PP_Resource (*AddLayer)(PP_Resource compositor);
  /**
   * Commits layers added by <code>AddLayer()</code> to the chromium compositor.
   *
   * param[in] compositor A <code>PP_Resource</code> corresponding to
   * a compositor layer resource.
   * @param[in] cc A <code>PP_CompletionCallback</code> to be called when
   * layers have been represented on screen.
   *
   * @return An int32_t containing a result code from <code>pp_errors.h</code>.
   */
  int32_t (*CommitLayers)(PP_Resource compositor,
                          struct PP_CompletionCallback cc);
  /**
   * Resets layers added by <code>AddLayer()</code>.
   *
   * param[in] compositor A <code>PP_Resource</code> corresponding to
   * a compositor layer resource.
   *
   * @return An int32_t containing a result code from <code>pp_errors.h</code>.
   */
  int32_t (*ResetLayers)(PP_Resource compositor);
};
/**
 * @}
 */

/* ppb_compositor_layer.idl */
/**
 * @addtogroup Enums
 * @{
 */
/**
 * This enumeration contains blend modes used for computing the result pixels
 * based on the source RGBA values in layers with the RGBA values that are
 * already in the destination framebuffer.
 * alpha_src, color_src: source alpha and color.
 * alpha_dst, color_dst: destination alpha and color (before compositing).
 * Below descriptions of the blend modes assume the colors are pre-multiplied.
 * This interface is still in development (Dev API status) and may change,
 * so is only supported on Dev channel and Canary currently.
 */
typedef enum {
  /**
   * No blending, copy source to the destination directly.
   */
  PP_BLENDMODE_NONE,
  /**
   * Source is placed over the destination.
   * Resulting alpha = alpha_src + alpha_dst - alpha_src * alpha_dst
   * Resulting color = color_src + color_dst * (1 - alpha_src)
   */
  PP_BLENDMODE_SRC_OVER,
  /**
   * The last blend mode.
   */
  PP_BLENDMODE_LAST = PP_BLENDMODE_SRC_OVER
} PP_BlendMode;
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * Defines the <code>PPB_CompositorLayer</code> interface. It is used by
 * <code>PPB_Compositor</code>.
 */
struct PPB_CompositorLayer_0_2 { /* dev */
  /**
   * Determines if a resource is a compositor layer resource.
   *
   * @param[in] resource The <code>PP_Resource</code> to test.
   *
   * @return A <code>PP_Bool</code> with <code>PP_TRUE</code> if the given
   * resource is a compositor layer resource or <code>PP_FALSE</code>
   * otherwise.
   */
  PP_Bool (*IsCompositorLayer)(PP_Resource resource);
  /**
   * Sets the color of a solid color layer. If the layer is uninitialized,
   * it will initialize the layer first, and then set its color.
   * If the layer has been initialized to another kind of layer, the layer will
   * not be changed, and <code>PP_ERROR_BADARGUMENT</code> will be returned.
   *
   * param[in] layer A <code>PP_Resource</code> corresponding to a compositor
   * layer resource.
   * param[in] red A <code>float</code> for the red color component. It will be
   * clamped to [0, 1].
   * param[in] green A <code>float</code> for the green color component. It will
   * be clamped to [0, 1].
   * param[in] blue A <code>float</code> for the blue color component. It will
   * be clamped to [0, 1].
   * param[in] alpha A <code>float</code> for the alpha color component. It will
   * be clamped to [0, 1].
   * param[in] size A <code>PP_Size</code> for the size of the layer before
   * transform.
   *
   * @return An int32_t containing a result code from <code>pp_errors.h</code>.
   */
  int32_t (*SetColor)(PP_Resource layer,
                      float red,
                      float green,
                      float blue,
                      float alpha,
                      const struct PP_Size* size);
  /**
   * Sets the texture of a texture layer. If the layer is uninitialized,
   * it will initialize the layer first, and then set its texture.
   * The source rect will be set to ((0, 0), (1, 1)). If the layer has been
   * initialized to another kind of layer, the layer will not be changed,
   * and <code>PP_ERROR_BADARGUMENT</code> will be returned.
   *
   * param[in] layer A <code>PP_Resource</code> corresponding to a compositor
   * layer resource.
   * param[in] context A <code>PP_Resource</code> corresponding to a graphics
   * 3d resource which owns the GL texture.
   * param[in] target GL texture target (GL_TEXTURE_2D, etc).
   * param[in] texture A GL texture object id.
   * param[in] size A <code>PP_Size</code> for the size of the layer before
   * transform.
   * param[in] cc A <code>PP_CompletionCallback</code> to be called when
   * the texture is released by Chromium compositor.
   *
   * @return An int32_t containing a result code from <code>pp_errors.h</code>.
   */
  int32_t (*SetTexture)(PP_Resource layer,
                        PP_Resource context,
                        uint32_t target,
                        uint32_t texture,
                        const struct PP_Size* size,
                        struct PP_CompletionCallback cc);
  /**
   * Sets the image of an image layer. If the layer is uninitialized,
   * it will initialize the layer first, and then set its image.
   * The layer size will be set to the image's size. The source rect will be set
   * to the full image. If the layer has been initialized to another kind of
   * layer, the layer will not be changed, and <code>PP_ERROR_BADARGUMENT</code>
   * will be returned.
   *
   * param[in] layer A <code>PP_Resource</code> corresponding to a compositor
   * layer resource.
   * param[in] image_data A <code>PP_Resource</code> corresponding to
   * an image data resource.
   * param[in] size A <code>PP_Size</code> for the size of the layer before
   * transform. If NULL, the image's size will be used.
   * param[in] cc A <code>PP_CompletionCallback</code> to be called when
   * the image data is released by Chromium compositor.
   *
   * @return An int32_t containing a result code from <code>pp_errors.h</code>.
   */
  int32_t (*SetImage)(PP_Resource layer,
                      PP_Resource image_data,
                      const struct PP_Size* size,
                      struct PP_CompletionCallback cc);
  /**
   * Sets a clip rectangle for a compositor layer. The Chromium compositor
   * applies a transform matrix on the layer first, and then clips the layer
   * with the rectangle.
   *
   * param[in] layer A <code>PP_Resource</code> corresponding to a compositor
   * layer resource.
   * param[in] rect The clip rectangle. The origin is top-left corner of
   * the plugin.
   *
   * @return An int32_t containing a result code from <code>pp_errors.h</code>.
   */
  int32_t (*SetClipRect)(PP_Resource layer, const struct PP_Rect* rect);
  /**
   * Sets a transform matrix which is used to composite the layer.
   *
   * param[in] layer A <code>PP_Resource</code> corresponding to a compositor
   * layer resource.
   * param[in] matrix A float array with 16 elements. The matrix is
   * column major. The default transform matrix is an identity matrix.
   *
   * @return An int32_t containing a result code from <code>pp_errors.h</code>.
   */
  int32_t (*SetTransform)(PP_Resource layer, const float matrix[16]);
  /**
   * Sets the opacity value which will be applied to the layer. The effective
   * value of each pixel is computed as:
   *
   *   if (premult_alpha)
   *     pixel.rgb = pixel.rgb * opacity;
   *   pixel.a = pixel.a * opactiy;
   *
   * param[in] layer A <code>PP_Resource</code> corresponding to a compositor
   * layer resource.
   * param[in] opacity A <code>float</code> for the opacity value, The default
   * value is 1.0f.
   *
   * @return An int32_t containing a result code from <code>pp_errors.h</code>.
   */
  int32_t (*SetOpacity)(PP_Resource layer, float opacity);
  /**
   * Sets the blend mode which is used to composite the layer.
   *
   * param[in] layer A <code>PP_Resource</code> corresponding to a compositor
   * layer resource.
   * param[in] mode A <code>PP_BlendMode</code>. The default mode is
   * <code>PP_BLENDMODE_SRC_OVER</code>.
   *
   * @return An int32_t containing a result code from <code>pp_errors.h</code>.
   */
  int32_t (*SetBlendMode)(PP_Resource layer, PP_BlendMode mode);
  /**
   * Sets a source rectangle for a texture layer or an image layer.
   *
   * param[in] layer A <code>PP_Resource</code> corresponding to a compositor
   * layer resource.
   * param[in] rect A <code>PP_FloatRect</code> for an area of the source to
   * consider. For a texture layer, rect is in uv coordinates. For an image
   * layer, rect is in pixels. If the rect is beyond the dimensions of the
   * texture or image, <code>PP_ERROR_BADARGUMENT</code> will be returned.
   * If the layer size does not match the source rect size, bilinear scaling
   * will be used.
   *
   * @return An int32_t containing a result code from <code>pp_errors.h</code>.
   */
  int32_t (*SetSourceRect)(PP_Resource layer, const struct PP_FloatRect* rect);
  /**
   * Sets the premultiplied alpha for an texture layer.
   *
   * param[in] layer A <code>PP_Resource</code> corresponding to a compositor
   * layer resource.
   * param[in] premult A <code>PP_Bool</code> with <code>PP_TRUE</code> if
   * pre-multiplied alpha is used.
   *
   * @return An int32_t containing a result code from <code>pp_errors.h</code>.
   */
  int32_t (*SetPremultipliedAlpha)(PP_Resource layer, PP_Bool premult);
};

struct PPB_CompositorLayer_0_1 { /* dev */
  PP_Bool (*IsCompositorLayer)(PP_Resource resource);
  int32_t (*SetColor)(PP_Resource layer,
                      float red,
                      float green,
                      float blue,
                      float alpha,
                      const struct PP_Size* size);
  int32_t (*SetTexture)(PP_Resource layer,
                        PP_Resource context,
                        uint32_t texture,
                        const struct PP_Size* size,
                        struct PP_CompletionCallback cc);
  int32_t (*SetImage)(PP_Resource layer,
                      PP_Resource image_data,
                      const struct PP_Size* size,
                      struct PP_CompletionCallback cc);
  int32_t (*SetClipRect)(PP_Resource layer, const struct PP_Rect* rect);
  int32_t (*SetTransform)(PP_Resource layer, const float matrix[16]);
  int32_t (*SetOpacity)(PP_Resource layer, float opacity);
  int32_t (*SetBlendMode)(PP_Resource layer, PP_BlendMode mode);
  int32_t (*SetSourceRect)(PP_Resource layer, const struct PP_FloatRect* rect);
  int32_t (*SetPremultipliedAlpha)(PP_Resource layer, PP_Bool premult);
};
/**
 * @}
 */

/* ppb_console.idl */
/**
 * @addtogroup Enums
 * @{
 */
typedef enum {
  PP_LOGLEVEL_TIP = 0,
  PP_LOGLEVEL_LOG = 1,
  PP_LOGLEVEL_WARNING = 2,
  PP_LOGLEVEL_ERROR = 3
} PP_LogLevel;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_LogLevel, 4);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
struct PPB_Console_1_0 {
  /**
   * Logs the given message to the JavaScript console associated with the
   * given plugin instance with the given logging level. The name of the plugin
   * issuing the log message will be automatically prepended to the message.
   * The value may be any type of Var.
   */
  void (*Log)(PP_Instance instance, PP_LogLevel level, struct PP_Var value);
  /**
   * Logs a message to the console with the given source information rather
   * than using the internal PPAPI plugin name. The name must be a string var.
   *
   * The regular log function will automatically prepend the name of your
   * plugin to the message as the "source" of the message. Some plugins may
   * wish to override this. For example, if your plugin is a Python
   * interpreter, you would want log messages to contain the source .py file
   * doing the log statement rather than have "python" show up in the console.
   */
  void (*LogWithSource)(PP_Instance instance,
                        PP_LogLevel level,
                        struct PP_Var source,
                        struct PP_Var value);
};

typedef struct PPB_Console_1_0 PPB_Console;
/**
 * @}
 */

/* ppb_core.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPB_Core</code> interface contains pointers to functions related
 * to memory management, time, and threads on the browser.
 *
 */
struct PPB_Core_1_0 {
  /**
   *
   * AddRefResource() adds a reference to a resource.
   *
   * @param[in] config A <code>PP_Resource</code> corresponding to a
   * resource.
   */
  void (*AddRefResource)(PP_Resource resource);
  /**
   * ReleaseResource() removes a reference from a resource.
   *
   * @param[in] config A <code>PP_Resource</code> corresponding to a
   * resource.
   */
  void (*ReleaseResource)(PP_Resource resource);
  /**
   * GetTime() returns the "wall clock time" according to the
   * browser.
   *
   * @return A <code>PP_Time</code> containing the "wall clock time" according
   * to the browser.
   */
  PP_Time (*GetTime)(void);
  /**
   * GetTimeTicks() returns the "tick time" according to the browser.
   * This clock is used by the browser when passing some event times to the
   * module (e.g. using the <code>PP_InputEvent::time_stamp_seconds</code>
   * field). It is not correlated to any actual wall clock time
   * (like GetTime()). Because of this, it will not run change if the user
   * changes their computer clock.
   *
   * @return A <code>PP_TimeTicks</code> containing the "tick time" according
   * to the browser.
   */
  PP_TimeTicks (*GetTimeTicks)(void);
  /**
   * CallOnMainThread() schedules work to be executed on the main module thread
   * after the specified delay. The delay may be 0 to specify a call back as
   * soon as possible.
   *
   * The <code>result</code> parameter will just be passed as the second
   * argument to the callback. Many applications won't need this, but it allows
   * a module to emulate calls of some callbacks which do use this value.
   *
   * <strong>Note:</strong> CallOnMainThread, even when used from the main
   * thread with a delay of 0 milliseconds, will never directly invoke the
   * callback.  Even in this case, the callback will be scheduled
   * asynchronously.
   *
   * <strong>Note:</strong> If the browser is shutting down or if the module
   * has no instances, then the callback function may not be called.
   *
   * @param[in] delay_in_milliseconds An int32_t delay in milliseconds.
   * @param[in] callback A <code>PP_CompletionCallback</code> callback function
   * that the browser will call after the specified delay.
   * @param[in] result An int32_t that the browser will pass to the given
   * <code>PP_CompletionCallback</code>.
   */
  void (*CallOnMainThread)(int32_t delay_in_milliseconds,
                           struct PP_CompletionCallback callback,
                           int32_t result);
  /**
   * IsMainThread() returns true if the current thread is the main pepper
   * thread.
   *
   * This function is useful for implementing sanity checks, and deciding if
   * dispatching using CallOnMainThread() is required.
   *
   * @return A <code>PP_Bool</code> containing <code>PP_TRUE</code> if the
   * current thread is the main pepper thread, otherwise <code>PP_FALSE</code>.
   */
  PP_Bool (*IsMainThread)(void);
};

typedef struct PPB_Core_1_0 PPB_Core;
/**
 * @}
 */

/* ppb_file_io.idl */
/**
 * @addtogroup Enums
 * @{
 */
/**
 * The PP_FileOpenFlags enum contains file open constants.
 */
typedef enum {
  /** Requests read access to a file. */
  PP_FILEOPENFLAG_READ = 1 << 0,
  /**
   * Requests write access to a file.  May be combined with
   * <code>PP_FILEOPENFLAG_READ</code> to request read and write access.
   */
  PP_FILEOPENFLAG_WRITE = 1 << 1,
  /**
   * Requests that the file be created if it does not exist.  If the file
   * already exists, then this flag is ignored unless
   * <code>PP_FILEOPENFLAG_EXCLUSIVE</code> was also specified, in which case
   * FileIO::Open() will fail.
   */
  PP_FILEOPENFLAG_CREATE = 1 << 2,
  /**
   * Requests that the file be truncated to length 0 if it exists and is a
   * regular file. <code>PP_FILEOPENFLAG_WRITE</code> must also be specified.
   */
  PP_FILEOPENFLAG_TRUNCATE = 1 << 3,
  /**
   * Requests that the file is created when this flag is combined with
   * <code>PP_FILEOPENFLAG_CREATE</code>.  If this flag is specified, and the
   * file already exists, then the FileIO::Open() call will fail.
   */
  PP_FILEOPENFLAG_EXCLUSIVE = 1 << 4,
  /**
   * Requests write access to a file, but writes will always occur at the end of
   * the file. Mututally exclusive with <code>PP_FILEOPENFLAG_WRITE</code>.
   *
   * This is only supported in version 1.2 (Chrome 29) and later.
   */
  PP_FILEOPENFLAG_APPEND = 1 << 5
} PP_FileOpenFlags;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_FileOpenFlags, 4);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPB_FileIO</code> struct is used to operate on a regular file
 * (PP_FileType_Regular).
 */
struct PPB_FileIO_1_1 {
  /**
   * Create() creates a new FileIO object.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying the instance
   * with the file.
   *
   * @return A <code>PP_Resource</code> corresponding to a FileIO if
   * successful or 0 if the module is invalid.
   */
  PP_Resource (*Create)(PP_Instance instance);
  /**
   * IsFileIO() determines if the provided resource is a FileIO.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to a FileIO.
   *
   * @return <code>PP_TRUE</code> if the resource is a
   * <code>PPB_FileIO</code>, <code>PP_FALSE</code> if the resource is
   * invalid or some type other than <code>PPB_FileIO</code>.
   */
  PP_Bool (*IsFileIO)(PP_Resource resource);
  /**
   * Open() opens the specified regular file for I/O according to the given
   * open flags, which is a bit-mask of the <code>PP_FileOpenFlags</code>
   * values. Upon success, the corresponding file is classified as "in use"
   * by this FileIO object until such time as the FileIO object is closed
   * or destroyed.
   *
   * @param[in] file_io A <code>PP_Resource</code> corresponding to a
   * FileIO.
   * @param[in] file_ref A <code>PP_Resource</code> corresponding to a file
   * reference.
   * @param[in] open_flags A bit-mask of the <code>PP_FileOpenFlags</code>
   * values.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion of Open().
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   */
  int32_t (*Open)(PP_Resource file_io,
                  PP_Resource file_ref,
                  int32_t open_flags,
                  struct PP_CompletionCallback callback);
  /**
   * Query() queries info about the file opened by this FileIO object. The
   * FileIO object must be opened, and there must be no other operations
   * pending.
   *
   * @param[in] file_io A <code>PP_Resource</code> corresponding to a
   * FileIO.
   * @param[out] info The <code>PP_FileInfo</code> structure representing all
   * information about the file.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion of Query(). <code>info</code> must remain valid until after the
   * callback runs. If you pass a blocking callback, <code>info</code> must
   * remain valid until after Query() returns.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   * PP_ERROR_FAILED will be returned if the file isn't opened, and
   * PP_ERROR_INPROGRESS will be returned if there is another operation pending.
   */
  int32_t (*Query)(PP_Resource file_io,
                   struct PP_FileInfo* info,
                   struct PP_CompletionCallback callback);
  /**
   * Touch() Updates time stamps for the file opened by this FileIO object.
   * This function will fail if the FileIO object has not been opened. The
   * FileIO object must be opened, and there must be no other operations
   * pending.
   *
   * @param[in] file_io A <code>PP_Resource</code> corresponding to a file
   * FileIO.
   * @param[in] last_access_time The last time the FileIO was accessed.
   * @param[in] last_modified_time The last time the FileIO was modified.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion of Touch().
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   * PP_ERROR_FAILED will be returned if the file isn't opened, and
   * PP_ERROR_INPROGRESS will be returned if there is another operation pending.
   */
  int32_t (*Touch)(PP_Resource file_io,
                   PP_Time last_access_time,
                   PP_Time last_modified_time,
                   struct PP_CompletionCallback callback);
  /**
   * Read() reads from an offset in the file.  The size of the buffer must be
   * large enough to hold the specified number of bytes to read.  This function
   * might perform a partial read, meaning all the requested bytes
   * might not be returned, even if the end of the file has not been reached.
   * The FileIO object must have been opened with read access.
   *
   * ReadToArray() is preferred to Read() when doing asynchronous operations.
   *
   * @param[in] file_io A <code>PP_Resource</code> corresponding to a file
   * FileIO.
   * @param[in] offset The offset into the file.
   * @param[in] buffer The buffer to hold the specified number of bytes read.
   * @param[in] bytes_to_read The number of bytes to read from
   * <code>offset</code>.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion of Read(). <code>buffer</code> must remain valid until after
   * the callback runs. If you pass a blocking callback, <code>buffer</code>
   * must remain valid until after Read() returns.
   *
   * @return The number of bytes read or an error code from
   * <code>pp_errors.h</code>. If the return value is 0, then end-of-file was
   * reached. It is valid to call Read() multiple times with a completion
   * callback to queue up parallel reads from the file, but pending reads
   * cannot be interleaved with other operations.
   */
  int32_t (*Read)(PP_Resource file_io,
                  int64_t offset,
                  char* buffer,
                  int32_t bytes_to_read,
                  struct PP_CompletionCallback callback);
  /**
   * Write() writes to an offset in the file.  This function might perform a
   * partial write. The FileIO object must have been opened with write access.
   *
   * @param[in] file_io A <code>PP_Resource</code> corresponding to a file
   * FileIO.
   * @param[in] offset The offset into the file.
   * @param[in] buffer The buffer to hold the specified number of bytes read.
   * @param[in] bytes_to_write The number of bytes to write to
   * <code>offset</code>.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion of Write().
   *
   * @return The number of bytes written or an error code from
   * <code>pp_errors.h</code>. If the return value is 0, then end-of-file was
   * reached. It is valid to call Write() multiple times with a completion
   * callback to queue up parallel writes to the file, but pending writes
   * cannot be interleaved with other operations.
   */
  int32_t (*Write)(PP_Resource file_io,
                   int64_t offset,
                   const char* buffer,
                   int32_t bytes_to_write,
                   struct PP_CompletionCallback callback);
  /**
   * SetLength() sets the length of the file.  If the file size is extended,
   * then the extended area of the file is zero-filled. The FileIO object must
   * have been opened with write access and there must be no other operations
   * pending.
   *
   * @param[in] file_io A <code>PP_Resource</code> corresponding to a file
   * FileIO.
   * @param[in] length The length of the file to be set.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion of SetLength().
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   * PP_ERROR_FAILED will be returned if the file isn't opened, and
   * PP_ERROR_INPROGRESS will be returned if there is another operation pending.
   */
  int32_t (*SetLength)(PP_Resource file_io,
                       int64_t length,
                       struct PP_CompletionCallback callback);
  /**
   * Flush() flushes changes to disk.  This call can be very expensive! The
   * FileIO object must have been opened with write access and there must be no
   * other operations pending.
   *
   * @param[in] file_io A <code>PP_Resource</code> corresponding to a file
   * FileIO.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion of Flush().
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   * PP_ERROR_FAILED will be returned if the file isn't opened, and
   * PP_ERROR_INPROGRESS will be returned if there is another operation pending.
   */
  int32_t (*Flush)(PP_Resource file_io, struct PP_CompletionCallback callback);
  /**
   * Close() cancels any IO that may be pending, and closes the FileIO object.
   * Any pending callbacks will still run, reporting
   * <code>PP_ERROR_ABORTED</code> if pending IO was interrupted.  It is not
   * valid to call Open() again after a call to this method.
   * <strong>Note:</strong> If the FileIO object is destroyed, and it is still
   * open, then it will be implicitly closed, so you are not required to call
   * Close().
   *
   * @param[in] file_io A <code>PP_Resource</code> corresponding to a file
   * FileIO.
   */
  void (*Close)(PP_Resource file_io);
  /**
   * ReadToArray() reads from an offset in the file.  A PP_ArrayOutput must be
   * provided so that output will be stored in its allocated buffer.  This
   * function might perform a partial read. The FileIO object must have been
   * opened with read access.
   *
   * @param[in] file_io A <code>PP_Resource</code> corresponding to a file
   * FileIO.
   * @param[in] offset The offset into the file.
   * @param[in] max_read_length The maximum number of bytes to read from
   * <code>offset</code>.
   * @param[in] output A <code>PP_ArrayOutput</code> to hold the output data.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion of ReadToArray().
   *
   * @return The number of bytes read or an error code from
   * <code>pp_errors.h</code>. If the return value is 0, then end-of-file was
   * reached. It is valid to call ReadToArray() multiple times with a completion
   * callback to queue up parallel reads from the file, but pending reads
   * cannot be interleaved with other operations.
   */
  int32_t (*ReadToArray)(PP_Resource file_io,
                         int64_t offset,
                         int32_t max_read_length,
                         struct PP_ArrayOutput* output,
                         struct PP_CompletionCallback callback);
};

typedef struct PPB_FileIO_1_1 PPB_FileIO;

struct PPB_FileIO_1_0 {
  PP_Resource (*Create)(PP_Instance instance);
  PP_Bool (*IsFileIO)(PP_Resource resource);
  int32_t (*Open)(PP_Resource file_io,
                  PP_Resource file_ref,
                  int32_t open_flags,
                  struct PP_CompletionCallback callback);
  int32_t (*Query)(PP_Resource file_io,
                   struct PP_FileInfo* info,
                   struct PP_CompletionCallback callback);
  int32_t (*Touch)(PP_Resource file_io,
                   PP_Time last_access_time,
                   PP_Time last_modified_time,
                   struct PP_CompletionCallback callback);
  int32_t (*Read)(PP_Resource file_io,
                  int64_t offset,
                  char* buffer,
                  int32_t bytes_to_read,
                  struct PP_CompletionCallback callback);
  int32_t (*Write)(PP_Resource file_io,
                   int64_t offset,
                   const char* buffer,
                   int32_t bytes_to_write,
                   struct PP_CompletionCallback callback);
  int32_t (*SetLength)(PP_Resource file_io,
                       int64_t length,
                       struct PP_CompletionCallback callback);
  int32_t (*Flush)(PP_Resource file_io, struct PP_CompletionCallback callback);
  void (*Close)(PP_Resource file_io);
};
/**
 * @}
 */

/* ppb_file_ref.idl */
/**
 * @addtogroup Enums
 * @{
 */
/**
 * The <code>PP_MakeDirectoryFlags</code> enum contains flags used to control
 * behavior of <code>PPB_FileRef.MakeDirectory()</code>.
 */
typedef enum {
  PP_MAKEDIRECTORYFLAG_NONE = 0 << 0,
  /** Requests that ancestor directories are created if they do not exist. */
  PP_MAKEDIRECTORYFLAG_WITH_ANCESTORS = 1 << 0,
  /**
   * Requests that the PPB_FileRef.MakeDirectory() call fails if the directory
   * already exists.
   */
  PP_MAKEDIRECTORYFLAG_EXCLUSIVE = 1 << 1
} PP_MakeDirectoryFlags;
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPB_FileRef</code> struct represents a "weak pointer" to a file in
 * a file system.  This struct contains a <code>PP_FileSystemType</code>
 * identifier and a file path string.
 */
struct PPB_FileRef_1_2 {
  /**
   * Create() creates a weak pointer to a file in the given file system. File
   * paths are POSIX style.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to a file
   * system.
   * @param[in] path A path to the file. Must begin with a '/' character.
   *
   * @return A <code>PP_Resource</code> corresponding to a file reference if
   * successful or 0 if the path is malformed.
   */
  PP_Resource (*Create)(PP_Resource file_system, const char* path);
  /**
   * IsFileRef() determines if the provided resource is a file reference.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to a file
   * reference.
   *
   * @return <code>PP_TRUE</code> if the resource is a
   * <code>PPB_FileRef</code>, <code>PP_FALSE</code> if the resource is
   * invalid or some type other than <code>PPB_FileRef</code>.
   */
  PP_Bool (*IsFileRef)(PP_Resource resource);
  /**
   * GetFileSystemType() returns the type of the file system.
   *
   * @param[in] file_ref A <code>PP_Resource</code> corresponding to a file
   * reference.
   *
   * @return A <code>PP_FileSystemType</code> with the file system type if
   * valid or <code>PP_FILESYSTEMTYPE_INVALID</code> if the provided resource
   * is not a valid file reference.
   */
  PP_FileSystemType (*GetFileSystemType)(PP_Resource file_ref);
  /**
   * GetName() returns the name of the file.
   *
   * @param[in] file_ref A <code>PP_Resource</code> corresponding to a file
   * reference.
   *
   * @return A <code>PP_Var</code> containing the name of the file.  The value
   * returned by this function does not include any path components (such as
   * the name of the parent directory, for example). It is just the name of the
   * file. Use GetPath() to get the full file path.
   */
  struct PP_Var (*GetName)(PP_Resource file_ref);
  /**
   * GetPath() returns the absolute path of the file.
   *
   * @param[in] file_ref A <code>PP_Resource</code> corresponding to a file
   * reference.
   *
   * @return A <code>PP_Var</code> containing the absolute path of the file.
   * This function fails if the file system type is
   * <code>PP_FileSystemType_External</code>.
   */
  struct PP_Var (*GetPath)(PP_Resource file_ref);
  /**
   * GetParent() returns the parent directory of this file.  If
   * <code>file_ref</code> points to the root of the filesystem, then the root
   * is returned.
   *
   * @param[in] file_ref A <code>PP_Resource</code> corresponding to a file
   * reference.
   *
   * @return A <code>PP_Resource</code> containing the parent directory of the
   * file. This function fails if the file system type is
   * <code>PP_FileSystemType_External</code>.
   */
  PP_Resource (*GetParent)(PP_Resource file_ref);
  /**
   * MakeDirectory() makes a new directory in the file system according to the
   * given <code>make_directory_flags</code>, which is a bit-mask of the
   * <code>PP_MakeDirectoryFlags</code> values.  It is not valid to make a
   * directory in the external file system.
   *
   * @param[in] file_ref A <code>PP_Resource</code> corresponding to a file
   * reference.
   * @param[in] make_directory_flags A bit-mask of the
   * <code>PP_MakeDirectoryFlags</code> values.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion of MakeDirectory().
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   */
  int32_t (*MakeDirectory)(PP_Resource directory_ref,
                           int32_t make_directory_flags,
                           struct PP_CompletionCallback callback);
  /**
   * Touch() Updates time stamps for a file.  You must have write access to the
   * file if it exists in the external filesystem.
   *
   * @param[in] file_ref A <code>PP_Resource</code> corresponding to a file
   * reference.
   * @param[in] last_access_time The last time the file was accessed.
   * @param[in] last_modified_time The last time the file was modified.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion of Touch().
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   */
  int32_t (*Touch)(PP_Resource file_ref,
                   PP_Time last_access_time,
                   PP_Time last_modified_time,
                   struct PP_CompletionCallback callback);
  /**
   * Delete() deletes a file or directory. If <code>file_ref</code> refers to
   * a directory, then the directory must be empty. It is an error to delete a
   * file or directory that is in use.  It is not valid to delete a file in
   * the external file system.
   *
   * @param[in] file_ref A <code>PP_Resource</code> corresponding to a file
   * reference.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion of Delete().
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   */
  int32_t (*Delete)(PP_Resource file_ref,
                    struct PP_CompletionCallback callback);
  /**
   * Rename() renames a file or directory.  Arguments <code>file_ref</code> and
   * <code>new_file_ref</code> must both refer to files in the same file
   * system. It is an error to rename a file or directory that is in use.  It
   * is not valid to rename a file in the external file system.
   *
   * @param[in] file_ref A <code>PP_Resource</code> corresponding to a file
   * reference.
   * @param[in] new_file_ref A <code>PP_Resource</code> corresponding to a new
   * file reference.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion of Rename().
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   */
  int32_t (*Rename)(PP_Resource file_ref,
                    PP_Resource new_file_ref,
                    struct PP_CompletionCallback callback);
  /**
   * Query() queries info about a file or directory. You must have access to
   * read this file or directory if it exists in the external filesystem.
   *
   * @param[in] file_ref A <code>PP_Resource</code> corresponding to a file
   * reference.
   * @param[out] info A pointer to a <code>PP_FileInfo</code> which will be
   * populated with information about the file or directory.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion of Query().
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   */
  int32_t (*Query)(PP_Resource file_ref,
                   struct PP_FileInfo* info,
                   struct PP_CompletionCallback callback);
  /**
   * ReadDirectoryEntries() reads all entries in a directory.
   *
   * @param[in] file_ref A <code>PP_Resource</code> corresponding to a directory
   * reference.
   * @param[in] output An output array which will receive
   * <code>PP_DirectoryEntry</code> objects on success.
   * @param[in] callback A <code>PP_CompletionCallback</code> to run on
   * completion.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   */
  int32_t (*ReadDirectoryEntries)(PP_Resource file_ref,
                                  struct PP_ArrayOutput output,
                                  struct PP_CompletionCallback callback);
};

typedef struct PPB_FileRef_1_2 PPB_FileRef;

struct PPB_FileRef_1_0 {
  PP_Resource (*Create)(PP_Resource file_system, const char* path);
  PP_Bool (*IsFileRef)(PP_Resource resource);
  PP_FileSystemType (*GetFileSystemType)(PP_Resource file_ref);
  struct PP_Var (*GetName)(PP_Resource file_ref);
  struct PP_Var (*GetPath)(PP_Resource file_ref);
  PP_Resource (*GetParent)(PP_Resource file_ref);
  int32_t (*MakeDirectory)(PP_Resource directory_ref,
                           PP_Bool make_ancestors,
                           struct PP_CompletionCallback callback);
  int32_t (*Touch)(PP_Resource file_ref,
                   PP_Time last_access_time,
                   PP_Time last_modified_time,
                   struct PP_CompletionCallback callback);
  int32_t (*Delete)(PP_Resource file_ref,
                    struct PP_CompletionCallback callback);
  int32_t (*Rename)(PP_Resource file_ref,
                    PP_Resource new_file_ref,
                    struct PP_CompletionCallback callback);
};

struct PPB_FileRef_1_1 {
  PP_Resource (*Create)(PP_Resource file_system, const char* path);
  PP_Bool (*IsFileRef)(PP_Resource resource);
  PP_FileSystemType (*GetFileSystemType)(PP_Resource file_ref);
  struct PP_Var (*GetName)(PP_Resource file_ref);
  struct PP_Var (*GetPath)(PP_Resource file_ref);
  PP_Resource (*GetParent)(PP_Resource file_ref);
  int32_t (*MakeDirectory)(PP_Resource directory_ref,
                           PP_Bool make_ancestors,
                           struct PP_CompletionCallback callback);
  int32_t (*Touch)(PP_Resource file_ref,
                   PP_Time last_access_time,
                   PP_Time last_modified_time,
                   struct PP_CompletionCallback callback);
  int32_t (*Delete)(PP_Resource file_ref,
                    struct PP_CompletionCallback callback);
  int32_t (*Rename)(PP_Resource file_ref,
                    PP_Resource new_file_ref,
                    struct PP_CompletionCallback callback);
  int32_t (*Query)(PP_Resource file_ref,
                   struct PP_FileInfo* info,
                   struct PP_CompletionCallback callback);
  int32_t (*ReadDirectoryEntries)(PP_Resource file_ref,
                                  struct PP_ArrayOutput output,
                                  struct PP_CompletionCallback callback);
};
/**
 * @}
 */

/* ppb_file_system.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPB_FileSystem</code> struct identifies the file system type
 * associated with a file.
 */
struct PPB_FileSystem_1_0 {
  /** Create() creates a file system object of the given type.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying the instance
   * with the file.
   * @param[in] type A file system type as defined by
   * <code>PP_FileSystemType</code> enum (except PP_FILESYSTEMTYPE_ISOLATED,
   * which is currently not supported).
   * @return A <code>PP_Resource</code> corresponding to a file system if
   * successful.
   */
  PP_Resource (*Create)(PP_Instance instance, PP_FileSystemType type);
  /**
   * IsFileSystem() determines if the provided resource is a file system.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to a file
   * system.
   *
   * @return <code>PP_TRUE</code> if the resource is a
   * <code>PPB_FileSystem</code>, <code>PP_FALSE</code> if the resource is
   * invalid or some type other than <code>PPB_FileSystem</code>.
   */
  PP_Bool (*IsFileSystem)(PP_Resource resource);
  /**
   * Open() opens the file system. A file system must be opened before running
   * any other operation on it.
   *
   * @param[in] file_system A <code>PP_Resource</code> corresponding to a file
   * system.
   *
   * @param[in] expected_size The expected size of the file system. Note that
   * this does not request quota; to do that, you must either invoke
   * requestQuota from JavaScript:
   * http://www.html5rocks.com/en/tutorials/file/filesystem/#toc-requesting-quota
   * or set the unlimitedStorage permission for Chrome Web Store apps:
   * http://code.google.com/chrome/extensions/manifest.html#permissions
   *
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion of Open().
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   */
  int32_t (*Open)(PP_Resource file_system,
                  int64_t expected_size,
                  struct PP_CompletionCallback callback);
  /**
   * GetType() returns the type of the provided file system.
   *
   * @param[in] file_system A <code>PP_Resource</code> corresponding to a file
   * system.
   *
   * @return A <code>PP_FileSystemType</code> with the file system type if
   * valid or <code>PP_FILESYSTEMTYPE_INVALID</code> if the provided resource
   * is not a valid file system. It is valid to call this function even before
   * Open() completes.
   */
  PP_FileSystemType (*GetType)(PP_Resource file_system);
};

typedef struct PPB_FileSystem_1_0 PPB_FileSystem;
/**
 * @}
 */

/* ppb_fullscreen.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPB_Fullscreen</code> interface is implemented by the browser.
 * This interface provides a way of checking the current screen mode and
 * toggling fullscreen mode.
 */
struct PPB_Fullscreen_1_0 {
  /**
   * IsFullscreen() checks whether the module instance is currently in
   * fullscreen mode.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying one instance
   * of a module.
   *
   * @return <code>PP_TRUE</code> if the module instance is in fullscreen mode,
   * <code>PP_FALSE</code> if the module instance is not in fullscreen mode.
   */
  PP_Bool (*IsFullscreen)(PP_Instance instance);
  /**
   * SetFullscreen() switches the module instance to and from fullscreen
   * mode.
   *
   * The transition to and from fullscreen mode is asynchronous. During the
   * transition, IsFullscreen() will return the previous value and
   * no 2D or 3D device can be bound. The transition ends at DidChangeView()
   * when IsFullscreen() returns the new value. You might receive other
   * DidChangeView() calls while in transition.
   *
   * The transition to fullscreen mode can only occur while the browser is
   * processing a user gesture, even if <code>PP_TRUE</code> is returned.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying one instance
   * of a module.
   * @param[in] fullscreen <code>PP_TRUE</code> to enter fullscreen mode, or
   * <code>PP_FALSE</code> to exit fullscreen mode.
   *
   * @return <code>PP_TRUE</code> on success or <code>PP_FALSE</code> on
   * failure.
   */
  PP_Bool (*SetFullscreen)(PP_Instance instance, PP_Bool fullscreen);
  /**
   * GetScreenSize() gets the size of the screen in pixels. The module instance
   * will be resized to this size when SetFullscreen() is called to enter
   * fullscreen mode.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying one instance
   * of a module.
   * @param[out] size The size of the entire screen in pixels.
   *
   * @return <code>PP_TRUE</code> on success or <code>PP_FALSE</code> on
   * failure.
   */
  PP_Bool (*GetScreenSize)(PP_Instance instance, struct PP_Size* size);
};

typedef struct PPB_Fullscreen_1_0 PPB_Fullscreen;
/**
 * @}
 */

/* ppb_gamepad.idl */
/**
 * @addtogroup Structs
 * @{
 */
/**
 * The data for one gamepad device.
 */
struct PP_GamepadSampleData {
  /**
   * Number of valid elements in the |axes| array.
   */
  uint32_t axes_length;
  /**
   * Normalized values for the axes, indices valid up to |axes_length|-1. Axis
   * values range from -1..1, and are in order of "importance".
   */
  float axes[16];
  /**
   * Number of valid elements in the |buttons| array.
   */
  uint32_t buttons_length;
  /**
   * Normalized values for the buttons, indices valid up to |buttons_length|
   * - 1. Button values range from 0..1, and are in order of importance.
   */
  float buttons[32];
  /**
   * Monotonically increasing value that is incremented when the data have
   * been updated.
   */
  double timestamp;
  /**
   * Identifier for the type of device/manufacturer.
   */
  uint16_t id[128];
  /**
   * Is there a gamepad connected at this index? If this is false, no other
   * data in this structure is valid.
   */
  PP_Bool connected;
  /* Padding to make the struct the same size between 64 and 32. */
  int8_t unused_pad_[4];
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_GamepadSampleData, 472);

/**
 * The data for all gamepads connected to the system.
 */
struct PP_GamepadsSampleData {
  /**
   * Number of valid elements in the |items| array.
   */
  uint32_t length;
  /* Padding to make the struct the same size between 64 and 32. */
  int8_t unused_pad_[4];
  /**
   * Data for an individual gamepad device connected to the system.
   */
  struct PP_GamepadSampleData items[4];
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_GamepadsSampleData, 1896);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPB_Gamepad</code> interface allows retrieving data from
 * gamepad/joystick devices that are connected to the system.
 */
struct PPB_Gamepad_1_0 {
  /**
   * Samples the current state of the available gamepads.
   */
  void (*Sample)(PP_Instance instance, struct PP_GamepadsSampleData* data);
};

typedef struct PPB_Gamepad_1_0 PPB_Gamepad;
/**
 * @}
 */

/* ppb_graphics_2d.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * <code>PPB_Graphics2D</code> defines the interface for a 2D graphics context.
 */
struct PPB_Graphics2D_1_2 {
  /**
   * Create() creates a 2D graphics context. The returned graphics context will
   * not be bound to the module instance on creation (call BindGraphics() on
   * the module instance to bind the returned graphics context to the module
   * instance).
   *
   * @param[in] instance The module instance.
   * @param[in] size The size of the graphic context.
   * @param[in] is_always_opaque Set the <code>is_always_opaque</code> flag to
   * <code>PP_TRUE</code> if you know that you will be painting only opaque
   * data to this context. This option will disable blending when compositing
   * the module with the web page, which might give higher performance on some
   * computers.
   *
   * If you set <code>is_always_opaque</code>, your alpha channel should always
   * be set to 0xFF or there may be painting artifacts. The alpha values
   * overwrite the destination alpha values without blending when
   * <code>is_always_opaque</code> is true.
   *
   * @return A <code>PP_Resource</code> containing the 2D graphics context if
   * successful or 0 if unsuccessful.
   */
  PP_Resource (*Create)(PP_Instance instance,
                        const struct PP_Size* size,
                        PP_Bool is_always_opaque);
  /**
   * IsGraphics2D() determines if the given resource is a valid
   * <code>Graphics2D</code>.
   *
   * @param[in] resource A <code>Graphics2D</code> context resource.
   *
   * @return PP_TRUE if the given resource is a valid <code>Graphics2D</code>,
   * <code>PP_FALSE</code> if it is an invalid resource or is a resource of
   * another type.
   */
  PP_Bool (*IsGraphics2D)(PP_Resource resource);
  /**
   * Describe() retrieves the configuration for the given graphics context,
   * filling the given values (which must not be <code>NULL</code>).
   *
   * @param[in] resource The 2D Graphics resource.
   * @param[in,out] size The size of the 2D graphics context in the browser.
   * @param[in,out] is_always_opaque Identifies whether only opaque data
   * will be painted.
   *
   * @return Returns <code>PP_TRUE</code> on success or <code>PP_FALSE</code> if
   * the resource is invalid. The output parameters will be set to 0 on a
   * <code>PP_FALSE</code>.
   */
  PP_Bool (*Describe)(PP_Resource graphics_2d,
                      struct PP_Size* size,
                      PP_Bool* is_always_opaque);
  /**
   * PaintImageData() enqueues a paint of the given image into the context.
   * This function has no effect until you call Flush() As a result, what
   * counts is the contents of the bitmap when you call Flush(), not when
   * you call this function.
   *
   * The provided image will be placed at <code>top_left</code> from the top
   *  left of the context's internal backing store. Then the pixels contained
   * in <code>src_rect</code> will be copied into the backing store. This
   * means that the rectangle being painted will be at <code>src_rect</code>
   * offset by <code>top_left</code>.
   *
   * The <code>src_rect</code> is specified in the coordinate system of the
   * image being painted, not the context. For the common case of copying the
   * entire image, you may specify an empty <code>src_rect</code>.
   *
   * The painted area of the source bitmap must fall entirely within the
   * context. Attempting to paint outside of the context will result in an
   * error. However, the source bitmap may fall outside the context, as long
   * as the <code>src_rect</code> subset of it falls entirely within the
   * context.
   *
   * There are two methods most modules will use for painting. The first
   * method is to generate a new <code>ImageData</code> and then paint it. In
   * this case, you'll set the location of your painting to
   * <code>top_left</code> and set <code>src_rect</code> to <code>NULL</code>.
   * The second is that you're generating small invalid regions out of a larger
   * bitmap representing your entire instance. In this case, you would set the
   * location of your image to (0,0) and then set <code>src_rect</code> to the
   * pixels you changed.
   *
   * @param[in] resource The 2D Graphics resource.
   * @param[in] image The <code>ImageData</code> to be painted.
   * @param[in] top_left A <code>Point</code> representing the
   * <code>top_left</code> location where the <code>ImageData</code> will be
   * painted.
   * @param[in] src_rect The rectangular area where the <code>ImageData</code>
   * will be painted.
   */
  void (*PaintImageData)(PP_Resource graphics_2d,
                         PP_Resource image_data,
                         const struct PP_Point* top_left,
                         const struct PP_Rect* src_rect);
  /**
   * Scroll() enqueues a scroll of the context's backing store. This
   * function has no effect until you call Flush(). The data within the
   * provided clipping rectangle will be shifted by (dx, dy) pixels.
   *
   * This function will result in some exposed region which will have undefined
   * contents. The module should call PaintImageData() on these exposed regions
   * to give the correct contents.
   *
   * The scroll can be larger than the area of the clipping rectangle, which
   * means the current image will be scrolled out of the rectangle. This
   * scenario is not an error but will result in a no-op.
   *
   * @param[in] graphics_2d The 2D Graphics resource.
   * @param[in] clip The clipping rectangle.
   * @param[in] amount The amount the area in the clipping rectangle will
   * shifted.
   */
  void (*Scroll)(PP_Resource graphics_2d,
                 const struct PP_Rect* clip_rect,
                 const struct PP_Point* amount);
  /**
   * ReplaceContents() provides a slightly more efficient way to paint the
   * entire module's image. Normally, calling PaintImageData() requires that
   * the browser copy the pixels out of the image and into the graphics
   * context's backing store. This function replaces the graphics context's
   * backing store with the given image, avoiding the copy.
   *
   * The new image must be the exact same size as this graphics context. If the
   * new image uses a different image format than the browser's native bitmap
   * format (use <code>PPB_ImageData.GetNativeImageDataFormat()</code> to
   * retrieve the format), then a conversion will be done inside the browser
   * which may slow the performance a little bit.
   *
   * <strong>Note:</strong> The new image will not be painted until you call
   * Flush().
   *
   * After this call, you should take care to release your references to the
   * image. If you paint to the image after ReplaceContents(), there is the
   * possibility of significant painting artifacts because the page might use
   * partially-rendered data when copying out of the backing store.
   *
   * In the case of an animation, you will want to allocate a new image for the
   * next frame. It is best if you wait until the flush callback has executed
   * before allocating this bitmap. This gives the browser the option of
   * caching the previous backing store and handing it back to you (assuming
   * the sizes match). In the optimal case, this means no bitmaps are allocated
   * during the animation, and the backing store and "front buffer" (which the
   * plugin is painting into) are just being swapped back and forth.
   *
   * @param[in] graphics_2d The 2D Graphics resource.
   * @param[in] image The <code>ImageData</code> to be painted.
   */
  void (*ReplaceContents)(PP_Resource graphics_2d, PP_Resource image_data);
  /**
   * Flush() flushes any enqueued paint, scroll, and replace commands to the
   * backing store. This function actually executes the updates, and causes a
   * repaint of the webpage, assuming this graphics context is bound to a module
   * instance.
   *
   * Flush() runs in asynchronous mode. Specify a callback function and the
   * argument for that callback function. The callback function will be
   * executed on the calling thread when the image has been painted to the
   * screen. While you are waiting for a flush callback, additional calls to
   * Flush() will fail.
   *
   * Because the callback is executed (or thread unblocked) only when the
   * instance's image is actually on the screen, this function provides
   * a way to rate limit animations. By waiting until the image is on the
   * screen before painting the next frame, you can ensure you're not
   * flushing 2D graphics faster than the screen can be updated.
   *
   * <strong>Unbound contexts</strong>
   * If the context is not bound to a module instance, you will
   * still get a callback. The callback will execute after Flush() returns
   * to avoid reentrancy. The callback will not wait until anything is
   * painted to the screen because there will be nothing on the screen. The
   * timing of this callback is not guaranteed and may be deprioritized by
   * the browser because it is not affecting the user experience.
   *
   * <strong>Off-screen instances</strong>
   * If the context is bound to an instance that is currently not visible (for
   * example, scrolled out of view) it will behave like the "unbound context"
   * case.
   *
   * <strong>Detaching a context</strong>
   * If you detach a context from a module instance, any pending flush
   * callbacks will be converted into the "unbound context" case.
   *
   * <strong>Released contexts</strong>
   * A callback may or may not get called even if you have released all
   * of your references to the context. This scenario can occur if there are
   * internal references to the context suggesting it has not been internally
   * destroyed (for example, if it is still bound to an instance) or due to
   * other implementation details. As a result, you should be careful to
   * check that flush callbacks are for the context you expect and that
   * you're capable of handling callbacks for unreferenced contexts.
   *
   * <strong>Shutdown</strong>
   * If a module instance is removed when a flush is pending, the
   * callback will not be executed.
   *
   * @param[in] graphics_2d The 2D Graphics resource.
   * @param[in] callback A <code>CompletionCallback</code> to be called when
   * the image has been painted on the screen.
   *
   * @return Returns <code>PP_OK</code> on success or
   * <code>PP_ERROR_BADRESOURCE</code> if the graphics context is invalid,
   * <code>PP_ERROR_BADARGUMENT</code> if the callback is null and flush is
   * being called from the main thread of the module, or
   * <code>PP_ERROR_INPROGRESS</code> if a flush is already pending that has
   * not issued its callback yet.  In the failure case, nothing will be updated
   * and no callback will be scheduled.
   */
  int32_t (*Flush)(PP_Resource graphics_2d,
                   struct PP_CompletionCallback callback);
  /**
   * SetScale() sets the scale factor that will be applied when painting the
   * graphics context onto the output device. Typically, if rendering at device
   * resolution is desired, the context would be created with the width and
   * height scaled up by the view's GetDeviceScale and SetScale called with a
   * scale of 1.0 / GetDeviceScale(). For example, if the view resource passed
   * to DidChangeView has a rectangle of (w=200, h=100) and a device scale of
   * 2.0, one would call Create with a size of (w=400, h=200) and then call
   * SetScale with 0.5. One would then treat each pixel in the context as a
   * single device pixel.
   *
   * @param[in] resource A <code>Graphics2D</code> context resource.
   * @param[in] scale The scale to apply when painting.
   *
   * @return Returns <code>PP_TRUE</code> on success or <code>PP_FALSE</code> if
   * the resource is invalid or the scale factor is 0 or less.
   */
  PP_Bool (*SetScale)(PP_Resource resource, float scale);
  /***
   * GetScale() gets the scale factor that will be applied when painting the
   * graphics context onto the output device.
   *
   * @param[in] resource A <code>Graphics2D</code> context resource.
   *
   * @return Returns the scale factor for the graphics context. If the resource
   * is not a valid <code>Graphics2D</code> context, this will return 0.0.
   */
  float (*GetScale)(PP_Resource resource);
  /**
   * SetLayerTransform() sets a transformation factor that will be applied for
   * the current graphics context displayed on the output device.  If both
   * SetScale and SetLayerTransform will be used, they are going to get combined
   * for the final result.
   *
   * This function has no effect until you call Flush().
   *
   * @param[in] scale The scale to be applied.
   * @param[in] origin The origin of the scale.
   * @param[in] translate The translation to be applied.
   *
   * @return Returns <code>PP_TRUE</code> on success or <code>PP_FALSE</code>
   * if the resource is invalid or the scale factor is 0 or less.
   */
  PP_Bool (*SetLayerTransform)(PP_Resource resource,
                               float scale,
                               const struct PP_Point* origin,
                               const struct PP_Point* translate);
};

typedef struct PPB_Graphics2D_1_2 PPB_Graphics2D;

struct PPB_Graphics2D_1_0 {
  PP_Resource (*Create)(PP_Instance instance,
                        const struct PP_Size* size,
                        PP_Bool is_always_opaque);
  PP_Bool (*IsGraphics2D)(PP_Resource resource);
  PP_Bool (*Describe)(PP_Resource graphics_2d,
                      struct PP_Size* size,
                      PP_Bool* is_always_opaque);
  void (*PaintImageData)(PP_Resource graphics_2d,
                         PP_Resource image_data,
                         const struct PP_Point* top_left,
                         const struct PP_Rect* src_rect);
  void (*Scroll)(PP_Resource graphics_2d,
                 const struct PP_Rect* clip_rect,
                 const struct PP_Point* amount);
  void (*ReplaceContents)(PP_Resource graphics_2d, PP_Resource image_data);
  int32_t (*Flush)(PP_Resource graphics_2d,
                   struct PP_CompletionCallback callback);
};

struct PPB_Graphics2D_1_1 {
  PP_Resource (*Create)(PP_Instance instance,
                        const struct PP_Size* size,
                        PP_Bool is_always_opaque);
  PP_Bool (*IsGraphics2D)(PP_Resource resource);
  PP_Bool (*Describe)(PP_Resource graphics_2d,
                      struct PP_Size* size,
                      PP_Bool* is_always_opaque);
  void (*PaintImageData)(PP_Resource graphics_2d,
                         PP_Resource image_data,
                         const struct PP_Point* top_left,
                         const struct PP_Rect* src_rect);
  void (*Scroll)(PP_Resource graphics_2d,
                 const struct PP_Rect* clip_rect,
                 const struct PP_Point* amount);
  void (*ReplaceContents)(PP_Resource graphics_2d, PP_Resource image_data);
  int32_t (*Flush)(PP_Resource graphics_2d,
                   struct PP_CompletionCallback callback);
  PP_Bool (*SetScale)(PP_Resource resource, float scale);
  float (*GetScale)(PP_Resource resource);
};
/**
 * @}
 */

/* ppb_graphics_3d.idl */
/* Add 3D graphics enums */
#include "ppapi/c/pp_graphics_3d.h"

/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * <code>PPB_Graphics3D</code> defines the interface for a 3D graphics context.
 * <strong>Example usage from plugin code:</strong>
 *
 * <strong>Setup:</strong>
 * @code
 * PP_Resource context;
 * int32_t attribs[] = {PP_GRAPHICS3DATTRIB_WIDTH, 800,
 *                      PP_GRAPHICS3DATTRIB_HEIGHT, 800,
 *                      PP_GRAPHICS3DATTRIB_NONE};
 * context = g3d->Create(instance, 0, attribs);
 * inst->BindGraphics(instance, context);
 * @endcode
 *
 * <strong>Present one frame:</strong>
 * @code
 * PP_CompletionCallback callback = {
 *   DidFinishSwappingBuffers, 0, PP_COMPLETIONCALLBACK_FLAG_NONE,
 * };
 * gles2->Clear(context, GL_COLOR_BUFFER_BIT);
 * g3d->SwapBuffers(context, callback);
 * @endcode
 *
 * <strong>Shutdown:</strong>
 * @code
 * core->ReleaseResource(context);
 * @endcode
 */
struct PPB_Graphics3D_1_0 {
  /**
   * GetAttribMaxValue() retrieves the maximum supported value for the
   * given attribute. This function may be used to check if a particular
   * attribute value is supported before attempting to create a context.
   *
   * @param[in] instance The module instance.
   * @param[in] attribute The attribute for which maximum value is queried.
   * Attributes that can be queried for include:
   * - <code>PP_GRAPHICS3DATTRIB_ALPHA_SIZE</code>
   * - <code>PP_GRAPHICS3DATTRIB_BLUE_SIZE</code>
   * - <code>PP_GRAPHICS3DATTRIB_GREEN_SIZE</code>
   * - <code>PP_GRAPHICS3DATTRIB_RED_SIZE</code>
   * - <code>PP_GRAPHICS3DATTRIB_DEPTH_SIZE</code>
   * - <code>PP_GRAPHICS3DATTRIB_STENCIL_SIZE</code>
   * - <code>PP_GRAPHICS3DATTRIB_SAMPLES</code>
   * - <code>PP_GRAPHICS3DATTRIB_SAMPLE_BUFFERS</code>
   * - <code>PP_GRAPHICS3DATTRIB_WIDTH</code>
   * - <code>PP_GRAPHICS3DATTRIB_HEIGHT</code>
   * @param[out] value The maximum supported value for <code>attribute</code>
   *
   * @return Returns <code>PP_TRUE</code> on success or the following on error:
   * - <code>PP_ERROR_BADRESOURCE</code> if <code>instance</code> is invalid
   * - <code>PP_ERROR_BADARGUMENT</code> if <code>attribute</code> is invalid
   *   or <code>value</code> is 0
   */
  int32_t (*GetAttribMaxValue)(PP_Resource instance,
                               int32_t attribute,
                               int32_t* value);
  /**
   * Create() creates and initializes a 3D rendering context.
   * The returned context is off-screen to start with. It must be attached to
   * a plugin instance using <code>PPB_Instance::BindGraphics</code> to draw
   * on the web page.
   *
   * @param[in] instance The module instance.
   *
   * @param[in] share_context The 3D context with which the created context
   * would share resources. If <code>share_context</code> is not 0, then all
   * shareable data, as defined by the client API (note that for OpenGL and
   * OpenGL ES, shareable data excludes texture objects named 0) will be shared
   * by <code>share_context<code>, all other contexts <code>share_context</code>
   * already shares with, and the newly created context. An arbitrary number of
   * <code>PPB_Graphics3D</code> can share data in this fashion.
   *
   * @param[in] attrib_list specifies a list of attributes for the context.
   * It is a list of attribute name-value pairs in which each attribute is
   * immediately followed by the corresponding desired value. The list is
   * terminated with <code>PP_GRAPHICS3DATTRIB_NONE</code>.
   * The <code>attrib_list<code> may be 0 or empty (first attribute is
   * <code>PP_GRAPHICS3DATTRIB_NONE</code>). If an attribute is not
   * specified in <code>attrib_list</code>, then the default value is used
   * (it is said to be specified implicitly).
   * Attributes for the context are chosen according to an attribute-specific
   * criteria. Attributes can be classified into two categories:
   * - AtLeast: The attribute value in the returned context meets or exceeds
   *            the value specified in <code>attrib_list</code>.
   * - Exact: The attribute value in the returned context is equal to
   *          the value specified in <code>attrib_list</code>.
   *
   * Attributes that can be specified in <code>attrib_list</code> include:
   * - <code>PP_GRAPHICS3DATTRIB_ALPHA_SIZE</code>:
   *   Category: AtLeast Default: 0.
   * - <code>PP_GRAPHICS3DATTRIB_BLUE_SIZE</code>:
   *   Category: AtLeast Default: 0.
   * - <code>PP_GRAPHICS3DATTRIB_GREEN_SIZE</code>:
   *   Category: AtLeast Default: 0.
   * - <code>PP_GRAPHICS3DATTRIB_RED_SIZE</code>:
   *   Category: AtLeast Default: 0.
   * - <code>PP_GRAPHICS3DATTRIB_DEPTH_SIZE</code>:
   *   Category: AtLeast Default: 0.
   * - <code>PP_GRAPHICS3DATTRIB_STENCIL_SIZE</code>:
   *   Category: AtLeast Default: 0.
   * - <code>PP_GRAPHICS3DATTRIB_SAMPLES</code>:
   *   Category: AtLeast Default: 0.
   * - <code>PP_GRAPHICS3DATTRIB_SAMPLE_BUFFERS</code>:
   *   Category: AtLeast Default: 0.
   * - <code>PP_GRAPHICS3DATTRIB_WIDTH</code>:
   *   Category: Exact Default: 0.
   * - <code>PP_GRAPHICS3DATTRIB_HEIGHT</code>:
   *   Category: Exact Default: 0.
   * - <code>PP_GRAPHICS3DATTRIB_SWAP_BEHAVIOR</code>:
   *   Category: Exact Default: Implementation defined.
   *
   * @return A <code>PP_Resource</code> containing the 3D graphics context if
   * successful or 0 if unsuccessful.
   */
  PP_Resource (*Create)(PP_Instance instance,
                        PP_Resource share_context,
                        const int32_t attrib_list[]);
  /**
   * IsGraphics3D() determines if the given resource is a valid
   * <code>Graphics3D</code> context.
   *
   * @param[in] resource A <code>Graphics3D</code> context resource.
   *
   * @return PP_TRUE if the given resource is a valid <code>Graphics3D</code>,
   * <code>PP_FALSE</code> if it is an invalid resource or is a resource of
   * another type.
   */
  PP_Bool (*IsGraphics3D)(PP_Resource resource);
  /**
   * GetAttribs() retrieves the value for each attribute in
   * <code>attrib_list</code>.
   *
   * @param[in] context The 3D graphics context.
   * @param[in,out] attrib_list The list of attributes that are queried.
   * <code>attrib_list</code> has the same structure as described for
   * <code>PPB_Graphics3D::Create</code>. It is both input and output
   * structure for this function. All attributes specified in
   * <code>PPB_Graphics3D::Create</code> can be queried for.
   *
   * @return Returns <code>PP_OK</code> on success or:
   * - <code>PP_ERROR_BADRESOURCE</code> if context is invalid
   * - <code>PP_ERROR_BADARGUMENT</code> if attrib_list is 0 or any attribute
   *   in the <code>attrib_list</code> is not a valid attribute.
   *
   * <strong>Example usage:</strong> To get the values for rgb bits in the
   * color buffer, this function must be called as following:
   * @code
   * int attrib_list[] = {PP_GRAPHICS3DATTRIB_RED_SIZE, 0,
   *                      PP_GRAPHICS3DATTRIB_GREEN_SIZE, 0,
   *                      PP_GRAPHICS3DATTRIB_BLUE_SIZE, 0,
   *                      PP_GRAPHICS3DATTRIB_NONE};
   * GetAttribs(context, attrib_list);
   * int red_bits = attrib_list[1];
   * int green_bits = attrib_list[3];
   * int blue_bits = attrib_list[5];
   * @endcode
   */
  int32_t (*GetAttribs)(PP_Resource context, int32_t attrib_list[]);
  /**
   * SetAttribs() sets the values for each attribute in
   * <code>attrib_list</code>.
   *
   * @param[in] context The 3D graphics context.
   * @param[in] attrib_list The list of attributes whose values need to be set.
   * <code>attrib_list</code> has the same structure as described for
   * <code>PPB_Graphics3D::Create</code>.
   * Attributes that can be specified are:
   * - <code>PP_GRAPHICS3DATTRIB_SWAP_BEHAVIOR</code>
   *
   * @return Returns <code>PP_OK</code> on success or:
   * - <code>PP_ERROR_BADRESOURCE</code> if <code>context</code> is invalid.
   * - <code>PP_ERROR_BADARGUMENT</code> if <code>attrib_list</code> is 0 or
   *   any attribute in the <code>attrib_list</code> is not a valid attribute.
   */
  int32_t (*SetAttribs)(PP_Resource context, const int32_t attrib_list[]);
  /**
   * GetError() returns the current state of the given 3D context.
   *
   * The recoverable error conditions that have no side effect are
   * detected and returned immediately by all functions in this interface.
   * In addition the implementation may get into a fatal state while
   * processing a command. In this case the application must destroy the
   * context and reinitialize client API state and objects to continue
   * rendering.
   *
   * Note that the same error code is also returned in the SwapBuffers callback.
   * It is recommended to handle error in the SwapBuffers callback because
   * GetError is synchronous. This function may be useful in rare cases where
   * drawing a frame is expensive and you want to verify the result of
   * ResizeBuffers before attempting to draw a frame.
   *
   * @param[in] The 3D graphics context.
   * @return Returns:
   * - <code>PP_OK</code> if no error
   * - <code>PP_ERROR_NOMEMORY</code>
   * - <code>PP_ERROR_CONTEXT_LOST</code>
   */
  int32_t (*GetError)(PP_Resource context);
  /**
   * ResizeBuffers() resizes the backing surface for context.
   *
   * If the surface could not be resized due to insufficient resources,
   * <code>PP_ERROR_NOMEMORY</code> error is returned on the next
   * <code>SwapBuffers</code> callback.
   *
   * @param[in] context The 3D graphics context.
   * @param[in] width The width of the backing surface.
   * @param[in] height The height of the backing surface.
   * @return Returns <code>PP_OK</code> on success or:
   * - <code>PP_ERROR_BADRESOURCE</code> if context is invalid.
   * - <code>PP_ERROR_BADARGUMENT</code> if the value specified for
   *   <code>width</code> or <code>height</code> is less than zero.
   */
  int32_t (*ResizeBuffers)(PP_Resource context, int32_t width, int32_t height);
  /**
   * SwapBuffers() makes the contents of the color buffer available for
   * compositing. This function has no effect on off-screen surfaces - ones not
   * bound to any plugin instance. The contents of ancillary buffers are always
   * undefined after calling <code>SwapBuffers</code>. The contents of the color
   * buffer are undefined if the value of the
   * <code>PP_GRAPHICS3DATTRIB_SWAP_BEHAVIOR</code> attribute of context is not
   * <code>PP_GRAPHICS3DATTRIB_BUFFER_PRESERVED</code>.
   *
   * <code>SwapBuffers</code> runs in asynchronous mode. Specify a callback
   * function and the argument for that callback function. The callback function
   * will be executed on the calling thread after the color buffer has been
   * composited with rest of the html page. While you are waiting for a
   * SwapBuffers callback, additional calls to SwapBuffers will fail.
   *
   * Because the callback is executed (or thread unblocked) only when the
   * plugin's current state is actually on the screen, this function provides a
   * way to rate limit animations. By waiting until the image is on the screen
   * before painting the next frame, you can ensure you're not generating
   * updates faster than the screen can be updated.
   *
   * SwapBuffers performs an implicit flush operation on context.
   * If the context gets into an unrecoverable error condition while
   * processing a command, the error code will be returned as the argument
   * for the callback. The callback may return the following error codes:
   * - <code>PP_ERROR_NOMEMORY</code>
   * - <code>PP_ERROR_CONTEXT_LOST</code>
   * Note that the same error code may also be obtained by calling GetError.
   *
   * @param[in] context The 3D graphics context.
   * @param[in] callback The callback that will executed when
   * <code>SwapBuffers</code> completes.
   *
   * @return Returns PP_OK on success or:
   * - <code>PP_ERROR_BADRESOURCE</code> if context is invalid.
   * - <code>PP_ERROR_BADARGUMENT</code> if callback is invalid.
   *
   */
  int32_t (*SwapBuffers)(PP_Resource context,
                         struct PP_CompletionCallback callback);
};

typedef struct PPB_Graphics3D_1_0 PPB_Graphics3D;
/**
 * @}
 */

/* ppb_net_address.idl */
/**
 * @addtogroup Enums
 * @{
 */
/**
 * Network address family types.
 */
typedef enum {
  /**
   * The address family is unspecified.
   */
  PP_NETADDRESS_FAMILY_UNSPECIFIED = 0,
  /**
   * The Internet Protocol version 4 (IPv4) address family.
   */
  PP_NETADDRESS_FAMILY_IPV4 = 1,
  /**
   * The Internet Protocol version 6 (IPv6) address family.
   */
  PP_NETADDRESS_FAMILY_IPV6 = 2
} PP_NetAddress_Family;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_NetAddress_Family, 4);
/**
 * @}
 */

/**
 * @addtogroup Structs
 * @{
 */
/**
 * All members are expressed in network byte order.
 */
struct PP_NetAddress_IPv4 {
  /**
   * Port number.
   */
  uint16_t port;
  /**
   * IPv4 address.
   */
  uint8_t addr[4];
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_NetAddress_IPv4, 6);

/**
 * All members are expressed in network byte order.
 */
struct PP_NetAddress_IPv6 {
  /**
   * Port number.
   */
  uint16_t port;
  /**
   * IPv6 address.
   */
  uint8_t addr[16];
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_NetAddress_IPv6, 18);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPB_NetAddress</code> interface provides operations on network
 * addresses.
 */
struct PPB_NetAddress_1_0 {
  /**
   * Creates a <code>PPB_NetAddress</code> resource with the specified IPv4
   * address.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying one instance of
   * a module.
   * @param[in] ipv4_addr An IPv4 address.
   *
   * @return A <code>PP_Resource</code> representing the same address as
   * <code>ipv4_addr</code> or 0 on failure.
   */
  PP_Resource (*CreateFromIPv4Address)(
      PP_Instance instance,
      const struct PP_NetAddress_IPv4* ipv4_addr);
  /**
   * Creates a <code>PPB_NetAddress</code> resource with the specified IPv6
   * address.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying one instance of
   * a module.
   * @param[in] ipv6_addr An IPv6 address.
   *
   * @return A <code>PP_Resource</code> representing the same address as
   * <code>ipv6_addr</code> or 0 on failure.
   */
  PP_Resource (*CreateFromIPv6Address)(
      PP_Instance instance,
      const struct PP_NetAddress_IPv6* ipv6_addr);
  /**
   * Determines if a given resource is a network address.
   *
   * @param[in] resource A <code>PP_Resource</code> to check.
   *
   * @return <code>PP_TRUE</code> if the input is a <code>PPB_NetAddress</code>
   * resource; <code>PP_FALSE</code> otherwise.
   */
  PP_Bool (*IsNetAddress)(PP_Resource resource);
  /**
   * Gets the address family.
   *
   * @param[in] addr A <code>PP_Resource</code> corresponding to a network
   * address.
   *
   * @return The address family on success;
   * <code>PP_NETADDRESS_FAMILY_UNSPECIFIED</code> on failure.
   */
  PP_NetAddress_Family (*GetFamily)(PP_Resource addr);
  /**
   * Returns a human-readable description of the network address. The
   * description is in the form of host [ ":" port ] and conforms to
   * http://tools.ietf.org/html/rfc3986#section-3.2 for IPv4 and IPv6 addresses
   * (e.g., "192.168.0.1", "192.168.0.1:99", or "[::1]:80").
   *
   * @param[in] addr A <code>PP_Resource</code> corresponding to a network
   * address.
   * @param[in] include_port Whether to include the port number in the
   * description.
   *
   * @return A string <code>PP_Var</code> on success; an undefined
   * <code>PP_Var</code> on failure.
   */
  struct PP_Var (*DescribeAsString)(PP_Resource addr, PP_Bool include_port);
  /**
   * Fills a <code>PP_NetAddress_IPv4</code> structure if the network address is
   * of <code>PP_NETADDRESS_FAMILY_IPV4</code> address family.
   * Note that passing a network address of
   * <code>PP_NETADDRESS_FAMILY_IPV6</code> address family will fail even if the
   * address is an IPv4-mapped IPv6 address.
   *
   * @param[in] addr A <code>PP_Resource</code> corresponding to a network
   * address.
   * @param[out] ipv4_addr A <code>PP_NetAddress_IPv4</code> structure to store
   * the result.
   *
   * @return A <code>PP_Bool</code> value indicating whether the operation
   * succeeded.
   */
  PP_Bool (*DescribeAsIPv4Address)(PP_Resource addr,
                                   struct PP_NetAddress_IPv4* ipv4_addr);
  /**
   * Fills a <code>PP_NetAddress_IPv6</code> structure if the network address is
   * of <code>PP_NETADDRESS_FAMILY_IPV6</code> address family.
   * Note that passing a network address of
   * <code>PP_NETADDRESS_FAMILY_IPV4</code> address family will fail - this
   * method doesn't map it to an IPv6 address.
   *
   * @param[in] addr A <code>PP_Resource</code> corresponding to a network
   * address.
   * @param[out] ipv6_addr A <code>PP_NetAddress_IPv6</code> structure to store
   * the result.
   *
   * @return A <code>PP_Bool</code> value indicating whether the operation
   * succeeded.
   */
  PP_Bool (*DescribeAsIPv6Address)(PP_Resource addr,
                                   struct PP_NetAddress_IPv6* ipv6_addr);
};

typedef struct PPB_NetAddress_1_0 PPB_NetAddress;
/**
 * @}
 */

/* ppb_host_resolver.idl */
/**
 * @addtogroup Enums
 * @{
 */
/**
 * <code>PP_HostResolver_Flag</code> is an enumeration of flags which can be
 * OR-ed and passed to the host resolver. Currently there is only one flag
 * defined.
 */
typedef enum {
  /**
   * Hint to request the canonical name of the host, which can be retrieved by
   * <code>GetCanonicalName()</code>.
   */
  PP_HOSTRESOLVER_FLAG_CANONNAME = 1 << 0
} PP_HostResolver_Flag;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_HostResolver_Flag, 4);
/**
 * @}
 */

/**
 * @addtogroup Structs
 * @{
 */
/**
 * <code>PP_HostResolver_Hint</code> represents hints for host resolution.
 */
struct PP_HostResolver_Hint {
  /**
   * Network address family.
   */
  PP_NetAddress_Family family;
  /**
   * Combination of flags from <code>PP_HostResolver_Flag</code>.
   */
  int32_t flags;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_HostResolver_Hint, 8);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPB_HostResolver</code> interface supports host name
 * resolution.
 *
 * Permissions: In order to run <code>Resolve()</code>, apps permission
 * <code>socket</code> with subrule <code>resolve-host</code> is required.
 * For more details about network communication permissions, please see:
 * http://developer.chrome.com/apps/app_network.html
 */
struct PPB_HostResolver_1_0 {
  /**
   * Creates a host resolver resource.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying one instance of
   * a module.
   *
   * @return A <code>PP_Resource</code> corresponding to a host reslover or 0
   * on failure.
   */
  PP_Resource (*Create)(PP_Instance instance);
  /**
   * Determines if a given resource is a host resolver.
   *
   * @param[in] resource A <code>PP_Resource</code> to check.
   *
   * @return <code>PP_TRUE</code> if the input is a
   * <code>PPB_HostResolver</code> resource; <code>PP_FALSE</code> otherwise.
   */
  PP_Bool (*IsHostResolver)(PP_Resource resource);
  /**
   * Requests resolution of a host name. If the call completes successfully, the
   * results can be retrieved by <code>GetCanonicalName()</code>,
   * <code>GetNetAddressCount()</code> and <code>GetNetAddress()</code>.
   *
   * @param[in] host_resolver A <code>PP_Resource</code> corresponding to a host
   * resolver.
   * @param[in] host The host name (or IP address literal) to resolve.
   * @param[in] port The port number to be set in the resulting network
   * addresses.
   * @param[in] hint A <code>PP_HostResolver_Hint</code> structure providing
   * hints for host resolution.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   * <code>PP_ERROR_NOACCESS</code> will be returned if the caller doesn't have
   * required permissions. <code>PP_ERROR_NAME_NOT_RESOLVED</code> will be
   * returned if the host name couldn't be resolved.
   */
  int32_t (*Resolve)(PP_Resource host_resolver,
                     const char* host,
                     uint16_t port,
                     const struct PP_HostResolver_Hint* hint,
                     struct PP_CompletionCallback callback);
  /**
   * Gets the canonical name of the host.
   *
   * @param[in] host_resolver A <code>PP_Resource</code> corresponding to a host
   * resolver.
   *
   * @return A string <code>PP_Var</code> on success, which is an empty string
   * if <code>PP_HOSTRESOLVER_FLAG_CANONNAME</code> is not set in the hint flags
   * when calling <code>Resolve()</code>; an undefined <code>PP_Var</code> if
   * there is a pending <code>Resolve()</code> call or the previous
   * <code>Resolve()</code> call failed.
   */
  struct PP_Var (*GetCanonicalName)(PP_Resource host_resolver);
  /**
   * Gets the number of network addresses.
   *
   * @param[in] host_resolver A <code>PP_Resource</code> corresponding to a host
   * resolver.
   *
   * @return The number of available network addresses on success; 0 if there is
   * a pending <code>Resolve()</code> call or the previous
   * <code>Resolve()</code> call failed.
   */
  uint32_t (*GetNetAddressCount)(PP_Resource host_resolver);
  /**
   * Gets a network address.
   *
   * @param[in] host_resolver A <code>PP_Resource</code> corresponding to a host
   * resolver.
   * @param[in] index An index indicating which address to return.
   *
   * @return A <code>PPB_NetAddress</code> resource on success; 0 if there is a
   * pending <code>Resolve()</code> call or the previous <code>Resolve()</code>
   * call failed, or the specified index is out of range.
   */
  PP_Resource (*GetNetAddress)(PP_Resource host_resolver, uint32_t index);
};

typedef struct PPB_HostResolver_1_0 PPB_HostResolver;
/**
 * @}
 */

/* ppb_image_data.idl */
/**
 * @addtogroup Enums
 * @{
 */
/**
 * <code>PP_ImageDataFormat</code> is an enumeration of the different types of
 * image data formats.
 *
 * The third part of each enumeration value describes the memory layout from
 * the lowest address to the highest. For example, BGRA means the B component
 * is stored in the lowest address, no matter what endianness the platform is
 * using.
 *
 * The PREMUL suffix implies pre-multiplied alpha is used. In this mode, the
 * red, green and blue color components of the pixel data supplied to an image
 * data should be pre-multiplied by their alpha value. For example: starting
 * with floating point color components, here is how to convert them to 8-bit
 * premultiplied components for image data:
 *
 * ...components of a pixel, floats ranging from 0 to 1...
 * <code>float red = 1.0f;</code>
 * <code>float green = 0.50f;</code>
 * <code>float blue = 0.0f;</code>
 * <code>float alpha = 0.75f;</code>
 * ...components for image data are 8-bit values ranging from 0 to 255...
 * <code>uint8_t image_data_red_premul = (uint8_t)(red * alpha * 255.0f);
 * </code>
 * <code>uint8_t image_data_green_premul = (uint8_t)(green * alpha * 255.0f);
 * </code>
 * <code>uint8_t image_data_blue_premul = (uint8_t)(blue * alpha * 255.0f);
 * </code>
 * <code>uint8_t image_data_alpha_premul = (uint8_t)(alpha * 255.0f);</code>
 *
 * <strong>Note:</strong> The resulting pre-multiplied red, green and blue
 * components should not be greater than the alpha value.
 */
typedef enum {
  PP_IMAGEDATAFORMAT_BGRA_PREMUL,
  PP_IMAGEDATAFORMAT_RGBA_PREMUL
} PP_ImageDataFormat;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_ImageDataFormat, 4);
/**
 * @}
 */

/**
 * @addtogroup Structs
 * @{
 */
/**
 * The <code>PP_ImageDataDesc</code> structure represents a description of
 * image data.
 */
struct PP_ImageDataDesc {
  /**
   * This value represents one of the image data types in the
   * <code>PP_ImageDataFormat</code> enum.
   */
  PP_ImageDataFormat format;
  /** This value represents the size of the bitmap in pixels. */
  struct PP_Size size;
  /**
   * This value represents the row width in bytes. This may be different than
   * width * 4 since there may be padding at the end of the lines.
   */
  int32_t stride;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_ImageDataDesc, 16);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPB_ImageData</code> interface contains pointers to several
 * functions for determining the browser's treatment of image data.
 */
struct PPB_ImageData_1_0 {
  /**
   * GetNativeImageDataFormat() returns the browser's preferred format for
   * image data. The browser uses this format internally for painting. Other
   * formats may require internal conversions to paint or may have additional
   * restrictions depending on the function.
   *
   * @return A <code>PP_ImageDataFormat</code> containing the preferred format.
   */
  PP_ImageDataFormat (*GetNativeImageDataFormat)(void);
  /**
   * IsImageDataFormatSupported() determines if the given image data format is
   * supported by the browser. Note: <code>PP_IMAGEDATAFORMAT_BGRA_PREMUL</code>
   * and <code>PP_IMAGEDATAFORMAT_RGBA_PREMUL</code> formats are always
   * supported. Other image formats do not make this guarantee, and should be
   * checked first with IsImageDataFormatSupported() before using.
   *
   * @param[in] format The image data format.
   *
   * @return A <code>PP_Bool</code> with <code>PP_TRUE</code> if the given
   * image data format is supported by the browser.
   */
  PP_Bool (*IsImageDataFormatSupported)(PP_ImageDataFormat format);
  /**
   * Create() allocates an image data resource with the given format and size.
   *
   * For security reasons, if uninitialized, the bitmap will not contain random
   * memory, but may contain data from a previous image produced by the same
   * module if the bitmap was cached and re-used.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying one instance
   * of a module.
   * @param[in] format The desired image data format.
   * @param[in] size A pointer to a <code>PP_Size</code> containing the image
   * size.
   * @param[in] init_to_zero A <code>PP_Bool</code> to determine transparency
   * at creation.
   * Set the <code>init_to_zero</code> flag if you want the bitmap initialized
   * to transparent during the creation process. If this flag is not set, the
   * current contents of the bitmap will be undefined, and the module should
   * be sure to set all the pixels.
   *
   * @return A <code>PP_Resource</code> with a nonzero ID on success or zero on
   * failure. Failure means the instance, image size, or format was invalid.
   */
  PP_Resource (*Create)(PP_Instance instance,
                        PP_ImageDataFormat format,
                        const struct PP_Size* size,
                        PP_Bool init_to_zero);
  /**
   * IsImageData() determines if a given resource is image data.
   *
   * @param[in] image_data A <code>PP_Resource</code> corresponding to image
   * data.
   *
   * @return A <code>PP_Bool</code> with <code>PP_TRUE</code> if the given
   * resource is an image data or <code>PP_FALSE</code> if the resource is
   * invalid or some type other than image data.
   */
  PP_Bool (*IsImageData)(PP_Resource image_data);
  /**
   * Describe() computes the description of the
   * image data.
   *
   * @param[in] image_data A <code>PP_Resource</code> corresponding to image
   * data.
   * @param[in,out] desc A pointer to a <code>PP_ImageDataDesc</code>
   * containing the description.
   *
   * @return A <code>PP_Bool</code> with <code>PP_TRUE</code> on success or
   * <code>PP_FALSE</code> if the resource is not an image data. On
   * <code>PP_FALSE</code>, the <code>desc</code> structure will be filled
   * with 0.
   */
  PP_Bool (*Describe)(PP_Resource image_data, struct PP_ImageDataDesc* desc);
  /**
   * Map() maps an image data into the module address space.
   *
   * @param[in] image_data A <code>PP_Resource</code> corresponding to image
   * data.
   *
   * @return A pointer to the beginning of the data.
   */
  void* (*Map)(PP_Resource image_data);
  /**
   * Unmap is a pointer to a function that unmaps an image data from the module
   * address space.
   *
   * @param[in] image_data A <code>PP_Resource</code> corresponding to image
   * data.
   */
  void (*Unmap)(PP_Resource image_data);
};

typedef struct PPB_ImageData_1_0 PPB_ImageData;
/**
 * @}
 */

/* ppb_instance.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The PPB_Instance interface contains pointers to functions
 * related to the module instance on a web page.
 */
struct PPB_Instance_1_0 {
  /**
   * BindGraphics() binds the given graphics as the current display surface.
   * The contents of this device is what will be displayed in the instance's
   * area on the web page. The device must be a 2D or a 3D device.
   *
   * You can pass a <code>NULL</code> resource as the device parameter to
   * unbind all devices from the given instance. The instance will then appear
   * transparent. Re-binding the same device will return <code>PP_TRUE</code>
   * and will do nothing.
   *
   * Any previously-bound device will be released. It is an error to bind
   * a device when it is already bound to another instance. If you want
   * to move a device between instances, first unbind it from the old one, and
   * then rebind it to the new one.
   *
   * Binding a device will invalidate that portion of the web page to flush the
   * contents of the new device to the screen.
   *
   * @param[in] instance A PP_Instance identifying one instance of a module.
   * @param[in] device A PP_Resource corresponding to a graphics device.
   *
   * @return <code>PP_Bool</code> containing <code>PP_TRUE</code> if bind was
   * successful or <code>PP_FALSE</code> if the device was not the correct
   * type. On success, a reference to the device will be held by the
   * instance, so the caller can release its reference if it chooses.
   */
  PP_Bool (*BindGraphics)(PP_Instance instance, PP_Resource device);
  /**
   * IsFullFrame() determines if the instance is full-frame. Such an instance
   * represents the entire document in a frame rather than an embedded
   * resource. This can happen if the user does a top-level navigation or the
   * page specifies an iframe to a resource with a MIME type registered by the
   * module.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying one instance
   * of a module.
   *
   * @return A <code>PP_Bool</code> containing <code>PP_TRUE</code> if the
   * instance is full-frame.
   */
  PP_Bool (*IsFullFrame)(PP_Instance instance);
};

typedef struct PPB_Instance_1_0 PPB_Instance;
/**
 * @}
 */

/* ppb_media_stream_audio_track.idl */
/**
 * @addtogroup Enums
 * @{
 */
/**
 * This enumeration contains audio track attributes which are used by
 * <code>Configure()</code>.
 */
typedef enum {
  /**
   * Attribute list terminator.
   */
  PP_MEDIASTREAMAUDIOTRACK_ATTRIB_NONE = 0,
  /**
   * The maximum number of buffers to hold audio samples.
   * Note: this is only used as advisory; the browser may allocate more or fewer
   * based on available resources. How many buffers depends on usage -
   * request at least 2 to make sure latency doesn't cause lost samples. If
   * the plugin expects to hold on to more than one buffer at a time (e.g. to do
   * multi-buffer processing), it should request that many more.
   */
  PP_MEDIASTREAMAUDIOTRACK_ATTRIB_BUFFERS = 1,
  /**
   * The sample rate of audio data in buffers. The attribute value is a
   * <code>PP_AudioBuffer_SampleRate</code>.
   */
  PP_MEDIASTREAMAUDIOTRACK_ATTRIB_SAMPLE_RATE = 2,
  /**
   * The sample size of audio data in buffers in bytes. The attribute value is a
   * <code>PP_AudioBuffer_SampleSize</code>.
   */
  PP_MEDIASTREAMAUDIOTRACK_ATTRIB_SAMPLE_SIZE = 3,
  /**
   * The number of channels in audio buffers.
   *
   * Supported values: 1, 2
   */
  PP_MEDIASTREAMAUDIOTRACK_ATTRIB_CHANNELS = 4,
  /**
   * The duration of an audio buffer in milliseconds.
   *
   * Valid range: 10 to 10000
   */
  PP_MEDIASTREAMAUDIOTRACK_ATTRIB_DURATION = 5
} PP_MediaStreamAudioTrack_Attrib;
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
struct PPB_MediaStreamAudioTrack_0_1 {
  /**
   * Determines if a resource is a MediaStream audio track resource.
   *
   * @param[in] resource The <code>PP_Resource</code> to test.
   *
   * @return A <code>PP_Bool</code> with <code>PP_TRUE</code> if the given
   * resource is a Mediastream audio track resource or <code>PP_FALSE</code>
   * otherwise.
   */
  PP_Bool (*IsMediaStreamAudioTrack)(PP_Resource resource);
  /**
   * Configures underlying buffers for incoming audio samples.
   * If the application doesn't want to drop samples, then the
   * <code>PP_MEDIASTREAMAUDIOTRACK_ATTRIB_BUFFERS</code> should be
   * chosen such that inter-buffer processing time variability won't overrun all
   * the input buffers. If all buffers are filled, then samples will be
   * dropped. The application can detect this by examining the timestamp on
   * returned buffers. If <code>Configure()</code> is not called, default
   * settings will be used. Calls to Configure while the plugin holds
   * buffers will fail.
   * Example usage from plugin code:
   * @code
   * int32_t attribs[] = {
   *     PP_MEDIASTREAMAUDIOTRACK_ATTRIB_BUFFERS, 4,
   *     PP_MEDIASTREAMAUDIOTRACK_ATTRIB_DURATION, 10,
   *     PP_MEDIASTREAMAUDIOTRACK_ATTRIB_NONE};
   * track_if->Configure(track, attribs, callback);
   * @endcode
   *
   * @param[in] audio_track A <code>PP_Resource</code> corresponding to an audio
   * resource.
   * @param[in] attrib_list A list of attribute name-value pairs in which each
   * attribute is immediately followed by the corresponding desired value.
   * The list is terminated by
   * <code>PP_MEDIASTREAMAUDIOTRACK_ATTRIB_NONE</code>.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion of <code>Configure()</code>.
   *
   * @return An int32_t containing a result code from <code>pp_errors.h</code>.
   */
  int32_t (*Configure)(PP_Resource audio_track,
                       const int32_t attrib_list[],
                       struct PP_CompletionCallback callback);
  /**
   * Gets attribute value for a given attribute name.
   *
   * @param[in] audio_track A <code>PP_Resource</code> corresponding to an audio
   * resource.
   * @param[in] attrib A <code>PP_MediaStreamAudioTrack_Attrib</code> for
   * querying.
   * @param[out] value A int32_t for storing the attribute value on success.
   * Otherwise, the value will not be changed.
   *
   * @return An int32_t containing a result code from <code>pp_errors.h</code>.
   */
  int32_t (*GetAttrib)(PP_Resource audio_track,
                       PP_MediaStreamAudioTrack_Attrib attrib,
                       int32_t* value);
  /**
   * Returns the track ID of the underlying MediaStream audio track.
   *
   * @param[in] audio_track The <code>PP_Resource</code> to check.
   *
   * @return A <code>PP_Var</code> containing the MediaStream track ID as
   * a string.
   */
  struct PP_Var (*GetId)(PP_Resource audio_track);
  /**
   * Checks whether the underlying MediaStream track has ended.
   * Calls to GetBuffer while the track has ended are safe to make and will
   * complete, but will fail.
   *
   * @param[in] audio_track The <code>PP_Resource</code> to check.
   *
   * @return A <code>PP_Bool</code> with <code>PP_TRUE</code> if the given
   * MediaStream track has ended or <code>PP_FALSE</code> otherwise.
   */
  PP_Bool (*HasEnded)(PP_Resource audio_track);
  /**
   * Gets the next audio buffer from the MediaStream track.
   * If internal processing is slower than the incoming buffer rate, new buffers
   * will be dropped from the incoming stream. Once all buffers are full,
   * audio samples will be dropped until <code>RecycleBuffer()</code> is called
   * to free a slot for another buffer.
   * If there are no audio data in the input buffer,
   * <code>PP_OK_COMPLETIONPENDING</code> will be returned immediately and the
   * <code>callback</code> will be called, when a new buffer of audio samples
   * is received or an error happens.
   *
   * @param[in] audio_track A <code>PP_Resource</code> corresponding to an audio
   * resource.
   * @param[out] buffer A <code>PP_Resource</code> corresponding to
   * an AudioBuffer resource.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion of GetBuffer().
   *
   * @return An int32_t containing a result code from <code>pp_errors.h</code>.
   */
  int32_t (*GetBuffer)(PP_Resource audio_track,
                       PP_Resource* buffer,
                       struct PP_CompletionCallback callback);
  /**
   * Recycles a buffer returned by <code>GetBuffer()</code>, so the track can
   * reuse the buffer. And the buffer will become invalid. The caller should
   * release all references it holds to <code>buffer</code> and not use it
   * anymore.
   *
   * @param[in] audio_track A <code>PP_Resource</code> corresponding to an audio
   * resource.
   * @param[in] buffer A <code>PP_Resource</code> corresponding to
   * an AudioBuffer resource returned by <code>GetBuffer()</code>.
   *
   * @return An int32_t containing a result code from <code>pp_errors.h</code>.
   */
  int32_t (*RecycleBuffer)(PP_Resource audio_track, PP_Resource buffer);
  /**
   * Closes the MediaStream audio track and disconnects it from the audio
   * source. After calling <code>Close()</code>, no new buffers will be
   * received.
   *
   * @param[in] audio_track A <code>PP_Resource</code> corresponding to a
   * MediaStream audio track resource.
   */
  void (*Close)(PP_Resource audio_track);
};

typedef struct PPB_MediaStreamAudioTrack_0_1 PPB_MediaStreamAudioTrack;
/**
 * @}
 */

/* ppb_media_stream_video_track.idl */
/**
 * @addtogroup Enums
 * @{
 */
/**
 * This enumeration contains video track attributes which are used by
 * <code>Configure()</code>.
 */
typedef enum {
  /**
   * Attribute list terminator.
   */
  PP_MEDIASTREAMVIDEOTRACK_ATTRIB_NONE = 0,
  /**
   * The maximum number of frames to hold in the input buffer.
   * Note: this is only used as advisory; the browser may allocate more or fewer
   * based on available resources. How many frames to buffer depends on usage -
   * request at least 2 to make sure latency doesn't cause lost frames. If
   * the plugin expects to hold on to more than one frame at a time (e.g. to do
   * multi-frame processing), it should request that many more.
   * If this attribute is not specified or value 0 is specified for this
   * attribute, the default value will be used.
   */
  PP_MEDIASTREAMVIDEOTRACK_ATTRIB_BUFFERED_FRAMES = 1,
  /**
   * The width of video frames in pixels. It should be a multiple of 4.
   * If the specified size is different from the video source (webcam),
   * frames will be scaled to specified size.
   * If this attribute is not specified or value 0 is specified, the original
   * frame size of the video track will be used.
   *
   * Maximum value: 4096 (4K resolution).
   */
  PP_MEDIASTREAMVIDEOTRACK_ATTRIB_WIDTH = 2,
  /**
   * The height of video frames in pixels. It should be a multiple of 4.
   * If the specified size is different from the video source (webcam),
   * frames will be scaled to specified size.
   * If this attribute is not specified or value 0 is specified, the original
   * frame size of the video track will be used.
   *
   * Maximum value: 4096 (4K resolution).
   */
  PP_MEDIASTREAMVIDEOTRACK_ATTRIB_HEIGHT = 3,
  /**
   * The format of video frames. The attribute value is
   * a <code>PP_VideoFrame_Format</code>. If the specified format is different
   * from the video source (webcam), frames will be converted to specified
   * format.
   * If this attribute is not specified or value
   * <code>PP_VIDEOFRAME_FORMAT_UNKNOWN</code> is specified, the orignal frame
   * format of the video track will be used.
   */
  PP_MEDIASTREAMVIDEOTRACK_ATTRIB_FORMAT = 4
} PP_MediaStreamVideoTrack_Attrib;
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
struct PPB_MediaStreamVideoTrack_1_0 { /* dev */
  /**
   * Creates a PPB_MediaStreamVideoTrack resource for video output. Call this
   * when you will be creating frames and putting them to the track.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying one instance of
   * a module.
   *
   * @return A <code>PP_Resource</code> corresponding to a
   * PPB_MediaStreamVideoTrack resource if successful, 0 if failed.
   */
  PP_Resource (*Create)(PP_Instance instance);
  /**
   * Determines if a resource is a MediaStream video track resource.
   *
   * @param[in] resource The <code>PP_Resource</code> to test.
   *
   * @return A <code>PP_Bool</code> with <code>PP_TRUE</code> if the given
   * resource is a Mediastream video track resource or <code>PP_FALSE</code>
   * otherwise.
   */
  PP_Bool (*IsMediaStreamVideoTrack)(PP_Resource resource);
  /**
   * Configures underlying frame buffers for incoming frames.
   * If the application doesn't want to drop frames, then the
   * <code>PP_MEDIASTREAMVIDEOTRACK_ATTRIB_BUFFERED_FRAMES</code> should be
   * chosen such that inter-frame processing time variability won't overrun the
   * input buffer. If the buffer is overfilled, then frames will be dropped.
   * The application can detect this by examining the timestamp on returned
   * frames. If some attributes are not specified, default values will be used
   * for those unspecified attributes. If <code>Configure()</code> is not
   * called, default settings will be used.
   * Example usage from plugin code:
   * @code
   * int32_t attribs[] = {
   *     PP_MEDIASTREAMVIDEOTRACK_ATTRIB_BUFFERED_FRAMES, 4,
   *     PP_MEDIASTREAMVIDEOTRACK_ATTRIB_NONE};
   * track_if->Configure(track, attribs, callback);
   * @endcode
   *
   * @param[in] video_track A <code>PP_Resource</code> corresponding to a video
   * resource.
   * @param[in] attrib_list A list of attribute name-value pairs in which each
   * attribute is immediately followed by the corresponding desired value.
   * The list is terminated by
   * <code>PP_MEDIASTREAMVIDEOTRACK_ATTRIB_NONE</code>.
   * @param[in] callback <code>PP_CompletionCallback</code> to be called upon
   * completion of <code>Configure()</code>.
   *
   * @return An int32_t containing a result code from <code>pp_errors.h</code>.
   * Returns <code>PP_ERROR_INPROGRESS</code> if there is a pending call of
   * <code>Configure()</code> or <code>GetFrame()</code>, or the plugin
   * holds some frames which are not recycled with <code>RecycleFrame()</code>.
   * If an error is returned, all attributes and the underlying buffer will not
   * be changed.
   */
  int32_t (*Configure)(PP_Resource video_track,
                       const int32_t attrib_list[],
                       struct PP_CompletionCallback callback);
  /**
   * Gets attribute value for a given attribute name.
   *
   * @param[in] video_track A <code>PP_Resource</code> corresponding to a video
   * resource.
   * @param[in] attrib A <code>PP_MediaStreamVideoTrack_Attrib</code> for
   * querying.
   * @param[out] value A int32_t for storing the attribute value on success.
   * Otherwise, the value will not be changed.
   *
   * @return An int32_t containing a result code from <code>pp_errors.h</code>.
   */
  int32_t (*GetAttrib)(PP_Resource video_track,
                       PP_MediaStreamVideoTrack_Attrib attrib,
                       int32_t* value);
  /**
   * Returns the track ID of the underlying MediaStream video track.
   *
   * @param[in] video_track The <code>PP_Resource</code> to check.
   *
   * @return A <code>PP_Var</code> containing the MediaStream track ID as
   * a string.
   */
  struct PP_Var (*GetId)(PP_Resource video_track);
  /**
   * Checks whether the underlying MediaStream track has ended.
   * Calls to GetFrame while the track has ended are safe to make and will
   * complete, but will fail.
   *
   * @param[in] video_track The <code>PP_Resource</code> to check.
   *
   * @return A <code>PP_Bool</code> with <code>PP_TRUE</code> if the given
   * MediaStream track has ended or <code>PP_FALSE</code> otherwise.
   */
  PP_Bool (*HasEnded)(PP_Resource video_track);
  /**
   * Gets the next video frame from the MediaStream track.
   * If internal processing is slower than the incoming frame rate, new frames
   * will be dropped from the incoming stream. Once the input buffer is full,
   * frames will be dropped until <code>RecycleFrame()</code> is called to free
   * a spot for another frame to be buffered.
   * If there are no frames in the input buffer,
   * <code>PP_OK_COMPLETIONPENDING</code> will be returned immediately and the
   * <code>callback</code> will be called when a new frame is received or an
   * error happens.
   *
   * @param[in] video_track A <code>PP_Resource</code> corresponding to a video
   * resource.
   * @param[out] frame A <code>PP_Resource</code> corresponding to a VideoFrame
   * resource.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion of GetFrame().
   *
   * @return An int32_t containing a result code from <code>pp_errors.h</code>.
   * Returns PP_ERROR_NOMEMORY if <code>max_buffered_frames</code> frames buffer
   * was not allocated successfully.
   */
  int32_t (*GetFrame)(PP_Resource video_track,
                      PP_Resource* frame,
                      struct PP_CompletionCallback callback);
  /**
   * Recycles a frame returned by <code>GetFrame()</code>, so the track can
   * reuse the underlying buffer of this frame. And the frame will become
   * invalid. The caller should release all references it holds to
   * <code>frame</code> and not use it anymore.
   *
   * @param[in] video_track A <code>PP_Resource</code> corresponding to a video
   * resource.
   * @param[in] frame A <code>PP_Resource</code> corresponding to a VideoFrame
   * resource returned by <code>GetFrame()</code>.
   *
   * @return An int32_t containing a result code from <code>pp_errors.h</code>.
   */
  int32_t (*RecycleFrame)(PP_Resource video_track, PP_Resource frame);
  /**
   * Closes the MediaStream video track and disconnects it from video source.
   * After calling <code>Close()</code>, no new frames will be received.
   *
   * @param[in] video_track A <code>PP_Resource</code> corresponding to a
   * MediaStream video track resource.
   */
  void (*Close)(PP_Resource video_track);
  /**
   * Gets a free frame for output. The frame is allocated by
   * <code>Configure()</code>. The caller should fill it with frame data, and
   * then use |PutFrame()| to send the frame back.
   */
  int32_t (*GetEmptyFrame)(PP_Resource video_track,
                           PP_Resource* frame,
                           struct PP_CompletionCallback callback);
  /**
   * Sends a frame returned by |GetEmptyFrame()| to the output track.
   * After this function, the |frame| should not be used anymore and the
   * caller should release the reference that it holds.
   */
  int32_t (*PutFrame)(PP_Resource video_track, PP_Resource frame);
};

struct PPB_MediaStreamVideoTrack_0_1 {
  PP_Bool (*IsMediaStreamVideoTrack)(PP_Resource resource);
  int32_t (*Configure)(PP_Resource video_track,
                       const int32_t attrib_list[],
                       struct PP_CompletionCallback callback);
  int32_t (*GetAttrib)(PP_Resource video_track,
                       PP_MediaStreamVideoTrack_Attrib attrib,
                       int32_t* value);
  struct PP_Var (*GetId)(PP_Resource video_track);
  PP_Bool (*HasEnded)(PP_Resource video_track);
  int32_t (*GetFrame)(PP_Resource video_track,
                      PP_Resource* frame,
                      struct PP_CompletionCallback callback);
  int32_t (*RecycleFrame)(PP_Resource video_track, PP_Resource frame);
  void (*Close)(PP_Resource video_track);
};

typedef struct PPB_MediaStreamVideoTrack_0_1 PPB_MediaStreamVideoTrack;
/**
 * @}
 */

/* ppb_message_loop.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * A message loop allows PPAPI calls to be issued on a thread. You may not
 * issue any API calls on a thread without creating a message loop. It also
 * allows you to post work to the message loop for a thread.
 *
 * To process work posted to the message loop, as well as completion callbacks
 * for asynchronous operations, you must run the message loop via Run().
 *
 * Note the system manages the lifetime of the instance (and all associated
 * resources). If the instance is deleted from the page, background threads may
 * suddenly see their PP_Resource handles become invalid. In this case, calls
 * will fail with PP_ERROR_BADRESOURCE. If you need to access data associated
 * with your instance, you will probably want to create some kind of threadsafe
 * proxy object that can handle asynchronous destruction of the instance object.
 *
 * Typical usage:
 *   On the main thread:
 *    - Create the thread yourself (using pthreads).
 *    - Create the message loop resource.
 *    - Pass the message loop resource to your thread's main function.
 *    - Call PostWork() on the message loop to run functions on the thread.
 *
 *   From the background thread's main function:
 *    - Call AttachToCurrentThread() with the message loop resource.
 *    - Call Run() with the message loop resource.
 *
 *   Your callbacks should look like this:
 *   @code
 *   void DoMyWork(void* user_data, int32_t status) {
 *     if (status != PP_OK) {
 *       Cleanup();  // e.g. free user_data.
 *       return;
 *     }
 *     ... do your work...
 *   }
 *   @endcode
 * For a C++ example, see ppapi/utility/threading/simple_thread.h
 *
 * (You can also create the message loop resource on the background thread,
 * but then the main thread will have no reference to it should you want to
 * call PostWork()).
 *
 *
 * THREAD HANDLING
 *
 * The main thread has an implicitly created message loop. The main thread is
 * the thread where PPP_InitializeModule and PPP_Instance functions are called.
 * You can retrieve a reference to this message loop by calling
 * GetForMainThread() or, if your code is on the main thread, GetCurrent() will
 * also work.
 *
 * Some special threads created by the system can not have message loops. In
 * particular, the background thread created for audio processing has this
 * requirement because it's intended to be highly responsive to keep up with
 * the realtime requirements of audio processing. You can not make PPAPI calls
 * from these threads.
 *
 * Once you associate a message loop with a thread, you don't have to keep a
 * reference to it. The system will hold a reference to the message loop for as
 * long as the thread is running. The current message loop can be retrieved
 * using the GetCurrent() function.
 *
 * It is legal to create threads in your plugin without message loops, but
 * PPAPI calls will fail unless explicitly noted in the documentation.
 *
 * You can create a message loop object on a thread and never actually run the
 * message loop. This will allow you to call blocking PPAPI calls (via
 * PP_BlockUntilComplete()). If you make any asynchronous calls, the callbacks
 * from those calls will be queued in the message loop and never run. The same
 * thing will happen if work is scheduled after the message loop exits and
 * the message loop is not run again.
 *
 *
 * DESTRUCTION AND ERROR HANDLING
 *
 * Often, your application will associate memory with completion callbacks. For
 * example, the C++ CompletionCallbackFactory has a small amount of
 * heap-allocated memory for each callback. This memory will be leaked if the
 * callback is never run. To avoid this memory leak, you need to be careful
 * about error handling and shutdown.
 *
 * There are a number of cases where posted callbacks will never be run:
 *
 *  - You tear down the thread (via pthreads) without "destroying" the message
 *    loop (via PostQuit with should_destroy = PP_TRUE). In this case, any
 *    tasks in the message queue will be lost.
 *
 *  - You create a message loop, post callbacks to it, and never run it.
 *
 *  - You quit the message loop via PostQuit with should_destroy set to
 *    PP_FALSE. In this case, the system will assume the message loop will be
 *    run again later and keep your tasks.
 *
 * To do proper shutdown, call PostQuit with should_destroy = PP_TRUE. This
 * will prohibit future work from being posted, and will allow the message loop
 * to run until all pending tasks are run.
 *
 * If you post a callback to a message loop that's been destroyed, or to an
 * invalid message loop, PostWork will return an error and will not run the
 * callback. This is true even for callbacks with the "required" flag set,
 * since the system may not even know what thread to issue the error callback
 * on.
 *
 * Therefore, you should check for errors from PostWork and destroy any
 * associated memory to avoid leaks. If you're using the C++
 * CompletionCallbackFactory, use the following pattern:
 * @code
 * pp::CompletionCallback callback = factory_.NewOptionalCallback(...);
 * int32_t result = message_loop.PostWork(callback);
 * if (result != PP_OK)
 *   callback.Run(result);
 * @endcode
 * This will run the callback with an error value, and assumes that the
 * implementation of your callback checks the "result" argument and returns
 * immediately on error.
 */
struct PPB_MessageLoop_1_0 {
  /**
   * Creates a message loop resource.
   *
   * This may be called from any thread. After your thread starts but before
   * issuing any other PPAPI calls on it, you must associate it with a message
   * loop by calling AttachToCurrentThread.
   */
  PP_Resource (*Create)(PP_Instance instance);
  /**
   * Returns a resource identifying the message loop for the main thread. The
   * main thread always has a message loop created by the system.
   */
  PP_Resource (*GetForMainThread)(void);
  /**
   * Returns a reference to the PPB_MessageLoop object attached to the current
   * thread. If there is no attached message loop, the return value will be 0.
   */
  PP_Resource (*GetCurrent)(void);
  /**
   * Sets the given message loop resource as being the associated message loop
   * for the currently running thread.
   *
   * You must call this function exactly once on a thread before making any
   * PPAPI calls. A message loop can only be attached to one thread, and the
   * message loop can not be changed later. The message loop will be attached
   * as long as the thread is running or until you quit with should_destroy
   * set to PP_TRUE.
   *
   * If this function fails, attempting to run the message loop will fail.
   * Note that you can still post work to the message loop: it will get queued
   * up should the message loop eventually be successfully attached and run.
   *
   * @return
   *   - PP_OK: The message loop was successfully attached to the thread and is
   *     ready to use.
   *   - PP_ERROR_BADRESOURCE: The given message loop resource is invalid.
   *   - PP_ERROR_INPROGRESS: The current thread already has a message loop
   *     attached. This will always be the case for the main thread, which has
   *     an implicit system-created message loop attached.
   *   - PP_ERROR_WRONG_THREAD: The current thread type can not have a message
   *     loop attached to it. See the interface level discussion about these
   *     special threads, which include realtime audio threads.
   */
  int32_t (*AttachToCurrentThread)(PP_Resource message_loop);
  /**
   * Runs the thread message loop. Running the message loop is required for you
   * to get issued completion callbacks on the thread.
   *
   * The message loop identified by the argument must have been previously
   * successfully attached to the current thread.
   *
   * You may not run nested message loops. Since the main thread has an
   * implicit message loop that the system runs, you may not call Run on the
   * main thread.
   *
   * @return
   *   - PP_OK: The message loop was successfully run. Note that on
   *     success, the message loop will only exit when you call PostQuit().
   *   - PP_ERROR_BADRESOURCE: The given message loop resource is invalid.
   *   - PP_ERROR_WRONG_THREAD: You are attempting to run a message loop that
   *     has not been successfully attached to the current thread. Call
   *     AttachToCurrentThread().
   *   - PP_ERROR_INPROGRESS: You are attempting to call Run in a nested
   *     fashion (Run is already on the stack). This will occur if you attempt
   *     to call run on the main thread's message loop (see above).
   */
  int32_t (*Run)(PP_Resource message_loop);
  /**
   * Schedules work to run on the given message loop. This may be called from
   * any thread. Posted work will be executed in the order it was posted when
   * the message loop is Run().
   *
   * @param message_loop The message loop resource.
   *
   * @param callback The completion callback to execute from the message loop.
   *
   * @param delay_ms The number of milliseconds to delay execution of the given
   * completion callback. Passing 0 means it will get queued normally and
   * executed in order.
   *
   *
   * The completion callback will be called with PP_OK as the "result" parameter
   * if it is run normally. It is good practice to check for PP_OK and return
   * early otherwise.
   *
   * The "required" flag on the completion callback is ignored. If there is an
   * error posting your callback, the error will be returned from PostWork and
   * the callback will never be run (because there is no appropriate place to
   * run your callback with an error without causing unexpected threading
   * problems). If you associate memory with the completion callback (for
   * example, you're using the C++ CompletionCallbackFactory), you will need to
   * free this or manually run the callback. See "Destruction and error
   * handling" above.
   *
   *
   * You can call this function before the message loop has started and the
   * work will get queued until the message loop is run. You can also post
   * work after the message loop has exited as long as should_destroy was
   * PP_FALSE. It will be queued until the next invocation of Run().
   *
   * @return
   *   - PP_OK: The work was posted to the message loop's queue. As described
   *     above, this does not mean that the work has been or will be executed
   *     (if you never run the message loop after posting).
   *   - PP_ERROR_BADRESOURCE: The given message loop resource is invalid.
   *   - PP_ERROR_BADARGUMENT: The function pointer for the completion callback
   *     is null (this will be the case if you pass PP_BlockUntilComplete()).
   *   - PP_ERROR_FAILED: The message loop has been destroyed.
   */
  int32_t (*PostWork)(PP_Resource message_loop,
                      struct PP_CompletionCallback callback,
                      int64_t delay_ms);
  /**
   * Posts a quit message to the given message loop's work queue. Work posted
   * before that point will be processed before quitting.
   *
   * This may be called on the message loop registered for the current thread,
   * or it may be called on the message loop registered for another thread. It
   * is an error to attempt to PostQuit() the main thread loop.
   *
   * @param should_destroy Marks the message loop as being in a destroyed state
   * and prevents further posting of messages.
   *
   * If you quit a message loop without setting should_destroy, it will still
   * be attached to the thread and you can still run it again by calling Run()
   * again. If you destroy it, it will be detached from the current thread.
   *
   * @return
   *   - PP_OK: The request to quit was successfully posted.
   *   - PP_ERROR_BADRESOURCE: The message loop was invalid.
   *   - PP_ERROR_WRONG_THREAD: You are attempting to quit the main thread.
   *     The main thread's message loop is managed by the system and can't be
   *     quit.
   */
  int32_t (*PostQuit)(PP_Resource message_loop, PP_Bool should_destroy);
};

typedef struct PPB_MessageLoop_1_0 PPB_MessageLoop;
/**
 * @}
 */

/* ppp_message_handler.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPP_MessageHandler</code> interface is implemented by the plugin
 * if the plugin wants to receive messages from a thread other than the main
 * Pepper thread, or if the plugin wants to handle blocking messages which
 * JavaScript may send via postMessageAndAwaitResponse().
 *
 * This interface struct should not be returned by PPP_GetInterface; instead it
 * must be passed as a parameter to PPB_Messaging::RegisterMessageHandler.
 */
struct PPP_MessageHandler_0_2 {
  /**
   * Invoked as a result of JavaScript invoking postMessage() on the plugin's
   * DOM element.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying one instance
   * of a module.
   * @param[in] user_data is the same pointer which was provided by a call to
   * RegisterMessageHandler().
   * @param[in] message A copy of the parameter that JavaScript provided to
   * postMessage().
   */
  void (*HandleMessage)(PP_Instance instance,
                        void* user_data,
                        const struct PP_Var* message);
  /**
   * Invoked as a result of JavaScript invoking postMessageAndAwaitResponse()
   * on the plugin's DOM element.
   *
   * NOTE: JavaScript execution is blocked during the duration of this call.
   * Hence, the plugin should respond as quickly as possible. For this reason,
   * blocking completion callbacks are disallowed while handling a blocking
   * message.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying one instance
   * of a module.
   * @param[in] user_data is the same pointer which was provided by a call to
   * RegisterMessageHandler().
   * @param[in] message is a copy of the parameter that JavaScript provided
   * to postMessageAndAwaitResponse().
   * @param[out] response will be copied to a JavaScript object which is
   * returned as the result of postMessageAndAwaitResponse() to the invoking
   *
   */
  void (*HandleBlockingMessage)(PP_Instance instance,
                                void* user_data,
                                const struct PP_Var* message,
                                struct PP_Var* response);
  /**
   * Invoked when the handler object is no longer needed. After this, no more
   * calls will be made which pass this same value for <code>instance</code>
   * and <code>user_data</code>.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying one instance
   * of a module.
   * @param[in] user_data is the same pointer which was provided by a call to
   * RegisterMessageHandler.
   */
  void (*Destroy)(PP_Instance instance, void* user_data);
};

typedef struct PPP_MessageHandler_0_2 PPP_MessageHandler;
/**
 * @}
 */

/* ppb_messaging.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPB_Messaging</code> interface is implemented by the browser
 * and is related to sending messages to JavaScript message event listeners on
 * the DOM element associated with specific module instance.
 */
struct PPB_Messaging_1_2 {
  /**
   * PostMessage() asynchronously invokes any listeners for message events on
   * the DOM element for the given module instance. A call to PostMessage()
   * will not block while the message is processed.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying one instance
   * of a module.
   * @param[in] message A <code>PP_Var</code> containing the data to be sent to
   * JavaScript.
   * <code>message</code> can be any <code>PP_Var</code> type except
   * <code>PP_VARTYPE_OBJECT</code>. Array/Dictionary types are supported from
   * Chrome M29 onward. All var types are copied when passing them to
   * JavaScript.
   *
   * When passing array or dictionary <code>PP_Var</code>s, the entire reference
   * graph will be converted and transferred. If the reference graph has cycles,
   * the message will not be sent and an error will be logged to the console.
   *
   * Listeners for message events in JavaScript code will receive an object
   * conforming to the HTML 5 <code>MessageEvent</code> interface.
   * Specifically, the value of message will be contained as a property called
   *  data in the received <code>MessageEvent</code>.
   *
   * This messaging system is similar to the system used for listening for
   * messages from Web Workers. Refer to
   * <code>http://www.whatwg.org/specs/web-workers/current-work/</code> for
   * further information.
   *
   * <strong>Example:</strong>
   *
   * @code
   *
   * <body>
   *   <object id="plugin"
   *           type="application/x-ppapi-postMessage-example"/>
   *   <script type="text/javascript">
   *     var plugin = document.getElementById('plugin');
   *     plugin.addEventListener("message",
   *                             function(message) { alert(message.data); },
   *                             false);
   *   </script>
   * </body>
   *
   * @endcode
   *
   * The module instance then invokes PostMessage() as follows:
   *
   * @code
   *
   *  char hello_world[] = "Hello world!";
   *  PP_Var hello_var = ppb_var_interface->VarFromUtf8(instance,
   *                                                    hello_world,
   *                                                    sizeof(hello_world));
   *  ppb_messaging_interface->PostMessage(instance, hello_var); // Copies var.
   *  ppb_var_interface->Release(hello_var);
   *
   * @endcode
   *
   * The browser will pop-up an alert saying "Hello world!"
   */
  void (*PostMessage)(PP_Instance instance, struct PP_Var message);
  /**
   * Registers a handler for receiving messages from JavaScript. If a handler
   * is registered this way, it will replace PPP_Messaging, and all messages
   * sent from JavaScript via postMessage and postMessageAndAwaitResponse will
   * be dispatched to <code>handler</code>.
   *
   * The function calls will be dispatched via <code>message_loop</code>. This
   * means that the functions will be invoked on the thread to which
   * <code>message_loop</code> is attached, when <code>message_loop</code> is
   * run. It is illegal to pass the main thread message loop;
   * RegisterMessageHandler will return PP_ERROR_WRONG_THREAD in that case.
   * If you quit <code>message_loop</code> before calling Unregister(),
   * the browser will not be able to call functions in the plugin's message
   * handler any more. That could mean missing some messages or could cause a
   * leak if you depend on Destroy() to free hander data. So you should,
   * whenever possible, Unregister() the handler prior to quitting its event
   * loop.
   *
   * Attempting to register a message handler when one is already registered
   * will cause the current MessageHandler to be unregistered and replaced. In
   * that case, no messages will be sent to the "default" message handler
   * (PPP_Messaging). Messages will stop arriving at the prior message handler
   * and will begin to be dispatched at the new message handler.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying one instance
   * of a module.
   * @param[in] user_data A pointer the plugin may choose to use when handling
   * calls to functions within PPP_MessageHandler. The browser will pass this
   * same pointer when invoking functions within PPP_MessageHandler.
   * @param[in] handler The plugin-provided set of functions for handling
   * messages.
   * @param[in] message_loop Represents the message loop on which
   * PPP_MessageHandler functions should be invoked.
   * @return PP_OK on success, or an error from pp_errors.h.
   */
  int32_t (*RegisterMessageHandler)(
      PP_Instance instance,
      void* user_data,
      const struct PPP_MessageHandler_0_2* handler,
      PP_Resource message_loop);
  /**
   * Unregisters the current message handler for <code>instance</code> if one
   * is registered. After this call, the message handler (if one was
   * registered) will have "Destroy" called on it and will receive no further
   * messages after that point. After that point, all messages sent from
   * JavaScript using postMessage() will be dispatched to PPP_Messaging (if
   * the plugin supports PPP_MESSAGING_INTERFACE). Attempts to call
   * postMessageAndAwaitResponse() from JavaScript will fail.
   *
   * Attempting to unregister a message handler when none is registered has no
   * effect.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying one instance
   * of a module.
   */
  void (*UnregisterMessageHandler)(PP_Instance instance);
};

typedef struct PPB_Messaging_1_2 PPB_Messaging;

struct PPB_Messaging_1_0 {
  void (*PostMessage)(PP_Instance instance, struct PP_Var message);
};
/**
 * @}
 */

/* ppb_mouse_cursor.idl */
/**
 * @addtogroup Enums
 * @{
 */
/**
 * The <code>PP_MouseCursor_Type</code> enumeration lists the available stock
 * cursor types.
 */
enum PP_MouseCursor_Type {
  PP_MOUSECURSOR_TYPE_CUSTOM = -1,
  PP_MOUSECURSOR_TYPE_POINTER = 0,
  PP_MOUSECURSOR_TYPE_CROSS = 1,
  PP_MOUSECURSOR_TYPE_HAND = 2,
  PP_MOUSECURSOR_TYPE_IBEAM = 3,
  PP_MOUSECURSOR_TYPE_WAIT = 4,
  PP_MOUSECURSOR_TYPE_HELP = 5,
  PP_MOUSECURSOR_TYPE_EASTRESIZE = 6,
  PP_MOUSECURSOR_TYPE_NORTHRESIZE = 7,
  PP_MOUSECURSOR_TYPE_NORTHEASTRESIZE = 8,
  PP_MOUSECURSOR_TYPE_NORTHWESTRESIZE = 9,
  PP_MOUSECURSOR_TYPE_SOUTHRESIZE = 10,
  PP_MOUSECURSOR_TYPE_SOUTHEASTRESIZE = 11,
  PP_MOUSECURSOR_TYPE_SOUTHWESTRESIZE = 12,
  PP_MOUSECURSOR_TYPE_WESTRESIZE = 13,
  PP_MOUSECURSOR_TYPE_NORTHSOUTHRESIZE = 14,
  PP_MOUSECURSOR_TYPE_EASTWESTRESIZE = 15,
  PP_MOUSECURSOR_TYPE_NORTHEASTSOUTHWESTRESIZE = 16,
  PP_MOUSECURSOR_TYPE_NORTHWESTSOUTHEASTRESIZE = 17,
  PP_MOUSECURSOR_TYPE_COLUMNRESIZE = 18,
  PP_MOUSECURSOR_TYPE_ROWRESIZE = 19,
  PP_MOUSECURSOR_TYPE_MIDDLEPANNING = 20,
  PP_MOUSECURSOR_TYPE_EASTPANNING = 21,
  PP_MOUSECURSOR_TYPE_NORTHPANNING = 22,
  PP_MOUSECURSOR_TYPE_NORTHEASTPANNING = 23,
  PP_MOUSECURSOR_TYPE_NORTHWESTPANNING = 24,
  PP_MOUSECURSOR_TYPE_SOUTHPANNING = 25,
  PP_MOUSECURSOR_TYPE_SOUTHEASTPANNING = 26,
  PP_MOUSECURSOR_TYPE_SOUTHWESTPANNING = 27,
  PP_MOUSECURSOR_TYPE_WESTPANNING = 28,
  PP_MOUSECURSOR_TYPE_MOVE = 29,
  PP_MOUSECURSOR_TYPE_VERTICALTEXT = 30,
  PP_MOUSECURSOR_TYPE_CELL = 31,
  PP_MOUSECURSOR_TYPE_CONTEXTMENU = 32,
  PP_MOUSECURSOR_TYPE_ALIAS = 33,
  PP_MOUSECURSOR_TYPE_PROGRESS = 34,
  PP_MOUSECURSOR_TYPE_NODROP = 35,
  PP_MOUSECURSOR_TYPE_COPY = 36,
  PP_MOUSECURSOR_TYPE_NONE = 37,
  PP_MOUSECURSOR_TYPE_NOTALLOWED = 38,
  PP_MOUSECURSOR_TYPE_ZOOMIN = 39,
  PP_MOUSECURSOR_TYPE_ZOOMOUT = 40,
  PP_MOUSECURSOR_TYPE_GRAB = 41,
  PP_MOUSECURSOR_TYPE_GRABBING = 42
};
PP_COMPILE_ASSERT_ENUM_SIZE_IN_BYTES(PP_MouseCursor_Type, 4);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPB_MouseCursor</code> allows setting the mouse cursor.
 */
struct PPB_MouseCursor_1_0 {
  /**
   * Sets the given mouse cursor. The mouse cursor will be in effect whenever
   * the mouse is over the given instance until it is set again by another
   * call. Note that you can hide the mouse cursor by setting it to the
   * <code>PP_MOUSECURSOR_TYPE_NONE</code> type.
   *
   * This function allows setting both system defined mouse cursors and
   * custom cursors. To set a system-defined cursor, pass the type you want
   * and set the custom image to 0 and the hot spot to NULL. To set a custom
   * cursor, set the type to <code>PP_MOUSECURSOR_TYPE_CUSTOM</code> and
   * specify your image and hot spot.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying the instance
   * that the mouse cursor will affect.
   *
   * @param[in] type A <code>PP_MouseCursor_Type</code> identifying the type of
   * mouse cursor to show.
   *
   * @param[in] image A <code>PPB_ImageData</code> resource identifying the
   * custom image to set when the type is
   * <code>PP_MOUSECURSOR_TYPE_CUSTOM</code>. The image must be less than 32
   * pixels in each direction and must be of the system's native image format.
   * When you are specifying a predefined cursor, this parameter must be 0.
   *
   * @param[in] hot_spot When setting a custom cursor, this identifies the
   * pixel position within the given image of the "hot spot" of the cursor.
   * When specifying a stock cursor, this parameter is ignored.
   *
   * @return PP_TRUE on success, or PP_FALSE if the instance or cursor type
   * is invalid, or if the image is too large.
   */
  PP_Bool (*SetCursor)(PP_Instance instance,
                       enum PP_MouseCursor_Type type,
                       PP_Resource image,
                       const struct PP_Point* hot_spot);
};

typedef struct PPB_MouseCursor_1_0 PPB_MouseCursor;
/**
 * @}
 */

/* ppb_mouse_lock.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPB_MouseLock</code> interface is implemented by the browser.
 * This interface provides a way of locking the target of mouse events to a
 * single module instance and removing the cursor from view. This mode is
 * useful for certain classes of applications, especially first-person
 * perspective 3D applications and 3D modeling software.
 */
struct PPB_MouseLock_1_0 {
  /**
   * LockMouse() requests the mouse to be locked.
   *
   * While the mouse is locked, the cursor is implicitly hidden from the user.
   * Any movement of the mouse will generate a
   * <code>PP_INPUTEVENT_TYPE_MOUSEMOVE</code> event. The
   * <code>GetPosition()</code> function in the <code>PPB_MouseInputEvent</code>
   * interface reports the last known mouse position just as mouse lock was
   * entered. The <code>GetMovement()</code> function provides relative movement
   * information indicating what the change in position of the mouse would be
   * had it not been locked.
   *
   * The browser may revoke the mouse lock for reasons including (but not
   * limited to) the user pressing the ESC key, the user activating another
   * program using a reserved keystroke (e.g. ALT+TAB), or some other system
   * event.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying one instance
   * of a module.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   */
  int32_t (*LockMouse)(PP_Instance instance,
                       struct PP_CompletionCallback callback);
  /**
   * UnlockMouse() causes the mouse to be unlocked, allowing it to track user
   * movement again. This is an asynchronous operation. The module instance
   * will be notified using the <code>PPP_MouseLock</code> interface when it
   * has lost the mouse lock.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying one instance
   * of a module.
   */
  void (*UnlockMouse)(PP_Instance instance);
};

typedef struct PPB_MouseLock_1_0 PPB_MouseLock;
/**
 * @}
 */

/* ppb_network_list.idl */
/**
 * @addtogroup Enums
 * @{
 */
/**
 * Type of a network interface.
 */
typedef enum {
  /**
   * Type of the network interface is not known.
   */
  PP_NETWORKLIST_TYPE_UNKNOWN = 0,
  /**
   * Wired Ethernet network.
   */
  PP_NETWORKLIST_TYPE_ETHERNET = 1,
  /**
   * Wireless Wi-Fi network.
   */
  PP_NETWORKLIST_TYPE_WIFI = 2,
  /**
   * Cellular network (e.g. LTE).
   */
  PP_NETWORKLIST_TYPE_CELLULAR = 3
} PP_NetworkList_Type;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_NetworkList_Type, 4);

/**
 * State of a network interface.
 */
typedef enum {
  /**
   * Network interface is down.
   */
  PP_NETWORKLIST_STATE_DOWN = 0,
  /**
   * Network interface is up.
   */
  PP_NETWORKLIST_STATE_UP = 1
} PP_NetworkList_State;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_NetworkList_State, 4);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPB_NetworkList</code> is used to represent a list of
 * network interfaces and their configuration. The content of the list
 * is immutable.  The current networks configuration can be received
 * using the <code>PPB_NetworkMonitor</code> interface.
 */
struct PPB_NetworkList_1_0 {
  /**
   * Determines if the specified <code>resource</code> is a
   * <code>NetworkList</code> object.
   *
   * @param[in] resource A <code>PP_Resource</code> resource.
   *
   * @return Returns <code>PP_TRUE</code> if <code>resource</code> is
   * a <code>PPB_NetworkList</code>, <code>PP_FALSE</code>
   * otherwise.
   */
  PP_Bool (*IsNetworkList)(PP_Resource resource);
  /**
   * Gets number of interfaces in the list.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to a
   * network list.
   *
   * @return Returns number of available network interfaces or 0 if
   * the list has never been updated.
   */
  uint32_t (*GetCount)(PP_Resource resource);
  /**
   * Gets name of a network interface.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to a
   * network list.
   * @param[in] index Index of the network interface.
   *
   * @return Returns name for the network interface with the specified
   * <code>index</code>.
   */
  struct PP_Var (*GetName)(PP_Resource resource, uint32_t index);
  /**
   * Gets type of a network interface.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to a
   * network list.
   * @param[in] index Index of the network interface.
   *
   * @return Returns type of the network interface with the specified
   * <code>index</code>.
   */
  PP_NetworkList_Type (*GetType)(PP_Resource resource, uint32_t index);
  /**
   * Gets state of a network interface.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to a
   * network list.
   * @param[in] index Index of the network interface.
   *
   * @return Returns current state of the network interface with the
   * specified <code>index</code>.
   */
  PP_NetworkList_State (*GetState)(PP_Resource resource, uint32_t index);
  /**
   * Gets list of IP addresses for a network interface.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to a
   * network list.
   * @param[in] index Index of the network interface.
   * @param[in] output An output array which will receive
   * <code>PPB_NetAddress</code> resources on success. Please note that the
   * ref count of those resources has already been increased by 1 for the
   * caller.
   *
   * @return An error code from <code>pp_errors.h</code>.
   */
  int32_t (*GetIpAddresses)(PP_Resource resource,
                            uint32_t index,
                            struct PP_ArrayOutput output);
  /**
   * Gets display name of a network interface.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to a
   * network list.
   * @param[in] index Index of the network interface.
   *
   * @return Returns display name for the network interface with the
   * specified <code>index</code>.
   */
  struct PP_Var (*GetDisplayName)(PP_Resource resource, uint32_t index);
  /**
   * Gets MTU (Maximum Transmission Unit) of a network interface.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to a
   * network list.
   * @param[in] index Index of the network interface.
   *
   * @return Returns MTU for the network interface with the specified
   * <code>index</code> or 0 if MTU is unknown.
   */
  uint32_t (*GetMTU)(PP_Resource resource, uint32_t index);
};

typedef struct PPB_NetworkList_1_0 PPB_NetworkList;
/**
 * @}
 */

/* ppb_network_monitor.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPB_NetworkMonitor</code> allows to get network interfaces
 * configuration and monitor network configuration changes.
 *
 * Permissions: Apps permission <code>socket</code> with subrule
 * <code>network-state</code> is required for <code>UpdateNetworkList()</code>.
 * For more details about network communication permissions, please see:
 * http://developer.chrome.com/apps/app_network.html
 */
struct PPB_NetworkMonitor_1_0 {
  /**
   * Creates a Network Monitor resource.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying one instance of
   * a module.
   *
   * @return A <code>PP_Resource</code> corresponding to a network monitor or 0
   * on failure.
   */
  PP_Resource (*Create)(PP_Instance instance);
  /**
   * Gets current network configuration. When called for the first time,
   * completes as soon as the current network configuration is received from
   * the browser. Each consequent call will wait for network list changes,
   * returning a new <code>PPB_NetworkList</code> resource every time.
   *
   * @param[in] network_monitor A <code>PP_Resource</code> corresponding to a
   * network monitor.
   * @param[out] network_list The <code>PPB_NetworkList<code> resource with the
   * current state of network interfaces.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   * <code>PP_ERROR_NOACCESS</code> will be returned if the caller doesn't have
   * required permissions.
   */
  int32_t (*UpdateNetworkList)(PP_Resource network_monitor,
                               PP_Resource* network_list,
                               struct PP_CompletionCallback callback);
  /**
   * Determines if the specified <code>resource</code> is a
   * <code>NetworkMonitor</code> object.
   *
   * @param[in] resource A <code>PP_Resource</code> resource.
   *
   * @return Returns <code>PP_TRUE</code> if <code>resource</code> is a
   * <code>PPB_NetworkMonitor</code>, <code>PP_FALSE</code>  otherwise.
   */
  PP_Bool (*IsNetworkMonitor)(PP_Resource resource);
};

typedef struct PPB_NetworkMonitor_1_0 PPB_NetworkMonitor;
/**
 * @}
 */

/* ppb_network_proxy.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * This interface provides a way to determine the appropriate proxy settings
 * for a given URL.
 *
 * Permissions: Apps permission <code>socket</code> with subrule
 * <code>resolve-proxy</code> is required for using this API.
 * For more details about network communication permissions, please see:
 * http://developer.chrome.com/apps/app_network.html
 */
struct PPB_NetworkProxy_1_0 {
  /**
   * Retrieves the proxy that will be used for the given URL. The result will
   * be a string in PAC format. For more details about PAC format, please see
   * http://en.wikipedia.org/wiki/Proxy_auto-config
   *
   * @param[in] instance A <code>PP_Instance</code> identifying one instance
   * of a module.
   *
   * @param[in] url A string <code>PP_Var</code> containing a URL.
   *
   * @param[out] proxy_string A <code>PP_Var</code> that GetProxyForURL will
   * set upon successful completion. If the call fails, <code>proxy_string
   * </code> will be unchanged. Otherwise, it will be set to a string <code>
   * PP_Var</code> containing the appropriate PAC string for <code>url</code>.
   * If set, <code>proxy_string</code> will have a reference count of 1 which
   * the plugin must manage.
   *
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   */
  int32_t (*GetProxyForURL)(PP_Instance instance,
                            struct PP_Var url,
                            struct PP_Var* proxy_string,
                            struct PP_CompletionCallback callback);
};

typedef struct PPB_NetworkProxy_1_0 PPB_NetworkProxy;
/**
 * @}
 */

/* ppb_opengles2.idl */
#include "ppapi/c/pp_resource.h"

#ifndef __gl2_h_
typedef void GLvoid;
typedef int GLsizei;
typedef unsigned short GLushort;
typedef short GLshort;
typedef unsigned char GLubyte;
typedef unsigned int GLenum;
typedef int GLint;
typedef unsigned char GLboolean;
typedef unsigned int GLbitfield;
typedef float GLfloat;
typedef float GLclampf;
typedef signed char GLbyte;
typedef unsigned int GLuint;
typedef int GLfixed;
typedef int GLclampx;
#ifdef _WIN64
typedef long long int GLintptr;
typedef long long int GLsizeiptr;
#else
typedef long int GLintptr;
typedef long int GLsizeiptr;
#endif  // _WIN64
#endif  // __gl2_h_


/**
 * @addtogroup Interfaces
 * @{
 */
struct PPB_OpenGLES2_1_0 {
  void (*ActiveTexture)(PP_Resource context, GLenum texture);
  void (*AttachShader)(PP_Resource context, GLuint program, GLuint shader);
  void (*BindAttribLocation)(PP_Resource context,
                             GLuint program,
                             GLuint index,
                             const char* name);
  void (*BindBuffer)(PP_Resource context, GLenum target, GLuint buffer);
  void (*BindFramebuffer)(PP_Resource context,
                          GLenum target,
                          GLuint framebuffer);
  void (*BindRenderbuffer)(PP_Resource context,
                           GLenum target,
                           GLuint renderbuffer);
  void (*BindTexture)(PP_Resource context, GLenum target, GLuint texture);
  void (*BlendColor)(PP_Resource context,
                     GLclampf red,
                     GLclampf green,
                     GLclampf blue,
                     GLclampf alpha);
  void (*BlendEquation)(PP_Resource context, GLenum mode);
  void (*BlendEquationSeparate)(PP_Resource context,
                                GLenum modeRGB,
                                GLenum modeAlpha);
  void (*BlendFunc)(PP_Resource context, GLenum sfactor, GLenum dfactor);
  void (*BlendFuncSeparate)(PP_Resource context,
                            GLenum srcRGB,
                            GLenum dstRGB,
                            GLenum srcAlpha,
                            GLenum dstAlpha);
  void (*BufferData)(PP_Resource context,
                     GLenum target,
                     GLsizeiptr size,
                     const void* data,
                     GLenum usage);
  void (*BufferSubData)(PP_Resource context,
                        GLenum target,
                        GLintptr offset,
                        GLsizeiptr size,
                        const void* data);
  GLenum (*CheckFramebufferStatus)(PP_Resource context, GLenum target);
  void (*Clear)(PP_Resource context, GLbitfield mask);
  void (*ClearColor)(PP_Resource context,
                     GLclampf red,
                     GLclampf green,
                     GLclampf blue,
                     GLclampf alpha);
  void (*ClearDepthf)(PP_Resource context, GLclampf depth);
  void (*ClearStencil)(PP_Resource context, GLint s);
  void (*ColorMask)(PP_Resource context,
                    GLboolean red,
                    GLboolean green,
                    GLboolean blue,
                    GLboolean alpha);
  void (*CompileShader)(PP_Resource context, GLuint shader);
  void (*CompressedTexImage2D)(PP_Resource context,
                               GLenum target,
                               GLint level,
                               GLenum internalformat,
                               GLsizei width,
                               GLsizei height,
                               GLint border,
                               GLsizei imageSize,
                               const void* data);
  void (*CompressedTexSubImage2D)(PP_Resource context,
                                  GLenum target,
                                  GLint level,
                                  GLint xoffset,
                                  GLint yoffset,
                                  GLsizei width,
                                  GLsizei height,
                                  GLenum format,
                                  GLsizei imageSize,
                                  const void* data);
  void (*CopyTexImage2D)(PP_Resource context,
                         GLenum target,
                         GLint level,
                         GLenum internalformat,
                         GLint x,
                         GLint y,
                         GLsizei width,
                         GLsizei height,
                         GLint border);
  void (*CopyTexSubImage2D)(PP_Resource context,
                            GLenum target,
                            GLint level,
                            GLint xoffset,
                            GLint yoffset,
                            GLint x,
                            GLint y,
                            GLsizei width,
                            GLsizei height);
  GLuint (*CreateProgram)(PP_Resource context);
  GLuint (*CreateShader)(PP_Resource context, GLenum type);
  void (*CullFace)(PP_Resource context, GLenum mode);
  void (*DeleteBuffers)(PP_Resource context, GLsizei n, const GLuint* buffers);
  void (*DeleteFramebuffers)(PP_Resource context,
                             GLsizei n,
                             const GLuint* framebuffers);
  void (*DeleteProgram)(PP_Resource context, GLuint program);
  void (*DeleteRenderbuffers)(PP_Resource context,
                              GLsizei n,
                              const GLuint* renderbuffers);
  void (*DeleteShader)(PP_Resource context, GLuint shader);
  void (*DeleteTextures)(PP_Resource context,
                         GLsizei n,
                         const GLuint* textures);
  void (*DepthFunc)(PP_Resource context, GLenum func);
  void (*DepthMask)(PP_Resource context, GLboolean flag);
  void (*DepthRangef)(PP_Resource context, GLclampf zNear, GLclampf zFar);
  void (*DetachShader)(PP_Resource context, GLuint program, GLuint shader);
  void (*Disable)(PP_Resource context, GLenum cap);
  void (*DisableVertexAttribArray)(PP_Resource context, GLuint index);
  void (*DrawArrays)(PP_Resource context,
                     GLenum mode,
                     GLint first,
                     GLsizei count);
  void (*DrawElements)(PP_Resource context,
                       GLenum mode,
                       GLsizei count,
                       GLenum type,
                       const void* indices);
  void (*Enable)(PP_Resource context, GLenum cap);
  void (*EnableVertexAttribArray)(PP_Resource context, GLuint index);
  void (*Finish)(PP_Resource context);
  void (*Flush)(PP_Resource context);
  void (*FramebufferRenderbuffer)(PP_Resource context,
                                  GLenum target,
                                  GLenum attachment,
                                  GLenum renderbuffertarget,
                                  GLuint renderbuffer);
  void (*FramebufferTexture2D)(PP_Resource context,
                               GLenum target,
                               GLenum attachment,
                               GLenum textarget,
                               GLuint texture,
                               GLint level);
  void (*FrontFace)(PP_Resource context, GLenum mode);
  void (*GenBuffers)(PP_Resource context, GLsizei n, GLuint* buffers);
  void (*GenerateMipmap)(PP_Resource context, GLenum target);
  void (*GenFramebuffers)(PP_Resource context, GLsizei n, GLuint* framebuffers);
  void (*GenRenderbuffers)(PP_Resource context,
                           GLsizei n,
                           GLuint* renderbuffers);
  void (*GenTextures)(PP_Resource context, GLsizei n, GLuint* textures);
  void (*GetActiveAttrib)(PP_Resource context,
                          GLuint program,
                          GLuint index,
                          GLsizei bufsize,
                          GLsizei* length,
                          GLint* size,
                          GLenum* type,
                          char* name);
  void (*GetActiveUniform)(PP_Resource context,
                           GLuint program,
                           GLuint index,
                           GLsizei bufsize,
                           GLsizei* length,
                           GLint* size,
                           GLenum* type,
                           char* name);
  void (*GetAttachedShaders)(PP_Resource context,
                             GLuint program,
                             GLsizei maxcount,
                             GLsizei* count,
                             GLuint* shaders);
  GLint (*GetAttribLocation)(PP_Resource context,
                             GLuint program,
                             const char* name);
  void (*GetBooleanv)(PP_Resource context, GLenum pname, GLboolean* params);
  void (*GetBufferParameteriv)(PP_Resource context,
                               GLenum target,
                               GLenum pname,
                               GLint* params);
  GLenum (*GetError)(PP_Resource context);
  void (*GetFloatv)(PP_Resource context, GLenum pname, GLfloat* params);
  void (*GetFramebufferAttachmentParameteriv)(PP_Resource context,
                                              GLenum target,
                                              GLenum attachment,
                                              GLenum pname,
                                              GLint* params);
  void (*GetIntegerv)(PP_Resource context, GLenum pname, GLint* params);
  void (*GetProgramiv)(PP_Resource context,
                       GLuint program,
                       GLenum pname,
                       GLint* params);
  void (*GetProgramInfoLog)(PP_Resource context,
                            GLuint program,
                            GLsizei bufsize,
                            GLsizei* length,
                            char* infolog);
  void (*GetRenderbufferParameteriv)(PP_Resource context,
                                     GLenum target,
                                     GLenum pname,
                                     GLint* params);
  void (*GetShaderiv)(PP_Resource context,
                      GLuint shader,
                      GLenum pname,
                      GLint* params);
  void (*GetShaderInfoLog)(PP_Resource context,
                           GLuint shader,
                           GLsizei bufsize,
                           GLsizei* length,
                           char* infolog);
  void (*GetShaderPrecisionFormat)(PP_Resource context,
                                   GLenum shadertype,
                                   GLenum precisiontype,
                                   GLint* range,
                                   GLint* precision);
  void (*GetShaderSource)(PP_Resource context,
                          GLuint shader,
                          GLsizei bufsize,
                          GLsizei* length,
                          char* source);
  const GLubyte* (*GetString)(PP_Resource context, GLenum name);
  void (*GetTexParameterfv)(PP_Resource context,
                            GLenum target,
                            GLenum pname,
                            GLfloat* params);
  void (*GetTexParameteriv)(PP_Resource context,
                            GLenum target,
                            GLenum pname,
                            GLint* params);
  void (*GetUniformfv)(PP_Resource context,
                       GLuint program,
                       GLint location,
                       GLfloat* params);
  void (*GetUniformiv)(PP_Resource context,
                       GLuint program,
                       GLint location,
                       GLint* params);
  GLint (*GetUniformLocation)(PP_Resource context,
                              GLuint program,
                              const char* name);
  void (*GetVertexAttribfv)(PP_Resource context,
                            GLuint index,
                            GLenum pname,
                            GLfloat* params);
  void (*GetVertexAttribiv)(PP_Resource context,
                            GLuint index,
                            GLenum pname,
                            GLint* params);
  void (*GetVertexAttribPointerv)(PP_Resource context,
                                  GLuint index,
                                  GLenum pname,
                                  void** pointer);
  void (*Hint)(PP_Resource context, GLenum target, GLenum mode);
  GLboolean (*IsBuffer)(PP_Resource context, GLuint buffer);
  GLboolean (*IsEnabled)(PP_Resource context, GLenum cap);
  GLboolean (*IsFramebuffer)(PP_Resource context, GLuint framebuffer);
  GLboolean (*IsProgram)(PP_Resource context, GLuint program);
  GLboolean (*IsRenderbuffer)(PP_Resource context, GLuint renderbuffer);
  GLboolean (*IsShader)(PP_Resource context, GLuint shader);
  GLboolean (*IsTexture)(PP_Resource context, GLuint texture);
  void (*LineWidth)(PP_Resource context, GLfloat width);
  void (*LinkProgram)(PP_Resource context, GLuint program);
  void (*PixelStorei)(PP_Resource context, GLenum pname, GLint param);
  void (*PolygonOffset)(PP_Resource context, GLfloat factor, GLfloat units);
  void (*ReadPixels)(PP_Resource context,
                     GLint x,
                     GLint y,
                     GLsizei width,
                     GLsizei height,
                     GLenum format,
                     GLenum type,
                     void* pixels);
  void (*ReleaseShaderCompiler)(PP_Resource context);
  void (*RenderbufferStorage)(PP_Resource context,
                              GLenum target,
                              GLenum internalformat,
                              GLsizei width,
                              GLsizei height);
  void (*SampleCoverage)(PP_Resource context, GLclampf value, GLboolean invert);
  void (*Scissor)(PP_Resource context,
                  GLint x,
                  GLint y,
                  GLsizei width,
                  GLsizei height);
  void (*ShaderBinary)(PP_Resource context,
                       GLsizei n,
                       const GLuint* shaders,
                       GLenum binaryformat,
                       const void* binary,
                       GLsizei length);
  void (*ShaderSource)(PP_Resource context,
                       GLuint shader,
                       GLsizei count,
                       const char** str,
                       const GLint* length);
  void (*StencilFunc)(PP_Resource context, GLenum func, GLint ref, GLuint mask);
  void (*StencilFuncSeparate)(PP_Resource context,
                              GLenum face,
                              GLenum func,
                              GLint ref,
                              GLuint mask);
  void (*StencilMask)(PP_Resource context, GLuint mask);
  void (*StencilMaskSeparate)(PP_Resource context, GLenum face, GLuint mask);
  void (*StencilOp)(PP_Resource context,
                    GLenum fail,
                    GLenum zfail,
                    GLenum zpass);
  void (*StencilOpSeparate)(PP_Resource context,
                            GLenum face,
                            GLenum fail,
                            GLenum zfail,
                            GLenum zpass);
  void (*TexImage2D)(PP_Resource context,
                     GLenum target,
                     GLint level,
                     GLint internalformat,
                     GLsizei width,
                     GLsizei height,
                     GLint border,
                     GLenum format,
                     GLenum type,
                     const void* pixels);
  void (*TexParameterf)(PP_Resource context,
                        GLenum target,
                        GLenum pname,
                        GLfloat param);
  void (*TexParameterfv)(PP_Resource context,
                         GLenum target,
                         GLenum pname,
                         const GLfloat* params);
  void (*TexParameteri)(PP_Resource context,
                        GLenum target,
                        GLenum pname,
                        GLint param);
  void (*TexParameteriv)(PP_Resource context,
                         GLenum target,
                         GLenum pname,
                         const GLint* params);
  void (*TexSubImage2D)(PP_Resource context,
                        GLenum target,
                        GLint level,
                        GLint xoffset,
                        GLint yoffset,
                        GLsizei width,
                        GLsizei height,
                        GLenum format,
                        GLenum type,
                        const void* pixels);
  void (*Uniform1f)(PP_Resource context, GLint location, GLfloat x);
  void (*Uniform1fv)(PP_Resource context,
                     GLint location,
                     GLsizei count,
                     const GLfloat* v);
  void (*Uniform1i)(PP_Resource context, GLint location, GLint x);
  void (*Uniform1iv)(PP_Resource context,
                     GLint location,
                     GLsizei count,
                     const GLint* v);
  void (*Uniform2f)(PP_Resource context, GLint location, GLfloat x, GLfloat y);
  void (*Uniform2fv)(PP_Resource context,
                     GLint location,
                     GLsizei count,
                     const GLfloat* v);
  void (*Uniform2i)(PP_Resource context, GLint location, GLint x, GLint y);
  void (*Uniform2iv)(PP_Resource context,
                     GLint location,
                     GLsizei count,
                     const GLint* v);
  void (*Uniform3f)(PP_Resource context,
                    GLint location,
                    GLfloat x,
                    GLfloat y,
                    GLfloat z);
  void (*Uniform3fv)(PP_Resource context,
                     GLint location,
                     GLsizei count,
                     const GLfloat* v);
  void (*Uniform3i)(PP_Resource context,
                    GLint location,
                    GLint x,
                    GLint y,
                    GLint z);
  void (*Uniform3iv)(PP_Resource context,
                     GLint location,
                     GLsizei count,
                     const GLint* v);
  void (*Uniform4f)(PP_Resource context,
                    GLint location,
                    GLfloat x,
                    GLfloat y,
                    GLfloat z,
                    GLfloat w);
  void (*Uniform4fv)(PP_Resource context,
                     GLint location,
                     GLsizei count,
                     const GLfloat* v);
  void (*Uniform4i)(PP_Resource context,
                    GLint location,
                    GLint x,
                    GLint y,
                    GLint z,
                    GLint w);
  void (*Uniform4iv)(PP_Resource context,
                     GLint location,
                     GLsizei count,
                     const GLint* v);
  void (*UniformMatrix2fv)(PP_Resource context,
                           GLint location,
                           GLsizei count,
                           GLboolean transpose,
                           const GLfloat* value);
  void (*UniformMatrix3fv)(PP_Resource context,
                           GLint location,
                           GLsizei count,
                           GLboolean transpose,
                           const GLfloat* value);
  void (*UniformMatrix4fv)(PP_Resource context,
                           GLint location,
                           GLsizei count,
                           GLboolean transpose,
                           const GLfloat* value);
  void (*UseProgram)(PP_Resource context, GLuint program);
  void (*ValidateProgram)(PP_Resource context, GLuint program);
  void (*VertexAttrib1f)(PP_Resource context, GLuint indx, GLfloat x);
  void (*VertexAttrib1fv)(PP_Resource context,
                          GLuint indx,
                          const GLfloat* values);
  void (*VertexAttrib2f)(PP_Resource context,
                         GLuint indx,
                         GLfloat x,
                         GLfloat y);
  void (*VertexAttrib2fv)(PP_Resource context,
                          GLuint indx,
                          const GLfloat* values);
  void (*VertexAttrib3f)(PP_Resource context,
                         GLuint indx,
                         GLfloat x,
                         GLfloat y,
                         GLfloat z);
  void (*VertexAttrib3fv)(PP_Resource context,
                          GLuint indx,
                          const GLfloat* values);
  void (*VertexAttrib4f)(PP_Resource context,
                         GLuint indx,
                         GLfloat x,
                         GLfloat y,
                         GLfloat z,
                         GLfloat w);
  void (*VertexAttrib4fv)(PP_Resource context,
                          GLuint indx,
                          const GLfloat* values);
  void (*VertexAttribPointer)(PP_Resource context,
                              GLuint indx,
                              GLint size,
                              GLenum type,
                              GLboolean normalized,
                              GLsizei stride,
                              const void* ptr);
  void (*Viewport)(PP_Resource context,
                   GLint x,
                   GLint y,
                   GLsizei width,
                   GLsizei height);
};

struct PPB_OpenGLES2 {
  void (*ActiveTexture)(PP_Resource context, GLenum texture);
  void (*AttachShader)(PP_Resource context, GLuint program, GLuint shader);
  void (*BindAttribLocation)(PP_Resource context,
                             GLuint program,
                             GLuint index,
                             const char* name);
  void (*BindBuffer)(PP_Resource context, GLenum target, GLuint buffer);
  void (*BindFramebuffer)(PP_Resource context,
                          GLenum target,
                          GLuint framebuffer);
  void (*BindRenderbuffer)(PP_Resource context,
                           GLenum target,
                           GLuint renderbuffer);
  void (*BindTexture)(PP_Resource context, GLenum target, GLuint texture);
  void (*BlendColor)(PP_Resource context,
                     GLclampf red,
                     GLclampf green,
                     GLclampf blue,
                     GLclampf alpha);
  void (*BlendEquation)(PP_Resource context, GLenum mode);
  void (*BlendEquationSeparate)(PP_Resource context,
                                GLenum modeRGB,
                                GLenum modeAlpha);
  void (*BlendFunc)(PP_Resource context, GLenum sfactor, GLenum dfactor);
  void (*BlendFuncSeparate)(PP_Resource context,
                            GLenum srcRGB,
                            GLenum dstRGB,
                            GLenum srcAlpha,
                            GLenum dstAlpha);
  void (*BufferData)(PP_Resource context,
                     GLenum target,
                     GLsizeiptr size,
                     const void* data,
                     GLenum usage);
  void (*BufferSubData)(PP_Resource context,
                        GLenum target,
                        GLintptr offset,
                        GLsizeiptr size,
                        const void* data);
  GLenum (*CheckFramebufferStatus)(PP_Resource context, GLenum target);
  void (*Clear)(PP_Resource context, GLbitfield mask);
  void (*ClearColor)(PP_Resource context,
                     GLclampf red,
                     GLclampf green,
                     GLclampf blue,
                     GLclampf alpha);
  void (*ClearDepthf)(PP_Resource context, GLclampf depth);
  void (*ClearStencil)(PP_Resource context, GLint s);
  void (*ColorMask)(PP_Resource context,
                    GLboolean red,
                    GLboolean green,
                    GLboolean blue,
                    GLboolean alpha);
  void (*CompileShader)(PP_Resource context, GLuint shader);
  void (*CompressedTexImage2D)(PP_Resource context,
                               GLenum target,
                               GLint level,
                               GLenum internalformat,
                               GLsizei width,
                               GLsizei height,
                               GLint border,
                               GLsizei imageSize,
                               const void* data);
  void (*CompressedTexSubImage2D)(PP_Resource context,
                                  GLenum target,
                                  GLint level,
                                  GLint xoffset,
                                  GLint yoffset,
                                  GLsizei width,
                                  GLsizei height,
                                  GLenum format,
                                  GLsizei imageSize,
                                  const void* data);
  void (*CopyTexImage2D)(PP_Resource context,
                         GLenum target,
                         GLint level,
                         GLenum internalformat,
                         GLint x,
                         GLint y,
                         GLsizei width,
                         GLsizei height,
                         GLint border);
  void (*CopyTexSubImage2D)(PP_Resource context,
                            GLenum target,
                            GLint level,
                            GLint xoffset,
                            GLint yoffset,
                            GLint x,
                            GLint y,
                            GLsizei width,
                            GLsizei height);
  GLuint (*CreateProgram)(PP_Resource context);
  GLuint (*CreateShader)(PP_Resource context, GLenum type);
  void (*CullFace)(PP_Resource context, GLenum mode);
  void (*DeleteBuffers)(PP_Resource context, GLsizei n, const GLuint* buffers);
  void (*DeleteFramebuffers)(PP_Resource context,
                             GLsizei n,
                             const GLuint* framebuffers);
  void (*DeleteProgram)(PP_Resource context, GLuint program);
  void (*DeleteRenderbuffers)(PP_Resource context,
                              GLsizei n,
                              const GLuint* renderbuffers);
  void (*DeleteShader)(PP_Resource context, GLuint shader);
  void (*DeleteTextures)(PP_Resource context,
                         GLsizei n,
                         const GLuint* textures);
  void (*DepthFunc)(PP_Resource context, GLenum func);
  void (*DepthMask)(PP_Resource context, GLboolean flag);
  void (*DepthRangef)(PP_Resource context, GLclampf zNear, GLclampf zFar);
  void (*DetachShader)(PP_Resource context, GLuint program, GLuint shader);
  void (*Disable)(PP_Resource context, GLenum cap);
  void (*DisableVertexAttribArray)(PP_Resource context, GLuint index);
  void (*DrawArrays)(PP_Resource context,
                     GLenum mode,
                     GLint first,
                     GLsizei count);
  void (*DrawElements)(PP_Resource context,
                       GLenum mode,
                       GLsizei count,
                       GLenum type,
                       const void* indices);
  void (*Enable)(PP_Resource context, GLenum cap);
  void (*EnableVertexAttribArray)(PP_Resource context, GLuint index);
  void (*Finish)(PP_Resource context);
  void (*Flush)(PP_Resource context);
  void (*FramebufferRenderbuffer)(PP_Resource context,
                                  GLenum target,
                                  GLenum attachment,
                                  GLenum renderbuffertarget,
                                  GLuint renderbuffer);
  void (*FramebufferTexture2D)(PP_Resource context,
                               GLenum target,
                               GLenum attachment,
                               GLenum textarget,
                               GLuint texture,
                               GLint level);
  void (*FrontFace)(PP_Resource context, GLenum mode);
  void (*GenBuffers)(PP_Resource context, GLsizei n, GLuint* buffers);
  void (*GenerateMipmap)(PP_Resource context, GLenum target);
  void (*GenFramebuffers)(PP_Resource context, GLsizei n, GLuint* framebuffers);
  void (*GenRenderbuffers)(PP_Resource context,
                           GLsizei n,
                           GLuint* renderbuffers);
  void (*GenTextures)(PP_Resource context, GLsizei n, GLuint* textures);
  void (*GetActiveAttrib)(PP_Resource context,
                          GLuint program,
                          GLuint index,
                          GLsizei bufsize,
                          GLsizei* length,
                          GLint* size,
                          GLenum* type,
                          char* name);
  void (*GetActiveUniform)(PP_Resource context,
                           GLuint program,
                           GLuint index,
                           GLsizei bufsize,
                           GLsizei* length,
                           GLint* size,
                           GLenum* type,
                           char* name);
  void (*GetAttachedShaders)(PP_Resource context,
                             GLuint program,
                             GLsizei maxcount,
                             GLsizei* count,
                             GLuint* shaders);
  GLint (*GetAttribLocation)(PP_Resource context,
                             GLuint program,
                             const char* name);
  void (*GetBooleanv)(PP_Resource context, GLenum pname, GLboolean* params);
  void (*GetBufferParameteriv)(PP_Resource context,
                               GLenum target,
                               GLenum pname,
                               GLint* params);
  GLenum (*GetError)(PP_Resource context);
  void (*GetFloatv)(PP_Resource context, GLenum pname, GLfloat* params);
  void (*GetFramebufferAttachmentParameteriv)(PP_Resource context,
                                              GLenum target,
                                              GLenum attachment,
                                              GLenum pname,
                                              GLint* params);
  void (*GetIntegerv)(PP_Resource context, GLenum pname, GLint* params);
  void (*GetProgramiv)(PP_Resource context,
                       GLuint program,
                       GLenum pname,
                       GLint* params);
  void (*GetProgramInfoLog)(PP_Resource context,
                            GLuint program,
                            GLsizei bufsize,
                            GLsizei* length,
                            char* infolog);
  void (*GetRenderbufferParameteriv)(PP_Resource context,
                                     GLenum target,
                                     GLenum pname,
                                     GLint* params);
  void (*GetShaderiv)(PP_Resource context,
                      GLuint shader,
                      GLenum pname,
                      GLint* params);
  void (*GetShaderInfoLog)(PP_Resource context,
                           GLuint shader,
                           GLsizei bufsize,
                           GLsizei* length,
                           char* infolog);
  void (*GetShaderPrecisionFormat)(PP_Resource context,
                                   GLenum shadertype,
                                   GLenum precisiontype,
                                   GLint* range,
                                   GLint* precision);
  void (*GetShaderSource)(PP_Resource context,
                          GLuint shader,
                          GLsizei bufsize,
                          GLsizei* length,
                          char* source);
  const GLubyte* (*GetString)(PP_Resource context, GLenum name);
  void (*GetTexParameterfv)(PP_Resource context,
                            GLenum target,
                            GLenum pname,
                            GLfloat* params);
  void (*GetTexParameteriv)(PP_Resource context,
                            GLenum target,
                            GLenum pname,
                            GLint* params);
  void (*GetUniformfv)(PP_Resource context,
                       GLuint program,
                       GLint location,
                       GLfloat* params);
  void (*GetUniformiv)(PP_Resource context,
                       GLuint program,
                       GLint location,
                       GLint* params);
  GLint (*GetUniformLocation)(PP_Resource context,
                              GLuint program,
                              const char* name);
  void (*GetVertexAttribfv)(PP_Resource context,
                            GLuint index,
                            GLenum pname,
                            GLfloat* params);
  void (*GetVertexAttribiv)(PP_Resource context,
                            GLuint index,
                            GLenum pname,
                            GLint* params);
  void (*GetVertexAttribPointerv)(PP_Resource context,
                                  GLuint index,
                                  GLenum pname,
                                  void** pointer);
  void (*Hint)(PP_Resource context, GLenum target, GLenum mode);
  GLboolean (*IsBuffer)(PP_Resource context, GLuint buffer);
  GLboolean (*IsEnabled)(PP_Resource context, GLenum cap);
  GLboolean (*IsFramebuffer)(PP_Resource context, GLuint framebuffer);
  GLboolean (*IsProgram)(PP_Resource context, GLuint program);
  GLboolean (*IsRenderbuffer)(PP_Resource context, GLuint renderbuffer);
  GLboolean (*IsShader)(PP_Resource context, GLuint shader);
  GLboolean (*IsTexture)(PP_Resource context, GLuint texture);
  void (*LineWidth)(PP_Resource context, GLfloat width);
  void (*LinkProgram)(PP_Resource context, GLuint program);
  void (*PixelStorei)(PP_Resource context, GLenum pname, GLint param);
  void (*PolygonOffset)(PP_Resource context, GLfloat factor, GLfloat units);
  void (*ReadPixels)(PP_Resource context,
                     GLint x,
                     GLint y,
                     GLsizei width,
                     GLsizei height,
                     GLenum format,
                     GLenum type,
                     void* pixels);
  void (*ReleaseShaderCompiler)(PP_Resource context);
  void (*RenderbufferStorage)(PP_Resource context,
                              GLenum target,
                              GLenum internalformat,
                              GLsizei width,
                              GLsizei height);
  void (*SampleCoverage)(PP_Resource context, GLclampf value, GLboolean invert);
  void (*Scissor)(PP_Resource context,
                  GLint x,
                  GLint y,
                  GLsizei width,
                  GLsizei height);
  void (*ShaderBinary)(PP_Resource context,
                       GLsizei n,
                       const GLuint* shaders,
                       GLenum binaryformat,
                       const void* binary,
                       GLsizei length);
  void (*ShaderSource)(PP_Resource context,
                       GLuint shader,
                       GLsizei count,
                       const char** str,
                       const GLint* length);
  void (*StencilFunc)(PP_Resource context, GLenum func, GLint ref, GLuint mask);
  void (*StencilFuncSeparate)(PP_Resource context,
                              GLenum face,
                              GLenum func,
                              GLint ref,
                              GLuint mask);
  void (*StencilMask)(PP_Resource context, GLuint mask);
  void (*StencilMaskSeparate)(PP_Resource context, GLenum face, GLuint mask);
  void (*StencilOp)(PP_Resource context,
                    GLenum fail,
                    GLenum zfail,
                    GLenum zpass);
  void (*StencilOpSeparate)(PP_Resource context,
                            GLenum face,
                            GLenum fail,
                            GLenum zfail,
                            GLenum zpass);
  void (*TexImage2D)(PP_Resource context,
                     GLenum target,
                     GLint level,
                     GLint internalformat,
                     GLsizei width,
                     GLsizei height,
                     GLint border,
                     GLenum format,
                     GLenum type,
                     const void* pixels);
  void (*TexParameterf)(PP_Resource context,
                        GLenum target,
                        GLenum pname,
                        GLfloat param);
  void (*TexParameterfv)(PP_Resource context,
                         GLenum target,
                         GLenum pname,
                         const GLfloat* params);
  void (*TexParameteri)(PP_Resource context,
                        GLenum target,
                        GLenum pname,
                        GLint param);
  void (*TexParameteriv)(PP_Resource context,
                         GLenum target,
                         GLenum pname,
                         const GLint* params);
  void (*TexSubImage2D)(PP_Resource context,
                        GLenum target,
                        GLint level,
                        GLint xoffset,
                        GLint yoffset,
                        GLsizei width,
                        GLsizei height,
                        GLenum format,
                        GLenum type,
                        const void* pixels);
  void (*Uniform1f)(PP_Resource context, GLint location, GLfloat x);
  void (*Uniform1fv)(PP_Resource context,
                     GLint location,
                     GLsizei count,
                     const GLfloat* v);
  void (*Uniform1i)(PP_Resource context, GLint location, GLint x);
  void (*Uniform1iv)(PP_Resource context,
                     GLint location,
                     GLsizei count,
                     const GLint* v);
  void (*Uniform2f)(PP_Resource context, GLint location, GLfloat x, GLfloat y);
  void (*Uniform2fv)(PP_Resource context,
                     GLint location,
                     GLsizei count,
                     const GLfloat* v);
  void (*Uniform2i)(PP_Resource context, GLint location, GLint x, GLint y);
  void (*Uniform2iv)(PP_Resource context,
                     GLint location,
                     GLsizei count,
                     const GLint* v);
  void (*Uniform3f)(PP_Resource context,
                    GLint location,
                    GLfloat x,
                    GLfloat y,
                    GLfloat z);
  void (*Uniform3fv)(PP_Resource context,
                     GLint location,
                     GLsizei count,
                     const GLfloat* v);
  void (*Uniform3i)(PP_Resource context,
                    GLint location,
                    GLint x,
                    GLint y,
                    GLint z);
  void (*Uniform3iv)(PP_Resource context,
                     GLint location,
                     GLsizei count,
                     const GLint* v);
  void (*Uniform4f)(PP_Resource context,
                    GLint location,
                    GLfloat x,
                    GLfloat y,
                    GLfloat z,
                    GLfloat w);
  void (*Uniform4fv)(PP_Resource context,
                     GLint location,
                     GLsizei count,
                     const GLfloat* v);
  void (*Uniform4i)(PP_Resource context,
                    GLint location,
                    GLint x,
                    GLint y,
                    GLint z,
                    GLint w);
  void (*Uniform4iv)(PP_Resource context,
                     GLint location,
                     GLsizei count,
                     const GLint* v);
  void (*UniformMatrix2fv)(PP_Resource context,
                           GLint location,
                           GLsizei count,
                           GLboolean transpose,
                           const GLfloat* value);
  void (*UniformMatrix3fv)(PP_Resource context,
                           GLint location,
                           GLsizei count,
                           GLboolean transpose,
                           const GLfloat* value);
  void (*UniformMatrix4fv)(PP_Resource context,
                           GLint location,
                           GLsizei count,
                           GLboolean transpose,
                           const GLfloat* value);
  void (*UseProgram)(PP_Resource context, GLuint program);
  void (*ValidateProgram)(PP_Resource context, GLuint program);
  void (*VertexAttrib1f)(PP_Resource context, GLuint indx, GLfloat x);
  void (*VertexAttrib1fv)(PP_Resource context,
                          GLuint indx,
                          const GLfloat* values);
  void (*VertexAttrib2f)(PP_Resource context,
                         GLuint indx,
                         GLfloat x,
                         GLfloat y);
  void (*VertexAttrib2fv)(PP_Resource context,
                          GLuint indx,
                          const GLfloat* values);
  void (*VertexAttrib3f)(PP_Resource context,
                         GLuint indx,
                         GLfloat x,
                         GLfloat y,
                         GLfloat z);
  void (*VertexAttrib3fv)(PP_Resource context,
                          GLuint indx,
                          const GLfloat* values);
  void (*VertexAttrib4f)(PP_Resource context,
                         GLuint indx,
                         GLfloat x,
                         GLfloat y,
                         GLfloat z,
                         GLfloat w);
  void (*VertexAttrib4fv)(PP_Resource context,
                          GLuint indx,
                          const GLfloat* values);
  void (*VertexAttribPointer)(PP_Resource context,
                              GLuint indx,
                              GLint size,
                              GLenum type,
                              GLboolean normalized,
                              GLsizei stride,
                              const void* ptr);
  void (*Viewport)(PP_Resource context,
                   GLint x,
                   GLint y,
                   GLsizei width,
                   GLsizei height);
};

struct PPB_OpenGLES2InstancedArrays_1_0 {
  void (*DrawArraysInstancedANGLE)(PP_Resource context,
                                   GLenum mode,
                                   GLint first,
                                   GLsizei count,
                                   GLsizei primcount);
  void (*DrawElementsInstancedANGLE)(PP_Resource context,
                                     GLenum mode,
                                     GLsizei count,
                                     GLenum type,
                                     const void* indices,
                                     GLsizei primcount);
  void (*VertexAttribDivisorANGLE)(PP_Resource context,
                                   GLuint index,
                                   GLuint divisor);
};

struct PPB_OpenGLES2InstancedArrays {
  void (*DrawArraysInstancedANGLE)(PP_Resource context,
                                   GLenum mode,
                                   GLint first,
                                   GLsizei count,
                                   GLsizei primcount);
  void (*DrawElementsInstancedANGLE)(PP_Resource context,
                                     GLenum mode,
                                     GLsizei count,
                                     GLenum type,
                                     const void* indices,
                                     GLsizei primcount);
  void (*VertexAttribDivisorANGLE)(PP_Resource context,
                                   GLuint index,
                                   GLuint divisor);
};

struct PPB_OpenGLES2FramebufferBlit_1_0 {
  void (*BlitFramebufferEXT)(PP_Resource context,
                             GLint srcX0,
                             GLint srcY0,
                             GLint srcX1,
                             GLint srcY1,
                             GLint dstX0,
                             GLint dstY0,
                             GLint dstX1,
                             GLint dstY1,
                             GLbitfield mask,
                             GLenum filter);
};

struct PPB_OpenGLES2FramebufferBlit {
  void (*BlitFramebufferEXT)(PP_Resource context,
                             GLint srcX0,
                             GLint srcY0,
                             GLint srcX1,
                             GLint srcY1,
                             GLint dstX0,
                             GLint dstY0,
                             GLint dstX1,
                             GLint dstY1,
                             GLbitfield mask,
                             GLenum filter);
};

struct PPB_OpenGLES2FramebufferMultisample_1_0 {
  void (*RenderbufferStorageMultisampleEXT)(PP_Resource context,
                                            GLenum target,
                                            GLsizei samples,
                                            GLenum internalformat,
                                            GLsizei width,
                                            GLsizei height);
};

struct PPB_OpenGLES2FramebufferMultisample {
  void (*RenderbufferStorageMultisampleEXT)(PP_Resource context,
                                            GLenum target,
                                            GLsizei samples,
                                            GLenum internalformat,
                                            GLsizei width,
                                            GLsizei height);
};

struct PPB_OpenGLES2ChromiumEnableFeature_1_0 {
  GLboolean (*EnableFeatureCHROMIUM)(PP_Resource context, const char* feature);
};

struct PPB_OpenGLES2ChromiumEnableFeature {
  GLboolean (*EnableFeatureCHROMIUM)(PP_Resource context, const char* feature);
};

struct PPB_OpenGLES2ChromiumMapSub_1_0 {
  void* (*MapBufferSubDataCHROMIUM)(PP_Resource context,
                                    GLuint target,
                                    GLintptr offset,
                                    GLsizeiptr size,
                                    GLenum access);
  void (*UnmapBufferSubDataCHROMIUM)(PP_Resource context, const void* mem);
  void* (*MapTexSubImage2DCHROMIUM)(PP_Resource context,
                                    GLenum target,
                                    GLint level,
                                    GLint xoffset,
                                    GLint yoffset,
                                    GLsizei width,
                                    GLsizei height,
                                    GLenum format,
                                    GLenum type,
                                    GLenum access);
  void (*UnmapTexSubImage2DCHROMIUM)(PP_Resource context, const void* mem);
};

struct PPB_OpenGLES2ChromiumMapSub {
  void* (*MapBufferSubDataCHROMIUM)(PP_Resource context,
                                    GLuint target,
                                    GLintptr offset,
                                    GLsizeiptr size,
                                    GLenum access);
  void (*UnmapBufferSubDataCHROMIUM)(PP_Resource context, const void* mem);
  void* (*MapTexSubImage2DCHROMIUM)(PP_Resource context,
                                    GLenum target,
                                    GLint level,
                                    GLint xoffset,
                                    GLint yoffset,
                                    GLsizei width,
                                    GLsizei height,
                                    GLenum format,
                                    GLenum type,
                                    GLenum access);
  void (*UnmapTexSubImage2DCHROMIUM)(PP_Resource context, const void* mem);
};

struct PPB_OpenGLES2Query_1_0 {
  void (*GenQueriesEXT)(PP_Resource context, GLsizei n, GLuint* queries);
  void (*DeleteQueriesEXT)(PP_Resource context,
                           GLsizei n,
                           const GLuint* queries);
  GLboolean (*IsQueryEXT)(PP_Resource context, GLuint id);
  void (*BeginQueryEXT)(PP_Resource context, GLenum target, GLuint id);
  void (*EndQueryEXT)(PP_Resource context, GLenum target);
  void (*GetQueryivEXT)(PP_Resource context,
                        GLenum target,
                        GLenum pname,
                        GLint* params);
  void (*GetQueryObjectuivEXT)(PP_Resource context,
                               GLuint id,
                               GLenum pname,
                               GLuint* params);
};

struct PPB_OpenGLES2Query {
  void (*GenQueriesEXT)(PP_Resource context, GLsizei n, GLuint* queries);
  void (*DeleteQueriesEXT)(PP_Resource context,
                           GLsizei n,
                           const GLuint* queries);
  GLboolean (*IsQueryEXT)(PP_Resource context, GLuint id);
  void (*BeginQueryEXT)(PP_Resource context, GLenum target, GLuint id);
  void (*EndQueryEXT)(PP_Resource context, GLenum target);
  void (*GetQueryivEXT)(PP_Resource context,
                        GLenum target,
                        GLenum pname,
                        GLint* params);
  void (*GetQueryObjectuivEXT)(PP_Resource context,
                               GLuint id,
                               GLenum pname,
                               GLuint* params);
};

struct PPB_OpenGLES2VertexArrayObject_1_0 {
  void (*GenVertexArraysOES)(PP_Resource context, GLsizei n, GLuint* arrays);
  void (*DeleteVertexArraysOES)(PP_Resource context,
                                GLsizei n,
                                const GLuint* arrays);
  GLboolean (*IsVertexArrayOES)(PP_Resource context, GLuint array);
  void (*BindVertexArrayOES)(PP_Resource context, GLuint array);
};

struct PPB_OpenGLES2VertexArrayObject {
  void (*GenVertexArraysOES)(PP_Resource context, GLsizei n, GLuint* arrays);
  void (*DeleteVertexArraysOES)(PP_Resource context,
                                GLsizei n,
                                const GLuint* arrays);
  GLboolean (*IsVertexArrayOES)(PP_Resource context, GLuint array);
  void (*BindVertexArrayOES)(PP_Resource context, GLuint array);
};
/**
 * @}
 */

/* ppb_tcp_socket.idl */
/**
 * @addtogroup Enums
 * @{
 */
/**
 * Option names used by <code>SetOption()</code>.
 */
typedef enum {
  /**
   * Disables coalescing of small writes to make TCP segments, and instead
   * delivers data immediately. Value's type is <code>PP_VARTYPE_BOOL</code>.
   * On version 1.1 or earlier, this option can only be set after a successful
   * <code>Connect()</code> call. On version 1.2 or later, there is no such
   * limitation.
   */
  PP_TCPSOCKET_OPTION_NO_DELAY = 0,
  /**
   * Specifies the total per-socket buffer space reserved for sends. Value's
   * type should be <code>PP_VARTYPE_INT32</code>.
   * On version 1.1 or earlier, this option can only be set after a successful
   * <code>Connect()</code> call. On version 1.2 or later, there is no such
   * limitation.
   *
   * Note: This is only treated as a hint for the browser to set the buffer
   * size. Even if <code>SetOption()</code> succeeds, the browser doesn't
   * guarantee it will conform to the size.
   */
  PP_TCPSOCKET_OPTION_SEND_BUFFER_SIZE = 1,
  /**
   * Specifies the total per-socket buffer space reserved for receives. Value's
   * type should be <code>PP_VARTYPE_INT32</code>.
   * On version 1.1 or earlier, this option can only be set after a successful
   * <code>Connect()</code> call. On version 1.2 or later, there is no such
   * limitation.
   *
   * Note: This is only treated as a hint for the browser to set the buffer
   * size. Even if <code>SetOption()</code> succeeds, the browser doesn't
   * guarantee it will conform to the size.
   */
  PP_TCPSOCKET_OPTION_RECV_BUFFER_SIZE = 2
} PP_TCPSocket_Option;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_TCPSocket_Option, 4);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPB_TCPSocket</code> interface provides TCP socket operations.
 *
 * Permissions: Apps permission <code>socket</code> with subrule
 * <code>tcp-connect</code> is required for <code>Connect()</code>; subrule
 * <code>tcp-listen</code> is required for <code>Listen()</code>.
 * For more details about network communication permissions, please see:
 * http://developer.chrome.com/apps/app_network.html
 */
struct PPB_TCPSocket_1_2 {
  /**
   * Creates a TCP socket resource.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying one instance of
   * a module.
   *
   * @return A <code>PP_Resource</code> corresponding to a TCP socket or 0
   * on failure.
   */
  PP_Resource (*Create)(PP_Instance instance);
  /**
   * Determines if a given resource is a TCP socket.
   *
   * @param[in] resource A <code>PP_Resource</code> to check.
   *
   * @return <code>PP_TRUE</code> if the input is a
   * <code>PPB_TCPSocket</code> resource; <code>PP_FALSE</code> otherwise.
   */
  PP_Bool (*IsTCPSocket)(PP_Resource resource);
  /**
   * Binds the socket to the given address. The socket must not be bound.
   *
   * @param[in] tcp_socket A <code>PP_Resource</code> corresponding to a TCP
   * socket.
   * @param[in] addr A <code>PPB_NetAddress</code> resource.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>,
   * including (but not limited to):
   * - <code>PP_ERROR_ADDRESS_IN_USE</code>: the address is already in use.
   * - <code>PP_ERROR_ADDRESS_INVALID</code>: the address is invalid.
   */
  int32_t (*Bind)(PP_Resource tcp_socket,
                  PP_Resource addr,
                  struct PP_CompletionCallback callback);
  /**
   * Connects the socket to the given address. The socket must not be listening.
   * Binding the socket beforehand is optional.
   *
   * @param[in] tcp_socket A <code>PP_Resource</code> corresponding to a TCP
   * socket.
   * @param[in] addr A <code>PPB_NetAddress</code> resource.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>,
   * including (but not limited to):
   * - <code>PP_ERROR_NOACCESS</code>: the caller doesn't have required
   *   permissions.
   * - <code>PP_ERROR_ADDRESS_UNREACHABLE</code>: <code>addr</code> is
   *   unreachable.
   * - <code>PP_ERROR_CONNECTION_REFUSED</code>: the connection attempt was
   *   refused.
   * - <code>PP_ERROR_CONNECTION_FAILED</code>: the connection attempt failed.
   * - <code>PP_ERROR_CONNECTION_TIMEDOUT</code>: the connection attempt timed
   *   out.
   *
   * Since version 1.1, if the socket is listening/connected or has a pending
   * listen/connect request, <code>Connect()</code> will fail without starting a
   * connection attempt; otherwise, any failure during the connection attempt
   * will cause the socket to be closed.
   */
  int32_t (*Connect)(PP_Resource tcp_socket,
                     PP_Resource addr,
                     struct PP_CompletionCallback callback);
  /**
   * Gets the local address of the socket, if it is bound.
   *
   * @param[in] tcp_socket A <code>PP_Resource</code> corresponding to a TCP
   * socket.
   *
   * @return A <code>PPB_NetAddress</code> resource on success or 0 on failure.
   */
  PP_Resource (*GetLocalAddress)(PP_Resource tcp_socket);
  /**
   * Gets the remote address of the socket, if it is connected.
   *
   * @param[in] tcp_socket A <code>PP_Resource</code> corresponding to a TCP
   * socket.
   *
   * @return A <code>PPB_NetAddress</code> resource on success or 0 on failure.
   */
  PP_Resource (*GetRemoteAddress)(PP_Resource tcp_socket);
  /**
   * Reads data from the socket. The socket must be connected. It may perform a
   * partial read.
   *
   * @param[in] tcp_socket A <code>PP_Resource</code> corresponding to a TCP
   * socket.
   * @param[out] buffer The buffer to store the received data on success. It
   * must be at least as large as <code>bytes_to_read</code>.
   * @param[in] bytes_to_read The number of bytes to read.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion.
   *
   * @return A non-negative number on success to indicate how many bytes have
   * been read, 0 means that end-of-file was reached; otherwise, an error code
   * from <code>pp_errors.h</code>.
   */
  int32_t (*Read)(PP_Resource tcp_socket,
                  char* buffer,
                  int32_t bytes_to_read,
                  struct PP_CompletionCallback callback);
  /**
   * Writes data to the socket. The socket must be connected. It may perform a
   * partial write.
   *
   * @param[in] tcp_socket A <code>PP_Resource</code> corresponding to a TCP
   * socket.
   * @param[in] buffer The buffer containing the data to write.
   * @param[in] bytes_to_write The number of bytes to write.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion.
   *
   * @return A non-negative number on success to indicate how many bytes have
   * been written; otherwise, an error code from <code>pp_errors.h</code>.
   */
  int32_t (*Write)(PP_Resource tcp_socket,
                   const char* buffer,
                   int32_t bytes_to_write,
                   struct PP_CompletionCallback callback);
  /**
   * Starts listening. The socket must be bound and not connected.
   *
   * @param[in] tcp_socket A <code>PP_Resource</code> corresponding to a TCP
   * socket.
   * @param[in] backlog A hint to determine the maximum length to which the
   * queue of pending connections may grow.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>,
   * including (but not limited to):
   * - <code>PP_ERROR_NOACCESS</code>: the caller doesn't have required
   *   permissions.
   * - <code>PP_ERROR_ADDRESS_IN_USE</code>: Another socket is already listening
   *   on the same port.
   */
  int32_t (*Listen)(PP_Resource tcp_socket,
                    int32_t backlog,
                    struct PP_CompletionCallback callback);
  /**
   * Accepts a connection. The socket must be listening.
   *
   * @param[in] tcp_socket A <code>PP_Resource</code> corresponding to a TCP
   * socket.
   * @param[out] accepted_tcp_socket Stores the accepted TCP socket on success.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>,
   * including (but not limited to):
   * - <code>PP_ERROR_CONNECTION_ABORTED</code>: A connection has been aborted.
   */
  int32_t (*Accept)(PP_Resource tcp_socket,
                    PP_Resource* accepted_tcp_socket,
                    struct PP_CompletionCallback callback);
  /**
   * Cancels all pending operations and closes the socket. Any pending callbacks
   * will still run, reporting <code>PP_ERROR_ABORTED</code> if pending IO was
   * interrupted. After a call to this method, no output buffer pointers passed
   * into previous <code>Read()</code> or <code>Accept()</code> calls will be
   * accessed. It is not valid to call <code>Connect()</code> or
   * <code>Listen()</code> again.
   *
   * The socket is implicitly closed if it is destroyed, so you are not required
   * to call this method.
   *
   * @param[in] tcp_socket A <code>PP_Resource</code> corresponding to a TCP
   * socket.
   */
  void (*Close)(PP_Resource tcp_socket);
  /**
   * Sets a socket option on the TCP socket.
   * Please see the <code>PP_TCPSocket_Option</code> description for option
   * names, value types and allowed values.
   *
   * @param[in] tcp_socket A <code>PP_Resource</code> corresponding to a TCP
   * socket.
   * @param[in] name The option to set.
   * @param[in] value The option value to set.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   */
  int32_t (*SetOption)(PP_Resource tcp_socket,
                       PP_TCPSocket_Option name,
                       struct PP_Var value,
                       struct PP_CompletionCallback callback);
};

typedef struct PPB_TCPSocket_1_2 PPB_TCPSocket;

struct PPB_TCPSocket_1_0 {
  PP_Resource (*Create)(PP_Instance instance);
  PP_Bool (*IsTCPSocket)(PP_Resource resource);
  int32_t (*Connect)(PP_Resource tcp_socket,
                     PP_Resource addr,
                     struct PP_CompletionCallback callback);
  PP_Resource (*GetLocalAddress)(PP_Resource tcp_socket);
  PP_Resource (*GetRemoteAddress)(PP_Resource tcp_socket);
  int32_t (*Read)(PP_Resource tcp_socket,
                  char* buffer,
                  int32_t bytes_to_read,
                  struct PP_CompletionCallback callback);
  int32_t (*Write)(PP_Resource tcp_socket,
                   const char* buffer,
                   int32_t bytes_to_write,
                   struct PP_CompletionCallback callback);
  void (*Close)(PP_Resource tcp_socket);
  int32_t (*SetOption)(PP_Resource tcp_socket,
                       PP_TCPSocket_Option name,
                       struct PP_Var value,
                       struct PP_CompletionCallback callback);
};

struct PPB_TCPSocket_1_1 {
  PP_Resource (*Create)(PP_Instance instance);
  PP_Bool (*IsTCPSocket)(PP_Resource resource);
  int32_t (*Bind)(PP_Resource tcp_socket,
                  PP_Resource addr,
                  struct PP_CompletionCallback callback);
  int32_t (*Connect)(PP_Resource tcp_socket,
                     PP_Resource addr,
                     struct PP_CompletionCallback callback);
  PP_Resource (*GetLocalAddress)(PP_Resource tcp_socket);
  PP_Resource (*GetRemoteAddress)(PP_Resource tcp_socket);
  int32_t (*Read)(PP_Resource tcp_socket,
                  char* buffer,
                  int32_t bytes_to_read,
                  struct PP_CompletionCallback callback);
  int32_t (*Write)(PP_Resource tcp_socket,
                   const char* buffer,
                   int32_t bytes_to_write,
                   struct PP_CompletionCallback callback);
  int32_t (*Listen)(PP_Resource tcp_socket,
                    int32_t backlog,
                    struct PP_CompletionCallback callback);
  int32_t (*Accept)(PP_Resource tcp_socket,
                    PP_Resource* accepted_tcp_socket,
                    struct PP_CompletionCallback callback);
  void (*Close)(PP_Resource tcp_socket);
  int32_t (*SetOption)(PP_Resource tcp_socket,
                       PP_TCPSocket_Option name,
                       struct PP_Var value,
                       struct PP_CompletionCallback callback);
};
/**
 * @}
 */

/* ppb_text_input_controller.idl */
/**
 * @addtogroup Enums
 * @{
 */
/**
 * PP_TextInput_Type is used to indicate the status of a plugin in regard to
 * text input.
 */
typedef enum {
  /**
   * Input caret is not in an editable mode, no input method shall be used.
   */
  PP_TEXTINPUT_TYPE_NONE = 0,
  /**
   * Input caret is in a normal editable mode, any input method can be used.
   */
  PP_TEXTINPUT_TYPE_TEXT = 1,
  /**
   * Input caret is in a password box, an input method may be used only if
   * it's suitable for password input.
   */
  PP_TEXTINPUT_TYPE_PASSWORD = 2,
  PP_TEXTINPUT_TYPE_SEARCH = 3,
  PP_TEXTINPUT_TYPE_EMAIL = 4,
  PP_TEXTINPUT_TYPE_NUMBER = 5,
  PP_TEXTINPUT_TYPE_TELEPHONE = 6,
  PP_TEXTINPUT_TYPE_URL = 7
} PP_TextInput_Type;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_TextInput_Type, 4);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * <code>PPB_TextInputController</code> provides a set of functions for giving
 * hints to the browser about the text input status of plugins, and functions
 * for controlling input method editors (IMEs).
 */
struct PPB_TextInputController_1_0 {
  /**
   * Informs the browser about the current text input mode of the plugin.
   * Typical use of this information in the browser is to properly
   * display/suppress tools for supporting text inputs (such as virtual
   * keyboards in touch screen based devices, or input method editors often
   * used for composing East Asian characters).
   */
  void (*SetTextInputType)(PP_Instance instance, PP_TextInput_Type type);
  /**
   * Informs the browser about the coordinates of the text input caret area.
   * Typical use of this information in the browser is to layout IME windows
   * etc.
   */
  void (*UpdateCaretPosition)(PP_Instance instance,
                              const struct PP_Rect* caret);
  /**
   * Cancels the current composition in IME.
   */
  void (*CancelCompositionText)(PP_Instance instance);
  /**
   * Informs the browser about the current text selection and surrounding
   * text. <code>text</code> is a UTF-8 string that contains the current range
   * of text selection in the plugin. <code>caret</code> is the byte-index of
   * the caret position within <code>text</code>. <code>anchor</code> is the
   * byte-index of the anchor position (i.e., if a range of text is selected,
   * it is the other edge of selection different from <code>caret</code>. If
   * there are no selection, <code>anchor</code> is equal to <code>caret</code>.
   *
   * Typical use of this information in the browser is to enable "reconversion"
   * features of IME that puts back the already committed text into the
   * pre-commit composition state. Another use is to improve the precision
   * of suggestion of IME by taking the context into account (e.g., if the caret
   * looks to be on the beginning of a sentence, suggest capital letters in a
   * virtual keyboard).
   *
   * When the focus is not on text, call this function setting <code>text</code>
   * to an empty string and <code>caret</code> and <code>anchor</code> to zero.
   * Also, the plugin should send the empty text when it does not want to reveal
   * the selection to IME (e.g., when the surrounding text is containing
   * password text).
   */
  void (*UpdateSurroundingText)(PP_Instance instance,
                                struct PP_Var text,
                                uint32_t caret,
                                uint32_t anchor);
};

typedef struct PPB_TextInputController_1_0 PPB_TextInputController;
/**
 * @}
 */

/* ppb_udp_socket.idl */
/**
 * @addtogroup Enums
 * @{
 */
/**
 * Option names used by <code>SetOption()</code>.
 */
typedef enum {
  /**
   * Allows the socket to share the local address to which it will be bound with
   * other processes. Value's type should be <code>PP_VARTYPE_BOOL</code>.
   * This option can only be set before calling <code>Bind()</code>.
   */
  PP_UDPSOCKET_OPTION_ADDRESS_REUSE = 0,
  /**
   * Allows sending and receiving packets to and from broadcast addresses.
   * Value's type should be <code>PP_VARTYPE_BOOL</code>.
   * On version 1.0, this option can only be set before calling
   * <code>Bind()</code>. On version 1.1 or later, there is no such limitation.
   */
  PP_UDPSOCKET_OPTION_BROADCAST = 1,
  /**
   * Specifies the total per-socket buffer space reserved for sends. Value's
   * type should be <code>PP_VARTYPE_INT32</code>.
   * On version 1.0, this option can only be set after a successful
   * <code>Bind()</code> call. On version 1.1 or later, there is no such
   * limitation.
   *
   * Note: This is only treated as a hint for the browser to set the buffer
   * size. Even if <code>SetOption()</code> succeeds, the browser doesn't
   * guarantee it will conform to the size.
   */
  PP_UDPSOCKET_OPTION_SEND_BUFFER_SIZE = 2,
  /**
   * Specifies the total per-socket buffer space reserved for receives. Value's
   * type should be <code>PP_VARTYPE_INT32</code>.
   * On version 1.0, this option can only be set after a successful
   * <code>Bind()</code> call. On version 1.1 or later, there is no such
   * limitation.
   *
   * Note: This is only treated as a hint for the browser to set the buffer
   * size. Even if <code>SetOption()</code> succeeds, the browser doesn't
   * guarantee it will conform to the size.
   */
  PP_UDPSOCKET_OPTION_RECV_BUFFER_SIZE = 3,
  /**
   * Specifies whether the packets sent from the host to the multicast group
   * should be looped back to the host or not. Value's type should be
   * <code>PP_VARTYPE_BOOL</code>.
   * This option can only be set before calling <code>Bind()</code>.
   *
   * This is only supported in version 1.2 of the API (Chrome 43) and later.
   */
  PP_UDPSOCKET_OPTION_MULTICAST_LOOP = 4,
  /**
   * Specifies the time-to-live for packets sent to the multicast group. The
   * value should be within 0 to 255 range. The default value is 1 and means
   * that packets will not be routed beyond the local network. Value's type
   * should be <code>PP_VARTYPE_INT32</code>.
   * This option can only be set before calling <code>Bind()</code>.
   *
   * This is only supported in version 1.2 of the API (Chrome 43) and later.
   */
  PP_UDPSOCKET_OPTION_MULTICAST_TTL = 5
} PP_UDPSocket_Option;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_UDPSocket_Option, 4);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPB_UDPSocket</code> interface provides UDP socket operations.
 *
 * Permissions: Apps permission <code>socket</code> with subrule
 * <code>udp-bind</code> is required for <code>Bind()</code>; subrule
 * <code>udp-send-to</code> is required for <code>SendTo()</code>.
 * For more details about network communication permissions, please see:
 * http://developer.chrome.com/apps/app_network.html
 */
struct PPB_UDPSocket_1_2 {
  /**
   * Creates a UDP socket resource.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying one instance of
   * a module.
   *
   * @return A <code>PP_Resource</code> corresponding to a UDP socket or 0
   * on failure.
   */
  PP_Resource (*Create)(PP_Instance instance);
  /**
   * Determines if a given resource is a UDP socket.
   *
   * @param[in] resource A <code>PP_Resource</code> to check.
   *
   * @return <code>PP_TRUE</code> if the input is a <code>PPB_UDPSocket</code>
   * resource; <code>PP_FALSE</code> otherwise.
   */
  PP_Bool (*IsUDPSocket)(PP_Resource resource);
  /**
   * Binds the socket to the given address.
   *
   * @param[in] udp_socket A <code>PP_Resource</code> corresponding to a UDP
   * socket.
   * @param[in] addr A <code>PPB_NetAddress</code> resource.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   * <code>PP_ERROR_NOACCESS</code> will be returned if the caller doesn't have
   * required permissions. <code>PP_ERROR_ADDRESS_IN_USE</code> will be returned
   * if the address is already in use.
   */
  int32_t (*Bind)(PP_Resource udp_socket,
                  PP_Resource addr,
                  struct PP_CompletionCallback callback);
  /**
   * Gets the address that the socket is bound to. The socket must be bound.
   *
   * @param[in] udp_socket A <code>PP_Resource</code> corresponding to a UDP
   * socket.
   *
   * @return A <code>PPB_NetAddress</code> resource on success or 0 on failure.
   */
  PP_Resource (*GetBoundAddress)(PP_Resource udp_socket);
  /**
   * Receives data from the socket and stores the source address. The socket
   * must be bound.
   *
   * @param[in] udp_socket A <code>PP_Resource</code> corresponding to a UDP
   * socket.
   * @param[out] buffer The buffer to store the received data on success. It
   * must be at least as large as <code>num_bytes</code>.
   * @param[in] num_bytes The number of bytes to receive.
   * @param[out] addr A <code>PPB_NetAddress</code> resource to store the source
   * address on success.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion.
   *
   * @return A non-negative number on success to indicate how many bytes have
   * been received; otherwise, an error code from <code>pp_errors.h</code>.
   */
  int32_t (*RecvFrom)(PP_Resource udp_socket,
                      char* buffer,
                      int32_t num_bytes,
                      PP_Resource* addr,
                      struct PP_CompletionCallback callback);
  /**
   * Sends data to a specific destination. The socket must be bound.
   *
   * @param[in] udp_socket A <code>PP_Resource</code> corresponding to a UDP
   * socket.
   * @param[in] buffer The buffer containing the data to send.
   * @param[in] num_bytes The number of bytes to send.
   * @param[in] addr A <code>PPB_NetAddress</code> resource holding the
   * destination address.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion.
   *
   * @return A non-negative number on success to indicate how many bytes have
   * been sent; otherwise, an error code from <code>pp_errors.h</code>.
   * <code>PP_ERROR_NOACCESS</code> will be returned if the caller doesn't have
   * required permissions.
   * <code>PP_ERROR_INPROGRESS</code> will be returned if the socket is busy
   * sending. The caller should wait until a pending send completes before
   * retrying.
   */
  int32_t (*SendTo)(PP_Resource udp_socket,
                    const char* buffer,
                    int32_t num_bytes,
                    PP_Resource addr,
                    struct PP_CompletionCallback callback);
  /**
   * Cancels all pending reads and writes, and closes the socket. Any pending
   * callbacks will still run, reporting <code>PP_ERROR_ABORTED</code> if
   * pending IO was interrupted. After a call to this method, no output
   * parameters passed into previous <code>RecvFrom()</code> calls will be
   * accessed. It is not valid to call <code>Bind()</code> again.
   *
   * The socket is implicitly closed if it is destroyed, so you are not
   * required to call this method.
   *
   * @param[in] udp_socket A <code>PP_Resource</code> corresponding to a UDP
   * socket.
   */
  void (*Close)(PP_Resource udp_socket);
  /**
   * Sets a socket option on the UDP socket.
   * Please see the <code>PP_UDPSocket_Option</code> description for option
   * names, value types and allowed values.
   *
   * @param[in] udp_socket A <code>PP_Resource</code> corresponding to a UDP
   * socket.
   * @param[in] name The option to set.
   * @param[in] value The option value to set.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   */
  int32_t (*SetOption)(PP_Resource udp_socket,
                       PP_UDPSocket_Option name,
                       struct PP_Var value,
                       struct PP_CompletionCallback callback);
  /**
   * Joins the multicast group with address specified by <code>group</code>
   * parameter, which is expected to be a <code>PPB_NetAddress</code> object.
   *
   * @param[in] udp_socket A <code>PP_Resource</code> corresponding to a UDP
   * socket.
   * @param[in] group A <code>PP_Resource</code> corresponding to the network
   * address of the multicast group.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   */
  int32_t (*JoinGroup)(PP_Resource udp_socket,
                       PP_Resource group,
                       struct PP_CompletionCallback callback);
  /**
   * Leaves the multicast group with address specified by <code>group</code>
   * parameter, which is expected to be a <code>PPB_NetAddress</code> object.
   *
   * @param[in] udp_socket A <code>PP_Resource</code> corresponding to a UDP
   * socket.
   * @param[in] group A <code>PP_Resource</code> corresponding to the network
   * address of the multicast group.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   */
  int32_t (*LeaveGroup)(PP_Resource udp_socket,
                        PP_Resource group,
                        struct PP_CompletionCallback callback);
};

typedef struct PPB_UDPSocket_1_2 PPB_UDPSocket;

struct PPB_UDPSocket_1_0 {
  PP_Resource (*Create)(PP_Instance instance);
  PP_Bool (*IsUDPSocket)(PP_Resource resource);
  int32_t (*Bind)(PP_Resource udp_socket,
                  PP_Resource addr,
                  struct PP_CompletionCallback callback);
  PP_Resource (*GetBoundAddress)(PP_Resource udp_socket);
  int32_t (*RecvFrom)(PP_Resource udp_socket,
                      char* buffer,
                      int32_t num_bytes,
                      PP_Resource* addr,
                      struct PP_CompletionCallback callback);
  int32_t (*SendTo)(PP_Resource udp_socket,
                    const char* buffer,
                    int32_t num_bytes,
                    PP_Resource addr,
                    struct PP_CompletionCallback callback);
  void (*Close)(PP_Resource udp_socket);
  int32_t (*SetOption)(PP_Resource udp_socket,
                       PP_UDPSocket_Option name,
                       struct PP_Var value,
                       struct PP_CompletionCallback callback);
};

struct PPB_UDPSocket_1_1 {
  PP_Resource (*Create)(PP_Instance instance);
  PP_Bool (*IsUDPSocket)(PP_Resource resource);
  int32_t (*Bind)(PP_Resource udp_socket,
                  PP_Resource addr,
                  struct PP_CompletionCallback callback);
  PP_Resource (*GetBoundAddress)(PP_Resource udp_socket);
  int32_t (*RecvFrom)(PP_Resource udp_socket,
                      char* buffer,
                      int32_t num_bytes,
                      PP_Resource* addr,
                      struct PP_CompletionCallback callback);
  int32_t (*SendTo)(PP_Resource udp_socket,
                    const char* buffer,
                    int32_t num_bytes,
                    PP_Resource addr,
                    struct PP_CompletionCallback callback);
  void (*Close)(PP_Resource udp_socket);
  int32_t (*SetOption)(PP_Resource udp_socket,
                       PP_UDPSocket_Option name,
                       struct PP_Var value,
                       struct PP_CompletionCallback callback);
};
/**
 * @}
 */

/* ppb_url_loader.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <strong>PPB_URLLoader</strong> interface contains pointers to functions
 * for loading URLs. The typical steps for loading a URL are:
 *
 * -# Call Create() to create a URLLoader object.
 * -# Create a <code>URLRequestInfo</code> object and set properties on it.
 * Refer to <code>PPB_URLRequestInfo</code> for further information.
 * -# Call Open() with the <code>URLRequestInfo</code> as an argument.
 * -# When Open() completes, call GetResponseInfo() to examine the response
 * headers. Refer to <code>PPB_URLResponseInfo</code> for further information.
 * -# Call ReadResponseBody() to stream the data for the response.
 *
 * Alternatively, if <code>PP_URLREQUESTPROPERTY_STREAMTOFILE</code> was set on
 * the <code>URLRequestInfo</code> in step #2:
 * - Call FinishStreamingToFile(), after examining the response headers
 * (step #4),  to wait for the downloaded file to be complete.
 * - Then, access the downloaded file using the GetBodyAsFileRef() function of
 * the <code>URLResponseInfo</code> returned in step #4.
 */
struct PPB_URLLoader_1_0 {
  /**
   * Create() creates a new <code>URLLoader</code> object. The
   * <code>URLLoader</code> is associated with a particular instance, so that
   * any UI dialogs that need to be shown to the user can be positioned
   * relative to the window containing the instance.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying one instance
   * of a module.
   *
   * @return A <code>PP_Resource</code> corresponding to a URLLoader if
   * successful, 0 if the instance is invalid.
   */
  PP_Resource (*Create)(PP_Instance instance);
  /**
   * IsURLLoader() determines if a resource is an <code>URLLoader</code>.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to a
   * <code>URLLoader</code>.
   *
   * @return <code>PP_TRUE</code> if the resource is a <code>URLLoader</code>,
   * <code>PP_FALSE</code> if the resource is invalid or some type other
   * than <code>URLLoader</code>.
   */
  PP_Bool (*IsURLLoader)(PP_Resource resource);
  /**
   * Open() begins loading the <code>URLRequestInfo</code>. The operation
   * completes when response headers are received or when an error occurs.  Use
   * GetResponseInfo() to access the response headers.
   *
   * @param[in] loader A <code>PP_Resource</code> corresponding to a
   * <code>URLLoader</code>.
   * @param[in] resource A <code>PP_Resource</code> corresponding to a
   * <code>URLRequestInfo</code>.
   * @param[in] callback A <code>PP_CompletionCallback</code> to run on
   * asynchronous completion of Open(). This callback will run when response
   * headers for the url are received or error occurred. This callback
   * will only run if Open() returns <code>PP_OK_COMPLETIONPENDING</code>.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   */
  int32_t (*Open)(PP_Resource loader,
                  PP_Resource request_info,
                  struct PP_CompletionCallback callback);
  /**
   * FollowRedirect() can be invoked to follow a redirect after Open()
   * completed on receiving redirect headers.
   *
   * @param[in] loader A <code>PP_Resource</code> corresponding to a
   * <code>URLLoader</code>.
   * @param[in] callback A <code>PP_CompletionCallback</code> to run on
   * asynchronous completion of FollowRedirect(). This callback will run when
   * response headers for the redirect url are received or error occurred. This
   * callback will only run if FollowRedirect() returns
   * <code>PP_OK_COMPLETIONPENDING</code>.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   */
  int32_t (*FollowRedirect)(PP_Resource loader,
                            struct PP_CompletionCallback callback);
  /**
   * GetUploadProgress() returns the current upload progress (which is
   * meaningful after Open() has been called). Progress only refers to the
   * request body and does not include the headers.
   *
   * This data is only available if the <code>URLRequestInfo</code> passed
   * to Open() had the <code>PP_URLREQUESTPROPERTY_REPORTUPLOADPROGRESS</code>
   * property set to PP_TRUE.
   *
   * @param[in] loader A <code>PP_Resource</code> corresponding to a
   * <code>URLLoader</code>.
   * @param[in] bytes_sent The number of bytes sent thus far.
   * @param[in] total_bytes_to_be_sent The total number of bytes to be sent.
   *
   * @return <code>PP_TRUE</code> if the upload progress is available,
   * <code>PP_FALSE</code> if it is not available.
   */
  PP_Bool (*GetUploadProgress)(PP_Resource loader,
                               int64_t* bytes_sent,
                               int64_t* total_bytes_to_be_sent);
  /**
   * GetDownloadProgress() returns the current download progress, which is
   * meaningful after Open() has been called. Progress only refers to the
   * response body and does not include the headers.
   *
   * This data is only available if the <code>URLRequestInfo</code> passed to
   * Open() had the <code>PP_URLREQUESTPROPERTY_REPORTDOWNLOADPROGRESS</code>
   * property set to <code>PP_TRUE</code>.
   *
   * @param[in] loader A <code>PP_Resource</code> corresponding to a
   * <code>URLLoader</code>.
   * @param[in] bytes_received The number of bytes received thus far.
   * @param[in] total_bytes_to_be_received The total number of bytes to be
   * received. The total bytes to be received may be unknown, in which case
   * <code>total_bytes_to_be_received</code> will be set to -1.
   *
   * @return <code>PP_TRUE</code> if the download progress is available,
   * <code>PP_FALSE</code> if it is not available.
   */
  PP_Bool (*GetDownloadProgress)(PP_Resource loader,
                                 int64_t* bytes_received,
                                 int64_t* total_bytes_to_be_received);
  /**
   * GetResponseInfo() returns the current <code>URLResponseInfo</code> object.
   *
   * @param[in] instance A <code>PP_Resource</code> corresponding to a
   * <code>URLLoader</code>.
   *
   * @return A <code>PP_Resource</code> corresponding to the
   * <code>URLResponseInfo</code> if successful, 0 if the loader is not a valid
   * resource or if Open() has not been called.
   */
  PP_Resource (*GetResponseInfo)(PP_Resource loader);
  /**
   * ReadResponseBody() is used to read the response body. The size of the
   * buffer must be large enough to hold the specified number of bytes to read.
   * This function might perform a partial read.
   *
   * @param[in] loader A <code>PP_Resource</code> corresponding to a
   * <code>URLLoader</code>.
   * @param[in,out] buffer A pointer to the buffer for the response body.
   * @param[in] bytes_to_read The number of bytes to read.
   * @param[in] callback A <code>PP_CompletionCallback</code> to run on
   * asynchronous completion. The callback will run if the bytes (full or
   * partial) are read or an error occurs asynchronously. This callback will
   * run only if this function returns <code>PP_OK_COMPLETIONPENDING</code>.
   *
   * @return An int32_t containing the number of bytes read or an error code
   * from <code>pp_errors.h</code>.
   */
  int32_t (*ReadResponseBody)(PP_Resource loader,
                              void* buffer,
                              int32_t bytes_to_read,
                              struct PP_CompletionCallback callback);
  /**
   * FinishStreamingToFile() is used to wait for the response body to be
   * completely downloaded to the file provided by the GetBodyAsFileRef()
   * in the current <code>URLResponseInfo</code>. This function is only used if
   * <code>PP_URLREQUESTPROPERTY_STREAMTOFILE</code> was set on the
   * <code>URLRequestInfo</code> passed to Open().
   *
   * @param[in] loader A <code>PP_Resource</code> corresponding to a
   * <code>URLLoader</code>.
   * @param[in] callback A <code>PP_CompletionCallback</code> to run on
   * asynchronous completion. This callback will run when body is downloaded
   * or an error occurs after FinishStreamingToFile() returns
   * <code>PP_OK_COMPLETIONPENDING</code>.
   *
   * @return An int32_t containing the number of bytes read or an error code
   * from <code>pp_errors.h</code>.
   */
  int32_t (*FinishStreamingToFile)(PP_Resource loader,
                                   struct PP_CompletionCallback callback);
  /**
   * Close is a pointer to a function used to cancel any pending IO and close
   * the <code>URLLoader</code> object. Any pending callbacks will still run,
   * reporting <code>PP_ERROR_ABORTED</code> if pending IO was interrupted.
   * It is NOT valid to call Open() again after a call to this function.
   *
   * <strong>Note:</strong> If the <code>URLLoader</code> object is destroyed
   * while it is still open, then it will be implicitly closed so you are not
   * required to call Close().
   *
   * @param[in] loader A <code>PP_Resource</code> corresponding to a
   * <code>URLLoader</code>.
   */
  void (*Close)(PP_Resource loader);
};

typedef struct PPB_URLLoader_1_0 PPB_URLLoader;
/**
 * @}
 */

/* ppb_url_request_info.idl */
/**
 * @addtogroup Enums
 * @{
 */
/**
 * This enumeration contains properties that can be set on a URL request.
 */
typedef enum {
  /** This corresponds to a string (<code>PP_VARTYPE_STRING</code>). */
  PP_URLREQUESTPROPERTY_URL = 0,
  /**
   * This corresponds to a string (<code>PP_VARTYPE_STRING</code>); either
   * POST or GET. Refer to the
   * <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec5.html">HTTP
   * Methods</a> documentation for further information.
   *
   */
  PP_URLREQUESTPROPERTY_METHOD = 1,
  /**
   * This corresponds to a string (<code>PP_VARTYPE_STRING</code>); \n
   * delimited. Refer to the
   * <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html"Header
   * Field Definitions</a> documentation for further information.
   */
  PP_URLREQUESTPROPERTY_HEADERS = 2,
  /**
   * This corresponds to a <code>PP_Bool</code> (<code>PP_VARTYPE_BOOL</code>;
   * default=<code>PP_FALSE</code>).
   * Set this value to <code>PP_TRUE</code> if you want to download the data
   * to a file. Use PPB_URLLoader.FinishStreamingToFile() to complete the
   * download.
   */
  PP_URLREQUESTPROPERTY_STREAMTOFILE = 3,
  /**
   * This corresponds to a <code>PP_Bool</code> (<code>PP_VARTYPE_BOOL</code>;
   * default=<code>PP_TRUE</code>).
   * Set this value to <code>PP_FALSE</code> if you want to use
   * PPB_URLLoader.FollowRedirects() to follow the redirects only after
   * examining redirect headers.
   */
  PP_URLREQUESTPROPERTY_FOLLOWREDIRECTS = 4,
  /**
   * This corresponds to a <code>PP_Bool</code> (<code>PP_VARTYPE_BOOL</code>;
   * default=<code>PP_FALSE</code>).
   * Set this value to <code>PP_TRUE</code> if you want to be able to poll the
   * download progress using PPB_URLLoader.GetDownloadProgress().
   */
  PP_URLREQUESTPROPERTY_RECORDDOWNLOADPROGRESS = 5,
  /**
   * This corresponds to a <code>PP_Bool</code>
   * (default=<code>PP_FALSE</code>). Set this value to <code>PP_TRUE</code> if
   * you want to be able to poll the upload progress using
   * PPB_URLLoader.GetUploadProgress().
   */
  PP_URLREQUESTPROPERTY_RECORDUPLOADPROGRESS = 6,
  /**
   * This corresponds to a string (<code>PP_VARTYPE_STRING)</code> or may be
   * undefined (<code>PP_VARTYPE_UNDEFINED</code>; default).
   * Set it to a string to set a custom referrer (if empty, the referrer header
   * will be omitted), or to undefined to use the default referrer. Only loaders
   * with universal access (only available on trusted implementations) will
   * accept <code>URLRequestInfo</code> objects that try to set a custom
   * referrer; if given to a loader without universal access,
   * <code>PP_ERROR_NOACCESS</code> will result.
   */
  PP_URLREQUESTPROPERTY_CUSTOMREFERRERURL = 7,
  /**
   * This corresponds to a <code>PP_Bool</code> (<code>PP_VARTYPE_BOOL</code>;
   * default=<code>PP_FALSE</code>). Whether cross-origin requests are allowed.
   * Cross-origin requests are made using the CORS (Cross-Origin Resource
   * Sharing) algorithm to check whether the request should be allowed. For the
   * complete CORS algorithm, refer to
   * the <a href="http://www.w3.org/TR/access-control">Cross-Origin Resource
   * Sharing</a> documentation.
   */
  PP_URLREQUESTPROPERTY_ALLOWCROSSORIGINREQUESTS = 8,
  /**
   * This corresponds to a <code>PP_Bool</code> (<code>PP_VARTYPE_BOOL</code>;
   * default=<code>PP_FALSE</code>).
   * Whether HTTP credentials are sent with cross-origin requests. If false,
   * no credentials are sent with the request and cookies are ignored in the
   * response. If the request is not cross-origin, this property is ignored.
   */
  PP_URLREQUESTPROPERTY_ALLOWCREDENTIALS = 9,
  /**
   * This corresponds to a string (<code>PP_VARTYPE_STRING</code>) or may be
   * undefined (<code>PP_VARTYPE_UNDEFINED</code>; default).
   * Set it to a string to set a custom content-transfer-encoding header (if
   * empty, that header will be omitted), or to undefined to use the default
   * (if any). Only loaders with universal access (only available on trusted
   * implementations) will accept <code>URLRequestInfo</code> objects that try
   * to set a custom content transfer encoding; if given to a loader without
   * universal access, <code>PP_ERROR_NOACCESS</code> will result.
   */
  PP_URLREQUESTPROPERTY_CUSTOMCONTENTTRANSFERENCODING = 10,
  /**
   * This corresponds to an integer (<code>PP_VARTYPE_INT32</code>); default
   * is not defined and is set by the browser, possibly depending on system
   * capabilities. Set it to an integer to set an upper threshold for the
   * prefetched buffer of an asynchronous load. When exceeded, the browser will
   * defer loading until
   * <code>PP_URLREQUESTPROPERTY_PREFETCHBUFFERLOWERERTHRESHOLD</code> is hit,
   * at which time it will begin prefetching again. When setting this property,
   * <code>PP_URLREQUESTPROPERTY_PREFETCHBUFFERLOWERERTHRESHOLD</code> must also
   * be set. Behavior is undefined if the former is <= the latter.
   */
  PP_URLREQUESTPROPERTY_PREFETCHBUFFERUPPERTHRESHOLD = 11,
  /**
   * This corresponds to an integer (<code>PP_VARTYPE_INT32</code>); default is
   * not defined and is set by the browser to a value appropriate for the
   * default <code>PP_URLREQUESTPROPERTY_PREFETCHBUFFERUPPERTHRESHOLD</code>.
   * Set it to an integer to set a lower threshold for the prefetched buffer
   * of an asynchronous load. When reached, the browser will resume loading if
   * If <code>PP_URLREQUESTPROPERTY_PREFETCHBUFFERLOWERERTHRESHOLD</code> had
   * previously been reached.
   * When setting this property,
   * <code>PP_URLREQUESTPROPERTY_PREFETCHBUFFERUPPERTHRESHOLD</code> must also
   * be set. Behavior is undefined if the former is >= the latter.
   */
  PP_URLREQUESTPROPERTY_PREFETCHBUFFERLOWERTHRESHOLD = 12,
  /**
   * This corresponds to a string (<code>PP_VARTYPE_STRING</code>) or may be
   * undefined (<code>PP_VARTYPE_UNDEFINED</code>; default). Set it to a string
   * to set a custom user-agent header (if empty, that header will be omitted),
   * or to undefined to use the default. Only loaders with universal access
   * (only available on trusted implementations) will accept
   * <code>URLRequestInfo</code> objects that try to set a custom user agent; if
   * given to a loader without universal access, <code>PP_ERROR_NOACCESS</code>
   * will result.
   */
  PP_URLREQUESTPROPERTY_CUSTOMUSERAGENT = 13
} PP_URLRequestProperty;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_URLRequestProperty, 4);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPB_URLRequestInfo</code> interface is used to create
 * and handle URL requests. This API is used in conjunction with
 * <code>PPB_URLLoader</code>. Refer to <code>PPB_URLLoader</code> for further
 * information.
 */
struct PPB_URLRequestInfo_1_0 {
  /**
   * Create() creates a new <code>URLRequestInfo</code> object.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying one instance
   * of a module.
   *
   * @return A <code>PP_Resource</code> identifying the
   * <code>URLRequestInfo</code> if successful, 0 if the instance is invalid.
   */
  PP_Resource (*Create)(PP_Instance instance);
  /**
   * IsURLRequestInfo() determines if a resource is a
   * <code>URLRequestInfo</code>.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to a
   * <code>URLRequestInfo</code>.
   *
   * @return <code>PP_TRUE</code> if the resource is a
   * <code>URLRequestInfo</code>, <code>PP_FALSE</code> if the resource is
   * invalid or some type other than <code>URLRequestInfo</code>.
   */
  PP_Bool (*IsURLRequestInfo)(PP_Resource resource);
  /**
   * SetProperty() sets a request property. The value of the property must be
   * the correct type according to the property being set.
   *
   * @param[in] request A <code>PP_Resource</code> corresponding to a
   * <code>URLRequestInfo</code>.
   * @param[in] property A <code>PP_URLRequestProperty</code> identifying the
   * property to set.
   * @param[in] value A <code>PP_Var</code> containing the property value.
   *
   * @return <code>PP_TRUE</code> if successful, <code>PP_FALSE</code> if any
   * of the parameters are invalid.
   */
  PP_Bool (*SetProperty)(PP_Resource request,
                         PP_URLRequestProperty property,
                         struct PP_Var value);
  /**
   * AppendDataToBody() appends data to the request body. A Content-Length
   * request header will be automatically generated.
   *
   * @param[in] request A <code>PP_Resource</code> corresponding to a
   * <code>URLRequestInfo</code>.
   * @param[in] data A pointer to a buffer holding the data.
   * @param[in] len The length, in bytes, of the data.
   *
   * @return <code>PP_TRUE</code> if successful, <code>PP_FALSE</code> if any
   * of the parameters are invalid.
   *
   *
   */
  PP_Bool (*AppendDataToBody)(PP_Resource request,
                              const void* data,
                              uint32_t len);
  /**
   * AppendFileToBody() appends a file, to be uploaded, to the request body.
   * A content-length request header will be automatically generated.
   *
   * @param[in] request A <code>PP_Resource</code> corresponding to a
   * <code>URLRequestInfo</code>.
   * @param[in] file_ref A <code>PP_Resource</code> corresponding to a file
   * reference.
   * @param[in] start_offset An optional starting point offset within the
   * file.
   * @param[in] number_of_bytes An optional number of bytes of the file to
   * be included. If <code>number_of_bytes</code> is -1, then the sub-range
   * to upload extends to the end of the file.
   * @param[in] expected_last_modified_time An optional (non-zero) last
   * modified time stamp used to validate that the file was not modified since
   * the given time before it was uploaded. The upload will fail with an error
   * code of <code>PP_ERROR_FILECHANGED</code> if the file has been modified
   * since the given time. If <code>expected_last_modified_time</code> is 0,
   * then no validation is performed.
   *
   * @return <code>PP_TRUE</code> if successful, <code>PP_FALSE</code> if any
   * of the parameters are invalid.
   */
  PP_Bool (*AppendFileToBody)(PP_Resource request,
                              PP_Resource file_ref,
                              int64_t start_offset,
                              int64_t number_of_bytes,
                              PP_Time expected_last_modified_time);
};

typedef struct PPB_URLRequestInfo_1_0 PPB_URLRequestInfo;
/**
 * @}
 */

/* ppb_url_response_info.idl */
/**
 * @addtogroup Enums
 * @{
 */
/**
 * This enumeration contains properties set on a URL response.
 */
typedef enum {
  /**
   * This corresponds to a string (PP_VARTYPE_STRING); an absolute URL formed by
   * resolving the relative request URL with the absolute document URL. Refer
   * to the
   * <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec5.html#sec5.1.2">
   * HTTP Request URI</a> and
   * <a href="http://www.w3.org/TR/html4/struct/links.html#h-12.4.1">
   * HTML Resolving Relative URIs</a> documentation for further information.
   */
  PP_URLRESPONSEPROPERTY_URL = 0,
  /**
   * This corresponds to a string (PP_VARTYPE_STRING); the absolute URL returned
   * in the response header's 'Location' field if this is a redirect response,
   * an empty string otherwise. Refer to the
   * <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.3">
   * HTTP Status Codes - Redirection</a> documentation for further information.
   */
  PP_URLRESPONSEPROPERTY_REDIRECTURL = 1,
  /**
   * This corresponds to a string (PP_VARTYPE_STRING); the HTTP method to be
   * used in a new request if this is a redirect response, an empty string
   * otherwise. Refer to the
   * <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.3">
   * HTTP Status Codes - Redirection</a> documentation for further information.
   */
  PP_URLRESPONSEPROPERTY_REDIRECTMETHOD = 2,
  /**
   * This corresponds to an int32 (PP_VARETYPE_INT32); the status code from the
   * response, e.g., 200 if the request was successful. Refer to the
   * <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec6.html#sec6.1.1">
   * HTTP Status Code and Reason Phrase</a> documentation for further
   * information.
   */
  PP_URLRESPONSEPROPERTY_STATUSCODE = 3,
  /**
   * This corresponds to a string (PP_VARTYPE_STRING); the status line
   * from the response. Refer to the
   * <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec6.html#sec6.1">
   * HTTP Response Status Line</a> documentation for further information.
   */
  PP_URLRESPONSEPROPERTY_STATUSLINE = 4,
  /**
   * This corresponds to a string(PP_VARTYPE_STRING), a \n-delimited list of
   * header field/value pairs of the form "field: value", returned by the
   * server. Refer to the
   * <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14">
   * HTTP Header Field Definitions</a> documentation for further information.
   */
  PP_URLRESPONSEPROPERTY_HEADERS = 5
} PP_URLResponseProperty;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_URLResponseProperty, 4);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The PPB_URLResponseInfo interface contains APIs for
 * examining URL responses. Refer to <code>PPB_URLLoader</code> for further
 * information.
 */
struct PPB_URLResponseInfo_1_0 {
  /**
   * IsURLResponseInfo() determines if a response is a
   * <code>URLResponseInfo</code>.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to a
   * <code>URLResponseInfo</code>.
   *
   * @return <code>PP_TRUE</code> if the resource is a
   * <code>URLResponseInfo</code>, <code>PP_FALSE</code> if the resource is
   * invalid or some type other than <code>URLResponseInfo</code>.
   */
  PP_Bool (*IsURLResponseInfo)(PP_Resource resource);
  /**
   * GetProperty() gets a response property.
   *
   * @param[in] request A <code>PP_Resource</code> corresponding to a
   * <code>URLResponseInfo</code>.
   * @param[in] property A <code>PP_URLResponseProperty</code> identifying
   * the type of property in the response.
   *
   * @return A <code>PP_Var</code> containing the response property value if
   * successful, <code>PP_VARTYPE_VOID</code> if an input parameter is invalid.
   */
  struct PP_Var (*GetProperty)(PP_Resource response,
                               PP_URLResponseProperty property);
  /**
   * GetBodyAsFileRef() returns a FileRef pointing to the file containing the
   * response body.  This is only valid if
   * <code>PP_URLREQUESTPROPERTY_STREAMTOFILE</code> was set on the
   * <code>URLRequestInfo</code> used to produce this response.  This file
   * remains valid until the <code>URLLoader</code> associated with this
   * <code>URLResponseInfo</code> is closed or destroyed.
   *
   * @param[in] request A <code>PP_Resource</code> corresponding to a
   * <code>URLResponseInfo</code>.
   *
   * @return A <code>PP_Resource</code> corresponding to a <code>FileRef</code>
   * if successful, 0 if <code>PP_URLREQUESTPROPERTY_STREAMTOFILE</code> was
   * not requested or if the <code>URLLoader</code> has not been opened yet.
   */
  PP_Resource (*GetBodyAsFileRef)(PP_Resource response);
};

typedef struct PPB_URLResponseInfo_1_0 PPB_URLResponseInfo;
/**
 * @}
 */

/* ppb_var.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * PPB_Var API
 */
struct PPB_Var_1_2 {
  /**
   * AddRef() adds a reference to the given var. If this is not a refcounted
   * object, this function will do nothing so you can always call it no matter
   * what the type.
   *
   * @param[in] var A <code>PP_Var</code> that will have a reference added.
   */
  void (*AddRef)(struct PP_Var var);
  /**
   * Release() removes a reference to given var, deleting it if the internal
   * reference count becomes 0. If the <code>PP_Var</code> is of type
   * <code>PP_VARTYPE_RESOURCE</code>,
   * it will implicitly release a reference count on the
   * <code>PP_Resource</code> (equivalent to PPB_Core::ReleaseResource()).
   *
   * If the given var is not a refcounted object, this function will do nothing
   * so you can always call it no matter what the type.
   *
   * @param[in] var A <code>PP_Var</code> that will have a reference removed.
   */
  void (*Release)(struct PP_Var var);
  /**
   * VarFromUtf8() creates a string var from a string. The string must be
   * encoded in valid UTF-8 and is NOT NULL-terminated, the length must be
   * specified in <code>len</code>. It is an error if the string is not
   * valid UTF-8.
   *
   * If the length is 0, the <code>*data</code> pointer will not be dereferenced
   * and may be <code>NULL</code>. Note, however if length is 0, the
   * "NULL-ness" will not be preserved, as VarToUtf8() will never return
   * <code>NULL</code> on success, even for empty strings.
   *
   * The resulting object will be a refcounted string object. It will be
   * AddRef'ed for the caller. When the caller is done with it, it should be
   * Released.
   *
   * On error (basically out of memory to allocate the string, or input that
   * is not valid UTF-8), this function will return a Null var.
   *
   * @param[in] data A string
   * @param[in] len The length of the string.
   *
   * @return A <code>PP_Var</code> structure containing a reference counted
   * string object.
   */
  struct PP_Var (*VarFromUtf8)(const char* data, uint32_t len);
  /**
   * VarToUtf8() converts a string-type var to a char* encoded in UTF-8. This
   * string is NOT NULL-terminated. The length will be placed in
   * <code>*len</code>. If the string is valid but empty the return value will
   * be non-NULL, but <code>*len</code> will still be 0.
   *
   * If the var is not a string, this function will return NULL and
   * <code>*len</code> will be 0.
   *
   * The returned buffer will be valid as long as the underlying var is alive.
   * If the instance frees its reference, the string will be freed and the
   * pointer will be to arbitrary memory.
   *
   * @param[in] var A PP_Var struct containing a string-type var.
   * @param[in,out] len A pointer to the length of the string-type var.
   *
   * @return A char* encoded in UTF-8.
   */
  const char* (*VarToUtf8)(struct PP_Var var, uint32_t* len);
  /**
   * Converts a resource-type var to a <code>PP_Resource</code>.
   *
   * @param[in] var A <code>PP_Var</code> struct containing a resource-type var.
   *
   * @return A <code>PP_Resource</code> retrieved from the var, or 0 if the var
   * is not a resource. The reference count of the resource is incremented on
   * behalf of the caller.
   */
  PP_Resource (*VarToResource)(struct PP_Var var);
  /**
   * Creates a new <code>PP_Var</code> from a given resource. Implicitly adds a
   * reference count on the <code>PP_Resource</code> (equivalent to
   * PPB_Core::AddRefResource(resource)).
   *
   * @param[in] resource A <code>PP_Resource</code> to be wrapped in a var.
   *
   * @return A <code>PP_Var</code> created for this resource, with type
   * <code>PP_VARTYPE_RESOURCE</code>. The reference count of the var is set to
   * 1 on behalf of the caller.
   */
  struct PP_Var (*VarFromResource)(PP_Resource resource);
};

typedef struct PPB_Var_1_2 PPB_Var;

struct PPB_Var_1_0 {
  void (*AddRef)(struct PP_Var var);
  void (*Release)(struct PP_Var var);
  struct PP_Var (*VarFromUtf8)(PP_Module module,
                               const char* data,
                               uint32_t len);
  const char* (*VarToUtf8)(struct PP_Var var, uint32_t* len);
};

struct PPB_Var_1_1 {
  void (*AddRef)(struct PP_Var var);
  void (*Release)(struct PP_Var var);
  struct PP_Var (*VarFromUtf8)(const char* data, uint32_t len);
  const char* (*VarToUtf8)(struct PP_Var var, uint32_t* len);
};
/**
 * @}
 */

/* ppb_var_array.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
struct PPB_VarArray_1_0 {
  /**
   * Creates an array var, i.e., a <code>PP_Var</code> with type set to
   * <code>PP_VARTYPE_ARRAY</code>. The array length is set to 0.
   *
   * @return An empty array var, whose reference count is set to 1 on behalf of
   * the caller.
   */
  struct PP_Var (*Create)(void);
  /**
   * Gets an element from the array.
   *
   * @param[in] array An array var.
   * @param[in] index An index indicating which element to return.
   *
   * @return The element at the specified position. The reference count of the
   * element returned is incremented on behalf of the caller. If
   * <code>index</code> is larger than or equal to the array length, an
   * undefined var is returned.
   */
  struct PP_Var (*Get)(struct PP_Var array, uint32_t index);
  /**
   * Sets the value of an element in the array.
   *
   * @param[in] array An array var.
   * @param[in] index An index indicating which element to modify. If
   * <code>index</code> is larger than or equal to the array length, the length
   * is updated to be <code>index</code> + 1. Any position in the array that
   * hasn't been set before is set to undefined, i.e., <code>PP_Var</code> of
   * type <code>PP_VARTYPE_UNDEFINED</code>.
   * @param[in] value The value to set. The array holds a reference to it on
   * success.
   *
   * @return A <code>PP_Bool</code> indicating whether the operation succeeds.
   */
  PP_Bool (*Set)(struct PP_Var array, uint32_t index, struct PP_Var value);
  /**
   * Gets the array length.
   *
   * @param[in] array An array var.
   *
   * @return The array length.
   */
  uint32_t (*GetLength)(struct PP_Var array);
  /**
   * Sets the array length.
   *
   * @param[in] array An array var.
   * @param[in] length The new array length. If <code>length</code> is smaller
   * than its current value, the array is truncated to the new length; any
   * elements that no longer fit are removed and the references to them will be
   * released. If <code>length</code> is larger than its current value,
   * undefined vars are appended to increase the array to the specified length.
   *
   * @return A <code>PP_Bool</code> indicating whether the operation succeeds.
   */
  PP_Bool (*SetLength)(struct PP_Var array, uint32_t length);
};

typedef struct PPB_VarArray_1_0 PPB_VarArray;
/**
 * @}
 */

/* ppb_var_array_buffer.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPB_VarArrayBuffer</code> interface provides a way to interact
 * with JavaScript ArrayBuffers, which represent a contiguous sequence of
 * bytes. Use <code>PPB_Var</code> to manage the reference count for a
 * <code>VarArrayBuffer</code>. Note that these Vars are not part of the
 * embedding page's DOM, and can only be shared with JavaScript using the
 * <code>PostMessage</code> and <code>HandleMessage</code> functions of
 * <code>pp::Instance</code>.
 */
struct PPB_VarArrayBuffer_1_0 {
  /**
   * Create() creates a zero-initialized <code>VarArrayBuffer</code>.
   *
   * @param[in] size_in_bytes The size of the <code>ArrayBuffer</code> to
   * be created.
   *
   * @return A <code>PP_Var</code> representing a <code>VarArrayBuffer</code>
   * of the requested size and with a reference count of 1.
   */
  struct PP_Var (*Create)(uint32_t size_in_bytes);
  /**
   * ByteLength() retrieves the length of the <code>VarArrayBuffer</code> in
   * bytes. On success, <code>byte_length</code> is set to the length of the
   * given <code>ArrayBuffer</code> var. On failure, <code>byte_length</code>
   * is unchanged (this could happen, for instance, if the given
   * <code>PP_Var</code> is not of type <code>PP_VARTYPE_ARRAY_BUFFER</code>).
   * Note that ByteLength() will successfully retrieve the size of an
   * <code>ArrayBuffer</code> even if the <code>ArrayBuffer</code> is not
   * currently mapped.
   *
   * @param[in] array The <code>ArrayBuffer</code> whose length should be
   * returned.
   *
   * @param[out] byte_length A variable which is set to the length of the given
   * <code>ArrayBuffer</code> on success.
   *
   * @return <code>PP_TRUE</code> on success, <code>PP_FALSE</code> on failure.
   */
  PP_Bool (*ByteLength)(struct PP_Var array, uint32_t* byte_length);
  /**
   * Map() maps the <code>ArrayBuffer</code> in to the module's address space
   * and returns a pointer to the beginning of the buffer for the given
   * <code>ArrayBuffer PP_Var</code>. ArrayBuffers are copied when transmitted,
   * so changes to the underlying memory are not automatically available to
   * the embedding page.
   *
   * Note that calling Map() can be a relatively expensive operation. Use care
   * when calling it in performance-critical code. For example, you should call
   * it only once when looping over an <code>ArrayBuffer</code>.
   *
   * <strong>Example:</strong>
   *
   * @code
   * char* data = (char*)(array_buffer_if.Map(array_buffer_var));
   * uint32_t byte_length = 0;
   * PP_Bool ok = array_buffer_if.ByteLength(array_buffer_var, &byte_length);
   * if (!ok)
   *   return DoSomethingBecauseMyVarIsNotAnArrayBuffer();
   * for (uint32_t i = 0; i < byte_length; ++i)
   *   data[i] = 'A';
   * @endcode
   *
   * @param[in] array The <code>ArrayBuffer</code> whose internal buffer should
   * be returned.
   *
   * @return A pointer to the internal buffer for this
   * <code>ArrayBuffer</code>. Returns <code>NULL</code>
   * if the given <code>PP_Var</code> is not of type
   * <code>PP_VARTYPE_ARRAY_BUFFER</code>.
   */
  void* (*Map)(struct PP_Var array);
  /**
   * Unmap() unmaps the given <code>ArrayBuffer</code> var from the module
   * address space. Use this if you want to save memory but might want to call
   * Map() to map the buffer again later. The <code>PP_Var</code> remains valid
   * and should still be released using <code>PPB_Var</code> when you are done
   * with the <code>ArrayBuffer</code>.
   *
   * @param[in] array The <code>ArrayBuffer</code> to be released.
   */
  void (*Unmap)(struct PP_Var array);
};

typedef struct PPB_VarArrayBuffer_1_0 PPB_VarArrayBuffer;
/**
 * @}
 */

/* ppb_var_dictionary.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * A dictionary var contains key-value pairs with unique keys. The keys are
 * strings while the values can be arbitrary vars. Key comparison is always
 * done by value instead of by reference.
 */
struct PPB_VarDictionary_1_0 {
  /**
   * Creates a dictionary var, i.e., a <code>PP_Var</code> with type set to
   * <code>PP_VARTYPE_DICTIONARY</code>.
   *
   * @return An empty dictionary var, whose reference count is set to 1 on
   * behalf of the caller.
   */
  struct PP_Var (*Create)(void);
  /**
   * Gets the value associated with the specified key.
   *
   * @param[in] dict A dictionary var.
   * @param[in] key A string var.
   *
   * @return The value that is associated with <code>key</code>. The reference
   * count of the element returned is incremented on behalf of the caller. If
   * <code>key</code> is not a string var, or it doesn't exist in
   * <code>dict</code>, an undefined var is returned.
   */
  struct PP_Var (*Get)(struct PP_Var dict, struct PP_Var key);
  /**
   * Sets the value associated with the specified key.
   *
   * @param[in] dict A dictionary var.
   * @param[in] key A string var. If this key hasn't existed in
   * <code>dict</code>, it is added and associated with <code>value</code>;
   * otherwise, the previous value is replaced with <code>value</code>.
   * @param[in] value The value to set. The dictionary holds a reference to it
   * on success.
   *
   * @return A <code>PP_Bool</code> indicating whether the operation succeeds.
   */
  PP_Bool (*Set)(struct PP_Var dict, struct PP_Var key, struct PP_Var value);
  /**
   * Deletes the specified key and its associated value, if the key exists. The
   * reference to the element will be released.
   *
   * @param[in] dict A dictionary var.
   * @param[in] key A string var.
   */
  void (*Delete)(struct PP_Var dict, struct PP_Var key);
  /**
   * Checks whether a key exists.
   *
   * @param[in] dict A dictionary var.
   * @param[in] key A string var.
   *
   * @return A <code>PP_Bool</code> indicating whether the key exists.
   */
  PP_Bool (*HasKey)(struct PP_Var dict, struct PP_Var key);
  /**
   * Gets all the keys in a dictionary. Please note that for each key that you
   * set into the dictionary, a string var with the same contents is returned;
   * but it may not be the same string var (i.e., <code>value.as_id</code> may
   * be different).
   *
   * @param[in] dict A dictionary var.
   *
   * @return An array var which contains all the keys of <code>dict</code>. Its
   * reference count is incremented on behalf of the caller. The elements are
   * string vars. Returns a null var if failed.
   */
  struct PP_Var (*GetKeys)(struct PP_Var dict);
};

typedef struct PPB_VarDictionary_1_0 PPB_VarDictionary;
/**
 * @}
 */

/* ppb_video_decoder.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * Video decoder interface.
 *
 * Typical usage:
 * - Call Create() to create a new video decoder resource.
 * - Call Initialize() to initialize it with a 3d graphics context and the
 *   desired codec profile.
 * - Call Decode() continuously (waiting for each previous call to complete) to
 *   push bitstream buffers to the decoder.
 * - Call GetPicture() continuously (waiting for each previous call to complete)
 *   to pull decoded pictures from the decoder.
 * - Call Flush() to signal end of stream to the decoder and perform shutdown
 *   when it completes.
 * - Call Reset() to quickly stop the decoder (e.g. to implement Seek) and wait
 *   for the callback before restarting decoding at another point.
 * - To destroy the decoder, the plugin should release all of its references to
 *   it. Any pending callbacks will abort before the decoder is destroyed.
 *
 * Available video codecs vary by platform.
 * All: theora, vorbis, vp8.
 * Chrome and ChromeOS: aac, h264.
 * ChromeOS: mpeg4.
 */
struct PPB_VideoDecoder_1_1 {
  /**
   * Creates a new video decoder resource.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying the instance
   * with the video decoder.
   *
   * @return A <code>PP_Resource</code> corresponding to a video decoder if
   * successful or 0 otherwise.
   */
  PP_Resource (*Create)(PP_Instance instance);
  /**
   * Determines if the given resource is a video decoder.
   *
   * @param[in] resource A <code>PP_Resource</code> identifying a resource.
   *
   * @return <code>PP_TRUE</code> if the resource is a
   * <code>PPB_VideoDecoder</code>, <code>PP_FALSE</code> if the resource is
   * invalid or some other type.
   */
  PP_Bool (*IsVideoDecoder)(PP_Resource resource);
  /**
   * Initializes a video decoder resource. This should be called after Create()
   * and before any other functions.
   *
   * @param[in] video_decoder A <code>PP_Resource</code> identifying the video
   * decoder.
   * @param[in] graphics3d_context A <code>PPB_Graphics3D</code> resource to use
   * during decoding.
   * @param[in] profile A <code>PP_VideoProfile</code> specifying the video
   * codec profile.
   * @param[in] acceleration A <code>PP_HardwareAcceleration</code> specifying
   * whether to use a hardware accelerated or a software implementation.
   * @param[in] min_picture_count A count of pictures the plugin would like to
   * have in flight. This is effectively the number of times the plugin can
   * call GetPicture() and get a decoded frame without calling
   * RecyclePicture(). The decoder has its own internal minimum count, and will
   * take the larger of its internal and this value. A client that doesn't care
   * can therefore just pass in zero for this argument.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   * Returns PP_ERROR_NOTSUPPORTED if video decoding is not available, or the
   * requested profile is not supported. In this case, the client may call
   * Initialize() again with different parameters to find a good configuration.
   * Returns PP_ERROR_BADARGUMENT if the requested minimum picture count is
   * unreasonably large.
   */
  int32_t (*Initialize)(PP_Resource video_decoder,
                        PP_Resource graphics3d_context,
                        PP_VideoProfile profile,
                        PP_HardwareAcceleration acceleration,
                        uint32_t min_picture_count,
                        struct PP_CompletionCallback callback);
  /**
   * Decodes a bitstream buffer. Copies |size| bytes of data from the plugin's
   * |buffer|. The plugin should wait until the decoder signals completion by
   * returning PP_OK or by running |callback| before calling Decode() again.
   *
   * In general, each bitstream buffer should contain a demuxed bitstream frame
   * for the selected video codec. For example, H264 decoders expect to receive
   * one AnnexB NAL unit, including the 4 byte start code prefix, while VP8
   * decoders expect to receive a bitstream frame without the IVF frame header.
   *
   * If the call to Decode() eventually results in a picture, the |decode_id|
   * parameter is copied into the returned picture. The plugin can use this to
   * associate decoded pictures with Decode() calls (e.g. to assign timestamps
   * or frame numbers to pictures.) This value is opaque to the API so the
   * plugin is free to pass any value.
   *
   * @param[in] video_decoder A <code>PP_Resource</code> identifying the video
   * decoder.
   * @param[in] decode_id An optional value, chosen by the plugin, that can be
   * used to associate calls to Decode() with decoded pictures returned by
   * GetPicture().
   * @param[in] size Buffer size in bytes.
   * @param[in] buffer Starting address of buffer.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called on
   * completion.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   * Returns PP_ERROR_FAILED if the decoder isn't initialized or if a Flush()
   * or Reset() call is pending.
   * Returns PP_ERROR_INPROGRESS if there is another Decode() call pending.
   * Returns PP_ERROR_NOMEMORY if a bitstream buffer can't be created.
   * Returns PP_ERROR_ABORTED when Reset() is called while Decode() is pending.
   */
  int32_t (*Decode)(PP_Resource video_decoder,
                    uint32_t decode_id,
                    uint32_t size,
                    const void* buffer,
                    struct PP_CompletionCallback callback);
  /**
   * Gets the next picture from the decoder. The picture is valid after the
   * decoder signals completion by returning PP_OK or running |callback|. The
   * plugin can call GetPicture() again after the decoder signals completion.
   * When the plugin is finished using the picture, it should return it to the
   * system by calling RecyclePicture().
   *
   * @param[in] video_decoder A <code>PP_Resource</code> identifying the video
   * decoder.
   * @param[out] picture A <code>PP_VideoPicture</code> to hold the decoded
   * picture.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called on
   * completion.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   * Returns PP_ERROR_FAILED if the decoder isn't initialized or if a Reset()
   * call is pending.
   * Returns PP_ERROR_INPROGRESS if there is another GetPicture() call pending.
   * Returns PP_ERROR_ABORTED when Reset() is called, or if a call to Flush()
   * completes while GetPicture() is pending.
   */
  int32_t (*GetPicture)(PP_Resource video_decoder,
                        struct PP_VideoPicture* picture,
                        struct PP_CompletionCallback callback);
  /**
   * Recycles a picture that the plugin has received from the decoder.
   * The plugin should call this as soon as it has finished using the texture so
   * the decoder can decode more pictures.
   *
   * @param[in] video_decoder A <code>PP_Resource</code> identifying the video
   * decoder.
   * @param[in] picture A <code>PP_VideoPicture</code> to return to
   * the decoder.
   */
  void (*RecyclePicture)(PP_Resource video_decoder,
                         const struct PP_VideoPicture* picture);
  /**
   * Flushes the decoder. The plugin should call Flush() when it reaches the
   * end of its video stream in order to stop cleanly. The decoder will run any
   * pending Decode() call to completion. The plugin should make no further
   * calls to the decoder other than GetPicture() and RecyclePicture() until
   * the decoder signals completion by running |callback|. Just before
   * completion, any pending GetPicture() call will complete by running its
   * callback with result PP_ERROR_ABORTED to signal that no more pictures are
   * available. Any pictures held by the plugin remain valid during and after
   * the flush and should be recycled back to the decoder.
   *
   * @param[in] video_decoder A <code>PP_Resource</code> identifying the video
   * decoder.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called on
   * completion.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   * Returns PP_ERROR_FAILED if the decoder isn't initialized.
   */
  int32_t (*Flush)(PP_Resource video_decoder,
                   struct PP_CompletionCallback callback);
  /**
   * Resets the decoder as quickly as possible. The plugin can call Reset() to
   * skip to another position in the video stream. After Reset() returns, any
   * pending calls to Decode() and GetPicture()) abort, causing their callbacks
   * to run with PP_ERROR_ABORTED. The plugin should not make further calls to
   * the decoder other than RecyclePicture() until the decoder signals
   * completion by running |callback|. Any pictures held by the plugin remain
   * valid during and after the reset and should be recycled back to the
   * decoder.
   *
   * @param[in] video_decoder A <code>PP_Resource</code> identifying the video
   * decoder.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called on
   * completion.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   * Returns PP_ERROR_FAILED if the decoder isn't initialized.
   */
  int32_t (*Reset)(PP_Resource video_decoder,
                   struct PP_CompletionCallback callback);
};

typedef struct PPB_VideoDecoder_1_1 PPB_VideoDecoder;

struct PPB_VideoDecoder_0_1 {
  PP_Resource (*Create)(PP_Instance instance);
  PP_Bool (*IsVideoDecoder)(PP_Resource resource);
  int32_t (*Initialize)(PP_Resource video_decoder,
                        PP_Resource graphics3d_context,
                        PP_VideoProfile profile,
                        PP_Bool allow_software_fallback,
                        struct PP_CompletionCallback callback);
  int32_t (*Decode)(PP_Resource video_decoder,
                    uint32_t decode_id,
                    uint32_t size,
                    const void* buffer,
                    struct PP_CompletionCallback callback);
  int32_t (*GetPicture)(PP_Resource video_decoder,
                        struct PP_VideoPicture_0_1* picture,
                        struct PP_CompletionCallback callback);
  void (*RecyclePicture)(PP_Resource video_decoder,
                         const struct PP_VideoPicture* picture);
  int32_t (*Flush)(PP_Resource video_decoder,
                   struct PP_CompletionCallback callback);
  int32_t (*Reset)(PP_Resource video_decoder,
                   struct PP_CompletionCallback callback);
};

struct PPB_VideoDecoder_0_2 {
  PP_Resource (*Create)(PP_Instance instance);
  PP_Bool (*IsVideoDecoder)(PP_Resource resource);
  int32_t (*Initialize)(PP_Resource video_decoder,
                        PP_Resource graphics3d_context,
                        PP_VideoProfile profile,
                        PP_HardwareAcceleration acceleration,
                        struct PP_CompletionCallback callback);
  int32_t (*Decode)(PP_Resource video_decoder,
                    uint32_t decode_id,
                    uint32_t size,
                    const void* buffer,
                    struct PP_CompletionCallback callback);
  int32_t (*GetPicture)(PP_Resource video_decoder,
                        struct PP_VideoPicture_0_1* picture,
                        struct PP_CompletionCallback callback);
  void (*RecyclePicture)(PP_Resource video_decoder,
                         const struct PP_VideoPicture* picture);
  int32_t (*Flush)(PP_Resource video_decoder,
                   struct PP_CompletionCallback callback);
  int32_t (*Reset)(PP_Resource video_decoder,
                   struct PP_CompletionCallback callback);
};

struct PPB_VideoDecoder_1_0 {
  PP_Resource (*Create)(PP_Instance instance);
  PP_Bool (*IsVideoDecoder)(PP_Resource resource);
  int32_t (*Initialize)(PP_Resource video_decoder,
                        PP_Resource graphics3d_context,
                        PP_VideoProfile profile,
                        PP_HardwareAcceleration acceleration,
                        struct PP_CompletionCallback callback);
  int32_t (*Decode)(PP_Resource video_decoder,
                    uint32_t decode_id,
                    uint32_t size,
                    const void* buffer,
                    struct PP_CompletionCallback callback);
  int32_t (*GetPicture)(PP_Resource video_decoder,
                        struct PP_VideoPicture* picture,
                        struct PP_CompletionCallback callback);
  void (*RecyclePicture)(PP_Resource video_decoder,
                         const struct PP_VideoPicture* picture);
  int32_t (*Flush)(PP_Resource video_decoder,
                   struct PP_CompletionCallback callback);
  int32_t (*Reset)(PP_Resource video_decoder,
                   struct PP_CompletionCallback callback);
};
/**
 * @}
 */

/* ppb_video_frame.idl */
/**
 * @addtogroup Enums
 * @{
 */
typedef enum {
  /**
   * Unknown format value.
   */
  PP_VIDEOFRAME_FORMAT_UNKNOWN = 0,
  /**
   * 12bpp YVU planar 1x1 Y, 2x2 VU samples.
   */
  PP_VIDEOFRAME_FORMAT_YV12 = 1,
  /**
   * 12bpp YUV planar 1x1 Y, 2x2 UV samples.
   */
  PP_VIDEOFRAME_FORMAT_I420 = 2,
  /**
   * 32bpp BGRA.
   */
  PP_VIDEOFRAME_FORMAT_BGRA = 3,
  /**
   * The last format.
   */
  PP_VIDEOFRAME_FORMAT_LAST = PP_VIDEOFRAME_FORMAT_BGRA
} PP_VideoFrame_Format;
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
struct PPB_VideoFrame_0_1 {
  /**
   * Determines if a resource is a VideoFrame resource.
   *
   * @param[in] resource The <code>PP_Resource</code> to test.
   *
   * @return A <code>PP_Bool</code> with <code>PP_TRUE</code> if the given
   * resource is a VideoFrame resource or <code>PP_FALSE</code> otherwise.
   */
  PP_Bool (*IsVideoFrame)(PP_Resource resource);
  /**
   * Gets the timestamp of the video frame.
   *
   * @param[in] frame A <code>PP_Resource</code> corresponding to a video frame
   * resource.
   *
   * @return A <code>PP_TimeDelta</code> containing the timestamp of the video
   * frame. Given in seconds since the start of the containing video stream.
   */
  PP_TimeDelta (*GetTimestamp)(PP_Resource frame);
  /**
   * Sets the timestamp of the video frame. Given in seconds since the
   * start of the containing video stream.
   *
   * @param[in] frame A <code>PP_Resource</code> corresponding to a video frame
   * resource.
   * @param[in] timestamp A <code>PP_TimeDelta</code> containing the timestamp
   * of the video frame. Given in seconds since the start of the containing
   * video stream.
   */
  void (*SetTimestamp)(PP_Resource frame, PP_TimeDelta timestamp);
  /**
   * Gets the format of the video frame.
   *
   * @param[in] frame A <code>PP_Resource</code> corresponding to a video frame
   * resource.
   *
   * @return A <code>PP_VideoFrame_Format</code> containing the format of the
   * video frame.
   */
  PP_VideoFrame_Format (*GetFormat)(PP_Resource frame);
  /**
   * Gets the size of the video frame.
   *
   * @param[in] frame A <code>PP_Resource</code> corresponding to a video frame
   * resource.
   * @param[out] size A <code>PP_Size</code>.
   *
   * @return A <code>PP_Bool</code> with <code>PP_TRUE</code> on success or
   * <code>PP_FALSE</code> on failure.
   */
  PP_Bool (*GetSize)(PP_Resource frame, struct PP_Size* size);
  /**
   * Gets the data buffer for video frame pixels.
   *
   * @param[in] frame A <code>PP_Resource</code> corresponding to a video frame
   * resource.
   *
   * @return A pointer to the beginning of the data buffer.
   */
  void* (*GetDataBuffer)(PP_Resource frame);
  /**
   * Gets the size of data buffer.
   *
   * @param[in] frame A <code>PP_Resource</code> corresponding to a video frame
   * resource.
   *
   * @return The size of the data buffer.
   */
  uint32_t (*GetDataBufferSize)(PP_Resource frame);
};

typedef struct PPB_VideoFrame_0_1 PPB_VideoFrame;
/**
 * @}
 */

/* ppb_video_encoder.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * Video encoder interface.
 *
 * Typical usage:
 * - Call Create() to create a new video encoder resource.
 * - Call GetSupportedFormats() to determine which codecs and profiles are
 *   available.
 * - Call Initialize() to initialize the encoder for a supported profile.
 * - Call GetVideoFrame() to get a blank frame and fill it in, or get a video
 *   frame from another resource, e.g. <code>PPB_MediaStreamVideoTrack</code>.
 * - Call Encode() to push the video frame to the encoder. If an external frame
 *   is pushed, wait for completion to recycle the frame.
 * - Call GetBitstreamBuffer() continuously (waiting for each previous call to
 *   complete) to pull encoded pictures from the encoder.
 * - Call RecycleBitstreamBuffer() after consuming the data in the bitstream
 *   buffer.
 * - To destroy the encoder, the plugin should release all of its references to
 *   it. Any pending callbacks will abort before the encoder is destroyed.
 *
 * Available video codecs vary by platform.
 * All: vp8 (software).
 * ChromeOS, depending on your device: h264 (hardware), vp8 (hardware)
 */
struct PPB_VideoEncoder_0_2 {
  /**
   * Creates a new video encoder resource.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying the instance
   * with the video encoder.
   *
   * @return A <code>PP_Resource</code> corresponding to a video encoder if
   * successful or 0 otherwise.
   */
  PP_Resource (*Create)(PP_Instance instance);
  /**
   * Determines if the given resource is a video encoder.
   *
   * @param[in] resource A <code>PP_Resource</code> identifying a resource.
   *
   * @return <code>PP_TRUE</code> if the resource is a
   * <code>PPB_VideoEncoder</code>, <code>PP_FALSE</code> if the resource is
   * invalid or some other type.
   */
  PP_Bool (*IsVideoEncoder)(PP_Resource resource);
  /**
   * Gets an array of supported video encoder profiles.
   * These can be used to choose a profile before calling Initialize().
   *
   * @param[in] video_encoder A <code>PP_Resource</code> identifying the video
   * encoder.
   * @param[in] output A <code>PP_ArrayOutput</code> to receive the supported
   * <code>PP_VideoProfileDescription</code> structs.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion.
   *
   * @return If >= 0, the number of supported profiles returned, otherwise an
   * error code from <code>pp_errors.h</code>.
   */
  int32_t (*GetSupportedProfiles)(PP_Resource video_encoder,
                                  struct PP_ArrayOutput output,
                                  struct PP_CompletionCallback callback);
  /**
   * Initializes a video encoder resource. The plugin should call Initialize()
   * successfully before calling any of the functions below.
   *
   * @param[in] video_encoder A <code>PP_Resource</code> identifying the video
   * encoder.
   * @param[in] input_format The <code>PP_VideoFrame_Format</code> of the
   * frames which will be encoded.
   * @param[in] input_visible_size A <code>PP_Size</code> specifying the
   * dimensions of the visible part of the input frames.
   * @param[in] output_profile A <code>PP_VideoProfile</code> specifying the
   * codec profile of the encoded output stream.
   * @param[in] acceleration A <code>PP_HardwareAcceleration</code> specifying
   * whether to use a hardware accelerated or a software implementation.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   * Returns PP_ERROR_NOTSUPPORTED if video encoding is not available, or the
   * requested codec profile is not supported.
   */
  int32_t (*Initialize)(PP_Resource video_encoder,
                        PP_VideoFrame_Format input_format,
                        const struct PP_Size* input_visible_size,
                        PP_VideoProfile output_profile,
                        uint32_t initial_bitrate,
                        PP_HardwareAcceleration acceleration,
                        struct PP_CompletionCallback callback);
  /**
   * Gets the number of input video frames that the encoder may hold while
   * encoding. If the plugin is providing the video frames, it should have at
   * least this many available.
   *
   * @param[in] video_encoder A <code>PP_Resource</code> identifying the video
   * encoder.
   * @return An int32_t containing the number of frames required, or an error
   * code from <code>pp_errors.h</code>.
   * Returns PP_ERROR_FAILED if Initialize() has not successfully completed.
   */
  int32_t (*GetFramesRequired)(PP_Resource video_encoder);
  /**
   * Gets the coded size of the video frames required by the encoder. Coded
   * size is the logical size of the input frames, in pixels.  The encoder may
   * have hardware alignment requirements that make this different from
   * |input_visible_size|, as requested in the call to Initialize().
   *
   * @param[in] video_encoder A <code>PP_Resource</code> identifying the video
   * encoder.
   * @param[in] coded_size A <code>PP_Size</code> to hold the coded size.
   * @return An int32_t containing a result code from <code>pp_errors.h</code>.
   * Returns PP_ERROR_FAILED if Initialize() has not successfully completed.
   */
  int32_t (*GetFrameCodedSize)(PP_Resource video_encoder,
                               struct PP_Size* coded_size);
  /**
   * Gets a blank video frame which can be filled with video data and passed
   * to the encoder.
   *
   * @param[in] video_encoder A <code>PP_Resource</code> identifying the video
   * encoder.
   * @param[out] video_frame A blank <code>PPB_VideoFrame</code> resource.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   * Returns PP_ERROR_FAILED if Initialize() has not successfully completed.
   */
  int32_t (*GetVideoFrame)(PP_Resource video_encoder,
                           PP_Resource* video_frame,
                           struct PP_CompletionCallback callback);
  /**
   * Encodes a video frame.
   *
   * @param[in] video_encoder A <code>PP_Resource</code> identifying the video
   * encoder.
   * @param[in] video_frame The <code>PPB_VideoFrame</code> to be encoded.
   * @param[in] force_keyframe A <code>PP_Bool> specifying whether the encoder
   * should emit a key frame for this video frame.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion. Plugins that pass <code>PPB_VideoFrame</code> resources owned
   * by other resources should wait for completion before reusing them.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   * Returns PP_ERROR_FAILED if Initialize() has not successfully completed.
   */
  int32_t (*Encode)(PP_Resource video_encoder,
                    PP_Resource video_frame,
                    PP_Bool force_keyframe,
                    struct PP_CompletionCallback callback);
  /**
   * Gets the next encoded bitstream buffer from the encoder.
   *
   * @param[in] video_encoder A <code>PP_Resource</code> identifying the video
   * encoder.
   * @param[out] bitstream_buffer A <code>PP_BitstreamBuffer</code> containing
   * encoded video data.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion. The plugin can call GetBitstreamBuffer from the callback in
   * order to continuously "pull" bitstream buffers from the encoder.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   * Returns PP_ERROR_FAILED if Initialize() has not successfully completed.
   * Returns PP_ERROR_INPROGRESS if a prior call to GetBitstreamBuffer() has
   * not completed.
   */
  int32_t (*GetBitstreamBuffer)(PP_Resource video_encoder,
                                struct PP_BitstreamBuffer* bitstream_buffer,
                                struct PP_CompletionCallback callback);
  /**
   * Recycles a bitstream buffer back to the encoder.
   *
   * @param[in] video_encoder A <code>PP_Resource</code> identifying the video
   * encoder.
   * @param[in] bitstream_buffer A <code>PP_BitstreamBuffer</code> that is no
   * longer needed by the plugin.
   */
  void (*RecycleBitstreamBuffer)(
      PP_Resource video_encoder,
      const struct PP_BitstreamBuffer* bitstream_buffer);
  /**
   * Requests a change to encoding parameters. This is only a request,
   * fulfilled on a best-effort basis.
   *
   * @param[in] video_encoder A <code>PP_Resource</code> identifying the video
   * encoder.
   * @param[in] bitrate The requested new bitrate, in bits per second.
   * @param[in] framerate The requested new framerate, in frames per second.
   */
  void (*RequestEncodingParametersChange)(PP_Resource video_encoder,
                                          uint32_t bitrate,
                                          uint32_t framerate);
  /**
   * Closes the video encoder, and cancels any pending encodes. Any pending
   * callbacks will still run, reporting <code>PP_ERROR_ABORTED</code> . It is
   * not valid to call any encoder functions after a call to this method.
   * <strong>Note:</strong> Destroying the video encoder closes it implicitly,
   * so you are not required to call Close().
   *
   * @param[in] video_encoder A <code>PP_Resource</code> identifying the video
   * encoder.
   */
  void (*Close)(PP_Resource video_encoder);
};

typedef struct PPB_VideoEncoder_0_2 PPB_VideoEncoder;

struct PPB_VideoEncoder_0_1 { /* dev */
  PP_Resource (*Create)(PP_Instance instance);
  PP_Bool (*IsVideoEncoder)(PP_Resource resource);
  int32_t (*GetSupportedProfiles)(PP_Resource video_encoder,
                                  struct PP_ArrayOutput output,
                                  struct PP_CompletionCallback callback);
  int32_t (*Initialize)(PP_Resource video_encoder,
                        PP_VideoFrame_Format input_format,
                        const struct PP_Size* input_visible_size,
                        PP_VideoProfile output_profile,
                        uint32_t initial_bitrate,
                        PP_HardwareAcceleration acceleration,
                        struct PP_CompletionCallback callback);
  int32_t (*GetFramesRequired)(PP_Resource video_encoder);
  int32_t (*GetFrameCodedSize)(PP_Resource video_encoder,
                               struct PP_Size* coded_size);
  int32_t (*GetVideoFrame)(PP_Resource video_encoder,
                           PP_Resource* video_frame,
                           struct PP_CompletionCallback callback);
  int32_t (*Encode)(PP_Resource video_encoder,
                    PP_Resource video_frame,
                    PP_Bool force_keyframe,
                    struct PP_CompletionCallback callback);
  int32_t (*GetBitstreamBuffer)(PP_Resource video_encoder,
                                struct PP_BitstreamBuffer* bitstream_buffer,
                                struct PP_CompletionCallback callback);
  void (*RecycleBitstreamBuffer)(
      PP_Resource video_encoder,
      const struct PP_BitstreamBuffer* bitstream_buffer);
  void (*RequestEncodingParametersChange)(PP_Resource video_encoder,
                                          uint32_t bitrate,
                                          uint32_t framerate);
  void (*Close)(PP_Resource video_encoder);
};
/**
 * @}
 */

/* ppb_view.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * <code>PPB_View</code> represents the state of the view of an instance.
 * You will receive new view information using
 * <code>PPP_Instance.DidChangeView</code>.
 */
struct PPB_View_1_2 {
  /**
   * IsView() determines if the given resource is a valid
   * <code>PPB_View</code> resource. Note that <code>PPB_ViewChanged</code>
   * resources derive from <code>PPB_View</code> and will return true here
   * as well.
   *
   * @param resource A <code>PP_Resource</code> corresponding to a
   * <code>PPB_View</code> resource.
   *
   * @return <code>PP_TRUE</code> if the given resource supports
   * <code>PPB_View</code> or <code>PP_FALSE</code> if it is an invalid
   * resource or is a resource of another type.
   */
  PP_Bool (*IsView)(PP_Resource resource);
  /**
   * GetRect() retrieves the rectangle of the module instance associated
   * with a view changed notification relative to the upper-left of the browser
   * viewport. This position changes when the page is scrolled.
   *
   * The returned rectangle may not be inside the visible portion of the
   * viewport if the module instance is scrolled off the page. Therefore, the
   * position may be negative or larger than the size of the page. The size will
   * always reflect the size of the module were it to be scrolled entirely into
   * view.
   *
   * In general, most modules will not need to worry about the position of the
   * module instance in the viewport, and only need to use the size.
   *
   * @param resource A <code>PP_Resource</code> corresponding to a
   * <code>PPB_View</code> resource.
   *
   * @param rect A <code>PP_Rect</code> receiving the rectangle on success.
   *
   * @return Returns <code>PP_TRUE</code> if the resource was valid and the
   * viewport rectangle was filled in, <code>PP_FALSE</code> if not.
   */
  PP_Bool (*GetRect)(PP_Resource resource, struct PP_Rect* rect);
  /**
   * IsFullscreen() returns whether the instance is currently
   * displaying in fullscreen mode.
   *
   * @param resource A <code>PP_Resource</code> corresponding to a
   * <code>PPB_View</code> resource.
   *
   * @return <code>PP_TRUE</code> if the instance is in full screen mode,
   * or <code>PP_FALSE</code> if it's not or the resource is invalid.
   */
  PP_Bool (*IsFullscreen)(PP_Resource resource);
  /**
   * IsVisible() determines whether the module instance might be visible to
   * the user. For example, the Chrome window could be minimized or another
   * window could be over it. In both of these cases, the module instance
   * would not be visible to the user, but IsVisible() will return true.
   *
   * Use the result to speed up or stop updates for invisible module
   * instances.
   *
   * This function performs the duties of GetRect() (determining whether the
   * module instance is scrolled into view and the clip rectangle is nonempty)
   * and IsPageVisible() (whether the page is visible to the user).
   *
   * @param resource A <code>PP_Resource</code> corresponding to a
   * <code>PPB_View</code> resource.
   *
   * @return <code>PP_TRUE</code> if the instance might be visible to the
   * user, <code>PP_FALSE</code> if it is definitely not visible.
   */
  PP_Bool (*IsVisible)(PP_Resource resource);
  /**
   * IsPageVisible() determines if the page that contains the module instance
   * is visible. The most common cause of invisible pages is that
   * the page is in a background tab in the browser.
   *
   * Most applications should use IsVisible() instead of this function since
   * the module instance could be scrolled off of a visible page, and this
   * function will still return true. However, depending on how your module
   * interacts with the page, there may be certain updates that you may want to
   * perform when the page is visible even if your specific module instance is
   * not visible.
   *
   * @param resource A <code>PP_Resource</code> corresponding to a
   * <code>PPB_View</code> resource.
   *
   * @return <code>PP_TRUE</code> if the instance is plausibly visible to the
   * user, <code>PP_FALSE</code> if it is definitely not visible.
   */
  PP_Bool (*IsPageVisible)(PP_Resource resource);
  /**
   * GetClipRect() returns the clip rectangle relative to the upper-left corner
   * of the module instance. This rectangle indicates the portions of the module
   * instance that are scrolled into view.
   *
   * If the module instance is scrolled off the view, the return value will be
   * (0, 0, 0, 0). This clip rectangle does <i>not</i> take into account page
   * visibility. Therefore, if the module instance is scrolled into view, but
   * the page itself is on a tab that is not visible, the return rectangle will
   * contain the visible rectangle as though the page were visible. Refer to
   * IsPageVisible() and IsVisible() if you want to account for page
   * visibility.
   *
   * Most applications will not need to worry about the clip rectangle. The
   * recommended behavior is to do full updates if the module instance is
   * visible, as determined by IsVisible(), and do no updates if it is not
   * visible.
   *
   * However, if the cost for computing pixels is very high for your
   * application, or the pages you're targeting frequently have very large
   * module instances with small visible portions, you may wish to optimize
   * further. In this case, the clip rectangle will tell you which parts of
   * the module to update.
   *
   * Note that painting of the page and sending of view changed updates
   * happens asynchronously. This means when the user scrolls, for example,
   * it is likely that the previous backing store of the module instance will
   * be used for the first paint, and will be updated later when your
   * application generates new content with the new clip. This may cause
   * flickering at the boundaries when scrolling. If you do choose to do
   * partial updates, you may want to think about what color the invisible
   * portions of your backing store contain (be it transparent or some
   * background color) or to paint a certain region outside the clip to reduce
   * the visual distraction when this happens.
   *
   * @param resource A <code>PP_Resource</code> corresponding to a
   * <code>PPB_View</code> resource.
   *
   * @param clip Output argument receiving the clip rect on success.
   *
   * @return Returns <code>PP_TRUE</code> if the resource was valid and the
   * clip rect was filled in, <code>PP_FALSE</code> if not.
   */
  PP_Bool (*GetClipRect)(PP_Resource resource, struct PP_Rect* clip);
  /**
   * GetDeviceScale returns the scale factor between device pixels and Density
   * Independent Pixels (DIPs, also known as logical pixels or UI pixels on
   * some platforms). This allows the developer to render their contents at
   * device resolution, even as coordinates / sizes are given in DIPs through
   * the API.
   *
   * Note that the coordinate system for Pepper APIs is DIPs. Also note that
   * one DIP might not equal one CSS pixel - when page scale/zoom is in effect.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to a
   * <code>PPB_View</code> resource.
   *
   * @return A <code>float</code> value representing the number of device pixels
   * per DIP. If the resource is invalid, the value will be 0.0.
   */
  float (*GetDeviceScale)(PP_Resource resource);
  /**
   * GetCSSScale returns the scale factor between DIPs and CSS pixels. This
   * allows proper scaling between DIPs - as sent via the Pepper API - and CSS
   * pixel coordinates used for Web content.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to a
   * <code>PPB_View</code> resource.
   *
   * @return css_scale A <code>float</code> value representing the number of
   * DIPs per CSS pixel. If the resource is invalid, the value will be 0.0.
   */
  float (*GetCSSScale)(PP_Resource resource);
  /**
   * GetScrollOffset returns the scroll offset of the window containing the
   * plugin.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to a
   * <code>PPB_View</code> resource.
   *
   * @param[out] offset A <code>PP_Point</code> which will be set to the value
   * of the scroll offset in CSS pixels.
   *
   * @return Returns <code>PP_TRUE</code> if the resource was valid and the
   * offset was filled in, <code>PP_FALSE</code> if not.
   */
  PP_Bool (*GetScrollOffset)(PP_Resource resource, struct PP_Point* offset);
};

typedef struct PPB_View_1_2 PPB_View;

struct PPB_View_1_0 {
  PP_Bool (*IsView)(PP_Resource resource);
  PP_Bool (*GetRect)(PP_Resource resource, struct PP_Rect* rect);
  PP_Bool (*IsFullscreen)(PP_Resource resource);
  PP_Bool (*IsVisible)(PP_Resource resource);
  PP_Bool (*IsPageVisible)(PP_Resource resource);
  PP_Bool (*GetClipRect)(PP_Resource resource, struct PP_Rect* clip);
};

struct PPB_View_1_1 {
  PP_Bool (*IsView)(PP_Resource resource);
  PP_Bool (*GetRect)(PP_Resource resource, struct PP_Rect* rect);
  PP_Bool (*IsFullscreen)(PP_Resource resource);
  PP_Bool (*IsVisible)(PP_Resource resource);
  PP_Bool (*IsPageVisible)(PP_Resource resource);
  PP_Bool (*GetClipRect)(PP_Resource resource, struct PP_Rect* clip);
  float (*GetDeviceScale)(PP_Resource resource);
  float (*GetCSSScale)(PP_Resource resource);
};
/**
 * @}
 */

/* ppb_vpn_provider.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * Use the <code>PPB_VpnProvider</code> interface to implement a VPN client.
 * Important: This API is available only on Chrome OS.
 *
 * This interface enhances the <code>chrome.vpnProvider</code> JavaScript API by
 * providing a high performance path for packet handling.
 *
 * Permissions: Apps permission <code>vpnProvider</code> is required for
 * <code>PPB_VpnProvider.Bind()</code>.
 *
 * Typical usage:
 * - Create a <code>PPB_VpnProvider</code> instance.
 * - Register the callback for <code>PPB_VpnProvider.ReceivePacket()</code>.
 * - In the extension follow the usual workflow for configuring a VPN connection
 *   via the <code>chrome.vpnProvider</code> API until the step for notifying
 *   the connection state as "connected".
 * - Bind to the previously created connection using
 *   <code>PPB_VpnProvider.Bind()</code>.
 * - Notify the connection state as "connected" from JavaScript using
 *   <code>chrome.vpnProvider.notifyConnectionStateChanged</code>.
 * - When the steps above are completed without errors, a virtual tunnel is
 *   created to the network stack of Chrome OS. IP packets can be sent through
 *   the tunnel using <code>PPB_VpnProvider.SendPacket()</code> and any packets
 *   originating on the Chrome OS device will be received using the callback
 *   registered for <code>PPB_VpnProvider.ReceivePacket()</code>.
 * - When the user disconnects from the VPN configuration or there is an error
 *   the extension will be notfied via
 *   <code>chrome.vpnProvider.onPlatformMessage</code>.
 */
struct PPB_VpnProvider_0_1 { /* dev */
  /**
   * Create() creates a VpnProvider instance.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying the instance
   * with the VpnProvider.
   *
   * @return A <code>PP_Resource</code> corresponding to a VpnProvider if
   * successful.
   */
  PP_Resource (*Create)(PP_Instance instance);
  /**
   * IsVpnProvider() determines if the provided <code>resource</code> is a
   * VpnProvider instance.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to a
   * VpnProvider.
   *
   * @return Returns <code>PP_TRUE</code> if <code>resource</code> is a
   * <code>PPB_VpnProvider</code>, <code>PP_FALSE</code> if the
   * <code>resource</code> is invalid or some type other than
   * <code>PPB_VpnProvider</code>.
   */
  PP_Bool (*IsVpnProvider)(PP_Resource resource);
  /**
   * Bind() binds to an existing configuration created from JavaScript by
   * <code>chrome.vpnProvider.createConfig</code>. All packets will be routed
   * via <code>SendPacket</code> and <code>ReceivePacket</code>. The user should
   * register the callback for <code>ReceivePacket</code> before calling
   * <code>Bind()</code>.
   *
   * @param[in] vpn_provider A <code>PP_Resource</code> corresponding to a
   * VpnProvider.
   *
   * @param[in] configuration_id A <code>PP_VARTYPE_STRING</code> representing
   * the configuration id from the callback of
   * <code>chrome.vpnProvider.createConfig</code>.
   *
   * @param[in] configuration_name A <code>PP_VARTYPE_STRING</code> representing
   * the configuration name as defined by the user when calling
   * <code>chrome.vpnProvider.createConfig</code>.
   *
   * @param[in] callback A <code>PP_CompletionCallback</code> called on
   * completion.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   * Returns <code>PP_ERROR_INPROGRESS</code> if a previous call to
   * <code>Bind()</code> has not completed.
   * Returns <code>PP_ERROR_BADARGUMENT</code> if either
   * <code>configuration_id</code> or <code>configuration_name</code> are not of
   * type <code>PP_VARTYPE_STRING</code>.
   * Returns <code>PP_ERROR_NOACCESS</code> if the caller does the have the
   * required "vpnProvider" permission.
   * Returns <code>PP_ERROR_FAILED</code> if <code>connection_id</code> and
   * <code>connection_name</code> could not be matched with the existing
   * connection, or if the plugin originates from a different extension than the
   * one that created the connection.
   */
  int32_t (*Bind)(PP_Resource vpn_provider,
                  struct PP_Var configuration_id,
                  struct PP_Var configuration_name,
                  struct PP_CompletionCallback callback);
  /**
   * SendPacket() sends an IP packet through the tunnel created for the VPN
   * session. This will succeed only when the VPN session is owned by the
   * module and the connection is bound.
   *
   * @param[in] vpn_provider A <code>PP_Resource</code> corresponding to a
   * VpnProvider.
   *
   * @param[in] packet A <code>PP_VARTYPE_ARRAY_BUFFER</code> corresponding to
   * an IP packet to be sent to the platform.
   *
   * @param[in] callback A <code>PP_CompletionCallback</code> called on
   * completion.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   * Returns <code>PP_ERROR_FAILED</code> if the connection is not bound.
   * Returns <code>PP_ERROR_INPROGRESS</code> if a previous call to
   * <code>SendPacket()</code> has not completed.
   * Returns <code>PP_ERROR_BADARGUMENT</code> if <code>packet</code> is not of
   * type <code>PP_VARTYPE_ARRAY_BUFFER</code>.
   */
  int32_t (*SendPacket)(PP_Resource vpn_provider,
                        struct PP_Var packet,
                        struct PP_CompletionCallback callback);
  /**
   * ReceivePacket() receives an IP packet from the tunnel for the VPN session.
   * This function only returns a single packet. This function must be called at
   * least N times to receive N packets, no matter the size of each packet. The
   * callback should be registered before calling <code>Bind()</code>.
   *
   * @param[in] vpn_provider A <code>PP_Resource</code> corresponding to a
   * VpnProvider.
   *
   * @param[out] packet The received packet is copied to provided
   * <code>packet</code>. The <code>packet</code> must remain valid until
   * ReceivePacket() completes. Its received <code>PP_VarType</code> will be
   * <code>PP_VARTYPE_ARRAY_BUFFER</code>.
   *
   * @param[in] callback A <code>PP_CompletionCallback</code> called on
   * completion.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   * Returns <code>PP_ERROR_INPROGRESS</code> if a previous call to
   * <code>ReceivePacket()</code> has not completed.
   */
  int32_t (*ReceivePacket)(PP_Resource vpn_provider,
                           struct PP_Var* packet,
                           struct PP_CompletionCallback callback);
};
/**
 * @}
 */

/* ppb_websocket.idl */
/**
 * @addtogroup Enums
 * @{
 */
/**
 * This enumeration contains the types representing the WebSocket ready state
 * and these states are based on the JavaScript WebSocket API specification.
 * GetReadyState() returns one of these states.
 */
typedef enum {
  /**
   * Ready state is queried on an invalid resource.
   */
  PP_WEBSOCKETREADYSTATE_INVALID = -1,
  /**
   * Ready state that the connection has not yet been established.
   */
  PP_WEBSOCKETREADYSTATE_CONNECTING = 0,
  /**
   * Ready state that the WebSocket connection is established and communication
   * is possible.
   */
  PP_WEBSOCKETREADYSTATE_OPEN = 1,
  /**
   * Ready state that the connection is going through the closing handshake.
   */
  PP_WEBSOCKETREADYSTATE_CLOSING = 2,
  /**
   * Ready state that the connection has been closed or could not be opened.
   */
  PP_WEBSOCKETREADYSTATE_CLOSED = 3
} PP_WebSocketReadyState;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_WebSocketReadyState, 4);

/**
 * This enumeration contains status codes. These codes are used in Close() and
 * GetCloseCode(). Refer to RFC 6455, The WebSocket Protocol, for further
 * information.
 * <code>PP_WEBSOCKETSTATUSCODE_NORMAL_CLOSURE</code> and codes in the range
 * <code>PP_WEBSOCKETSTATUSCODE_USER_REGISTERED_MIN</code> to
 * <code>PP_WEBSOCKETSTATUSCODE_USER_REGISTERED_MAX</code>, and
 * <code>PP_WEBSOCKETSTATUSCODE_USER_PRIVATE_MIN</code> to
 * <code>PP_WEBSOCKETSTATUSCODE_USER_PRIVATE_MAX</code> are valid for Close().
 */
typedef enum {
  /**
   * Indicates to request closing connection without status code and reason.
   *
   * (Note that the code 1005 is forbidden to send in actual close frames by
   * the RFC. PP_WebSocket reuses this code internally and the code will never
   * appear in the actual close frames.)
   */
  PP_WEBSOCKETSTATUSCODE_NOT_SPECIFIED = 1005,
  /**
   * Status codes in the range 0-999 are not used.
   */
  /**
   * Indicates a normal closure.
   */
  PP_WEBSOCKETSTATUSCODE_NORMAL_CLOSURE = 1000,
  /**
   * Indicates that an endpoint is "going away", such as a server going down.
   */
  PP_WEBSOCKETSTATUSCODE_GOING_AWAY = 1001,
  /**
   * Indicates that an endpoint is terminating the connection due to a protocol
   * error.
   */
  PP_WEBSOCKETSTATUSCODE_PROTOCOL_ERROR = 1002,
  /**
   * Indicates that an endpoint is terminating the connection because it has
   * received a type of data it cannot accept.
   */
  PP_WEBSOCKETSTATUSCODE_UNSUPPORTED_DATA = 1003,
  /**
   * Status code 1004 is reserved.
   */
  /**
   * Pseudo code to indicate that receiving close frame doesn't contain any
   * status code.
   */
  PP_WEBSOCKETSTATUSCODE_NO_STATUS_RECEIVED = 1005,
  /**
   * Pseudo code to indicate that connection was closed abnormally, e.g.,
   * without closing handshake.
   */
  PP_WEBSOCKETSTATUSCODE_ABNORMAL_CLOSURE = 1006,
  /**
   * Indicates that an endpoint is terminating the connection because it has
   * received data within a message that was not consistent with the type of
   * the message (e.g., non-UTF-8 data within a text message).
   */
  PP_WEBSOCKETSTATUSCODE_INVALID_FRAME_PAYLOAD_DATA = 1007,
  /**
   * Indicates that an endpoint is terminating the connection because it has
   * received a message that violates its policy.
   */
  PP_WEBSOCKETSTATUSCODE_POLICY_VIOLATION = 1008,
  /**
   * Indicates that an endpoint is terminating the connection because it has
   * received a message that is too big for it to process.
   */
  PP_WEBSOCKETSTATUSCODE_MESSAGE_TOO_BIG = 1009,
  /**
   * Indicates that an endpoint (client) is terminating the connection because
   * it has expected the server to negotiate one or more extension, but the
   * server didn't return them in the response message of the WebSocket
   * handshake.
   */
  PP_WEBSOCKETSTATUSCODE_MANDATORY_EXTENSION = 1010,
  /**
   * Indicates that a server is terminating the connection because it
   * encountered an unexpected condition.
   */
  PP_WEBSOCKETSTATUSCODE_INTERNAL_SERVER_ERROR = 1011,
  /**
   * Status codes in the range 1012-1014 are reserved.
   */
  /**
   * Pseudo code to indicate that the connection was closed due to a failure to
   * perform a TLS handshake.
   */
  PP_WEBSOCKETSTATUSCODE_TLS_HANDSHAKE = 1015,
  /**
   * Status codes in the range 1016-2999 are reserved.
   */
  /**
   * Status codes in the range 3000-3999 are reserved for use by libraries,
   * frameworks, and applications. These codes are registered directly with
   * IANA.
   */
  PP_WEBSOCKETSTATUSCODE_USER_REGISTERED_MIN = 3000,
  PP_WEBSOCKETSTATUSCODE_USER_REGISTERED_MAX = 3999,
  /**
   * Status codes in the range 4000-4999 are reserved for private use.
   * Application can use these codes for application specific purposes freely.
   */
  PP_WEBSOCKETSTATUSCODE_USER_PRIVATE_MIN = 4000,
  PP_WEBSOCKETSTATUSCODE_USER_PRIVATE_MAX = 4999
} PP_WebSocketCloseCode;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_WebSocketCloseCode, 4);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPB_WebSocket</code> interface provides bi-directional,
 * full-duplex, communications over a single TCP socket.
 */
struct PPB_WebSocket_1_0 {
  /**
   * Create() creates a WebSocket instance.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying the instance
   * with the WebSocket.
   *
   * @return A <code>PP_Resource</code> corresponding to a WebSocket if
   * successful.
   */
  PP_Resource (*Create)(PP_Instance instance);
  /**
   * IsWebSocket() determines if the provided <code>resource</code> is a
   * WebSocket instance.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to a
   * WebSocket.
   *
   * @return Returns <code>PP_TRUE</code> if <code>resource</code> is a
   * <code>PPB_WebSocket</code>, <code>PP_FALSE</code> if the
   * <code>resource</code> is invalid or some type other than
   * <code>PPB_WebSocket</code>.
   */
  PP_Bool (*IsWebSocket)(PP_Resource resource);
  /**
   * Connect() connects to the specified WebSocket server. You can call this
   * function once for a <code>web_socket</code>.
   *
   * @param[in] web_socket A <code>PP_Resource</code> corresponding to a
   * WebSocket.
   *
   * @param[in] url A <code>PP_Var</code> representing a WebSocket server URL.
   * The <code>PP_VarType</code> must be <code>PP_VARTYPE_STRING</code>.
   *
   * @param[in] protocols A pointer to an array of <code>PP_Var</code>
   * specifying sub-protocols. Each <code>PP_Var</code> represents one
   * sub-protocol and its <code>PP_VarType</code> must be
   * <code>PP_VARTYPE_STRING</code>. This argument can be null only if
   * <code>protocol_count</code> is 0.
   *
   * @param[in] protocol_count The number of sub-protocols in
   * <code>protocols</code>.
   *
   * @param[in] callback A <code>PP_CompletionCallback</code> called
   * when a connection is established or an error occurs in establishing
   * connection.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   * Returns <code>PP_ERROR_BADARGUMENT</code> if the specified
   * <code>url</code>, or <code>protocols</code> contain an invalid string as
   * defined in the WebSocket API specification.
   * <code>PP_ERROR_BADARGUMENT</code> corresponds to a SyntaxError in the
   * WebSocket API specification.
   * Returns <code>PP_ERROR_NOACCESS</code> if the protocol specified in the
   * <code>url</code> is not a secure protocol, but the origin of the caller
   * has a secure scheme. Also returns <code>PP_ERROR_NOACCESS</code> if the
   * port specified in the <code>url</code> is a port that the user agent
   * is configured to block access to because it is a well-known port like
   * SMTP. <code>PP_ERROR_NOACCESS</code> corresponds to a SecurityError of the
   * specification.
   * Returns <code>PP_ERROR_INPROGRESS</code> if this is not the first call to
   * Connect().
   */
  int32_t (*Connect)(PP_Resource web_socket,
                     struct PP_Var url,
                     const struct PP_Var protocols[],
                     uint32_t protocol_count,
                     struct PP_CompletionCallback callback);
  /**
   * Close() closes the specified WebSocket connection by specifying
   * <code>code</code> and <code>reason</code>.
   *
   * @param[in] web_socket A <code>PP_Resource</code> corresponding to a
   * WebSocket.
   *
   * @param[in] code The WebSocket close code. This is ignored if it is
   * <code>PP_WEBSOCKETSTATUSCODE_NOT_SPECIFIED</code>.
   * <code>PP_WEBSOCKETSTATUSCODE_NORMAL_CLOSURE</code> must be used for the
   * usual case. To indicate some specific error cases, codes in the range
   * <code>PP_WEBSOCKETSTATUSCODE_USER_REGISTERED_MIN</code> to
   * <code>PP_WEBSOCKETSTATUSCODE_USER_REGISTERED_MAX</code>, and in the range
   * <code>PP_WEBSOCKETSTATUSCODE_USER_PRIVATE_MIN</code> to
   * <code>PP_WEBSOCKETSTATUSCODE_USER_PRIVATE_MAX</code> are available.
   *
   * @param[in] reason A <code>PP_Var</code> representing the WebSocket
   * close reason. This is ignored if it is <code>PP_VARTYPE_UNDEFINED</code>.
   * Otherwise, its <code>PP_VarType</code> must be
   * <code>PP_VARTYPE_STRING</code>.
   *
   * @param[in] callback A <code>PP_CompletionCallback</code> called
   * when the connection is closed or an error occurs in closing the
   * connection.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   * Returns <code>PP_ERROR_BADARGUMENT</code> if <code>reason</code> contains
   * an invalid character as a UTF-8 string, or is longer than 123 bytes.
   * <code>PP_ERROR_BADARGUMENT</code> corresponds to a JavaScript SyntaxError
   * in the WebSocket API specification.
   * Returns <code>PP_ERROR_NOACCESS</code> if the code is not an integer
   * equal to 1000 or in the range 3000 to 4999. <code>PP_ERROR_NOACCESS</code>
   * corresponds to an InvalidAccessError in the WebSocket API specification.
   * Returns <code>PP_ERROR_INPROGRESS</code> if a previous call to Close() is
   * not finished.
   */
  int32_t (*Close)(PP_Resource web_socket,
                   uint16_t code,
                   struct PP_Var reason,
                   struct PP_CompletionCallback callback);
  /**
   * ReceiveMessage() receives a message from the WebSocket server.
   * This interface only returns a single message. That is, this interface must
   * be called at least N times to receive N messages, no matter the size of
   * each message.
   *
   * @param[in] web_socket A <code>PP_Resource</code> corresponding to a
   * WebSocket.
   *
   * @param[out] message The received message is copied to provided
   * <code>message</code>. The <code>message</code> must remain valid until
   * ReceiveMessage() completes. Its received <code>PP_VarType</code> will be
   * <code>PP_VARTYPE_STRING</code> or <code>PP_VARTYPE_ARRAY_BUFFER</code>.
   *
   * @param[in] callback A <code>PP_CompletionCallback</code> called
   * when ReceiveMessage() completes. This callback is ignored if
   * ReceiveMessage() completes synchronously and returns <code>PP_OK</code>.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   * If an error is detected or connection is closed, ReceiveMessage() returns
   * <code>PP_ERROR_FAILED</code> after all buffered messages are received.
   * Until buffered message become empty, ReceiveMessage() continues to return
   * <code>PP_OK</code> as if connection is still established without errors.
   */
  int32_t (*ReceiveMessage)(PP_Resource web_socket,
                            struct PP_Var* message,
                            struct PP_CompletionCallback callback);
  /**
   * SendMessage() sends a message to the WebSocket server.
   *
   * @param[in] web_socket A <code>PP_Resource</code> corresponding to a
   * WebSocket.
   *
   * @param[in] message A message to send. The message is copied to an internal
   * buffer, so the caller can free <code>message</code> safely after returning
   * from the function. Its sent <code>PP_VarType</code> must be
   * <code>PP_VARTYPE_STRING</code> or <code>PP_VARTYPE_ARRAY_BUFFER</code>.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   * Returns <code>PP_ERROR_FAILED</code> if the ReadyState is
   * <code>PP_WEBSOCKETREADYSTATE_CONNECTING</code>.
   * <code>PP_ERROR_FAILED</code> corresponds to a JavaScript
   * InvalidStateError in the WebSocket API specification.
   * Returns <code>PP_ERROR_BADARGUMENT</code> if the provided
   * <code>message</code> contains an invalid character as a UTF-8 string.
   * <code>PP_ERROR_BADARGUMENT</code> corresponds to a JavaScript
   * SyntaxError in the WebSocket API specification.
   * Otherwise, returns <code>PP_OK</code>, which doesn't necessarily mean
   * that the server received the message.
   */
  int32_t (*SendMessage)(PP_Resource web_socket, struct PP_Var message);
  /**
   * GetBufferedAmount() returns the number of bytes of text and binary
   * messages that have been queued for the WebSocket connection to send, but
   * have not been transmitted to the network yet.
   *
   * @param[in] web_socket A <code>PP_Resource</code> corresponding to a
   * WebSocket.
   *
   * @return Returns the number of bytes.
   */
  uint64_t (*GetBufferedAmount)(PP_Resource web_socket);
  /**
   * GetCloseCode() returns the connection close code for the WebSocket
   * connection.
   *
   * @param[in] web_socket A <code>PP_Resource</code> corresponding to a
   * WebSocket.
   *
   * @return Returns 0 if called before the close code is set.
   */
  uint16_t (*GetCloseCode)(PP_Resource web_socket);
  /**
   * GetCloseReason() returns the connection close reason for the WebSocket
   * connection.
   *
   * @param[in] web_socket A <code>PP_Resource</code> corresponding to a
   * WebSocket.
   *
   * @return Returns a <code>PP_VARTYPE_STRING</code> var. If called before the
   * close reason is set, the return value contains an empty string. Returns a
   * <code>PP_VARTYPE_UNDEFINED</code> if called on an invalid resource.
   */
  struct PP_Var (*GetCloseReason)(PP_Resource web_socket);
  /**
   * GetCloseWasClean() returns if the connection was closed cleanly for the
   * specified WebSocket connection.
   *
   * @param[in] web_socket A <code>PP_Resource</code> corresponding to a
   * WebSocket.
   *
   * @return Returns <code>PP_FALSE</code> if called before the connection is
   * closed, called on an invalid resource, or closed for abnormal reasons.
   * Otherwise, returns <code>PP_TRUE</code> if the connection was closed
   * cleanly.
   */
  PP_Bool (*GetCloseWasClean)(PP_Resource web_socket);
  /**
   * GetExtensions() returns the extensions selected by the server for the
   * specified WebSocket connection.
   *
   * @param[in] web_socket A <code>PP_Resource</code> corresponding to a
   * WebSocket.
   *
   * @return Returns a <code>PP_VARTYPE_STRING</code> var. If called before the
   * connection is established, the var's data is an empty string. Returns a
   * <code>PP_VARTYPE_UNDEFINED</code> if called on an invalid resource.
   */
  struct PP_Var (*GetExtensions)(PP_Resource web_socket);
  /**
   * GetProtocol() returns the sub-protocol chosen by the server for the
   * specified WebSocket connection.
   *
   * @param[in] web_socket A <code>PP_Resource</code> corresponding to a
   * WebSocket.
   *
   * @return Returns a <code>PP_VARTYPE_STRING</code> var. If called before the
   * connection is established, the var contains the empty string. Returns a
   * <code>PP_VARTYPE_UNDEFINED</code> if called on an invalid resource.
   */
  struct PP_Var (*GetProtocol)(PP_Resource web_socket);
  /**
   * GetReadyState() returns the ready state of the specified WebSocket
   * connection.
   *
   * @param[in] web_socket A <code>PP_Resource</code> corresponding to a
   * WebSocket.
   *
   * @return Returns <code>PP_WEBSOCKETREADYSTATE_INVALID</code> if called
   * before Connect() is called, or if this function is called on an
   * invalid resource.
   */
  PP_WebSocketReadyState (*GetReadyState)(PP_Resource web_socket);
  /**
   * GetURL() returns the URL associated with specified WebSocket connection.
   *
   * @param[in] web_socket A <code>PP_Resource</code> corresponding to a
   * WebSocket.
   *
   * @return Returns a <code>PP_VARTYPE_STRING</code> var. If called before the
   * connection is established, the var contains the empty string. Returns a
   * <code>PP_VARTYPE_UNDEFINED</code> if this function is called on an
   * invalid resource.
   */
  struct PP_Var (*GetURL)(PP_Resource web_socket);
};

typedef struct PPB_WebSocket_1_0 PPB_WebSocket;
/**
 * @}
 */

/* ppp.idl */

#include "ppapi/c/pp_module.h"
#include "ppapi/c/pp_stdint.h"
#include "ppapi/c/ppb.h"

#if __GNUC__ >= 4
#define PP_EXPORT __attribute__ ((visibility("default")))
#elif defined(_MSC_VER)
#define PP_EXPORT __declspec(dllexport)
#endif

/* {PENDING: undefine PP_EXPORT?} */

/* We don't want name mangling for these external functions.  We only need
 * 'extern "C"' if we're compiling with a C++ compiler.
 */
#ifdef __cplusplus
extern "C" {
#endif

/**
 * @addtogroup Functions
 * @{
 */

/**
 * PPP_InitializeModule() is the entry point for a module and is called by the
 * browser when your module loads. Your code must implement this function.
 *
 * Failure indicates to the browser that this module can not be used. In this
 * case, the module will be unloaded and ShutdownModule will NOT be called.
 *
 * @param[in] module A handle to your module. Generally you should store this
 * value since it will be required for other API calls.
 * @param[in] get_browser_interface A pointer to the function that you can
 * use to query for browser interfaces. Generally you should store this value
 * for future use.
 *
 * @return <code>PP_OK</code> on success. Any other value on failure.
 */
PP_EXPORT int32_t PPP_InitializeModule(PP_Module module,
                                       PPB_GetInterface get_browser_interface);
/**
 * @}
 */

/**
 * @addtogroup Functions
 * @{
 */

/**
 * PPP_ShutdownModule() is <strong>sometimes</strong> called before the module
 * is unloaded. It is not recommended that you implement this function.
 *
 * There is no practical use of this function for third party modules. Its
 * existence is because of some internal use cases inside Chrome.
 *
 * Since your module runs in a separate process, there's no need to free
 * allocated memory. There is also no need to free any resources since all of
 * resources associated with an instance will be force-freed when that instance
 * is deleted.
 *
 * <strong>Note:</strong> This function will always be skipped on untrusted
 * (Native Client) implementations. This function may be skipped on trusted
 * implementations in certain circumstances when Chrome does "fast shutdown"
 * of a web page.
 */
PP_EXPORT void PPP_ShutdownModule(void);
/**
 * @}
 */

/**
 * @addtogroup Functions
 * @{
 */

/**
 * PPP_GetInterface() is called by the browser to query the module for
 * interfaces it supports.
 *
 * Your module must implement the <code>PPP_Instance</code> interface or it
 * will be unloaded. Other interfaces are optional.
 *
 * This function is called from within browser code whenever an interface is
 * needed. This means your plugin could be reentered via this function if you
 * make a browser call and it needs an interface. Furthermore, you should not
 * make any other browser calls from within your implementation to avoid
 * reentering the browser.
 *
 * As a result, your implementation of this should merely provide a lookup
 * from the requested name to an interface pointer, via something like a big
 * if/else block or a map, and not do any other work.
 *
 * @param[in] interface_name A pointer to a "PPP" (plugin) interface name.
 * Interface names are null-terminated ASCII strings.
 *
 * @return A pointer for the interface or <code>NULL</code> if the interface is
 * not supported.
 */
PP_EXPORT const void* PPP_GetInterface(const char* interface_name);
/**
 * @}
 */

#ifdef __cplusplus
}  /* extern "C" */
#endif


/**
 * @addtogroup Typedefs
 * @{
 */
/**
 * Defines the type of the <code>PPP_InitializeModule</code> function.
 */
typedef int32_t (*PP_InitializeModule_Func)(
    PP_Module module,
    PPB_GetInterface get_browser_interface);

/**
 * Defines the type of the <code>PPP_ShutdownModule</code> function.
 */
typedef void (*PP_ShutdownModule_Func)(void);

/**
 * Defines the type of the <code>PPP_ShutdownModule</code> function.
 */
typedef const void* (*PP_GetInterface_Func)(const char* interface_name);
/**
 * @}
 */

/* ppp_graphics_3d.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * <code>PPP_Graphics3D</code> defines the notification interface for a 3D
 * graphics context.
 */
struct PPP_Graphics3D_1_0 {
  /**
   * Called when the OpenGL ES window is invalidated and needs to be repainted.
   */
  void (*Graphics3DContextLost)(PP_Instance instance);
};

typedef struct PPP_Graphics3D_1_0 PPP_Graphics3D;
/**
 * @}
 */

/* ppp_input_event.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
struct PPP_InputEvent_0_1 {
  /**
   * Function for receiving input events from the browser.
   *
   * In order to receive input events, you must register for them by calling
   * PPB_InputEvent.RequestInputEvents() or RequestFilteringInputEvents(). By
   * default, no events are delivered.
   *
   * If the event was handled, it will not be forwarded to the default handlers
   * in the web page.  If it was not handled, it may be dispatched to a default
   * handler. So it is important that an instance respond accurately with
   * whether event propagation should continue.
   *
   * Event propagation also controls focus. If you handle an event like a mouse
   * event, typically the instance will be given focus. Returning false from
   * a filtered event handler or not registering for an event type means that
   * the click will be given to a lower part of the page and your instance will
   * not receive focus. This allows an instance to be partially transparent,
   * where clicks on the transparent areas will behave like clicks to the
   * underlying page.
   *
   * In general, you should try to keep input event handling short. Especially
   * for filtered input events, the browser or page may be blocked waiting for
   * you to respond.
   *
   * The caller of this function will maintain a reference to the input event
   * resource during this call. Unless you take a reference to the resource
   * to hold it for later, you don't need to release it.
   *
   * <strong>Note:</strong> If you're not receiving input events, make sure you
   * register for the event classes you want by calling RequestInputEvents or
   * RequestFilteringInputEvents. If you're still not receiving keyboard input
   * events, make sure you're returning true (or using a non-filtered event
   * handler) for mouse events. Otherwise, the instance will not receive focus
   * and keyboard events will not be sent.
   *
   * \see PPB_InputEvent.RequestInputEvents and
   * PPB_InputEvent.RequestFilteringInputEvents
   *
   * @return PP_TRUE if the event was handled, PP_FALSE if not. If you have
   * registered to filter this class of events by calling
   * RequestFilteringInputEvents, and you return PP_FALSE, the event will
   * be forwarded to the page (and eventually the browser) for the default
   * handling. For non-filtered events, the return value will be ignored.
   */
  PP_Bool (*HandleInputEvent)(PP_Instance instance, PP_Resource input_event);
};

typedef struct PPP_InputEvent_0_1 PPP_InputEvent;
/**
 * @}
 */

/* ppp_instance.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPP_Instance</code> interface contains pointers to a series of
 * functions that you must implement in your module. These functions can be
 * trivial (simply return the default return value) unless you want your module
 * to handle events such as change of focus or input events (keyboard/mouse)
 * events.
 */
struct PPP_Instance_1_1 {
  /**
   * DidCreate() is a creation handler that is called when a new instance is
   * created. This function is called for each instantiation on the page,
   * corresponding to one \<embed\> tag on the page.
   *
   * Generally you would handle this call by initializing the information
   * your module associates with an instance and creating a mapping from the
   * given <code>PP_Instance</code> handle to this data. The
   * <code>PP_Instance</code> handle will be used in subsequent calls to
   * identify which instance the call pertains to.
   *
   * It's possible for more than one instance to be created in a single module.
   * This means that you may get more than one <code>OnCreate</code> without an
   * <code>OnDestroy</code> in between, and should be prepared to maintain
   * multiple states associated with each instance.
   *
   * If this function reports a failure (by returning <code>PP_FALSE</code>),
   * the instance will be deleted.
   *
   * @param[in] instance A new <code>PP_Instance</code> identifying one
   * instance of a module. This is an opaque handle.
   *
   * @param[in] argc The number of arguments contained in <code>argn</code>
   * and <code>argv</code>.
   *
   * @param[in] argn An array of argument names.  These argument names are
   * supplied in the \<embed\> tag, for example:
   * <code>\<embed id="nacl_module" dimensions="2"\></code> will produce two
   * argument names: "id" and "dimensions."
   *
   * @param[in] argv An array of argument values.  These are the values of the
   * arguments listed in the \<embed\> tag, for example
   * <code>\<embed id="nacl_module" dimensions="2"\></code> will produce two
   * argument values: "nacl_module" and "2".  The indices of these values match
   * the indices of the corresponding names in <code>argn</code>.
   *
   * @return <code>PP_TRUE</code> on success or <code>PP_FALSE</code> on
   * failure.
   */
  PP_Bool (*DidCreate)(PP_Instance instance,
                       uint32_t argc,
                       const char* argn[],
                       const char* argv[]);
  /**
   * DidDestroy() is an instance destruction handler. This function is called
   * in many cases (see below) when a module instance is destroyed. It will be
   * called even if DidCreate() returned failure.
   *
   * Generally you will handle this call by deallocating the tracking
   * information and the <code>PP_Instance</code> mapping you created in the
   * DidCreate() call. You can also free resources associated with this
   * instance but this isn't required; all resources associated with the deleted
   * instance will be automatically freed when this function returns.
   *
   * The instance identifier will still be valid during this call, so the module
   * can perform cleanup-related tasks. Once this function returns, the
   * <code>PP_Instance</code> handle will be invalid. This means that you can't
   * do any asynchronous operations like network requests, file writes or
   * messaging from this function since they will be immediately canceled.
   *
   * <strong>Note:</strong> This function will always be skipped on untrusted
   * (Native Client) implementations. This function may be skipped on trusted
   * implementations in certain circumstances when Chrome does "fast shutdown"
   * of a web page. Fast shutdown will happen in some cases when all module
   * instances are being deleted, and no cleanup functions will be called.
   * The module will just be unloaded and the process terminated.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying one instance
   * of a module.
   */
  void (*DidDestroy)(PP_Instance instance);
  /**
   * <code>DidChangeView() is called when the position, size, or other view
   * attributes of the instance has changed.
   */
  void (*DidChangeView)(PP_Instance instance, PP_Resource view);
  /**
   * DidChangeFocus() is called when an instance has gained or lost focus.
   * Having focus means that keyboard events will be sent to the instance.
   * An instance's default condition is that it will not have focus.
   *
   * The focus flag takes into account both browser tab and window focus as
   * well as focus of the plugin element on the page. In order to be deemed
   * to have focus, the browser window must be topmost, the tab must be
   * selected in the window, and the instance must be the focused element on
   * the page.
   *
   * <strong>Note:</strong>Clicks on instances will give focus only if you
   * handle the click event. Return <code>true</code> from
   * <code>HandleInputEvent</code> in <code>PPP_InputEvent</code> (or use
   * unfiltered events) to signal that the click event was handled. Otherwise,
   * the browser will bubble the event and give focus to the element on the page
   * that actually did end up consuming it. If you're not getting focus, check
   * to make sure you're either requesting them via
   * <code>RequestInputEvents()<code> (which implicitly marks all input events
   * as consumed) or via <code>RequestFilteringInputEvents()</code> and
   * returning true from your event handler.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying the instance
   * receiving the input event.
   *
   * @param[in] has_focus Indicates the new focused state of the instance.
   */
  void (*DidChangeFocus)(PP_Instance instance, PP_Bool has_focus);
  /**
   * HandleDocumentLoad() is called after initialize for a full-frame
   * instance that was instantiated based on the MIME type of a DOMWindow
   * navigation. This situation only applies to modules that are pre-registered
   * to handle certain MIME types. If you haven't specifically registered to
   * handle a MIME type or aren't positive this applies to you, your
   * implementation of this function can just return <code>PP_FALSE</code>.
   *
   * The given <code>url_loader</code> corresponds to a
   * <code>PPB_URLLoader</code> instance that is already opened. Its response
   * headers may be queried using <code>PPB_URLLoader::GetResponseInfo</code>.
   * The reference count for the URL loader is not incremented automatically on
   * behalf of the module. You need to increment the reference count yourself
   * if you are going to keep a reference to it.
   *
   * This method returns <code>PP_FALSE</code> if the module cannot handle the
   * data. In response to this method, the module should call
   * ReadResponseBody() to read the incoming data.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying the instance
   * that should do the load.
   *
   * @param[in] url_loader An open <code>PPB_URLLoader</code> instance.
   *
   * @return <code>PP_TRUE</code> if the data was handled,
   * <code>PP_FALSE</code> otherwise.  If you return false, the load will be
   * canceled for you.
   */
  PP_Bool (*HandleDocumentLoad)(PP_Instance instance, PP_Resource url_loader);
};

typedef struct PPP_Instance_1_1 PPP_Instance;

struct PPP_Instance_1_0 {
  PP_Bool (*DidCreate)(PP_Instance instance,
                       uint32_t argc,
                       const char* argn[],
                       const char* argv[]);
  void (*DidDestroy)(PP_Instance instance);
  void (*DidChangeView)(PP_Instance instance,
                        const struct PP_Rect* position,
                        const struct PP_Rect* clip);
  void (*DidChangeFocus)(PP_Instance instance, PP_Bool has_focus);
  PP_Bool (*HandleDocumentLoad)(PP_Instance instance, PP_Resource url_loader);
};
/**
 * @}
 */

/* ppp_messaging.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPP_Messaging</code> interface contains pointers to functions
 * that you must implement to handle postMessage events on the associated
 * DOM element.
 */
struct PPP_Messaging_1_0 {
  /**
   * HandleMessage() is a function that the browser calls when PostMessage()
   * is invoked on the DOM element for the module instance in JavaScript. Note
   * that PostMessage() in the JavaScript interface is asynchronous, meaning
   * JavaScript execution will not be blocked while HandleMessage() is
   * processing the message.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying one instance
   * of a module.
   * @param[in] message A <code>PP_Var</code> which has been converted from a
   * JavaScript value. JavaScript array/object types are supported from Chrome
   * M29 onward. All JavaScript values are copied when passing them to the
   * plugin.
   *
   * When converting JavaScript arrays, any object properties whose name
   * is not an array index are ignored. When passing arrays and objects, the
   * entire reference graph will be converted and transferred. If the reference
   * graph has cycles, the message will not be sent and an error will be logged
   * to the console.
   *
   * The following JavaScript code invokes <code>HandleMessage</code>, passing
   * the module instance on which it was invoked, with <code>message</code>
   * being a string <code>PP_Var</code> containing "Hello world!"
   *
   * <strong>Example:</strong>
   *
   * @code
   *
   * <body>
   *   <object id="plugin"
   *           type="application/x-ppapi-postMessage-example"/>
   *   <script type="text/javascript">
   *     document.getElementById('plugin').postMessage("Hello world!");
   *   </script>
   * </body>
   *
   * @endcode
   *
   */
  void (*HandleMessage)(PP_Instance instance, struct PP_Var message);
};

typedef struct PPP_Messaging_1_0 PPP_Messaging;
/**
 * @}
 */

/* ppp_mouse_lock.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPP_MouseLock</code> interface contains a function that you must
 * implement to receive mouse lock events from the browser.
 */
struct PPP_MouseLock_1_0 {
  /**
   * MouseLockLost() is called when the instance loses the mouse lock, such as
   * when the user presses the ESC key.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying one instance
   * of a module.
   */
  void (*MouseLockLost)(PP_Instance instance);
};

typedef struct PPP_MouseLock_1_0 PPP_MouseLock;
/**
 * @}
 */

/* trusted/ppb_broker_trusted.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The PPB_BrokerTrusted interface provides access to a trusted broker
 * with greater privileges than the plugin. The interface only supports
 * out-of-process plugins and is to be used by proxy implementations.  All
 * functions should be called from the main thread only.
 *
 * A PPB_BrokerTrusted resource represents a connection to the broker. Its
 * lifetime controls the lifetime of the broker, regardless of whether the
 * handle is closed. The handle should be closed before the resource is
 * released.
 */
struct PPB_BrokerTrusted_0_3 {
  /**
   * Returns a trusted broker resource.
   */
  PP_Resource (*CreateTrusted)(PP_Instance instance);
  /**
   * Returns true if the resource is a trusted broker.
   */
  PP_Bool (*IsBrokerTrusted)(PP_Resource resource);
  /**
   * Connects to the trusted broker. It may have already
   * been launched by another instance.
   * The plugin takes ownership of the handle once the callback has been called
   * with a result of PP_OK. The plugin should immediately call GetHandle and
   * begin managing it. If the result is not PP_OK, the browser still owns the
   * handle.
   *
   * Returns PP_ERROR_WOULD_BLOCK on success, and invokes
   * the |connect_callback| asynchronously to complete.
   * As this function should always be invoked from the main thread,
   * do not use the blocking variant of PP_CompletionCallback.
   * Returns PP_ERROR_FAILED if called from an in-process plugin.
   */
  int32_t (*Connect)(PP_Resource broker,
                     struct PP_CompletionCallback connect_callback);
  /**
   * Gets the handle to the pipe. Use once Connect has completed. Each instance
   * of this interface has its own pipe.
   *
   * Returns PP_OK on success, and places the result into the given output
   * parameter. The handle is only set when returning PP_OK. Calling this
   * before connect has completed will return PP_ERROR_FAILED.
   */
  int32_t (*GetHandle)(PP_Resource broker, int32_t* handle);
  /**
   * Returns PP_TRUE if the plugin has permission to launch the broker. A user
   * must explicitly grant permission to launch the broker for a particular
   * website. This is done through an infobar that is displayed when |Connect|
   * is called. This function returns PP_TRUE if the user has already granted
   * permission to launch the broker for the website containing this plugin
   * instance. Returns PP_FALSE otherwise.
   */
  PP_Bool (*IsAllowed)(PP_Resource broker);
};

typedef struct PPB_BrokerTrusted_0_3 PPB_BrokerTrusted;

struct PPB_BrokerTrusted_0_2 {
  PP_Resource (*CreateTrusted)(PP_Instance instance);
  PP_Bool (*IsBrokerTrusted)(PP_Resource resource);
  int32_t (*Connect)(PP_Resource broker,
                     struct PP_CompletionCallback connect_callback);
  int32_t (*GetHandle)(PP_Resource broker, int32_t* handle);
};
/**
 * @}
 */

/* trusted/ppb_browser_font_trusted.idl */
/**
 * @addtogroup Enums
 * @{
 */
typedef enum {
  /**
   * Uses the user's default web page font (normally either the default serif
   * or sans serif font).
   */
  PP_BROWSERFONT_TRUSTED_FAMILY_DEFAULT = 0,
  /**
   * These families will use the default web page font corresponding to the
   * given family.
   */
  PP_BROWSERFONT_TRUSTED_FAMILY_SERIF = 1,
  PP_BROWSERFONT_TRUSTED_FAMILY_SANSSERIF = 2,
  PP_BROWSERFONT_TRUSTED_FAMILY_MONOSPACE = 3
} PP_BrowserFont_Trusted_Family;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_BrowserFont_Trusted_Family, 4);

/**
 * Specifies the font weight. Normally users will only use NORMAL or BOLD.
 */
typedef enum {
  PP_BROWSERFONT_TRUSTED_WEIGHT_100 = 0,
  PP_BROWSERFONT_TRUSTED_WEIGHT_200 = 1,
  PP_BROWSERFONT_TRUSTED_WEIGHT_300 = 2,
  PP_BROWSERFONT_TRUSTED_WEIGHT_400 = 3,
  PP_BROWSERFONT_TRUSTED_WEIGHT_500 = 4,
  PP_BROWSERFONT_TRUSTED_WEIGHT_600 = 5,
  PP_BROWSERFONT_TRUSTED_WEIGHT_700 = 6,
  PP_BROWSERFONT_TRUSTED_WEIGHT_800 = 7,
  PP_BROWSERFONT_TRUSTED_WEIGHT_900 = 8,
  PP_BROWSERFONT_TRUSTED_WEIGHT_NORMAL = PP_BROWSERFONT_TRUSTED_WEIGHT_400,
  PP_BROWSERFONT_TRUSTED_WEIGHT_BOLD = PP_BROWSERFONT_TRUSTED_WEIGHT_700
} PP_BrowserFont_Trusted_Weight;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_BrowserFont_Trusted_Weight, 4);
/**
 * @}
 */

/**
 * @addtogroup Structs
 * @{
 */
struct PP_BrowserFont_Trusted_Description {
  /**
   * Font face name as a string. This can also be an undefined var, in which
   * case the generic family will be obeyed. If the face is not available on
   * the system, the browser will attempt to do font fallback or pick a default
   * font.
   */
  struct PP_Var face;
  /**
   * When Create()ing a font and the face is an undefined var, the family
   * specifies the generic font family type to use. If the face is specified,
   * this will be ignored.
   *
   * When Describe()ing a font, the family will be the value you passed in when
   * the font was created. In other words, if you specify a face name, the
   * family will not be updated to reflect whether the font name you requested
   * is serif or sans serif.
   */
  PP_BrowserFont_Trusted_Family family;
  /**
   * Size in pixels.
   *
   * You can specify 0 to get the default font size. The default font size
   * may vary depending on the requested font. The typical example is that
   * the user may have a different font size for the default monospace font to
   * give it a similar optical size to the proportionally spaced fonts.
   */
  uint32_t size;
  /**
   * Normally you will use either normal or bold.
   */
  PP_BrowserFont_Trusted_Weight weight;
  PP_Bool italic;
  PP_Bool small_caps;
  /**
   * Adjustment to apply to letter and word spacing, respectively. Initialize
   * to 0 to get normal spacing. Negative values bring letters/words closer
   * together, positive values separate them.
   */
  int32_t letter_spacing;
  int32_t word_spacing;
  /**
   * Ensure that this struct is 48-bytes wide by padding the end.  In some
   * compilers, PP_Var is 8-byte aligned, so those compilers align this struct
   * on 8-byte boundaries as well and pad it to 16 bytes even without this
   * padding attribute.  This padding makes its size consistent across
   * compilers.
   */
  int32_t padding;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_BrowserFont_Trusted_Description, 48);

struct PP_BrowserFont_Trusted_Metrics {
  int32_t height;
  int32_t ascent;
  int32_t descent;
  int32_t line_spacing;
  int32_t x_height;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_BrowserFont_Trusted_Metrics, 20);

struct PP_BrowserFont_Trusted_TextRun {
  /**
   * This var must either be a string or a null/undefined var (which will be
   * treated as a 0-length string).
   */
  struct PP_Var text;
  /**
   * Set to PP_TRUE if the text is right-to-left.
   */
  PP_Bool rtl;
  /**
   * Set to PP_TRUE to force the directionality of the text regardless of
   * content
   */
  PP_Bool override_direction;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_BrowserFont_Trusted_TextRun, 24);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * Provides an interface for native browser text rendering.
 *
 * This API is "trusted" not for security reasons, but because it can not be
 * implemented efficiently when running out-of-process in Browser Client. In
 * this case, WebKit is in another process and every text call would require a
 * synchronous IPC to the renderer. It is, however, available to native
 * (non-NaCl) out-of-process PPAPI plugins since WebKit is available in the
 * plugin process.
 */
struct PPB_BrowserFont_Trusted_1_0 {
  /**
   * Returns a list of all available font families on the system. You can use
   * this list to decide whether to Create() a font.
   *
   * The return value will be a single string with null characters delimiting
   * the end of each font name. For example: "Arial\0Courier\0Times\0".
   *
   * Returns an undefined var on failure (this typically means you passed an
   * invalid instance).
   */
  struct PP_Var (*GetFontFamilies)(PP_Instance instance);
  /**
   * Returns a font which best matches the given description. The return value
   * will have a non-zero ID on success, or zero on failure.
   */
  PP_Resource (*Create)(
      PP_Instance instance,
      const struct PP_BrowserFont_Trusted_Description* description);
  /**
   * Returns PP_TRUE if the given resource is a Font. Returns PP_FALSE if the
   * resource is invalid or some type other than a Font.
   */
  PP_Bool (*IsFont)(PP_Resource resource);
  /**
   * Loads the description and metrics of the font into the given structures.
   * The description will be different than the description the font was
   * created with since it will be filled with the real values from the font
   * that was actually selected.
   *
   * The PP_Var in the description should be of type Void on input. On output,
   * this will contain the string and will have a reference count of 1. The
   * plugin is responsible for calling Release on this var.
   *
   * Returns PP_TRUE on success, PP_FALSE if the font is invalid or if the Var
   * in the description isn't Null (to prevent leaks).
   */
  PP_Bool (*Describe)(PP_Resource font,
                      struct PP_BrowserFont_Trusted_Description* description,
                      struct PP_BrowserFont_Trusted_Metrics* metrics);
  /**
   * Draws the text to the image buffer.
   *
   * The given point represents the baseline of the left edge of the font,
   * regardless of whether it is left-to-right or right-to-left (in the case of
   * RTL text, this will actually represent the logical end of the text).
   *
   * The clip is optional and may be NULL. In this case, the text will be
   * clipped to the image.
   *
   * The image_data_is_opaque flag indicates whether subpixel antialiasing can
   * be performed, if it is supported. When the image below the text is
   * opaque, subpixel antialiasing is supported and you should set this to
   * PP_TRUE to pick up the user's default preferences. If your plugin is
   * partially transparent, then subpixel antialiasing is not possible and
   * grayscale antialiasing will be used instead (assuming the user has
   * antialiasing enabled at all).
   */
  PP_Bool (*DrawTextAt)(PP_Resource font,
                        PP_Resource image_data,
                        const struct PP_BrowserFont_Trusted_TextRun* text,
                        const struct PP_Point* position,
                        uint32_t color,
                        const struct PP_Rect* clip,
                        PP_Bool image_data_is_opaque);
  /**
   * Returns the width of the given string. If the font is invalid or the var
   * isn't a valid string, this will return -1.
   *
   * Note that this function handles complex scripts such as Arabic, combining
   * accents, etc. so that adding the width of substrings won't necessarily
   * produce the correct width of the entire string.
   *
   * Returns -1 on failure.
   */
  int32_t (*MeasureText)(PP_Resource font,
                         const struct PP_BrowserFont_Trusted_TextRun* text);
  /**
   * Returns the character at the given pixel X position from the beginning of
   * the string. This handles complex scripts such as Arabic, where characters
   * may be combined or replaced depending on the context. Returns (uint32)-1
   * on failure.
   *
   * TODO(brettw) this function may be broken. See the CharPosRTL test. It
   * seems to tell you "insertion point" rather than painting position. This
   * is useful but maybe not what we intended here.
   */
  uint32_t (*CharacterOffsetForPixel)(
      PP_Resource font,
      const struct PP_BrowserFont_Trusted_TextRun* text,
      int32_t pixel_position);
  /**
   * Returns the horizontal advance to the given character if the string was
   * placed at the given position. This handles complex scripts such as Arabic,
   * where characters may be combined or replaced depending on context. Returns
   * -1 on error.
   */
  int32_t (*PixelOffsetForCharacter)(
      PP_Resource font,
      const struct PP_BrowserFont_Trusted_TextRun* text,
      uint32_t char_offset);
};

typedef struct PPB_BrowserFont_Trusted_1_0 PPB_BrowserFont_Trusted;
/**
 * @}
 */

/* trusted/ppb_char_set_trusted.idl */
/**
 * @addtogroup Enums
 * @{
 */
typedef enum {
  /**
   * Causes the entire conversion to fail if an error is encountered. The
   * conversion function will return NULL.
   */
  PP_CHARSET_TRUSTED_CONVERSIONERROR_FAIL,
  /**
   * Silently skips over errors. Unrepresentable characters and input encoding
   * errors will be removed from the output.
   */
  PP_CHARSET_TRUSTED_CONVERSIONERROR_SKIP,
  /**
   * Replaces the error or unrepresentable character with a substitution
   * character. When converting to a Unicode character set (UTF-8 or UTF-16) it
   * will use the unicode "substitution character" U+FFFD. When converting to
   * another character set, the character will be charset-specific. For many
   * languages this will be the representation of the '?' character.
   */
  PP_CHARSET_TRUSTED_CONVERSIONERROR_SUBSTITUTE
} PP_CharSet_Trusted_ConversionError;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_CharSet_Trusted_ConversionError, 4);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPB_CharSet_Trusted</code> interface provides functions for
 * converting between character sets.
 *
 * This inteface is provided for trusted plugins only since in Native Client it
 * would require an expensive out-of-process IPC call for each conversion,
 * which makes performance unacceptable. Native Client plugins should include
 * ICU or some other library if they need this feature.
 */
struct PPB_CharSet_Trusted_1_0 {
  /**
   * Converts the UTF-16 string pointed to by |*utf16| to an 8-bit string in
   * the specified code page. |utf16_len| is measured in UTF-16 units, not
   * bytes. This value may not be NULL.
   *
   * The given output buffer will be filled up to output_length bytes with the
   * result. output_length will be updated with the number of bytes required
   * for the given string. The output buffer may be null to just retrieve the
   * required buffer length.
   *
   * This function will return PP_FALSE if there was an error converting the
   * string and you requested PP_CHARSET_CONVERSIONERROR_FAIL, or the output
   * character set was unknown. Otherwise, it will return PP_TRUE.
   */
  PP_Bool (*UTF16ToCharSet)(const uint16_t utf16[],
                            uint32_t utf16_len,
                            const char* output_char_set,
                            PP_CharSet_Trusted_ConversionError on_error,
                            char* output_buffer,
                            uint32_t* output_length);
  /**
   * Same as UTF16ToCharSet except converts in the other direction. The input
   * is in the given charset, and the |input_len| is the number of bytes in
   * the |input| string.
   *
   * Note that the output_utf16_length is measured in UTF-16 characters.
   *
   * Since UTF16 can represent every Unicode character, the only time the
   * replacement character will be used is if the encoding in the input string
   * is incorrect.
   */
  PP_Bool (*CharSetToUTF16)(const char* input,
                            uint32_t input_len,
                            const char* input_char_set,
                            PP_CharSet_Trusted_ConversionError on_error,
                            uint16_t* output_buffer,
                            uint32_t* output_utf16_length);
  /**
   * Returns a string var representing the current multi-byte character set of
   * the current system.
   *
   * WARNING: You really shouldn't be using this function unless you're dealing
   * with legacy data. You should be using UTF-8 or UTF-16 and you don't have
   * to worry about the character sets.
   */
  struct PP_Var (*GetDefaultCharSet)(PP_Instance instance);
};

typedef struct PPB_CharSet_Trusted_1_0 PPB_CharSet_Trusted;
/**
 * @}
 */

/* trusted/ppb_file_chooser_trusted.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
struct PPB_FileChooserTrusted_0_6 {
  /**
   * This function displays a previously created file chooser resource as a
   * dialog box, prompting the user to choose a file or files to open, or a
   * single file for saving. The callback is called with PP_OK on successful
   * completion with a file (or files) selected or PP_ERROR_USERCANCEL if the
   * user selected no file.
   *
   * @param[in] chooser The file chooser resource.
   * @param[in] save_as A <code>PP_Bool</code> value indicating if this dialog
   * is choosing a file for saving.
   * @param[in] suggested_file_name If saving, the suggested name for the
   * file, otherwise, null or undefined.
   * @param[in] callback A <code>CompletionCallback</code> to be called after
   * the user has closed the file chooser dialog.
   *
   * @return PP_OK_COMPLETIONPENDING if request to show the dialog was
   * successful, another error code from pp_errors.h on failure.
   */
  int32_t (*ShowWithoutUserGesture)(PP_Resource chooser,
                                    PP_Bool save_as,
                                    struct PP_Var suggested_file_name,
                                    struct PP_ArrayOutput output,
                                    struct PP_CompletionCallback callback);
};

typedef struct PPB_FileChooserTrusted_0_6 PPB_FileChooserTrusted;

struct PPB_FileChooserTrusted_0_5 {
  int32_t (*ShowWithoutUserGesture)(PP_Resource chooser,
                                    PP_Bool save_as,
                                    struct PP_Var suggested_file_name,
                                    struct PP_CompletionCallback callback);
};
/**
 * @}
 */

/* trusted/ppb_url_loader_trusted.idl */
/**
 * @addtogroup Typedefs
 * @{
 */
/**
 * Callback that indicates the status of the download and upload for the
 * given URLLoader resource.
 */
typedef void (*PP_URLLoaderTrusted_StatusCallback)(
    PP_Instance pp_instance,
    PP_Resource pp_resource,
    int64_t bytes_sent,
    int64_t total_bytes_to_be_sent,
    int64_t bytes_received,
    int64_t total_bytes_to_be_received);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
/* Available only to trusted implementations. */
struct PPB_URLLoaderTrusted_0_3 {
  /**
   * Grant this URLLoader the capability to make unrestricted cross-origin
   * requests.
   */
  void (*GrantUniversalAccess)(PP_Resource loader);
  /**
   * Registers that the given function will be called when the upload or
   * downloaded byte count has changed. This is not exposed on the untrusted
   * interface because it can be quite chatty and encourages people to write
   * feedback UIs that update as frequently as the progress updates.
   *
   * The other serious gotcha with this callback is that the callback must not
   * mutate the URL loader or cause it to be destroyed.
   *
   * However, the proxy layer needs this information to push to the other
   * process, so we expose it here. Only one callback can be set per URL
   * Loader. Setting to a NULL callback will disable it.
   */
  void (*RegisterStatusCallback)(PP_Resource loader,
                                 PP_URLLoaderTrusted_StatusCallback cb);
};

typedef struct PPB_URLLoaderTrusted_0_3 PPB_URLLoaderTrusted;
/**
 * @}
 */

/* trusted/ppp_broker.idl */
// {PENDING: undefine PP_EXPORT?}

#include "ppapi/c/pp_instance.h"
#include "ppapi/c/pp_stdint.h"


#if __GNUC__ >= 4

#define PP_EXPORT __attribute__ ((visibility("default")))
#elif defined(_MSC_VER)
#define PP_EXPORT __declspec(dllexport)
#endif



/* We don't want name mangling for these external functions.  We only need
 * 'extern "C"' if we're compiling with a C++ compiler.
 */
#ifdef __cplusplus
extern "C" {
#endif

/**
 * @addtogroup Typedefs
 * @{
 */

/**
 * PP_ConnectInstance_Func defines the signature that you implement to
 * receive notifications when a plugin instance connects to the broker.
 * The broker should listen on the socket before returning.
 *
 * @param[in] instance The plugin instance connecting to the broker.
 * @param[in] handle Handle to a socket the broker can use to communicate with
 * the plugin.
 * @return PP_OK on success. Any other value on failure.
 */
typedef int32_t (*PP_ConnectInstance_Func)(PP_Instance instance,
                                           int32_t handle);
/**
 * @}
 */

/**
 * @addtogroup Functions
 * @{
 */

/**
 * PPP_InitializeBroker() is the entry point for a broker and is
 * called by the browser when your module loads. Your code must implement this
 * function.
 *
 * Failure indicates to the browser that this broker can not be used. In this
 * case, the broker will be unloaded.
 *
 * @param[out] connect_instance_func A pointer to a connect instance function.
 * @return PP_OK on success. Any other value on failure.
*/
PP_EXPORT int32_t PPP_InitializeBroker(
    PP_ConnectInstance_Func* connect_instance_func);
/**
 * @}
 */

/**
 * @addtogroup Functions
 * @{
 */

/** PPP_ShutdownBroker() is called before the broker is unloaded.
 */
PP_EXPORT void PPP_ShutdownBroker();
/**
 * @}
 */

#ifdef __cplusplus
}  /* extern "C" */
#endif

/* dev/pp_cursor_type_dev.idl */
/**
 * @addtogroup Enums
 * @{
 */
enum PP_CursorType_Dev {
  PP_CURSORTYPE_CUSTOM = -1,
  PP_CURSORTYPE_POINTER = 0,
  PP_CURSORTYPE_CROSS = 1,
  PP_CURSORTYPE_HAND = 2,
  PP_CURSORTYPE_IBEAM = 3,
  PP_CURSORTYPE_WAIT = 4,
  PP_CURSORTYPE_HELP = 5,
  PP_CURSORTYPE_EASTRESIZE = 6,
  PP_CURSORTYPE_NORTHRESIZE = 7,
  PP_CURSORTYPE_NORTHEASTRESIZE = 8,
  PP_CURSORTYPE_NORTHWESTRESIZE = 9,
  PP_CURSORTYPE_SOUTHRESIZE = 10,
  PP_CURSORTYPE_SOUTHEASTRESIZE = 11,
  PP_CURSORTYPE_SOUTHWESTRESIZE = 12,
  PP_CURSORTYPE_WESTRESIZE = 13,
  PP_CURSORTYPE_NORTHSOUTHRESIZE = 14,
  PP_CURSORTYPE_EASTWESTRESIZE = 15,
  PP_CURSORTYPE_NORTHEASTSOUTHWESTRESIZE = 16,
  PP_CURSORTYPE_NORTHWESTSOUTHEASTRESIZE = 17,
  PP_CURSORTYPE_COLUMNRESIZE = 18,
  PP_CURSORTYPE_ROWRESIZE = 19,
  PP_CURSORTYPE_MIDDLEPANNING = 20,
  PP_CURSORTYPE_EASTPANNING = 21,
  PP_CURSORTYPE_NORTHPANNING = 22,
  PP_CURSORTYPE_NORTHEASTPANNING = 23,
  PP_CURSORTYPE_NORTHWESTPANNING = 24,
  PP_CURSORTYPE_SOUTHPANNING = 25,
  PP_CURSORTYPE_SOUTHEASTPANNING = 26,
  PP_CURSORTYPE_SOUTHWESTPANNING = 27,
  PP_CURSORTYPE_WESTPANNING = 28,
  PP_CURSORTYPE_MOVE = 29,
  PP_CURSORTYPE_VERTICALTEXT = 30,
  PP_CURSORTYPE_CELL = 31,
  PP_CURSORTYPE_CONTEXTMENU = 32,
  PP_CURSORTYPE_ALIAS = 33,
  PP_CURSORTYPE_PROGRESS = 34,
  PP_CURSORTYPE_NODROP = 35,
  PP_CURSORTYPE_COPY = 36,
  PP_CURSORTYPE_NONE = 37,
  PP_CURSORTYPE_NOTALLOWED = 38,
  PP_CURSORTYPE_ZOOMIN = 39,
  PP_CURSORTYPE_ZOOMOUT = 40,
  PP_CURSORTYPE_GRAB = 41,
  PP_CURSORTYPE_GRABBING = 42
};
PP_COMPILE_ASSERT_ENUM_SIZE_IN_BYTES(PP_CursorType_Dev, 4);
/**
 * @}
 */

/* dev/pp_print_settings_dev.idl */
/**
 * @addtogroup Enums
 * @{
 */
typedef enum {
  PP_PRINTORIENTATION_NORMAL = 0,
  PP_PRINTORIENTATION_ROTATED_90_CW = 1,
  PP_PRINTORIENTATION_ROTATED_180 = 2,
  PP_PRINTORIENTATION_ROTATED_90_CCW = 3
} PP_PrintOrientation_Dev;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_PrintOrientation_Dev, 4);

typedef enum {
  PP_PRINTOUTPUTFORMAT_RASTER = 1u << 0,
  PP_PRINTOUTPUTFORMAT_PDF = 1u << 1,
  PP_PRINTOUTPUTFORMAT_POSTSCRIPT = 1u << 2,
  PP_PRINTOUTPUTFORMAT_EMF = 1u << 3
} PP_PrintOutputFormat_Dev;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_PrintOutputFormat_Dev, 4);

typedef enum {
  PP_PRINTSCALINGOPTION_NONE = 0,
  PP_PRINTSCALINGOPTION_FIT_TO_PRINTABLE_AREA = 1,
  PP_PRINTSCALINGOPTION_SOURCE_SIZE = 2
} PP_PrintScalingOption_Dev;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_PrintScalingOption_Dev, 4);
/**
 * @}
 */

/**
 * @addtogroup Structs
 * @{
 */
struct PP_PrintSettings_Dev {
  /** This is the size of the printable area in points (1/72 of an inch). */
  struct PP_Rect printable_area;
  struct PP_Rect content_area;
  struct PP_Size paper_size;
  int32_t dpi;
  PP_PrintOrientation_Dev orientation;
  PP_PrintScalingOption_Dev print_scaling_option;
  PP_Bool grayscale;
  /** Note that Chrome currently only supports PDF printing. */
  PP_PrintOutputFormat_Dev format;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_PrintSettings_Dev, 60);
/**
 * @}
 */

/* dev/pp_video_capture_dev.idl */
/**
 * @addtogroup Structs
 * @{
 */
/**
 * PP_VideoCaptureDeviceInfo_Dev is a structure that represent a video capture
 * configuration, such as resolution and frame rate.
 */
struct PP_VideoCaptureDeviceInfo_Dev {
  uint32_t width;
  uint32_t height;
  uint32_t frames_per_second;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_VideoCaptureDeviceInfo_Dev, 12);
/**
 * @}
 */

/**
 * @addtogroup Enums
 * @{
 */
/**
 * PP_VideoCaptureStatus_Dev is an enumeration that defines the various possible
 * states of a VideoCapture.
 */
typedef enum {
  /**
   * Initial state, capture is stopped.
   */
  PP_VIDEO_CAPTURE_STATUS_STOPPED = 0,
  /**
   * StartCapture has been called, but capture hasn't started yet.
   */
  PP_VIDEO_CAPTURE_STATUS_STARTING = 1,
  /**
   * Capture has been started.
   */
  PP_VIDEO_CAPTURE_STATUS_STARTED = 2,
  /**
   * Capture has been started, but is paused because no buffer is available.
   */
  PP_VIDEO_CAPTURE_STATUS_PAUSED = 3,
  /**
   * StopCapture has been called, but capture hasn't stopped yet.
   */
  PP_VIDEO_CAPTURE_STATUS_STOPPING = 4
} PP_VideoCaptureStatus_Dev;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_VideoCaptureStatus_Dev, 4);
/**
 * @}
 */

/* dev/pp_video_dev.idl */
/**
 * @addtogroup Enums
 * @{
 */
/**
 * Video format.
 *
 * Keep the values in this enum unique, as they imply format (h.264 vs. VP8,
 * for example), and keep the values for a particular format grouped together
 * for clarity.
 * Note: Keep these in sync with media::VideoCodecProfile.
 */
typedef enum {
  PP_VIDEODECODER_PROFILE_UNKNOWN = -1,
  PP_VIDEODECODER_H264PROFILE_NONE = 0,
  PP_VIDEODECODER_H264PROFILE_BASELINE = 1,
  PP_VIDEODECODER_H264PROFILE_MAIN = 2,
  PP_VIDEODECODER_H264PROFILE_EXTENDED = 3,
  PP_VIDEODECODER_H264PROFILE_HIGH = 4,
  PP_VIDEODECODER_H264PROFILE_HIGH10PROFILE = 5,
  PP_VIDEODECODER_H264PROFILE_HIGH422PROFILE = 6,
  PP_VIDEODECODER_H264PROFILE_HIGH444PREDICTIVEPROFILE = 7,
  PP_VIDEODECODER_H264PROFILE_SCALABLEBASELINE = 8,
  PP_VIDEODECODER_H264PROFILE_SCALABLEHIGH = 9,
  PP_VIDEODECODER_H264PROFILE_STEREOHIGH = 10,
  PP_VIDEODECODER_H264PROFILE_MULTIVIEWHIGH = 11,
  PP_VIDEODECODER_VP8PROFILE_ANY = 12
} PP_VideoDecoder_Profile;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_VideoDecoder_Profile, 4);
/**
 * @}
 */

/**
 * @addtogroup Structs
 * @{
 */
/**
 * The data structure for video bitstream buffer.
 */
struct PP_VideoBitstreamBuffer_Dev {
  /**
   * Client-specified identifier for the bitstream buffer. Valid values are
   * non-negative.
   */
  int32_t id;
  /**
   * Buffer to hold the bitstream data. Should be allocated using the
   * PPB_Buffer interface for consistent interprocess behaviour.
   */
  PP_Resource data;
  /**
   * Size of the bitstream contained in buffer (in bytes).
   */
  uint32_t size;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_VideoBitstreamBuffer_Dev, 12);

/**
 * Struct for specifying texture-backed picture data.
 */
struct PP_PictureBuffer_Dev {
  /**
   * Client-specified id for the picture buffer. By using this value client can
   * keep track of the buffers it has assigned to the video decoder and how they
   * are passed back to it. Valid values are non-negative.
   */
  int32_t id;
  /**
   * Dimensions of the buffer.
   */
  struct PP_Size size;
  /**
   * Texture ID in the given context where picture is stored.
   */
  uint32_t texture_id;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_PictureBuffer_Dev, 16);

/**
 * Structure to describe a decoded output frame.
 */
struct PP_Picture_Dev {
  /**
   * ID of the picture buffer where the picture is stored.
   */
  int32_t picture_buffer_id;
  /**
   * ID of the bitstream from which this data was decoded.
   */
  int32_t bitstream_buffer_id;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_Picture_Dev, 8);
/**
 * @}
 */

/**
 * @addtogroup Enums
 * @{
 */
/**
 * Decoder error codes reported to the plugin. A reasonable naive
 * error handling policy is for the plugin to Destroy() the decoder on error.
 */
typedef enum {
  /**
   * An operation was attempted during an incompatible decoder state.
   */
  PP_VIDEODECODERERROR_ILLEGAL_STATE = 1,
  /**
   * Invalid argument was passed to an API method.
   */
  PP_VIDEODECODERERROR_INVALID_ARGUMENT = 2,
  /**
   * Encoded input is unreadable.
   */
  PP_VIDEODECODERERROR_UNREADABLE_INPUT = 3,
  /**
   * A failure occurred at the browser layer or lower.  Examples of such
   * failures include GPU hardware failures, GPU driver failures, GPU library
   * failures, browser programming errors, and so on.
   */
  PP_VIDEODECODERERROR_PLATFORM_FAILURE = 4
} PP_VideoDecodeError_Dev;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_VideoDecodeError_Dev, 4);
/**
 * @}
 */

/* dev/ppb_device_ref_dev.idl */
/**
 * @addtogroup Typedefs
 * @{
 */
/**
 * Defines the callback type to receive device change notifications for
 * <code>PPB_AudioInput_Dev.MonitorDeviceChange()</code> and
 * <code>PPB_VideoCapture_Dev.MonitorDeviceChange()</code>.
 *
 * @param[inout] user_data The opaque pointer that the caller passed into
 * <code>MonitorDeviceChange()</code>.
 * @param[in] device_count How many devices in the array.
 * @param[in] devices An array of <code>PPB_DeviceRef_Dev</code>. Please note
 * that the ref count of the elements is not increased on behalf of the plugin.
 */
typedef void (*PP_MonitorDeviceChangeCallback)(void* user_data,
                                               uint32_t device_count,
                                               const PP_Resource devices[]);
/**
 * @}
 */

/**
 * @addtogroup Enums
 * @{
 */
/**
 * Device types.
 */
typedef enum {
  PP_DEVICETYPE_DEV_INVALID = 0,
  PP_DEVICETYPE_DEV_AUDIOCAPTURE = 1,
  PP_DEVICETYPE_DEV_VIDEOCAPTURE = 2
} PP_DeviceType_Dev;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_DeviceType_Dev, 4);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
struct PPB_DeviceRef_Dev_0_1 {
  /**
   * Determines if the provided resource is a device reference.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to a generic
   * resource.
   *
   * @return A <code>PP_Bool</code> that is <code>PP_TRUE</code> if the given
   * resource is a device reference, otherwise <code>PP_FALSE</code>.
   */
  PP_Bool (*IsDeviceRef)(PP_Resource resource);
  /**
   * Gets the device type.
   *
   * @param[in] device_ref A <code>PP_Resource</code> corresponding to a device
   * reference.
   *
   * @return A <code>PP_DeviceType_Dev</code> value.
   */
  PP_DeviceType_Dev (*GetType)(PP_Resource device_ref);
  /**
   * Gets the device name.
   *
   * @param[in] device_ref A <code>PP_Resource</code> corresponding to a device
   * reference.
   *
   * @return A <code>PP_Var</code> of type <code>PP_VARTYPE_STRING</code>
   * containing the name of the device if successful; a <code>PP_Var</code> of
   * type <code>PP_VARTYPE_UNDEFINED</code> if failed.
   */
  struct PP_Var (*GetName)(PP_Resource device_ref);
};

typedef struct PPB_DeviceRef_Dev_0_1 PPB_DeviceRef_Dev;
/**
 * @}
 */

/* dev/ppb_audio_input_dev.idl */
/**
 * @addtogroup Typedefs
 * @{
 */
/**
 * <code>PPB_AudioInput_Callback</code> defines the type of an audio callback
 * function used to provide the audio buffer with data. This callback will be
 * called on a separate thread from the creation thread.
 *
 * @param[in] sample_buffer A buffer providing audio input data.
 * @param[in] buffer_size_in_bytes The size of the buffer in bytes.
 * @param[in] latency The time that has elapsed since the data was recorded.
 * @param[inout] user_data An opaque pointer that was passed into
 * <code>PPB_AudioInput_Dev.Open()</code>.
 */
typedef void (*PPB_AudioInput_Callback)(const void* sample_buffer,
                                        uint32_t buffer_size_in_bytes,
                                        PP_TimeDelta latency,
                                        void* user_data);

typedef void (*PPB_AudioInput_Callback_0_3)(const void* sample_buffer,
                                            uint32_t buffer_size_in_bytes,
                                            void* user_data);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPB_AudioInput_Dev</code> interface contains pointers to several
 * functions for handling audio input resources.
 *
 * TODO(brettw) before moving out of dev, we need to resolve the issue of
 * the mismatch between the current audio config interface and this one.
 *
 * In particular, the params for input assume stereo, but this class takes
 * everything as mono. We either need to not use an audio config resource, or
 * add mono support.
 *
 * In addition, RecommendSampleFrameCount is completely wrong for audio input.
 * RecommendSampleFrameCount returns the frame count for the current
 * low-latency output device, which is likely inappropriate for a random input
 * device. We may want to move the "recommend" functions to the input or output
 * classes rather than the config.
 */
struct PPB_AudioInput_Dev_0_4 {
  /**
   * Creates an audio input resource.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying one instance of
   * a module.
   *
   * @return A <code>PP_Resource</code> corresponding to an audio input resource
   * if successful, 0 if failed.
   */
  PP_Resource (*Create)(PP_Instance instance);
  /**
   * Determines if the given resource is an audio input resource.
   *
   * @param[in] resource A <code>PP_Resource</code> containing a resource.
   *
   * @return A <code>PP_Bool</code> containing <code>PP_TRUE</code> if the given
   * resource is an audio input resource, otherwise <code>PP_FALSE</code>.
   */
  PP_Bool (*IsAudioInput)(PP_Resource resource);
  /**
   * Enumerates audio input devices.
   *
   * @param[in] audio_input A <code>PP_Resource</code> corresponding to an audio
   * input resource.
   * @param[in] output An output array which will receive
   * <code>PPB_DeviceRef_Dev</code> resources on success. Please note that the
   * ref count of those resources has already been increased by 1 for the
   * caller.
   * @param[in] callback A <code>PP_CompletionCallback</code> to run on
   * completion.
   *
   * @return An error code from <code>pp_errors.h</code>.
   */
  int32_t (*EnumerateDevices)(PP_Resource audio_input,
                              struct PP_ArrayOutput output,
                              struct PP_CompletionCallback callback);
  /**
   * Requests device change notifications.
   *
   * @param[in] audio_input A <code>PP_Resource</code> corresponding to an audio
   * input resource.
   * @param[in] callback The callback to receive notifications. If not NULL, it
   * will be called once for the currently available devices, and then every
   * time the list of available devices changes. All calls will happen on the
   * same thread as the one on which MonitorDeviceChange() is called. It will
   * receive notifications until <code>audio_input</code> is destroyed or
   * <code>MonitorDeviceChange()</code> is called to set a new callback for
   * <code>audio_input</code>. You can pass NULL to cancel sending
   * notifications.
   * @param[inout] user_data An opaque pointer that will be passed to
   * <code>callback</code>.
   *
   * @return An error code from <code>pp_errors.h</code>.
   */
  int32_t (*MonitorDeviceChange)(PP_Resource audio_input,
                                 PP_MonitorDeviceChangeCallback callback,
                                 void* user_data);
  /**
   * Opens an audio input device. No sound will be captured until
   * StartCapture() is called.
   *
   * @param[in] audio_input A <code>PP_Resource</code> corresponding to an audio
   * input resource.
   * @param[in] device_ref Identifies an audio input device. It could be one of
   * the resource in the array returned by EnumerateDevices(), or 0 which means
   * the default device.
   * @param[in] config A <code>PPB_AudioConfig</code> audio configuration
   * resource.
   * @param[in] audio_input_callback A <code>PPB_AudioInput_Callback</code>
   * function that will be called when data is available.
   * @param[inout] user_data An opaque pointer that will be passed into
   * <code>audio_input_callback</code>.
   * @param[in] callback A <code>PP_CompletionCallback</code> to run when this
   * open operation is completed.
   *
   * @return An error code from <code>pp_errors.h</code>.
   */
  int32_t (*Open)(PP_Resource audio_input,
                  PP_Resource device_ref,
                  PP_Resource config,
                  PPB_AudioInput_Callback audio_input_callback,
                  void* user_data,
                  struct PP_CompletionCallback callback);
  /**
   * Returns an audio config resource for the given audio input resource.
   *
   * @param[in] audio_input A <code>PP_Resource</code> corresponding to an audio
   * input resource.
   *
   * @return A <code>PP_Resource</code> containing the audio config resource if
   * successful.
   */
  PP_Resource (*GetCurrentConfig)(PP_Resource audio_input);
  /**
   * Starts the capture of the audio input resource and begins periodically
   * calling the callback.
   *
   * @param[in] audio_input A <code>PP_Resource</code> corresponding to an audio
   * input resource.
   *
   * @return A <code>PP_Bool</code> containing <code>PP_TRUE</code> if
   * successful, otherwise <code>PP_FALSE</code>.
   * Also returns <code>PP_TRUE</code> (and is a no-op) if called while capture
   * is already started.
   */
  PP_Bool (*StartCapture)(PP_Resource audio_input);
  /**
   * Stops the capture of the audio input resource.
   *
   * @param[in] audio_input A PP_Resource containing the audio input resource.
   *
   * @return A <code>PP_Bool</code> containing <code>PP_TRUE</code> if
   * successful, otherwise <code>PP_FALSE</code>.
   * Also returns <code>PP_TRUE</code> (and is a no-op) if called while capture
   * is already stopped. If a buffer is being captured, StopCapture will block
   * until the call completes.
   */
  PP_Bool (*StopCapture)(PP_Resource audio_input);
  /**
   * Closes the audio input device, and stops capturing if necessary. It is
   * not valid to call Open() again after a call to this method.
   * If an audio input resource is destroyed while a device is still open, then
   * it will be implicitly closed, so you are not required to call this method.
   *
   * @param[in] audio_input A <code>PP_Resource</code> corresponding to an audio
   * input resource.
   */
  void (*Close)(PP_Resource audio_input);
};

typedef struct PPB_AudioInput_Dev_0_4 PPB_AudioInput_Dev;

struct PPB_AudioInput_Dev_0_3 {
  PP_Resource (*Create)(PP_Instance instance);
  PP_Bool (*IsAudioInput)(PP_Resource resource);
  int32_t (*EnumerateDevices)(PP_Resource audio_input,
                              struct PP_ArrayOutput output,
                              struct PP_CompletionCallback callback);
  int32_t (*MonitorDeviceChange)(PP_Resource audio_input,
                                 PP_MonitorDeviceChangeCallback callback,
                                 void* user_data);
  int32_t (*Open)(PP_Resource audio_input,
                  PP_Resource device_ref,
                  PP_Resource config,
                  PPB_AudioInput_Callback_0_3 audio_input_callback,
                  void* user_data,
                  struct PP_CompletionCallback callback);
  PP_Resource (*GetCurrentConfig)(PP_Resource audio_input);
  PP_Bool (*StartCapture)(PP_Resource audio_input);
  PP_Bool (*StopCapture)(PP_Resource audio_input);
  void (*Close)(PP_Resource audio_input);
};
/**
 * @}
 */

/* dev/ppb_buffer_dev.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
struct PPB_Buffer_Dev_0_4 {
  /**
   * Allocates a buffer of the given size in bytes. The return value will have
   * a non-zero ID on success, or zero on failure. Failure means the module
   * handle was invalid. The buffer will be initialized to contain zeroes.
   */
  PP_Resource (*Create)(PP_Instance instance, uint32_t size_in_bytes);
  /**
   * Returns PP_TRUE if the given resource is a Buffer. Returns PP_FALSE if the
   * resource is invalid or some type other than a Buffer.
   */
  PP_Bool (*IsBuffer)(PP_Resource resource);
  /**
   * Gets the size of the buffer. Returns PP_TRUE on success, PP_FALSE
   * if the resource is not a buffer. On failure, |*size_in_bytes| is not set.
   */
  PP_Bool (*Describe)(PP_Resource resource, uint32_t* size_in_bytes);
  /**
   * Maps this buffer into the plugin address space and returns a pointer to
   * the beginning of the data.
   */
  void* (*Map)(PP_Resource resource);
  /**
   * Unmaps this buffer.
   */
  void (*Unmap)(PP_Resource resource);
};

typedef struct PPB_Buffer_Dev_0_4 PPB_Buffer_Dev;
/**
 * @}
 */

/* dev/ppb_char_set_dev.idl */
/**
 * @addtogroup Enums
 * @{
 */
typedef enum {
  /**
   * Causes the entire conversion to fail if an error is encountered. The
   * conversion function will return NULL.
   */
  PP_CHARSET_CONVERSIONERROR_FAIL,
  /**
   * Silently skips over errors. Unrepresentable characters and input encoding
   * errors will be removed from the output.
   */
  PP_CHARSET_CONVERSIONERROR_SKIP,
  /**
   * Replaces the error or unrepresentable character with a substitution
   * character. When converting to a Unicode character set (UTF-8 or UTF-16) it
   * will use the unicode "substitution character" U+FFFD. When converting to
   * another character set, the character will be charset-specific. For many
   * languages this will be the representation of the '?' character.
   */
  PP_CHARSET_CONVERSIONERROR_SUBSTITUTE
} PP_CharSet_ConversionError;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_CharSet_ConversionError, 4);
/**
 * @}
 */


typedef uint16_t* uint16_ptr_t;


/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPB_CharSet_Trusted</code> interface provides functions for
 * converting between character sets.
 *
 * This inteface is provided for trusted plugins only since in Native Client it
 * would require an expensive out-of-process IPC call for each conversion,
 * which makes performance unacceptable. Native Client plugins should include
 * ICU or some other library if they need this feature.
 */
struct PPB_CharSet_Dev_0_4 {
  /**
   * Converts the UTF-16 string pointed to by |*utf16| to an 8-bit string in
   * the specified code page. |utf16_len| is measured in UTF-16 units, not
   * bytes. This value may not be NULL.
   *
   * The given output buffer will be filled up to output_length bytes with the
   * result. output_length will be updated with the number of bytes required
   * for the given string. The output buffer may be null to just retrieve the
   * required buffer length.
   *
   * This function will return PP_FALSE if there was an error converting the
   * string and you requested PP_CHARSET_CONVERSIONERROR_FAIL, or the output
   * character set was unknown. Otherwise, it will return PP_TRUE.
   */
  const char* (*UTF16ToCharSet)(PP_Instance instance,
                                const uint16_t utf16[],
                                uint32_t utf16_len,
                                const char* output_char_set,
                                PP_CharSet_ConversionError on_error,
                                uint32_t* output_length);
  /**
   * Same as UTF16ToCharSet except converts in the other direction. The input
   * is in the given charset, and the |input_len| is the number of bytes in
   * the |input| string.
   *
   * Note that the output_utf16_length is measured in UTF-16 characters.
   *
   * Since UTF16 can represent every Unicode character, the only time the
   * replacement character will be used is if the encoding in the input string
   * is incorrect.
   */
  uint16_ptr_t (*CharSetToUTF16)(PP_Instance instance,
                                 const char* input,
                                 uint32_t input_len,
                                 const char* input_char_set,
                                 PP_CharSet_ConversionError on_error,
                                 uint32_t* output_utf16_length);
  /**
   * Returns a string var representing the current multi-byte character set of
   * the current system.
   *
   * WARNING: You really shouldn't be using this function unless you're dealing
   * with legacy data. You should be using UTF-8 or UTF-16 and you don't have
   * to worry about the character sets.
   */
  struct PP_Var (*GetDefaultCharSet)(PP_Instance instance);
};

typedef struct PPB_CharSet_Dev_0_4 PPB_CharSet_Dev;
/**
 * @}
 */

/* dev/ppb_crypto_dev.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
struct PPB_Crypto_Dev_0_1 {
  /**
   * Fills the given buffer with random bytes. This is potentially slow so only
   * request the amount of data you need.
   */
  void (*GetRandomBytes)(char* buffer, uint32_t num_bytes);
};

typedef struct PPB_Crypto_Dev_0_1 PPB_Crypto_Dev;
/**
 * @}
 */

/* dev/ppb_cursor_control_dev.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
struct PPB_CursorControl_Dev_0_4 {
  /**
   * Set a cursor.  If "type" is PP_CURSORTYPE_CUSTOM, then "custom_image"
   * must be an ImageData resource containing the cursor and "hot_spot" must
   * contain the offset within that image that refers to the cursor's position.
   */
  PP_Bool (*SetCursor)(PP_Instance instance,
                       enum PP_CursorType_Dev type,
                       PP_Resource custom_image,
                       const struct PP_Point* hot_spot);
  /**
   * This method causes the cursor to be moved to the center of the
   * instance and be locked, preventing the user from moving it.
   * The cursor is implicitly hidden from the user while locked.
   * Cursor lock may only be requested in response to a
   * PP_InputEvent_MouseDown, and then only if the event was generated via
   * user gesture.
   *
   * While the cursor is locked, any movement of the mouse will
   * generate a PP_InputEvent_Type_MouseMove, whose x and y values
   * indicate the position the cursor would have been moved to had
   * the cursor not been locked, and had the screen been infinite in size.
   *
   * The browser may revoke cursor lock for reasons including but not
   * limited to the user pressing the ESC key, the user activating
   * another program via a reserved keystroke (e.g., ALT+TAB), or
   * some other system event.
   *
   * Returns PP_TRUE if the cursor could be locked, PP_FALSE otherwise.
   */
  PP_Bool (*LockCursor)(PP_Instance instance);
  /**
   * Causes the cursor to be unlocked, allowing it to track user
   * movement again.
   */
  PP_Bool (*UnlockCursor)(PP_Instance instance);
  /**
   * Returns PP_TRUE if the cursor is locked, PP_FALSE otherwise.
   */
  PP_Bool (*HasCursorLock)(PP_Instance instance);
  /**
   * Returns PP_TRUE if the cursor can be locked, PP_FALSE otherwise.
   */
  PP_Bool (*CanLockCursor)(PP_Instance instance);
};

typedef struct PPB_CursorControl_Dev_0_4 PPB_CursorControl_Dev;
/**
 * @}
 */

/* dev/ppb_file_chooser_dev.idl */
/**
 * @addtogroup Enums
 * @{
 */
/**
 * This enumeration contains constants to control the behavior of the file
 * chooser dialog.
 */
typedef enum {
  /**
   * Mode for choosing a single existing file.
   */
  PP_FILECHOOSERMODE_OPEN = 0,
  /**
   * Mode for choosing multiple existing files.
   */
  PP_FILECHOOSERMODE_OPENMULTIPLE = 1
} PP_FileChooserMode_Dev;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_FileChooserMode_Dev, 4);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
struct PPB_FileChooser_Dev_0_6 {
  /**
   * This function creates a file chooser dialog resource.  The chooser is
   * associated with a particular instance, so that it may be positioned on the
   * screen relative to the tab containing the instance.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying one instance
   * of a module.
   * @param[in] mode A <code>PP_FileChooserMode_Dev</code> value that controls
   * the behavior of the file chooser dialog.
   * @param[in] accept_types A comma-separated list of MIME types and file
   * extensions such as "audio/ *,text/plain,.html" (note there should be no
   * space between the '/' and the '*', but one is added to avoid confusing C++
   * comments). The dialog may restrict selectable files to the specified MIME
   * types and file extensions. If a string in the comma-separated list begins
   * with a period (.) then the string is interpreted as a file extension,
   * otherwise it is interpreted as a MIME-type. An empty string or an undefined
   * var may be given to indicate that all types should be accepted.
   *
   * @return A <code>PP_Resource</code> containing the file chooser if
   * successful or 0 if it could not be created.
   */
  PP_Resource (*Create)(PP_Instance instance,
                        PP_FileChooserMode_Dev mode,
                        struct PP_Var accept_types);
  /**
   * Determines if the provided resource is a file chooser.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to a generic
   * resource.
   *
   * @return A <code>PP_Bool</code> that is <code>PP_TRUE</code> if the given
   * resource is a file chooser resource, otherwise <code>PP_FALSE</code>.
   */
  PP_Bool (*IsFileChooser)(PP_Resource resource);
  /**
   * This function displays a previously created file chooser resource as a
   * dialog box, prompting the user to choose a file or files. This function
   * must be called in response to a user gesture, such as a mouse click or
   * touch event. The callback is called with PP_OK on successful completion
   * with a file (or files) selected, PP_ERROR_USERCANCEL if the user selected
   * no file, or another error code from pp_errors.h on failure.
   *
   * <b>Subtle note:</b> This function will only work when the tab containing
   * the plugin is visible. Show() will fail if the tab is in the background.
   * Since it's not normally possible to get input events while invisible, this
   * is not normally an issue. But there is a race condition because events are
   * processed asynchronously. If the user clicks and switches tabs very
   * quickly, a plugin could believe the tab is visible while Chrome believes
   * it is invisible and the Show() call will fail. This will not generally
   * cause user confusion since the user will have switched tabs and will not
   * want to see a file chooser from a different tab.
   *
   * @param[in] chooser The file chooser resource.
   *
   * @param[in] output An output array which will receive PP_Resource(s)
   * identifying the <code>PPB_FileRef</code> objects that the user selected on
   * success.
   *
   * @param[in] callback A <code>CompletionCallback</code> to be called after
   * the user has closed the file chooser dialog.
   *
   * @return PP_OK_COMPLETIONPENDING if request to show the dialog was
   * successful, another error code from pp_errors.h on failure.
   */
  int32_t (*Show)(PP_Resource chooser,
                  struct PP_ArrayOutput output,
                  struct PP_CompletionCallback callback);
};

typedef struct PPB_FileChooser_Dev_0_6 PPB_FileChooser_Dev;

struct PPB_FileChooser_Dev_0_5 {
  PP_Resource (*Create)(PP_Instance instance,
                        PP_FileChooserMode_Dev mode,
                        struct PP_Var accept_types);
  PP_Bool (*IsFileChooser)(PP_Resource resource);
  int32_t (*Show)(PP_Resource chooser, struct PP_CompletionCallback callback);
  PP_Resource (*GetNextChosenFile)(PP_Resource chooser);
};
/**
 * @}
 */

/* dev/ppb_font_dev.idl */
/**
 * @addtogroup Enums
 * @{
 */
typedef enum {
  /**
   * Uses the user's default web page font (normally either the default serif
   * or sans serif font).
   */
  PP_FONTFAMILY_DEFAULT = 0,
  /**
   * These families will use the default web page font corresponding to the
   * given family.
   */
  PP_FONTFAMILY_SERIF = 1,
  PP_FONTFAMILY_SANSSERIF = 2,
  PP_FONTFAMILY_MONOSPACE = 3
} PP_FontFamily_Dev;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_FontFamily_Dev, 4);

/**
 * Specifies the font weight. Normally users will only use NORMAL or BOLD.
 */
typedef enum {
  PP_FONTWEIGHT_100 = 0,
  PP_FONTWEIGHT_200 = 1,
  PP_FONTWEIGHT_300 = 2,
  PP_FONTWEIGHT_400 = 3,
  PP_FONTWEIGHT_500 = 4,
  PP_FONTWEIGHT_600 = 5,
  PP_FONTWEIGHT_700 = 6,
  PP_FONTWEIGHT_800 = 7,
  PP_FONTWEIGHT_900 = 8,
  PP_FONTWEIGHT_NORMAL = PP_FONTWEIGHT_400,
  PP_FONTWEIGHT_BOLD = PP_FONTWEIGHT_700
} PP_FontWeight_Dev;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_FontWeight_Dev, 4);
/**
 * @}
 */

/**
 * @addtogroup Structs
 * @{
 */
struct PP_FontDescription_Dev {
  /**
   * Font face name as a string. This can also be an undefined var, in which
   * case the generic family will be obeyed. If the face is not available on
   * the system, the browser will attempt to do font fallback or pick a default
   * font.
   */
  struct PP_Var face;
  /**
   * When Create()ing a font and the face is an undefined var, the family
   * specifies the generic font family type to use. If the face is specified,
   * this will be ignored.
   *
   * When Describe()ing a font, the family will be the value you passed in when
   * the font was created. In other words, if you specify a face name, the
   * family will not be updated to reflect whether the font name you requested
   * is serif or sans serif.
   */
  PP_FontFamily_Dev family;
  /**
   * Size in pixels.
   *
   * You can specify 0 to get the default font size. The default font size
   * may vary depending on the requested font. The typical example is that
   * the user may have a different font size for the default monospace font to
   * give it a similar optical size to the proportionally spaced fonts.
   */
  uint32_t size;
  /**
   * Normally you will use either PP_FONTWEIGHT_NORMAL or PP_FONTWEIGHT_BOLD.
   */
  PP_FontWeight_Dev weight;
  PP_Bool italic;
  PP_Bool small_caps;
  /**
   * Adjustment to apply to letter and word spacing, respectively. Initialize
   * to 0 to get normal spacing. Negative values bring letters/words closer
   * together, positive values separate them.
   */
  int32_t letter_spacing;
  int32_t word_spacing;
  /**
   * Ensure that this struct is 48-bytes wide by padding the end.  In some
   * compilers, PP_Var is 8-byte aligned, so those compilers align this struct
   * on 8-byte boundaries as well and pad it to 16 bytes even without this
   * padding attribute.  This padding makes its size consistent across
   * compilers.
   */
  int32_t padding;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_FontDescription_Dev, 48);

struct PP_FontMetrics_Dev {
  int32_t height;
  int32_t ascent;
  int32_t descent;
  int32_t line_spacing;
  int32_t x_height;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_FontMetrics_Dev, 20);

struct PP_TextRun_Dev {
  /**
   * This var must either be a string or a null/undefined var (which will be
   * treated as a 0-length string).
   */
  struct PP_Var text;
  /**
   * Set to PP_TRUE if the text is right-to-left.
   *
   * When <code>override_direction</code> is false, the browser will perform
   * the Unicode Bidirectional Algorithm (http://unicode.org/reports/tr9/) on
   * the text. The value of the <code>rtl</code> flag specifies the
   * directionality of the surrounding environment. This means that Hebrew
   * word will always display right to left, even if <code>rtl</code> is false.
   *
   * When <code>override_direction</code> is true, no autodetection will be done
   * and <code>rtl</code> specifies the direction of the text.
   *
   * TODO(brettw) note that autodetection with rtl = true is currently
   * unimplemented.
   */
  PP_Bool rtl;
  /**
   * Set to PP_TRUE to force the directionality of the text regardless of
   * content.
   *
   * If this flag is set, the browser will skip autodetection of the content
   * and will display all text in the direction specified by the
   * <code>rtl</code> flag.
   */
  PP_Bool override_direction;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_TextRun_Dev, 24);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
struct PPB_Font_Dev_0_6 {
  /**
   * Returns a list of all available font families on the system. You can use
   * this list to decide whether to Create() a font.
   *
   * The return value will be a single string with null characters delimiting
   * the end of each font name. For example: "Arial\0Courier\0Times\0".
   *
   * Returns an undefined var on failure (this typically means you passed an
   * invalid instance).
   */
  struct PP_Var (*GetFontFamilies)(PP_Instance instance);
  /**
   * Returns a font which best matches the given description. The return value
   * will have a non-zero ID on success, or zero on failure.
   */
  PP_Resource (*Create)(PP_Instance instance,
                        const struct PP_FontDescription_Dev* description);
  /**
   * Returns PP_TRUE if the given resource is a Font. Returns PP_FALSE if the
   * resource is invalid or some type other than a Font.
   */
  PP_Bool (*IsFont)(PP_Resource resource);
  /**
   * Loads the description and metrics of the font into the given structures.
   * The description will be different than the description the font was
   * created with since it will be filled with the real values from the font
   * that was actually selected.
   *
   * The PP_Var in the description should be of type Void on input. On output,
   * this will contain the string and will have a reference count of 1. The
   * plugin is responsible for calling Release on this var.
   *
   * Returns PP_TRUE on success, PP_FALSE if the font is invalid or if the Var
   * in the description isn't Null (to prevent leaks).
   */
  PP_Bool (*Describe)(PP_Resource font,
                      struct PP_FontDescription_Dev* description,
                      struct PP_FontMetrics_Dev* metrics);
  /**
   * Draws the text to the image buffer.
   *
   * The given point represents the baseline of the left edge of the font,
   * regardless of whether it is left-to-right or right-to-left (in the case of
   * RTL text, this will actually represent the logical end of the text).
   *
   * The clip is optional and may be NULL. In this case, the text will be
   * clipped to the image.
   *
   * The image_data_is_opaque flag indicates whether subpixel antialiasing can
   * be performed, if it is supported. When the image below the text is
   * opaque, subpixel antialiasing is supported and you should set this to
   * PP_TRUE to pick up the user's default preferences. If your plugin is
   * partially transparent, then subpixel antialiasing is not possible and
   * grayscale antialiasing will be used instead (assuming the user has
   * antialiasing enabled at all).
   */
  PP_Bool (*DrawTextAt)(PP_Resource font,
                        PP_Resource image_data,
                        const struct PP_TextRun_Dev* text,
                        const struct PP_Point* position,
                        uint32_t color,
                        const struct PP_Rect* clip,
                        PP_Bool image_data_is_opaque);
  /**
   * Returns the width of the given string. If the font is invalid or the var
   * isn't a valid string, this will return -1.
   *
   * Note that this function handles complex scripts such as Arabic, combining
   * accents, etc. so that adding the width of substrings won't necessarily
   * produce the correct width of the entire string.
   *
   * Returns -1 on failure.
   */
  int32_t (*MeasureText)(PP_Resource font, const struct PP_TextRun_Dev* text);
  /**
   * Returns the character at the given pixel X position from the beginning of
   * the string. This handles complex scripts such as Arabic, where characters
   * may be combined or replaced depending on the context. Returns (uint32)-1
   * on failure.
   */
  uint32_t (*CharacterOffsetForPixel)(PP_Resource font,
                                      const struct PP_TextRun_Dev* text,
                                      int32_t pixel_position);
  /**
   * Returns the horizontal advance to the given character if the string was
   * placed at the given position. This handles complex scripts such as Arabic,
   * where characters may be combined or replaced depending on context. Returns
   * -1 on error.
   */
  int32_t (*PixelOffsetForCharacter)(PP_Resource font,
                                     const struct PP_TextRun_Dev* text,
                                     uint32_t char_offset);
};

typedef struct PPB_Font_Dev_0_6 PPB_Font_Dev;
/**
 * @}
 */

/* dev/ppb_ime_input_event_dev.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
struct PPB_IMEInputEvent_Dev_0_2 {
  /**
   * Create() creates an IME input event with the given parameters. Normally
   * you will get an IME event passed through the <code>HandleInputEvent</code>
   * and will not need to create them, but some applications may want to create
   * their own for internal use.
   *
   * @param[in] instance The instance for which this event occurred.
   *
   * @param[in] type A <code>PP_InputEvent_Type</code> identifying the type of
   * input event. The type must be one of the IME event types.
   *
   * @param[in] time_stamp A <code>PP_TimeTicks</code> indicating the time
   * when the event occurred.
   *
   * @param[in] text The string returned by <code>GetText</code>.
   *
   * @param[in] segment_number The number returned by
   * <code>GetSegmentNumber</code>.
   *
   * @param[in] segment_offsets The array of numbers returned by
   * <code>GetSegmentOffset</code>. If <code>segment_number</code> is zero,
   * the number of elements of the array should be zero. If
   * <code>segment_number</code> is non-zero, the length of the array must be
   * <code>segment_number</code> + 1.
   *
   * @param[in] target_segment The number returned by
   * <code>GetTargetSegment</code>.
   *
   * @param[in] selection_start The start index returned by
   * <code>GetSelection</code>.
   *
   * @param[in] selection_end The end index returned by
   * <code>GetSelection</code>.
   *
   * @return A <code>PP_Resource</code> containing the new IME input event.
   */
  PP_Resource (*Create)(PP_Instance instance,
                        PP_InputEvent_Type type,
                        PP_TimeTicks time_stamp,
                        struct PP_Var text,
                        uint32_t segment_number,
                        const uint32_t segment_offsets[],
                        int32_t target_segment,
                        uint32_t selection_start,
                        uint32_t selection_end);
  /**
   * IsIMEInputEvent() determines if a resource is an IME event.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to an event.
   *
   * @return <code>PP_TRUE</code> if the given resource is a valid input event.
   */
  PP_Bool (*IsIMEInputEvent)(PP_Resource resource);
  /**
   * GetText() returns the composition text as a UTF-8 string for the given IME
   * event.
   *
   * @param[in] ime_event A <code>PP_Resource</code> corresponding to an IME
   * event.
   *
   * @return A string var representing the composition text. For non-IME input
   * events the return value will be an undefined var.
   */
  struct PP_Var (*GetText)(PP_Resource ime_event);
  /**
   * GetSegmentNumber() returns the number of segments in the composition text.
   *
   * @param[in] ime_event A <code>PP_Resource</code> corresponding to an IME
   * event.
   *
   * @return The number of segments. For events other than COMPOSITION_UPDATE,
   * returns 0.
   */
  uint32_t (*GetSegmentNumber)(PP_Resource ime_event);
  /**
   * GetSegmentOffset() returns the position of the index-th segmentation point
   * in the composition text. The position is given by a byte-offset (not a
   * character-offset) of the string returned by GetText(). It always satisfies
   * 0=GetSegmentOffset(0) < ... < GetSegmentOffset(i) < GetSegmentOffset(i+1)
   * < ... < GetSegmentOffset(GetSegmentNumber())=(byte-length of GetText()).
   * Note that [GetSegmentOffset(i), GetSegmentOffset(i+1)) represents the range
   * of the i-th segment, and hence GetSegmentNumber() can be a valid argument
   * to this function instead of an off-by-1 error.
   *
   * @param[in] ime_event A <code>PP_Resource</code> corresponding to an IME
   * event.
   *
   * @param[in] index An integer indicating a segment.
   *
   * @return The byte-offset of the segmentation point. If the event is not
   * COMPOSITION_UPDATE or index is out of range, returns 0.
   */
  uint32_t (*GetSegmentOffset)(PP_Resource ime_event, uint32_t index);
  /**
   * GetTargetSegment() returns the index of the current target segment of
   * composition.
   *
   * @param[in] ime_event A <code>PP_Resource</code> corresponding to an IME
   * event.
   *
   * @return An integer indicating the index of the target segment. When there
   * is no active target segment, or the event is not COMPOSITION_UPDATE,
   * returns -1.
   */
  int32_t (*GetTargetSegment)(PP_Resource ime_event);
  /**
   * GetSelection() returns the range selected by caret in the composition text.
   *
   * @param[in] ime_event A <code>PP_Resource</code> corresponding to an IME
   * event.
   *
   * @param[out] start The start position of the current selection.
   *
   * @param[out] end The end position of the current selection.
   */
  void (*GetSelection)(PP_Resource ime_event, uint32_t* start, uint32_t* end);
};

typedef struct PPB_IMEInputEvent_Dev_0_2 PPB_IMEInputEvent_Dev;

struct PPB_IMEInputEvent_Dev_0_1 {
  PP_Bool (*IsIMEInputEvent)(PP_Resource resource);
  struct PP_Var (*GetText)(PP_Resource ime_event);
  uint32_t (*GetSegmentNumber)(PP_Resource ime_event);
  uint32_t (*GetSegmentOffset)(PP_Resource ime_event, uint32_t index);
  int32_t (*GetTargetSegment)(PP_Resource ime_event);
  void (*GetSelection)(PP_Resource ime_event, uint32_t* start, uint32_t* end);
};
/**
 * @}
 */

/* dev/ppb_memory_dev.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The PPB_Memory_Dev interface contains pointers to functions related to memory
 * management.
 *
 */
struct PPB_Memory_Dev_0_1 {
  /**
   * MemAlloc is a pointer to a function that allocate memory.
   *
   * @param[in] num_bytes A number of bytes to allocate.
   * @return A pointer to the memory if successful, NULL If the
   * allocation fails.
   */
  void* (*MemAlloc)(uint32_t num_bytes);
  /**
   * MemFree is a pointer to a function that deallocates memory.
   *
   * @param[in] ptr A pointer to the memory to deallocate. It is safe to
   * pass NULL to this function.
   */
  void (*MemFree)(void* ptr);
};

typedef struct PPB_Memory_Dev_0_1 PPB_Memory_Dev;
/**
 * @}
 */

/* dev/ppb_opengles2ext_dev.idl */
#include "ppapi/c/pp_resource.h"
#include "ppapi/c/ppb_opengles2.h"


/**
 * @addtogroup Interfaces
 * @{
 */
struct PPB_OpenGLES2DrawBuffers_Dev_1_0 {
  void (*DrawBuffersEXT)(PP_Resource context,
                         GLsizei count,
                         const GLenum* bufs);
};

struct PPB_OpenGLES2DrawBuffers_Dev {
  void (*DrawBuffersEXT)(PP_Resource context,
                         GLsizei count,
                         const GLenum* bufs);
};
/**
 * @}
 */

/* dev/ppb_printing_dev.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
struct PPB_Printing_Dev_0_7 {
  /** Create a resource for accessing printing functionality.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying one instance
   * of a module.
   *
   * @return A <code>PP_Resource</code> containing the printing resource if
   * successful or 0 if it could not be created.
   */
  PP_Resource (*Create)(PP_Instance instance);
  /**
   * Outputs the default print settings for the default printer into
   * <code>print_settings</code>. The callback is called with
   * <code>PP_OK</code> when the settings have been retrieved successfully.
   *
   * @param[in] resource The printing resource.
   *
   * @param[in] callback A <code>CompletionCallback</code> to be called when
   * <code>print_settings</code> have been retrieved.
   *
   * @return PP_OK_COMPLETIONPENDING if request for the default print settings
   * was successful, another error code from pp_errors.h on failure.
   */
  int32_t (*GetDefaultPrintSettings)(
      PP_Resource resource,
      struct PP_PrintSettings_Dev* print_settings,
      struct PP_CompletionCallback callback);
};

typedef struct PPB_Printing_Dev_0_7 PPB_Printing_Dev;
/**
 * @}
 */

/* dev/ppb_text_input_dev.idl */
/**
 * @addtogroup Enums
 * @{
 */
/**
 * PP_TextInput_Type is used to indicate the status of a plugin in regard to
 * text input.
 */
typedef enum {
  /**
   * Input caret is not in an editable mode, no input method shall be used.
   */
  PP_TEXTINPUT_TYPE_DEV_NONE = 0,
  /**
   * Input caret is in a normal editable mode, any input method can be used.
   */
  PP_TEXTINPUT_TYPE_DEV_TEXT = 1,
  /**
   * Input caret is in a password box, an input method may be used only if
   * it's suitable for password input.
   */
  PP_TEXTINPUT_TYPE_DEV_PASSWORD = 2,
  PP_TEXTINPUT_TYPE_DEV_SEARCH = 3,
  PP_TEXTINPUT_TYPE_DEV_EMAIL = 4,
  PP_TEXTINPUT_TYPE_DEV_NUMBER = 5,
  PP_TEXTINPUT_TYPE_DEV_TELEPHONE = 6,
  PP_TEXTINPUT_TYPE_DEV_URL = 7
} PP_TextInput_Type_Dev;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_TextInput_Type_Dev, 4);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * <code>PPB_TextInput_Dev</code> provides a set of functions for giving hints
 * to the browser about the text input status of plugins, and functions for
 * controlling input method editors (IMEs).
 */
struct PPB_TextInput_Dev_0_2 {
  /**
   * Informs the browser about the current text input mode of the plugin.
   * Typical use of this information in the browser is to properly
   * display/suppress tools for supporting text inputs (such as virtual
   * keyboards in touch screen based devices, or input method editors often
   * used for composing East Asian characters).
   */
  void (*SetTextInputType)(PP_Instance instance, PP_TextInput_Type_Dev type);
  /**
   * Informs the browser about the coordinates of the text input caret and the
   * bounding box of the text input area. Typical use of this information in
   * the browser is to layout IME windows etc.
   */
  void (*UpdateCaretPosition)(PP_Instance instance,
                              const struct PP_Rect* caret,
                              const struct PP_Rect* bounding_box);
  /**
   * Cancels the current composition in IME.
   */
  void (*CancelCompositionText)(PP_Instance instance);
  /**
   * In response to the <code>PPP_TextInput_Dev::RequestSurroundingText</code>
   * call, informs the browser about the current text selection and surrounding
   * text. <code>text</code> is a UTF-8 string that contains the current range
   * of text selection in the plugin. <code>caret</code> is the byte-index of
   * the caret position within <code>text</code>. <code>anchor</code> is the
   * byte-index of the anchor position (i.e., if a range of text is selected,
   * it is the other edge of selection different from <code>caret</code>. If
   * there are no selection, <code>anchor</code> is equal to <code>caret</code>.
   *
   * Typical use of this information in the browser is to enable "reconversion"
   * features of IME that puts back the already committed text into the
   * pre-commit composition state. Another use is to improve the precision
   * of suggestion of IME by taking the context into account (e.g., if the caret
   * looks to be on the beginning of a sentence, suggest capital letters in a
   * virtual keyboard).
   *
   * When the focus is not on text, call this function setting <code>text</code>
   * to an empty string and <code>caret</code> and <code>anchor</code> to zero.
   * Also, the plugin should send the empty text when it does not want to reveal
   * the selection to IME (e.g., when the surrounding text is containing
   * password text).
   */
  void (*UpdateSurroundingText)(PP_Instance instance,
                                const char* text,
                                uint32_t caret,
                                uint32_t anchor);
  /**
   * Informs the browser when a range of text selection is changed in a plugin.
   * When the browser needs to know the content of the updated selection, it
   * pings back by <code>PPP_TextInput_Dev::RequestSurroundingText</code>. The
   * plugin then should send the information with
   * <code>UpdateSurroundingText</code>.
   */
  void (*SelectionChanged)(PP_Instance instance);
};

typedef struct PPB_TextInput_Dev_0_2 PPB_TextInput_Dev;

struct PPB_TextInput_Dev_0_1 {
  void (*SetTextInputType)(PP_Instance instance, PP_TextInput_Type_Dev type);
  void (*UpdateCaretPosition)(PP_Instance instance,
                              const struct PP_Rect* caret,
                              const struct PP_Rect* bounding_box);
  void (*CancelCompositionText)(PP_Instance instance);
};
/**
 * @}
 */

/* dev/ppb_trace_event_dev.idl */
/**
 * @addtogroup Typedefs
 * @{
 */
/**
 * A trace event timestamp.
 */
typedef int64_t PP_TraceEventTime;
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
struct PPB_Trace_Event_Dev_0_2 {
  /**
   * Gets a pointer to a character for identifying a category name in the
   * tracing system as well as for being able to early exit in client-side
   * tracing code.
   *
   * NB: This mem_t return value should technically be const, but return values
   * for Pepper IDL of mem_t type are not const.  The same is true for the arg
   * |category_enabled| for AddTraceEvent.
   */
  void* (*GetCategoryEnabled)(const char* category_name);
  /**
   * Adds a trace event to the platform tracing system. This function call is
   * usually the result of a TRACE_* macro from trace_event.h when tracing and
   * the category of the particular trace are enabled. It is not advisable to
   * call this function on its own; it is really only meant to be used by the
   * trace macros.
   */
  void (*AddTraceEvent)(int8_t phase,
                        const void* category_enabled,
                        const char* name,
                        uint64_t id,
                        uint32_t num_args,
                        const char* arg_names[],
                        const uint8_t arg_types[],
                        const uint64_t arg_values[],
                        uint8_t flags);
  /**
   * Version of the above interface that allows specifying a custom thread id
   * and timestamp. This is useful for when tracing data cannot be registered
   * in real time. For example, this could be used by storing timestamps
   * internally and then registering the events retroactively.
   */
  void (*AddTraceEventWithThreadIdAndTimestamp)(int8_t phase,
                                                const void* category_enabled,
                                                const char* name,
                                                uint64_t id,
                                                int32_t thread_id,
                                                PP_TraceEventTime timestamp,
                                                uint32_t num_args,
                                                const char* arg_names[],
                                                const uint8_t arg_types[],
                                                const uint64_t arg_values[],
                                                uint8_t flags);
  /**
   * Get the current clock value. Since this uses the same function as the trace
   * events use internally, it can be used to create events with explicit time
   * stamps.
   */
  PP_TraceEventTime (*Now)(void);
  /**
   * Sets the thread name of the calling thread in the tracing system so it will
   * show up properly in chrome://tracing.
   */
  void (*SetThreadName)(const char* thread_name);
};

typedef struct PPB_Trace_Event_Dev_0_2 PPB_Trace_Event_Dev;

struct PPB_Trace_Event_Dev_0_1 {
  void* (*GetCategoryEnabled)(const char* category_name);
  void (*AddTraceEvent)(int8_t phase,
                        const void* category_enabled,
                        const char* name,
                        uint64_t id,
                        uint32_t num_args,
                        const char* arg_names[],
                        const uint8_t arg_types[],
                        const uint64_t arg_values[],
                        uint8_t flags);
  void (*SetThreadName)(const char* thread_name);
};
/**
 * @}
 */

/* dev/ppb_truetype_font_dev.idl */
/**
 * @addtogroup Enums
 * @{
 */
/**
 * The PP_TrueTypeFontFamily_Dev defines generic font families. These can be
 * used to create generic fonts consistent with the user's browser settings.
 */
typedef enum {
  /**
   * For a description of these default families, see the
   * <a href="http://www.w3.org/TR/css3-fonts/#generic-font-families">
   * 3.1.1 Generic font families</a> documentation.
   */
  PP_TRUETYPEFONTFAMILY_SERIF = 0,
  PP_TRUETYPEFONTFAMILY_SANSSERIF = 1,
  PP_TRUETYPEFONTFAMILY_CURSIVE = 2,
  PP_TRUETYPEFONTFAMILY_FANTASY = 3,
  PP_TRUETYPEFONTFAMILY_MONOSPACE = 4
} PP_TrueTypeFontFamily_Dev;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_TrueTypeFontFamily_Dev, 4);

/**
 * The PP_TrueTypeFontStyle_Dev enum defines font styles.
 */
typedef enum {
  PP_TRUETYPEFONTSTYLE_NORMAL = 0,
  PP_TRUETYPEFONTSTYLE_ITALIC = 1
} PP_TrueTypeFontStyle_Dev;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_TrueTypeFontStyle_Dev, 4);

/**
 * The PP_TrueTypeFontWeight_Dev enum defines font weights.
 */
typedef enum {
  PP_TRUETYPEFONTWEIGHT_THIN = 100,
  PP_TRUETYPEFONTWEIGHT_ULTRALIGHT = 200,
  PP_TRUETYPEFONTWEIGHT_LIGHT = 300,
  PP_TRUETYPEFONTWEIGHT_NORMAL = 400,
  PP_TRUETYPEFONTWEIGHT_MEDIUM = 500,
  PP_TRUETYPEFONTWEIGHT_SEMIBOLD = 600,
  PP_TRUETYPEFONTWEIGHT_BOLD = 700,
  PP_TRUETYPEFONTWEIGHT_ULTRABOLD = 800,
  PP_TRUETYPEFONTWEIGHT_HEAVY = 900
} PP_TrueTypeFontWeight_Dev;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_TrueTypeFontWeight_Dev, 4);

/**
 * The PP_TrueTypeFontWidth_Dev enum defines font widths.
 */
typedef enum {
  PP_TRUETYPEFONTWIDTH_ULTRACONDENSED = 0,
  PP_TRUETYPEFONTWIDTH_EXTRACONDENSED = 1,
  PP_TRUETYPEFONTWIDTH_CONDENSED = 2,
  PP_TRUETYPEFONTWIDTH_SEMICONDENSED = 3,
  PP_TRUETYPEFONTWIDTH_NORMAL = 4,
  PP_TRUETYPEFONTWIDTH_SEMIEXPANDED = 5,
  PP_TRUETYPEFONTWIDTH_EXPANDED = 6,
  PP_TRUETYPEFONTWIDTH_EXTRAEXPANDED = 7,
  PP_TRUETYPEFONTWIDTH_ULTRAEXPANDED = 8
} PP_TrueTypeFontWidth_Dev;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_TrueTypeFontWidth_Dev, 4);

/**
 * The PP_TrueTypeFontCharset enum defines font character sets.
 */
typedef enum {
  PP_TRUETYPEFONTCHARSET_ANSI = 0,
  PP_TRUETYPEFONTCHARSET_DEFAULT = 1,
  PP_TRUETYPEFONTCHARSET_SYMBOL = 2,
  PP_TRUETYPEFONTCHARSET_MAC = 77,
  PP_TRUETYPEFONTCHARSET_SHIFTJIS = 128,
  PP_TRUETYPEFONTCHARSET_HANGUL = 129,
  PP_TRUETYPEFONTCHARSET_JOHAB = 130,
  PP_TRUETYPEFONTCHARSET_GB2312 = 134,
  PP_TRUETYPEFONTCHARSET_CHINESEBIG5 = 136,
  PP_TRUETYPEFONTCHARSET_GREEK = 161,
  PP_TRUETYPEFONTCHARSET_TURKISH = 162,
  PP_TRUETYPEFONTCHARSET_VIETNAMESE = 163,
  PP_TRUETYPEFONTCHARSET_HEBREW = 177,
  PP_TRUETYPEFONTCHARSET_ARABIC = 178,
  PP_TRUETYPEFONTCHARSET_BALTIC = 186,
  PP_TRUETYPEFONTCHARSET_RUSSIAN = 204,
  PP_TRUETYPEFONTCHARSET_THAI = 222,
  PP_TRUETYPEFONTCHARSET_EASTEUROPE = 238,
  PP_TRUETYPEFONTCHARSET_OEM = 255
} PP_TrueTypeFontCharset_Dev;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_TrueTypeFontCharset_Dev, 4);
/**
 * @}
 */

/**
 * @addtogroup Structs
 * @{
 */
/**
 * The <code>PP_TrueTypeFontDesc</code> struct describes a TrueType font. It is
 * passed to Create(), and returned by Describe().
 */
struct PP_TrueTypeFontDesc_Dev {
  /**
   * Font family name as a string. This can also be an undefined var, in which
   * case the generic family will be obeyed. If the face is not available on
   * the system, the browser will attempt to do font fallback or pick a default
   * font.
   */
  struct PP_Var family;
  /** This value specifies a generic font family. If a family name string is
   * provided when creating a font, this is ignored. */
  PP_TrueTypeFontFamily_Dev generic_family;
  /** This value specifies the font style. */
  PP_TrueTypeFontStyle_Dev style;
  /** This value specifies the font weight. */
  PP_TrueTypeFontWeight_Dev weight;
  /** This value specifies the font width, for condensed or expanded fonts */
  PP_TrueTypeFontWidth_Dev width;
  /** This value specifies a character set. */
  PP_TrueTypeFontCharset_Dev charset;
  /**
   * Ensure that this struct is 40-bytes wide by padding the end.  In some
   * compilers, PP_Var is 8-byte aligned, so those compilers align this struct
   * on 8-byte boundaries as well and pad it to 16 bytes even without this
   * padding attribute.  This padding makes its size consistent across
   * compilers.
   */
  int32_t padding;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_TrueTypeFontDesc_Dev, 40);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
struct PPB_TrueTypeFont_Dev_0_1 {
  /**
   * Gets an array of TrueType font family names available on the host.
   * These names can be used to create a font from a specific family.
   *
   * @param[in] instance A <code>PP_Instance</code> requesting the family names.
   * @param[in] output A <code>PP_ArrayOutput</code> to hold the names.
   * The output is an array of PP_Vars, each holding a family name.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion of GetFontFamilies.
   *
   * @return If >= 0, the number of family names returned, otherwise an error
   * code from <code>pp_errors.h</code>.
   */
  int32_t (*GetFontFamilies)(PP_Instance instance,
                             struct PP_ArrayOutput output,
                             struct PP_CompletionCallback callback);
  /**
   * Gets an array of TrueType font descriptors for a given font family. These
   * descriptors can be used to create a font in that family and matching the
   * descriptor attributes.
   *
   * @param[in] instance A <code>PP_Instance</code> requesting the font
   * descriptors.
   * @param[in] family A <code>PP_Var</code> holding a string specifying the
   * font family.
   * @param[in] output A <code>PP_ArrayOutput</code> to hold the descriptors.
   * The output is an array of <code>PP_TrueTypeFontDesc</code> structs. Each
   * desc contains a PP_Var for the family name which must be released.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion of GetFontsInFamily.
   *
   * @return If >= 0, the number of font descriptors returned, otherwise an
   * error code from <code>pp_errors.h</code>.
   */
  int32_t (*GetFontsInFamily)(PP_Instance instance,
                              struct PP_Var family,
                              struct PP_ArrayOutput output,
                              struct PP_CompletionCallback callback);
  /**
   * Creates a font resource matching the given font characteristics. The
   * resource id will be non-zero on success, or zero on failure.
   *
   * @param[in] instance A <code>PP_Instance</code> to own the font.
   * @param[in] desc A pointer to a <code>PP_TrueTypeFontDesc</code> describing
   * the font.
   */
  PP_Resource (*Create)(PP_Instance instance,
                        const struct PP_TrueTypeFontDesc_Dev* desc);
  /**
   * Determines if the given resource is a TrueType font.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to a resource.
   *
   * @return <code>PP_TRUE</code> if the resource is a
   * <code>PPB_TrueTypeFont_Dev</code>, <code>PP_FALSE</code> otherwise.
   */
  PP_Bool (*IsTrueTypeFont)(PP_Resource resource);
  /**
   * Returns a description of the given font resource. This description may
   * differ from the description passed to Create, reflecting the host's font
   * matching and fallback algorithm.
   *
   * @param[in] font A <code>PP_Resource</code> corresponding to a font.
   * @param[out] desc A pointer to a <code>PP_TrueTypeFontDesc</code> to hold
   * the description. The internal 'family' PP_Var should be set to undefined,
   * since this function overwrites the <code>PP_TrueTypeFontDesc</code>. After
   * successful completion, the family will be set to a PP_Var with a single
   * reference, which the caller must release after use.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion of Describe.
   *
   * @return A return code from <code>pp_errors.h</code>. If an error code is
   * returned, the <code>PP_TrueTypeFontDesc</code> will be unchanged.
   */
  int32_t (*Describe)(PP_Resource font,
                      struct PP_TrueTypeFontDesc_Dev* desc,
                      struct PP_CompletionCallback callback);
  /**
   * Gets an array of identifying tags for each table in the font. These tags
   * can be used to request specific tables using GetTable.
   *
   * @param[in] font A <code>PP_Resource</code> corresponding to a font.
   * @param[in] output A <code>PP_ArrayOutput</code> to hold the tags.
   * The output is an array of 4 byte integers, each representing a table tag.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion of GetTableTags.
   *
   * @return If >= 0, the number of table tags returned, otherwise an error
   * code from <code>pp_errors.h</code>.
   */
  int32_t (*GetTableTags)(PP_Resource font,
                          struct PP_ArrayOutput output,
                          struct PP_CompletionCallback callback);
  /**
   * Copies the given font table into client memory.
   *
   * @param[in] font A <code>PP_Resource</code> corresponding to a font.
   * @param[in] table A 4 byte value indicating which table to copy.
   * For example, 'glyf' will cause the outline table to be copied into the
   * output array. A zero tag value will cause the entire font to be copied.
   * @param[in] offset The offset into the font table. Passing an offset
   * greater than or equal to the table size will succeed with 0 bytes copied.
   * @param[in] max_data_length The maximum number of bytes to transfer from
   * <code>offset</code>.
   * @param[in] output A <code>PP_ArrayOutput</code> to hold the font data.
   * The output is an array of bytes.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion of GetTable.
   *
   * @return If >= 0, the table size in bytes, otherwise an error code from
   * <code>pp_errors.h</code>.
   */
  int32_t (*GetTable)(PP_Resource font,
                      uint32_t table,
                      int32_t offset,
                      int32_t max_data_length,
                      struct PP_ArrayOutput output,
                      struct PP_CompletionCallback callback);
};

typedef struct PPB_TrueTypeFont_Dev_0_1 PPB_TrueTypeFont_Dev;
/**
 * @}
 */

/* dev/ppb_url_util_dev.idl */
/**
 * @addtogroup Structs
 * @{
 */
/*
 * A component specifies the range of the part of the URL. The begin specifies
 * the index into the string of the first character of that component. The len
 * specifies the length of that component.
 *
 * This range does not include any special delimiter for that component, so
 * the scheme doesn't include the trailing colon, the username and password
 * don't include the @ and :, the port doesn't include the colon, the query
 * doesn't include the ?, and the ref doesn't include the #.
 *
 * The exception is that the path *does* include the first /, since that's an
 * integral part of the path.
 *
 * If the component is not present at all, begin will be 0 and len will be -1.
 * If the component is present but empty, the length will be 0 instead. Example:
 *   http://foo/search    -> query = (0, -1)
 *   http://foo/search?   -> query = (18, 0)
 */
struct PP_URLComponent_Dev {
  int32_t begin;
  int32_t len;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_URLComponent_Dev, 8);

struct PP_URLComponents_Dev {
  struct PP_URLComponent_Dev scheme;
  struct PP_URLComponent_Dev username;
  struct PP_URLComponent_Dev password;
  struct PP_URLComponent_Dev host;
  struct PP_URLComponent_Dev port;
  struct PP_URLComponent_Dev path;
  struct PP_URLComponent_Dev query;
  struct PP_URLComponent_Dev ref;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_URLComponents_Dev, 64);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
/*
 * URL encoding: URLs are supplied to this interface as NULL-terminated 8-bit
 * strings. You can pass non-ASCII characters which will be interpreted as
 * UTF-8. Canonicalized URL strings returned by these functions will be ASCII
 * except for the reference fragment (stuff after the '#') which will be
 * encoded as UTF-8.
 */
struct PPB_URLUtil_Dev_0_7 {
  /*
   * Canonicalizes the given URL string according to the rules of the host
   * browser. If the URL is invalid or the var is not a string, this will
   * return a Null var and the components structure will be unchanged.
   *
   * The components pointer, if non-NULL and the canonicalized URL is valid,
   * will identify the components of the resulting URL. Components may be NULL
   * to specify that no component information is necessary.
   */
  struct PP_Var (*Canonicalize)(struct PP_Var url,
                                struct PP_URLComponents_Dev* components);
  /*
   *  Resolves the given URL relative to the given base URL. The resulting URL
   *  is returned as a string. If the resolution is invalid or either of the
   *  inputs are not strings, a Null var will be returned. The resulting URL
   *  will also be canonicalized according to the rules of the browser.
   *
   *  Note that the "relative" URL may in fact be absolute, in which case it
   *  will be returned. This function is identical to resolving the full URL
   *  for an <a href="..."> on a web page. Attempting to resolve a relative URL
   *  on a base URL that doesn't support this (e.g. "data") will fail and will
   *  return a Null var, unless the relative URL is itself absolute.
   *
   *  The components pointer, if non-NULL and the canonicalized URL is valid,
   *  will identify the components of the resulting URL. Components may be NULL
   *  to specify that no component information is necessary.
   */
  struct PP_Var (*ResolveRelativeToURL)(
      struct PP_Var base_url,
      struct PP_Var relative_string,
      struct PP_URLComponents_Dev* components);
  /*
   *  Identical to ResolveRelativeToURL except that the base URL is the base
   *  URL of the document containing the given plugin instance.
   *
   *  Danger: This will be identical to resolving a relative URL on the page,
   *  and might be overridden by the page to something different than its actual
   *  URL via the <base> tag. Therefore, resolving a relative URL of "" won't
   *  necessarily give you the URL of the page!
   */
  struct PP_Var (*ResolveRelativeToDocument)(
      PP_Instance instance,
      struct PP_Var relative_string,
      struct PP_URLComponents_Dev* components);
  /*
   * Checks whether the given two URLs are in the same security origin. Returns
   * FALSE if either of the URLs are invalid.
   */
  PP_Bool (*IsSameSecurityOrigin)(struct PP_Var url_a, struct PP_Var url_b);
  /*
   * Checks whether the document hosting the given plugin instance can access
   * the given URL according to the same origin policy of the browser. Returns
   * PP_FALSE if the instance or the URL is invalid.
   */
  PP_Bool (*DocumentCanRequest)(PP_Instance instance, struct PP_Var url);
  /*
   * Checks whether the document containing the |active| plugin instance can
   * access the document containing the |target| plugin instance according to
   * the security policy of the browser. This includes the same origin policy
   * and any cross-origin capabilities enabled by the document. If either of
   * the plugin instances are invalid, returns PP_FALSE.
   */
  PP_Bool (*DocumentCanAccessDocument)(PP_Instance active, PP_Instance target);
  /*
   * Returns the URL for the document. This is a safe way to retrieve
   * window.location.href.
   * The components pointer, if non-NULL and the canonicalized URL is valid,
   * will identify the components of the resulting URL. Components may be NULL
   * to specify that no component information is necessary.
   */
  struct PP_Var (*GetDocumentURL)(PP_Instance instance,
                                  struct PP_URLComponents_Dev* components);
  /*
   * Returns the Source URL for the plugin. This returns the URL that would be
   * streamed to the plugin if it were a NPAPI plugin. This is usually the src
   * attribute on the <embed> element, but the rules are obscure and different
   * based on whether the plugin is loaded from an <embed> element or an
   * <object> element.
   * The components pointer, if non-NULL and the canonicalized URL is valid,
   * will identify the components of the resulting URL. Components may be NULL
   * to specify that no component information is necessary.
   */
  struct PP_Var (*GetPluginInstanceURL)(
      PP_Instance instance,
      struct PP_URLComponents_Dev* components);
  /*
   * Returns the Referrer URL of the HTTP request that loaded the plugin. This
   * is the value of the 'Referer' header of the request. An undefined value
   * means the 'Referer' header was absent.
   * The components pointer, if non-NULL and the canonicalized URL is valid,
   * will identify the components of the resulting URL. Components may be NULL
   * to specify that no component information is necessary.
   */
  struct PP_Var (*GetPluginReferrerURL)(
      PP_Instance instance,
      struct PP_URLComponents_Dev* components);
};

typedef struct PPB_URLUtil_Dev_0_7 PPB_URLUtil_Dev;

struct PPB_URLUtil_Dev_0_6 {
  struct PP_Var (*Canonicalize)(struct PP_Var url,
                                struct PP_URLComponents_Dev* components);
  struct PP_Var (*ResolveRelativeToURL)(
      struct PP_Var base_url,
      struct PP_Var relative_string,
      struct PP_URLComponents_Dev* components);
  struct PP_Var (*ResolveRelativeToDocument)(
      PP_Instance instance,
      struct PP_Var relative_string,
      struct PP_URLComponents_Dev* components);
  PP_Bool (*IsSameSecurityOrigin)(struct PP_Var url_a, struct PP_Var url_b);
  PP_Bool (*DocumentCanRequest)(PP_Instance instance, struct PP_Var url);
  PP_Bool (*DocumentCanAccessDocument)(PP_Instance active, PP_Instance target);
  struct PP_Var (*GetDocumentURL)(PP_Instance instance,
                                  struct PP_URLComponents_Dev* components);
  struct PP_Var (*GetPluginInstanceURL)(
      PP_Instance instance,
      struct PP_URLComponents_Dev* components);
};
/**
 * @}
 */

/* dev/ppp_class_deprecated.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * Interface for the plugin to implement JavaScript-accessible objects.
 *
 * This interface has no interface name. Instead, the plugin passes a pointer
 * to this interface to PPB_Var_Deprecated.CreateObject that corresponds to the
 * object being implemented.
 *
 * See the PPB_Var_Deprecated interface for more information on these functions.
 * This interface just allows you to implement the "back end" of those
 * functions, so most of the contract is specified in that interface.
 *
 * See
 *   http://code.google.com/p/ppapi/wiki/InterfacingWithJavaScript
 * for general information on using and implementing vars.
 */
struct PPP_Class_Deprecated_1_0 {
  /**
   * |name| is guaranteed to be an integer or string type var. Exception is
   * guaranteed non-NULL. An integer is used for |name| when implementing
   * array access into the object. This test should only return true for
   * properties that are not methods.  Use HasMethod() to handle methods.
   */
  PP_Bool (*HasProperty)(const void* object,
                         struct PP_Var name,
                         struct PP_Var* exception);
  /**
   * |name| is guaranteed to be a string-type. Exception is guaranteed non-NULL.
   * If the method does not exist, return false and don't set the exception.
   * Errors in this function will probably not occur in general usage, but
   * if you need to throw an exception, still return false.
   */
  PP_Bool (*HasMethod)(const void* object,
                       struct PP_Var name,
                       struct PP_Var* exception);
  /**
   * |name| is guaranteed to be a string-type or an integer-type var. Exception
   * is guaranteed non-NULL. An integer is used for |name| when implementing
   * array access into the object. If the property does not exist, set the
   * exception and return a var of type Void. A property does not exist if
   * a call HasProperty() for the same |name| would return false.
   */
  struct PP_Var (*GetProperty)(const void* object,
                               struct PP_Var name,
                               struct PP_Var* exception);
  /**
   * Exception is guaranteed non-NULL.
   *
   * This should include all enumerable properties, including methods. Be sure
   * to set |*property_count| to 0 and |properties| to NULL in all failure
   * cases, these should never be unset when calling this function. The
   * pointers passed in are guaranteed not to be NULL, so you don't have to
   * NULL check them.
   *
   * If you have any properties, allocate the property array with
   * PPB_Core.MemAlloc(sizeof(PP_Var) * property_count) and add a reference
   * to each property on behalf of the caller. The caller is responsible for
   * Release()ing each var and calling PPB_Core.MemFree on the property pointer.
   */
  void (*GetAllPropertyNames)(const void* object,
                              uint32_t* property_count,
                              struct PP_Var** properties,
                              struct PP_Var* exception);
  /**
   * |name| is guaranteed to be an integer or string type var. Exception is
   * guaranteed non-NULL.
   */
  void (*SetProperty)(const void* object,
                      struct PP_Var name,
                      struct PP_Var value,
                      struct PP_Var* exception);
  /**
   * |name| is guaranteed to be an integer or string type var. Exception is
   * guaranteed non-NULL.
   */
  void (*RemoveProperty)(const void* object,
                         struct PP_Var name,
                         struct PP_Var* exception);
  /* TODO(brettw) need native array access here. */
  /**
   * |name| is guaranteed to be a string type var. Exception is guaranteed
   * non-NULL
   */
  struct PP_Var (*Call)(const void* object,
                        struct PP_Var method_name,
                        uint32_t argc,
                        const struct PP_Var argv[],
                        struct PP_Var* exception);
  /** Exception is guaranteed non-NULL. */
  struct PP_Var (*Construct)(const void* object,
                             uint32_t argc,
                             const struct PP_Var argv[],
                             struct PP_Var* exception);
  /**
   * Called when the reference count of the object reaches 0. Normally, plugins
   * would free their internal data pointed to by the |object| pointer.
   */
  void (*Deallocate)(const void* object);
};

typedef struct PPP_Class_Deprecated_1_0 PPP_Class_Deprecated;
/**
 * @}
 */

/* dev/ppb_var_deprecated.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
struct PPB_Var_Deprecated_0_3 {
  /**
   * Adds a reference to the given var. If this is not a refcounted object,
   * this function will do nothing so you can always call it no matter what the
   * type.
   */
  void (*AddRef)(struct PP_Var var);
  /**
   * Removes a reference to given var, deleting it if the internal refcount
   * becomes 0. If the given var is not a refcounted object, this function will
   * do nothing so you can always call it no matter what the type.
   */
  void (*Release)(struct PP_Var var);
  /**
   * Creates a string var from a string. The string must be encoded in valid
   * UTF-8 and is NOT NULL-terminated, the length must be specified in |len|.
   * It is an error if the string is not valid UTF-8.
   *
   * If the length is 0, the |data| pointer will not be dereferenced and may
   * be NULL. Note, however, that if you do this, the "NULL-ness" will not be
   * preserved, as VarToUtf8 will never return NULL on success, even for empty
   * strings.
   *
   * The resulting object will be a refcounted string object. It will be
   * AddRef()ed for the caller. When the caller is done with it, it should be
   * Release()d.
   *
   * On error (basically out of memory to allocate the string, or input that
   * is not valid UTF-8), this function will return a Null var.
   */
  struct PP_Var (*VarFromUtf8)(PP_Module module,
                               const char* data,
                               uint32_t len);
  /**
   * Converts a string-type var to a char* encoded in UTF-8. This string is NOT
   * NULL-terminated. The length will be placed in |*len|. If the string is
   * valid but empty the return value will be non-NULL, but |*len| will still
   * be 0.
   *
   * If the var is not a string, this function will return NULL and |*len| will
   * be 0.
   *
   * The returned buffer will be valid as long as the underlying var is alive.
   * If the plugin frees its reference, the string will be freed and the pointer
   * will be to random memory.
   */
  const char* (*VarToUtf8)(struct PP_Var var, uint32_t* len);
  /**
   * Returns true if the property with the given name exists on the given
   * object, false if it does not. Methods are also counted as properties.
   *
   * The name can either be a string or an integer var. It is an error to pass
   * another type of var as the name.
   *
   * If you pass an invalid name or object, the exception will be set (if it is
   * non-NULL, and the return value will be false).
   */
  PP_Bool (*HasProperty)(struct PP_Var object,
                         struct PP_Var name,
                         struct PP_Var* exception);
  /**
   * Identical to HasProperty, except that HasMethod additionally checks if the
   * property is a function.
   */
  PP_Bool (*HasMethod)(struct PP_Var object,
                       struct PP_Var name,
                       struct PP_Var* exception);
  /**
   * Returns the value of the given property. If the property doesn't exist, the
   * exception (if non-NULL) will be set and a "Void" var will be returned.
   */
  struct PP_Var (*GetProperty)(struct PP_Var object,
                               struct PP_Var name,
                               struct PP_Var* exception);
  /**
   * Retrieves all property names on the given object. Property names include
   * methods.
   *
   * If there is a failure, the given exception will be set (if it is non-NULL).
   * On failure, |*properties| will be set to NULL and |*property_count| will be
   * set to 0.
   *
   * A pointer to the array of property names will be placesd in |*properties|.
   * The caller is responsible for calling Release() on each of these properties
   * (as per normal refcounted memory management) as well as freeing the array
   * pointer with PPB_Core.MemFree().
   *
   * This function returns all "enumerable" properties. Some JavaScript
   * properties are "hidden" and these properties won't be retrieved by this
   * function, yet you can still set and get them.
   *
   * Example:
   * <pre>  uint32_t count;
   *   PP_Var* properties;
   *   ppb_var.GetAllPropertyNames(object, &count, &properties);
   *
   *   ...use the properties here...
   *
   *   for (uint32_t i = 0; i < count; i++)
   *     ppb_var.Release(properties[i]);
   *   ppb_core.MemFree(properties); </pre>
   */
  void (*GetAllPropertyNames)(struct PP_Var object,
                              uint32_t* property_count,
                              struct PP_Var** properties,
                              struct PP_Var* exception);
  /**
   * Sets the property with the given name on the given object. The exception
   * will be set, if it is non-NULL, on failure.
   */
  void (*SetProperty)(struct PP_Var object,
                      struct PP_Var name,
                      struct PP_Var value,
                      struct PP_Var* exception);
  /**
   * Removes the given property from the given object. The property name must
   * be an string or integer var, using other types will throw an exception
   * (assuming the exception pointer is non-NULL).
   */
  void (*RemoveProperty)(struct PP_Var object,
                         struct PP_Var name,
                         struct PP_Var* exception);
  /* TODO(brettw) need native array access here. */
  /**
   * Invoke the function |method_name| on the given object. If |method_name|
   * is a Null var, the default method will be invoked, which is how you can
   * invoke function objects.
   *
   * Unless it is type Null, |method_name| must be a string. Unlike other
   * Var functions, integer lookup is not supported since you can't call
   * functions on integers in JavaScript.
   *
   * Pass the arguments to the function in order in the |argv| array, and the
   * number of arguments in the |argc| parameter. |argv| can be NULL if |argc|
   * is zero.
   *
   * Example:
   *   Call(obj, VarFromUtf8("DoIt"), 0, NULL, NULL) = obj.DoIt() in JavaScript.
   *   Call(obj, PP_MakeNull(), 0, NULL, NULL) = obj() in JavaScript.
   */
  struct PP_Var (*Call)(struct PP_Var object,
                        struct PP_Var method_name,
                        uint32_t argc,
                        const struct PP_Var argv[],
                        struct PP_Var* exception);
  /**
   * Invoke the object as a constructor.
   *
   * For example, if |object| is |String|, this is like saying |new String| in
   * JavaScript.
   */
  struct PP_Var (*Construct)(struct PP_Var object,
                             uint32_t argc,
                             const struct PP_Var argv[],
                             struct PP_Var* exception);
  /**
   * If the object is an instance of the given class, then this method returns
   * true and sets *object_data to the value passed to CreateObject provided
   * object_data is non-NULL. Otherwise, this method returns false.
   */
  PP_Bool (*IsInstanceOf)(struct PP_Var var,
                          const struct PPP_Class_Deprecated_1_0* object_class,
                          void* object_data);
  /**
   * Creates an object that the plugin implements. The plugin supplies a
   * pointer to the class interface it implements for that object, and its
   * associated internal data that represents that object. This object data
   * must be unique among all "live" objects.
   *
   * The returned object will have a reference count of 1. When the reference
   * count reached 0, the class' Destruct function wlil be called.
   *
   * On failure, this will return a null var. This probably means the module
   * was invalid.
   *
   * Example: Say we're implementing a "Point" object.
   * <pre>  void PointDestruct(void* object) {
   *     delete (Point*)object;
   *   }
   *
   *   const PPP_Class_Deprecated point_class = {
   *     ... all the other class functions go here ...
   *     &PointDestruct
   *   };
   *
   *    * The plugin's internal object associated with the point.
   *   class Point {
   *     ...
   *   };
   *
   *   PP_Var MakePoint(int x, int y) {
   *     return CreateObject(&point_class, new Point(x, y));
   *   }</pre>
   */
  struct PP_Var (*CreateObject)(
      PP_Instance instance,
      const struct PPP_Class_Deprecated_1_0* object_class,
      void* object_data);
  /* Like CreateObject but takes a module. This will be deleted when all callers
   * can be changed to use the PP_Instance CreateObject one. */
  struct PP_Var (*CreateObjectWithModuleDeprecated)(
      PP_Module module,
      const struct PPP_Class_Deprecated_1_0* object_class,
      void* object_data);
};

typedef struct PPB_Var_Deprecated_0_3 PPB_Var_Deprecated;
/**
 * @}
 */

/* dev/ppb_video_capture_dev.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * Video capture interface. It goes hand-in-hand with PPP_VideoCapture_Dev.
 *
 * Theory of operation:
 * 1- Create a VideoCapture resource using Create.
 * 2- Find available video capture devices using EnumerateDevices.
 * 3- Open a video capture device. In addition to a device reference (0 can be
 * used to indicate the default device), you pass in the requested info
 * (resolution, frame rate), as well as suggest a number of buffers you will
 * need.
 * 4- Start the capture using StartCapture.
 * 5- Receive the OnDeviceInfo callback, in PPP_VideoCapture_Dev, which will
 * give you the actual capture info (the requested one is not guaranteed), as
 * well as an array of buffers allocated by the browser.
 * 6- On every frame captured by the browser, OnBufferReady (in
 * PPP_VideoCapture_Dev) is called with the index of the buffer from the array
 * containing the new frame. The buffer is now "owned" by the plugin, and the
 * browser won't reuse it until ReuseBuffer is called.
 * 7- When the plugin is done with the buffer, call ReuseBuffer.
 * 8- Stop the capture using StopCapture.
 * 9- Close the device.
 *
 * The browser may change the resolution based on the constraints of the system,
 * in which case OnDeviceInfo will be called again, with new buffers.
 *
 * The buffers contain the pixel data for a frame. The format is planar YUV
 * 4:2:0, one byte per pixel, tightly packed (width x height Y values, then
 * width/2 x height/2 U values, then width/2 x height/2 V values).
 */
struct PPB_VideoCapture_Dev_0_3 {
  /**
   * Creates a new VideoCapture.
   */
  PP_Resource (*Create)(PP_Instance instance);
  /**
   * Returns PP_TRUE if the given resource is a VideoCapture.
   */
  PP_Bool (*IsVideoCapture)(PP_Resource video_capture);
  /**
   * Enumerates video capture devices.
   *
   * @param[in] video_capture A <code>PP_Resource</code> corresponding to a
   * video capture resource.
   * @param[in] output An output array which will receive
   * <code>PPB_DeviceRef_Dev</code> resources on success. Please note that the
   * ref count of those resources has already been increased by 1 for the
   * caller.
   * @param[in] callback A <code>PP_CompletionCallback</code> to run on
   * completion.
   *
   * @return An error code from <code>pp_errors.h</code>.
   */
  int32_t (*EnumerateDevices)(PP_Resource video_capture,
                              struct PP_ArrayOutput output,
                              struct PP_CompletionCallback callback);
  /**
   * Requests device change notifications.
   *
   * @param[in] video_capture A <code>PP_Resource</code> corresponding to a
   * video capture resource.
   * @param[in] callback The callback to receive notifications. If not NULL, it
   * will be called once for the currently available devices, and then every
   * time the list of available devices changes. All calls will happen on the
   * same thread as the one on which MonitorDeviceChange() is called. It will
   * receive notifications until <code>video_capture</code> is destroyed or
   * <code>MonitorDeviceChange()</code> is called to set a new callback for
   * <code>video_capture</code>. You can pass NULL to cancel sending
   * notifications.
   * @param[inout] user_data An opaque pointer that will be passed to
   * <code>callback</code>.
   *
   * @return An error code from <code>pp_errors.h</code>.
   */
  int32_t (*MonitorDeviceChange)(PP_Resource video_capture,
                                 PP_MonitorDeviceChangeCallback callback,
                                 void* user_data);
  /**
   * Opens a video capture device. |device_ref| identifies a video capture
   * device. It could be one of the resource in the array returned by
   * |EnumerateDevices()|, or 0 which means the default device.
   * |requested_info| is a pointer to a structure containing the requested
   * resolution and frame rate. |buffer_count| is the number of buffers
   * requested by the plugin. Note: it is only used as advisory, the browser may
   * allocate more or fewer based on available resources. How many buffers
   * depends on usage. At least 2 to make sure latency doesn't cause lost
   * frames. If the plugin expects to hold on to more than one buffer at a time
   * (e.g. to do multi-frame processing, like video encoding), it should request
   * that many more.
   */
  int32_t (*Open)(PP_Resource video_capture,
                  PP_Resource device_ref,
                  const struct PP_VideoCaptureDeviceInfo_Dev* requested_info,
                  uint32_t buffer_count,
                  struct PP_CompletionCallback callback);
  /**
   * Starts the capture.
   *
   * Returns PP_ERROR_FAILED if called when the capture was already started, or
   * PP_OK on success.
   */
  int32_t (*StartCapture)(PP_Resource video_capture);
  /**
   * Allows the browser to reuse a buffer that was previously sent by
   * PPP_VideoCapture_Dev.OnBufferReady. |buffer| is the index of the buffer in
   * the array returned by PPP_VideoCapture_Dev.OnDeviceInfo.
   *
   * Returns PP_ERROR_BADARGUMENT if buffer is out of range (greater than the
   * number of buffers returned by PPP_VideoCapture_Dev.OnDeviceInfo), or if it
   * is not currently owned by the plugin. Returns PP_OK otherwise.
   */
  int32_t (*ReuseBuffer)(PP_Resource video_capture, uint32_t buffer);
  /**
   * Stops the capture.
   *
   * Returns PP_ERROR_FAILED if the capture wasn't already started, or PP_OK on
   * success.
   */
  int32_t (*StopCapture)(PP_Resource video_capture);
  /**
   * Closes the video capture device, and stops capturing if necessary. It is
   * not valid to call |Open()| again after a call to this method.
   * If a video capture resource is destroyed while a device is still open, then
   * it will be implicitly closed, so you are not required to call this method.
   */
  void (*Close)(PP_Resource video_capture);
};

typedef struct PPB_VideoCapture_Dev_0_3 PPB_VideoCapture_Dev;
/**
 * @}
 */

/* dev/ppb_video_decoder_dev.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * Video decoder interface.
 *
 * Typical usage:
 * - Use Create() to create & configure a new PPB_VideoDecoder_Dev resource.
 * - Call Decode() to decode some video data.
 * - Receive ProvidePictureBuffers callback
 *   - Supply the decoder with textures using AssignPictureBuffers.
 * - Receive PictureReady callbacks
 *   - Hand the textures back to the decoder using ReusePictureBuffer.
 * - To signal EOS to the decoder: call Flush() and wait for NotifyFlushDone
 *   callback.
 * - To reset the decoder (e.g. to implement Seek): call Reset() and wait for
 *   NotifyResetDone callback.
 * - To tear down the decoder call Destroy().
 *
 * See PPP_VideoDecoder_Dev for the notifications the decoder may send the
 * plugin.
 */
struct PPB_VideoDecoder_Dev_0_16 {
  /**
   * Creates & initializes a video decoder.
   *
   * Parameters:
   *   |instance| pointer to the plugin instance.
   *   |context| a PPB_Graphics3D resource in which decoding will happen.
   *   |profile| the video stream's format profile.
   *
   * The created decoder is returned as PP_Resource. 0 means failure.
   */
  PP_Resource (*Create)(PP_Instance instance,
                        PP_Resource context,
                        PP_VideoDecoder_Profile profile);
  /**
   * Tests whether |resource| is a video decoder created through Create
   * function of this interface.
   *
   * Parameters:
   *   |resource| is handle to resource to test.
   *
   * Returns true if is a video decoder, false otherwise.
   */
  PP_Bool (*IsVideoDecoder)(PP_Resource resource);
  /**
   * Dispatches bitstream buffer to the decoder.
   *
   * Parameters:
   *   |video_decoder| is the previously created handle to the decoder resource.
   *   |bitstream_buffer| is the bitstream buffer that contains at most one
   *   input frame.
   *   |callback| will be called when |bitstream_buffer| has been processed by
   *   the decoder.
   *
   * Returns an error code from pp_errors.h.
   */
  int32_t (*Decode)(PP_Resource video_decoder,
                    const struct PP_VideoBitstreamBuffer_Dev* bitstream_buffer,
                    struct PP_CompletionCallback callback);
  /**
   * Provides the decoder with texture-backed picture buffers for video
   * decoding.
   *
   * This function should be called when the plugin has its
   * ProvidePictureBuffers method called.  The decoder will stall until it has
   * received all the buffers it's asked for.
   *
   * Parameters:
   *   |video_decoder| is the previously created handle to the decoder resource.
   *   |no_of_buffers| how many buffers are behind picture buffer pointer.
   *   |buffers| contains the reference to the picture buffer that was
   *   allocated.
   */
  void (*AssignPictureBuffers)(PP_Resource video_decoder,
                               uint32_t no_of_buffers,
                               const struct PP_PictureBuffer_Dev buffers[]);
  /**
   * Tells the decoder to reuse the given picture buffer. Typical use of this
   * function is to call from PictureReady callback to recycle picture buffer
   * back to the decoder after blitting the image so that decoder can use the
   * image for output again.
   *
   * Parameters:
   *   |video_decoder| is the previously created handle to the decoder resource.
   *   |picture_buffer_id| contains the id of the picture buffer that was
   *   processed.
   */
  void (*ReusePictureBuffer)(PP_Resource video_decoder,
                             int32_t picture_buffer_id);
  /**
   * Flush input and output buffers in the decoder.  Any pending inputs are
   * decoded and pending outputs are delivered to the plugin.  Once done
   * flushing, the decoder will call |callback|.
   *
   * Parameters:
   *   |video_decoder| is the previously created handle to the decoder resource.
   *   |callback| is one-time callback that will be called once the flushing
   *   request has been completed.
   *
   * Returns an error code from pp_errors.h.
   */
  int32_t (*Flush)(PP_Resource video_decoder,
                   struct PP_CompletionCallback callback);
  /**
   * Reset the decoder as quickly as possible.  Pending inputs and outputs are
   * dropped and the decoder is put back into a state ready to receive further
   * Decode() calls.  |callback| will be called when the reset is done.
   *
   * Parameters:
   *   |video_decoder| is the previously created handle to the decoder resource.
   *   |callback| is one-time callback that will be called once the reset
   *   request has been completed.
   *
   * Returns an error code from pp_errors.h.
   */
  int32_t (*Reset)(PP_Resource video_decoder,
                   struct PP_CompletionCallback callback);
  /**
   * Tear down the decoder as quickly as possible.  Pending inputs and outputs
   * are dropped and the decoder frees all of its resources.  Although resources
   * may be freed asynchronously, after this method returns no more callbacks
   * will be made on the client.  Any resources held by the client at that point
   * may be freed.
   *
   * Parameters:
   *   |video_decoder| is the previously created handle to the decoder resource.
   */
  void (*Destroy)(PP_Resource video_decoder);
};

typedef struct PPB_VideoDecoder_Dev_0_16 PPB_VideoDecoder_Dev;
/**
 * @}
 */

/* dev/ppb_view_dev.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/* PPB_View_Dev interface */
struct PPB_View_Dev_0_1 {
  /**
   * GetDeviceScale returns the scale factor between device pixels and DIPs
   * (also known as logical pixels or UI pixels on some platforms). This allows
   * the developer to render their contents at device resolution, even as
   * coordinates / sizes are given in DIPs through the API.
   *
   * Note that the coordinate system for Pepper APIs is DIPs. Also note that
   * one DIP might not equal one CSS pixel - when page scale/zoom is in effect.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to a
   * <code>PPB_View</code> resource.
   *
   * @return A <code>float</code> value representing the number of device pixels
   * per DIP. If the resource is invalid, the value will be 0.0.
   */
  float (*GetDeviceScale)(PP_Resource resource);
  /**
   * GetCSSScale returns the scale factor between DIPs and CSS pixels. This
   * allows proper scaling between DIPs - as sent via the Pepper API - and CSS
   * pixel coordinates used for Web content.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to a
   * <code>PPB_View</code> resource.
   *
   * @return css_scale A <code>float</code> value representing the number of
   * DIPs per CSS pixel. If the resource is invalid, the value will be 0.0.
   */
  float (*GetCSSScale)(PP_Resource resource);
};

typedef struct PPB_View_Dev_0_1 PPB_View_Dev;
/**
 * @}
 */

/* dev/ppp_network_state_dev.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
struct PPP_NetworkState_Dev_0_1 {
  /**
   * Notification that the online state has changed for the user's network.
   * This will change as a result of a network cable being plugged or
   * unplugged, WiFi connections going up and down, or other events.
   *
   * Note that being "online" isn't a guarantee that any particular connections
   * will succeed.
   */
  void (*SetOnLine)(PP_Bool is_online);
};

typedef struct PPP_NetworkState_Dev_0_1 PPP_NetworkState_Dev;
/**
 * @}
 */

/* dev/ppp_printing_dev.idl */
/**
 * @addtogroup Structs
 * @{
 */
/**
 * Specifies a contiguous range of page numbers to be printed.
 * The page numbers use a zero-based index.
 */
struct PP_PrintPageNumberRange_Dev {
  uint32_t first_page_number;
  uint32_t last_page_number;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_PrintPageNumberRange_Dev, 8);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
struct PPP_Printing_Dev_0_6 {
  /**
   *  Returns a bit field representing the supported print output formats.  For
   *  example, if only PDF and PostScript are supported,
   *  QuerySupportedFormats returns a value equivalent to:
   *  (PP_PRINTOUTPUTFORMAT_PDF | PP_PRINTOUTPUTFORMAT_POSTSCRIPT)
   */
  uint32_t (*QuerySupportedFormats)(PP_Instance instance);
  /**
   * Begins a print session with the given print settings. Calls to PrintPages
   * can only be made after a successful call to Begin. Returns the number of
   * pages required for the print output at the given page size (0 indicates
   * a failure).
   */
  int32_t (*Begin)(PP_Instance instance,
                   const struct PP_PrintSettings_Dev* print_settings);
  /**
   * Prints the specified pages using the format specified in Begin.
   * Returns a PPB_Buffer resource that represents the printed output. Returns
   * 0 on failure.
   */
  PP_Resource (*PrintPages)(
      PP_Instance instance,
      const struct PP_PrintPageNumberRange_Dev* page_ranges,
      uint32_t page_range_count);
  /** Ends the print session. Further calls to PrintPages will fail. */
  void (*End)(PP_Instance instance);
  /**
   *  Returns true if the current content should be printed into the full page
   *  and not scaled down to fit within the printer's printable area.
   */
  PP_Bool (*IsScalingDisabled)(PP_Instance instance);
};

typedef struct PPP_Printing_Dev_0_6 PPP_Printing_Dev;
/**
 * @}
 */

/* dev/ppp_text_input_dev.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * <code>PPP_TextInput_Dev</code> is a set of function pointers that the
 * plugin has to implement to provide hints for text input system (IME).
 */
struct PPP_TextInput_Dev_0_1 {
  /**
   * Requests the plugin to send back the text around the current caret or
   * selection by <code>PPB_TextInput_Dev::UpdateSurroundingText</code>.
   * It is recommended to include the <code>desired_number_of_characters</code>
   * characters before and after the selection, but not mandatory.
   */
  void (*RequestSurroundingText)(PP_Instance instance,
                                 uint32_t desired_number_of_characters);
};

typedef struct PPP_TextInput_Dev_0_1 PPP_TextInput_Dev;
/**
 * @}
 */

/* dev/ppp_video_capture_dev.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * Video Capture client interface. See |PPB_VideoCapture_Dev| for general theory
 * of operation.
 */
struct PPP_VideoCapture_Dev_0_1 {
  /**
   * Signals the capture device information, such as resolution and frame rate,
   * and the array of buffers that the browser will use to send pixel data.
   *
   * |info| is a pointer to the PP_VideoCaptureDeviceInfo_Dev structure
   * containing resolution and frame rate.
   * |buffer_count| is the number of buffers, and |buffers| is the array of
   * PPB_Buffer_Dev buffers.
   *
   * Note: the buffers are passed without an extra reference. The plugin is
   * expected to add its own references to the buffers.
   */
  void (*OnDeviceInfo)(PP_Instance instance,
                       PP_Resource video_capture,
                       const struct PP_VideoCaptureDeviceInfo_Dev* info,
                       uint32_t buffer_count,
                       const PP_Resource buffers[]);
  /**
   * Signals status changes on the VideoCapture. |status| is a
   * one of the values from PP_VideoCaptureStatus_Dev;
   */
  void (*OnStatus)(PP_Instance instance,
                   PP_Resource video_capture,
                   uint32_t status);
  /**
   * Signals an error from the video capture system.
   *
   * Errors that can be generated:
   * - PP_ERROR_NOMEMORY: not enough memory was available to allocate buffers.
   * - PP_ERROR_FAILED: video capture could not start.
   */
  void (*OnError)(PP_Instance instance,
                  PP_Resource video_capture,
                  uint32_t error_code);
  /**
   * Signals that a buffer is available for consumption by the plugin.
   *
   * |buffer| is the index of the buffer, in the array returned by OnDeviceInfo.
   */
  void (*OnBufferReady)(PP_Instance instance,
                        PP_Resource video_capture,
                        uint32_t buffer);
};

typedef struct PPP_VideoCapture_Dev_0_1 PPP_VideoCapture_Dev;
/**
 * @}
 */

/* dev/ppp_video_decoder_dev.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * PPP_VideoDecoder_Dev structure contains the function pointers that the
 * plugin MUST implement to provide services needed by the video decoder
 * implementation.
 *
 * See PPB_VideoDecoder_Dev for general usage tips.
 */
struct PPP_VideoDecoder_Dev_0_11 {
  /**
   * Callback function to provide buffers for the decoded output pictures. If
   * succeeds plugin must provide buffers through AssignPictureBuffers function
   * to the API. If |req_num_of_bufs| matching exactly the specification
   * given in the parameters cannot be allocated decoder should be destroyed.
   *
   * Decoding will not proceed until buffers have been provided.
   *
   * Parameters:
   *  |instance| the plugin instance to which the callback is responding.
   *  |decoder| the PPB_VideoDecoder_Dev resource.
   *  |req_num_of_bufs| tells how many buffers are needed by the decoder.
   *  |dimensions| tells the dimensions of the buffer to allocate.
   *  |texture_target| the type of texture used. Sample targets in use are
   *      TEXTURE_2D (most platforms) and TEXTURE_EXTERNAL_OES (on ARM).
   */
  void (*ProvidePictureBuffers)(PP_Instance instance,
                                PP_Resource decoder,
                                uint32_t req_num_of_bufs,
                                const struct PP_Size* dimensions,
                                uint32_t texture_target);
  /**
   * Callback function for decoder to deliver unneeded picture buffers back to
   * the plugin.
   *
   * Parameters:
   *  |instance| the plugin instance to which the callback is responding.
   *  |decoder| the PPB_VideoDecoder_Dev resource.
   *  |picture_buffer| points to the picture buffer that is no longer needed.
   */
  void (*DismissPictureBuffer)(PP_Instance instance,
                               PP_Resource decoder,
                               int32_t picture_buffer_id);
  /**
   * Callback function for decoder to deliver decoded pictures ready to be
   * displayed. Decoder expects the plugin to return the buffer back to the
   * decoder through ReusePictureBuffer function in PPB Video Decoder API.
   *
   * Parameters:
   *  |instance| the plugin instance to which the callback is responding.
   *  |decoder| the PPB_VideoDecoder_Dev resource.
   *  |picture| is the picture that is ready.
   */
  void (*PictureReady)(PP_Instance instance,
                       PP_Resource decoder,
                       const struct PP_Picture_Dev* picture);
  /**
   * Error handler callback for decoder to deliver information about detected
   * errors to the plugin.
   *
   * Parameters:
   *  |instance| the plugin instance to which the callback is responding.
   *  |decoder| the PPB_VideoDecoder_Dev resource.
   *  |error| error is the enumeration specifying the error.
   */
  void (*NotifyError)(PP_Instance instance,
                      PP_Resource decoder,
                      PP_VideoDecodeError_Dev error);
};

typedef struct PPP_VideoDecoder_Dev_0_11 PPP_VideoDecoder_Dev;
/**
 * @}
 */

/* private/pp_content_decryptor.idl */
/**
 * @addtogroup Structs
 * @{
 */
struct PP_DecryptTrackingInfo {
  /**
   * Client-specified identifier for the associated decrypt request. By using
   * this value, the client can associate the decrypted block with a decryption
   * request.
   */
  uint32_t request_id;
  /**
   * A unique buffer ID to identify a PPB_Buffer_Dev. Unlike a PP_Resource,
   * this ID is identical at both the renderer side and the plugin side.
   * In <code>PPB_ContentDecryptor_Private</code> calls, this is the ID of the
   * buffer associated with the decrypted block/frame/samples.
   * In <code>PPP_ContentDecryptor_Private</code> calls, this is the ID of a
   * buffer that is no longer need at the renderer side, which can be released
   * or recycled by the plugin. This ID can be 0 if there is no buffer to be
   * released or recycled.
   */
  uint32_t buffer_id;
  /**
   * Timestamp in microseconds of the associated block. By using this value,
   * the client can associate the decrypted (and decoded) data with an input
   * block. This is needed because buffers may be delivered out of order and
   * not in response to the <code>request_id</code> they were provided with.
   */
  int64_t timestamp;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_DecryptTrackingInfo, 16);

/**
 * The <code>PP_DecryptSubsampleDescription</code> struct contains information
 * to support subsample decryption.
 *
 * An input block can be split into several continuous subsamples.
 * A <code>PP_DecryptSubsampleEntry</code> specifies the number of clear and
 * cipher bytes in each subsample. For example, the following block has three
 * subsamples:
 *
 * |<----- subsample1 ----->|<----- subsample2 ----->|<----- subsample3 ----->|
 * |   clear1   |  cipher1  |  clear2  |   cipher2   | clear3 |    cipher3    |
 *
 * For decryption, all of the cipher bytes in a block should be treated as a
 * contiguous (in the subsample order) logical stream. The clear bytes should
 * not be considered as part of decryption.
 *
 * Logical stream to decrypt:   |  cipher1  |   cipher2   |    cipher3    |
 * Decrypted stream:            | decrypted1|  decrypted2 |   decrypted3  |
 *
 * After decryption, the decrypted bytes should be copied over the position
 * of the corresponding cipher bytes in the original block to form the output
 * block. Following the above example, the decrypted block should be:
 *
 * |<----- subsample1 ----->|<----- subsample2 ----->|<----- subsample3 ----->|
 * |   clear1   | decrypted1|  clear2  |  decrypted2 | clear3 |   decrypted3  |
 */
struct PP_DecryptSubsampleDescription {
  /**
   * Size in bytes of clear data in a subsample entry.
   */
  uint32_t clear_bytes;
  /**
   * Size in bytes of encrypted data in a subsample entry.
   */
  uint32_t cipher_bytes;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_DecryptSubsampleDescription, 8);

/**
 * The <code>PP_EncryptedBlockInfo</code> struct contains all the information
 * needed to decrypt an encrypted block.
 */
struct PP_EncryptedBlockInfo {
  /**
   * Information needed by the client to track the block to be decrypted.
   */
  struct PP_DecryptTrackingInfo tracking_info;
  /**
   * Size in bytes of data to be decrypted (data_offset included).
   */
  uint32_t data_size;
  /**
   * Key ID of the block to be decrypted.
   *
   * For WebM the key ID can be as large as 2048 bytes in theory. But it's not
   * used in current implementations. If we really need to support it, we should
   * move key ID out as a separate parameter, e.g. as a <code>PP_Var</code>, or
   * make the whole <code>PP_EncryptedBlockInfo</code> as a
   * <code>PP_Resource</code>.
   */
  uint8_t key_id[64];
  uint32_t key_id_size;
  /**
   * Initialization vector of the block to be decrypted.
   */
  uint8_t iv[16];
  uint32_t iv_size;
  /**
   * Subsample information of the block to be decrypted.
   *
   * We need to have a fixed size of |subsamples| here. Choose 32 because it is
   * sufficient for almost all real life scenarios. Note that in theory the
   * number of subsamples could be larger than 32. If that happens, playback
   * will fail.
   */
  struct PP_DecryptSubsampleDescription subsamples[32];
  uint32_t num_subsamples;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_EncryptedBlockInfo, 368);
/**
 * @}
 */

/**
 * @addtogroup Enums
 * @{
 */
/**
 * <code>PP_DecryptedFrameFormat</code> contains video frame formats.
 */
typedef enum {
  PP_DECRYPTEDFRAMEFORMAT_UNKNOWN = 0,
  PP_DECRYPTEDFRAMEFORMAT_YV12 = 1,
  PP_DECRYPTEDFRAMEFORMAT_I420 = 2
} PP_DecryptedFrameFormat;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_DecryptedFrameFormat, 4);

/**
 * <code>PP_DecryptedSampleFormat</code> contains audio sample formats.
 */
typedef enum {
  PP_DECRYPTEDSAMPLEFORMAT_UNKNOWN = 0,
  PP_DECRYPTEDSAMPLEFORMAT_U8 = 1,
  PP_DECRYPTEDSAMPLEFORMAT_S16 = 2,
  PP_DECRYPTEDSAMPLEFORMAT_S32 = 3,
  PP_DECRYPTEDSAMPLEFORMAT_F32 = 4,
  PP_DECRYPTEDSAMPLEFORMAT_PLANAR_S16 = 5,
  PP_DECRYPTEDSAMPLEFORMAT_PLANAR_F32 = 6
} PP_DecryptedSampleFormat;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_DecryptedSampleFormat, 4);

/**
 * The <code>PP_DecryptResult</code> enum contains decryption and decoding
 * result constants.
 */
typedef enum {
  /** The decryption (and/or decoding) operation finished successfully. */
  PP_DECRYPTRESULT_SUCCESS = 0,
  /** The decryptor did not have the necessary decryption key. */
  PP_DECRYPTRESULT_DECRYPT_NOKEY = 1,
  /** The input was accepted by the decoder but no frame(s) can be produced. */
  PP_DECRYPTRESULT_NEEDMOREDATA = 2,
  /** An unexpected error happened during decryption. */
  PP_DECRYPTRESULT_DECRYPT_ERROR = 3,
  /** An unexpected error happened during decoding. */
  PP_DECRYPTRESULT_DECODE_ERROR = 4
} PP_DecryptResult;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_DecryptResult, 4);
/**
 * @}
 */

/**
 * @addtogroup Structs
 * @{
 */
/**
 * <code>PP_DecryptedBlockInfo</code> struct contains the decryption result and
 * tracking info associated with the decrypted block.
 */
struct PP_DecryptedBlockInfo {
  /**
   * Result of the decryption (and/or decoding) operation.
   */
  PP_DecryptResult result;
  /**
   * Size in bytes of decrypted data, which may be less than the size of the
   * corresponding buffer.
   */
  uint32_t data_size;
  /**
   * Information needed by the client to track the block to be decrypted.
   */
  struct PP_DecryptTrackingInfo tracking_info;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_DecryptedBlockInfo, 24);
/**
 * @}
 */

/**
 * @addtogroup Enums
 * @{
 */
/**
 * <code>PP_DecryptedFramePlanes</code> provides YUV plane index values for
 * accessing plane offsets stored in <code>PP_DecryptedFrameInfo</code>.
 */
typedef enum {
  PP_DECRYPTEDFRAMEPLANES_Y = 0,
  PP_DECRYPTEDFRAMEPLANES_U = 1,
  PP_DECRYPTEDFRAMEPLANES_V = 2
} PP_DecryptedFramePlanes;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_DecryptedFramePlanes, 4);
/**
 * @}
 */

/**
 * @addtogroup Structs
 * @{
 */
/**
 * <code>PP_DecryptedFrameInfo</code> contains the result of the
 * decrypt and decode operation on the associated frame, information required
 * to access the frame data in buffer, and tracking info.
 */
struct PP_DecryptedFrameInfo {
  /**
   * Result of the decrypt and decode operation.
   */
  PP_DecryptResult result;
  /**
   * Format of the decrypted frame.
   */
  PP_DecryptedFrameFormat format;
  /**
   * Offsets into the buffer resource for accessing video planes.
   */
  int32_t plane_offsets[3];
  /**
   * Stride of each plane.
   */
  int32_t strides[3];
  /**
   * Width of the video frame, in pixels.
   */
  int32_t width;
  /**
   * Height of the video frame, in pixels.
   */
  int32_t height;
  /**
   * Information needed by the client to track the decrypted frame.
   */
  struct PP_DecryptTrackingInfo tracking_info;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_DecryptedFrameInfo, 56);

/**
 * <code>PP_DecryptedSampleInfo</code> contains the result of the
 * decrypt and decode operation on the associated samples, information required
 * to access the sample data in buffer, and tracking info.
 */
struct PP_DecryptedSampleInfo {
  /**
   * Result of the decrypt and decode operation.
   */
  PP_DecryptResult result;
  /**
   * Format of the decrypted samples.
   */
  PP_DecryptedSampleFormat format;
  /**
   * Size in bytes of decrypted samples.
   */
  uint32_t data_size;
  /**
   * 4-byte padding to make the size of <code>PP_DecryptedSampleInfo</code>
   * a multiple of 8 bytes. The value of this field should not be used.
   */
  uint32_t padding;
  /**
   * Information needed by the client to track the decrypted samples.
   */
  struct PP_DecryptTrackingInfo tracking_info;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_DecryptedSampleInfo, 32);
/**
 * @}
 */

/**
 * @addtogroup Enums
 * @{
 */
/**
 * <code>PP_AudioCodec</code> contains audio codec type constants.
 */
typedef enum {
  PP_AUDIOCODEC_UNKNOWN = 0,
  PP_AUDIOCODEC_VORBIS = 1,
  PP_AUDIOCODEC_AAC = 2
} PP_AudioCodec;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_AudioCodec, 4);
/**
 * @}
 */

/**
 * @addtogroup Structs
 * @{
 */
/**
 * <code>PP_AudioDecoderConfig</code> contains audio decoder configuration
 * information required to initialize audio decoders, and a request ID
 * that allows clients to associate a decoder initialization request with a
 * status response. Note: When <code>codec</code> requires extra data for
 * initialization, the data is sent as a <code>PP_Resource</code> carried
 * alongside <code>PP_AudioDecoderConfig</code>.
 */
struct PP_AudioDecoderConfig {
  /**
   * The audio codec to initialize.
   */
  PP_AudioCodec codec;
  /**
   * Number of audio channels.
   */
  int32_t channel_count;
  /**
   * Size of each audio channel.
   */
  int32_t bits_per_channel;
  /**
   * Audio sampling rate.
   */
  int32_t samples_per_second;
  /**
   * Client-specified identifier for the associated audio decoder initialization
   * request. By using this value, the client can associate a decoder
   * initialization status response with an initialization request.
   */
  uint32_t request_id;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_AudioDecoderConfig, 20);
/**
 * @}
 */

/**
 * @addtogroup Enums
 * @{
 */
/**
 * <code>PP_VideoCodec</code> contains video codec type constants.
 */
typedef enum {
  PP_VIDEOCODEC_UNKNOWN = 0,
  PP_VIDEOCODEC_VP8 = 1,
  PP_VIDEOCODEC_H264 = 2,
  PP_VIDEOCODEC_VP9 = 3
} PP_VideoCodec;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_VideoCodec, 4);

/**
 * <code>PP_VideoCodecProfile</code> contains video codec profile type
 * constants required for video decoder configuration.
 *.
 */
typedef enum {
  PP_VIDEOCODECPROFILE_UNKNOWN = 0,
  PP_VIDEOCODECPROFILE_NOT_NEEDED = 1,
  PP_VIDEOCODECPROFILE_H264_BASELINE = 2,
  PP_VIDEOCODECPROFILE_H264_MAIN = 3,
  PP_VIDEOCODECPROFILE_H264_EXTENDED = 4,
  PP_VIDEOCODECPROFILE_H264_HIGH = 5,
  PP_VIDEOCODECPROFILE_H264_HIGH_10 = 6,
  PP_VIDEOCODECPROFILE_H264_HIGH_422 = 7,
  PP_VIDEOCODECPROFILE_H264_HIGH_444_PREDICTIVE = 8
} PP_VideoCodecProfile;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_VideoCodecProfile, 4);
/**
 * @}
 */

/**
 * @addtogroup Structs
 * @{
 */
/**
 * <code>PP_VideoDecoderConfig</code> contains video decoder configuration
 * information required to initialize video decoders, and a request ID
 * that allows clients to associate a decoder initialization request with a
 * status response. Note: When <code>codec</code> requires extra data for
 * initialization, the data is sent as a <code>PP_Resource</code> carried
 * alongside <code>PP_VideoDecoderConfig</code>.
 */
struct PP_VideoDecoderConfig {
  /**
   * The video codec to initialize.
   */
  PP_VideoCodec codec;
  /**
   * Profile to use when initializing the video codec.
   */
  PP_VideoCodecProfile profile;
  /**
   * Output video format.
   */
  PP_DecryptedFrameFormat format;
  /**
   * Width of decoded video frames, in pixels.
   */
  int32_t width;
  /**
   * Height of decoded video frames, in pixels.
   */
  int32_t height;
  /**
   * Client-specified identifier for the associated video decoder initialization
   * request. By using this value, the client can associate a decoder
   * initialization status response with an initialization request.
   */
  uint32_t request_id;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_VideoDecoderConfig, 24);
/**
 * @}
 */

/**
 * @addtogroup Enums
 * @{
 */
/**
 * <code>PP_DecryptorStreamType</code> contains stream type constants.
 */
typedef enum {
  PP_DECRYPTORSTREAMTYPE_AUDIO = 0,
  PP_DECRYPTORSTREAMTYPE_VIDEO = 1
} PP_DecryptorStreamType;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_DecryptorStreamType, 4);

/**
 * <code>PP_SessionType</code> contains session type constants.
 */
typedef enum {
  PP_SESSIONTYPE_TEMPORARY = 0,
  PP_SESSIONTYPE_PERSISTENT_LICENSE = 1,
  PP_SESSIONTYPE_PERSISTENT_RELEASE = 2
} PP_SessionType;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_SessionType, 4);

/**
 * <code>PP_InitDataType</code> contains Initialization Data Type constants.
 */
typedef enum {
  PP_INITDATATYPE_CENC = 0,
  PP_INITDATATYPE_KEYIDS = 1,
  PP_INITDATATYPE_WEBM = 2
} PP_InitDataType;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_InitDataType, 4);

/**
 * <code>PP_CdmExceptionCode</code> contains exception code constants.
 */
typedef enum {
  PP_CDMEXCEPTIONCODE_NOTSUPPORTEDERROR = 1,
  PP_CDMEXCEPTIONCODE_INVALIDSTATEERROR = 2,
  PP_CDMEXCEPTIONCODE_INVALIDACCESSERROR = 3,
  PP_CDMEXCEPTIONCODE_QUOTAEXCEEDEDERROR = 4,
  PP_CDMEXCEPTIONCODE_UNKNOWNERROR = 5,
  PP_CDMEXCEPTIONCODE_CLIENTERROR = 6,
  PP_CDMEXCEPTIONCODE_OUTPUTERROR = 7
} PP_CdmExceptionCode;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_CdmExceptionCode, 4);

/**
 * <code>PP_CdmMessageType</code> contains message type constants.
 */
typedef enum {
  PP_CDMMESSAGETYPE_LICENSE_REQUEST = 0,
  PP_CDMMESSAGETYPE_LICENSE_RENEWAL = 1,
  PP_CDMMESSAGETYPE_LICENSE_RELEASE = 2
} PP_CdmMessageType;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_CdmMessageType, 4);

/**
 * <code>PP_CdmKeyStatus</code> contains key status constants.
 */
typedef enum {
  PP_CDMKEYSTATUS_USABLE = 0,
  PP_CDMKEYSTATUS_INVALID = 1,
  PP_CDMKEYSTATUS_EXPIRED = 2,
  PP_CDMKEYSTATUS_OUTPUTRESTRICTED = 3,
  PP_CDMKEYSTATUS_OUTPUTDOWNSCALED = 4,
  PP_CDMKEYSTATUS_STATUSPENDING = 5,
  PP_CDMKEYSTATUS_RELEASED = 6
} PP_CdmKeyStatus;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_CdmKeyStatus, 4);
/**
 * @}
 */

/**
 * @addtogroup Structs
 * @{
 */
/**
 * The <code>PP_KeyInformation</code> struct contains information about a
 * key used for decryption.
 */
struct PP_KeyInformation {
  /**
   * Key ID.
   */
  uint8_t key_id[512];
  uint32_t key_id_size;
  /**
   * Status of this key.
   */
  PP_CdmKeyStatus key_status;
  /**
   * Optional error code for keys that are not usable.
   */
  uint32_t system_code;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_KeyInformation, 524);
/**
 * @}
 */

/* private/pp_file_handle.idl */

#ifdef _WIN32
#include<windows.h>
typedef HANDLE PP_FileHandle;
static const PP_FileHandle PP_kInvalidFileHandle = NULL;

#else
typedef int PP_FileHandle;
static const PP_FileHandle PP_kInvalidFileHandle = -1;
#endif

/* private/pp_private_font_charset.idl */
/**
 * @addtogroup Enums
 * @{
 */
typedef enum {
  PP_PRIVATEFONTCHARSET_ANSI = 0,
  PP_PRIVATEFONTCHARSET_DEFAULT = 1,
  PP_PRIVATEFONTCHARSET_SYMBOL = 2,
  PP_PRIVATEFONTCHARSET_MAC = 77,
  PP_PRIVATEFONTCHARSET_SHIFTJIS = 128,
  PP_PRIVATEFONTCHARSET_HANGUL = 129,
  PP_PRIVATEFONTCHARSET_JOHAB = 130,
  PP_PRIVATEFONTCHARSET_GB2312 = 134,
  PP_PRIVATEFONTCHARSET_CHINESEBIG5 = 136,
  PP_PRIVATEFONTCHARSET_GREEK = 161,
  PP_PRIVATEFONTCHARSET_TURKISH = 162,
  PP_PRIVATEFONTCHARSET_VIETNAMESE = 163,
  PP_PRIVATEFONTCHARSET_HEBREW = 177,
  PP_PRIVATEFONTCHARSET_ARABIC = 178,
  PP_PRIVATEFONTCHARSET_BALTIC = 186,
  PP_PRIVATEFONTCHARSET_RUSSIAN = 204,
  PP_PRIVATEFONTCHARSET_THAI = 222,
  PP_PRIVATEFONTCHARSET_EASTEUROPE = 238,
  PP_PRIVATEFONTCHARSET_OEM = 255
} PP_PrivateFontCharset;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_PrivateFontCharset, 4);
/**
 * @}
 */

/* private/pp_video_capture_format.idl */
/**
 * @addtogroup Structs
 * @{
 */
/**
 * The <code>PP_VideoCaptureFormat</code> struct represents a video capture
 * format.
 */
struct PP_VideoCaptureFormat {
  /**
   * Frame size in pixels.
   */
  struct PP_Size frame_size;
  /**
   * Frame rate in frames per second.
   */
  float frame_rate;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_VideoCaptureFormat, 12);
/**
 * @}
 */

/* private/pp_video_frame_private.idl */
/**
 * @addtogroup Structs
 * @{
 */
/**
 * The <code>PP_VideoFrame_Private</code> struct represents a video frame.
 * Video sources and destinations use frames to transfer video to and from
 * the browser.
 */
struct PP_VideoFrame_Private {
  /**
   * A timestamp placing the frame in a video stream.
   */
  PP_TimeTicks timestamp;
  /**
   * An image data resource to hold the video frame.
   */
  PP_Resource image_data;
  /**
   * Ensure that this struct is 16-bytes wide by padding the end.  In some
   * compilers, PP_TimeTicks is 8-byte aligned, so those compilers align this
   * struct on 8-byte boundaries as well and pad it to 8 bytes even without this
   * padding attribute.  This padding makes its size consistent across
   * compilers.
   */
  int32_t padding;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_VideoFrame_Private, 16);
/**
 * @}
 */

/* private/ppb_camera_capabilities_private.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPB_CameraCapabilities_Private</code> interface contains pointers
 * to several functions for getting the image capture capabilities within the
 * browser.
 */
struct PPB_CameraCapabilities_Private_0_1 {
  /**
   * IsCameraCapabilities() determines if the given resource is a
   * <code>PPB_CameraCapabilities_Private</code>.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to an image
   * capture capabilities resource.
   *
   * @return A <code>PP_Bool</code> containing <code>PP_TRUE</code> if the given
   * resource is an <code>PP_CameraCapabilities_Private</code> resource,
   * otherwise <code>PP_FALSE</code>.
   */
  PP_Bool (*IsCameraCapabilities)(PP_Resource resource);
  /**
   * GetSupportedVideoCaptureFormats() returns the supported video capture
   * formats for the given <code>PPB_CameraCapabilities_Private</code>.
   *
   * @param[in] capabilities A <code>PP_Resource</code> corresponding to an
   * image capture capabilities resource.
   * @param[out] array_size The size of preview size array.
   * @param[out] formats An array of <code>PP_VideoCaptureFormat</code>
   * corresponding to the supported video capture formats. The ownership of the
   * array belongs to <code>PPB_CameraCapabilities_Private</code> and the caller
   * should not free it. When a PPB_CameraCapabilities_Private is deleted, the
   * array returning from this is no longer valid.
   */
  void (*GetSupportedVideoCaptureFormats)(
      PP_Resource capabilities,
      uint32_t* array_size,
      struct PP_VideoCaptureFormat** formats);
};

typedef struct PPB_CameraCapabilities_Private_0_1
    PPB_CameraCapabilities_Private;
/**
 * @}
 */

/* private/ppb_camera_device_private.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * To query camera capabilities:
 * 1. Get a PPB_CameraDevice_Private object by Create().
 * 2. Open() camera device with track id of MediaStream video track.
 * 3. Call GetCameraCapabilities() to get a
 *    <code>PPB_CameraCapabilities_Private</code> object, which can be used to
 *    query camera capabilities.
 */
struct PPB_CameraDevice_Private_0_1 {
  /**
   * Creates a PPB_CameraDevice_Private resource.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying one instance
   * of a module.
   *
   * @return A <code>PP_Resource</code> corresponding to a
   * PPB_CameraDevice_Private resource if successful, 0 if failed.
   */
  PP_Resource (*Create)(PP_Instance instance);
  /**
   * Determines if a resource is a camera device resource.
   *
   * @param[in] resource The <code>PP_Resource</code> to test.
   *
   * @return A <code>PP_Bool</code> with <code>PP_TRUE</code> if the given
   * resource is a camera device resource or <code>PP_FALSE</code>
   * otherwise.
   */
  PP_Bool (*IsCameraDevice)(PP_Resource resource);
  /**
   * Opens a camera device.
   *
   * @param[in] camera_device A <code>PP_Resource</code> corresponding to a
   * camera device resource.
   * @param[in] device_id A <code>PP_Var</code> identifying a camera device. The
   * type is string. The ID can be obtained from MediaStreamTrack.getSources()
   * or MediaStreamVideoTrack.id.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion of <code>Open()</code>.
   *
   * @return An error code from <code>pp_errors.h</code>.
   */
  int32_t (*Open)(PP_Resource camera_device,
                  struct PP_Var device_id,
                  struct PP_CompletionCallback callback);
  /**
   * Disconnects from the camera and cancels all pending requests.
   * After this returns, no callbacks will be called. If <code>
   * PPB_CameraDevice_Private</code> is destroyed and is not closed yet, this
   * function will be automatically called. Calling this more than once has no
   * effect.
   *
   * @param[in] camera_device A <code>PP_Resource</code> corresponding to a
   * camera device resource.
   */
  void (*Close)(PP_Resource camera_device);
  /**
   * Gets the camera capabilities.
   *
   * The camera capabilities do not change for a given camera source.
   *
   * @param[in] camera_device A <code>PP_Resource</code> corresponding to a
   * camera device resource.
   * @param[out] capabilities A <code>PPB_CameraCapabilities_Private</code> for
   * storing the camera capabilities on success. Otherwise, the value will not
   * be changed.
   * @param[in] callback <code>PP_CompletionCallback</code> to be called upon
   * completion of <code>GetCameraCapabilities()</code>.
   *
   * @return An int32_t containing a result code from <code>pp_errors.h</code>.
   */
  int32_t (*GetCameraCapabilities)(PP_Resource camera_device,
                                   PP_Resource* capabilities,
                                   struct PP_CompletionCallback callback);
};

typedef struct PPB_CameraDevice_Private_0_1 PPB_CameraDevice_Private;
/**
 * @}
 */

/* private/ppb_content_decryptor_private.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * <code>PPB_ContentDecryptor_Private</code> structure contains the function
 * pointers the browser must implement to support plugins implementing the
 * <code>PPP_ContentDecryptor_Private</code> interface. This interface provides
 * browser side support for the Content Decryption Module (CDM) for Encrypted
 * Media Extensions: http://www.w3.org/TR/encrypted-media/
 */
struct PPB_ContentDecryptor_Private_0_14 {
  /**
   * A promise has been resolved by the CDM.
   *
   * @param[in] promise_id Identifies the promise that the CDM resolved.
   */
  void (*PromiseResolved)(PP_Instance instance, uint32_t promise_id);
  /**
   * A promise that resulted in a new session has been resolved by the CDM.
   *
   * @param[in] promise_id Identifies the promise that the CDM resolved.
   *
   * @param[in] session_id A <code>PP_Var</code> of type
   * <code>PP_VARTYPE_STRING</code> containing the session's ID attribute.
   */
  void (*PromiseResolvedWithSession)(PP_Instance instance,
                                     uint32_t promise_id,
                                     struct PP_Var session_id);
  /**
   * A promise has been rejected by the CDM due to an error.
   *
   * @param[in] promise_id Identifies the promise that the CDM rejected.
   *
   * @param[in] exception_code A <code>PP_CdmExceptionCode</code> containing
   * the exception code.
   *
   * @param[in] system_code A system error code.
   *
   * @param[in] error_description A <code>PP_Var</code> of type
   * <code>PP_VARTYPE_STRING</code> containing the error description.
   */
  void (*PromiseRejected)(PP_Instance instance,
                          uint32_t promise_id,
                          PP_CdmExceptionCode exception_code,
                          uint32_t system_code,
                          struct PP_Var error_description);
  /**
   * A message or request has been generated for key_system in the CDM, and
   * must be sent to the web application.
   *
   * For example, when the browser invokes <code>CreateSession()</code>
   * on the <code>PPP_ContentDecryptor_Private</code> interface, the plugin
   * must send a message containing the license request.
   *
   * Note that <code>SessionMessage()</code> can be used for purposes other than
   * responses to <code>CreateSession()</code> calls. See also the text
   * in the comment for <code>SessionReady()</code>, which describes a sequence
   * of <code>UpdateSession()</code> and <code>SessionMessage()</code> calls
   * required to prepare for decryption.
   *
   * @param[in] session_id A <code>PP_Var</code> of type
   * <code>PP_VARTYPE_STRING</code> containing the ID of a session for
   * which this message is intended.
   *
   * @param[in] message_type A <code>PP_CdmMessageType</code> containing the
   * message type.
   *
   * @param[in] message A <code>PP_Var</code> of type
   * <code>PP_VARTYPE_ARRAY_BUFFER</code> that contains the message.
   *
   * @param[in] legacy_destination_url A <code>PP_Var</code> of type
   * <code>PP_VARTYPE_STRING</code> containing the destination URL for the
   * message.
   */
  void (*SessionMessage)(PP_Instance instance,
                         struct PP_Var session_id,
                         PP_CdmMessageType message_type,
                         struct PP_Var message,
                         struct PP_Var legacy_destination_url);
  /**
   * The keys for a session have changed.
   *
   * @param[in] session_id A <code>PP_Var</code> of type
   * <code>PP_VARTYPE_STRING</code> containing the ID of the session that has
   * a change in keys.
   *
   * @param[in] has_additional_usable_key A <code>PP_Bool</code> indicating if
   * a new usable key has been added.
   *
   * @param[in] key_count The number of arguments contained in
   * <code>key_information</code>
   *
   * @param[in] key_information An array of type <code>PP_KeyInformation</code>
   * that are the session's key IDs and their status.
   */
  void (*SessionKeysChange)(PP_Instance instance,
                            struct PP_Var session_id,
                            PP_Bool has_additional_usable_key,
                            uint32_t key_count,
                            const struct PP_KeyInformation key_information[]);
  /**
   * The expiration time for a session has changed.
   *
   * @param[in] session_id A <code>PP_Var</code> of type
   * <code>PP_VARTYPE_STRING</code> containing the ID of the session that has
   * a new expiration time.
   *
   * @param[in] new_expiry_time A <code>PP_Time</code> indicating the new
   * expiry time of the session. The value is defined as the number of seconds
   * since the Epoch (00:00:00 UTC, January 1, 1970).
   */
  void (*SessionExpirationChange)(PP_Instance instance,
                                  struct PP_Var session_id,
                                  PP_Time new_expiry_time);
  /**
   * The session has been closed as the result of a call to the
   * <code>ReleaseSession()</code> method on the
   * <code>PPP_ContentDecryptor_Private</code> interface, or due to other
   * factors as determined by the CDM.
   *
   * @param[in] session_id A <code>PP_Var</code> of type
   * <code>PP_VARTYPE_STRING</code> containing the session's ID attribute of
   * the session that is now closed.
   */
  void (*SessionClosed)(PP_Instance instance, struct PP_Var session_id);
  /**
   * An error occurred in a <code>PPP_ContentDecryptor_Private</code> method,
   * or within the plugin implementing the interface.
   *
   * @param[in] session_id A <code>PP_Var</code> of type
   * <code>PP_VARTYPE_STRING</code> containing the session's ID attribute of
   * the session that caused the error.
   *
   * @param[in] exception_code A <code>PP_CdmExceptionCode</code> containing
   * the exception code.
   *
   * @param[in] system_code A system error code.
   *
   * @param[in] error_description A <code>PP_Var</code> of type
   * <code>PP_VARTYPE_STRING</code> containing the error description.
   */
  void (*LegacySessionError)(PP_Instance instance,
                             struct PP_Var session_id,
                             PP_CdmExceptionCode exception_code,
                             uint32_t system_code,
                             struct PP_Var error_description);
  /**
   * Called after the <code>Decrypt()</code> method on the
   * <code>PPP_ContentDecryptor_Private</code> interface completes to
   * deliver decrypted_block to the browser for decoding and rendering.
   *
   * The plugin must not hold a reference to the encrypted buffer resource
   * provided to <code>Decrypt()</code> when it calls this method. The browser
   * will reuse the buffer in a subsequent <code>Decrypt()</code> call.
   *
   * @param[in] decrypted_block A <code>PP_Resource</code> corresponding to a
   * <code>PPB_Buffer_Dev</code> resource that contains a decrypted data
   * block.
   *
   * @param[in] decrypted_block_info A <code>PP_DecryptedBlockInfo</code> that
   * contains the result code and tracking info associated with the
   * <code>decrypted_block</code>.
   */
  void (*DeliverBlock)(
      PP_Instance instance,
      PP_Resource decrypted_block,
      const struct PP_DecryptedBlockInfo* decrypted_block_info);
  /**
   * Called after the <code>InitializeAudioDecoder()</code> or
   * <code>InitializeVideoDecoder()</code> method on the
   * <code>PPP_ContentDecryptor_Private</code> interface completes to report
   * decoder initialization status to the browser.
   *
   * @param[in] success A <code>PP_Bool</code> that is set to
   * <code>PP_TRUE</code> when the decoder initialization request associated
   * with <code>request_id</code> was successful.
   *
   * @param[in] decoder_type A <code>PP_DecryptorStreamType</code> identifying
   * the decoder type for which this initialization status response was sent.
   *
   * @param[in] request_id The <code>request_id</code> value passed to
   * <code>InitializeAudioDecoder</code> or <code>InitializeVideoDecoder</code>
   * in <code>PP_AudioDecoderConfig</code> or
   * <code>PP_VideoDecoderConfig</code>.
   */
  void (*DecoderInitializeDone)(PP_Instance instance,
                                PP_DecryptorStreamType decoder_type,
                                uint32_t request_id,
                                PP_Bool success);
  /**
   * Called after the <code>DeinitializeDecoder()</code> method on the
   * <code>PPP_ContentDecryptor_Private</code> interface completes to report
   * decoder de-initialization completion to the browser.
   *
   * @param[in] decoder_type The <code>PP_DecryptorStreamType</code> passed to
   * <code>DeinitializeDecoder()</code>.
   *
   * @param[in] request_id The <code>request_id</code> value passed to
   * <code>DeinitializeDecoder()</code>.
   */
  void (*DecoderDeinitializeDone)(PP_Instance instance,
                                  PP_DecryptorStreamType decoder_type,
                                  uint32_t request_id);
  /**
   * Called after the <code>ResetDecoder()</code> method on the
   * <code>PPP_ContentDecryptor_Private</code> interface completes to report
   * decoder reset completion to the browser.
   *
   * @param[in] decoder_type The <code>PP_DecryptorStreamType</code> passed to
   * <code>ResetDecoder()</code>.
   *
   * @param[in] request_id The <code>request_id</code> value passed to
   * <code>ResetDecoder()</code>.
   */
  void (*DecoderResetDone)(PP_Instance instance,
                           PP_DecryptorStreamType decoder_type,
                           uint32_t request_id);
  /**
   * Called after the <code>DecryptAndDecode()</code> method on the
   * <code>PPP_ContentDecryptor_Private</code> interface completes to deliver
   * a decrypted and decoded video frame to the browser for rendering.
   *
   * The plugin must not hold a reference to the encrypted buffer resource
   * provided to <code>DecryptAndDecode()</code> when it calls this method. The
   * browser will reuse the buffer in a subsequent
   * <code>DecryptAndDecode()</code> call.
   *
   * @param[in] decrypted_frame A <code>PP_Resource</code> corresponding to a
   * <code>PPB_Buffer_Dev</code> resource that contains a video frame.
   *
   * @param[in] decrypted_frame_info A <code>PP_DecryptedFrameInfo</code> that
   * contains the result code, tracking info, and buffer format associated with
   * <code>decrypted_frame</code>.
   */
  void (*DeliverFrame)(
      PP_Instance instance,
      PP_Resource decrypted_frame,
      const struct PP_DecryptedFrameInfo* decrypted_frame_info);
  /**
   * Called after the <code>DecryptAndDecode()</code> method on the
   * <code>PPP_ContentDecryptor_Private</code> interface completes to deliver
   * a buffer of decrypted and decoded audio samples to the browser for
   * rendering.
   *
   * The plugin must not hold a reference to the encrypted buffer resource
   * provided to <code>DecryptAndDecode()</code> when it calls this method. The
   * browser will reuse the buffer in a subsequent
   * <code>DecryptAndDecode()</code> call.
   *
   * <code>audio_frames</code> can contain multiple audio output buffers. Each
   * buffer is serialized in this format:
   *
   * |<------------------- serialized audio buffer ------------------->|
   * | int64_t timestamp | int64_t length | length bytes of audio data |
   *
   * For example, with three audio output buffers, |audio_frames| will look
   * like this:
   *
   * |<---------------- audio_frames ------------------>|
   * | audio buffer 0 | audio buffer 1 | audio buffer 2 |
   *
   * @param[in] audio_frames A <code>PP_Resource</code> corresponding to a
   * <code>PPB_Buffer_Dev</code> resource that contains a decrypted buffer
   * of decoded audio samples.
   *
   * @param[in] decrypted_sample_info A <code>PP_DecryptedSampleInfo</code> that
   * contains the tracking info and result code associated with the decrypted
   * samples.
   */
  void (*DeliverSamples)(
      PP_Instance instance,
      PP_Resource audio_frames,
      const struct PP_DecryptedSampleInfo* decrypted_sample_info);
};

typedef struct PPB_ContentDecryptor_Private_0_14 PPB_ContentDecryptor_Private;
/**
 * @}
 */

/* private/ppb_display_color_profile_private.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * <code>PPB_DisplayColorProfile_Private</code> defines the methods for getting
 * the display color profile and monitoring its changes.
 *
 * <strong>Setup:<strong>
 * @code
 * PP_ArrayOutput output = { MyAllocatorFunction, color_profile_data };
 * PP_Resource display_cp = display_cp_interface->Create(instance);
 * display_cp_interface->GetColorProfile(display_cp,
 *                                       output,
 *                                       completion_callback);
 * @endcode
 */
struct PPB_DisplayColorProfile_Private_0_1 {
  /**
   * Create() creates a display color profile resource.
   *
   * @param[in] instance The module instance.
   * @return A <code>PP_Resource</code> containing a display color profile
   * resource.
   */
  PP_Resource (*Create)(PP_Instance instance);
  /**
   * IsDisplayColorProfile() determines if the given resource is a valid
   * <code>DisplayColorProfile</code> resource.
   *
   * @param[in] resource A <code>DisplayColorProfile</code> context resource.
   * @return Returns:
   * - <code>PP_TRUE</code> if the given resource is a valid
   *   <code>DisplayColorProfile</code>
   * - <code>PP_FALSE</code> if it is an invalid resource or is a resource
   *   of another type.
   */
  PP_Bool (*IsDisplayColorProfile)(PP_Resource resource);
  /**
   * GetColorProfile() enqueues a request for the current display color profile.
   *
   * This method is intended for getting the color profile data of the display
   * on which the browser window resides. [However currently Chrome only
   * considers the system's primary display color profile when doing its color
   * management. For consistency this method will also return the color profile
   * that Chrome uses for its browser window.]
   *
   * @param[in] display_color_profile_res The display color profile resource.
   * @param[in] color_profile A <code>PP_OutputArray</code> which on success
   * will receive a byte array containing the ICC color profile data (see
   * www.color.org for a reference to the ICC color profile specification
   * and versions). The returned color profile version is the one supported by
   * the host system.
   * @param[in] callback The completion callback to be called once the display
   * color profile data is available.
   *
   * @return Returns an error code from <code>pp_errors.h</code>.
   */
  int32_t (*GetColorProfile)(PP_Resource display_color_profile_res,
                             struct PP_ArrayOutput color_profile,
                             struct PP_CompletionCallback callback);
  /**
   * RegisterColorProfileChangeCallback() registers a callback to be called next
   * time the color profile for the browser window in which the plugin resides
   * changes. In order to get notifications for all color profile changes a call
   * to RegisterColorProfileChangeCallback() function should be done when the
   * previous notification was fired.
   *
   * There might be 2 scenarios in which the color profile for a window changes:
   * a) The window is moved from one display to another;
   * b) The user changes the display color space from the system settings.
   *
   * @param[in] display_color_profile_res The display color profile resource.
   * @param[in] callback The callback to be invoked next time the display
   * color profile changes.
   *
   * @return Returns an error code from <code>pp_errors.h</code>.
   */
  int32_t (*RegisterColorProfileChangeCallback)(
      PP_Resource display_color_profile_res,
      struct PP_CompletionCallback callback);
};

typedef struct PPB_DisplayColorProfile_Private_0_1
    PPB_DisplayColorProfile_Private;
/**
 * @}
 */

/* private/ppb_ext_crx_file_system_private.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/* <code>PPB_Ext_CrxFileSystem_Private</code> interface */
struct PPB_Ext_CrxFileSystem_Private_0_1 {
  /**
   * Open() opens the CRX file system for the current extension.  It will fail
   * when called from non-extension context.
   *
   * @param[in] crxfs A <code>PP_Resource</code> corresponding to a
   * CrxFileSystem.
   * @param[out] file_system An output <code>PP_Resource</code> corresponding
   * to a PPB_FileSystem.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion of Open.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   */
  int32_t (*Open)(PP_Instance instance,
                  PP_Resource* file_system,
                  struct PP_CompletionCallback callback);
};

typedef struct PPB_Ext_CrxFileSystem_Private_0_1 PPB_Ext_CrxFileSystem_Private;
/**
 * @}
 */

/* private/ppb_file_io_private.idl */
#include "ppapi/c/private/pp_file_handle.h"

/**
 * @addtogroup Interfaces
 * @{
 */
/* PPB_FileIO_Private interface */
struct PPB_FileIO_Private_0_1 {
  /**
   * Returns a file handle corresponding to the given FileIO
   * object.  The FileIO object must have been opened with a
   * successful call to FileIO::Open.  The caller gets the ownership
   * of the returned file handle and must close it.
   */
  int32_t (*RequestOSFileHandle)(PP_Resource file_io,
                                 PP_FileHandle* handle,
                                 struct PP_CompletionCallback callback);
};

typedef struct PPB_FileIO_Private_0_1 PPB_FileIO_Private;
/**
 * @}
 */

/* private/ppb_file_ref_private.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/* PPB_FileRefPrivate interface */
struct PPB_FileRefPrivate_0_1 {
  /**
   * GetAbsolutePath() returns the absolute path of the file.
   *
   * @param[in] file_ref A <code>PP_Resource</code> corresponding to a file
   * reference.
   *
   * @return A <code>PP_Var</code> containing the absolute path of the file.
   */
  struct PP_Var (*GetAbsolutePath)(PP_Resource file_ref);
};

typedef struct PPB_FileRefPrivate_0_1 PPB_FileRefPrivate;
/**
 * @}
 */

/* private/ppb_find_private.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * This is a private interface for doing browser Find in the PDF plugin.
 */
struct PPB_Find_Private_0_3 {
  /**
   * Sets the instance of this plugin as the mechanism that will be used to
   * handle find requests in the renderer. This will only succeed if the plugin
   * is embedded within the content of the top level frame. Note that this will
   * result in the renderer handing over all responsibility for doing find to
   * the plugin and content from the rest of the page will not be searched.
   *
   *
   * In the case that the plugin is loaded directly as the top level document,
   * this function does not need to be called. In that case the plugin is
   * assumed to handle find requests.
   *
   * There can only be one plugin which handles find requests. If a plugin calls
   * this while an existing plugin is registered, the existing plugin will be
   * de-registered and will no longer receive any requests.
   */
  void (*SetPluginToHandleFindRequests)(PP_Instance instance);
  /**
   * Updates the number of find results for the current search term.  If
   * there are no matches 0 should be passed in.  Only when the plugin has
   * finished searching should it pass in the final count with final_result set
   * to PP_TRUE.
   */
  void (*NumberOfFindResultsChanged)(PP_Instance instance,
                                     int32_t total,
                                     PP_Bool final_result);
  /**
   * Updates the index of the currently selected search item.
   */
  void (*SelectedFindResultChanged)(PP_Instance instance, int32_t index);
  /**
   * Updates the tickmarks on the scrollbar for the find request. |tickmarks|
   * contains |count| PP_Rects indicating the tickmark ranges.
   */
  void (*SetTickmarks)(PP_Instance instance,
                       const struct PP_Rect tickmarks[],
                       uint32_t count);
};

typedef struct PPB_Find_Private_0_3 PPB_Find_Private;
/**
 * @}
 */

/* private/ppb_flash.idl */
/**
 * @addtogroup Enums
 * @{
 */
typedef enum {
  /**
   * No restrictions on Flash LSOs.
   */
  PP_FLASHLSORESTRICTIONS_NONE = 1,
  /**
   * Don't allow access to Flash LSOs.
   */
  PP_FLASHLSORESTRICTIONS_BLOCK = 2,
  /**
   * Store Flash LSOs in memory only.
   */
  PP_FLASHLSORESTRICTIONS_IN_MEMORY = 3
} PP_FlashLSORestrictions;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_FlashLSORestrictions, 4);

typedef enum {
  /**
   * Specifies if the system likely supports 3D hardware acceleration.
   *
   * The result is a boolean PP_Var, depending on the supported nature of 3D
   * acceleration. If querying this function returns true, the 3D system will
   * normally use the native hardware for rendering which will be much faster.
   *
   * Having this set to true only means that 3D should be used to draw 2D and
   * video elements. PP_FLASHSETTING_STAGE3D_ENABLED should be checked to
   * determine if it's ok to use 3D for arbitrary content.
   *
   * In rare cases (depending on the platform) this value will be true but a
   * created 3D context will use emulation because context initialization
   * failed.
   */
  PP_FLASHSETTING_3DENABLED = 1,
  /**
   * Specifies if the given instance is in private/incognito/off-the-record mode
   * (returns true) or "regular" mode (returns false). Returns an undefined
   * PP_Var on invalid instance.
   */
  PP_FLASHSETTING_INCOGNITO = 2,
  /**
   * Specifies if arbitrary 3d commands are supported (returns true), or if 3d
   * should only be used for drawing 2d and video (returns false).
   *
   * This should only be enabled if PP_FLASHSETTING_3DENABLED is true.
   */
  PP_FLASHSETTING_STAGE3DENABLED = 3,
  /**
   * Specifies the string for the language code of the UI of the browser.
   *
   * For example: "en-US" or "de".
   *
   * Returns an undefined PP_Var on invalid instance.
   */
  PP_FLASHSETTING_LANGUAGE = 4,
  /**
   * Specifies the number of CPU cores that are present on the system.
   */
  PP_FLASHSETTING_NUMCORES = 5,
  /**
   * Specifies restrictions on how flash should handle LSOs. The result is an
   * int from <code>PP_FlashLSORestrictions</code>.
   */
  PP_FLASHSETTING_LSORESTRICTIONS = 6,
  /**
   * Specifies if the driver is reliable enough to use Shader Model 3 commands
   * with it.
   *
   * This should only be enabled if PP_FLASHSETTING_STAGE3DENABLED is true.
   */
  PP_FLASHSETTING_STAGE3DBASELINEENABLED = 7
} PP_FlashSetting;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_FlashSetting, 4);

/**
 * This enum provides keys for setting breakpad crash report data.
 */
typedef enum {
  /**
   * Specifies the document URL which contains the flash instance.
   */
  PP_FLASHCRASHKEY_URL = 1,
  /**
   * Specifies the URL of the current swf.
   */
  PP_FLASHCRASHKEY_RESOURCE_URL = 2
} PP_FlashCrashKey;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_FlashCrashKey, 4);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPB_Flash</code> interface contains pointers to various functions
 * that are only needed to support Pepper Flash.
 */
struct PPB_Flash_13_0 {
  /**
   * Sets or clears the rendering hint that the given plugin instance is always
   * on top of page content. Somewhat more optimized painting can be used in
   * this case.
   */
  void (*SetInstanceAlwaysOnTop)(PP_Instance instance, PP_Bool on_top);
  /**
   * Draws the given pre-laid-out text. It is almost equivalent to Windows'
   * ExtTextOut with the addition of the transformation (a 3x3 matrix given the
   * transform to apply before drawing). It also adds the allow_subpixel_aa
   * flag which when true, will use subpixel antialiasing if enabled in the
   * system settings. For this to work properly, the graphics layer that the
   * text is being drawn into must be opaque.
   */
  PP_Bool (*DrawGlyphs)(
      PP_Instance instance,
      PP_Resource pp_image_data,
      const struct PP_BrowserFont_Trusted_Description* font_desc,
      uint32_t color,
      const struct PP_Point* position,
      const struct PP_Rect* clip,
      const float transformation[3][3],
      PP_Bool allow_subpixel_aa,
      uint32_t glyph_count,
      const uint16_t glyph_indices[],
      const struct PP_Point glyph_advances[]);
  /**
   * Retrieves the proxy that will be used for the given URL. The result will
   * be a string in PAC format, or an undefined var on error.
   */
  struct PP_Var (*GetProxyForURL)(PP_Instance instance, const char* url);
  /**
   * Navigate to the URL given by the given URLRequestInfo. (This supports GETs,
   * POSTs, and javascript: URLs.) May open a new tab if target is not "_self".
   */
  int32_t (*Navigate)(PP_Resource request_info,
                      const char* target,
                      PP_Bool from_user_action);
  /**
   * Retrieves the local time zone offset from GM time for the given UTC time.
   */
  double (*GetLocalTimeZoneOffset)(PP_Instance instance, PP_Time t);
  /**
   * Gets a (string) with "command-line" options for Flash; used to pass
   * run-time debugging parameters, etc.
   */
  struct PP_Var (*GetCommandLineArgs)(PP_Module module);
  /**
   * Loads the given font in a more privileged process on Windows. Call this if
   * Windows is giving errors for font calls. See
   * content/renderer/font_cache_dispatcher_win.cc
   *
   * The parameter is a pointer to a LOGFONTW structure.
   *
   * On non-Windows platforms, this function does nothing.
   */
  void (*PreloadFontWin)(const void* logfontw);
  /**
   * Returns whether the given rectangle (in the plugin) is topmost, i.e., above
   * all other web content.
   */
  PP_Bool (*IsRectTopmost)(PP_Instance instance, const struct PP_Rect* rect);
  /**
   * Indicates that there's activity and, e.g., the screensaver shouldn't kick
   * in.
   */
  void (*UpdateActivity)(PP_Instance instance);
  /**
   * Returns the value associated with the given setting. Invalid enums will
   * result in an undefined PP_Var return value.
   */
  struct PP_Var (*GetSetting)(PP_Instance instance, PP_FlashSetting setting);
  /**
   * Allows setting breakpad crash data which will be included in plugin crash
   * reports. Returns PP_FALSE if crash data could not be set.
   */
  PP_Bool (*SetCrashData)(PP_Instance instance,
                          PP_FlashCrashKey key,
                          struct PP_Var value);
  /**
   * Enumerates video capture devices. |video_capture| is a valid
   * PPB_VideoCapture_Dev resource. Once the operation has completed
   * successfully, |devices| will be set up with an array of
   * PPB_DeviceRef_Dev resources.
   *
   * PP_OK is returned on success and different pepper error code on failure.
   * The ref count of the returned |devices| has already been increased by 1 for
   * the caller.
   *
   * NOTE: This method is a synchronous version of |EnumerateDevices| in
   * PPB_VideoCapture_Dev.
   */
  int32_t (*EnumerateVideoCaptureDevices)(PP_Instance instance,
                                          PP_Resource video_capture,
                                          struct PP_ArrayOutput devices);
};

typedef struct PPB_Flash_13_0 PPB_Flash;

struct PPB_Flash_12_4 {
  void (*SetInstanceAlwaysOnTop)(PP_Instance instance, PP_Bool on_top);
  PP_Bool (*DrawGlyphs)(
      PP_Instance instance,
      PP_Resource pp_image_data,
      const struct PP_BrowserFont_Trusted_Description* font_desc,
      uint32_t color,
      const struct PP_Point* position,
      const struct PP_Rect* clip,
      const float transformation[3][3],
      PP_Bool allow_subpixel_aa,
      uint32_t glyph_count,
      const uint16_t glyph_indices[],
      const struct PP_Point glyph_advances[]);
  struct PP_Var (*GetProxyForURL)(PP_Instance instance, const char* url);
  int32_t (*Navigate)(PP_Resource request_info,
                      const char* target,
                      PP_Bool from_user_action);
  void (*RunMessageLoop)(PP_Instance instance);
  void (*QuitMessageLoop)(PP_Instance instance);
  double (*GetLocalTimeZoneOffset)(PP_Instance instance, PP_Time t);
  struct PP_Var (*GetCommandLineArgs)(PP_Module module);
  void (*PreloadFontWin)(const void* logfontw);
  PP_Bool (*IsRectTopmost)(PP_Instance instance, const struct PP_Rect* rect);
  int32_t (*InvokePrinting)(PP_Instance instance);
  void (*UpdateActivity)(PP_Instance instance);
  struct PP_Var (*GetDeviceID)(PP_Instance instance);
  int32_t (*GetSettingInt)(PP_Instance instance, PP_FlashSetting setting);
  struct PP_Var (*GetSetting)(PP_Instance instance, PP_FlashSetting setting);
};

struct PPB_Flash_12_5 {
  void (*SetInstanceAlwaysOnTop)(PP_Instance instance, PP_Bool on_top);
  PP_Bool (*DrawGlyphs)(
      PP_Instance instance,
      PP_Resource pp_image_data,
      const struct PP_BrowserFont_Trusted_Description* font_desc,
      uint32_t color,
      const struct PP_Point* position,
      const struct PP_Rect* clip,
      const float transformation[3][3],
      PP_Bool allow_subpixel_aa,
      uint32_t glyph_count,
      const uint16_t glyph_indices[],
      const struct PP_Point glyph_advances[]);
  struct PP_Var (*GetProxyForURL)(PP_Instance instance, const char* url);
  int32_t (*Navigate)(PP_Resource request_info,
                      const char* target,
                      PP_Bool from_user_action);
  void (*RunMessageLoop)(PP_Instance instance);
  void (*QuitMessageLoop)(PP_Instance instance);
  double (*GetLocalTimeZoneOffset)(PP_Instance instance, PP_Time t);
  struct PP_Var (*GetCommandLineArgs)(PP_Module module);
  void (*PreloadFontWin)(const void* logfontw);
  PP_Bool (*IsRectTopmost)(PP_Instance instance, const struct PP_Rect* rect);
  int32_t (*InvokePrinting)(PP_Instance instance);
  void (*UpdateActivity)(PP_Instance instance);
  struct PP_Var (*GetDeviceID)(PP_Instance instance);
  int32_t (*GetSettingInt)(PP_Instance instance, PP_FlashSetting setting);
  struct PP_Var (*GetSetting)(PP_Instance instance, PP_FlashSetting setting);
  PP_Bool (*SetCrashData)(PP_Instance instance,
                          PP_FlashCrashKey key,
                          struct PP_Var value);
};

struct PPB_Flash_12_6 {
  void (*SetInstanceAlwaysOnTop)(PP_Instance instance, PP_Bool on_top);
  PP_Bool (*DrawGlyphs)(
      PP_Instance instance,
      PP_Resource pp_image_data,
      const struct PP_BrowserFont_Trusted_Description* font_desc,
      uint32_t color,
      const struct PP_Point* position,
      const struct PP_Rect* clip,
      const float transformation[3][3],
      PP_Bool allow_subpixel_aa,
      uint32_t glyph_count,
      const uint16_t glyph_indices[],
      const struct PP_Point glyph_advances[]);
  struct PP_Var (*GetProxyForURL)(PP_Instance instance, const char* url);
  int32_t (*Navigate)(PP_Resource request_info,
                      const char* target,
                      PP_Bool from_user_action);
  void (*RunMessageLoop)(PP_Instance instance);
  void (*QuitMessageLoop)(PP_Instance instance);
  double (*GetLocalTimeZoneOffset)(PP_Instance instance, PP_Time t);
  struct PP_Var (*GetCommandLineArgs)(PP_Module module);
  void (*PreloadFontWin)(const void* logfontw);
  PP_Bool (*IsRectTopmost)(PP_Instance instance, const struct PP_Rect* rect);
  int32_t (*InvokePrinting)(PP_Instance instance);
  void (*UpdateActivity)(PP_Instance instance);
  struct PP_Var (*GetDeviceID)(PP_Instance instance);
  int32_t (*GetSettingInt)(PP_Instance instance, PP_FlashSetting setting);
  struct PP_Var (*GetSetting)(PP_Instance instance, PP_FlashSetting setting);
  PP_Bool (*SetCrashData)(PP_Instance instance,
                          PP_FlashCrashKey key,
                          struct PP_Var value);
  int32_t (*EnumerateVideoCaptureDevices)(PP_Instance instance,
                                          PP_Resource video_capture,
                                          struct PP_ArrayOutput devices);
};
/**
 * @}
 */

/* private/ppb_flash_clipboard.idl */
/**
 * @addtogroup Enums
 * @{
 */
/**
 * This enumeration contains the types of clipboards that can be accessed.
 * These types correspond to clipboard types in WebKit.
 */
typedef enum {
  /** The standard clipboard. */
  PP_FLASH_CLIPBOARD_TYPE_STANDARD = 0,
  /** The selection clipboard (e.g., on Linux). */
  PP_FLASH_CLIPBOARD_TYPE_SELECTION = 1
} PP_Flash_Clipboard_Type;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_Flash_Clipboard_Type, 4);

/**
 * This enumeration contains the predefined clipboard data formats.
 */
typedef enum {
  /** Indicates an invalid or unsupported clipboard data format. */
  PP_FLASH_CLIPBOARD_FORMAT_INVALID = 0,
  /**
   * Indicates plaintext clipboard data. The format expected/returned is a
   * <code>PP_VARTYPE_STRING</code>.
   */
  PP_FLASH_CLIPBOARD_FORMAT_PLAINTEXT = 1,
  /**
   * Indicates HTML clipboard data. The format expected/returned is a
   * <code>PP_VARTYPE_STRING</code>.
   */
  PP_FLASH_CLIPBOARD_FORMAT_HTML = 2,
  /**
   * Indicates RTF clipboard data. The format expected/returned is a
   * <code>PP_VARTYPE_ARRAY_BUFFER</code>.
   */
  PP_FLASH_CLIPBOARD_FORMAT_RTF = 3
} PP_Flash_Clipboard_Format;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_Flash_Clipboard_Format, 4);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPB_Flash_Clipboard</code> interface contains pointers to functions
 * used by Pepper Flash to access the clipboard.
 *
 */
struct PPB_Flash_Clipboard_5_1 {
  /**
   * Registers a custom clipboard format. The format is identified by a
   * string. An id identifying the format will be returned if the format is
   * successfully registered, which can be used to read/write data of that
   * format. If the format has already been registered, the id associated with
   * that format will be returned. If the format fails to be registered
   * <code>PP_FLASH_CLIPBOARD_FORMAT_INVALID</code> will be returned.
   *
   * All custom data should be read/written as <code>PP_Var</code> array
   * buffers. The clipboard format is pepper-specific meaning that although the
   * data will be stored on the system clipboard, it can only be accessed in a
   * sensible way by using the pepper API. Data stored in custom formats can
   * be safely shared between different applications that use pepper.
   */
  uint32_t (*RegisterCustomFormat)(PP_Instance instance_id,
                                   const char* format_name);
  /**
   * Checks whether a given data format is available from the given clipboard.
   * Returns true if the given format is available from the given clipboard.
   */
  PP_Bool (*IsFormatAvailable)(PP_Instance instance_id,
                               PP_Flash_Clipboard_Type clipboard_type,
                               uint32_t format);
  /**
   * Reads data in the given <code>format</code> from the clipboard. An
   * undefined <code>PP_Var</code> is returned if there is an error in reading
   * the clipboard data and a null <code>PP_Var</code> is returned if there is
   * no data of the specified <code>format</code> to read.
   */
  struct PP_Var (*ReadData)(PP_Instance instance_id,
                            PP_Flash_Clipboard_Type clipboard_type,
                            uint32_t format);
  /**
   * Writes the given array of data items to the clipboard. All existing
   * clipboard data in any format is erased before writing this data. Thus,
   * passing an array of size 0 has the effect of clearing the clipboard without
   * writing any data. Each data item in the array should have a different
   * <code>PP_Flash_Clipboard_Format</code>. If multiple data items have the
   * same format, only the last item with that format will be written.
   * If there is an error writing any of the items in the array to the
   * clipboard, none will be written and an error code is returned.
   * The error code will be <code>PP_ERROR_NOSPACE</code> if the value is
   * too large to be written, <code>PP_ERROR_BADARGUMENT</code> if a PP_Var
   * cannot be converted into the format supplied or <code>PP_FAILED</code>
   * if the format is not supported.
   */
  int32_t (*WriteData)(PP_Instance instance_id,
                       PP_Flash_Clipboard_Type clipboard_type,
                       uint32_t data_item_count,
                       const uint32_t formats[],
                       const struct PP_Var data_items[]);
  /**
   * Gets a sequence number which uniquely identifies clipboard state. This can
   * be used to version the data on the clipboard and determine whether it has
   * changed. The sequence number will be placed in |sequence_number| and
   * PP_TRUE returned if the sequence number was retrieved successfully.
   */
  PP_Bool (*GetSequenceNumber)(PP_Instance instance_id,
                               PP_Flash_Clipboard_Type clipboard_type,
                               uint64_t* sequence_number);
};

typedef struct PPB_Flash_Clipboard_5_1 PPB_Flash_Clipboard;

struct PPB_Flash_Clipboard_4_0 {
  PP_Bool (*IsFormatAvailable)(PP_Instance instance_id,
                               PP_Flash_Clipboard_Type clipboard_type,
                               PP_Flash_Clipboard_Format format);
  struct PP_Var (*ReadData)(PP_Instance instance_id,
                            PP_Flash_Clipboard_Type clipboard_type,
                            PP_Flash_Clipboard_Format format);
  int32_t (*WriteData)(PP_Instance instance_id,
                       PP_Flash_Clipboard_Type clipboard_type,
                       uint32_t data_item_count,
                       const PP_Flash_Clipboard_Format formats[],
                       const struct PP_Var data_items[]);
};

struct PPB_Flash_Clipboard_5_0 {
  uint32_t (*RegisterCustomFormat)(PP_Instance instance_id,
                                   const char* format_name);
  PP_Bool (*IsFormatAvailable)(PP_Instance instance_id,
                               PP_Flash_Clipboard_Type clipboard_type,
                               uint32_t format);
  struct PP_Var (*ReadData)(PP_Instance instance_id,
                            PP_Flash_Clipboard_Type clipboard_type,
                            uint32_t format);
  int32_t (*WriteData)(PP_Instance instance_id,
                       PP_Flash_Clipboard_Type clipboard_type,
                       uint32_t data_item_count,
                       const uint32_t formats[],
                       const struct PP_Var data_items[]);
};
/**
 * @}
 */

/* private/ppb_flash_device_id.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/* TODO(raymes): This is deprecated by the PPB_Flash_DRM interface. Remove this
 * interface after a few versions of Chrome have passed. */
struct PPB_Flash_DeviceID_1_0 {
  PP_Resource (*Create)(PP_Instance instance);
  /**
   * Asynchronously computes the device ID. When available, it will place the
   * string in |*id| and will call the completion callback. On failure the
   * given var will be PP_VARTYPE_UNDEFINED.
   */
  int32_t (*GetDeviceID)(PP_Resource device_id,
                         struct PP_Var* id,
                         struct PP_CompletionCallback callback);
};

typedef struct PPB_Flash_DeviceID_1_0 PPB_Flash_DeviceID;
/**
 * @}
 */

/* private/ppb_flash_drm.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * A resource for performing Flash DRM-related operations.
 */
struct PPB_Flash_DRM_1_1 {
  /**
   * Creates a PPB_Flash_DRM resource for performing DRM-related operations in
   * Flash.
   */
  PP_Resource (*Create)(PP_Instance instance);
  /**
   * Asynchronously computes the device ID. When available, it will place the
   * string in |*id| and will call the completion callback. On failure the
   * given var will be PP_VARTYPE_UNDEFINED.
   */
  int32_t (*GetDeviceID)(PP_Resource drm,
                         struct PP_Var* id,
                         struct PP_CompletionCallback callback);
  /**
   * Windows and Mac only. Synchronously outputs the HMONITOR or
   * CGDirectDisplayID corresponding to the monitor on which the plugin instance
   * is displayed in |hmonitor|. This value is queried asynchronously and this
   * will return PP_FALSE if the value is not yet available or an error
   * occurred. PP_TRUE is returned on success.
   */
  PP_Bool (*GetHmonitor)(PP_Resource drm, int64_t* hmonitor);
  /**
   * Asynchronously returns a PPB_FileRef resource in |file_ref| which points to
   * the Voucher file for performing DRM verification. |callback| will be called
   * upon completion.
   */
  int32_t (*GetVoucherFile)(PP_Resource drm,
                            PP_Resource* file_ref,
                            struct PP_CompletionCallback callback);
  /**
   * Asynchronously returns a value indicating whether the monitor on which the
   * plugin instance is displayed is external. |callback| will be called upon
   * completion.
   */
  int32_t (*MonitorIsExternal)(PP_Resource drm,
                               PP_Bool* is_external,
                               struct PP_CompletionCallback callback);
};

typedef struct PPB_Flash_DRM_1_1 PPB_Flash_DRM;

struct PPB_Flash_DRM_1_0 {
  PP_Resource (*Create)(PP_Instance instance);
  int32_t (*GetDeviceID)(PP_Resource drm,
                         struct PP_Var* id,
                         struct PP_CompletionCallback callback);
  PP_Bool (*GetHmonitor)(PP_Resource drm, int64_t* hmonitor);
  int32_t (*GetVoucherFile)(PP_Resource drm,
                            PP_Resource* file_ref,
                            struct PP_CompletionCallback callback);
};
/**
 * @}
 */

/* private/ppb_flash_file.idl */
/**
 * @addtogroup Structs
 * @{
 */
struct PP_DirEntry_Dev {
  char* name;
  PP_Bool is_dir;
};

/* Directory. */
struct PP_DirContents_Dev {
  int32_t count;
  struct PP_DirEntry_Dev *entries;
};
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
/* PPB_Flash_File_ModuleLocal */
struct PPB_Flash_File_ModuleLocal_3_0 {
  /* Deprecated. Returns true. */
  PP_Bool (*CreateThreadAdapterForInstance)(PP_Instance instance);
  /* Deprecated. Does nothing. */
  void (*ClearThreadAdapterForInstance)(PP_Instance instance);
  /* Opens a module-local file, returning a file descriptor (posix) or a HANDLE
   * (win32) into file. Module-local file paths (here and below) are
   * '/'-separated UTF-8 strings, relative to a module-specific root. The return
   * value is the ppapi error, PP_OK if success, one of the PP_ERROR_* in case
   * of failure
   */
  int32_t (*OpenFile)(PP_Instance instance,
                      const char* path,
                      int32_t mode,
                      PP_FileHandle* file);
  /* Renames a module-local file. The return value is the ppapi error, PP_OK if
   * success, one of the PP_ERROR_* in case of failure.
   */
  int32_t (*RenameFile)(PP_Instance instance,
                        const char* path_from,
                        const char* path_to);
  /* Deletes a module-local file or directory. If recursive is set and the path
   * points to a directory, deletes all the contents of the directory. The
   * return value is the ppapi error, PP_OK if success, one of the PP_ERROR_* in
   * case of failure.
   */
  int32_t (*DeleteFileOrDir)(PP_Instance instance,
                             const char* path,
                             PP_Bool recursive);
  /* Creates a module-local directory. The return value is the ppapi error,
   * PP_OK if success, one of the PP_ERROR_* in case of failure.
   */
  int32_t (*CreateDir)(PP_Instance instance, const char* path);
  /* Queries information about a module-local file. The return value is the
   * ppapi error, PP_OK if success, one of the PP_ERROR_* in case of failure.
   */
  int32_t (*QueryFile)(PP_Instance instance,
                       const char* path,
                       struct PP_FileInfo* info);
  /* Gets the list of files contained in a module-local directory. The return
   * value is the ppapi error, PP_OK if success, one of the PP_ERROR_* in case
   * of failure. If non-NULL, the returned contents should be freed with
   * FreeDirContents.
   */
  int32_t (*GetDirContents)(PP_Instance instance,
                            const char* path,
                            struct PP_DirContents_Dev** contents);
  /* Frees the data allocated by GetDirContents. */
  void (*FreeDirContents)(PP_Instance instance,
                          const struct PP_DirContents_Dev* contents);
  /* Creates a temporary file. The file will be automatically deleted when all
   * handles to it are closed.
   * Returns PP_OK if successful, one of the PP_ERROR_* values in case of
   * failure.
   * If successful, |file| is set to a file descriptor (posix) or a HANDLE
   * (win32) to the file. If failed, |file| is not touched.
   */
  int32_t (*CreateTemporaryFile)(PP_Instance instance, PP_FileHandle* file);
};

typedef struct PPB_Flash_File_ModuleLocal_3_0 PPB_Flash_File_ModuleLocal;

/**
 * This interface provides (for Flash) synchronous access to files whose paths
 * are given by a Pepper FileRef. Such FileRefs are typically obtained via the
 * Pepper file chooser.
 */
struct PPB_Flash_File_FileRef_2_0 {
  /* The functions below correspond exactly to their module-local counterparts
   * (except in taking FileRefs instead of paths, of course). We omit the
   * functionality which we do not provide for FileRefs.
   */
  int32_t (*OpenFile)(PP_Resource file_ref_id,
                      int32_t mode,
                      PP_FileHandle* file);
  int32_t (*QueryFile)(PP_Resource file_ref_id, struct PP_FileInfo* info);
};

typedef struct PPB_Flash_File_FileRef_2_0 PPB_Flash_File_FileRef;
/**
 * @}
 */

/* private/ppb_flash_font_file.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
struct PPB_Flash_FontFile_0_2 {
  /* Returns a resource identifying a font file corresponding to the given font
   * request after applying the browser-specific fallback.
   */
  PP_Resource (*Create)(
      PP_Instance instance,
      const struct PP_BrowserFont_Trusted_Description* description,
      PP_PrivateFontCharset charset);
  /* Determines if a given resource is Flash font file.
   */
  PP_Bool (*IsFlashFontFile)(PP_Resource resource);
  /* Returns the requested font table.
   * |output_length| should pass in the size of |output|. And it will return
   * the actual length of returned data. |output| could be NULL in order to
   * query the size of the buffer size needed. In that case, the input value of
   * |output_length| is ignored.
   * Note: it is Linux only and fails directly on other platforms.
   */
  PP_Bool (*GetFontTable)(PP_Resource font_file,
                          uint32_t table,
                          void* output,
                          uint32_t* output_length);
  /**
   * Returns whether <code>PPB_Flash_FontFile</code> is supported on Windows.
   */
  PP_Bool (*IsSupportedForWindows)(void);
};

typedef struct PPB_Flash_FontFile_0_2 PPB_Flash_FontFile;

struct PPB_Flash_FontFile_0_1 {
  PP_Resource (*Create)(
      PP_Instance instance,
      const struct PP_BrowserFont_Trusted_Description* description,
      PP_PrivateFontCharset charset);
  PP_Bool (*IsFlashFontFile)(PP_Resource resource);
  PP_Bool (*GetFontTable)(PP_Resource font_file,
                          uint32_t table,
                          void* output,
                          uint32_t* output_length);
};
/**
 * @}
 */

/* private/ppb_flash_fullscreen.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
struct PPB_FlashFullscreen_1_0 {
  /**
   * Checks whether the plugin instance is currently in fullscreen mode.
   */
  PP_Bool (*IsFullscreen)(PP_Instance instance);
  /**
   * Switches the plugin instance to/from fullscreen mode. Returns PP_TRUE on
   * success, PP_FALSE on failure.
   *
   * This does not unbind the current Graphics2D or Graphics3D. Pending flushes
   * and swapbuffers will execute as if the resource was off-screen. The
   * transition is asynchronous. During the transition, IsFullscreen will
   * return PP_FALSE, and no Graphics2D or Graphics3D can be bound. The
   * transition ends at the next DidChangeView when going into fullscreen mode.
   * The transition out of fullscreen mode is synchronous.
   */
  PP_Bool (*SetFullscreen)(PP_Instance instance, PP_Bool fullscreen);
  /**
   * Gets the size of the screen in pixels. When going fullscreen, the instance
   * will be resized to that size.
   */
  PP_Bool (*GetScreenSize)(PP_Instance instance, struct PP_Size* size);
};

typedef struct PPB_FlashFullscreen_1_0 PPB_FlashFullscreen;

struct PPB_FlashFullscreen_0_1 {
  PP_Bool (*IsFullscreen)(PP_Instance instance);
  PP_Bool (*SetFullscreen)(PP_Instance instance, PP_Bool fullscreen);
  PP_Bool (*GetScreenSize)(PP_Instance instance, struct PP_Size* size);
};
/**
 * @}
 */

/* private/ppb_flash_menu.idl */
/**
 * @addtogroup Enums
 * @{
 */
/* Menu item type.
 *
 * TODO(viettrungluu): Radio items not supported yet. Will also probably want
 * special menu items tied to clipboard access.
 */
typedef enum {
  PP_FLASH_MENUITEM_TYPE_NORMAL = 0,
  PP_FLASH_MENUITEM_TYPE_CHECKBOX = 1,
  PP_FLASH_MENUITEM_TYPE_SEPARATOR = 2,
  PP_FLASH_MENUITEM_TYPE_SUBMENU = 3
} PP_Flash_MenuItem_Type;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_Flash_MenuItem_Type, 4);
/**
 * @}
 */

/**
 * @addtogroup Structs
 * @{
 */
struct PP_Flash_MenuItem {
  PP_Flash_MenuItem_Type type;
  char* name;
  int32_t id;
  PP_Bool enabled;
  PP_Bool checked;
  struct PP_Flash_Menu* submenu;
};

struct PP_Flash_Menu {
  uint32_t count;
  struct PP_Flash_MenuItem *items;
};
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
struct PPB_Flash_Menu_0_2 {
  PP_Resource (*Create)(PP_Instance instance_id,
                        const struct PP_Flash_Menu* menu_data);
  PP_Bool (*IsFlashMenu)(PP_Resource resource_id);
  /* Display a context menu at the given location. If the user selects an item,
   * |selected_id| will be set to its |id| and the callback called with |PP_OK|.
   * If the user dismisses the menu without selecting an item,
   * |PP_ERROR_USERCANCEL| will be indicated.
   */
  int32_t (*Show)(PP_Resource menu_id,
                  const struct PP_Point* location,
                  int32_t* selected_id,
                  struct PP_CompletionCallback callback);
};

typedef struct PPB_Flash_Menu_0_2 PPB_Flash_Menu;
/**
 * @}
 */

/* private/ppb_flash_message_loop.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPB_Flash_MessageLoop</code> interface supports Pepper Flash to run
 * nested message loops.
 */
struct PPB_Flash_MessageLoop_0_1 {
  /**
   * Allocates a Flash message loop resource.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying one instance
   * of a module.
   *
   * @return A <code>PP_Resource</code> that can be used to run a nested message
   * loop if successful; 0 if failed.
   */
  PP_Resource (*Create)(PP_Instance instance);
  /**
   * Determines if a given resource is a Flash message loop.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to a generic
   * resource.
   *
   * @return A <code>PP_Bool</code> that is <code>PP_TRUE</code> if the given
   * resource is a Flash message loop, otherwise <code>PP_FALSE</code>.
   */
  PP_Bool (*IsFlashMessageLoop)(PP_Resource resource);
  /**
   * Runs a nested message loop. The plugin will be reentered from this call.
   * This function is used in places where Flash would normally enter a nested
   * message loop (e.g., when displaying context menus), but Pepper provides
   * only an asynchronous call. After performing that asynchronous call, call
   * <code>Run()</code>. In the callback, call <code>Quit()</code>.
   *
   * For a given message loop resource, only the first call to
   * <code>Run()</code> will start a nested message loop. The subsequent calls
   * will return <code>PP_ERROR_FAILED</code> immediately.
   *
   * @param[in] flash_message_loop The Flash message loop.
   *
   * @return <code>PP_ERROR_ABORTED</code> if the message loop quits because the
   * resource is destroyed; <code>PP_OK</code> if the message loop quits because
   * of other reasons (e.g., <code>Quit()</code> is called);
   * <code>PP_ERROR_FAILED</code> if this is not the first call to
   * <code>Run()</code>.
   */
  int32_t (*Run)(PP_Resource flash_message_loop);
  /**
   * Signals to quit the outermost nested message loop. Use this to exit and
   * return back to the caller after you call <code>Run()</code>.
   *
   * If <code>Quit()</code> is not called to balance the call to
   * <code>Run()</code>, the outermost nested message loop will be quitted
   * implicitly when the resource is destroyed.
   *
   * @param[in] flash_message_loop The Flash message loop.
   */
  void (*Quit)(PP_Resource flash_message_loop);
};

typedef struct PPB_Flash_MessageLoop_0_1 PPB_Flash_MessageLoop;
/**
 * @}
 */

/* private/ppb_flash_print.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPB_Flash_Print</code> interface contains Flash-specific printing
 * functionality.
 */
struct PPB_Flash_Print_1_0 {
  /**
   * Invokes printing on the given plugin instance.
   */
  void (*InvokePrinting)(PP_Instance instance);
};

typedef struct PPB_Flash_Print_1_0 PPB_Flash_Print;
/**
 * @}
 */

/* private/ppb_net_address_private.idl */
/**
 * @addtogroup Enums
 * @{
 */
typedef enum {
  /**
   * The address family is unspecified.
   */
  PP_NETADDRESSFAMILY_PRIVATE_UNSPECIFIED = 0,
  /**
   * The Internet Protocol version 4 (IPv4) address family.
   */
  PP_NETADDRESSFAMILY_PRIVATE_IPV4 = 1,
  /**
   * The Internet Protocol version 6 (IPv6) address family.
   */
  PP_NETADDRESSFAMILY_PRIVATE_IPV6 = 2
} PP_NetAddressFamily_Private;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_NetAddressFamily_Private, 4);
/**
 * @}
 */

/**
 * @addtogroup Structs
 * @{
 */
/**
 * This is an opaque type holding a network address. Plugins must
 * never access members of this struct directly.
 */
struct PP_NetAddress_Private {
  uint32_t size;
  int8_t data[128];
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_NetAddress_Private, 132);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPB_NetAddress_Private</code> interface provides operations on
 * network addresses.
 */
struct PPB_NetAddress_Private_1_1 {
  /**
   * Returns PP_TRUE if the two addresses are equal (host and port).
   */
  PP_Bool (*AreEqual)(const struct PP_NetAddress_Private* addr1,
                      const struct PP_NetAddress_Private* addr2);
  /**
   * Returns PP_TRUE if the two addresses refer to the same host.
   */
  PP_Bool (*AreHostsEqual)(const struct PP_NetAddress_Private* addr1,
                           const struct PP_NetAddress_Private* addr2);
  /**
   * Returns a human-readable description of the network address, optionally
   * including the port (e.g., "192.168.0.1", "192.168.0.1:99", or "[::1]:80"),
   * or an undefined var on failure.
   */
  struct PP_Var (*Describe)(PP_Module module,
                            const struct PP_NetAddress_Private* addr,
                            PP_Bool include_port);
  /**
   * Replaces the port in the given source address. Returns PP_TRUE on success.
   */
  PP_Bool (*ReplacePort)(const struct PP_NetAddress_Private* src_addr,
                         uint16_t port,
                         struct PP_NetAddress_Private* addr_out);
  /**
   * Gets the "any" address (for IPv4 or IPv6); for use with UDP Bind.
   */
  void (*GetAnyAddress)(PP_Bool is_ipv6, struct PP_NetAddress_Private* addr);
  /**
   * Gets the address family.
   */
  PP_NetAddressFamily_Private (*GetFamily)(
      const struct PP_NetAddress_Private* addr);
  /**
   * Gets the port. The port is returned in host byte order.
   */
  uint16_t (*GetPort)(const struct PP_NetAddress_Private* addr);
  /**
   * Gets the address. The output, address, must be large enough for the
   * current socket family. The output will be the binary representation of an
   * address for the current socket family. For IPv4 and IPv6 the address is in
   * network byte order. PP_TRUE is returned if the address was successfully
   * retrieved.
   */
  PP_Bool (*GetAddress)(const struct PP_NetAddress_Private* addr,
                        void* address,
                        uint16_t address_size);
  /**
   * Returns ScopeID for IPv6 addresses or 0 for IPv4.
   */
  uint32_t (*GetScopeID)(const struct PP_NetAddress_Private* addr);
  /**
   * Creates NetAddress with the specified IPv4 address and port
   * number.
   */
  void (*CreateFromIPv4Address)(const uint8_t ip[4],
                                uint16_t port,
                                struct PP_NetAddress_Private* addr_out);
  /**
   * Creates NetAddress with the specified IPv6 address, scope_id and
   * port number.
   */
  void (*CreateFromIPv6Address)(const uint8_t ip[16],
                                uint32_t scope_id,
                                uint16_t port,
                                struct PP_NetAddress_Private* addr_out);
};

typedef struct PPB_NetAddress_Private_1_1 PPB_NetAddress_Private;

struct PPB_NetAddress_Private_0_1 {
  PP_Bool (*AreEqual)(const struct PP_NetAddress_Private* addr1,
                      const struct PP_NetAddress_Private* addr2);
  PP_Bool (*AreHostsEqual)(const struct PP_NetAddress_Private* addr1,
                           const struct PP_NetAddress_Private* addr2);
  struct PP_Var (*Describe)(PP_Module module,
                            const struct PP_NetAddress_Private* addr,
                            PP_Bool include_port);
  PP_Bool (*ReplacePort)(const struct PP_NetAddress_Private* src_addr,
                         uint16_t port,
                         struct PP_NetAddress_Private* addr_out);
  void (*GetAnyAddress)(PP_Bool is_ipv6, struct PP_NetAddress_Private* addr);
};

struct PPB_NetAddress_Private_1_0 {
  PP_Bool (*AreEqual)(const struct PP_NetAddress_Private* addr1,
                      const struct PP_NetAddress_Private* addr2);
  PP_Bool (*AreHostsEqual)(const struct PP_NetAddress_Private* addr1,
                           const struct PP_NetAddress_Private* addr2);
  struct PP_Var (*Describe)(PP_Module module,
                            const struct PP_NetAddress_Private* addr,
                            PP_Bool include_port);
  PP_Bool (*ReplacePort)(const struct PP_NetAddress_Private* src_addr,
                         uint16_t port,
                         struct PP_NetAddress_Private* addr_out);
  void (*GetAnyAddress)(PP_Bool is_ipv6, struct PP_NetAddress_Private* addr);
  PP_NetAddressFamily_Private (*GetFamily)(
      const struct PP_NetAddress_Private* addr);
  uint16_t (*GetPort)(const struct PP_NetAddress_Private* addr);
  PP_Bool (*GetAddress)(const struct PP_NetAddress_Private* addr,
                        void* address,
                        uint16_t address_size);
};
/**
 * @}
 */

/* private/ppb_host_resolver_private.idl */
/**
 * @addtogroup Enums
 * @{
 */
/**
 * The <code>PP_HostResolver_Flags</code> is an enumeration of the
 * different types of flags, that can be OR-ed and passed to host
 * resolver.
 */
typedef enum {
  /**
   * AI_CANONNAME
   */
  PP_HOST_RESOLVER_PRIVATE_FLAGS_CANONNAME = 1 << 0,
  /**
   * Hint to the resolver that only loopback addresses are configured.
   */
  PP_HOST_RESOLVER_PRIVATE_FLAGS_LOOPBACK_ONLY = 1 << 1
} PP_HostResolver_Private_Flags;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_HostResolver_Private_Flags, 4);
/**
 * @}
 */

/**
 * @addtogroup Structs
 * @{
 */
struct PP_HostResolver_Private_Hint {
  PP_NetAddressFamily_Private family;
  int32_t flags;
};
PP_COMPILE_ASSERT_STRUCT_SIZE_IN_BYTES(PP_HostResolver_Private_Hint, 8);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
struct PPB_HostResolver_Private_0_1 {
  /**
   * Allocates a Host Resolver resource.
   */
  PP_Resource (*Create)(PP_Instance instance);
  /**
   * Determines if a given resource is a Host Resolver.
   */
  PP_Bool (*IsHostResolver)(PP_Resource resource);
  /**
   * Creates a new request to Host Resolver. |callback| is invoked
   * when request is processed and a list of network addresses is
   * obtained. These addresses can be be used in Connect, Bind or
   * Listen calls to connect to a given |host| and |port|.
   */
  int32_t (*Resolve)(PP_Resource host_resolver,
                     const char* host,
                     uint16_t port,
                     const struct PP_HostResolver_Private_Hint* hint,
                     struct PP_CompletionCallback callback);
  /**
   * Returns canonical name of host.
   */
  struct PP_Var (*GetCanonicalName)(PP_Resource host_resolver);
  /**
   * Returns number of network addresses obtained after Resolve call.
   */
  uint32_t (*GetSize)(PP_Resource host_resolver);
  /**
   * Stores in the |addr| |index|-th network address. |addr| can't be
   * NULL. Returns PP_TRUE if success or PP_FALSE if the given
   * resource is not a Host Resolver or |index| exceeds number of
   * available addresses.
   */
  PP_Bool (*GetNetAddress)(PP_Resource host_resolver,
                           uint32_t index,
                           struct PP_NetAddress_Private* addr);
};

typedef struct PPB_HostResolver_Private_0_1 PPB_HostResolver_Private;
/**
 * @}
 */

/* private/ppb_instance_private.idl */
/**
 * @addtogroup Enums
 * @{
 */
/**
 * The <code>PP_ExternalPluginResult </code> enum contains result codes from
 * launching an external plugin.
 */
typedef enum {
  /** Successful external plugin call */
  PP_EXTERNAL_PLUGIN_OK = 0,
  /** Unspecified external plugin error */
  PP_EXTERNAL_PLUGIN_FAILED = 1,
  /** Error creating the module */
  PP_EXTERNAL_PLUGIN_ERROR_MODULE = 2,
  /** Error creating and initializing the instance */
  PP_EXTERNAL_PLUGIN_ERROR_INSTANCE = 3
} PP_ExternalPluginResult;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_ExternalPluginResult, 4);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The PPB_Instance_Private interface contains functions available only to
 * trusted plugin instances.
 *
 */
struct PPB_Instance_Private_0_1 {
  /**
   * GetWindowObject is a pointer to a function that determines
   * the DOM window containing this module instance.
   *
   * @param[in] instance A PP_Instance whose WindowObject should be retrieved.
   * @return A PP_Var containing window object on success.
   */
  struct PP_Var (*GetWindowObject)(PP_Instance instance);
  /**
   * GetOwnerElementObject is a pointer to a function that determines
   * the DOM element containing this module instance.
   *
   * @param[in] instance A PP_Instance whose WindowObject should be retrieved.
   * @return A PP_Var containing DOM element on success.
   */
  struct PP_Var (*GetOwnerElementObject)(PP_Instance instance);
  /**
   * ExecuteScript is a pointer to a function that executes the given
   * script in the context of the frame containing the module.
   *
   * The exception, if any, will be returned in *exception. As with the PPB_Var
   * interface, the exception parameter, if non-NULL, must be initialized
   * to a "void" var or the function will immediately return. On success,
   * the exception parameter will be set to a "void" var. On failure, the
   * return value will be a "void" var.
   *
   * @param[in] script A string containing the JavaScript to execute.
   * @param[in/out] exception PP_Var containing the exception. Initialize
   * this to NULL if you don't want exception info; initialize this to a void
   * exception if want exception info.
   *
   * @return The result of the script execution, or a "void" var
   * if execution failed.
   */
  struct PP_Var (*ExecuteScript)(PP_Instance instance,
                                 struct PP_Var script,
                                 struct PP_Var* exception);
};

typedef struct PPB_Instance_Private_0_1 PPB_Instance_Private;
/**
 * @}
 */

/* private/ppb_isolated_file_system_private.idl */
/**
 * @addtogroup Enums
 * @{
 */
/**
 * The <code>PP_IsolatedFileSystemType_Private</code> values indicate the type
 * of isolated file systems.
 */
typedef enum {
  /** Type for invalid file systems */
  PP_ISOLATEDFILESYSTEMTYPE_PRIVATE_INVALID = 0,
  /** Type for CRX file systems */
  PP_ISOLATEDFILESYSTEMTYPE_PRIVATE_CRX = 1,
  /** Type for PluginPrivate file systems */
  PP_ISOLATEDFILESYSTEMTYPE_PRIVATE_PLUGINPRIVATE = 2
} PP_IsolatedFileSystemType_Private;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_IsolatedFileSystemType_Private, 4);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
/* <code>PPB_IsolatedFileSystem_Private</code> interface */
struct PPB_IsolatedFileSystem_Private_0_2 {
  /**
   * Open() opens a file system corresponding the given file system type.
   *
   * When opening the CRX file system, this should be called from an extension
   * context, otherwise it will fail.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying the instance
   * with the file system.
   * @param[in] type A file system type as defined by
   * <code>PP_IsolatedFileSystemType_Private</code> enum.
   * @param[out] file_system An output <code>PP_Resource</code> corresponding
   * to a PPB_FileSystem.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion of Open.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   */
  int32_t (*Open)(PP_Instance instance,
                  PP_IsolatedFileSystemType_Private type,
                  PP_Resource* file_system,
                  struct PP_CompletionCallback callback);
};

typedef struct PPB_IsolatedFileSystem_Private_0_2
    PPB_IsolatedFileSystem_Private;
/**
 * @}
 */

/* private/ppb_output_protection_private.idl */
/**
 * @addtogroup Enums
 * @{
 */
/**
 * Content protection methods applied on video output link.
 */
typedef enum {
  PP_OUTPUT_PROTECTION_METHOD_PRIVATE_NONE = 0,
  PP_OUTPUT_PROTECTION_METHOD_PRIVATE_HDCP = 1 << 0
} PP_OutputProtectionMethod_Private;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_OutputProtectionMethod_Private, 4);

/**
 * Video output link types.
 */
typedef enum {
  PP_OUTPUT_PROTECTION_LINK_TYPE_PRIVATE_NONE = 0,
  PP_OUTPUT_PROTECTION_LINK_TYPE_PRIVATE_UNKNOWN = 1 << 0,
  PP_OUTPUT_PROTECTION_LINK_TYPE_PRIVATE_INTERNAL = 1 << 1,
  PP_OUTPUT_PROTECTION_LINK_TYPE_PRIVATE_VGA = 1 << 2,
  PP_OUTPUT_PROTECTION_LINK_TYPE_PRIVATE_HDMI = 1 << 3,
  PP_OUTPUT_PROTECTION_LINK_TYPE_PRIVATE_DVI = 1 << 4,
  PP_OUTPUT_PROTECTION_LINK_TYPE_PRIVATE_DISPLAYPORT = 1 << 5,
  PP_OUTPUT_PROTECTION_LINK_TYPE_PRIVATE_NETWORK = 1 << 6
} PP_OutputProtectionLinkType_Private;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_OutputProtectionLinkType_Private, 4);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPB_OutputProtection_Private</code> interface allows controlling
 * output protection.
 *
 * <strong>Example:</strong>
 *
 * @code
 * op = output_protection->Create(instance);
 * output_protection->QueryStatus(op, &link_mask, &protection_mask,
 *                                done_callback);
 * @endcode
 *
 * In this example, the plugin wants to enforce HDCP for HDMI link.
 * @code
 * if (link_mask & PP_OUTPUT_PROTECTION_LINK_TYPE_PRIVATE_HDMI) {
 *   output_protection->EnableProtection(
 *       op, PP_OUTPUT_PROTECTION_METHOD_PRIVATE_HDCP, done_callback);
 * }
 * @endcode
 *
 * After EnableProtection() completes, the plugin has to query protection
 * status periodically to make sure the protection is enabled and remains
 * enabled.
 */
struct PPB_OutputProtection_Private_0_1 {
  /**
   * Create() creates a new <code>PPB_OutputProtection_Private</code> object.
   *
   * @pram[in] instance A <code>PP_Instance</code> identifying one instance of
   * a module.
   *
   * @return A <code>PP_Resource</code> corresponding to a
   * <code>PPB_OutputProtection_Private</code> if successful, 0 if creation
   * failed.
   */
  PP_Resource (*Create)(PP_Instance instance);
  /**
   * IsOutputProtection() determines if the provided resource is a
   * <code>PPB_OutputProtection_Private</code>.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to a
   * <code>PPB_OutputProtection_Private</code>.
   *
   * @return <code>PP_TRUE</code> if the resource is a
   * <code>PPB_OutputProtection_Private</code>, <code>PP_FALSE</code> if the
   * resource is invalid or some type other than
   * <code>PPB_OutputProtection_Private</code>.
   */
  PP_Bool (*IsOutputProtection)(PP_Resource resource);
  /**
   * Query link status and protection status.
   * Clients have to query status periodically in order to detect changes.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to a
   * <code>PPB_OutputProtection_Private</code>.
   * @param[out] link_mask The type of connected output links, which is a
   * bit-mask of the <code>PP_OutputProtectionLinkType_Private</code> values.
   * @param[out] protection_mask Enabled protection methods, which is a
   * bit-mask of the <code>PP_OutputProtectionMethod_Private</code> values.
   * @param[in] callback A <code>PP_CompletionCallback</code> to run on
   * asynchronous completion of QueryStatus(). This callback will only run if
   * QueryStatus() returns <code>PP_OK_COMPLETIONPENDING</code>.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   */
  int32_t (*QueryStatus)(PP_Resource resource,
                         uint32_t* link_mask,
                         uint32_t* protection_mask,
                         struct PP_CompletionCallback callback);
  /**
   * Set desired protection methods.
   *
   * When the desired protection method(s) have been applied to all applicable
   * output links, the relevant bit(s) of the protection_mask returned by
   * QueryStatus() will be set. Otherwise, the relevant bit(s) of
   * protection_mask will not be set; there is no separate error code or
   * callback.
   *
   * Protections will be disabled if no longer desired by all instances.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to a
   * <code>PPB_OutputProtection_Private</code>.
   * @param[in] desired_protection_mask The desired protection methods, which
   * is a bit-mask of the <code>PP_OutputProtectionMethod_Private</code>
   * values.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called with
   * <code>PP_OK</code> when the protection request has been made. This may be
   * before the protection have actually been applied. Call QueryStatus to get
   * protection status. If it failed to make the protection request, the
   * callback is called with <code>PP_ERROR_FAILED</code> and there is no need
   * to call QueryStatus().
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   */
  int32_t (*EnableProtection)(PP_Resource resource,
                              uint32_t desired_protection_mask,
                              struct PP_CompletionCallback callback);
};

typedef struct PPB_OutputProtection_Private_0_1 PPB_OutputProtection_Private;
/**
 * @}
 */

/* private/ppb_pdf.idl */
/**
 * @addtogroup Enums
 * @{
 */
typedef enum {
  PP_PDFFEATURE_HIDPI = 0,
  PP_PDFFEATURE_PRINTING = 1
} PP_PDFFeature;
/**
 * @}
 */

/**
 * @addtogroup Structs
 * @{
 */
struct PP_PrivateFontFileDescription {
  char* face;
  uint32_t weight;
  PP_Bool italic;
};

struct PP_PrivateFindResult {
  int32_t start_index;
  int32_t length;
};

struct PP_PrivateAccessibilityViewportInfo {
  double zoom;
  struct PP_Point scroll;
  struct PP_Point offset;
};

struct PP_PrivateAccessibilityDocInfo {
  uint32_t page_count;
  PP_Bool text_accessible;
  PP_Bool text_copyable;
};
/**
 * @}
 */

/**
 * @addtogroup Enums
 * @{
 */
typedef enum {
  PP_PRIVATEDIRECTION_NONE = 0,
  PP_PRIVATEDIRECTION_LTR = 1,
  PP_PRIVATEDIRECTION_RTL = 2,
  PP_PRIVATEDIRECTION_TTB = 3,
  PP_PRIVATEDIRECTION_BTT = 4,
  PP_PRIVATEDIRECTION_LAST = PP_PRIVATEDIRECTION_BTT
} PP_PrivateDirection;
/**
 * @}
 */

/**
 * @addtogroup Structs
 * @{
 */
struct PP_PrivateAccessibilityPageInfo {
  uint32_t page_index;
  struct PP_Rect bounds;
  uint32_t text_run_count;
  uint32_t char_count;
};

struct PP_PrivateAccessibilityTextRunInfo {
  uint32_t len;
  double font_size;
  struct PP_FloatRect bounds;
  PP_PrivateDirection direction;
};

struct PP_PrivateAccessibilityCharInfo {
  uint32_t unicode_character;
  double char_width;
};
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
struct PPB_PDF_0_1 {
  /* Returns a resource identifying a font file corresponding to the given font
   * request after applying the browser-specific fallback.
   *
   * Currently Linux-only.
   */
  PP_Resource (*GetFontFileWithFallback)(
      PP_Instance instance,
      const struct PP_BrowserFont_Trusted_Description* description,
      PP_PrivateFontCharset charset);
  /* Given a resource previously returned by GetFontFileWithFallback, returns
   * a pointer to the requested font table. Linux only.
   */
  PP_Bool (*GetFontTableForPrivateFontFile)(PP_Resource font_file,
                                            uint32_t table,
                                            void* output,
                                            uint32_t* output_length);
  /* Search the given string using ICU.  Use PPB_Core's MemFree on results when
   * done.
   */
  void (*SearchString)(PP_Instance instance,
                       const void* str,
                       const void* term,
                       PP_Bool case_sensitive,
                       struct PP_PrivateFindResult** results,
                       int32_t* count);
  /* Since WebFrame doesn't know about PPAPI requests, it'll think the page has
   * finished loading even if there are outstanding requests by the plugin.
   * Take this out once WebFrame knows about requests by PPAPI plugins.
   */
  void (*DidStartLoading)(PP_Instance instance);
  void (*DidStopLoading)(PP_Instance instance);
  /* Sets content restriction for a full-page plugin (i.e. can't copy/print).
   * The value is a bitfield of ContentRestriction enums.
   */
  void (*SetContentRestriction)(PP_Instance instance, int32_t restrictions);
  /* Notifies the browser that the given action has been performed. */
  void (*UserMetricsRecordAction)(PP_Instance instance, struct PP_Var action);
  /* Notifies the browser that the PDF has an unsupported feature. */
  void (*HasUnsupportedFeature)(PP_Instance instance);
  /*Invoke SaveAs... dialog, similar to the right-click or wrench menu. */
  void (*SaveAs)(PP_Instance instance);
  /* Invoke Print dialog for plugin. */
  void (*Print)(PP_Instance instance);
  PP_Bool (*IsFeatureEnabled)(PP_Instance instance, PP_PDFFeature feature);
  /* Sets the selected text of the plugin. If |selected_text| is empty, then no
   * text is selected. */
  void (*SetSelectedText)(PP_Instance instance, const char* selected_text);
  /* Sets the link under the cursor. If |url| is empty, then no link is under
   * the cursor. */
  void (*SetLinkUnderCursor)(PP_Instance instance, const char* url);
  /* Gets pointers to both the mmap'd V8 snapshot files and their sizes.
   * This is needed when loading V8's initial snapshot from external files. */
  void (*GetV8ExternalSnapshotData)(PP_Instance instance,
                                    void** natives_data_out,
                                    int32_t* natives_size_out,
                                    void** snapshot_data_out,
                                    int32_t* snapshot_size_out);
  /* Sends information about the viewport to the renderer for accessibility
   * support. */
  void (*SetAccessibilityViewportInfo)(
      PP_Instance instance,
      const struct PP_PrivateAccessibilityViewportInfo* viewport_info);
  /* Sends information about the PDF document to the renderer for accessibility
   * support. */
  void (*SetAccessibilityDocInfo)(
      PP_Instance instance,
      const struct PP_PrivateAccessibilityDocInfo* doc_info);
  /* Sends information about one page in a PDF document to the renderer for
   * accessibility support. */
  void (*SetAccessibilityPageInfo)(
      PP_Instance instance,
      const struct PP_PrivateAccessibilityPageInfo* page_info,
      const struct PP_PrivateAccessibilityTextRunInfo text_runs[],
      const struct PP_PrivateAccessibilityCharInfo chars[]);
  /* Sends information about the PDF's URL and the embedder's URL. */
  void (*SetCrashData)(PP_Instance instance,
                       const char* pdf_url,
                       const char* top_level_url);
};

typedef struct PPB_PDF_0_1 PPB_PDF;
/**
 * @}
 */

/* private/ppb_platform_verification_private.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPB_PlatformVerification_Private</code> interface allows authorized
 * services to verify that the underlying platform is trusted. An example of a
 * trusted platform is a Chrome OS device in verified boot mode.
 */
struct PPB_PlatformVerification_Private_0_2 {
  /**
   * Create() creates a <code>PPB_PlatformVerification_Private</code> object.
   *
   * @pram[in] instance A <code>PP_Instance</code> identifying one instance of
   * a module.
   *
   * @return A <code>PP_Resource</code> corresponding to a
   * <code>PPB_PlatformVerification_Private</code> if successful, 0 if creation
   * failed.
   */
  PP_Resource (*Create)(PP_Instance instance);
  /**
   * IsPlatformVerification() determines if the provided resource is a
   * <code>PPB_PlatformVerification_Private</code>.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to a
   * <code>PPB_PlatformVerification_Private</code>.
   *
   * @return <code>PP_TRUE</code> if the resource is a
   * <code>PPB_PlatformVerification_Private</code>, <code>PP_FALSE</code> if the
   * resource is invalid or some type other than
   * <code>PPB_PlatformVerification_Private</code>.
   */
  PP_Bool (*IsPlatformVerification)(PP_Resource resource);
  /**
   * Requests a platform challenge for a given service id.
   *
   * @param[in] service_id A <code>PP_Var</code> of type
   * <code>PP_VARTYPE_STRING</code> containing the service_id for the challenge.
   *
   * @param[in] challenge A <code>PP_Var</code> of type
   * <code>PP_VARTYPE_ARRAY_BUFFER</code> that contains the challenge data.
   *
   * @param[out] signed_data A <code>PP_Var</code> of type
   * <code>PP_VARTYPE_ARRAY_BUFFER</code> that contains the data signed by the
   * platform.
   *
   * @param[out] signed_data_signature A <code>PP_Var</code> of type
   * <code>PP_VARTYPE_ARRAY_BUFFER</code> that contains the signature of the
   * signed data block.
   *
   * @param[out] platform_key_certificate A <code>PP_Var</code> of type
   * <code>PP_VARTYPE_STRING</code> that contains the device specific
   * certificate for the requested service_id.
   *
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called after
   * the platform challenge has been completed. This callback will only run if
   * the return code is <code>PP_OK_COMPLETIONPENDING</code>.
   *
   * @return An int32_t containing an error code from <code>pp_errors.h</code>.
   */
  int32_t (*ChallengePlatform)(PP_Resource instance,
                               struct PP_Var service_id,
                               struct PP_Var challenge,
                               struct PP_Var* signed_data,
                               struct PP_Var* signed_data_signature,
                               struct PP_Var* platform_key_certificate,
                               struct PP_CompletionCallback callback);
};

typedef struct PPB_PlatformVerification_Private_0_2
    PPB_PlatformVerification_Private;
/**
 * @}
 */

/* private/ppb_tcp_server_socket_private.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPB_TCPServerSocket_Private</code> interface provides TCP
 * server socket operations.
 */
struct PPB_TCPServerSocket_Private_0_2 {
  /**
   * Allocates a TCP server socket resource.
   */
  PP_Resource (*Create)(PP_Instance instance);
  /**
   * Determines if a given resource is TCP server socket.
   */
  PP_Bool (*IsTCPServerSocket)(PP_Resource resource);
  /**
   * Binds |tcp_server_socket| to the address given by |addr| and
   * starts listening.  The |backlog| argument defines the maximum
   * length to which the queue of pending connections may
   * grow. |callback| is invoked when |tcp_server_socket| is ready to
   * accept incoming connections or in the case of failure. Returns
   * PP_ERROR_NOSPACE if socket can't be initialized, or
   * PP_ERROR_FAILED in the case of Listen failure. Otherwise, returns
   * PP_OK.
   */
  int32_t (*Listen)(PP_Resource tcp_server_socket,
                    const struct PP_NetAddress_Private* addr,
                    int32_t backlog,
                    struct PP_CompletionCallback callback);
  /**
   * Accepts single connection, creates instance of
   * PPB_TCPSocket_Private and stores reference to it in
   * |tcp_socket|. |callback| is invoked when connection is accepted
   * or in the case of failure. This method can be called only after
   * successful Listen call on |tcp_server_socket|.
   */
  int32_t (*Accept)(PP_Resource tcp_server_socket,
                    PP_Resource* tcp_socket,
                    struct PP_CompletionCallback callback);
  /**
   * Returns the current address to which the socket is bound, in the
   * buffer pointed to by |addr|. This method can be called only after
   * successful Listen() call and before StopListening() call.
   */
  int32_t (*GetLocalAddress)(PP_Resource tcp_server_socket,
                             struct PP_NetAddress_Private* addr);
  /**
   * Cancels all pending callbacks reporting PP_ERROR_ABORTED and
   * closes the socket. Note: this method is implicitly called when
   * server socket is destroyed.
   */
  void (*StopListening)(PP_Resource tcp_server_socket);
};

typedef struct PPB_TCPServerSocket_Private_0_2 PPB_TCPServerSocket_Private;

struct PPB_TCPServerSocket_Private_0_1 {
  PP_Resource (*Create)(PP_Instance instance);
  PP_Bool (*IsTCPServerSocket)(PP_Resource resource);
  int32_t (*Listen)(PP_Resource tcp_server_socket,
                    const struct PP_NetAddress_Private* addr,
                    int32_t backlog,
                    struct PP_CompletionCallback callback);
  int32_t (*Accept)(PP_Resource tcp_server_socket,
                    PP_Resource* tcp_socket,
                    struct PP_CompletionCallback callback);
  void (*StopListening)(PP_Resource tcp_server_socket);
};
/**
 * @}
 */

/* private/ppb_tcp_socket_private.idl */
/**
 * @addtogroup Enums
 * @{
 */
typedef enum {
  /* Special value used for testing. Guaranteed to fail SetOption(). */
  PP_TCPSOCKETOPTION_PRIVATE_INVALID = 0,
  /* Disable coalescing of small writes to make TCP segments, and instead
   * deliver data immediately. For SSL sockets, this option must be set before
   * SSLHandshake() is called. Value type is PP_VARTYPE_BOOL. */
  PP_TCPSOCKETOPTION_PRIVATE_NO_DELAY = 1
} PP_TCPSocketOption_Private;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_TCPSocketOption_Private, 4);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPB_TCPSocket_Private</code> interface provides TCP socket
 * operations.
 */
struct PPB_TCPSocket_Private_0_5 {
  /**
   * Allocates a TCP socket resource.
   */
  PP_Resource (*Create)(PP_Instance instance);
  /**
   * Determines if a given resource is TCP socket.
   */
  PP_Bool (*IsTCPSocket)(PP_Resource resource);
  /**
   * Connects to a TCP port given as a host-port pair.
   * When a proxy server is used, |host| and |port| refer to the proxy server
   * instead of the destination server.
   */
  int32_t (*Connect)(PP_Resource tcp_socket,
                     const char* host,
                     uint16_t port,
                     struct PP_CompletionCallback callback);
  /**
   * Same as Connect(), but connecting to the address given by |addr|. A typical
   * use-case would be for reconnections.
   */
  int32_t (*ConnectWithNetAddress)(PP_Resource tcp_socket,
                                   const struct PP_NetAddress_Private* addr,
                                   struct PP_CompletionCallback callback);
  /**
   * Gets the local address of the socket, if it has been connected.
   * Returns PP_TRUE on success.
   */
  PP_Bool (*GetLocalAddress)(PP_Resource tcp_socket,
                             struct PP_NetAddress_Private* local_addr);
  /**
   * Gets the remote address of the socket, if it has been connected.
   * Returns PP_TRUE on success.
   */
  PP_Bool (*GetRemoteAddress)(PP_Resource tcp_socket,
                              struct PP_NetAddress_Private* remote_addr);
  /**
   * Does SSL handshake and moves to sending and receiving encrypted data. The
   * socket must have been successfully connected. |server_name| will be
   * compared with the name(s) in the server's certificate during the SSL
   * handshake. |server_port| is only used to identify an SSL server in the SSL
   * session cache.
   * When a proxy server is used, |server_name| and |server_port| refer to the
   * destination server.
   * If the socket is not connected, or there are pending read/write requests,
   * SSLHandshake() will fail without starting a handshake. Otherwise, any
   * failure during the handshake process will cause the socket to be
   * disconnected.
   */
  int32_t (*SSLHandshake)(PP_Resource tcp_socket,
                          const char* server_name,
                          uint16_t server_port,
                          struct PP_CompletionCallback callback);
  /**
   * Returns the server's <code>PPB_X509Certificate_Private</code> for a socket
   * connection if an SSL connection has been established using
   * <code>SSLHandshake</code>. If no SSL connection has been established, a
   * null resource is returned.
   */
  PP_Resource (*GetServerCertificate)(PP_Resource tcp_socket);
  /**
   * NOTE: This function is not implemented and will return
   * <code>PP_FALSE</code>.
   * Adds a trusted/untrusted chain building certificate to be used for this
   * connection. The <code>certificate</code> must be a
   * <code>PPB_X509Certificate_Private<code>. <code>PP_TRUE</code> is returned
   * upon success.
   */
  PP_Bool (*AddChainBuildingCertificate)(PP_Resource tcp_socket,
                                         PP_Resource certificate,
                                         PP_Bool is_trusted);
  /**
   * Reads data from the socket. The size of |buffer| must be at least as large
   * as |bytes_to_read|. May perform a partial read. Returns the number of bytes
   * read or an error code. If the return value is 0, then it indicates that
   * end-of-file was reached.
   * This method won't return more than 1 megabyte, so if |bytes_to_read|
   * exceeds 1 megabyte, it will always perform a partial read.
   * Multiple outstanding read requests are not supported.
   */
  int32_t (*Read)(PP_Resource tcp_socket,
                  char* buffer,
                  int32_t bytes_to_read,
                  struct PP_CompletionCallback callback);
  /**
   * Writes data to the socket. May perform a partial write. Returns the number
   * of bytes written or an error code.
   * This method won't write more than 1 megabyte, so if |bytes_to_write|
   * exceeds 1 megabyte, it will always perform a partial write.
   * Multiple outstanding write requests are not supported.
   */
  int32_t (*Write)(PP_Resource tcp_socket,
                   const char* buffer,
                   int32_t bytes_to_write,
                   struct PP_CompletionCallback callback);
  /**
   * Cancels any IO that may be pending, and disconnects the socket. Any pending
   * callbacks will still run, reporting PP_Error_Aborted if pending IO was
   * interrupted. It is NOT valid to call Connect() again after a call to this
   * method. Note: If the socket is destroyed when it is still connected, then
   * it will be implicitly disconnected, so you are not required to call this
   * method.
   */
  void (*Disconnect)(PP_Resource tcp_socket);
  /**
   * Sets an option on |tcp_socket|.  Supported |name| and |value| parameters
   * are as described for PP_TCPSocketOption_Private.  |callback| will be
   * invoked with PP_OK if setting the option succeeds, or an error code
   * otherwise. The socket must be connection before SetOption is called.
   */
  int32_t (*SetOption)(PP_Resource tcp_socket,
                       PP_TCPSocketOption_Private name,
                       struct PP_Var value,
                       struct PP_CompletionCallback callback);
};

typedef struct PPB_TCPSocket_Private_0_5 PPB_TCPSocket_Private;

struct PPB_TCPSocket_Private_0_3 {
  PP_Resource (*Create)(PP_Instance instance);
  PP_Bool (*IsTCPSocket)(PP_Resource resource);
  int32_t (*Connect)(PP_Resource tcp_socket,
                     const char* host,
                     uint16_t port,
                     struct PP_CompletionCallback callback);
  int32_t (*ConnectWithNetAddress)(PP_Resource tcp_socket,
                                   const struct PP_NetAddress_Private* addr,
                                   struct PP_CompletionCallback callback);
  PP_Bool (*GetLocalAddress)(PP_Resource tcp_socket,
                             struct PP_NetAddress_Private* local_addr);
  PP_Bool (*GetRemoteAddress)(PP_Resource tcp_socket,
                              struct PP_NetAddress_Private* remote_addr);
  int32_t (*SSLHandshake)(PP_Resource tcp_socket,
                          const char* server_name,
                          uint16_t server_port,
                          struct PP_CompletionCallback callback);
  int32_t (*Read)(PP_Resource tcp_socket,
                  char* buffer,
                  int32_t bytes_to_read,
                  struct PP_CompletionCallback callback);
  int32_t (*Write)(PP_Resource tcp_socket,
                   const char* buffer,
                   int32_t bytes_to_write,
                   struct PP_CompletionCallback callback);
  void (*Disconnect)(PP_Resource tcp_socket);
};

struct PPB_TCPSocket_Private_0_4 {
  PP_Resource (*Create)(PP_Instance instance);
  PP_Bool (*IsTCPSocket)(PP_Resource resource);
  int32_t (*Connect)(PP_Resource tcp_socket,
                     const char* host,
                     uint16_t port,
                     struct PP_CompletionCallback callback);
  int32_t (*ConnectWithNetAddress)(PP_Resource tcp_socket,
                                   const struct PP_NetAddress_Private* addr,
                                   struct PP_CompletionCallback callback);
  PP_Bool (*GetLocalAddress)(PP_Resource tcp_socket,
                             struct PP_NetAddress_Private* local_addr);
  PP_Bool (*GetRemoteAddress)(PP_Resource tcp_socket,
                              struct PP_NetAddress_Private* remote_addr);
  int32_t (*SSLHandshake)(PP_Resource tcp_socket,
                          const char* server_name,
                          uint16_t server_port,
                          struct PP_CompletionCallback callback);
  PP_Resource (*GetServerCertificate)(PP_Resource tcp_socket);
  PP_Bool (*AddChainBuildingCertificate)(PP_Resource tcp_socket,
                                         PP_Resource certificate,
                                         PP_Bool is_trusted);
  int32_t (*Read)(PP_Resource tcp_socket,
                  char* buffer,
                  int32_t bytes_to_read,
                  struct PP_CompletionCallback callback);
  int32_t (*Write)(PP_Resource tcp_socket,
                   const char* buffer,
                   int32_t bytes_to_write,
                   struct PP_CompletionCallback callback);
  void (*Disconnect)(PP_Resource tcp_socket);
};
/**
 * @}
 */

/* private/ppb_testing_private.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
struct PPB_Testing_Private_1_0 {
  /**
   * Reads the bitmap data out of the backing store for the given
   * DeviceContext2D and into the given image. If the data was successfully
   * read, it will return PP_TRUE.
   *
   * This function should not generally be necessary for normal plugin
   * operation. If you want to update portions of a device, the expectation is
   * that you will either regenerate the data, or maintain a backing store
   * pushing updates to the device from your backing store via PaintImageData.
   * Using this function will introduce an extra copy which will make your
   * plugin slower. In some cases, this may be a very expensive operation (it
   * may require slow cross-process transitions or graphics card readbacks).
   *
   * Data will be read into the image starting at |top_left| in the device
   * context, and proceeding down and to the right for as many pixels as the
   * image is large. If any part of the image bound would fall outside of the
   * backing store of the device if positioned at |top_left|, this function
   * will fail and return PP_FALSE.
   *
   * The image format must be of the format
   * PPB_ImageData.GetNativeImageDataFormat() or this function will fail and
   * return PP_FALSE.
   *
   * The returned image data will represent the current status of the backing
   * store. This will not include any paint, scroll, or replace operations
   * that have not yet been flushed; these operations are only reflected in
   * the backing store (and hence ReadImageData) until after a Flush()
   * operation has completed.
   */
  PP_Bool (*ReadImageData)(PP_Resource device_context_2d,
                           PP_Resource image,
                           const struct PP_Point* top_left);
  /**
   * Runs a nested message loop. The plugin will be reentered from this call.
   * This function is used for unit testing the API. The normal pattern is to
   * issue some asynchronous call that has a callback. Then you call
   * RunMessageLoop which will suspend the plugin and go back to processing
   * messages, giving the asynchronous operation time to complete. In your
   * callback, you save the data and call QuitMessageLoop, which will then
   * pop back up and continue with the test. This avoids having to write a
   * complicated state machine for simple tests for asynchronous APIs.
   */
  void (*RunMessageLoop)(PP_Instance instance);
  /**
   * Posts a quit message for the outermost nested message loop. Use this to
   * exit and return back to the caller after you call RunMessageLoop.
   */
  void (*QuitMessageLoop)(PP_Instance instance);
  /**
   * Returns the number of live objects (resources + strings + objects)
   * associated with this plugin instance. Used for detecting leaks. Returns
   * (uint32_t)-1 on failure.
   */
  uint32_t (*GetLiveObjectsForInstance)(PP_Instance instance);
  /**
   * Returns PP_TRUE if the plugin is running out-of-process, PP_FALSE
   * otherwise.
   */
  PP_Bool (*IsOutOfProcess)(void);
  /**
   * Posts the plugin's current Power Saver status to JavaScript. The plugin
   * itself does not recieve anything. This is not idiomatic for Pepper,
   * but convenient for testing.
   */
  void (*PostPowerSaverStatus)(PP_Instance instance);
  /**
   * Subscribes to changes to the plugin's Power Saver status. The status
   * changes are not forwarded to the plugin itself, but posted to JavaScript.
   * This is not idiomatic for Pepper, but conveienent for testing.
   */
  void (*SubscribeToPowerSaverNotifications)(PP_Instance instance);
  /**
   * Passes the input event to the browser, which sends it back to the
   * plugin. The plugin should implement PPP_InputEvent and register for
   * the input event type.
   *
   * This method sends an input event through the browser just as if it had
   * come from the user. If the browser determines that it is an event for the
   * plugin, it will be sent to be handled by the plugin's PPP_InputEvent
   * interface. When generating mouse events, make sure the position is within
   * the plugin's area on the page. When generating a keyboard event, make sure
   * the plugin is focused.
   *
   * Note that the browser may generate extra input events in order to
   * maintain certain invariants, such as always having a "mouse enter" event
   * before any other mouse event. Furthermore, the event the plugin receives
   * after sending a simulated event will be slightly different from the
   * original event. The browser may change the timestamp, add modifiers, and
   * slightly alter the mouse position, due to coordinate transforms it
   * performs.
   */
  void (*SimulateInputEvent)(PP_Instance instance, PP_Resource input_event);
  /**
   * Returns the URL for the document. This is a safe way to retrieve
   * window.location.href.
   * If the canonicalized URL is valid, the method will parse the URL
   * and fill in the components structure. This pointer may be NULL
   * to specify that no component information is necessary.
   */
  struct PP_Var (*GetDocumentURL)(PP_Instance instance,
                                  struct PP_URLComponents_Dev* components);
  /**
   * Fetches up to |array_size| active PP_Vars in the tracker. Returns the
   * number of vars in the tracker. The active vars are written to |live_vars|
   * contiguously starting at index 0. The vars are not in any particular order.
   * If the number of live vars is greater than |array_size|, then an arbitrary
   * subset of |array_size| vars is written to |live_vars|. The reference count
   * of the returned PP_Vars will *not* be affected by this call.
   */
  uint32_t (*GetLiveVars)(struct PP_Var live_vars[], uint32_t array_size);
  /**
   * Sets the threshold size at which point we switch from transmitting
   * array buffers in IPC messages to using shared memory. This is only used
   * for testing purposes where we need to transmit small buffers using shmem
   * (in order to have fast tests). Passing a value of 0 resets the threshold
   * to its default. The threshold is in bytes.
   */
  void (*SetMinimumArrayBufferSizeForShmem)(PP_Instance instance,
                                            uint32_t threshold);
  /**
   * Run the V8 garbage collector for tests.
   */
  void (*RunV8GC)(PP_Instance instance);
};

typedef struct PPB_Testing_Private_1_0 PPB_Testing_Private;
/**
 * @}
 */

/* private/ppb_udp_socket_private.idl */
/**
 * @addtogroup Enums
 * @{
 */
typedef enum {
  /* Allow the socket to share the local address to which socket will
   * be bound with other processes. Value's type should be
   * PP_VARTYPE_BOOL. */
  PP_UDPSOCKETFEATURE_PRIVATE_ADDRESS_REUSE = 0,
  /* Allow sending and receiving packets sent to and from broadcast
   * addresses. Value's type should be PP_VARTYPE_BOOL. */
  PP_UDPSOCKETFEATURE_PRIVATE_BROADCAST = 1,
  /* Special value for counting the number of available
   * features. Should not be passed to SetSocketFeature(). */
  PP_UDPSOCKETFEATURE_PRIVATE_COUNT = 2
} PP_UDPSocketFeature_Private;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_UDPSocketFeature_Private, 4);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
struct PPB_UDPSocket_Private_0_4 {
  /**
   * Creates a UDP socket resource.
   */
  PP_Resource (*Create)(PP_Instance instance_id);
  /**
   * Determines if a given resource is a UDP socket.
   */
  PP_Bool (*IsUDPSocket)(PP_Resource resource_id);
  /**
   * Sets a socket feature to |udp_socket|. Should be called before
   * Bind(). Possible values for |name|, |value| and |value|'s type
   * are described in PP_UDPSocketFeature_Private description. If no
   * error occurs, returns PP_OK. Otherwise, returns
   * PP_ERROR_BADRESOURCE (if bad |udp_socket| provided),
   * PP_ERROR_BADARGUMENT (if bad name/value/value's type provided)
   * or PP_ERROR_FAILED in the case of internal errors.
   */
  int32_t (*SetSocketFeature)(PP_Resource udp_socket,
                              PP_UDPSocketFeature_Private name,
                              struct PP_Var value);
  /* Creates a socket and binds to the address given by |addr|. */
  int32_t (*Bind)(PP_Resource udp_socket,
                  const struct PP_NetAddress_Private* addr,
                  struct PP_CompletionCallback callback);
  /* Returns the address that the socket has bound to.  A successful
   * call to Bind must be called first. Returns PP_FALSE if Bind
   * fails, or if Close has been called.
   */
  PP_Bool (*GetBoundAddress)(PP_Resource udp_socket,
                             struct PP_NetAddress_Private* addr);
  /* Performs a non-blocking recvfrom call on socket.
   * Bind must be called first. |callback| is invoked when recvfrom
   * reads data.  You must call GetRecvFromAddress to recover the
   * address the data was retrieved from.
   */
  int32_t (*RecvFrom)(PP_Resource udp_socket,
                      char* buffer,
                      int32_t num_bytes,
                      struct PP_CompletionCallback callback);
  /* Upon successful completion of RecvFrom, the address that the data
   * was received from is stored in |addr|.
   */
  PP_Bool (*GetRecvFromAddress)(PP_Resource udp_socket,
                                struct PP_NetAddress_Private* addr);
  /* Performs a non-blocking sendto call on the socket created and
   * bound(has already called Bind).  The callback |callback| is
   * invoked when sendto completes.
   */
  int32_t (*SendTo)(PP_Resource udp_socket,
                    const char* buffer,
                    int32_t num_bytes,
                    const struct PP_NetAddress_Private* addr,
                    struct PP_CompletionCallback callback);
  /* Cancels all pending reads and writes, and closes the socket. */
  void (*Close)(PP_Resource udp_socket);
};

typedef struct PPB_UDPSocket_Private_0_4 PPB_UDPSocket_Private;

struct PPB_UDPSocket_Private_0_2 {
  PP_Resource (*Create)(PP_Instance instance_id);
  PP_Bool (*IsUDPSocket)(PP_Resource resource_id);
  int32_t (*Bind)(PP_Resource udp_socket,
                  const struct PP_NetAddress_Private* addr,
                  struct PP_CompletionCallback callback);
  int32_t (*RecvFrom)(PP_Resource udp_socket,
                      char* buffer,
                      int32_t num_bytes,
                      struct PP_CompletionCallback callback);
  PP_Bool (*GetRecvFromAddress)(PP_Resource udp_socket,
                                struct PP_NetAddress_Private* addr);
  int32_t (*SendTo)(PP_Resource udp_socket,
                    const char* buffer,
                    int32_t num_bytes,
                    const struct PP_NetAddress_Private* addr,
                    struct PP_CompletionCallback callback);
  void (*Close)(PP_Resource udp_socket);
};

struct PPB_UDPSocket_Private_0_3 {
  PP_Resource (*Create)(PP_Instance instance_id);
  PP_Bool (*IsUDPSocket)(PP_Resource resource_id);
  int32_t (*Bind)(PP_Resource udp_socket,
                  const struct PP_NetAddress_Private* addr,
                  struct PP_CompletionCallback callback);
  PP_Bool (*GetBoundAddress)(PP_Resource udp_socket,
                             struct PP_NetAddress_Private* addr);
  int32_t (*RecvFrom)(PP_Resource udp_socket,
                      char* buffer,
                      int32_t num_bytes,
                      struct PP_CompletionCallback callback);
  PP_Bool (*GetRecvFromAddress)(PP_Resource udp_socket,
                                struct PP_NetAddress_Private* addr);
  int32_t (*SendTo)(PP_Resource udp_socket,
                    const char* buffer,
                    int32_t num_bytes,
                    const struct PP_NetAddress_Private* addr,
                    struct PP_CompletionCallback callback);
  void (*Close)(PP_Resource udp_socket);
};
/**
 * @}
 */

/* private/ppb_uma_private.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * Contains functions for plugins to report UMA usage stats.
 */
struct PPB_UMA_Private_0_3 {
  /**
   * HistogramCustomTimes is a pointer to a function which records a time
   * sample given in milliseconds in the histogram given by |name|, possibly
   * creating the histogram if it does not exist.
   */
  void (*HistogramCustomTimes)(PP_Instance instance,
                               struct PP_Var name,
                               int64_t sample,
                               int64_t min,
                               int64_t max,
                               uint32_t bucket_count);
  /**
   * HistogramCustomCounts is a pointer to a function which records a sample
   * in the histogram given by |name|, possibly creating the histogram if it
   * does not exist.
   */
  void (*HistogramCustomCounts)(PP_Instance instance,
                                struct PP_Var name,
                                int32_t sample,
                                int32_t min,
                                int32_t max,
                                uint32_t bucket_count);
  /**
   * HistogramEnumeration is a pointer to a function which records a sample
   * in the histogram given by |name|, possibly creating the histogram if it
   * does not exist.  The sample represents a value in an enumeration bounded
   * by |boundary_value|, that is, sample < boundary_value always.
   */
  void (*HistogramEnumeration)(PP_Instance instance,
                               struct PP_Var name,
                               int32_t sample,
                               int32_t boundary_value);
  /**
   * IsCrashReportingEnabled returns PP_OK to the completion callback to
   * indicate that the current user has opted-in to crash reporting, or
   * PP_ERROR_* on failure or when a user has not opted-in.  This can be used to
   * gate other reporting processes such as analytics and crash reporting.
   */
  int32_t (*IsCrashReportingEnabled)(PP_Instance instance,
                                     struct PP_CompletionCallback callback);
};

typedef struct PPB_UMA_Private_0_3 PPB_UMA_Private;
/**
 * @}
 */

/* private/ppb_video_destination_private.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPB_VideoDestination_Private</code> interface contains pointers to
 * several functions for creating video destination resources and using them to
 * send video frames to a MediaStream video track in the browser.
 */
struct PPB_VideoDestination_Private_0_1 {
  /**
   * Creates a video destination resource.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying an instance of
   * a module.
   *
   * @return A <code>PP_Resource</code> with a nonzero ID on success or zero on
   * failure. Failure means the instance was invalid.
   */
  PP_Resource (*Create)(PP_Instance instance);
  /**
   * Determines if a resource is a video destination resource.
   *
   * @param[in] resource The <code>PP_Resource</code> to test.
   *
   * @return A <code>PP_Bool</code> with <code>PP_TRUE</code> if the given
   * resource is a video destination resource or <code>PP_FALSE</code>
   * otherwise.
   */
  PP_Bool (*IsVideoDestination)(PP_Resource resource);
  /**
   * Opens a video destination for putting frames.
   *
   * @param[in] destination A <code>PP_Resource</code> corresponding to a video
   * destination resource.
   * @param[in] stream_url A <code>PP_Var</code> string holding a URL
   * identifying a MediaStream.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion of Open().
   *
   * @return An int32_t containing a result code from <code>pp_errors.h</code>.
   * Returns PP_ERROR_BADRESOURCE if destination isn't a valid video
   * destination.
   * Returns PP_ERROR_INPROGRESS if destination is already open.
   * Returns PP_ERROR_FAILED if the MediaStream doesn't exist or if there is
   * some other browser error.
   */
  int32_t (*Open)(PP_Resource destination,
                  struct PP_Var stream_url,
                  struct PP_CompletionCallback callback);
  /**
   * Puts a frame to the video destination.
   *
   * After this call, you should take care to release your references to the
   * image embedded in the video frame. If you paint to the image after
   * PutFame(), there is the possibility of artifacts because the browser may
   * still be copying the frame to the stream.
   *
   * @param[in] destination A <code>PP_Resource</code> corresponding to a video
   * destination resource.
   * @param[in] frame A <code>PP_VideoFrame_Private</code> holding the video
   * frame to send to the destination.
   *
   * @return An int32_t containing a result code from <code>pp_errors.h</code>.
   * Returns PP_ERROR_BADRESOURCE if destination isn't a valid video
   * destination.
   * Returns PP_ERROR_FAILED if destination is not open, if the video frame has
   * an invalid image data resource, or if some other browser error occurs.
   */
  int32_t (*PutFrame)(PP_Resource destination,
                      const struct PP_VideoFrame_Private* frame);
  /**
   * Closes the video destination.
   *
   * @param[in] destination A <code>PP_Resource</code> corresponding to a video
   * destination.
   */
  void (*Close)(PP_Resource destination);
};

typedef struct PPB_VideoDestination_Private_0_1 PPB_VideoDestination_Private;
/**
 * @}
 */

/* private/ppb_video_source_private.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPB_VideoSource_Private</code> interface contains pointers to
 * several functions for creating video source resources and using them to
 * receive video frames from a MediaStream video track in the browser.
 */
struct PPB_VideoSource_Private_0_1 {
  /**
   * Creates a video source resource.
   *
   * @param[in] instance A <code>PP_Instance</code> identifying an instance of
   * a module.
   *
   * @return A <code>PP_Resource</code> with a nonzero ID on success or zero on
   * failure. Failure means the instance was invalid.
   */
  PP_Resource (*Create)(PP_Instance instance);
  /**
   * Determines if a resource is a video source resource.
   *
   * @param[in] resource The <code>PP_Resource</code> to test.
   *
   * @return A <code>PP_Bool</code> with <code>PP_TRUE</code> if the given
   * resource is a video source resource or <code>PP_FALSE</code> otherwise.
   */
  PP_Bool (*IsVideoSource)(PP_Resource resource);
  /**
   * Opens a video source for getting frames.
   *
   * @param[in] source A <code>PP_Resource</code> corresponding to a video
   * source resource.
   * @param[in] stream_url A <code>PP_Var</code> string holding a URL
   * identifying a MediaStream.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion of Open().
   *
   * @return An int32_t containing a result code from <code>pp_errors.h</code>.
   * Returns PP_ERROR_BADRESOURCE if source isn't a valid video source.
   * Returns PP_ERROR_INPROGRESS if source is already open.
   * Returns PP_ERROR_FAILED if the MediaStream doesn't exist or if there is
   * some other browser error.
   */
  int32_t (*Open)(PP_Resource source,
                  struct PP_Var stream_url,
                  struct PP_CompletionCallback callback);
  /**
   * Gets a frame from the video source. The returned image data is only valid
   * until the next call to GetFrame.
   * The image data resource inside the returned frame will have its reference
   * count incremented by one and must be managed by the plugin.
   *
   * @param[in] source A <code>PP_Resource</code> corresponding to a video
   * source resource.
   * @param[out] frame A <code>PP_VideoFrame_Private</code> to hold a video
   * frame from the source.
   * @param[in] callback A <code>PP_CompletionCallback</code> to be called upon
   * completion of GetNextFrame().
   *
   * @return An int32_t containing a result code from <code>pp_errors.h</code>.
   * Returns PP_ERROR_BADRESOURCE if source isn't a valid video source.
   * Returns PP_ERROR_FAILED if the source is not open, or if some other
   * browser error occurs.
   */
  int32_t (*GetFrame)(PP_Resource source,
                      struct PP_VideoFrame_Private* frame,
                      struct PP_CompletionCallback callback);
  /**
   * Closes the video source.
   *
   * @param[in] source A <code>PP_Resource</code> corresponding to a video
   * source resource.
   */
  void (*Close)(PP_Resource source);
};

typedef struct PPB_VideoSource_Private_0_1 PPB_VideoSource_Private;
/**
 * @}
 */

/* private/ppb_x509_certificate_private.idl */
/**
 * @addtogroup Enums
 * @{
 */
/**
 * This enumeration corresponds to fields of an X509 certificate. Refer to
 * <a href="http://www.ietf.org/rfc/rfc5280.txt>RFC 5280</a> for further
 * documentation about particular fields.
 */
typedef enum {
  /** This corresponds to a string (<code>PP_VARTYPE_STRING</code>). */
  PP_X509CERTIFICATE_PRIVATE_ISSUER_COMMON_NAME = 0,
  /** This corresponds to a string (<code>PP_VARTYPE_STRING</code>). */
  PP_X509CERTIFICATE_PRIVATE_ISSUER_LOCALITY_NAME = 1,
  /** This corresponds to a string (<code>PP_VARTYPE_STRING</code>). */
  PP_X509CERTIFICATE_PRIVATE_ISSUER_STATE_OR_PROVINCE_NAME = 2,
  /** This corresponds to a string (<code>PP_VARTYPE_STRING</code>). */
  PP_X509CERTIFICATE_PRIVATE_ISSUER_COUNTRY_NAME = 3,
  /** This corresponds to a string (<code>PP_VARTYPE_STRING</code>). */
  PP_X509CERTIFICATE_PRIVATE_ISSUER_ORGANIZATION_NAME = 4,
  /** This corresponds to a string (<code>PP_VARTYPE_STRING</code>). */
  PP_X509CERTIFICATE_PRIVATE_ISSUER_ORGANIZATION_UNIT_NAME = 5,
  /**
   * Note: This field is unimplemented and will return
   * <code>PP_VARTYPE_NULL</code>.
   */
  PP_X509CERTIFICATE_PRIVATE_ISSUER_UNIQUE_ID = 6,
  /** This corresponds to a string (<code>PP_VARTYPE_STRING</code>). */
  PP_X509CERTIFICATE_PRIVATE_SUBJECT_COMMON_NAME = 7,
  /** This corresponds to a string (<code>PP_VARTYPE_STRING</code>). */
  PP_X509CERTIFICATE_PRIVATE_SUBJECT_LOCALITY_NAME = 8,
  /** This corresponds to a string (<code>PP_VARTYPE_STRING</code>). */
  PP_X509CERTIFICATE_PRIVATE_SUBJECT_STATE_OR_PROVINCE_NAME = 9,
  /** This corresponds to a string (<code>PP_VARTYPE_STRING</code>). */
  PP_X509CERTIFICATE_PRIVATE_SUBJECT_COUNTRY_NAME = 10,
  /** This corresponds to a string (<code>PP_VARTYPE_STRING</code>). */
  PP_X509CERTIFICATE_PRIVATE_SUBJECT_ORGANIZATION_NAME = 11,
  /** This corresponds to a string (<code>PP_VARTYPE_STRING</code>). */
  PP_X509CERTIFICATE_PRIVATE_SUBJECT_ORGANIZATION_UNIT_NAME = 12,
  /**
   * Note: This field is unimplemented and will return
   * <code>PP_VARTYPE_NULL</code>.
   */
  PP_X509CERTIFICATE_PRIVATE_SUBJECT_UNIQUE_ID = 13,
  /**
   * Note: This field is unimplemented and will return
   * <code>PP_VARTYPE_NULL</code>.
   */
  PP_X509CERTIFICATE_PRIVATE_VERSION = 14,
  /**
   * This corresponds to a byte array (<code>PP_VARTYPE_ARRAY_BUFFER</code>).
   * The serial number may include a leading 0.
   */
  PP_X509CERTIFICATE_PRIVATE_SERIAL_NUMBER = 15,
  /**
   * Note: This field is unimplemented and will return
   * <code>PP_VARTYPE_NULL</code>.
   */
  PP_X509CERTIFICATE_PRIVATE_SIGNATURE_ALGORITHM_OID = 16,
  /**
   * Note: This field is unimplemented and will return
   * <code>PP_VARTYPE_NULL</code>.
   */
  PP_X509CERTIFICATE_PRIVATE_SIGNATURE_ALGORITHM_PARAMATERS_RAW = 17,
  /**
   * This corresponds to a double (<code>PP_VARTYPE_DOUBLE</code>) which
   * can be cast to a <code>PP_TIME</code>.
   */
  PP_X509CERTIFICATE_PRIVATE_VALIDITY_NOT_BEFORE = 18,
  /**
   * This corresponds to a double (<code>PP_VARTYPE_DOUBLE</code>) which
   * can be cast to a <code>PP_TIME</code>.
   */
  PP_X509CERTIFICATE_PRIVATE_VALIDITY_NOT_AFTER = 19,
  /** This corresponds to a string (<code>PP_VARTYPE_STRING</code>). */
  PP_X509CERTIFICATE_PRIVATE_SUBJECT_PUBLIC_KEY_ALGORITHM_OID = 20,
  /**
   * Note: This field is unimplemented and will return
   * <code>PP_VARTYPE_NULL</code>.
   */
  PP_X509CERTIFICATE_PRIVATE_SUBJECT_PUBLIC_KEY = 21,
  /**
   * This corresponds to a byte array (<code>PP_VARTYPE_ARRAY_BUFFER</code>).
   * This is the DER-encoded representation of the certificate.
   */
  PP_X509CERTIFICATE_PRIVATE_RAW = 22,
  /** This corresponds to a string (<code>PP_VARTYPE_STRING</code>). */
  PP_X509CERTIFICATE_PRIVATE_ISSUER_DISTINGUISHED_NAME = 23,
  /** This corresponds to a string (<code>PP_VARTYPE_STRING</code>). */
  PP_X509CERTIFICATE_PRIVATE_SUBJECT_DISTINGUISHED_NAME = 24
} PP_X509Certificate_Private_Field;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_X509Certificate_Private_Field, 4);

/**
 * This enumeration defines the different possible values for X5O9 certificate
 * versions as returned by:
 * <code>GetField(resource, PP_X509CERTIFICATE_PRIVATE_VERSION)</code>.
 */
typedef enum {
  PP_X509CERTIFICATE_PRIVATE_V1 = 0,
  PP_X509CERTIFICATE_PRIVATE_V2 = 1,
  PP_X509CERTIFICATE_PRIVATE_V3 = 2
} PPB_X509Certificate_Private_Version;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PPB_X509Certificate_Private_Version, 4);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The <code>PPB_X509Certificate_Private</code> interface provides access to
 * the fields of an X509 certificate.
 */
struct PPB_X509Certificate_Private_0_1 {
  /**
   * Allocates a <code>PPB_X509Certificate_Private</code> resource.
   * <code>Initialize()</code> must be called before using the certificate.
   */
  PP_Resource (*Create)(PP_Instance instance);
  /**
   * Returns <code>PP_TRUE</code> if a given resource is a
   * <code>PPB_X509Certificate_Private</code>.
   */
  PP_Bool (*IsX509CertificatePrivate)(PP_Resource resource);
  /**
   * Initializes a <code>PPB_X509Certificate_Private</code> from the DER-encoded
   * representation. |bytes| should represent only a single certificate.
   * <code>PP_FALSE</code> is returned if |bytes| is not a valid DER-encoding of
   * a certificate. Note: Flash requires this to be synchronous.
   */
  PP_Bool (*Initialize)(PP_Resource resource,
                        const char* bytes,
                        uint32_t length);
  /**
   * Get a field of the X509Certificate as a <code>PP_Var</code>. A null
   * <code>PP_Var</code> is returned if the field is unavailable.
   */
  struct PP_Var (*GetField)(PP_Resource resource,
                            PP_X509Certificate_Private_Field field);
};

typedef struct PPB_X509Certificate_Private_0_1 PPB_X509Certificate_Private;
/**
 * @}
 */

/* private/ppp_content_decryptor_private.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * <code>PPP_ContentDecryptor_Private</code> structure contains the function
 * pointers the decryption plugin must implement to provide services needed by
 * the browser. This interface provides the plugin side support for the Content
 * Decryption Module (CDM) for Encrypted Media Extensions:
 * http://www.w3.org/TR/encrypted-media/
 */
struct PPP_ContentDecryptor_Private_0_16 {
  /**
   * Initialize for the specified key system.
   *
   * @param[in] promise_id A reference for the promise that gets resolved or
   * rejected depending upon the success or failure of initialization.
   *
   * @param[in] key_system A <code>PP_Var</code> of type
   * <code>PP_VARTYPE_STRING</code> containing the name of the key system.
   * @param[in] allow_distinctive_identifier Inform the CDM that it may use a
   * distinctive identifier.
   * @param[in] allow_persistent_state Inform the CDM that it may use persistent
   * state.
   */
  void (*Initialize)(PP_Instance instance,
                     uint32_t promise_id,
                     struct PP_Var key_system,
                     PP_Bool allow_distinctive_identifier,
                     PP_Bool allow_persistent_state);
  /**
   * Provides a server certificate to be used to encrypt messages to the
   * license server.
   *
   * @param[in] promise_id A reference for the promise that gets resolved or
   * rejected depending upon the success or failure of setting the certificate.
   *
   * @param[in] server_certificate A <code>PP_Var</code> of type
   * <code>PP_VARTYPE_ARRAYBUFFER</code> containing the certificate to be used.
   */
  void (*SetServerCertificate)(PP_Instance instance,
                               uint32_t promise_id,
                               struct PP_Var server_certificate);
  /**
   * Creates a session and subsequently generates a request for a license.
   * <code>init_data_type</code> contains the MIME type of
   * <code>init_data</code>. <code>init_data</code> is a data buffer
   * containing data for use in generating the request.
   *
   * Note: <code>CreateSessionAndGenerateRequest()</code> must create a
   * session ID and provide it to the browser via <code>SessionCreated()</code>
   * on the <code>PPB_ContentDecryptor_Private</code> interface.
   *
   * @param[in] promise_id A reference for the promise that gets resolved or
   * rejected depending upon the success or failure when creating the session.
   *
   * @param[in] session_type A <code>PP_SessionType</code> that indicates the
   * type of session to be created.
   *
   * @param[in] init_data_type A <code>PP_InitDataType</code> that indicates
   * the Initialization Data Type for init_data.
   *
   * @param[in] init_data A <code>PP_Var</code> of type
   * <code>PP_VARTYPE_ARRAYBUFFER</code> containing container specific
   * initialization data.
   */
  void (*CreateSessionAndGenerateRequest)(PP_Instance instance,
                                          uint32_t promise_id,
                                          PP_SessionType session_type,
                                          PP_InitDataType init_data_type,
                                          struct PP_Var init_data);
  /**
   * Loads a session whose session ID is <code>session_id</code>.
   *
   * Note: After the session is successfully loaded, the CDM must call
   * <code>SessionCreated()</code> with <code>session_id</code> on the
   * <code>PPB_ContentDecryptor_Private</code> interface.
   *
   * @param[in] promise_id A reference for the promise that gets resolved or
   * rejected depending upon the success or failure of loading the session.
   *
   * @param[in] session_type A <code>PP_SessionType</code> that indicates the
   * type of session to be loaded.
   *
   * @param[in] session_id A <code>PP_Var</code> of type
   * <code>PP_VARTYPE_STRING</code> containing the session ID of the session
   * to load.
   */
  void (*LoadSession)(PP_Instance instance,
                      uint32_t promise_id,
                      PP_SessionType session_type,
                      struct PP_Var session_id);
  /**
   * Provides a license or other message to the decryptor.
   *
   * When the CDM needs more information, it must call
   * <code>SessionMessage()</code> on the
   * <code>PPB_ContentDecryptor_Private</code> interface, and the browser
   * must notify the web application. When the CDM has finished processing
   * <code>response</code> and needs no more information, it must call
   * <code>SessionReady()</code> on the
   * <code>PPB_ContentDecryptor_Private</code> interface, and the browser
   * must notify the web application.
   *
   * @param[in] promise_id A reference for the promise that gets resolved or
   * rejected depending upon the success or failure of updating the session.
   *
   * @param[in] session_id A <code>PP_Var</code> of type
   * <code>PP_VARTYPE_STRING</code> containing the session ID of the session
   * to be updated.
   *
   * @param[in] response A <code>PP_Var</code> of type
   * <code>PP_VARTYPE_ARRAYBUFFER</code> containing the license or other
   * message for the given session ID.
   */
  void (*UpdateSession)(PP_Instance instance,
                        uint32_t promise_id,
                        struct PP_Var session_id,
                        struct PP_Var response);
  /**
   * Close the specified session and related resources.
   *
   * @param[in] promise_id A reference for the promise that gets resolved or
   * rejected depending upon the success or failure of closing the session.
   *
   * @param[in] session_id A <code>PP_Var</code> of type
   * <code>PP_VARTYPE_STRING</code> containing the session ID of the session
   * to be closed.
   *
   */
  void (*CloseSession)(PP_Instance instance,
                       uint32_t promise_id,
                       struct PP_Var session_id);
  /**
   * Remove stored data associated with this session.
   *
   * @param[in] promise_id A reference for the promise that gets resolved or
   * rejected depending upon the success or failure of removing the session
   * data.
   *
   * @param[in] session_id A <code>PP_Var</code> of type
   * <code>PP_VARTYPE_STRING</code> containing the session ID of the session
   * to be removed.
   *
   */
  void (*RemoveSession)(PP_Instance instance,
                        uint32_t promise_id,
                        struct PP_Var session_id);
  /**
   * Decrypts the block and returns the unencrypted block via
   * <code>DeliverBlock()</code> on the
   * <code>PPB_ContentDecryptor_Private</code> interface. The returned block
   * contains encoded data.
   *
   * @param[in] resource A <code>PP_Resource</code> corresponding to a
   * <code>PPB_Buffer_Dev</code> resource that contains an encrypted data
   * block.
   *
   * @param[in] encrypted_block_info A <code>PP_EncryptedBlockInfo</code> that
   * contains all auxiliary information needed for decryption of the
   * <code>encrypted_block</code>.
   */
  void (*Decrypt)(PP_Instance instance,
                  PP_Resource encrypted_block,
                  const struct PP_EncryptedBlockInfo* encrypted_block_info);
  /**
   * Initializes the audio decoder using codec and settings in
   * <code>decoder_config</code>, and returns the result of the initialization
   * request to the browser using the <code>DecoderInitializeDone(
      )</code> method
   * on the <code>PPB_ContentDecryptor_Private</code> interface.
   *
   * @param[in] decoder_config A <code>PP_AudioDecoderConfig</code> that
   * contains audio decoder settings and a request ID. The request ID is passed
   * to the <code>DecoderInitializeDone()</code> method on the
   * <code>PPB_ContentDecryptor_Private</code> interface to allow clients to
   * associate the result with a audio decoder initialization request.
   *
   * @param[in] codec_extra_data A <code>PP_Resource</code> corresponding to a
   * <code>PPB_Buffer_Dev</code> resource containing codec setup data required
   * by some codecs. It should be set to 0 when the codec being initialized
   * does not require it.
   */
  void (*InitializeAudioDecoder)(
      PP_Instance instance,
      const struct PP_AudioDecoderConfig* decoder_config,
      PP_Resource codec_extra_data);
  /**
   * Initializes the video decoder using codec and settings in
   * <code>decoder_config</code>, and returns the result of the initialization
   * request to the browser using the <code>DecoderInitializeDone()</code>
   * method on the <code>PPB_ContentDecryptor_Private</code> interface.
   *
   * @param[in] decoder_config A <code>PP_VideoDecoderConfig</code> that
   * contains video decoder settings and a request ID. The request ID is passed
   * to the <code>DecoderInitializeDone()</code> method on the
   * <code>PPB_ContentDecryptor_Private</code> interface to allow clients to
   * associate the result with a video decoder initialization request.
   *
   * @param[in] codec_extra_data A <code>PP_Resource</code> corresponding to a
   * <code>PPB_Buffer_Dev</code> resource containing codec setup data required
   * by some codecs. It should be set to 0 when the codec being initialized
   * does not require it.
   */
  void (*InitializeVideoDecoder)(
      PP_Instance instance,
      const struct PP_VideoDecoderConfig* decoder_config,
      PP_Resource codec_extra_data);
  /**
   * De-initializes the decoder for the <code>PP_DecryptorStreamType</code>
   * specified by <code>decoder_type</code> and sets it to an uninitialized
   * state. The decoder can be re-initialized after de-initialization completes
   * by calling <code>InitializeAudioDecoder</code> or
   * <code>InitializeVideoDecoder</code>.
   *
   * De-initialization completion is reported to the browser using the
   * <code>DecoderDeinitializeDone()</code> method on the
   * <code>PPB_ContentDecryptor_Private</code> interface.
   *
   * @param[in] decoder_type A <code>PP_DecryptorStreamType</code> that
   * specifies the decoder to de-initialize.
   *
   * @param[in] request_id A request ID that allows the browser to associate a
   * request to de-initialize a decoder with the corresponding call to the
   * <code>DecoderDeinitializeDone()</code> method on the
   * <code>PPB_ContentDecryptor_Private</code> interface.
   */
  void (*DeinitializeDecoder)(PP_Instance instance,
                              PP_DecryptorStreamType decoder_type,
                              uint32_t request_id);
  /**
   * Resets the decoder for the <code>PP_DecryptorStreamType</code> specified
   * by <code>decoder_type</code> to an initialized clean state. Reset
   * completion is reported to the browser using the
   * <code>DecoderResetDone()</code> method on the
   * <code>PPB_ContentDecryptor_Private</code> interface. This method can be
   * used to signal a discontinuity in the encoded data stream, and is safe to
   * call multiple times.
   *
   * @param[in] decoder_type A <code>PP_DecryptorStreamType</code> that
   * specifies the decoder to reset.
   *
   * @param[in] request_id A request ID that allows the browser to associate a
   * request to reset the decoder with a corresponding call to the
   * <code>DecoderResetDone()</code> method on the
   * <code>PPB_ContentDecryptor_Private</code> interface.
   */
  void (*ResetDecoder)(PP_Instance instance,
                       PP_DecryptorStreamType decoder_type,
                       uint32_t request_id);
  /**
   * Decrypts encrypted_buffer, decodes it, and returns the unencrypted
   * uncompressed (decoded) data to the browser via the
   * <code>DeliverFrame()</code> or <code>DeliverSamples()</code> method on the
   * <code>PPB_ContentDecryptor_Private</code> interface.
   *
   * @param[in] decoder_type A <code>PP_DecryptorStreamType</code> that
   * specifies the decoder to use after <code>encrypted_buffer</code> is
   * decrypted.
   *
   * @param[in] encrypted_buffer A <code>PP_Resource</code> corresponding to a
   * <code>PPB_Buffer_Dev</code> resource that contains encrypted media data.
   *
   * @param[in] encrypted_block_info A <code>PP_EncryptedBlockInfo</code> that
   * contains all auxiliary information needed for decryption of the
   * <code>encrypted_block</code>.
   */
  void (*DecryptAndDecode)(
      PP_Instance instance,
      PP_DecryptorStreamType decoder_type,
      PP_Resource encrypted_buffer,
      const struct PP_EncryptedBlockInfo* encrypted_block_info);
};

typedef struct PPP_ContentDecryptor_Private_0_16 PPP_ContentDecryptor_Private;
/**
 * @}
 */

/* private/ppp_find_private.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
struct PPP_Find_Private_0_3 {
  /**
   * Finds the given UTF-8 text starting at the current selection. The number of
   * results will be updated asynchronously via NumberOfFindResultsChanged in
   * PPB_Find. Note that multiple StartFind calls can happen before StopFind is
   * called in the case of the search term changing.
   *
   * Return PP_FALSE if the plugin doesn't support find in page. Consequently,
   * it won't call any callbacks.
   */
  PP_Bool (*StartFind)(PP_Instance instance,
                       const char* text,
                       PP_Bool case_sensitive);
  /**
   * Go to the next/previous result.
   */
  void (*SelectFindResult)(PP_Instance instance, PP_Bool forward);
  /**
   * Tells the plugin that the find operation has stopped, so it should clear
   * any highlighting.
   */
  void (*StopFind)(PP_Instance instance);
};

typedef struct PPP_Find_Private_0_3 PPP_Find_Private;
/**
 * @}
 */

/* private/ppp_flash_browser_operations.idl */
/**
 * @addtogroup Enums
 * @{
 */
typedef enum {
  PP_FLASH_BROWSEROPERATIONS_SETTINGTYPE_CAMERAMIC = 0,
  PP_FLASH_BROWSEROPERATIONS_SETTINGTYPE_PEERNETWORKING = 1
} PP_Flash_BrowserOperations_SettingType;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_Flash_BrowserOperations_SettingType, 4);

typedef enum {
  /* This value is only used with <code>SetSitePermission()</code>. */
  PP_FLASH_BROWSEROPERATIONS_PERMISSION_DEFAULT = 0,
  PP_FLASH_BROWSEROPERATIONS_PERMISSION_ALLOW = 1,
  PP_FLASH_BROWSEROPERATIONS_PERMISSION_BLOCK = 2,
  PP_FLASH_BROWSEROPERATIONS_PERMISSION_ASK = 3
} PP_Flash_BrowserOperations_Permission;
PP_COMPILE_ASSERT_SIZE_IN_BYTES(PP_Flash_BrowserOperations_Permission, 4);
/**
 * @}
 */

/**
 * @addtogroup Structs
 * @{
 */
struct PP_Flash_BrowserOperations_SiteSetting {
  const char* site;
  PP_Flash_BrowserOperations_Permission permission;
};
/**
 * @}
 */

/**
 * @addtogroup Typedefs
 * @{
 */
typedef void (*PPB_Flash_BrowserOperations_GetSettingsCallback)(
    void* user_data,
    PP_Bool success,
    PP_Flash_BrowserOperations_Permission default_permission,
    uint32_t site_count,
    const struct PP_Flash_BrowserOperations_SiteSetting sites[]);
/**
 * @}
 */

/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * This interface allows the browser to request the plugin do things.
 */
struct PPP_Flash_BrowserOperations_1_3 {
  /**
   * This function allows the plugin to implement the "Clear site data" feature.
   *
   * @param[in] plugin_data_path String containing the directory where the
   * plugin data is
   * stored. On UTF16 systems (Windows), this will be encoded as UTF-8. It will
   * be an absolute path and will not have a directory separator (slash) at the
   * end.
   * @param[in] site String specifying which site to clear the data for. This
   * will be null to clear data for all sites.
   * @param[in] flags Currently always 0 in Chrome to clear all data. This may
   * be extended in the future to clear only specific types of data.
   * @param[in] max_age The maximum age in seconds to clear data for. This
   * allows the plugin to implement "clear past hour" and "clear past data",
   * etc.
   *
   * @return PP_TRUE on success, PP_FALSE on failure.
   *
   * See also the NPP_ClearSiteData function in NPAPI.
   * https://wiki.mozilla.org/NPAPI:ClearSiteData
   */
  PP_Bool (*ClearSiteData)(const char* plugin_data_path,
                           const char* site,
                           uint64_t flags,
                           uint64_t max_age);
  /**
   * Requests the plugin to deauthorize content licenses. It prevents Flash from
   * playing protected content, such as movies and music the user may have
   * rented or purchased.
   *
   * @param[in] plugin_data_path String containing the directory where the
   * plugin settings are stored.
   *
   * @return <code>PP_TRUE</code> on success, <code>PP_FALSE</code> on failure.
   */
  PP_Bool (*DeauthorizeContentLicenses)(const char* plugin_data_path);
  /**
   * Gets permission settings. <code>callback</code> will be called exactly once
   * to return the settings.
   *
   * @param[in] plugin_data_path String containing the directory where the
   * plugin settings are stored.
   * @param[in] setting_type What type of setting to retrieve.
   * @param[in] callback The callback to return retrieved data.
   * @param[inout] user_data An opaque pointer that will be passed to
   * <code>callback</code>.
   */
  void (*GetPermissionSettings)(
      const char* plugin_data_path,
      PP_Flash_BrowserOperations_SettingType setting_type,
      PPB_Flash_BrowserOperations_GetSettingsCallback callback,
      void* user_data);
  /**
   * Sets default permission. It applies to all sites except those with
   * site-specific settings.
   *
   * @param[in] plugin_data_path String containing the directory where the
   * plugin settings are stored.
   * @param[in] setting_type What type of setting to set.
   * @param[in] permission The default permission.
   * @param[in] clear_site_specific Whether to remove all site-specific
   * settings.
   *
   * @return <code>PP_TRUE</code> on success, <code>PP_FALSE</code> on failure.
   */
  PP_Bool (*SetDefaultPermission)(
      const char* plugin_data_path,
      PP_Flash_BrowserOperations_SettingType setting_type,
      PP_Flash_BrowserOperations_Permission permission,
      PP_Bool clear_site_specific);
  /**
   * Sets site-specific permission. If a site has already got site-specific
   * permission and it is not in <code>sites</code>, it won't be affected.
   *
   * @param[in] plugin_data_path String containing the directory where the
   * plugin settings are stored.
   * @param[in] setting_type What type of setting to set.
   * @param[in] site_count How many items are there in <code>sites</code>.
   * @param[in] sites The site-specific settings. If a site is specified with
   * <code>PP_FLASH_BROWSEROPERATIONS_PERMISSION_DEFAULT</code> permission, it
   * will be removed from the site-specific list.
   *
   * @return <code>PP_TRUE</code> on success, <code>PP_FALSE</code> on failure.
   */
  PP_Bool (*SetSitePermission)(
      const char* plugin_data_path,
      PP_Flash_BrowserOperations_SettingType setting_type,
      uint32_t site_count,
      const struct PP_Flash_BrowserOperations_SiteSetting sites[]);
  /**
   * Returns a list of sites that have stored data, for use with the
   * "Clear site data" feature.
   *
   * @param[in] plugin_data_path String containing the directory where the
   * plugin data is stored.
   * @param[out] sites A NULL-terminated array of sites that have stored data.
   * Use FreeSiteList on the array when done.
   *
   * See also the NPP_GetSitesWithData function in NPAPI:
   * https://wiki.mozilla.org/NPAPI:ClearSiteData
   */
  void (*GetSitesWithData)(const char* plugin_data_path, char*** sites);
  /**
   * Frees the list of sites returned by GetSitesWithData.
   *
   * @param[in] sites A NULL-terminated array of strings.
   */
  void (*FreeSiteList)(char* sites[]);
};

typedef struct PPP_Flash_BrowserOperations_1_3 PPP_Flash_BrowserOperations;

struct PPP_Flash_BrowserOperations_1_0 {
  PP_Bool (*ClearSiteData)(const char* plugin_data_path,
                           const char* site,
                           uint64_t flags,
                           uint64_t max_age);
};

struct PPP_Flash_BrowserOperations_1_2 {
  PP_Bool (*ClearSiteData)(const char* plugin_data_path,
                           const char* site,
                           uint64_t flags,
                           uint64_t max_age);
  PP_Bool (*DeauthorizeContentLicenses)(const char* plugin_data_path);
  void (*GetPermissionSettings)(
      const char* plugin_data_path,
      PP_Flash_BrowserOperations_SettingType setting_type,
      PPB_Flash_BrowserOperations_GetSettingsCallback callback,
      void* user_data);
  PP_Bool (*SetDefaultPermission)(
      const char* plugin_data_path,
      PP_Flash_BrowserOperations_SettingType setting_type,
      PP_Flash_BrowserOperations_Permission permission,
      PP_Bool clear_site_specific);
  PP_Bool (*SetSitePermission)(
      const char* plugin_data_path,
      PP_Flash_BrowserOperations_SettingType setting_type,
      uint32_t site_count,
      const struct PP_Flash_BrowserOperations_SiteSetting sites[]);
};
/**
 * @}
 */

/* private/ppp_instance_private.idl */
/**
 * @addtogroup Interfaces
 * @{
 */
/**
 * The PPP_Instance_Private interface contains pointers to a series of
 * functions that may be implemented in a trusted plugin to provide capabilities
 * that aren't possible in untrusted modules.
 */
struct PPP_Instance_Private_0_1 {
  /**
   * GetInstanceObject returns a PP_Var representing the scriptable object for
   * the given instance. Normally this will be a PPP_Class_Deprecated object
   * that exposes methods and properties to JavaScript.
   *
   * On Failure, the returned PP_Var should be a "void" var.
   *
   * The returned PP_Var should have a reference added for the caller, which
   * will be responsible for Release()ing that reference.
   *
   * @param[in] instance A PP_Instance identifying the instance from which the
   *            instance object is being requested.
   * @return A PP_Var containing scriptable object.
   */
  struct PP_Var (*GetInstanceObject)(PP_Instance instance);
};

typedef struct PPP_Instance_Private_0_1 PPP_Instance_Private;
/**
 * @}
 */

/* private/ppp_pexe_stream_handler.idl */
#include "ppapi/c/private/pp_file_handle.h"

/**
 * @addtogroup Interfaces
 * @{
 */
struct PPP_PexeStreamHandler_1_0 {
  /**
   * Invoked as a result of a cache hit for a translated pexe.
   */
  void (*DidCacheHit)(void* user_data, PP_FileHandle nexe_file_handle);
  /**
   * Invoked as a result of a cache miss for a translated pexe.
   * Provides the expected length of the pexe, as read from HTTP headers.
   */
  void (*DidCacheMiss)(void* user_data,
                       int64_t expected_total_length,
                       PP_FileHandle temp_nexe_file);
  /**
   * Invoked when a block of data has been downloaded.
   * Only invoked after DidCacheMiss().
   */
  void (*DidStreamData)(void* user_data, const void* data, int32_t length);
  /**
   * Invoked when the stream has finished downloading, regardless of whether it
   * succeeded. Not invoked if DidCacheHit() was called.
   */
  void (*DidFinishStream)(void* user_data, int32_t pp_error);
};

typedef struct PPP_PexeStreamHandler_1_0 PPP_PexeStreamHandler;
/**
 * @}
 */

#include "host/rpc.h"
#include "json/json.cpp"
using namespace std;
using namespace JSON;
const string ToString_PP_ArrayOutput_GetDataBuffer(const PP_ArrayOutput_GetDataBuffer &v);
void FromJSON_PP_ArrayOutput_GetDataBuffer(JSONIterator& iterator, PP_ArrayOutput_GetDataBuffer &value);
const string ToString_PP_ArrayOutput(const PP_ArrayOutput *v);
const string ToString_PP_ArrayOutput(const PP_ArrayOutput &v);
void FromJSON_PP_ArrayOutput(JSONIterator& iterator, PP_ArrayOutput &value);
const string ToString_PP_Bool(const PP_Bool *v);
const string ToString_PP_Bool(const PP_Bool &v);
void FromJSON_PP_Bool(JSONIterator& iterator, PP_Bool &value);
const string ToString_PP_VideoProfile(const PP_VideoProfile *v);
const string ToString_PP_VideoProfile(const PP_VideoProfile &v);
void FromJSON_PP_VideoProfile(JSONIterator& iterator, PP_VideoProfile &value);
const string ToString_PP_AudioProfile(const PP_AudioProfile *v);
const string ToString_PP_AudioProfile(const PP_AudioProfile &v);
void FromJSON_PP_AudioProfile(JSONIterator& iterator, PP_AudioProfile &value);
const string ToString_PP_HardwareAcceleration(const PP_HardwareAcceleration *v);
const string ToString_PP_HardwareAcceleration(const PP_HardwareAcceleration &v);
void FromJSON_PP_HardwareAcceleration(JSONIterator& iterator, PP_HardwareAcceleration &value);
const string ToString_PP_VideoPicture(const PP_VideoPicture *v);
const string ToString_PP_VideoPicture(const PP_VideoPicture &v);
void FromJSON_PP_VideoPicture(JSONIterator& iterator, PP_VideoPicture &value);
const string ToString_PP_VideoPicture_0_1(const PP_VideoPicture_0_1 *v);
const string ToString_PP_VideoPicture_0_1(const PP_VideoPicture_0_1 &v);
void FromJSON_PP_VideoPicture_0_1(JSONIterator& iterator, PP_VideoPicture_0_1 &value);
const string ToString_PP_VideoProfileDescription(const PP_VideoProfileDescription *v);
const string ToString_PP_VideoProfileDescription(const PP_VideoProfileDescription &v);
void FromJSON_PP_VideoProfileDescription(JSONIterator& iterator, PP_VideoProfileDescription &value);
const string ToString_PP_VideoProfileDescription_0_1(const PP_VideoProfileDescription_0_1 *v);
const string ToString_PP_VideoProfileDescription_0_1(const PP_VideoProfileDescription_0_1 &v);
void FromJSON_PP_VideoProfileDescription_0_1(JSONIterator& iterator, PP_VideoProfileDescription_0_1 &value);
const string ToString_PP_AudioProfileDescription(const PP_AudioProfileDescription *v);
const string ToString_PP_AudioProfileDescription(const PP_AudioProfileDescription &v);
void FromJSON_PP_AudioProfileDescription(JSONIterator& iterator, PP_AudioProfileDescription &value);
const string ToString_PP_BitstreamBuffer(const PP_BitstreamBuffer *v);
const string ToString_PP_BitstreamBuffer(const PP_BitstreamBuffer &v);
void FromJSON_PP_BitstreamBuffer(JSONIterator& iterator, PP_BitstreamBuffer &value);
const string ToString_PP_AudioBitstreamBuffer(const PP_AudioBitstreamBuffer *v);
const string ToString_PP_AudioBitstreamBuffer(const PP_AudioBitstreamBuffer &v);
void FromJSON_PP_AudioBitstreamBuffer(JSONIterator& iterator, PP_AudioBitstreamBuffer &value);
const string ToString_PP_CompletionCallback_Func(const PP_CompletionCallback_Func &v);
void FromJSON_PP_CompletionCallback_Func(JSONIterator& iterator, PP_CompletionCallback_Func &value);
const string ToString_PP_CompletionCallback_Flag(const PP_CompletionCallback_Flag *v);
const string ToString_PP_CompletionCallback_Flag(const PP_CompletionCallback_Flag &v);
void FromJSON_PP_CompletionCallback_Flag(JSONIterator& iterator, PP_CompletionCallback_Flag &value);
const string ToString_PP_CompletionCallback(const PP_CompletionCallback *v);
const string ToString_PP_CompletionCallback(const PP_CompletionCallback &v);
void FromJSON_PP_CompletionCallback(JSONIterator& iterator, PP_CompletionCallback &value);
const string ToString_PP_DirectoryEntry(const PP_DirectoryEntry *v);
const string ToString_PP_DirectoryEntry(const PP_DirectoryEntry &v);
void FromJSON_PP_DirectoryEntry(JSONIterator& iterator, PP_DirectoryEntry &value);
const string ToString_PP_FileType(const PP_FileType *v);
const string ToString_PP_FileType(const PP_FileType &v);
void FromJSON_PP_FileType(JSONIterator& iterator, PP_FileType &value);
const string ToString_PP_FileSystemType(const PP_FileSystemType *v);
const string ToString_PP_FileSystemType(const PP_FileSystemType &v);
void FromJSON_PP_FileSystemType(JSONIterator& iterator, PP_FileSystemType &value);
const string ToString_PP_FileInfo(const PP_FileInfo *v);
const string ToString_PP_FileInfo(const PP_FileInfo &v);
void FromJSON_PP_FileInfo(JSONIterator& iterator, PP_FileInfo &value);
const string ToString_PP_Graphics3DAttrib(const PP_Graphics3DAttrib *v);
const string ToString_PP_Graphics3DAttrib(const PP_Graphics3DAttrib &v);
void FromJSON_PP_Graphics3DAttrib(JSONIterator& iterator, PP_Graphics3DAttrib &value);
const string ToString_PP_InputEvent_Key(const PP_InputEvent_Key *v);
const string ToString_PP_InputEvent_Key(const PP_InputEvent_Key &v);
void FromJSON_PP_InputEvent_Key(JSONIterator& iterator, PP_InputEvent_Key &value);
const string ToString_PP_InputEvent_Character(const PP_InputEvent_Character *v);
const string ToString_PP_InputEvent_Character(const PP_InputEvent_Character &v);
void FromJSON_PP_InputEvent_Character(JSONIterator& iterator, PP_InputEvent_Character &value);
const string ToString_PP_InputEvent_Mouse(const PP_InputEvent_Mouse *v);
const string ToString_PP_InputEvent_Mouse(const PP_InputEvent_Mouse &v);
void FromJSON_PP_InputEvent_Mouse(JSONIterator& iterator, PP_InputEvent_Mouse &value);
const string ToString_PP_InputEvent_Wheel(const PP_InputEvent_Wheel *v);
const string ToString_PP_InputEvent_Wheel(const PP_InputEvent_Wheel &v);
void FromJSON_PP_InputEvent_Wheel(JSONIterator& iterator, PP_InputEvent_Wheel &value);
const string ToString_PP_Instance(const PP_Instance *v);
const string ToString_PP_Instance(const PP_Instance &v);
void FromJSON_PP_Instance(JSONIterator& iterator, PP_Instance &value);
const string ToString_PP_Module(const PP_Module *v);
const string ToString_PP_Module(const PP_Module &v);
void FromJSON_PP_Module(JSONIterator& iterator, PP_Module &value);
const string ToString_PP_Point(const PP_Point *v);
const string ToString_PP_Point(const PP_Point &v);
void FromJSON_PP_Point(JSONIterator& iterator, PP_Point &value);
const string ToString_PP_FloatPoint(const PP_FloatPoint *v);
const string ToString_PP_FloatPoint(const PP_FloatPoint &v);
void FromJSON_PP_FloatPoint(JSONIterator& iterator, PP_FloatPoint &value);
const string ToString_PP_Rect(const PP_Rect *v);
const string ToString_PP_Rect(const PP_Rect &v);
void FromJSON_PP_Rect(JSONIterator& iterator, PP_Rect &value);
const string ToString_PP_FloatRect(const PP_FloatRect *v);
const string ToString_PP_FloatRect(const PP_FloatRect &v);
void FromJSON_PP_FloatRect(JSONIterator& iterator, PP_FloatRect &value);
const string ToString_PP_Resource(const PP_Resource *v);
const string ToString_PP_Resource(const PP_Resource &v);
void FromJSON_PP_Resource(JSONIterator& iterator, PP_Resource &value);
const string ToString_PP_Size(const PP_Size *v);
const string ToString_PP_Size(const PP_Size &v);
void FromJSON_PP_Size(JSONIterator& iterator, PP_Size &value);
const string ToString_PP_FloatSize(const PP_FloatSize *v);
const string ToString_PP_FloatSize(const PP_FloatSize &v);
void FromJSON_PP_FloatSize(JSONIterator& iterator, PP_FloatSize &value);
const string ToString_PP_Time(const PP_Time *v);
const string ToString_PP_Time(const PP_Time &v);
void FromJSON_PP_Time(JSONIterator& iterator, PP_Time &value);
const string ToString_PP_TimeTicks(const PP_TimeTicks *v);
const string ToString_PP_TimeTicks(const PP_TimeTicks &v);
void FromJSON_PP_TimeTicks(JSONIterator& iterator, PP_TimeTicks &value);
const string ToString_PP_TimeDelta(const PP_TimeDelta *v);
const string ToString_PP_TimeDelta(const PP_TimeDelta &v);
void FromJSON_PP_TimeDelta(JSONIterator& iterator, PP_TimeDelta &value);
const string ToString_PP_TouchPoint(const PP_TouchPoint *v);
const string ToString_PP_TouchPoint(const PP_TouchPoint &v);
void FromJSON_PP_TouchPoint(JSONIterator& iterator, PP_TouchPoint &value);
const string ToString_PP_VarType(const PP_VarType *v);
const string ToString_PP_VarType(const PP_VarType &v);
void FromJSON_PP_VarType(JSONIterator& iterator, PP_VarType &value);
const string ToString_PP_VarValue(const PP_VarValue *v);
const string ToString_PP_VarValue(const PP_VarValue &v);
void FromJSON_PP_VarValue(JSONIterator& iterator, PP_VarValue &value);
const string ToString_PP_Var(const PP_Var *v);
const string ToString_PP_Var(const PP_Var &v);
void FromJSON_PP_Var(JSONIterator& iterator, PP_Var &value);
const string ToString_PPB_GetInterface(const PPB_GetInterface &v);
void FromJSON_PPB_GetInterface(JSONIterator& iterator, PPB_GetInterface &value);
const string ToString_PPB_Audio_Callback(const PPB_Audio_Callback_1_0 &v);
void FromJSON_PPB_Audio_Callback(JSONIterator& iterator, PPB_Audio_Callback_1_0 &value);
const string ToString_PPB_Audio_Callback(const PPB_Audio_Callback &v);
void FromJSON_PPB_Audio_Callback(JSONIterator& iterator, PPB_Audio_Callback &value);
#ifdef INTERPOSE
static PPB_Audio_1_0 *_real_PPB_Audio_1_0;
#endif // INTERPOSE
const string ToString_PPB_Audio(const PPB_Audio_1_0 *v);
#ifdef INTERPOSE
static PPB_Audio_1_1 *_real_PPB_Audio_1_1;
#endif // INTERPOSE
const string ToString_PPB_Audio(const PPB_Audio_1_1 *v);
const string ToString_PP_AudioBuffer_SampleRate(const PP_AudioBuffer_SampleRate *v);
const string ToString_PP_AudioBuffer_SampleRate(const PP_AudioBuffer_SampleRate &v);
void FromJSON_PP_AudioBuffer_SampleRate(JSONIterator& iterator, PP_AudioBuffer_SampleRate &value);
const string ToString_PP_AudioBuffer_SampleSize(const PP_AudioBuffer_SampleSize *v);
const string ToString_PP_AudioBuffer_SampleSize(const PP_AudioBuffer_SampleSize &v);
void FromJSON_PP_AudioBuffer_SampleSize(JSONIterator& iterator, PP_AudioBuffer_SampleSize &value);
#ifdef INTERPOSE
static PPB_AudioBuffer_0_1 *_real_PPB_AudioBuffer_0_1;
#endif // INTERPOSE
const string ToString_PPB_AudioBuffer(const PPB_AudioBuffer_0_1 *v);
const string ToString_PP_AudioSampleRate(const PP_AudioSampleRate *v);
const string ToString_PP_AudioSampleRate(const PP_AudioSampleRate &v);
void FromJSON_PP_AudioSampleRate(JSONIterator& iterator, PP_AudioSampleRate &value);
#ifdef INTERPOSE
static PPB_AudioConfig_1_0 *_real_PPB_AudioConfig_1_0;
#endif // INTERPOSE
const string ToString_PPB_AudioConfig(const PPB_AudioConfig_1_0 *v);
#ifdef INTERPOSE
static PPB_AudioConfig_1_1 *_real_PPB_AudioConfig_1_1;
#endif // INTERPOSE
const string ToString_PPB_AudioConfig(const PPB_AudioConfig_1_1 *v);
#ifdef INTERPOSE
static PPB_AudioEncoder_0_1 *_real_PPB_AudioEncoder_0_1;
#endif // INTERPOSE
const string ToString_PPB_AudioEncoder(const PPB_AudioEncoder_0_1 *v);
#ifdef INTERPOSE
static PPB_Compositor_0_1 *_real_PPB_Compositor_0_1;
#endif // INTERPOSE
const string ToString_PPB_Compositor(const PPB_Compositor_0_1 *v);
const string ToString_PP_BlendMode(const PP_BlendMode *v);
const string ToString_PP_BlendMode(const PP_BlendMode &v);
void FromJSON_PP_BlendMode(JSONIterator& iterator, PP_BlendMode &value);
#ifdef INTERPOSE
static PPB_CompositorLayer_0_1 *_real_PPB_CompositorLayer_0_1;
#endif // INTERPOSE
const string ToString_PPB_CompositorLayer(const PPB_CompositorLayer_0_1 *v);
#ifdef INTERPOSE
static PPB_CompositorLayer_0_2 *_real_PPB_CompositorLayer_0_2;
#endif // INTERPOSE
const string ToString_PPB_CompositorLayer(const PPB_CompositorLayer_0_2 *v);
const string ToString_PP_LogLevel(const PP_LogLevel *v);
const string ToString_PP_LogLevel(const PP_LogLevel &v);
void FromJSON_PP_LogLevel(JSONIterator& iterator, PP_LogLevel &value);
#ifdef INTERPOSE
static PPB_Console_1_0 *_real_PPB_Console_1_0;
#endif // INTERPOSE
const string ToString_PPB_Console(const PPB_Console_1_0 *v);
#ifdef INTERPOSE
static PPB_Core_1_0 *_real_PPB_Core_1_0;
#endif // INTERPOSE
const string ToString_PPB_Core(const PPB_Core_1_0 *v);
const string ToString_PP_FileOpenFlags(const PP_FileOpenFlags *v);
const string ToString_PP_FileOpenFlags(const PP_FileOpenFlags &v);
void FromJSON_PP_FileOpenFlags(JSONIterator& iterator, PP_FileOpenFlags &value);
#ifdef INTERPOSE
static PPB_FileIO_1_0 *_real_PPB_FileIO_1_0;
#endif // INTERPOSE
const string ToString_PPB_FileIO(const PPB_FileIO_1_0 *v);
#ifdef INTERPOSE
static PPB_FileIO_1_1 *_real_PPB_FileIO_1_1;
#endif // INTERPOSE
const string ToString_PPB_FileIO(const PPB_FileIO_1_1 *v);
const string ToString_PP_MakeDirectoryFlags(const PP_MakeDirectoryFlags *v);
const string ToString_PP_MakeDirectoryFlags(const PP_MakeDirectoryFlags &v);
void FromJSON_PP_MakeDirectoryFlags(JSONIterator& iterator, PP_MakeDirectoryFlags &value);
#ifdef INTERPOSE
static PPB_FileRef_1_0 *_real_PPB_FileRef_1_0;
#endif // INTERPOSE
const string ToString_PPB_FileRef(const PPB_FileRef_1_0 *v);
#ifdef INTERPOSE
static PPB_FileRef_1_1 *_real_PPB_FileRef_1_1;
#endif // INTERPOSE
const string ToString_PPB_FileRef(const PPB_FileRef_1_1 *v);
#ifdef INTERPOSE
static PPB_FileRef_1_2 *_real_PPB_FileRef_1_2;
#endif // INTERPOSE
const string ToString_PPB_FileRef(const PPB_FileRef_1_2 *v);
#ifdef INTERPOSE
static PPB_FileSystem_1_0 *_real_PPB_FileSystem_1_0;
#endif // INTERPOSE
const string ToString_PPB_FileSystem(const PPB_FileSystem_1_0 *v);
#ifdef INTERPOSE
static PPB_Fullscreen_1_0 *_real_PPB_Fullscreen_1_0;
#endif // INTERPOSE
const string ToString_PPB_Fullscreen(const PPB_Fullscreen_1_0 *v);
const string ToString_PP_GamepadSampleData(const PP_GamepadSampleData *v);
const string ToString_PP_GamepadSampleData(const PP_GamepadSampleData &v);
void FromJSON_PP_GamepadSampleData(JSONIterator& iterator, PP_GamepadSampleData &value);
const string ToString_PP_GamepadsSampleData(const PP_GamepadsSampleData *v);
const string ToString_PP_GamepadsSampleData(const PP_GamepadsSampleData &v);
void FromJSON_PP_GamepadsSampleData(JSONIterator& iterator, PP_GamepadsSampleData &value);
#ifdef INTERPOSE
static PPB_Gamepad_1_0 *_real_PPB_Gamepad_1_0;
#endif // INTERPOSE
const string ToString_PPB_Gamepad(const PPB_Gamepad_1_0 *v);
#ifdef INTERPOSE
static PPB_Graphics2D_1_0 *_real_PPB_Graphics2D_1_0;
#endif // INTERPOSE
const string ToString_PPB_Graphics2D(const PPB_Graphics2D_1_0 *v);
#ifdef INTERPOSE
static PPB_Graphics2D_1_1 *_real_PPB_Graphics2D_1_1;
#endif // INTERPOSE
const string ToString_PPB_Graphics2D(const PPB_Graphics2D_1_1 *v);
#ifdef INTERPOSE
static PPB_Graphics2D_1_2 *_real_PPB_Graphics2D_1_2;
#endif // INTERPOSE
const string ToString_PPB_Graphics2D(const PPB_Graphics2D_1_2 *v);
#ifdef INTERPOSE
static PPB_Graphics3D_1_0 *_real_PPB_Graphics3D_1_0;
#endif // INTERPOSE
const string ToString_PPB_Graphics3D(const PPB_Graphics3D_1_0 *v);
const string ToString_PP_HostResolver_Flag(const PP_HostResolver_Flag *v);
const string ToString_PP_HostResolver_Flag(const PP_HostResolver_Flag &v);
void FromJSON_PP_HostResolver_Flag(JSONIterator& iterator, PP_HostResolver_Flag &value);
const string ToString_PP_HostResolver_Hint(const PP_HostResolver_Hint *v);
const string ToString_PP_HostResolver_Hint(const PP_HostResolver_Hint &v);
void FromJSON_PP_HostResolver_Hint(JSONIterator& iterator, PP_HostResolver_Hint &value);
#ifdef INTERPOSE
static PPB_HostResolver_1_0 *_real_PPB_HostResolver_1_0;
#endif // INTERPOSE
const string ToString_PPB_HostResolver(const PPB_HostResolver_1_0 *v);
const string ToString_PP_ImageDataFormat(const PP_ImageDataFormat *v);
const string ToString_PP_ImageDataFormat(const PP_ImageDataFormat &v);
void FromJSON_PP_ImageDataFormat(JSONIterator& iterator, PP_ImageDataFormat &value);
const string ToString_PP_ImageDataDesc(const PP_ImageDataDesc *v);
const string ToString_PP_ImageDataDesc(const PP_ImageDataDesc &v);
void FromJSON_PP_ImageDataDesc(JSONIterator& iterator, PP_ImageDataDesc &value);
#ifdef INTERPOSE
static PPB_ImageData_1_0 *_real_PPB_ImageData_1_0;
#endif // INTERPOSE
const string ToString_PPB_ImageData(const PPB_ImageData_1_0 *v);
const string ToString_PP_InputEvent_Type(const PP_InputEvent_Type *v);
const string ToString_PP_InputEvent_Type(const PP_InputEvent_Type &v);
void FromJSON_PP_InputEvent_Type(JSONIterator& iterator, PP_InputEvent_Type &value);
const string ToString_PP_InputEvent_Modifier(const PP_InputEvent_Modifier *v);
const string ToString_PP_InputEvent_Modifier(const PP_InputEvent_Modifier &v);
void FromJSON_PP_InputEvent_Modifier(JSONIterator& iterator, PP_InputEvent_Modifier &value);
const string ToString_PP_InputEvent_MouseButton(const PP_InputEvent_MouseButton *v);
const string ToString_PP_InputEvent_MouseButton(const PP_InputEvent_MouseButton &v);
void FromJSON_PP_InputEvent_MouseButton(JSONIterator& iterator, PP_InputEvent_MouseButton &value);
const string ToString_PP_InputEvent_Class(const PP_InputEvent_Class *v);
const string ToString_PP_InputEvent_Class(const PP_InputEvent_Class &v);
void FromJSON_PP_InputEvent_Class(JSONIterator& iterator, PP_InputEvent_Class &value);
#ifdef INTERPOSE
static PPB_InputEvent_1_0 *_real_PPB_InputEvent_1_0;
#endif // INTERPOSE
const string ToString_PPB_InputEvent(const PPB_InputEvent_1_0 *v);
#ifdef INTERPOSE
static PPB_MouseInputEvent_1_0 *_real_PPB_MouseInputEvent_1_0;
#endif // INTERPOSE
const string ToString_PPB_MouseInputEvent(const PPB_MouseInputEvent_1_0 *v);
#ifdef INTERPOSE
static PPB_MouseInputEvent_1_1 *_real_PPB_MouseInputEvent_1_1;
#endif // INTERPOSE
const string ToString_PPB_MouseInputEvent(const PPB_MouseInputEvent_1_1 *v);
#ifdef INTERPOSE
static PPB_WheelInputEvent_1_0 *_real_PPB_WheelInputEvent_1_0;
#endif // INTERPOSE
const string ToString_PPB_WheelInputEvent(const PPB_WheelInputEvent_1_0 *v);
#ifdef INTERPOSE
static PPB_KeyboardInputEvent_1_0 *_real_PPB_KeyboardInputEvent_1_0;
#endif // INTERPOSE
const string ToString_PPB_KeyboardInputEvent(const PPB_KeyboardInputEvent_1_0 *v);
#ifdef INTERPOSE
static PPB_KeyboardInputEvent_1_2 *_real_PPB_KeyboardInputEvent_1_2;
#endif // INTERPOSE
const string ToString_PPB_KeyboardInputEvent(const PPB_KeyboardInputEvent_1_2 *v);
const string ToString_PP_TouchListType(const PP_TouchListType *v);
const string ToString_PP_TouchListType(const PP_TouchListType &v);
void FromJSON_PP_TouchListType(JSONIterator& iterator, PP_TouchListType &value);
#ifdef INTERPOSE
static PPB_TouchInputEvent_1_0 *_real_PPB_TouchInputEvent_1_0;
#endif // INTERPOSE
const string ToString_PPB_TouchInputEvent(const PPB_TouchInputEvent_1_0 *v);
#ifdef INTERPOSE
static PPB_IMEInputEvent_1_0 *_real_PPB_IMEInputEvent_1_0;
#endif // INTERPOSE
const string ToString_PPB_IMEInputEvent(const PPB_IMEInputEvent_1_0 *v);
#ifdef INTERPOSE
static PPB_Instance_1_0 *_real_PPB_Instance_1_0;
#endif // INTERPOSE
const string ToString_PPB_Instance(const PPB_Instance_1_0 *v);
const string ToString_PP_MediaStreamAudioTrack_Attrib(const PP_MediaStreamAudioTrack_Attrib *v);
const string ToString_PP_MediaStreamAudioTrack_Attrib(const PP_MediaStreamAudioTrack_Attrib &v);
void FromJSON_PP_MediaStreamAudioTrack_Attrib(JSONIterator& iterator, PP_MediaStreamAudioTrack_Attrib &value);
#ifdef INTERPOSE
static PPB_MediaStreamAudioTrack_0_1 *_real_PPB_MediaStreamAudioTrack_0_1;
#endif // INTERPOSE
const string ToString_PPB_MediaStreamAudioTrack(const PPB_MediaStreamAudioTrack_0_1 *v);
const string ToString_PP_MediaStreamVideoTrack_Attrib(const PP_MediaStreamVideoTrack_Attrib *v);
const string ToString_PP_MediaStreamVideoTrack_Attrib(const PP_MediaStreamVideoTrack_Attrib &v);
void FromJSON_PP_MediaStreamVideoTrack_Attrib(JSONIterator& iterator, PP_MediaStreamVideoTrack_Attrib &value);
#ifdef INTERPOSE
static PPB_MediaStreamVideoTrack_0_1 *_real_PPB_MediaStreamVideoTrack_0_1;
#endif // INTERPOSE
const string ToString_PPB_MediaStreamVideoTrack(const PPB_MediaStreamVideoTrack_0_1 *v);
#ifdef INTERPOSE
static PPB_MediaStreamVideoTrack_1_0 *_real_PPB_MediaStreamVideoTrack_1_0;
#endif // INTERPOSE
const string ToString_PPB_MediaStreamVideoTrack(const PPB_MediaStreamVideoTrack_1_0 *v);
#ifdef INTERPOSE
static PPB_MessageLoop_1_0 *_real_PPB_MessageLoop_1_0;
#endif // INTERPOSE
const string ToString_PPB_MessageLoop(const PPB_MessageLoop_1_0 *v);
#ifdef INTERPOSE
static PPB_Messaging_1_0 *_real_PPB_Messaging_1_0;
#endif // INTERPOSE
const string ToString_PPB_Messaging(const PPB_Messaging_1_0 *v);
#ifdef INTERPOSE
static PPB_Messaging_1_2 *_real_PPB_Messaging_1_2;
#endif // INTERPOSE
const string ToString_PPB_Messaging(const PPB_Messaging_1_2 *v);
const string ToString_PP_MouseCursor_Type(const PP_MouseCursor_Type *v);
const string ToString_PP_MouseCursor_Type(const PP_MouseCursor_Type &v);
void FromJSON_PP_MouseCursor_Type(JSONIterator& iterator, PP_MouseCursor_Type &value);
#ifdef INTERPOSE
static PPB_MouseCursor_1_0 *_real_PPB_MouseCursor_1_0;
#endif // INTERPOSE
const string ToString_PPB_MouseCursor(const PPB_MouseCursor_1_0 *v);
#ifdef INTERPOSE
static PPB_MouseLock_1_0 *_real_PPB_MouseLock_1_0;
#endif // INTERPOSE
const string ToString_PPB_MouseLock(const PPB_MouseLock_1_0 *v);
const string ToString_PP_NetAddress_Family(const PP_NetAddress_Family *v);
const string ToString_PP_NetAddress_Family(const PP_NetAddress_Family &v);
void FromJSON_PP_NetAddress_Family(JSONIterator& iterator, PP_NetAddress_Family &value);
const string ToString_PP_NetAddress_IPv4(const PP_NetAddress_IPv4 *v);
const string ToString_PP_NetAddress_IPv4(const PP_NetAddress_IPv4 &v);
void FromJSON_PP_NetAddress_IPv4(JSONIterator& iterator, PP_NetAddress_IPv4 &value);
const string ToString_PP_NetAddress_IPv6(const PP_NetAddress_IPv6 *v);
const string ToString_PP_NetAddress_IPv6(const PP_NetAddress_IPv6 &v);
void FromJSON_PP_NetAddress_IPv6(JSONIterator& iterator, PP_NetAddress_IPv6 &value);
#ifdef INTERPOSE
static PPB_NetAddress_1_0 *_real_PPB_NetAddress_1_0;
#endif // INTERPOSE
const string ToString_PPB_NetAddress(const PPB_NetAddress_1_0 *v);
const string ToString_PP_NetworkList_Type(const PP_NetworkList_Type *v);
const string ToString_PP_NetworkList_Type(const PP_NetworkList_Type &v);
void FromJSON_PP_NetworkList_Type(JSONIterator& iterator, PP_NetworkList_Type &value);
const string ToString_PP_NetworkList_State(const PP_NetworkList_State *v);
const string ToString_PP_NetworkList_State(const PP_NetworkList_State &v);
void FromJSON_PP_NetworkList_State(JSONIterator& iterator, PP_NetworkList_State &value);
#ifdef INTERPOSE
static PPB_NetworkList_1_0 *_real_PPB_NetworkList_1_0;
#endif // INTERPOSE
const string ToString_PPB_NetworkList(const PPB_NetworkList_1_0 *v);
#ifdef INTERPOSE
static PPB_NetworkMonitor_1_0 *_real_PPB_NetworkMonitor_1_0;
#endif // INTERPOSE
const string ToString_PPB_NetworkMonitor(const PPB_NetworkMonitor_1_0 *v);
#ifdef INTERPOSE
static PPB_NetworkProxy_1_0 *_real_PPB_NetworkProxy_1_0;
#endif // INTERPOSE
const string ToString_PPB_NetworkProxy(const PPB_NetworkProxy_1_0 *v);
#ifdef INTERPOSE
static PPB_OpenGLES2_1_0 *_real_PPB_OpenGLES2_1_0;
#endif // INTERPOSE
const string ToString_PPB_OpenGLES2(const PPB_OpenGLES2_1_0 *v);
#ifdef INTERPOSE
static PPB_OpenGLES2InstancedArrays_1_0 *_real_PPB_OpenGLES2InstancedArrays_1_0;
#endif // INTERPOSE
const string ToString_PPB_OpenGLES2InstancedArrays(const PPB_OpenGLES2InstancedArrays_1_0 *v);
#ifdef INTERPOSE
static PPB_OpenGLES2FramebufferBlit_1_0 *_real_PPB_OpenGLES2FramebufferBlit_1_0;
#endif // INTERPOSE
const string ToString_PPB_OpenGLES2FramebufferBlit(const PPB_OpenGLES2FramebufferBlit_1_0 *v);
#ifdef INTERPOSE
static PPB_OpenGLES2FramebufferMultisample_1_0 *_real_PPB_OpenGLES2FramebufferMultisample_1_0;
#endif // INTERPOSE
const string ToString_PPB_OpenGLES2FramebufferMultisample(const PPB_OpenGLES2FramebufferMultisample_1_0 *v);
#ifdef INTERPOSE
static PPB_OpenGLES2ChromiumEnableFeature_1_0 *_real_PPB_OpenGLES2ChromiumEnableFeature_1_0;
#endif // INTERPOSE
const string ToString_PPB_OpenGLES2ChromiumEnableFeature(const PPB_OpenGLES2ChromiumEnableFeature_1_0 *v);
#ifdef INTERPOSE
static PPB_OpenGLES2ChromiumMapSub_1_0 *_real_PPB_OpenGLES2ChromiumMapSub_1_0;
#endif // INTERPOSE
const string ToString_PPB_OpenGLES2ChromiumMapSub(const PPB_OpenGLES2ChromiumMapSub_1_0 *v);
#ifdef INTERPOSE
static PPB_OpenGLES2Query_1_0 *_real_PPB_OpenGLES2Query_1_0;
#endif // INTERPOSE
const string ToString_PPB_OpenGLES2Query(const PPB_OpenGLES2Query_1_0 *v);
#ifdef INTERPOSE
static PPB_OpenGLES2VertexArrayObject_1_0 *_real_PPB_OpenGLES2VertexArrayObject_1_0;
#endif // INTERPOSE
const string ToString_PPB_OpenGLES2VertexArrayObject(const PPB_OpenGLES2VertexArrayObject_1_0 *v);
const string ToString_PP_TCPSocket_Option(const PP_TCPSocket_Option *v);
const string ToString_PP_TCPSocket_Option(const PP_TCPSocket_Option &v);
void FromJSON_PP_TCPSocket_Option(JSONIterator& iterator, PP_TCPSocket_Option &value);
#ifdef INTERPOSE
static PPB_TCPSocket_1_0 *_real_PPB_TCPSocket_1_0;
#endif // INTERPOSE
const string ToString_PPB_TCPSocket(const PPB_TCPSocket_1_0 *v);
#ifdef INTERPOSE
static PPB_TCPSocket_1_1 *_real_PPB_TCPSocket_1_1;
#endif // INTERPOSE
const string ToString_PPB_TCPSocket(const PPB_TCPSocket_1_1 *v);
#ifdef INTERPOSE
static PPB_TCPSocket_1_2 *_real_PPB_TCPSocket_1_2;
#endif // INTERPOSE
const string ToString_PPB_TCPSocket(const PPB_TCPSocket_1_2 *v);
const string ToString_PP_TextInput_Type(const PP_TextInput_Type *v);
const string ToString_PP_TextInput_Type(const PP_TextInput_Type &v);
void FromJSON_PP_TextInput_Type(JSONIterator& iterator, PP_TextInput_Type &value);
#ifdef INTERPOSE
static PPB_TextInputController_1_0 *_real_PPB_TextInputController_1_0;
#endif // INTERPOSE
const string ToString_PPB_TextInputController(const PPB_TextInputController_1_0 *v);
const string ToString_PP_UDPSocket_Option(const PP_UDPSocket_Option *v);
const string ToString_PP_UDPSocket_Option(const PP_UDPSocket_Option &v);
void FromJSON_PP_UDPSocket_Option(JSONIterator& iterator, PP_UDPSocket_Option &value);
#ifdef INTERPOSE
static PPB_UDPSocket_1_0 *_real_PPB_UDPSocket_1_0;
#endif // INTERPOSE
const string ToString_PPB_UDPSocket(const PPB_UDPSocket_1_0 *v);
#ifdef INTERPOSE
static PPB_UDPSocket_1_1 *_real_PPB_UDPSocket_1_1;
#endif // INTERPOSE
const string ToString_PPB_UDPSocket(const PPB_UDPSocket_1_1 *v);
#ifdef INTERPOSE
static PPB_UDPSocket_1_2 *_real_PPB_UDPSocket_1_2;
#endif // INTERPOSE
const string ToString_PPB_UDPSocket(const PPB_UDPSocket_1_2 *v);
#ifdef INTERPOSE
static PPB_URLLoader_1_0 *_real_PPB_URLLoader_1_0;
#endif // INTERPOSE
const string ToString_PPB_URLLoader(const PPB_URLLoader_1_0 *v);
const string ToString_PP_URLRequestProperty(const PP_URLRequestProperty *v);
const string ToString_PP_URLRequestProperty(const PP_URLRequestProperty &v);
void FromJSON_PP_URLRequestProperty(JSONIterator& iterator, PP_URLRequestProperty &value);
#ifdef INTERPOSE
static PPB_URLRequestInfo_1_0 *_real_PPB_URLRequestInfo_1_0;
#endif // INTERPOSE
const string ToString_PPB_URLRequestInfo(const PPB_URLRequestInfo_1_0 *v);
const string ToString_PP_URLResponseProperty(const PP_URLResponseProperty *v);
const string ToString_PP_URLResponseProperty(const PP_URLResponseProperty &v);
void FromJSON_PP_URLResponseProperty(JSONIterator& iterator, PP_URLResponseProperty &value);
#ifdef INTERPOSE
static PPB_URLResponseInfo_1_0 *_real_PPB_URLResponseInfo_1_0;
#endif // INTERPOSE
const string ToString_PPB_URLResponseInfo(const PPB_URLResponseInfo_1_0 *v);
#ifdef INTERPOSE
static PPB_Var_1_0 *_real_PPB_Var_1_0;
#endif // INTERPOSE
const string ToString_PPB_Var(const PPB_Var_1_0 *v);
#ifdef INTERPOSE
static PPB_Var_1_1 *_real_PPB_Var_1_1;
#endif // INTERPOSE
const string ToString_PPB_Var(const PPB_Var_1_1 *v);
#ifdef INTERPOSE
static PPB_Var_1_2 *_real_PPB_Var_1_2;
#endif // INTERPOSE
const string ToString_PPB_Var(const PPB_Var_1_2 *v);
#ifdef INTERPOSE
static PPB_VarArray_1_0 *_real_PPB_VarArray_1_0;
#endif // INTERPOSE
const string ToString_PPB_VarArray(const PPB_VarArray_1_0 *v);
#ifdef INTERPOSE
static PPB_VarArrayBuffer_1_0 *_real_PPB_VarArrayBuffer_1_0;
#endif // INTERPOSE
const string ToString_PPB_VarArrayBuffer(const PPB_VarArrayBuffer_1_0 *v);
#ifdef INTERPOSE
static PPB_VarDictionary_1_0 *_real_PPB_VarDictionary_1_0;
#endif // INTERPOSE
const string ToString_PPB_VarDictionary(const PPB_VarDictionary_1_0 *v);
#ifdef INTERPOSE
static PPB_VideoDecoder_0_1 *_real_PPB_VideoDecoder_0_1;
#endif // INTERPOSE
const string ToString_PPB_VideoDecoder(const PPB_VideoDecoder_0_1 *v);
#ifdef INTERPOSE
static PPB_VideoDecoder_0_2 *_real_PPB_VideoDecoder_0_2;
#endif // INTERPOSE
const string ToString_PPB_VideoDecoder(const PPB_VideoDecoder_0_2 *v);
#ifdef INTERPOSE
static PPB_VideoDecoder_1_0 *_real_PPB_VideoDecoder_1_0;
#endif // INTERPOSE
const string ToString_PPB_VideoDecoder(const PPB_VideoDecoder_1_0 *v);
#ifdef INTERPOSE
static PPB_VideoDecoder_1_1 *_real_PPB_VideoDecoder_1_1;
#endif // INTERPOSE
const string ToString_PPB_VideoDecoder(const PPB_VideoDecoder_1_1 *v);
#ifdef INTERPOSE
static PPB_VideoEncoder_0_1 *_real_PPB_VideoEncoder_0_1;
#endif // INTERPOSE
const string ToString_PPB_VideoEncoder(const PPB_VideoEncoder_0_1 *v);
#ifdef INTERPOSE
static PPB_VideoEncoder_0_2 *_real_PPB_VideoEncoder_0_2;
#endif // INTERPOSE
const string ToString_PPB_VideoEncoder(const PPB_VideoEncoder_0_2 *v);
const string ToString_PP_VideoFrame_Format(const PP_VideoFrame_Format *v);
const string ToString_PP_VideoFrame_Format(const PP_VideoFrame_Format &v);
void FromJSON_PP_VideoFrame_Format(JSONIterator& iterator, PP_VideoFrame_Format &value);
#ifdef INTERPOSE
static PPB_VideoFrame_0_1 *_real_PPB_VideoFrame_0_1;
#endif // INTERPOSE
const string ToString_PPB_VideoFrame(const PPB_VideoFrame_0_1 *v);
#ifdef INTERPOSE
static PPB_View_1_0 *_real_PPB_View_1_0;
#endif // INTERPOSE
const string ToString_PPB_View(const PPB_View_1_0 *v);
#ifdef INTERPOSE
static PPB_View_1_1 *_real_PPB_View_1_1;
#endif // INTERPOSE
const string ToString_PPB_View(const PPB_View_1_1 *v);
#ifdef INTERPOSE
static PPB_View_1_2 *_real_PPB_View_1_2;
#endif // INTERPOSE
const string ToString_PPB_View(const PPB_View_1_2 *v);
#ifdef INTERPOSE
static PPB_VpnProvider_0_1 *_real_PPB_VpnProvider_0_1;
#endif // INTERPOSE
const string ToString_PPB_VpnProvider(const PPB_VpnProvider_0_1 *v);
const string ToString_PP_WebSocketReadyState(const PP_WebSocketReadyState *v);
const string ToString_PP_WebSocketReadyState(const PP_WebSocketReadyState &v);
void FromJSON_PP_WebSocketReadyState(JSONIterator& iterator, PP_WebSocketReadyState &value);
const string ToString_PP_WebSocketCloseCode(const PP_WebSocketCloseCode *v);
const string ToString_PP_WebSocketCloseCode(const PP_WebSocketCloseCode &v);
void FromJSON_PP_WebSocketCloseCode(JSONIterator& iterator, PP_WebSocketCloseCode &value);
#ifdef INTERPOSE
static PPB_WebSocket_1_0 *_real_PPB_WebSocket_1_0;
#endif // INTERPOSE
const string ToString_PPB_WebSocket(const PPB_WebSocket_1_0 *v);
const string ToString_PP_InitializeModule_Func(const PP_InitializeModule_Func &v);
void FromJSON_PP_InitializeModule_Func(JSONIterator& iterator, PP_InitializeModule_Func &value);
const string ToString_PP_ShutdownModule_Func(const PP_ShutdownModule_Func &v);
void FromJSON_PP_ShutdownModule_Func(JSONIterator& iterator, PP_ShutdownModule_Func &value);
const string ToString_PP_GetInterface_Func(const PP_GetInterface_Func &v);
void FromJSON_PP_GetInterface_Func(JSONIterator& iterator, PP_GetInterface_Func &value);
#ifdef INTERPOSE
static PPP_Graphics3D_1_0 *_real_PPP_Graphics3D_1_0;
#endif // INTERPOSE
static char* Call_PPP_Graphics3D(void* _interface, JSONIterator& iterator);
#ifdef INTERPOSE
static PPP_InputEvent_0_1 *_real_PPP_InputEvent_0_1;
#endif // INTERPOSE
static char* Call_PPP_InputEvent(void* _interface, JSONIterator& iterator);
#ifdef INTERPOSE
static PPP_Instance_1_0 *_real_PPP_Instance_1_0;
#endif // INTERPOSE
static char* Call_PPP_Instance_1_0(void* _interface, JSONIterator& iterator);
#ifdef INTERPOSE
static PPP_Instance_1_1 *_real_PPP_Instance_1_1;
#endif // INTERPOSE
static char* Call_PPP_Instance(void* _interface, JSONIterator& iterator);
#ifdef INTERPOSE
static PPP_MessageHandler_0_2 *_real_PPP_MessageHandler_0_2;
#endif // INTERPOSE
static char* Call_PPP_MessageHandler(void* _interface, JSONIterator& iterator);
#ifdef INTERPOSE
static PPP_Messaging_1_0 *_real_PPP_Messaging_1_0;
#endif // INTERPOSE
static char* Call_PPP_Messaging(void* _interface, JSONIterator& iterator);
#ifdef INTERPOSE
static PPP_MouseLock_1_0 *_real_PPP_MouseLock_1_0;
#endif // INTERPOSE
static char* Call_PPP_MouseLock(void* _interface, JSONIterator& iterator);
#ifdef INTERPOSE
static PPB_BrokerTrusted_0_2 *_real_PPB_BrokerTrusted_0_2;
#endif // INTERPOSE
const string ToString_PPB_BrokerTrusted(const PPB_BrokerTrusted_0_2 *v);
#ifdef INTERPOSE
static PPB_BrokerTrusted_0_3 *_real_PPB_BrokerTrusted_0_3;
#endif // INTERPOSE
const string ToString_PPB_BrokerTrusted(const PPB_BrokerTrusted_0_3 *v);
const string ToString_PP_BrowserFont_Trusted_Family(const PP_BrowserFont_Trusted_Family *v);
const string ToString_PP_BrowserFont_Trusted_Family(const PP_BrowserFont_Trusted_Family &v);
void FromJSON_PP_BrowserFont_Trusted_Family(JSONIterator& iterator, PP_BrowserFont_Trusted_Family &value);
const string ToString_PP_BrowserFont_Trusted_Weight(const PP_BrowserFont_Trusted_Weight *v);
const string ToString_PP_BrowserFont_Trusted_Weight(const PP_BrowserFont_Trusted_Weight &v);
void FromJSON_PP_BrowserFont_Trusted_Weight(JSONIterator& iterator, PP_BrowserFont_Trusted_Weight &value);
const string ToString_PP_BrowserFont_Trusted_Description(const PP_BrowserFont_Trusted_Description *v);
const string ToString_PP_BrowserFont_Trusted_Description(const PP_BrowserFont_Trusted_Description &v);
void FromJSON_PP_BrowserFont_Trusted_Description(JSONIterator& iterator, PP_BrowserFont_Trusted_Description &value);
const string ToString_PP_BrowserFont_Trusted_Metrics(const PP_BrowserFont_Trusted_Metrics *v);
const string ToString_PP_BrowserFont_Trusted_Metrics(const PP_BrowserFont_Trusted_Metrics &v);
void FromJSON_PP_BrowserFont_Trusted_Metrics(JSONIterator& iterator, PP_BrowserFont_Trusted_Metrics &value);
const string ToString_PP_BrowserFont_Trusted_TextRun(const PP_BrowserFont_Trusted_TextRun *v);
const string ToString_PP_BrowserFont_Trusted_TextRun(const PP_BrowserFont_Trusted_TextRun &v);
void FromJSON_PP_BrowserFont_Trusted_TextRun(JSONIterator& iterator, PP_BrowserFont_Trusted_TextRun &value);
#ifdef INTERPOSE
static PPB_BrowserFont_Trusted_1_0 *_real_PPB_BrowserFont_Trusted_1_0;
#endif // INTERPOSE
const string ToString_PPB_BrowserFont_Trusted(const PPB_BrowserFont_Trusted_1_0 *v);
const string ToString_PP_CharSet_Trusted_ConversionError(const PP_CharSet_Trusted_ConversionError *v);
const string ToString_PP_CharSet_Trusted_ConversionError(const PP_CharSet_Trusted_ConversionError &v);
void FromJSON_PP_CharSet_Trusted_ConversionError(JSONIterator& iterator, PP_CharSet_Trusted_ConversionError &value);
#ifdef INTERPOSE
static PPB_CharSet_Trusted_1_0 *_real_PPB_CharSet_Trusted_1_0;
#endif // INTERPOSE
const string ToString_PPB_CharSet_Trusted(const PPB_CharSet_Trusted_1_0 *v);
#ifdef INTERPOSE
static PPB_FileChooserTrusted_0_5 *_real_PPB_FileChooserTrusted_0_5;
#endif // INTERPOSE
const string ToString_PPB_FileChooserTrusted(const PPB_FileChooserTrusted_0_5 *v);
#ifdef INTERPOSE
static PPB_FileChooserTrusted_0_6 *_real_PPB_FileChooserTrusted_0_6;
#endif // INTERPOSE
const string ToString_PPB_FileChooserTrusted(const PPB_FileChooserTrusted_0_6 *v);
const string ToString_PP_URLLoaderTrusted_StatusCallback(const PP_URLLoaderTrusted_StatusCallback &v);
void FromJSON_PP_URLLoaderTrusted_StatusCallback(JSONIterator& iterator, PP_URLLoaderTrusted_StatusCallback &value);
#ifdef INTERPOSE
static PPB_URLLoaderTrusted_0_3 *_real_PPB_URLLoaderTrusted_0_3;
#endif // INTERPOSE
const string ToString_PPB_URLLoaderTrusted(const PPB_URLLoaderTrusted_0_3 *v);
const string ToString_PP_CursorType_Dev(const PP_CursorType_Dev *v);
const string ToString_PP_CursorType_Dev(const PP_CursorType_Dev &v);
void FromJSON_PP_CursorType_Dev(JSONIterator& iterator, PP_CursorType_Dev &value);
const string ToString_PP_PrintOrientation_Dev(const PP_PrintOrientation_Dev *v);
const string ToString_PP_PrintOrientation_Dev(const PP_PrintOrientation_Dev &v);
void FromJSON_PP_PrintOrientation_Dev(JSONIterator& iterator, PP_PrintOrientation_Dev &value);
const string ToString_PP_PrintOutputFormat_Dev(const PP_PrintOutputFormat_Dev *v);
const string ToString_PP_PrintOutputFormat_Dev(const PP_PrintOutputFormat_Dev &v);
void FromJSON_PP_PrintOutputFormat_Dev(JSONIterator& iterator, PP_PrintOutputFormat_Dev &value);
const string ToString_PP_PrintScalingOption_Dev(const PP_PrintScalingOption_Dev *v);
const string ToString_PP_PrintScalingOption_Dev(const PP_PrintScalingOption_Dev &v);
void FromJSON_PP_PrintScalingOption_Dev(JSONIterator& iterator, PP_PrintScalingOption_Dev &value);
const string ToString_PP_PrintSettings_Dev(const PP_PrintSettings_Dev *v);
const string ToString_PP_PrintSettings_Dev(const PP_PrintSettings_Dev &v);
void FromJSON_PP_PrintSettings_Dev(JSONIterator& iterator, PP_PrintSettings_Dev &value);
const string ToString_PP_VideoCaptureDeviceInfo_Dev(const PP_VideoCaptureDeviceInfo_Dev *v);
const string ToString_PP_VideoCaptureDeviceInfo_Dev(const PP_VideoCaptureDeviceInfo_Dev &v);
void FromJSON_PP_VideoCaptureDeviceInfo_Dev(JSONIterator& iterator, PP_VideoCaptureDeviceInfo_Dev &value);
const string ToString_PP_VideoCaptureStatus_Dev(const PP_VideoCaptureStatus_Dev *v);
const string ToString_PP_VideoCaptureStatus_Dev(const PP_VideoCaptureStatus_Dev &v);
void FromJSON_PP_VideoCaptureStatus_Dev(JSONIterator& iterator, PP_VideoCaptureStatus_Dev &value);
const string ToString_PP_VideoDecoder_Profile(const PP_VideoDecoder_Profile *v);
const string ToString_PP_VideoDecoder_Profile(const PP_VideoDecoder_Profile &v);
void FromJSON_PP_VideoDecoder_Profile(JSONIterator& iterator, PP_VideoDecoder_Profile &value);
const string ToString_PP_VideoBitstreamBuffer_Dev(const PP_VideoBitstreamBuffer_Dev *v);
const string ToString_PP_VideoBitstreamBuffer_Dev(const PP_VideoBitstreamBuffer_Dev &v);
void FromJSON_PP_VideoBitstreamBuffer_Dev(JSONIterator& iterator, PP_VideoBitstreamBuffer_Dev &value);
const string ToString_PP_PictureBuffer_Dev(const PP_PictureBuffer_Dev *v);
const string ToString_PP_PictureBuffer_Dev(const PP_PictureBuffer_Dev &v);
void FromJSON_PP_PictureBuffer_Dev(JSONIterator& iterator, PP_PictureBuffer_Dev &value);
const string ToString_PP_Picture_Dev(const PP_Picture_Dev *v);
const string ToString_PP_Picture_Dev(const PP_Picture_Dev &v);
void FromJSON_PP_Picture_Dev(JSONIterator& iterator, PP_Picture_Dev &value);
const string ToString_PP_VideoDecodeError_Dev(const PP_VideoDecodeError_Dev *v);
const string ToString_PP_VideoDecodeError_Dev(const PP_VideoDecodeError_Dev &v);
void FromJSON_PP_VideoDecodeError_Dev(JSONIterator& iterator, PP_VideoDecodeError_Dev &value);
const string ToString_PPB_AudioInput_Callback(const PPB_AudioInput_Callback_0_3 &v);
void FromJSON_PPB_AudioInput_Callback(JSONIterator& iterator, PPB_AudioInput_Callback_0_3 &value);
const string ToString_PPB_AudioInput_Callback(const PPB_AudioInput_Callback &v);
void FromJSON_PPB_AudioInput_Callback(JSONIterator& iterator, PPB_AudioInput_Callback &value);
#ifdef INTERPOSE
static PPB_AudioInput_Dev_0_3 *_real_PPB_AudioInput_Dev_0_3;
#endif // INTERPOSE
const string ToString_PPB_AudioInput_Dev(const PPB_AudioInput_Dev_0_3 *v);
#ifdef INTERPOSE
static PPB_AudioInput_Dev_0_4 *_real_PPB_AudioInput_Dev_0_4;
#endif // INTERPOSE
const string ToString_PPB_AudioInput_Dev(const PPB_AudioInput_Dev_0_4 *v);
#ifdef INTERPOSE
static PPB_Buffer_Dev_0_4 *_real_PPB_Buffer_Dev_0_4;
#endif // INTERPOSE
const string ToString_PPB_Buffer_Dev(const PPB_Buffer_Dev_0_4 *v);
const string ToString_PP_CharSet_ConversionError(const PP_CharSet_ConversionError *v);
const string ToString_PP_CharSet_ConversionError(const PP_CharSet_ConversionError &v);
void FromJSON_PP_CharSet_ConversionError(JSONIterator& iterator, PP_CharSet_ConversionError &value);
#ifdef INTERPOSE
static PPB_CharSet_Dev_0_4 *_real_PPB_CharSet_Dev_0_4;
#endif // INTERPOSE
const string ToString_PPB_CharSet_Dev(const PPB_CharSet_Dev_0_4 *v);
#ifdef INTERPOSE
static PPB_Crypto_Dev_0_1 *_real_PPB_Crypto_Dev_0_1;
#endif // INTERPOSE
const string ToString_PPB_Crypto_Dev(const PPB_Crypto_Dev_0_1 *v);
#ifdef INTERPOSE
static PPB_CursorControl_Dev_0_4 *_real_PPB_CursorControl_Dev_0_4;
#endif // INTERPOSE
const string ToString_PPB_CursorControl_Dev(const PPB_CursorControl_Dev_0_4 *v);
const string ToString_PP_MonitorDeviceChangeCallback(const PP_MonitorDeviceChangeCallback &v);
void FromJSON_PP_MonitorDeviceChangeCallback(JSONIterator& iterator, PP_MonitorDeviceChangeCallback &value);
const string ToString_PP_DeviceType_Dev(const PP_DeviceType_Dev *v);
const string ToString_PP_DeviceType_Dev(const PP_DeviceType_Dev &v);
void FromJSON_PP_DeviceType_Dev(JSONIterator& iterator, PP_DeviceType_Dev &value);
#ifdef INTERPOSE
static PPB_DeviceRef_Dev_0_1 *_real_PPB_DeviceRef_Dev_0_1;
#endif // INTERPOSE
const string ToString_PPB_DeviceRef_Dev(const PPB_DeviceRef_Dev_0_1 *v);
const string ToString_PP_FileChooserMode_Dev(const PP_FileChooserMode_Dev *v);
const string ToString_PP_FileChooserMode_Dev(const PP_FileChooserMode_Dev &v);
void FromJSON_PP_FileChooserMode_Dev(JSONIterator& iterator, PP_FileChooserMode_Dev &value);
#ifdef INTERPOSE
static PPB_FileChooser_Dev_0_5 *_real_PPB_FileChooser_Dev_0_5;
#endif // INTERPOSE
const string ToString_PPB_FileChooser_Dev(const PPB_FileChooser_Dev_0_5 *v);
#ifdef INTERPOSE
static PPB_FileChooser_Dev_0_6 *_real_PPB_FileChooser_Dev_0_6;
#endif // INTERPOSE
const string ToString_PPB_FileChooser_Dev(const PPB_FileChooser_Dev_0_6 *v);
const string ToString_PP_FontFamily_Dev(const PP_FontFamily_Dev *v);
const string ToString_PP_FontFamily_Dev(const PP_FontFamily_Dev &v);
void FromJSON_PP_FontFamily_Dev(JSONIterator& iterator, PP_FontFamily_Dev &value);
const string ToString_PP_FontWeight_Dev(const PP_FontWeight_Dev *v);
const string ToString_PP_FontWeight_Dev(const PP_FontWeight_Dev &v);
void FromJSON_PP_FontWeight_Dev(JSONIterator& iterator, PP_FontWeight_Dev &value);
const string ToString_PP_FontDescription_Dev(const PP_FontDescription_Dev *v);
const string ToString_PP_FontDescription_Dev(const PP_FontDescription_Dev &v);
void FromJSON_PP_FontDescription_Dev(JSONIterator& iterator, PP_FontDescription_Dev &value);
const string ToString_PP_FontMetrics_Dev(const PP_FontMetrics_Dev *v);
const string ToString_PP_FontMetrics_Dev(const PP_FontMetrics_Dev &v);
void FromJSON_PP_FontMetrics_Dev(JSONIterator& iterator, PP_FontMetrics_Dev &value);
const string ToString_PP_TextRun_Dev(const PP_TextRun_Dev *v);
const string ToString_PP_TextRun_Dev(const PP_TextRun_Dev &v);
void FromJSON_PP_TextRun_Dev(JSONIterator& iterator, PP_TextRun_Dev &value);
#ifdef INTERPOSE
static PPB_Font_Dev_0_6 *_real_PPB_Font_Dev_0_6;
#endif // INTERPOSE
const string ToString_PPB_Font_Dev(const PPB_Font_Dev_0_6 *v);
#ifdef INTERPOSE
static PPB_IMEInputEvent_Dev_0_1 *_real_PPB_IMEInputEvent_Dev_0_1;
#endif // INTERPOSE
const string ToString_PPB_IMEInputEvent_Dev(const PPB_IMEInputEvent_Dev_0_1 *v);
#ifdef INTERPOSE
static PPB_IMEInputEvent_Dev_0_2 *_real_PPB_IMEInputEvent_Dev_0_2;
#endif // INTERPOSE
const string ToString_PPB_IMEInputEvent_Dev(const PPB_IMEInputEvent_Dev_0_2 *v);
#ifdef INTERPOSE
static PPB_Memory_Dev_0_1 *_real_PPB_Memory_Dev_0_1;
#endif // INTERPOSE
const string ToString_PPB_Memory_Dev(const PPB_Memory_Dev_0_1 *v);
#ifdef INTERPOSE
static PPB_OpenGLES2DrawBuffers_Dev_1_0 *_real_PPB_OpenGLES2DrawBuffers_Dev_1_0;
#endif // INTERPOSE
const string ToString_PPB_OpenGLES2DrawBuffers_Dev(const PPB_OpenGLES2DrawBuffers_Dev_1_0 *v);
#ifdef INTERPOSE
static PPB_Printing_Dev_0_7 *_real_PPB_Printing_Dev_0_7;
#endif // INTERPOSE
const string ToString_PPB_Printing_Dev(const PPB_Printing_Dev_0_7 *v);
const string ToString_PP_TextInput_Type_Dev(const PP_TextInput_Type_Dev *v);
const string ToString_PP_TextInput_Type_Dev(const PP_TextInput_Type_Dev &v);
void FromJSON_PP_TextInput_Type_Dev(JSONIterator& iterator, PP_TextInput_Type_Dev &value);
#ifdef INTERPOSE
static PPB_TextInput_Dev_0_1 *_real_PPB_TextInput_Dev_0_1;
#endif // INTERPOSE
const string ToString_PPB_TextInput_Dev(const PPB_TextInput_Dev_0_1 *v);
#ifdef INTERPOSE
static PPB_TextInput_Dev_0_2 *_real_PPB_TextInput_Dev_0_2;
#endif // INTERPOSE
const string ToString_PPB_TextInput_Dev(const PPB_TextInput_Dev_0_2 *v);
const string ToString_PP_TraceEventTime(const PP_TraceEventTime *v);
const string ToString_PP_TraceEventTime(const PP_TraceEventTime &v);
void FromJSON_PP_TraceEventTime(JSONIterator& iterator, PP_TraceEventTime &value);
#ifdef INTERPOSE
static PPB_Trace_Event_Dev_0_1 *_real_PPB_Trace_Event_Dev_0_1;
#endif // INTERPOSE
const string ToString_PPB_Trace_Event_Dev(const PPB_Trace_Event_Dev_0_1 *v);
#ifdef INTERPOSE
static PPB_Trace_Event_Dev_0_2 *_real_PPB_Trace_Event_Dev_0_2;
#endif // INTERPOSE
const string ToString_PPB_Trace_Event_Dev(const PPB_Trace_Event_Dev_0_2 *v);
const string ToString_PP_TrueTypeFontFamily_Dev(const PP_TrueTypeFontFamily_Dev *v);
const string ToString_PP_TrueTypeFontFamily_Dev(const PP_TrueTypeFontFamily_Dev &v);
void FromJSON_PP_TrueTypeFontFamily_Dev(JSONIterator& iterator, PP_TrueTypeFontFamily_Dev &value);
const string ToString_PP_TrueTypeFontStyle_Dev(const PP_TrueTypeFontStyle_Dev *v);
const string ToString_PP_TrueTypeFontStyle_Dev(const PP_TrueTypeFontStyle_Dev &v);
void FromJSON_PP_TrueTypeFontStyle_Dev(JSONIterator& iterator, PP_TrueTypeFontStyle_Dev &value);
const string ToString_PP_TrueTypeFontWeight_Dev(const PP_TrueTypeFontWeight_Dev *v);
const string ToString_PP_TrueTypeFontWeight_Dev(const PP_TrueTypeFontWeight_Dev &v);
void FromJSON_PP_TrueTypeFontWeight_Dev(JSONIterator& iterator, PP_TrueTypeFontWeight_Dev &value);
const string ToString_PP_TrueTypeFontWidth_Dev(const PP_TrueTypeFontWidth_Dev *v);
const string ToString_PP_TrueTypeFontWidth_Dev(const PP_TrueTypeFontWidth_Dev &v);
void FromJSON_PP_TrueTypeFontWidth_Dev(JSONIterator& iterator, PP_TrueTypeFontWidth_Dev &value);
const string ToString_PP_TrueTypeFontCharset_Dev(const PP_TrueTypeFontCharset_Dev *v);
const string ToString_PP_TrueTypeFontCharset_Dev(const PP_TrueTypeFontCharset_Dev &v);
void FromJSON_PP_TrueTypeFontCharset_Dev(JSONIterator& iterator, PP_TrueTypeFontCharset_Dev &value);
const string ToString_PP_TrueTypeFontDesc_Dev(const PP_TrueTypeFontDesc_Dev *v);
const string ToString_PP_TrueTypeFontDesc_Dev(const PP_TrueTypeFontDesc_Dev &v);
void FromJSON_PP_TrueTypeFontDesc_Dev(JSONIterator& iterator, PP_TrueTypeFontDesc_Dev &value);
#ifdef INTERPOSE
static PPB_TrueTypeFont_Dev_0_1 *_real_PPB_TrueTypeFont_Dev_0_1;
#endif // INTERPOSE
const string ToString_PPB_TrueTypeFont_Dev(const PPB_TrueTypeFont_Dev_0_1 *v);
const string ToString_PP_URLComponent_Dev(const PP_URLComponent_Dev *v);
const string ToString_PP_URLComponent_Dev(const PP_URLComponent_Dev &v);
void FromJSON_PP_URLComponent_Dev(JSONIterator& iterator, PP_URLComponent_Dev &value);
const string ToString_PP_URLComponents_Dev(const PP_URLComponents_Dev *v);
const string ToString_PP_URLComponents_Dev(const PP_URLComponents_Dev &v);
void FromJSON_PP_URLComponents_Dev(JSONIterator& iterator, PP_URLComponents_Dev &value);
#ifdef INTERPOSE
static PPB_URLUtil_Dev_0_6 *_real_PPB_URLUtil_Dev_0_6;
#endif // INTERPOSE
const string ToString_PPB_URLUtil_Dev(const PPB_URLUtil_Dev_0_6 *v);
#ifdef INTERPOSE
static PPB_URLUtil_Dev_0_7 *_real_PPB_URLUtil_Dev_0_7;
#endif // INTERPOSE
const string ToString_PPB_URLUtil_Dev(const PPB_URLUtil_Dev_0_7 *v);
#ifdef INTERPOSE
static PPB_Var_Deprecated_0_3 *_real_PPB_Var_Deprecated_0_3;
#endif // INTERPOSE
const string ToString_PPB_Var_Deprecated(const PPB_Var_Deprecated_0_3 *v);
#ifdef INTERPOSE
static PPB_VideoCapture_Dev_0_3 *_real_PPB_VideoCapture_Dev_0_3;
#endif // INTERPOSE
const string ToString_PPB_VideoCapture_Dev(const PPB_VideoCapture_Dev_0_3 *v);
#ifdef INTERPOSE
static PPB_VideoDecoder_Dev_0_16 *_real_PPB_VideoDecoder_Dev_0_16;
#endif // INTERPOSE
const string ToString_PPB_VideoDecoder_Dev(const PPB_VideoDecoder_Dev_0_16 *v);
#ifdef INTERPOSE
static PPB_View_Dev_0_1 *_real_PPB_View_Dev_0_1;
#endif // INTERPOSE
const string ToString_PPB_View_Dev(const PPB_View_Dev_0_1 *v);
#ifdef INTERPOSE
static PPP_Class_Deprecated_1_0 *_real_PPP_Class_Deprecated_1_0;
#endif // INTERPOSE
static char* Call_PPP_Class_Deprecated(void* _interface, JSONIterator& iterator);
#ifdef INTERPOSE
static PPP_NetworkState_Dev_0_1 *_real_PPP_NetworkState_Dev_0_1;
#endif // INTERPOSE
static char* Call_PPP_NetworkState_Dev(void* _interface, JSONIterator& iterator);
const string ToString_PP_PrintPageNumberRange_Dev(const PP_PrintPageNumberRange_Dev *v);
const string ToString_PP_PrintPageNumberRange_Dev(const PP_PrintPageNumberRange_Dev &v);
void FromJSON_PP_PrintPageNumberRange_Dev(JSONIterator& iterator, PP_PrintPageNumberRange_Dev &value);
#ifdef INTERPOSE
static PPP_Printing_Dev_0_6 *_real_PPP_Printing_Dev_0_6;
#endif // INTERPOSE
static char* Call_PPP_Printing_Dev(void* _interface, JSONIterator& iterator);
#ifdef INTERPOSE
static PPP_TextInput_Dev_0_1 *_real_PPP_TextInput_Dev_0_1;
#endif // INTERPOSE
static char* Call_PPP_TextInput_Dev(void* _interface, JSONIterator& iterator);
#ifdef INTERPOSE
static PPP_VideoCapture_Dev_0_1 *_real_PPP_VideoCapture_Dev_0_1;
#endif // INTERPOSE
static char* Call_PPP_VideoCapture_Dev(void* _interface, JSONIterator& iterator);
#ifdef INTERPOSE
static PPP_VideoDecoder_Dev_0_11 *_real_PPP_VideoDecoder_Dev_0_11;
#endif // INTERPOSE
static char* Call_PPP_VideoDecoder_Dev(void* _interface, JSONIterator& iterator);
const string ToString_PP_DecryptTrackingInfo(const PP_DecryptTrackingInfo *v);
const string ToString_PP_DecryptTrackingInfo(const PP_DecryptTrackingInfo &v);
void FromJSON_PP_DecryptTrackingInfo(JSONIterator& iterator, PP_DecryptTrackingInfo &value);
const string ToString_PP_DecryptSubsampleDescription(const PP_DecryptSubsampleDescription *v);
const string ToString_PP_DecryptSubsampleDescription(const PP_DecryptSubsampleDescription &v);
void FromJSON_PP_DecryptSubsampleDescription(JSONIterator& iterator, PP_DecryptSubsampleDescription &value);
const string ToString_PP_EncryptedBlockInfo(const PP_EncryptedBlockInfo *v);
const string ToString_PP_EncryptedBlockInfo(const PP_EncryptedBlockInfo &v);
void FromJSON_PP_EncryptedBlockInfo(JSONIterator& iterator, PP_EncryptedBlockInfo &value);
const string ToString_PP_DecryptedFrameFormat(const PP_DecryptedFrameFormat *v);
const string ToString_PP_DecryptedFrameFormat(const PP_DecryptedFrameFormat &v);
void FromJSON_PP_DecryptedFrameFormat(JSONIterator& iterator, PP_DecryptedFrameFormat &value);
const string ToString_PP_DecryptedSampleFormat(const PP_DecryptedSampleFormat *v);
const string ToString_PP_DecryptedSampleFormat(const PP_DecryptedSampleFormat &v);
void FromJSON_PP_DecryptedSampleFormat(JSONIterator& iterator, PP_DecryptedSampleFormat &value);
const string ToString_PP_DecryptResult(const PP_DecryptResult *v);
const string ToString_PP_DecryptResult(const PP_DecryptResult &v);
void FromJSON_PP_DecryptResult(JSONIterator& iterator, PP_DecryptResult &value);
const string ToString_PP_DecryptedBlockInfo(const PP_DecryptedBlockInfo *v);
const string ToString_PP_DecryptedBlockInfo(const PP_DecryptedBlockInfo &v);
void FromJSON_PP_DecryptedBlockInfo(JSONIterator& iterator, PP_DecryptedBlockInfo &value);
const string ToString_PP_DecryptedFramePlanes(const PP_DecryptedFramePlanes *v);
const string ToString_PP_DecryptedFramePlanes(const PP_DecryptedFramePlanes &v);
void FromJSON_PP_DecryptedFramePlanes(JSONIterator& iterator, PP_DecryptedFramePlanes &value);
const string ToString_PP_DecryptedFrameInfo(const PP_DecryptedFrameInfo *v);
const string ToString_PP_DecryptedFrameInfo(const PP_DecryptedFrameInfo &v);
void FromJSON_PP_DecryptedFrameInfo(JSONIterator& iterator, PP_DecryptedFrameInfo &value);
const string ToString_PP_DecryptedSampleInfo(const PP_DecryptedSampleInfo *v);
const string ToString_PP_DecryptedSampleInfo(const PP_DecryptedSampleInfo &v);
void FromJSON_PP_DecryptedSampleInfo(JSONIterator& iterator, PP_DecryptedSampleInfo &value);
const string ToString_PP_AudioCodec(const PP_AudioCodec *v);
const string ToString_PP_AudioCodec(const PP_AudioCodec &v);
void FromJSON_PP_AudioCodec(JSONIterator& iterator, PP_AudioCodec &value);
const string ToString_PP_AudioDecoderConfig(const PP_AudioDecoderConfig *v);
const string ToString_PP_AudioDecoderConfig(const PP_AudioDecoderConfig &v);
void FromJSON_PP_AudioDecoderConfig(JSONIterator& iterator, PP_AudioDecoderConfig &value);
const string ToString_PP_VideoCodec(const PP_VideoCodec *v);
const string ToString_PP_VideoCodec(const PP_VideoCodec &v);
void FromJSON_PP_VideoCodec(JSONIterator& iterator, PP_VideoCodec &value);
const string ToString_PP_VideoCodecProfile(const PP_VideoCodecProfile *v);
const string ToString_PP_VideoCodecProfile(const PP_VideoCodecProfile &v);
void FromJSON_PP_VideoCodecProfile(JSONIterator& iterator, PP_VideoCodecProfile &value);
const string ToString_PP_VideoDecoderConfig(const PP_VideoDecoderConfig *v);
const string ToString_PP_VideoDecoderConfig(const PP_VideoDecoderConfig &v);
void FromJSON_PP_VideoDecoderConfig(JSONIterator& iterator, PP_VideoDecoderConfig &value);
const string ToString_PP_DecryptorStreamType(const PP_DecryptorStreamType *v);
const string ToString_PP_DecryptorStreamType(const PP_DecryptorStreamType &v);
void FromJSON_PP_DecryptorStreamType(JSONIterator& iterator, PP_DecryptorStreamType &value);
const string ToString_PP_SessionType(const PP_SessionType *v);
const string ToString_PP_SessionType(const PP_SessionType &v);
void FromJSON_PP_SessionType(JSONIterator& iterator, PP_SessionType &value);
const string ToString_PP_InitDataType(const PP_InitDataType *v);
const string ToString_PP_InitDataType(const PP_InitDataType &v);
void FromJSON_PP_InitDataType(JSONIterator& iterator, PP_InitDataType &value);
const string ToString_PP_CdmExceptionCode(const PP_CdmExceptionCode *v);
const string ToString_PP_CdmExceptionCode(const PP_CdmExceptionCode &v);
void FromJSON_PP_CdmExceptionCode(JSONIterator& iterator, PP_CdmExceptionCode &value);
const string ToString_PP_CdmMessageType(const PP_CdmMessageType *v);
const string ToString_PP_CdmMessageType(const PP_CdmMessageType &v);
void FromJSON_PP_CdmMessageType(JSONIterator& iterator, PP_CdmMessageType &value);
const string ToString_PP_CdmKeyStatus(const PP_CdmKeyStatus *v);
const string ToString_PP_CdmKeyStatus(const PP_CdmKeyStatus &v);
void FromJSON_PP_CdmKeyStatus(JSONIterator& iterator, PP_CdmKeyStatus &value);
const string ToString_PP_KeyInformation(const PP_KeyInformation *v);
const string ToString_PP_KeyInformation(const PP_KeyInformation &v);
void FromJSON_PP_KeyInformation(JSONIterator& iterator, PP_KeyInformation &value);
const string ToString_PP_PrivateFontCharset(const PP_PrivateFontCharset *v);
const string ToString_PP_PrivateFontCharset(const PP_PrivateFontCharset &v);
void FromJSON_PP_PrivateFontCharset(JSONIterator& iterator, PP_PrivateFontCharset &value);
const string ToString_PP_VideoCaptureFormat(const PP_VideoCaptureFormat *v);
const string ToString_PP_VideoCaptureFormat(const PP_VideoCaptureFormat &v);
void FromJSON_PP_VideoCaptureFormat(JSONIterator& iterator, PP_VideoCaptureFormat &value);
const string ToString_PP_VideoFrame_Private(const PP_VideoFrame_Private *v);
const string ToString_PP_VideoFrame_Private(const PP_VideoFrame_Private &v);
void FromJSON_PP_VideoFrame_Private(JSONIterator& iterator, PP_VideoFrame_Private &value);
#ifdef INTERPOSE
static PPB_CameraCapabilities_Private_0_1 *_real_PPB_CameraCapabilities_Private_0_1;
#endif // INTERPOSE
const string ToString_PPB_CameraCapabilities_Private(const PPB_CameraCapabilities_Private_0_1 *v);
#ifdef INTERPOSE
static PPB_CameraDevice_Private_0_1 *_real_PPB_CameraDevice_Private_0_1;
#endif // INTERPOSE
const string ToString_PPB_CameraDevice_Private(const PPB_CameraDevice_Private_0_1 *v);
#ifdef INTERPOSE
static PPB_ContentDecryptor_Private_0_14 *_real_PPB_ContentDecryptor_Private_0_14;
#endif // INTERPOSE
const string ToString_PPB_ContentDecryptor_Private(const PPB_ContentDecryptor_Private_0_14 *v);
#ifdef INTERPOSE
static PPB_DisplayColorProfile_Private_0_1 *_real_PPB_DisplayColorProfile_Private_0_1;
#endif // INTERPOSE
const string ToString_PPB_DisplayColorProfile_Private(const PPB_DisplayColorProfile_Private_0_1 *v);
#ifdef INTERPOSE
static PPB_Ext_CrxFileSystem_Private_0_1 *_real_PPB_Ext_CrxFileSystem_Private_0_1;
#endif // INTERPOSE
const string ToString_PPB_Ext_CrxFileSystem_Private(const PPB_Ext_CrxFileSystem_Private_0_1 *v);
#ifdef INTERPOSE
static PPB_FileIO_Private_0_1 *_real_PPB_FileIO_Private_0_1;
#endif // INTERPOSE
const string ToString_PPB_FileIO_Private(const PPB_FileIO_Private_0_1 *v);
#ifdef INTERPOSE
static PPB_FileRefPrivate_0_1 *_real_PPB_FileRefPrivate_0_1;
#endif // INTERPOSE
const string ToString_PPB_FileRefPrivate(const PPB_FileRefPrivate_0_1 *v);
#ifdef INTERPOSE
static PPB_Find_Private_0_3 *_real_PPB_Find_Private_0_3;
#endif // INTERPOSE
const string ToString_PPB_Find_Private(const PPB_Find_Private_0_3 *v);
const string ToString_PP_FlashLSORestrictions(const PP_FlashLSORestrictions *v);
const string ToString_PP_FlashLSORestrictions(const PP_FlashLSORestrictions &v);
void FromJSON_PP_FlashLSORestrictions(JSONIterator& iterator, PP_FlashLSORestrictions &value);
const string ToString_PP_FlashSetting(const PP_FlashSetting *v);
const string ToString_PP_FlashSetting(const PP_FlashSetting &v);
void FromJSON_PP_FlashSetting(JSONIterator& iterator, PP_FlashSetting &value);
const string ToString_PP_FlashCrashKey(const PP_FlashCrashKey *v);
const string ToString_PP_FlashCrashKey(const PP_FlashCrashKey &v);
void FromJSON_PP_FlashCrashKey(JSONIterator& iterator, PP_FlashCrashKey &value);
#ifdef INTERPOSE
static PPB_Flash_12_4 *_real_PPB_Flash_12_4;
#endif // INTERPOSE
const string ToString_PPB_Flash(const PPB_Flash_12_4 *v);
#ifdef INTERPOSE
static PPB_Flash_12_5 *_real_PPB_Flash_12_5;
#endif // INTERPOSE
const string ToString_PPB_Flash(const PPB_Flash_12_5 *v);
#ifdef INTERPOSE
static PPB_Flash_12_6 *_real_PPB_Flash_12_6;
#endif // INTERPOSE
const string ToString_PPB_Flash(const PPB_Flash_12_6 *v);
#ifdef INTERPOSE
static PPB_Flash_13_0 *_real_PPB_Flash_13_0;
#endif // INTERPOSE
const string ToString_PPB_Flash(const PPB_Flash_13_0 *v);
const string ToString_PP_Flash_Clipboard_Type(const PP_Flash_Clipboard_Type *v);
const string ToString_PP_Flash_Clipboard_Type(const PP_Flash_Clipboard_Type &v);
void FromJSON_PP_Flash_Clipboard_Type(JSONIterator& iterator, PP_Flash_Clipboard_Type &value);
const string ToString_PP_Flash_Clipboard_Format(const PP_Flash_Clipboard_Format *v);
const string ToString_PP_Flash_Clipboard_Format(const PP_Flash_Clipboard_Format &v);
void FromJSON_PP_Flash_Clipboard_Format(JSONIterator& iterator, PP_Flash_Clipboard_Format &value);
#ifdef INTERPOSE
static PPB_Flash_Clipboard_4_0 *_real_PPB_Flash_Clipboard_4_0;
#endif // INTERPOSE
const string ToString_PPB_Flash_Clipboard(const PPB_Flash_Clipboard_4_0 *v);
#ifdef INTERPOSE
static PPB_Flash_Clipboard_5_0 *_real_PPB_Flash_Clipboard_5_0;
#endif // INTERPOSE
const string ToString_PPB_Flash_Clipboard(const PPB_Flash_Clipboard_5_0 *v);
#ifdef INTERPOSE
static PPB_Flash_Clipboard_5_1 *_real_PPB_Flash_Clipboard_5_1;
#endif // INTERPOSE
const string ToString_PPB_Flash_Clipboard(const PPB_Flash_Clipboard_5_1 *v);
#ifdef INTERPOSE
static PPB_Flash_DeviceID_1_0 *_real_PPB_Flash_DeviceID_1_0;
#endif // INTERPOSE
const string ToString_PPB_Flash_DeviceID(const PPB_Flash_DeviceID_1_0 *v);
#ifdef INTERPOSE
static PPB_Flash_DRM_1_0 *_real_PPB_Flash_DRM_1_0;
#endif // INTERPOSE
const string ToString_PPB_Flash_DRM(const PPB_Flash_DRM_1_0 *v);
#ifdef INTERPOSE
static PPB_Flash_DRM_1_1 *_real_PPB_Flash_DRM_1_1;
#endif // INTERPOSE
const string ToString_PPB_Flash_DRM(const PPB_Flash_DRM_1_1 *v);
const string ToString_PP_DirEntry_Dev(const PP_DirEntry_Dev *v);
const string ToString_PP_DirEntry_Dev(const PP_DirEntry_Dev &v);
void FromJSON_PP_DirEntry_Dev(JSONIterator& iterator, PP_DirEntry_Dev &value);
const string ToString_PP_DirContents_Dev(const PP_DirContents_Dev *v);
const string ToString_PP_DirContents_Dev(const PP_DirContents_Dev &v);
void FromJSON_PP_DirContents_Dev(JSONIterator& iterator, PP_DirContents_Dev &value);
#ifdef INTERPOSE
static PPB_Flash_File_ModuleLocal_3_0 *_real_PPB_Flash_File_ModuleLocal_3_0;
#endif // INTERPOSE
const string ToString_PPB_Flash_File_ModuleLocal(const PPB_Flash_File_ModuleLocal_3_0 *v);
#ifdef INTERPOSE
static PPB_Flash_File_FileRef_2_0 *_real_PPB_Flash_File_FileRef_2_0;
#endif // INTERPOSE
const string ToString_PPB_Flash_File_FileRef(const PPB_Flash_File_FileRef_2_0 *v);
#ifdef INTERPOSE
static PPB_Flash_FontFile_0_1 *_real_PPB_Flash_FontFile_0_1;
#endif // INTERPOSE
const string ToString_PPB_Flash_FontFile(const PPB_Flash_FontFile_0_1 *v);
#ifdef INTERPOSE
static PPB_Flash_FontFile_0_2 *_real_PPB_Flash_FontFile_0_2;
#endif // INTERPOSE
const string ToString_PPB_Flash_FontFile(const PPB_Flash_FontFile_0_2 *v);
#ifdef INTERPOSE
static PPB_FlashFullscreen_0_1 *_real_PPB_FlashFullscreen_0_1;
#endif // INTERPOSE
const string ToString_PPB_FlashFullscreen(const PPB_FlashFullscreen_0_1 *v);
#ifdef INTERPOSE
static PPB_FlashFullscreen_1_0 *_real_PPB_FlashFullscreen_1_0;
#endif // INTERPOSE
const string ToString_PPB_FlashFullscreen(const PPB_FlashFullscreen_1_0 *v);
const string ToString_PP_Flash_MenuItem_Type(const PP_Flash_MenuItem_Type *v);
const string ToString_PP_Flash_MenuItem_Type(const PP_Flash_MenuItem_Type &v);
void FromJSON_PP_Flash_MenuItem_Type(JSONIterator& iterator, PP_Flash_MenuItem_Type &value);
const string ToString_PP_Flash_MenuItem(const PP_Flash_MenuItem *v);
const string ToString_PP_Flash_MenuItem(const PP_Flash_MenuItem &v);
void FromJSON_PP_Flash_MenuItem(JSONIterator& iterator, PP_Flash_MenuItem &value);
const string ToString_PP_Flash_Menu(const PP_Flash_Menu *v);
const string ToString_PP_Flash_Menu(const PP_Flash_Menu &v);
void FromJSON_PP_Flash_Menu(JSONIterator& iterator, PP_Flash_Menu &value);
#ifdef INTERPOSE
static PPB_Flash_Menu_0_2 *_real_PPB_Flash_Menu_0_2;
#endif // INTERPOSE
const string ToString_PPB_Flash_Menu(const PPB_Flash_Menu_0_2 *v);
#ifdef INTERPOSE
static PPB_Flash_MessageLoop_0_1 *_real_PPB_Flash_MessageLoop_0_1;
#endif // INTERPOSE
const string ToString_PPB_Flash_MessageLoop(const PPB_Flash_MessageLoop_0_1 *v);
#ifdef INTERPOSE
static PPB_Flash_Print_1_0 *_real_PPB_Flash_Print_1_0;
#endif // INTERPOSE
const string ToString_PPB_Flash_Print(const PPB_Flash_Print_1_0 *v);
const string ToString_PP_HostResolver_Private_Flags(const PP_HostResolver_Private_Flags *v);
const string ToString_PP_HostResolver_Private_Flags(const PP_HostResolver_Private_Flags &v);
void FromJSON_PP_HostResolver_Private_Flags(JSONIterator& iterator, PP_HostResolver_Private_Flags &value);
const string ToString_PP_HostResolver_Private_Hint(const PP_HostResolver_Private_Hint *v);
const string ToString_PP_HostResolver_Private_Hint(const PP_HostResolver_Private_Hint &v);
void FromJSON_PP_HostResolver_Private_Hint(JSONIterator& iterator, PP_HostResolver_Private_Hint &value);
#ifdef INTERPOSE
static PPB_HostResolver_Private_0_1 *_real_PPB_HostResolver_Private_0_1;
#endif // INTERPOSE
const string ToString_PPB_HostResolver_Private(const PPB_HostResolver_Private_0_1 *v);
const string ToString_PP_ExternalPluginResult(const PP_ExternalPluginResult *v);
const string ToString_PP_ExternalPluginResult(const PP_ExternalPluginResult &v);
void FromJSON_PP_ExternalPluginResult(JSONIterator& iterator, PP_ExternalPluginResult &value);
#ifdef INTERPOSE
static PPB_Instance_Private_0_1 *_real_PPB_Instance_Private_0_1;
#endif // INTERPOSE
const string ToString_PPB_Instance_Private(const PPB_Instance_Private_0_1 *v);
const string ToString_PP_IsolatedFileSystemType_Private(const PP_IsolatedFileSystemType_Private *v);
const string ToString_PP_IsolatedFileSystemType_Private(const PP_IsolatedFileSystemType_Private &v);
void FromJSON_PP_IsolatedFileSystemType_Private(JSONIterator& iterator, PP_IsolatedFileSystemType_Private &value);
#ifdef INTERPOSE
static PPB_IsolatedFileSystem_Private_0_2 *_real_PPB_IsolatedFileSystem_Private_0_2;
#endif // INTERPOSE
const string ToString_PPB_IsolatedFileSystem_Private(const PPB_IsolatedFileSystem_Private_0_2 *v);
const string ToString_PP_NetAddressFamily_Private(const PP_NetAddressFamily_Private *v);
const string ToString_PP_NetAddressFamily_Private(const PP_NetAddressFamily_Private &v);
void FromJSON_PP_NetAddressFamily_Private(JSONIterator& iterator, PP_NetAddressFamily_Private &value);
const string ToString_PP_NetAddress_Private(const PP_NetAddress_Private *v);
const string ToString_PP_NetAddress_Private(const PP_NetAddress_Private &v);
void FromJSON_PP_NetAddress_Private(JSONIterator& iterator, PP_NetAddress_Private &value);
#ifdef INTERPOSE
static PPB_NetAddress_Private_0_1 *_real_PPB_NetAddress_Private_0_1;
#endif // INTERPOSE
const string ToString_PPB_NetAddress_Private(const PPB_NetAddress_Private_0_1 *v);
#ifdef INTERPOSE
static PPB_NetAddress_Private_1_0 *_real_PPB_NetAddress_Private_1_0;
#endif // INTERPOSE
const string ToString_PPB_NetAddress_Private(const PPB_NetAddress_Private_1_0 *v);
#ifdef INTERPOSE
static PPB_NetAddress_Private_1_1 *_real_PPB_NetAddress_Private_1_1;
#endif // INTERPOSE
const string ToString_PPB_NetAddress_Private(const PPB_NetAddress_Private_1_1 *v);
const string ToString_PP_OutputProtectionMethod_Private(const PP_OutputProtectionMethod_Private *v);
const string ToString_PP_OutputProtectionMethod_Private(const PP_OutputProtectionMethod_Private &v);
void FromJSON_PP_OutputProtectionMethod_Private(JSONIterator& iterator, PP_OutputProtectionMethod_Private &value);
const string ToString_PP_OutputProtectionLinkType_Private(const PP_OutputProtectionLinkType_Private *v);
const string ToString_PP_OutputProtectionLinkType_Private(const PP_OutputProtectionLinkType_Private &v);
void FromJSON_PP_OutputProtectionLinkType_Private(JSONIterator& iterator, PP_OutputProtectionLinkType_Private &value);
#ifdef INTERPOSE
static PPB_OutputProtection_Private_0_1 *_real_PPB_OutputProtection_Private_0_1;
#endif // INTERPOSE
const string ToString_PPB_OutputProtection_Private(const PPB_OutputProtection_Private_0_1 *v);
const string ToString_PP_PDFFeature(const PP_PDFFeature *v);
const string ToString_PP_PDFFeature(const PP_PDFFeature &v);
void FromJSON_PP_PDFFeature(JSONIterator& iterator, PP_PDFFeature &value);
const string ToString_PP_PrivateFontFileDescription(const PP_PrivateFontFileDescription *v);
const string ToString_PP_PrivateFontFileDescription(const PP_PrivateFontFileDescription &v);
void FromJSON_PP_PrivateFontFileDescription(JSONIterator& iterator, PP_PrivateFontFileDescription &value);
const string ToString_PP_PrivateFindResult(const PP_PrivateFindResult *v);
const string ToString_PP_PrivateFindResult(const PP_PrivateFindResult &v);
void FromJSON_PP_PrivateFindResult(JSONIterator& iterator, PP_PrivateFindResult &value);
const string ToString_PP_PrivateAccessibilityViewportInfo(const PP_PrivateAccessibilityViewportInfo *v);
const string ToString_PP_PrivateAccessibilityViewportInfo(const PP_PrivateAccessibilityViewportInfo &v);
void FromJSON_PP_PrivateAccessibilityViewportInfo(JSONIterator& iterator, PP_PrivateAccessibilityViewportInfo &value);
const string ToString_PP_PrivateAccessibilityDocInfo(const PP_PrivateAccessibilityDocInfo *v);
const string ToString_PP_PrivateAccessibilityDocInfo(const PP_PrivateAccessibilityDocInfo &v);
void FromJSON_PP_PrivateAccessibilityDocInfo(JSONIterator& iterator, PP_PrivateAccessibilityDocInfo &value);
const string ToString_PP_PrivateDirection(const PP_PrivateDirection *v);
const string ToString_PP_PrivateDirection(const PP_PrivateDirection &v);
void FromJSON_PP_PrivateDirection(JSONIterator& iterator, PP_PrivateDirection &value);
const string ToString_PP_PrivateAccessibilityPageInfo(const PP_PrivateAccessibilityPageInfo *v);
const string ToString_PP_PrivateAccessibilityPageInfo(const PP_PrivateAccessibilityPageInfo &v);
void FromJSON_PP_PrivateAccessibilityPageInfo(JSONIterator& iterator, PP_PrivateAccessibilityPageInfo &value);
const string ToString_PP_PrivateAccessibilityTextRunInfo(const PP_PrivateAccessibilityTextRunInfo *v);
const string ToString_PP_PrivateAccessibilityTextRunInfo(const PP_PrivateAccessibilityTextRunInfo &v);
void FromJSON_PP_PrivateAccessibilityTextRunInfo(JSONIterator& iterator, PP_PrivateAccessibilityTextRunInfo &value);
const string ToString_PP_PrivateAccessibilityCharInfo(const PP_PrivateAccessibilityCharInfo *v);
const string ToString_PP_PrivateAccessibilityCharInfo(const PP_PrivateAccessibilityCharInfo &v);
void FromJSON_PP_PrivateAccessibilityCharInfo(JSONIterator& iterator, PP_PrivateAccessibilityCharInfo &value);
#ifdef INTERPOSE
static PPB_PDF_0_1 *_real_PPB_PDF_0_1;
#endif // INTERPOSE
const string ToString_PPB_PDF(const PPB_PDF_0_1 *v);
#ifdef INTERPOSE
static PPB_PlatformVerification_Private_0_2 *_real_PPB_PlatformVerification_Private_0_2;
#endif // INTERPOSE
const string ToString_PPB_PlatformVerification_Private(const PPB_PlatformVerification_Private_0_2 *v);
#ifdef INTERPOSE
static PPB_TCPServerSocket_Private_0_1 *_real_PPB_TCPServerSocket_Private_0_1;
#endif // INTERPOSE
const string ToString_PPB_TCPServerSocket_Private(const PPB_TCPServerSocket_Private_0_1 *v);
#ifdef INTERPOSE
static PPB_TCPServerSocket_Private_0_2 *_real_PPB_TCPServerSocket_Private_0_2;
#endif // INTERPOSE
const string ToString_PPB_TCPServerSocket_Private(const PPB_TCPServerSocket_Private_0_2 *v);
const string ToString_PP_TCPSocketOption_Private(const PP_TCPSocketOption_Private *v);
const string ToString_PP_TCPSocketOption_Private(const PP_TCPSocketOption_Private &v);
void FromJSON_PP_TCPSocketOption_Private(JSONIterator& iterator, PP_TCPSocketOption_Private &value);
#ifdef INTERPOSE
static PPB_TCPSocket_Private_0_3 *_real_PPB_TCPSocket_Private_0_3;
#endif // INTERPOSE
const string ToString_PPB_TCPSocket_Private(const PPB_TCPSocket_Private_0_3 *v);
#ifdef INTERPOSE
static PPB_TCPSocket_Private_0_4 *_real_PPB_TCPSocket_Private_0_4;
#endif // INTERPOSE
const string ToString_PPB_TCPSocket_Private(const PPB_TCPSocket_Private_0_4 *v);
#ifdef INTERPOSE
static PPB_TCPSocket_Private_0_5 *_real_PPB_TCPSocket_Private_0_5;
#endif // INTERPOSE
const string ToString_PPB_TCPSocket_Private(const PPB_TCPSocket_Private_0_5 *v);
#ifdef INTERPOSE
static PPB_Testing_Private_1_0 *_real_PPB_Testing_Private_1_0;
#endif // INTERPOSE
const string ToString_PPB_Testing_Private(const PPB_Testing_Private_1_0 *v);
const string ToString_PP_UDPSocketFeature_Private(const PP_UDPSocketFeature_Private *v);
const string ToString_PP_UDPSocketFeature_Private(const PP_UDPSocketFeature_Private &v);
void FromJSON_PP_UDPSocketFeature_Private(JSONIterator& iterator, PP_UDPSocketFeature_Private &value);
#ifdef INTERPOSE
static PPB_UDPSocket_Private_0_2 *_real_PPB_UDPSocket_Private_0_2;
#endif // INTERPOSE
const string ToString_PPB_UDPSocket_Private(const PPB_UDPSocket_Private_0_2 *v);
#ifdef INTERPOSE
static PPB_UDPSocket_Private_0_3 *_real_PPB_UDPSocket_Private_0_3;
#endif // INTERPOSE
const string ToString_PPB_UDPSocket_Private(const PPB_UDPSocket_Private_0_3 *v);
#ifdef INTERPOSE
static PPB_UDPSocket_Private_0_4 *_real_PPB_UDPSocket_Private_0_4;
#endif // INTERPOSE
const string ToString_PPB_UDPSocket_Private(const PPB_UDPSocket_Private_0_4 *v);
#ifdef INTERPOSE
static PPB_UMA_Private_0_3 *_real_PPB_UMA_Private_0_3;
#endif // INTERPOSE
const string ToString_PPB_UMA_Private(const PPB_UMA_Private_0_3 *v);
#ifdef INTERPOSE
static PPB_VideoDestination_Private_0_1 *_real_PPB_VideoDestination_Private_0_1;
#endif // INTERPOSE
const string ToString_PPB_VideoDestination_Private(const PPB_VideoDestination_Private_0_1 *v);
#ifdef INTERPOSE
static PPB_VideoSource_Private_0_1 *_real_PPB_VideoSource_Private_0_1;
#endif // INTERPOSE
const string ToString_PPB_VideoSource_Private(const PPB_VideoSource_Private_0_1 *v);
const string ToString_PP_X509Certificate_Private_Field(const PP_X509Certificate_Private_Field *v);
const string ToString_PP_X509Certificate_Private_Field(const PP_X509Certificate_Private_Field &v);
void FromJSON_PP_X509Certificate_Private_Field(JSONIterator& iterator, PP_X509Certificate_Private_Field &value);
const string ToString_PPB_X509Certificate_Private_Version(const PPB_X509Certificate_Private_Version *v);
const string ToString_PPB_X509Certificate_Private_Version(const PPB_X509Certificate_Private_Version &v);
void FromJSON_PPB_X509Certificate_Private_Version(JSONIterator& iterator, PPB_X509Certificate_Private_Version &value);
#ifdef INTERPOSE
static PPB_X509Certificate_Private_0_1 *_real_PPB_X509Certificate_Private_0_1;
#endif // INTERPOSE
const string ToString_PPB_X509Certificate_Private(const PPB_X509Certificate_Private_0_1 *v);
#ifdef INTERPOSE
static PPP_ContentDecryptor_Private_0_16 *_real_PPP_ContentDecryptor_Private_0_16;
#endif // INTERPOSE
static char* Call_PPP_ContentDecryptor_Private(void* _interface, JSONIterator& iterator);
#ifdef INTERPOSE
static PPP_Find_Private_0_3 *_real_PPP_Find_Private_0_3;
#endif // INTERPOSE
static char* Call_PPP_Find_Private(void* _interface, JSONIterator& iterator);
const string ToString_PP_Flash_BrowserOperations_SettingType(const PP_Flash_BrowserOperations_SettingType *v);
const string ToString_PP_Flash_BrowserOperations_SettingType(const PP_Flash_BrowserOperations_SettingType &v);
void FromJSON_PP_Flash_BrowserOperations_SettingType(JSONIterator& iterator, PP_Flash_BrowserOperations_SettingType &value);
const string ToString_PP_Flash_BrowserOperations_Permission(const PP_Flash_BrowserOperations_Permission *v);
const string ToString_PP_Flash_BrowserOperations_Permission(const PP_Flash_BrowserOperations_Permission &v);
void FromJSON_PP_Flash_BrowserOperations_Permission(JSONIterator& iterator, PP_Flash_BrowserOperations_Permission &value);
const string ToString_PP_Flash_BrowserOperations_SiteSetting(const PP_Flash_BrowserOperations_SiteSetting *v);
const string ToString_PP_Flash_BrowserOperations_SiteSetting(const PP_Flash_BrowserOperations_SiteSetting &v);
void FromJSON_PP_Flash_BrowserOperations_SiteSetting(JSONIterator& iterator, PP_Flash_BrowserOperations_SiteSetting &value);
const string ToString_PPB_Flash_BrowserOperations_GetSettingsCallback(const PPB_Flash_BrowserOperations_GetSettingsCallback &v);
void FromJSON_PPB_Flash_BrowserOperations_GetSettingsCallback(JSONIterator& iterator, PPB_Flash_BrowserOperations_GetSettingsCallback &value);
#ifdef INTERPOSE
static PPP_Flash_BrowserOperations_1_0 *_real_PPP_Flash_BrowserOperations_1_0;
#endif // INTERPOSE
static char* Call_PPP_Flash_BrowserOperations_1_0(void* _interface, JSONIterator& iterator);
#ifdef INTERPOSE
static PPP_Flash_BrowserOperations_1_2 *_real_PPP_Flash_BrowserOperations_1_2;
#endif // INTERPOSE
static char* Call_PPP_Flash_BrowserOperations_1_2(void* _interface, JSONIterator& iterator);
#ifdef INTERPOSE
static PPP_Flash_BrowserOperations_1_3 *_real_PPP_Flash_BrowserOperations_1_3;
#endif // INTERPOSE
static char* Call_PPP_Flash_BrowserOperations(void* _interface, JSONIterator& iterator);
#ifdef INTERPOSE
static PPP_Instance_Private_0_1 *_real_PPP_Instance_Private_0_1;
#endif // INTERPOSE
static char* Call_PPP_Instance_Private(void* _interface, JSONIterator& iterator);
#ifdef INTERPOSE
static PPP_PexeStreamHandler_1_0 *_real_PPP_PexeStreamHandler_1_0;
#endif // INTERPOSE
static char* Call_PPP_PexeStreamHandler(void* _interface, JSONIterator& iterator);
const string ToString_PP_ArrayOutput_GetDataBuffer(const PP_ArrayOutput_GetDataBuffer &v) {
  return PointerToString(v);
}
void FromJSON_PP_ArrayOutput_GetDataBuffer(JSONIterator& iterator, PP_ArrayOutput_GetDataBuffer &value) {
  PointerValueFromJSON(iterator, value);
}
const string ToString_PP_ArrayOutput(const PP_ArrayOutput *v) {
  if (!v) {
    return "null";
  }
  return ToString_PP_ArrayOutput(*v);
}
const string ToString_PP_ArrayOutput(const PP_ArrayOutput &v) {
  stringstream x;
  BeginProps(x);
  AddProp(x, "GetDataBuffer", ToString_PP_ArrayOutput_GetDataBuffer(v.GetDataBuffer));
  AddProp(x, "user_data", ToString_mem_t(v.user_data));
  EndProps(x);
  return x.str();
}
void FromJSON_PP_ArrayOutput(JSONIterator& iterator, PP_ArrayOutput &value) {
  const JSON::Token& current = iterator.getCurrentAndGotoNext();
  if (current.isPrimitive() && !current.value().compare("null")) {
    return;
  }
  if (!current.isObject()) {
    Fail("Expected object!", "");
  }
  iterator.skip();
  FromJSON_PP_ArrayOutput_GetDataBuffer(iterator, value.GetDataBuffer);
  iterator.skip();
  FromJSON_mem_t(iterator, value.user_data);
}
const string ToString_PP_Bool(const PP_Bool *v) {
  switch (*v) {
    case 0:
      return "\"PP_FALSE\"";
    case 1:
      return "\"PP_TRUE\"";
    default:
      return "\"???\"";
  }
}
const string ToString_PP_Bool(const PP_Bool &v) {
  return ToString_PP_Bool(&v);
}
void FromJSON_PP_Bool(JSONIterator& iterator, PP_Bool &value) {
  long int v;
  FromJSON_int(iterator, v);
  value = PP_Bool(v);
}
const string ToString_PP_VideoProfile(const PP_VideoProfile *v) {
  switch (*v) {
    case 0:
      return "\"PP_VIDEOPROFILE_H264BASELINE\"";
    case 1:
      return "\"PP_VIDEOPROFILE_H264MAIN\"";
    case 2:
      return "\"PP_VIDEOPROFILE_H264EXTENDED\"";
    case 3:
      return "\"PP_VIDEOPROFILE_H264HIGH\"";
    case 4:
      return "\"PP_VIDEOPROFILE_H264HIGH10PROFILE\"";
    case 5:
      return "\"PP_VIDEOPROFILE_H264HIGH422PROFILE\"";
    case 6:
      return "\"PP_VIDEOPROFILE_H264HIGH444PREDICTIVEPROFILE\"";
    case 7:
      return "\"PP_VIDEOPROFILE_H264SCALABLEBASELINE\"";
    case 8:
      return "\"PP_VIDEOPROFILE_H264SCALABLEHIGH\"";
    case 9:
      return "\"PP_VIDEOPROFILE_H264STEREOHIGH\"";
    case 10:
      return "\"PP_VIDEOPROFILE_H264MULTIVIEWHIGH\"";
    case 11:
      return "\"PP_VIDEOPROFILE_VP8_ANY\"";
    case 12:
      return "\"PP_VIDEOPROFILE_VP9_ANY\"";
    default:
      return "\"???\"";
  }
}
const string ToString_PP_VideoProfile(const PP_VideoProfile &v) {
  return ToString_PP_VideoProfile(&v);
}
void FromJSON_PP_VideoProfile(JSONIterator& iterator, PP_VideoProfile &value) {
  long int v;
  FromJSON_int(iterator, v);
  value = PP_VideoProfile(v);
}
const string ToString_PP_AudioProfile(const PP_AudioProfile *v) {
  switch (*v) {
    case 0:
      return "\"PP_AUDIOPROFILE_OPUS\"";
    default:
      return "\"???\"";
  }
}
const string ToString_PP_AudioProfile(const PP_AudioProfile &v) {
  return ToString_PP_AudioProfile(&v);
}
void FromJSON_PP_AudioProfile(JSONIterator& iterator, PP_AudioProfile &value) {
  long int v;
  FromJSON_int(iterator, v);
  value = PP_AudioProfile(v);
}
const string ToString_PP_HardwareAcceleration(const PP_HardwareAcceleration *v) {
  switch (*v) {
    case 0:
      return "\"PP_HARDWAREACCELERATION_ONLY\"";
    case 1:
      return "\"PP_HARDWAREACCELERATION_WITHFALLBACK\"";
    case 2:
      return "\"PP_HARDWAREACCELERATION_NONE\"";
    default:
      return "\"???\"";
  }
}
const string ToString_PP_HardwareAcceleration(const PP_HardwareAcceleration &v) {
  return ToString_PP_HardwareAcceleration(&v);
}
void FromJSON_PP_HardwareAcceleration(JSONIterator& iterator, PP_HardwareAcceleration &value) {
  long int v;
  FromJSON_int(iterator, v);
  value = PP_HardwareAcceleration(v);
}
const string ToString_PP_VideoPicture(const PP_VideoPicture *v) {
  if (!v) {
    return "null";
  }
  return ToString_PP_VideoPicture(*v);
}
const string ToString_PP_VideoPicture(const PP_VideoPicture &v) {
  stringstream x;
  BeginProps(x);
  AddProp(x, "decode_id", ToString_uint32_t(v.decode_id));
  AddProp(x, "texture_id", ToString_uint32_t(v.texture_id));
  AddProp(x, "texture_target", ToString_uint32_t(v.texture_target));
  AddProp(x, "texture_size", ToString_PP_Size(v.texture_size));
  AddProp(x, "visible_rect", ToString_PP_Rect(v.visible_rect));
  EndProps(x);
  return x.str();
}
void FromJSON_PP_VideoPicture(JSONIterator& iterator, PP_VideoPicture &value) {
  const JSON::Token& current = iterator.getCurrentAndGotoNext();
  if (current.isPrimitive() && !current.value().compare("null")) {
    return;
  }
  if (!current.isObject()) {
    Fail("Expected object!", "");
  }
  iterator.skip();
  FromJSON_uint32_t(iterator, value.decode_id);
  iterator.skip();
  FromJSON_uint32_t(iterator, value.texture_id);
  iterator.skip();
  FromJSON_uint32_t(iterator, value.texture_target);
  iterator.skip();
  FromJSON_PP_Size(iterator, value.texture_size);
  iterator.skip();
  FromJSON_PP_Rect(iterator, value.visible_rect);
}
const string ToString_PP_VideoPicture_0_1(const PP_VideoPicture_0_1 *v) {
  if (!v) {
    return "null";
  }
  return ToString_PP_VideoPicture_0_1(*v);
}
const string ToString_PP_VideoPicture_0_1(const PP_VideoPicture_0_1 &v) {
  stringstream x;
  BeginProps(x);
  AddProp(x, "decode_id", ToString_uint32_t(v.decode_id));
  AddProp(x, "texture_id", ToString_uint32_t(v.texture_id));
  AddProp(x, "texture_target", ToString_uint32_t(v.texture_target));
  AddProp(x, "texture_size", ToString_PP_Size(v.texture_size));
  EndProps(x);
  return x.str();
}
void FromJSON_PP_VideoPicture_0_1(JSONIterator& iterator, PP_VideoPicture_0_1 &value) {
  const JSON::Token& current = iterator.getCurrentAndGotoNext();
  if (current.isPrimitive() && !current.value().compare("null")) {
    return;
  }
  if (!current.isObject()) {
    Fail("Expected object!", "");
  }
  iterator.skip();
  FromJSON_uint32_t(iterator, value.decode_id);
  iterator.skip();
  FromJSON_uint32_t(iterator, value.texture_id);
  iterator.skip();
  FromJSON_uint32_t(iterator, value.texture_target);
  iterator.skip();
  FromJSON_PP_Size(iterator, value.texture_size);
}
const string ToString_PP_VideoProfileDescription(const PP_VideoProfileDescription *v) {
  if (!v) {
    return "null";
  }
  return ToString_PP_VideoProfileDescription(*v);
}
const string ToString_PP_VideoProfileDescription(const PP_VideoProfileDescription &v) {
  stringstream x;
  BeginProps(x);
  AddProp(x, "profile", ToString_PP_VideoProfile(v.profile));
  AddProp(x, "max_resolution", ToString_PP_Size(v.max_resolution));
  AddProp(x, "max_framerate_numerator", ToString_uint32_t(v.max_framerate_numerator));
  AddProp(x, "max_framerate_denominator", ToString_uint32_t(v.max_framerate_denominator));
  AddProp(x, "hardware_accelerated", ToString_PP_Bool(v.hardware_accelerated));
  EndProps(x);
  return x.str();
}
void FromJSON_PP_VideoProfileDescription(JSONIterator& iterator, PP_VideoProfileDescription &value) {
  const JSON::Token& current = iterator.getCurrentAndGotoNext();
  if (current.isPrimitive() && !current.value().compare("null")) {
    return;
  }
  if (!current.isObject()) {
    Fail("Expected object!", "");
  }
  iterator.skip();
  FromJSON_PP_VideoProfile(iterator, value.profile);
  iterator.skip();
  FromJSON_PP_Size(iterator, value.max_resolution);
  iterator.skip();
  FromJSON_uint32_t(iterator, value.max_framerate_numerator);
  iterator.skip();
  FromJSON_uint32_t(iterator, value.max_framerate_denominator);
  iterator.skip();
  FromJSON_PP_Bool(iterator, value.hardware_accelerated);
}
const string ToString_PP_VideoProfileDescription_0_1(const PP_VideoProfileDescription_0_1 *v) {
  if (!v) {
    return "null";
  }
  return ToString_PP_VideoProfileDescription_0_1(*v);
}
const string ToString_PP_VideoProfileDescription_0_1(const PP_VideoProfileDescription_0_1 &v) {
  stringstream x;
  BeginProps(x);
  AddProp(x, "profile", ToString_PP_VideoProfile(v.profile));
  AddProp(x, "max_resolution", ToString_PP_Size(v.max_resolution));
  AddProp(x, "max_framerate_numerator", ToString_uint32_t(v.max_framerate_numerator));
  AddProp(x, "max_framerate_denominator", ToString_uint32_t(v.max_framerate_denominator));
  AddProp(x, "acceleration", ToString_PP_HardwareAcceleration(v.acceleration));
  EndProps(x);
  return x.str();
}
void FromJSON_PP_VideoProfileDescription_0_1(JSONIterator& iterator, PP_VideoProfileDescription_0_1 &value) {
  const JSON::Token& current = iterator.getCurrentAndGotoNext();
  if (current.isPrimitive() && !current.value().compare("null")) {
    return;
  }
  if (!current.isObject()) {
    Fail("Expected object!", "");
  }
  iterator.skip();
  FromJSON_PP_VideoProfile(iterator, value.profile);
  iterator.skip();
  FromJSON_PP_Size(iterator, value.max_resolution);
  iterator.skip();
  FromJSON_uint32_t(iterator, value.max_framerate_numerator);
  iterator.skip();
  FromJSON_uint32_t(iterator, value.max_framerate_denominator);
  iterator.skip();
  FromJSON_PP_HardwareAcceleration(iterator, value.acceleration);
}
const string ToString_PP_AudioProfileDescription(const PP_AudioProfileDescription *v) {
  if (!v) {
    return "null";
  }
  return ToString_PP_AudioProfileDescription(*v);
}
const string ToString_PP_AudioProfileDescription(const PP_AudioProfileDescription &v) {
  stringstream x;
  BeginProps(x);
  AddProp(x, "profile", ToString_PP_AudioProfile(v.profile));
  AddProp(x, "max_channels", ToString_uint32_t(v.max_channels));
  AddProp(x, "sample_size", ToString_uint32_t(v.sample_size));
  AddProp(x, "sample_rate", ToString_uint32_t(v.sample_rate));
  AddProp(x, "hardware_accelerated", ToString_PP_Bool(v.hardware_accelerated));
  EndProps(x);
  return x.str();
}
void FromJSON_PP_AudioProfileDescription(JSONIterator& iterator, PP_AudioProfileDescription &value) {
  const JSON::Token& current = iterator.getCurrentAndGotoNext();
  if (current.isPrimitive() && !current.value().compare("null")) {
    return;
  }
  if (!current.isObject()) {
    Fail("Expected object!", "");
  }
  iterator.skip();
  FromJSON_PP_AudioProfile(iterator, value.profile);
  iterator.skip();
  FromJSON_uint32_t(iterator, value.max_channels);
  iterator.skip();
  FromJSON_uint32_t(iterator, value.sample_size);
  iterator.skip();
  FromJSON_uint32_t(iterator, value.sample_rate);
  iterator.skip();
  FromJSON_PP_Bool(iterator, value.hardware_accelerated);
}
const string ToString_PP_BitstreamBuffer(const PP_BitstreamBuffer *v) {
  if (!v) {
    return "null";
  }
  return ToString_PP_BitstreamBuffer(*v);
}
const string ToString_PP_BitstreamBuffer(const PP_BitstreamBuffer &v) {
  stringstream x;
  BeginProps(x);
  AddProp(x, "size", ToString_uint32_t(v.size));
  AddProp(x, "buffer", ToString_mem_t(v.buffer));
  AddProp(x, "key_frame", ToString_PP_Bool(v.key_frame));
  EndProps(x);
  return x.str();
}
void FromJSON_PP_BitstreamBuffer(JSONIterator& iterator, PP_BitstreamBuffer &value) {
  const JSON::Token& current = iterator.getCurrentAndGotoNext();
  if (current.isPrimitive() && !current.value().compare("null")) {
    return;
  }
  if (!current.isObject()) {
    Fail("Expected object!", "");
  }
  iterator.skip();
  FromJSON_uint32_t(iterator, value.size);
  iterator.skip();
  FromJSON_mem_t(iterator, value.buffer);
  iterator.skip();
  FromJSON_PP_Bool(iterator, value.key_frame);
}
const string ToString_PP_AudioBitstreamBuffer(const PP_AudioBitstreamBuffer *v) {
  if (!v) {
    return "null";
  }
  return ToString_PP_AudioBitstreamBuffer(*v);
}
const string ToString_PP_AudioBitstreamBuffer(const PP_AudioBitstreamBuffer &v) {
  stringstream x;
  BeginProps(x);
  AddProp(x, "size", ToString_uint32_t(v.size));
  AddProp(x, "buffer", ToString_mem_t(v.buffer));
  EndProps(x);
  return x.str();
}
void FromJSON_PP_AudioBitstreamBuffer(JSONIterator& iterator, PP_AudioBitstreamBuffer &value) {
  const JSON::Token& current = iterator.getCurrentAndGotoNext();
  if (current.isPrimitive() && !current.value().compare("null")) {
    return;
  }
  if (!current.isObject()) {
    Fail("Expected object!", "");
  }
  iterator.skip();
  FromJSON_uint32_t(iterator, value.size);
  iterator.skip();
  FromJSON_mem_t(iterator, value.buffer);
}
const string ToString_PP_CompletionCallback_Func(const PP_CompletionCallback_Func &v) {
  return PointerToString(v);
}
void FromJSON_PP_CompletionCallback_Func(JSONIterator& iterator, PP_CompletionCallback_Func &value) {
  PointerValueFromJSON(iterator, value);
}
const string ToString_PP_CompletionCallback_Flag(const PP_CompletionCallback_Flag *v) {
  switch (*v) {
    case 0 << 0:
      return "\"PP_COMPLETIONCALLBACK_FLAG_NONE\"";
    case 1 << 0:
      return "\"PP_COMPLETIONCALLBACK_FLAG_OPTIONAL\"";
    default:
      return "\"???\"";
  }
}
const string ToString_PP_CompletionCallback_Flag(const PP_CompletionCallback_Flag &v) {
  return ToString_PP_CompletionCallback_Flag(&v);
}
void FromJSON_PP_CompletionCallback_Flag(JSONIterator& iterator, PP_CompletionCallback_Flag &value) {
  long int v;
  FromJSON_int(iterator, v);
  value = PP_CompletionCallback_Flag(v);
}
const string ToString_PP_CompletionCallback(const PP_CompletionCallback *v) {
  if (!v) {
    return "null";
  }
  return ToString_PP_CompletionCallback(*v);
}
const string ToString_PP_CompletionCallback(const PP_CompletionCallback &v) {
  stringstream x;
  BeginProps(x);
  AddProp(x, "func", ToString_PP_CompletionCallback_Func(v.func));
  AddProp(x, "user_data", ToString_mem_t(v.user_data));
  AddProp(x, "flags", ToString_int32_t(v.flags));
  EndProps(x);
  return x.str();
}
void FromJSON_PP_CompletionCallback(JSONIterator& iterator, PP_CompletionCallback &value) {
  const JSON::Token& current = iterator.getCurrentAndGotoNext();
  if (current.isPrimitive() && !current.value().compare("null")) {
    return;
  }
  if (!current.isObject()) {
    Fail("Expected object!", "");
  }
  iterator.skip();
  FromJSON_PP_CompletionCallback_Func(iterator, value.func);
  iterator.skip();
  FromJSON_mem_t(iterator, value.user_data);
  iterator.skip();
  FromJSON_int32_t(iterator, value.flags);
}
const string ToString_PP_DirectoryEntry(const PP_DirectoryEntry *v) {
  if (!v) {
    return "null";
  }
  return ToString_PP_DirectoryEntry(*v);
}
const string ToString_PP_DirectoryEntry(const PP_DirectoryEntry &v) {
  stringstream x;
  BeginProps(x);
  AddProp(x, "file_ref", ToString_PP_Resource(v.file_ref));
  AddProp(x, "file_type", ToString_PP_FileType(v.file_type));
  EndProps(x);
  return x.str();
}
void FromJSON_PP_DirectoryEntry(JSONIterator& iterator, PP_DirectoryEntry &value) {
  const JSON::Token& current = iterator.getCurrentAndGotoNext();
  if (current.isPrimitive() && !current.value().compare("null")) {
    return;
  }
  if (!current.isObject()) {
    Fail("Expected object!", "");
  }
  iterator.skip();
  FromJSON_PP_Resource(iterator, value.file_ref);
  iterator.skip();
  FromJSON_PP_FileType(iterator, value.file_type);
}
const string ToString_PP_FileType(const PP_FileType *v) {
  switch (*v) {
    case 0:
      return "\"PP_FILETYPE_REGULAR\"";
    case 1:
      return "\"PP_FILETYPE_DIRECTORY\"";
    case 2:
      return "\"PP_FILETYPE_OTHER\"";
    default:
      return "\"???\"";
  }
}
const string ToString_PP_FileType(const PP_FileType &v) {
  return ToString_PP_FileType(&v);
}
void FromJSON_PP_FileType(JSONIterator& iterator, PP_FileType &value) {
  long int v;
  FromJSON_int(iterator, v);
  value = PP_FileType(v);
}
const string ToString_PP_FileSystemType(const PP_FileSystemType *v) {
  switch (*v) {
    case 0:
      return "\"PP_FILESYSTEMTYPE_INVALID\"";
    case 1:
      return "\"PP_FILESYSTEMTYPE_EXTERNAL\"";
    case 2:
      return "\"PP_FILESYSTEMTYPE_LOCALPERSISTENT\"";
    case 3:
      return "\"PP_FILESYSTEMTYPE_LOCALTEMPORARY\"";
    case 4:
      return "\"PP_FILESYSTEMTYPE_ISOLATED\"";
    default:
      return "\"???\"";
  }
}
const string ToString_PP_FileSystemType(const PP_FileSystemType &v) {
  return ToString_PP_FileSystemType(&v);
}
void FromJSON_PP_FileSystemType(JSONIterator& iterator, PP_FileSystemType &value) {
  long int v;
  FromJSON_int(iterator, v);
  value = PP_FileSystemType(v);
}
const string ToString_PP_FileInfo(const PP_FileInfo *v) {
  if (!v) {
    return "null";
  }
  return ToString_PP_FileInfo(*v);
}
const string ToString_PP_FileInfo(const PP_FileInfo &v) {
  stringstream x;
  BeginProps(x);
  AddProp(x, "size", ToString_int64_t(v.size));
  AddProp(x, "type", ToString_PP_FileType(v.type));
  AddProp(x, "system_type", ToString_PP_FileSystemType(v.system_type));
  AddProp(x, "creation_time", ToString_PP_Time(v.creation_time));
  AddProp(x, "last_access_time", ToString_PP_Time(v.last_access_time));
  AddProp(x, "last_modified_time", ToString_PP_Time(v.last_modified_time));
  EndProps(x);
  return x.str();
}
void FromJSON_PP_FileInfo(JSONIterator& iterator, PP_FileInfo &value) {
  const JSON::Token& current = iterator.getCurrentAndGotoNext();
  if (current.isPrimitive() && !current.value().compare("null")) {
    return;
  }
  if (!current.isObject()) {
    Fail("Expected object!", "");
  }
  iterator.skip();
  FromJSON_int64_t(iterator, value.size);
  iterator.skip();
  FromJSON_PP_FileType(iterator, value.type);
  iterator.skip();
  FromJSON_PP_FileSystemType(iterator, value.system_type);
  iterator.skip();
  FromJSON_PP_Time(iterator, value.creation_time);
  iterator.skip();
  FromJSON_PP_Time(iterator, value.last_access_time);
  iterator.skip();
  FromJSON_PP_Time(iterator, value.last_modified_time);
}
const string ToString_PP_Graphics3DAttrib(const PP_Graphics3DAttrib *v) {
  switch (*v) {
    case 0x3021:
      return "\"PP_GRAPHICS3DATTRIB_ALPHA_SIZE\"";
    case 0x3022:
      return "\"PP_GRAPHICS3DATTRIB_BLUE_SIZE\"";
    case 0x3023:
      return "\"PP_GRAPHICS3DATTRIB_GREEN_SIZE\"";
    case 0x3024:
      return "\"PP_GRAPHICS3DATTRIB_RED_SIZE\"";
    case 0x3025:
      return "\"PP_GRAPHICS3DATTRIB_DEPTH_SIZE\"";
    case 0x3026:
      return "\"PP_GRAPHICS3DATTRIB_STENCIL_SIZE\"";
    case 0x3031:
      return "\"PP_GRAPHICS3DATTRIB_SAMPLES\"";
    case 0x3032:
      return "\"PP_GRAPHICS3DATTRIB_SAMPLE_BUFFERS\"";
    case 0x3038:
      return "\"PP_GRAPHICS3DATTRIB_NONE\"";
    case 0x3056:
      return "\"PP_GRAPHICS3DATTRIB_HEIGHT\"";
    case 0x3057:
      return "\"PP_GRAPHICS3DATTRIB_WIDTH\"";
    case 0x3093:
      return "\"PP_GRAPHICS3DATTRIB_SWAP_BEHAVIOR\"";
    case 0x3094:
      return "\"PP_GRAPHICS3DATTRIB_BUFFER_PRESERVED\"";
    case 0x3095:
      return "\"PP_GRAPHICS3DATTRIB_BUFFER_DESTROYED\"";
    case 0x11000:
      return "\"PP_GRAPHICS3DATTRIB_GPU_PREFERENCE\"";
    case 0x11001:
      return "\"PP_GRAPHICS3DATTRIB_GPU_PREFERENCE_LOW_POWER\"";
    case 0x11002:
      return "\"PP_GRAPHICS3DATTRIB_GPU_PREFERENCE_PERFORMANCE\"";
    default:
      return "\"???\"";
  }
}
const string ToString_PP_Graphics3DAttrib(const PP_Graphics3DAttrib &v) {
  return ToString_PP_Graphics3DAttrib(&v);
}
void FromJSON_PP_Graphics3DAttrib(JSONIterator& iterator, PP_Graphics3DAttrib &value) {
  long int v;
  FromJSON_int(iterator, v);
  value = PP_Graphics3DAttrib(v);
}
const string ToString_PP_InputEvent_Key(const PP_InputEvent_Key *v) {
  if (!v) {
    return "null";
  }
  return ToString_PP_InputEvent_Key(*v);
}
const string ToString_PP_InputEvent_Key(const PP_InputEvent_Key &v) {
  stringstream x;
  BeginProps(x);
  AddProp(x, "modifier", ToString_uint32_t(v.modifier));
  AddProp(x, "key_code", ToString_uint32_t(v.key_code));
  EndProps(x);
  return x.str();
}
void FromJSON_PP_InputEvent_Key(JSONIterator& iterator, PP_InputEvent_Key &value) {
  const JSON::Token& current = iterator.getCurrentAndGotoNext();
  if (current.isPrimitive() && !current.value().compare("null")) {
    return;
  }
  if (!current.isObject()) {
    Fail("Expected object!", "");
  }
  iterator.skip();
  FromJSON_uint32_t(iterator, value.modifier);
  iterator.skip();
  FromJSON_uint32_t(iterator, value.key_code);
}
const string ToString_PP_InputEvent_Character(const PP_InputEvent_Character *v) {
  if (!v) {
    return "null";
  }
  return ToString_PP_InputEvent_Character(*v);
}
const string ToString_PP_InputEvent_Character(const PP_InputEvent_Character &v) {
  stringstream x;
  BeginProps(x);
  AddProp(x, "modifier", ToString_uint32_t(v.modifier));
  {
    BeginProp(x, "text");
    BeginElements(x);
    for (uint32_t _n = 0; _n < 5; ++_n) {
      AddElement(x, ToString_int8_t(v.text[_n]));
    }
    EndElements(x);
  }
  EndProps(x);
  return x.str();
}
void FromJSON_PP_InputEvent_Character(JSONIterator& iterator, PP_InputEvent_Character &value) {
  const JSON::Token& current = iterator.getCurrentAndGotoNext();
  if (current.isPrimitive() && !current.value().compare("null")) {
    return;
  }
  if (!current.isObject()) {
    Fail("Expected object!", "");
  }
  iterator.skip();
  FromJSON_uint32_t(iterator, value.modifier);
  iterator.skip();

  {
    size_t children = iterator.expectArrayAndGotoFirstItem();
    if (children > 5) {
      Fail("Too many items in array\n", "");
    }
    for (uint32_t _n = 0; _n < children; ++_n) {
      FromJSON_int8_t(iterator, (value.text)[_n]);
    }
    // FIXME Null out remaining items?
  }
}
const string ToString_PP_InputEvent_Mouse(const PP_InputEvent_Mouse *v) {
  if (!v) {
    return "null";
  }
  return ToString_PP_InputEvent_Mouse(*v);
}
const string ToString_PP_InputEvent_Mouse(const PP_InputEvent_Mouse &v) {
  stringstream x;
  BeginProps(x);
  AddProp(x, "modifier", ToString_uint32_t(v.modifier));
  AddProp(x, "button", ToString_PP_InputEvent_MouseButton(v.button));
  AddProp(x, "x", ToString_float_t(v.x));
  AddProp(x, "y", ToString_float_t(v.y));
  AddProp(x, "click_count", ToString_int32_t(v.click_count));
  EndProps(x);
  return x.str();
}
void FromJSON_PP_InputEvent_Mouse(JSONIterator& iterator, PP_InputEvent_Mouse &value) {
  const JSON::Token& current = iterator.getCurrentAndGotoNext();
  if (current.isPrimitive() && !current.value().compare("null")) {
    return;
  }
  if (!current.isObject()) {
    Fail("Expected object!", "");
  }
  iterator.skip();
  FromJSON_uint32_t(iterator, value.modifier);
  iterator.skip();
  FromJSON_PP_InputEvent_MouseButton(iterator, value.button);
  iterator.skip();
  FromJSON_float_t(iterator, value.x);
  iterator.skip();
  FromJSON_float_t(iterator, value.y);
  iterator.skip();
  FromJSON_int32_t(iterator, value.click_count);
}
const string ToString_PP_InputEvent_Wheel(const PP_InputEvent_Wheel *v) {
  if (!v) {
    return "null";
  }
  return ToString_PP_InputEvent_Wheel(*v);
}
const string ToString_PP_InputEvent_Wheel(const PP_InputEvent_Wheel &v) {
  stringstream x;
  BeginProps(x);
  AddProp(x, "modifier", ToString_uint32_t(v.modifier));
  AddProp(x, "delta_x", ToString_float_t(v.delta_x));
  AddProp(x, "delta_y", ToString_float_t(v.delta_y));
  AddProp(x, "wheel_ticks_x", ToString_float_t(v.wheel_ticks_x));
  AddProp(x, "wheel_ticks_y", ToString_float_t(v.wheel_ticks_y));
  AddProp(x, "scroll_by_page", ToString_PP_Bool(v.scroll_by_page));
  EndProps(x);
  return x.str();
}
void FromJSON_PP_InputEvent_Wheel(JSONIterator& iterator, PP_InputEvent_Wheel &value) {
  const JSON::Token& current = iterator.getCurrentAndGotoNext();
  if (current.isPrimitive() && !current.value().compare("null")) {
    return;
  }
  if (!current.isObject()) {
    Fail("Expected object!", "");
  }
  iterator.skip();
  FromJSON_uint32_t(iterator, value.modifier);
  iterator.skip();
  FromJSON_float_t(iterator, value.delta_x);
  iterator.skip();
  FromJSON_float_t(iterator, value.delta_y);
  iterator.skip();
  FromJSON_float_t(iterator, value.wheel_ticks_x);
  iterator.skip();
  FromJSON_float_t(iterator, value.wheel_ticks_y);
  iterator.skip();
  FromJSON_PP_Bool(iterator, value.scroll_by_page);
}
const string ToString_PP_Instance(const PP_Instance *v) {
  return ToString_int32_t(v);
}
const string ToString_PP_Instance(const PP_Instance &v) {
  return ToString_PP_Instance(&v);
}
void FromJSON_PP_Instance(JSONIterator& iterator, PP_Instance &value) {
  FromJSON_int32_t(iterator, value);
}
const string ToString_PP_Module(const PP_Module *v) {
  return ToString_int32_t(v);
}
const string ToString_PP_Module(const PP_Module &v) {
  return ToString_PP_Module(&v);
}
void FromJSON_PP_Module(JSONIterator& iterator, PP_Module &value) {
  FromJSON_int32_t(iterator, value);
}
const string ToString_PP_Point(const PP_Point *v) {
  if (!v) {
    return "null";
  }
  return ToString_PP_Point(*v);
}
const string ToString_PP_Point(const PP_Point &v) {
  stringstream x;
  BeginProps(x);
  AddProp(x, "x", ToString_int32_t(v.x));
  AddProp(x, "y", ToString_int32_t(v.y));
  EndProps(x);
  return x.str();
}
void FromJSON_PP_Point(JSONIterator& iterator, PP_Point &value) {
  const JSON::Token& current = iterator.getCurrentAndGotoNext();
  if (current.isPrimitive() && !current.value().compare("null")) {
    return;
  }
  if (!current.isObject()) {
    Fail("Expected object!", "");
  }
  iterator.skip();
  FromJSON_int32_t(iterator, value.x);
  iterator.skip();
  FromJSON_int32_t(iterator, value.y);
}
const string ToString_PP_FloatPoint(const PP_FloatPoint *v) {
  if (!v) {
    return "null";
  }
  return ToString_PP_FloatPoint(*v);
}
const string ToString_PP_FloatPoint(const PP_FloatPoint &v) {
  stringstream x;
  BeginProps(x);
  AddProp(x, "x", ToString_float_t(v.x));
  AddProp(x, "y", ToString_float_t(v.y));
  EndProps(x);
  return x.str();
}
void FromJSON_PP_FloatPoint(JSONIterator& iterator, PP_FloatPoint &value) {
  const JSON::Token& current = iterator.getCurrentAndGotoNext();
  if (current.isPrimitive() && !current.value().compare("null")) {
    return;
  }
  if (!current.isObject()) {
    Fail("Expected object!", "");
  }
  iterator.skip();
  FromJSON_float_t(iterator, value.x);
  iterator.skip();
  FromJSON_float_t(iterator, value.y);
}
const string ToString_PP_Rect(const PP_Rect *v) {
  if (!v) {
    return "null";
  }
  return ToString_PP_Rect(*v);
}
const string ToString_PP_Rect(const PP_Rect &v) {
  stringstream x;
  BeginProps(x);
  AddProp(x, "point", ToString_PP_Point(v.point));
  AddProp(x, "size", ToString_PP_Size(v.size));
  EndProps(x);
  return x.str();
}
void FromJSON_PP_Rect(JSONIterator& iterator, PP_Rect &value) {
  const JSON::Token& current = iterator.getCurrentAndGotoNext();
  if (current.isPrimitive() && !current.value().compare("null")) {
    return;
  }
  if (!current.isObject()) {
    Fail("Expected object!", "");
  }
  iterator.skip();
  FromJSON_PP_Point(iterator, value.point);
  iterator.skip();
  FromJSON_PP_Size(iterator, value.size);
}
const string ToString_PP_FloatRect(const PP_FloatRect *v) {
  if (!v) {
    return "null";
  }
  return ToString_PP_FloatRect(*v);
}
const string ToString_PP_FloatRect(const PP_FloatRect &v) {
  stringstream x;
  BeginProps(x);
  AddProp(x, "point", ToString_PP_FloatPoint(v.point));
  AddProp(x, "size", ToString_PP_FloatSize(v.size));
  EndProps(x);
  return x.str();
}
void FromJSON_PP_FloatRect(JSONIterator& iterator, PP_FloatRect &value) {
  const JSON::Token& current = iterator.getCurrentAndGotoNext();
  if (current.isPrimitive() && !current.value().compare("null")) {
    return;
  }
  if (!current.isObject()) {
    Fail("Expected object!", "");
  }
  iterator.skip();
  FromJSON_PP_FloatPoint(iterator, value.point);
  iterator.skip();
  FromJSON_PP_FloatSize(iterator, value.size);
}
const string ToString_PP_Resource(const PP_Resource *v) {
  return ToString_int32_t(v);
}
const string ToString_PP_Resource(const PP_Resource &v) {
  return ToString_PP_Resource(&v);
}
void FromJSON_PP_Resource(JSONIterator& iterator, PP_Resource &value) {
  FromJSON_int32_t(iterator, value);
}
const string ToString_PP_Size(const PP_Size *v) {
  if (!v) {
    return "null";
  }
  return ToString_PP_Size(*v);
}
const string ToString_PP_Size(const PP_Size &v) {
  stringstream x;
  BeginProps(x);
  AddProp(x, "width", ToString_int32_t(v.width));
  AddProp(x, "height", ToString_int32_t(v.height));
  EndProps(x);
  return x.str();
}
void FromJSON_PP_Size(JSONIterator& iterator, PP_Size &value) {
  const JSON::Token& current = iterator.getCurrentAndGotoNext();
  if (current.isPrimitive() && !current.value().compare("null")) {
    return;
  }
  if (!current.isObject()) {
    Fail("Expected object!", "");
  }
  iterator.skip();
  FromJSON_int32_t(iterator, value.width);
  iterator.skip();
  FromJSON_int32_t(iterator, value.height);
}
const string ToString_PP_FloatSize(const PP_FloatSize *v) {
  if (!v) {
    return "null";
  }
  return ToString_PP_FloatSize(*v);
}
const string ToString_PP_FloatSize(const PP_FloatSize &v) {
  stringstream x;
  BeginProps(x);
  AddProp(x, "width", ToString_float_t(v.width));
  AddProp(x, "height", ToString_float_t(v.height));
  EndProps(x);
  return x.str();
}
void FromJSON_PP_FloatSize(JSONIterator& iterator, PP_FloatSize &value) {
  const JSON::Token& current = iterator.getCurrentAndGotoNext();
  if (current.isPrimitive() && !current.value().compare("null")) {
    return;
  }
  if (!current.isObject()) {
    Fail("Expected object!", "");
  }
  iterator.skip();
  FromJSON_float_t(iterator, value.width);
  iterator.skip();
  FromJSON_float_t(iterator, value.height);
}
const string ToString_PP_Time(const PP_Time *v) {
  return ToString_double_t(v);
}
const string ToString_PP_Time(const PP_Time &v) {
  return ToString_PP_Time(&v);
}
void FromJSON_PP_Time(JSONIterator& iterator, PP_Time &value) {
  FromJSON_double_t(iterator, value);
}
const string ToString_PP_TimeTicks(const PP_TimeTicks *v) {
  return ToString_double_t(v);
}
const string ToString_PP_TimeTicks(const PP_TimeTicks &v) {
  return ToString_PP_TimeTicks(&v);
}
void FromJSON_PP_TimeTicks(JSONIterator& iterator, PP_TimeTicks &value) {
  FromJSON_double_t(iterator, value);
}
const string ToString_PP_TimeDelta(const PP_TimeDelta *v) {
  return ToString_double_t(v);
}
const string ToString_PP_TimeDelta(const PP_TimeDelta &v) {
  return ToString_PP_TimeDelta(&v);
}
void FromJSON_PP_TimeDelta(JSONIterator& iterator, PP_TimeDelta &value) {
  FromJSON_double_t(iterator, value);
}
const string ToString_PP_TouchPoint(const PP_TouchPoint *v) {
  if (!v) {
    return "null";
  }
  return ToString_PP_TouchPoint(*v);
}
const string ToString_PP_TouchPoint(const PP_TouchPoint &v) {
  stringstream x;
  BeginProps(x);
  AddProp(x, "id", ToString_uint32_t(v.id));
  AddProp(x, "position", ToString_PP_FloatPoint(v.position));
  AddProp(x, "radius", ToString_PP_FloatPoint(v.radius));
  AddProp(x, "rotation_angle", ToString_float_t(v.rotation_angle));
  AddProp(x, "pressure", ToString_float_t(v.pressure));
  EndProps(x);
  return x.str();
}
void FromJSON_PP_TouchPoint(JSONIterator& iterator, PP_TouchPoint &value) {
  const JSON::Token& current = iterator.getCurrentAndGotoNext();
  if (current.isPrimitive() && !current.value().compare("null")) {
    return;
  }
  if (!current.isObject()) {
    Fail("Expected object!", "");
  }
  iterator.skip();
  FromJSON_uint32_t(iterator, value.id);
  iterator.skip();
  FromJSON_PP_FloatPoint(iterator, value.position);
  iterator.skip();
  FromJSON_PP_FloatPoint(iterator, value.radius);
  iterator.skip();
  FromJSON_float_t(iterator, value.rotation_angle);
  iterator.skip();
  FromJSON_float_t(iterator, value.pressure);
}
const string ToString_PP_VarType(const PP_VarType *v) {
  switch (*v) {
    case 0:
      return "\"PP_VARTYPE_UNDEFINED\"";
    case 1:
      return "\"PP_VARTYPE_NULL\"";
    case 2:
      return "\"PP_VARTYPE_BOOL\"";
    case 3:
      return "\"PP_VARTYPE_INT32\"";
    case 4:
      return "\"PP_VARTYPE_DOUBLE\"";
    case 5:
      return "\"PP_VARTYPE_STRING\"";
    case 6:
      return "\"PP_VARTYPE_OBJECT\"";
    case 7:
      return "\"PP_VARTYPE_ARRAY\"";
    case 8:
      return "\"PP_VARTYPE_DICTIONARY\"";
    case 9:
      return "\"PP_VARTYPE_ARRAY_BUFFER\"";
    case 10:
      return "\"PP_VARTYPE_RESOURCE\"";
    default:
      return "\"???\"";
  }
}
const string ToString_PP_VarType(const PP_VarType &v) {
  return ToString_PP_VarType(&v);
}
void FromJSON_PP_VarType(JSONIterator& iterator, PP_VarType &value) {
  long int v;
  FromJSON_int(iterator, v);
  value = PP_VarType(v);
}
const string ToString_PP_VarValue(const PP_VarValue *v) {
  if (!v) {
    return "null";
  }
  return ToString_PP_VarValue(*v);
}
const string ToString_PP_VarValue(const PP_VarValue &v) {
  stringstream x;
  BeginProps(x);
  AddProp(x, "as_bool", ToString_PP_Bool(v.as_bool));
  AddProp(x, "as_int", ToString_int32_t(v.as_int));
  AddProp(x, "as_double", ToString_double_t(v.as_double));
  AddProp(x, "as_id", ToString_int64_t(v.as_id));
  EndProps(x);
  return x.str();
}
void FromJSON_PP_VarValue(JSONIterator& iterator, PP_VarValue &value) {
  const JSON::Token& current = iterator.getCurrentAndGotoNext();
  if (current.isPrimitive() && !current.value().compare("null")) {
    return;
  }
  if (!current.isObject()) {
    Fail("Expected object!", "");
  }
  string name = iterator.getCurrentStringAndGotoNext().value();
  if (!name.compare("as_bool")) {
    FromJSON_PP_Bool(iterator, value.as_bool);
  } else   if (!name.compare("as_int")) {
    FromJSON_int32_t(iterator, value.as_int);
  } else   if (!name.compare("as_double")) {
    FromJSON_double_t(iterator, value.as_double);
  } else   if (!name.compare("as_id")) {
    FromJSON_int64_t(iterator, value.as_id);
  }
}
const string ToString_PP_Var(const PP_Var *v) {
  if (!v) {
    return "null";
  }
  return ToString_PP_Var(*v);
}
const string ToString_PP_Var(const PP_Var &v) {
  stringstream x;
  BeginProps(x);
  AddProp(x, "type", ToString_PP_VarType(v.type));
  AddProp(x, "padding", ToString_int32_t(v.padding));
  AddProp(x, "value", ToString_PP_VarValue(v.value));
  EndProps(x);
  return x.str();
}
void FromJSON_PP_Var(JSONIterator& iterator, PP_Var &value) {
  const JSON::Token& current = iterator.getCurrentAndGotoNext();
  if (current.isPrimitive() && !current.value().compare("null")) {
    return;
  }
  if (!current.isObject()) {
    Fail("Expected object!", "");
  }
  iterator.skip();
  FromJSON_PP_VarType(iterator, value.type);
  iterator.skip();
  FromJSON_int32_t(iterator, value.padding);
  iterator.skip();
  FromJSON_PP_VarValue(iterator, value.value);
}
const string ToString_PPB_GetInterface(const PPB_GetInterface &v) {
  return PointerToString(v);
}
void FromJSON_PPB_GetInterface(JSONIterator& iterator, PPB_GetInterface &value) {
  PointerValueFromJSON(iterator, value);
}
const string ToString_PPB_Audio_Callback(const PPB_Audio_Callback_1_0 &v) {
  return PointerToString(v);
}
void FromJSON_PPB_Audio_Callback(JSONIterator& iterator, PPB_Audio_Callback_1_0 &value) {
  PointerValueFromJSON(iterator, value);
}
const string ToString_PPB_Audio_Callback(const PPB_Audio_Callback &v) {
  return PointerToString(v);
}
void FromJSON_PPB_Audio_Callback(JSONIterator& iterator, PPB_Audio_Callback &value) {
  PointerValueFromJSON(iterator, value);
}
namespace ns_PPB_Audio_1_0 {
static PP_Resource Create_1_0(PP_Instance instance, PP_Resource config, PPB_Audio_Callback_1_0 audio_callback, void* user_data) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_Audio\"");
  AddProp(ss, "__version", "\"1.0\"");
  AddProp(ss, "__method", "\"Create\"");
  AddProp(ss, "instance", ToString_PP_Instance(instance));
  AddProp(ss, "config", ToString_PP_Resource(config));
  AddProp(ss, "audio_callback", ToString_PPB_Audio_Callback(audio_callback));
  AddProp(ss, "user_data", ToString_mem_t(user_data));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_Resource(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  Logging_PPB_Audio_Callback_1_0_holder* audio_callback_holder = new Logging_PPB_Audio_Callback_1_0_holder();
  audio_callback_holder->func = audio_callback;
  audio_callback_holder->user_data = user_data;
  user_data = audio_callback_holder;
  int32_t rval = ((PPB_Audio_1_0*)RealGetInterface("PPB_Audio;1.0"))->Create(instance, config, Logging_PPB_Audio_Callback_1_0, user_data);
  printf("RPC response: [");
  printf("%s", ToString_PP_Resource(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static PP_Bool IsAudio_1_0(PP_Resource resource) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_Audio\"");
  AddProp(ss, "__version", "\"1.0\"");
  AddProp(ss, "__method", "\"IsAudio\"");
  AddProp(ss, "resource", ToString_PP_Resource(resource));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  PP_Bool rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_Bool(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_Bool rval = ((PPB_Audio_1_0*)RealGetInterface("PPB_Audio;1.0"))->IsAudio(resource);
  printf("RPC response: [");
  printf("%s", ToString_PP_Bool(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static PP_Resource GetCurrentConfig_1_0(PP_Resource audio) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_Audio\"");
  AddProp(ss, "__version", "\"1.0\"");
  AddProp(ss, "__method", "\"GetCurrentConfig\"");
  AddProp(ss, "audio", ToString_PP_Resource(audio));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_Resource(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  int32_t rval = ((PPB_Audio_1_0*)RealGetInterface("PPB_Audio;1.0"))->GetCurrentConfig(audio);
  printf("RPC response: [");
  printf("%s", ToString_PP_Resource(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static PP_Bool StartPlayback_1_0(PP_Resource audio) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_Audio\"");
  AddProp(ss, "__version", "\"1.0\"");
  AddProp(ss, "__method", "\"StartPlayback\"");
  AddProp(ss, "audio", ToString_PP_Resource(audio));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  PP_Bool rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_Bool(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_Bool rval = ((PPB_Audio_1_0*)RealGetInterface("PPB_Audio;1.0"))->StartPlayback(audio);
  printf("RPC response: [");
  printf("%s", ToString_PP_Bool(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static PP_Bool StopPlayback_1_0(PP_Resource audio) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_Audio\"");
  AddProp(ss, "__version", "\"1.0\"");
  AddProp(ss, "__method", "\"StopPlayback\"");
  AddProp(ss, "audio", ToString_PP_Resource(audio));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  PP_Bool rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_Bool(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_Bool rval = ((PPB_Audio_1_0*)RealGetInterface("PPB_Audio;1.0"))->StopPlayback(audio);
  printf("RPC response: [");
  printf("%s", ToString_PP_Bool(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
}
static PPB_Audio_1_0 _PPB_Audio_1_0 = {
  ns_PPB_Audio_1_0::Create_1_0,
  ns_PPB_Audio_1_0::IsAudio_1_0,
  ns_PPB_Audio_1_0::GetCurrentConfig_1_0,
  ns_PPB_Audio_1_0::StartPlayback_1_0,
  ns_PPB_Audio_1_0::StopPlayback_1_0,
};
const string ToString_PPB_Audio(const PPB_Audio_1_0 *v) {
  stringstream s;
  s << v;
  return s.str();
}
namespace ns_PPB_Audio_1_1 {
static PP_Resource Create_1_1(PP_Instance instance, PP_Resource config, PPB_Audio_Callback audio_callback, void* user_data) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_Audio\"");
  AddProp(ss, "__version", "\"1.1\"");
  AddProp(ss, "__method", "\"Create\"");
  AddProp(ss, "instance", ToString_PP_Instance(instance));
  AddProp(ss, "config", ToString_PP_Resource(config));
  AddProp(ss, "audio_callback", ToString_PPB_Audio_Callback(audio_callback));
  AddProp(ss, "user_data", ToString_mem_t(user_data));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_Resource(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  int32_t rval = ((PPB_Audio_1_1*)RealGetInterface("PPB_Audio;1.1"))->Create(instance, config, audio_callback, user_data);
  printf("RPC response: [");
  printf("%s", ToString_PP_Resource(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static PP_Bool IsAudio_1_1(PP_Resource resource) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_Audio\"");
  AddProp(ss, "__version", "\"1.1\"");
  AddProp(ss, "__method", "\"IsAudio\"");
  AddProp(ss, "resource", ToString_PP_Resource(resource));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  PP_Bool rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_Bool(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_Bool rval = ((PPB_Audio_1_1*)RealGetInterface("PPB_Audio;1.1"))->IsAudio(resource);
  printf("RPC response: [");
  printf("%s", ToString_PP_Bool(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static PP_Resource GetCurrentConfig_1_1(PP_Resource audio) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_Audio\"");
  AddProp(ss, "__version", "\"1.1\"");
  AddProp(ss, "__method", "\"GetCurrentConfig\"");
  AddProp(ss, "audio", ToString_PP_Resource(audio));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_Resource(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  int32_t rval = ((PPB_Audio_1_1*)RealGetInterface("PPB_Audio;1.1"))->GetCurrentConfig(audio);
  printf("RPC response: [");
  printf("%s", ToString_PP_Resource(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static PP_Bool StartPlayback_1_1(PP_Resource audio) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_Audio\"");
  AddProp(ss, "__version", "\"1.1\"");
  AddProp(ss, "__method", "\"StartPlayback\"");
  AddProp(ss, "audio", ToString_PP_Resource(audio));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  PP_Bool rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_Bool(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_Bool rval = ((PPB_Audio_1_1*)RealGetInterface("PPB_Audio;1.1"))->StartPlayback(audio);
  printf("RPC response: [");
  printf("%s", ToString_PP_Bool(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static PP_Bool StopPlayback_1_1(PP_Resource audio) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_Audio\"");
  AddProp(ss, "__version", "\"1.1\"");
  AddProp(ss, "__method", "\"StopPlayback\"");
  AddProp(ss, "audio", ToString_PP_Resource(audio));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  PP_Bool rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_Bool(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_Bool rval = ((PPB_Audio_1_1*)RealGetInterface("PPB_Audio;1.1"))->StopPlayback(audio);
  printf("RPC response: [");
  printf("%s", ToString_PP_Bool(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
}
static PPB_Audio_1_1 _PPB_Audio_1_1 = {
  ns_PPB_Audio_1_1::Create_1_1,
  ns_PPB_Audio_1_1::IsAudio_1_1,
  ns_PPB_Audio_1_1::GetCurrentConfig_1_1,
  ns_PPB_Audio_1_1::StartPlayback_1_1,
  ns_PPB_Audio_1_1::StopPlayback_1_1,
};
const string ToString_PPB_Audio(const PPB_Audio_1_1 *v) {
  stringstream s;
  s << v;
  return s.str();
}
const string ToString_PP_AudioBuffer_SampleRate(const PP_AudioBuffer_SampleRate *v) {
  switch (*v) {
    case 0:
      return "\"PP_AUDIOBUFFER_SAMPLERATE_UNKNOWN\"";
    case 8000:
      return "\"PP_AUDIOBUFFER_SAMPLERATE_8000\"";
    case 16000:
      return "\"PP_AUDIOBUFFER_SAMPLERATE_16000\"";
    case 22050:
      return "\"PP_AUDIOBUFFER_SAMPLERATE_22050\"";
    case 32000:
      return "\"PP_AUDIOBUFFER_SAMPLERATE_32000\"";
    case 44100:
      return "\"PP_AUDIOBUFFER_SAMPLERATE_44100\"";
    case 48000:
      return "\"PP_AUDIOBUFFER_SAMPLERATE_48000\"";
    case 96000:
      return "\"PP_AUDIOBUFFER_SAMPLERATE_96000\"";
    case 192000:
      return "\"PP_AUDIOBUFFER_SAMPLERATE_192000\"";
    default:
      return "\"???\"";
  }
}
const string ToString_PP_AudioBuffer_SampleRate(const PP_AudioBuffer_SampleRate &v) {
  return ToString_PP_AudioBuffer_SampleRate(&v);
}
void FromJSON_PP_AudioBuffer_SampleRate(JSONIterator& iterator, PP_AudioBuffer_SampleRate &value) {
  long int v;
  FromJSON_int(iterator, v);
  value = PP_AudioBuffer_SampleRate(v);
}
const string ToString_PP_AudioBuffer_SampleSize(const PP_AudioBuffer_SampleSize *v) {
  switch (*v) {
    case 0:
      return "\"PP_AUDIOBUFFER_SAMPLESIZE_UNKNOWN\"";
    case 2:
      return "\"PP_AUDIOBUFFER_SAMPLESIZE_16_BITS\"";
    default:
      return "\"???\"";
  }
}
const string ToString_PP_AudioBuffer_SampleSize(const PP_AudioBuffer_SampleSize &v) {
  return ToString_PP_AudioBuffer_SampleSize(&v);
}
void FromJSON_PP_AudioBuffer_SampleSize(JSONIterator& iterator, PP_AudioBuffer_SampleSize &value) {
  long int v;
  FromJSON_int(iterator, v);
  value = PP_AudioBuffer_SampleSize(v);
}
namespace ns_PPB_AudioBuffer_0_1 {
static PP_Bool IsAudioBuffer_0_1(PP_Resource resource) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_AudioBuffer\"");
  AddProp(ss, "__version", "\"0.1\"");
  AddProp(ss, "__method", "\"IsAudioBuffer\"");
  AddProp(ss, "resource", ToString_PP_Resource(resource));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  PP_Bool rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_Bool(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_Bool rval = ((PPB_AudioBuffer_0_1*)RealGetInterface("PPB_AudioBuffer;0.1"))->IsAudioBuffer(resource);
  printf("RPC response: [");
  printf("%s", ToString_PP_Bool(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static PP_TimeDelta GetTimestamp_0_1(PP_Resource buffer) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_AudioBuffer\"");
  AddProp(ss, "__version", "\"0.1\"");
  AddProp(ss, "__method", "\"GetTimestamp\"");
  AddProp(ss, "buffer", ToString_PP_Resource(buffer));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  double rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_TimeDelta(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  double rval = ((PPB_AudioBuffer_0_1*)RealGetInterface("PPB_AudioBuffer;0.1"))->GetTimestamp(buffer);
  printf("RPC response: [");
  printf("%s", ToString_PP_TimeDelta(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static void SetTimestamp_0_1(PP_Resource buffer, PP_TimeDelta timestamp) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_AudioBuffer\"");
  AddProp(ss, "__version", "\"0.1\"");
  AddProp(ss, "__method", "\"SetTimestamp\"");
  AddProp(ss, "buffer", ToString_PP_Resource(buffer));
  AddProp(ss, "timestamp", ToString_PP_TimeDelta(timestamp));
  EndProps(ss);
#ifndef INTERPOSE
  RPC<MainThreadOnly>(ss);
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  ((PPB_AudioBuffer_0_1*)RealGetInterface("PPB_AudioBuffer;0.1"))->SetTimestamp(buffer, timestamp);
#endif // !INTERPOSE
}
static PP_AudioBuffer_SampleRate GetSampleRate_0_1(PP_Resource buffer) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_AudioBuffer\"");
  AddProp(ss, "__version", "\"0.1\"");
  AddProp(ss, "__method", "\"GetSampleRate\"");
  AddProp(ss, "buffer", ToString_PP_Resource(buffer));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  PP_AudioBuffer_SampleRate rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_AudioBuffer_SampleRate(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_AudioBuffer_SampleRate rval = ((PPB_AudioBuffer_0_1*)RealGetInterface("PPB_AudioBuffer;0.1"))->GetSampleRate(buffer);
  printf("RPC response: [");
  printf("%s", ToString_PP_AudioBuffer_SampleRate(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static PP_AudioBuffer_SampleSize GetSampleSize_0_1(PP_Resource buffer) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_AudioBuffer\"");
  AddProp(ss, "__version", "\"0.1\"");
  AddProp(ss, "__method", "\"GetSampleSize\"");
  AddProp(ss, "buffer", ToString_PP_Resource(buffer));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  PP_AudioBuffer_SampleSize rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_AudioBuffer_SampleSize(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_AudioBuffer_SampleSize rval = ((PPB_AudioBuffer_0_1*)RealGetInterface("PPB_AudioBuffer;0.1"))->GetSampleSize(buffer);
  printf("RPC response: [");
  printf("%s", ToString_PP_AudioBuffer_SampleSize(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static uint32_t GetNumberOfChannels_0_1(PP_Resource buffer) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_AudioBuffer\"");
  AddProp(ss, "__version", "\"0.1\"");
  AddProp(ss, "__method", "\"GetNumberOfChannels\"");
  AddProp(ss, "buffer", ToString_PP_Resource(buffer));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  uint32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_uint32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  uint32_t rval = ((PPB_AudioBuffer_0_1*)RealGetInterface("PPB_AudioBuffer;0.1"))->GetNumberOfChannels(buffer);
  printf("RPC response: [");
  printf("%s", ToString_uint32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static uint32_t GetNumberOfSamples_0_1(PP_Resource buffer) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_AudioBuffer\"");
  AddProp(ss, "__version", "\"0.1\"");
  AddProp(ss, "__method", "\"GetNumberOfSamples\"");
  AddProp(ss, "buffer", ToString_PP_Resource(buffer));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  uint32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_uint32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  uint32_t rval = ((PPB_AudioBuffer_0_1*)RealGetInterface("PPB_AudioBuffer;0.1"))->GetNumberOfSamples(buffer);
  printf("RPC response: [");
  printf("%s", ToString_uint32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static void* GetDataBuffer_0_1(PP_Resource buffer) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_AudioBuffer\"");
  AddProp(ss, "__version", "\"0.1\"");
  AddProp(ss, "__method", "\"GetDataBuffer\"");
  AddProp(ss, "buffer", ToString_PP_Resource(buffer));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  void* rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_mem_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  void* rval = ((PPB_AudioBuffer_0_1*)RealGetInterface("PPB_AudioBuffer;0.1"))->GetDataBuffer(buffer);
  printf("RPC response: [");
  printf("%s", ToString_mem_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static uint32_t GetDataBufferSize_0_1(PP_Resource buffer) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_AudioBuffer\"");
  AddProp(ss, "__version", "\"0.1\"");
  AddProp(ss, "__method", "\"GetDataBufferSize\"");
  AddProp(ss, "buffer", ToString_PP_Resource(buffer));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  uint32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_uint32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  uint32_t rval = ((PPB_AudioBuffer_0_1*)RealGetInterface("PPB_AudioBuffer;0.1"))->GetDataBufferSize(buffer);
  printf("RPC response: [");
  printf("%s", ToString_uint32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
}
static PPB_AudioBuffer_0_1 _PPB_AudioBuffer_0_1 = {
  ns_PPB_AudioBuffer_0_1::IsAudioBuffer_0_1,
  ns_PPB_AudioBuffer_0_1::GetTimestamp_0_1,
  ns_PPB_AudioBuffer_0_1::SetTimestamp_0_1,
  ns_PPB_AudioBuffer_0_1::GetSampleRate_0_1,
  ns_PPB_AudioBuffer_0_1::GetSampleSize_0_1,
  ns_PPB_AudioBuffer_0_1::GetNumberOfChannels_0_1,
  ns_PPB_AudioBuffer_0_1::GetNumberOfSamples_0_1,
  ns_PPB_AudioBuffer_0_1::GetDataBuffer_0_1,
  ns_PPB_AudioBuffer_0_1::GetDataBufferSize_0_1,
};
const string ToString_PPB_AudioBuffer(const PPB_AudioBuffer_0_1 *v) {
  stringstream s;
  s << v;
  return s.str();
}
const string ToString_PP_AudioSampleRate(const PP_AudioSampleRate *v) {
  switch (*v) {
    case 0:
      return "\"PP_AUDIOSAMPLERATE_NONE\"";
    case 44100:
      return "\"PP_AUDIOSAMPLERATE_44100\"";
    case 48000:
      return "\"PP_AUDIOSAMPLERATE_48000\"";
    default:
      return "\"???\"";
  }
}
const string ToString_PP_AudioSampleRate(const PP_AudioSampleRate &v) {
  return ToString_PP_AudioSampleRate(&v);
}
void FromJSON_PP_AudioSampleRate(JSONIterator& iterator, PP_AudioSampleRate &value) {
  long int v;
  FromJSON_int(iterator, v);
  value = PP_AudioSampleRate(v);
}
namespace ns_PPB_AudioConfig_1_0 {
static PP_Resource CreateStereo16Bit_1_0(PP_Instance instance, PP_AudioSampleRate sample_rate, uint32_t sample_frame_count) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_AudioConfig\"");
  AddProp(ss, "__version", "\"1.0\"");
  AddProp(ss, "__method", "\"CreateStereo16Bit\"");
  AddProp(ss, "instance", ToString_PP_Instance(instance));
  AddProp(ss, "sample_rate", ToString_PP_AudioSampleRate(sample_rate));
  AddProp(ss, "sample_frame_count", ToString_uint32_t(sample_frame_count));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_Resource(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  int32_t rval = ((PPB_AudioConfig_1_0*)RealGetInterface("PPB_AudioConfig;1.0"))->CreateStereo16Bit(instance, sample_rate, sample_frame_count);
  printf("RPC response: [");
  printf("%s", ToString_PP_Resource(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static uint32_t RecommendSampleFrameCount_1_0(PP_AudioSampleRate sample_rate, uint32_t requested_sample_frame_count) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_AudioConfig\"");
  AddProp(ss, "__version", "\"1.0\"");
  AddProp(ss, "__method", "\"RecommendSampleFrameCount\"");
  AddProp(ss, "sample_rate", ToString_PP_AudioSampleRate(sample_rate));
  AddProp(ss, "requested_sample_frame_count", ToString_uint32_t(requested_sample_frame_count));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  uint32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_uint32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  uint32_t rval = ((PPB_AudioConfig_1_0*)RealGetInterface("PPB_AudioConfig;1.0"))->RecommendSampleFrameCount(sample_rate, requested_sample_frame_count);
  printf("RPC response: [");
  printf("%s", ToString_uint32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
/* skipping RecommendSampleFrameCount */
static PP_Bool IsAudioConfig_1_0(PP_Resource resource) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_AudioConfig\"");
  AddProp(ss, "__version", "\"1.0\"");
  AddProp(ss, "__method", "\"IsAudioConfig\"");
  AddProp(ss, "resource", ToString_PP_Resource(resource));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  PP_Bool rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_Bool(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_Bool rval = ((PPB_AudioConfig_1_0*)RealGetInterface("PPB_AudioConfig;1.0"))->IsAudioConfig(resource);
  printf("RPC response: [");
  printf("%s", ToString_PP_Bool(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static PP_AudioSampleRate GetSampleRate_1_0(PP_Resource config) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_AudioConfig\"");
  AddProp(ss, "__version", "\"1.0\"");
  AddProp(ss, "__method", "\"GetSampleRate\"");
  AddProp(ss, "config", ToString_PP_Resource(config));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  PP_AudioSampleRate rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_AudioSampleRate(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_AudioSampleRate rval = ((PPB_AudioConfig_1_0*)RealGetInterface("PPB_AudioConfig;1.0"))->GetSampleRate(config);
  printf("RPC response: [");
  printf("%s", ToString_PP_AudioSampleRate(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static uint32_t GetSampleFrameCount_1_0(PP_Resource config) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_AudioConfig\"");
  AddProp(ss, "__version", "\"1.0\"");
  AddProp(ss, "__method", "\"GetSampleFrameCount\"");
  AddProp(ss, "config", ToString_PP_Resource(config));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  uint32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_uint32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  uint32_t rval = ((PPB_AudioConfig_1_0*)RealGetInterface("PPB_AudioConfig;1.0"))->GetSampleFrameCount(config);
  printf("RPC response: [");
  printf("%s", ToString_uint32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
/* skipping RecommendSampleRate */
}
static PPB_AudioConfig_1_0 _PPB_AudioConfig_1_0 = {
  ns_PPB_AudioConfig_1_0::CreateStereo16Bit_1_0,
  ns_PPB_AudioConfig_1_0::RecommendSampleFrameCount_1_0,
  ns_PPB_AudioConfig_1_0::IsAudioConfig_1_0,
  ns_PPB_AudioConfig_1_0::GetSampleRate_1_0,
  ns_PPB_AudioConfig_1_0::GetSampleFrameCount_1_0,
};
const string ToString_PPB_AudioConfig(const PPB_AudioConfig_1_0 *v) {
  stringstream s;
  s << v;
  return s.str();
}
namespace ns_PPB_AudioConfig_1_1 {
static PP_Resource CreateStereo16Bit_1_1(PP_Instance instance, PP_AudioSampleRate sample_rate, uint32_t sample_frame_count) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_AudioConfig\"");
  AddProp(ss, "__version", "\"1.1\"");
  AddProp(ss, "__method", "\"CreateStereo16Bit\"");
  AddProp(ss, "instance", ToString_PP_Instance(instance));
  AddProp(ss, "sample_rate", ToString_PP_AudioSampleRate(sample_rate));
  AddProp(ss, "sample_frame_count", ToString_uint32_t(sample_frame_count));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_Resource(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  int32_t rval = ((PPB_AudioConfig_1_1*)RealGetInterface("PPB_AudioConfig;1.1"))->CreateStereo16Bit(instance, sample_rate, sample_frame_count);
  printf("RPC response: [");
  printf("%s", ToString_PP_Resource(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
/* skipping RecommendSampleFrameCount */
static uint32_t RecommendSampleFrameCount_1_1(PP_Instance instance, PP_AudioSampleRate sample_rate, uint32_t requested_sample_frame_count) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_AudioConfig\"");
  AddProp(ss, "__version", "\"1.1\"");
  AddProp(ss, "__method", "\"RecommendSampleFrameCount\"");
  AddProp(ss, "instance", ToString_PP_Instance(instance));
  AddProp(ss, "sample_rate", ToString_PP_AudioSampleRate(sample_rate));
  AddProp(ss, "requested_sample_frame_count", ToString_uint32_t(requested_sample_frame_count));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  uint32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_uint32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  uint32_t rval = ((PPB_AudioConfig_1_1*)RealGetInterface("PPB_AudioConfig;1.1"))->RecommendSampleFrameCount(instance, sample_rate, requested_sample_frame_count);
  printf("RPC response: [");
  printf("%s", ToString_uint32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static PP_Bool IsAudioConfig_1_1(PP_Resource resource) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_AudioConfig\"");
  AddProp(ss, "__version", "\"1.1\"");
  AddProp(ss, "__method", "\"IsAudioConfig\"");
  AddProp(ss, "resource", ToString_PP_Resource(resource));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  PP_Bool rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_Bool(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_Bool rval = ((PPB_AudioConfig_1_1*)RealGetInterface("PPB_AudioConfig;1.1"))->IsAudioConfig(resource);
  printf("RPC response: [");
  printf("%s", ToString_PP_Bool(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static PP_AudioSampleRate GetSampleRate_1_1(PP_Resource config) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_AudioConfig\"");
  AddProp(ss, "__version", "\"1.1\"");
  AddProp(ss, "__method", "\"GetSampleRate\"");
  AddProp(ss, "config", ToString_PP_Resource(config));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  PP_AudioSampleRate rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_AudioSampleRate(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_AudioSampleRate rval = ((PPB_AudioConfig_1_1*)RealGetInterface("PPB_AudioConfig;1.1"))->GetSampleRate(config);
  printf("RPC response: [");
  printf("%s", ToString_PP_AudioSampleRate(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static uint32_t GetSampleFrameCount_1_1(PP_Resource config) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_AudioConfig\"");
  AddProp(ss, "__version", "\"1.1\"");
  AddProp(ss, "__method", "\"GetSampleFrameCount\"");
  AddProp(ss, "config", ToString_PP_Resource(config));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  uint32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_uint32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  uint32_t rval = ((PPB_AudioConfig_1_1*)RealGetInterface("PPB_AudioConfig;1.1"))->GetSampleFrameCount(config);
  printf("RPC response: [");
  printf("%s", ToString_uint32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static PP_AudioSampleRate RecommendSampleRate_1_1(PP_Instance instance) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_AudioConfig\"");
  AddProp(ss, "__version", "\"1.1\"");
  AddProp(ss, "__method", "\"RecommendSampleRate\"");
  AddProp(ss, "instance", ToString_PP_Instance(instance));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  PP_AudioSampleRate rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_AudioSampleRate(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_AudioSampleRate rval = ((PPB_AudioConfig_1_1*)RealGetInterface("PPB_AudioConfig;1.1"))->RecommendSampleRate(instance);
  printf("RPC response: [");
  printf("%s", ToString_PP_AudioSampleRate(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
}
static PPB_AudioConfig_1_1 _PPB_AudioConfig_1_1 = {
  ns_PPB_AudioConfig_1_1::CreateStereo16Bit_1_1,
  ns_PPB_AudioConfig_1_1::RecommendSampleFrameCount_1_1,
  ns_PPB_AudioConfig_1_1::IsAudioConfig_1_1,
  ns_PPB_AudioConfig_1_1::GetSampleRate_1_1,
  ns_PPB_AudioConfig_1_1::GetSampleFrameCount_1_1,
  ns_PPB_AudioConfig_1_1::RecommendSampleRate_1_1,
};
const string ToString_PPB_AudioConfig(const PPB_AudioConfig_1_1 *v) {
  stringstream s;
  s << v;
  return s.str();
}
namespace ns_PPB_AudioEncoder_0_1 {
static PP_Resource Create_0_1(PP_Instance instance) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_AudioEncoder\"");
  AddProp(ss, "__version", "\"0.1\"");
  AddProp(ss, "__method", "\"Create\"");
  AddProp(ss, "instance", ToString_PP_Instance(instance));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_Resource(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  int32_t rval = ((PPB_AudioEncoder_0_1*)RealGetInterface("PPB_AudioEncoder;0.1"))->Create(instance);
  printf("RPC response: [");
  printf("%s", ToString_PP_Resource(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static PP_Bool IsAudioEncoder_0_1(PP_Resource resource) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_AudioEncoder\"");
  AddProp(ss, "__version", "\"0.1\"");
  AddProp(ss, "__method", "\"IsAudioEncoder\"");
  AddProp(ss, "resource", ToString_PP_Resource(resource));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  PP_Bool rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_Bool(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_Bool rval = ((PPB_AudioEncoder_0_1*)RealGetInterface("PPB_AudioEncoder;0.1"))->IsAudioEncoder(resource);
  printf("RPC response: [");
  printf("%s", ToString_PP_Bool(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t GetSupportedProfiles_0_1(PP_Resource audio_encoder, struct PP_ArrayOutput output, struct PP_CompletionCallback callback) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_AudioEncoder\"");
  AddProp(ss, "__version", "\"0.1\"");
  AddProp(ss, "__method", "\"GetSupportedProfiles\"");
  AddProp(ss, "audio_encoder", ToString_PP_Resource(audio_encoder));
  AddProp(ss, "output", ToString_PP_ArrayOutput(output));
  AddProp(ss, "callback", ToString_PP_CompletionCallback(callback));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_CompletionCallback logging_callback;
  logging_callback.func = &Logging_PP_CompletionCallback;
  logging_callback.user_data = new PP_CompletionCallback(callback);
  logging_callback.flags = callback.flags;
  int32_t rval = ((PPB_AudioEncoder_0_1*)RealGetInterface("PPB_AudioEncoder;0.1"))->GetSupportedProfiles(audio_encoder, output, logging_callback);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t Initialize_0_1(PP_Resource audio_encoder, uint32_t channels, PP_AudioBuffer_SampleRate input_sample_rate, PP_AudioBuffer_SampleSize input_sample_size, PP_AudioProfile output_profile, uint32_t initial_bitrate, PP_HardwareAcceleration acceleration, struct PP_CompletionCallback callback) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_AudioEncoder\"");
  AddProp(ss, "__version", "\"0.1\"");
  AddProp(ss, "__method", "\"Initialize\"");
  AddProp(ss, "audio_encoder", ToString_PP_Resource(audio_encoder));
  AddProp(ss, "channels", ToString_uint32_t(channels));
  AddProp(ss, "input_sample_rate", ToString_PP_AudioBuffer_SampleRate(input_sample_rate));
  AddProp(ss, "input_sample_size", ToString_PP_AudioBuffer_SampleSize(input_sample_size));
  AddProp(ss, "output_profile", ToString_PP_AudioProfile(output_profile));
  AddProp(ss, "initial_bitrate", ToString_uint32_t(initial_bitrate));
  AddProp(ss, "acceleration", ToString_PP_HardwareAcceleration(acceleration));
  AddProp(ss, "callback", ToString_PP_CompletionCallback(callback));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_CompletionCallback logging_callback;
  logging_callback.func = &Logging_PP_CompletionCallback;
  logging_callback.user_data = new PP_CompletionCallback(callback);
  logging_callback.flags = callback.flags;
  int32_t rval = ((PPB_AudioEncoder_0_1*)RealGetInterface("PPB_AudioEncoder;0.1"))->Initialize(audio_encoder, channels, input_sample_rate, input_sample_size, output_profile, initial_bitrate, acceleration, logging_callback);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t GetNumberOfSamples_0_1(PP_Resource audio_encoder) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_AudioEncoder\"");
  AddProp(ss, "__version", "\"0.1\"");
  AddProp(ss, "__method", "\"GetNumberOfSamples\"");
  AddProp(ss, "audio_encoder", ToString_PP_Resource(audio_encoder));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  int32_t rval = ((PPB_AudioEncoder_0_1*)RealGetInterface("PPB_AudioEncoder;0.1"))->GetNumberOfSamples(audio_encoder);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t GetBuffer_0_1(PP_Resource audio_encoder, PP_Resource* audio_buffer, struct PP_CompletionCallback callback) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_AudioEncoder\"");
  AddProp(ss, "__version", "\"0.1\"");
  AddProp(ss, "__method", "\"GetBuffer\"");
  AddProp(ss, "audio_encoder", ToString_PP_Resource(audio_encoder));
  AddProp(ss, "audio_buffer", PointerToString(audio_buffer));
  AddProp(ss, "callback", ToString_PP_CompletionCallback(callback));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  iterator.expectObjectAndGotoFirstProperty();
  iterator.skip();
  FromJSON_PP_Resource(iterator, *audio_buffer);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_CompletionCallback logging_callback;
  logging_callback.func = &Logging_PP_CompletionCallback;
  logging_callback.user_data = new PP_CompletionCallback(callback);
  logging_callback.flags = callback.flags;
  int32_t rval = ((PPB_AudioEncoder_0_1*)RealGetInterface("PPB_AudioEncoder;0.1"))->GetBuffer(audio_encoder, audio_buffer, logging_callback);
  printf("RPC response: [");
  printf("[");
  printf("%s", ToString_int32_t(rval).c_str());
  printf(",");
  std::stringstream os;
  BeginProps(os);
  if (!!audio_buffer) {
  AddProp(os, "audio_buffer", ToString_PP_Resource(audio_buffer));
  }
  EndProps(os);
  printf("%s]", os.str().c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t Encode_0_1(PP_Resource audio_encoder, PP_Resource audio_buffer, struct PP_CompletionCallback callback) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_AudioEncoder\"");
  AddProp(ss, "__version", "\"0.1\"");
  AddProp(ss, "__method", "\"Encode\"");
  AddProp(ss, "audio_encoder", ToString_PP_Resource(audio_encoder));
  AddProp(ss, "audio_buffer", ToString_PP_Resource(audio_buffer));
  AddProp(ss, "callback", ToString_PP_CompletionCallback(callback));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_CompletionCallback logging_callback;
  logging_callback.func = &Logging_PP_CompletionCallback;
  logging_callback.user_data = new PP_CompletionCallback(callback);
  logging_callback.flags = callback.flags;
  int32_t rval = ((PPB_AudioEncoder_0_1*)RealGetInterface("PPB_AudioEncoder;0.1"))->Encode(audio_encoder, audio_buffer, logging_callback);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t GetBitstreamBuffer_0_1(PP_Resource audio_encoder, struct PP_AudioBitstreamBuffer* bitstream_buffer, struct PP_CompletionCallback callback) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_AudioEncoder\"");
  AddProp(ss, "__version", "\"0.1\"");
  AddProp(ss, "__method", "\"GetBitstreamBuffer\"");
  AddProp(ss, "audio_encoder", ToString_PP_Resource(audio_encoder));
  AddProp(ss, "bitstream_buffer", PointerToString(bitstream_buffer));
  AddProp(ss, "callback", ToString_PP_CompletionCallback(callback));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  iterator.expectObjectAndGotoFirstProperty();
  if (!!bitstream_buffer) {
    iterator.skip();
    FromJSON_PP_AudioBitstreamBuffer(iterator, *bitstream_buffer);
  }
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_CompletionCallback logging_callback;
  logging_callback.func = &Logging_PP_CompletionCallback;
  logging_callback.user_data = new PP_CompletionCallback(callback);
  logging_callback.flags = callback.flags;
  int32_t rval = ((PPB_AudioEncoder_0_1*)RealGetInterface("PPB_AudioEncoder;0.1"))->GetBitstreamBuffer(audio_encoder, bitstream_buffer, logging_callback);
  printf("RPC response: [");
  printf("[");
  printf("%s", ToString_int32_t(rval).c_str());
  printf(",");
  std::stringstream os;
  BeginProps(os);
  if (!!bitstream_buffer) {
  AddProp(os, "bitstream_buffer", ToString_PP_AudioBitstreamBuffer(bitstream_buffer));
  }
  EndProps(os);
  printf("%s]", os.str().c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static void RecycleBitstreamBuffer_0_1(PP_Resource audio_encoder, const struct PP_AudioBitstreamBuffer* bitstream_buffer) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_AudioEncoder\"");
  AddProp(ss, "__version", "\"0.1\"");
  AddProp(ss, "__method", "\"RecycleBitstreamBuffer\"");
  AddProp(ss, "audio_encoder", ToString_PP_Resource(audio_encoder));
  AddProp(ss, "bitstream_buffer", ToString_PP_AudioBitstreamBuffer(bitstream_buffer));
  EndProps(ss);
#ifndef INTERPOSE
  RPC<MainThreadOnly>(ss);
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  ((PPB_AudioEncoder_0_1*)RealGetInterface("PPB_AudioEncoder;0.1"))->RecycleBitstreamBuffer(audio_encoder, bitstream_buffer);
#endif // !INTERPOSE
}
static void RequestBitrateChange_0_1(PP_Resource audio_encoder, uint32_t bitrate) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_AudioEncoder\"");
  AddProp(ss, "__version", "\"0.1\"");
  AddProp(ss, "__method", "\"RequestBitrateChange\"");
  AddProp(ss, "audio_encoder", ToString_PP_Resource(audio_encoder));
  AddProp(ss, "bitrate", ToString_uint32_t(bitrate));
  EndProps(ss);
#ifndef INTERPOSE
  RPC<MainThreadOnly>(ss);
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  ((PPB_AudioEncoder_0_1*)RealGetInterface("PPB_AudioEncoder;0.1"))->RequestBitrateChange(audio_encoder, bitrate);
#endif // !INTERPOSE
}
static void Close_0_1(PP_Resource audio_encoder) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_AudioEncoder\"");
  AddProp(ss, "__version", "\"0.1\"");
  AddProp(ss, "__method", "\"Close\"");
  AddProp(ss, "audio_encoder", ToString_PP_Resource(audio_encoder));
  EndProps(ss);
#ifndef INTERPOSE
  RPC<MainThreadOnly>(ss);
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  ((PPB_AudioEncoder_0_1*)RealGetInterface("PPB_AudioEncoder;0.1"))->Close(audio_encoder);
#endif // !INTERPOSE
}
}
static PPB_AudioEncoder_0_1 _PPB_AudioEncoder_0_1 = {
  ns_PPB_AudioEncoder_0_1::Create_0_1,
  ns_PPB_AudioEncoder_0_1::IsAudioEncoder_0_1,
  ns_PPB_AudioEncoder_0_1::GetSupportedProfiles_0_1,
  ns_PPB_AudioEncoder_0_1::Initialize_0_1,
  ns_PPB_AudioEncoder_0_1::GetNumberOfSamples_0_1,
  ns_PPB_AudioEncoder_0_1::GetBuffer_0_1,
  ns_PPB_AudioEncoder_0_1::Encode_0_1,
  ns_PPB_AudioEncoder_0_1::GetBitstreamBuffer_0_1,
  ns_PPB_AudioEncoder_0_1::RecycleBitstreamBuffer_0_1,
  ns_PPB_AudioEncoder_0_1::RequestBitrateChange_0_1,
  ns_PPB_AudioEncoder_0_1::Close_0_1,
};
const string ToString_PPB_AudioEncoder(const PPB_AudioEncoder_0_1 *v) {
  stringstream s;
  s << v;
  return s.str();
}
namespace ns_PPB_Compositor_0_1 {
static PP_Bool IsCompositor_0_1(PP_Resource resource) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_Compositor\"");
  AddProp(ss, "__version", "\"0.1\"");
  AddProp(ss, "__method", "\"IsCompositor\"");
  AddProp(ss, "resource", ToString_PP_Resource(resource));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  PP_Bool rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_Bool(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_Bool rval = ((PPB_Compositor_0_1*)RealGetInterface("PPB_Compositor;0.1"))->IsCompositor(resource);
  printf("RPC response: [");
  printf("%s", ToString_PP_Bool(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static PP_Resource Create_0_1(PP_Instance instance) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_Compositor\"");
  AddProp(ss, "__version", "\"0.1\"");
  AddProp(ss, "__method", "\"Create\"");
  AddProp(ss, "instance", ToString_PP_Instance(instance));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_Resource(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  int32_t rval = ((PPB_Compositor_0_1*)RealGetInterface("PPB_Compositor;0.1"))->Create(instance);
  printf("RPC response: [");
  printf("%s", ToString_PP_Resource(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static PP_Resource AddLayer_0_1(PP_Resource compositor) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_Compositor\"");
  AddProp(ss, "__version", "\"0.1\"");
  AddProp(ss, "__method", "\"AddLayer\"");
  AddProp(ss, "compositor", ToString_PP_Resource(compositor));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_Resource(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  int32_t rval = ((PPB_Compositor_0_1*)RealGetInterface("PPB_Compositor;0.1"))->AddLayer(compositor);
  printf("RPC response: [");
  printf("%s", ToString_PP_Resource(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t CommitLayers_0_1(PP_Resource compositor, struct PP_CompletionCallback cc) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_Compositor\"");
  AddProp(ss, "__version", "\"0.1\"");
  AddProp(ss, "__method", "\"CommitLayers\"");
  AddProp(ss, "compositor", ToString_PP_Resource(compositor));
  AddProp(ss, "cc", ToString_PP_CompletionCallback(cc));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_CompletionCallback logging_cc;
  logging_cc.func = &Logging_PP_CompletionCallback;
  logging_cc.user_data = new PP_CompletionCallback(cc);
  logging_cc.flags = cc.flags;
  int32_t rval = ((PPB_Compositor_0_1*)RealGetInterface("PPB_Compositor;0.1"))->CommitLayers(compositor, logging_cc);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t ResetLayers_0_1(PP_Resource compositor) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_Compositor\"");
  AddProp(ss, "__version", "\"0.1\"");
  AddProp(ss, "__method", "\"ResetLayers\"");
  AddProp(ss, "compositor", ToString_PP_Resource(compositor));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  int32_t rval = ((PPB_Compositor_0_1*)RealGetInterface("PPB_Compositor;0.1"))->ResetLayers(compositor);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
}
static PPB_Compositor_0_1 _PPB_Compositor_0_1 = {
  ns_PPB_Compositor_0_1::IsCompositor_0_1,
  ns_PPB_Compositor_0_1::Create_0_1,
  ns_PPB_Compositor_0_1::AddLayer_0_1,
  ns_PPB_Compositor_0_1::CommitLayers_0_1,
  ns_PPB_Compositor_0_1::ResetLayers_0_1,
};
const string ToString_PPB_Compositor(const PPB_Compositor_0_1 *v) {
  stringstream s;
  s << v;
  return s.str();
}
const string ToString_PP_BlendMode(const PP_BlendMode *v) {
  switch (*v) {
    case 0:
      return "\"PP_BLENDMODE_NONE\"";
    case 1:
      return "\"PP_BLENDMODE_SRC_OVER\"";
    default:
      return "\"???\"";
  }
}
const string ToString_PP_BlendMode(const PP_BlendMode &v) {
  return ToString_PP_BlendMode(&v);
}
void FromJSON_PP_BlendMode(JSONIterator& iterator, PP_BlendMode &value) {
  long int v;
  FromJSON_int(iterator, v);
  value = PP_BlendMode(v);
}
namespace ns_PPB_CompositorLayer_0_1 {
static PP_Bool IsCompositorLayer_0_1(PP_Resource resource) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_CompositorLayer\"");
  AddProp(ss, "__version", "\"0.1\"");
  AddProp(ss, "__method", "\"IsCompositorLayer\"");
  AddProp(ss, "resource", ToString_PP_Resource(resource));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  PP_Bool rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_Bool(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_Bool rval = ((PPB_CompositorLayer_0_1*)RealGetInterface("PPB_CompositorLayer;0.1"))->IsCompositorLayer(resource);
  printf("RPC response: [");
  printf("%s", ToString_PP_Bool(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t SetColor_0_1(PP_Resource layer, float red, float green, float blue, float alpha, const struct PP_Size* size) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_CompositorLayer\"");
  AddProp(ss, "__version", "\"0.1\"");
  AddProp(ss, "__method", "\"SetColor\"");
  AddProp(ss, "layer", ToString_PP_Resource(layer));
  AddProp(ss, "red", ToString_float_t(red));
  AddProp(ss, "green", ToString_float_t(green));
  AddProp(ss, "blue", ToString_float_t(blue));
  AddProp(ss, "alpha", ToString_float_t(alpha));
  AddProp(ss, "size", ToString_PP_Size(size));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  int32_t rval = ((PPB_CompositorLayer_0_1*)RealGetInterface("PPB_CompositorLayer;0.1"))->SetColor(layer, red, green, blue, alpha, size);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t SetTexture_0_1(PP_Resource layer, PP_Resource context, uint32_t texture, const struct PP_Size* size, struct PP_CompletionCallback cc) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_CompositorLayer\"");
  AddProp(ss, "__version", "\"0.1\"");
  AddProp(ss, "__method", "\"SetTexture\"");
  AddProp(ss, "layer", ToString_PP_Resource(layer));
  AddProp(ss, "context", ToString_PP_Resource(context));
  AddProp(ss, "texture", ToString_uint32_t(texture));
  AddProp(ss, "size", ToString_PP_Size(size));
  AddProp(ss, "cc", ToString_PP_CompletionCallback(cc));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_CompletionCallback logging_cc;
  logging_cc.func = &Logging_PP_CompletionCallback;
  logging_cc.user_data = new PP_CompletionCallback(cc);
  logging_cc.flags = cc.flags;
  int32_t rval = ((PPB_CompositorLayer_0_1*)RealGetInterface("PPB_CompositorLayer;0.1"))->SetTexture(layer, context, texture, size, logging_cc);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
/* skipping SetTexture */
static int32_t SetImage_0_1(PP_Resource layer, PP_Resource image_data, const struct PP_Size* size, struct PP_CompletionCallback cc) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_CompositorLayer\"");
  AddProp(ss, "__version", "\"0.1\"");
  AddProp(ss, "__method", "\"SetImage\"");
  AddProp(ss, "layer", ToString_PP_Resource(layer));
  AddProp(ss, "image_data", ToString_PP_Resource(image_data));
  AddProp(ss, "size", ToString_PP_Size(size));
  AddProp(ss, "cc", ToString_PP_CompletionCallback(cc));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_CompletionCallback logging_cc;
  logging_cc.func = &Logging_PP_CompletionCallback;
  logging_cc.user_data = new PP_CompletionCallback(cc);
  logging_cc.flags = cc.flags;
  int32_t rval = ((PPB_CompositorLayer_0_1*)RealGetInterface("PPB_CompositorLayer;0.1"))->SetImage(layer, image_data, size, logging_cc);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t SetClipRect_0_1(PP_Resource layer, const struct PP_Rect* rect) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_CompositorLayer\"");
  AddProp(ss, "__version", "\"0.1\"");
  AddProp(ss, "__method", "\"SetClipRect\"");
  AddProp(ss, "layer", ToString_PP_Resource(layer));
  AddProp(ss, "rect", ToString_PP_Rect(rect));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  int32_t rval = ((PPB_CompositorLayer_0_1*)RealGetInterface("PPB_CompositorLayer;0.1"))->SetClipRect(layer, rect);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t SetTransform_0_1(PP_Resource layer, const float matrix[16]) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_CompositorLayer\"");
  AddProp(ss, "__version", "\"0.1\"");
  AddProp(ss, "__method", "\"SetTransform\"");
  AddProp(ss, "layer", ToString_PP_Resource(layer));
  {
    BeginProp(ss, "matrix");
    BeginElements(ss);
    for (uint32_t _n = 0; _n < 16; ++_n) {
      AddElement(ss, ToString_float_t(matrix[_n]));
    }
    EndElements(ss);
  }
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  int32_t rval = ((PPB_CompositorLayer_0_1*)RealGetInterface("PPB_CompositorLayer;0.1"))->SetTransform(layer, matrix);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t SetOpacity_0_1(PP_Resource layer, float opacity) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_CompositorLayer\"");
  AddProp(ss, "__version", "\"0.1\"");
  AddProp(ss, "__method", "\"SetOpacity\"");
  AddProp(ss, "layer", ToString_PP_Resource(layer));
  AddProp(ss, "opacity", ToString_float_t(opacity));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  int32_t rval = ((PPB_CompositorLayer_0_1*)RealGetInterface("PPB_CompositorLayer;0.1"))->SetOpacity(layer, opacity);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t SetBlendMode_0_1(PP_Resource layer, PP_BlendMode mode) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_CompositorLayer\"");
  AddProp(ss, "__version", "\"0.1\"");
  AddProp(ss, "__method", "\"SetBlendMode\"");
  AddProp(ss, "layer", ToString_PP_Resource(layer));
  AddProp(ss, "mode", ToString_PP_BlendMode(mode));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  int32_t rval = ((PPB_CompositorLayer_0_1*)RealGetInterface("PPB_CompositorLayer;0.1"))->SetBlendMode(layer, mode);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t SetSourceRect_0_1(PP_Resource layer, const struct PP_FloatRect* rect) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_CompositorLayer\"");
  AddProp(ss, "__version", "\"0.1\"");
  AddProp(ss, "__method", "\"SetSourceRect\"");
  AddProp(ss, "layer", ToString_PP_Resource(layer));
  AddProp(ss, "rect", ToString_PP_FloatRect(rect));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  int32_t rval = ((PPB_CompositorLayer_0_1*)RealGetInterface("PPB_CompositorLayer;0.1"))->SetSourceRect(layer, rect);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t SetPremultipliedAlpha_0_1(PP_Resource layer, PP_Bool premult) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_CompositorLayer\"");
  AddProp(ss, "__version", "\"0.1\"");
  AddProp(ss, "__method", "\"SetPremultipliedAlpha\"");
  AddProp(ss, "layer", ToString_PP_Resource(layer));
  AddProp(ss, "premult", ToString_PP_Bool(premult));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  int32_t rval = ((PPB_CompositorLayer_0_1*)RealGetInterface("PPB_CompositorLayer;0.1"))->SetPremultipliedAlpha(layer, premult);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
}
static PPB_CompositorLayer_0_1 _PPB_CompositorLayer_0_1 = {
  ns_PPB_CompositorLayer_0_1::IsCompositorLayer_0_1,
  ns_PPB_CompositorLayer_0_1::SetColor_0_1,
  ns_PPB_CompositorLayer_0_1::SetTexture_0_1,
  ns_PPB_CompositorLayer_0_1::SetImage_0_1,
  ns_PPB_CompositorLayer_0_1::SetClipRect_0_1,
  ns_PPB_CompositorLayer_0_1::SetTransform_0_1,
  ns_PPB_CompositorLayer_0_1::SetOpacity_0_1,
  ns_PPB_CompositorLayer_0_1::SetBlendMode_0_1,
  ns_PPB_CompositorLayer_0_1::SetSourceRect_0_1,
  ns_PPB_CompositorLayer_0_1::SetPremultipliedAlpha_0_1,
};
const string ToString_PPB_CompositorLayer(const PPB_CompositorLayer_0_1 *v) {
  stringstream s;
  s << v;
  return s.str();
}
namespace ns_PPB_CompositorLayer_0_2 {
static PP_Bool IsCompositorLayer_0_2(PP_Resource resource) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_CompositorLayer\"");
  AddProp(ss, "__version", "\"0.2\"");
  AddProp(ss, "__method", "\"IsCompositorLayer\"");
  AddProp(ss, "resource", ToString_PP_Resource(resource));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  PP_Bool rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_Bool(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_Bool rval = ((PPB_CompositorLayer_0_2*)RealGetInterface("PPB_CompositorLayer;0.2"))->IsCompositorLayer(resource);
  printf("RPC response: [");
  printf("%s", ToString_PP_Bool(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t SetColor_0_2(PP_Resource layer, float red, float green, float blue, float alpha, const struct PP_Size* size) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_CompositorLayer\"");
  AddProp(ss, "__version", "\"0.2\"");
  AddProp(ss, "__method", "\"SetColor\"");
  AddProp(ss, "layer", ToString_PP_Resource(layer));
  AddProp(ss, "red", ToString_float_t(red));
  AddProp(ss, "green", ToString_float_t(green));
  AddProp(ss, "blue", ToString_float_t(blue));
  AddProp(ss, "alpha", ToString_float_t(alpha));
  AddProp(ss, "size", ToString_PP_Size(size));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  int32_t rval = ((PPB_CompositorLayer_0_2*)RealGetInterface("PPB_CompositorLayer;0.2"))->SetColor(layer, red, green, blue, alpha, size);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
/* skipping SetTexture */
static int32_t SetTexture_0_2(PP_Resource layer, PP_Resource context, uint32_t target, uint32_t texture, const struct PP_Size* size, struct PP_CompletionCallback cc) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_CompositorLayer\"");
  AddProp(ss, "__version", "\"0.2\"");
  AddProp(ss, "__method", "\"SetTexture\"");
  AddProp(ss, "layer", ToString_PP_Resource(layer));
  AddProp(ss, "context", ToString_PP_Resource(context));
  AddProp(ss, "target", ToString_uint32_t(target));
  AddProp(ss, "texture", ToString_uint32_t(texture));
  AddProp(ss, "size", ToString_PP_Size(size));
  AddProp(ss, "cc", ToString_PP_CompletionCallback(cc));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_CompletionCallback logging_cc;
  logging_cc.func = &Logging_PP_CompletionCallback;
  logging_cc.user_data = new PP_CompletionCallback(cc);
  logging_cc.flags = cc.flags;
  int32_t rval = ((PPB_CompositorLayer_0_2*)RealGetInterface("PPB_CompositorLayer;0.2"))->SetTexture(layer, context, target, texture, size, logging_cc);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t SetImage_0_2(PP_Resource layer, PP_Resource image_data, const struct PP_Size* size, struct PP_CompletionCallback cc) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_CompositorLayer\"");
  AddProp(ss, "__version", "\"0.2\"");
  AddProp(ss, "__method", "\"SetImage\"");
  AddProp(ss, "layer", ToString_PP_Resource(layer));
  AddProp(ss, "image_data", ToString_PP_Resource(image_data));
  AddProp(ss, "size", ToString_PP_Size(size));
  AddProp(ss, "cc", ToString_PP_CompletionCallback(cc));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_CompletionCallback logging_cc;
  logging_cc.func = &Logging_PP_CompletionCallback;
  logging_cc.user_data = new PP_CompletionCallback(cc);
  logging_cc.flags = cc.flags;
  int32_t rval = ((PPB_CompositorLayer_0_2*)RealGetInterface("PPB_CompositorLayer;0.2"))->SetImage(layer, image_data, size, logging_cc);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t SetClipRect_0_2(PP_Resource layer, const struct PP_Rect* rect) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_CompositorLayer\"");
  AddProp(ss, "__version", "\"0.2\"");
  AddProp(ss, "__method", "\"SetClipRect\"");
  AddProp(ss, "layer", ToString_PP_Resource(layer));
  AddProp(ss, "rect", ToString_PP_Rect(rect));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  int32_t rval = ((PPB_CompositorLayer_0_2*)RealGetInterface("PPB_CompositorLayer;0.2"))->SetClipRect(layer, rect);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t SetTransform_0_2(PP_Resource layer, const float matrix[16]) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_CompositorLayer\"");
  AddProp(ss, "__version", "\"0.2\"");
  AddProp(ss, "__method", "\"SetTransform\"");
  AddProp(ss, "layer", ToString_PP_Resource(layer));
  {
    BeginProp(ss, "matrix");
    BeginElements(ss);
    for (uint32_t _n = 0; _n < 16; ++_n) {
      AddElement(ss, ToString_float_t(matrix[_n]));
    }
    EndElements(ss);
  }
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  int32_t rval = ((PPB_CompositorLayer_0_2*)RealGetInterface("PPB_CompositorLayer;0.2"))->SetTransform(layer, matrix);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t SetOpacity_0_2(PP_Resource layer, float opacity) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_CompositorLayer\"");
  AddProp(ss, "__version", "\"0.2\"");
  AddProp(ss, "__method", "\"SetOpacity\"");
  AddProp(ss, "layer", ToString_PP_Resource(layer));
  AddProp(ss, "opacity", ToString_float_t(opacity));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  int32_t rval = ((PPB_CompositorLayer_0_2*)RealGetInterface("PPB_CompositorLayer;0.2"))->SetOpacity(layer, opacity);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t SetBlendMode_0_2(PP_Resource layer, PP_BlendMode mode) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_CompositorLayer\"");
  AddProp(ss, "__version", "\"0.2\"");
  AddProp(ss, "__method", "\"SetBlendMode\"");
  AddProp(ss, "layer", ToString_PP_Resource(layer));
  AddProp(ss, "mode", ToString_PP_BlendMode(mode));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  int32_t rval = ((PPB_CompositorLayer_0_2*)RealGetInterface("PPB_CompositorLayer;0.2"))->SetBlendMode(layer, mode);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t SetSourceRect_0_2(PP_Resource layer, const struct PP_FloatRect* rect) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_CompositorLayer\"");
  AddProp(ss, "__version", "\"0.2\"");
  AddProp(ss, "__method", "\"SetSourceRect\"");
  AddProp(ss, "layer", ToString_PP_Resource(layer));
  AddProp(ss, "rect", ToString_PP_FloatRect(rect));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  int32_t rval = ((PPB_CompositorLayer_0_2*)RealGetInterface("PPB_CompositorLayer;0.2"))->SetSourceRect(layer, rect);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t SetPremultipliedAlpha_0_2(PP_Resource layer, PP_Bool premult) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_CompositorLayer\"");
  AddProp(ss, "__version", "\"0.2\"");
  AddProp(ss, "__method", "\"SetPremultipliedAlpha\"");
  AddProp(ss, "layer", ToString_PP_Resource(layer));
  AddProp(ss, "premult", ToString_PP_Bool(premult));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  int32_t rval = ((PPB_CompositorLayer_0_2*)RealGetInterface("PPB_CompositorLayer;0.2"))->SetPremultipliedAlpha(layer, premult);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
}
static PPB_CompositorLayer_0_2 _PPB_CompositorLayer_0_2 = {
  ns_PPB_CompositorLayer_0_2::IsCompositorLayer_0_2,
  ns_PPB_CompositorLayer_0_2::SetColor_0_2,
  ns_PPB_CompositorLayer_0_2::SetTexture_0_2,
  ns_PPB_CompositorLayer_0_2::SetImage_0_2,
  ns_PPB_CompositorLayer_0_2::SetClipRect_0_2,
  ns_PPB_CompositorLayer_0_2::SetTransform_0_2,
  ns_PPB_CompositorLayer_0_2::SetOpacity_0_2,
  ns_PPB_CompositorLayer_0_2::SetBlendMode_0_2,
  ns_PPB_CompositorLayer_0_2::SetSourceRect_0_2,
  ns_PPB_CompositorLayer_0_2::SetPremultipliedAlpha_0_2,
};
const string ToString_PPB_CompositorLayer(const PPB_CompositorLayer_0_2 *v) {
  stringstream s;
  s << v;
  return s.str();
}
const string ToString_PP_LogLevel(const PP_LogLevel *v) {
  switch (*v) {
    case 0:
      return "\"PP_LOGLEVEL_TIP\"";
    case 1:
      return "\"PP_LOGLEVEL_LOG\"";
    case 2:
      return "\"PP_LOGLEVEL_WARNING\"";
    case 3:
      return "\"PP_LOGLEVEL_ERROR\"";
    default:
      return "\"???\"";
  }
}
const string ToString_PP_LogLevel(const PP_LogLevel &v) {
  return ToString_PP_LogLevel(&v);
}
void FromJSON_PP_LogLevel(JSONIterator& iterator, PP_LogLevel &value) {
  long int v;
  FromJSON_int(iterator, v);
  value = PP_LogLevel(v);
}
namespace ns_PPB_Console_1_0 {
static void Log_1_0(PP_Instance instance, PP_LogLevel level, struct PP_Var value) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_Console\"");
  AddProp(ss, "__version", "\"1.0\"");
  AddProp(ss, "__method", "\"Log\"");
  AddProp(ss, "instance", ToString_PP_Instance(instance));
  AddProp(ss, "level", ToString_PP_LogLevel(level));
  AddProp(ss, "value", ToString_PP_Var(value));
  EndProps(ss);
#ifndef INTERPOSE
  RPC<MainThreadOnly>(ss);
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  ((PPB_Console_1_0*)RealGetInterface("PPB_Console;1.0"))->Log(instance, level, value);
#endif // !INTERPOSE
}
static void LogWithSource_1_0(PP_Instance instance, PP_LogLevel level, struct PP_Var source, struct PP_Var value) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_Console\"");
  AddProp(ss, "__version", "\"1.0\"");
  AddProp(ss, "__method", "\"LogWithSource\"");
  AddProp(ss, "instance", ToString_PP_Instance(instance));
  AddProp(ss, "level", ToString_PP_LogLevel(level));
  AddProp(ss, "source", ToString_PP_Var(source));
  AddProp(ss, "value", ToString_PP_Var(value));
  EndProps(ss);
#ifndef INTERPOSE
  RPC<MainThreadOnly>(ss);
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  ((PPB_Console_1_0*)RealGetInterface("PPB_Console;1.0"))->LogWithSource(instance, level, source, value);
#endif // !INTERPOSE
}
}
static PPB_Console_1_0 _PPB_Console_1_0 = {
  ns_PPB_Console_1_0::Log_1_0,
  ns_PPB_Console_1_0::LogWithSource_1_0,
};
const string ToString_PPB_Console(const PPB_Console_1_0 *v) {
  stringstream s;
  s << v;
  return s.str();
}
namespace ns_PPB_Core_1_0 {
static void AddRefResource_1_0(PP_Resource resource) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_Core\"");
  AddProp(ss, "__version", "\"1.0\"");
  AddProp(ss, "__method", "\"AddRefResource\"");
  AddProp(ss, "resource", ToString_PP_Resource(resource));
  EndProps(ss);
#ifndef INTERPOSE
  RPC<MainThreadOnly>(ss);
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  ((PPB_Core_1_0*)RealGetInterface("PPB_Core;1.0"))->AddRefResource(resource);
#endif // !INTERPOSE
}
static void ReleaseResource_1_0(PP_Resource resource) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_Core\"");
  AddProp(ss, "__version", "\"1.0\"");
  AddProp(ss, "__method", "\"ReleaseResource\"");
  AddProp(ss, "resource", ToString_PP_Resource(resource));
  EndProps(ss);
#ifndef INTERPOSE
  RPC<MainThreadOnly>(ss);
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  ((PPB_Core_1_0*)RealGetInterface("PPB_Core;1.0"))->ReleaseResource(resource);
#endif // !INTERPOSE
}
static PP_Time GetTime_1_0(void) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_Core\"");
  AddProp(ss, "__version", "\"1.0\"");
  AddProp(ss, "__method", "\"GetTime\"");
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  double rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_Time(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  double rval = ((PPB_Core_1_0*)RealGetInterface("PPB_Core;1.0"))->GetTime();
  printf("RPC response: [");
  printf("%s", ToString_PP_Time(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static PP_TimeTicks GetTimeTicks_1_0(void) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_Core\"");
  AddProp(ss, "__version", "\"1.0\"");
  AddProp(ss, "__method", "\"GetTimeTicks\"");
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  double rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_TimeTicks(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  double rval = ((PPB_Core_1_0*)RealGetInterface("PPB_Core;1.0"))->GetTimeTicks();
  printf("RPC response: [");
  printf("%s", ToString_PP_TimeTicks(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static void CallOnMainThread_1_0(int32_t delay_in_milliseconds, struct PP_CompletionCallback callback, int32_t result) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_Core\"");
  AddProp(ss, "__version", "\"1.0\"");
  AddProp(ss, "__method", "\"CallOnMainThread\"");
  AddProp(ss, "delay_in_milliseconds", ToString_int32_t(delay_in_milliseconds));
  AddProp(ss, "callback", ToString_PP_CompletionCallback(callback));
  AddProp(ss, "result", ToString_int32_t(result));
  EndProps(ss);
#ifndef INTERPOSE
  RPC<MaybeNonMainThread>(ss);
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_CompletionCallback logging_callback;
  logging_callback.func = &Logging_PP_CompletionCallback;
  logging_callback.user_data = new PP_CompletionCallback(callback);
  logging_callback.flags = callback.flags;
  ((PPB_Core_1_0*)RealGetInterface("PPB_Core;1.0"))->CallOnMainThread(delay_in_milliseconds, logging_callback, result);
#endif // !INTERPOSE
}
static PP_Bool IsMainThread_1_0(void) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_Core\"");
  AddProp(ss, "__version", "\"1.0\"");
  AddProp(ss, "__method", "\"IsMainThread\"");
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MaybeNonMainThread>(ss);
  PP_Bool rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_Bool(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_Bool rval = ((PPB_Core_1_0*)RealGetInterface("PPB_Core;1.0"))->IsMainThread();
  printf("RPC response: [");
  printf("%s", ToString_PP_Bool(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
}
static PPB_Core_1_0 _PPB_Core_1_0 = {
  ns_PPB_Core_1_0::AddRefResource_1_0,
  ns_PPB_Core_1_0::ReleaseResource_1_0,
  ns_PPB_Core_1_0::GetTime_1_0,
  ns_PPB_Core_1_0::GetTimeTicks_1_0,
  ns_PPB_Core_1_0::CallOnMainThread_1_0,
  ns_PPB_Core_1_0::IsMainThread_1_0,
};
const string ToString_PPB_Core(const PPB_Core_1_0 *v) {
  stringstream s;
  s << v;
  return s.str();
}
const string ToString_PP_FileOpenFlags(const PP_FileOpenFlags *v) {
  switch (*v) {
    case 1 << 0:
      return "\"PP_FILEOPENFLAG_READ\"";
    case 1 << 1:
      return "\"PP_FILEOPENFLAG_WRITE\"";
    case 1 << 2:
      return "\"PP_FILEOPENFLAG_CREATE\"";
    case 1 << 3:
      return "\"PP_FILEOPENFLAG_TRUNCATE\"";
    case 1 << 4:
      return "\"PP_FILEOPENFLAG_EXCLUSIVE\"";
    case 1 << 5:
      return "\"PP_FILEOPENFLAG_APPEND\"";
    default:
      return "\"???\"";
  }
}
const string ToString_PP_FileOpenFlags(const PP_FileOpenFlags &v) {
  return ToString_PP_FileOpenFlags(&v);
}
void FromJSON_PP_FileOpenFlags(JSONIterator& iterator, PP_FileOpenFlags &value) {
  long int v;
  FromJSON_int(iterator, v);
  value = PP_FileOpenFlags(v);
}
namespace ns_PPB_FileIO_1_0 {
static PP_Resource Create_1_0(PP_Instance instance) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileIO\"");
  AddProp(ss, "__version", "\"1.0\"");
  AddProp(ss, "__method", "\"Create\"");
  AddProp(ss, "instance", ToString_PP_Instance(instance));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_Resource(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  int32_t rval = ((PPB_FileIO_1_0*)RealGetInterface("PPB_FileIO;1.0"))->Create(instance);
  printf("RPC response: [");
  printf("%s", ToString_PP_Resource(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static PP_Bool IsFileIO_1_0(PP_Resource resource) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileIO\"");
  AddProp(ss, "__version", "\"1.0\"");
  AddProp(ss, "__method", "\"IsFileIO\"");
  AddProp(ss, "resource", ToString_PP_Resource(resource));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  PP_Bool rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_Bool(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_Bool rval = ((PPB_FileIO_1_0*)RealGetInterface("PPB_FileIO;1.0"))->IsFileIO(resource);
  printf("RPC response: [");
  printf("%s", ToString_PP_Bool(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t Open_1_0(PP_Resource file_io, PP_Resource file_ref, int32_t open_flags, struct PP_CompletionCallback callback) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileIO\"");
  AddProp(ss, "__version", "\"1.0\"");
  AddProp(ss, "__method", "\"Open\"");
  AddProp(ss, "file_io", ToString_PP_Resource(file_io));
  AddProp(ss, "file_ref", ToString_PP_Resource(file_ref));
  AddProp(ss, "open_flags", ToString_int32_t(open_flags));
  AddProp(ss, "callback", ToString_PP_CompletionCallback(callback));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_CompletionCallback logging_callback;
  logging_callback.func = &Logging_PP_CompletionCallback;
  logging_callback.user_data = new PP_CompletionCallback(callback);
  logging_callback.flags = callback.flags;
  int32_t rval = ((PPB_FileIO_1_0*)RealGetInterface("PPB_FileIO;1.0"))->Open(file_io, file_ref, open_flags, logging_callback);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t Query_1_0(PP_Resource file_io, struct PP_FileInfo* info, struct PP_CompletionCallback callback) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileIO\"");
  AddProp(ss, "__version", "\"1.0\"");
  AddProp(ss, "__method", "\"Query\"");
  AddProp(ss, "file_io", ToString_PP_Resource(file_io));
  AddProp(ss, "info", PointerToString(info));
  AddProp(ss, "callback", ToString_PP_CompletionCallback(callback));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  iterator.expectObjectAndGotoFirstProperty();
  if (!!info) {
    iterator.skip();
    FromJSON_PP_FileInfo(iterator, *info);
  }
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_CompletionCallback logging_callback;
  logging_callback.func = &Logging_PP_CompletionCallback;
  logging_callback.user_data = new PP_CompletionCallback(callback);
  logging_callback.flags = callback.flags;
  int32_t rval = ((PPB_FileIO_1_0*)RealGetInterface("PPB_FileIO;1.0"))->Query(file_io, info, logging_callback);
  printf("RPC response: [");
  printf("[");
  printf("%s", ToString_int32_t(rval).c_str());
  printf(",");
  std::stringstream os;
  BeginProps(os);
  if (!!info) {
  AddProp(os, "info", ToString_PP_FileInfo(info));
  }
  EndProps(os);
  printf("%s]", os.str().c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t Touch_1_0(PP_Resource file_io, PP_Time last_access_time, PP_Time last_modified_time, struct PP_CompletionCallback callback) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileIO\"");
  AddProp(ss, "__version", "\"1.0\"");
  AddProp(ss, "__method", "\"Touch\"");
  AddProp(ss, "file_io", ToString_PP_Resource(file_io));
  AddProp(ss, "last_access_time", ToString_PP_Time(last_access_time));
  AddProp(ss, "last_modified_time", ToString_PP_Time(last_modified_time));
  AddProp(ss, "callback", ToString_PP_CompletionCallback(callback));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_CompletionCallback logging_callback;
  logging_callback.func = &Logging_PP_CompletionCallback;
  logging_callback.user_data = new PP_CompletionCallback(callback);
  logging_callback.flags = callback.flags;
  int32_t rval = ((PPB_FileIO_1_0*)RealGetInterface("PPB_FileIO;1.0"))->Touch(file_io, last_access_time, last_modified_time, logging_callback);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t Read_1_0(PP_Resource file_io, int64_t offset, char* buffer, int32_t bytes_to_read, struct PP_CompletionCallback callback) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileIO\"");
  AddProp(ss, "__version", "\"1.0\"");
  AddProp(ss, "__method", "\"Read\"");
  AddProp(ss, "file_io", ToString_PP_Resource(file_io));
  AddProp(ss, "offset", ToString_int64_t(offset));
  AddProp(ss, "buffer", ToString_str_t(buffer));
  AddProp(ss, "bytes_to_read", ToString_int32_t(bytes_to_read));
  AddProp(ss, "callback", ToString_PP_CompletionCallback(callback));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  iterator.expectObjectAndGotoFirstProperty();
  iterator.skip();
  FromJSON_str_t(iterator, buffer);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_CompletionCallback logging_callback;
  logging_callback.func = &Logging_PP_CompletionCallback;
  logging_callback.user_data = new PP_CompletionCallback(callback);
  logging_callback.flags = callback.flags;
  int32_t rval = ((PPB_FileIO_1_0*)RealGetInterface("PPB_FileIO;1.0"))->Read(file_io, offset, buffer, bytes_to_read, logging_callback);
  printf("RPC response: [");
  printf("[");
  printf("%s", ToString_int32_t(rval).c_str());
  printf(",");
  std::stringstream os;
  BeginProps(os);
  AddProp(os, "buffer", ToString_str_t(buffer));
  EndProps(os);
  printf("%s]", os.str().c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t Write_1_0(PP_Resource file_io, int64_t offset, const char* buffer, int32_t bytes_to_write, struct PP_CompletionCallback callback) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileIO\"");
  AddProp(ss, "__version", "\"1.0\"");
  AddProp(ss, "__method", "\"Write\"");
  AddProp(ss, "file_io", ToString_PP_Resource(file_io));
  AddProp(ss, "offset", ToString_int64_t(offset));
  AddProp(ss, "buffer", ToString_str_t(buffer));
  AddProp(ss, "bytes_to_write", ToString_int32_t(bytes_to_write));
  AddProp(ss, "callback", ToString_PP_CompletionCallback(callback));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_CompletionCallback logging_callback;
  logging_callback.func = &Logging_PP_CompletionCallback;
  logging_callback.user_data = new PP_CompletionCallback(callback);
  logging_callback.flags = callback.flags;
  int32_t rval = ((PPB_FileIO_1_0*)RealGetInterface("PPB_FileIO;1.0"))->Write(file_io, offset, buffer, bytes_to_write, logging_callback);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t SetLength_1_0(PP_Resource file_io, int64_t length, struct PP_CompletionCallback callback) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileIO\"");
  AddProp(ss, "__version", "\"1.0\"");
  AddProp(ss, "__method", "\"SetLength\"");
  AddProp(ss, "file_io", ToString_PP_Resource(file_io));
  AddProp(ss, "length", ToString_int64_t(length));
  AddProp(ss, "callback", ToString_PP_CompletionCallback(callback));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_CompletionCallback logging_callback;
  logging_callback.func = &Logging_PP_CompletionCallback;
  logging_callback.user_data = new PP_CompletionCallback(callback);
  logging_callback.flags = callback.flags;
  int32_t rval = ((PPB_FileIO_1_0*)RealGetInterface("PPB_FileIO;1.0"))->SetLength(file_io, length, logging_callback);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t Flush_1_0(PP_Resource file_io, struct PP_CompletionCallback callback) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileIO\"");
  AddProp(ss, "__version", "\"1.0\"");
  AddProp(ss, "__method", "\"Flush\"");
  AddProp(ss, "file_io", ToString_PP_Resource(file_io));
  AddProp(ss, "callback", ToString_PP_CompletionCallback(callback));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_CompletionCallback logging_callback;
  logging_callback.func = &Logging_PP_CompletionCallback;
  logging_callback.user_data = new PP_CompletionCallback(callback);
  logging_callback.flags = callback.flags;
  int32_t rval = ((PPB_FileIO_1_0*)RealGetInterface("PPB_FileIO;1.0"))->Flush(file_io, logging_callback);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static void Close_1_0(PP_Resource file_io) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileIO\"");
  AddProp(ss, "__version", "\"1.0\"");
  AddProp(ss, "__method", "\"Close\"");
  AddProp(ss, "file_io", ToString_PP_Resource(file_io));
  EndProps(ss);
#ifndef INTERPOSE
  RPC<MainThreadOnly>(ss);
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  ((PPB_FileIO_1_0*)RealGetInterface("PPB_FileIO;1.0"))->Close(file_io);
#endif // !INTERPOSE
}
/* skipping ReadToArray */
}
static PPB_FileIO_1_0 _PPB_FileIO_1_0 = {
  ns_PPB_FileIO_1_0::Create_1_0,
  ns_PPB_FileIO_1_0::IsFileIO_1_0,
  ns_PPB_FileIO_1_0::Open_1_0,
  ns_PPB_FileIO_1_0::Query_1_0,
  ns_PPB_FileIO_1_0::Touch_1_0,
  ns_PPB_FileIO_1_0::Read_1_0,
  ns_PPB_FileIO_1_0::Write_1_0,
  ns_PPB_FileIO_1_0::SetLength_1_0,
  ns_PPB_FileIO_1_0::Flush_1_0,
  ns_PPB_FileIO_1_0::Close_1_0,
};
const string ToString_PPB_FileIO(const PPB_FileIO_1_0 *v) {
  stringstream s;
  s << v;
  return s.str();
}
namespace ns_PPB_FileIO_1_1 {
static PP_Resource Create_1_1(PP_Instance instance) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileIO\"");
  AddProp(ss, "__version", "\"1.1\"");
  AddProp(ss, "__method", "\"Create\"");
  AddProp(ss, "instance", ToString_PP_Instance(instance));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_Resource(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  int32_t rval = ((PPB_FileIO_1_1*)RealGetInterface("PPB_FileIO;1.1"))->Create(instance);
  printf("RPC response: [");
  printf("%s", ToString_PP_Resource(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static PP_Bool IsFileIO_1_1(PP_Resource resource) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileIO\"");
  AddProp(ss, "__version", "\"1.1\"");
  AddProp(ss, "__method", "\"IsFileIO\"");
  AddProp(ss, "resource", ToString_PP_Resource(resource));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  PP_Bool rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_Bool(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_Bool rval = ((PPB_FileIO_1_1*)RealGetInterface("PPB_FileIO;1.1"))->IsFileIO(resource);
  printf("RPC response: [");
  printf("%s", ToString_PP_Bool(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t Open_1_1(PP_Resource file_io, PP_Resource file_ref, int32_t open_flags, struct PP_CompletionCallback callback) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileIO\"");
  AddProp(ss, "__version", "\"1.1\"");
  AddProp(ss, "__method", "\"Open\"");
  AddProp(ss, "file_io", ToString_PP_Resource(file_io));
  AddProp(ss, "file_ref", ToString_PP_Resource(file_ref));
  AddProp(ss, "open_flags", ToString_int32_t(open_flags));
  AddProp(ss, "callback", ToString_PP_CompletionCallback(callback));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_CompletionCallback logging_callback;
  logging_callback.func = &Logging_PP_CompletionCallback;
  logging_callback.user_data = new PP_CompletionCallback(callback);
  logging_callback.flags = callback.flags;
  int32_t rval = ((PPB_FileIO_1_1*)RealGetInterface("PPB_FileIO;1.1"))->Open(file_io, file_ref, open_flags, logging_callback);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t Query_1_1(PP_Resource file_io, struct PP_FileInfo* info, struct PP_CompletionCallback callback) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileIO\"");
  AddProp(ss, "__version", "\"1.1\"");
  AddProp(ss, "__method", "\"Query\"");
  AddProp(ss, "file_io", ToString_PP_Resource(file_io));
  AddProp(ss, "info", PointerToString(info));
  AddProp(ss, "callback", ToString_PP_CompletionCallback(callback));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  iterator.expectObjectAndGotoFirstProperty();
  if (!!info) {
    iterator.skip();
    FromJSON_PP_FileInfo(iterator, *info);
  }
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_CompletionCallback logging_callback;
  logging_callback.func = &Logging_PP_CompletionCallback;
  logging_callback.user_data = new PP_CompletionCallback(callback);
  logging_callback.flags = callback.flags;
  int32_t rval = ((PPB_FileIO_1_1*)RealGetInterface("PPB_FileIO;1.1"))->Query(file_io, info, logging_callback);
  printf("RPC response: [");
  printf("[");
  printf("%s", ToString_int32_t(rval).c_str());
  printf(",");
  std::stringstream os;
  BeginProps(os);
  if (!!info) {
  AddProp(os, "info", ToString_PP_FileInfo(info));
  }
  EndProps(os);
  printf("%s]", os.str().c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t Touch_1_1(PP_Resource file_io, PP_Time last_access_time, PP_Time last_modified_time, struct PP_CompletionCallback callback) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileIO\"");
  AddProp(ss, "__version", "\"1.1\"");
  AddProp(ss, "__method", "\"Touch\"");
  AddProp(ss, "file_io", ToString_PP_Resource(file_io));
  AddProp(ss, "last_access_time", ToString_PP_Time(last_access_time));
  AddProp(ss, "last_modified_time", ToString_PP_Time(last_modified_time));
  AddProp(ss, "callback", ToString_PP_CompletionCallback(callback));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_CompletionCallback logging_callback;
  logging_callback.func = &Logging_PP_CompletionCallback;
  logging_callback.user_data = new PP_CompletionCallback(callback);
  logging_callback.flags = callback.flags;
  int32_t rval = ((PPB_FileIO_1_1*)RealGetInterface("PPB_FileIO;1.1"))->Touch(file_io, last_access_time, last_modified_time, logging_callback);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t Read_1_1(PP_Resource file_io, int64_t offset, char* buffer, int32_t bytes_to_read, struct PP_CompletionCallback callback) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileIO\"");
  AddProp(ss, "__version", "\"1.1\"");
  AddProp(ss, "__method", "\"Read\"");
  AddProp(ss, "file_io", ToString_PP_Resource(file_io));
  AddProp(ss, "offset", ToString_int64_t(offset));
  AddProp(ss, "buffer", ToString_str_t(buffer));
  AddProp(ss, "bytes_to_read", ToString_int32_t(bytes_to_read));
  AddProp(ss, "callback", ToString_PP_CompletionCallback(callback));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  iterator.expectObjectAndGotoFirstProperty();
  iterator.skip();
  FromJSON_str_t(iterator, buffer);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_CompletionCallback logging_callback;
  logging_callback.func = &Logging_PP_CompletionCallback;
  logging_callback.user_data = new PP_CompletionCallback(callback);
  logging_callback.flags = callback.flags;
  int32_t rval = ((PPB_FileIO_1_1*)RealGetInterface("PPB_FileIO;1.1"))->Read(file_io, offset, buffer, bytes_to_read, logging_callback);
  printf("RPC response: [");
  printf("[");
  printf("%s", ToString_int32_t(rval).c_str());
  printf(",");
  std::stringstream os;
  BeginProps(os);
  AddProp(os, "buffer", ToString_str_t(buffer));
  EndProps(os);
  printf("%s]", os.str().c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t Write_1_1(PP_Resource file_io, int64_t offset, const char* buffer, int32_t bytes_to_write, struct PP_CompletionCallback callback) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileIO\"");
  AddProp(ss, "__version", "\"1.1\"");
  AddProp(ss, "__method", "\"Write\"");
  AddProp(ss, "file_io", ToString_PP_Resource(file_io));
  AddProp(ss, "offset", ToString_int64_t(offset));
  AddProp(ss, "buffer", ToString_str_t(buffer));
  AddProp(ss, "bytes_to_write", ToString_int32_t(bytes_to_write));
  AddProp(ss, "callback", ToString_PP_CompletionCallback(callback));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_CompletionCallback logging_callback;
  logging_callback.func = &Logging_PP_CompletionCallback;
  logging_callback.user_data = new PP_CompletionCallback(callback);
  logging_callback.flags = callback.flags;
  int32_t rval = ((PPB_FileIO_1_1*)RealGetInterface("PPB_FileIO;1.1"))->Write(file_io, offset, buffer, bytes_to_write, logging_callback);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t SetLength_1_1(PP_Resource file_io, int64_t length, struct PP_CompletionCallback callback) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileIO\"");
  AddProp(ss, "__version", "\"1.1\"");
  AddProp(ss, "__method", "\"SetLength\"");
  AddProp(ss, "file_io", ToString_PP_Resource(file_io));
  AddProp(ss, "length", ToString_int64_t(length));
  AddProp(ss, "callback", ToString_PP_CompletionCallback(callback));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_CompletionCallback logging_callback;
  logging_callback.func = &Logging_PP_CompletionCallback;
  logging_callback.user_data = new PP_CompletionCallback(callback);
  logging_callback.flags = callback.flags;
  int32_t rval = ((PPB_FileIO_1_1*)RealGetInterface("PPB_FileIO;1.1"))->SetLength(file_io, length, logging_callback);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t Flush_1_1(PP_Resource file_io, struct PP_CompletionCallback callback) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileIO\"");
  AddProp(ss, "__version", "\"1.1\"");
  AddProp(ss, "__method", "\"Flush\"");
  AddProp(ss, "file_io", ToString_PP_Resource(file_io));
  AddProp(ss, "callback", ToString_PP_CompletionCallback(callback));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_CompletionCallback logging_callback;
  logging_callback.func = &Logging_PP_CompletionCallback;
  logging_callback.user_data = new PP_CompletionCallback(callback);
  logging_callback.flags = callback.flags;
  int32_t rval = ((PPB_FileIO_1_1*)RealGetInterface("PPB_FileIO;1.1"))->Flush(file_io, logging_callback);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static void Close_1_1(PP_Resource file_io) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileIO\"");
  AddProp(ss, "__version", "\"1.1\"");
  AddProp(ss, "__method", "\"Close\"");
  AddProp(ss, "file_io", ToString_PP_Resource(file_io));
  EndProps(ss);
#ifndef INTERPOSE
  RPC<MainThreadOnly>(ss);
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  ((PPB_FileIO_1_1*)RealGetInterface("PPB_FileIO;1.1"))->Close(file_io);
#endif // !INTERPOSE
}
static int32_t ReadToArray_1_1(PP_Resource file_io, int64_t offset, int32_t max_read_length, struct PP_ArrayOutput* output, struct PP_CompletionCallback callback) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileIO\"");
  AddProp(ss, "__version", "\"1.1\"");
  AddProp(ss, "__method", "\"ReadToArray\"");
  AddProp(ss, "file_io", ToString_PP_Resource(file_io));
  AddProp(ss, "offset", ToString_int64_t(offset));
  AddProp(ss, "max_read_length", ToString_int32_t(max_read_length));
  AddProp(ss, "output", ToString_PP_ArrayOutput(output));
  AddProp(ss, "callback", ToString_PP_CompletionCallback(callback));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  iterator.expectObjectAndGotoFirstProperty();
  iterator.skip();
  FromJSON_PP_ArrayOutput(iterator, *output);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_CompletionCallback logging_callback;
  logging_callback.func = &Logging_PP_CompletionCallback;
  logging_callback.user_data = new PP_CompletionCallback(callback);
  logging_callback.flags = callback.flags;
  int32_t rval = ((PPB_FileIO_1_1*)RealGetInterface("PPB_FileIO;1.1"))->ReadToArray(file_io, offset, max_read_length, output, logging_callback);
  printf("RPC response: [");
  printf("[");
  printf("%s", ToString_int32_t(rval).c_str());
  printf(",");
  std::stringstream os;
  BeginProps(os);
  AddProp(os, "output", ToString_PP_ArrayOutput(output));
  EndProps(os);
  printf("%s]", os.str().c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
}
static PPB_FileIO_1_1 _PPB_FileIO_1_1 = {
  ns_PPB_FileIO_1_1::Create_1_1,
  ns_PPB_FileIO_1_1::IsFileIO_1_1,
  ns_PPB_FileIO_1_1::Open_1_1,
  ns_PPB_FileIO_1_1::Query_1_1,
  ns_PPB_FileIO_1_1::Touch_1_1,
  ns_PPB_FileIO_1_1::Read_1_1,
  ns_PPB_FileIO_1_1::Write_1_1,
  ns_PPB_FileIO_1_1::SetLength_1_1,
  ns_PPB_FileIO_1_1::Flush_1_1,
  ns_PPB_FileIO_1_1::Close_1_1,
  ns_PPB_FileIO_1_1::ReadToArray_1_1,
};
const string ToString_PPB_FileIO(const PPB_FileIO_1_1 *v) {
  stringstream s;
  s << v;
  return s.str();
}
const string ToString_PP_MakeDirectoryFlags(const PP_MakeDirectoryFlags *v) {
  switch (*v) {
    case 0 << 0:
      return "\"PP_MAKEDIRECTORYFLAG_NONE\"";
    case 1 << 0:
      return "\"PP_MAKEDIRECTORYFLAG_WITH_ANCESTORS\"";
    case 1 << 1:
      return "\"PP_MAKEDIRECTORYFLAG_EXCLUSIVE\"";
    default:
      return "\"???\"";
  }
}
const string ToString_PP_MakeDirectoryFlags(const PP_MakeDirectoryFlags &v) {
  return ToString_PP_MakeDirectoryFlags(&v);
}
void FromJSON_PP_MakeDirectoryFlags(JSONIterator& iterator, PP_MakeDirectoryFlags &value) {
  long int v;
  FromJSON_int(iterator, v);
  value = PP_MakeDirectoryFlags(v);
}
namespace ns_PPB_FileRef_1_0 {
static PP_Resource Create_1_0(PP_Resource file_system, const char* path) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileRef\"");
  AddProp(ss, "__version", "\"1.0\"");
  AddProp(ss, "__method", "\"Create\"");
  AddProp(ss, "file_system", ToString_PP_Resource(file_system));
  AddProp(ss, "path", ToString_str_t(path));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_Resource(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  int32_t rval = ((PPB_FileRef_1_0*)RealGetInterface("PPB_FileRef;1.0"))->Create(file_system, path);
  printf("RPC response: [");
  printf("%s", ToString_PP_Resource(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static PP_Bool IsFileRef_1_0(PP_Resource resource) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileRef\"");
  AddProp(ss, "__version", "\"1.0\"");
  AddProp(ss, "__method", "\"IsFileRef\"");
  AddProp(ss, "resource", ToString_PP_Resource(resource));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  PP_Bool rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_Bool(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_Bool rval = ((PPB_FileRef_1_0*)RealGetInterface("PPB_FileRef;1.0"))->IsFileRef(resource);
  printf("RPC response: [");
  printf("%s", ToString_PP_Bool(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static PP_FileSystemType GetFileSystemType_1_0(PP_Resource file_ref) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileRef\"");
  AddProp(ss, "__version", "\"1.0\"");
  AddProp(ss, "__method", "\"GetFileSystemType\"");
  AddProp(ss, "file_ref", ToString_PP_Resource(file_ref));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  PP_FileSystemType rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_FileSystemType(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_FileSystemType rval = ((PPB_FileRef_1_0*)RealGetInterface("PPB_FileRef;1.0"))->GetFileSystemType(file_ref);
  printf("RPC response: [");
  printf("%s", ToString_PP_FileSystemType(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static struct PP_Var GetName_1_0(PP_Resource file_ref) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileRef\"");
  AddProp(ss, "__version", "\"1.0\"");
  AddProp(ss, "__method", "\"GetName\"");
  AddProp(ss, "file_ref", ToString_PP_Resource(file_ref));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  struct PP_Var rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_Var(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  struct PP_Var rval = ((PPB_FileRef_1_0*)RealGetInterface("PPB_FileRef;1.0"))->GetName(file_ref);
  printf("RPC response: [");
  printf("%s", ToString_PP_Var(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static struct PP_Var GetPath_1_0(PP_Resource file_ref) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileRef\"");
  AddProp(ss, "__version", "\"1.0\"");
  AddProp(ss, "__method", "\"GetPath\"");
  AddProp(ss, "file_ref", ToString_PP_Resource(file_ref));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  struct PP_Var rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_Var(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  struct PP_Var rval = ((PPB_FileRef_1_0*)RealGetInterface("PPB_FileRef;1.0"))->GetPath(file_ref);
  printf("RPC response: [");
  printf("%s", ToString_PP_Var(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static PP_Resource GetParent_1_0(PP_Resource file_ref) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileRef\"");
  AddProp(ss, "__version", "\"1.0\"");
  AddProp(ss, "__method", "\"GetParent\"");
  AddProp(ss, "file_ref", ToString_PP_Resource(file_ref));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_Resource(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  int32_t rval = ((PPB_FileRef_1_0*)RealGetInterface("PPB_FileRef;1.0"))->GetParent(file_ref);
  printf("RPC response: [");
  printf("%s", ToString_PP_Resource(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t MakeDirectory_1_0(PP_Resource directory_ref, PP_Bool make_ancestors, struct PP_CompletionCallback callback) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileRef\"");
  AddProp(ss, "__version", "\"1.0\"");
  AddProp(ss, "__method", "\"MakeDirectory\"");
  AddProp(ss, "directory_ref", ToString_PP_Resource(directory_ref));
  AddProp(ss, "make_ancestors", ToString_PP_Bool(make_ancestors));
  AddProp(ss, "callback", ToString_PP_CompletionCallback(callback));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_CompletionCallback logging_callback;
  logging_callback.func = &Logging_PP_CompletionCallback;
  logging_callback.user_data = new PP_CompletionCallback(callback);
  logging_callback.flags = callback.flags;
  int32_t rval = ((PPB_FileRef_1_0*)RealGetInterface("PPB_FileRef;1.0"))->MakeDirectory(directory_ref, make_ancestors, logging_callback);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
/* skipping MakeDirectory */
static int32_t Touch_1_0(PP_Resource file_ref, PP_Time last_access_time, PP_Time last_modified_time, struct PP_CompletionCallback callback) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileRef\"");
  AddProp(ss, "__version", "\"1.0\"");
  AddProp(ss, "__method", "\"Touch\"");
  AddProp(ss, "file_ref", ToString_PP_Resource(file_ref));
  AddProp(ss, "last_access_time", ToString_PP_Time(last_access_time));
  AddProp(ss, "last_modified_time", ToString_PP_Time(last_modified_time));
  AddProp(ss, "callback", ToString_PP_CompletionCallback(callback));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_CompletionCallback logging_callback;
  logging_callback.func = &Logging_PP_CompletionCallback;
  logging_callback.user_data = new PP_CompletionCallback(callback);
  logging_callback.flags = callback.flags;
  int32_t rval = ((PPB_FileRef_1_0*)RealGetInterface("PPB_FileRef;1.0"))->Touch(file_ref, last_access_time, last_modified_time, logging_callback);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t Delete_1_0(PP_Resource file_ref, struct PP_CompletionCallback callback) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileRef\"");
  AddProp(ss, "__version", "\"1.0\"");
  AddProp(ss, "__method", "\"Delete\"");
  AddProp(ss, "file_ref", ToString_PP_Resource(file_ref));
  AddProp(ss, "callback", ToString_PP_CompletionCallback(callback));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_CompletionCallback logging_callback;
  logging_callback.func = &Logging_PP_CompletionCallback;
  logging_callback.user_data = new PP_CompletionCallback(callback);
  logging_callback.flags = callback.flags;
  int32_t rval = ((PPB_FileRef_1_0*)RealGetInterface("PPB_FileRef;1.0"))->Delete(file_ref, logging_callback);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t Rename_1_0(PP_Resource file_ref, PP_Resource new_file_ref, struct PP_CompletionCallback callback) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileRef\"");
  AddProp(ss, "__version", "\"1.0\"");
  AddProp(ss, "__method", "\"Rename\"");
  AddProp(ss, "file_ref", ToString_PP_Resource(file_ref));
  AddProp(ss, "new_file_ref", ToString_PP_Resource(new_file_ref));
  AddProp(ss, "callback", ToString_PP_CompletionCallback(callback));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_CompletionCallback logging_callback;
  logging_callback.func = &Logging_PP_CompletionCallback;
  logging_callback.user_data = new PP_CompletionCallback(callback);
  logging_callback.flags = callback.flags;
  int32_t rval = ((PPB_FileRef_1_0*)RealGetInterface("PPB_FileRef;1.0"))->Rename(file_ref, new_file_ref, logging_callback);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
/* skipping Query */
/* skipping ReadDirectoryEntries */
}
static PPB_FileRef_1_0 _PPB_FileRef_1_0 = {
  ns_PPB_FileRef_1_0::Create_1_0,
  ns_PPB_FileRef_1_0::IsFileRef_1_0,
  ns_PPB_FileRef_1_0::GetFileSystemType_1_0,
  ns_PPB_FileRef_1_0::GetName_1_0,
  ns_PPB_FileRef_1_0::GetPath_1_0,
  ns_PPB_FileRef_1_0::GetParent_1_0,
  ns_PPB_FileRef_1_0::MakeDirectory_1_0,
  ns_PPB_FileRef_1_0::Touch_1_0,
  ns_PPB_FileRef_1_0::Delete_1_0,
  ns_PPB_FileRef_1_0::Rename_1_0,
};
const string ToString_PPB_FileRef(const PPB_FileRef_1_0 *v) {
  stringstream s;
  s << v;
  return s.str();
}
namespace ns_PPB_FileRef_1_1 {
static PP_Resource Create_1_1(PP_Resource file_system, const char* path) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileRef\"");
  AddProp(ss, "__version", "\"1.1\"");
  AddProp(ss, "__method", "\"Create\"");
  AddProp(ss, "file_system", ToString_PP_Resource(file_system));
  AddProp(ss, "path", ToString_str_t(path));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_Resource(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  int32_t rval = ((PPB_FileRef_1_1*)RealGetInterface("PPB_FileRef;1.1"))->Create(file_system, path);
  printf("RPC response: [");
  printf("%s", ToString_PP_Resource(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static PP_Bool IsFileRef_1_1(PP_Resource resource) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileRef\"");
  AddProp(ss, "__version", "\"1.1\"");
  AddProp(ss, "__method", "\"IsFileRef\"");
  AddProp(ss, "resource", ToString_PP_Resource(resource));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  PP_Bool rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_Bool(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_Bool rval = ((PPB_FileRef_1_1*)RealGetInterface("PPB_FileRef;1.1"))->IsFileRef(resource);
  printf("RPC response: [");
  printf("%s", ToString_PP_Bool(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static PP_FileSystemType GetFileSystemType_1_1(PP_Resource file_ref) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileRef\"");
  AddProp(ss, "__version", "\"1.1\"");
  AddProp(ss, "__method", "\"GetFileSystemType\"");
  AddProp(ss, "file_ref", ToString_PP_Resource(file_ref));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  PP_FileSystemType rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_FileSystemType(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_FileSystemType rval = ((PPB_FileRef_1_1*)RealGetInterface("PPB_FileRef;1.1"))->GetFileSystemType(file_ref);
  printf("RPC response: [");
  printf("%s", ToString_PP_FileSystemType(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static struct PP_Var GetName_1_1(PP_Resource file_ref) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileRef\"");
  AddProp(ss, "__version", "\"1.1\"");
  AddProp(ss, "__method", "\"GetName\"");
  AddProp(ss, "file_ref", ToString_PP_Resource(file_ref));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  struct PP_Var rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_Var(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  struct PP_Var rval = ((PPB_FileRef_1_1*)RealGetInterface("PPB_FileRef;1.1"))->GetName(file_ref);
  printf("RPC response: [");
  printf("%s", ToString_PP_Var(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static struct PP_Var GetPath_1_1(PP_Resource file_ref) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileRef\"");
  AddProp(ss, "__version", "\"1.1\"");
  AddProp(ss, "__method", "\"GetPath\"");
  AddProp(ss, "file_ref", ToString_PP_Resource(file_ref));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  struct PP_Var rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_Var(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  struct PP_Var rval = ((PPB_FileRef_1_1*)RealGetInterface("PPB_FileRef;1.1"))->GetPath(file_ref);
  printf("RPC response: [");
  printf("%s", ToString_PP_Var(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static PP_Resource GetParent_1_1(PP_Resource file_ref) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileRef\"");
  AddProp(ss, "__version", "\"1.1\"");
  AddProp(ss, "__method", "\"GetParent\"");
  AddProp(ss, "file_ref", ToString_PP_Resource(file_ref));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_Resource(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  int32_t rval = ((PPB_FileRef_1_1*)RealGetInterface("PPB_FileRef;1.1"))->GetParent(file_ref);
  printf("RPC response: [");
  printf("%s", ToString_PP_Resource(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t MakeDirectory_1_1(PP_Resource directory_ref, PP_Bool make_ancestors, struct PP_CompletionCallback callback) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileRef\"");
  AddProp(ss, "__version", "\"1.1\"");
  AddProp(ss, "__method", "\"MakeDirectory\"");
  AddProp(ss, "directory_ref", ToString_PP_Resource(directory_ref));
  AddProp(ss, "make_ancestors", ToString_PP_Bool(make_ancestors));
  AddProp(ss, "callback", ToString_PP_CompletionCallback(callback));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_CompletionCallback logging_callback;
  logging_callback.func = &Logging_PP_CompletionCallback;
  logging_callback.user_data = new PP_CompletionCallback(callback);
  logging_callback.flags = callback.flags;
  int32_t rval = ((PPB_FileRef_1_1*)RealGetInterface("PPB_FileRef;1.1"))->MakeDirectory(directory_ref, make_ancestors, logging_callback);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
/* skipping MakeDirectory */
static int32_t Touch_1_1(PP_Resource file_ref, PP_Time last_access_time, PP_Time last_modified_time, struct PP_CompletionCallback callback) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileRef\"");
  AddProp(ss, "__version", "\"1.1\"");
  AddProp(ss, "__method", "\"Touch\"");
  AddProp(ss, "file_ref", ToString_PP_Resource(file_ref));
  AddProp(ss, "last_access_time", ToString_PP_Time(last_access_time));
  AddProp(ss, "last_modified_time", ToString_PP_Time(last_modified_time));
  AddProp(ss, "callback", ToString_PP_CompletionCallback(callback));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_CompletionCallback logging_callback;
  logging_callback.func = &Logging_PP_CompletionCallback;
  logging_callback.user_data = new PP_CompletionCallback(callback);
  logging_callback.flags = callback.flags;
  int32_t rval = ((PPB_FileRef_1_1*)RealGetInterface("PPB_FileRef;1.1"))->Touch(file_ref, last_access_time, last_modified_time, logging_callback);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t Delete_1_1(PP_Resource file_ref, struct PP_CompletionCallback callback) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileRef\"");
  AddProp(ss, "__version", "\"1.1\"");
  AddProp(ss, "__method", "\"Delete\"");
  AddProp(ss, "file_ref", ToString_PP_Resource(file_ref));
  AddProp(ss, "callback", ToString_PP_CompletionCallback(callback));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_CompletionCallback logging_callback;
  logging_callback.func = &Logging_PP_CompletionCallback;
  logging_callback.user_data = new PP_CompletionCallback(callback);
  logging_callback.flags = callback.flags;
  int32_t rval = ((PPB_FileRef_1_1*)RealGetInterface("PPB_FileRef;1.1"))->Delete(file_ref, logging_callback);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t Rename_1_1(PP_Resource file_ref, PP_Resource new_file_ref, struct PP_CompletionCallback callback) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileRef\"");
  AddProp(ss, "__version", "\"1.1\"");
  AddProp(ss, "__method", "\"Rename\"");
  AddProp(ss, "file_ref", ToString_PP_Resource(file_ref));
  AddProp(ss, "new_file_ref", ToString_PP_Resource(new_file_ref));
  AddProp(ss, "callback", ToString_PP_CompletionCallback(callback));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_CompletionCallback logging_callback;
  logging_callback.func = &Logging_PP_CompletionCallback;
  logging_callback.user_data = new PP_CompletionCallback(callback);
  logging_callback.flags = callback.flags;
  int32_t rval = ((PPB_FileRef_1_1*)RealGetInterface("PPB_FileRef;1.1"))->Rename(file_ref, new_file_ref, logging_callback);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t Query_1_1(PP_Resource file_ref, struct PP_FileInfo* info, struct PP_CompletionCallback callback) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileRef\"");
  AddProp(ss, "__version", "\"1.1\"");
  AddProp(ss, "__method", "\"Query\"");
  AddProp(ss, "file_ref", ToString_PP_Resource(file_ref));
  AddProp(ss, "info", PointerToString(info));
  AddProp(ss, "callback", ToString_PP_CompletionCallback(callback));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  iterator.expectObjectAndGotoFirstProperty();
  if (!!info) {
    iterator.skip();
    FromJSON_PP_FileInfo(iterator, *info);
  }
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_CompletionCallback logging_callback;
  logging_callback.func = &Logging_PP_CompletionCallback;
  logging_callback.user_data = new PP_CompletionCallback(callback);
  logging_callback.flags = callback.flags;
  int32_t rval = ((PPB_FileRef_1_1*)RealGetInterface("PPB_FileRef;1.1"))->Query(file_ref, info, logging_callback);
  printf("RPC response: [");
  printf("[");
  printf("%s", ToString_int32_t(rval).c_str());
  printf(",");
  std::stringstream os;
  BeginProps(os);
  if (!!info) {
  AddProp(os, "info", ToString_PP_FileInfo(info));
  }
  EndProps(os);
  printf("%s]", os.str().c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
static int32_t ReadDirectoryEntries_1_1(PP_Resource file_ref, struct PP_ArrayOutput output, struct PP_CompletionCallback callback) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileRef\"");
  AddProp(ss, "__version", "\"1.1\"");
  AddProp(ss, "__method", "\"ReadDirectoryEntries\"");
  AddProp(ss, "file_ref", ToString_PP_Resource(file_ref));
  AddProp(ss, "output", ToString_PP_ArrayOutput(output));
  AddProp(ss, "callback", ToString_PP_CompletionCallback(callback));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_int32_t(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  PP_CompletionCallback logging_callback;
  logging_callback.func = &Logging_PP_CompletionCallback;
  logging_callback.user_data = new PP_CompletionCallback(callback);
  logging_callback.flags = callback.flags;
  int32_t rval = ((PPB_FileRef_1_1*)RealGetInterface("PPB_FileRef;1.1"))->ReadDirectoryEntries(file_ref, output, logging_callback);
  printf("RPC response: [");
  printf("%s", ToString_int32_t(rval).c_str());
  printf("]\n");
  return rval;
#endif // !INTERPOSE
}
}
static PPB_FileRef_1_1 _PPB_FileRef_1_1 = {
  ns_PPB_FileRef_1_1::Create_1_1,
  ns_PPB_FileRef_1_1::IsFileRef_1_1,
  ns_PPB_FileRef_1_1::GetFileSystemType_1_1,
  ns_PPB_FileRef_1_1::GetName_1_1,
  ns_PPB_FileRef_1_1::GetPath_1_1,
  ns_PPB_FileRef_1_1::GetParent_1_1,
  ns_PPB_FileRef_1_1::MakeDirectory_1_1,
  ns_PPB_FileRef_1_1::Touch_1_1,
  ns_PPB_FileRef_1_1::Delete_1_1,
  ns_PPB_FileRef_1_1::Rename_1_1,
  ns_PPB_FileRef_1_1::Query_1_1,
  ns_PPB_FileRef_1_1::ReadDirectoryEntries_1_1,
};
const string ToString_PPB_FileRef(const PPB_FileRef_1_1 *v) {
  stringstream s;
  s << v;
  return s.str();
}
namespace ns_PPB_FileRef_1_2 {
static PP_Resource Create_1_2(PP_Resource file_system, const char* path) {
  stringstream ss;
  BeginProps(ss);
  AddProp(ss, "__interface", "\"PPB_FileRef\"");
  AddProp(ss, "__version", "\"1.2\"");
  AddProp(ss, "__method", "\"Create\"");
  AddProp(ss, "file_system", ToString_PP_Resource(file_system));
  AddProp(ss, "path", ToString_str_t(path));
  EndProps(ss);
#ifndef INTERPOSE
  string json = RPCWithResult<MainThreadOnly>(ss);
  int32_t rval;
  JSONIterator iterator(json);
  iterator.expectArrayAndGotoFirstItem();
  FromJSON_PP_Resource(iterator, rval);
  return rval;
#else // !INTERPOSE
  printf("%s\n", ss.str().c_str());
  i