
/* -*- Mode: C++; tab-width: 20; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/*
 * Derived from the Unicode Character Database by genUnicodePropertyData.pl
 *
 * For Unicode terms of use, see http://www.unicode.org/terms_of_use.html
 */

/*
 * Created on Tue Nov 15 16:39:42 2016 from UCD data files with version info:
 *

# Unicode Character Database
# Date: 2016-06-20, 14:59:00 GMT [KW]
# © 2016 Unicode®, Inc.
# Unicode and the Unicode Logo are registered trademarks of Unicode, Inc. in the U.S. and other countries.
# For terms of use, see http://www.unicode.org/terms_of_use.html
#
# For documentation, see the following:
# NamesList.html
# UAX #38, "Unicode Han Database (Unihan)"
# UAX #44, "Unicode Character Database."
#
# The UAXes can be accessed at http://www.unicode.org/versions/Unicode9.0.0/

This directory contains the final data files
for the Unicode Character Database, for Version 9.0.0 of the Unicode Standard.

# Scripts-9.0.0.txt
# Date: 2016-06-01, 10:34:37 GMT

# BidiMirroring-9.0.0.txt
# Date: 2016-01-21, 22:00:00 GMT [KW, LI]

# BidiBrackets-9.0.0.txt
# Date: 2016-06-07, 22:30:00 GMT [AG, LI, KW]

# HangulSyllableType-9.0.0.txt
# Date: 2016-03-02, 18:55:01 GMT

# LineBreak-9.0.0.txt
# Date: 2016-05-26, 01:00:00 GMT [KW, LI]

# EastAsianWidth-9.0.0.txt
# Date: 2016-05-27, 17:00:00 GMT [KW, LI]

# DerivedCoreProperties-9.0.0.txt
# Date: 2016-06-01, 10:34:24 GMT

# IdentifierStatus.txt
# Date: 2016-06-16, 13:41:30 GMT

# IdentifierType.txt
# Date: 2016-06-16, 13:41:30 GMT

#
# Unihan_Variants.txt
# Date: 2016-06-01 07:01:48 GMT [JHJ]

# VerticalOrientation-16.txt
# Date: 2016-07-23, 01:00:00 GMT [EM, KI, LI]

 *
 * * * * * This file contains MACHINE-GENERATED DATA, do not edit! * * * * *
 */

#include <stdint.h>
#include "harfbuzz/hb.h"

#if !ENABLE_INTL_API
static const uint32_t sScriptCodeToTag[] = {
  HB_TAG('Z','y','y','y'),
  HB_TAG('Z','i','n','h'),
  HB_TAG('A','r','a','b'),
  HB_TAG('A','r','m','n'),
  HB_TAG('B','e','n','g'),
  HB_TAG('B','o','p','o'),
  HB_TAG('C','h','e','r'),
  HB_TAG('C','o','p','t'),
  HB_TAG('C','y','r','l'),
  HB_TAG('D','s','r','t'),
  HB_TAG('D','e','v','a'),
  HB_TAG('E','t','h','i'),
  HB_TAG('G','e','o','r'),
  HB_TAG('G','o','t','h'),
  HB_TAG('G','r','e','k'),
  HB_TAG('G','u','j','r'),
  HB_TAG('G','u','r','u'),
  HB_TAG('H','a','n','i'),
  HB_TAG('H','a','n','g'),
  HB_TAG('H','e','b','r'),
  HB_TAG('H','i','r','a'),
  HB_TAG('K','n','d','a'),
  HB_TAG('K','a','n','a'),
  HB_TAG('K','h','m','r'),
  HB_TAG('L','a','o','o'),
  HB_TAG('L','a','t','n'),
  HB_TAG('M','l','y','m'),
  HB_TAG('M','o','n','g'),
  HB_TAG('M','y','m','r'),
  HB_TAG('O','g','a','m'),
  HB_TAG('I','t','a','l'),
  HB_TAG('O','r','y','a'),
  HB_TAG('R','u','n','r'),
  HB_TAG('S','i','n','h'),
  HB_TAG('S','y','r','c'),
  HB_TAG('T','a','m','l'),
  HB_TAG('T','e','l','u'),
  HB_TAG('T','h','a','a'),
  HB_TAG('T','h','a','i'),
  HB_TAG('T','i','b','t'),
  HB_TAG('C','a','n','s'),
  HB_TAG('Y','i','i','i'),
  HB_TAG('T','g','l','g'),
  HB_TAG('H','a','n','o'),
  HB_TAG('B','u','h','d'),
  HB_TAG('T','a','g','b'),
  HB_TAG('B','r','a','i'),
  HB_TAG('C','p','r','t'),
  HB_TAG('L','i','m','b'),
  HB_TAG('L','i','n','b'),
  HB_TAG('O','s','m','a'),
  HB_TAG('S','h','a','w'),
  HB_TAG('T','a','l','e'),
  HB_TAG('U','g','a','r'),
  HB_TAG('H','r','k','t'),
  HB_TAG('B','u','g','i'),
  HB_TAG('G','l','a','g'),
  HB_TAG('K','h','a','r'),
  HB_TAG('S','y','l','o'),
  HB_TAG('T','a','l','u'),
  HB_TAG('T','f','n','g'),
  HB_TAG('X','p','e','o'),
  HB_TAG('B','a','l','i'),
  HB_TAG('B','a','t','k'),
  HB_TAG('B','l','i','s'),
  HB_TAG('B','r','a','h'),
  HB_TAG('C','h','a','m'),
  HB_TAG('C','i','r','t'),
  HB_TAG('C','y','r','s'),
  HB_TAG('E','g','y','d'),
  HB_TAG('E','g','y','h'),
  HB_TAG('E','g','y','p'),
  HB_TAG('G','e','o','k'),
  HB_TAG('H','a','n','s'),
  HB_TAG('H','a','n','t'),
  HB_TAG('H','m','n','g'),
  HB_TAG('H','u','n','g'),
  HB_TAG('I','n','d','s'),
  HB_TAG('J','a','v','a'),
  HB_TAG('K','a','l','i'),
  HB_TAG('L','a','t','f'),
  HB_TAG('L','a','t','g'),
  HB_TAG('L','e','p','c'),
  HB_TAG('L','i','n','a'),
  HB_TAG('M','a','n','d'),
  HB_TAG('M','a','y','a'),
  HB_TAG('M','e','r','o'),
  HB_TAG('N','k','o','o'),
  HB_TAG('O','r','k','h'),
  HB_TAG('P','e','r','m'),
  HB_TAG('P','h','a','g'),
  HB_TAG('P','h','n','x'),
  HB_TAG('P','l','r','d'),
  HB_TAG('R','o','r','o'),
  HB_TAG('S','a','r','a'),
  HB_TAG('S','y','r','e'),
  HB_TAG('S','y','r','j'),
  HB_TAG('S','y','r','n'),
  HB_TAG('T','e','n','g'),
  HB_TAG('V','a','i','i'),
  HB_TAG('V','i','s','p'),
  HB_TAG('X','s','u','x'),
  HB_TAG('Z','x','x','x'),
  HB_TAG('Z','z','z','z'),
  HB_TAG('C','a','r','i'),
  HB_TAG('J','p','a','n'),
  HB_TAG('L','a','n','a'),
  HB_TAG('L','y','c','i'),
  HB_TAG('L','y','d','i'),
  HB_TAG('O','l','c','k'),
  HB_TAG('R','j','n','g'),
  HB_TAG('S','a','u','r'),
  HB_TAG('S','g','n','w'),
  HB_TAG('S','u','n','d'),
  HB_TAG('M','o','o','n'),
  HB_TAG('M','t','e','i'),
  HB_TAG('A','r','m','i'),
  HB_TAG('A','v','s','t'),
  HB_TAG('C','a','k','m'),
  HB_TAG('K','o','r','e'),
  HB_TAG('K','t','h','i'),
  HB_TAG('M','a','n','i'),
  HB_TAG('P','h','l','i'),
  HB_TAG('P','h','l','p'),
  HB_TAG('P','h','l','v'),
  HB_TAG('P','r','t','i'),
  HB_TAG('S','a','m','r'),
  HB_TAG('T','a','v','t'),
  HB_TAG('Z','m','t','h'),
  HB_TAG('Z','s','y','m'),
  HB_TAG('B','a','m','u'),
  HB_TAG('L','i','s','u'),
  HB_TAG('N','k','g','b'),
  HB_TAG('S','a','r','b'),
  HB_TAG('B','a','s','s'),
  HB_TAG('D','u','p','l'),
  HB_TAG('E','l','b','a'),
  HB_TAG('G','r','a','n'),
  HB_TAG('K','p','e','l'),
  HB_TAG('L','o','m','a'),
  HB_TAG('M','e','n','d'),
  HB_TAG('M','e','r','c'),
  HB_TAG('N','a','r','b'),
  HB_TAG('N','b','a','t'),
  HB_TAG('P','a','l','m'),
  HB_TAG('S','i','n','d'),
  HB_TAG('W','a','r','a'),
  HB_TAG('A','f','a','k'),
  HB_TAG('J','u','r','c'),
  HB_TAG('M','r','o','o'),
  HB_TAG('N','s','h','u'),
  HB_TAG('S','h','r','d'),
  HB_TAG('S','o','r','a'),
  HB_TAG('T','a','k','r'),
  HB_TAG('T','a','n','g'),
  HB_TAG('W','o','l','e'),
  HB_TAG('H','l','u','w'),
  HB_TAG('K','h','o','j'),
  HB_TAG('T','i','r','h'),
  HB_TAG('A','g','h','b'),
  HB_TAG('M','a','h','j'),
  HB_TAG('A','h','o','m'),
  HB_TAG('H','a','t','r'),
  HB_TAG('M','o','d','i'),
  HB_TAG('M','u','l','t'),
  HB_TAG('P','a','u','c'),
  HB_TAG('S','i','d','d'),
  HB_TAG('A','d','l','m'),
  HB_TAG('B','h','k','s'),
  HB_TAG('M','a','r','c'),
  HB_TAG('N','e','w','a'),
  HB_TAG('O','s','g','e'),
  HB_TAG('H','a','n','b'),
  HB_TAG('J','a','m','o'),
  HB_TAG('Z','s','y','e')
};
#endif

#if !ENABLE_INTL_API
static const int16_t sMirrorOffsets[] = {
  0,
  1,
  -1,
  2,
  -2,
  16,
  -16,
  3,
  -3,
  2016,
  138,
  1824,
  2104,
  2108,
  2106,
  -138,
  8,
  7,
  -8,
  -7,
  -1824,
  -2016,
  -2104,
  -2106,
  -2108
};
#endif


#if !ENABLE_INTL_API
#define kCharProp1MaxPlane  1
#define kCharProp1IndexBits 11
#define kCharProp1CharBits  5
static const uint8_t sCharProp1Planes[1] = {1};

static const uint8_t sCharProp1Pages[2][2048] = {
  {0,1,2,2,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,5,6,7,0,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,9,10,11,0,12,0,13,14,0,0,15,16,17,18,19,0,0,0,0,20,21,22,23,0,0,0,24,25,0,26,27,0,0,26,28,0,0,26,28,0,0,26,28,0,0,26,28,0,0,0,28,0,0,0,29,0,0,26,28,0,0,0,28,0,0,0,30,0,0,31,32,0,0,33,34,0,35,36,0,37,38,0,39,0,0,40,0,0,41,0,0,0,42,42,42,43,43,44,45,45,0,0,0,0,0,0,0,0,0,0,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,0,0,0,48,48,0,0,0,0,49,0,0,0,0,0,0,50,0,0,0,51,0,0,0,0,0,0,52,0,0,53,0,54,0,0,0,55,56,57,0,58,0,59,0,60,0,0,0,0,61,62,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,66,67,68,0,69,70,0,0,0,0,0,0,0,0,71,72,73,74,75,76,77,78,79,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,0,0,82,83,0,0,0,0,0,0,0,0,0,0,0,0,84,85,86,87,0,88,0,89,90,91,92,93,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,94,0,0,0,95,0,0,0,96,97,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,100,0,0,101,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,103,0,0,104,0,0,0,0,0,0,0,0,105,0,0,0,0,0,56,106,0,107,108,109,0,110,111,0,0,0,0,0,0,112,113,114,0,0,0,0,0,0,0,28,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,121,115,116,117,118,119,120,122,123,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,126,127,128,0,0,0,0,1,2,129,130,0,0,0,0},
  {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,0,0,0,0,0,0,0,132,0,0,0,133,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,134,135,0,0,0,0,0,136,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,95,0,137,0,0,138,139,0,110,0,0,140,0,0,141,0,0,0,0,0,142,0,26,28,143,0,0,0,0,0,0,144,0,0,0,145,0,0,0,0,0,0,95,146,0,0,95,0,0,0,147,0,0,0,148,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,149,0,150,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,151,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,153,154,0,0,0,0,155,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,156,157,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,158,0,0,0,159,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
};

static const nsCharProps1 sCharProp1Values[160][32] = {
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {3,0,0}, {0,0,0}, {4,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {3,0,0}, {0,0,0}, {4,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {5,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {6,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,232}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,232}, {0,0,216}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220},},
  {{0,0,220}, {0,0,202}, {0,0,202}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,202}, {0,0,202}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,1}, {0,0,1}, {0,0,1}, {0,0,1}, {0,0,1}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,230},},
  {{0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,240}, {0,0,230}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,220}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,230}, {0,0,232}, {0,0,220}, {0,0,220}, {0,0,230}, {0,0,233}, {0,0,234}, {0,0,234}, {0,0,233},},
  {{0,0,234}, {0,0,234}, {0,0,233}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,222}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230},},
  {{0,0,230}, {0,0,230}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,222}, {0,0,228}, {0,0,230}, {0,0,10}, {0,0,11}, {0,0,12}, {0,0,13}, {0,0,14}, {0,0,15}, {0,0,16}, {0,0,17}, {0,0,18}, {0,0,19}, {0,0,19}, {0,0,20}, {0,0,21}, {0,0,22}, {0,0,0}, {0,0,23},},
  {{0,0,0}, {0,0,24}, {0,0,25}, {0,0,0}, {0,0,230}, {0,0,220}, {0,0,0}, {0,0,18}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,30}, {0,0,31}, {0,0,32}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,27}, {0,0,28}, {0,0,29}, {0,0,30}, {0,0,31}, {0,0,32}, {0,0,33}, {0,0,34}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,220},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,35}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,230},},
  {{0,0,230}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,36}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,230}, {0,0,220}, {0,0,220}, {0,0,230}, {0,0,220}, {0,0,230},},
  {{0,0,230}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230},},
  {{0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230},},
  {{0,0,230}, {0,0,230}, {0,0,0}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,27}, {0,0,28}, {0,0,29}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,7}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,84}, {0,0,91}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,103}, {0,0,103}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,107}, {0,0,107}, {0,0,107}, {0,0,107}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,118}, {0,0,118}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,122}, {0,0,122}, {0,0,122}, {0,0,122}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,220}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,220}, {0,0,0}, {0,0,220}, {0,0,0}, {0,0,216}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,129}, {0,0,130}, {0,0,0}, {0,0,132}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,130}, {0,0,130}, {0,0,130}, {0,0,130}, {0,0,0}, {0,0,0},},
  {{0,0,130}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,9}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,7}, {0,0,0}, {0,0,9}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0},},
  {{0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0},},
  {{0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0},},
  {{0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,228}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,222}, {0,0,230}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,220},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,7}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,7}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,7}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,1}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220},},
  {{0,0,230}, {0,0,0}, {0,0,1}, {0,0,1}, {0,0,1}, {0,0,1}, {0,0,1}, {0,0,1}, {0,0,1}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,230}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,234}, {0,0,214}, {0,0,220}, {0,0,202}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230},},
  {{0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,233}, {0,0,220}, {0,0,230}, {0,0,220},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,1}, {0,0,1}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,1}, {0,0,1}, {0,0,1}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,1}, {0,0,1}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,1}, {0,0,1}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {7,0,0}, {7,0,0}, {7,0,0}, {8,0,0}, {8,0,0}, {8,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {9,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {10,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0},},
  {{1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {11,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {12,0,0}, {0,0,0}, {13,0,0}, {14,0,0}, {0,0,0}, {14,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {15,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0},},
  {{1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {16,0,0}, {16,0,0}, {16,0,0}, {0,0,0}, {17,0,0}, {17,0,0}, {0,0,0}, {0,0,0}, {18,0,0}, {18,0,0}, {18,0,0}, {19,0,0}, {19,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {3,0,0}, {0,0,0}, {4,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {7,0,0}, {1,0,0}, {2,0,0}, {8,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {20,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {21,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0},},
  {{2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0},},
  {{2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {22,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {23,0,0}, {24,0,0}, {23,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9},},
  {{0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230},},
  {{0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0},},
  {{1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,218}, {0,0,228}, {0,0,232}, {0,0,222}, {0,0,224}, {0,0,224}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,8}, {0,0,8}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,7}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230},},
  {{0,0,0}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,3,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,3,0}, {0,7,0}, {0,7,0}, {0,7,0},},
  {{0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,3,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0},},
  {{0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,3,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0},},
  {{0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,3,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0},},
  {{0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,3,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0},},
  {{0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,3,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0},},
  {{0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,3,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0},},
  {{0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0},},
  {{0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0},},
  {{0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,26}, {0,0,0},},
  {{0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {3,0,0}, {0,0,0}, {4,0,0}, {0,0,0}, {1,0,0},},
  {{2,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,220}, {0,0,0}, {0,0,0},},
  {{0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,220}, {0,0,0}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,1}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,7}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,7}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,7}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,7}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,7}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,9}, {0,0,7}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,7}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,7}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,1}, {0,0,1}, {0,0,1}, {0,0,1}, {0,0,1}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,1}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,216}, {0,0,216}, {0,0,1}, {0,0,1}, {0,0,1}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,226}, {0,0,216}, {0,0,216}, {0,0,216}, {0,0,216}, {0,0,216}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220},},
  {{0,0,220}, {0,0,220}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230},},
  {{0,0,230}, {0,0,230}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,7}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},}
};
#endif

#if ENABLE_INTL_API
#define kCharProp2MaxPlane  16
#define kCharProp2IndexBits 9
#define kCharProp2CharBits  7
static const uint8_t sCharProp2Planes[16] = {1,2,3,4,4,4,4,4,4,4,4,4,4,4,3,3};

static const uint8_t sCharProp2Pages[5][512] = {
  {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,34,35,36,37,38,39,40,40,40,41,16,16,42,43,44,16,16,16,16,16,16,16,45,16,16,46,47,48,49,50,51,52,53,54,16,55,56,57,34,16,58,59,34,60,61,16,16,16,16,16,16,62,63,16,16,64,65,16,34,34,34,66,67,68,69,34,34,70,34,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,72,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,73,40,40,40,40,40,40,40,40,40,74,16,16,75,76,77,78,16,16,79,80,81,16,82,16,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,83,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,84,34,16,16,16,16,16,16,85,16,86,87},
  {16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,88,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,34,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,34,34,34,34,34,34,34,34,89,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,34,34,34,34,34,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,90,91,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,34,34,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,34,34,34,34,16,16,34,16,16,16,16,16,16,16,16,16,34,34,34,34,34,89,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,34,34,34,34,92,34,34,34,34,34,34,34,34,34,34,34,16,16,34,34,16,16,16,16,16,16,16,16,16,16,16,16},
  {71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,93,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,94,71,95,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,96,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,97},
  {34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,97},
  {16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16}
};

static const nsCharProps2 sCharProp2Values[98][128] = {
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{0,0},{1,0},{0,0},{1,0},{1,0},{1,0},{1,0},{0,0},{1,0},{1,0},{0,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,0},{1,0},{1,0},{1,0},{0,0},{0,0},{0,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{0,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{0,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1}},
  {{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1}},
  {{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{0,0},{0,0},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,0},{1,1},{1,1},{1,0},{1,0},{1,0},{1,1},{1,0},{1,0},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,0},{1,0},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,0},{1,0}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,0},{1,1},{1,1},{1,1},{1,0},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1}},
  {{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1}},
  {{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1}},
  {{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,0},{1,1},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1}},
  {{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1}},
  {{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1}},
  {{1,0},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,0},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,0},{1,0},{1,1},{1,0},{1,0},{1,1},{1,1},{1,0},{1,0},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,0},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,0},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,0},{1,0},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,1},{1,1},{1,0},{1,1},{1,0},{1,1},{1,1},{1,0},{1,0},{1,0},{1,1},{1,1},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,0},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,1},{1,0},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,0},{1,0},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1}},
  {{1,0},{1,0},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,1},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,0},{1,1},{1,1},{1,0},{1,1},{1,0},{1,0},{1,1},{1,1},{1,0},{1,1},{1,0},{1,0},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,0},{1,1},{1,0},{1,1},{1,0},{1,0},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,0},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,0},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1}},
  {{1,1},{1,0},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1}},
  {{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1}},
  {{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},
  {{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1}},
  {{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1}},
  {{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,0},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2}},
  {{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2}},
  {{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,0},{0,0},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2}},
  {{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,0},{1,0},{1,0},{1,0},{1,1},{1,0},{1,0},{1,0},{1,0},{1,1},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,0},{1,0},{1,0},{1,0},{1,0},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},
  {{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1}},
  {{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,0},{1,1},{1,0},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,0},{1,1},{1,0},{1,1},{1,0},{1,1},{1,0},{1,1},{1,0},{1,1},{1,0},{1,0},{1,0}},
  {{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,0},{1,1},{1,0},{1,1},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,0},{1,1},{1,0},{1,1},{1,0},{1,0},{1,0}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,0},{1,0},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{0,0},{1,0},{1,0},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{0,0},{0,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{0,0},{0,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{0,0},{0,0},{1,0},{1,0},{1,0},{1,0},{1,0},{0,0},{1,0},{1,0},{1,0},{1,0},{0,0},{0,0},{0,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{0,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{0,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{0,0},{0,0},{0,0},{0,0},{1,0},{0,0},{0,0},{0,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{0,0},{0,0},{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,0},{1,0},{1,0},{1,0},{1,0},{0,0},{1,0},{1,0},{1,0},{0,0},{0,0},{1,0},{0,0},{0,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,0},{0,0},{1,0},{0,0},{1,0},{0,0},{1,0},{1,0},{1,0},{1,0},{0,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,0},{1,0},{1,0},{1,0},{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,0},{0,0},{0,0},{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},
  {{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,0},{1,0},{0,0},{0,0},{0,0},{0,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{0,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{0,0},{0,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,0},{1,0},{1,0},{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,0},{1,0},{1,0},{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{3,0},{3,0},{0,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{0,0},{0,0},{0,0}},
  {{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,0},{0,0},{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},
  {{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},
  {{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},
  {{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},
  {{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,0},{1,0},{1,0},{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,0},{1,0},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,2}},
  {{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{0,0},{2,0},{2,0},{0,0},{0,0},{0,1},{0,1},{0,1},{3,0},{3,0},{3,0},{3,0},{3,0},{3,0},{3,0},{3,0},{3,0},{3,0},{0,0},{0,0},{3,0},{3,0},{3,0},{3,0},{3,0},{3,0},{3,0},{3,0},{3,0},{3,0},{3,0},{3,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{3,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{2,1},{0,1},{2,1},{0,1},{2,1},{0,1},{2,1},{0,1},{2,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{2,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1}},
  {{0,1},{0,1},{0,1},{2,1},{0,1},{2,1},{0,1},{2,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{2,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{2,1},{2,1},{0,0},{0,0},{0,1},{0,1},{2,0},{2,0},{0,1},{0,1},{0,0},{3,1},{2,1},{0,1},{2,1},{0,1},{2,1},{0,1},{2,1},{0,1},{2,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{2,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{2,1},{0,1},{2,1},{0,1},{2,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{2,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{2,1},{2,1},{0,1},{0,1},{0,1},{0,1},{0,1},{3,1},{0,1},{0,1},{0,0}},
  {{0,0},{0,0},{0,0},{0,0},{0,0},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{2,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},
  {{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0}},
  {{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{2,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{2,0},{2,0},{2,0},{2,0},{2,0}},
  {{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1}},
  {{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},
  {{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},
  {{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,2},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,1}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1}},
  {{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},
  {{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,1},{0,1},{0,0},{0,1},{0,0},{0,1},{0,1},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,1},{0,0},{0,1},{0,0},{0,1},{0,1},{0,0},{0,0},{0,1},{0,1},{0,1},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{2,0},{2,0},{2,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,0},{3,0},{3,0},{3,0},{3,0},{3,0},{3,0},{0,0},{0,0},{0,0},{0,0},{1,0},{1,0},{1,0},{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,0},{2,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{3,0},{3,0},{0,0},{0,0},{2,0},{1,0},{2,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{3,0},{3,0},{1,0},{1,0},{1,0},{2,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{3,0},{0,0},{3,0},{0,0},{3,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{3,0},{3,0},{3,0},{3,0},{3,0},{3,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{0,0},{0,0},{0,0},{3,0},{0,0},{0,0},{0,0},{0,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,0},{1,0},{1,0},{0,0},{0,0},{1,0},{1,0}},
  {{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,0}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},
  {{2,0},{2,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},
  {{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},
  {{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1}},
  {{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,0},{0,0},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1}},
  {{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,1},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},
  {{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,0},{1,0}}
};
#endif

#if !ENABLE_INTL_API
#define kCharProp2MaxPlane  16
#define kCharProp2IndexBits 12
#define kCharProp2CharBits  4
static const uint8_t sCharProp2Planes[16] = {1,2,3,4,4,4,4,4,4,4,4,4,4,5,6,6};

static const uint16_t sCharProp2Pages[7][4096] = {
  {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,16,16,17,18,16,16,19,20,21,22,23,24,25,26,27,16,28,29,30,31,32,33,33,33,34,33,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,56,56,57,57,57,58,58,59,60,60,60,61,60,60,60,60,60,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,78,79,80,81,82,83,78,78,78,78,84,85,86,87,88,89,90,91,78,78,78,92,92,93,94,95,96,97,98,99,100,101,102,103,104,105,105,105,105,106,107,108,109,110,111,112,113,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,192,193,194,195,196,196,197,198,199,200,201,202,196,196,203,204,205,206,207,208,209,210,211,212,213,214,215,216,196,196,217,217,218,219,220,221,222,223,224,225,226,226,227,228,228,229,230,230,230,230,230,231,232,233,233,233,234,235,235,235,235,235,236,236,236,236,237,238,236,236,237,236,236,239,240,241,236,236,236,240,236,236,236,242,243,244,236,245,246,246,246,246,246,247,248,249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,250,249,251,252,253,253,253,253,254,255,256,257,258,259,260,261,262,263,264,264,265,266,267,268,269,270,271,272,273,273,274,273,273,275,276,273,277,249,249,249,249,278,279,280,281,282,283,284,285,286,287,287,288,287,289,290,291,291,292,293,294,294,294,295,296,297,298,298,299,300,196,196,196,196,301,302,302,303,304,305,306,307,308,309,310,311,312,312,313,314,315,315,316,317,318,319,320,321,322,196,196,196,323,324,325,326,33,33,327,328,328,329,330,331,33,332,328,333,334,334,334,335,16,16,16,16,16,16,16,16,16,336,16,16,16,16,16,337,338,339,338,338,339,340,338,341,342,342,342,343,344,345,346,347,348,349,350,351,352,353,354,355,356,357,358,359,360,361,362,363,364,365,366,367,368,369,370,371,372,373,374,375,376,377,375,378,379,380,381,382,383,384,385,386,387,388,389,390,386,386,391,386,392,393,394,395,396,396,396,397,398,399,386,400,401,402,403,404,398,398,405,406,407,406,408,409,410,411,412,412,412,412,413,414,415,415,415,415,416,415,415,417,415,418,419,420,421,422,423,424,425,426,398,427,428,429,430,431,398,432,433,434,435,436,437,438,439,398,440,398,441,442,443,444,445,446,375,447,448,386,449,386,450,450,450,450,450,450,450,450,450,450,450,450,450,450,450,450,386,386,386,386,386,386,386,386,451,452,386,386,386,453,386,454,386,386,386,386,386,386,386,386,386,386,386,386,386,386,386,386,375,455,398,386,456,457,375,458,375,459,375,460,461,462,463,406,464,464,465,466,466,467,468,469,470,470,470,470,470,470,471,472,473,473,474,475,475,475,476,477,236,478,479,479,479,479,480,480,481,482,483,484,485,196,196,196,486,487,486,486,486,486,486,488,486,486,486,486,486,486,486,486,486,486,486,486,486,489,406,490,491,492,493,494,495,496,497,496,498,499,500,501,502,501,503,504,505,506,507,508,509,509,510,509,511,512,506,513,514,514,515,516,517,518,519,520,521,522,517,523,519,520,520,524,525,526,526,527,528,528,528,528,528,529,520,530,520,520,520,520,520,531,520,532,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,534,398,398,398,398,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,534,535,535,536,537,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,538,539,539,539,540,541,541,542,543,543,543,543,543,543,543,543,543,543,543,543,543,543,543,543,544,543,545,196,58,58,546,547,58,548,549,549,549,549,550,551,39,552,553,554,555,555,555,556,557,558,559,560,196,196,196,561,562,563,564,565,566,566,566,567,568,569,569,570,571,572,573,574,575,576,577,578,579,580,230,581,582,583,583,584,585,586,587,588,589,589,590,591,592,593,217,594,595,595,595,596,597,598,599,600,601,602,479,33,33,603,604,605,605,605,605,605,606,606,607,608,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,613,611,609,610,611,612,611,614,233,615,235,235,616,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,617,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,619,619,619,619,619,619,619,619,619,619,619,619,619,619,619,619,620,621,622,619,619,619,623,619,619,619,619,619,619,624,535,535,625,626,627,628,629,630,630,630,630,630,630,631,632,633,630,630,630,630,630,630,630,630,630,630,630,630,630,630,630,630,630,630,630,630,630,634,108,630,630,630,630,635,630,630,636,196,196,637,638,639,640,641,642,643,644,645,630,630,630,630,630,630,630,646,647,648,649,650,651,652,653,654,655,656,657,658,659,660,661,662},
  {663,664,665,666,667,667,196,196,664,664,664,664,664,664,664,668,669,670,670,671,672,672,672,673,674,675,676,196,196,396,396,677,196,196,196,196,196,196,196,196,678,679,680,680,680,681,682,683,684,684,685,686,687,688,688,689,690,691,692,692,693,694,196,196,695,695,696,697,697,698,698,698,699,700,701,702,702,703,704,705,706,706,707,708,708,708,709,196,196,196,196,196,196,196,196,196,710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,711,710,712,713,196,196,196,196,196,196,196,196,196,714,715,715,716,717,718,719,720,721,722,723,105,105,105,724,725,726,727,728,729,105,105,105,105,730,730,731,732,733,734,733,733,735,736,737,738,739,740,741,742,743,744,105,105,745,746,747,748,749,749,749,750,751,752,753,754,755,756,757,105,105,105,105,105,758,758,758,758,759,105,105,105,760,760,760,761,762,762,762,763,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,764,765,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,766,767,767,768,769,770,771,772,773,774,774,775,776,777,778,779,780,781,782,783,784,785,785,786,787,788,788,789,790,791,792,793,794,795,796,797,196,196,196,196,798,799,800,801,801,802,803,804,805,806,807,808,809,810,811,812,196,196,196,196,196,196,196,196,813,813,813,814,815,816,196,196,817,817,817,818,819,820,196,196,196,196,196,196,196,196,196,196,821,821,822,823,824,825,406,406,826,826,826,827,828,829,830,196,831,831,832,833,834,196,196,196,835,836,837,838,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,839,839,840,840,841,842,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,843,843,843,844,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,845,846,847,848,849,850,851,852,853,854,855,856,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,857,858,196,196,196,196,196,196,859,859,859,859,859,859,860,861,857,857,857,857,857,857,857,857,857,857,857,857,862,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,863,863,863,863,863,863,863,863,863,863,863,863,863,863,863,863,863,863,863,863,863,863,863,863,863,863,863,863,863,863,863,863,863,863,863,863,863,864,863,863,865,863,863,863,863,863,863,863,863,863,863,863,863,863,863,866,863,863,863,863,863,863,863,863,863,863,867,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,868,868,868,868,868,868,868,868,868,868,868,868,868,868,868,868,868,868,868,868,868,868,868,868,868,868,868,868,869,868,868,868,868,868,868,868,870,406,406,406,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,549,549,549,549,549,549,549,549,549,549,549,549,549,549,549,549,549,549,549,549,549,549,549,549,549,549,549,549,549,549,549,549,549,549,549,871,872,873,874,196,196,196,196,196,196,875,876,877,878,878,878,879,880,881,882,883,878,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,884,884,884,884,885,886,887,888,889,890,196,196,196,196,891,406,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,893,406,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,892,894,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,895,406,406,406,406,406,406,406,406,406,406,406,406,406,406,406,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,896,896,896,896,896,896,897,898,899,900,901,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,902,902,902,902,902,902,902,902,902,902,902,902,902,902,902,903,902,902,904,902,902,902,905,906,907,902,908,902,902,902,909,406,910,910,910,910,911,196,196,196,196,196,196,196,196,196,196,196,398,398,398,398,398,912,913,914,196,196,196,196,196,196,196,196,915,916,917,918,919,920,921,915,922,923,924,925,926,915,916,917,927,928,917,929,930,931,932,915,933,917,915,916,917,918,919,917,921,915,922,932,915,933,917,915,916,917,934,915,935,936,937,938,917,939,915,940,941,942,943,917,944,915,945,917,946,947,948,949,950,950,950,950,950,950,950,950,950,950,950,950,950,950,950,950,950,950,950,950,950,950,950,950,950,950,950,950,950,950,950,950,951,951,951,952,951,951,953,954,955,956,957,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,958,959,960,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,961,961,961,961,961,961,961,961,961,961,961,961,962,963,105,105,964,964,965,966,967,968,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,969,630,970,971,972,973,974,975,976,977,978,977,108,108,108,979,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,980,981,982,981,981,981,981,981,981,983,984,985,986,985,981,987,988,412,989,412,412,412,990,412,991,992,993,994,994,994,995,996,997,520,520,998,999,1000,994,994,994,994,994,994,994,994,994,994,514,514,1001,1002,514,514,514,1003,1004,1005,514,1006,1007,1008,514,1009,514,514,514,1010,1011,1012,1013,1014,1015,514,1016,1017,514,514,514,1018,1019,1020,1021,1022,1023,514,1024,1025,981,1026,980,981,981,1027,981,1028,514,514,514,514,1029,398,398,1030,514,514,1031,1032,1033,1034,1035,1036,398,398,398,398,398,398,398,1037,398,398,398,398,398,1038,994,994,1039,375,375,375,1040,1041,375,375,1040,375,1042,1043,1043,1043,1043,1043,994,1044,1045,1046,1047,1048,994,994,514,1049,994,994,1050,994,994,994,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1043,1051},
  {533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,1052,535,535,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,1053,533,533,533,533,533,533,533,533,533,533,533,533,533,1054,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,1055,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,619,619,619,619,619,619,619,619,619,619,619,619,619,619,619,619,619,619,619,619,619,619,619,619,619,619,619,619,619,619,619,619,619,623,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,1056},
  {535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,1056},
  {196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196},
  {1057,1058,1059,1059,1059,1059,1059,1059,1058,1058,1058,1058,1058,1058,1058,1058,638,638,638,638,638,638,638,638,638,638,638,638,638,638,638,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,1058,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196},
  {618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,618,1060}
};

static const nsCharProps2 sCharProp2Values[1061][16] = {
  {{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,8,1,4,-1},{0,0,0,0,0,0,7,1,17,-1},{0,0,0,0,0,0,8,1,6,-1},{0,0,0,0,0,0,9,1,6,-1},{0,0,0,0,0,0,7,1,10,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1}},
  {{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,7,1,9,-1},{0,0,0,0,0,0,7,1,9,-1},{0,0,0,0,0,0,7,1,9,-1},{0,0,0,0,0,0,8,1,9,-1}},
  {{0,0,0,29,0,0,9,1,26,-1},{0,0,0,21,0,0,10,1,11,-1},{0,0,0,21,0,0,10,1,23,-1},{0,0,0,21,0,0,4,1,2,-1},{0,0,0,23,0,0,4,1,22,-1},{0,0,0,21,0,0,4,1,21,-1},{0,0,0,21,0,0,10,1,2,-1},{0,0,0,21,1,0,10,1,23,-1},{0,1,0,22,0,0,10,1,20,-1},{0,2,0,18,0,0,10,1,36,-1},{0,0,0,21,0,0,10,1,2,-1},{0,0,0,25,0,0,3,1,22,-1},{0,0,0,21,0,0,6,1,16,-1},{0,0,0,17,1,0,3,1,13,-1},{0,0,0,21,1,0,6,1,16,-1},{0,0,0,21,0,0,6,1,27,-1}},
  {{0,0,0,13,1,0,2,1,19,0},{0,0,0,13,1,0,2,1,19,1},{0,0,0,13,1,0,2,1,19,2},{0,0,0,13,1,0,2,1,19,3},{0,0,0,13,1,0,2,1,19,4},{0,0,0,13,1,0,2,1,19,5},{0,0,0,13,1,0,2,1,19,6},{0,0,0,13,1,0,2,1,19,7},{0,0,0,13,1,0,2,1,19,8},{0,0,0,13,1,0,2,1,19,9},{0,0,0,21,1,0,6,1,16,-1},{0,0,0,21,0,0,10,1,16,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,21,0,0,10,1,11,-1}},
  {{0,0,0,21,0,0,10,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1}},
  {{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{0,1,0,22,0,0,10,1,20,-1},{0,0,0,21,0,0,10,1,22,-1},{0,2,0,18,0,0,10,1,36,-1},{0,0,0,24,0,0,10,1,2,-1},{0,0,0,16,1,0,10,1,2,-1}},
  {{0,0,0,24,0,0,10,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1}},
  {{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{0,1,0,22,0,0,10,1,20,-1},{0,0,0,25,0,0,10,1,4,-1},{0,2,0,18,0,0,10,1,8,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,0,0,0,18,1,9,-1}},
  {{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,7,1,29,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1}},
  {{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1},{0,0,0,0,0,0,18,1,9,-1}},
  {{0,0,0,29,0,0,6,1,12,-1},{0,0,0,21,0,0,10,1,20,-1},{0,0,0,23,0,0,4,1,21,-1},{0,0,0,23,0,0,4,1,22,-1},{0,0,0,23,0,0,4,1,22,-1},{0,0,0,23,0,0,4,1,22,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,21,0,0,10,0,1,-1},{0,0,0,24,0,0,10,1,1,-1},{0,0,0,26,0,0,10,0,2,-1},{25,0,0,7,0,0,0,1,1,-1},{0,0,0,20,0,0,10,1,23,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,1,0,1,18,1,4,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,24,0,0,10,1,2,-1}},
  {{0,0,0,26,0,0,4,1,21,-1},{0,0,0,25,0,0,4,0,22,-1},{0,0,0,15,0,0,2,1,1,2},{0,0,0,15,0,0,2,1,1,3},{0,0,0,24,0,0,10,1,5,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,21,0,0,10,1,1,-1},{0,0,0,21,1,0,10,1,1,-1},{0,0,0,24,0,0,10,1,1,-1},{0,0,0,15,0,0,2,1,1,1},{25,0,0,7,0,0,0,1,1,-1},{0,0,0,19,0,0,10,1,23,-1},{0,0,0,15,0,0,10,0,1,-1},{0,0,0,15,0,0,10,0,1,-1},{0,0,0,15,0,0,10,0,1,-1},{0,0,0,21,0,0,10,1,20,-1}},
  {{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1}},
  {{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{0,0,0,25,0,0,10,0,1,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1}},
  {{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1}},
  {{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{0,0,0,25,0,0,10,0,1,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1}},
  {{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1}},
  {{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1}},
  {{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1}},
  {{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1}},
  {{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1}},
  {{25,0,0,9,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1}},
  {{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1}},
  {{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,7,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1}},
  {{25,0,0,7,0,0,0,1,2,-1},{25,0,0,7,0,0,0,1,2,-1},{25,0,0,7,0,0,0,1,2,-1},{25,0,0,7,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,8,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,8,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,8,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1}},
  {{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1}},
  {{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1}},
  {{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,8,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1}},
  {{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1}},
  {{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1}},
  {{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1}},
  {{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1}},
  {{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1}},
  {{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1}},
  {{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,7,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1}},
  {{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{0,0,0,6,0,0,10,1,2,-1},{0,0,0,6,0,0,10,1,2,-1},{0,0,0,6,1,0,0,1,2,-1},{0,0,0,6,1,0,0,1,2,-1},{0,0,0,6,0,0,0,1,2,-1},{0,0,0,6,0,0,0,1,2,-1},{0,0,0,6,0,0,0,1,2,-1}},
  {{0,0,0,6,0,0,0,1,2,-1},{0,0,0,6,0,0,0,1,2,-1},{0,0,0,24,0,0,10,1,2,-1},{0,0,0,24,0,0,10,1,2,-1},{0,0,0,24,0,0,10,1,2,-1},{0,0,0,24,0,0,10,1,2,-1},{0,0,0,6,0,0,10,1,2,-1},{0,0,0,6,0,0,10,1,1,-1},{0,0,0,6,0,0,10,1,5,-1},{0,0,0,6,0,0,10,1,1,-1},{0,0,0,6,0,0,10,1,1,-1},{0,0,0,6,0,0,10,1,1,-1},{0,0,0,6,0,0,10,1,5,-1},{0,0,0,6,0,0,10,1,1,-1},{0,0,0,6,0,0,10,1,2,-1},{0,0,0,6,0,0,10,1,2,-1}},
  {{0,0,0,6,0,0,0,1,1,-1},{0,0,0,6,0,0,0,1,2,-1},{0,0,0,24,0,0,10,1,2,-1},{0,0,0,24,0,0,10,1,2,-1},{0,0,0,24,0,0,10,1,2,-1},{0,0,0,24,0,0,10,1,2,-1},{0,0,0,24,0,0,10,1,2,-1},{0,0,0,24,0,0,10,1,2,-1},{0,0,0,24,0,0,10,1,1,-1},{0,0,0,24,0,0,10,1,1,-1},{0,0,0,24,0,0,10,1,1,-1},{0,0,0,24,0,0,10,1,1,-1},{0,0,0,24,0,0,10,1,2,-1},{0,0,0,24,0,0,10,1,1,-1},{0,0,0,24,0,0,10,1,2,-1},{0,0,0,24,0,0,10,1,5,-1}},
  {{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{0,0,0,24,0,0,10,1,2,-1},{0,0,0,24,0,0,10,1,2,-1},{0,0,0,24,0,0,10,1,2,-1},{0,0,0,24,0,0,10,1,2,-1},{0,0,0,24,0,0,10,1,2,-1},{5,0,0,24,0,0,10,0,2,-1},{5,0,0,24,0,0,10,0,2,-1},{0,0,0,6,1,0,10,1,2,-1},{0,0,0,24,0,0,10,1,2,-1},{0,0,0,6,0,0,0,1,2,-1},{0,0,0,24,0,0,10,1,2,-1}},
  {{0,0,0,24,0,0,10,1,2,-1},{0,0,0,24,0,0,10,1,2,-1},{0,0,0,24,0,0,10,1,2,-1},{0,0,0,24,0,0,10,1,2,-1},{0,0,0,24,0,0,10,1,2,-1},{0,0,0,24,0,0,10,1,2,-1},{0,0,0,24,0,0,10,1,2,-1},{0,0,0,24,0,0,10,1,2,-1},{0,0,0,24,0,0,10,1,2,-1},{0,0,0,24,0,0,10,1,2,-1},{0,0,0,24,0,0,10,1,2,-1},{0,0,0,24,0,0,10,1,2,-1},{0,0,0,24,0,0,10,1,2,-1},{0,0,0,24,0,0,10,1,2,-1},{0,0,0,24,0,0,10,1,2,-1},{0,0,0,24,0,0,10,1,2,-1}},
  {{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,1,0,17,1,9,-1}},
  {{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1}},
  {{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1}},
  {{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1}},
  {{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,1,17,1,12,-1}},
  {{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,12,-1},{1,0,0,12,0,0,17,1,12,-1},{1,0,0,12,0,0,17,1,12,-1},{1,0,0,12,0,0,17,1,12,-1}},
  {{1,0,0,12,0,0,17,1,12,-1},{1,0,0,12,0,0,17,1,12,-1},{1,0,0,12,0,0,17,1,12,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1}},
  {{14,0,0,9,0,0,0,1,2,-1},{14,0,0,5,0,0,0,1,2,-1},{14,0,0,9,0,0,0,1,2,-1},{14,0,0,5,0,0,0,1,2,-1},{0,0,0,6,0,0,10,1,2,-1},{14,0,0,24,1,0,10,1,2,-1},{14,0,0,9,0,0,0,1,2,-1},{14,0,0,5,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{14,0,0,6,0,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{0,0,0,21,0,0,10,1,16,-1},{14,0,0,9,0,0,0,1,2,-1}},
  {{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{14,0,0,24,0,0,10,1,2,-1},{0,0,0,24,0,0,10,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{0,0,0,21,0,0,10,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{14,0,0,9,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1}},
  {{14,0,0,5,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1}},
  {{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1}},
  {{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1}},
  {{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,9,0,0,0,1,2,-1}},
  {{14,0,0,5,0,0,0,1,2,-1},{14,0,0,5,0,0,0,1,2,-1},{14,0,0,9,0,0,0,1,2,-1},{14,0,0,9,0,0,0,1,2,-1},{14,0,0,9,0,0,0,1,2,-1},{14,0,0,5,0,0,0,1,2,-1},{14,0,0,5,0,0,0,1,2,-1},{14,0,0,5,0,0,0,1,2,-1},{14,0,0,9,0,0,0,1,2,-1},{14,0,0,5,0,0,0,1,2,-1},{14,0,0,9,0,0,0,1,2,-1},{14,0,0,5,0,0,0,1,2,-1},{14,0,0,9,0,0,0,1,2,-1},{14,0,0,5,0,0,0,1,2,-1},{14,0,0,9,0,0,0,1,2,-1},{14,0,0,5,0,0,0,1,2,-1}},
  {{14,0,0,9,0,0,0,1,2,-1},{14,0,0,5,0,0,0,1,2,-1},{7,0,0,9,0,0,0,1,2,-1},{7,0,0,5,0,0,0,1,2,-1},{7,0,0,9,0,0,0,1,2,-1},{7,0,0,5,0,0,0,1,2,-1},{7,0,0,9,0,0,0,1,2,-1},{7,0,0,5,0,0,0,1,2,-1},{7,0,0,9,0,0,0,1,2,-1},{7,0,0,5,0,0,0,1,2,-1},{7,0,0,9,0,0,0,1,2,-1},{7,0,0,5,0,0,0,1,2,-1},{7,0,0,9,0,0,0,1,2,-1},{7,0,0,5,0,0,0,1,2,-1},{7,0,0,9,0,0,0,1,2,-1},{7,0,0,5,0,0,0,1,2,-1}},
  {{14,0,0,5,0,0,0,1,2,-1},{14,0,0,5,0,0,0,1,2,-1},{14,0,0,5,0,0,0,1,2,-1},{14,0,0,5,0,0,0,1,2,-1},{14,0,0,9,0,0,0,1,2,-1},{14,0,0,5,0,0,0,1,2,-1},{14,0,0,25,0,0,10,1,2,-1},{14,0,0,9,0,0,0,1,2,-1},{14,0,0,5,0,0,0,1,2,-1},{14,0,0,9,0,0,0,1,2,-1},{14,0,0,9,0,0,0,1,2,-1},{14,0,0,5,0,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1}},
  {{8,0,0,9,1,0,0,1,2,-1},{8,0,0,9,1,0,0,1,2,-1},{8,0,0,9,1,0,0,1,2,-1},{8,0,0,9,1,0,0,1,2,-1},{8,0,0,9,1,0,0,1,2,-1},{8,0,0,9,1,0,0,1,2,-1},{8,0,0,9,1,0,0,1,2,-1},{8,0,0,9,1,0,0,1,2,-1},{8,0,0,9,1,0,0,1,2,-1},{8,0,0,9,1,0,0,1,2,-1},{8,0,0,9,1,0,0,1,2,-1},{8,0,0,9,1,0,0,1,2,-1},{8,0,0,9,1,0,0,1,2,-1},{8,0,0,9,1,0,0,1,2,-1},{8,0,0,9,1,0,0,1,2,-1},{8,0,0,9,1,0,0,1,2,-1}},
  {{8,0,0,5,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1}},
  {{8,0,0,9,0,0,0,1,2,-1},{8,0,0,5,0,0,0,1,2,-1},{8,0,0,9,0,0,0,1,2,-1},{8,0,0,5,0,0,0,1,2,-1},{8,0,0,9,0,0,0,1,2,-1},{8,0,0,5,0,0,0,1,2,-1},{8,0,0,9,0,0,0,1,2,-1},{8,0,0,5,0,0,0,1,2,-1},{8,0,0,9,0,0,0,1,2,-1},{8,0,0,5,0,0,0,1,2,-1},{8,0,0,9,0,0,0,1,2,-1},{8,0,0,5,0,0,0,1,2,-1},{8,0,0,9,0,0,0,1,2,-1},{8,0,0,5,0,0,0,1,2,-1},{8,0,0,9,0,0,0,1,2,-1},{8,0,0,5,0,0,0,1,2,-1}},
  {{8,0,0,9,0,0,0,1,2,-1},{8,0,0,5,0,0,0,1,2,-1},{8,0,0,26,0,0,0,1,2,-1},{8,0,0,12,0,0,17,1,9,-1},{8,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{8,0,0,12,0,0,17,1,9,-1},{8,0,0,11,0,0,17,1,9,-1},{8,0,0,11,0,0,17,1,9,-1},{8,0,0,9,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,9,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,9,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1}},
  {{8,0,0,9,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,9,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,9,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,9,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,9,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,9,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,9,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,9,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1}},
  {{8,0,0,9,1,0,0,1,2,-1},{8,0,0,9,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,9,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,9,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,9,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,9,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,9,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,9,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1}},
  {{8,0,0,9,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,9,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,9,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,9,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,9,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,9,0,0,0,1,2,-1},{8,0,0,5,0,0,0,1,2,-1},{8,0,0,9,0,0,0,1,2,-1},{8,0,0,5,0,0,0,1,2,-1},{8,0,0,9,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1}},
  {{103,0,0,2,0,0,0,1,0,-1},{3,0,0,9,1,0,0,1,2,-1},{3,0,0,9,1,0,0,1,2,-1},{3,0,0,9,1,0,0,1,2,-1},{3,0,0,9,1,0,0,1,2,-1},{3,0,0,9,1,0,0,1,2,-1},{3,0,0,9,1,0,0,1,2,-1},{3,0,0,9,1,0,0,1,2,-1},{3,0,0,9,1,0,0,1,2,-1},{3,0,0,9,1,0,0,1,2,-1},{3,0,0,9,1,0,0,1,2,-1},{3,0,0,9,1,0,0,1,2,-1},{3,0,0,9,1,0,0,1,2,-1},{3,0,0,9,1,0,0,1,2,-1},{3,0,0,9,1,0,0,1,2,-1},{3,0,0,9,1,0,0,1,2,-1}},
  {{3,0,0,9,1,0,0,1,2,-1},{3,0,0,9,1,0,0,1,2,-1},{3,0,0,9,1,0,0,1,2,-1},{3,0,0,9,1,0,0,1,2,-1},{3,0,0,9,1,0,0,1,2,-1},{3,0,0,9,1,0,0,1,2,-1},{3,0,0,9,1,0,0,1,2,-1},{3,0,0,9,1,0,0,1,2,-1},{3,0,0,9,1,0,0,1,2,-1},{3,0,0,9,1,0,0,1,2,-1},{3,0,0,9,1,0,0,1,2,-1},{3,0,0,9,1,0,0,1,2,-1},{3,0,0,9,1,0,0,1,2,-1},{3,0,0,9,1,0,0,1,2,-1},{3,0,0,9,1,0,0,1,2,-1},{3,0,0,9,1,0,0,1,2,-1}},
  {{3,0,0,9,1,0,0,1,2,-1},{3,0,0,9,1,0,0,1,2,-1},{3,0,0,9,1,0,0,1,2,-1},{3,0,0,9,1,0,0,1,2,-1},{3,0,0,9,1,0,0,1,2,-1},{3,0,0,9,1,0,0,1,2,-1},{3,0,0,9,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{3,0,0,6,1,0,0,1,2,-1},{3,0,0,21,0,0,0,1,2,-1},{3,0,0,21,0,0,0,1,2,-1},{3,0,0,21,0,0,0,1,2,-1},{3,0,0,21,0,0,0,1,2,-1},{3,0,0,21,0,0,0,1,2,-1},{3,0,0,21,0,0,0,1,2,-1}},
  {{103,0,0,2,0,0,0,1,0,-1},{3,0,0,5,1,0,0,1,2,-1},{3,0,0,5,1,0,0,1,2,-1},{3,0,0,5,1,0,0,1,2,-1},{3,0,0,5,1,0,0,1,2,-1},{3,0,0,5,1,0,0,1,2,-1},{3,0,0,5,1,0,0,1,2,-1},{3,0,0,5,1,0,0,1,2,-1},{3,0,0,5,1,0,0,1,2,-1},{3,0,0,5,1,0,0,1,2,-1},{3,0,0,5,1,0,0,1,2,-1},{3,0,0,5,1,0,0,1,2,-1},{3,0,0,5,1,0,0,1,2,-1},{3,0,0,5,1,0,0,1,2,-1},{3,0,0,5,1,0,0,1,2,-1},{3,0,0,5,1,0,0,1,2,-1}},
  {{3,0,0,5,1,0,0,1,2,-1},{3,0,0,5,1,0,0,1,2,-1},{3,0,0,5,1,0,0,1,2,-1},{3,0,0,5,1,0,0,1,2,-1},{3,0,0,5,1,0,0,1,2,-1},{3,0,0,5,1,0,0,1,2,-1},{3,0,0,5,1,0,0,1,2,-1},{3,0,0,5,1,0,0,1,2,-1},{3,0,0,5,1,0,0,1,2,-1},{3,0,0,5,1,0,0,1,2,-1},{3,0,0,5,1,0,0,1,2,-1},{3,0,0,5,1,0,0,1,2,-1},{3,0,0,5,1,0,0,1,2,-1},{3,0,0,5,1,0,0,1,2,-1},{3,0,0,5,1,0,0,1,2,-1},{3,0,0,5,1,0,0,1,2,-1}},
  {{3,0,0,5,1,0,0,1,2,-1},{3,0,0,5,1,0,0,1,2,-1},{3,0,0,5,1,0,0,1,2,-1},{3,0,0,5,1,0,0,1,2,-1},{3,0,0,5,1,0,0,1,2,-1},{3,0,0,5,1,0,0,1,2,-1},{3,0,0,5,1,0,0,1,2,-1},{3,0,0,5,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{0,0,0,21,0,0,0,1,16,-1},{3,0,0,17,1,0,10,1,4,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{3,0,0,26,0,0,10,1,2,-1},{3,0,0,26,0,0,10,1,2,-1},{3,0,0,23,0,0,4,1,22,-1}},
  {{103,0,0,2,0,0,1,1,0,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1}},
  {{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1}},
  {{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,1,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,17,0,0,1,1,4,-1},{19,0,0,12,0,0,17,1,9,-1}},
  {{19,0,0,21,0,0,1,1,2,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,21,0,0,1,1,2,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,21,0,0,1,1,11,-1},{19,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1}},
  {{19,0,0,7,1,0,1,1,38,-1},{19,0,0,7,1,0,1,1,38,-1},{19,0,0,7,1,0,1,1,38,-1},{19,0,0,7,1,0,1,1,38,-1},{19,0,0,7,1,0,1,1,38,-1},{19,0,0,7,1,0,1,1,38,-1},{19,0,0,7,1,0,1,1,38,-1},{19,0,0,7,1,0,1,1,38,-1},{19,0,0,7,1,0,1,1,38,-1},{19,0,0,7,1,0,1,1,38,-1},{19,0,0,7,1,0,1,1,38,-1},{19,0,0,7,1,0,1,1,38,-1},{19,0,0,7,1,0,1,1,38,-1},{19,0,0,7,1,0,1,1,38,-1},{19,0,0,7,1,0,1,1,38,-1},{19,0,0,7,1,0,1,1,38,-1}},
  {{19,0,0,7,1,0,1,1,38,-1},{19,0,0,7,1,0,1,1,38,-1},{19,0,0,7,1,0,1,1,38,-1},{19,0,0,7,1,0,1,1,38,-1},{19,0,0,7,1,0,1,1,38,-1},{19,0,0,7,1,0,1,1,38,-1},{19,0,0,7,1,0,1,1,38,-1},{19,0,0,7,1,0,1,1,38,-1},{19,0,0,7,1,0,1,1,38,-1},{19,0,0,7,1,0,1,1,38,-1},{19,0,0,7,1,0,1,1,38,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1}},
  {{19,0,0,7,1,0,1,1,38,-1},{19,0,0,7,1,0,1,1,38,-1},{19,0,0,7,1,0,1,1,38,-1},{19,0,0,21,1,0,1,1,2,-1},{19,0,0,21,1,0,1,1,2,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1}},
  {{2,0,0,1,0,0,5,1,2,-1},{2,0,0,1,0,0,5,1,2,-1},{2,0,0,1,0,0,5,1,2,-1},{2,0,0,1,0,0,5,1,2,-1},{2,0,0,1,0,0,5,1,2,-1},{0,0,0,1,0,0,5,1,2,-1},{2,0,0,25,0,0,10,1,2,-1},{2,0,0,25,0,0,10,1,2,-1},{2,0,0,25,0,0,13,1,2,-1},{2,0,0,21,0,0,4,1,21,-1},{2,0,0,21,0,0,4,1,21,-1},{2,0,0,23,0,0,13,1,21,-1},{0,0,0,21,0,0,6,1,16,-1},{2,0,0,21,0,0,13,1,16,-1},{2,0,0,26,0,0,10,1,2,-1},{2,0,0,26,0,0,10,1,2,-1}},
  {{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{0,0,0,21,0,0,13,1,11,-1},{0,0,0,1,0,1,13,1,9,-1},{103,0,0,2,0,0,13,1,0,-1},{2,0,0,21,0,0,13,1,11,-1},{0,0,0,21,0,0,13,1,11,-1}},
  {{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1}},
  {{0,0,0,6,0,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,1,0,17,1,9,-1}},
  {{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,1,0,17,1,9,-1},{1,0,0,12,1,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1}},
  {{2,0,0,13,1,0,5,1,19,0},{2,0,0,13,1,0,5,1,19,1},{2,0,0,13,1,0,5,1,19,2},{2,0,0,13,1,0,5,1,19,3},{2,0,0,13,1,0,5,1,19,4},{2,0,0,13,1,0,5,1,19,5},{2,0,0,13,1,0,5,1,19,6},{2,0,0,13,1,0,5,1,19,7},{2,0,0,13,1,0,5,1,19,8},{2,0,0,13,1,0,5,1,19,9},{2,0,0,21,0,0,4,1,21,-1},{2,0,0,21,0,0,5,1,19,-1},{2,0,0,21,0,0,5,1,19,-1},{2,0,0,21,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1}},
  {{1,0,0,12,1,0,17,1,9,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1}},
  {{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1}},
  {{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,21,0,0,13,1,11,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{0,0,0,1,0,0,5,1,2,-1},{2,0,0,26,0,0,10,1,2,-1},{2,0,0,12,0,0,17,1,9,-1}},
  {{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,6,1,0,13,1,2,-1},{2,0,0,6,1,0,13,1,2,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,26,0,0,10,1,2,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1}},
  {{2,0,0,13,1,0,2,1,19,0},{2,0,0,13,1,0,2,1,19,1},{2,0,0,13,1,0,2,1,19,2},{2,0,0,13,1,0,2,1,19,3},{2,0,0,13,1,0,2,1,19,4},{2,0,0,13,1,0,2,1,19,5},{2,0,0,13,1,0,2,1,19,6},{2,0,0,13,1,0,2,1,19,7},{2,0,0,13,1,0,2,1,19,8},{2,0,0,13,1,0,2,1,19,9},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,26,1,0,13,1,2,-1},{2,0,0,26,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1}},
  {{34,0,0,21,0,0,13,1,2,-1},{34,0,0,21,0,0,13,1,2,-1},{34,0,0,21,0,0,13,1,2,-1},{34,0,0,21,0,0,13,1,2,-1},{34,0,0,21,0,0,13,1,2,-1},{34,0,0,21,0,0,13,1,2,-1},{34,0,0,21,0,0,13,1,2,-1},{34,0,0,21,0,0,13,1,2,-1},{34,0,0,21,0,0,13,1,2,-1},{34,0,0,21,0,0,13,1,2,-1},{34,0,0,21,0,0,13,1,2,-1},{34,0,0,21,0,0,13,1,2,-1},{34,0,0,21,0,0,13,1,2,-1},{34,0,0,21,0,0,13,1,2,-1},{103,0,0,2,0,0,13,1,0,-1},{34,0,0,1,0,0,13,1,2,-1}},
  {{34,0,0,7,0,0,13,1,2,-1},{34,0,0,12,0,0,17,1,9,-1},{34,0,0,7,0,0,13,1,2,-1},{34,0,0,7,0,0,13,1,2,-1},{34,0,0,7,0,0,13,1,2,-1},{34,0,0,7,0,0,13,1,2,-1},{34,0,0,7,0,0,13,1,2,-1},{34,0,0,7,0,0,13,1,2,-1},{34,0,0,7,0,0,13,1,2,-1},{34,0,0,7,0,0,13,1,2,-1},{34,0,0,7,0,0,13,1,2,-1},{34,0,0,7,0,0,13,1,2,-1},{34,0,0,7,0,0,13,1,2,-1},{34,0,0,7,0,0,13,1,2,-1},{34,0,0,7,0,0,13,1,2,-1},{34,0,0,7,0,0,13,1,2,-1}},
  {{34,0,0,7,0,0,13,1,2,-1},{34,0,0,7,0,0,13,1,2,-1},{34,0,0,7,0,0,13,1,2,-1},{34,0,0,7,0,0,13,1,2,-1},{34,0,0,7,0,0,13,1,2,-1},{34,0,0,7,0,0,13,1,2,-1},{34,0,0,7,0,0,13,1,2,-1},{34,0,0,7,0,0,13,1,2,-1},{34,0,0,7,0,0,13,1,2,-1},{34,0,0,7,0,0,13,1,2,-1},{34,0,0,7,0,0,13,1,2,-1},{34,0,0,7,0,0,13,1,2,-1},{34,0,0,7,0,0,13,1,2,-1},{34,0,0,7,0,0,13,1,2,-1},{34,0,0,7,0,0,13,1,2,-1},{34,0,0,7,0,0,13,1,2,-1}},
  {{34,0,0,12,0,0,17,1,9,-1},{34,0,0,12,0,0,17,1,9,-1},{34,0,0,12,0,0,17,1,9,-1},{34,0,0,12,0,0,17,1,9,-1},{34,0,0,12,0,0,17,1,9,-1},{34,0,0,12,0,0,17,1,9,-1},{34,0,0,12,0,0,17,1,9,-1},{34,0,0,12,0,0,17,1,9,-1},{34,0,0,12,0,0,17,1,9,-1},{34,0,0,12,0,0,17,1,9,-1},{34,0,0,12,0,0,17,1,9,-1},{34,0,0,12,0,0,17,1,9,-1},{34,0,0,12,0,0,17,1,9,-1},{34,0,0,12,0,0,17,1,9,-1},{34,0,0,12,0,0,17,1,9,-1},{34,0,0,12,0,0,17,1,9,-1}},
  {{34,0,0,12,0,0,17,1,9,-1},{34,0,0,12,0,0,17,1,9,-1},{34,0,0,12,0,0,17,1,9,-1},{34,0,0,12,0,0,17,1,9,-1},{34,0,0,12,0,0,17,1,9,-1},{34,0,0,12,0,0,17,1,9,-1},{34,0,0,12,0,0,17,1,9,-1},{34,0,0,12,0,0,17,1,9,-1},{34,0,0,12,0,0,17,1,9,-1},{34,0,0,12,0,0,17,1,9,-1},{34,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{34,0,0,7,0,0,13,1,2,-1},{34,0,0,7,0,0,13,1,2,-1},{34,0,0,7,0,0,13,1,2,-1}},
  {{37,0,0,7,1,0,13,1,2,-1},{37,0,0,7,1,0,13,1,2,-1},{37,0,0,7,1,0,13,1,2,-1},{37,0,0,7,1,0,13,1,2,-1},{37,0,0,7,1,0,13,1,2,-1},{37,0,0,7,1,0,13,1,2,-1},{37,0,0,7,1,0,13,1,2,-1},{37,0,0,7,1,0,13,1,2,-1},{37,0,0,7,1,0,13,1,2,-1},{37,0,0,7,1,0,13,1,2,-1},{37,0,0,7,1,0,13,1,2,-1},{37,0,0,7,1,0,13,1,2,-1},{37,0,0,7,1,0,13,1,2,-1},{37,0,0,7,1,0,13,1,2,-1},{37,0,0,7,1,0,13,1,2,-1},{37,0,0,7,1,0,13,1,2,-1}},
  {{37,0,0,7,1,0,13,1,2,-1},{37,0,0,7,1,0,13,1,2,-1},{37,0,0,7,1,0,13,1,2,-1},{37,0,0,7,1,0,13,1,2,-1},{37,0,0,7,1,0,13,1,2,-1},{37,0,0,7,1,0,13,1,2,-1},{37,0,0,12,1,0,17,1,9,-1},{37,0,0,12,1,0,17,1,9,-1},{37,0,0,12,1,0,17,1,9,-1},{37,0,0,12,1,0,17,1,9,-1},{37,0,0,12,1,0,17,1,9,-1},{37,0,0,12,1,0,17,1,9,-1},{37,0,0,12,1,0,17,1,9,-1},{37,0,0,12,1,0,17,1,9,-1},{37,0,0,12,1,0,17,1,9,-1},{37,0,0,12,1,0,17,1,9,-1}},
  {{37,0,0,12,1,0,17,1,9,-1},{37,0,0,7,1,0,13,1,2,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1}},
  {{87,0,0,13,0,0,1,1,19,0},{87,0,0,13,0,0,1,1,19,1},{87,0,0,13,0,0,1,1,19,2},{87,0,0,13,0,0,1,1,19,3},{87,0,0,13,0,0,1,1,19,4},{87,0,0,13,0,0,1,1,19,5},{87,0,0,13,0,0,1,1,19,6},{87,0,0,13,0,0,1,1,19,7},{87,0,0,13,0,0,1,1,19,8},{87,0,0,13,0,0,1,1,19,9},{87,0,0,7,0,0,1,1,2,-1},{87,0,0,7,0,0,1,1,2,-1},{87,0,0,7,0,0,1,1,2,-1},{87,0,0,7,0,0,1,1,2,-1},{87,0,0,7,0,0,1,1,2,-1},{87,0,0,7,0,0,1,1,2,-1}},
  {{87,0,0,7,0,0,1,1,2,-1},{87,0,0,7,0,0,1,1,2,-1},{87,0,0,7,0,0,1,1,2,-1},{87,0,0,7,0,0,1,1,2,-1},{87,0,0,7,0,0,1,1,2,-1},{87,0,0,7,0,0,1,1,2,-1},{87,0,0,7,0,0,1,1,2,-1},{87,0,0,7,0,0,1,1,2,-1},{87,0,0,7,0,0,1,1,2,-1},{87,0,0,7,0,0,1,1,2,-1},{87,0,0,7,0,0,1,1,2,-1},{87,0,0,7,0,0,1,1,2,-1},{87,0,0,7,0,0,1,1,2,-1},{87,0,0,7,0,0,1,1,2,-1},{87,0,0,7,0,0,1,1,2,-1},{87,0,0,7,0,0,1,1,2,-1}},
  {{87,0,0,7,0,0,1,1,2,-1},{87,0,0,7,0,0,1,1,2,-1},{87,0,0,7,0,0,1,1,2,-1},{87,0,0,7,0,0,1,1,2,-1},{87,0,0,7,0,0,1,1,2,-1},{87,0,0,7,0,0,1,1,2,-1},{87,0,0,7,0,0,1,1,2,-1},{87,0,0,7,0,0,1,1,2,-1},{87,0,0,7,0,0,1,1,2,-1},{87,0,0,7,0,0,1,1,2,-1},{87,0,0,7,0,0,1,1,2,-1},{87,0,0,12,0,0,17,1,9,-1},{87,0,0,12,0,0,17,1,9,-1},{87,0,0,12,0,0,17,1,9,-1},{87,0,0,12,0,0,17,1,9,-1},{87,0,0,12,0,0,17,1,9,-1}},
  {{87,0,0,12,0,0,17,1,9,-1},{87,0,0,12,0,0,17,1,9,-1},{87,0,0,12,0,0,17,1,9,-1},{87,0,0,12,0,0,17,1,9,-1},{87,0,0,6,0,0,1,1,2,-1},{87,0,0,6,0,0,1,1,2,-1},{87,0,0,26,0,0,10,1,2,-1},{87,0,0,21,0,0,10,1,2,-1},{87,0,0,21,0,0,10,1,16,-1},{87,0,0,21,0,0,10,1,11,-1},{87,0,0,6,0,0,1,1,2,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1}},
  {{126,0,0,7,0,0,1,1,2,-1},{126,0,0,7,0,0,1,1,2,-1},{126,0,0,7,0,0,1,1,2,-1},{126,0,0,7,0,0,1,1,2,-1},{126,0,0,7,0,0,1,1,2,-1},{126,0,0,7,0,0,1,1,2,-1},{126,0,0,7,0,0,1,1,2,-1},{126,0,0,7,0,0,1,1,2,-1},{126,0,0,7,0,0,1,1,2,-1},{126,0,0,7,0,0,1,1,2,-1},{126,0,0,7,0,0,1,1,2,-1},{126,0,0,7,0,0,1,1,2,-1},{126,0,0,7,0,0,1,1,2,-1},{126,0,0,7,0,0,1,1,2,-1},{126,0,0,7,0,0,1,1,2,-1},{126,0,0,7,0,0,1,1,2,-1}},
  {{126,0,0,7,0,0,1,1,2,-1},{126,0,0,7,0,0,1,1,2,-1},{126,0,0,7,0,0,1,1,2,-1},{126,0,0,7,0,0,1,1,2,-1},{126,0,0,7,0,0,1,1,2,-1},{126,0,0,7,0,0,1,1,2,-1},{126,0,0,12,0,0,17,1,9,-1},{126,0,0,12,0,0,17,1,9,-1},{126,0,0,12,0,0,17,1,9,-1},{126,0,0,12,0,0,17,1,9,-1},{126,0,0,6,0,0,1,1,2,-1},{126,0,0,12,0,0,17,1,9,-1},{126,0,0,12,0,0,17,1,9,-1},{126,0,0,12,0,0,17,1,9,-1},{126,0,0,12,0,0,17,1,9,-1},{126,0,0,12,0,0,17,1,9,-1}},
  {{126,0,0,12,0,0,17,1,9,-1},{126,0,0,12,0,0,17,1,9,-1},{126,0,0,12,0,0,17,1,9,-1},{126,0,0,12,0,0,17,1,9,-1},{126,0,0,6,0,0,1,1,2,-1},{126,0,0,12,0,0,17,1,9,-1},{126,0,0,12,0,0,17,1,9,-1},{126,0,0,12,0,0,17,1,9,-1},{126,0,0,6,0,0,1,1,2,-1},{126,0,0,12,0,0,17,1,9,-1},{126,0,0,12,0,0,17,1,9,-1},{126,0,0,12,0,0,17,1,9,-1},{126,0,0,12,0,0,17,1,9,-1},{126,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1}},
  {{126,0,0,21,0,0,1,1,2,-1},{126,0,0,21,0,0,1,1,2,-1},{126,0,0,21,0,0,1,1,2,-1},{126,0,0,21,0,0,1,1,2,-1},{126,0,0,21,0,0,1,1,2,-1},{126,0,0,21,0,0,1,1,2,-1},{126,0,0,21,0,0,1,1,2,-1},{126,0,0,21,0,0,1,1,2,-1},{126,0,0,21,0,0,1,1,2,-1},{126,0,0,21,0,0,1,1,2,-1},{126,0,0,21,0,0,1,1,2,-1},{126,0,0,21,0,0,1,1,2,-1},{126,0,0,21,0,0,1,1,2,-1},{126,0,0,21,0,0,1,1,2,-1},{126,0,0,21,0,0,1,1,2,-1},{103,0,0,2,0,0,1,1,0,-1}},
  {{84,0,0,7,0,0,1,1,2,-1},{84,0,0,7,0,0,1,1,2,-1},{84,0,0,7,0,0,1,1,2,-1},{84,0,0,7,0,0,1,1,2,-1},{84,0,0,7,0,0,1,1,2,-1},{84,0,0,7,0,0,1,1,2,-1},{84,0,0,7,0,0,1,1,2,-1},{84,0,0,7,0,0,1,1,2,-1},{84,0,0,7,0,0,1,1,2,-1},{84,0,0,7,0,0,1,1,2,-1},{84,0,0,7,0,0,1,1,2,-1},{84,0,0,7,0,0,1,1,2,-1},{84,0,0,7,0,0,1,1,2,-1},{84,0,0,7,0,0,1,1,2,-1},{84,0,0,7,0,0,1,1,2,-1},{84,0,0,7,0,0,1,1,2,-1}},
  {{84,0,0,7,0,0,1,1,2,-1},{84,0,0,7,0,0,1,1,2,-1},{84,0,0,7,0,0,1,1,2,-1},{84,0,0,7,0,0,1,1,2,-1},{84,0,0,7,0,0,1,1,2,-1},{84,0,0,7,0,0,1,1,2,-1},{84,0,0,7,0,0,1,1,2,-1},{84,0,0,7,0,0,1,1,2,-1},{84,0,0,7,0,0,1,1,2,-1},{84,0,0,12,0,0,17,1,9,-1},{84,0,0,12,0,0,17,1,9,-1},{84,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{84,0,0,21,0,0,1,1,2,-1},{103,0,0,2,0,0,1,1,0,-1}},
  {{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1}},
  {{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1}},
  {{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{103,0,0,2,0,0,13,1,0,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{2,0,0,7,1,0,13,1,2,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1}},
  {{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1}},
  {{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1}},
  {{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{0,0,0,1,0,0,5,1,2,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1}},
  {{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1},{2,0,0,12,0,0,17,1,9,-1}},
  {{10,0,0,12,0,0,17,1,9,-1},{10,0,0,12,1,0,17,1,9,-1},{10,0,0,12,1,0,17,1,9,-1},{10,0,0,10,1,0,0,1,9,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1}},
  {{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1}},
  {{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,12,1,0,17,1,9,-1},{10,0,0,10,1,0,0,1,9,-1},{10,0,0,12,1,0,17,1,9,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,10,1,0,0,1,9,-1},{10,0,0,10,1,0,0,1,9,-1}},
  {{10,0,0,10,1,0,0,1,9,-1},{10,0,0,12,1,0,17,1,9,-1},{10,0,0,12,1,0,17,1,9,-1},{10,0,0,12,1,0,17,1,9,-1},{10,0,0,12,1,0,17,1,9,-1},{10,0,0,12,1,0,17,1,9,-1},{10,0,0,12,1,0,17,1,9,-1},{10,0,0,12,1,0,17,1,9,-1},{10,0,0,12,1,0,17,1,9,-1},{10,0,0,10,1,0,0,1,9,-1},{10,0,0,10,1,0,0,1,9,-1},{10,0,0,10,1,0,0,1,9,-1},{10,0,0,10,1,0,0,1,9,-1},{10,0,0,12,1,0,17,1,9,-1},{10,0,0,10,0,0,0,1,9,-1},{10,0,0,10,1,0,0,1,9,-1}},
  {{10,0,0,7,1,0,0,1,2,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{10,0,0,12,0,0,17,1,9,-1},{10,0,0,12,0,0,17,1,9,-1},{10,0,0,12,0,0,17,1,9,-1},{10,0,0,12,1,0,17,1,9,-1},{10,0,0,12,1,0,17,1,9,-1},{10,0,0,7,0,0,0,1,2,-1},{10,0,0,7,0,0,0,1,2,-1},{10,0,0,7,0,0,0,1,2,-1},{10,0,0,7,0,0,0,1,2,-1},{10,0,0,7,0,0,0,1,2,-1},{10,0,0,7,0,0,0,1,2,-1},{10,0,0,7,0,0,0,1,2,-1},{10,0,0,7,0,0,0,1,2,-1}},
  {{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,12,1,0,17,1,9,-1},{10,0,0,12,1,0,17,1,9,-1},{0,0,0,21,0,0,0,1,4,-1},{0,0,0,21,0,0,0,1,4,-1},{10,0,0,13,1,0,0,1,19,0},{10,0,0,13,1,0,0,1,19,1},{10,0,0,13,1,0,0,1,19,2},{10,0,0,13,1,0,0,1,19,3},{10,0,0,13,1,0,0,1,19,4},{10,0,0,13,1,0,0,1,19,5},{10,0,0,13,1,0,0,1,19,6},{10,0,0,13,1,0,0,1,19,7},{10,0,0,13,1,0,0,1,19,8},{10,0,0,13,1,0,0,1,19,9}},
  {{10,0,0,21,0,0,0,1,2,-1},{10,0,0,6,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,0,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1},{10,0,0,7,1,0,0,1,2,-1}},
  {{4,0,0,7,0,0,0,1,2,-1},{4,0,0,12,1,0,17,1,9,-1},{4,0,0,10,1,0,0,1,9,-1},{4,0,0,10,1,0,0,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{4,0,0,7,1,0,0,1,2,-1},{4,0,0,7,1,0,0,1,2,-1},{4,0,0,7,1,0,0,1,2,-1},{4,0,0,7,1,0,0,1,2,-1},{4,0,0,7,1,0,0,1,2,-1},{4,0,0,7,1,0,0,1,2,-1},{4,0,0,7,1,0,0,1,2,-1},{4,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{4,0,0,7,1,0,0,1,2,-1}},
  {{4,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{4,0,0,7,1,0,0,1,2,-1},{4,0,0,7,1,0,0,1,2,-1},{4,0,0,7,1,0,0,1,2,-1},{4,0,0,7,1,0,0,1,2,-1},{4,0,0,7,1,0,0,1,2,-1},{4,0,0,7,1,0,0,1,2,-1},{4,0,0,7,1,0,0,1,2,-1},{4,0,0,7,1,0,0,1,2,-1},{4,0,0,7,1,0,0,1,2,-1},{4,0,0,7,1,0,0,1,2,-1},{4,0,0,7,1,0,0,1,2,-1},{4,0,0,7,1,0,0,1,2,-1},{4,0,0,7,1,0,0,1,2,-1}},
  {{4,0,0,7,1,0,0,1,2,-1},{4,0,0,7,1,0,0,1,2,-1},{4,0,0,7,1,0,0,1,2,-1},{4,0,0,7,1,0,0,1,2,-1},{4,0,0,7,1,0,0,1,2,-1},{4,0,0,7,1,0,0,1,2,-1},{4,0,0,7,1,0,0,1,2,-1},{4,0,0,7,1,0,0,1,2,-1},{4,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{4,0,0,7,1,0,0,1,2,-1},{4,0,0,7,1,0,0,1,2,-1},{4,0,0,7,1,0,0,1,2,-1},{4,0,0,7,1,0,0,1,2,-1},{4,0,0,7,1,0,0,1,2,-1},{4,0,0,7,1,0,0,1,2,-1}},
  {{4,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{4,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{4,0,0,7,1,0,0,1,2,-1},{4,0,0,7,1,0,0,1,2,-1},{4,0,0,7,1,0,0,1,2,-1},{4,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{4,0,0,12,1,0,17,1,9,-1},{4,0,0,7,1,0,0,1,2,-1},{4,0,0,10,1,0,0,1,9,-1},{4,0,0,10,1,0,0,1,9,-1}},
  {{4,0,0,10,1,0,0,1,9,-1},{4,0,0,12,1,0,17,1,9,-1},{4,0,0,12,1,0,17,1,9,-1},{4,0,0,12,1,0,17,1,9,-1},{4,0,0,12,1,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{4,0,0,10,1,0,0,1,9,-1},{4,0,0,10,1,0,0,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{4,0,0,10,1,0,0,1,9,-1},{4,0,0,10,1,0,0,1,9,-1},{4,0,0,12,1,0,17,1,9,-1},{4,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{4,0,0,10,1,0,0,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{4,0,0,7,0,0,0,1,2,-1},{4,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{4,0,0,7,0,0,0,1,2,-1}},
  {{4,0,0,7,1,0,0,1,2,-1},{4,0,0,7,1,0,0,1,2,-1},{4,0,0,12,1,0,17,1,9,-1},{4,0,0,12,1,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{4,0,0,13,1,0,0,1,19,0},{4,0,0,13,1,0,0,1,19,1},{4,0,0,13,1,0,0,1,19,2},{4,0,0,13,1,0,0,1,19,3},{4,0,0,13,1,0,0,1,19,4},{4,0,0,13,1,0,0,1,19,5},{4,0,0,13,1,0,0,1,19,6},{4,0,0,13,1,0,0,1,19,7},{4,0,0,13,1,0,0,1,19,8},{4,0,0,13,1,0,0,1,19,9}},
  {{4,0,0,7,1,0,0,1,2,-1},{4,0,0,7,1,0,0,1,2,-1},{4,0,0,23,0,0,4,1,21,-1},{4,0,0,23,0,0,4,1,21,-1},{4,0,0,15,0,0,0,1,2,-1},{4,0,0,15,0,0,0,1,2,-1},{4,0,0,15,0,0,0,1,2,-1},{4,0,0,15,0,0,0,1,2,-1},{4,0,0,15,0,0,0,1,2,-1},{4,0,0,15,0,0,0,1,21,-1},{4,0,0,26,0,0,0,1,2,-1},{4,0,0,23,0,0,4,1,22,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{103,0,0,2,0,0,0,1,0,-1},{16,0,0,12,1,0,17,1,9,-1},{16,0,0,12,1,0,17,1,9,-1},{16,0,0,10,1,0,0,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{16,0,0,7,1,0,0,1,2,-1},{16,0,0,7,1,0,0,1,2,-1},{16,0,0,7,1,0,0,1,2,-1},{16,0,0,7,1,0,0,1,2,-1},{16,0,0,7,1,0,0,1,2,-1},{16,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{16,0,0,7,1,0,0,1,2,-1}},
  {{16,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{16,0,0,7,1,0,0,1,2,-1},{16,0,0,7,1,0,0,1,2,-1},{16,0,0,7,1,0,0,1,2,-1},{16,0,0,7,1,0,0,1,2,-1},{16,0,0,7,1,0,0,1,2,-1},{16,0,0,7,1,0,0,1,2,-1},{16,0,0,7,1,0,0,1,2,-1},{16,0,0,7,1,0,0,1,2,-1},{16,0,0,7,1,0,0,1,2,-1},{16,0,0,7,1,0,0,1,2,-1},{16,0,0,7,1,0,0,1,2,-1},{16,0,0,7,1,0,0,1,2,-1},{16,0,0,7,1,0,0,1,2,-1}},
  {{16,0,0,7,1,0,0,1,2,-1},{16,0,0,7,1,0,0,1,2,-1},{16,0,0,7,1,0,0,1,2,-1},{16,0,0,7,1,0,0,1,2,-1},{16,0,0,7,1,0,0,1,2,-1},{16,0,0,7,1,0,0,1,2,-1},{16,0,0,7,1,0,0,1,2,-1},{16,0,0,7,1,0,0,1,2,-1},{16,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{16,0,0,7,1,0,0,1,2,-1},{16,0,0,7,1,0,0,1,2,-1},{16,0,0,7,1,0,0,1,2,-1},{16,0,0,7,1,0,0,1,2,-1},{16,0,0,7,1,0,0,1,2,-1},{16,0,0,7,1,0,0,1,2,-1}},
  {{16,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{16,0,0,7,1,0,0,1,2,-1},{16,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{16,0,0,7,1,0,0,1,2,-1},{16,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{16,0,0,7,1,0,0,1,2,-1},{16,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{16,0,0,12,1,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{16,0,0,10,1,0,0,1,9,-1},{16,0,0,10,1,0,0,1,9,-1}},
  {{16,0,0,10,1,0,0,1,9,-1},{16,0,0,12,1,0,17,1,9,-1},{16,0,0,12,1,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{16,0,0,12,1,0,17,1,9,-1},{16,0,0,12,1,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{16,0,0,12,1,0,17,1,9,-1},{16,0,0,12,1,0,17,1,9,-1},{16,0,0,12,1,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{103,0,0,2,0,0,0,1,0,-1},{16,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{16,0,0,7,0,0,0,1,2,-1},{16,0,0,7,0,0,0,1,2,-1},{16,0,0,7,0,0,0,1,2,-1},{16,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{16,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{16,0,0,13,1,0,0,1,19,0},{16,0,0,13,1,0,0,1,19,1},{16,0,0,13,1,0,0,1,19,2},{16,0,0,13,1,0,0,1,19,3},{16,0,0,13,1,0,0,1,19,4},{16,0,0,13,1,0,0,1,19,5},{16,0,0,13,1,0,0,1,19,6},{16,0,0,13,1,0,0,1,19,7},{16,0,0,13,1,0,0,1,19,8},{16,0,0,13,1,0,0,1,19,9}},
  {{16,0,0,12,1,0,17,1,9,-1},{16,0,0,12,1,0,17,1,9,-1},{16,0,0,7,1,0,0,1,2,-1},{16,0,0,7,1,0,0,1,2,-1},{16,0,0,7,1,0,0,1,2,-1},{16,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{103,0,0,2,0,0,0,1,0,-1},{15,0,0,12,1,0,17,1,9,-1},{15,0,0,12,1,0,17,1,9,-1},{15,0,0,10,1,0,0,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{15,0,0,7,1,0,0,1,2,-1}},
  {{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1}},
  {{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1}},
  {{15,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{15,0,0,12,1,0,17,1,9,-1},{15,0,0,7,1,0,0,1,2,-1},{15,0,0,10,1,0,0,1,9,-1},{15,0,0,10,1,0,0,1,9,-1}},
  {{15,0,0,10,1,0,0,1,9,-1},{15,0,0,12,1,0,17,1,9,-1},{15,0,0,12,1,0,17,1,9,-1},{15,0,0,12,1,0,17,1,9,-1},{15,0,0,12,1,0,17,1,9,-1},{15,0,0,12,1,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{15,0,0,12,1,0,17,1,9,-1},{15,0,0,12,1,0,17,1,9,-1},{15,0,0,10,1,0,0,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{15,0,0,10,1,0,0,1,9,-1},{15,0,0,10,1,0,0,1,9,-1},{15,0,0,12,1,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{15,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{15,0,0,7,1,0,0,1,2,-1},{15,0,0,7,1,0,0,1,2,-1},{15,0,0,12,1,0,17,1,9,-1},{15,0,0,12,1,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{15,0,0,13,1,0,0,1,19,0},{15,0,0,13,1,0,0,1,19,1},{15,0,0,13,1,0,0,1,19,2},{15,0,0,13,1,0,0,1,19,3},{15,0,0,13,1,0,0,1,19,4},{15,0,0,13,1,0,0,1,19,5},{15,0,0,13,1,0,0,1,19,6},{15,0,0,13,1,0,0,1,19,7},{15,0,0,13,1,0,0,1,19,8},{15,0,0,13,1,0,0,1,19,9}},
  {{15,0,0,21,0,0,0,1,2,-1},{15,0,0,23,0,0,4,1,22,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{15,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{103,0,0,2,0,0,0,1,0,-1},{31,0,0,12,1,0,17,1,9,-1},{31,0,0,10,1,0,0,1,9,-1},{31,0,0,10,1,0,0,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{31,0,0,7,1,0,0,1,2,-1},{31,0,0,7,1,0,0,1,2,-1},{31,0,0,7,1,0,0,1,2,-1},{31,0,0,7,1,0,0,1,2,-1},{31,0,0,7,1,0,0,1,2,-1},{31,0,0,7,1,0,0,1,2,-1},{31,0,0,7,1,0,0,1,2,-1},{31,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{31,0,0,7,1,0,0,1,2,-1}},
  {{31,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{31,0,0,7,1,0,0,1,2,-1},{31,0,0,7,1,0,0,1,2,-1},{31,0,0,7,1,0,0,1,2,-1},{31,0,0,7,1,0,0,1,2,-1},{31,0,0,7,1,0,0,1,2,-1},{31,0,0,7,1,0,0,1,2,-1},{31,0,0,7,1,0,0,1,2,-1},{31,0,0,7,1,0,0,1,2,-1},{31,0,0,7,1,0,0,1,2,-1},{31,0,0,7,1,0,0,1,2,-1},{31,0,0,7,1,0,0,1,2,-1},{31,0,0,7,1,0,0,1,2,-1},{31,0,0,7,1,0,0,1,2,-1}},
  {{31,0,0,7,1,0,0,1,2,-1},{31,0,0,7,1,0,0,1,2,-1},{31,0,0,7,1,0,0,1,2,-1},{31,0,0,7,1,0,0,1,2,-1},{31,0,0,7,1,0,0,1,2,-1},{31,0,0,7,1,0,0,1,2,-1},{31,0,0,7,1,0,0,1,2,-1},{31,0,0,7,1,0,0,1,2,-1},{31,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{31,0,0,7,1,0,0,1,2,-1},{31,0,0,7,1,0,0,1,2,-1},{31,0,0,7,1,0,0,1,2,-1},{31,0,0,7,1,0,0,1,2,-1},{31,0,0,7,1,0,0,1,2,-1},{31,0,0,7,1,0,0,1,2,-1}},
  {{31,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{31,0,0,7,1,0,0,1,2,-1},{31,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{31,0,0,7,1,0,0,1,2,-1},{31,0,0,7,1,0,0,1,2,-1},{31,0,0,7,1,0,0,1,2,-1},{31,0,0,7,1,0,0,1,2,-1},{31,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{31,0,0,12,1,0,17,1,9,-1},{31,0,0,7,1,0,0,1,2,-1},{31,0,0,10,1,0,0,1,9,-1},{31,0,0,12,1,0,17,1,9,-1}},
  {{31,0,0,10,1,0,0,1,9,-1},{31,0,0,12,1,0,17,1,9,-1},{31,0,0,12,1,0,17,1,9,-1},{31,0,0,12,1,0,17,1,9,-1},{31,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{31,0,0,10,1,0,0,1,9,-1},{31,0,0,10,1,0,0,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{31,0,0,10,1,0,0,1,9,-1},{31,0,0,10,1,0,0,1,9,-1},{31,0,0,12,1,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{31,0,0,12,1,0,17,1,9,-1},{31,0,0,10,1,0,0,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{31,0,0,7,0,0,0,1,2,-1},{31,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{31,0,0,7,1,0,0,1,2,-1}},
  {{31,0,0,7,1,0,0,1,2,-1},{31,0,0,7,1,0,0,1,2,-1},{31,0,0,12,0,0,17,1,9,-1},{31,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{31,0,0,13,1,0,0,1,19,0},{31,0,0,13,1,0,0,1,19,1},{31,0,0,13,1,0,0,1,19,2},{31,0,0,13,1,0,0,1,19,3},{31,0,0,13,1,0,0,1,19,4},{31,0,0,13,1,0,0,1,19,5},{31,0,0,13,1,0,0,1,19,6},{31,0,0,13,1,0,0,1,19,7},{31,0,0,13,1,0,0,1,19,8},{31,0,0,13,1,0,0,1,19,9}},
  {{31,0,0,26,0,0,0,1,2,-1},{31,0,0,7,1,0,0,1,2,-1},{31,0,0,15,0,0,0,1,2,-1},{31,0,0,15,0,0,0,1,2,-1},{31,0,0,15,0,0,0,1,2,-1},{31,0,0,15,0,0,0,1,2,-1},{31,0,0,15,0,0,0,1,2,-1},{31,0,0,15,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{35,0,0,12,1,0,17,1,9,-1},{35,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{35,0,0,7,1,0,0,1,2,-1},{35,0,0,7,1,0,0,1,2,-1},{35,0,0,7,1,0,0,1,2,-1},{35,0,0,7,1,0,0,1,2,-1},{35,0,0,7,1,0,0,1,2,-1},{35,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{35,0,0,7,1,0,0,1,2,-1},{35,0,0,7,1,0,0,1,2,-1}},
  {{35,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{35,0,0,7,1,0,0,1,2,-1},{35,0,0,7,1,0,0,1,2,-1},{35,0,0,7,1,0,0,1,2,-1},{35,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{35,0,0,7,1,0,0,1,2,-1},{35,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{35,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{35,0,0,7,1,0,0,1,2,-1},{35,0,0,7,1,0,0,1,2,-1}},
  {{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{35,0,0,7,1,0,0,1,2,-1},{35,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{35,0,0,7,1,0,0,1,2,-1},{35,0,0,7,1,0,0,1,2,-1},{35,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{35,0,0,7,1,0,0,1,2,-1},{35,0,0,7,1,0,0,1,2,-1}},
  {{35,0,0,7,1,0,0,1,2,-1},{35,0,0,7,1,0,0,1,2,-1},{35,0,0,7,1,0,0,1,2,-1},{35,0,0,7,1,0,0,1,2,-1},{35,0,0,7,1,0,0,1,2,-1},{35,0,0,7,1,0,0,1,2,-1},{35,0,0,7,1,0,0,1,2,-1},{35,0,0,7,1,0,0,1,2,-1},{35,0,0,7,1,0,0,1,2,-1},{35,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{35,0,0,10,1,0,0,1,9,-1},{35,0,0,10,1,0,0,1,9,-1}},
  {{35,0,0,12,1,0,17,1,9,-1},{35,0,0,10,1,0,0,1,9,-1},{35,0,0,10,1,0,0,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{35,0,0,10,1,0,0,1,9,-1},{35,0,0,10,1,0,0,1,9,-1},{35,0,0,10,1,0,0,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{35,0,0,10,1,0,0,1,9,-1},{35,0,0,10,1,0,0,1,9,-1},{35,0,0,10,1,0,0,1,9,-1},{35,0,0,12,1,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{35,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{35,0,0,10,1,0,0,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{35,0,0,13,1,0,0,1,19,0},{35,0,0,13,1,0,0,1,19,1},{35,0,0,13,1,0,0,1,19,2},{35,0,0,13,1,0,0,1,19,3},{35,0,0,13,1,0,0,1,19,4},{35,0,0,13,1,0,0,1,19,5},{35,0,0,13,1,0,0,1,19,6},{35,0,0,13,1,0,0,1,19,7},{35,0,0,13,1,0,0,1,19,8},{35,0,0,13,1,0,0,1,19,9}},
  {{35,0,0,15,0,0,0,1,2,-1},{35,0,0,15,0,0,0,1,2,-1},{35,0,0,15,0,0,0,1,2,-1},{35,0,0,26,0,0,10,1,2,-1},{35,0,0,26,0,0,10,1,2,-1},{35,0,0,26,0,0,10,1,2,-1},{35,0,0,26,0,0,10,1,2,-1},{35,0,0,26,0,0,10,1,2,-1},{35,0,0,26,0,0,10,1,2,-1},{35,0,0,23,0,0,4,1,22,-1},{35,0,0,26,0,0,10,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{36,0,0,12,0,0,17,1,9,-1},{36,0,0,10,1,0,0,1,9,-1},{36,0,0,10,1,0,0,1,9,-1},{36,0,0,10,1,0,0,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1}},
  {{36,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1}},
  {{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1}},
  {{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,0,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,12,1,0,17,1,9,-1},{36,0,0,12,1,0,17,1,9,-1}},
  {{36,0,0,12,1,0,17,1,9,-1},{36,0,0,10,1,0,0,1,9,-1},{36,0,0,10,1,0,0,1,9,-1},{36,0,0,10,1,0,0,1,9,-1},{36,0,0,10,1,0,0,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{36,0,0,12,1,0,17,1,9,-1},{36,0,0,12,1,0,17,1,9,-1},{36,0,0,12,1,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{36,0,0,12,1,0,17,1,9,-1},{36,0,0,12,1,0,17,1,9,-1},{36,0,0,12,1,0,17,1,9,-1},{36,0,0,12,1,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{36,0,0,12,1,0,17,1,9,-1},{36,0,0,12,1,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{36,0,0,7,0,0,0,1,2,-1},{36,0,0,7,0,0,0,1,2,-1},{36,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{36,0,0,7,1,0,0,1,2,-1},{36,0,0,7,1,0,0,1,2,-1},{36,0,0,12,0,0,17,1,9,-1},{36,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{36,0,0,13,1,0,0,1,19,0},{36,0,0,13,1,0,0,1,19,1},{36,0,0,13,1,0,0,1,19,2},{36,0,0,13,1,0,0,1,19,3},{36,0,0,13,1,0,0,1,19,4},{36,0,0,13,1,0,0,1,19,5},{36,0,0,13,1,0,0,1,19,6},{36,0,0,13,1,0,0,1,19,7},{36,0,0,13,1,0,0,1,19,8},{36,0,0,13,1,0,0,1,19,9}},
  {{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{36,0,0,15,0,0,10,1,2,-1},{36,0,0,15,0,0,10,1,2,-1},{36,0,0,15,0,0,10,1,2,-1},{36,0,0,15,0,0,10,1,2,-1},{36,0,0,15,0,0,10,1,2,-1},{36,0,0,15,0,0,10,1,2,-1},{36,0,0,15,0,0,10,1,2,-1},{36,0,0,26,0,0,0,1,2,-1}},
  {{21,0,0,7,1,0,0,1,2,-1},{21,0,0,12,0,0,17,1,9,-1},{21,0,0,10,1,0,0,1,9,-1},{21,0,0,10,1,0,0,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1}},
  {{21,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1}},
  {{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1}},
  {{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{21,0,0,12,1,0,17,1,9,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,10,1,0,0,1,9,-1},{21,0,0,12,1,0,0,1,9,-1}},
  {{21,0,0,10,1,0,0,1,9,-1},{21,0,0,10,1,0,0,1,9,-1},{21,0,0,10,1,0,0,1,9,-1},{21,0,0,10,1,0,0,1,9,-1},{21,0,0,10,1,0,0,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{21,0,0,12,1,0,0,1,9,-1},{21,0,0,10,1,0,0,1,9,-1},{21,0,0,10,1,0,0,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{21,0,0,10,1,0,0,1,9,-1},{21,0,0,10,1,0,0,1,9,-1},{21,0,0,12,1,0,17,1,9,-1},{21,0,0,12,1,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{21,0,0,10,1,0,0,1,9,-1},{21,0,0,10,1,0,0,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{21,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,12,1,0,17,1,9,-1},{21,0,0,12,1,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{21,0,0,13,1,0,0,1,19,0},{21,0,0,13,1,0,0,1,19,1},{21,0,0,13,1,0,0,1,19,2},{21,0,0,13,1,0,0,1,19,3},{21,0,0,13,1,0,0,1,19,4},{21,0,0,13,1,0,0,1,19,5},{21,0,0,13,1,0,0,1,19,6},{21,0,0,13,1,0,0,1,19,7},{21,0,0,13,1,0,0,1,19,8},{21,0,0,13,1,0,0,1,19,9}},
  {{103,0,0,2,0,0,0,1,0,-1},{21,0,0,7,1,0,0,1,2,-1},{21,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{103,0,0,2,0,0,0,1,0,-1},{26,0,0,12,0,0,17,1,9,-1},{26,0,0,10,1,0,0,1,9,-1},{26,0,0,10,1,0,0,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1}},
  {{26,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1}},
  {{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1}},
  {{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,10,1,0,0,1,9,-1},{26,0,0,10,1,0,0,1,9,-1}},
  {{26,0,0,10,1,0,0,1,9,-1},{26,0,0,12,1,0,17,1,9,-1},{26,0,0,12,1,0,17,1,9,-1},{26,0,0,12,1,0,17,1,9,-1},{26,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{26,0,0,10,1,0,0,1,9,-1},{26,0,0,10,1,0,0,1,9,-1},{26,0,0,10,1,0,0,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{26,0,0,10,1,0,0,1,9,-1},{26,0,0,10,1,0,0,1,9,-1},{26,0,0,10,1,0,0,1,9,-1},{26,0,0,12,1,0,17,1,9,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,26,0,0,0,1,2,-1}},
  {{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,10,1,0,0,1,9,-1},{26,0,0,15,0,0,0,1,2,-1},{26,0,0,15,0,0,0,1,2,-1},{26,0,0,15,0,0,0,1,2,-1},{26,0,0,15,0,0,0,1,2,-1},{26,0,0,15,0,0,0,1,2,-1},{26,0,0,15,0,0,0,1,2,-1},{26,0,0,15,0,0,0,1,2,-1},{26,0,0,7,0,0,0,1,2,-1}},
  {{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,12,0,0,17,1,9,-1},{26,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{26,0,0,13,1,0,0,1,19,0},{26,0,0,13,1,0,0,1,19,1},{26,0,0,13,1,0,0,1,19,2},{26,0,0,13,1,0,0,1,19,3},{26,0,0,13,1,0,0,1,19,4},{26,0,0,13,1,0,0,1,19,5},{26,0,0,13,1,0,0,1,19,6},{26,0,0,13,1,0,0,1,19,7},{26,0,0,13,1,0,0,1,19,8},{26,0,0,13,1,0,0,1,19,9}},
  {{26,0,0,15,0,0,0,1,2,-1},{26,0,0,15,0,0,0,1,2,-1},{26,0,0,15,0,0,0,1,2,-1},{26,0,0,15,0,0,0,1,2,-1},{26,0,0,15,0,0,0,1,2,-1},{26,0,0,15,0,0,0,1,2,-1},{26,0,0,15,0,0,0,1,2,-1},{26,0,0,15,0,0,0,1,2,-1},{26,0,0,15,0,0,0,1,2,-1},{26,0,0,26,0,0,0,1,21,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1},{26,0,0,7,1,0,0,1,2,-1}},
  {{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{33,0,0,10,1,0,0,1,9,-1},{33,0,0,10,1,0,0,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,0,0,0,1,2,-1}},
  {{33,0,0,7,0,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1}},
  {{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,0,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1}},
  {{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{33,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{33,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{33,0,0,12,1,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{33,0,0,10,1,0,0,1,9,-1}},
  {{33,0,0,10,1,0,0,1,9,-1},{33,0,0,10,1,0,0,1,9,-1},{33,0,0,12,1,0,17,1,9,-1},{33,0,0,12,1,0,17,1,9,-1},{33,0,0,12,1,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{33,0,0,12,1,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{33,0,0,10,1,0,0,1,9,-1},{33,0,0,10,1,0,0,1,9,-1},{33,0,0,10,1,0,0,1,9,-1},{33,0,0,10,1,0,0,1,9,-1},{33,0,0,10,1,0,0,1,9,-1},{33,0,0,10,1,0,0,1,9,-1},{33,0,0,10,1,0,0,1,9,-1},{33,0,0,10,0,0,0,1,9,-1}},
  {{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{33,0,0,13,0,0,0,1,19,0},{33,0,0,13,0,0,0,1,19,1},{33,0,0,13,0,0,0,1,19,2},{33,0,0,13,0,0,0,1,19,3},{33,0,0,13,0,0,0,1,19,4},{33,0,0,13,0,0,0,1,19,5},{33,0,0,13,0,0,0,1,19,6},{33,0,0,13,0,0,0,1,19,7},{33,0,0,13,0,0,0,1,19,8},{33,0,0,13,0,0,0,1,19,9}},
  {{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{33,0,0,10,1,0,0,1,9,-1},{33,0,0,10,0,0,0,1,9,-1},{33,0,0,21,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{103,0,0,2,0,0,0,1,0,-1},{38,0,0,7,1,0,0,1,24,-1},{38,0,0,7,1,0,0,1,24,-1},{38,0,0,7,1,0,0,1,24,-1},{38,0,0,7,1,0,0,1,24,-1},{38,0,0,7,1,0,0,1,24,-1},{38,0,0,7,1,0,0,1,24,-1},{38,0,0,7,1,0,0,1,24,-1},{38,0,0,7,1,0,0,1,24,-1},{38,0,0,7,1,0,0,1,24,-1},{38,0,0,7,1,0,0,1,24,-1},{38,0,0,7,1,0,0,1,24,-1},{38,0,0,7,1,0,0,1,24,-1},{38,0,0,7,1,0,0,1,24,-1},{38,0,0,7,1,0,0,1,24,-1},{38,0,0,7,1,0,0,1,24,-1}},
  {{38,0,0,7,1,0,0,1,24,-1},{38,0,0,7,1,0,0,1,24,-1},{38,0,0,7,1,0,0,1,24,-1},{38,0,0,7,1,0,0,1,24,-1},{38,0,0,7,1,0,0,1,24,-1},{38,0,0,7,1,0,0,1,24,-1},{38,0,0,7,1,0,0,1,24,-1},{38,0,0,7,1,0,0,1,24,-1},{38,0,0,7,1,0,0,1,24,-1},{38,0,0,7,1,0,0,1,24,-1},{38,0,0,7,1,0,0,1,24,-1},{38,0,0,7,1,0,0,1,24,-1},{38,0,0,7,1,0,0,1,24,-1},{38,0,0,7,1,0,0,1,24,-1},{38,0,0,7,1,0,0,1,24,-1},{38,0,0,7,1,0,0,1,24,-1}},
  {{38,0,0,7,1,0,0,1,24,-1},{38,0,0,12,1,0,17,1,24,-1},{38,0,0,7,1,0,0,1,24,-1},{38,0,0,7,0,0,0,1,24,-1},{38,0,0,12,1,0,17,1,24,-1},{38,0,0,12,1,0,17,1,24,-1},{38,0,0,12,1,0,17,1,24,-1},{38,0,0,12,1,0,17,1,24,-1},{38,0,0,12,1,0,17,1,24,-1},{38,0,0,12,1,0,17,1,24,-1},{38,0,0,12,1,0,17,1,24,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{0,0,0,23,0,0,4,1,22,-1}},
  {{38,0,0,7,1,0,0,1,24,-1},{38,0,0,7,1,0,0,1,24,-1},{38,0,0,7,1,0,0,1,24,-1},{38,0,0,7,1,0,0,1,24,-1},{38,0,0,7,1,0,0,1,24,-1},{38,0,0,7,1,0,0,1,24,-1},{38,0,0,6,1,0,0,1,24,-1},{38,0,0,12,1,0,17,1,24,-1},{38,0,0,12,1,0,17,1,24,-1},{38,0,0,12,1,0,17,1,24,-1},{38,0,0,12,1,0,17,1,24,-1},{38,0,0,12,1,0,17,1,24,-1},{38,0,0,12,1,0,17,1,24,-1},{38,0,0,12,1,0,17,1,24,-1},{38,0,0,12,1,0,17,1,24,-1},{38,0,0,21,0,0,0,1,2,-1}},
  {{38,0,0,13,1,0,0,1,19,0},{38,0,0,13,1,0,0,1,19,1},{38,0,0,13,1,0,0,1,19,2},{38,0,0,13,1,0,0,1,19,3},{38,0,0,13,1,0,0,1,19,4},{38,0,0,13,1,0,0,1,19,5},{38,0,0,13,1,0,0,1,19,6},{38,0,0,13,1,0,0,1,19,7},{38,0,0,13,1,0,0,1,19,8},{38,0,0,13,1,0,0,1,19,9},{38,0,0,21,0,0,0,1,4,-1},{38,0,0,21,0,0,0,1,4,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{103,0,0,2,0,0,0,1,0,-1},{24,0,0,7,1,0,0,1,24,-1},{24,0,0,7,1,0,0,1,24,-1},{103,0,0,2,0,0,0,1,0,-1},{24,0,0,7,1,0,0,1,24,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{24,0,0,7,1,0,0,1,24,-1},{24,0,0,7,1,0,0,1,24,-1},{103,0,0,2,0,0,0,1,0,-1},{24,0,0,7,1,0,0,1,24,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{24,0,0,7,1,0,0,1,24,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{24,0,0,7,1,0,0,1,24,-1},{24,0,0,7,1,0,0,1,24,-1},{24,0,0,7,1,0,0,1,24,-1},{24,0,0,7,1,0,0,1,24,-1},{103,0,0,2,0,0,0,1,0,-1},{24,0,0,7,1,0,0,1,24,-1},{24,0,0,7,1,0,0,1,24,-1},{24,0,0,7,1,0,0,1,24,-1},{24,0,0,7,1,0,0,1,24,-1},{24,0,0,7,1,0,0,1,24,-1},{24,0,0,7,1,0,0,1,24,-1},{24,0,0,7,1,0,0,1,24,-1}},
  {{103,0,0,2,0,0,0,1,0,-1},{24,0,0,7,1,0,0,1,24,-1},{24,0,0,7,1,0,0,1,24,-1},{24,0,0,7,1,0,0,1,24,-1},{103,0,0,2,0,0,0,1,0,-1},{24,0,0,7,1,0,0,1,24,-1},{103,0,0,2,0,0,0,1,0,-1},{24,0,0,7,1,0,0,1,24,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{24,0,0,7,1,0,0,1,24,-1},{24,0,0,7,1,0,0,1,24,-1},{103,0,0,2,0,0,0,1,0,-1},{24,0,0,7,1,0,0,1,24,-1},{24,0,0,7,1,0,0,1,24,-1},{24,0,0,7,1,0,0,1,24,-1}},
  {{24,0,0,7,1,0,0,1,24,-1},{24,0,0,12,1,0,17,1,24,-1},{24,0,0,7,1,0,0,1,24,-1},{24,0,0,7,0,0,0,1,24,-1},{24,0,0,12,1,0,17,1,24,-1},{24,0,0,12,1,0,17,1,24,-1},{24,0,0,12,1,0,17,1,24,-1},{24,0,0,12,1,0,17,1,24,-1},{24,0,0,12,1,0,17,1,24,-1},{24,0,0,12,1,0,17,1,24,-1},{103,0,0,2,0,0,0,1,0,-1},{24,0,0,12,1,0,17,1,24,-1},{24,0,0,12,1,0,17,1,24,-1},{24,0,0,7,1,0,0,1,24,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{24,0,0,7,1,0,0,1,24,-1},{24,0,0,7,1,0,0,1,24,-1},{24,0,0,7,1,0,0,1,24,-1},{24,0,0,7,1,0,0,1,24,-1},{24,0,0,7,1,0,0,1,24,-1},{103,0,0,2,0,0,0,1,0,-1},{24,0,0,6,1,0,0,1,24,-1},{103,0,0,2,0,0,0,1,0,-1},{24,0,0,12,1,0,17,1,24,-1},{24,0,0,12,1,0,17,1,24,-1},{24,0,0,12,1,0,17,1,24,-1},{24,0,0,12,1,0,17,1,24,-1},{24,0,0,12,1,0,17,1,24,-1},{24,0,0,12,1,0,17,1,24,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{24,0,0,13,1,0,0,1,19,0},{24,0,0,13,1,0,0,1,19,1},{24,0,0,13,1,0,0,1,19,2},{24,0,0,13,1,0,0,1,19,3},{24,0,0,13,1,0,0,1,19,4},{24,0,0,13,1,0,0,1,19,5},{24,0,0,13,1,0,0,1,19,6},{24,0,0,13,1,0,0,1,19,7},{24,0,0,13,1,0,0,1,19,8},{24,0,0,13,1,0,0,1,19,9},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{24,0,0,7,0,0,0,1,24,-1},{24,0,0,7,0,0,0,1,24,-1},{24,0,0,7,1,0,0,1,24,-1},{24,0,0,7,1,0,0,1,24,-1}},
  {{39,0,0,7,1,0,0,1,2,-1},{39,0,0,26,0,0,0,1,5,-1},{39,0,0,26,0,0,0,1,5,-1},{39,0,0,26,0,0,0,1,5,-1},{39,0,0,21,0,0,0,1,5,-1},{39,0,0,21,0,0,0,1,2,-1},{39,0,0,21,0,0,0,1,5,-1},{39,0,0,21,0,0,0,1,5,-1},{39,0,0,21,0,0,0,1,12,-1},{39,0,0,21,0,0,0,1,5,-1},{39,0,0,21,0,0,0,1,5,-1},{39,0,0,21,1,0,0,1,4,-1},{39,0,0,21,0,0,0,1,12,-1},{39,0,0,21,0,0,0,1,11,-1},{39,0,0,21,0,0,0,1,11,-1},{39,0,0,21,0,0,0,1,11,-1}},
  {{39,0,0,21,0,0,0,1,11,-1},{39,0,0,21,0,0,0,1,11,-1},{39,0,0,21,0,0,0,1,12,-1},{39,0,0,26,0,0,0,1,2,-1},{39,0,0,21,0,0,0,1,11,-1},{39,0,0,26,0,0,0,1,2,-1},{39,0,0,26,0,0,0,1,2,-1},{39,0,0,26,0,0,0,1,2,-1},{39,0,0,12,0,0,17,1,9,-1},{39,0,0,12,0,0,17,1,9,-1},{39,0,0,26,0,0,0,1,2,-1},{39,0,0,26,0,0,0,1,2,-1},{39,0,0,26,0,0,0,1,2,-1},{39,0,0,26,0,0,0,1,2,-1},{39,0,0,26,0,0,0,1,2,-1},{39,0,0,26,0,0,0,1,2,-1}},
  {{39,0,0,13,1,0,0,1,19,0},{39,0,0,13,1,0,0,1,19,1},{39,0,0,13,1,0,0,1,19,2},{39,0,0,13,1,0,0,1,19,3},{39,0,0,13,1,0,0,1,19,4},{39,0,0,13,1,0,0,1,19,5},{39,0,0,13,1,0,0,1,19,6},{39,0,0,13,1,0,0,1,19,7},{39,0,0,13,1,0,0,1,19,8},{39,0,0,13,1,0,0,1,19,9},{39,0,0,15,0,0,0,1,2,-1},{39,0,0,15,0,0,0,1,2,-1},{39,0,0,15,0,0,0,1,2,-1},{39,0,0,15,0,0,0,1,2,-1},{39,0,0,15,0,0,0,1,2,-1},{39,0,0,15,0,0,0,1,2,-1}},
  {{39,0,0,15,0,0,0,1,2,-1},{39,0,0,15,0,0,0,1,2,-1},{39,0,0,15,0,0,0,1,2,-1},{39,0,0,15,0,0,0,1,2,-1},{39,0,0,26,0,0,0,1,4,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,26,0,0,0,1,2,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,26,0,0,0,1,2,-1},{39,0,0,12,0,0,17,1,9,-1},{39,1,0,22,0,0,10,1,20,-1},{39,2,0,18,0,0,10,1,8,-1},{39,1,0,22,0,0,10,1,20,-1},{39,2,0,18,0,0,10,1,8,-1},{39,0,0,10,1,0,0,1,9,-1},{39,0,0,10,1,0,0,1,9,-1}},
  {{39,0,0,7,1,0,0,1,2,-1},{39,0,0,7,1,0,0,1,2,-1},{39,0,0,7,1,0,0,1,2,-1},{39,0,0,7,0,0,0,1,2,-1},{39,0,0,7,1,0,0,1,2,-1},{39,0,0,7,1,0,0,1,2,-1},{39,0,0,7,1,0,0,1,2,-1},{39,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{39,0,0,7,1,0,0,1,2,-1},{39,0,0,7,1,0,0,1,2,-1},{39,0,0,7,1,0,0,1,2,-1},{39,0,0,7,1,0,0,1,2,-1},{39,0,0,7,0,0,0,1,2,-1},{39,0,0,7,1,0,0,1,2,-1},{39,0,0,7,1,0,0,1,2,-1}},
  {{39,0,0,7,1,0,0,1,2,-1},{39,0,0,7,1,0,0,1,2,-1},{39,0,0,7,0,0,0,1,2,-1},{39,0,0,7,1,0,0,1,2,-1},{39,0,0,7,1,0,0,1,2,-1},{39,0,0,7,1,0,0,1,2,-1},{39,0,0,7,1,0,0,1,2,-1},{39,0,0,7,0,0,0,1,2,-1},{39,0,0,7,1,0,0,1,2,-1},{39,0,0,7,1,0,0,1,2,-1},{39,0,0,7,1,0,0,1,2,-1},{39,0,0,7,1,0,0,1,2,-1},{39,0,0,7,0,0,0,1,2,-1},{39,0,0,7,1,0,0,1,2,-1},{39,0,0,7,1,0,0,1,2,-1},{39,0,0,7,1,0,0,1,2,-1}},
  {{39,0,0,7,1,0,0,1,2,-1},{39,0,0,7,1,0,0,1,2,-1},{39,0,0,7,1,0,0,1,2,-1},{39,0,0,7,1,0,0,1,2,-1},{39,0,0,7,1,0,0,1,2,-1},{39,0,0,7,1,0,0,1,2,-1},{39,0,0,7,1,0,0,1,2,-1},{39,0,0,7,1,0,0,1,2,-1},{39,0,0,7,1,0,0,1,2,-1},{39,0,0,7,0,0,0,1,2,-1},{39,0,0,7,1,0,0,1,2,-1},{39,0,0,7,1,0,0,1,2,-1},{39,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{103,0,0,2,0,0,0,1,0,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,0,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,0,0,17,1,9,-1},{39,0,0,12,0,0,17,1,9,-1},{39,0,0,12,0,0,17,1,9,-1},{39,0,0,12,0,0,17,1,9,-1},{39,0,0,12,0,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,10,1,0,0,1,4,-1}},
  {{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,0,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,21,0,0,0,1,4,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,7,1,0,0,1,2,-1},{39,0,0,7,1,0,0,1,2,-1},{39,0,0,7,1,0,0,1,2,-1},{39,0,0,7,1,0,0,1,2,-1},{39,0,0,7,1,0,0,1,2,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1}},
  {{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,0,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,0,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1}},
  {{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,0,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,0,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,0,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1}},
  {{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,0,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,12,1,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{39,0,0,26,0,0,0,1,4,-1},{39,0,0,26,0,0,0,1,4,-1}},
  {{39,0,0,26,0,0,0,1,2,-1},{39,0,0,26,0,0,0,1,2,-1},{39,0,0,26,0,0,0,1,2,-1},{39,0,0,26,0,0,0,1,2,-1},{39,0,0,26,0,0,0,1,2,-1},{39,0,0,26,0,0,0,1,2,-1},{39,0,0,12,1,0,17,1,9,-1},{39,0,0,26,0,0,0,1,2,-1},{39,0,0,26,0,0,0,1,2,-1},{39,0,0,26,0,0,0,1,2,-1},{39,0,0,26,0,0,0,1,2,-1},{39,0,0,26,0,0,0,1,2,-1},{39,0,0,26,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{39,0,0,26,0,0,0,1,2,-1},{39,0,0,26,0,0,0,1,2,-1}},
  {{39,0,0,21,0,0,0,1,5,-1},{39,0,0,21,0,0,0,1,5,-1},{39,0,0,21,0,0,0,1,4,-1},{39,0,0,21,0,0,0,1,5,-1},{39,0,0,21,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{39,0,0,21,0,0,0,1,12,-1},{39,0,0,21,0,0,0,1,12,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1}},
  {{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,10,1,0,0,1,24,-1},{28,0,0,10,1,0,0,1,24,-1},{28,0,0,12,1,0,17,1,24,-1},{28,0,0,12,1,0,17,1,24,-1},{28,0,0,12,1,0,17,1,24,-1}},
  {{28,0,0,12,1,0,17,1,24,-1},{28,0,0,10,1,0,0,1,24,-1},{28,0,0,12,1,0,17,1,24,-1},{28,0,0,12,1,0,17,1,24,-1},{28,0,0,12,1,0,17,1,24,-1},{28,0,0,12,1,0,17,1,24,-1},{28,0,0,12,1,0,17,1,24,-1},{28,0,0,12,1,0,17,1,24,-1},{28,0,0,10,1,0,0,1,24,-1},{28,0,0,12,1,0,17,1,24,-1},{28,0,0,12,1,0,17,1,24,-1},{28,0,0,10,1,0,0,1,24,-1},{28,0,0,10,1,0,0,1,24,-1},{28,0,0,12,1,0,17,1,24,-1},{28,0,0,12,1,0,17,1,24,-1},{28,0,0,7,1,0,0,1,24,-1}},
  {{28,0,0,13,1,0,0,1,19,0},{28,0,0,13,1,0,0,1,19,1},{28,0,0,13,1,0,0,1,19,2},{28,0,0,13,1,0,0,1,19,3},{28,0,0,13,1,0,0,1,19,4},{28,0,0,13,1,0,0,1,19,5},{28,0,0,13,1,0,0,1,19,6},{28,0,0,13,1,0,0,1,19,7},{28,0,0,13,1,0,0,1,19,8},{28,0,0,13,1,0,0,1,19,9},{28,0,0,21,0,0,0,1,4,-1},{28,0,0,21,0,0,0,1,4,-1},{28,0,0,21,0,0,0,1,2,-1},{28,0,0,21,0,0,0,1,2,-1},{28,0,0,21,0,0,0,1,2,-1},{28,0,0,21,0,0,0,1,2,-1}},
  {{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,10,1,0,0,1,24,-1},{28,0,0,10,1,0,0,1,24,-1},{28,0,0,12,1,0,17,1,24,-1},{28,0,0,12,1,0,17,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,12,1,0,17,1,24,-1},{28,0,0,12,1,0,17,1,24,-1}},
  {{28,0,0,12,1,0,17,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,10,1,0,0,1,24,-1},{28,0,0,10,1,0,0,1,24,-1},{28,0,0,10,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,10,1,0,0,1,24,-1},{28,0,0,10,1,0,0,1,24,-1},{28,0,0,10,1,0,0,1,24,-1},{28,0,0,10,1,0,0,1,24,-1},{28,0,0,10,1,0,0,1,24,-1},{28,0,0,10,1,0,0,1,24,-1},{28,0,0,10,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1}},
  {{28,0,0,7,1,0,0,1,24,-1},{28,0,0,12,1,0,17,1,24,-1},{28,0,0,12,1,0,17,1,24,-1},{28,0,0,12,1,0,17,1,24,-1},{28,0,0,12,1,0,17,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1}},
  {{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,12,1,0,17,1,24,-1},{28,0,0,10,1,0,0,1,24,-1},{28,0,0,10,1,0,0,1,24,-1},{28,0,0,12,1,0,17,1,24,-1},{28,0,0,12,1,0,17,1,24,-1},{28,0,0,10,1,0,0,1,24,-1},{28,0,0,10,1,0,0,1,24,-1},{28,0,0,10,1,0,0,1,24,-1},{28,0,0,10,1,0,0,1,24,-1},{28,0,0,10,1,0,0,1,24,-1},{28,0,0,10,1,0,0,1,24,-1},{28,0,0,12,1,0,17,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,10,1,0,0,1,24,-1}},
  {{28,0,0,13,1,0,0,1,19,0},{28,0,0,13,1,0,0,1,19,1},{28,0,0,13,1,0,0,1,19,2},{28,0,0,13,1,0,0,1,19,3},{28,0,0,13,1,0,0,1,19,4},{28,0,0,13,1,0,0,1,19,5},{28,0,0,13,1,0,0,1,19,6},{28,0,0,13,1,0,0,1,19,7},{28,0,0,13,1,0,0,1,19,8},{28,0,0,13,1,0,0,1,19,9},{28,0,0,10,1,0,0,1,24,-1},{28,0,0,10,1,0,0,1,24,-1},{28,0,0,10,1,0,0,1,24,-1},{28,0,0,12,1,0,17,1,24,-1},{28,0,0,26,0,0,0,1,24,-1},{28,0,0,26,0,0,0,1,24,-1}},
  {{12,0,0,9,0,0,0,1,2,-1},{12,0,0,9,0,0,0,1,2,-1},{12,0,0,9,0,0,0,1,2,-1},{12,0,0,9,0,0,0,1,2,-1},{12,0,0,9,0,0,0,1,2,-1},{12,0,0,9,0,0,0,1,2,-1},{12,0,0,9,0,0,0,1,2,-1},{12,0,0,9,0,0,0,1,2,-1},{12,0,0,9,0,0,0,1,2,-1},{12,0,0,9,0,0,0,1,2,-1},{12,0,0,9,0,0,0,1,2,-1},{12,0,0,9,0,0,0,1,2,-1},{12,0,0,9,0,0,0,1,2,-1},{12,0,0,9,0,0,0,1,2,-1},{12,0,0,9,0,0,0,1,2,-1},{12,0,0,9,0,0,0,1,2,-1}},
  {{12,0,0,9,0,0,0,1,2,-1},{12,0,0,9,0,0,0,1,2,-1},{12,0,0,9,0,0,0,1,2,-1},{12,0,0,9,0,0,0,1,2,-1},{12,0,0,9,0,0,0,1,2,-1},{12,0,0,9,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{12,0,0,9,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{12,0,0,9,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{12,0,0,7,1,0,0,1,2,-1},{12,0,0,7,1,0,0,1,2,-1},{12,0,0,7,1,0,0,1,2,-1},{12,0,0,7,1,0,0,1,2,-1},{12,0,0,7,1,0,0,1,2,-1},{12,0,0,7,1,0,0,1,2,-1},{12,0,0,7,1,0,0,1,2,-1},{12,0,0,7,1,0,0,1,2,-1},{12,0,0,7,1,0,0,1,2,-1},{12,0,0,7,1,0,0,1,2,-1},{12,0,0,7,1,0,0,1,2,-1},{12,0,0,7,1,0,0,1,2,-1},{12,0,0,7,1,0,0,1,2,-1},{12,0,0,7,1,0,0,1,2,-1},{12,0,0,7,1,0,0,1,2,-1},{12,0,0,7,1,0,0,1,2,-1}},
  {{12,0,0,7,1,0,0,1,2,-1},{12,0,0,7,0,0,0,1,2,-1},{12,0,0,7,0,0,0,1,2,-1},{12,0,0,7,0,0,0,1,2,-1},{12,0,0,7,0,0,0,1,2,-1},{12,0,0,7,0,0,0,1,2,-1},{12,0,0,7,0,0,0,1,2,-1},{12,0,0,7,1,0,0,1,2,-1},{12,0,0,7,1,0,0,1,2,-1},{12,0,0,7,1,0,0,1,2,-1},{12,0,0,7,1,0,0,1,2,-1},{0,0,0,21,0,0,0,1,2,-1},{12,0,0,6,0,0,0,1,2,-1},{12,0,0,7,1,0,0,1,2,-1},{12,0,0,7,1,0,0,1,2,-1},{12,0,0,7,1,0,0,1,2,-1}},
  {{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1}},
  {{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,1,0,0,33,-1}},
  {{18,0,0,7,0,1,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1}},
  {{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1}},
  {{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,34,-1},{18,0,0,7,0,0,0,0,34,-1},{18,0,0,7,0,0,0,0,34,-1},{18,0,0,7,0,0,0,0,34,-1},{18,0,0,7,0,0,0,0,34,-1},{18,0,0,7,0,0,0,0,34,-1},{18,0,0,7,0,0,0,0,34,-1},{18,0,0,7,0,0,0,0,34,-1}},
  {{18,0,0,7,0,0,0,0,34,-1},{18,0,0,7,0,0,0,0,34,-1},{18,0,0,7,0,0,0,0,34,-1},{18,0,0,7,0,0,0,0,34,-1},{18,0,0,7,0,0,0,0,34,-1},{18,0,0,7,0,0,0,0,34,-1},{18,0,0,7,0,0,0,0,34,-1},{18,0,0,7,0,0,0,0,34,-1},{18,0,0,7,0,0,0,0,34,-1},{18,0,0,7,0,0,0,0,34,-1},{18,0,0,7,0,0,0,0,34,-1},{18,0,0,7,0,0,0,0,34,-1},{18,0,0,7,0,0,0,0,34,-1},{18,0,0,7,0,0,0,0,34,-1},{18,0,0,7,0,0,0,0,34,-1},{18,0,0,7,0,0,0,0,34,-1}},
  {{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1}},
  {{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{11,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{11,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{11,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1}},
  {{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1}},
  {{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{11,0,0,12,1,0,17,1,9,-1},{11,0,0,12,1,0,17,1,9,-1},{11,0,0,12,1,0,17,1,9,-1}},
  {{11,0,0,21,0,0,0,1,2,-1},{11,0,0,21,0,0,0,1,4,-1},{11,0,0,21,0,0,0,1,2,-1},{11,0,0,21,0,0,0,1,2,-1},{11,0,0,21,0,0,0,1,2,-1},{11,0,0,21,0,0,0,1,2,-1},{11,0,0,21,0,0,0,1,2,-1},{11,0,0,21,0,0,0,1,2,-1},{11,0,0,21,0,0,0,1,2,-1},{11,0,0,15,0,0,0,1,2,1},{11,0,0,15,0,0,0,1,2,2},{11,0,0,15,0,0,0,1,2,3},{11,0,0,15,0,0,0,1,2,4},{11,0,0,15,0,0,0,1,2,5},{11,0,0,15,0,0,0,1,2,6},{11,0,0,15,0,0,0,1,2,7}},
  {{11,0,0,15,0,0,0,1,2,8},{11,0,0,15,0,0,0,1,2,9},{11,0,0,15,0,0,0,1,2,-1},{11,0,0,15,0,0,0,1,2,-1},{11,0,0,15,0,0,0,1,2,-1},{11,0,0,15,0,0,0,1,2,-1},{11,0,0,15,0,0,0,1,2,-1},{11,0,0,15,0,0,0,1,2,-1},{11,0,0,15,0,0,0,1,2,-1},{11,0,0,15,0,0,0,1,2,-1},{11,0,0,15,0,0,0,1,2,-1},{11,0,0,15,0,0,0,1,2,-1},{11,0,0,15,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{11,0,0,26,0,0,10,1,2,-1},{11,0,0,26,0,0,10,1,2,-1},{11,0,0,26,0,0,10,1,2,-1},{11,0,0,26,0,0,10,1,2,-1},{11,0,0,26,0,0,10,1,2,-1},{11,0,0,26,0,0,10,1,2,-1},{11,0,0,26,0,0,10,1,2,-1},{11,0,0,26,0,0,10,1,2,-1},{11,0,0,26,0,0,10,1,2,-1},{11,0,0,26,0,0,10,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{6,0,0,9,0,0,0,1,2,-1},{6,0,0,9,0,0,0,1,2,-1},{6,0,0,9,0,0,0,1,2,-1},{6,0,0,9,0,0,0,1,2,-1},{6,0,0,9,0,0,0,1,2,-1},{6,0,0,9,0,0,0,1,2,-1},{6,0,0,9,0,0,0,1,2,-1},{6,0,0,9,0,0,0,1,2,-1},{6,0,0,9,0,0,0,1,2,-1},{6,0,0,9,0,0,0,1,2,-1},{6,0,0,9,0,0,0,1,2,-1},{6,0,0,9,0,0,0,1,2,-1},{6,0,0,9,0,0,0,1,2,-1},{6,0,0,9,0,0,0,1,2,-1},{6,0,0,9,0,0,0,1,2,-1},{6,0,0,9,0,0,0,1,2,-1}},
  {{6,0,0,9,0,0,0,1,2,-1},{6,0,0,9,0,0,0,1,2,-1},{6,0,0,9,0,0,0,1,2,-1},{6,0,0,9,0,0,0,1,2,-1},{6,0,0,9,0,0,0,1,2,-1},{6,0,0,9,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{6,0,0,5,0,0,0,1,2,-1},{6,0,0,5,0,0,0,1,2,-1},{6,0,0,5,0,0,0,1,2,-1},{6,0,0,5,0,0,0,1,2,-1},{6,0,0,5,0,0,0,1,2,-1},{6,0,0,5,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{40,0,0,17,0,0,10,1,4,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1}},
  {{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1}},
  {{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,21,0,0,0,0,2,-1},{40,0,0,21,0,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1}},
  {{29,0,0,29,0,0,9,1,4,-1},{29,0,0,7,0,0,0,1,2,-1},{29,0,0,7,0,0,0,1,2,-1},{29,0,0,7,0,0,0,1,2,-1},{29,0,0,7,0,0,0,1,2,-1},{29,0,0,7,0,0,0,1,2,-1},{29,0,0,7,0,0,0,1,2,-1},{29,0,0,7,0,0,0,1,2,-1},{29,0,0,7,0,0,0,1,2,-1},{29,0,0,7,0,0,0,1,2,-1},{29,0,0,7,0,0,0,1,2,-1},{29,0,0,7,0,0,0,1,2,-1},{29,0,0,7,0,0,0,1,2,-1},{29,0,0,7,0,0,0,1,2,-1},{29,0,0,7,0,0,0,1,2,-1},{29,0,0,7,0,0,0,1,2,-1}},
  {{29,0,0,7,0,0,0,1,2,-1},{29,0,0,7,0,0,0,1,2,-1},{29,0,0,7,0,0,0,1,2,-1},{29,0,0,7,0,0,0,1,2,-1},{29,0,0,7,0,0,0,1,2,-1},{29,0,0,7,0,0,0,1,2,-1},{29,0,0,7,0,0,0,1,2,-1},{29,0,0,7,0,0,0,1,2,-1},{29,0,0,7,0,0,0,1,2,-1},{29,0,0,7,0,0,0,1,2,-1},{29,0,0,7,0,0,0,1,2,-1},{29,1,0,22,0,0,10,1,20,-1},{29,2,0,18,0,0,10,1,8,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{32,0,0,7,0,0,0,1,2,-1},{32,0,0,7,0,0,0,1,2,-1},{32,0,0,7,0,0,0,1,2,-1},{32,0,0,7,0,0,0,1,2,-1},{32,0,0,7,0,0,0,1,2,-1},{32,0,0,7,0,0,0,1,2,-1},{32,0,0,7,0,0,0,1,2,-1},{32,0,0,7,0,0,0,1,2,-1},{32,0,0,7,0,0,0,1,2,-1},{32,0,0,7,0,0,0,1,2,-1},{32,0,0,7,0,0,0,1,2,-1},{32,0,0,7,0,0,0,1,2,-1},{32,0,0,7,0,0,0,1,2,-1},{32,0,0,7,0,0,0,1,2,-1},{32,0,0,7,0,0,0,1,2,-1},{32,0,0,7,0,0,0,1,2,-1}},
  {{32,0,0,7,0,0,0,1,2,-1},{32,0,0,7,0,0,0,1,2,-1},{32,0,0,7,0,0,0,1,2,-1},{32,0,0,7,0,0,0,1,2,-1},{32,0,0,7,0,0,0,1,2,-1},{32,0,0,7,0,0,0,1,2,-1},{32,0,0,7,0,0,0,1,2,-1},{32,0,0,7,0,0,0,1,2,-1},{32,0,0,7,0,0,0,1,2,-1},{32,0,0,7,0,0,0,1,2,-1},{32,0,0,7,0,0,0,1,2,-1},{0,0,0,21,0,0,0,1,4,-1},{0,0,0,21,0,0,0,1,4,-1},{0,0,0,21,0,0,0,1,4,-1},{32,0,0,14,0,0,0,1,2,-1},{32,0,0,14,0,0,0,1,2,-1}},
  {{32,0,0,14,0,0,0,1,2,-1},{32,0,0,7,0,0,0,1,2,-1},{32,0,0,7,0,0,0,1,2,-1},{32,0,0,7,0,0,0,1,2,-1},{32,0,0,7,0,0,0,1,2,-1},{32,0,0,7,0,0,0,1,2,-1},{32,0,0,7,0,0,0,1,2,-1},{32,0,0,7,0,0,0,1,2,-1},{32,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{42,0,0,7,0,0,0,1,2,-1},{42,0,0,7,0,0,0,1,2,-1},{42,0,0,7,0,0,0,1,2,-1},{42,0,0,7,0,0,0,1,2,-1},{42,0,0,7,0,0,0,1,2,-1},{42,0,0,7,0,0,0,1,2,-1},{42,0,0,7,0,0,0,1,2,-1},{42,0,0,7,0,0,0,1,2,-1},{42,0,0,7,0,0,0,1,2,-1},{42,0,0,7,0,0,0,1,2,-1},{42,0,0,7,0,0,0,1,2,-1},{42,0,0,7,0,0,0,1,2,-1},{42,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{42,0,0,7,0,0,0,1,2,-1},{42,0,0,7,0,0,0,1,2,-1}},
  {{42,0,0,7,0,0,0,1,2,-1},{42,0,0,7,0,0,0,1,2,-1},{42,0,0,12,0,0,17,1,9,-1},{42,0,0,12,0,0,17,1,9,-1},{42,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{43,0,0,7,0,0,0,1,2,-1},{43,0,0,7,0,0,0,1,2,-1},{43,0,0,7,0,0,0,1,2,-1},{43,0,0,7,0,0,0,1,2,-1},{43,0,0,7,0,0,0,1,2,-1},{43,0,0,7,0,0,0,1,2,-1},{43,0,0,7,0,0,0,1,2,-1},{43,0,0,7,0,0,0,1,2,-1},{43,0,0,7,0,0,0,1,2,-1},{43,0,0,7,0,0,0,1,2,-1},{43,0,0,7,0,0,0,1,2,-1},{43,0,0,7,0,0,0,1,2,-1},{43,0,0,7,0,0,0,1,2,-1},{43,0,0,7,0,0,0,1,2,-1},{43,0,0,7,0,0,0,1,2,-1},{43,0,0,7,0,0,0,1,2,-1}},
  {{43,0,0,7,0,0,0,1,2,-1},{43,0,0,7,0,0,0,1,2,-1},{43,0,0,12,0,0,17,1,9,-1},{43,0,0,12,0,0,17,1,9,-1},{43,0,0,12,0,0,17,1,9,-1},{0,0,0,21,0,0,0,1,4,-1},{0,0,0,21,0,0,0,1,4,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{44,0,0,7,0,0,0,1,2,-1},{44,0,0,7,0,0,0,1,2,-1},{44,0,0,7,0,0,0,1,2,-1},{44,0,0,7,0,0,0,1,2,-1},{44,0,0,7,0,0,0,1,2,-1},{44,0,0,7,0,0,0,1,2,-1},{44,0,0,7,0,0,0,1,2,-1},{44,0,0,7,0,0,0,1,2,-1},{44,0,0,7,0,0,0,1,2,-1},{44,0,0,7,0,0,0,1,2,-1},{44,0,0,7,0,0,0,1,2,-1},{44,0,0,7,0,0,0,1,2,-1},{44,0,0,7,0,0,0,1,2,-1},{44,0,0,7,0,0,0,1,2,-1},{44,0,0,7,0,0,0,1,2,-1},{44,0,0,7,0,0,0,1,2,-1}},
  {{44,0,0,7,0,0,0,1,2,-1},{44,0,0,7,0,0,0,1,2,-1},{44,0,0,12,0,0,17,1,9,-1},{44,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{45,0,0,7,0,0,0,1,2,-1},{45,0,0,7,0,0,0,1,2,-1},{45,0,0,7,0,0,0,1,2,-1},{45,0,0,7,0,0,0,1,2,-1},{45,0,0,7,0,0,0,1,2,-1},{45,0,0,7,0,0,0,1,2,-1},{45,0,0,7,0,0,0,1,2,-1},{45,0,0,7,0,0,0,1,2,-1},{45,0,0,7,0,0,0,1,2,-1},{45,0,0,7,0,0,0,1,2,-1},{45,0,0,7,0,0,0,1,2,-1},{45,0,0,7,0,0,0,1,2,-1},{45,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{45,0,0,7,0,0,0,1,2,-1},{45,0,0,7,0,0,0,1,2,-1}},
  {{45,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{45,0,0,12,0,0,17,1,9,-1},{45,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{23,0,0,7,1,0,0,1,24,-1},{23,0,0,7,1,0,0,1,24,-1},{23,0,0,7,1,0,0,1,24,-1},{23,0,0,7,1,0,0,1,24,-1},{23,0,0,7,1,0,0,1,24,-1},{23,0,0,7,1,0,0,1,24,-1},{23,0,0,7,1,0,0,1,24,-1},{23,0,0,7,1,0,0,1,24,-1},{23,0,0,7,1,0,0,1,24,-1},{23,0,0,7,1,0,0,1,24,-1},{23,0,0,7,1,0,0,1,24,-1},{23,0,0,7,1,0,0,1,24,-1},{23,0,0,7,1,0,0,1,24,-1},{23,0,0,7,1,0,0,1,24,-1},{23,0,0,7,1,0,0,1,24,-1},{23,0,0,7,1,0,0,1,24,-1}},
  {{23,0,0,7,1,0,0,1,24,-1},{23,0,0,7,1,0,0,1,24,-1},{23,0,0,7,1,0,0,1,24,-1},{23,0,0,7,0,0,0,1,24,-1},{23,0,0,7,0,0,0,1,24,-1},{23,0,0,7,1,0,0,1,24,-1},{23,0,0,7,1,0,0,1,24,-1},{23,0,0,7,1,0,0,1,24,-1},{23,0,0,7,0,0,0,1,24,-1},{23,0,0,7,1,0,0,1,24,-1},{23,0,0,7,1,0,0,1,24,-1},{23,0,0,7,1,0,0,1,24,-1},{23,0,0,7,1,0,0,1,24,-1},{23,0,0,7,1,0,0,1,24,-1},{23,0,0,7,1,0,0,1,24,-1},{23,0,0,7,1,0,0,1,24,-1}},
  {{23,0,0,7,1,0,0,1,24,-1},{23,0,0,7,1,0,0,1,24,-1},{23,0,0,7,1,0,0,1,24,-1},{23,0,0,7,1,0,0,1,24,-1},{23,0,0,12,0,1,17,1,24,-1},{23,0,0,12,0,1,17,1,24,-1},{23,0,0,10,1,0,0,1,24,-1},{23,0,0,12,1,0,17,1,24,-1},{23,0,0,12,1,0,17,1,24,-1},{23,0,0,12,1,0,17,1,24,-1},{23,0,0,12,1,0,17,1,24,-1},{23,0,0,12,1,0,17,1,24,-1},{23,0,0,12,1,0,17,1,24,-1},{23,0,0,12,1,0,17,1,24,-1},{23,0,0,10,1,0,0,1,24,-1},{23,0,0,10,1,0,0,1,24,-1}},
  {{23,0,0,10,1,0,0,1,24,-1},{23,0,0,10,1,0,0,1,24,-1},{23,0,0,10,1,0,0,1,24,-1},{23,0,0,10,1,0,0,1,24,-1},{23,0,0,10,1,0,0,1,24,-1},{23,0,0,10,1,0,0,1,24,-1},{23,0,0,12,1,0,17,1,24,-1},{23,0,0,10,1,0,0,1,24,-1},{23,0,0,10,1,0,0,1,24,-1},{23,0,0,12,1,0,17,1,24,-1},{23,0,0,12,1,0,17,1,24,-1},{23,0,0,12,0,0,17,1,24,-1},{23,0,0,12,0,0,17,1,24,-1},{23,0,0,12,0,0,17,1,24,-1},{23,0,0,12,0,0,17,1,24,-1},{23,0,0,12,0,0,17,1,24,-1}},
  {{23,0,0,12,0,0,17,1,24,-1},{23,0,0,12,0,0,17,1,24,-1},{23,0,0,12,1,0,17,1,24,-1},{23,0,0,12,0,0,17,1,24,-1},{23,0,0,21,0,0,0,1,4,-1},{23,0,0,21,0,0,0,1,4,-1},{23,0,0,21,0,0,0,1,18,-1},{23,0,0,6,1,0,0,1,24,-1},{23,0,0,21,0,0,0,1,4,-1},{23,0,0,21,0,0,0,1,2,-1},{23,0,0,21,0,0,0,1,4,-1},{23,0,0,23,0,0,4,1,22,-1},{23,0,0,7,1,0,0,1,24,-1},{23,0,0,12,0,0,17,1,24,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{23,0,0,13,1,0,0,1,19,0},{23,0,0,13,1,0,0,1,19,1},{23,0,0,13,1,0,0,1,19,2},{23,0,0,13,1,0,0,1,19,3},{23,0,0,13,1,0,0,1,19,4},{23,0,0,13,1,0,0,1,19,5},{23,0,0,13,1,0,0,1,19,6},{23,0,0,13,1,0,0,1,19,7},{23,0,0,13,1,0,0,1,19,8},{23,0,0,13,1,0,0,1,19,9},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{23,0,0,15,0,0,10,1,2,-1},{23,0,0,15,0,0,10,1,2,-1},{23,0,0,15,0,0,10,1,2,-1},{23,0,0,15,0,0,10,1,2,-1},{23,0,0,15,0,0,10,1,2,-1},{23,0,0,15,0,0,10,1,2,-1},{23,0,0,15,0,0,10,1,2,-1},{23,0,0,15,0,0,10,1,2,-1},{23,0,0,15,0,0,10,1,2,-1},{23,0,0,15,0,0,10,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{27,0,0,21,0,0,10,1,2,-1},{27,0,0,21,0,0,10,1,2,-1},{0,0,0,21,0,0,10,1,11,-1},{0,0,0,21,0,0,10,1,11,-1},{27,0,0,21,0,0,10,1,4,-1},{0,0,0,21,0,0,10,1,4,-1},{27,0,0,17,0,0,10,1,5,-1},{27,0,0,21,0,0,10,1,2,-1},{27,0,0,21,0,0,10,1,11,-1},{27,0,0,21,0,0,10,1,11,-1},{27,0,0,21,0,0,10,1,2,-1},{27,0,0,12,0,1,17,1,9,-1},{27,0,0,12,0,1,17,1,9,-1},{27,0,0,12,0,1,17,1,9,-1},{27,0,0,1,0,1,18,1,12,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{27,0,0,13,2,0,0,1,19,0},{27,0,0,13,2,0,0,1,19,1},{27,0,0,13,2,0,0,1,19,2},{27,0,0,13,2,0,0,1,19,3},{27,0,0,13,2,0,0,1,19,4},{27,0,0,13,2,0,0,1,19,5},{27,0,0,13,2,0,0,1,19,6},{27,0,0,13,2,0,0,1,19,7},{27,0,0,13,2,0,0,1,19,8},{27,0,0,13,2,0,0,1,19,9},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1}},
  {{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,6,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1}},
  {{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,12,2,0,17,1,9,-1},{27,0,0,12,2,0,17,1,9,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1}},
  {{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,7,2,0,0,1,2,-1},{27,0,0,12,2,0,17,1,9,-1},{27,0,0,7,2,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{40,0,0,7,2,0,0,0,2,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1}},
  {{48,0,0,7,0,0,0,1,2,-1},{48,0,0,7,0,0,0,1,2,-1},{48,0,0,7,0,0,0,1,2,-1},{48,0,0,7,0,0,0,1,2,-1},{48,0,0,7,0,0,0,1,2,-1},{48,0,0,7,0,0,0,1,2,-1},{48,0,0,7,0,0,0,1,2,-1},{48,0,0,7,0,0,0,1,2,-1},{48,0,0,7,0,0,0,1,2,-1},{48,0,0,7,0,0,0,1,2,-1},{48,0,0,7,0,0,0,1,2,-1},{48,0,0,7,0,0,0,1,2,-1},{48,0,0,7,0,0,0,1,2,-1},{48,0,0,7,0,0,0,1,2,-1},{48,0,0,7,0,0,0,1,2,-1},{48,0,0,7,0,0,0,1,2,-1}},
  {{48,0,0,7,0,0,0,1,2,-1},{48,0,0,7,0,0,0,1,2,-1},{48,0,0,7,0,0,0,1,2,-1},{48,0,0,7,0,0,0,1,2,-1},{48,0,0,7,0,0,0,1,2,-1},{48,0,0,7,0,0,0,1,2,-1},{48,0,0,7,0,0,0,1,2,-1},{48,0,0,7,0,0,0,1,2,-1},{48,0,0,7,0,0,0,1,2,-1},{48,0,0,7,0,0,0,1,2,-1},{48,0,0,7,0,0,0,1,2,-1},{48,0,0,7,0,0,0,1,2,-1},{48,0,0,7,0,0,0,1,2,-1},{48,0,0,7,0,0,0,1,2,-1},{48,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{48,0,0,12,0,0,17,1,9,-1},{48,0,0,12,0,0,17,1,9,-1},{48,0,0,12,0,0,17,1,9,-1},{48,0,0,10,0,0,0,1,9,-1},{48,0,0,10,0,0,0,1,9,-1},{48,0,0,10,0,0,0,1,9,-1},{48,0,0,10,0,0,0,1,9,-1},{48,0,0,12,0,0,17,1,9,-1},{48,0,0,12,0,0,17,1,9,-1},{48,0,0,10,0,0,0,1,9,-1},{48,0,0,10,0,0,0,1,9,-1},{48,0,0,10,0,0,0,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{48,0,0,10,0,0,0,1,9,-1},{48,0,0,10,0,0,0,1,9,-1},{48,0,0,12,0,0,17,1,9,-1},{48,0,0,10,0,0,0,1,9,-1},{48,0,0,10,0,0,0,1,9,-1},{48,0,0,10,0,0,0,1,9,-1},{48,0,0,10,0,0,0,1,9,-1},{48,0,0,10,0,0,0,1,9,-1},{48,0,0,10,0,0,0,1,9,-1},{48,0,0,12,0,0,17,1,9,-1},{48,0,0,12,0,0,17,1,9,-1},{48,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{48,0,0,26,0,0,10,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{48,0,0,21,0,0,10,1,11,-1},{48,0,0,21,0,0,10,1,11,-1},{48,0,0,13,0,0,0,1,19,0},{48,0,0,13,0,0,0,1,19,1},{48,0,0,13,0,0,0,1,19,2},{48,0,0,13,0,0,0,1,19,3},{48,0,0,13,0,0,0,1,19,4},{48,0,0,13,0,0,0,1,19,5},{48,0,0,13,0,0,0,1,19,6},{48,0,0,13,0,0,0,1,19,7},{48,0,0,13,0,0,0,1,19,8},{48,0,0,13,0,0,0,1,19,9}},
  {{52,0,0,7,0,0,0,1,24,-1},{52,0,0,7,0,0,0,1,24,-1},{52,0,0,7,0,0,0,1,24,-1},{52,0,0,7,0,0,0,1,24,-1},{52,0,0,7,0,0,0,1,24,-1},{52,0,0,7,0,0,0,1,24,-1},{52,0,0,7,0,0,0,1,24,-1},{52,0,0,7,0,0,0,1,24,-1},{52,0,0,7,0,0,0,1,24,-1},{52,0,0,7,0,0,0,1,24,-1},{52,0,0,7,0,0,0,1,24,-1},{52,0,0,7,0,0,0,1,24,-1},{52,0,0,7,0,0,0,1,24,-1},{52,0,0,7,0,0,0,1,24,-1},{52,0,0,7,0,0,0,1,24,-1},{52,0,0,7,0,0,0,1,24,-1}},
  {{52,0,0,7,0,0,0,1,24,-1},{52,0,0,7,0,0,0,1,24,-1},{52,0,0,7,0,0,0,1,24,-1},{52,0,0,7,0,0,0,1,24,-1},{52,0,0,7,0,0,0,1,24,-1},{52,0,0,7,0,0,0,1,24,-1},{52,0,0,7,0,0,0,1,24,-1},{52,0,0,7,0,0,0,1,24,-1},{52,0,0,7,0,0,0,1,24,-1},{52,0,0,7,0,0,0,1,24,-1},{52,0,0,7,0,0,0,1,24,-1},{52,0,0,7,0,0,0,1,24,-1},{52,0,0,7,0,0,0,1,24,-1},{52,0,0,7,0,0,0,1,24,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{52,0,0,7,0,0,0,1,24,-1},{52,0,0,7,0,0,0,1,24,-1},{52,0,0,7,0,0,0,1,24,-1},{52,0,0,7,0,0,0,1,24,-1},{52,0,0,7,0,0,0,1,24,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{59,0,0,7,0,0,0,1,24,-1},{59,0,0,7,0,0,0,1,24,-1},{59,0,0,7,0,0,0,1,24,-1},{59,0,0,7,0,0,0,1,24,-1},{59,0,0,7,0,0,0,1,24,-1},{59,0,0,7,0,0,0,1,24,-1},{59,0,0,7,0,0,0,1,24,-1},{59,0,0,7,0,0,0,1,24,-1},{59,0,0,7,0,0,0,1,24,-1},{59,0,0,7,0,0,0,1,24,-1},{59,0,0,7,0,0,0,1,24,-1},{59,0,0,7,0,0,0,1,24,-1},{59,0,0,7,0,0,0,1,24,-1},{59,0,0,7,0,0,0,1,24,-1},{59,0,0,7,0,0,0,1,24,-1},{59,0,0,7,0,0,0,1,24,-1}},
  {{59,0,0,7,0,0,0,1,24,-1},{59,0,0,7,0,0,0,1,24,-1},{59,0,0,7,0,0,0,1,24,-1},{59,0,0,7,0,0,0,1,24,-1},{59,0,0,7,0,0,0,1,24,-1},{59,0,0,7,0,0,0,1,24,-1},{59,0,0,7,0,0,0,1,24,-1},{59,0,0,7,0,0,0,1,24,-1},{59,0,0,7,0,0,0,1,24,-1},{59,0,0,7,0,0,0,1,24,-1},{59,0,0,7,0,0,0,1,24,-1},{59,0,0,7,0,0,0,1,24,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{59,0,0,7,0,0,0,1,24,-1},{59,0,0,7,0,0,0,1,24,-1},{59,0,0,7,0,0,0,1,24,-1},{59,0,0,7,0,0,0,1,24,-1},{59,0,0,7,0,0,0,1,24,-1},{59,0,0,7,0,0,0,1,24,-1},{59,0,0,7,0,0,0,1,24,-1},{59,0,0,7,0,0,0,1,24,-1},{59,0,0,7,0,0,0,1,24,-1},{59,0,0,7,0,0,0,1,24,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{59,0,0,13,0,0,0,1,19,0},{59,0,0,13,0,0,0,1,19,1},{59,0,0,13,0,0,0,1,19,2},{59,0,0,13,0,0,0,1,19,3},{59,0,0,13,0,0,0,1,19,4},{59,0,0,13,0,0,0,1,19,5},{59,0,0,13,0,0,0,1,19,6},{59,0,0,13,0,0,0,1,19,7},{59,0,0,13,0,0,0,1,19,8},{59,0,0,13,0,0,0,1,19,9},{59,0,0,15,0,0,0,1,24,1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{59,0,0,26,0,0,10,1,24,-1},{59,0,0,26,0,0,10,1,24,-1}},
  {{23,0,0,26,0,0,10,1,2,-1},{23,0,0,26,0,0,10,1,2,-1},{23,0,0,26,0,0,10,1,2,-1},{23,0,0,26,0,0,10,1,2,-1},{23,0,0,26,0,0,10,1,2,-1},{23,0,0,26,0,0,10,1,2,-1},{23,0,0,26,0,0,10,1,2,-1},{23,0,0,26,0,0,10,1,2,-1},{23,0,0,26,0,0,10,1,2,-1},{23,0,0,26,0,0,10,1,2,-1},{23,0,0,26,0,0,10,1,2,-1},{23,0,0,26,0,0,10,1,2,-1},{23,0,0,26,0,0,10,1,2,-1},{23,0,0,26,0,0,10,1,2,-1},{23,0,0,26,0,0,10,1,2,-1},{23,0,0,26,0,0,10,1,2,-1}},
  {{55,0,0,7,0,0,0,1,2,-1},{55,0,0,7,0,0,0,1,2,-1},{55,0,0,7,0,0,0,1,2,-1},{55,0,0,7,0,0,0,1,2,-1},{55,0,0,7,0,0,0,1,2,-1},{55,0,0,7,0,0,0,1,2,-1},{55,0,0,7,0,0,0,1,2,-1},{55,0,0,7,0,0,0,1,2,-1},{55,0,0,7,0,0,0,1,2,-1},{55,0,0,7,0,0,0,1,2,-1},{55,0,0,7,0,0,0,1,2,-1},{55,0,0,7,0,0,0,1,2,-1},{55,0,0,7,0,0,0,1,2,-1},{55,0,0,7,0,0,0,1,2,-1},{55,0,0,7,0,0,0,1,2,-1},{55,0,0,7,0,0,0,1,2,-1}},
  {{55,0,0,7,0,0,0,1,2,-1},{55,0,0,7,0,0,0,1,2,-1},{55,0,0,7,0,0,0,1,2,-1},{55,0,0,7,0,0,0,1,2,-1},{55,0,0,7,0,0,0,1,2,-1},{55,0,0,7,0,0,0,1,2,-1},{55,0,0,7,0,0,0,1,2,-1},{55,0,0,12,0,0,17,1,9,-1},{55,0,0,12,0,0,17,1,9,-1},{55,0,0,10,0,0,0,1,9,-1},{55,0,0,10,0,0,0,1,9,-1},{55,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{55,0,0,21,0,0,0,1,2,-1},{55,0,0,21,0,0,0,1,2,-1}},
  {{106,0,0,7,0,0,0,1,24,-1},{106,0,0,7,0,0,0,1,24,-1},{106,0,0,7,0,0,0,1,24,-1},{106,0,0,7,0,0,0,1,24,-1},{106,0,0,7,0,0,0,1,24,-1},{106,0,0,7,0,0,0,1,24,-1},{106,0,0,7,0,0,0,1,24,-1},{106,0,0,7,0,0,0,1,24,-1},{106,0,0,7,0,0,0,1,24,-1},{106,0,0,7,0,0,0,1,24,-1},{106,0,0,7,0,0,0,1,24,-1},{106,0,0,7,0,0,0,1,24,-1},{106,0,0,7,0,0,0,1,24,-1},{106,0,0,7,0,0,0,1,24,-1},{106,0,0,7,0,0,0,1,24,-1},{106,0,0,7,0,0,0,1,24,-1}},
  {{106,0,0,7,0,0,0,1,24,-1},{106,0,0,7,0,0,0,1,24,-1},{106,0,0,7,0,0,0,1,24,-1},{106,0,0,7,0,0,0,1,24,-1},{106,0,0,7,0,0,0,1,24,-1},{106,0,0,10,0,0,0,1,24,-1},{106,0,0,12,0,0,17,1,24,-1},{106,0,0,10,0,0,0,1,24,-1},{106,0,0,12,0,0,17,1,24,-1},{106,0,0,12,0,0,17,1,24,-1},{106,0,0,12,0,0,17,1,24,-1},{106,0,0,12,0,0,17,1,24,-1},{106,0,0,12,0,0,17,1,24,-1},{106,0,0,12,0,0,17,1,24,-1},{106,0,0,12,0,0,17,1,24,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{106,0,0,12,0,0,17,1,24,-1},{106,0,0,10,0,0,0,1,24,-1},{106,0,0,12,0,0,17,1,24,-1},{106,0,0,10,0,0,0,1,24,-1},{106,0,0,10,0,0,0,1,24,-1},{106,0,0,12,0,0,17,1,24,-1},{106,0,0,12,0,0,17,1,24,-1},{106,0,0,12,0,0,17,1,24,-1},{106,0,0,12,0,0,17,1,24,-1},{106,0,0,12,0,0,17,1,24,-1},{106,0,0,12,0,0,17,1,24,-1},{106,0,0,12,0,0,17,1,24,-1},{106,0,0,12,0,0,17,1,24,-1},{106,0,0,10,0,0,0,1,24,-1},{106,0,0,10,0,0,0,1,24,-1},{106,0,0,10,0,0,0,1,24,-1}},
  {{106,0,0,10,0,0,0,1,24,-1},{106,0,0,10,0,0,0,1,24,-1},{106,0,0,10,0,0,0,1,24,-1},{106,0,0,12,0,0,17,1,24,-1},{106,0,0,12,0,0,17,1,24,-1},{106,0,0,12,0,0,17,1,24,-1},{106,0,0,12,0,0,17,1,24,-1},{106,0,0,12,0,0,17,1,24,-1},{106,0,0,12,0,0,17,1,24,-1},{106,0,0,12,0,0,17,1,24,-1},{106,0,0,12,0,0,17,1,24,-1},{106,0,0,12,0,0,17,1,24,-1},{106,0,0,12,0,0,17,1,24,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{106,0,0,12,0,0,17,1,9,-1}},
  {{106,0,0,13,0,0,0,1,19,0},{106,0,0,13,0,0,0,1,19,1},{106,0,0,13,0,0,0,1,19,2},{106,0,0,13,0,0,0,1,19,3},{106,0,0,13,0,0,0,1,19,4},{106,0,0,13,0,0,0,1,19,5},{106,0,0,13,0,0,0,1,19,6},{106,0,0,13,0,0,0,1,19,7},{106,0,0,13,0,0,0,1,19,8},{106,0,0,13,0,0,0,1,19,9},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{106,0,0,21,0,0,0,1,24,-1},{106,0,0,21,0,0,0,1,24,-1},{106,0,0,21,0,0,0,1,24,-1},{106,0,0,21,0,0,0,1,24,-1},{106,0,0,21,0,0,0,1,24,-1},{106,0,0,21,0,0,0,1,24,-1},{106,0,0,21,0,0,0,1,24,-1},{106,0,0,6,0,0,0,1,24,-1},{106,0,0,21,0,0,0,1,24,-1},{106,0,0,21,0,0,0,1,24,-1},{106,0,0,21,0,0,0,1,24,-1},{106,0,0,21,0,0,0,1,24,-1},{106,0,0,21,0,0,0,1,24,-1},{106,0,0,21,0,0,0,1,24,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,11,0,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{62,0,0,12,0,0,17,1,9,-1},{62,0,0,12,0,0,17,1,9,-1},{62,0,0,12,0,0,17,1,9,-1},{62,0,0,12,0,0,17,1,9,-1},{62,0,0,10,0,0,0,1,9,-1},{62,0,0,7,0,0,0,1,2,-1},{62,0,0,7,0,0,0,1,2,-1},{62,0,0,7,0,0,0,1,2,-1},{62,0,0,7,0,0,0,1,2,-1},{62,0,0,7,0,0,0,1,2,-1},{62,0,0,7,0,0,0,1,2,-1},{62,0,0,7,0,0,0,1,2,-1},{62,0,0,7,0,0,0,1,2,-1},{62,0,0,7,0,0,0,1,2,-1},{62,0,0,7,0,0,0,1,2,-1},{62,0,0,7,0,0,0,1,2,-1}},
  {{62,0,0,7,0,0,0,1,2,-1},{62,0,0,7,0,0,0,1,2,-1},{62,0,0,7,0,0,0,1,2,-1},{62,0,0,7,0,0,0,1,2,-1},{62,0,0,7,0,0,0,1,2,-1},{62,0,0,7,0,0,0,1,2,-1},{62,0,0,7,0,0,0,1,2,-1},{62,0,0,7,0,0,0,1,2,-1},{62,0,0,7,0,0,0,1,2,-1},{62,0,0,7,0,0,0,1,2,-1},{62,0,0,7,0,0,0,1,2,-1},{62,0,0,7,0,0,0,1,2,-1},{62,0,0,7,0,0,0,1,2,-1},{62,0,0,7,0,0,0,1,2,-1},{62,0,0,7,0,0,0,1,2,-1},{62,0,0,7,0,0,0,1,2,-1}},
  {{62,0,0,7,0,0,0,1,2,-1},{62,0,0,7,0,0,0,1,2,-1},{62,0,0,7,0,0,0,1,2,-1},{62,0,0,7,0,0,0,1,2,-1},{62,0,0,12,0,0,17,1,9,-1},{62,0,0,10,0,0,0,1,9,-1},{62,0,0,12,0,0,17,1,9,-1},{62,0,0,12,0,0,17,1,9,-1},{62,0,0,12,0,0,17,1,9,-1},{62,0,0,12,0,0,17,1,9,-1},{62,0,0,12,0,0,17,1,9,-1},{62,0,0,10,0,0,0,1,9,-1},{62,0,0,12,0,0,17,1,9,-1},{62,0,0,10,0,0,0,1,9,-1},{62,0,0,10,0,0,0,1,9,-1},{62,0,0,10,0,0,0,1,9,-1}},
  {{62,0,0,10,0,0,0,1,9,-1},{62,0,0,10,0,0,0,1,9,-1},{62,0,0,12,0,0,17,1,9,-1},{62,0,0,10,0,0,0,1,9,-1},{62,0,0,10,0,0,0,1,9,-1},{62,0,0,7,0,0,0,1,2,-1},{62,0,0,7,0,0,0,1,2,-1},{62,0,0,7,0,0,0,1,2,-1},{62,0,0,7,0,0,0,1,2,-1},{62,0,0,7,0,0,0,1,2,-1},{62,0,0,7,0,0,0,1,2,-1},{62,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{62,0,0,13,0,0,0,1,19,0},{62,0,0,13,0,0,0,1,19,1},{62,0,0,13,0,0,0,1,19,2},{62,0,0,13,0,0,0,1,19,3},{62,0,0,13,0,0,0,1,19,4},{62,0,0,13,0,0,0,1,19,5},{62,0,0,13,0,0,0,1,19,6},{62,0,0,13,0,0,0,1,19,7},{62,0,0,13,0,0,0,1,19,8},{62,0,0,13,0,0,0,1,19,9},{62,0,0,21,0,0,0,1,4,-1},{62,0,0,21,0,0,0,1,4,-1},{62,0,0,21,0,0,0,1,2,-1},{62,0,0,21,0,0,0,1,4,-1},{62,0,0,21,0,0,0,1,4,-1},{62,0,0,21,0,0,0,1,4,-1}},
  {{62,0,0,21,0,0,0,1,4,-1},{62,0,0,26,0,0,0,1,2,-1},{62,0,0,26,0,0,0,1,2,-1},{62,0,0,26,0,0,0,1,2,-1},{62,0,0,26,0,0,0,1,2,-1},{62,0,0,26,0,0,0,1,2,-1},{62,0,0,26,0,0,0,1,2,-1},{62,0,0,26,0,0,0,1,2,-1},{62,0,0,26,0,0,0,1,2,-1},{62,0,0,26,0,0,0,1,2,-1},{62,0,0,26,0,0,0,1,2,-1},{62,0,0,12,0,0,17,1,9,-1},{62,0,0,12,0,0,17,1,9,-1},{62,0,0,12,0,0,17,1,9,-1},{62,0,0,12,0,0,17,1,9,-1},{62,0,0,12,0,0,17,1,9,-1}},
  {{62,0,0,12,0,0,17,1,9,-1},{62,0,0,12,0,0,17,1,9,-1},{62,0,0,12,0,0,17,1,9,-1},{62,0,0,12,0,0,17,1,9,-1},{62,0,0,26,0,0,0,1,2,-1},{62,0,0,26,0,0,0,1,2,-1},{62,0,0,26,0,0,0,1,2,-1},{62,0,0,26,0,0,0,1,2,-1},{62,0,0,26,0,0,0,1,2,-1},{62,0,0,26,0,0,0,1,2,-1},{62,0,0,26,0,0,0,1,2,-1},{62,0,0,26,0,0,0,1,2,-1},{62,0,0,26,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{113,0,0,12,0,0,17,1,9,-1},{113,0,0,12,0,0,17,1,9,-1},{113,0,0,10,0,0,0,1,9,-1},{113,0,0,7,0,0,0,1,2,-1},{113,0,0,7,0,0,0,1,2,-1},{113,0,0,7,0,0,0,1,2,-1},{113,0,0,7,0,0,0,1,2,-1},{113,0,0,7,0,0,0,1,2,-1},{113,0,0,7,0,0,0,1,2,-1},{113,0,0,7,0,0,0,1,2,-1},{113,0,0,7,0,0,0,1,2,-1},{113,0,0,7,0,0,0,1,2,-1},{113,0,0,7,0,0,0,1,2,-1},{113,0,0,7,0,0,0,1,2,-1},{113,0,0,7,0,0,0,1,2,-1},{113,0,0,7,0,0,0,1,2,-1}},
  {{113,0,0,7,0,0,0,1,2,-1},{113,0,0,7,0,0,0,1,2,-1},{113,0,0,7,0,0,0,1,2,-1},{113,0,0,7,0,0,0,1,2,-1},{113,0,0,7,0,0,0,1,2,-1},{113,0,0,7,0,0,0,1,2,-1},{113,0,0,7,0,0,0,1,2,-1},{113,0,0,7,0,0,0,1,2,-1},{113,0,0,7,0,0,0,1,2,-1},{113,0,0,7,0,0,0,1,2,-1},{113,0,0,7,0,0,0,1,2,-1},{113,0,0,7,0,0,0,1,2,-1},{113,0,0,7,0,0,0,1,2,-1},{113,0,0,7,0,0,0,1,2,-1},{113,0,0,7,0,0,0,1,2,-1},{113,0,0,7,0,0,0,1,2,-1}},
  {{113,0,0,7,0,0,0,1,2,-1},{113,0,0,10,0,0,0,1,9,-1},{113,0,0,12,0,0,17,1,9,-1},{113,0,0,12,0,0,17,1,9,-1},{113,0,0,12,0,0,17,1,9,-1},{113,0,0,12,0,0,17,1,9,-1},{113,0,0,10,0,0,0,1,9,-1},{113,0,0,10,0,0,0,1,9,-1},{113,0,0,12,0,0,17,1,9,-1},{113,0,0,12,0,0,17,1,9,-1},{113,0,0,10,0,0,0,1,9,-1},{113,0,0,12,0,0,17,1,9,-1},{113,0,0,12,0,0,17,1,9,-1},{113,0,0,12,0,0,17,1,9,-1},{113,0,0,7,0,0,0,1,2,-1},{113,0,0,7,0,0,0,1,2,-1}},
  {{113,0,0,13,0,0,0,1,19,0},{113,0,0,13,0,0,0,1,19,1},{113,0,0,13,0,0,0,1,19,2},{113,0,0,13,0,0,0,1,19,3},{113,0,0,13,0,0,0,1,19,4},{113,0,0,13,0,0,0,1,19,5},{113,0,0,13,0,0,0,1,19,6},{113,0,0,13,0,0,0,1,19,7},{113,0,0,13,0,0,0,1,19,8},{113,0,0,13,0,0,0,1,19,9},{113,0,0,7,0,0,0,1,2,-1},{113,0,0,7,0,0,0,1,2,-1},{113,0,0,7,0,0,0,1,2,-1},{113,0,0,7,0,0,0,1,2,-1},{113,0,0,7,0,0,0,1,2,-1},{113,0,0,7,0,0,0,1,2,-1}},
  {{63,0,0,7,0,0,0,1,2,-1},{63,0,0,7,0,0,0,1,2,-1},{63,0,0,7,0,0,0,1,2,-1},{63,0,0,7,0,0,0,1,2,-1},{63,0,0,7,0,0,0,1,2,-1},{63,0,0,7,0,0,0,1,2,-1},{63,0,0,7,0,0,0,1,2,-1},{63,0,0,7,0,0,0,1,2,-1},{63,0,0,7,0,0,0,1,2,-1},{63,0,0,7,0,0,0,1,2,-1},{63,0,0,7,0,0,0,1,2,-1},{63,0,0,7,0,0,0,1,2,-1},{63,0,0,7,0,0,0,1,2,-1},{63,0,0,7,0,0,0,1,2,-1},{63,0,0,7,0,0,0,1,2,-1},{63,0,0,7,0,0,0,1,2,-1}},
  {{63,0,0,7,0,0,0,1,2,-1},{63,0,0,7,0,0,0,1,2,-1},{63,0,0,7,0,0,0,1,2,-1},{63,0,0,7,0,0,0,1,2,-1},{63,0,0,7,0,0,0,1,2,-1},{63,0,0,7,0,0,0,1,2,-1},{63,0,0,12,0,0,17,1,9,-1},{63,0,0,10,0,0,0,1,9,-1},{63,0,0,12,0,0,17,1,9,-1},{63,0,0,12,0,0,17,1,9,-1},{63,0,0,10,0,0,0,1,9,-1},{63,0,0,10,0,0,0,1,9,-1},{63,0,0,10,0,0,0,1,9,-1},{63,0,0,12,0,0,17,1,9,-1},{63,0,0,10,0,0,0,1,9,-1},{63,0,0,12,0,0,17,1,9,-1}},
  {{63,0,0,12,0,0,17,1,9,-1},{63,0,0,12,0,0,17,1,9,-1},{63,0,0,10,0,0,0,1,9,-1},{63,0,0,10,0,0,0,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{63,0,0,21,0,0,0,1,2,-1},{63,0,0,21,0,0,0,1,2,-1},{63,0,0,21,0,0,0,1,2,-1},{63,0,0,21,0,0,0,1,2,-1}},
  {{82,0,0,7,0,0,0,1,2,-1},{82,0,0,7,0,0,0,1,2,-1},{82,0,0,7,0,0,0,1,2,-1},{82,0,0,7,0,0,0,1,2,-1},{82,0,0,7,0,0,0,1,2,-1},{82,0,0,7,0,0,0,1,2,-1},{82,0,0,7,0,0,0,1,2,-1},{82,0,0,7,0,0,0,1,2,-1},{82,0,0,7,0,0,0,1,2,-1},{82,0,0,7,0,0,0,1,2,-1},{82,0,0,7,0,0,0,1,2,-1},{82,0,0,7,0,0,0,1,2,-1},{82,0,0,7,0,0,0,1,2,-1},{82,0,0,7,0,0,0,1,2,-1},{82,0,0,7,0,0,0,1,2,-1},{82,0,0,7,0,0,0,1,2,-1}},
  {{82,0,0,7,0,0,0,1,2,-1},{82,0,0,7,0,0,0,1,2,-1},{82,0,0,7,0,0,0,1,2,-1},{82,0,0,7,0,0,0,1,2,-1},{82,0,0,10,0,0,0,1,9,-1},{82,0,0,10,0,0,0,1,9,-1},{82,0,0,10,0,0,0,1,9,-1},{82,0,0,10,0,0,0,1,9,-1},{82,0,0,10,0,0,0,1,9,-1},{82,0,0,10,0,0,0,1,9,-1},{82,0,0,10,0,0,0,1,9,-1},{82,0,0,10,0,0,0,1,9,-1},{82,0,0,12,0,0,17,1,9,-1},{82,0,0,12,0,0,17,1,9,-1},{82,0,0,12,0,0,17,1,9,-1},{82,0,0,12,0,0,17,1,9,-1}},
  {{82,0,0,12,0,0,17,1,9,-1},{82,0,0,12,0,0,17,1,9,-1},{82,0,0,12,0,0,17,1,9,-1},{82,0,0,12,0,0,17,1,9,-1},{82,0,0,10,0,0,0,1,9,-1},{82,0,0,10,0,0,0,1,9,-1},{82,0,0,12,0,0,17,1,9,-1},{82,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{82,0,0,21,0,0,0,1,4,-1},{82,0,0,21,0,0,0,1,4,-1},{82,0,0,21,0,0,0,1,4,-1},{82,0,0,21,0,0,0,1,4,-1},{82,0,0,21,0,0,0,1,4,-1}},
  {{82,0,0,13,0,0,0,1,19,0},{82,0,0,13,0,0,0,1,19,1},{82,0,0,13,0,0,0,1,19,2},{82,0,0,13,0,0,0,1,19,3},{82,0,0,13,0,0,0,1,19,4},{82,0,0,13,0,0,0,1,19,5},{82,0,0,13,0,0,0,1,19,6},{82,0,0,13,0,0,0,1,19,7},{82,0,0,13,0,0,0,1,19,8},{82,0,0,13,0,0,0,1,19,9},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{82,0,0,7,0,0,0,1,2,-1},{82,0,0,7,0,0,0,1,2,-1},{82,0,0,7,0,0,0,1,2,-1}},
  {{109,0,0,13,0,0,0,1,19,0},{109,0,0,13,0,0,0,1,19,1},{109,0,0,13,0,0,0,1,19,2},{109,0,0,13,0,0,0,1,19,3},{109,0,0,13,0,0,0,1,19,4},{109,0,0,13,0,0,0,1,19,5},{109,0,0,13,0,0,0,1,19,6},{109,0,0,13,0,0,0,1,19,7},{109,0,0,13,0,0,0,1,19,8},{109,0,0,13,0,0,0,1,19,9},{109,0,0,7,0,0,0,1,2,-1},{109,0,0,7,0,0,0,1,2,-1},{109,0,0,7,0,0,0,1,2,-1},{109,0,0,7,0,0,0,1,2,-1},{109,0,0,7,0,0,0,1,2,-1},{109,0,0,7,0,0,0,1,2,-1}},
  {{109,0,0,7,0,0,0,1,2,-1},{109,0,0,7,0,0,0,1,2,-1},{109,0,0,7,0,0,0,1,2,-1},{109,0,0,7,0,0,0,1,2,-1},{109,0,0,7,0,0,0,1,2,-1},{109,0,0,7,0,0,0,1,2,-1},{109,0,0,7,0,0,0,1,2,-1},{109,0,0,7,0,0,0,1,2,-1},{109,0,0,7,0,0,0,1,2,-1},{109,0,0,7,0,0,0,1,2,-1},{109,0,0,7,0,0,0,1,2,-1},{109,0,0,7,0,0,0,1,2,-1},{109,0,0,7,0,0,0,1,2,-1},{109,0,0,7,0,0,0,1,2,-1},{109,0,0,7,0,0,0,1,2,-1},{109,0,0,7,0,0,0,1,2,-1}},
  {{109,0,0,7,0,0,0,1,2,-1},{109,0,0,7,0,0,0,1,2,-1},{109,0,0,7,0,0,0,1,2,-1},{109,0,0,7,0,0,0,1,2,-1},{109,0,0,7,0,0,0,1,2,-1},{109,0,0,7,0,0,0,1,2,-1},{109,0,0,7,0,0,0,1,2,-1},{109,0,0,7,0,0,0,1,2,-1},{109,0,0,6,0,0,0,1,2,-1},{109,0,0,6,0,0,0,1,2,-1},{109,0,0,6,0,0,0,1,2,-1},{109,0,0,6,0,0,0,1,2,-1},{109,0,0,6,0,0,0,1,2,-1},{109,0,0,6,0,0,0,1,2,-1},{109,0,0,21,0,0,0,1,4,-1},{109,0,0,21,0,0,0,1,4,-1}},
  {{8,0,0,5,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{113,0,0,21,0,0,0,1,2,-1},{113,0,0,21,0,0,0,1,2,-1},{113,0,0,21,0,0,0,1,2,-1},{113,0,0,21,0,0,0,1,2,-1},{113,0,0,21,0,0,0,1,2,-1},{113,0,0,21,0,0,0,1,2,-1},{113,0,0,21,0,0,0,1,2,-1},{113,0,0,21,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{0,0,0,21,0,0,0,1,2,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1}},
  {{1,0,0,12,0,0,17,1,9,-1},{0,0,0,10,0,0,0,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{0,0,0,7,0,0,0,1,2,-1},{0,0,0,7,0,0,0,1,2,-1},{0,0,0,7,0,0,0,1,2,-1},{0,0,0,7,0,0,0,1,2,-1},{1,0,0,12,0,0,17,1,9,-1},{0,0,0,7,0,0,0,1,2,-1},{0,0,0,7,0,0,0,1,2,-1}},
  {{0,0,0,7,0,0,0,1,2,-1},{0,0,0,7,0,0,0,1,2,-1},{0,0,0,10,0,0,0,1,9,-1},{0,0,0,10,0,0,0,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{0,0,0,7,0,0,0,1,2,-1},{0,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{14,0,0,5,0,0,0,1,2,-1},{14,0,0,5,0,0,0,1,2,-1},{14,0,0,5,0,0,0,1,2,-1},{14,0,0,5,0,0,0,1,2,-1},{14,0,0,5,0,0,0,1,2,-1},{8,0,0,5,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1}},
  {{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1}},
  {{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{14,0,0,6,0,0,0,1,2,-1},{14,0,0,6,0,0,0,1,2,-1},{14,0,0,6,0,0,0,1,2,-1}},
  {{14,0,0,6,0,0,0,1,2,-1},{14,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{14,0,0,6,0,0,0,1,2,-1},{14,0,0,6,0,0,0,1,2,-1},{14,0,0,6,0,0,0,1,2,-1},{14,0,0,6,0,0,0,1,2,-1},{14,0,0,6,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1}},
  {{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{8,0,0,6,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1}},
  {{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1}},
  {{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{14,0,0,6,0,0,0,1,2,-1}},
  {{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1}},
  {{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1}},
  {{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1}},
  {{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1}},
  {{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1}},
  {{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{14,0,0,9,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{14,0,0,9,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{14,0,0,9,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{14,0,0,9,1,0,0,1,2,-1}},
  {{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,0,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,0,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,0,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,0,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,0,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,0,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,8,1,0,0,1,2,-1},{14,0,0,8,1,0,0,1,2,-1},{14,0,0,8,1,0,0,1,2,-1},{14,0,0,8,1,0,0,1,2,-1},{14,0,0,8,1,0,0,1,2,-1},{14,0,0,8,1,0,0,1,2,-1},{14,0,0,8,1,0,0,1,2,-1},{14,0,0,8,1,0,0,1,2,-1}},
  {{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,0,0,0,1,2,-1},{14,0,0,8,1,0,0,1,2,-1},{14,0,0,24,0,0,10,1,2,-1},{14,0,0,5,0,0,0,1,2,-1},{14,0,0,24,0,0,10,1,2,-1}},
  {{14,0,0,24,0,0,10,1,2,-1},{14,0,0,24,0,0,10,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,0,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,0,0,0,1,2,-1},{14,0,0,8,1,0,0,1,2,-1},{14,0,0,24,0,0,10,1,2,-1},{14,0,0,24,0,0,10,1,2,-1},{14,0,0,24,0,0,10,1,2,-1}},
  {{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{14,0,0,24,0,0,10,1,2,-1},{14,0,0,24,0,0,10,1,2,-1},{14,0,0,24,0,0,10,1,2,-1}},
  {{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,0,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,0,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,24,0,0,10,1,2,-1},{14,0,0,24,0,0,10,1,2,-1},{14,0,0,24,0,0,10,1,2,-1}},
  {{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,5,1,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,0,0,0,1,2,-1},{14,0,0,9,1,0,0,1,2,-1},{14,0,0,9,0,0,0,1,2,-1},{14,0,0,8,1,0,0,1,2,-1},{14,0,0,24,0,0,10,1,5,-1},{14,0,0,24,0,0,10,1,2,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{0,0,0,29,0,0,9,1,4,-1},{0,0,0,29,0,0,9,1,4,-1},{0,0,0,29,0,0,9,1,4,-1},{0,0,0,29,0,0,9,1,4,-1},{0,0,0,29,0,0,9,1,4,-1},{0,0,0,29,0,0,9,1,4,-1},{0,0,0,29,0,0,9,1,4,-1},{0,0,0,29,0,0,9,1,12,-1},{0,0,0,29,0,0,9,1,4,-1},{0,0,0,29,0,0,9,1,4,-1},{0,0,0,29,0,0,9,1,4,-1},{0,0,0,1,0,1,18,1,28,-1},{1,0,0,1,1,1,18,1,9,-1},{1,0,0,1,1,1,18,1,42,-1},{0,0,0,1,0,1,0,1,9,-1},{0,0,0,1,0,1,1,1,9,-1}},
  {{0,0,0,17,1,0,10,1,4,-1},{0,0,0,17,0,0,10,1,12,-1},{0,0,0,17,0,0,10,1,4,-1},{0,0,0,17,0,0,10,1,4,-1},{0,0,0,17,0,0,10,1,3,-1},{0,0,0,17,0,0,10,1,1,-1},{0,0,0,21,0,0,10,0,1,-1},{0,0,0,21,0,0,10,1,2,-1},{0,0,0,20,0,0,10,1,23,-1},{0,0,0,19,1,0,10,1,23,-1},{0,0,0,22,0,0,10,1,20,-1},{0,0,0,20,0,0,10,1,23,-1},{0,0,0,20,0,0,10,1,23,-1},{0,0,0,19,0,0,10,1,23,-1},{0,0,0,22,0,0,10,1,20,-1},{0,0,0,20,0,0,10,1,23,-1}},
  {{0,0,0,21,0,0,10,0,1,-1},{0,0,0,21,0,0,10,0,1,-1},{0,0,0,21,0,0,10,1,2,-1},{0,0,0,21,0,0,10,1,2,-1},{0,0,0,21,0,0,10,1,15,-1},{0,0,0,21,0,0,10,1,15,-1},{0,0,0,21,0,0,10,1,15,-1},{0,0,0,21,1,0,10,1,4,-1},{0,0,0,27,0,0,9,1,6,-1},{0,0,0,28,0,0,7,1,6,-1},{0,0,0,1,0,1,11,1,9,-1},{0,0,0,1,0,1,14,1,9,-1},{0,0,0,1,0,1,16,1,9,-1},{0,0,0,1,0,1,12,1,9,-1},{0,0,0,1,0,1,15,1,9,-1},{0,0,0,29,0,0,6,1,12,-1}},
  {{0,0,0,21,0,0,4,0,21,-1},{0,0,0,21,0,0,4,0,21,-1},{0,0,0,21,0,0,4,1,21,-1},{0,0,0,21,0,0,4,1,21,-1},{0,0,0,21,0,0,4,1,21,-1},{0,0,0,21,0,0,10,1,21,-1},{0,0,0,21,0,0,10,1,21,-1},{0,0,0,21,0,0,10,1,21,-1},{0,0,0,21,0,0,10,1,2,-1},{0,0,0,20,0,0,10,1,23,-1},{0,0,0,19,0,0,10,1,23,-1},{0,0,0,21,0,0,10,0,1,-1},{0,0,0,21,0,0,10,0,18,-1},{0,0,0,21,0,0,10,1,18,-1},{0,0,0,21,0,0,10,1,2,-1},{0,0,0,16,0,0,10,1,2,-1}},
  {{0,0,0,16,0,0,10,1,2,-1},{0,0,0,21,0,0,10,1,2,-1},{0,0,0,21,0,0,10,0,2,-1},{0,0,0,21,0,0,10,1,2,-1},{0,0,0,25,0,0,6,1,16,-1},{0,1,0,22,0,0,10,1,20,-1},{0,2,0,18,0,0,10,1,8,-1},{0,0,0,21,0,0,10,0,18,-1},{0,0,0,21,0,0,10,0,18,-1},{0,0,0,21,0,0,10,0,18,-1},{0,0,0,21,0,0,10,1,2,-1},{0,0,0,21,0,0,10,1,2,-1},{0,0,0,21,0,0,10,1,2,-1},{0,0,0,21,0,0,10,1,2,-1},{0,0,0,21,0,0,10,1,2,-1},{0,0,0,21,0,0,10,1,2,-1}},
  {{0,0,0,21,0,0,10,1,2,-1},{0,0,0,21,0,0,10,0,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,21,0,0,10,1,2,-1},{0,0,0,16,0,0,10,1,2,-1},{0,0,0,21,0,0,10,1,2,-1},{0,0,0,21,0,0,10,1,4,-1},{0,0,0,21,0,0,10,1,2,-1},{0,0,0,21,0,0,10,1,4,-1},{0,0,0,21,0,0,10,1,4,-1},{0,0,0,21,0,0,10,1,4,-1},{0,0,0,21,0,0,10,1,4,-1},{0,0,0,21,0,0,10,1,2,-1},{0,0,0,21,0,0,10,1,4,-1},{0,0,0,21,0,0,10,1,4,-1},{0,0,0,29,0,0,9,1,4,-1}},
  {{0,0,0,1,0,1,18,1,30,-1},{0,0,0,1,0,1,18,1,2,-1},{0,0,0,1,0,1,18,1,2,-1},{0,0,0,1,0,1,18,1,2,-1},{0,0,0,1,0,1,18,1,2,-1},{103,0,0,2,0,1,0,0,0,-1},{0,0,0,1,0,1,20,1,9,-1},{0,0,0,1,0,1,21,1,9,-1},{0,0,0,1,0,1,19,1,9,-1},{0,0,0,1,0,1,22,1,9,-1},{0,0,0,1,0,1,18,1,9,-1},{0,0,0,1,0,1,18,1,9,-1},{0,0,0,1,0,1,18,1,9,-1},{0,0,0,1,0,1,18,1,9,-1},{0,0,0,1,0,1,18,1,9,-1},{0,0,0,1,0,1,18,1,9,-1}},
  {{0,0,0,15,0,0,2,1,2,0},{25,0,0,6,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{0,0,0,15,0,0,2,1,1,4},{0,0,0,15,0,0,2,1,2,5},{0,0,0,15,0,0,2,1,2,6},{0,0,0,15,0,0,2,1,2,7},{0,0,0,15,0,0,2,1,2,8},{0,0,0,15,0,0,2,1,2,9},{0,0,0,25,0,0,3,1,2,-1},{0,0,0,25,0,0,3,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,1,0,22,0,0,10,1,20,-1},{0,2,0,18,0,0,10,1,8,-1},{25,0,0,6,0,0,0,1,1,-1}},
  {{0,0,0,15,0,0,2,1,2,0},{0,0,0,15,0,0,2,1,1,1},{0,0,0,15,0,0,2,1,1,2},{0,0,0,15,0,0,2,1,1,3},{0,0,0,15,0,0,2,1,1,4},{0,0,0,15,0,0,2,1,2,5},{0,0,0,15,0,0,2,1,2,6},{0,0,0,15,0,0,2,1,2,7},{0,0,0,15,0,0,2,1,2,8},{0,0,0,15,0,0,2,1,2,9},{0,0,0,25,0,0,3,1,2,-1},{0,0,0,25,0,0,3,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,1,0,22,0,0,10,1,20,-1},{0,2,0,18,0,0,10,1,8,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{0,0,0,23,0,0,4,1,22,-1},{0,0,0,23,0,0,4,1,22,-1},{0,0,0,23,0,0,4,1,22,-1},{0,0,0,23,0,0,4,1,22,-1},{0,0,0,23,0,0,4,1,22,-1},{0,0,0,23,0,0,4,1,22,-1},{0,0,0,23,0,0,4,1,22,-1},{0,0,0,23,0,0,4,1,21,-1},{0,0,0,23,0,0,4,1,22,-1},{0,0,1,23,0,0,4,1,22,-1},{0,0,0,23,0,0,4,1,22,-1},{0,0,0,23,0,0,4,1,22,-1},{0,0,0,23,0,0,4,1,22,-1},{0,0,0,23,0,0,4,1,22,-1},{0,0,0,23,0,0,4,1,22,-1},{0,0,0,23,0,0,4,1,22,-1}},
  {{0,0,0,23,0,0,4,1,22,-1},{0,0,0,23,0,0,4,1,22,-1},{0,0,0,23,0,0,4,1,22,-1},{0,0,0,23,0,0,4,1,22,-1},{0,0,0,23,0,0,4,1,22,-1},{0,0,0,23,0,0,4,1,22,-1},{0,0,0,23,0,0,4,1,21,-1},{0,0,0,23,0,0,4,1,22,-1},{0,0,0,23,0,0,4,1,22,-1},{0,0,0,23,0,0,4,1,22,-1},{0,0,0,23,0,0,4,1,22,-1},{0,0,0,23,0,0,4,1,21,-1},{0,0,0,23,0,0,4,1,22,-1},{0,0,0,23,0,0,4,1,22,-1},{0,0,0,23,0,0,4,1,21,-1},{103,0,0,2,0,0,4,1,22,-1}},
  {{103,0,0,2,0,0,4,1,22,-1},{103,0,0,2,0,0,4,1,22,-1},{103,0,0,2,0,0,4,1,22,-1},{103,0,0,2,0,0,4,1,22,-1},{103,0,0,2,0,0,4,1,22,-1},{103,0,0,2,0,0,4,1,22,-1},{103,0,0,2,0,0,4,1,22,-1},{103,0,0,2,0,0,4,1,22,-1},{103,0,0,2,0,0,4,1,22,-1},{103,0,0,2,0,0,4,1,22,-1},{103,0,0,2,0,0,4,1,22,-1},{103,0,0,2,0,0,4,1,22,-1},{103,0,0,2,0,0,4,1,22,-1},{103,0,0,2,0,0,4,1,22,-1},{103,0,0,2,0,0,4,1,22,-1},{103,0,0,2,0,0,4,1,22,-1}},
  {{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,11,0,0,17,0,9,-1},{1,0,0,11,0,0,17,0,9,-1},{1,0,0,11,0,0,17,0,9,-1}},
  {{1,0,0,11,0,0,17,0,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,11,0,0,17,0,9,-1},{1,0,0,11,0,0,17,0,9,-1},{1,0,0,11,0,0,17,0,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1}},
  {{1,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,26,0,0,10,0,21,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,9,0,0,0,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,21,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,0,2,-1}},
  {{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,5,0,0,0,0,1,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,26,0,0,10,0,22,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1}},
  {{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,26,0,0,10,0,2,-1},{14,0,0,9,0,0,0,1,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,26,0,0,10,0,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,1,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,26,0,0,4,0,2,-1},{0,0,0,5,0,0,0,1,2,-1}},
  {{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,7,0,0,0,0,2,-1},{0,0,0,7,0,0,0,0,2,-1},{0,0,0,7,0,0,0,0,2,-1},{0,0,0,7,0,0,0,0,2,-1},{0,0,0,5,0,0,0,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,5,0,0,0,0,2,-1},{0,0,0,5,0,0,0,0,2,-1},{0,0,0,9,0,0,0,0,2,-1},{0,0,0,9,0,0,0,0,2,-1}},
  {{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,9,0,0,0,0,2,-1},{0,0,0,5,0,0,0,0,2,-1},{0,0,0,5,0,0,0,0,2,-1},{0,0,0,5,0,0,0,0,2,-1},{0,0,0,5,0,0,0,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{25,0,0,5,0,0,0,1,2,-1},{0,0,0,26,0,0,0,0,2,-1}},
  {{0,0,0,15,0,0,10,0,2,-1},{0,0,0,15,0,0,10,0,2,-1},{0,0,0,15,0,0,10,0,2,-1},{0,0,0,15,0,0,10,0,2,-1},{0,0,0,15,0,0,10,0,1,-1},{0,0,0,15,0,0,10,0,1,-1},{0,0,0,15,0,0,10,0,2,-1},{0,0,0,15,0,0,10,0,2,-1},{0,0,0,15,0,0,10,0,2,-1},{0,0,0,15,0,0,10,0,2,-1},{0,0,0,15,0,0,10,0,2,-1},{0,0,0,15,0,0,10,0,1,-1},{0,0,0,15,0,0,10,0,2,-1},{0,0,0,15,0,0,10,0,2,-1},{0,0,0,15,0,0,10,0,1,-1},{0,0,0,15,0,0,10,0,2,-1}},
  {{25,0,0,14,0,0,0,0,1,-1},{25,0,0,14,0,0,0,0,1,-1},{25,0,0,14,0,0,0,0,1,-1},{25,0,0,14,0,0,0,0,1,-1},{25,0,0,14,0,0,0,0,1,-1},{25,0,0,14,0,0,0,0,1,-1},{25,0,0,14,0,0,0,0,1,-1},{25,0,0,14,0,0,0,0,1,-1},{25,0,0,14,0,0,0,0,1,-1},{25,0,0,14,0,0,0,0,1,-1},{25,0,0,14,0,0,0,0,1,-1},{25,0,0,14,0,0,0,0,1,-1},{25,0,0,14,0,0,0,0,2,-1},{25,0,0,14,0,0,0,0,2,-1},{25,0,0,14,0,0,0,0,2,-1},{25,0,0,14,0,0,0,0,2,-1}},
  {{25,0,0,14,0,0,0,0,1,-1},{25,0,0,14,0,0,0,0,1,-1},{25,0,0,14,0,0,0,0,1,-1},{25,0,0,14,0,0,0,0,1,-1},{25,0,0,14,0,0,0,0,1,-1},{25,0,0,14,0,0,0,0,1,-1},{25,0,0,14,0,0,0,0,1,-1},{25,0,0,14,0,0,0,0,1,-1},{25,0,0,14,0,0,0,0,1,-1},{25,0,0,14,0,0,0,0,1,-1},{25,0,0,14,0,0,0,0,2,-1},{25,0,0,14,0,0,0,0,2,-1},{25,0,0,14,0,0,0,0,2,-1},{25,0,0,14,0,0,0,0,2,-1},{25,0,0,14,0,0,0,0,2,-1},{25,0,0,14,0,0,0,0,2,-1}},
  {{25,0,0,14,0,0,0,0,2,-1},{25,0,0,14,0,0,0,0,2,-1},{25,0,0,14,0,0,0,0,2,-1},{25,0,0,9,0,0,0,0,2,-1},{25,0,0,5,0,0,0,0,2,-1},{25,0,0,14,0,0,0,0,2,-1},{25,0,0,14,0,0,0,0,2,-1},{25,0,0,14,0,0,0,0,2,-1},{25,0,0,14,0,0,0,0,2,-1},{0,0,0,15,0,0,10,0,1,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1}},
  {{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1}},
  {{0,0,0,25,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1}},
  {{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1}},
  {{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1}},
  {{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1}},
  {{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1}},
  {{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,1,-1}},
  {{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,3,1,22,-1},{0,0,0,25,0,0,4,1,22,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,0,1,-1},{0,0,0,25,0,0,10,1,1,-1}},
  {{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,2,-1}},
  {{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,0,1,-1},{0,0,0,25,0,0,10,0,1,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1}},
  {{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1}},
  {{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1}},
  {{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,1,-1}},
  {{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1}},
  {{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1}},
  {{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1}},
  {{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,1,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1}},
  {{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,1,-1}},
  {{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,15,-1}},
  {{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,1,0,22,0,0,10,1,20,-1},{0,2,0,18,0,0,10,1,8,-1},{0,1,0,22,0,0,10,1,20,-1},{0,2,0,18,0,0,10,1,8,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1}},
  {{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1}},
  {{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,1,1,22,0,0,10,3,20,-1},{0,2,1,18,0,0,10,3,8,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1}},
  {{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1}},
  {{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1}},
  {{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1}},
  {{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1}},
  {{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1}},
  {{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1}},
  {{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,0,2,-1}},
  {{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1}},
  {{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1}},
  {{0,0,1,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{103,0,0,2,0,0,0,0,0,-1}},
  {{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1}},
  {{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1}},
  {{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1}},
  {{0,0,0,15,0,0,10,0,1,1},{0,0,0,15,0,0,10,0,1,2},{0,0,0,15,0,0,10,0,1,3},{0,0,0,15,0,0,10,0,1,4},{0,0,0,15,0,0,10,0,1,5},{0,0,0,15,0,0,10,0,1,6},{0,0,0,15,0,0,10,0,1,7},{0,0,0,15,0,0,10,0,1,8},{0,0,0,15,0,0,10,0,1,9},{0,0,0,15,0,0,10,0,1,-1},{0,0,0,15,0,0,10,0,1,-1},{0,0,0,15,0,0,10,0,1,-1},{0,0,0,15,0,0,10,0,1,-1},{0,0,0,15,0,0,10,0,1,-1},{0,0,0,15,0,0,10,0,1,-1},{0,0,0,15,0,0,10,0,1,-1}},
  {{0,0,0,15,0,0,10,0,1,-1},{0,0,0,15,0,0,10,0,1,-1},{0,0,0,15,0,0,10,0,1,-1},{0,0,0,15,0,0,10,0,1,-1},{0,0,0,15,0,0,10,0,1,1},{0,0,0,15,0,0,10,0,1,2},{0,0,0,15,0,0,10,0,1,3},{0,0,0,15,0,0,10,0,1,4},{0,0,0,15,0,0,10,0,1,5},{0,0,0,15,0,0,10,0,1,6},{0,0,0,15,0,0,10,0,1,7},{0,0,0,15,0,0,10,0,1,8},{0,0,0,15,0,0,10,0,1,9},{0,0,0,15,0,0,10,0,1,-1},{0,0,0,15,0,0,10,0,1,-1},{0,0,0,15,0,0,10,0,1,-1}},
  {{0,0,0,15,0,0,10,0,1,-1},{0,0,0,15,0,0,10,0,1,-1},{0,0,0,15,0,0,10,0,1,-1},{0,0,0,15,0,0,10,0,1,-1},{0,0,0,15,0,0,10,0,1,-1},{0,0,0,15,0,0,10,0,1,-1},{0,0,0,15,0,0,10,0,1,-1},{0,0,0,15,0,0,10,0,1,-1},{0,0,0,15,0,0,2,0,1,1},{0,0,0,15,0,0,2,0,1,2},{0,0,0,15,0,0,2,0,1,3},{0,0,0,15,0,0,2,0,1,4},{0,0,0,15,0,0,2,0,1,5},{0,0,0,15,0,0,2,0,1,6},{0,0,0,15,0,0,2,0,1,7},{0,0,0,15,0,0,2,0,1,8}},
  {{0,0,0,15,0,0,2,0,1,9},{0,0,0,15,0,0,2,0,1,-1},{0,0,0,15,0,0,2,0,1,-1},{0,0,0,15,0,0,2,0,1,-1},{0,0,0,15,0,0,2,0,1,-1},{0,0,0,15,0,0,2,0,1,-1},{0,0,0,15,0,0,2,0,1,-1},{0,0,0,15,0,0,2,0,1,-1},{0,0,0,15,0,0,2,0,1,-1},{0,0,0,15,0,0,2,0,1,-1},{0,0,0,15,0,0,2,0,1,-1},{0,0,0,15,0,0,2,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1}},
  {{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1}},
  {{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,15,0,0,10,0,1,0},{0,0,0,15,0,0,10,0,1,-1},{0,0,0,15,0,0,10,0,1,-1},{0,0,0,15,0,0,10,0,1,-1},{0,0,0,15,0,0,10,0,1,-1},{0,0,0,15,0,0,10,0,1,-1}},
  {{0,0,0,15,0,0,10,0,1,-1},{0,0,0,15,0,0,10,0,1,-1},{0,0,0,15,0,0,10,0,1,-1},{0,0,0,15,0,0,10,0,1,-1},{0,0,0,15,0,0,10,0,1,-1},{0,0,0,15,0,0,10,0,1,1},{0,0,0,15,0,0,10,0,1,2},{0,0,0,15,0,0,10,0,1,3},{0,0,0,15,0,0,10,0,1,4},{0,0,0,15,0,0,10,0,1,5},{0,0,0,15,0,0,10,0,1,6},{0,0,0,15,0,0,10,0,1,7},{0,0,0,15,0,0,10,0,1,8},{0,0,0,15,0,0,10,0,1,9},{0,0,0,15,0,0,10,0,1,-1},{0,0,0,15,0,0,10,0,2,0}},
  {{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,1,-1}},
  {{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1}},
  {{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1}},
  {{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,1,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1}},
  {{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1}},
  {{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,25,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1}},
  {{0,0,0,26,0,0,10,0,1,-1},{0,0,0,25,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1}},
  {{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1}},
  {{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,1,-1}},
  {{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,25,0,0,10,0,2,-1},{0,0,0,25,0,0,10,0,2,-1},{0,0,0,25,0,0,10,0,2,-1},{0,0,0,25,0,0,10,0,2,-1},{0,0,0,25,0,0,10,0,2,-1},{0,0,1,25,0,0,10,0,2,-1},{0,0,1,25,0,0,10,0,2,-1},{0,0,0,25,0,0,10,0,2,-1}},
  {{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1}},
  {{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,1,14,-1},{0,0,0,26,0,0,10,1,14,-1},{0,0,0,26,0,0,10,1,14,-1},{0,0,0,26,0,0,10,1,40,-1},{0,0,0,26,0,0,10,1,14,-1},{0,0,0,26,0,0,10,1,14,-1}},
  {{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1}},
  {{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1}},
  {{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1}},
  {{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,25,0,0,10,0,1,-1}},
  {{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,14,-1}},
  {{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1}},
  {{0,0,0,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1}},
  {{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1}},
  {{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,14,-1}},
  {{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,14,-1}},
  {{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1}},
  {{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1}},
  {{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,0,26,0,0,10,0,40,-1},{0,0,0,26,0,0,10,0,40,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1}},
  {{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1}},
  {{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1}},
  {{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,23,-1},{0,0,0,26,0,0,10,0,23,-1},{0,0,0,26,0,0,10,0,23,-1},{0,0,0,26,0,0,10,0,23,-1},{0,0,0,26,0,0,10,0,23,-1}},
  {{0,0,0,26,0,0,10,0,23,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,11,-1},{0,0,0,26,0,0,10,0,11,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,1,0,22,0,0,10,1,20,-1},{0,2,0,18,0,0,10,1,8,-1},{0,1,0,22,0,0,10,1,20,-1},{0,2,0,18,0,0,10,1,8,-1},{0,1,0,22,0,0,10,1,20,-1},{0,2,0,18,0,0,10,1,8,-1},{0,1,0,22,0,0,10,1,20,-1},{0,2,0,18,0,0,10,1,8,-1}},
  {{0,1,0,22,0,0,10,1,20,-1},{0,2,0,18,0,0,10,1,8,-1},{0,1,0,22,0,0,10,1,20,-1},{0,2,0,18,0,0,10,1,8,-1},{0,1,0,22,0,0,10,1,20,-1},{0,2,0,18,0,0,10,1,8,-1},{0,0,0,15,0,0,10,0,1,1},{0,0,0,15,0,0,10,0,1,2},{0,0,0,15,0,0,10,0,1,3},{0,0,0,15,0,0,10,0,1,4},{0,0,0,15,0,0,10,0,1,5},{0,0,0,15,0,0,10,0,1,6},{0,0,0,15,0,0,10,0,1,7},{0,0,0,15,0,0,10,0,1,8},{0,0,0,15,0,0,10,0,1,9},{0,0,0,15,0,0,10,0,1,-1}},
  {{0,0,0,15,0,0,10,0,1,1},{0,0,0,15,0,0,10,0,1,2},{0,0,0,15,0,0,10,0,1,3},{0,0,0,15,0,0,10,0,1,4},{0,0,0,15,0,0,10,0,1,5},{0,0,0,15,0,0,10,0,1,6},{0,0,0,15,0,0,10,0,1,7},{0,0,0,15,0,0,10,0,1,8},{0,0,0,15,0,0,10,0,1,9},{0,0,0,15,0,0,10,0,1,-1},{0,0,0,15,0,0,10,0,1,1},{0,0,0,15,0,0,10,0,1,2},{0,0,0,15,0,0,10,0,1,3},{0,0,0,15,0,0,10,0,1,4},{0,0,0,15,0,0,10,0,1,5},{0,0,0,15,0,0,10,0,1,6}},
  {{0,0,0,15,0,0,10,0,1,7},{0,0,0,15,0,0,10,0,1,8},{0,0,0,15,0,0,10,0,1,9},{0,0,0,15,0,0,10,0,1,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,1,26,0,0,10,1,2,-1},{0,0,1,26,0,0,10,1,2,-1},{0,0,1,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1}},
  {{0,0,1,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,1,26,0,0,10,1,2,-1}},
  {{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,1,0,22,0,0,10,1,20,-1},{0,2,0,18,0,0,10,1,8,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1}},
  {{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,1,0,22,0,0,10,1,20,-1},{0,2,0,18,0,0,10,1,8,-1},{0,1,0,22,0,0,10,1,20,-1},{0,2,0,18,0,0,10,1,8,-1},{0,1,0,22,0,0,10,1,20,-1},{0,2,0,18,0,0,10,1,8,-1},{0,1,0,22,0,0,10,1,20,-1},{0,2,0,18,0,0,10,1,8,-1},{0,1,0,22,0,0,10,1,20,-1},{0,2,0,18,0,0,10,1,8,-1}},
  {{46,0,0,26,0,0,0,1,2,-1},{46,0,0,26,0,0,0,1,2,-1},{46,0,0,26,0,0,0,1,2,-1},{46,0,0,26,0,0,0,1,2,-1},{46,0,0,26,0,0,0,1,2,-1},{46,0,0,26,0,0,0,1,2,-1},{46,0,0,26,0,0,0,1,2,-1},{46,0,0,26,0,0,0,1,2,-1},{46,0,0,26,0,0,0,1,2,-1},{46,0,0,26,0,0,0,1,2,-1},{46,0,0,26,0,0,0,1,2,-1},{46,0,0,26,0,0,0,1,2,-1},{46,0,0,26,0,0,0,1,2,-1},{46,0,0,26,0,0,0,1,2,-1},{46,0,0,26,0,0,0,1,2,-1},{46,0,0,26,0,0,0,1,2,-1}},
  {{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,1,0,22,0,0,10,1,20,-1},{0,2,0,18,0,0,10,1,8,-1},{0,1,0,22,0,0,10,1,20,-1},{0,2,0,18,0,0,10,1,8,-1},{0,1,0,22,0,0,10,1,20,-1},{0,2,0,18,0,0,10,1,8,-1},{0,1,0,22,0,0,10,1,20,-1},{0,2,0,18,0,0,10,1,8,-1},{0,1,0,22,0,0,10,1,20,-1},{0,2,0,18,0,0,10,1,8,-1},{0,1,0,22,0,0,10,1,20,-1},{0,2,0,18,0,0,10,1,8,-1},{0,1,0,22,0,0,10,1,20,-1}},
  {{0,2,0,18,0,0,10,1,8,-1},{0,1,0,22,0,0,10,1,20,-1},{0,2,0,18,0,0,10,1,8,-1},{0,1,0,22,0,0,10,1,20,-1},{0,2,0,18,0,0,10,1,8,-1},{0,1,0,22,0,0,10,1,20,-1},{0,2,0,18,0,0,10,1,8,-1},{0,1,0,22,0,0,10,1,20,-1},{0,2,0,18,0,0,10,1,8,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1}},
  {{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,1,0,22,0,0,10,1,20,-1},{0,2,0,18,0,0,10,1,8,-1},{0,1,0,22,0,0,10,1,20,-1},{0,2,0,18,0,0,10,1,8,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1}},
  {{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,1,0,22,0,0,10,1,20,-1},{0,2,0,18,0,0,10,1,8,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1}},
  {{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1}},
  {{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1}},
  {{0,0,1,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,0,1,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1}},
  {{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1}},
  {{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1}},
  {{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1}},
  {{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{103,0,0,2,0,0,0,0,0,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1}},
  {{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1}},
  {{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1}},
  {{56,0,0,9,0,0,0,1,2,-1},{56,0,0,9,0,0,0,1,2,-1},{56,0,0,9,0,0,0,1,2,-1},{56,0,0,9,0,0,0,1,2,-1},{56,0,0,9,0,0,0,1,2,-1},{56,0,0,9,0,0,0,1,2,-1},{56,0,0,9,0,0,0,1,2,-1},{56,0,0,9,0,0,0,1,2,-1},{56,0,0,9,0,0,0,1,2,-1},{56,0,0,9,0,0,0,1,2,-1},{56,0,0,9,0,0,0,1,2,-1},{56,0,0,9,0,0,0,1,2,-1},{56,0,0,9,0,0,0,1,2,-1},{56,0,0,9,0,0,0,1,2,-1},{56,0,0,9,0,0,0,1,2,-1},{56,0,0,9,0,0,0,1,2,-1}},
  {{56,0,0,9,0,0,0,1,2,-1},{56,0,0,9,0,0,0,1,2,-1},{56,0,0,9,0,0,0,1,2,-1},{56,0,0,9,0,0,0,1,2,-1},{56,0,0,9,0,0,0,1,2,-1},{56,0,0,9,0,0,0,1,2,-1},{56,0,0,9,0,0,0,1,2,-1},{56,0,0,9,0,0,0,1,2,-1},{56,0,0,9,0,0,0,1,2,-1},{56,0,0,9,0,0,0,1,2,-1},{56,0,0,9,0,0,0,1,2,-1},{56,0,0,9,0,0,0,1,2,-1},{56,0,0,9,0,0,0,1,2,-1},{56,0,0,9,0,0,0,1,2,-1},{56,0,0,9,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{56,0,0,5,0,0,0,1,2,-1},{56,0,0,5,0,0,0,1,2,-1},{56,0,0,5,0,0,0,1,2,-1},{56,0,0,5,0,0,0,1,2,-1},{56,0,0,5,0,0,0,1,2,-1},{56,0,0,5,0,0,0,1,2,-1},{56,0,0,5,0,0,0,1,2,-1},{56,0,0,5,0,0,0,1,2,-1},{56,0,0,5,0,0,0,1,2,-1},{56,0,0,5,0,0,0,1,2,-1},{56,0,0,5,0,0,0,1,2,-1},{56,0,0,5,0,0,0,1,2,-1},{56,0,0,5,0,0,0,1,2,-1},{56,0,0,5,0,0,0,1,2,-1},{56,0,0,5,0,0,0,1,2,-1},{56,0,0,5,0,0,0,1,2,-1}},
  {{56,0,0,5,0,0,0,1,2,-1},{56,0,0,5,0,0,0,1,2,-1},{56,0,0,5,0,0,0,1,2,-1},{56,0,0,5,0,0,0,1,2,-1},{56,0,0,5,0,0,0,1,2,-1},{56,0,0,5,0,0,0,1,2,-1},{56,0,0,5,0,0,0,1,2,-1},{56,0,0,5,0,0,0,1,2,-1},{56,0,0,5,0,0,0,1,2,-1},{56,0,0,5,0,0,0,1,2,-1},{56,0,0,5,0,0,0,1,2,-1},{56,0,0,5,0,0,0,1,2,-1},{56,0,0,5,0,0,0,1,2,-1},{56,0,0,5,0,0,0,1,2,-1},{56,0,0,5,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1}},
  {{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1}},
  {{7,0,0,9,0,0,0,1,2,-1},{7,0,0,5,0,0,0,1,2,-1},{7,0,0,9,0,0,0,1,2,-1},{7,0,0,5,0,0,0,1,2,-1},{7,0,0,9,0,0,0,1,2,-1},{7,0,0,5,0,0,0,1,2,-1},{7,0,0,9,0,0,0,1,2,-1},{7,0,0,5,0,0,0,1,2,-1},{7,0,0,9,0,0,0,1,2,-1},{7,0,0,5,0,0,0,1,2,-1},{7,0,0,9,0,0,0,1,2,-1},{7,0,0,5,0,0,0,1,2,-1},{7,0,0,9,0,0,0,1,2,-1},{7,0,0,5,0,0,0,1,2,-1},{7,0,0,9,0,0,0,1,2,-1},{7,0,0,5,0,0,0,1,2,-1}},
  {{7,0,0,9,0,0,0,1,2,-1},{7,0,0,5,0,0,0,1,2,-1},{7,0,0,9,0,0,0,1,2,-1},{7,0,0,5,0,0,0,1,2,-1},{7,0,0,5,0,0,0,1,2,-1},{7,0,0,26,0,0,10,1,2,-1},{7,0,0,26,0,0,10,1,2,-1},{7,0,0,26,0,0,10,1,2,-1},{7,0,0,26,0,0,10,1,2,-1},{7,0,0,26,0,0,10,1,2,-1},{7,0,0,26,0,0,10,1,2,-1},{7,0,0,9,0,0,0,1,2,-1},{7,0,0,5,0,0,0,1,2,-1},{7,0,0,9,0,0,0,1,2,-1},{7,0,0,5,0,0,0,1,2,-1},{7,0,0,12,0,0,17,1,9,-1}},
  {{7,0,0,12,0,0,17,1,9,-1},{7,0,0,12,0,0,17,1,9,-1},{7,0,0,9,0,0,0,1,2,-1},{7,0,0,5,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{7,0,0,21,0,0,10,1,11,-1},{7,0,0,21,0,0,10,1,4,-1},{7,0,0,21,0,0,10,1,4,-1},{7,0,0,21,0,0,10,1,4,-1},{7,0,0,15,0,0,10,1,2,-1},{7,0,0,21,0,0,10,1,11,-1},{7,0,0,21,0,0,10,1,4,-1}},
  {{12,0,0,5,0,0,0,1,2,-1},{12,0,0,5,0,0,0,1,2,-1},{12,0,0,5,0,0,0,1,2,-1},{12,0,0,5,0,0,0,1,2,-1},{12,0,0,5,0,0,0,1,2,-1},{12,0,0,5,0,0,0,1,2,-1},{12,0,0,5,0,0,0,1,2,-1},{12,0,0,5,0,0,0,1,2,-1},{12,0,0,5,0,0,0,1,2,-1},{12,0,0,5,0,0,0,1,2,-1},{12,0,0,5,0,0,0,1,2,-1},{12,0,0,5,0,0,0,1,2,-1},{12,0,0,5,0,0,0,1,2,-1},{12,0,0,5,0,0,0,1,2,-1},{12,0,0,5,0,0,0,1,2,-1},{12,0,0,5,0,0,0,1,2,-1}},
  {{12,0,0,5,0,0,0,1,2,-1},{12,0,0,5,0,0,0,1,2,-1},{12,0,0,5,0,0,0,1,2,-1},{12,0,0,5,0,0,0,1,2,-1},{12,0,0,5,0,0,0,1,2,-1},{12,0,0,5,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{12,0,0,5,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{12,0,0,5,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{60,0,0,7,2,0,0,1,2,-1},{60,0,0,7,2,0,0,1,2,-1},{60,0,0,7,2,0,0,1,2,-1},{60,0,0,7,2,0,0,1,2,-1},{60,0,0,7,2,0,0,1,2,-1},{60,0,0,7,2,0,0,1,2,-1},{60,0,0,7,2,0,0,1,2,-1},{60,0,0,7,2,0,0,1,2,-1},{60,0,0,7,2,0,0,1,2,-1},{60,0,0,7,2,0,0,1,2,-1},{60,0,0,7,2,0,0,1,2,-1},{60,0,0,7,2,0,0,1,2,-1},{60,0,0,7,2,0,0,1,2,-1},{60,0,0,7,2,0,0,1,2,-1},{60,0,0,7,2,0,0,1,2,-1},{60,0,0,7,2,0,0,1,2,-1}},
  {{60,0,0,7,2,0,0,1,2,-1},{60,0,0,7,2,0,0,1,2,-1},{60,0,0,7,2,0,0,1,2,-1},{60,0,0,7,2,0,0,1,2,-1},{60,0,0,7,2,0,0,1,2,-1},{60,0,0,7,2,0,0,1,2,-1},{60,0,0,7,2,0,0,1,2,-1},{60,0,0,7,2,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{60,0,0,6,0,0,0,1,2,-1}},
  {{60,0,0,21,0,0,0,1,4,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{60,0,0,12,2,0,17,1,9,-1}},
  {{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{8,0,0,12,0,0,17,1,9,-1},{8,0,0,12,0,0,17,1,9,-1},{8,0,0,12,0,0,17,1,9,-1},{8,0,0,12,0,0,17,1,9,-1},{8,0,0,12,0,0,17,1,9,-1},{8,0,0,12,0,0,17,1,9,-1},{8,0,0,12,0,0,17,1,9,-1},{8,0,0,12,0,0,17,1,9,-1},{8,0,0,12,0,0,17,1,9,-1},{8,0,0,12,0,0,17,1,9,-1},{8,0,0,12,0,0,17,1,9,-1},{8,0,0,12,0,0,17,1,9,-1},{8,0,0,12,0,0,17,1,9,-1},{8,0,0,12,0,0,17,1,9,-1},{8,0,0,12,0,0,17,1,9,-1},{8,0,0,12,0,0,17,1,9,-1}},
  {{0,0,0,21,0,0,10,1,23,-1},{0,0,0,21,0,0,10,1,23,-1},{0,0,0,20,0,0,10,1,23,-1},{0,0,0,19,0,0,10,1,23,-1},{0,0,0,20,0,0,10,1,23,-1},{0,0,0,19,0,0,10,1,23,-1},{0,0,0,21,0,0,10,1,23,-1},{0,0,0,21,0,0,10,1,23,-1},{0,0,0,21,0,0,10,1,23,-1},{0,0,0,20,0,0,10,1,23,-1},{0,0,0,19,0,0,10,1,23,-1},{0,0,0,21,0,0,10,1,23,-1},{0,0,0,20,0,0,10,1,23,-1},{0,0,0,19,0,0,10,1,23,-1},{0,0,0,21,0,0,10,1,4,-1},{0,0,0,21,0,0,10,1,4,-1}},
  {{0,0,0,21,0,0,10,1,4,-1},{0,0,0,21,0,0,10,1,4,-1},{0,0,0,21,0,0,10,1,4,-1},{0,0,0,21,0,0,10,1,4,-1},{0,0,0,21,0,0,10,1,4,-1},{0,0,0,21,0,0,10,1,4,-1},{0,0,0,21,0,0,10,1,2,-1},{0,0,0,17,0,0,10,1,4,-1},{0,0,0,21,0,0,10,1,20,-1},{0,0,0,21,0,0,10,1,4,-1},{0,0,0,17,0,0,10,1,2,-1},{0,0,0,21,0,0,10,1,2,-1},{0,0,0,20,0,0,10,1,23,-1},{0,0,0,19,0,0,10,1,23,-1},{0,0,0,21,0,0,10,1,2,-1},{0,0,0,21,0,0,10,1,2,-1}},
  {{0,0,0,20,0,0,10,1,23,-1},{0,0,0,19,0,0,10,1,23,-1},{0,1,0,22,0,0,10,1,20,-1},{0,2,0,18,0,0,10,1,8,-1},{0,1,0,22,0,0,10,1,20,-1},{0,2,0,18,0,0,10,1,8,-1},{0,1,0,22,0,0,10,1,20,-1},{0,2,0,18,0,0,10,1,8,-1},{0,1,0,22,0,0,10,1,20,-1},{0,2,0,18,0,0,10,1,8,-1},{0,0,0,21,0,0,10,1,4,-1},{0,0,0,21,0,0,10,1,4,-1},{0,0,0,21,0,0,10,1,4,-1},{0,0,0,21,0,0,10,1,4,-1},{0,0,0,21,0,0,10,1,11,-1},{0,0,0,6,0,0,10,1,2,-1}},
  {{0,0,0,21,0,0,10,1,4,-1},{0,0,0,21,0,0,10,1,4,-1},{0,0,0,21,0,0,10,1,2,-1},{0,0,0,21,0,0,10,1,4,-1},{0,0,0,21,0,0,10,1,4,-1},{0,0,0,21,0,0,10,1,2,-1},{0,0,0,21,0,0,10,1,2,-1},{0,0,0,21,0,0,10,1,2,-1},{0,0,0,21,0,0,10,1,2,-1},{0,0,0,21,0,0,10,1,2,-1},{0,0,0,17,0,0,10,1,3,-1},{0,0,0,17,0,0,10,1,3,-1},{0,0,0,21,0,0,10,1,4,-1},{0,0,0,21,0,0,10,1,4,-1},{0,0,0,21,0,0,10,1,4,-1},{0,0,0,21,0,0,10,1,2,-1}},
  {{0,0,0,17,0,0,10,1,4,-1},{0,0,0,21,0,0,10,1,4,-1},{0,0,0,22,0,0,10,1,20,-1},{0,0,0,21,0,0,10,1,4,-1},{0,0,0,21,0,0,10,1,4,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{17,0,1,26,0,0,10,0,14,-1},{17,0,1,26,0,0,10,0,14,-1},{17,0,1,26,0,0,10,0,14,-1},{17,0,1,26,0,0,10,0,14,-1},{17,0,1,26,0,0,10,0,14,-1},{17,0,1,26,0,0,10,0,14,-1},{17,0,1,26,0,0,10,0,14,-1},{17,0,1,26,0,0,10,0,14,-1},{17,0,1,26,0,0,10,0,14,-1},{17,0,1,26,0,0,10,0,14,-1},{17,0,1,26,0,0,10,0,14,-1},{17,0,1,26,0,0,10,0,14,-1},{17,0,1,26,0,0,10,0,14,-1},{17,0,1,26,0,0,10,0,14,-1},{17,0,1,26,0,0,10,0,14,-1},{17,0,1,26,0,0,10,0,14,-1}},
  {{17,0,1,26,0,0,10,0,14,-1},{17,0,1,26,0,0,10,0,14,-1},{17,0,1,26,0,0,10,0,14,-1},{17,0,1,26,0,0,10,0,14,-1},{17,0,1,26,0,0,10,0,14,-1},{17,0,1,26,0,0,10,0,14,-1},{17,0,1,26,0,0,10,0,14,-1},{17,0,1,26,0,0,10,0,14,-1},{17,0,1,26,0,0,10,0,14,-1},{17,0,1,26,0,0,10,0,14,-1},{103,0,0,2,0,0,0,0,0,-1},{17,0,1,26,0,0,10,0,14,-1},{17,0,1,26,0,0,10,0,14,-1},{17,0,1,26,0,0,10,0,14,-1},{17,0,1,26,0,0,10,0,14,-1},{17,0,1,26,0,0,10,0,14,-1}},
  {{17,0,1,26,0,0,10,0,14,-1},{17,0,1,26,0,0,10,0,14,-1},{17,0,1,26,0,0,10,0,14,-1},{17,0,1,26,0,0,10,0,14,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1}},
  {{17,0,1,26,0,0,10,0,14,-1},{17,0,1,26,0,0,10,0,14,-1},{17,0,1,26,0,0,10,0,14,-1},{17,0,1,26,0,0,10,0,14,-1},{17,0,1,26,0,0,10,0,14,-1},{17,0,1,26,0,0,10,0,14,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1}},
  {{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1}},
  {{0,0,1,29,0,0,9,0,4,-1},{0,0,1,21,0,0,10,2,8,-1},{0,0,1,21,0,0,10,2,8,-1},{0,0,1,21,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{17,0,1,6,1,0,0,0,18,-1},{0,0,1,7,1,0,0,0,14,-1},{17,0,1,14,1,0,0,0,14,-1},{0,1,1,22,0,0,10,3,20,-1},{0,2,1,18,0,0,10,3,8,-1},{0,1,1,22,0,0,10,3,20,-1},{0,2,1,18,0,0,10,3,8,-1},{0,1,1,22,0,0,10,3,20,-1},{0,2,1,18,0,0,10,3,8,-1},{0,1,1,22,0,0,10,3,20,-1},{0,2,1,18,0,0,10,3,8,-1}},
  {{0,1,1,22,0,0,10,3,20,-1},{0,2,1,18,0,0,10,3,8,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,1,1,22,0,0,10,3,20,-1},{0,2,1,18,0,0,10,3,8,-1},{0,1,1,22,0,0,10,3,20,-1},{0,2,1,18,0,0,10,3,8,-1},{0,1,1,22,0,0,10,3,20,-1},{0,2,1,18,0,0,10,3,8,-1},{0,1,1,22,0,0,10,3,20,-1},{0,2,1,18,0,0,10,3,8,-1},{0,0,1,17,0,0,10,3,18,-1},{0,0,1,22,0,0,10,3,20,-1},{0,0,1,18,0,0,10,3,8,-1},{0,0,1,18,0,0,10,3,8,-1}},
  {{0,0,1,26,0,0,10,0,14,-1},{17,0,1,14,0,0,0,0,14,-1},{17,0,1,14,0,0,0,0,14,-1},{17,0,1,14,0,0,0,0,14,-1},{17,0,1,14,0,0,0,0,14,-1},{17,0,1,14,0,0,0,0,14,-1},{17,0,1,14,0,0,0,0,14,-1},{17,0,1,14,0,0,0,0,14,-1},{17,0,1,14,0,0,0,0,14,-1},{17,0,1,14,0,0,0,0,14,-1},{1,0,1,12,0,0,17,0,9,-1},{1,0,1,12,0,0,17,0,9,-1},{1,0,1,12,0,0,17,0,9,-1},{1,0,1,12,0,0,17,0,9,-1},{18,0,1,10,0,0,0,0,9,-1},{18,0,1,10,0,0,0,0,9,-1}},
  {{0,0,1,17,0,0,10,3,14,-1},{0,0,1,6,0,0,0,0,14,-1},{0,0,1,6,0,0,0,0,14,-1},{0,0,1,6,0,0,0,0,14,-1},{0,0,1,6,0,0,0,0,14,-1},{0,0,1,6,0,0,0,0,9,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{17,0,1,14,0,0,0,0,14,-1},{17,0,1,14,0,0,0,0,14,-1},{17,0,1,14,0,0,0,0,14,-1},{17,0,1,6,0,0,0,0,18,-1},{0,0,1,7,0,0,0,0,18,-1},{0,0,1,21,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1}},
  {{103,0,0,2,0,0,0,0,0,-1},{20,0,1,7,1,0,0,2,37,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,2,37,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,2,37,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,2,37,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,2,37,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1}},
  {{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1}},
  {{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,2,37,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1}},
  {{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,2,37,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,2,37,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,2,37,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,2,37,-1},{20,0,1,7,1,0,0,0,14,-1}},
  {{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,0,14,-1},{20,0,1,7,1,0,0,2,37,-1},{20,0,1,7,1,0,0,2,37,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{1,0,1,12,1,0,17,0,9,-1},{1,0,1,12,1,0,17,0,9,-1},{0,0,1,24,0,0,10,2,18,-1},{0,0,1,24,0,0,10,2,18,-1},{20,0,1,6,1,0,0,0,18,-1},{20,0,1,6,1,0,0,0,18,-1},{20,0,1,7,0,0,0,0,14,-1}},
  {{0,0,1,17,1,0,10,3,18,-1},{22,0,1,7,1,0,0,2,37,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,2,37,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,2,37,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,2,37,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,2,37,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1}},
  {{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1}},
  {{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,2,37,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1}},
  {{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,2,37,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,2,37,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,2,37,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,2,37,-1},{22,0,1,7,1,0,0,0,14,-1}},
  {{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,2,37,-1},{22,0,1,7,1,0,0,2,37,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{22,0,1,7,1,0,0,0,14,-1},{0,0,1,21,1,0,10,0,18,-1},{0,0,1,6,1,0,0,3,37,-1},{22,0,1,6,1,0,0,0,18,-1},{22,0,1,6,1,0,0,0,18,-1},{22,0,1,7,0,0,0,0,14,-1}},
  {{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1}},
  {{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1}},
  {{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,2,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1}},
  {{103,0,0,2,0,0,0,0,0,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1}},
  {{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1}},
  {{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,1,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1}},
  {{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{18,0,1,7,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,0,-1}},
  {{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,15,0,0,0,0,14,-1},{0,0,1,15,0,0,0,0,14,-1},{0,0,1,15,0,0,0,0,14,-1},{0,0,1,15,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1}},
  {{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{5,0,1,7,1,0,0,0,14,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1}},
  {{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1}},
  {{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1}},
  {{22,0,1,7,0,0,0,2,37,-1},{22,0,1,7,0,0,0,2,37,-1},{22,0,1,7,0,0,0,2,37,-1},{22,0,1,7,0,0,0,2,37,-1},{22,0,1,7,0,0,0,2,37,-1},{22,0,1,7,0,0,0,2,37,-1},{22,0,1,7,0,0,0,2,37,-1},{22,0,1,7,0,0,0,2,37,-1},{22,0,1,7,0,0,0,2,37,-1},{22,0,1,7,0,0,0,2,37,-1},{22,0,1,7,0,0,0,2,37,-1},{22,0,1,7,0,0,0,2,37,-1},{22,0,1,7,0,0,0,2,37,-1},{22,0,1,7,0,0,0,2,37,-1},{22,0,1,7,0,0,0,2,37,-1},{22,0,1,7,0,0,0,2,37,-1}},
  {{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,0,0,14,-1}},
  {{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,10,0,14,-1},{18,0,1,26,0,0,10,0,14,-1},{103,0,0,2,0,0,0,0,0,-1}},
  {{0,0,1,15,0,0,0,0,14,-1},{0,0,1,15,0,0,0,0,14,-1},{0,0,1,15,0,0,0,0,14,-1},{0,0,1,15,0,0,0,0,14,-1},{0,0,1,15,0,0,0,0,14,-1},{0,0,1,15,0,0,0,0,14,-1},{0,0,1,15,0,0,0,0,14,-1},{0,0,1,15,0,0,0,0,14,-1},{0,0,1,15,0,0,0,0,14,-1},{0,0,1,15,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1}},
  {{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1}},
  {{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,0,15,0,0,0,0,1,-1},{0,0,0,15,0,0,0,0,1,-1},{0,0,0,15,0,0,0,0,1,-1},{0,0,0,15,0,0,0,0,1,-1},{0,0,0,15,0,0,0,0,1,-1},{0,0,0,15,0,0,0,0,1,-1},{0,0,0,15,0,0,0,0,1,-1},{0,0,0,15,0,0,0,0,1,-1}},
  {{0,0,1,26,0,0,10,0,14,-1},{0,0,1,15,0,0,10,0,14,-1},{0,0,1,15,0,0,10,0,14,-1},{0,0,1,15,0,0,10,0,14,-1},{0,0,1,15,0,0,10,0,14,-1},{0,0,1,15,0,0,10,0,14,-1},{0,0,1,15,0,0,10,0,14,-1},{0,0,1,15,0,0,10,0,14,-1},{0,0,1,15,0,0,10,0,14,-1},{0,0,1,15,0,0,10,0,14,-1},{0,0,1,15,0,0,10,0,14,-1},{0,0,1,15,0,0,10,0,14,-1},{0,0,1,15,0,0,10,0,14,-1},{0,0,1,15,0,0,10,0,14,-1},{0,0,1,15,0,0,10,0,14,-1},{0,0,1,15,0,0,10,0,14,-1}},
  {{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,0,0,14,-1},{18,0,1,26,0,0,10,0,14,-1},{18,0,1,26,0,0,10,0,14,-1},{18,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,0,0,14,-1}},
  {{0,0,1,26,0,0,0,0,14,-1},{0,0,1,15,0,0,10,0,14,-1},{0,0,1,15,0,0,10,0,14,-1},{0,0,1,15,0,0,10,0,14,-1},{0,0,1,15,0,0,10,0,14,-1},{0,0,1,15,0,0,10,0,14,-1},{0,0,1,15,0,0,10,0,14,-1},{0,0,1,15,0,0,10,0,14,-1},{0,0,1,15,0,0,10,0,14,-1},{0,0,1,15,0,0,10,0,14,-1},{0,0,1,15,0,0,10,0,14,-1},{0,0,1,15,0,0,10,0,14,-1},{0,0,1,15,0,0,10,0,14,-1},{0,0,1,15,0,0,10,0,14,-1},{0,0,1,15,0,0,10,0,14,-1},{0,0,1,15,0,0,10,0,14,-1}},
  {{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1}},
  {{22,0,1,26,0,0,0,0,14,-1},{22,0,1,26,0,0,0,0,14,-1},{22,0,1,26,0,0,0,0,14,-1},{22,0,1,26,0,0,0,0,14,-1},{22,0,1,26,0,0,0,0,14,-1},{22,0,1,26,0,0,0,0,14,-1},{22,0,1,26,0,0,0,0,14,-1},{22,0,1,26,0,0,0,0,14,-1},{22,0,1,26,0,0,0,0,14,-1},{22,0,1,26,0,0,0,0,14,-1},{22,0,1,26,0,0,0,0,14,-1},{22,0,1,26,0,0,0,0,14,-1},{22,0,1,26,0,0,0,0,14,-1},{22,0,1,26,0,0,0,0,14,-1},{22,0,1,26,0,0,0,0,14,-1},{22,0,1,26,0,0,0,0,14,-1}},
  {{22,0,1,26,0,0,0,0,14,-1},{22,0,1,26,0,0,0,0,14,-1},{22,0,1,26,0,0,0,0,14,-1},{22,0,1,26,0,0,0,0,14,-1},{22,0,1,26,0,0,0,0,14,-1},{22,0,1,26,0,0,0,0,14,-1},{22,0,1,26,0,0,0,0,14,-1},{22,0,1,26,0,0,0,0,14,-1},{22,0,1,26,0,0,0,0,14,-1},{22,0,1,26,0,0,0,0,14,-1},{22,0,1,26,0,0,0,0,14,-1},{22,0,1,26,0,0,0,0,14,-1},{22,0,1,26,0,0,0,0,14,-1},{22,0,1,26,0,0,0,0,14,-1},{22,0,1,26,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,0,-1}},
  {{22,0,1,26,0,0,0,2,14,-1},{22,0,1,26,0,0,0,2,14,-1},{22,0,1,26,0,0,0,2,14,-1},{22,0,1,26,0,0,0,2,14,-1},{22,0,1,26,0,0,0,2,14,-1},{22,0,1,26,0,0,0,2,14,-1},{22,0,1,26,0,0,0,2,14,-1},{22,0,1,26,0,0,0,2,14,-1},{22,0,1,26,0,0,0,2,14,-1},{22,0,1,26,0,0,0,2,14,-1},{22,0,1,26,0,0,0,2,14,-1},{22,0,1,26,0,0,0,2,14,-1},{22,0,1,26,0,0,0,2,14,-1},{22,0,1,26,0,0,0,2,14,-1},{22,0,1,26,0,0,0,2,14,-1},{22,0,1,26,0,0,0,2,14,-1}},
  {{22,0,1,26,0,0,0,2,14,-1},{22,0,1,26,0,0,0,2,14,-1},{22,0,1,26,0,0,0,2,14,-1},{22,0,1,26,0,0,0,2,14,-1},{22,0,1,26,0,0,0,2,14,-1},{22,0,1,26,0,0,0,2,14,-1},{22,0,1,26,0,0,0,2,14,-1},{22,0,1,26,0,0,0,2,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1}},
  {{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,0,2,14,-1},{0,0,1,26,0,0,0,2,14,-1},{0,0,1,26,0,0,0,2,14,-1},{0,0,1,26,0,0,0,2,14,-1},{0,0,1,26,0,0,0,2,14,-1}},
  {{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1}},
  {{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,10,0,14,-1}},
  {{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1}},
  {{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1}},
  {{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1}},
  {{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1}},
  {{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1},{41,0,1,6,2,0,0,0,18,-1},{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1}},
  {{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1},{41,0,1,7,2,0,0,0,14,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1}},
  {{41,0,1,26,0,0,10,0,14,-1},{41,0,1,26,0,0,10,0,14,-1},{41,0,1,26,0,0,10,0,14,-1},{41,0,1,26,0,0,10,0,14,-1},{41,0,1,26,0,0,10,0,14,-1},{41,0,1,26,0,0,10,0,14,-1},{41,0,1,26,0,0,10,0,14,-1},{41,0,1,26,0,0,10,0,14,-1},{41,0,1,26,0,0,10,0,14,-1},{41,0,1,26,0,0,10,0,14,-1},{41,0,1,26,0,0,10,0,14,-1},{41,0,1,26,0,0,10,0,14,-1},{41,0,1,26,0,0,10,0,14,-1},{41,0,1,26,0,0,10,0,14,-1},{41,0,1,26,0,0,10,0,14,-1},{41,0,1,26,0,0,10,0,14,-1}},
  {{41,0,1,26,0,0,10,0,14,-1},{41,0,1,26,0,0,10,0,14,-1},{41,0,1,26,0,0,10,0,14,-1},{41,0,1,26,0,0,10,0,14,-1},{41,0,1,26,0,0,10,0,14,-1},{41,0,1,26,0,0,10,0,14,-1},{41,0,1,26,0,0,10,0,14,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1}},
  {{131,0,0,7,0,0,0,1,2,-1},{131,0,0,7,0,0,0,1,2,-1},{131,0,0,7,0,0,0,1,2,-1},{131,0,0,7,0,0,0,1,2,-1},{131,0,0,7,0,0,0,1,2,-1},{131,0,0,7,0,0,0,1,2,-1},{131,0,0,7,0,0,0,1,2,-1},{131,0,0,7,0,0,0,1,2,-1},{131,0,0,7,0,0,0,1,2,-1},{131,0,0,7,0,0,0,1,2,-1},{131,0,0,7,0,0,0,1,2,-1},{131,0,0,7,0,0,0,1,2,-1},{131,0,0,7,0,0,0,1,2,-1},{131,0,0,7,0,0,0,1,2,-1},{131,0,0,7,0,0,0,1,2,-1},{131,0,0,7,0,0,0,1,2,-1}},
  {{131,0,0,7,0,0,0,1,2,-1},{131,0,0,7,0,0,0,1,2,-1},{131,0,0,7,0,0,0,1,2,-1},{131,0,0,7,0,0,0,1,2,-1},{131,0,0,7,0,0,0,1,2,-1},{131,0,0,7,0,0,0,1,2,-1},{131,0,0,7,0,0,0,1,2,-1},{131,0,0,7,0,0,0,1,2,-1},{131,0,0,6,0,0,0,1,2,-1},{131,0,0,6,0,0,0,1,2,-1},{131,0,0,6,0,0,0,1,2,-1},{131,0,0,6,0,0,0,1,2,-1},{131,0,0,6,0,0,0,1,2,-1},{131,0,0,6,0,0,0,1,2,-1},{131,0,0,21,0,0,0,1,4,-1},{131,0,0,21,0,0,0,1,4,-1}},
  {{99,0,0,7,0,0,0,1,2,-1},{99,0,0,7,0,0,0,1,2,-1},{99,0,0,7,0,0,0,1,2,-1},{99,0,0,7,0,0,0,1,2,-1},{99,0,0,7,0,0,0,1,2,-1},{99,0,0,7,0,0,0,1,2,-1},{99,0,0,7,0,0,0,1,2,-1},{99,0,0,7,0,0,0,1,2,-1},{99,0,0,7,0,0,0,1,2,-1},{99,0,0,7,0,0,0,1,2,-1},{99,0,0,7,0,0,0,1,2,-1},{99,0,0,7,0,0,0,1,2,-1},{99,0,0,7,0,0,0,1,2,-1},{99,0,0,7,0,0,0,1,2,-1},{99,0,0,7,0,0,0,1,2,-1},{99,0,0,7,0,0,0,1,2,-1}},
  {{99,0,0,7,0,0,0,1,2,-1},{99,0,0,7,0,0,0,1,2,-1},{99,0,0,7,0,0,0,1,2,-1},{99,0,0,7,0,0,0,1,2,-1},{99,0,0,7,0,0,0,1,2,-1},{99,0,0,7,0,0,0,1,2,-1},{99,0,0,7,0,0,0,1,2,-1},{99,0,0,7,0,0,0,1,2,-1},{99,0,0,7,0,0,0,1,2,-1},{99,0,0,7,0,0,0,1,2,-1},{99,0,0,7,0,0,0,1,2,-1},{99,0,0,7,0,0,0,1,2,-1},{99,0,0,6,0,0,0,1,2,-1},{99,0,0,21,0,0,10,1,4,-1},{99,0,0,21,0,0,10,1,11,-1},{99,0,0,21,0,0,10,1,4,-1}},
  {{99,0,0,13,0,0,0,1,19,0},{99,0,0,13,0,0,0,1,19,1},{99,0,0,13,0,0,0,1,19,2},{99,0,0,13,0,0,0,1,19,3},{99,0,0,13,0,0,0,1,19,4},{99,0,0,13,0,0,0,1,19,5},{99,0,0,13,0,0,0,1,19,6},{99,0,0,13,0,0,0,1,19,7},{99,0,0,13,0,0,0,1,19,8},{99,0,0,13,0,0,0,1,19,9},{99,0,0,7,0,0,0,1,2,-1},{99,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{8,0,0,9,1,0,0,1,2,-1},{8,0,0,5,1,0,0,1,2,-1},{8,0,0,9,0,0,0,1,2,-1},{8,0,0,5,0,0,0,1,2,-1},{8,0,0,9,0,0,0,1,2,-1},{8,0,0,5,0,0,0,1,2,-1},{8,0,0,9,0,0,0,1,2,-1},{8,0,0,5,0,0,0,1,2,-1},{8,0,0,9,0,0,0,1,2,-1},{8,0,0,5,0,0,0,1,2,-1},{8,0,0,9,0,0,0,1,2,-1},{8,0,0,5,0,0,0,1,2,-1},{8,0,0,9,0,0,0,1,2,-1},{8,0,0,5,0,0,0,1,2,-1},{8,0,0,7,0,0,0,1,2,-1},{8,0,0,12,0,0,17,1,9,-1}},
  {{8,0,0,11,0,0,17,1,9,-1},{8,0,0,11,0,0,17,1,9,-1},{8,0,0,11,0,0,17,1,9,-1},{8,0,0,21,0,0,10,1,2,-1},{8,0,0,12,1,0,17,1,9,-1},{8,0,0,12,1,0,17,1,9,-1},{8,0,0,12,1,0,17,1,9,-1},{8,0,0,12,1,0,17,1,9,-1},{8,0,0,12,1,0,17,1,9,-1},{8,0,0,12,1,0,17,1,9,-1},{8,0,0,12,1,0,17,1,9,-1},{8,0,0,12,1,0,17,1,9,-1},{8,0,0,12,0,0,17,1,9,-1},{8,0,0,12,0,0,17,1,9,-1},{8,0,0,21,0,0,10,1,2,-1},{8,0,0,6,1,0,10,1,2,-1}},
  {{8,0,0,9,0,0,0,1,2,-1},{8,0,0,5,0,0,0,1,2,-1},{8,0,0,9,0,0,0,1,2,-1},{8,0,0,5,0,0,0,1,2,-1},{8,0,0,9,0,0,0,1,2,-1},{8,0,0,5,0,0,0,1,2,-1},{8,0,0,9,0,0,0,1,2,-1},{8,0,0,5,0,0,0,1,2,-1},{8,0,0,9,0,0,0,1,2,-1},{8,0,0,5,0,0,0,1,2,-1},{8,0,0,9,0,0,0,1,2,-1},{8,0,0,5,0,0,0,1,2,-1},{8,0,0,6,0,0,0,1,2,-1},{8,0,0,6,0,0,0,1,2,-1},{8,0,0,12,0,0,17,1,9,-1},{8,0,0,12,1,0,17,1,9,-1}},
  {{130,0,0,7,0,0,0,1,2,-1},{130,0,0,7,0,0,0,1,2,-1},{130,0,0,7,0,0,0,1,2,-1},{130,0,0,7,0,0,0,1,2,-1},{130,0,0,7,0,0,0,1,2,-1},{130,0,0,7,0,0,0,1,2,-1},{130,0,0,7,0,0,0,1,2,-1},{130,0,0,7,0,0,0,1,2,-1},{130,0,0,7,0,0,0,1,2,-1},{130,0,0,7,0,0,0,1,2,-1},{130,0,0,7,0,0,0,1,2,-1},{130,0,0,7,0,0,0,1,2,-1},{130,0,0,7,0,0,0,1,2,-1},{130,0,0,7,0,0,0,1,2,-1},{130,0,0,7,0,0,0,1,2,-1},{130,0,0,7,0,0,0,1,2,-1}},
  {{130,0,0,7,0,0,0,1,2,-1},{130,0,0,7,0,0,0,1,2,-1},{130,0,0,7,0,0,0,1,2,-1},{130,0,0,7,0,0,0,1,2,-1},{130,0,0,7,0,0,0,1,2,-1},{130,0,0,7,0,0,0,1,2,-1},{130,0,0,14,0,0,0,1,2,-1},{130,0,0,14,0,0,0,1,2,-1},{130,0,0,14,0,0,0,1,2,-1},{130,0,0,14,0,0,0,1,2,-1},{130,0,0,14,0,0,0,1,2,-1},{130,0,0,14,0,0,0,1,2,-1},{130,0,0,14,0,0,0,1,2,-1},{130,0,0,14,0,0,0,1,2,-1},{130,0,0,14,0,0,0,1,2,-1},{130,0,0,14,0,0,0,1,2,-1}},
  {{130,0,0,12,0,0,17,1,9,-1},{130,0,0,12,0,0,17,1,9,-1},{130,0,0,21,0,0,0,1,2,-1},{130,0,0,21,0,0,0,1,4,-1},{130,0,0,21,0,0,0,1,4,-1},{130,0,0,21,0,0,0,1,4,-1},{130,0,0,21,0,0,0,1,4,-1},{130,0,0,21,0,0,0,1,4,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{0,0,0,24,0,0,10,1,2,-1},{0,0,0,24,0,0,10,1,2,-1},{0,0,0,24,0,0,10,1,2,-1},{0,0,0,24,0,0,10,1,2,-1},{0,0,0,24,0,0,10,1,2,-1},{0,0,0,24,0,0,10,1,2,-1},{0,0,0,24,0,0,10,1,2,-1},{0,0,0,6,1,0,10,1,2,-1},{0,0,0,6,1,0,10,1,2,-1},{0,0,0,6,1,0,10,1,2,-1},{0,0,0,6,1,0,10,1,2,-1},{0,0,0,6,1,0,10,1,2,-1},{0,0,0,6,1,0,10,1,2,-1},{0,0,0,6,1,0,10,1,2,-1},{0,0,0,6,1,0,10,1,2,-1},{0,0,0,6,1,0,10,1,2,-1}},
  {{0,0,0,24,0,0,10,1,2,-1},{0,0,0,24,0,0,10,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1}},
  {{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1}},
  {{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1}},
  {{25,0,0,6,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1}},
  {{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{0,0,0,6,1,0,10,1,2,-1},{0,0,0,24,0,0,0,1,2,-1},{0,0,0,24,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,7,0,0,0,1,2,-1}},
  {{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1}},
  {{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,9,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{25,0,0,9,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,9,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{25,0,0,7,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,5,1,0,0,1,2,-1},{25,0,0,7,0,0,0,1,2,-1},{25,0,0,7,0,0,0,1,2,-1},{25,0,0,7,0,0,0,1,2,-1},{25,0,0,7,0,0,0,1,2,-1},{25,0,0,7,0,0,0,1,2,-1}},
  {{58,0,0,7,0,0,0,1,2,-1},{58,0,0,7,0,0,0,1,2,-1},{58,0,0,12,0,0,17,1,9,-1},{58,0,0,7,0,0,0,1,2,-1},{58,0,0,7,0,0,0,1,2,-1},{58,0,0,7,0,0,0,1,2,-1},{58,0,0,12,0,0,17,1,9,-1},{58,0,0,7,0,0,0,1,2,-1},{58,0,0,7,0,0,0,1,2,-1},{58,0,0,7,0,0,0,1,2,-1},{58,0,0,7,0,0,0,1,2,-1},{58,0,0,12,0,0,17,1,9,-1},{58,0,0,7,0,0,0,1,2,-1},{58,0,0,7,0,0,0,1,2,-1},{58,0,0,7,0,0,0,1,2,-1},{58,0,0,7,0,0,0,1,2,-1}},
  {{58,0,0,7,0,0,0,1,2,-1},{58,0,0,7,0,0,0,1,2,-1},{58,0,0,7,0,0,0,1,2,-1},{58,0,0,7,0,0,0,1,2,-1},{58,0,0,7,0,0,0,1,2,-1},{58,0,0,7,0,0,0,1,2,-1},{58,0,0,7,0,0,0,1,2,-1},{58,0,0,7,0,0,0,1,2,-1},{58,0,0,7,0,0,0,1,2,-1},{58,0,0,7,0,0,0,1,2,-1},{58,0,0,7,0,0,0,1,2,-1},{58,0,0,7,0,0,0,1,2,-1},{58,0,0,7,0,0,0,1,2,-1},{58,0,0,7,0,0,0,1,2,-1},{58,0,0,7,0,0,0,1,2,-1},{58,0,0,7,0,0,0,1,2,-1}},
  {{58,0,0,7,0,0,0,1,2,-1},{58,0,0,7,0,0,0,1,2,-1},{58,0,0,7,0,0,0,1,2,-1},{58,0,0,10,0,0,0,1,9,-1},{58,0,0,10,0,0,0,1,9,-1},{58,0,0,12,0,0,17,1,9,-1},{58,0,0,12,0,0,17,1,9,-1},{58,0,0,10,0,0,0,1,9,-1},{58,0,0,26,0,0,10,1,2,-1},{58,0,0,26,0,0,10,1,2,-1},{58,0,0,26,0,0,10,1,2,-1},{58,0,0,26,0,0,10,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{0,0,0,15,0,0,0,1,2,-1},{0,0,0,15,0,0,0,1,2,-1},{0,0,0,15,0,0,0,1,2,-1},{0,0,0,15,0,0,0,1,2,-1},{0,0,0,15,0,0,0,1,2,-1},{0,0,0,15,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,23,0,0,4,1,21,-1},{0,0,0,26,0,0,4,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{90,0,0,7,0,0,0,1,2,-1},{90,0,0,7,0,0,0,1,2,-1},{90,0,0,7,0,0,0,1,2,-1},{90,0,0,7,0,0,0,1,2,-1},{90,0,0,7,0,0,0,1,2,-1},{90,0,0,7,0,0,0,1,2,-1},{90,0,0,7,0,0,0,1,2,-1},{90,0,0,7,0,0,0,1,2,-1},{90,0,0,7,0,0,0,1,2,-1},{90,0,0,7,0,0,0,1,2,-1},{90,0,0,7,0,0,0,1,2,-1},{90,0,0,7,0,0,0,1,2,-1},{90,0,0,7,0,0,0,1,2,-1},{90,0,0,7,0,0,0,1,2,-1},{90,0,0,7,0,0,0,1,2,-1},{90,0,0,7,0,0,0,1,2,-1}},
  {{90,0,0,7,0,0,0,1,2,-1},{90,0,0,7,0,0,0,1,2,-1},{90,0,0,7,0,0,0,1,2,-1},{90,0,0,7,0,0,0,1,2,-1},{90,0,0,21,0,0,10,1,5,-1},{90,0,0,21,0,0,10,1,5,-1},{90,0,0,21,0,0,10,1,11,-1},{90,0,0,21,0,0,10,1,11,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{111,0,0,10,0,0,0,1,9,-1},{111,0,0,10,0,0,0,1,9,-1},{111,0,0,7,0,0,0,1,2,-1},{111,0,0,7,0,0,0,1,2,-1},{111,0,0,7,0,0,0,1,2,-1},{111,0,0,7,0,0,0,1,2,-1},{111,0,0,7,0,0,0,1,2,-1},{111,0,0,7,0,0,0,1,2,-1},{111,0,0,7,0,0,0,1,2,-1},{111,0,0,7,0,0,0,1,2,-1},{111,0,0,7,0,0,0,1,2,-1},{111,0,0,7,0,0,0,1,2,-1},{111,0,0,7,0,0,0,1,2,-1},{111,0,0,7,0,0,0,1,2,-1},{111,0,0,7,0,0,0,1,2,-1},{111,0,0,7,0,0,0,1,2,-1}},
  {{111,0,0,7,0,0,0,1,2,-1},{111,0,0,7,0,0,0,1,2,-1},{111,0,0,7,0,0,0,1,2,-1},{111,0,0,7,0,0,0,1,2,-1},{111,0,0,7,0,0,0,1,2,-1},{111,0,0,7,0,0,0,1,2,-1},{111,0,0,7,0,0,0,1,2,-1},{111,0,0,7,0,0,0,1,2,-1},{111,0,0,7,0,0,0,1,2,-1},{111,0,0,7,0,0,0,1,2,-1},{111,0,0,7,0,0,0,1,2,-1},{111,0,0,7,0,0,0,1,2,-1},{111,0,0,7,0,0,0,1,2,-1},{111,0,0,7,0,0,0,1,2,-1},{111,0,0,7,0,0,0,1,2,-1},{111,0,0,7,0,0,0,1,2,-1}},
  {{111,0,0,7,0,0,0,1,2,-1},{111,0,0,7,0,0,0,1,2,-1},{111,0,0,7,0,0,0,1,2,-1},{111,0,0,7,0,0,0,1,2,-1},{111,0,0,10,0,0,0,1,9,-1},{111,0,0,10,0,0,0,1,9,-1},{111,0,0,10,0,0,0,1,9,-1},{111,0,0,10,0,0,0,1,9,-1},{111,0,0,10,0,0,0,1,9,-1},{111,0,0,10,0,0,0,1,9,-1},{111,0,0,10,0,0,0,1,9,-1},{111,0,0,10,0,0,0,1,9,-1},{111,0,0,10,0,0,0,1,9,-1},{111,0,0,10,0,0,0,1,9,-1},{111,0,0,10,0,0,0,1,9,-1},{111,0,0,10,0,0,0,1,9,-1}},
  {{111,0,0,10,0,0,0,1,9,-1},{111,0,0,10,0,0,0,1,9,-1},{111,0,0,10,0,0,0,1,9,-1},{111,0,0,10,0,0,0,1,9,-1},{111,0,0,12,0,0,17,1,9,-1},{111,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{111,0,0,21,0,0,0,1,4,-1},{111,0,0,21,0,0,0,1,4,-1}},
  {{111,0,0,13,0,0,0,1,19,0},{111,0,0,13,0,0,0,1,19,1},{111,0,0,13,0,0,0,1,19,2},{111,0,0,13,0,0,0,1,19,3},{111,0,0,13,0,0,0,1,19,4},{111,0,0,13,0,0,0,1,19,5},{111,0,0,13,0,0,0,1,19,6},{111,0,0,13,0,0,0,1,19,7},{111,0,0,13,0,0,0,1,19,8},{111,0,0,13,0,0,0,1,19,9},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{10,0,0,12,0,0,17,1,9,-1},{10,0,0,12,0,0,17,1,9,-1},{10,0,0,12,0,0,17,1,9,-1},{10,0,0,12,0,0,17,1,9,-1},{10,0,0,12,0,0,17,1,9,-1},{10,0,0,12,0,0,17,1,9,-1},{10,0,0,12,0,0,17,1,9,-1},{10,0,0,12,0,0,17,1,9,-1},{10,0,0,12,0,0,17,1,9,-1},{10,0,0,12,0,0,17,1,9,-1},{10,0,0,12,0,0,17,1,9,-1},{10,0,0,12,0,0,17,1,9,-1},{10,0,0,12,0,0,17,1,9,-1},{10,0,0,12,0,0,17,1,9,-1},{10,0,0,12,0,0,17,1,9,-1},{10,0,0,12,0,0,17,1,9,-1}},
  {{10,0,0,12,0,0,17,1,9,-1},{10,0,0,12,0,0,17,1,9,-1},{10,0,0,7,0,0,0,1,2,-1},{10,0,0,7,0,0,0,1,2,-1},{10,0,0,7,0,0,0,1,2,-1},{10,0,0,7,0,0,0,1,2,-1},{10,0,0,7,0,0,0,1,2,-1},{10,0,0,7,0,0,0,1,2,-1},{10,0,0,21,0,0,0,1,2,-1},{10,0,0,21,0,0,0,1,2,-1},{10,0,0,21,0,0,0,1,2,-1},{10,0,0,7,0,0,0,1,2,-1},{10,0,0,21,0,0,0,1,5,-1},{10,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{79,0,0,13,0,0,0,1,19,0},{79,0,0,13,0,0,0,1,19,1},{79,0,0,13,0,0,0,1,19,2},{79,0,0,13,0,0,0,1,19,3},{79,0,0,13,0,0,0,1,19,4},{79,0,0,13,0,0,0,1,19,5},{79,0,0,13,0,0,0,1,19,6},{79,0,0,13,0,0,0,1,19,7},{79,0,0,13,0,0,0,1,19,8},{79,0,0,13,0,0,0,1,19,9},{79,0,0,7,0,0,0,1,2,-1},{79,0,0,7,0,0,0,1,2,-1},{79,0,0,7,0,0,0,1,2,-1},{79,0,0,7,0,0,0,1,2,-1},{79,0,0,7,0,0,0,1,2,-1},{79,0,0,7,0,0,0,1,2,-1}},
  {{79,0,0,7,0,0,0,1,2,-1},{79,0,0,7,0,0,0,1,2,-1},{79,0,0,7,0,0,0,1,2,-1},{79,0,0,7,0,0,0,1,2,-1},{79,0,0,7,0,0,0,1,2,-1},{79,0,0,7,0,0,0,1,2,-1},{79,0,0,7,0,0,0,1,2,-1},{79,0,0,7,0,0,0,1,2,-1},{79,0,0,7,0,0,0,1,2,-1},{79,0,0,7,0,0,0,1,2,-1},{79,0,0,7,0,0,0,1,2,-1},{79,0,0,7,0,0,0,1,2,-1},{79,0,0,7,0,0,0,1,2,-1},{79,0,0,7,0,0,0,1,2,-1},{79,0,0,7,0,0,0,1,2,-1},{79,0,0,7,0,0,0,1,2,-1}},
  {{79,0,0,7,0,0,0,1,2,-1},{79,0,0,7,0,0,0,1,2,-1},{79,0,0,7,0,0,0,1,2,-1},{79,0,0,7,0,0,0,1,2,-1},{79,0,0,7,0,0,0,1,2,-1},{79,0,0,7,0,0,0,1,2,-1},{79,0,0,12,0,0,17,1,9,-1},{79,0,0,12,0,0,17,1,9,-1},{79,0,0,12,0,0,17,1,9,-1},{79,0,0,12,0,0,17,1,9,-1},{79,0,0,12,0,0,17,1,9,-1},{79,0,0,12,0,0,17,1,9,-1},{79,0,0,12,0,0,17,1,9,-1},{79,0,0,12,0,0,17,1,9,-1},{0,0,0,21,0,0,0,1,4,-1},{79,0,0,21,0,0,0,1,4,-1}},
  {{110,0,0,7,0,0,0,1,2,-1},{110,0,0,7,0,0,0,1,2,-1},{110,0,0,7,0,0,0,1,2,-1},{110,0,0,7,0,0,0,1,2,-1},{110,0,0,7,0,0,0,1,2,-1},{110,0,0,7,0,0,0,1,2,-1},{110,0,0,7,0,0,0,1,2,-1},{110,0,0,7,0,0,0,1,2,-1},{110,0,0,7,0,0,0,1,2,-1},{110,0,0,7,0,0,0,1,2,-1},{110,0,0,7,0,0,0,1,2,-1},{110,0,0,7,0,0,0,1,2,-1},{110,0,0,7,0,0,0,1,2,-1},{110,0,0,7,0,0,0,1,2,-1},{110,0,0,7,0,0,0,1,2,-1},{110,0,0,7,0,0,0,1,2,-1}},
  {{110,0,0,7,0,0,0,1,2,-1},{110,0,0,7,0,0,0,1,2,-1},{110,0,0,7,0,0,0,1,2,-1},{110,0,0,7,0,0,0,1,2,-1},{110,0,0,7,0,0,0,1,2,-1},{110,0,0,7,0,0,0,1,2,-1},{110,0,0,7,0,0,0,1,2,-1},{110,0,0,12,0,0,17,1,9,-1},{110,0,0,12,0,0,17,1,9,-1},{110,0,0,12,0,0,17,1,9,-1},{110,0,0,12,0,0,17,1,9,-1},{110,0,0,12,0,0,17,1,9,-1},{110,0,0,12,0,0,17,1,9,-1},{110,0,0,12,0,0,17,1,9,-1},{110,0,0,12,0,0,17,1,9,-1},{110,0,0,12,0,0,17,1,9,-1}},
  {{110,0,0,12,0,0,17,1,9,-1},{110,0,0,12,0,0,17,1,9,-1},{110,0,0,10,0,0,0,1,9,-1},{110,0,0,10,0,0,0,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{110,0,0,21,0,0,0,1,2,-1}},
  {{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{18,0,1,7,0,0,0,0,33,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1}},
  {{78,0,0,12,0,0,17,1,9,-1},{78,0,0,12,0,0,17,1,9,-1},{78,0,0,12,0,0,17,1,9,-1},{78,0,0,10,0,0,0,1,9,-1},{78,0,0,7,0,0,0,1,2,-1},{78,0,0,7,0,0,0,1,2,-1},{78,0,0,7,0,0,0,1,2,-1},{78,0,0,7,0,0,0,1,2,-1},{78,0,0,7,0,0,0,1,2,-1},{78,0,0,7,0,0,0,1,2,-1},{78,0,0,7,0,0,0,1,2,-1},{78,0,0,7,0,0,0,1,2,-1},{78,0,0,7,0,0,0,1,2,-1},{78,0,0,7,0,0,0,1,2,-1},{78,0,0,7,0,0,0,1,2,-1},{78,0,0,7,0,0,0,1,2,-1}},
  {{78,0,0,7,0,0,0,1,2,-1},{78,0,0,7,0,0,0,1,2,-1},{78,0,0,7,0,0,0,1,2,-1},{78,0,0,7,0,0,0,1,2,-1},{78,0,0,7,0,0,0,1,2,-1},{78,0,0,7,0,0,0,1,2,-1},{78,0,0,7,0,0,0,1,2,-1},{78,0,0,7,0,0,0,1,2,-1},{78,0,0,7,0,0,0,1,2,-1},{78,0,0,7,0,0,0,1,2,-1},{78,0,0,7,0,0,0,1,2,-1},{78,0,0,7,0,0,0,1,2,-1},{78,0,0,7,0,0,0,1,2,-1},{78,0,0,7,0,0,0,1,2,-1},{78,0,0,7,0,0,0,1,2,-1},{78,0,0,7,0,0,0,1,2,-1}},
  {{78,0,0,7,0,0,0,1,2,-1},{78,0,0,7,0,0,0,1,2,-1},{78,0,0,7,0,0,0,1,2,-1},{78,0,0,12,0,0,17,1,9,-1},{78,0,0,10,0,0,0,1,9,-1},{78,0,0,10,0,0,0,1,9,-1},{78,0,0,12,0,0,17,1,9,-1},{78,0,0,12,0,0,17,1,9,-1},{78,0,0,12,0,0,17,1,9,-1},{78,0,0,12,0,0,17,1,9,-1},{78,0,0,10,0,0,0,1,9,-1},{78,0,0,10,0,0,0,1,9,-1},{78,0,0,12,0,0,17,1,9,-1},{78,0,0,10,0,0,0,1,9,-1},{78,0,0,10,0,0,0,1,9,-1},{78,0,0,10,0,0,0,1,9,-1}},
  {{78,0,0,10,0,0,0,1,9,-1},{78,0,0,21,0,0,0,1,2,-1},{78,0,0,21,0,0,0,1,2,-1},{78,0,0,21,0,0,0,1,2,-1},{78,0,0,21,0,0,0,1,2,-1},{78,0,0,21,0,0,0,1,2,-1},{78,0,0,21,0,0,0,1,2,-1},{78,0,0,21,0,0,0,1,4,-1},{78,0,0,21,0,0,0,1,4,-1},{78,0,0,21,0,0,0,1,4,-1},{78,0,0,21,0,0,0,1,2,-1},{78,0,0,21,0,0,0,1,2,-1},{78,0,0,21,0,0,0,1,2,-1},{78,0,0,21,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{0,0,0,6,0,0,0,1,2,-1}},
  {{78,0,0,13,0,0,0,1,19,0},{78,0,0,13,0,0,0,1,19,1},{78,0,0,13,0,0,0,1,19,2},{78,0,0,13,0,0,0,1,19,3},{78,0,0,13,0,0,0,1,19,4},{78,0,0,13,0,0,0,1,19,5},{78,0,0,13,0,0,0,1,19,6},{78,0,0,13,0,0,0,1,19,7},{78,0,0,13,0,0,0,1,19,8},{78,0,0,13,0,0,0,1,19,9},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{78,0,0,21,0,0,0,1,2,-1},{78,0,0,21,0,0,0,1,2,-1}},
  {{28,0,0,7,0,0,0,1,24,-1},{28,0,0,7,0,0,0,1,24,-1},{28,0,0,7,0,0,0,1,24,-1},{28,0,0,7,0,0,0,1,24,-1},{28,0,0,7,0,0,0,1,24,-1},{28,0,0,12,0,0,17,1,24,-1},{28,0,0,6,0,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1}},
  {{28,0,0,13,1,0,0,1,19,0},{28,0,0,13,1,0,0,1,19,1},{28,0,0,13,1,0,0,1,19,2},{28,0,0,13,1,0,0,1,19,3},{28,0,0,13,1,0,0,1,19,4},{28,0,0,13,1,0,0,1,19,5},{28,0,0,13,1,0,0,1,19,6},{28,0,0,13,1,0,0,1,19,7},{28,0,0,13,1,0,0,1,19,8},{28,0,0,13,1,0,0,1,19,9},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{66,0,0,7,0,0,0,1,2,-1},{66,0,0,7,0,0,0,1,2,-1},{66,0,0,7,0,0,0,1,2,-1},{66,0,0,7,0,0,0,1,2,-1},{66,0,0,7,0,0,0,1,2,-1},{66,0,0,7,0,0,0,1,2,-1},{66,0,0,7,0,0,0,1,2,-1},{66,0,0,7,0,0,0,1,2,-1},{66,0,0,7,0,0,0,1,2,-1},{66,0,0,7,0,0,0,1,2,-1},{66,0,0,7,0,0,0,1,2,-1},{66,0,0,7,0,0,0,1,2,-1},{66,0,0,7,0,0,0,1,2,-1},{66,0,0,7,0,0,0,1,2,-1},{66,0,0,7,0,0,0,1,2,-1},{66,0,0,7,0,0,0,1,2,-1}},
  {{66,0,0,7,0,0,0,1,2,-1},{66,0,0,7,0,0,0,1,2,-1},{66,0,0,7,0,0,0,1,2,-1},{66,0,0,7,0,0,0,1,2,-1},{66,0,0,7,0,0,0,1,2,-1},{66,0,0,7,0,0,0,1,2,-1},{66,0,0,7,0,0,0,1,2,-1},{66,0,0,7,0,0,0,1,2,-1},{66,0,0,7,0,0,0,1,2,-1},{66,0,0,12,0,0,17,1,9,-1},{66,0,0,12,0,0,17,1,9,-1},{66,0,0,12,0,0,17,1,9,-1},{66,0,0,12,0,0,17,1,9,-1},{66,0,0,12,0,0,17,1,9,-1},{66,0,0,12,0,0,17,1,9,-1},{66,0,0,10,0,0,0,1,9,-1}},
  {{66,0,0,10,0,0,0,1,9,-1},{66,0,0,12,0,0,17,1,9,-1},{66,0,0,12,0,0,17,1,9,-1},{66,0,0,10,0,0,0,1,9,-1},{66,0,0,10,0,0,0,1,9,-1},{66,0,0,12,0,0,17,1,9,-1},{66,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{66,0,0,7,0,0,0,1,2,-1},{66,0,0,7,0,0,0,1,2,-1},{66,0,0,7,0,0,0,1,2,-1},{66,0,0,12,0,0,17,1,9,-1},{66,0,0,7,0,0,0,1,2,-1},{66,0,0,7,0,0,0,1,2,-1},{66,0,0,7,0,0,0,1,2,-1},{66,0,0,7,0,0,0,1,2,-1},{66,0,0,7,0,0,0,1,2,-1},{66,0,0,7,0,0,0,1,2,-1},{66,0,0,7,0,0,0,1,2,-1},{66,0,0,7,0,0,0,1,2,-1},{66,0,0,12,0,0,17,1,9,-1},{66,0,0,10,0,0,0,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{66,0,0,13,0,0,0,1,19,0},{66,0,0,13,0,0,0,1,19,1},{66,0,0,13,0,0,0,1,19,2},{66,0,0,13,0,0,0,1,19,3},{66,0,0,13,0,0,0,1,19,4},{66,0,0,13,0,0,0,1,19,5},{66,0,0,13,0,0,0,1,19,6},{66,0,0,13,0,0,0,1,19,7},{66,0,0,13,0,0,0,1,19,8},{66,0,0,13,0,0,0,1,19,9},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{66,0,0,21,0,0,0,1,2,-1},{66,0,0,21,0,0,0,1,4,-1},{66,0,0,21,0,0,0,1,4,-1},{66,0,0,21,0,0,0,1,4,-1}},
  {{28,0,0,6,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,26,0,0,0,1,24,-1},{28,0,0,26,0,0,0,1,24,-1},{28,0,0,26,0,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,10,1,0,0,1,24,-1},{28,0,0,12,1,0,17,1,24,-1},{28,0,0,10,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1},{28,0,0,7,1,0,0,1,24,-1}},
  {{127,0,0,7,0,0,0,1,24,-1},{127,0,0,7,0,0,0,1,24,-1},{127,0,0,7,0,0,0,1,24,-1},{127,0,0,7,0,0,0,1,24,-1},{127,0,0,7,0,0,0,1,24,-1},{127,0,0,7,0,0,0,1,24,-1},{127,0,0,7,0,0,0,1,24,-1},{127,0,0,7,0,0,0,1,24,-1},{127,0,0,7,0,0,0,1,24,-1},{127,0,0,7,0,0,0,1,24,-1},{127,0,0,7,0,0,0,1,24,-1},{127,0,0,7,0,0,0,1,24,-1},{127,0,0,7,0,0,0,1,24,-1},{127,0,0,7,0,0,0,1,24,-1},{127,0,0,7,0,0,0,1,24,-1},{127,0,0,7,0,0,0,1,24,-1}},
  {{127,0,0,12,0,0,17,1,24,-1},{127,0,0,7,0,0,0,1,24,-1},{127,0,0,12,0,0,17,1,24,-1},{127,0,0,12,0,0,17,1,24,-1},{127,0,0,12,0,0,17,1,24,-1},{127,0,0,7,0,0,0,1,24,-1},{127,0,0,7,0,0,0,1,24,-1},{127,0,0,12,0,0,17,1,24,-1},{127,0,0,12,0,0,17,1,24,-1},{127,0,0,7,0,0,0,1,24,-1},{127,0,0,7,0,0,0,1,24,-1},{127,0,0,7,0,0,0,1,24,-1},{127,0,0,7,0,0,0,1,24,-1},{127,0,0,7,0,0,0,1,24,-1},{127,0,0,12,0,0,17,1,24,-1},{127,0,0,12,0,0,17,1,24,-1}},
  {{127,0,0,7,0,0,0,1,24,-1},{127,0,0,12,0,0,17,1,24,-1},{127,0,0,7,0,0,0,1,24,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{127,0,0,7,0,0,0,1,24,-1},{127,0,0,7,0,0,0,1,24,-1},{127,0,0,6,0,0,0,1,24,-1},{127,0,0,21,0,0,0,1,24,-1},{127,0,0,21,0,0,0,1,24,-1}},
  {{115,0,0,7,0,0,0,1,2,-1},{115,0,0,7,0,0,0,1,2,-1},{115,0,0,7,0,0,0,1,2,-1},{115,0,0,7,0,0,0,1,2,-1},{115,0,0,7,0,0,0,1,2,-1},{115,0,0,7,0,0,0,1,2,-1},{115,0,0,7,0,0,0,1,2,-1},{115,0,0,7,0,0,0,1,2,-1},{115,0,0,7,0,0,0,1,2,-1},{115,0,0,7,0,0,0,1,2,-1},{115,0,0,7,0,0,0,1,2,-1},{115,0,0,10,0,0,0,1,9,-1},{115,0,0,12,0,0,17,1,9,-1},{115,0,0,12,0,0,17,1,9,-1},{115,0,0,10,0,0,0,1,9,-1},{115,0,0,10,0,0,0,1,9,-1}},
  {{115,0,0,21,0,0,0,1,4,-1},{115,0,0,21,0,0,0,1,4,-1},{115,0,0,7,0,0,0,1,2,-1},{115,0,0,6,0,0,0,1,2,-1},{115,0,0,6,0,0,0,1,2,-1},{115,0,0,10,0,0,0,1,9,-1},{115,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{103,0,0,2,0,0,0,1,0,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{103,0,0,2,0,0,0,1,0,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{11,0,0,7,1,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{0,0,0,24,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1},{25,0,0,6,0,0,0,1,2,-1}},
  {{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{14,0,0,5,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{6,0,0,5,0,0,0,1,2,-1},{6,0,0,5,0,0,0,1,2,-1},{6,0,0,5,0,0,0,1,2,-1},{6,0,0,5,0,0,0,1,2,-1},{6,0,0,5,0,0,0,1,2,-1},{6,0,0,5,0,0,0,1,2,-1},{6,0,0,5,0,0,0,1,2,-1},{6,0,0,5,0,0,0,1,2,-1},{6,0,0,5,0,0,0,1,2,-1},{6,0,0,5,0,0,0,1,2,-1},{6,0,0,5,0,0,0,1,2,-1},{6,0,0,5,0,0,0,1,2,-1},{6,0,0,5,0,0,0,1,2,-1},{6,0,0,5,0,0,0,1,2,-1},{6,0,0,5,0,0,0,1,2,-1},{6,0,0,5,0,0,0,1,2,-1}},
  {{115,0,0,7,0,0,0,1,2,-1},{115,0,0,7,0,0,0,1,2,-1},{115,0,0,7,0,0,0,1,2,-1},{115,0,0,7,0,0,0,1,2,-1},{115,0,0,7,0,0,0,1,2,-1},{115,0,0,7,0,0,0,1,2,-1},{115,0,0,7,0,0,0,1,2,-1},{115,0,0,7,0,0,0,1,2,-1},{115,0,0,7,0,0,0,1,2,-1},{115,0,0,7,0,0,0,1,2,-1},{115,0,0,7,0,0,0,1,2,-1},{115,0,0,7,0,0,0,1,2,-1},{115,0,0,7,0,0,0,1,2,-1},{115,0,0,7,0,0,0,1,2,-1},{115,0,0,7,0,0,0,1,2,-1},{115,0,0,7,0,0,0,1,2,-1}},
  {{115,0,0,7,0,0,0,1,2,-1},{115,0,0,7,0,0,0,1,2,-1},{115,0,0,7,0,0,0,1,2,-1},{115,0,0,10,0,0,0,1,9,-1},{115,0,0,10,0,0,0,1,9,-1},{115,0,0,12,0,0,17,1,9,-1},{115,0,0,10,0,0,0,1,9,-1},{115,0,0,10,0,0,0,1,9,-1},{115,0,0,12,0,0,17,1,9,-1},{115,0,0,10,0,0,0,1,9,-1},{115,0,0,10,0,0,0,1,9,-1},{115,0,0,21,0,0,0,1,4,-1},{115,0,0,10,0,0,0,1,9,-1},{115,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{115,0,0,13,0,0,0,1,19,0},{115,0,0,13,0,0,0,1,19,1},{115,0,0,13,0,0,0,1,19,2},{115,0,0,13,0,0,0,1,19,3},{115,0,0,13,0,0,0,1,19,4},{115,0,0,13,0,0,0,1,19,5},{115,0,0,13,0,0,0,1,19,6},{115,0,0,13,0,0,0,1,19,7},{115,0,0,13,0,0,0,1,19,8},{115,0,0,13,0,0,0,1,19,9},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{18,0,1,7,1,0,0,0,31,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1}},
  {{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,31,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1}},
  {{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1}},
  {{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,31,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1}},
  {{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,31,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1}},
  {{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{18,0,1,7,1,0,0,0,32,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1}},
  {{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{18,0,0,7,0,0,0,0,35,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{18,0,0,7,0,0,0,0,34,-1},{18,0,0,7,0,0,0,0,34,-1},{18,0,0,7,0,0,0,0,34,-1},{18,0,0,7,0,0,0,0,34,-1},{18,0,0,7,0,0,0,0,34,-1}},
  {{18,0,0,7,0,0,0,0,34,-1},{18,0,0,7,0,0,0,0,34,-1},{18,0,0,7,0,0,0,0,34,-1},{18,0,0,7,0,0,0,0,34,-1},{18,0,0,7,0,0,0,0,34,-1},{18,0,0,7,0,0,0,0,34,-1},{18,0,0,7,0,0,0,0,34,-1},{18,0,0,7,0,0,0,0,34,-1},{18,0,0,7,0,0,0,0,34,-1},{18,0,0,7,0,0,0,0,34,-1},{18,0,0,7,0,0,0,0,34,-1},{18,0,0,7,0,0,0,0,34,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1}},
  {{103,0,0,4,0,0,0,1,25,-1},{103,0,0,4,0,0,0,1,25,-1},{103,0,0,4,0,0,0,1,25,-1},{103,0,0,4,0,0,0,1,25,-1},{103,0,0,4,0,0,0,1,25,-1},{103,0,0,4,0,0,0,1,25,-1},{103,0,0,4,0,0,0,1,25,-1},{103,0,0,4,0,0,0,1,25,-1},{103,0,0,4,0,0,0,1,25,-1},{103,0,0,4,0,0,0,1,25,-1},{103,0,0,4,0,0,0,1,25,-1},{103,0,0,4,0,0,0,1,25,-1},{103,0,0,4,0,0,0,1,25,-1},{103,0,0,4,0,0,0,1,25,-1},{103,0,0,4,0,0,0,1,25,-1},{103,0,0,4,0,0,0,1,25,-1}},
  {{103,0,0,3,0,0,0,0,0,-1},{103,0,0,3,0,0,0,0,0,-1},{103,0,0,3,0,0,0,0,0,-1},{103,0,0,3,0,0,0,0,0,-1},{103,0,0,3,0,0,0,0,0,-1},{103,0,0,3,0,0,0,0,0,-1},{103,0,0,3,0,0,0,0,0,-1},{103,0,0,3,0,0,0,0,0,-1},{103,0,0,3,0,0,0,0,0,-1},{103,0,0,3,0,0,0,0,0,-1},{103,0,0,3,0,0,0,0,0,-1},{103,0,0,3,0,0,0,0,0,-1},{103,0,0,3,0,0,0,0,0,-1},{103,0,0,3,0,0,0,0,0,-1},{103,0,0,3,0,0,0,0,0,-1},{103,0,0,3,0,0,0,0,0,-1}},
  {{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1}},
  {{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1}},
  {{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1}},
  {{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1}},
  {{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1}},
  {{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{17,0,1,7,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1}},
  {{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{25,0,0,5,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{3,0,0,5,0,0,0,1,2,-1},{3,0,0,5,0,0,0,1,2,-1},{3,0,0,5,0,0,0,1,2,-1},{3,0,0,5,0,0,0,1,2,-1},{3,0,0,5,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{19,0,0,7,0,0,1,1,38,-1},{19,0,0,12,0,0,17,1,9,-1},{19,0,0,7,0,0,1,1,38,-1}},
  {{19,0,0,7,0,0,1,1,38,-1},{19,0,0,7,0,0,1,1,38,-1},{19,0,0,7,0,0,1,1,38,-1},{19,0,0,7,0,0,1,1,38,-1},{19,0,0,7,0,0,1,1,38,-1},{19,0,0,7,0,0,1,1,38,-1},{19,0,0,7,0,0,1,1,38,-1},{19,0,0,7,0,0,1,1,38,-1},{19,0,0,7,0,0,1,1,38,-1},{19,0,0,25,0,0,3,1,2,-1},{19,0,0,7,0,0,1,1,38,-1},{19,0,0,7,0,0,1,1,38,-1},{19,0,0,7,0,0,1,1,38,-1},{19,0,0,7,0,0,1,1,38,-1},{19,0,0,7,0,0,1,1,38,-1},{19,0,0,7,0,0,1,1,38,-1}},
  {{19,0,0,7,0,0,1,1,38,-1},{19,0,0,7,0,0,1,1,38,-1},{19,0,0,7,0,0,1,1,38,-1},{19,0,0,7,0,0,1,1,38,-1},{19,0,0,7,0,0,1,1,38,-1},{19,0,0,7,0,0,1,1,38,-1},{19,0,0,7,0,0,1,1,38,-1},{103,0,0,2,0,0,1,1,0,-1},{19,0,0,7,0,0,1,1,38,-1},{19,0,0,7,0,0,1,1,38,-1},{19,0,0,7,0,0,1,1,38,-1},{19,0,0,7,0,0,1,1,38,-1},{19,0,0,7,0,0,1,1,38,-1},{103,0,0,2,0,0,1,1,0,-1},{19,0,0,7,0,0,1,1,38,-1},{103,0,0,2,0,0,1,1,0,-1}},
  {{19,0,0,7,0,0,1,1,38,-1},{19,0,0,7,0,0,1,1,38,-1},{103,0,0,2,0,0,1,1,0,-1},{19,0,0,7,0,0,1,1,38,-1},{19,0,0,7,0,0,1,1,38,-1},{103,0,0,2,0,0,1,1,0,-1},{19,0,0,7,0,0,1,1,38,-1},{19,0,0,7,0,0,1,1,38,-1},{19,0,0,7,0,0,1,1,38,-1},{19,0,0,7,0,0,1,1,38,-1},{19,0,0,7,0,0,1,1,38,-1},{19,0,0,7,0,0,1,1,38,-1},{19,0,0,7,0,0,1,1,38,-1},{19,0,0,7,0,0,1,1,38,-1},{19,0,0,7,0,0,1,1,38,-1},{19,0,0,7,0,0,1,1,38,-1}},
  {{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1}},
  {{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,24,0,0,13,1,2,-1},{2,0,0,24,0,0,13,1,2,-1},{2,0,0,24,0,0,13,1,2,-1},{2,0,0,24,0,0,13,1,2,-1},{2,0,0,24,0,0,13,1,2,-1},{2,0,0,24,0,0,13,1,2,-1},{2,0,0,24,0,0,13,1,2,-1},{2,0,0,24,0,0,13,1,2,-1},{2,0,0,24,0,0,13,1,2,-1},{2,0,0,24,0,0,13,1,2,-1},{2,0,0,24,0,0,13,1,2,-1},{2,0,0,24,0,0,13,1,2,-1},{2,0,0,24,0,0,13,1,2,-1},{2,0,0,24,0,0,13,1,2,-1}},
  {{2,0,0,24,0,0,13,1,2,-1},{2,0,0,24,0,0,13,1,2,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1}},
  {{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1}},
  {{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{0,0,0,18,0,0,10,1,8,-1},{0,0,0,22,0,0,10,1,20,-1}},
  {{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1}},
  {{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1}},
  {{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,23,0,0,13,1,21,-1},{2,0,0,26,0,0,10,1,2,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1}},
  {{1,0,0,12,0,1,17,1,9,-1},{1,0,0,12,0,1,17,1,9,-1},{1,0,0,12,0,1,17,1,9,-1},{1,0,0,12,0,1,17,1,9,-1},{1,0,0,12,0,1,17,1,9,-1},{1,0,0,12,0,1,17,1,9,-1},{1,0,0,12,0,1,17,1,9,-1},{1,0,0,12,0,1,17,1,9,-1},{1,0,0,12,0,1,17,1,9,-1},{1,0,0,12,0,1,17,1,9,-1},{1,0,0,12,0,1,17,1,9,-1},{1,0,0,12,0,1,17,1,9,-1},{1,0,0,12,0,1,17,1,9,-1},{1,0,0,12,0,1,17,1,9,-1},{1,0,0,12,0,1,17,1,9,-1},{1,0,0,12,0,1,17,1,9,-1}},
  {{0,0,1,21,0,0,10,0,16,-1},{0,0,1,21,0,0,10,0,8,-1},{0,0,1,21,0,0,10,0,8,-1},{0,0,1,21,0,0,10,0,16,-1},{0,0,1,21,0,0,10,0,16,-1},{0,0,1,21,0,0,10,0,11,-1},{0,0,1,21,0,0,10,0,11,-1},{0,0,1,22,0,0,10,0,20,-1},{0,0,1,18,0,0,10,0,8,-1},{0,0,1,21,0,0,10,0,15,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1}},
  {{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{1,0,0,12,0,0,17,1,9,-1},{8,0,0,12,0,0,17,1,9,-1},{8,0,0,12,0,0,17,1,9,-1}},
  {{0,0,1,21,0,0,10,0,14,-1},{0,0,1,17,0,0,10,0,14,-1},{0,0,1,17,0,0,10,0,14,-1},{0,0,1,16,0,0,10,0,14,-1},{0,0,1,16,0,0,10,0,14,-1},{0,0,1,22,0,0,10,0,20,-1},{0,0,1,18,0,0,10,0,8,-1},{0,0,1,22,0,0,10,0,20,-1},{0,0,1,18,0,0,10,0,8,-1},{0,0,1,22,0,0,10,0,20,-1},{0,0,1,18,0,0,10,0,8,-1},{0,0,1,22,0,0,10,0,20,-1},{0,0,1,18,0,0,10,0,8,-1},{0,0,1,22,0,0,10,0,20,-1},{0,0,1,18,0,0,10,0,8,-1},{0,0,1,22,0,0,10,0,20,-1}},
  {{0,0,1,18,0,0,10,0,8,-1},{0,0,1,22,0,0,10,0,20,-1},{0,0,1,18,0,0,10,0,8,-1},{0,0,1,22,0,0,10,0,20,-1},{0,0,1,18,0,0,10,0,8,-1},{0,0,1,21,0,0,10,0,14,-1},{0,0,1,21,0,0,10,0,14,-1},{0,0,1,22,0,0,10,0,20,-1},{0,0,1,18,0,0,10,0,8,-1},{0,0,1,21,0,0,10,1,14,-1},{0,0,1,21,0,0,10,1,14,-1},{0,0,1,21,0,0,10,1,14,-1},{0,0,1,21,0,0,10,1,14,-1},{0,0,1,16,0,0,10,1,14,-1},{0,0,1,16,0,0,10,1,14,-1},{0,0,1,16,0,0,10,1,14,-1}},
  {{0,0,1,21,0,0,6,2,8,-1},{0,0,1,21,0,0,10,2,14,-1},{0,0,1,21,0,0,6,2,8,-1},{103,0,0,2,0,0,0,0,0,-1},{0,0,1,21,0,0,10,0,18,-1},{0,0,1,21,0,0,6,0,18,-1},{0,0,1,21,0,0,10,0,11,-1},{0,0,1,21,0,0,10,0,11,-1},{0,0,1,17,0,0,10,1,14,-1},{0,1,1,22,0,0,10,3,20,-1},{0,2,1,18,0,0,10,3,8,-1},{0,1,1,22,0,0,10,3,20,-1},{0,2,1,18,0,0,10,3,8,-1},{0,1,1,22,0,0,10,3,20,-1},{0,2,1,18,0,0,10,3,8,-1},{0,0,1,21,0,0,4,0,14,-1}},
  {{0,0,1,21,0,0,10,0,14,-1},{0,0,1,21,0,0,10,0,14,-1},{0,0,1,25,0,0,3,0,14,-1},{0,0,1,17,0,0,3,1,14,-1},{0,0,1,25,0,0,10,1,14,-1},{0,0,1,25,0,0,10,1,14,-1},{0,0,1,25,0,0,10,1,14,-1},{103,0,0,2,0,0,0,0,0,-1},{0,0,1,21,0,0,10,0,14,-1},{0,0,1,23,0,0,4,0,22,-1},{0,0,1,21,0,0,4,0,21,-1},{0,0,1,21,0,0,10,0,14,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1}},
  {{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{103,0,0,2,0,0,13,1,0,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1}},
  {{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{0,0,0,1,0,1,18,1,30,-1}},
  {{103,0,0,2,0,0,0,1,0,-1},{0,0,1,21,0,0,10,2,11,-1},{0,0,1,21,0,0,10,0,14,-1},{0,0,1,21,0,0,4,0,14,-1},{0,0,1,23,0,0,4,0,22,-1},{0,0,1,21,0,0,4,0,21,-1},{0,0,1,21,0,0,10,0,14,-1},{0,0,1,21,0,0,10,0,14,-1},{0,1,1,22,0,0,10,3,20,-1},{0,2,1,18,0,0,10,3,8,-1},{0,0,1,21,0,0,10,0,14,-1},{0,0,1,25,0,0,3,0,14,-1},{0,0,1,21,0,0,6,2,8,-1},{0,0,1,17,0,0,3,1,14,-1},{0,0,1,21,0,0,6,2,8,-1},{0,0,1,21,0,0,6,0,14,-1}},
  {{0,0,1,13,0,0,2,0,14,0},{0,0,1,13,0,0,2,0,14,1},{0,0,1,13,0,0,2,0,14,2},{0,0,1,13,0,0,2,0,14,3},{0,0,1,13,0,0,2,0,14,4},{0,0,1,13,0,0,2,0,14,5},{0,0,1,13,0,0,2,0,14,6},{0,0,1,13,0,0,2,0,14,7},{0,0,1,13,0,0,2,0,14,8},{0,0,1,13,0,0,2,0,14,9},{0,0,1,21,0,0,6,3,18,-1},{0,0,1,21,0,0,10,3,18,-1},{0,0,1,25,0,0,10,1,14,-1},{0,0,1,25,0,0,10,1,14,-1},{0,0,1,25,0,0,10,1,14,-1},{0,0,1,21,0,0,10,2,11,-1}},
  {{0,0,1,21,0,0,10,0,14,-1},{25,0,1,9,0,0,0,0,14,-1},{25,0,1,9,0,0,0,0,14,-1},{25,0,1,9,0,0,0,0,14,-1},{25,0,1,9,0,0,0,0,14,-1},{25,0,1,9,0,0,0,0,14,-1},{25,0,1,9,0,0,0,0,14,-1},{25,0,1,9,0,0,0,0,14,-1},{25,0,1,9,0,0,0,0,14,-1},{25,0,1,9,0,0,0,0,14,-1},{25,0,1,9,0,0,0,0,14,-1},{25,0,1,9,0,0,0,0,14,-1},{25,0,1,9,0,0,0,0,14,-1},{25,0,1,9,0,0,0,0,14,-1},{25,0,1,9,0,0,0,0,14,-1},{25,0,1,9,0,0,0,0,14,-1}},
  {{25,0,1,9,0,0,0,0,14,-1},{25,0,1,9,0,0,0,0,14,-1},{25,0,1,9,0,0,0,0,14,-1},{25,0,1,9,0,0,0,0,14,-1},{25,0,1,9,0,0,0,0,14,-1},{25,0,1,9,0,0,0,0,14,-1},{25,0,1,9,0,0,0,0,14,-1},{25,0,1,9,0,0,0,0,14,-1},{25,0,1,9,0,0,0,0,14,-1},{25,0,1,9,0,0,0,0,14,-1},{25,0,1,9,0,0,0,0,14,-1},{0,1,1,22,0,0,10,3,20,-1},{0,0,1,21,0,0,10,0,14,-1},{0,2,1,18,0,0,10,3,8,-1},{0,0,1,24,0,0,10,0,14,-1},{0,0,1,16,0,0,10,3,14,-1}},
  {{0,0,1,24,0,0,10,0,14,-1},{25,0,1,5,0,0,0,0,14,-1},{25,0,1,5,0,0,0,0,14,-1},{25,0,1,5,0,0,0,0,14,-1},{25,0,1,5,0,0,0,0,14,-1},{25,0,1,5,0,0,0,0,14,-1},{25,0,1,5,0,0,0,0,14,-1},{25,0,1,5,0,0,0,0,14,-1},{25,0,1,5,0,0,0,0,14,-1},{25,0,1,5,0,0,0,0,14,-1},{25,0,1,5,0,0,0,0,14,-1},{25,0,1,5,0,0,0,0,14,-1},{25,0,1,5,0,0,0,0,14,-1},{25,0,1,5,0,0,0,0,14,-1},{25,0,1,5,0,0,0,0,14,-1},{25,0,1,5,0,0,0,0,14,-1}},
  {{25,0,1,5,0,0,0,0,14,-1},{25,0,1,5,0,0,0,0,14,-1},{25,0,1,5,0,0,0,0,14,-1},{25,0,1,5,0,0,0,0,14,-1},{25,0,1,5,0,0,0,0,14,-1},{25,0,1,5,0,0,0,0,14,-1},{25,0,1,5,0,0,0,0,14,-1},{25,0,1,5,0,0,0,0,14,-1},{25,0,1,5,0,0,0,0,14,-1},{25,0,1,5,0,0,0,0,14,-1},{25,0,1,5,0,0,0,0,14,-1},{0,1,1,22,0,0,10,3,20,-1},{0,0,1,25,0,0,10,3,14,-1},{0,2,1,18,0,0,10,3,8,-1},{0,0,1,25,0,0,10,3,14,-1},{0,1,1,22,0,0,10,3,20,-1}},
  {{0,2,1,18,0,0,10,3,8,-1},{0,0,1,21,0,0,10,1,8,-1},{0,1,1,22,0,0,10,1,20,-1},{0,2,1,18,0,0,10,1,8,-1},{0,0,1,21,0,0,10,1,8,-1},{0,0,1,21,0,0,10,1,18,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,37,-1},{22,0,1,7,0,0,0,1,37,-1},{22,0,1,7,0,0,0,1,37,-1},{22,0,1,7,0,0,0,1,37,-1},{22,0,1,7,0,0,0,1,37,-1},{22,0,1,7,0,0,0,1,37,-1},{22,0,1,7,0,0,0,1,37,-1},{22,0,1,7,0,0,0,1,37,-1},{22,0,1,7,0,0,0,1,37,-1}},
  {{0,0,1,6,0,0,0,1,37,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1}},
  {{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1}},
  {{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{22,0,1,7,0,0,0,1,14,-1},{0,0,1,6,0,0,0,1,18,-1},{0,0,1,6,0,0,0,1,18,-1}},
  {{18,0,1,7,0,1,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1}},
  {{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1}},
  {{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{18,0,1,7,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{0,0,1,23,0,0,4,0,21,-1},{0,0,1,23,0,0,4,0,22,-1},{0,0,1,25,0,0,10,0,14,-1},{0,0,1,24,0,0,10,3,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,23,0,0,4,0,22,-1},{0,0,1,23,0,0,4,0,22,-1},{103,0,0,2,0,0,0,0,0,-1},{0,0,1,26,0,0,10,1,2,-1},{0,0,1,25,0,0,10,1,2,-1},{0,0,1,25,0,0,10,1,2,-1},{0,0,1,25,0,0,10,1,2,-1},{0,0,1,25,0,0,10,1,2,-1},{0,0,1,26,0,0,10,1,2,-1},{0,0,1,26,0,0,10,1,2,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{103,0,0,2,0,1,0,0,0,-1},{103,0,0,2,0,1,0,0,0,-1},{103,0,0,2,0,1,0,0,0,-1},{103,0,0,2,0,1,0,0,0,-1},{103,0,0,2,0,1,0,0,0,-1},{103,0,0,2,0,1,0,0,0,-1},{103,0,0,2,0,1,0,0,0,-1},{103,0,0,2,0,1,0,0,0,-1},{103,0,0,2,0,1,0,0,0,-1},{0,0,0,1,0,0,10,1,9,-1},{0,0,0,1,0,0,10,1,9,-1},{0,0,0,1,0,0,10,1,9,-1},{0,0,0,26,0,0,10,0,7,-1},{0,0,0,26,0,0,10,0,1,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1}},
  {{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1}},
  {{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1}},
  {{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{49,0,0,7,0,0,0,1,2,-1}},
  {{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{49,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{0,0,0,21,0,0,0,1,4,-1},{0,0,0,21,0,0,10,1,4,-1},{0,0,0,21,0,0,0,1,4,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{0,0,0,15,0,0,0,1,2,-1},{0,0,0,15,0,0,0,1,2,-1},{0,0,0,15,0,0,0,1,2,-1},{0,0,0,15,0,0,0,1,2,-1},{0,0,0,15,0,0,0,1,2,-1},{0,0,0,15,0,0,0,1,2,-1},{0,0,0,15,0,0,0,1,2,-1},{0,0,0,15,0,0,0,1,2,-1},{0,0,0,15,0,0,0,1,2,-1}},
  {{0,0,0,15,0,0,0,1,2,-1},{0,0,0,15,0,0,0,1,2,-1},{0,0,0,15,0,0,0,1,2,-1},{0,0,0,15,0,0,0,1,2,-1},{0,0,0,15,0,0,0,1,2,-1},{0,0,0,15,0,0,0,1,2,-1},{0,0,0,15,0,0,0,1,2,-1},{0,0,0,15,0,0,0,1,2,-1},{0,0,0,15,0,0,0,1,2,-1},{0,0,0,15,0,0,0,1,2,-1},{0,0,0,15,0,0,0,1,2,-1},{0,0,0,15,0,0,0,1,2,-1},{0,0,0,15,0,0,0,1,2,-1},{0,0,0,15,0,0,0,1,2,-1},{0,0,0,15,0,0,0,1,2,-1},{0,0,0,15,0,0,0,1,2,-1}},
  {{0,0,0,15,0,0,0,1,2,-1},{0,0,0,15,0,0,0,1,2,-1},{0,0,0,15,0,0,0,1,2,-1},{0,0,0,15,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1}},
  {{14,0,0,14,0,0,10,1,2,-1},{14,0,0,14,0,0,10,1,2,-1},{14,0,0,14,0,0,10,1,2,-1},{14,0,0,14,0,0,10,1,2,-1},{14,0,0,14,0,0,10,1,2,-1},{14,0,0,14,0,0,10,1,2,-1},{14,0,0,14,0,0,10,1,2,-1},{14,0,0,14,0,0,10,1,2,-1},{14,0,0,14,0,0,10,1,2,-1},{14,0,0,14,0,0,10,1,2,-1},{14,0,0,14,0,0,10,1,2,-1},{14,0,0,14,0,0,10,1,2,-1},{14,0,0,14,0,0,10,1,2,-1},{14,0,0,14,0,0,10,1,2,-1},{14,0,0,14,0,0,10,1,2,-1},{14,0,0,14,0,0,10,1,2,-1}},
  {{14,0,0,14,0,0,10,1,2,-1},{14,0,0,14,0,0,10,1,2,-1},{14,0,0,14,0,0,10,1,2,-1},{14,0,0,14,0,0,10,1,2,-1},{14,0,0,14,0,0,10,1,2,-1},{14,0,0,15,0,0,10,1,2,-1},{14,0,0,15,0,0,10,1,2,-1},{14,0,0,15,0,0,10,1,2,-1},{14,0,0,15,0,0,10,1,2,-1},{14,0,0,26,0,0,10,1,2,-1},{14,0,0,26,0,0,10,1,2,-1},{14,0,0,26,0,0,10,1,2,-1},{14,0,0,26,0,0,10,1,2,-1},{14,0,0,26,0,0,10,1,2,-1},{14,0,0,26,0,0,10,1,2,-1},{14,0,0,26,0,0,10,1,2,-1}},
  {{14,0,0,26,0,0,10,1,2,-1},{14,0,0,26,0,0,10,1,2,-1},{14,0,0,26,0,0,10,1,2,-1},{14,0,0,26,0,0,10,1,2,-1},{14,0,0,26,0,0,10,1,2,-1},{14,0,0,26,0,0,10,1,2,-1},{14,0,0,26,0,0,10,1,2,-1},{14,0,0,26,0,0,10,1,2,-1},{14,0,0,26,0,0,10,1,2,-1},{14,0,0,26,0,0,10,1,2,-1},{14,0,0,15,0,0,10,1,2,-1},{14,0,0,15,0,0,10,1,2,-1},{14,0,0,26,0,0,10,1,2,-1},{14,0,0,26,0,0,0,1,2,-1},{14,0,0,26,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{14,0,0,26,0,0,10,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{0,0,0,26,0,0,0,1,2,-1},{1,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{107,0,0,7,0,0,0,1,2,-1},{107,0,0,7,0,0,0,1,2,-1},{107,0,0,7,0,0,0,1,2,-1},{107,0,0,7,0,0,0,1,2,-1},{107,0,0,7,0,0,0,1,2,-1},{107,0,0,7,0,0,0,1,2,-1},{107,0,0,7,0,0,0,1,2,-1},{107,0,0,7,0,0,0,1,2,-1},{107,0,0,7,0,0,0,1,2,-1},{107,0,0,7,0,0,0,1,2,-1},{107,0,0,7,0,0,0,1,2,-1},{107,0,0,7,0,0,0,1,2,-1},{107,0,0,7,0,0,0,1,2,-1},{107,0,0,7,0,0,0,1,2,-1},{107,0,0,7,0,0,0,1,2,-1},{107,0,0,7,0,0,0,1,2,-1}},
  {{107,0,0,7,0,0,0,1,2,-1},{107,0,0,7,0,0,0,1,2,-1},{107,0,0,7,0,0,0,1,2,-1},{107,0,0,7,0,0,0,1,2,-1},{107,0,0,7,0,0,0,1,2,-1},{107,0,0,7,0,0,0,1,2,-1},{107,0,0,7,0,0,0,1,2,-1},{107,0,0,7,0,0,0,1,2,-1},{107,0,0,7,0,0,0,1,2,-1},{107,0,0,7,0,0,0,1,2,-1},{107,0,0,7,0,0,0,1,2,-1},{107,0,0,7,0,0,0,1,2,-1},{107,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{104,0,0,7,0,0,0,1,2,-1},{104,0,0,7,0,0,0,1,2,-1},{104,0,0,7,0,0,0,1,2,-1},{104,0,0,7,0,0,0,1,2,-1},{104,0,0,7,0,0,0,1,2,-1},{104,0,0,7,0,0,0,1,2,-1},{104,0,0,7,0,0,0,1,2,-1},{104,0,0,7,0,0,0,1,2,-1},{104,0,0,7,0,0,0,1,2,-1},{104,0,0,7,0,0,0,1,2,-1},{104,0,0,7,0,0,0,1,2,-1},{104,0,0,7,0,0,0,1,2,-1},{104,0,0,7,0,0,0,1,2,-1},{104,0,0,7,0,0,0,1,2,-1},{104,0,0,7,0,0,0,1,2,-1},{104,0,0,7,0,0,0,1,2,-1}},
  {{104,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{1,0,0,12,0,0,17,1,9,-1},{0,0,0,15,0,0,2,1,2,-1},{0,0,0,15,0,0,2,1,2,-1},{0,0,0,15,0,0,2,1,2,-1},{0,0,0,15,0,0,2,1,2,-1},{0,0,0,15,0,0,2,1,2,-1},{0,0,0,15,0,0,2,1,2,-1},{0,0,0,15,0,0,2,1,2,-1},{0,0,0,15,0,0,2,1,2,-1},{0,0,0,15,0,0,2,1,2,-1},{0,0,0,15,0,0,2,1,2,-1},{0,0,0,15,0,0,2,1,2,-1},{0,0,0,15,0,0,2,1,2,-1},{0,0,0,15,0,0,2,1,2,-1},{0,0,0,15,0,0,2,1,2,-1},{0,0,0,15,0,0,2,1,2,-1}},
  {{0,0,0,15,0,0,2,1,2,-1},{0,0,0,15,0,0,2,1,2,-1},{0,0,0,15,0,0,2,1,2,-1},{0,0,0,15,0,0,2,1,2,-1},{0,0,0,15,0,0,2,1,2,-1},{0,0,0,15,0,0,2,1,2,-1},{0,0,0,15,0,0,2,1,2,-1},{0,0,0,15,0,0,2,1,2,-1},{0,0,0,15,0,0,2,1,2,-1},{0,0,0,15,0,0,2,1,2,-1},{0,0,0,15,0,0,2,1,2,-1},{0,0,0,15,0,0,2,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{30,0,0,7,0,0,0,1,2,-1},{30,0,0,7,0,0,0,1,2,-1},{30,0,0,7,0,0,0,1,2,-1},{30,0,0,7,0,0,0,1,2,-1},{30,0,0,7,0,0,0,1,2,-1},{30,0,0,7,0,0,0,1,2,-1},{30,0,0,7,0,0,0,1,2,-1},{30,0,0,7,0,0,0,1,2,-1},{30,0,0,7,0,0,0,1,2,-1},{30,0,0,7,0,0,0,1,2,-1},{30,0,0,7,0,0,0,1,2,-1},{30,0,0,7,0,0,0,1,2,-1},{30,0,0,7,0,0,0,1,2,-1},{30,0,0,7,0,0,0,1,2,-1},{30,0,0,7,0,0,0,1,2,-1},{30,0,0,7,0,0,0,1,2,-1}},
  {{30,0,0,15,0,0,0,1,2,-1},{30,0,0,15,0,0,0,1,2,-1},{30,0,0,15,0,0,0,1,2,-1},{30,0,0,15,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{13,0,0,7,0,0,0,1,2,-1},{13,0,0,7,0,0,0,1,2,-1},{13,0,0,7,0,0,0,1,2,-1},{13,0,0,7,0,0,0,1,2,-1},{13,0,0,7,0,0,0,1,2,-1},{13,0,0,7,0,0,0,1,2,-1},{13,0,0,7,0,0,0,1,2,-1},{13,0,0,7,0,0,0,1,2,-1},{13,0,0,7,0,0,0,1,2,-1},{13,0,0,7,0,0,0,1,2,-1},{13,0,0,7,0,0,0,1,2,-1},{13,0,0,7,0,0,0,1,2,-1},{13,0,0,7,0,0,0,1,2,-1},{13,0,0,7,0,0,0,1,2,-1},{13,0,0,7,0,0,0,1,2,-1},{13,0,0,7,0,0,0,1,2,-1}},
  {{13,0,0,7,0,0,0,1,2,-1},{13,0,0,14,0,0,0,1,2,-1},{13,0,0,7,0,0,0,1,2,-1},{13,0,0,7,0,0,0,1,2,-1},{13,0,0,7,0,0,0,1,2,-1},{13,0,0,7,0,0,0,1,2,-1},{13,0,0,7,0,0,0,1,2,-1},{13,0,0,7,0,0,0,1,2,-1},{13,0,0,7,0,0,0,1,2,-1},{13,0,0,7,0,0,0,1,2,-1},{13,0,0,14,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{89,0,0,7,0,0,0,1,2,-1},{89,0,0,7,0,0,0,1,2,-1},{89,0,0,7,0,0,0,1,2,-1},{89,0,0,7,0,0,0,1,2,-1},{89,0,0,7,0,0,0,1,2,-1},{89,0,0,7,0,0,0,1,2,-1},{89,0,0,7,0,0,0,1,2,-1},{89,0,0,7,0,0,0,1,2,-1},{89,0,0,7,0,0,0,1,2,-1},{89,0,0,7,0,0,0,1,2,-1},{89,0,0,7,0,0,0,1,2,-1},{89,0,0,7,0,0,0,1,2,-1},{89,0,0,7,0,0,0,1,2,-1},{89,0,0,7,0,0,0,1,2,-1},{89,0,0,7,0,0,0,1,2,-1},{89,0,0,7,0,0,0,1,2,-1}},
  {{89,0,0,7,0,0,0,1,2,-1},{89,0,0,7,0,0,0,1,2,-1},{89,0,0,7,0,0,0,1,2,-1},{89,0,0,7,0,0,0,1,2,-1},{89,0,0,7,0,0,0,1,2,-1},{89,0,0,7,0,0,0,1,2,-1},{89,0,0,12,0,0,17,1,9,-1},{89,0,0,12,0,0,17,1,9,-1},{89,0,0,12,0,0,17,1,9,-1},{89,0,0,12,0,0,17,1,9,-1},{89,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{53,0,0,7,0,0,0,1,2,-1},{53,0,0,7,0,0,0,1,2,-1},{53,0,0,7,0,0,0,1,2,-1},{53,0,0,7,0,0,0,1,2,-1},{53,0,0,7,0,0,0,1,2,-1},{53,0,0,7,0,0,0,1,2,-1},{53,0,0,7,0,0,0,1,2,-1},{53,0,0,7,0,0,0,1,2,-1},{53,0,0,7,0,0,0,1,2,-1},{53,0,0,7,0,0,0,1,2,-1},{53,0,0,7,0,0,0,1,2,-1},{53,0,0,7,0,0,0,1,2,-1},{53,0,0,7,0,0,0,1,2,-1},{53,0,0,7,0,0,0,1,2,-1},{53,0,0,7,0,0,0,1,2,-1},{53,0,0,7,0,0,0,1,2,-1}},
  {{53,0,0,7,0,0,0,1,2,-1},{53,0,0,7,0,0,0,1,2,-1},{53,0,0,7,0,0,0,1,2,-1},{53,0,0,7,0,0,0,1,2,-1},{53,0,0,7,0,0,0,1,2,-1},{53,0,0,7,0,0,0,1,2,-1},{53,0,0,7,0,0,0,1,2,-1},{53,0,0,7,0,0,0,1,2,-1},{53,0,0,7,0,0,0,1,2,-1},{53,0,0,7,0,0,0,1,2,-1},{53,0,0,7,0,0,0,1,2,-1},{53,0,0,7,0,0,0,1,2,-1},{53,0,0,7,0,0,0,1,2,-1},{53,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{53,0,0,21,0,0,0,1,4,-1}},
  {{61,0,0,7,0,0,0,1,2,-1},{61,0,0,7,0,0,0,1,2,-1},{61,0,0,7,0,0,0,1,2,-1},{61,0,0,7,0,0,0,1,2,-1},{61,0,0,7,0,0,0,1,2,-1},{61,0,0,7,0,0,0,1,2,-1},{61,0,0,7,0,0,0,1,2,-1},{61,0,0,7,0,0,0,1,2,-1},{61,0,0,7,0,0,0,1,2,-1},{61,0,0,7,0,0,0,1,2,-1},{61,0,0,7,0,0,0,1,2,-1},{61,0,0,7,0,0,0,1,2,-1},{61,0,0,7,0,0,0,1,2,-1},{61,0,0,7,0,0,0,1,2,-1},{61,0,0,7,0,0,0,1,2,-1},{61,0,0,7,0,0,0,1,2,-1}},
  {{61,0,0,7,0,0,0,1,2,-1},{61,0,0,7,0,0,0,1,2,-1},{61,0,0,7,0,0,0,1,2,-1},{61,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{61,0,0,7,0,0,0,1,2,-1},{61,0,0,7,0,0,0,1,2,-1},{61,0,0,7,0,0,0,1,2,-1},{61,0,0,7,0,0,0,1,2,-1},{61,0,0,7,0,0,0,1,2,-1},{61,0,0,7,0,0,0,1,2,-1},{61,0,0,7,0,0,0,1,2,-1},{61,0,0,7,0,0,0,1,2,-1}},
  {{61,0,0,21,0,0,0,1,4,-1},{61,0,0,14,0,0,0,1,2,-1},{61,0,0,14,0,0,0,1,2,-1},{61,0,0,14,0,0,0,1,2,-1},{61,0,0,14,0,0,0,1,2,-1},{61,0,0,14,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{9,0,0,9,0,0,0,1,2,-1},{9,0,0,9,0,0,0,1,2,-1},{9,0,0,9,0,0,0,1,2,-1},{9,0,0,9,0,0,0,1,2,-1},{9,0,0,9,0,0,0,1,2,-1},{9,0,0,9,0,0,0,1,2,-1},{9,0,0,9,0,0,0,1,2,-1},{9,0,0,9,0,0,0,1,2,-1},{9,0,0,9,0,0,0,1,2,-1},{9,0,0,9,0,0,0,1,2,-1},{9,0,0,9,0,0,0,1,2,-1},{9,0,0,9,0,0,0,1,2,-1},{9,0,0,9,0,0,0,1,2,-1},{9,0,0,9,0,0,0,1,2,-1},{9,0,0,9,0,0,0,1,2,-1},{9,0,0,9,0,0,0,1,2,-1}},
  {{9,0,0,9,0,0,0,1,2,-1},{9,0,0,9,0,0,0,1,2,-1},{9,0,0,9,0,0,0,1,2,-1},{9,0,0,9,0,0,0,1,2,-1},{9,0,0,9,0,0,0,1,2,-1},{9,0,0,9,0,0,0,1,2,-1},{9,0,0,9,0,0,0,1,2,-1},{9,0,0,9,0,0,0,1,2,-1},{9,0,0,5,0,0,0,1,2,-1},{9,0,0,5,0,0,0,1,2,-1},{9,0,0,5,0,0,0,1,2,-1},{9,0,0,5,0,0,0,1,2,-1},{9,0,0,5,0,0,0,1,2,-1},{9,0,0,5,0,0,0,1,2,-1},{9,0,0,5,0,0,0,1,2,-1},{9,0,0,5,0,0,0,1,2,-1}},
  {{9,0,0,5,0,0,0,1,2,-1},{9,0,0,5,0,0,0,1,2,-1},{9,0,0,5,0,0,0,1,2,-1},{9,0,0,5,0,0,0,1,2,-1},{9,0,0,5,0,0,0,1,2,-1},{9,0,0,5,0,0,0,1,2,-1},{9,0,0,5,0,0,0,1,2,-1},{9,0,0,5,0,0,0,1,2,-1},{9,0,0,5,0,0,0,1,2,-1},{9,0,0,5,0,0,0,1,2,-1},{9,0,0,5,0,0,0,1,2,-1},{9,0,0,5,0,0,0,1,2,-1},{9,0,0,5,0,0,0,1,2,-1},{9,0,0,5,0,0,0,1,2,-1},{9,0,0,5,0,0,0,1,2,-1},{9,0,0,5,0,0,0,1,2,-1}},
  {{51,0,0,7,0,0,0,1,2,-1},{51,0,0,7,0,0,0,1,2,-1},{51,0,0,7,0,0,0,1,2,-1},{51,0,0,7,0,0,0,1,2,-1},{51,0,0,7,0,0,0,1,2,-1},{51,0,0,7,0,0,0,1,2,-1},{51,0,0,7,0,0,0,1,2,-1},{51,0,0,7,0,0,0,1,2,-1},{51,0,0,7,0,0,0,1,2,-1},{51,0,0,7,0,0,0,1,2,-1},{51,0,0,7,0,0,0,1,2,-1},{51,0,0,7,0,0,0,1,2,-1},{51,0,0,7,0,0,0,1,2,-1},{51,0,0,7,0,0,0,1,2,-1},{51,0,0,7,0,0,0,1,2,-1},{51,0,0,7,0,0,0,1,2,-1}},
  {{50,0,0,7,0,0,0,1,2,-1},{50,0,0,7,0,0,0,1,2,-1},{50,0,0,7,0,0,0,1,2,-1},{50,0,0,7,0,0,0,1,2,-1},{50,0,0,7,0,0,0,1,2,-1},{50,0,0,7,0,0,0,1,2,-1},{50,0,0,7,0,0,0,1,2,-1},{50,0,0,7,0,0,0,1,2,-1},{50,0,0,7,0,0,0,1,2,-1},{50,0,0,7,0,0,0,1,2,-1},{50,0,0,7,0,0,0,1,2,-1},{50,0,0,7,0,0,0,1,2,-1},{50,0,0,7,0,0,0,1,2,-1},{50,0,0,7,0,0,0,1,2,-1},{50,0,0,7,0,0,0,1,2,-1},{50,0,0,7,0,0,0,1,2,-1}},
  {{50,0,0,7,0,0,0,1,2,-1},{50,0,0,7,0,0,0,1,2,-1},{50,0,0,7,0,0,0,1,2,-1},{50,0,0,7,0,0,0,1,2,-1},{50,0,0,7,0,0,0,1,2,-1},{50,0,0,7,0,0,0,1,2,-1},{50,0,0,7,0,0,0,1,2,-1},{50,0,0,7,0,0,0,1,2,-1},{50,0,0,7,0,0,0,1,2,-1},{50,0,0,7,0,0,0,1,2,-1},{50,0,0,7,0,0,0,1,2,-1},{50,0,0,7,0,0,0,1,2,-1},{50,0,0,7,0,0,0,1,2,-1},{50,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{50,0,0,13,0,0,0,1,19,0},{50,0,0,13,0,0,0,1,19,1},{50,0,0,13,0,0,0,1,19,2},{50,0,0,13,0,0,0,1,19,3},{50,0,0,13,0,0,0,1,19,4},{50,0,0,13,0,0,0,1,19,5},{50,0,0,13,0,0,0,1,19,6},{50,0,0,13,0,0,0,1,19,7},{50,0,0,13,0,0,0,1,19,8},{50,0,0,13,0,0,0,1,19,9},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{171,0,0,9,0,0,0,1,2,-1},{171,0,0,9,0,0,0,1,2,-1},{171,0,0,9,0,0,0,1,2,-1},{171,0,0,9,0,0,0,1,2,-1},{171,0,0,9,0,0,0,1,2,-1},{171,0,0,9,0,0,0,1,2,-1},{171,0,0,9,0,0,0,1,2,-1},{171,0,0,9,0,0,0,1,2,-1},{171,0,0,9,0,0,0,1,2,-1},{171,0,0,9,0,0,0,1,2,-1},{171,0,0,9,0,0,0,1,2,-1},{171,0,0,9,0,0,0,1,2,-1},{171,0,0,9,0,0,0,1,2,-1},{171,0,0,9,0,0,0,1,2,-1},{171,0,0,9,0,0,0,1,2,-1},{171,0,0,9,0,0,0,1,2,-1}},
  {{171,0,0,9,0,0,0,1,2,-1},{171,0,0,9,0,0,0,1,2,-1},{171,0,0,9,0,0,0,1,2,-1},{171,0,0,9,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{171,0,0,5,0,0,0,1,2,-1},{171,0,0,5,0,0,0,1,2,-1},{171,0,0,5,0,0,0,1,2,-1},{171,0,0,5,0,0,0,1,2,-1},{171,0,0,5,0,0,0,1,2,-1},{171,0,0,5,0,0,0,1,2,-1},{171,0,0,5,0,0,0,1,2,-1},{171,0,0,5,0,0,0,1,2,-1}},
  {{171,0,0,5,0,0,0,1,2,-1},{171,0,0,5,0,0,0,1,2,-1},{171,0,0,5,0,0,0,1,2,-1},{171,0,0,5,0,0,0,1,2,-1},{171,0,0,5,0,0,0,1,2,-1},{171,0,0,5,0,0,0,1,2,-1},{171,0,0,5,0,0,0,1,2,-1},{171,0,0,5,0,0,0,1,2,-1},{171,0,0,5,0,0,0,1,2,-1},{171,0,0,5,0,0,0,1,2,-1},{171,0,0,5,0,0,0,1,2,-1},{171,0,0,5,0,0,0,1,2,-1},{171,0,0,5,0,0,0,1,2,-1},{171,0,0,5,0,0,0,1,2,-1},{171,0,0,5,0,0,0,1,2,-1},{171,0,0,5,0,0,0,1,2,-1}},
  {{171,0,0,5,0,0,0,1,2,-1},{171,0,0,5,0,0,0,1,2,-1},{171,0,0,5,0,0,0,1,2,-1},{171,0,0,5,0,0,0,1,2,-1},{171,0,0,5,0,0,0,1,2,-1},{171,0,0,5,0,0,0,1,2,-1},{171,0,0,5,0,0,0,1,2,-1},{171,0,0,5,0,0,0,1,2,-1},{171,0,0,5,0,0,0,1,2,-1},{171,0,0,5,0,0,0,1,2,-1},{171,0,0,5,0,0,0,1,2,-1},{171,0,0,5,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{136,0,0,7,0,0,0,1,2,-1},{136,0,0,7,0,0,0,1,2,-1},{136,0,0,7,0,0,0,1,2,-1},{136,0,0,7,0,0,0,1,2,-1},{136,0,0,7,0,0,0,1,2,-1},{136,0,0,7,0,0,0,1,2,-1},{136,0,0,7,0,0,0,1,2,-1},{136,0,0,7,0,0,0,1,2,-1},{136,0,0,7,0,0,0,1,2,-1},{136,0,0,7,0,0,0,1,2,-1},{136,0,0,7,0,0,0,1,2,-1},{136,0,0,7,0,0,0,1,2,-1},{136,0,0,7,0,0,0,1,2,-1},{136,0,0,7,0,0,0,1,2,-1},{136,0,0,7,0,0,0,1,2,-1},{136,0,0,7,0,0,0,1,2,-1}},
  {{136,0,0,7,0,0,0,1,2,-1},{136,0,0,7,0,0,0,1,2,-1},{136,0,0,7,0,0,0,1,2,-1},{136,0,0,7,0,0,0,1,2,-1},{136,0,0,7,0,0,0,1,2,-1},{136,0,0,7,0,0,0,1,2,-1},{136,0,0,7,0,0,0,1,2,-1},{136,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{159,0,0,7,0,0,0,1,2,-1},{159,0,0,7,0,0,0,1,2,-1},{159,0,0,7,0,0,0,1,2,-1},{159,0,0,7,0,0,0,1,2,-1},{159,0,0,7,0,0,0,1,2,-1},{159,0,0,7,0,0,0,1,2,-1},{159,0,0,7,0,0,0,1,2,-1},{159,0,0,7,0,0,0,1,2,-1},{159,0,0,7,0,0,0,1,2,-1},{159,0,0,7,0,0,0,1,2,-1},{159,0,0,7,0,0,0,1,2,-1},{159,0,0,7,0,0,0,1,2,-1},{159,0,0,7,0,0,0,1,2,-1},{159,0,0,7,0,0,0,1,2,-1},{159,0,0,7,0,0,0,1,2,-1},{159,0,0,7,0,0,0,1,2,-1}},
  {{159,0,0,7,0,0,0,1,2,-1},{159,0,0,7,0,0,0,1,2,-1},{159,0,0,7,0,0,0,1,2,-1},{159,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{159,0,0,21,0,0,0,1,2,-1}},
  {{83,0,0,7,0,0,0,1,2,-1},{83,0,0,7,0,0,0,1,2,-1},{83,0,0,7,0,0,0,1,2,-1},{83,0,0,7,0,0,0,1,2,-1},{83,0,0,7,0,0,0,1,2,-1},{83,0,0,7,0,0,0,1,2,-1},{83,0,0,7,0,0,0,1,2,-1},{83,0,0,7,0,0,0,1,2,-1},{83,0,0,7,0,0,0,1,2,-1},{83,0,0,7,0,0,0,1,2,-1},{83,0,0,7,0,0,0,1,2,-1},{83,0,0,7,0,0,0,1,2,-1},{83,0,0,7,0,0,0,1,2,-1},{83,0,0,7,0,0,0,1,2,-1},{83,0,0,7,0,0,0,1,2,-1},{83,0,0,7,0,0,0,1,2,-1}},
  {{83,0,0,7,0,0,0,1,2,-1},{83,0,0,7,0,0,0,1,2,-1},{83,0,0,7,0,0,0,1,2,-1},{83,0,0,7,0,0,0,1,2,-1},{83,0,0,7,0,0,0,1,2,-1},{83,0,0,7,0,0,0,1,2,-1},{83,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{83,0,0,7,0,0,0,1,2,-1},{83,0,0,7,0,0,0,1,2,-1},{83,0,0,7,0,0,0,1,2,-1},{83,0,0,7,0,0,0,1,2,-1},{83,0,0,7,0,0,0,1,2,-1},{83,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{83,0,0,7,0,0,0,1,2,-1},{83,0,0,7,0,0,0,1,2,-1},{83,0,0,7,0,0,0,1,2,-1},{83,0,0,7,0,0,0,1,2,-1},{83,0,0,7,0,0,0,1,2,-1},{83,0,0,7,0,0,0,1,2,-1},{83,0,0,7,0,0,0,1,2,-1},{83,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{47,0,0,7,0,0,1,1,2,-1},{47,0,0,7,0,0,1,1,2,-1},{47,0,0,7,0,0,1,1,2,-1},{47,0,0,7,0,0,1,1,2,-1},{47,0,0,7,0,0,1,1,2,-1},{47,0,0,7,0,0,1,1,2,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{47,0,0,7,0,0,1,1,2,-1},{103,0,0,2,0,0,1,1,0,-1},{47,0,0,7,0,0,1,1,2,-1},{47,0,0,7,0,0,1,1,2,-1},{47,0,0,7,0,0,1,1,2,-1},{47,0,0,7,0,0,1,1,2,-1},{47,0,0,7,0,0,1,1,2,-1},{47,0,0,7,0,0,1,1,2,-1}},
  {{47,0,0,7,0,0,1,1,2,-1},{47,0,0,7,0,0,1,1,2,-1},{47,0,0,7,0,0,1,1,2,-1},{47,0,0,7,0,0,1,1,2,-1},{47,0,0,7,0,0,1,1,2,-1},{47,0,0,7,0,0,1,1,2,-1},{47,0,0,7,0,0,1,1,2,-1},{47,0,0,7,0,0,1,1,2,-1},{47,0,0,7,0,0,1,1,2,-1},{47,0,0,7,0,0,1,1,2,-1},{47,0,0,7,0,0,1,1,2,-1},{47,0,0,7,0,0,1,1,2,-1},{47,0,0,7,0,0,1,1,2,-1},{47,0,0,7,0,0,1,1,2,-1},{47,0,0,7,0,0,1,1,2,-1},{47,0,0,7,0,0,1,1,2,-1}},
  {{47,0,0,7,0,0,1,1,2,-1},{47,0,0,7,0,0,1,1,2,-1},{47,0,0,7,0,0,1,1,2,-1},{47,0,0,7,0,0,1,1,2,-1},{47,0,0,7,0,0,1,1,2,-1},{47,0,0,7,0,0,1,1,2,-1},{103,0,0,2,0,0,1,1,0,-1},{47,0,0,7,0,0,1,1,2,-1},{47,0,0,7,0,0,1,1,2,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{47,0,0,7,0,0,1,1,2,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{47,0,0,7,0,0,1,1,2,-1}},
  {{116,0,0,7,0,0,1,1,2,-1},{116,0,0,7,0,0,1,1,2,-1},{116,0,0,7,0,0,1,1,2,-1},{116,0,0,7,0,0,1,1,2,-1},{116,0,0,7,0,0,1,1,2,-1},{116,0,0,7,0,0,1,1,2,-1},{116,0,0,7,0,0,1,1,2,-1},{116,0,0,7,0,0,1,1,2,-1},{116,0,0,7,0,0,1,1,2,-1},{116,0,0,7,0,0,1,1,2,-1},{116,0,0,7,0,0,1,1,2,-1},{116,0,0,7,0,0,1,1,2,-1},{116,0,0,7,0,0,1,1,2,-1},{116,0,0,7,0,0,1,1,2,-1},{116,0,0,7,0,0,1,1,2,-1},{116,0,0,7,0,0,1,1,2,-1}},
  {{116,0,0,7,0,0,1,1,2,-1},{116,0,0,7,0,0,1,1,2,-1},{116,0,0,7,0,0,1,1,2,-1},{116,0,0,7,0,0,1,1,2,-1},{116,0,0,7,0,0,1,1,2,-1},{116,0,0,7,0,0,1,1,2,-1},{103,0,0,2,0,0,1,1,0,-1},{116,0,0,21,0,0,1,1,4,-1},{116,0,0,15,0,0,1,1,2,-1},{116,0,0,15,0,0,1,1,2,-1},{116,0,0,15,0,0,1,1,2,-1},{116,0,0,15,0,0,1,1,2,-1},{116,0,0,15,0,0,1,1,2,-1},{116,0,0,15,0,0,1,1,2,-1},{116,0,0,15,0,0,1,1,2,-1},{116,0,0,15,0,0,1,1,2,-1}},
  {{144,0,0,7,0,0,1,1,2,-1},{144,0,0,7,0,0,1,1,2,-1},{144,0,0,7,0,0,1,1,2,-1},{144,0,0,7,0,0,1,1,2,-1},{144,0,0,7,0,0,1,1,2,-1},{144,0,0,7,0,0,1,1,2,-1},{144,0,0,7,0,0,1,1,2,-1},{144,0,0,7,0,0,1,1,2,-1},{144,0,0,7,0,0,1,1,2,-1},{144,0,0,7,0,0,1,1,2,-1},{144,0,0,7,0,0,1,1,2,-1},{144,0,0,7,0,0,1,1,2,-1},{144,0,0,7,0,0,1,1,2,-1},{144,0,0,7,0,0,1,1,2,-1},{144,0,0,7,0,0,1,1,2,-1},{144,0,0,7,0,0,1,1,2,-1}},
  {{144,0,0,7,0,0,1,1,2,-1},{144,0,0,7,0,0,1,1,2,-1},{144,0,0,7,0,0,1,1,2,-1},{144,0,0,7,0,0,1,1,2,-1},{144,0,0,7,0,0,1,1,2,-1},{144,0,0,7,0,0,1,1,2,-1},{144,0,0,7,0,0,1,1,2,-1},{144,0,0,26,0,0,1,1,2,-1},{144,0,0,26,0,0,1,1,2,-1},{144,0,0,15,0,0,1,1,2,-1},{144,0,0,15,0,0,1,1,2,-1},{144,0,0,15,0,0,1,1,2,-1},{144,0,0,15,0,0,1,1,2,-1},{144,0,0,15,0,0,1,1,2,-1},{144,0,0,15,0,0,1,1,2,-1},{144,0,0,15,0,0,1,1,2,-1}},
  {{143,0,0,7,0,0,1,1,2,-1},{143,0,0,7,0,0,1,1,2,-1},{143,0,0,7,0,0,1,1,2,-1},{143,0,0,7,0,0,1,1,2,-1},{143,0,0,7,0,0,1,1,2,-1},{143,0,0,7,0,0,1,1,2,-1},{143,0,0,7,0,0,1,1,2,-1},{143,0,0,7,0,0,1,1,2,-1},{143,0,0,7,0,0,1,1,2,-1},{143,0,0,7,0,0,1,1,2,-1},{143,0,0,7,0,0,1,1,2,-1},{143,0,0,7,0,0,1,1,2,-1},{143,0,0,7,0,0,1,1,2,-1},{143,0,0,7,0,0,1,1,2,-1},{143,0,0,7,0,0,1,1,2,-1},{143,0,0,7,0,0,1,1,2,-1}},
  {{143,0,0,7,0,0,1,1,2,-1},{143,0,0,7,0,0,1,1,2,-1},{143,0,0,7,0,0,1,1,2,-1},{143,0,0,7,0,0,1,1,2,-1},{143,0,0,7,0,0,1,1,2,-1},{143,0,0,7,0,0,1,1,2,-1},{143,0,0,7,0,0,1,1,2,-1},{143,0,0,7,0,0,1,1,2,-1},{143,0,0,7,0,0,1,1,2,-1},{143,0,0,7,0,0,1,1,2,-1},{143,0,0,7,0,0,1,1,2,-1},{143,0,0,7,0,0,1,1,2,-1},{143,0,0,7,0,0,1,1,2,-1},{143,0,0,7,0,0,1,1,2,-1},{143,0,0,7,0,0,1,1,2,-1},{103,0,0,2,0,0,1,1,0,-1}},
  {{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{143,0,0,15,0,0,1,1,2,-1},{143,0,0,15,0,0,1,1,2,-1},{143,0,0,15,0,0,1,1,2,-1},{143,0,0,15,0,0,1,1,2,-1},{143,0,0,15,0,0,1,1,2,-1},{143,0,0,15,0,0,1,1,2,-1},{143,0,0,15,0,0,1,1,2,-1},{143,0,0,15,0,0,1,1,2,-1},{143,0,0,15,0,0,1,1,2,-1}},
  {{162,0,0,7,0,0,1,1,2,-1},{162,0,0,7,0,0,1,1,2,-1},{162,0,0,7,0,0,1,1,2,-1},{162,0,0,7,0,0,1,1,2,-1},{162,0,0,7,0,0,1,1,2,-1},{162,0,0,7,0,0,1,1,2,-1},{162,0,0,7,0,0,1,1,2,-1},{162,0,0,7,0,0,1,1,2,-1},{162,0,0,7,0,0,1,1,2,-1},{162,0,0,7,0,0,1,1,2,-1},{162,0,0,7,0,0,1,1,2,-1},{162,0,0,7,0,0,1,1,2,-1},{162,0,0,7,0,0,1,1,2,-1},{162,0,0,7,0,0,1,1,2,-1},{162,0,0,7,0,0,1,1,2,-1},{162,0,0,7,0,0,1,1,2,-1}},
  {{162,0,0,7,0,0,1,1,2,-1},{162,0,0,7,0,0,1,1,2,-1},{162,0,0,7,0,0,1,1,2,-1},{103,0,0,2,0,0,1,1,0,-1},{162,0,0,7,0,0,1,1,2,-1},{162,0,0,7,0,0,1,1,2,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{162,0,0,15,0,0,1,1,2,-1},{162,0,0,15,0,0,1,1,2,-1},{162,0,0,15,0,0,1,1,2,-1},{162,0,0,15,0,0,1,1,2,-1},{162,0,0,15,0,0,1,1,2,-1}},
  {{91,0,0,7,0,0,1,1,2,-1},{91,0,0,7,0,0,1,1,2,-1},{91,0,0,7,0,0,1,1,2,-1},{91,0,0,7,0,0,1,1,2,-1},{91,0,0,7,0,0,1,1,2,-1},{91,0,0,7,0,0,1,1,2,-1},{91,0,0,7,0,0,1,1,2,-1},{91,0,0,7,0,0,1,1,2,-1},{91,0,0,7,0,0,1,1,2,-1},{91,0,0,7,0,0,1,1,2,-1},{91,0,0,7,0,0,1,1,2,-1},{91,0,0,7,0,0,1,1,2,-1},{91,0,0,7,0,0,1,1,2,-1},{91,0,0,7,0,0,1,1,2,-1},{91,0,0,7,0,0,1,1,2,-1},{91,0,0,7,0,0,1,1,2,-1}},
  {{91,0,0,7,0,0,1,1,2,-1},{91,0,0,7,0,0,1,1,2,-1},{91,0,0,7,0,0,1,1,2,-1},{91,0,0,7,0,0,1,1,2,-1},{91,0,0,7,0,0,1,1,2,-1},{91,0,0,7,0,0,1,1,2,-1},{91,0,0,15,0,0,1,1,2,-1},{91,0,0,15,0,0,1,1,2,-1},{91,0,0,15,0,0,1,1,2,-1},{91,0,0,15,0,0,1,1,2,-1},{91,0,0,15,0,0,1,1,2,-1},{91,0,0,15,0,0,1,1,2,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{91,0,0,21,0,0,10,1,4,-1}},
  {{108,0,0,7,0,0,1,1,2,-1},{108,0,0,7,0,0,1,1,2,-1},{108,0,0,7,0,0,1,1,2,-1},{108,0,0,7,0,0,1,1,2,-1},{108,0,0,7,0,0,1,1,2,-1},{108,0,0,7,0,0,1,1,2,-1},{108,0,0,7,0,0,1,1,2,-1},{108,0,0,7,0,0,1,1,2,-1},{108,0,0,7,0,0,1,1,2,-1},{108,0,0,7,0,0,1,1,2,-1},{108,0,0,7,0,0,1,1,2,-1},{108,0,0,7,0,0,1,1,2,-1},{108,0,0,7,0,0,1,1,2,-1},{108,0,0,7,0,0,1,1,2,-1},{108,0,0,7,0,0,1,1,2,-1},{108,0,0,7,0,0,1,1,2,-1}},
  {{108,0,0,7,0,0,1,1,2,-1},{108,0,0,7,0,0,1,1,2,-1},{108,0,0,7,0,0,1,1,2,-1},{108,0,0,7,0,0,1,1,2,-1},{108,0,0,7,0,0,1,1,2,-1},{108,0,0,7,0,0,1,1,2,-1},{108,0,0,7,0,0,1,1,2,-1},{108,0,0,7,0,0,1,1,2,-1},{108,0,0,7,0,0,1,1,2,-1},{108,0,0,7,0,0,1,1,2,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{108,0,0,21,0,0,1,1,2,-1}},
  {{86,0,0,7,0,0,1,0,2,-1},{86,0,0,7,0,0,1,0,2,-1},{86,0,0,7,0,0,1,0,2,-1},{86,0,0,7,0,0,1,0,2,-1},{86,0,0,7,0,0,1,0,2,-1},{86,0,0,7,0,0,1,0,2,-1},{86,0,0,7,0,0,1,0,2,-1},{86,0,0,7,0,0,1,0,2,-1},{86,0,0,7,0,0,1,0,2,-1},{86,0,0,7,0,0,1,0,2,-1},{86,0,0,7,0,0,1,0,2,-1},{86,0,0,7,0,0,1,0,2,-1},{86,0,0,7,0,0,1,0,2,-1},{86,0,0,7,0,0,1,0,2,-1},{86,0,0,7,0,0,1,0,2,-1},{86,0,0,7,0,0,1,0,2,-1}},
  {{141,0,0,7,0,0,1,1,2,-1},{141,0,0,7,0,0,1,1,2,-1},{141,0,0,7,0,0,1,1,2,-1},{141,0,0,7,0,0,1,1,2,-1},{141,0,0,7,0,0,1,1,2,-1},{141,0,0,7,0,0,1,1,2,-1},{141,0,0,7,0,0,1,1,2,-1},{141,0,0,7,0,0,1,1,2,-1},{141,0,0,7,0,0,1,1,2,-1},{141,0,0,7,0,0,1,1,2,-1},{141,0,0,7,0,0,1,1,2,-1},{141,0,0,7,0,0,1,1,2,-1},{141,0,0,7,0,0,1,1,2,-1},{141,0,0,7,0,0,1,1,2,-1},{141,0,0,7,0,0,1,1,2,-1},{141,0,0,7,0,0,1,1,2,-1}},
  {{141,0,0,7,0,0,1,1,2,-1},{141,0,0,7,0,0,1,1,2,-1},{141,0,0,7,0,0,1,1,2,-1},{141,0,0,7,0,0,1,1,2,-1},{141,0,0,7,0,0,1,1,2,-1},{141,0,0,7,0,0,1,1,2,-1},{141,0,0,7,0,0,1,1,2,-1},{141,0,0,7,0,0,1,1,2,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{141,0,0,15,0,0,1,1,2,-1},{141,0,0,15,0,0,1,1,2,-1},{141,0,0,7,0,0,1,1,2,-1},{141,0,0,7,0,0,1,1,2,-1}},
  {{141,0,0,15,0,0,1,1,2,-1},{141,0,0,15,0,0,1,1,2,-1},{141,0,0,15,0,0,1,1,2,-1},{141,0,0,15,0,0,1,1,2,-1},{141,0,0,15,0,0,1,1,2,-1},{141,0,0,15,0,0,1,1,2,-1},{141,0,0,15,0,0,1,1,2,-1},{141,0,0,15,0,0,1,1,2,-1},{141,0,0,15,0,0,1,1,2,-1},{141,0,0,15,0,0,1,1,2,-1},{141,0,0,15,0,0,1,1,2,-1},{141,0,0,15,0,0,1,1,2,-1},{141,0,0,15,0,0,1,1,2,-1},{141,0,0,15,0,0,1,1,2,-1},{141,0,0,15,0,0,1,1,2,-1},{141,0,0,15,0,0,1,1,2,-1}},
  {{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{141,0,0,15,0,0,1,1,2,-1},{141,0,0,15,0,0,1,1,2,-1},{141,0,0,15,0,0,1,1,2,-1},{141,0,0,15,0,0,1,1,2,-1},{141,0,0,15,0,0,1,1,2,-1},{141,0,0,15,0,0,1,1,2,-1},{141,0,0,15,0,0,1,1,2,-1},{141,0,0,15,0,0,1,1,2,-1},{141,0,0,15,0,0,1,1,2,-1},{141,0,0,15,0,0,1,1,2,-1},{141,0,0,15,0,0,1,1,2,-1},{141,0,0,15,0,0,1,1,2,-1},{141,0,0,15,0,0,1,1,2,-1},{141,0,0,15,0,0,1,1,2,-1}},
  {{57,0,0,7,0,0,1,1,2,-1},{57,0,0,12,0,0,17,1,9,-1},{57,0,0,12,0,0,17,1,9,-1},{57,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,1,1,0,-1},{57,0,0,12,0,0,17,1,9,-1},{57,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{57,0,0,12,0,0,17,1,9,-1},{57,0,0,12,0,0,17,1,9,-1},{57,0,0,12,0,0,17,1,9,-1},{57,0,0,12,0,0,17,1,9,-1}},
  {{57,0,0,7,0,0,1,1,2,-1},{57,0,0,7,0,0,1,1,2,-1},{57,0,0,7,0,0,1,1,2,-1},{57,0,0,7,0,0,1,1,2,-1},{103,0,0,2,0,0,1,1,0,-1},{57,0,0,7,0,0,1,1,2,-1},{57,0,0,7,0,0,1,1,2,-1},{57,0,0,7,0,0,1,1,2,-1},{103,0,0,2,0,0,1,1,0,-1},{57,0,0,7,0,0,1,1,2,-1},{57,0,0,7,0,0,1,1,2,-1},{57,0,0,7,0,0,1,1,2,-1},{57,0,0,7,0,0,1,1,2,-1},{57,0,0,7,0,0,1,1,2,-1},{57,0,0,7,0,0,1,1,2,-1},{57,0,0,7,0,0,1,1,2,-1}},
  {{57,0,0,7,0,0,1,1,2,-1},{57,0,0,7,0,0,1,1,2,-1},{57,0,0,7,0,0,1,1,2,-1},{57,0,0,7,0,0,1,1,2,-1},{57,0,0,7,0,0,1,1,2,-1},{57,0,0,7,0,0,1,1,2,-1},{57,0,0,7,0,0,1,1,2,-1},{57,0,0,7,0,0,1,1,2,-1},{57,0,0,7,0,0,1,1,2,-1},{57,0,0,7,0,0,1,1,2,-1},{57,0,0,7,0,0,1,1,2,-1},{57,0,0,7,0,0,1,1,2,-1},{57,0,0,7,0,0,1,1,2,-1},{57,0,0,7,0,0,1,1,2,-1},{57,0,0,7,0,0,1,1,2,-1},{57,0,0,7,0,0,1,1,2,-1}},
  {{57,0,0,7,0,0,1,1,2,-1},{57,0,0,7,0,0,1,1,2,-1},{57,0,0,7,0,0,1,1,2,-1},{57,0,0,7,0,0,1,1,2,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{57,0,0,12,0,0,17,1,9,-1},{57,0,0,12,0,0,17,1,9,-1},{57,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{57,0,0,12,0,0,17,1,9,-1}},
  {{57,0,0,15,0,0,1,1,2,1},{57,0,0,15,0,0,1,1,2,2},{57,0,0,15,0,0,1,1,2,3},{57,0,0,15,0,0,1,1,2,4},{57,0,0,15,0,0,1,1,2,-1},{57,0,0,15,0,0,1,1,2,-1},{57,0,0,15,0,0,1,1,2,-1},{57,0,0,15,0,0,1,1,2,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1}},
  {{57,0,0,21,0,0,1,1,4,-1},{57,0,0,21,0,0,1,1,4,-1},{57,0,0,21,0,0,1,1,4,-1},{57,0,0,21,0,0,1,1,4,-1},{57,0,0,21,0,0,1,1,4,-1},{57,0,0,21,0,0,1,1,4,-1},{57,0,0,21,0,0,1,1,4,-1},{57,0,0,21,0,0,1,1,4,-1},{57,0,0,21,0,0,1,1,2,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1}},
  {{133,0,0,7,0,0,1,1,2,-1},{133,0,0,7,0,0,1,1,2,-1},{133,0,0,7,0,0,1,1,2,-1},{133,0,0,7,0,0,1,1,2,-1},{133,0,0,7,0,0,1,1,2,-1},{133,0,0,7,0,0,1,1,2,-1},{133,0,0,7,0,0,1,1,2,-1},{133,0,0,7,0,0,1,1,2,-1},{133,0,0,7,0,0,1,1,2,-1},{133,0,0,7,0,0,1,1,2,-1},{133,0,0,7,0,0,1,1,2,-1},{133,0,0,7,0,0,1,1,2,-1},{133,0,0,7,0,0,1,1,2,-1},{133,0,0,7,0,0,1,1,2,-1},{133,0,0,7,0,0,1,1,2,-1},{133,0,0,7,0,0,1,1,2,-1}},
  {{133,0,0,7,0,0,1,1,2,-1},{133,0,0,7,0,0,1,1,2,-1},{133,0,0,7,0,0,1,1,2,-1},{133,0,0,7,0,0,1,1,2,-1},{133,0,0,7,0,0,1,1,2,-1},{133,0,0,7,0,0,1,1,2,-1},{133,0,0,7,0,0,1,1,2,-1},{133,0,0,7,0,0,1,1,2,-1},{133,0,0,7,0,0,1,1,2,-1},{133,0,0,7,0,0,1,1,2,-1},{133,0,0,7,0,0,1,1,2,-1},{133,0,0,7,0,0,1,1,2,-1},{133,0,0,7,0,0,1,1,2,-1},{133,0,0,15,0,0,1,1,2,-1},{133,0,0,15,0,0,1,1,2,-1},{133,0,0,21,0,0,1,1,2,-1}},
  {{142,0,0,7,0,0,1,1,2,-1},{142,0,0,7,0,0,1,1,2,-1},{142,0,0,7,0,0,1,1,2,-1},{142,0,0,7,0,0,1,1,2,-1},{142,0,0,7,0,0,1,1,2,-1},{142,0,0,7,0,0,1,1,2,-1},{142,0,0,7,0,0,1,1,2,-1},{142,0,0,7,0,0,1,1,2,-1},{142,0,0,7,0,0,1,1,2,-1},{142,0,0,7,0,0,1,1,2,-1},{142,0,0,7,0,0,1,1,2,-1},{142,0,0,7,0,0,1,1,2,-1},{142,0,0,7,0,0,1,1,2,-1},{142,0,0,7,0,0,1,1,2,-1},{142,0,0,7,0,0,1,1,2,-1},{142,0,0,7,0,0,1,1,2,-1}},
  {{142,0,0,7,0,0,1,1,2,-1},{142,0,0,7,0,0,1,1,2,-1},{142,0,0,7,0,0,1,1,2,-1},{142,0,0,7,0,0,1,1,2,-1},{142,0,0,7,0,0,1,1,2,-1},{142,0,0,7,0,0,1,1,2,-1},{142,0,0,7,0,0,1,1,2,-1},{142,0,0,7,0,0,1,1,2,-1},{142,0,0,7,0,0,1,1,2,-1},{142,0,0,7,0,0,1,1,2,-1},{142,0,0,7,0,0,1,1,2,-1},{142,0,0,7,0,0,1,1,2,-1},{142,0,0,7,0,0,1,1,2,-1},{142,0,0,15,0,0,1,1,2,-1},{142,0,0,15,0,0,1,1,2,-1},{142,0,0,15,0,0,1,1,2,-1}},
  {{121,0,0,7,0,0,1,1,2,-1},{121,0,0,7,0,0,1,1,2,-1},{121,0,0,7,0,0,1,1,2,-1},{121,0,0,7,0,0,1,1,2,-1},{121,0,0,7,0,0,1,1,2,-1},{121,0,0,7,0,0,1,1,2,-1},{121,0,0,7,0,0,1,1,2,-1},{121,0,0,7,0,0,1,1,2,-1},{121,0,0,26,0,0,1,1,2,-1},{121,0,0,7,0,0,1,1,2,-1},{121,0,0,7,0,0,1,1,2,-1},{121,0,0,7,0,0,1,1,2,-1},{121,0,0,7,0,0,1,1,2,-1},{121,0,0,7,0,0,1,1,2,-1},{121,0,0,7,0,0,1,1,2,-1},{121,0,0,7,0,0,1,1,2,-1}},
  {{121,0,0,7,0,0,1,1,2,-1},{121,0,0,7,0,0,1,1,2,-1},{121,0,0,7,0,0,1,1,2,-1},{121,0,0,7,0,0,1,1,2,-1},{121,0,0,7,0,0,1,1,2,-1},{121,0,0,7,0,0,1,1,2,-1},{121,0,0,7,0,0,1,1,2,-1},{121,0,0,7,0,0,1,1,2,-1},{121,0,0,7,0,0,1,1,2,-1},{121,0,0,7,0,0,1,1,2,-1},{121,0,0,7,0,0,1,1,2,-1},{121,0,0,7,0,0,1,1,2,-1},{121,0,0,7,0,0,1,1,2,-1},{121,0,0,7,0,0,1,1,2,-1},{121,0,0,7,0,0,1,1,2,-1},{121,0,0,7,0,0,1,1,2,-1}},
  {{121,0,0,7,0,0,1,1,2,-1},{121,0,0,7,0,0,1,1,2,-1},{121,0,0,7,0,0,1,1,2,-1},{121,0,0,7,0,0,1,1,2,-1},{121,0,0,7,0,0,1,1,2,-1},{121,0,0,12,0,0,17,1,9,-1},{121,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{121,0,0,15,0,0,1,1,2,-1},{121,0,0,15,0,0,1,1,2,-1},{121,0,0,15,0,0,1,1,2,-1},{121,0,0,15,0,0,1,1,2,-1},{121,0,0,15,0,0,1,1,2,-1}},
  {{121,0,0,21,0,0,1,1,4,-1},{121,0,0,21,0,0,1,1,4,-1},{121,0,0,21,0,0,1,1,4,-1},{121,0,0,21,0,0,1,1,4,-1},{121,0,0,21,0,0,1,1,4,-1},{121,0,0,21,0,0,1,1,4,-1},{121,0,0,21,0,0,1,1,15,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1}},
  {{117,0,0,7,0,0,1,1,2,-1},{117,0,0,7,0,0,1,1,2,-1},{117,0,0,7,0,0,1,1,2,-1},{117,0,0,7,0,0,1,1,2,-1},{117,0,0,7,0,0,1,1,2,-1},{117,0,0,7,0,0,1,1,2,-1},{117,0,0,7,0,0,1,1,2,-1},{117,0,0,7,0,0,1,1,2,-1},{117,0,0,7,0,0,1,1,2,-1},{117,0,0,7,0,0,1,1,2,-1},{117,0,0,7,0,0,1,1,2,-1},{117,0,0,7,0,0,1,1,2,-1},{117,0,0,7,0,0,1,1,2,-1},{117,0,0,7,0,0,1,1,2,-1},{117,0,0,7,0,0,1,1,2,-1},{117,0,0,7,0,0,1,1,2,-1}},
  {{117,0,0,7,0,0,1,1,2,-1},{117,0,0,7,0,0,1,1,2,-1},{117,0,0,7,0,0,1,1,2,-1},{117,0,0,7,0,0,1,1,2,-1},{117,0,0,7,0,0,1,1,2,-1},{117,0,0,7,0,0,1,1,2,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{117,0,0,21,0,0,10,1,4,-1},{117,0,0,21,0,0,10,1,4,-1},{117,0,0,21,0,0,10,1,4,-1},{117,0,0,21,0,0,10,1,4,-1},{117,0,0,21,0,0,10,1,4,-1},{117,0,0,21,0,0,10,1,4,-1},{117,0,0,21,0,0,10,1,4,-1}},
  {{125,0,0,7,0,0,1,1,2,-1},{125,0,0,7,0,0,1,1,2,-1},{125,0,0,7,0,0,1,1,2,-1},{125,0,0,7,0,0,1,1,2,-1},{125,0,0,7,0,0,1,1,2,-1},{125,0,0,7,0,0,1,1,2,-1},{125,0,0,7,0,0,1,1,2,-1},{125,0,0,7,0,0,1,1,2,-1},{125,0,0,7,0,0,1,1,2,-1},{125,0,0,7,0,0,1,1,2,-1},{125,0,0,7,0,0,1,1,2,-1},{125,0,0,7,0,0,1,1,2,-1},{125,0,0,7,0,0,1,1,2,-1},{125,0,0,7,0,0,1,1,2,-1},{125,0,0,7,0,0,1,1,2,-1},{125,0,0,7,0,0,1,1,2,-1}},
  {{125,0,0,7,0,0,1,1,2,-1},{125,0,0,7,0,0,1,1,2,-1},{125,0,0,7,0,0,1,1,2,-1},{125,0,0,7,0,0,1,1,2,-1},{125,0,0,7,0,0,1,1,2,-1},{125,0,0,7,0,0,1,1,2,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{125,0,0,15,0,0,1,1,2,-1},{125,0,0,15,0,0,1,1,2,-1},{125,0,0,15,0,0,1,1,2,-1},{125,0,0,15,0,0,1,1,2,-1},{125,0,0,15,0,0,1,1,2,-1},{125,0,0,15,0,0,1,1,2,-1},{125,0,0,15,0,0,1,1,2,-1},{125,0,0,15,0,0,1,1,2,-1}},
  {{122,0,0,7,0,0,1,1,2,-1},{122,0,0,7,0,0,1,1,2,-1},{122,0,0,7,0,0,1,1,2,-1},{122,0,0,7,0,0,1,1,2,-1},{122,0,0,7,0,0,1,1,2,-1},{122,0,0,7,0,0,1,1,2,-1},{122,0,0,7,0,0,1,1,2,-1},{122,0,0,7,0,0,1,1,2,-1},{122,0,0,7,0,0,1,1,2,-1},{122,0,0,7,0,0,1,1,2,-1},{122,0,0,7,0,0,1,1,2,-1},{122,0,0,7,0,0,1,1,2,-1},{122,0,0,7,0,0,1,1,2,-1},{122,0,0,7,0,0,1,1,2,-1},{122,0,0,7,0,0,1,1,2,-1},{122,0,0,7,0,0,1,1,2,-1}},
  {{122,0,0,7,0,0,1,1,2,-1},{122,0,0,7,0,0,1,1,2,-1},{122,0,0,7,0,0,1,1,2,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{122,0,0,15,0,0,1,1,2,-1},{122,0,0,15,0,0,1,1,2,-1},{122,0,0,15,0,0,1,1,2,-1},{122,0,0,15,0,0,1,1,2,-1},{122,0,0,15,0,0,1,1,2,-1},{122,0,0,15,0,0,1,1,2,-1},{122,0,0,15,0,0,1,1,2,-1},{122,0,0,15,0,0,1,1,2,-1}},
  {{123,0,0,7,0,0,1,1,2,-1},{123,0,0,7,0,0,1,1,2,-1},{123,0,0,7,0,0,1,1,2,-1},{123,0,0,7,0,0,1,1,2,-1},{123,0,0,7,0,0,1,1,2,-1},{123,0,0,7,0,0,1,1,2,-1},{123,0,0,7,0,0,1,1,2,-1},{123,0,0,7,0,0,1,1,2,-1},{123,0,0,7,0,0,1,1,2,-1},{123,0,0,7,0,0,1,1,2,-1},{123,0,0,7,0,0,1,1,2,-1},{123,0,0,7,0,0,1,1,2,-1},{123,0,0,7,0,0,1,1,2,-1},{123,0,0,7,0,0,1,1,2,-1},{123,0,0,7,0,0,1,1,2,-1},{123,0,0,7,0,0,1,1,2,-1}},
  {{123,0,0,7,0,0,1,1,2,-1},{123,0,0,7,0,0,1,1,2,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{123,0,0,21,0,0,1,1,2,-1},{123,0,0,21,0,0,1,1,2,-1},{123,0,0,21,0,0,1,1,2,-1},{123,0,0,21,0,0,1,1,2,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1}},
  {{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{123,0,0,15,0,0,1,1,2,-1},{123,0,0,15,0,0,1,1,2,-1},{123,0,0,15,0,0,1,1,2,-1},{123,0,0,15,0,0,1,1,2,-1},{123,0,0,15,0,0,1,1,2,-1},{123,0,0,15,0,0,1,1,2,-1},{123,0,0,15,0,0,1,1,2,-1}},
  {{88,0,0,7,0,0,1,1,2,-1},{88,0,0,7,0,0,1,1,2,-1},{88,0,0,7,0,0,1,1,2,-1},{88,0,0,7,0,0,1,1,2,-1},{88,0,0,7,0,0,1,1,2,-1},{88,0,0,7,0,0,1,1,2,-1},{88,0,0,7,0,0,1,1,2,-1},{88,0,0,7,0,0,1,1,2,-1},{88,0,0,7,0,0,1,1,2,-1},{88,0,0,7,0,0,1,1,2,-1},{88,0,0,7,0,0,1,1,2,-1},{88,0,0,7,0,0,1,1,2,-1},{88,0,0,7,0,0,1,1,2,-1},{88,0,0,7,0,0,1,1,2,-1},{88,0,0,7,0,0,1,1,2,-1},{88,0,0,7,0,0,1,1,2,-1}},
  {{88,0,0,7,0,0,1,1,2,-1},{88,0,0,7,0,0,1,1,2,-1},{88,0,0,7,0,0,1,1,2,-1},{88,0,0,7,0,0,1,1,2,-1},{88,0,0,7,0,0,1,1,2,-1},{88,0,0,7,0,0,1,1,2,-1},{88,0,0,7,0,0,1,1,2,-1},{88,0,0,7,0,0,1,1,2,-1},{88,0,0,7,0,0,1,1,2,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1}},
  {{76,0,0,9,0,0,1,1,2,-1},{76,0,0,9,0,0,1,1,2,-1},{76,0,0,9,0,0,1,1,2,-1},{76,0,0,9,0,0,1,1,2,-1},{76,0,0,9,0,0,1,1,2,-1},{76,0,0,9,0,0,1,1,2,-1},{76,0,0,9,0,0,1,1,2,-1},{76,0,0,9,0,0,1,1,2,-1},{76,0,0,9,0,0,1,1,2,-1},{76,0,0,9,0,0,1,1,2,-1},{76,0,0,9,0,0,1,1,2,-1},{76,0,0,9,0,0,1,1,2,-1},{76,0,0,9,0,0,1,1,2,-1},{76,0,0,9,0,0,1,1,2,-1},{76,0,0,9,0,0,1,1,2,-1},{76,0,0,9,0,0,1,1,2,-1}},
  {{76,0,0,9,0,0,1,1,2,-1},{76,0,0,9,0,0,1,1,2,-1},{76,0,0,9,0,0,1,1,2,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1}},
  {{76,0,0,5,0,0,1,1,2,-1},{76,0,0,5,0,0,1,1,2,-1},{76,0,0,5,0,0,1,1,2,-1},{76,0,0,5,0,0,1,1,2,-1},{76,0,0,5,0,0,1,1,2,-1},{76,0,0,5,0,0,1,1,2,-1},{76,0,0,5,0,0,1,1,2,-1},{76,0,0,5,0,0,1,1,2,-1},{76,0,0,5,0,0,1,1,2,-1},{76,0,0,5,0,0,1,1,2,-1},{76,0,0,5,0,0,1,1,2,-1},{76,0,0,5,0,0,1,1,2,-1},{76,0,0,5,0,0,1,1,2,-1},{76,0,0,5,0,0,1,1,2,-1},{76,0,0,5,0,0,1,1,2,-1},{76,0,0,5,0,0,1,1,2,-1}},
  {{76,0,0,5,0,0,1,1,2,-1},{76,0,0,5,0,0,1,1,2,-1},{76,0,0,5,0,0,1,1,2,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{76,0,0,15,0,0,1,1,2,-1},{76,0,0,15,0,0,1,1,2,-1},{76,0,0,15,0,0,1,1,2,-1},{76,0,0,15,0,0,1,1,2,-1},{76,0,0,15,0,0,1,1,2,-1},{76,0,0,15,0,0,1,1,2,-1}},
  {{2,0,0,15,0,0,5,1,2,1},{2,0,0,15,0,0,5,1,2,2},{2,0,0,15,0,0,5,1,2,3},{2,0,0,15,0,0,5,1,2,4},{2,0,0,15,0,0,5,1,2,5},{2,0,0,15,0,0,5,1,2,6},{2,0,0,15,0,0,5,1,2,7},{2,0,0,15,0,0,5,1,2,8},{2,0,0,15,0,0,5,1,2,9},{2,0,0,15,0,0,5,1,2,-1},{2,0,0,15,0,0,5,1,2,-1},{2,0,0,15,0,0,5,1,2,-1},{2,0,0,15,0,0,5,1,2,-1},{2,0,0,15,0,0,5,1,2,-1},{2,0,0,15,0,0,5,1,2,-1},{2,0,0,15,0,0,5,1,2,-1}},
  {{2,0,0,15,0,0,5,1,2,-1},{2,0,0,15,0,0,5,1,2,-1},{2,0,0,15,0,0,5,1,2,-1},{2,0,0,15,0,0,5,1,2,-1},{2,0,0,15,0,0,5,1,2,-1},{2,0,0,15,0,0,5,1,2,-1},{2,0,0,15,0,0,5,1,2,-1},{2,0,0,15,0,0,5,1,2,-1},{2,0,0,15,0,0,5,1,2,-1},{2,0,0,15,0,0,5,1,2,-1},{2,0,0,15,0,0,5,1,2,-1},{2,0,0,15,0,0,5,1,2,-1},{2,0,0,15,0,0,5,1,2,-1},{2,0,0,15,0,0,5,1,2,-1},{2,0,0,15,0,0,5,1,2,-1},{103,0,0,2,0,0,1,1,0,-1}},
  {{65,0,0,10,0,0,0,1,9,-1},{65,0,0,12,0,0,17,1,9,-1},{65,0,0,10,0,0,0,1,9,-1},{65,0,0,7,0,0,0,1,2,-1},{65,0,0,7,0,0,0,1,2,-1},{65,0,0,7,0,0,0,1,2,-1},{65,0,0,7,0,0,0,1,2,-1},{65,0,0,7,0,0,0,1,2,-1},{65,0,0,7,0,0,0,1,2,-1},{65,0,0,7,0,0,0,1,2,-1},{65,0,0,7,0,0,0,1,2,-1},{65,0,0,7,0,0,0,1,2,-1},{65,0,0,7,0,0,0,1,2,-1},{65,0,0,7,0,0,0,1,2,-1},{65,0,0,7,0,0,0,1,2,-1},{65,0,0,7,0,0,0,1,2,-1}},
  {{65,0,0,7,0,0,0,1,2,-1},{65,0,0,7,0,0,0,1,2,-1},{65,0,0,7,0,0,0,1,2,-1},{65,0,0,7,0,0,0,1,2,-1},{65,0,0,7,0,0,0,1,2,-1},{65,0,0,7,0,0,0,1,2,-1},{65,0,0,7,0,0,0,1,2,-1},{65,0,0,7,0,0,0,1,2,-1},{65,0,0,7,0,0,0,1,2,-1},{65,0,0,7,0,0,0,1,2,-1},{65,0,0,7,0,0,0,1,2,-1},{65,0,0,7,0,0,0,1,2,-1},{65,0,0,7,0,0,0,1,2,-1},{65,0,0,7,0,0,0,1,2,-1},{65,0,0,7,0,0,0,1,2,-1},{65,0,0,7,0,0,0,1,2,-1}},
  {{65,0,0,7,0,0,0,1,2,-1},{65,0,0,7,0,0,0,1,2,-1},{65,0,0,7,0,0,0,1,2,-1},{65,0,0,7,0,0,0,1,2,-1},{65,0,0,7,0,0,0,1,2,-1},{65,0,0,7,0,0,0,1,2,-1},{65,0,0,7,0,0,0,1,2,-1},{65,0,0,7,0,0,0,1,2,-1},{65,0,0,12,0,0,17,1,9,-1},{65,0,0,12,0,0,17,1,9,-1},{65,0,0,12,0,0,17,1,9,-1},{65,0,0,12,0,0,17,1,9,-1},{65,0,0,12,0,0,17,1,9,-1},{65,0,0,12,0,0,17,1,9,-1},{65,0,0,12,0,0,17,1,9,-1},{65,0,0,12,0,0,17,1,9,-1}},
  {{65,0,0,12,0,0,17,1,9,-1},{65,0,0,12,0,0,17,1,9,-1},{65,0,0,12,0,0,17,1,9,-1},{65,0,0,12,0,0,17,1,9,-1},{65,0,0,12,0,0,17,1,9,-1},{65,0,0,12,0,0,17,1,9,-1},{65,0,0,12,0,0,17,1,9,-1},{65,0,0,21,0,0,0,1,4,-1},{65,0,0,21,0,0,0,1,4,-1},{65,0,0,21,0,0,0,1,2,-1},{65,0,0,21,0,0,0,1,2,-1},{65,0,0,21,0,0,0,1,2,-1},{65,0,0,21,0,0,0,1,2,-1},{65,0,0,21,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{65,0,0,15,0,0,10,1,2,1},{65,0,0,15,0,0,10,1,2,2},{65,0,0,15,0,0,10,1,2,3},{65,0,0,15,0,0,10,1,2,4},{65,0,0,15,0,0,10,1,2,5},{65,0,0,15,0,0,10,1,2,6},{65,0,0,15,0,0,10,1,2,7},{65,0,0,15,0,0,10,1,2,8},{65,0,0,15,0,0,10,1,2,9},{65,0,0,15,0,0,10,1,2,-1},{65,0,0,15,0,0,10,1,2,-1},{65,0,0,15,0,0,10,1,2,-1},{65,0,0,15,0,0,10,1,2,-1},{65,0,0,15,0,0,10,1,2,-1}},
  {{65,0,0,15,0,0,10,1,2,-1},{65,0,0,15,0,0,10,1,2,-1},{65,0,0,15,0,0,10,1,2,-1},{65,0,0,15,0,0,10,1,2,-1},{65,0,0,15,0,0,10,1,2,-1},{65,0,0,15,0,0,10,1,2,-1},{65,0,0,13,0,0,0,1,19,0},{65,0,0,13,0,0,0,1,19,1},{65,0,0,13,0,0,0,1,19,2},{65,0,0,13,0,0,0,1,19,3},{65,0,0,13,0,0,0,1,19,4},{65,0,0,13,0,0,0,1,19,5},{65,0,0,13,0,0,0,1,19,6},{65,0,0,13,0,0,0,1,19,7},{65,0,0,13,0,0,0,1,19,8},{65,0,0,13,0,0,0,1,19,9}},
  {{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{65,0,0,12,0,0,17,1,9,-1}},
  {{120,0,0,12,0,0,17,1,9,-1},{120,0,0,12,0,0,17,1,9,-1},{120,0,0,10,0,0,0,1,9,-1},{120,0,0,7,0,0,0,1,2,-1},{120,0,0,7,0,0,0,1,2,-1},{120,0,0,7,0,0,0,1,2,-1},{120,0,0,7,0,0,0,1,2,-1},{120,0,0,7,0,0,0,1,2,-1},{120,0,0,7,0,0,0,1,2,-1},{120,0,0,7,0,0,0,1,2,-1},{120,0,0,7,0,0,0,1,2,-1},{120,0,0,7,0,0,0,1,2,-1},{120,0,0,7,0,0,0,1,2,-1},{120,0,0,7,0,0,0,1,2,-1},{120,0,0,7,0,0,0,1,2,-1},{120,0,0,7,0,0,0,1,2,-1}},
  {{120,0,0,7,0,0,0,1,2,-1},{120,0,0,7,0,0,0,1,2,-1},{120,0,0,7,0,0,0,1,2,-1},{120,0,0,7,0,0,0,1,2,-1},{120,0,0,7,0,0,0,1,2,-1},{120,0,0,7,0,0,0,1,2,-1},{120,0,0,7,0,0,0,1,2,-1},{120,0,0,7,0,0,0,1,2,-1},{120,0,0,7,0,0,0,1,2,-1},{120,0,0,7,0,0,0,1,2,-1},{120,0,0,7,0,0,0,1,2,-1},{120,0,0,7,0,0,0,1,2,-1},{120,0,0,7,0,0,0,1,2,-1},{120,0,0,7,0,0,0,1,2,-1},{120,0,0,7,0,0,0,1,2,-1},{120,0,0,7,0,0,0,1,2,-1}},
  {{120,0,0,10,0,0,0,1,9,-1},{120,0,0,10,0,0,0,1,9,-1},{120,0,0,10,0,0,0,1,9,-1},{120,0,0,12,0,0,17,1,9,-1},{120,0,0,12,0,0,17,1,9,-1},{120,0,0,12,0,0,17,1,9,-1},{120,0,0,12,0,0,17,1,9,-1},{120,0,0,10,0,0,0,1,9,-1},{120,0,0,10,0,0,0,1,9,-1},{120,0,0,12,0,0,17,1,9,-1},{120,0,0,12,0,0,17,1,9,-1},{120,0,0,21,0,0,0,1,2,-1},{120,0,0,21,0,0,0,1,2,-1},{120,0,0,1,0,0,0,1,2,-1},{120,0,0,21,0,0,0,1,4,-1},{120,0,0,21,0,0,0,1,4,-1}},
  {{120,0,0,21,0,0,0,1,4,-1},{120,0,0,21,0,0,0,1,4,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{152,0,0,7,0,0,0,1,2,-1},{152,0,0,7,0,0,0,1,2,-1},{152,0,0,7,0,0,0,1,2,-1},{152,0,0,7,0,0,0,1,2,-1},{152,0,0,7,0,0,0,1,2,-1},{152,0,0,7,0,0,0,1,2,-1},{152,0,0,7,0,0,0,1,2,-1},{152,0,0,7,0,0,0,1,2,-1},{152,0,0,7,0,0,0,1,2,-1},{152,0,0,7,0,0,0,1,2,-1},{152,0,0,7,0,0,0,1,2,-1},{152,0,0,7,0,0,0,1,2,-1},{152,0,0,7,0,0,0,1,2,-1},{152,0,0,7,0,0,0,1,2,-1},{152,0,0,7,0,0,0,1,2,-1},{152,0,0,7,0,0,0,1,2,-1}},
  {{152,0,0,7,0,0,0,1,2,-1},{152,0,0,7,0,0,0,1,2,-1},{152,0,0,7,0,0,0,1,2,-1},{152,0,0,7,0,0,0,1,2,-1},{152,0,0,7,0,0,0,1,2,-1},{152,0,0,7,0,0,0,1,2,-1},{152,0,0,7,0,0,0,1,2,-1},{152,0,0,7,0,0,0,1,2,-1},{152,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{152,0,0,13,0,0,0,1,19,0},{152,0,0,13,0,0,0,1,19,1},{152,0,0,13,0,0,0,1,19,2},{152,0,0,13,0,0,0,1,19,3},{152,0,0,13,0,0,0,1,19,4},{152,0,0,13,0,0,0,1,19,5},{152,0,0,13,0,0,0,1,19,6},{152,0,0,13,0,0,0,1,19,7},{152,0,0,13,0,0,0,1,19,8},{152,0,0,13,0,0,0,1,19,9},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{118,0,0,12,0,0,17,1,9,-1},{118,0,0,12,0,0,17,1,9,-1},{118,0,0,12,0,0,17,1,9,-1},{118,0,0,7,0,0,0,1,2,-1},{118,0,0,7,0,0,0,1,2,-1},{118,0,0,7,0,0,0,1,2,-1},{118,0,0,7,0,0,0,1,2,-1},{118,0,0,7,0,0,0,1,2,-1},{118,0,0,7,0,0,0,1,2,-1},{118,0,0,7,0,0,0,1,2,-1},{118,0,0,7,0,0,0,1,2,-1},{118,0,0,7,0,0,0,1,2,-1},{118,0,0,7,0,0,0,1,2,-1},{118,0,0,7,0,0,0,1,2,-1},{118,0,0,7,0,0,0,1,2,-1},{118,0,0,7,0,0,0,1,2,-1}},
  {{118,0,0,7,0,0,0,1,2,-1},{118,0,0,7,0,0,0,1,2,-1},{118,0,0,7,0,0,0,1,2,-1},{118,0,0,7,0,0,0,1,2,-1},{118,0,0,7,0,0,0,1,2,-1},{118,0,0,7,0,0,0,1,2,-1},{118,0,0,7,0,0,0,1,2,-1},{118,0,0,7,0,0,0,1,2,-1},{118,0,0,7,0,0,0,1,2,-1},{118,0,0,7,0,0,0,1,2,-1},{118,0,0,7,0,0,0,1,2,-1},{118,0,0,7,0,0,0,1,2,-1},{118,0,0,7,0,0,0,1,2,-1},{118,0,0,7,0,0,0,1,2,-1},{118,0,0,7,0,0,0,1,2,-1},{118,0,0,7,0,0,0,1,2,-1}},
  {{118,0,0,7,0,0,0,1,2,-1},{118,0,0,7,0,0,0,1,2,-1},{118,0,0,7,0,0,0,1,2,-1},{118,0,0,7,0,0,0,1,2,-1},{118,0,0,7,0,0,0,1,2,-1},{118,0,0,7,0,0,0,1,2,-1},{118,0,0,7,0,0,0,1,2,-1},{118,0,0,12,0,0,17,1,9,-1},{118,0,0,12,0,0,17,1,9,-1},{118,0,0,12,0,0,17,1,9,-1},{118,0,0,12,0,0,17,1,9,-1},{118,0,0,12,0,0,17,1,9,-1},{118,0,0,10,0,0,0,1,9,-1},{118,0,0,12,0,0,17,1,9,-1},{118,0,0,12,0,0,17,1,9,-1},{118,0,0,12,0,0,17,1,9,-1}},
  {{118,0,0,12,0,0,17,1,9,-1},{118,0,0,12,0,0,17,1,9,-1},{118,0,0,12,0,0,17,1,9,-1},{118,0,0,12,0,0,17,1,9,-1},{118,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{118,0,0,13,0,0,0,1,19,0},{118,0,0,13,0,0,0,1,19,1},{118,0,0,13,0,0,0,1,19,2},{118,0,0,13,0,0,0,1,19,3},{118,0,0,13,0,0,0,1,19,4},{118,0,0,13,0,0,0,1,19,5},{118,0,0,13,0,0,0,1,19,6},{118,0,0,13,0,0,0,1,19,7},{118,0,0,13,0,0,0,1,19,8},{118,0,0,13,0,0,0,1,19,9}},
  {{118,0,0,21,0,0,0,1,4,-1},{118,0,0,21,0,0,0,1,4,-1},{118,0,0,21,0,0,0,1,4,-1},{118,0,0,21,0,0,0,1,4,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{160,0,0,7,0,0,0,1,2,-1},{160,0,0,7,0,0,0,1,2,-1},{160,0,0,7,0,0,0,1,2,-1},{160,0,0,7,0,0,0,1,2,-1},{160,0,0,7,0,0,0,1,2,-1},{160,0,0,7,0,0,0,1,2,-1},{160,0,0,7,0,0,0,1,2,-1},{160,0,0,7,0,0,0,1,2,-1},{160,0,0,7,0,0,0,1,2,-1},{160,0,0,7,0,0,0,1,2,-1},{160,0,0,7,0,0,0,1,2,-1},{160,0,0,7,0,0,0,1,2,-1},{160,0,0,7,0,0,0,1,2,-1},{160,0,0,7,0,0,0,1,2,-1},{160,0,0,7,0,0,0,1,2,-1},{160,0,0,7,0,0,0,1,2,-1}},
  {{160,0,0,7,0,0,0,1,2,-1},{160,0,0,7,0,0,0,1,2,-1},{160,0,0,7,0,0,0,1,2,-1},{160,0,0,12,0,0,17,1,9,-1},{160,0,0,21,0,0,0,1,2,-1},{160,0,0,21,0,0,0,1,5,-1},{160,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{151,0,0,12,0,0,17,1,9,-1},{151,0,0,12,0,0,17,1,9,-1},{151,0,0,10,0,0,0,1,9,-1},{151,0,0,7,0,0,0,1,2,-1},{151,0,0,7,0,0,0,1,2,-1},{151,0,0,7,0,0,0,1,2,-1},{151,0,0,7,0,0,0,1,2,-1},{151,0,0,7,0,0,0,1,2,-1},{151,0,0,7,0,0,0,1,2,-1},{151,0,0,7,0,0,0,1,2,-1},{151,0,0,7,0,0,0,1,2,-1},{151,0,0,7,0,0,0,1,2,-1},{151,0,0,7,0,0,0,1,2,-1},{151,0,0,7,0,0,0,1,2,-1},{151,0,0,7,0,0,0,1,2,-1},{151,0,0,7,0,0,0,1,2,-1}},
  {{151,0,0,7,0,0,0,1,2,-1},{151,0,0,7,0,0,0,1,2,-1},{151,0,0,7,0,0,0,1,2,-1},{151,0,0,7,0,0,0,1,2,-1},{151,0,0,7,0,0,0,1,2,-1},{151,0,0,7,0,0,0,1,2,-1},{151,0,0,7,0,0,0,1,2,-1},{151,0,0,7,0,0,0,1,2,-1},{151,0,0,7,0,0,0,1,2,-1},{151,0,0,7,0,0,0,1,2,-1},{151,0,0,7,0,0,0,1,2,-1},{151,0,0,7,0,0,0,1,2,-1},{151,0,0,7,0,0,0,1,2,-1},{151,0,0,7,0,0,0,1,2,-1},{151,0,0,7,0,0,0,1,2,-1},{151,0,0,7,0,0,0,1,2,-1}},
  {{151,0,0,7,0,0,0,1,2,-1},{151,0,0,7,0,0,0,1,2,-1},{151,0,0,7,0,0,0,1,2,-1},{151,0,0,10,0,0,0,1,9,-1},{151,0,0,10,0,0,0,1,9,-1},{151,0,0,10,0,0,0,1,9,-1},{151,0,0,12,0,0,17,1,9,-1},{151,0,0,12,0,0,17,1,9,-1},{151,0,0,12,0,0,17,1,9,-1},{151,0,0,12,0,0,17,1,9,-1},{151,0,0,12,0,0,17,1,9,-1},{151,0,0,12,0,0,17,1,9,-1},{151,0,0,12,0,0,17,1,9,-1},{151,0,0,12,0,0,17,1,9,-1},{151,0,0,12,0,0,17,1,9,-1},{151,0,0,10,0,0,0,1,9,-1}},
  {{151,0,0,10,0,0,0,1,9,-1},{151,0,0,7,0,0,0,1,2,-1},{151,0,0,7,0,0,0,1,2,-1},{151,0,0,7,0,0,0,1,2,-1},{151,0,0,7,0,0,0,1,2,-1},{151,0,0,21,0,0,0,1,4,-1},{151,0,0,21,0,0,0,1,4,-1},{151,0,0,21,0,0,0,1,2,-1},{151,0,0,21,0,0,0,1,4,-1},{151,0,0,21,0,0,0,1,2,-1},{151,0,0,12,0,0,17,1,9,-1},{151,0,0,12,0,0,17,1,9,-1},{151,0,0,12,0,0,17,1,9,-1},{151,0,0,21,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{151,0,0,13,0,0,0,1,19,0},{151,0,0,13,0,0,0,1,19,1},{151,0,0,13,0,0,0,1,19,2},{151,0,0,13,0,0,0,1,19,3},{151,0,0,13,0,0,0,1,19,4},{151,0,0,13,0,0,0,1,19,5},{151,0,0,13,0,0,0,1,19,6},{151,0,0,13,0,0,0,1,19,7},{151,0,0,13,0,0,0,1,19,8},{151,0,0,13,0,0,0,1,19,9},{151,0,0,7,0,0,0,1,2,-1},{151,0,0,21,0,0,0,1,5,-1},{151,0,0,7,0,0,0,1,2,-1},{151,0,0,21,0,0,0,1,4,-1},{151,0,0,21,0,0,0,1,4,-1},{151,0,0,21,0,0,0,1,4,-1}},
  {{103,0,0,2,0,0,0,1,0,-1},{33,0,0,15,0,0,0,1,2,-1},{33,0,0,15,0,0,0,1,2,-1},{33,0,0,15,0,0,0,1,2,-1},{33,0,0,15,0,0,0,1,2,-1},{33,0,0,15,0,0,0,1,2,-1},{33,0,0,15,0,0,0,1,2,-1},{33,0,0,15,0,0,0,1,2,-1},{33,0,0,15,0,0,0,1,2,-1},{33,0,0,15,0,0,0,1,2,-1},{33,0,0,15,0,0,0,1,2,-1},{33,0,0,15,0,0,0,1,2,-1},{33,0,0,15,0,0,0,1,2,-1},{33,0,0,15,0,0,0,1,2,-1},{33,0,0,15,0,0,0,1,2,-1},{33,0,0,15,0,0,0,1,2,-1}},
  {{33,0,0,15,0,0,0,1,2,-1},{33,0,0,15,0,0,0,1,2,-1},{33,0,0,15,0,0,0,1,2,-1},{33,0,0,15,0,0,0,1,2,-1},{33,0,0,15,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{157,0,0,7,0,0,0,1,2,-1},{157,0,0,7,0,0,0,1,2,-1},{157,0,0,7,0,0,0,1,2,-1},{157,0,0,7,0,0,0,1,2,-1},{157,0,0,7,0,0,0,1,2,-1},{157,0,0,7,0,0,0,1,2,-1},{157,0,0,7,0,0,0,1,2,-1},{157,0,0,7,0,0,0,1,2,-1},{157,0,0,7,0,0,0,1,2,-1},{157,0,0,7,0,0,0,1,2,-1},{157,0,0,7,0,0,0,1,2,-1},{157,0,0,7,0,0,0,1,2,-1},{157,0,0,7,0,0,0,1,2,-1},{157,0,0,7,0,0,0,1,2,-1},{157,0,0,7,0,0,0,1,2,-1},{157,0,0,7,0,0,0,1,2,-1}},
  {{157,0,0,7,0,0,0,1,2,-1},{157,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{157,0,0,7,0,0,0,1,2,-1},{157,0,0,7,0,0,0,1,2,-1},{157,0,0,7,0,0,0,1,2,-1},{157,0,0,7,0,0,0,1,2,-1},{157,0,0,7,0,0,0,1,2,-1},{157,0,0,7,0,0,0,1,2,-1},{157,0,0,7,0,0,0,1,2,-1},{157,0,0,7,0,0,0,1,2,-1},{157,0,0,7,0,0,0,1,2,-1},{157,0,0,7,0,0,0,1,2,-1},{157,0,0,7,0,0,0,1,2,-1},{157,0,0,7,0,0,0,1,2,-1},{157,0,0,7,0,0,0,1,2,-1}},
  {{157,0,0,7,0,0,0,1,2,-1},{157,0,0,7,0,0,0,1,2,-1},{157,0,0,7,0,0,0,1,2,-1},{157,0,0,7,0,0,0,1,2,-1},{157,0,0,7,0,0,0,1,2,-1},{157,0,0,7,0,0,0,1,2,-1},{157,0,0,7,0,0,0,1,2,-1},{157,0,0,7,0,0,0,1,2,-1},{157,0,0,7,0,0,0,1,2,-1},{157,0,0,7,0,0,0,1,2,-1},{157,0,0,7,0,0,0,1,2,-1},{157,0,0,7,0,0,0,1,2,-1},{157,0,0,10,0,0,0,1,9,-1},{157,0,0,10,0,0,0,1,9,-1},{157,0,0,10,0,0,0,1,9,-1},{157,0,0,12,0,0,17,1,9,-1}},
  {{157,0,0,12,0,0,17,1,9,-1},{157,0,0,12,0,0,17,1,9,-1},{157,0,0,10,0,0,0,1,9,-1},{157,0,0,10,0,0,0,1,9,-1},{157,0,0,12,0,0,17,1,9,-1},{157,0,0,10,0,0,0,1,9,-1},{157,0,0,12,0,0,17,1,9,-1},{157,0,0,12,0,0,17,1,9,-1},{157,0,0,21,0,0,0,1,4,-1},{157,0,0,21,0,0,0,1,4,-1},{157,0,0,21,0,0,0,1,2,-1},{157,0,0,21,0,0,0,1,4,-1},{157,0,0,21,0,0,0,1,4,-1},{157,0,0,21,0,0,0,1,2,-1},{157,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{164,0,0,7,0,0,0,1,2,-1},{164,0,0,7,0,0,0,1,2,-1},{164,0,0,7,0,0,0,1,2,-1},{164,0,0,7,0,0,0,1,2,-1},{164,0,0,7,0,0,0,1,2,-1},{164,0,0,7,0,0,0,1,2,-1},{164,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{164,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{164,0,0,7,0,0,0,1,2,-1},{164,0,0,7,0,0,0,1,2,-1},{164,0,0,7,0,0,0,1,2,-1},{164,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{164,0,0,7,0,0,0,1,2,-1}},
  {{164,0,0,7,0,0,0,1,2,-1},{164,0,0,7,0,0,0,1,2,-1},{164,0,0,7,0,0,0,1,2,-1},{164,0,0,7,0,0,0,1,2,-1},{164,0,0,7,0,0,0,1,2,-1},{164,0,0,7,0,0,0,1,2,-1},{164,0,0,7,0,0,0,1,2,-1},{164,0,0,7,0,0,0,1,2,-1},{164,0,0,7,0,0,0,1,2,-1},{164,0,0,7,0,0,0,1,2,-1},{164,0,0,7,0,0,0,1,2,-1},{164,0,0,7,0,0,0,1,2,-1},{164,0,0,7,0,0,0,1,2,-1},{164,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{164,0,0,7,0,0,0,1,2,-1}},
  {{164,0,0,7,0,0,0,1,2,-1},{164,0,0,7,0,0,0,1,2,-1},{164,0,0,7,0,0,0,1,2,-1},{164,0,0,7,0,0,0,1,2,-1},{164,0,0,7,0,0,0,1,2,-1},{164,0,0,7,0,0,0,1,2,-1},{164,0,0,7,0,0,0,1,2,-1},{164,0,0,7,0,0,0,1,2,-1},{164,0,0,7,0,0,0,1,2,-1},{164,0,0,21,0,0,0,1,4,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{145,0,0,7,0,0,0,1,2,-1},{145,0,0,7,0,0,0,1,2,-1},{145,0,0,7,0,0,0,1,2,-1},{145,0,0,7,0,0,0,1,2,-1},{145,0,0,7,0,0,0,1,2,-1},{145,0,0,7,0,0,0,1,2,-1},{145,0,0,7,0,0,0,1,2,-1},{145,0,0,7,0,0,0,1,2,-1},{145,0,0,7,0,0,0,1,2,-1},{145,0,0,7,0,0,0,1,2,-1},{145,0,0,7,0,0,0,1,2,-1},{145,0,0,7,0,0,0,1,2,-1},{145,0,0,7,0,0,0,1,2,-1},{145,0,0,7,0,0,0,1,2,-1},{145,0,0,7,0,0,0,1,2,-1},{145,0,0,7,0,0,0,1,2,-1}},
  {{145,0,0,7,0,0,0,1,2,-1},{145,0,0,7,0,0,0,1,2,-1},{145,0,0,7,0,0,0,1,2,-1},{145,0,0,7,0,0,0,1,2,-1},{145,0,0,7,0,0,0,1,2,-1},{145,0,0,7,0,0,0,1,2,-1},{145,0,0,7,0,0,0,1,2,-1},{145,0,0,7,0,0,0,1,2,-1},{145,0,0,7,0,0,0,1,2,-1},{145,0,0,7,0,0,0,1,2,-1},{145,0,0,7,0,0,0,1,2,-1},{145,0,0,7,0,0,0,1,2,-1},{145,0,0,7,0,0,0,1,2,-1},{145,0,0,7,0,0,0,1,2,-1},{145,0,0,7,0,0,0,1,2,-1},{145,0,0,12,0,0,17,1,9,-1}},
  {{145,0,0,10,0,0,0,1,9,-1},{145,0,0,10,0,0,0,1,9,-1},{145,0,0,10,0,0,0,1,9,-1},{145,0,0,12,0,0,17,1,9,-1},{145,0,0,12,0,0,17,1,9,-1},{145,0,0,12,0,0,17,1,9,-1},{145,0,0,12,0,0,17,1,9,-1},{145,0,0,12,0,0,17,1,9,-1},{145,0,0,12,0,0,17,1,9,-1},{145,0,0,12,0,0,17,1,9,-1},{145,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{145,0,0,13,0,0,0,1,19,0},{145,0,0,13,0,0,0,1,19,1},{145,0,0,13,0,0,0,1,19,2},{145,0,0,13,0,0,0,1,19,3},{145,0,0,13,0,0,0,1,19,4},{145,0,0,13,0,0,0,1,19,5},{145,0,0,13,0,0,0,1,19,6},{145,0,0,13,0,0,0,1,19,7},{145,0,0,13,0,0,0,1,19,8},{145,0,0,13,0,0,0,1,19,9},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{137,0,0,12,0,0,17,1,9,-1},{137,0,0,12,0,0,17,1,9,-1},{137,0,0,10,0,0,0,1,9,-1},{137,0,0,10,0,0,0,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{137,0,0,7,0,0,0,1,2,-1}},
  {{137,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1}},
  {{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1}},
  {{137,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{137,0,0,12,0,0,17,1,9,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,10,0,0,0,1,9,-1},{137,0,0,10,0,0,0,1,9,-1}},
  {{137,0,0,12,0,0,17,1,9,-1},{137,0,0,10,0,0,0,1,9,-1},{137,0,0,10,0,0,0,1,9,-1},{137,0,0,10,0,0,0,1,9,-1},{137,0,0,10,0,0,0,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{137,0,0,10,0,0,0,1,9,-1},{137,0,0,10,0,0,0,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{137,0,0,10,0,0,0,1,9,-1},{137,0,0,10,0,0,0,1,9,-1},{137,0,0,10,0,0,0,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{137,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{137,0,0,10,0,0,0,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1}},
  {{137,0,0,7,0,0,0,1,2,-1},{137,0,0,7,0,0,0,1,2,-1},{137,0,0,10,0,0,0,1,9,-1},{137,0,0,10,0,0,0,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{137,0,0,12,0,0,17,1,9,-1},{137,0,0,12,0,0,17,1,9,-1},{137,0,0,12,0,0,17,1,9,-1},{137,0,0,12,0,0,17,1,9,-1},{137,0,0,12,0,0,17,1,9,-1},{137,0,0,12,0,0,17,1,9,-1},{137,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{137,0,0,12,0,0,17,1,9,-1},{137,0,0,12,0,0,17,1,9,-1},{137,0,0,12,0,0,17,1,9,-1},{137,0,0,12,0,0,17,1,9,-1},{137,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{170,0,0,7,0,0,0,1,2,-1},{170,0,0,7,0,0,0,1,2,-1},{170,0,0,7,0,0,0,1,2,-1},{170,0,0,7,0,0,0,1,2,-1},{170,0,0,7,0,0,0,1,2,-1},{170,0,0,7,0,0,0,1,2,-1},{170,0,0,7,0,0,0,1,2,-1},{170,0,0,7,0,0,0,1,2,-1},{170,0,0,7,0,0,0,1,2,-1},{170,0,0,7,0,0,0,1,2,-1},{170,0,0,7,0,0,0,1,2,-1},{170,0,0,7,0,0,0,1,2,-1},{170,0,0,7,0,0,0,1,2,-1},{170,0,0,7,0,0,0,1,2,-1},{170,0,0,7,0,0,0,1,2,-1},{170,0,0,7,0,0,0,1,2,-1}},
  {{170,0,0,7,0,0,0,1,2,-1},{170,0,0,7,0,0,0,1,2,-1},{170,0,0,7,0,0,0,1,2,-1},{170,0,0,7,0,0,0,1,2,-1},{170,0,0,7,0,0,0,1,2,-1},{170,0,0,10,0,0,0,1,9,-1},{170,0,0,10,0,0,0,1,9,-1},{170,0,0,10,0,0,0,1,9,-1},{170,0,0,12,0,0,17,1,9,-1},{170,0,0,12,0,0,17,1,9,-1},{170,0,0,12,0,0,17,1,9,-1},{170,0,0,12,0,0,17,1,9,-1},{170,0,0,12,0,0,17,1,9,-1},{170,0,0,12,0,0,17,1,9,-1},{170,0,0,12,0,0,17,1,9,-1},{170,0,0,12,0,0,17,1,9,-1}},
  {{170,0,0,10,0,0,0,1,9,-1},{170,0,0,10,0,0,0,1,9,-1},{170,0,0,12,0,0,17,1,9,-1},{170,0,0,12,0,0,17,1,9,-1},{170,0,0,12,0,0,17,1,9,-1},{170,0,0,10,0,0,0,1,9,-1},{170,0,0,12,0,0,17,1,9,-1},{170,0,0,7,0,0,0,1,2,-1},{170,0,0,7,0,0,0,1,2,-1},{170,0,0,7,0,0,0,1,2,-1},{170,0,0,7,0,0,0,1,2,-1},{170,0,0,21,0,0,0,1,4,-1},{170,0,0,21,0,0,0,1,4,-1},{170,0,0,21,0,0,0,1,4,-1},{170,0,0,21,0,0,0,1,4,-1},{170,0,0,21,0,0,0,1,2,-1}},
  {{170,0,0,13,0,0,0,1,19,0},{170,0,0,13,0,0,0,1,19,1},{170,0,0,13,0,0,0,1,19,2},{170,0,0,13,0,0,0,1,19,3},{170,0,0,13,0,0,0,1,19,4},{170,0,0,13,0,0,0,1,19,5},{170,0,0,13,0,0,0,1,19,6},{170,0,0,13,0,0,0,1,19,7},{170,0,0,13,0,0,0,1,19,8},{170,0,0,13,0,0,0,1,19,9},{103,0,0,2,0,0,0,1,0,-1},{170,0,0,21,0,0,0,1,4,-1},{103,0,0,2,0,0,0,1,0,-1},{170,0,0,21,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{158,0,0,7,0,0,0,1,2,-1},{158,0,0,7,0,0,0,1,2,-1},{158,0,0,7,0,0,0,1,2,-1},{158,0,0,7,0,0,0,1,2,-1},{158,0,0,7,0,0,0,1,2,-1},{158,0,0,7,0,0,0,1,2,-1},{158,0,0,7,0,0,0,1,2,-1},{158,0,0,7,0,0,0,1,2,-1},{158,0,0,7,0,0,0,1,2,-1},{158,0,0,7,0,0,0,1,2,-1},{158,0,0,7,0,0,0,1,2,-1},{158,0,0,7,0,0,0,1,2,-1},{158,0,0,7,0,0,0,1,2,-1},{158,0,0,7,0,0,0,1,2,-1},{158,0,0,7,0,0,0,1,2,-1},{158,0,0,7,0,0,0,1,2,-1}},
  {{158,0,0,10,0,0,0,1,9,-1},{158,0,0,10,0,0,0,1,9,-1},{158,0,0,10,0,0,0,1,9,-1},{158,0,0,12,0,0,17,1,9,-1},{158,0,0,12,0,0,17,1,9,-1},{158,0,0,12,0,0,17,1,9,-1},{158,0,0,12,0,0,17,1,9,-1},{158,0,0,12,0,0,17,1,9,-1},{158,0,0,12,0,0,17,1,9,-1},{158,0,0,10,0,0,0,1,9,-1},{158,0,0,12,0,0,17,1,9,-1},{158,0,0,10,0,0,0,1,9,-1},{158,0,0,10,0,0,0,1,9,-1},{158,0,0,10,0,0,0,1,9,-1},{158,0,0,10,0,0,0,1,9,-1},{158,0,0,12,0,0,17,1,9,-1}},
  {{158,0,0,12,0,0,17,1,9,-1},{158,0,0,10,0,0,0,1,9,-1},{158,0,0,12,0,0,17,1,9,-1},{158,0,0,12,0,0,17,1,9,-1},{158,0,0,7,0,0,0,1,2,-1},{158,0,0,7,0,0,0,1,2,-1},{158,0,0,21,0,0,0,1,2,-1},{158,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{158,0,0,13,0,0,0,1,19,0},{158,0,0,13,0,0,0,1,19,1},{158,0,0,13,0,0,0,1,19,2},{158,0,0,13,0,0,0,1,19,3},{158,0,0,13,0,0,0,1,19,4},{158,0,0,13,0,0,0,1,19,5},{158,0,0,13,0,0,0,1,19,6},{158,0,0,13,0,0,0,1,19,7},{158,0,0,13,0,0,0,1,19,8},{158,0,0,13,0,0,0,1,19,9},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{166,0,0,7,0,0,0,0,2,-1},{166,0,0,7,0,0,0,0,2,-1},{166,0,0,7,0,0,0,0,2,-1},{166,0,0,7,0,0,0,0,2,-1},{166,0,0,7,0,0,0,0,2,-1},{166,0,0,7,0,0,0,0,2,-1},{166,0,0,7,0,0,0,0,2,-1},{166,0,0,7,0,0,0,0,2,-1},{166,0,0,7,0,0,0,0,2,-1},{166,0,0,7,0,0,0,0,2,-1},{166,0,0,7,0,0,0,0,2,-1},{166,0,0,7,0,0,0,0,2,-1},{166,0,0,7,0,0,0,0,2,-1},{166,0,0,7,0,0,0,0,2,-1},{166,0,0,7,0,0,0,0,2,-1},{166,0,0,7,0,0,0,0,2,-1}},
  {{166,0,0,7,0,0,0,0,2,-1},{166,0,0,7,0,0,0,0,2,-1},{166,0,0,7,0,0,0,0,2,-1},{166,0,0,7,0,0,0,0,2,-1},{166,0,0,7,0,0,0,0,2,-1},{166,0,0,7,0,0,0,0,2,-1},{166,0,0,7,0,0,0,0,2,-1},{166,0,0,7,0,0,0,0,2,-1},{166,0,0,7,0,0,0,0,2,-1},{166,0,0,7,0,0,0,0,2,-1},{166,0,0,7,0,0,0,0,2,-1},{166,0,0,7,0,0,0,0,2,-1},{166,0,0,7,0,0,0,0,2,-1},{166,0,0,7,0,0,0,0,2,-1},{166,0,0,7,0,0,0,0,2,-1},{166,0,0,10,0,0,0,0,9,-1}},
  {{166,0,0,10,0,0,0,0,9,-1},{166,0,0,10,0,0,0,0,9,-1},{166,0,0,12,0,0,17,0,9,-1},{166,0,0,12,0,0,17,0,9,-1},{166,0,0,12,0,0,17,0,9,-1},{166,0,0,12,0,0,17,0,9,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{166,0,0,10,0,0,0,0,9,-1},{166,0,0,10,0,0,0,0,9,-1},{166,0,0,10,0,0,0,0,9,-1},{166,0,0,10,0,0,0,0,9,-1},{166,0,0,12,0,0,17,0,9,-1},{166,0,0,12,0,0,17,0,9,-1},{166,0,0,10,0,0,0,0,9,-1},{166,0,0,12,0,0,17,0,9,-1}},
  {{166,0,0,12,0,0,17,0,9,-1},{166,0,0,21,0,0,0,0,5,-1},{166,0,0,21,0,0,0,0,4,-1},{166,0,0,21,0,0,0,0,4,-1},{166,0,0,21,0,0,0,0,11,-1},{166,0,0,21,0,0,0,0,11,-1},{166,0,0,21,0,0,0,0,2,-1},{166,0,0,21,0,0,0,0,2,-1},{166,0,0,21,0,0,0,0,2,-1},{166,0,0,21,0,0,0,0,4,-1},{166,0,0,21,0,0,0,0,4,-1},{166,0,0,21,0,0,0,0,4,-1},{166,0,0,21,0,0,0,0,4,-1},{166,0,0,21,0,0,0,0,4,-1},{166,0,0,21,0,0,0,0,4,-1},{166,0,0,21,0,0,0,0,4,-1}},
  {{166,0,0,21,0,0,0,0,4,-1},{166,0,0,21,0,0,0,0,4,-1},{166,0,0,21,0,0,0,0,4,-1},{166,0,0,21,0,0,0,0,4,-1},{166,0,0,21,0,0,0,0,4,-1},{166,0,0,21,0,0,0,0,4,-1},{166,0,0,21,0,0,0,0,4,-1},{166,0,0,21,0,0,0,0,4,-1},{166,0,0,7,0,0,0,0,2,-1},{166,0,0,7,0,0,0,0,2,-1},{166,0,0,7,0,0,0,0,2,-1},{166,0,0,7,0,0,0,0,2,-1},{166,0,0,12,0,0,17,0,9,-1},{166,0,0,12,0,0,17,0,9,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1}},
  {{163,0,0,7,0,0,0,1,2,-1},{163,0,0,7,0,0,0,1,2,-1},{163,0,0,7,0,0,0,1,2,-1},{163,0,0,7,0,0,0,1,2,-1},{163,0,0,7,0,0,0,1,2,-1},{163,0,0,7,0,0,0,1,2,-1},{163,0,0,7,0,0,0,1,2,-1},{163,0,0,7,0,0,0,1,2,-1},{163,0,0,7,0,0,0,1,2,-1},{163,0,0,7,0,0,0,1,2,-1},{163,0,0,7,0,0,0,1,2,-1},{163,0,0,7,0,0,0,1,2,-1},{163,0,0,7,0,0,0,1,2,-1},{163,0,0,7,0,0,0,1,2,-1},{163,0,0,7,0,0,0,1,2,-1},{163,0,0,7,0,0,0,1,2,-1}},
  {{163,0,0,10,0,0,0,1,9,-1},{163,0,0,10,0,0,0,1,9,-1},{163,0,0,10,0,0,0,1,9,-1},{163,0,0,12,0,0,17,1,9,-1},{163,0,0,12,0,0,17,1,9,-1},{163,0,0,12,0,0,17,1,9,-1},{163,0,0,12,0,0,17,1,9,-1},{163,0,0,12,0,0,17,1,9,-1},{163,0,0,12,0,0,17,1,9,-1},{163,0,0,12,0,0,17,1,9,-1},{163,0,0,12,0,0,17,1,9,-1},{163,0,0,10,0,0,0,1,9,-1},{163,0,0,10,0,0,0,1,9,-1},{163,0,0,12,0,0,17,1,9,-1},{163,0,0,10,0,0,0,1,9,-1},{163,0,0,12,0,0,17,1,9,-1}},
  {{163,0,0,12,0,0,17,1,9,-1},{163,0,0,21,0,0,0,1,4,-1},{163,0,0,21,0,0,0,1,4,-1},{163,0,0,21,0,0,0,1,2,-1},{163,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{163,0,0,13,0,0,0,1,19,0},{163,0,0,13,0,0,0,1,19,1},{163,0,0,13,0,0,0,1,19,2},{163,0,0,13,0,0,0,1,19,3},{163,0,0,13,0,0,0,1,19,4},{163,0,0,13,0,0,0,1,19,5},{163,0,0,13,0,0,0,1,19,6},{163,0,0,13,0,0,0,1,19,7},{163,0,0,13,0,0,0,1,19,8},{163,0,0,13,0,0,0,1,19,9},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{27,0,0,21,0,0,10,1,5,-1},{27,0,0,21,0,0,10,1,5,-1},{27,0,0,21,0,0,10,1,5,-1},{27,0,0,21,0,0,10,1,5,-1},{27,0,0,21,0,0,10,1,5,-1},{27,0,0,21,0,0,10,1,5,-1},{27,0,0,21,0,0,10,1,5,-1},{27,0,0,21,0,0,10,1,5,-1},{27,0,0,21,0,0,10,1,5,-1},{27,0,0,21,0,0,10,1,5,-1},{27,0,0,21,0,0,10,1,5,-1},{27,0,0,21,0,0,10,1,5,-1},{27,0,0,21,0,0,10,1,5,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{153,0,0,7,0,0,0,1,2,-1},{153,0,0,7,0,0,0,1,2,-1},{153,0,0,7,0,0,0,1,2,-1},{153,0,0,7,0,0,0,1,2,-1},{153,0,0,7,0,0,0,1,2,-1},{153,0,0,7,0,0,0,1,2,-1},{153,0,0,7,0,0,0,1,2,-1},{153,0,0,7,0,0,0,1,2,-1},{153,0,0,7,0,0,0,1,2,-1},{153,0,0,7,0,0,0,1,2,-1},{153,0,0,7,0,0,0,1,2,-1},{153,0,0,7,0,0,0,1,2,-1},{153,0,0,7,0,0,0,1,2,-1},{153,0,0,7,0,0,0,1,2,-1},{153,0,0,7,0,0,0,1,2,-1},{153,0,0,7,0,0,0,1,2,-1}},
  {{153,0,0,7,0,0,0,1,2,-1},{153,0,0,7,0,0,0,1,2,-1},{153,0,0,7,0,0,0,1,2,-1},{153,0,0,7,0,0,0,1,2,-1},{153,0,0,7,0,0,0,1,2,-1},{153,0,0,7,0,0,0,1,2,-1},{153,0,0,7,0,0,0,1,2,-1},{153,0,0,7,0,0,0,1,2,-1},{153,0,0,7,0,0,0,1,2,-1},{153,0,0,7,0,0,0,1,2,-1},{153,0,0,7,0,0,0,1,2,-1},{153,0,0,12,0,0,17,1,9,-1},{153,0,0,10,0,0,0,1,9,-1},{153,0,0,12,0,0,17,1,9,-1},{153,0,0,10,0,0,0,1,9,-1},{153,0,0,10,0,0,0,1,9,-1}},
  {{153,0,0,12,0,0,17,1,9,-1},{153,0,0,12,0,0,17,1,9,-1},{153,0,0,12,0,0,17,1,9,-1},{153,0,0,12,0,0,17,1,9,-1},{153,0,0,12,0,0,17,1,9,-1},{153,0,0,12,0,0,17,1,9,-1},{153,0,0,10,0,0,0,1,9,-1},{153,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{153,0,0,13,0,0,0,1,19,0},{153,0,0,13,0,0,0,1,19,1},{153,0,0,13,0,0,0,1,19,2},{153,0,0,13,0,0,0,1,19,3},{153,0,0,13,0,0,0,1,19,4},{153,0,0,13,0,0,0,1,19,5},{153,0,0,13,0,0,0,1,19,6},{153,0,0,13,0,0,0,1,19,7},{153,0,0,13,0,0,0,1,19,8},{153,0,0,13,0,0,0,1,19,9},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{161,0,0,7,0,0,0,1,24,-1},{161,0,0,7,0,0,0,1,24,-1},{161,0,0,7,0,0,0,1,24,-1},{161,0,0,7,0,0,0,1,24,-1},{161,0,0,7,0,0,0,1,24,-1},{161,0,0,7,0,0,0,1,24,-1},{161,0,0,7,0,0,0,1,24,-1},{161,0,0,7,0,0,0,1,24,-1},{161,0,0,7,0,0,0,1,24,-1},{161,0,0,7,0,0,0,1,24,-1},{161,0,0,7,0,0,0,1,24,-1},{161,0,0,7,0,0,0,1,24,-1},{161,0,0,7,0,0,0,1,24,-1},{161,0,0,7,0,0,0,1,24,-1},{161,0,0,7,0,0,0,1,24,-1},{161,0,0,7,0,0,0,1,24,-1}},
  {{161,0,0,7,0,0,0,1,24,-1},{161,0,0,7,0,0,0,1,24,-1},{161,0,0,7,0,0,0,1,24,-1},{161,0,0,7,0,0,0,1,24,-1},{161,0,0,7,0,0,0,1,24,-1},{161,0,0,7,0,0,0,1,24,-1},{161,0,0,7,0,0,0,1,24,-1},{161,0,0,7,0,0,0,1,24,-1},{161,0,0,7,0,0,0,1,24,-1},{161,0,0,7,0,0,0,1,24,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{161,0,0,12,0,0,17,1,24,-1},{161,0,0,12,0,0,17,1,24,-1},{161,0,0,12,0,0,17,1,24,-1}},
  {{161,0,0,10,0,0,0,1,24,-1},{161,0,0,10,0,0,0,1,24,-1},{161,0,0,12,0,0,17,1,24,-1},{161,0,0,12,0,0,17,1,24,-1},{161,0,0,12,0,0,17,1,24,-1},{161,0,0,12,0,0,17,1,24,-1},{161,0,0,10,0,0,0,1,24,-1},{161,0,0,12,0,0,17,1,24,-1},{161,0,0,12,0,0,17,1,24,-1},{161,0,0,12,0,0,17,1,24,-1},{161,0,0,12,0,0,17,1,24,-1},{161,0,0,12,0,0,17,1,24,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{161,0,0,13,0,0,0,1,19,0},{161,0,0,13,0,0,0,1,19,1},{161,0,0,13,0,0,0,1,19,2},{161,0,0,13,0,0,0,1,19,3},{161,0,0,13,0,0,0,1,19,4},{161,0,0,13,0,0,0,1,19,5},{161,0,0,13,0,0,0,1,19,6},{161,0,0,13,0,0,0,1,19,7},{161,0,0,13,0,0,0,1,19,8},{161,0,0,13,0,0,0,1,19,9},{161,0,0,15,0,0,0,1,24,-1},{161,0,0,15,0,0,0,1,24,-1},{161,0,0,21,0,0,0,1,4,-1},{161,0,0,21,0,0,0,1,4,-1},{161,0,0,21,0,0,0,1,4,-1},{161,0,0,26,0,0,0,1,24,-1}},
  {{146,0,0,9,0,0,0,1,2,-1},{146,0,0,9,0,0,0,1,2,-1},{146,0,0,9,0,0,0,1,2,-1},{146,0,0,9,0,0,0,1,2,-1},{146,0,0,9,0,0,0,1,2,-1},{146,0,0,9,0,0,0,1,2,-1},{146,0,0,9,0,0,0,1,2,-1},{146,0,0,9,0,0,0,1,2,-1},{146,0,0,9,0,0,0,1,2,-1},{146,0,0,9,0,0,0,1,2,-1},{146,0,0,9,0,0,0,1,2,-1},{146,0,0,9,0,0,0,1,2,-1},{146,0,0,9,0,0,0,1,2,-1},{146,0,0,9,0,0,0,1,2,-1},{146,0,0,9,0,0,0,1,2,-1},{146,0,0,9,0,0,0,1,2,-1}},
  {{146,0,0,5,0,0,0,1,2,-1},{146,0,0,5,0,0,0,1,2,-1},{146,0,0,5,0,0,0,1,2,-1},{146,0,0,5,0,0,0,1,2,-1},{146,0,0,5,0,0,0,1,2,-1},{146,0,0,5,0,0,0,1,2,-1},{146,0,0,5,0,0,0,1,2,-1},{146,0,0,5,0,0,0,1,2,-1},{146,0,0,5,0,0,0,1,2,-1},{146,0,0,5,0,0,0,1,2,-1},{146,0,0,5,0,0,0,1,2,-1},{146,0,0,5,0,0,0,1,2,-1},{146,0,0,5,0,0,0,1,2,-1},{146,0,0,5,0,0,0,1,2,-1},{146,0,0,5,0,0,0,1,2,-1},{146,0,0,5,0,0,0,1,2,-1}},
  {{146,0,0,13,0,0,0,1,19,0},{146,0,0,13,0,0,0,1,19,1},{146,0,0,13,0,0,0,1,19,2},{146,0,0,13,0,0,0,1,19,3},{146,0,0,13,0,0,0,1,19,4},{146,0,0,13,0,0,0,1,19,5},{146,0,0,13,0,0,0,1,19,6},{146,0,0,13,0,0,0,1,19,7},{146,0,0,13,0,0,0,1,19,8},{146,0,0,13,0,0,0,1,19,9},{146,0,0,15,0,0,0,1,2,-1},{146,0,0,15,0,0,0,1,2,-1},{146,0,0,15,0,0,0,1,2,-1},{146,0,0,15,0,0,0,1,2,-1},{146,0,0,15,0,0,0,1,2,-1},{146,0,0,15,0,0,0,1,2,-1}},
  {{146,0,0,15,0,0,0,1,2,-1},{146,0,0,15,0,0,0,1,2,-1},{146,0,0,15,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{146,0,0,7,0,0,0,1,2,-1}},
  {{165,0,0,7,0,0,0,1,2,-1},{165,0,0,7,0,0,0,1,2,-1},{165,0,0,7,0,0,0,1,2,-1},{165,0,0,7,0,0,0,1,2,-1},{165,0,0,7,0,0,0,1,2,-1},{165,0,0,7,0,0,0,1,2,-1},{165,0,0,7,0,0,0,1,2,-1},{165,0,0,7,0,0,0,1,2,-1},{165,0,0,7,0,0,0,1,2,-1},{165,0,0,7,0,0,0,1,2,-1},{165,0,0,7,0,0,0,1,2,-1},{165,0,0,7,0,0,0,1,2,-1},{165,0,0,7,0,0,0,1,2,-1},{165,0,0,7,0,0,0,1,2,-1},{165,0,0,7,0,0,0,1,2,-1},{165,0,0,7,0,0,0,1,2,-1}},
  {{165,0,0,7,0,0,0,1,2,-1},{165,0,0,7,0,0,0,1,2,-1},{165,0,0,7,0,0,0,1,2,-1},{165,0,0,7,0,0,0,1,2,-1},{165,0,0,7,0,0,0,1,2,-1},{165,0,0,7,0,0,0,1,2,-1},{165,0,0,7,0,0,0,1,2,-1},{165,0,0,7,0,0,0,1,2,-1},{165,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1}},
  {{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1}},
  {{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,7,0,0,0,1,2,-1},{168,0,0,10,0,0,0,1,9,-1}},
  {{168,0,0,12,0,0,17,1,9,-1},{168,0,0,12,0,0,17,1,9,-1},{168,0,0,12,0,0,17,1,9,-1},{168,0,0,12,0,0,17,1,9,-1},{168,0,0,12,0,0,17,1,9,-1},{168,0,0,12,0,0,17,1,9,-1},{168,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{168,0,0,12,0,0,17,1,9,-1},{168,0,0,12,0,0,17,1,9,-1},{168,0,0,12,0,0,17,1,9,-1},{168,0,0,12,0,0,17,1,9,-1},{168,0,0,12,0,0,17,1,9,-1},{168,0,0,12,0,0,17,1,9,-1},{168,0,0,10,0,0,0,1,9,-1},{168,0,0,12,0,0,0,1,9,-1}},
  {{168,0,0,7,0,0,0,1,2,-1},{168,0,0,21,0,0,0,1,4,-1},{168,0,0,21,0,0,0,1,4,-1},{168,0,0,21,0,0,0,1,4,-1},{168,0,0,21,0,0,0,1,4,-1},{168,0,0,21,0,0,0,1,4,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{168,0,0,13,0,0,0,1,19,0},{168,0,0,13,0,0,0,1,19,1},{168,0,0,13,0,0,0,1,19,2},{168,0,0,13,0,0,0,1,19,3},{168,0,0,13,0,0,0,1,19,4},{168,0,0,13,0,0,0,1,19,5},{168,0,0,13,0,0,0,1,19,6},{168,0,0,13,0,0,0,1,19,7},{168,0,0,13,0,0,0,1,19,8},{168,0,0,13,0,0,0,1,19,9},{168,0,0,15,0,0,0,1,2,-1},{168,0,0,15,0,0,0,1,2,-1},{168,0,0,15,0,0,0,1,2,-1},{168,0,0,15,0,0,0,1,2,-1},{168,0,0,15,0,0,0,1,2,-1},{168,0,0,15,0,0,0,1,2,-1}},
  {{168,0,0,15,0,0,0,1,2,-1},{168,0,0,15,0,0,0,1,2,-1},{168,0,0,15,0,0,0,1,2,-1},{168,0,0,15,0,0,0,1,2,-1},{168,0,0,15,0,0,0,1,2,-1},{168,0,0,15,0,0,0,1,2,-1},{168,0,0,15,0,0,0,1,2,-1},{168,0,0,15,0,0,0,1,2,-1},{168,0,0,15,0,0,0,1,2,-1},{168,0,0,15,0,0,0,1,2,-1},{168,0,0,15,0,0,0,1,2,-1},{168,0,0,15,0,0,0,1,2,-1},{168,0,0,15,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{169,0,0,21,0,0,0,1,5,-1},{169,0,0,21,0,0,0,1,11,-1},{169,0,0,7,0,0,0,1,2,-1},{169,0,0,7,0,0,0,1,2,-1},{169,0,0,7,0,0,0,1,2,-1},{169,0,0,7,0,0,0,1,2,-1},{169,0,0,7,0,0,0,1,2,-1},{169,0,0,7,0,0,0,1,2,-1},{169,0,0,7,0,0,0,1,2,-1},{169,0,0,7,0,0,0,1,2,-1},{169,0,0,7,0,0,0,1,2,-1},{169,0,0,7,0,0,0,1,2,-1},{169,0,0,7,0,0,0,1,2,-1},{169,0,0,7,0,0,0,1,2,-1},{169,0,0,7,0,0,0,1,2,-1},{169,0,0,7,0,0,0,1,2,-1}},
  {{169,0,0,7,0,0,0,1,2,-1},{169,0,0,7,0,0,0,1,2,-1},{169,0,0,7,0,0,0,1,2,-1},{169,0,0,7,0,0,0,1,2,-1},{169,0,0,7,0,0,0,1,2,-1},{169,0,0,7,0,0,0,1,2,-1},{169,0,0,7,0,0,0,1,2,-1},{169,0,0,7,0,0,0,1,2,-1},{169,0,0,7,0,0,0,1,2,-1},{169,0,0,7,0,0,0,1,2,-1},{169,0,0,7,0,0,0,1,2,-1},{169,0,0,7,0,0,0,1,2,-1},{169,0,0,7,0,0,0,1,2,-1},{169,0,0,7,0,0,0,1,2,-1},{169,0,0,7,0,0,0,1,2,-1},{169,0,0,7,0,0,0,1,2,-1}},
  {{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{169,0,0,12,0,0,17,1,9,-1},{169,0,0,12,0,0,17,1,9,-1},{169,0,0,12,0,0,17,1,9,-1},{169,0,0,12,0,0,17,1,9,-1},{169,0,0,12,0,0,17,1,9,-1},{169,0,0,12,0,0,17,1,9,-1},{169,0,0,12,0,0,17,1,9,-1},{169,0,0,12,0,0,17,1,9,-1},{169,0,0,12,0,0,17,1,9,-1},{169,0,0,12,0,0,17,1,9,-1},{169,0,0,12,0,0,17,1,9,-1},{169,0,0,12,0,0,17,1,9,-1},{169,0,0,12,0,0,17,1,9,-1},{169,0,0,12,0,0,17,1,9,-1}},
  {{169,0,0,12,0,0,17,1,9,-1},{169,0,0,12,0,0,17,1,9,-1},{169,0,0,12,0,0,17,1,9,-1},{169,0,0,12,0,0,17,1,9,-1},{169,0,0,12,0,0,17,1,9,-1},{169,0,0,12,0,0,17,1,9,-1},{169,0,0,12,0,0,17,1,9,-1},{169,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{169,0,0,10,0,0,0,1,9,-1},{169,0,0,12,0,0,17,1,9,-1},{169,0,0,12,0,0,17,1,9,-1},{169,0,0,12,0,0,17,1,9,-1},{169,0,0,12,0,0,17,1,9,-1},{169,0,0,12,0,0,17,1,9,-1},{169,0,0,12,0,0,17,1,9,-1}},
  {{169,0,0,12,0,0,17,1,9,-1},{169,0,0,10,0,0,0,1,9,-1},{169,0,0,12,0,0,17,1,9,-1},{169,0,0,12,0,0,17,1,9,-1},{169,0,0,10,0,0,0,1,9,-1},{169,0,0,12,0,0,17,1,9,-1},{169,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{101,0,0,7,0,0,0,1,2,-1},{101,0,0,7,0,0,0,1,2,-1},{101,0,0,7,0,0,0,1,2,-1},{101,0,0,7,0,0,0,1,2,-1},{101,0,0,7,0,0,0,1,2,-1},{101,0,0,7,0,0,0,1,2,-1},{101,0,0,7,0,0,0,1,2,-1},{101,0,0,7,0,0,0,1,2,-1},{101,0,0,7,0,0,0,1,2,-1},{101,0,0,7,0,0,0,1,2,-1},{101,0,0,7,0,0,0,1,2,-1},{101,0,0,7,0,0,0,1,2,-1},{101,0,0,7,0,0,0,1,2,-1},{101,0,0,7,0,0,0,1,2,-1},{101,0,0,7,0,0,0,1,2,-1},{101,0,0,7,0,0,0,1,2,-1}},
  {{101,0,0,7,0,0,0,1,2,-1},{101,0,0,7,0,0,0,1,2,-1},{101,0,0,7,0,0,0,1,2,-1},{101,0,0,7,0,0,0,1,2,-1},{101,0,0,7,0,0,0,1,2,-1},{101,0,0,7,0,0,0,1,2,-1},{101,0,0,7,0,0,0,1,2,-1},{101,0,0,7,0,0,0,1,2,-1},{101,0,0,7,0,0,0,1,2,-1},{101,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{101,0,0,14,0,0,0,1,2,-1},{101,0,0,14,0,0,0,1,2,-1},{101,0,0,14,0,0,0,1,2,-1},{101,0,0,14,0,0,0,1,2,-1},{101,0,0,14,0,0,0,1,2,-1},{101,0,0,14,0,0,0,1,2,-1},{101,0,0,14,0,0,0,1,2,-1},{101,0,0,14,0,0,0,1,2,-1},{101,0,0,14,0,0,0,1,2,-1},{101,0,0,14,0,0,0,1,2,-1},{101,0,0,14,0,0,0,1,2,-1},{101,0,0,14,0,0,0,1,2,-1},{101,0,0,14,0,0,0,1,2,-1},{101,0,0,14,0,0,0,1,2,-1},{101,0,0,14,0,0,0,1,2,-1},{101,0,0,14,0,0,0,1,2,-1}},
  {{101,0,0,14,0,0,0,1,2,-1},{101,0,0,14,0,0,0,1,2,-1},{101,0,0,14,0,0,0,1,2,-1},{101,0,0,14,0,0,0,1,2,-1},{101,0,0,14,0,0,0,1,2,-1},{101,0,0,14,0,0,0,1,2,-1},{101,0,0,14,0,0,0,1,2,-1},{101,0,0,14,0,0,0,1,2,-1},{101,0,0,14,0,0,0,1,2,-1},{101,0,0,14,0,0,0,1,2,-1},{101,0,0,14,0,0,0,1,2,-1},{101,0,0,14,0,0,0,1,2,-1},{101,0,0,14,0,0,0,1,2,-1},{101,0,0,14,0,0,0,1,2,-1},{101,0,0,14,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{101,0,0,21,0,0,0,1,4,-1},{101,0,0,21,0,0,0,1,4,-1},{101,0,0,21,0,0,0,1,4,-1},{101,0,0,21,0,0,0,1,4,-1},{101,0,0,21,0,0,0,1,4,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{101,0,0,7,0,0,0,1,2,-1},{101,0,0,7,0,0,0,1,2,-1},{101,0,0,7,0,0,0,1,2,-1},{101,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1}},
  {{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,20,-1},{71,0,0,7,0,0,0,0,20,-1},{71,0,0,7,0,0,0,0,20,-1},{71,0,0,7,0,0,0,0,8,-1},{71,0,0,7,0,0,0,0,8,-1},{71,0,0,7,0,0,0,0,8,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1}},
  {{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,8,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,20,-1},{71,0,0,7,0,0,0,0,8,-1},{71,0,0,7,0,0,0,0,20,-1},{71,0,0,7,0,0,0,0,8,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1}},
  {{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,20,-1},{71,0,0,7,0,0,0,0,8,-1},{71,0,0,7,0,0,0,0,8,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1}},
  {{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{71,0,0,7,0,0,0,0,2,-1},{103,0,0,2,0,0,0,0,0,-1}},
  {{156,0,0,7,0,0,0,0,2,-1},{156,0,0,7,0,0,0,0,2,-1},{156,0,0,7,0,0,0,0,2,-1},{156,0,0,7,0,0,0,0,2,-1},{156,0,0,7,0,0,0,0,2,-1},{156,0,0,7,0,0,0,0,2,-1},{156,0,0,7,0,0,0,0,2,-1},{156,0,0,7,0,0,0,0,2,-1},{156,0,0,7,0,0,0,0,2,-1},{156,0,0,7,0,0,0,0,2,-1},{156,0,0,7,0,0,0,0,2,-1},{156,0,0,7,0,0,0,0,2,-1},{156,0,0,7,0,0,0,0,2,-1},{156,0,0,7,0,0,0,0,2,-1},{156,0,0,7,0,0,0,0,2,-1},{156,0,0,7,0,0,0,0,2,-1}},
  {{156,0,0,7,0,0,0,0,2,-1},{156,0,0,7,0,0,0,0,2,-1},{156,0,0,7,0,0,0,0,2,-1},{156,0,0,7,0,0,0,0,2,-1},{156,0,0,7,0,0,0,0,2,-1},{156,0,0,7,0,0,0,0,2,-1},{156,0,0,7,0,0,0,0,2,-1},{156,0,0,7,0,0,0,0,2,-1},{156,0,0,7,0,0,0,0,2,-1},{156,0,0,7,0,0,0,0,2,-1},{156,0,0,7,0,0,0,0,2,-1},{156,0,0,7,0,0,0,0,2,-1},{156,0,0,7,0,0,0,0,2,-1},{156,0,0,7,0,0,0,0,2,-1},{156,0,0,7,0,0,0,0,20,-1},{156,0,0,7,0,0,0,0,8,-1}},
  {{156,0,0,7,0,0,0,0,2,-1},{156,0,0,7,0,0,0,0,2,-1},{156,0,0,7,0,0,0,0,2,-1},{156,0,0,7,0,0,0,0,2,-1},{156,0,0,7,0,0,0,0,2,-1},{156,0,0,7,0,0,0,0,2,-1},{156,0,0,7,0,0,0,0,2,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1}},
  {{130,0,0,7,0,0,0,1,2,-1},{130,0,0,7,0,0,0,1,2,-1},{130,0,0,7,0,0,0,1,2,-1},{130,0,0,7,0,0,0,1,2,-1},{130,0,0,7,0,0,0,1,2,-1},{130,0,0,7,0,0,0,1,2,-1},{130,0,0,7,0,0,0,1,2,-1},{130,0,0,7,0,0,0,1,2,-1},{130,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{149,0,0,7,0,0,0,1,2,-1},{149,0,0,7,0,0,0,1,2,-1},{149,0,0,7,0,0,0,1,2,-1},{149,0,0,7,0,0,0,1,2,-1},{149,0,0,7,0,0,0,1,2,-1},{149,0,0,7,0,0,0,1,2,-1},{149,0,0,7,0,0,0,1,2,-1},{149,0,0,7,0,0,0,1,2,-1},{149,0,0,7,0,0,0,1,2,-1},{149,0,0,7,0,0,0,1,2,-1},{149,0,0,7,0,0,0,1,2,-1},{149,0,0,7,0,0,0,1,2,-1},{149,0,0,7,0,0,0,1,2,-1},{149,0,0,7,0,0,0,1,2,-1},{149,0,0,7,0,0,0,1,2,-1},{149,0,0,7,0,0,0,1,2,-1}},
  {{149,0,0,7,0,0,0,1,2,-1},{149,0,0,7,0,0,0,1,2,-1},{149,0,0,7,0,0,0,1,2,-1},{149,0,0,7,0,0,0,1,2,-1},{149,0,0,7,0,0,0,1,2,-1},{149,0,0,7,0,0,0,1,2,-1},{149,0,0,7,0,0,0,1,2,-1},{149,0,0,7,0,0,0,1,2,-1},{149,0,0,7,0,0,0,1,2,-1},{149,0,0,7,0,0,0,1,2,-1},{149,0,0,7,0,0,0,1,2,-1},{149,0,0,7,0,0,0,1,2,-1},{149,0,0,7,0,0,0,1,2,-1},{149,0,0,7,0,0,0,1,2,-1},{149,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{149,0,0,13,0,0,0,1,19,0},{149,0,0,13,0,0,0,1,19,1},{149,0,0,13,0,0,0,1,19,2},{149,0,0,13,0,0,0,1,19,3},{149,0,0,13,0,0,0,1,19,4},{149,0,0,13,0,0,0,1,19,5},{149,0,0,13,0,0,0,1,19,6},{149,0,0,13,0,0,0,1,19,7},{149,0,0,13,0,0,0,1,19,8},{149,0,0,13,0,0,0,1,19,9},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{149,0,0,21,0,0,0,1,4,-1},{149,0,0,21,0,0,0,1,4,-1}},
  {{134,0,0,7,0,0,0,1,2,-1},{134,0,0,7,0,0,0,1,2,-1},{134,0,0,7,0,0,0,1,2,-1},{134,0,0,7,0,0,0,1,2,-1},{134,0,0,7,0,0,0,1,2,-1},{134,0,0,7,0,0,0,1,2,-1},{134,0,0,7,0,0,0,1,2,-1},{134,0,0,7,0,0,0,1,2,-1},{134,0,0,7,0,0,0,1,2,-1},{134,0,0,7,0,0,0,1,2,-1},{134,0,0,7,0,0,0,1,2,-1},{134,0,0,7,0,0,0,1,2,-1},{134,0,0,7,0,0,0,1,2,-1},{134,0,0,7,0,0,0,1,2,-1},{134,0,0,7,0,0,0,1,2,-1},{134,0,0,7,0,0,0,1,2,-1}},
  {{134,0,0,7,0,0,0,1,2,-1},{134,0,0,7,0,0,0,1,2,-1},{134,0,0,7,0,0,0,1,2,-1},{134,0,0,7,0,0,0,1,2,-1},{134,0,0,7,0,0,0,1,2,-1},{134,0,0,7,0,0,0,1,2,-1},{134,0,0,7,0,0,0,1,2,-1},{134,0,0,7,0,0,0,1,2,-1},{134,0,0,7,0,0,0,1,2,-1},{134,0,0,7,0,0,0,1,2,-1},{134,0,0,7,0,0,0,1,2,-1},{134,0,0,7,0,0,0,1,2,-1},{134,0,0,7,0,0,0,1,2,-1},{134,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{134,0,0,12,0,0,17,1,9,-1},{134,0,0,12,0,0,17,1,9,-1},{134,0,0,12,0,0,17,1,9,-1},{134,0,0,12,0,0,17,1,9,-1},{134,0,0,12,0,0,17,1,9,-1},{134,0,0,21,0,0,0,1,4,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{75,0,0,7,0,0,0,1,2,-1},{75,0,0,7,0,0,0,1,2,-1},{75,0,0,7,0,0,0,1,2,-1},{75,0,0,7,0,0,0,1,2,-1},{75,0,0,7,0,0,0,1,2,-1},{75,0,0,7,0,0,0,1,2,-1},{75,0,0,7,0,0,0,1,2,-1},{75,0,0,7,0,0,0,1,2,-1},{75,0,0,7,0,0,0,1,2,-1},{75,0,0,7,0,0,0,1,2,-1},{75,0,0,7,0,0,0,1,2,-1},{75,0,0,7,0,0,0,1,2,-1},{75,0,0,7,0,0,0,1,2,-1},{75,0,0,7,0,0,0,1,2,-1},{75,0,0,7,0,0,0,1,2,-1},{75,0,0,7,0,0,0,1,2,-1}},
  {{75,0,0,12,0,0,17,1,9,-1},{75,0,0,12,0,0,17,1,9,-1},{75,0,0,12,0,0,17,1,9,-1},{75,0,0,12,0,0,17,1,9,-1},{75,0,0,12,0,0,17,1,9,-1},{75,0,0,12,0,0,17,1,9,-1},{75,0,0,12,0,0,17,1,9,-1},{75,0,0,21,0,0,0,1,4,-1},{75,0,0,21,0,0,0,1,4,-1},{75,0,0,21,0,0,0,1,4,-1},{75,0,0,21,0,0,0,1,2,-1},{75,0,0,21,0,0,0,1,2,-1},{75,0,0,26,0,0,0,1,2,-1},{75,0,0,26,0,0,0,1,2,-1},{75,0,0,26,0,0,0,1,2,-1},{75,0,0,26,0,0,0,1,2,-1}},
  {{75,0,0,6,0,0,0,1,2,-1},{75,0,0,6,0,0,0,1,2,-1},{75,0,0,6,0,0,0,1,2,-1},{75,0,0,6,0,0,0,1,2,-1},{75,0,0,21,0,0,0,1,4,-1},{75,0,0,26,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{75,0,0,13,0,0,0,1,19,0},{75,0,0,13,0,0,0,1,19,1},{75,0,0,13,0,0,0,1,19,2},{75,0,0,13,0,0,0,1,19,3},{75,0,0,13,0,0,0,1,19,4},{75,0,0,13,0,0,0,1,19,5},{75,0,0,13,0,0,0,1,19,6},{75,0,0,13,0,0,0,1,19,7},{75,0,0,13,0,0,0,1,19,8},{75,0,0,13,0,0,0,1,19,9},{103,0,0,2,0,0,0,1,0,-1},{75,0,0,15,0,0,0,1,2,-1},{75,0,0,15,0,0,0,1,2,-1},{75,0,0,15,0,0,0,1,2,-1},{75,0,0,15,0,0,0,1,2,-1},{75,0,0,15,0,0,0,1,2,-1}},
  {{75,0,0,15,0,0,0,1,2,-1},{75,0,0,15,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{75,0,0,7,0,0,0,1,2,-1},{75,0,0,7,0,0,0,1,2,-1},{75,0,0,7,0,0,0,1,2,-1},{75,0,0,7,0,0,0,1,2,-1},{75,0,0,7,0,0,0,1,2,-1},{75,0,0,7,0,0,0,1,2,-1},{75,0,0,7,0,0,0,1,2,-1},{75,0,0,7,0,0,0,1,2,-1},{75,0,0,7,0,0,0,1,2,-1},{75,0,0,7,0,0,0,1,2,-1},{75,0,0,7,0,0,0,1,2,-1},{75,0,0,7,0,0,0,1,2,-1},{75,0,0,7,0,0,0,1,2,-1}},
  {{75,0,0,7,0,0,0,1,2,-1},{75,0,0,7,0,0,0,1,2,-1},{75,0,0,7,0,0,0,1,2,-1},{75,0,0,7,0,0,0,1,2,-1},{75,0,0,7,0,0,0,1,2,-1},{75,0,0,7,0,0,0,1,2,-1},{75,0,0,7,0,0,0,1,2,-1},{75,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{75,0,0,7,0,0,0,1,2,-1},{75,0,0,7,0,0,0,1,2,-1},{75,0,0,7,0,0,0,1,2,-1}},
  {{92,0,0,7,2,0,0,1,2,-1},{92,0,0,7,2,0,0,1,2,-1},{92,0,0,7,2,0,0,1,2,-1},{92,0,0,7,2,0,0,1,2,-1},{92,0,0,7,2,0,0,1,2,-1},{92,0,0,7,2,0,0,1,2,-1},{92,0,0,7,2,0,0,1,2,-1},{92,0,0,7,2,0,0,1,2,-1},{92,0,0,7,2,0,0,1,2,-1},{92,0,0,7,2,0,0,1,2,-1},{92,0,0,7,2,0,0,1,2,-1},{92,0,0,7,2,0,0,1,2,-1},{92,0,0,7,2,0,0,1,2,-1},{92,0,0,7,2,0,0,1,2,-1},{92,0,0,7,2,0,0,1,2,-1},{92,0,0,7,2,0,0,1,2,-1}},
  {{92,0,0,7,2,0,0,1,2,-1},{92,0,0,7,2,0,0,1,2,-1},{92,0,0,7,2,0,0,1,2,-1},{92,0,0,7,2,0,0,1,2,-1},{92,0,0,7,2,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{92,0,0,7,2,0,0,1,2,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1}},
  {{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1}},
  {{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{92,0,0,10,2,0,0,1,9,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{92,0,0,12,2,0,17,1,9,-1}},
  {{92,0,0,12,2,0,17,1,9,-1},{92,0,0,12,2,0,17,1,9,-1},{92,0,0,12,2,0,17,1,9,-1},{92,0,0,6,2,0,0,1,2,-1},{92,0,0,6,2,0,0,1,2,-1},{92,0,0,6,2,0,0,1,2,-1},{92,0,0,6,2,0,0,1,2,-1},{92,0,0,6,2,0,0,1,2,-1},{92,0,0,6,2,0,0,1,2,-1},{92,0,0,6,2,0,0,1,2,-1},{92,0,0,6,2,0,0,1,2,-1},{92,0,0,6,2,0,0,1,2,-1},{92,0,0,6,2,0,0,1,2,-1},{92,0,0,6,2,0,0,1,2,-1},{92,0,0,6,2,0,0,1,2,-1},{92,0,0,6,2,0,0,1,2,-1}},
  {{154,0,1,6,0,0,0,0,18,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1}},
  {{154,0,1,7,0,0,0,0,14,-1},{154,0,1,7,0,0,0,0,14,-1},{154,0,1,7,0,0,0,0,14,-1},{154,0,1,7,0,0,0,0,14,-1},{154,0,1,7,0,0,0,0,14,-1},{154,0,1,7,0,0,0,0,14,-1},{154,0,1,7,0,0,0,0,14,-1},{154,0,1,7,0,0,0,0,14,-1},{154,0,1,7,0,0,0,0,14,-1},{154,0,1,7,0,0,0,0,14,-1},{154,0,1,7,0,0,0,0,14,-1},{154,0,1,7,0,0,0,0,14,-1},{154,0,1,7,0,0,0,0,14,-1},{154,0,1,7,0,0,0,0,14,-1},{154,0,1,7,0,0,0,0,14,-1},{154,0,1,7,0,0,0,0,14,-1}},
  {{154,0,1,7,0,0,0,0,14,-1},{154,0,1,7,0,0,0,0,14,-1},{154,0,1,7,0,0,0,0,14,-1},{154,0,1,7,0,0,0,0,14,-1},{154,0,1,7,0,0,0,0,14,-1},{154,0,1,7,0,0,0,0,14,-1},{154,0,1,7,0,0,0,0,14,-1},{154,0,1,7,0,0,0,0,14,-1},{154,0,1,7,0,0,0,0,14,-1},{154,0,1,7,0,0,0,0,14,-1},{154,0,1,7,0,0,0,0,14,-1},{154,0,1,7,0,0,0,0,14,-1},{154,0,1,7,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1}},
  {{154,0,1,7,0,0,0,0,14,-1},{154,0,1,7,0,0,0,0,14,-1},{154,0,1,7,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1}},
  {{22,0,1,7,0,0,0,0,14,-1},{20,0,1,7,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1}},
  {{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1}},
  {{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{135,0,0,7,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{135,0,0,26,0,0,0,1,2,-1},{135,0,0,12,0,0,17,1,9,-1},{135,0,0,12,0,0,17,1,9,-1},{135,0,0,21,0,0,0,1,4,-1}},
  {{0,0,0,1,0,1,18,1,9,-1},{0,0,0,1,0,1,18,1,9,-1},{0,0,0,1,0,1,18,1,9,-1},{0,0,0,1,0,1,18,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1}},
  {{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1}},
  {{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1}},
  {{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,10,0,0,0,0,9,-1},{0,0,0,10,0,0,0,0,9,-1},{1,0,0,12,0,0,17,0,9,-1},{1,0,0,12,0,0,17,0,9,-1},{1,0,0,12,0,0,17,0,9,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,10,0,0,0,0,9,-1},{0,0,0,10,0,0,0,0,9,-1},{0,0,0,10,0,0,0,0,9,-1}},
  {{0,0,0,10,0,0,0,0,9,-1},{0,0,0,10,0,0,0,0,9,-1},{0,0,0,10,0,0,0,0,9,-1},{0,0,0,1,0,1,18,0,9,-1},{0,0,0,1,0,1,18,0,9,-1},{0,0,0,1,0,1,18,0,9,-1},{0,0,0,1,0,1,18,0,9,-1},{0,0,0,1,0,1,18,0,9,-1},{0,0,0,1,0,1,18,0,9,-1},{0,0,0,1,0,1,18,0,9,-1},{0,0,0,1,0,1,18,0,9,-1},{1,0,0,12,0,0,17,0,9,-1},{1,0,0,12,0,0,17,0,9,-1},{1,0,0,12,0,0,17,0,9,-1},{1,0,0,12,0,0,17,0,9,-1},{1,0,0,12,0,0,17,0,9,-1}},
  {{1,0,0,12,0,0,17,0,9,-1},{1,0,0,12,0,0,17,0,9,-1},{1,0,0,12,0,0,17,0,9,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{1,0,0,12,0,0,17,0,9,-1},{1,0,0,12,0,0,17,0,9,-1},{1,0,0,12,0,0,17,0,9,-1},{1,0,0,12,0,0,17,0,9,-1},{1,0,0,12,0,0,17,0,9,-1},{1,0,0,12,0,0,17,0,9,-1},{1,0,0,12,0,0,17,0,9,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1}},
  {{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{1,0,0,12,0,0,17,0,9,-1},{1,0,0,12,0,0,17,0,9,-1},{1,0,0,12,0,0,17,0,9,-1},{1,0,0,12,0,0,17,0,9,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1}},
  {{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{0,0,0,26,0,0,0,0,2,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1}},
  {{14,0,0,26,0,0,10,1,2,-1},{14,0,0,26,0,0,10,1,2,-1},{14,0,0,26,0,0,10,1,2,-1},{14,0,0,26,0,0,10,1,2,-1},{14,0,0,26,0,0,10,1,2,-1},{14,0,0,26,0,0,10,1,2,-1},{14,0,0,26,0,0,10,1,2,-1},{14,0,0,26,0,0,10,1,2,-1},{14,0,0,26,0,0,10,1,2,-1},{14,0,0,26,0,0,10,1,2,-1},{14,0,0,26,0,0,10,1,2,-1},{14,0,0,26,0,0,10,1,2,-1},{14,0,0,26,0,0,10,1,2,-1},{14,0,0,26,0,0,10,1,2,-1},{14,0,0,26,0,0,10,1,2,-1},{14,0,0,26,0,0,10,1,2,-1}},
  {{14,0,0,26,0,0,10,1,2,-1},{14,0,0,26,0,0,10,1,2,-1},{14,0,0,12,0,0,17,1,9,-1},{14,0,0,12,0,0,17,1,9,-1},{14,0,0,12,0,0,17,1,9,-1},{14,0,0,26,0,0,10,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1}},
  {{0,0,0,15,0,0,0,0,2,-1},{0,0,0,15,0,0,0,0,2,-1},{0,0,0,15,0,0,0,0,2,-1},{0,0,0,15,0,0,0,0,2,-1},{0,0,0,15,0,0,0,0,2,-1},{0,0,0,15,0,0,0,0,2,-1},{0,0,0,15,0,0,0,0,2,-1},{0,0,0,15,0,0,0,0,2,-1},{0,0,0,15,0,0,0,0,2,-1},{0,0,0,15,0,0,0,0,2,-1},{0,0,0,15,0,0,0,0,2,-1},{0,0,0,15,0,0,0,0,2,-1},{0,0,0,15,0,0,0,0,2,-1},{0,0,0,15,0,0,0,0,2,-1},{0,0,0,15,0,0,0,0,2,-1},{0,0,0,15,0,0,0,0,2,-1}},
  {{0,0,0,15,0,0,0,0,2,-1},{0,0,0,15,0,0,0,0,2,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1}},
  {{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1}},
  {{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1}},
  {{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1}},
  {{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1}},
  {{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1}},
  {{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1}},
  {{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1}},
  {{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1}},
  {{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1}},
  {{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{0,0,0,9,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1}},
  {{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{0,0,0,5,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1}},
  {{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1}},
  {{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1}},
  {{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1}},
  {{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{0,0,0,9,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1}},
  {{0,0,0,9,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1}},
  {{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1}},
  {{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1}},
  {{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1}},
  {{0,0,0,9,0,0,0,1,2,-1},{0,0,0,25,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1}},
  {{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1}},
  {{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1}},
  {{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,25,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1}},
  {{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1}},
  {{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,25,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1}},
  {{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,25,0,0,10,1,2,-1}},
  {{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1}},
  {{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,25,0,0,0,1,2,-1}},
  {{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1}},
  {{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,25,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1}},
  {{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,25,0,0,10,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{0,0,0,9,0,0,0,1,2,-1},{0,0,0,5,0,0,0,1,2,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{0,0,0,13,0,0,2,1,19,0},{0,0,0,13,0,0,2,1,19,1}},
  {{0,0,0,13,0,0,2,1,19,2},{0,0,0,13,0,0,2,1,19,3},{0,0,0,13,0,0,2,1,19,4},{0,0,0,13,0,0,2,1,19,5},{0,0,0,13,0,0,2,1,19,6},{0,0,0,13,0,0,2,1,19,7},{0,0,0,13,0,0,2,1,19,8},{0,0,0,13,0,0,2,1,19,9},{0,0,0,13,0,0,2,1,19,0},{0,0,0,13,0,0,2,1,19,1},{0,0,0,13,0,0,2,1,19,2},{0,0,0,13,0,0,2,1,19,3},{0,0,0,13,0,0,2,1,19,4},{0,0,0,13,0,0,2,1,19,5},{0,0,0,13,0,0,2,1,19,6},{0,0,0,13,0,0,2,1,19,7}},
  {{0,0,0,13,0,0,2,1,19,8},{0,0,0,13,0,0,2,1,19,9},{0,0,0,13,0,0,2,1,19,0},{0,0,0,13,0,0,2,1,19,1},{0,0,0,13,0,0,2,1,19,2},{0,0,0,13,0,0,2,1,19,3},{0,0,0,13,0,0,2,1,19,4},{0,0,0,13,0,0,2,1,19,5},{0,0,0,13,0,0,2,1,19,6},{0,0,0,13,0,0,2,1,19,7},{0,0,0,13,0,0,2,1,19,8},{0,0,0,13,0,0,2,1,19,9},{0,0,0,13,0,0,2,1,19,0},{0,0,0,13,0,0,2,1,19,1},{0,0,0,13,0,0,2,1,19,2},{0,0,0,13,0,0,2,1,19,3}},
  {{0,0,0,13,0,0,2,1,19,4},{0,0,0,13,0,0,2,1,19,5},{0,0,0,13,0,0,2,1,19,6},{0,0,0,13,0,0,2,1,19,7},{0,0,0,13,0,0,2,1,19,8},{0,0,0,13,0,0,2,1,19,9},{0,0,0,13,0,0,2,1,19,0},{0,0,0,13,0,0,2,1,19,1},{0,0,0,13,0,0,2,1,19,2},{0,0,0,13,0,0,2,1,19,3},{0,0,0,13,0,0,2,1,19,4},{0,0,0,13,0,0,2,1,19,5},{0,0,0,13,0,0,2,1,19,6},{0,0,0,13,0,0,2,1,19,7},{0,0,0,13,0,0,2,1,19,8},{0,0,0,13,0,0,2,1,19,9}},
  {{112,0,0,26,0,0,0,0,2,-1},{112,0,0,26,0,0,0,0,2,-1},{112,0,0,26,0,0,0,0,2,-1},{112,0,0,26,0,0,0,0,2,-1},{112,0,0,26,0,0,0,0,2,-1},{112,0,0,26,0,0,0,0,2,-1},{112,0,0,26,0,0,0,0,2,-1},{112,0,0,26,0,0,0,0,2,-1},{112,0,0,26,0,0,0,0,2,-1},{112,0,0,26,0,0,0,0,2,-1},{112,0,0,26,0,0,0,0,2,-1},{112,0,0,26,0,0,0,0,2,-1},{112,0,0,26,0,0,0,0,2,-1},{112,0,0,26,0,0,0,0,2,-1},{112,0,0,26,0,0,0,0,2,-1},{112,0,0,26,0,0,0,0,2,-1}},
  {{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1}},
  {{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,26,0,0,0,0,2,-1},{112,0,0,26,0,0,0,0,2,-1},{112,0,0,26,0,0,0,0,2,-1},{112,0,0,26,0,0,0,0,2,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1}},
  {{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,26,0,0,0,0,2,-1},{112,0,0,26,0,0,0,0,2,-1},{112,0,0,26,0,0,0,0,2,-1}},
  {{112,0,0,26,0,0,0,0,2,-1},{112,0,0,26,0,0,0,0,2,-1},{112,0,0,26,0,0,0,0,2,-1},{112,0,0,26,0,0,0,0,2,-1},{112,0,0,26,0,0,0,0,2,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,26,0,0,0,0,2,-1},{112,0,0,26,0,0,0,0,2,-1},{112,0,0,26,0,0,0,0,2,-1},{112,0,0,26,0,0,0,0,2,-1},{112,0,0,26,0,0,0,0,2,-1},{112,0,0,26,0,0,0,0,2,-1},{112,0,0,26,0,0,0,0,2,-1},{112,0,0,26,0,0,0,0,2,-1},{112,0,0,26,0,0,0,0,2,-1},{112,0,0,26,0,0,0,0,2,-1}},
  {{112,0,0,26,0,0,0,0,2,-1},{112,0,0,26,0,0,0,0,2,-1},{112,0,0,26,0,0,0,0,2,-1},{112,0,0,26,0,0,0,0,2,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,26,0,0,0,0,2,-1},{112,0,0,26,0,0,0,0,2,-1},{112,0,0,21,0,0,0,0,4,-1},{112,0,0,21,0,0,0,0,4,-1},{112,0,0,21,0,0,0,0,4,-1},{112,0,0,21,0,0,0,0,4,-1},{112,0,0,21,0,0,0,0,2,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1}},
  {{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{103,0,0,2,0,0,0,0,0,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1}},
  {{103,0,0,2,0,0,0,0,0,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1},{112,0,0,12,0,0,17,0,9,-1}},
  {{56,0,0,12,0,0,17,1,9,-1},{56,0,0,12,0,0,17,1,9,-1},{56,0,0,12,0,0,17,1,9,-1},{56,0,0,12,0,0,17,1,9,-1},{56,0,0,12,0,0,17,1,9,-1},{56,0,0,12,0,0,17,1,9,-1},{56,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{56,0,0,12,0,0,17,1,9,-1},{56,0,0,12,0,0,17,1,9,-1},{56,0,0,12,0,0,17,1,9,-1},{56,0,0,12,0,0,17,1,9,-1},{56,0,0,12,0,0,17,1,9,-1},{56,0,0,12,0,0,17,1,9,-1},{56,0,0,12,0,0,17,1,9,-1},{56,0,0,12,0,0,17,1,9,-1}},
  {{56,0,0,12,0,0,17,1,9,-1},{56,0,0,12,0,0,17,1,9,-1},{56,0,0,12,0,0,17,1,9,-1},{56,0,0,12,0,0,17,1,9,-1},{56,0,0,12,0,0,17,1,9,-1},{56,0,0,12,0,0,17,1,9,-1},{56,0,0,12,0,0,17,1,9,-1},{56,0,0,12,0,0,17,1,9,-1},{56,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{56,0,0,12,0,0,17,1,9,-1},{56,0,0,12,0,0,17,1,9,-1},{56,0,0,12,0,0,17,1,9,-1},{56,0,0,12,0,0,17,1,9,-1},{56,0,0,12,0,0,17,1,9,-1}},
  {{56,0,0,12,0,0,17,1,9,-1},{56,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{56,0,0,12,0,0,17,1,9,-1},{56,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{56,0,0,12,0,0,17,1,9,-1},{56,0,0,12,0,0,17,1,9,-1},{56,0,0,12,0,0,17,1,9,-1},{56,0,0,12,0,0,17,1,9,-1},{56,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{140,0,0,7,0,0,1,1,2,-1},{140,0,0,7,0,0,1,1,2,-1},{140,0,0,7,0,0,1,1,2,-1},{140,0,0,7,0,0,1,1,2,-1},{140,0,0,7,0,0,1,1,2,-1},{140,0,0,7,0,0,1,1,2,-1},{140,0,0,7,0,0,1,1,2,-1},{140,0,0,7,0,0,1,1,2,-1},{140,0,0,7,0,0,1,1,2,-1},{140,0,0,7,0,0,1,1,2,-1},{140,0,0,7,0,0,1,1,2,-1},{140,0,0,7,0,0,1,1,2,-1},{140,0,0,7,0,0,1,1,2,-1},{140,0,0,7,0,0,1,1,2,-1},{140,0,0,7,0,0,1,1,2,-1},{140,0,0,7,0,0,1,1,2,-1}},
  {{140,0,0,7,0,0,1,1,2,-1},{140,0,0,7,0,0,1,1,2,-1},{140,0,0,7,0,0,1,1,2,-1},{140,0,0,7,0,0,1,1,2,-1},{140,0,0,7,0,0,1,1,2,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{140,0,0,15,0,0,1,1,2,-1},{140,0,0,15,0,0,1,1,2,-1},{140,0,0,15,0,0,1,1,2,-1},{140,0,0,15,0,0,1,1,2,-1},{140,0,0,15,0,0,1,1,2,-1},{140,0,0,15,0,0,1,1,2,-1},{140,0,0,15,0,0,1,1,2,-1},{140,0,0,15,0,0,1,1,2,-1},{140,0,0,15,0,0,1,1,2,-1}},
  {{140,0,0,12,0,0,17,1,9,-1},{140,0,0,12,0,0,17,1,9,-1},{140,0,0,12,0,0,17,1,9,-1},{140,0,0,12,0,0,17,1,9,-1},{140,0,0,12,0,0,17,1,9,-1},{140,0,0,12,0,0,17,1,9,-1},{140,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1}},
  {{167,0,0,9,0,0,1,1,2,-1},{167,0,0,9,0,0,1,1,2,-1},{167,0,0,9,0,0,1,1,2,-1},{167,0,0,9,0,0,1,1,2,-1},{167,0,0,9,0,0,1,1,2,-1},{167,0,0,9,0,0,1,1,2,-1},{167,0,0,9,0,0,1,1,2,-1},{167,0,0,9,0,0,1,1,2,-1},{167,0,0,9,0,0,1,1,2,-1},{167,0,0,9,0,0,1,1,2,-1},{167,0,0,9,0,0,1,1,2,-1},{167,0,0,9,0,0,1,1,2,-1},{167,0,0,9,0,0,1,1,2,-1},{167,0,0,9,0,0,1,1,2,-1},{167,0,0,9,0,0,1,1,2,-1},{167,0,0,9,0,0,1,1,2,-1}},
  {{167,0,0,9,0,0,1,1,2,-1},{167,0,0,9,0,0,1,1,2,-1},{167,0,0,5,0,0,1,1,2,-1},{167,0,0,5,0,0,1,1,2,-1},{167,0,0,5,0,0,1,1,2,-1},{167,0,0,5,0,0,1,1,2,-1},{167,0,0,5,0,0,1,1,2,-1},{167,0,0,5,0,0,1,1,2,-1},{167,0,0,5,0,0,1,1,2,-1},{167,0,0,5,0,0,1,1,2,-1},{167,0,0,5,0,0,1,1,2,-1},{167,0,0,5,0,0,1,1,2,-1},{167,0,0,5,0,0,1,1,2,-1},{167,0,0,5,0,0,1,1,2,-1},{167,0,0,5,0,0,1,1,2,-1},{167,0,0,5,0,0,1,1,2,-1}},
  {{167,0,0,5,0,0,1,1,2,-1},{167,0,0,5,0,0,1,1,2,-1},{167,0,0,5,0,0,1,1,2,-1},{167,0,0,5,0,0,1,1,2,-1},{167,0,0,5,0,0,1,1,2,-1},{167,0,0,5,0,0,1,1,2,-1},{167,0,0,5,0,0,1,1,2,-1},{167,0,0,5,0,0,1,1,2,-1},{167,0,0,5,0,0,1,1,2,-1},{167,0,0,5,0,0,1,1,2,-1},{167,0,0,5,0,0,1,1,2,-1},{167,0,0,5,0,0,1,1,2,-1},{167,0,0,5,0,0,1,1,2,-1},{167,0,0,5,0,0,1,1,2,-1},{167,0,0,5,0,0,1,1,2,-1},{167,0,0,5,0,0,1,1,2,-1}},
  {{167,0,0,5,0,0,1,1,2,-1},{167,0,0,5,0,0,1,1,2,-1},{167,0,0,5,0,0,1,1,2,-1},{167,0,0,5,0,0,1,1,2,-1},{167,0,0,12,0,0,17,1,9,-1},{167,0,0,12,0,0,17,1,9,-1},{167,0,0,12,0,0,17,1,9,-1},{167,0,0,12,0,0,17,1,9,-1},{167,0,0,12,0,0,17,1,9,-1},{167,0,0,12,0,0,17,1,9,-1},{167,0,0,12,0,0,17,1,9,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1}},
  {{167,0,0,13,0,0,1,1,19,0},{167,0,0,13,0,0,1,1,19,1},{167,0,0,13,0,0,1,1,19,2},{167,0,0,13,0,0,1,1,19,3},{167,0,0,13,0,0,1,1,19,4},{167,0,0,13,0,0,1,1,19,5},{167,0,0,13,0,0,1,1,19,6},{167,0,0,13,0,0,1,1,19,7},{167,0,0,13,0,0,1,1,19,8},{167,0,0,13,0,0,1,1,19,9},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{103,0,0,2,0,0,1,1,0,-1},{167,0,0,21,0,0,1,1,20,-1},{167,0,0,21,0,0,1,1,20,-1}},
  {{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{103,0,0,2,0,0,13,1,0,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1}},
  {{103,0,0,2,0,0,13,1,0,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{103,0,0,2,0,0,13,1,0,-1},{2,0,0,7,0,0,13,1,2,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{2,0,0,7,0,0,13,1,2,-1},{103,0,0,2,0,0,13,1,0,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1}},
  {{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{103,0,0,2,0,0,13,1,0,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{103,0,0,2,0,0,13,1,0,-1},{2,0,0,7,0,0,13,1,2,-1},{103,0,0,2,0,0,13,1,0,-1},{2,0,0,7,0,0,13,1,2,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1}},
  {{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{2,0,0,7,0,0,13,1,2,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{2,0,0,7,0,0,13,1,2,-1},{103,0,0,2,0,0,13,1,0,-1},{2,0,0,7,0,0,13,1,2,-1},{103,0,0,2,0,0,13,1,0,-1},{2,0,0,7,0,0,13,1,2,-1},{103,0,0,2,0,0,13,1,0,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1}},
  {{103,0,0,2,0,0,13,1,0,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{103,0,0,2,0,0,13,1,0,-1},{2,0,0,7,0,0,13,1,2,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{2,0,0,7,0,0,13,1,2,-1},{103,0,0,2,0,0,13,1,0,-1},{2,0,0,7,0,0,13,1,2,-1},{103,0,0,2,0,0,13,1,0,-1},{2,0,0,7,0,0,13,1,2,-1},{103,0,0,2,0,0,13,1,0,-1},{2,0,0,7,0,0,13,1,2,-1},{103,0,0,2,0,0,13,1,0,-1},{2,0,0,7,0,0,13,1,2,-1}},
  {{103,0,0,2,0,0,13,1,0,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{103,0,0,2,0,0,13,1,0,-1},{2,0,0,7,0,0,13,1,2,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{103,0,0,2,0,0,13,1,0,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1}},
  {{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{103,0,0,2,0,0,13,1,0,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{103,0,0,2,0,0,13,1,0,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{103,0,0,2,0,0,13,1,0,-1},{2,0,0,7,0,0,13,1,2,-1},{103,0,0,2,0,0,13,1,0,-1}},
  {{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{103,0,0,2,0,0,13,1,0,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1}},
  {{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1}},
  {{103,0,0,2,0,0,13,1,0,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{103,0,0,2,0,0,13,1,0,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{103,0,0,2,0,0,13,1,0,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1},{2,0,0,7,0,0,13,1,2,-1}},
  {{2,0,0,25,0,0,10,1,2,-1},{2,0,0,25,0,0,10,1,2,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1},{103,0,0,2,0,0,13,1,0,-1}},
  {{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1}},
  {{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1}},
  {{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1}},
  {{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1}},
  {{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{103,0,0,2,0,0,0,0,14,-1}},
  {{103,0,0,2,0,0,0,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1}},
  {{103,0,0,2,0,0,0,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1}},
  {{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1}},
  {{0,0,0,15,0,0,2,0,1,0},{0,0,0,15,0,0,2,0,1,0},{0,0,0,15,0,0,2,0,1,1},{0,0,0,15,0,0,2,0,1,2},{0,0,0,15,0,0,2,0,1,3},{0,0,0,15,0,0,2,0,1,4},{0,0,0,15,0,0,2,0,1,5},{0,0,0,15,0,0,2,0,1,6},{0,0,0,15,0,0,2,0,1,7},{0,0,0,15,0,0,2,0,1,8},{0,0,0,15,0,0,2,0,1,9},{0,0,0,15,0,0,10,0,1,-1},{0,0,0,15,0,0,10,0,1,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1}},
  {{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,2,-1},{103,0,0,2,0,0,0,0,14,-1}},
  {{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1}},
  {{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,1,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1}},
  {{0,0,0,26,0,0,0,0,1,-1},{0,0,1,26,0,0,0,0,1,-1},{0,0,1,26,0,0,0,0,1,-1},{0,0,1,26,0,0,0,0,1,-1},{0,0,1,26,0,0,0,0,1,-1},{0,0,1,26,0,0,0,0,1,-1},{0,0,1,26,0,0,0,0,1,-1},{0,0,1,26,0,0,0,0,1,-1},{0,0,1,26,0,0,0,0,1,-1},{0,0,1,26,0,0,0,0,1,-1},{0,0,1,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1}},
  {{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{0,0,0,26,0,0,0,0,1,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1}},
  {{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1}},
  {{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{0,0,0,26,0,0,0,0,39,-1},{0,0,0,26,0,0,0,0,39,-1},{0,0,0,26,0,0,0,0,39,-1},{0,0,0,26,0,0,0,0,39,-1},{0,0,0,26,0,0,0,0,39,-1},{0,0,0,26,0,0,0,0,39,-1},{0,0,0,26,0,0,0,0,39,-1},{0,0,0,26,0,0,0,0,39,-1},{0,0,0,26,0,0,0,0,39,-1},{0,0,0,26,0,0,0,0,39,-1}},
  {{0,0,0,26,0,0,0,0,39,-1},{0,0,0,26,0,0,0,0,39,-1},{0,0,0,26,0,0,0,0,39,-1},{0,0,0,26,0,0,0,0,39,-1},{0,0,0,26,0,0,0,0,39,-1},{0,0,0,26,0,0,0,0,39,-1},{0,0,0,26,0,0,0,0,39,-1},{0,0,0,26,0,0,0,0,39,-1},{0,0,0,26,0,0,0,0,39,-1},{0,0,0,26,0,0,0,0,39,-1},{0,0,0,26,0,0,0,0,39,-1},{0,0,0,26,0,0,0,0,39,-1},{0,0,0,26,0,0,0,0,39,-1},{0,0,0,26,0,0,0,0,39,-1},{0,0,0,26,0,0,0,0,39,-1},{0,0,0,26,0,0,0,0,39,-1}},
  {{20,0,1,26,0,0,0,2,14,-1},{0,0,1,26,0,0,0,2,14,-1},{0,0,1,26,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1}},
  {{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1}},
  {{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1}},
  {{0,0,1,26,0,0,0,0,14,-1},{0,0,1,26,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1}},
  {{0,0,1,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1}},
  {{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1}},
  {{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1}},
  {{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1}},
  {{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1}},
  {{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1}},
  {{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,0,26,0,0,10,0,40,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1}},
  {{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1}},
  {{0,0,1,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,24,0,0,10,0,41,-1},{0,0,1,24,0,0,10,0,41,-1},{0,0,1,24,0,0,10,0,41,-1},{0,0,1,24,0,0,10,0,41,-1},{0,0,1,24,0,0,10,0,41,-1}},
  {{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1}},
  {{0,0,1,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1}},
  {{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1}},
  {{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,14,-1}},
  {{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1}},
  {{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1}},
  {{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,2,-1}},
  {{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1}},
  {{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1}},
  {{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1}},
  {{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1}},
  {{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1}},
  {{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,1,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1}},
  {{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1}},
  {{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1}},
  {{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,40,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1}},
  {{0,0,0,26,0,0,10,0,40,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1}},
  {{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1}},
  {{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1}},
  {{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1}},
  {{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,23,-1},{0,0,0,26,0,0,10,0,23,-1},{0,0,0,26,0,0,10,0,23,-1},{0,0,0,26,0,0,10,0,18,-1},{0,0,0,26,0,0,10,0,18,-1},{0,0,0,26,0,0,10,0,18,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1}},
  {{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1}},
  {{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1}},
  {{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1}},
  {{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1}},
  {{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1}},
  {{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,0,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1}},
  {{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1}},
  {{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{0,0,0,26,0,0,10,0,2,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1}},
  {{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1}},
  {{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1}},
  {{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1}},
  {{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{0,0,0,26,0,0,10,1,2,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1}},
  {{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1}},
  {{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{103,0,0,2,0,0,0,0,14,-1}},
  {{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1}},
  {{0,0,1,26,0,0,10,0,40,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{0,0,1,26,0,0,10,0,40,-1},{103,0,0,2,0,0,0,0,14,-1}},
  {{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1}},
  {{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{103,0,0,2,0,0,0,0,14,-1}},
  {{0,0,1,26,0,0,10,0,14,-1},{0,0,1,26,0,0,10,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1}},
  {{0,0,1,26,0,0,10,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,0,14,-1}},
  {{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,14,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1}},
  {{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1}},
  {{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1}},
  {{17,0,1,7,1,0,0,0,14,-1},{17,0,1,7,1,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1}},
  {{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,1,2,0,0,0,0,14,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}},
  {{103,0,0,2,0,1,0,1,0,-1},{0,0,0,1,0,1,18,1,9,-1},{103,0,0,2,0,1,0,1,0,-1},{103,0,0,2,0,1,0,1,0,-1},{103,0,0,2,0,1,0,1,0,-1},{103,0,0,2,0,1,0,1,0,-1},{103,0,0,2,0,1,0,1,0,-1},{103,0,0,2,0,1,0,1,0,-1},{103,0,0,2,0,1,0,1,0,-1},{103,0,0,2,0,1,0,1,0,-1},{103,0,0,2,0,1,0,1,0,-1},{103,0,0,2,0,1,0,1,0,-1},{103,0,0,2,0,1,0,1,0,-1},{103,0,0,2,0,1,0,1,0,-1},{103,0,0,2,0,1,0,1,0,-1},{103,0,0,2,0,1,0,1,0,-1}},
  {{103,0,0,2,0,1,0,1,0,-1},{103,0,0,2,0,1,0,1,0,-1},{103,0,0,2,0,1,0,1,0,-1},{103,0,0,2,0,1,0,1,0,-1},{103,0,0,2,0,1,0,1,0,-1},{103,0,0,2,0,1,0,1,0,-1},{103,0,0,2,0,1,0,1,0,-1},{103,0,0,2,0,1,0,1,0,-1},{103,0,0,2,0,1,0,1,0,-1},{103,0,0,2,0,1,0,1,0,-1},{103,0,0,2,0,1,0,1,0,-1},{103,0,0,2,0,1,0,1,0,-1},{103,0,0,2,0,1,0,1,0,-1},{103,0,0,2,0,1,0,1,0,-1},{103,0,0,2,0,1,0,1,0,-1},{103,0,0,2,0,1,0,1,0,-1}},
  {{0,0,0,1,0,1,18,1,9,-1},{0,0,0,1,0,1,18,1,9,-1},{0,0,0,1,0,1,18,1,9,-1},{0,0,0,1,0,1,18,1,9,-1},{0,0,0,1,0,1,18,1,9,-1},{0,0,0,1,0,1,18,1,9,-1},{0,0,0,1,0,1,18,1,9,-1},{0,0,0,1,0,1,18,1,9,-1},{0,0,0,1,0,1,18,1,9,-1},{0,0,0,1,0,1,18,1,9,-1},{0,0,0,1,0,1,18,1,9,-1},{0,0,0,1,0,1,18,1,9,-1},{0,0,0,1,0,1,18,1,9,-1},{0,0,0,1,0,1,18,1,9,-1},{0,0,0,1,0,1,18,1,9,-1},{0,0,0,1,0,1,18,1,9,-1}},
  {{103,0,0,3,0,0,0,0,0,-1},{103,0,0,3,0,0,0,0,0,-1},{103,0,0,3,0,0,0,0,0,-1},{103,0,0,3,0,0,0,0,0,-1},{103,0,0,3,0,0,0,0,0,-1},{103,0,0,3,0,0,0,0,0,-1},{103,0,0,3,0,0,0,0,0,-1},{103,0,0,3,0,0,0,0,0,-1},{103,0,0,3,0,0,0,0,0,-1},{103,0,0,3,0,0,0,0,0,-1},{103,0,0,3,0,0,0,0,0,-1},{103,0,0,3,0,0,0,0,0,-1},{103,0,0,3,0,0,0,0,0,-1},{103,0,0,3,0,0,0,0,0,-1},{103,0,0,2,0,0,0,1,0,-1},{103,0,0,2,0,0,0,1,0,-1}}
};
#endif


#define kFullWidthMaxPlane  0
#define kFullWidthIndexBits 10
#define kFullWidthCharBits  6
static const uint8_t sFullWidthPages[1024] = {
  0,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,5,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,6,7,8
};

static const uint16_t sFullWidthValues[9][64] = {
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3000,0xff01,0xff02,0xff03,0xff04,0xff05,0xff06,0xff07,0xff08,0xff09,0xff0a,0xff0b,0xff0c,0xff0d,0xff0e,0xff0f,0xff10,0xff11,0xff12,0xff13,0xff14,0xff15,0xff16,0xff17,0xff18,0xff19,0xff1a,0xff1b,0xff1c,0xff1d,0xff1e,0xff1f},
  {0xff20,0xff21,0xff22,0xff23,0xff24,0xff25,0xff26,0xff27,0xff28,0xff29,0xff2a,0xff2b,0xff2c,0xff2d,0xff2e,0xff2f,0xff30,0xff31,0xff32,0xff33,0xff34,0xff35,0xff36,0xff37,0xff38,0xff39,0xff3a,0xff3b,0xff3c,0xff3d,0xff3e,0xff3f,0xff40,0xff41,0xff42,0xff43,0xff44,0xff45,0xff46,0xff47,0xff48,0xff49,0xff4a,0xff4b,0xff4c,0xff4d,0xff4e,0xff4f,0xff50,0xff51,0xff52,0xff53,0xff54,0xff55,0xff56,0xff57,0xff58,0xff59,0xff5a,0xff5b,0xff5c,0xff5d,0xff5e,0x0000},
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffe0,0xffe1,0x0000,0xffe5,0xffe4,0x0000,0x0000,0x0000,0x0000,0x0000,0xffe2,0x0000,0x0000,0xffe3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffe6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0000,0x0000,0x0000,0x0000,0x0000,0xff5f,0xff60,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3002,0x300c,0x300d,0x3001,0x30fb,0x30f2,0x30a1,0x30a3,0x30a5,0x30a7,0x30a9,0x30e3,0x30e5,0x30e7,0x30c3,0x30fc,0x30a2,0x30a4,0x30a6,0x30a8,0x30aa,0x30ab,0x30ad,0x30af,0x30b1,0x30b3,0x30b5,0x30b7,0x30b9,0x30bb,0x30bd},
  {0x30bf,0x30c1,0x30c4,0x30c6,0x30c8,0x30ca,0x30cb,0x30cc,0x30cd,0x30ce,0x30cf,0x30d2,0x30d5,0x30d8,0x30db,0x30de,0x30df,0x30e0,0x30e1,0x30e2,0x30e4,0x30e6,0x30e8,0x30e9,0x30ea,0x30eb,0x30ec,0x30ed,0x30ef,0x30f3,0x3099,0x309a,0x3164,0x3131,0x3132,0x3133,0x3134,0x3135,0x3136,0x3137,0x3138,0x3139,0x313a,0x313b,0x313c,0x313d,0x313e,0x313f,0x3140,0x3141,0x3142,0x3143,0x3144,0x3145,0x3146,0x3147,0x3148,0x3149,0x314a,0x314b,0x314c,0x314d,0x314e,0x0000},
  {0x0000,0x0000,0x314f,0x3150,0x3151,0x3152,0x3153,0x3154,0x0000,0x0000,0x3155,0x3156,0x3157,0x3158,0x3159,0x315a,0x0000,0x0000,0x315b,0x315c,0x315d,0x315e,0x315f,0x3160,0x0000,0x0000,0x3161,0x3162,0x3163,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2502,0x2190,0x2191,0x2192,0x2193,0x25a0,0x25cb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000}
};



#define kFullWidthInverseMaxPlane  0
#define kFullWidthInverseIndexBits 10
#define kFullWidthInverseCharBits  6
static const uint8_t sFullWidthInversePages[1024] = {
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,3,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,6,7,8,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,11,0,12
};

static const uint16_t sFullWidthInverseValues[13][64] = {
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffe9,0xffea,0xffeb,0xffec,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0000,0x0000,0xffe8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffed,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffee,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0020,0xff64,0xff61,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff62,0xff63,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff9e,0xff9f,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff67,0xff71,0xff68,0xff72,0xff69,0xff73,0xff6a,0xff74,0xff6b,0xff75,0xff76,0x0000,0xff77,0x0000,0xff78,0x0000,0xff79,0x0000,0xff7a,0x0000,0xff7b,0x0000,0xff7c,0x0000,0xff7d,0x0000,0xff7e,0x0000,0xff7f,0x0000,0xff80},
  {0x0000,0xff81,0x0000,0xff6f,0xff82,0x0000,0xff83,0x0000,0xff84,0x0000,0xff85,0xff86,0xff87,0xff88,0xff89,0xff8a,0x0000,0x0000,0xff8b,0x0000,0x0000,0xff8c,0x0000,0x0000,0xff8d,0x0000,0x0000,0xff8e,0x0000,0x0000,0xff8f,0xff90,0xff91,0xff92,0xff93,0xff6c,0xff94,0xff6d,0xff95,0xff6e,0xff96,0xff97,0xff98,0xff99,0xff9a,0xff9b,0x0000,0xff9c,0x0000,0x0000,0xff66,0xff9d,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff65,0xff70,0x0000,0x0000,0x0000},
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffa1,0xffa2,0xffa3,0xffa4,0xffa5,0xffa6,0xffa7,0xffa8,0xffa9,0xffaa,0xffab,0xffac,0xffad,0xffae,0xffaf},
  {0xffb0,0xffb1,0xffb2,0xffb3,0xffb4,0xffb5,0xffb6,0xffb7,0xffb8,0xffb9,0xffba,0xffbb,0xffbc,0xffbd,0xffbe,0xffc2,0xffc3,0xffc4,0xffc5,0xffc6,0xffc7,0xffca,0xffcb,0xffcc,0xffcd,0xffce,0xffcf,0xffd2,0xffd3,0xffd4,0xffd5,0xffd6,0xffd7,0xffda,0xffdb,0xffdc,0xffa0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0000,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027,0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,0x002f,0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,0x003f,0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f,0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,0x0058,0x0059,0x005a,0x005b,0x005c,0x005d,0x005e,0x005f},
  {0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,0x006f,0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,0x0078,0x0079,0x007a,0x007b,0x007c,0x007d,0x007e,0x2985,0x2986,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x00a2,0x00a3,0x00ac,0x00af,0x00a6,0x00a5,0x20a9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000}
};


#if !ENABLE_INTL_API
#define kCaseMapMaxPlane  1
#define kCaseMapIndexBits 11
#define kCaseMapCharBits  5
static const uint8_t sCaseMapPlanes[1] = {1};

static const uint8_t sCaseMapPages[2][2048] = {
  {0,0,1,2,0,3,4,5,6,7,8,9,10,11,12,13,6,14,15,16,17,0,0,0,0,0,18,19,20,21,22,23,24,25,26,6,27,6,28,6,6,29,30,31,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,36,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,0,0,0,0,0,0,39,0,0,0,0,6,6,6,6,40,6,6,6,41,42,43,44,42,45,46,47,0,0,0,0,0,0,0,0,0,48,49,50,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,53,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,56,57,58,6,6,6,59,60,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,62,63,0,0,0,0,64,6,65,66,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,69,70,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,73,0,0,0,0,0},
  {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,75,76,0,0,77,78,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,81,82,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,87,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
};

static const uint32_t sCaseMapValues[89][32] = {
  {0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x00000000,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x00000000,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x10000329,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x00000000,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x00000000},
  {0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x00000000,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000187},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000159,0x10000178,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x40000003,0x10000003,0x40000007,0x10000007,0x40000003,0x10000003,0x4000007f},
  {0x1000007f,0x40000003,0x10000003,0x40000007,0x10000007,0x40000003,0x10000003,0x4000000f,0x1000000f,0x00000000,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000187,0x40000003,0x10000003,0x40000007,0x10000007,0x40000003,0x10000003,0x1000012c},
  {0x100003c3,0x400003d2,0x40000001,0x10000001,0x40000001,0x10000001,0x400003d2,0x4000000f,0x1000000f,0x400003df,0x400003dd,0x40000007,0x10000007,0x00000000,0x40000053,0x400003d6,0x400003cb,0x40000003,0x10000003,0x400003f3,0x400003f7,0x10000063,0x400003ff,0x400003ff,0x40000001,0x10000001,0x100003a7,0x00000000,0x400003f3,0x400003ef,0x100003be,0x400003ea},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000326,0x4000000f,0x1000000f,0x4000032a,0x00000000,0x00000000,0x40000001,0x10000001,0x40000326,0x4000001f,0x1000001f,0x4000033b,0x40000339,0x40000007,0x10000007,0x40000003,0x10000003,0x40000325,0x40000001,0x10000001,0x00000000,0x00000000,0x40000001,0x10000001,0x00000000,0x10000048},
  {0x00000000,0x00000000,0x00000000,0x00000000,0x40000002,0x80000001,0x20000003,0x4000000e,0x8000000f,0x20000001,0x40000006,0x80000001,0x20000007,0x40000003,0x10000003,0x4000001f,0x1000001f,0x40000003,0x10000003,0x40000007,0x10000007,0x40000003,0x10000003,0x4000000f,0x1000000f,0x40000003,0x10000003,0x40000007,0x10000007,0x10000053,0x40000001,0x10000001},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x40000002,0x80000003,0x20000001,0x40000001,0x10000001,0x40000063,0x40000048,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001},
  {0x400003be,0x00000000,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x40002e5f,0x40000007,0x10000007,0x400003a7,0x40002e58,0x10002e41},
  {0x10002e3f,0x40000003,0x10000003,0x400003c3,0x400000cd,0x400000c9,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x10002e3f,0x10002e3c,0x10002e22,0x100003d2,0x100003d2,0x00000000,0x100003df,0x100003dd,0x00000000,0x100003d6,0x00000000,0x100003cb,0x1000a5f7,0x00000000,0x00000000,0x00000000},
  {0x100003f3,0x1000a5cd,0x00000000,0x100003f7,0x00000000,0x1000a5e8,0x1000a5cc,0x00000000,0x100003ff,0x100003ff,0x1000a5c4,0x10002e09,0x1000a5c1,0x00000000,0x00000000,0x100003f3,0x00000000,0x10002e1f,0x100003ef,0x00000000,0x00000000,0x100003ea,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x10002e19,0x00000000,0x00000000},
  {0x10000326,0x00000000,0x00000000,0x1000032a,0x00000000,0x00000000,0x00000000,0x1000a536,0x10000326,0x100000cd,0x1000033b,0x10000339,0x100000c9,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x10000325,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x1000a52f,0x1000a52e,0x00000000},
  {0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x100000dc,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x00000000,0x40000001,0x10000001,0x00000000,0x00000000,0x00000000,0x10000086,0x10000082,0x10000082,0x00000000,0x4000008c},
  {0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x4000002a,0x00000000,0x40000025,0x40000027,0x40000025,0x00000000,0x40000040,0x00000000,0x40000043,0x40000041,0x00000000,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020},
  {0x40000060,0x40000060,0x00000000,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x1000002a,0x10000025,0x10000027,0x10000025,0x00000000,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020},
  {0x10000060,0x10000060,0x10000061,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000040,0x10000043,0x10000041,0x40000018,0x10000042,0x10000049,0x00000000,0x00000000,0x00000000,0x10000073,0x10000076,0x10000018,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x1000006a,0x10000050,0x1000000b,0x1000008c,0x4000004c,0x10000060,0x00000000,0x4000000f,0x1000000f,0x4000000b,0x40000001,0x10000001,0x00000000,0x40000086,0x40000082,0x40000082},
  {0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020},
  {0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020},
  {0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050},
  {0x40000001,0x10000001,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001},
  {0x4000000f,0x40000003,0x10000003,0x40000007,0x10000007,0x40000003,0x10000003,0x4000000f,0x1000000f,0x40000003,0x10000003,0x40000007,0x10000007,0x40000003,0x10000003,0x1000000f,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050},
  {0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x400000d0,0x400000d0,0x400000d0,0x400000d0,0x400000d0,0x400000d0,0x400000d0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x00000000,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030},
  {0x100000d0,0x100000d0,0x100000d0,0x100000d0,0x100000d0,0x100000d0,0x100000d0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0},
  {0x40003de0,0x40003de0,0x40003de0,0x40003de0,0x40003de0,0x40003de0,0x00000000,0x40003de0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x40003de0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b830,0x4000b830,0x4000b830,0x4000b830,0x4000b830,0x4000b830,0x4000b830,0x4000b830,0x4000b830,0x4000b830,0x4000b830,0x4000b830,0x4000b830,0x4000b830,0x4000b830,0x4000b830},
  {0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b870,0x4000b870,0x4000b870,0x4000b870,0x4000b870,0x4000b870,0x4000b870,0x4000b870,0x4000b870,0x4000b870,0x4000b870,0x4000b870,0x4000b870,0x4000b870,0x4000b870,0x4000b870},
  {0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x00000000,0x00000000,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x00000000,0x00000000},
  {0x10001892,0x10001895,0x1000189c,0x100018a2,0x100018a6,0x100018a7,0x100018ac,0x100018e5,0x1000bac2,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x1000ba04,0x00000000,0x00000000,0x00000000,0x1000311e,0x00000000,0x00000000},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x100000fb,0x00000000,0x00000000,0x40001e41,0x00000000},
  {0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x00000000,0x00000000,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x00000000,0x00000000},
  {0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008},
  {0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x00000000,0x00000000,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x00000000,0x00000000,0x00000000,0x10000008,0x00000000,0x10000008,0x00000000,0x10000008,0x00000000,0x10000008,0x00000000,0x40000008,0x00000000,0x40000008,0x00000000,0x40000008,0x00000000,0x40000008},
  {0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x100000ca,0x100000ca,0x100000ba,0x100000ba,0x100000be,0x100000be,0x100000ac,0x100000ac,0x10000080,0x10000080,0x10000090,0x10000090,0x10000086,0x10000086,0x00000000,0x00000000},
  {0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x10000008,0x10000008,0x00000000,0x1000000f,0x00000000,0x00000000,0x00000000,0x00000000,0x40000008,0x40000008,0x400000ca,0x400000ca,0x4000000f,0x00000000,0x10001c27,0x00000000},
  {0x00000000,0x00000000,0x00000000,0x1000000f,0x00000000,0x00000000,0x00000000,0x00000000,0x400000ba,0x400000ba,0x400000be,0x400000be,0x4000000f,0x00000000,0x00000000,0x00000000,0x10000008,0x10000008,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x40000008,0x40000008,0x400000ac,0x400000ac,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x10000008,0x10000008,0x00000000,0x00000000,0x00000000,0x10000009,0x00000000,0x00000000,0x40000008,0x40000008,0x40000090,0x40000090,0x40000009,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x1000000f,0x00000000,0x00000000,0x00000000,0x00000000,0x40000080,0x40000080,0x40000086,0x40000086,0x4000000f,0x00000000,0x00000000,0x00000000},
  {0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x400022ef,0x00000000,0x00000000,0x00000000,0x40002141,0x400021ce,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x4000007c,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x1000007c,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x40000010,0x40000010,0x40000010,0x40000010,0x40000010,0x40000010,0x40000010,0x40000010,0x40000010,0x40000010,0x40000010,0x40000010,0x40000010,0x40000010,0x40000010,0x40000010,0x10000010,0x10000010,0x10000010,0x10000010,0x10000010,0x10000010,0x10000010,0x10000010,0x10000010,0x10000010,0x10000010,0x10000010,0x10000010,0x10000010,0x10000010,0x10000010},
  {0x00000000,0x00000000,0x00000000,0x40000007,0x10000007,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x40000066,0x40000066,0x4000006a,0x4000006a,0x4000006e,0x4000006e,0x4000006a,0x4000006a,0x40000066,0x40000066},
  {0x4000001a,0x4000001a,0x4000001e,0x4000001e,0x4000001a,0x4000001a,0x40000026,0x40000026,0x4000002a,0x4000002a,0x4000002e,0x4000002e,0x4000002a,0x4000002a,0x40000026,0x40000026,0x10000066,0x10000066,0x1000006a,0x1000006a,0x1000006e,0x1000006e,0x1000006a,0x1000006a,0x10000066,0x10000066,0x1000001a,0x1000001a,0x1000001e,0x1000001e,0x1000001a,0x1000001a},
  {0x10000026,0x10000026,0x1000002a,0x1000002a,0x1000002e,0x1000002e,0x1000002a,0x1000002a,0x10000026,0x10000026,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050},
  {0x40000070,0x40000070,0x40000070,0x40000070,0x40000070,0x40000070,0x40000070,0x40000070,0x40000070,0x40000070,0x40000070,0x40000070,0x40000070,0x40000070,0x40000070,0x00000000,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030},
  {0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000070,0x10000070,0x10000070,0x10000070,0x10000070,0x10000070,0x10000070,0x10000070,0x10000070,0x10000070,0x10000070,0x10000070,0x10000070,0x10000070,0x10000070,0x00000000},
  {0x40000001,0x10000001,0x40002e09,0x4000311e,0x40002e19,0x10002e5f,0x10002e58,0x4000000f,0x1000000f,0x40000003,0x10000003,0x40000007,0x10000007,0x40002e3c,0x40002e1f,0x40002e3f,0x40002e22,0x00000000,0x40000001,0x10000001,0x00000000,0x40000003,0x10000003,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x40002e41,0x40002e3f},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x40000007,0x10000007,0x40000003,0x10000003,0x00000000,0x00000000,0x00000000,0x40000001,0x10000001,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0},
  {0x10003de0,0x10003de0,0x10003de0,0x10003de0,0x10003de0,0x10003de0,0x00000000,0x10003de0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x10003de0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x00000000,0x00000000,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x00000000,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x40000003,0x10000003,0x40000007,0x10000007,0x4000ba04,0x40000001,0x10000001},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x00000000,0x00000000,0x40000007,0x10000007,0x4000a5e8,0x00000000,0x00000000,0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x00000000,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x4000a5cc,0x4000a5f7,0x4000a5cd,0x4000a5c1,0x4000a5c4,0x00000000,0x4000a52e,0x4000a536,0x4000a52f,0x40000ce0,0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x10000ce0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x1000b8d0,0x1000b8d0,0x1000b8d0,0x1000b8d0,0x1000b8d0,0x1000b8d0,0x1000b8d0,0x1000b8d0,0x1000b8d0,0x1000b8d0,0x1000b8d0,0x1000b8d0,0x1000b8d0,0x1000b8d0,0x1000b8d0,0x1000b8d0},
  {0x1000b830,0x1000b830,0x1000b830,0x1000b830,0x1000b830,0x1000b830,0x1000b830,0x1000b830,0x1000b830,0x1000b830,0x1000b830,0x1000b830,0x1000b830,0x1000b830,0x1000b830,0x1000b830,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850},
  {0x1000b870,0x1000b870,0x1000b870,0x1000b870,0x1000b870,0x1000b870,0x1000b870,0x1000b870,0x1000b870,0x1000b870,0x1000b870,0x1000b870,0x1000b870,0x1000b870,0x1000b870,0x1000b870,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850},
  {0x00000000,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x00000000,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x40000028,0x40000028,0x40000028,0x40000028,0x40000028,0x40000028,0x40000028,0x40000028,0x40000038,0x40000038,0x40000038,0x40000038,0x40000038,0x40000038,0x40000038,0x40000038,0x40000028,0x40000028,0x40000028,0x40000028,0x40000028,0x40000028,0x40000028,0x40000028,0x40000058,0x40000058,0x40000058,0x40000058,0x40000058,0x40000058,0x40000058,0x40000058},
  {0x40000068,0x40000068,0x40000068,0x40000068,0x40000068,0x40000068,0x40000068,0x40000068,0x10000028,0x10000028,0x10000028,0x10000028,0x10000028,0x10000028,0x10000028,0x10000028,0x10000038,0x10000038,0x10000038,0x10000038,0x10000038,0x10000038,0x10000038,0x10000038,0x10000028,0x10000028,0x10000028,0x10000028,0x10000028,0x10000028,0x10000028,0x10000028},
  {0x10000058,0x10000058,0x10000058,0x10000058,0x10000058,0x10000058,0x10000058,0x10000058,0x10000068,0x10000068,0x10000068,0x10000068,0x10000068,0x10000068,0x10000068,0x10000068,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x40000068,0x40000068,0x40000068,0x40000068,0x40000068,0x40000068,0x40000068,0x40000068,0x40000058,0x40000058,0x40000058,0x40000058,0x40000058,0x40000058,0x40000058,0x40000058},
  {0x40000028,0x40000028,0x40000028,0x40000028,0x40000028,0x40000028,0x40000028,0x40000028,0x40000038,0x40000038,0x40000038,0x40000038,0x40000038,0x40000038,0x40000038,0x40000038,0x40000028,0x40000028,0x40000028,0x40000028,0x00000000,0x00000000,0x00000000,0x00000000,0x10000068,0x10000068,0x10000068,0x10000068,0x10000068,0x10000068,0x10000068,0x10000068},
  {0x10000058,0x10000058,0x10000058,0x10000058,0x10000058,0x10000058,0x10000058,0x10000058,0x10000028,0x10000028,0x10000028,0x10000028,0x10000028,0x10000028,0x10000028,0x10000028,0x10000038,0x10000038,0x10000038,0x10000038,0x10000038,0x10000038,0x10000038,0x10000038,0x10000028,0x10000028,0x10000028,0x10000028,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040},
  {0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040},
  {0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060},
  {0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060},
  {0x40000022,0x40000022,0x40000026,0x40000026,0x40000022,0x40000022,0x4000002e,0x4000002e,0x40000022,0x40000022,0x40000026,0x40000026,0x40000022,0x40000022,0x4000003e,0x4000003e,0x40000022,0x40000022,0x40000026,0x40000026,0x40000022,0x40000022,0x4000002e,0x4000002e,0x40000022,0x40000022,0x40000026,0x40000026,0x40000022,0x40000022,0x4000005e,0x4000005e},
  {0x40000062,0x40000062,0x10000022,0x10000022,0x10000026,0x10000026,0x10000022,0x10000022,0x1000002e,0x1000002e,0x10000022,0x10000022,0x10000026,0x10000026,0x10000022,0x10000022,0x1000003e,0x1000003e,0x10000022,0x10000022,0x10000026,0x10000026,0x10000022,0x10000022,0x1000002e,0x1000002e,0x10000022,0x10000022,0x10000026,0x10000026,0x10000022,0x10000022},
  {0x1000005e,0x1000005e,0x10000062,0x10000062,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000}
};
#endif
const uint32_t kTitleToUpper = 0x80000000;
const uint32_t kUpperToLower = 0x40000000;
const uint32_t kLowerToTitle = 0x20000000;
const uint32_t kLowerToUpper = 0x10000000;
const uint32_t kCaseMapCharMask = 0x001fffff;

/*
 * * * * * This file contains MACHINE-GENERATED DATA, do not edit! * * * * *
 */
