# lint_ignore=E501
config = {
    "products": {
        "apk": {
            "product-name": "Fennec-%(version)s",
            "check_uptake": True,
            "alias": "fennec-beta-latest",
            "ssl-only": True,
            "add-locales": False,  # Do not add locales to let "multi" work
            "paths": {
                "android-api-15": {
                    "path": "/mobile/releases/%(version)s/android-api-15/:lang/fennec-%(version)s.:lang.android-arm.apk",
                    "bouncer-platform": "android",
                },
                "android-x86": {
                    "path": "/mobile/releases/%(version)s/android-x86/:lang/fennec-%(version)s.:lang.android-i386.apk",
                    "bouncer-platform": "android-x86",
                },
            },
        },
    },
}
